/*!
  * CoreUI v4.1.5 (https://coreui.io)
  * Copyright 2022 The CoreUI Team (https://github.com/orgs/coreui/people)
  * Licensed under MIT (https://coreui.io)
  */
import*as Popper from"@popperjs/core";const MAX_UID=1e6,MILLISECONDS_MULTIPLIER=1e3,TRANSITION_END="transitionend",toType=e=>null==e?`${e}`:Object.prototype.toString.call(e).match(/\s([a-z]+)/i)[1].toLowerCase(),getUID=e=>{do{e+=Math.floor(1e6*Math.random())}while(document.getElementById(e));return e},getSelector=e=>{let t=e.getAttribute("data-coreui-target");if(!t||"#"===t){let i=e.getAttribute("href");if(!i||!i.includes("#")&&!i.startsWith("."))return null;i.includes("#")&&!i.startsWith("#")&&(i=`#${i.split("#")[1]}`),t=i&&"#"!==i?i.trim():null}return t},getSelectorFromElement=e=>{const t=getSelector(e);return t&&document.querySelector(t)?t:null},getElementFromSelector=e=>{const t=getSelector(e);return t?document.querySelector(t):null},getTransitionDurationFromElement=e=>{if(!e)return 0;let{transitionDuration:t,transitionDelay:i}=window.getComputedStyle(e);const n=Number.parseFloat(t),s=Number.parseFloat(i);return n||s?(t=t.split(",")[0],i=i.split(",")[0],1e3*(Number.parseFloat(t)+Number.parseFloat(i))):0},triggerTransitionEnd=e=>{e.dispatchEvent(new Event(TRANSITION_END))},isElement=e=>!(!e||"object"!=typeof e)&&(void 0!==e.jquery&&(e=e[0]),void 0!==e.nodeType),getElement=e=>isElement(e)?e.jquery?e[0]:e:"string"==typeof e&&e.length>0?document.querySelector(e):null,typeCheckConfig=(e,t,i)=>{Object.keys(i).forEach((n=>{const s=i[n],o=t[n],r=o&&isElement(o)?"element":null==(a=o)?`${a}`:Object.prototype.toString.call(a).match(/\s([a-z]+)/i)[1].toLowerCase();var a;if(!new RegExp(s).test(r))throw new TypeError(`${e.toUpperCase()}: Option "${n}" provided type "${r}" but expected type "${s}".`)}))},isVisible=e=>{if(!isElement(e)||0===e.getClientRects().length)return!1;const t="visible"===getComputedStyle(e).getPropertyValue("visibility"),i=e.closest("details:not([open])");if(!i)return t;if(i!==e){const t=e.closest("summary");if(t&&t.parentNode!==i)return!1;if(null===t)return!1}return t},isDisabled=e=>!e||e.nodeType!==Node.ELEMENT_NODE||!!e.classList.contains("disabled")||(void 0!==e.disabled?e.disabled:e.hasAttribute("disabled")&&"false"!==e.getAttribute("disabled")),findShadowRoot=e=>{if(!document.documentElement.attachShadow)return null;if("function"==typeof e.getRootNode){const t=e.getRootNode();return t instanceof ShadowRoot?t:null}return e instanceof ShadowRoot?e:e.parentNode?findShadowRoot(e.parentNode):null},noop=()=>{},reflow=e=>{e.offsetHeight},getjQuery=()=>{const{jQuery:e}=window;return e&&!document.body.hasAttribute("data-coreui-no-jquery")?e:null},DOMContentLoadedCallbacks=[],onDOMContentLoaded=e=>{"loading"===document.readyState?(DOMContentLoadedCallbacks.length||document.addEventListener("DOMContentLoaded",(()=>{DOMContentLoadedCallbacks.forEach((e=>e()))})),DOMContentLoadedCallbacks.push(e)):e()},isRTL=()=>"rtl"===document.documentElement.dir,defineJQueryPlugin=e=>{var t;t=()=>{const t=getjQuery();if(t){const i=e.NAME,n=t.fn[i];t.fn[i]=e.jQueryInterface,t.fn[i].Constructor=e,t.fn[i].noConflict=()=>(t.fn[i]=n,e.jQueryInterface)}},"loading"===document.readyState?(DOMContentLoadedCallbacks.length||document.addEventListener("DOMContentLoaded",(()=>{DOMContentLoadedCallbacks.forEach((e=>e()))})),DOMContentLoadedCallbacks.push(t)):t()},execute=e=>{"function"==typeof e&&e()},executeAfterTransition=(e,t,i=!0)=>{if(!i)return void execute(e);const n=getTransitionDurationFromElement(t)+5;let s=!1;const o=({target:i})=>{i===t&&(s=!0,t.removeEventListener(TRANSITION_END,o),execute(e))};t.addEventListener(TRANSITION_END,o),setTimeout((()=>{s||triggerTransitionEnd(t)}),n)},getNextActiveElement=(e,t,i,n)=>{let s=e.indexOf(t);if(-1===s)return e[!i&&n?e.length-1:0];const o=e.length;return s+=i?1:-1,n&&(s=(s+o)%o),e[Math.max(0,Math.min(s,o-1))]},namespaceRegex=/[^.]*(?=\..*)\.|.*/,stripNameRegex=/\..*/,stripUidRegex=/::\d+$/,eventRegistry={};let uidEvent=1;const customEvents={mouseenter:"mouseover",mouseleave:"mouseout"},customEventsRegex=/^(mouseenter|mouseleave)/i,nativeEvents=new Set(["click","dblclick","mouseup","mousedown","contextmenu","mousewheel","DOMMouseScroll","mouseover","mouseout","mousemove","selectstart","selectend","keydown","keypress","keyup","orientationchange","touchstart","touchmove","touchend","touchcancel","pointerdown","pointermove","pointerup","pointerleave","pointercancel","gesturestart","gesturechange","gestureend","focus","blur","change","reset","select","submit","focusin","focusout","load","unload","beforeunload","resize","move","DOMContentLoaded","readystatechange","error","abort","scroll"]);function getUidEvent(e,t){return t&&`${t}::${uidEvent++}`||e.uidEvent||uidEvent++}function getEvent(e){const t=getUidEvent(e);return e.uidEvent=t,eventRegistry[t]=eventRegistry[t]||{},eventRegistry[t]}function bootstrapHandler(e,t){return function i(n){return n.delegateTarget=e,i.oneOff&&EventHandler.off(e,n.type,t),t.apply(e,[n])}}function bootstrapDelegationHandler(e,t,i){return function n(s){const o=e.querySelectorAll(t);for(let{target:r}=s;r&&r!==this;r=r.parentNode)for(let a=o.length;a--;)if(o[a]===r)return s.delegateTarget=r,n.oneOff&&EventHandler.off(e,s.type,t,i),i.apply(r,[s]);return null}}function findHandler(e,t,i=null){const n=Object.keys(e);for(let s=0,o=n.length;s<o;s++){const o=e[n[s]];if(o.originalHandler===t&&o.delegationSelector===i)return o}return null}function normalizeParams(e,t,i){const n="string"==typeof t,s=n?i:t;let o=getTypeEvent(e);return nativeEvents.has(o)||(o=e),[n,s,o]}function addHandler(e,t,i,n,s){if("string"!=typeof t||!e)return;if(i||(i=n,n=null),customEventsRegex.test(t)){const e=e=>function(t){if(!t.relatedTarget||t.relatedTarget!==t.delegateTarget&&!t.delegateTarget.contains(t.relatedTarget))return e.call(this,t)};n?n=e(n):i=e(i)}const[o,r,a]=normalizeParams(t,i,n),l=getEvent(e),c=l[a]||(l[a]={}),E=findHandler(c,r,o?i:null);if(E)return void(E.oneOff=E.oneOff&&s);const _=getUidEvent(r,t.replace(namespaceRegex,"")),h=o?bootstrapDelegationHandler(e,i,n):bootstrapHandler(e,i);h.delegationSelector=o?i:null,h.originalHandler=r,h.oneOff=s,h.uidEvent=_,c[_]=h,e.addEventListener(a,h,o)}function removeHandler(e,t,i,n,s){const o=findHandler(t[i],n,s);o&&(e.removeEventListener(i,o,Boolean(s)),delete t[i][o.uidEvent])}function removeNamespacedHandlers(e,t,i,n){const s=t[i]||{};Object.keys(s).forEach((o=>{if(o.includes(n)){const n=s[o];removeHandler(e,t,i,n.originalHandler,n.delegationSelector)}}))}function getTypeEvent(e){return e=e.replace(stripNameRegex,""),customEvents[e]||e}const EventHandler={on(e,t,i,n){addHandler(e,t,i,n,!1)},one(e,t,i,n){addHandler(e,t,i,n,!0)},off(e,t,i,n){if("string"!=typeof t||!e)return;const[s,o,r]=normalizeParams(t,i,n),a=r!==t,l=getEvent(e),c=t.startsWith(".");if(void 0!==o){if(!l||!l[r])return;return void removeHandler(e,l,r,o,s?i:null)}c&&Object.keys(l).forEach((i=>{removeNamespacedHandlers(e,l,i,t.slice(1))}));const E=l[r]||{};Object.keys(E).forEach((i=>{const n=i.replace(stripUidRegex,"");if(!a||t.includes(n)){const t=E[i];removeHandler(e,l,r,t.originalHandler,t.delegationSelector)}}))},trigger(e,t,i){if("string"!=typeof t||!e)return null;const n=getjQuery(),s=getTypeEvent(t),o=t!==s,r=nativeEvents.has(s);let a,l=!0,c=!0,E=!1,_=null;return o&&n&&(a=n.Event(t,i),n(e).trigger(a),l=!a.isPropagationStopped(),c=!a.isImmediatePropagationStopped(),E=a.isDefaultPrevented()),r?(_=document.createEvent("HTMLEvents"),_.initEvent(s,l,!0)):_=new CustomEvent(t,{bubbles:l,cancelable:!0}),void 0!==i&&Object.keys(i).forEach((e=>{Object.defineProperty(_,e,{get:()=>i[e]})})),E&&_.preventDefault(),c&&e.dispatchEvent(_),_.defaultPrevented&&void 0!==a&&a.preventDefault(),_}},elementMap=new Map,Data={set(e,t,i){elementMap.has(e)||elementMap.set(e,new Map);const n=elementMap.get(e);n.has(t)||0===n.size?n.set(t,i):console.error(`Bootstrap doesn't allow more than one instance per element. Bound instance: ${Array.from(n.keys())[0]}.`)},get:(e,t)=>elementMap.has(e)&&elementMap.get(e).get(t)||null,remove(e,t){if(!elementMap.has(e))return;const i=elementMap.get(e);i.delete(t),0===i.size&&elementMap.delete(e)}},VERSION="4.1.5";class BaseComponent{constructor(e){(e=getElement(e))&&(this._element=e,Data.set(this._element,this.constructor.DATA_KEY,this))}dispose(){Data.remove(this._element,this.constructor.DATA_KEY),EventHandler.off(this._element,this.constructor.EVENT_KEY),Object.getOwnPropertyNames(this).forEach((e=>{this[e]=null}))}_queueCallback(e,t,i=!0){executeAfterTransition(e,t,i)}static getInstance(e){return Data.get(getElement(e),this.DATA_KEY)}static getOrCreateInstance(e,t={}){return this.getInstance(e)||new this(e,"object"==typeof t?t:null)}static get VERSION(){return"4.1.5"}static get NAME(){throw new Error('You have to implement the static method "NAME", for each component!')}static get DATA_KEY(){return`coreui.${this.NAME}`}static get EVENT_KEY(){return`.${this.DATA_KEY}`}}const enableDismissTrigger=(e,t="hide")=>{const i=`click.dismiss${e.EVENT_KEY}`,n=e.NAME;EventHandler.on(document,i,`[data-coreui-dismiss="${n}"]`,(function(i){if(["A","AREA"].includes(this.tagName)&&i.preventDefault(),isDisabled(this))return;const s=getElementFromSelector(this)||this.closest(`.${n}`);e.getOrCreateInstance(s)[t]()}))},NAME$f="alert",DATA_KEY$e="coreui.alert",EVENT_KEY$e=".coreui.alert",EVENT_CLOSE="close.coreui.alert",EVENT_CLOSED="closed.coreui.alert",CLASS_NAME_FADE$5="fade",CLASS_NAME_SHOW$a="show";class Alert extends BaseComponent{static get NAME(){return NAME$f}close(){if(EventHandler.trigger(this._element,EVENT_CLOSE).defaultPrevented)return;this._element.classList.remove("show");const e=this._element.classList.contains("fade");this._queueCallback((()=>this._destroyElement()),this._element,e)}_destroyElement(){this._element.remove(),EventHandler.trigger(this._element,EVENT_CLOSED),this.dispose()}static jQueryInterface(e){return this.each((function(){const t=Alert.getOrCreateInstance(this);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e](this)}}))}}enableDismissTrigger(Alert,"close"),defineJQueryPlugin(Alert);const NAME$e="button",DATA_KEY$d="coreui.button",EVENT_KEY$d=".coreui.button",DATA_API_KEY$9=".data-api",CLASS_NAME_ACTIVE$4="active",SELECTOR_DATA_TOGGLE$6='[data-coreui-toggle="button"]',EVENT_CLICK_DATA_API$8="click.coreui.button.data-api";class Button extends BaseComponent{static get NAME(){return NAME$e}toggle(){this._element.setAttribute("aria-pressed",this._element.classList.toggle("active"))}static jQueryInterface(e){return this.each((function(){const t=Button.getOrCreateInstance(this);"toggle"===e&&t[e]()}))}}function normalizeData(e){return"true"===e||"false"!==e&&(e===Number(e).toString()?Number(e):""===e||"null"===e?null:e)}function normalizeDataKey(e){return e.replace(/[A-Z]/g,(e=>`-${e.toLowerCase()}`))}EventHandler.on(document,EVENT_CLICK_DATA_API$8,SELECTOR_DATA_TOGGLE$6,(e=>{e.preventDefault();const t=e.target.closest(SELECTOR_DATA_TOGGLE$6);Button.getOrCreateInstance(t).toggle()})),defineJQueryPlugin(Button);const Manipulator={setDataAttribute(e,t,i){e.setAttribute(`data-coreui-${normalizeDataKey(t)}`,i)},removeDataAttribute(e,t){e.removeAttribute(`data-coreui-${normalizeDataKey(t)}`)},getDataAttributes(e){if(!e)return{};const t={};return Object.keys(e.dataset).filter((e=>e.startsWith("coreui"))).forEach((i=>{let n=i.replace(/^coreui/,"");n=n.charAt(0).toLowerCase()+n.slice(1,n.length),t[n]=normalizeData(e.dataset[i])})),t},getDataAttribute:(e,t)=>normalizeData(e.getAttribute(`data-coreui-${normalizeDataKey(t)}`)),offset(e){const t=e.getBoundingClientRect();return{top:t.top+window.pageYOffset,left:t.left+window.pageXOffset}},position:e=>({top:e.offsetTop,left:e.offsetLeft})},NODE_TEXT=3,SelectorEngine={find:(e,t=document.documentElement)=>[].concat(...Element.prototype.querySelectorAll.call(t,e)),findOne:(e,t=document.documentElement)=>Element.prototype.querySelector.call(t,e),children:(e,t)=>[].concat(...e.children).filter((e=>e.matches(t))),parents(e,t){const i=[];let n=e.parentNode;for(;n&&n.nodeType===Node.ELEMENT_NODE&&3!==n.nodeType;)n.matches(t)&&i.push(n),n=n.parentNode;return i},prev(e,t){let i=e.previousElementSibling;for(;i;){if(i.matches(t))return[i];i=i.previousElementSibling}return[]},next(e,t){let i=e.nextElementSibling;for(;i;){if(i.matches(t))return[i];i=i.nextElementSibling}return[]},focusableChildren(e){const t=["a","button","input","textarea","select","details","[tabindex]",'[contenteditable="true"]'].map((e=>`${e}:not([tabindex^="-"])`)).join(", ");return this.find(t,e).filter((e=>!isDisabled(e)&&isVisible(e)))}},NAME$d="carousel",DATA_KEY$c="coreui.carousel",EVENT_KEY$c=`.${DATA_KEY$c}`,DATA_API_KEY$8=".data-api",ARROW_LEFT_KEY="ArrowLeft",ARROW_RIGHT_KEY="ArrowRight",TOUCHEVENT_COMPAT_WAIT=500,SWIPE_THRESHOLD=40,Default$c={interval:5e3,keyboard:!0,slide:!1,pause:"hover",wrap:!0,touch:!0},DefaultType$c={interval:"(number|boolean)",keyboard:"boolean",slide:"(boolean|string)",pause:"(string|boolean)",wrap:"boolean",touch:"boolean"},ORDER_NEXT="next",ORDER_PREV="prev",DIRECTION_LEFT="left",DIRECTION_RIGHT="right",KEY_TO_DIRECTION={ArrowLeft:DIRECTION_RIGHT,ArrowRight:DIRECTION_LEFT},EVENT_SLIDE=`slide${EVENT_KEY$c}`,EVENT_SLID=`slid${EVENT_KEY$c}`,EVENT_KEYDOWN=`keydown${EVENT_KEY$c}`,EVENT_MOUSEENTER=`mouseenter${EVENT_KEY$c}`,EVENT_MOUSELEAVE=`mouseleave${EVENT_KEY$c}`,EVENT_TOUCHSTART=`touchstart${EVENT_KEY$c}`,EVENT_TOUCHMOVE=`touchmove${EVENT_KEY$c}`,EVENT_TOUCHEND=`touchend${EVENT_KEY$c}`,EVENT_POINTERDOWN=`pointerdown${EVENT_KEY$c}`,EVENT_POINTERUP=`pointerup${EVENT_KEY$c}`,EVENT_DRAG_START=`dragstart${EVENT_KEY$c}`,EVENT_LOAD_DATA_API$4=`load${EVENT_KEY$c}.data-api`,EVENT_CLICK_DATA_API$7=`click${EVENT_KEY$c}.data-api`,CLASS_NAME_CAROUSEL="carousel",CLASS_NAME_ACTIVE$3="active",CLASS_NAME_SLIDE="slide",CLASS_NAME_END="carousel-item-end",CLASS_NAME_START="carousel-item-start",CLASS_NAME_NEXT="carousel-item-next",CLASS_NAME_PREV="carousel-item-prev",CLASS_NAME_POINTER_EVENT="pointer-event",SELECTOR_ACTIVE$1=".active",SELECTOR_ACTIVE_ITEM=".active.carousel-item",SELECTOR_ITEM=".carousel-item",SELECTOR_ITEM_IMG=".carousel-item img",SELECTOR_NEXT_PREV=".carousel-item-next, .carousel-item-prev",SELECTOR_INDICATORS=".carousel-indicators",SELECTOR_INDICATOR="[data-coreui-target]",SELECTOR_DATA_SLIDE="[data-coreui-slide], [data-coreui-slide-to]",SELECTOR_DATA_RIDE='[data-coreui-ride="carousel"]',POINTER_TYPE_TOUCH="touch",POINTER_TYPE_PEN="pen";class Carousel extends BaseComponent{constructor(e,t){super(e),this._items=null,this._interval=null,this._activeElement=null,this._isPaused=!1,this._isSliding=!1,this.touchTimeout=null,this.touchStartX=0,this.touchDeltaX=0,this._config=this._getConfig(t),this._indicatorsElement=SelectorEngine.findOne(SELECTOR_INDICATORS,this._element),this._touchSupported="ontouchstart"in document.documentElement||navigator.maxTouchPoints>0,this._pointerEvent=Boolean(window.PointerEvent),this._addEventListeners()}static get Default(){return Default$c}static get NAME(){return NAME$d}next(){this._slide(ORDER_NEXT)}nextWhenVisible(){!document.hidden&&isVisible(this._element)&&this.next()}prev(){this._slide(ORDER_PREV)}pause(e){e||(this._isPaused=!0),SelectorEngine.findOne(SELECTOR_NEXT_PREV,this._element)&&(triggerTransitionEnd(this._element),this.cycle(!0)),clearInterval(this._interval),this._interval=null}cycle(e){e||(this._isPaused=!1),this._interval&&(clearInterval(this._interval),this._interval=null),this._config&&this._config.interval&&!this._isPaused&&(this._updateInterval(),this._interval=setInterval((document.visibilityState?this.nextWhenVisible:this.next).bind(this),this._config.interval))}to(e){this._activeElement=SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM,this._element);const t=this._getItemIndex(this._activeElement);if(e>this._items.length-1||e<0)return;if(this._isSliding)return void EventHandler.one(this._element,EVENT_SLID,(()=>this.to(e)));if(t===e)return this.pause(),void this.cycle();const i=e>t?ORDER_NEXT:ORDER_PREV;this._slide(i,this._items[e])}_getConfig(e){return e={...Default$c,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig(NAME$d,e,DefaultType$c),e}_handleSwipe(){const e=Math.abs(this.touchDeltaX);if(e<=40)return;const t=e/this.touchDeltaX;this.touchDeltaX=0,t&&this._slide(t>0?DIRECTION_RIGHT:DIRECTION_LEFT)}_addEventListeners(){this._config.keyboard&&EventHandler.on(this._element,EVENT_KEYDOWN,(e=>this._keydown(e))),"hover"===this._config.pause&&(EventHandler.on(this._element,EVENT_MOUSEENTER,(e=>this.pause(e))),EventHandler.on(this._element,EVENT_MOUSELEAVE,(e=>this.cycle(e)))),this._config.touch&&this._touchSupported&&this._addTouchEventListeners()}_addTouchEventListeners(){const e=e=>this._pointerEvent&&("pen"===e.pointerType||"touch"===e.pointerType),t=t=>{e(t)?this.touchStartX=t.clientX:this._pointerEvent||(this.touchStartX=t.touches[0].clientX)},i=e=>{this.touchDeltaX=e.touches&&e.touches.length>1?0:e.touches[0].clientX-this.touchStartX},n=t=>{e(t)&&(this.touchDeltaX=t.clientX-this.touchStartX),this._handleSwipe(),"hover"===this._config.pause&&(this.pause(),this.touchTimeout&&clearTimeout(this.touchTimeout),this.touchTimeout=setTimeout((e=>this.cycle(e)),500+this._config.interval))};SelectorEngine.find(SELECTOR_ITEM_IMG,this._element).forEach((e=>{EventHandler.on(e,EVENT_DRAG_START,(e=>e.preventDefault()))})),this._pointerEvent?(EventHandler.on(this._element,EVENT_POINTERDOWN,(e=>t(e))),EventHandler.on(this._element,EVENT_POINTERUP,(e=>n(e))),this._element.classList.add("pointer-event")):(EventHandler.on(this._element,EVENT_TOUCHSTART,(e=>t(e))),EventHandler.on(this._element,EVENT_TOUCHMOVE,(e=>i(e))),EventHandler.on(this._element,EVENT_TOUCHEND,(e=>n(e))))}_keydown(e){if(/input|textarea/i.test(e.target.tagName))return;const t=KEY_TO_DIRECTION[e.key];t&&(e.preventDefault(),this._slide(t))}_getItemIndex(e){return this._items=e&&e.parentNode?SelectorEngine.find(SELECTOR_ITEM,e.parentNode):[],this._items.indexOf(e)}_getItemByOrder(e,t){const i=e===ORDER_NEXT;return getNextActiveElement(this._items,t,i,this._config.wrap)}_triggerSlideEvent(e,t){const i=this._getItemIndex(e),n=this._getItemIndex(SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM,this._element));return EventHandler.trigger(this._element,EVENT_SLIDE,{relatedTarget:e,direction:t,from:n,to:i})}_setActiveIndicatorElement(e){if(this._indicatorsElement){const t=SelectorEngine.findOne(".active",this._indicatorsElement);t.classList.remove("active"),t.removeAttribute("aria-current");const i=SelectorEngine.find(SELECTOR_INDICATOR,this._indicatorsElement);for(let t=0;t<i.length;t++)if(Number.parseInt(i[t].getAttribute("data-coreui-slide-to"),10)===this._getItemIndex(e)){i[t].classList.add("active"),i[t].setAttribute("aria-current","true");break}}}_updateInterval(){const e=this._activeElement||SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM,this._element);if(!e)return;const t=Number.parseInt(e.getAttribute("data-coreui-interval"),10);t?(this._config.defaultInterval=this._config.defaultInterval||this._config.interval,this._config.interval=t):this._config.interval=this._config.defaultInterval||this._config.interval}_slide(e,t){const i=this._directionToOrder(e),n=SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM,this._element),s=this._getItemIndex(n),o=t||this._getItemByOrder(i,n),r=this._getItemIndex(o),a=Boolean(this._interval),l=i===ORDER_NEXT,c=l?CLASS_NAME_START:CLASS_NAME_END,E=l?CLASS_NAME_NEXT:CLASS_NAME_PREV,_=this._orderToDirection(i);if(o&&o.classList.contains("active"))return void(this._isSliding=!1);if(this._isSliding)return;if(this._triggerSlideEvent(o,_).defaultPrevented)return;if(!n||!o)return;this._isSliding=!0,a&&this.pause(),this._setActiveIndicatorElement(o),this._activeElement=o;const h=()=>{EventHandler.trigger(this._element,EVENT_SLID,{relatedTarget:o,direction:_,from:s,to:r})};if(this._element.classList.contains("slide")){o.classList.add(E),reflow(o),n.classList.add(c),o.classList.add(c);const e=()=>{o.classList.remove(c,E),o.classList.add("active"),n.classList.remove("active",E,c),this._isSliding=!1,setTimeout(h,0)};this._queueCallback(e,n,!0)}else n.classList.remove("active"),o.classList.add("active"),this._isSliding=!1,h();a&&this.cycle()}_directionToOrder(e){return[DIRECTION_RIGHT,DIRECTION_LEFT].includes(e)?isRTL()?e===DIRECTION_LEFT?ORDER_PREV:ORDER_NEXT:e===DIRECTION_LEFT?ORDER_NEXT:ORDER_PREV:e}_orderToDirection(e){return[ORDER_NEXT,ORDER_PREV].includes(e)?isRTL()?e===ORDER_PREV?DIRECTION_LEFT:DIRECTION_RIGHT:e===ORDER_PREV?DIRECTION_RIGHT:DIRECTION_LEFT:e}static carouselInterface(e,t){const i=Carousel.getOrCreateInstance(e,t);let{_config:n}=i;"object"==typeof t&&(n={...n,...t});const s="string"==typeof t?t:n.slide;if("number"==typeof t)i.to(t);else if("string"==typeof s){if(void 0===i[s])throw new TypeError(`No method named "${s}"`);i[s]()}else n.interval&&n.ride&&(i.pause(),i.cycle())}static jQueryInterface(e){return this.each((function(){Carousel.carouselInterface(this,e)}))}static dataApiClickHandler(e){const t=getElementFromSelector(this);if(!t||!t.classList.contains("carousel"))return;const i={...Manipulator.getDataAttributes(t),...Manipulator.getDataAttributes(this)},n=this.getAttribute("data-coreui-slide-to");n&&(i.interval=!1),Carousel.carouselInterface(t,i),n&&Carousel.getInstance(t).to(n),e.preventDefault()}}EventHandler.on(document,EVENT_CLICK_DATA_API$7,SELECTOR_DATA_SLIDE,Carousel.dataApiClickHandler),EventHandler.on(window,EVENT_LOAD_DATA_API$4,(()=>{const e=SelectorEngine.find(SELECTOR_DATA_RIDE);for(let t=0,i=e.length;t<i;t++)Carousel.carouselInterface(e[t],Carousel.getInstance(e[t]))})),defineJQueryPlugin(Carousel);const NAME$c="collapse",DATA_KEY$b="coreui.collapse",EVENT_KEY$b=`.${DATA_KEY$b}`,DATA_API_KEY$7=".data-api",Default$b={toggle:!0,parent:null},DefaultType$b={toggle:"boolean",parent:"(null|element)"},EVENT_SHOW$6=`show${EVENT_KEY$b}`,EVENT_SHOWN$6=`shown${EVENT_KEY$b}`,EVENT_HIDE$6=`hide${EVENT_KEY$b}`,EVENT_HIDDEN$6=`hidden${EVENT_KEY$b}`,EVENT_CLICK_DATA_API$6=`click${EVENT_KEY$b}.data-api`,CLASS_NAME_SHOW$9="show",CLASS_NAME_COLLAPSE="collapse",CLASS_NAME_COLLAPSING="collapsing",CLASS_NAME_COLLAPSED="collapsed",CLASS_NAME_DEEPER_CHILDREN=":scope .collapse .collapse",CLASS_NAME_HORIZONTAL="collapse-horizontal",WIDTH="width",HEIGHT="height",SELECTOR_ACTIVES=".collapse.show, .collapse.collapsing",SELECTOR_DATA_TOGGLE$5='[data-coreui-toggle="collapse"]';class Collapse extends BaseComponent{constructor(e,t){super(e),this._isTransitioning=!1,this._config=this._getConfig(t),this._triggerArray=[];const i=SelectorEngine.find(SELECTOR_DATA_TOGGLE$5);for(let e=0,t=i.length;e<t;e++){const t=i[e],n=getSelectorFromElement(t),s=SelectorEngine.find(n).filter((e=>e===this._element));null!==n&&s.length&&(this._selector=n,this._triggerArray.push(t))}this._initializeChildren(),this._config.parent||this._addAriaAndCollapsedClass(this._triggerArray,this._isShown()),this._config.toggle&&this.toggle()}static get Default(){return Default$b}static get NAME(){return NAME$c}toggle(){this._isShown()?this.hide():this.show()}show(){if(this._isTransitioning||this._isShown())return;let e,t=[];if(this._config.parent){const e=SelectorEngine.find(CLASS_NAME_DEEPER_CHILDREN,this._config.parent);t=SelectorEngine.find(SELECTOR_ACTIVES,this._config.parent).filter((t=>!e.includes(t)))}const i=SelectorEngine.findOne(this._selector);if(t.length){const n=t.find((e=>i!==e));if(e=n?Collapse.getInstance(n):null,e&&e._isTransitioning)return}if(EventHandler.trigger(this._element,EVENT_SHOW$6).defaultPrevented)return;t.forEach((t=>{i!==t&&Collapse.getOrCreateInstance(t,{toggle:!1}).hide(),e||Data.set(t,DATA_KEY$b,null)}));const n=this._getDimension();this._element.classList.remove("collapse"),this._element.classList.add("collapsing"),this._element.style[n]=0,this._addAriaAndCollapsedClass(this._triggerArray,!0),this._isTransitioning=!0;const s=`scroll${n[0].toUpperCase()+n.slice(1)}`;this._queueCallback((()=>{this._isTransitioning=!1,this._element.classList.remove("collapsing"),this._element.classList.add("collapse","show"),this._element.style[n]="",EventHandler.trigger(this._element,EVENT_SHOWN$6)}),this._element,!0),this._element.style[n]=`${this._element[s]}px`}hide(){if(this._isTransitioning||!this._isShown())return;if(EventHandler.trigger(this._element,EVENT_HIDE$6).defaultPrevented)return;const e=this._getDimension();this._element.style[e]=`${this._element.getBoundingClientRect()[e]}px`,reflow(this._element),this._element.classList.add("collapsing"),this._element.classList.remove("collapse","show");const t=this._triggerArray.length;for(let e=0;e<t;e++){const t=this._triggerArray[e],i=getElementFromSelector(t);i&&!this._isShown(i)&&this._addAriaAndCollapsedClass([t],!1)}this._isTransitioning=!0,this._element.style[e]="",this._queueCallback((()=>{this._isTransitioning=!1,this._element.classList.remove("collapsing"),this._element.classList.add("collapse"),EventHandler.trigger(this._element,EVENT_HIDDEN$6)}),this._element,!0)}_isShown(e=this._element){return e.classList.contains("show")}_getConfig(e){return(e={...Default$b,...Manipulator.getDataAttributes(this._element),...e}).toggle=Boolean(e.toggle),e.parent=getElement(e.parent),typeCheckConfig(NAME$c,e,DefaultType$b),e}_getDimension(){return this._element.classList.contains("collapse-horizontal")?WIDTH:HEIGHT}_initializeChildren(){if(!this._config.parent)return;const e=SelectorEngine.find(CLASS_NAME_DEEPER_CHILDREN,this._config.parent);SelectorEngine.find(SELECTOR_DATA_TOGGLE$5,this._config.parent).filter((t=>!e.includes(t))).forEach((e=>{const t=getElementFromSelector(e);t&&this._addAriaAndCollapsedClass([e],this._isShown(t))}))}_addAriaAndCollapsedClass(e,t){e.length&&e.forEach((e=>{t?e.classList.remove("collapsed"):e.classList.add("collapsed"),e.setAttribute("aria-expanded",t)}))}static jQueryInterface(e){return this.each((function(){const t={};"string"==typeof e&&/show|hide/.test(e)&&(t.toggle=!1);const i=Collapse.getOrCreateInstance(this,t);if("string"==typeof e){if(void 0===i[e])throw new TypeError(`No method named "${e}"`);i[e]()}}))}}EventHandler.on(document,EVENT_CLICK_DATA_API$6,SELECTOR_DATA_TOGGLE$5,(function(e){("A"===e.target.tagName||e.delegateTarget&&"A"===e.delegateTarget.tagName)&&e.preventDefault();const t=getSelectorFromElement(this);SelectorEngine.find(t).forEach((e=>{Collapse.getOrCreateInstance(e,{toggle:!1}).toggle()}))})),defineJQueryPlugin(Collapse);const NAME$b="dropdown",DATA_KEY$a="coreui.dropdown",EVENT_KEY$a=`.${DATA_KEY$a}`,DATA_API_KEY$6=".data-api",ESCAPE_KEY$2="Escape",SPACE_KEY="Space",TAB_KEY$1="Tab",ARROW_UP_KEY="ArrowUp",ARROW_DOWN_KEY="ArrowDown",RIGHT_MOUSE_BUTTON=2,REGEXP_KEYDOWN=new RegExp("ArrowUp|ArrowDown|Escape"),EVENT_HIDE$5=`hide${EVENT_KEY$a}`,EVENT_HIDDEN$5=`hidden${EVENT_KEY$a}`,EVENT_SHOW$5=`show${EVENT_KEY$a}`,EVENT_SHOWN$5=`shown${EVENT_KEY$a}`,EVENT_CLICK_DATA_API$5=`click${EVENT_KEY$a}.data-api`,EVENT_KEYDOWN_DATA_API=`keydown${EVENT_KEY$a}.data-api`,EVENT_KEYUP_DATA_API=`keyup${EVENT_KEY$a}.data-api`,CLASS_NAME_SHOW$8="show",CLASS_NAME_DROPUP="dropup",CLASS_NAME_DROPEND="dropend",CLASS_NAME_DROPSTART="dropstart",CLASS_NAME_NAVBAR="navbar",SELECTOR_DATA_TOGGLE$4='[data-coreui-toggle="dropdown"]',SELECTOR_MENU=".dropdown-menu",SELECTOR_NAVBAR_NAV=".navbar-nav",SELECTOR_VISIBLE_ITEMS=".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)",PLACEMENT_TOP=isRTL()?"top-end":"top-start",PLACEMENT_TOPEND=isRTL()?"top-start":"top-end",PLACEMENT_BOTTOM=isRTL()?"bottom-end":"bottom-start",PLACEMENT_BOTTOMEND=isRTL()?"bottom-start":"bottom-end",PLACEMENT_RIGHT=isRTL()?"left-start":"right-start",PLACEMENT_LEFT=isRTL()?"right-start":"left-start",Default$a={offset:[0,2],boundary:"clippingParents",reference:"toggle",display:"dynamic",popperConfig:null,autoClose:!0},DefaultType$a={offset:"(array|string|function)",boundary:"(string|element)",reference:"(string|element|object)",display:"string",popperConfig:"(null|object|function)",autoClose:"(boolean|string)"};class Dropdown extends BaseComponent{constructor(e,t){super(e),this._popper=null,this._config=this._getConfig(t),this._menu=this._getMenuElement(),this._inNavbar=this._detectNavbar()}static get Default(){return Default$a}static get DefaultType(){return DefaultType$a}static get NAME(){return NAME$b}toggle(){return this._isShown()?this.hide():this.show()}show(){if(isDisabled(this._element)||this._isShown(this._menu))return;const e={relatedTarget:this._element};if(EventHandler.trigger(this._element,EVENT_SHOW$5,e).defaultPrevented)return;const t=Dropdown.getParentFromElement(this._element);this._inNavbar?Manipulator.setDataAttribute(this._menu,"popper","none"):this._createPopper(t),"ontouchstart"in document.documentElement&&!t.closest(".navbar-nav")&&[].concat(...document.body.children).forEach((e=>EventHandler.on(e,"mouseover",noop))),this._element.focus(),this._element.setAttribute("aria-expanded",!0),this._menu.classList.add("show"),this._element.classList.add("show"),EventHandler.trigger(this._element,EVENT_SHOWN$5,e)}hide(){if(isDisabled(this._element)||!this._isShown(this._menu))return;const e={relatedTarget:this._element};this._completeHide(e)}dispose(){this._popper&&this._popper.destroy(),super.dispose()}update(){this._inNavbar=this._detectNavbar(),this._popper&&this._popper.update()}_completeHide(e){EventHandler.trigger(this._element,EVENT_HIDE$5,e).defaultPrevented||("ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((e=>EventHandler.off(e,"mouseover",noop))),this._popper&&this._popper.destroy(),this._menu.classList.remove("show"),this._element.classList.remove("show"),this._element.setAttribute("aria-expanded","false"),Manipulator.removeDataAttribute(this._menu,"popper"),EventHandler.trigger(this._element,EVENT_HIDDEN$5,e))}_getConfig(e){if(e={...this.constructor.Default,...Manipulator.getDataAttributes(this._element),...e},typeCheckConfig(NAME$b,e,this.constructor.DefaultType),"object"==typeof e.reference&&!isElement(e.reference)&&"function"!=typeof e.reference.getBoundingClientRect)throw new TypeError(`${NAME$b.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.`);return e}_createPopper(e){if(void 0===Popper)throw new TypeError("Bootstrap's dropdowns require Popper (https://popper.js.org)");let t=this._element;"parent"===this._config.reference?t=e:isElement(this._config.reference)?t=getElement(this._config.reference):"object"==typeof this._config.reference&&(t=this._config.reference);const i=this._getPopperConfig(),n=i.modifiers.find((e=>"applyStyles"===e.name&&!1===e.enabled));this._popper=Popper.createPopper(t,this._menu,i),n&&Manipulator.setDataAttribute(this._menu,"popper","static")}_isShown(e=this._element){return e.classList.contains("show")}_getMenuElement(){return SelectorEngine.next(this._element,SELECTOR_MENU)[0]}_getPlacement(){const e=this._element.parentNode;if(e.classList.contains("dropend"))return PLACEMENT_RIGHT;if(e.classList.contains("dropstart"))return PLACEMENT_LEFT;const t="end"===getComputedStyle(this._menu).getPropertyValue("--cui-position").trim();return e.classList.contains("dropup")?t?PLACEMENT_TOPEND:PLACEMENT_TOP:t?PLACEMENT_BOTTOMEND:PLACEMENT_BOTTOM}_detectNavbar(){return null!==this._element.closest(".navbar")}_getOffset(){const{offset:e}=this._config;return"string"==typeof e?e.split(",").map((e=>Number.parseInt(e,10))):"function"==typeof e?t=>e(t,this._element):e}_getPopperConfig(){const e={placement:this._getPlacement(),modifiers:[{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"offset",options:{offset:this._getOffset()}}]};return"static"===this._config.display&&(e.modifiers=[{name:"applyStyles",enabled:!1}]),{...e,..."function"==typeof this._config.popperConfig?this._config.popperConfig(e):this._config.popperConfig}}_selectMenuItem({key:e,target:t}){const i=SelectorEngine.find(SELECTOR_VISIBLE_ITEMS,this._menu).filter(isVisible);i.length&&getNextActiveElement(i,t,"ArrowDown"===e,!i.includes(t)).focus()}static jQueryInterface(e){return this.each((function(){const t=Dropdown.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]()}}))}static clearMenus(e){if(e&&(2===e.button||"keyup"===e.type&&"Tab"!==e.key))return;const t=SelectorEngine.find(SELECTOR_DATA_TOGGLE$4);for(let i=0,n=t.length;i<n;i++){const n=Dropdown.getInstance(t[i]);if(!n||!1===n._config.autoClose)continue;if(!n._isShown())continue;const s={relatedTarget:n._element};if(e){const t=e.composedPath(),i=t.includes(n._menu);if(t.includes(n._element)||"inside"===n._config.autoClose&&!i||"outside"===n._config.autoClose&&i)continue;if(n._menu.contains(e.target)&&("keyup"===e.type&&"Tab"===e.key||/input|select|option|textarea|form/i.test(e.target.tagName)))continue;"click"===e.type&&(s.clickEvent=e)}n._completeHide(s)}}static getParentFromElement(e){return getElementFromSelector(e)||e.parentNode}static dataApiKeydownHandler(e){if(/input|textarea/i.test(e.target.tagName)?"Space"===e.key||"Escape"!==e.key&&("ArrowDown"!==e.key&&"ArrowUp"!==e.key||e.target.closest(SELECTOR_MENU)):!REGEXP_KEYDOWN.test(e.key))return;const t=this.classList.contains("show");if(!t&&"Escape"===e.key)return;if(e.preventDefault(),e.stopPropagation(),isDisabled(this))return;const i=this.matches(SELECTOR_DATA_TOGGLE$4)?this:SelectorEngine.prev(this,SELECTOR_DATA_TOGGLE$4)[0],n=Dropdown.getOrCreateInstance(i);if("Escape"!==e.key)return"ArrowUp"===e.key||"ArrowDown"===e.key?(t||n.show(),void n._selectMenuItem(e)):void(t&&"Space"!==e.key||Dropdown.clearMenus());n.hide()}}EventHandler.on(document,EVENT_KEYDOWN_DATA_API,SELECTOR_DATA_TOGGLE$4,Dropdown.dataApiKeydownHandler),EventHandler.on(document,EVENT_KEYDOWN_DATA_API,SELECTOR_MENU,Dropdown.dataApiKeydownHandler),EventHandler.on(document,EVENT_CLICK_DATA_API$5,Dropdown.clearMenus),EventHandler.on(document,EVENT_KEYUP_DATA_API,Dropdown.clearMenus),EventHandler.on(document,EVENT_CLICK_DATA_API$5,SELECTOR_DATA_TOGGLE$4,(function(e){e.preventDefault(),Dropdown.getOrCreateInstance(this).toggle()})),defineJQueryPlugin(Dropdown);const SELECTOR_FIXED_CONTENT=".fixed-top, .fixed-bottom, .is-fixed, .sticky-top",SELECTOR_STICKY_CONTENT=".sticky-top";class ScrollBarHelper{constructor(){this._element=document.body}getWidth(){const e=document.documentElement.clientWidth;return Math.abs(window.innerWidth-e)}hide(){const e=this.getWidth();this._disableOverFlow(),this._setElementAttributes(this._element,"paddingRight",(t=>t+e)),this._setElementAttributes(SELECTOR_FIXED_CONTENT,"paddingRight",(t=>t+e)),this._setElementAttributes(".sticky-top","marginRight",(t=>t-e))}_disableOverFlow(){this._saveInitialAttribute(this._element,"overflow"),this._element.style.overflow="hidden"}_setElementAttributes(e,t,i){const n=this.getWidth();this._applyManipulationCallback(e,(e=>{if(e!==this._element&&window.innerWidth>e.clientWidth+n)return;this._saveInitialAttribute(e,t);const s=window.getComputedStyle(e)[t];e.style[t]=`${i(Number.parseFloat(s))}px`}))}reset(){this._resetElementAttributes(this._element,"overflow"),this._resetElementAttributes(this._element,"paddingRight"),this._resetElementAttributes(SELECTOR_FIXED_CONTENT,"paddingRight"),this._resetElementAttributes(".sticky-top","marginRight")}_saveInitialAttribute(e,t){const i=e.style[t];i&&Manipulator.setDataAttribute(e,t,i)}_resetElementAttributes(e,t){this._applyManipulationCallback(e,(e=>{const i=Manipulator.getDataAttribute(e,t);void 0===i?e.style.removeProperty(t):(Manipulator.removeDataAttribute(e,t),e.style[t]=i)}))}_applyManipulationCallback(e,t){isElement(e)?t(e):SelectorEngine.find(e,this._element).forEach(t)}isOverflowing(){return this.getWidth()>0}}const Default$9={className:"modal-backdrop",isVisible:!0,isAnimated:!1,rootElement:"body",clickCallback:null},DefaultType$9={className:"string",isVisible:"boolean",isAnimated:"boolean",rootElement:"(element|string)",clickCallback:"(function|null)"},NAME$a="backdrop",CLASS_NAME_FADE$4="fade",CLASS_NAME_SHOW$7="show",EVENT_MOUSEDOWN="mousedown.coreui.backdrop";class Backdrop{constructor(e){this._config=this._getConfig(e),this._isAppended=!1,this._element=null}show(e){this._config.isVisible?(this._append(),this._config.isAnimated&&reflow(this._getElement()),this._getElement().classList.add("show"),this._emulateAnimation((()=>{execute(e)}))):execute(e)}hide(e){this._config.isVisible?(this._getElement().classList.remove("show"),this._emulateAnimation((()=>{this.dispose(),execute(e)}))):execute(e)}_getElement(){if(!this._element){const e=document.createElement("div");e.className=this._config.className,this._config.isAnimated&&e.classList.add("fade"),this._element=e}return this._element}_getConfig(e){return(e={...Default$9,..."object"==typeof e?e:{}}).rootElement=getElement(e.rootElement),typeCheckConfig(NAME$a,e,DefaultType$9),e}_append(){this._isAppended||(this._config.rootElement.append(this._getElement()),EventHandler.on(this._getElement(),EVENT_MOUSEDOWN,(()=>{execute(this._config.clickCallback)})),this._isAppended=!0)}dispose(){this._isAppended&&(EventHandler.off(this._element,EVENT_MOUSEDOWN),this._element.remove(),this._isAppended=!1)}_emulateAnimation(e){executeAfterTransition(e,this._getElement(),this._config.isAnimated)}}const Default$8={trapElement:null,autofocus:!0},DefaultType$8={trapElement:"element",autofocus:"boolean"},NAME$9="focustrap",DATA_KEY$9="coreui.focustrap",EVENT_KEY$9=`.${DATA_KEY$9}`,EVENT_FOCUSIN$1=`focusin${EVENT_KEY$9}`,EVENT_KEYDOWN_TAB=`keydown.tab${EVENT_KEY$9}`,TAB_KEY="Tab",TAB_NAV_FORWARD="forward",TAB_NAV_BACKWARD="backward";class FocusTrap{constructor(e){this._config=this._getConfig(e),this._isActive=!1,this._lastTabNavDirection=null}activate(){const{trapElement:e,autofocus:t}=this._config;this._isActive||(t&&e.focus(),EventHandler.off(document,EVENT_KEY$9),EventHandler.on(document,EVENT_FOCUSIN$1,(e=>this._handleFocusin(e))),EventHandler.on(document,EVENT_KEYDOWN_TAB,(e=>this._handleKeydown(e))),this._isActive=!0)}deactivate(){this._isActive&&(this._isActive=!1,EventHandler.off(document,EVENT_KEY$9))}_handleFocusin(e){const{target:t}=e,{trapElement:i}=this._config;if(t===document||t===i||i.contains(t))return;const n=SelectorEngine.focusableChildren(i);0===n.length?i.focus():"backward"===this._lastTabNavDirection?n[n.length-1].focus():n[0].focus()}_handleKeydown(e){"Tab"===e.key&&(this._lastTabNavDirection=e.shiftKey?"backward":"forward")}_getConfig(e){return e={...Default$8,..."object"==typeof e?e:{}},typeCheckConfig(NAME$9,e,DefaultType$8),e}}const NAME$8="modal",DATA_KEY$8="coreui.modal",EVENT_KEY$8=".coreui.modal",DATA_API_KEY$5=".data-api",ESCAPE_KEY$1="Escape",Default$7={backdrop:!0,keyboard:!0,focus:!0},DefaultType$7={backdrop:"(boolean|string)",keyboard:"boolean",focus:"boolean"},EVENT_HIDE$4="hide.coreui.modal",EVENT_HIDE_PREVENTED="hidePrevented.coreui.modal",EVENT_HIDDEN$4="hidden.coreui.modal",EVENT_SHOW$4="show.coreui.modal",EVENT_SHOWN$4="shown.coreui.modal",EVENT_RESIZE$1="resize.coreui.modal",EVENT_CLICK_DISMISS="click.dismiss.coreui.modal",EVENT_KEYDOWN_DISMISS$1="keydown.dismiss.coreui.modal",EVENT_MOUSEUP_DISMISS="mouseup.dismiss.coreui.modal",EVENT_MOUSEDOWN_DISMISS="mousedown.dismiss.coreui.modal",EVENT_CLICK_DATA_API$4="click.coreui.modal.data-api",CLASS_NAME_OPEN="modal-open",CLASS_NAME_FADE$3="fade",CLASS_NAME_SHOW$6="show",CLASS_NAME_STATIC="modal-static",OPEN_SELECTOR$1=".modal.show",SELECTOR_DIALOG=".modal-dialog",SELECTOR_MODAL_BODY=".modal-body",SELECTOR_DATA_TOGGLE$3='[data-coreui-toggle="modal"]';class Modal extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._dialog=SelectorEngine.findOne(".modal-dialog",this._element),this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._isShown=!1,this._ignoreBackdropClick=!1,this._isTransitioning=!1,this._scrollBar=new ScrollBarHelper}static get Default(){return Default$7}static get NAME(){return NAME$8}toggle(e){return this._isShown?this.hide():this.show(e)}show(e){this._isShown||this._isTransitioning||EventHandler.trigger(this._element,EVENT_SHOW$4,{relatedTarget:e}).defaultPrevented||(this._isShown=!0,this._isAnimated()&&(this._isTransitioning=!0),this._scrollBar.hide(),document.body.classList.add("modal-open"),this._adjustDialog(),this._setEscapeEvent(),this._setResizeEvent(),EventHandler.on(this._dialog,EVENT_MOUSEDOWN_DISMISS,(()=>{EventHandler.one(this._element,EVENT_MOUSEUP_DISMISS,(e=>{e.target===this._element&&(this._ignoreBackdropClick=!0)}))})),this._showBackdrop((()=>this._showElement(e))))}hide(){if(!this._isShown||this._isTransitioning)return;if(EventHandler.trigger(this._element,EVENT_HIDE$4).defaultPrevented)return;this._isShown=!1;const e=this._isAnimated();e&&(this._isTransitioning=!0),this._setEscapeEvent(),this._setResizeEvent(),this._focustrap.deactivate(),this._element.classList.remove("show"),EventHandler.off(this._element,EVENT_CLICK_DISMISS),EventHandler.off(this._dialog,EVENT_MOUSEDOWN_DISMISS),this._queueCallback((()=>this._hideModal()),this._element,e)}dispose(){[window,this._dialog].forEach((e=>EventHandler.off(e,EVENT_KEY$8))),this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose()}handleUpdate(){this._adjustDialog()}_initializeBackDrop(){return new Backdrop({isVisible:Boolean(this._config.backdrop),isAnimated:this._isAnimated()})}_initializeFocusTrap(){return new FocusTrap({trapElement:this._element})}_getConfig(e){return e={...Default$7,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig(NAME$8,e,DefaultType$7),e}_showElement(e){const t=this._isAnimated(),i=SelectorEngine.findOne(".modal-body",this._dialog);this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE||document.body.append(this._element),this._element.style.display="block",this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.scrollTop=0,i&&(i.scrollTop=0),t&&reflow(this._element),this._element.classList.add("show"),this._queueCallback((()=>{this._config.focus&&this._focustrap.activate(),this._isTransitioning=!1,EventHandler.trigger(this._element,EVENT_SHOWN$4,{relatedTarget:e})}),this._dialog,t)}_setEscapeEvent(){this._isShown?EventHandler.on(this._element,EVENT_KEYDOWN_DISMISS$1,(e=>{this._config.keyboard&&"Escape"===e.key?(e.preventDefault(),this.hide()):this._config.keyboard||"Escape"!==e.key||this._triggerBackdropTransition()})):EventHandler.off(this._element,EVENT_KEYDOWN_DISMISS$1)}_setResizeEvent(){this._isShown?EventHandler.on(window,EVENT_RESIZE$1,(()=>this._adjustDialog())):EventHandler.off(window,EVENT_RESIZE$1)}_hideModal(){this._element.style.display="none",this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._isTransitioning=!1,this._backdrop.hide((()=>{document.body.classList.remove("modal-open"),this._resetAdjustments(),this._scrollBar.reset(),EventHandler.trigger(this._element,EVENT_HIDDEN$4)}))}_showBackdrop(e){EventHandler.on(this._element,EVENT_CLICK_DISMISS,(e=>{this._ignoreBackdropClick?this._ignoreBackdropClick=!1:e.target===e.currentTarget&&(!0===this._config.backdrop?this.hide():"static"===this._config.backdrop&&this._triggerBackdropTransition())})),this._backdrop.show(e)}_isAnimated(){return this._element.classList.contains("fade")}_triggerBackdropTransition(){if(EventHandler.trigger(this._element,EVENT_HIDE_PREVENTED).defaultPrevented)return;const{classList:e,scrollHeight:t,style:i}=this._element,n=t>document.documentElement.clientHeight;!n&&"hidden"===i.overflowY||e.contains("modal-static")||(n||(i.overflowY="hidden"),e.add("modal-static"),this._queueCallback((()=>{e.remove("modal-static"),n||this._queueCallback((()=>{i.overflowY=""}),this._dialog)}),this._dialog),this._element.focus())}_adjustDialog(){const e=this._element.scrollHeight>document.documentElement.clientHeight,t=this._scrollBar.getWidth(),i=t>0;(!i&&e&&!isRTL()||i&&!e&&isRTL())&&(this._element.style.paddingLeft=`${t}px`),(i&&!e&&!isRTL()||!i&&e&&isRTL())&&(this._element.style.paddingRight=`${t}px`)}_resetAdjustments(){this._element.style.paddingLeft="",this._element.style.paddingRight=""}static jQueryInterface(e,t){return this.each((function(){const i=Modal.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===i[e])throw new TypeError(`No method named "${e}"`);i[e](t)}}))}}EventHandler.on(document,EVENT_CLICK_DATA_API$4,SELECTOR_DATA_TOGGLE$3,(function(e){const t=getElementFromSelector(this);["A","AREA"].includes(this.tagName)&&e.preventDefault(),EventHandler.one(t,EVENT_SHOW$4,(e=>{e.defaultPrevented||EventHandler.one(t,EVENT_HIDDEN$4,(()=>{isVisible(this)&&this.focus()}))}));const i=SelectorEngine.findOne(".modal.show");i&&Modal.getInstance(i).hide(),Modal.getOrCreateInstance(t).toggle(this)})),enableDismissTrigger(Modal),defineJQueryPlugin(Modal);const NAME$7="navigation",DATA_KEY$7="coreui.navigation",EVENT_KEY$7=`.${DATA_KEY$7}`,DATA_API_KEY$4=".data-api",Default$6={activeLinksExact:!0,groupsAutoCollapse:!0},DefaultType$6={activeLinksExact:"boolean",groupsAutoCollapse:"(string|boolean)"},CLASS_NAME_ACTIVE$2="active",CLASS_NAME_SHOW$5="show",CLASS_NAME_NAV_GROUP="nav-group",CLASS_NAME_NAV_GROUP_TOGGLE="nav-group-toggle",EVENT_CLICK_DATA_API$3=`click${EVENT_KEY$7}.data-api`,EVENT_LOAD_DATA_API$3=`load${EVENT_KEY$7}.data-api`,SELECTOR_NAV_GROUP=".nav-group",SELECTOR_NAV_GROUP_ITEMS=".nav-group-items",SELECTOR_NAV_GROUP_TOGGLE=".nav-group-toggle",SELECTOR_NAV_LINK=".nav-link",SELECTOR_DATA_NAVIGATION='[data-coreui="navigation"]';class Navigation extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._setActiveLink(),this._addEventListeners(),Data.set(e,DATA_KEY$7,this)}static get Default(){return Default$6}static get DATA_KEY(){return DATA_KEY$7}static get DefaultType(){return DefaultType$6}static get NAME(){return NAME$7}_getConfig(e){return e={...Default$6,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig(NAME$7,e,DefaultType$6),e}_setActiveLink(){Array.from(this._element.querySelectorAll(".nav-link")).forEach((e=>{if(e.classList.contains("nav-group-toggle"))return;let t=String(window.location);(/\?.*=/.test(t)||/\?./.test(t))&&(t=t.split("?")[0]),/#./.test(t)&&(t=t.split("#")[0]),this._config.activeLinksExact&&e.href===t&&(e.classList.add("active"),Array.from(this._getParents(e,".nav-group")).forEach((e=>{e.classList.add("show"),e.setAttribute("aria-expanded",!0)}))),!this._config.activeLinksExact&&e.href.startsWith(t)&&(e.classList.add("active"),Array.from(this._getParents(e,".nav-group")).forEach((e=>{e.classList.add("show"),e.setAttribute("aria-expanded",!0)})))}))}_getParents(e,t){const i=[];for(;e&&e!==document;e=e.parentNode)t?e.matches(t)&&i.push(e):i.push(e);return i}_getAllSiblings(e,t){const i=[];e=e.parentNode.firstChild;do{3!==e.nodeType&&8!==e.nodeType&&(t&&!t(e)||i.push(e))}while(e=e.nextSibling);return i}_getChildren(e,t){const i=[];for(;e;e=e.nextSibling)1===e.nodeType&&e!==t&&i.push(e);return i}_getSiblings(e,t){return this._getChildren(e.parentNode.firstChild,e).filter(t)}_slideDown(e){e.style.height="auto";const t=e.clientHeight;e.style.height="0px",setTimeout((()=>{e.style.height=`${t}px`}),0),this._queueCallback((()=>{e.style.height="auto"}),e,!0)}_slideUp(e,t){const i=e.clientHeight;e.style.height=`${i}px`,setTimeout((()=>{e.style.height="0px"}),0),this._queueCallback((()=>{"function"==typeof t&&t()}),e,!0)}_toggleGroupItems(e){let t=e.target;t.classList.contains("nav-group-toggle")||(t=t.closest(".nav-group-toggle"));!0===this._config.groupsAutoCollapse&&this._getSiblings(t.parentNode,(e=>Boolean(e.classList.contains("nav-group")&&e.classList.contains("show")))).forEach((e=>{this._slideUp(SelectorEngine.findOne(".nav-group-items",e),(()=>{e.classList.remove("show"),e.setAttribute("aria-expanded",!1)}))})),t.parentNode.classList.contains("show")?this._slideUp(SelectorEngine.findOne(".nav-group-items",t.parentNode),(()=>{t.parentNode.classList.remove("show"),t.parentNode.setAttribute("aria-expanded",!1)})):(t.parentNode.classList.add("show"),t.parentNode.setAttribute("aria-expanded",!0),this._slideDown(SelectorEngine.findOne(".nav-group-items",t.parentNode)))}_addEventListeners(){EventHandler.on(this._element,EVENT_CLICK_DATA_API$3,".nav-group-toggle",(e=>{e.preventDefault(),this._toggleGroupItems(e,this)}))}static navigationInterface(e,t){const i=Navigation.getOrCreateInstance(e,t);if("string"==typeof t){if(void 0===i[t])throw new TypeError(`No method named "${t}"`);i[t]()}}static jQueryInterface(e){return this.each((function(){Navigation.navigationInterface(this,e)}))}}EventHandler.on(window,EVENT_LOAD_DATA_API$3,(()=>{Array.from(document.querySelectorAll(SELECTOR_DATA_NAVIGATION)).forEach((e=>{Navigation.navigationInterface(e)}))})),defineJQueryPlugin(Navigation);const NAME$6="offcanvas",DATA_KEY$6="coreui.offcanvas",EVENT_KEY$6=`.${DATA_KEY$6}`,DATA_API_KEY$3=".data-api",EVENT_LOAD_DATA_API$2=`load${EVENT_KEY$6}.data-api`,ESCAPE_KEY="Escape",Default$5={backdrop:!0,keyboard:!0,scroll:!1},DefaultType$5={backdrop:"boolean",keyboard:"boolean",scroll:"boolean"},CLASS_NAME_SHOW$4="show",CLASS_NAME_BACKDROP$1="offcanvas-backdrop",OPEN_SELECTOR=".offcanvas.show",EVENT_SHOW$3=`show${EVENT_KEY$6}`,EVENT_SHOWN$3=`shown${EVENT_KEY$6}`,EVENT_HIDE$3=`hide${EVENT_KEY$6}`,EVENT_HIDDEN$3=`hidden${EVENT_KEY$6}`,EVENT_CLICK_DATA_API$2=`click${EVENT_KEY$6}.data-api`,EVENT_KEYDOWN_DISMISS=`keydown.dismiss${EVENT_KEY$6}`,SELECTOR_DATA_TOGGLE$2='[data-coreui-toggle="offcanvas"]';class Offcanvas extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._isShown=!1,this._backdrop=this._initializeBackDrop(),this._focustrap=this._initializeFocusTrap(),this._addEventListeners()}static get NAME(){return NAME$6}static get Default(){return Default$5}toggle(e){return this._isShown?this.hide():this.show(e)}show(e){this._isShown||EventHandler.trigger(this._element,EVENT_SHOW$3,{relatedTarget:e}).defaultPrevented||(this._isShown=!0,this._element.style.visibility="visible",this._backdrop.show(),this._config.scroll||(new ScrollBarHelper).hide(),this._element.removeAttribute("aria-hidden"),this._element.setAttribute("aria-modal",!0),this._element.setAttribute("role","dialog"),this._element.classList.add("show"),this._queueCallback((()=>{this._config.scroll||this._focustrap.activate(),EventHandler.trigger(this._element,EVENT_SHOWN$3,{relatedTarget:e})}),this._element,!0))}hide(){this._isShown&&(EventHandler.trigger(this._element,EVENT_HIDE$3).defaultPrevented||(this._focustrap.deactivate(),this._element.blur(),this._isShown=!1,this._element.classList.remove("show"),this._backdrop.hide(),this._queueCallback((()=>{this._element.setAttribute("aria-hidden",!0),this._element.removeAttribute("aria-modal"),this._element.removeAttribute("role"),this._element.style.visibility="hidden",this._config.scroll||(new ScrollBarHelper).reset(),EventHandler.trigger(this._element,EVENT_HIDDEN$3)}),this._element,!0)))}dispose(){this._backdrop.dispose(),this._focustrap.deactivate(),super.dispose()}_getConfig(e){return e={...Default$5,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig(NAME$6,e,DefaultType$5),e}_initializeBackDrop(){return new Backdrop({className:"offcanvas-backdrop",isVisible:this._config.backdrop,isAnimated:!0,rootElement:this._element.parentNode,clickCallback:()=>this.hide()})}_initializeFocusTrap(){return new FocusTrap({trapElement:this._element})}_addEventListeners(){EventHandler.on(this._element,EVENT_KEYDOWN_DISMISS,(e=>{this._config.keyboard&&"Escape"===e.key&&this.hide()}))}static jQueryInterface(e){return this.each((function(){const t=Offcanvas.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e]||e.startsWith("_")||"constructor"===e)throw new TypeError(`No method named "${e}"`);t[e](this)}}))}}EventHandler.on(document,EVENT_CLICK_DATA_API$2,SELECTOR_DATA_TOGGLE$2,(function(e){const t=getElementFromSelector(this);if(["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled(this))return;EventHandler.one(t,EVENT_HIDDEN$3,(()=>{isVisible(this)&&this.focus()}));const i=SelectorEngine.findOne(OPEN_SELECTOR);i&&i!==t&&Offcanvas.getInstance(i).hide(),Offcanvas.getOrCreateInstance(t).toggle(this)})),EventHandler.on(window,EVENT_LOAD_DATA_API$2,(()=>SelectorEngine.find(OPEN_SELECTOR).forEach((e=>Offcanvas.getOrCreateInstance(e).show())))),enableDismissTrigger(Offcanvas),defineJQueryPlugin(Offcanvas);const uriAttributes=new Set(["background","cite","href","itemtype","longdesc","poster","src","xlink:href"]),ARIA_ATTRIBUTE_PATTERN=/^aria-[\w-]*$/i,SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file|sms):|[^#&/:?]*(?:[#/?]|$))/i,DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i,allowedAttribute=(e,t)=>{const i=e.nodeName.toLowerCase();if(t.includes(i))return!uriAttributes.has(i)||Boolean(SAFE_URL_PATTERN.test(e.nodeValue)||DATA_URL_PATTERN.test(e.nodeValue));const n=t.filter((e=>e instanceof RegExp));for(let e=0,t=n.length;e<t;e++)if(n[e].test(i))return!0;return!1},DefaultAllowlist={"*":["class","dir","id","lang","role",ARIA_ATTRIBUTE_PATTERN],a:["target","href","title","rel"],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:["src","srcset","alt","title","width","height"],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]};function sanitizeHtml(e,t,i){if(!e.length)return e;if(i&&"function"==typeof i)return i(e);const n=(new window.DOMParser).parseFromString(e,"text/html"),s=[].concat(...n.body.querySelectorAll("*"));for(let e=0,i=s.length;e<i;e++){const i=s[e],n=i.nodeName.toLowerCase();if(!Object.keys(t).includes(n)){i.remove();continue}const o=[].concat(...i.attributes),r=[].concat(t["*"]||[],t[n]||[]);o.forEach((e=>{allowedAttribute(e,r)||i.removeAttribute(e.nodeName)}))}return n.body.innerHTML}const NAME$5="tooltip",DATA_KEY$5="coreui.tooltip",EVENT_KEY$5=`.${DATA_KEY$5}`,CLASS_PREFIX$1="bs-tooltip",DISALLOWED_ATTRIBUTES=new Set(["sanitize","allowList","sanitizeFn"]),DefaultType$4={animation:"boolean",template:"string",title:"(string|element|function)",trigger:"string",delay:"(number|object)",html:"boolean",selector:"(string|boolean)",placement:"(string|function)",offset:"(array|string|function)",container:"(string|element|boolean)",fallbackPlacements:"array",boundary:"(string|element)",customClass:"(string|function)",sanitize:"boolean",sanitizeFn:"(null|function)",allowList:"object",popperConfig:"(null|object|function)"},AttachmentMap={AUTO:"auto",TOP:"top",RIGHT:isRTL()?"left":"right",BOTTOM:"bottom",LEFT:isRTL()?"right":"left"},Default$4={animation:!0,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:"hover focus",title:"",delay:0,html:!1,selector:!1,placement:"top",offset:[0,0],container:!1,fallbackPlacements:["top","right","bottom","left"],boundary:"clippingParents",customClass:"",sanitize:!0,sanitizeFn:null,allowList:DefaultAllowlist,popperConfig:null},Event$2={HIDE:`hide${EVENT_KEY$5}`,HIDDEN:`hidden${EVENT_KEY$5}`,SHOW:`show${EVENT_KEY$5}`,SHOWN:`shown${EVENT_KEY$5}`,INSERTED:`inserted${EVENT_KEY$5}`,CLICK:`click${EVENT_KEY$5}`,FOCUSIN:`focusin${EVENT_KEY$5}`,FOCUSOUT:`focusout${EVENT_KEY$5}`,MOUSEENTER:`mouseenter${EVENT_KEY$5}`,MOUSELEAVE:`mouseleave${EVENT_KEY$5}`},CLASS_NAME_FADE$2="fade",CLASS_NAME_MODAL="modal",CLASS_NAME_SHOW$3="show",HOVER_STATE_SHOW="show",HOVER_STATE_OUT="out",SELECTOR_TOOLTIP_INNER=".tooltip-inner",SELECTOR_MODAL=".modal",EVENT_MODAL_HIDE="hide.coreui.modal",TRIGGER_HOVER="hover",TRIGGER_FOCUS="focus",TRIGGER_CLICK="click",TRIGGER_MANUAL="manual";class Tooltip extends BaseComponent{constructor(e,t){if(void 0===Popper)throw new TypeError("Bootstrap's tooltips require Popper (https://popper.js.org)");super(e),this._isEnabled=!0,this._timeout=0,this._hoverState="",this._activeTrigger={},this._popper=null,this._config=this._getConfig(t),this.tip=null,this._setListeners()}static get Default(){return Default$4}static get NAME(){return NAME$5}static get Event(){return Event$2}static get DefaultType(){return DefaultType$4}enable(){this._isEnabled=!0}disable(){this._isEnabled=!1}toggleEnabled(){this._isEnabled=!this._isEnabled}toggle(e){if(this._isEnabled)if(e){const t=this._initializeOnDelegatedTarget(e);t._activeTrigger.click=!t._activeTrigger.click,t._isWithActiveTrigger()?t._enter(null,t):t._leave(null,t)}else{if(this.getTipElement().classList.contains("show"))return void this._leave(null,this);this._enter(null,this)}}dispose(){clearTimeout(this._timeout),EventHandler.off(this._element.closest(".modal"),EVENT_MODAL_HIDE,this._hideModalHandler),this.tip&&this.tip.remove(),this._disposePopper(),super.dispose()}show(){if("none"===this._element.style.display)throw new Error("Please use show on visible elements");if(!this.isWithContent()||!this._isEnabled)return;const e=EventHandler.trigger(this._element,this.constructor.Event.SHOW),t=findShadowRoot(this._element),i=null===t?this._element.ownerDocument.documentElement.contains(this._element):t.contains(this._element);if(e.defaultPrevented||!i)return;"tooltip"===this.constructor.NAME&&this.tip&&this.getTitle()!==this.tip.querySelector(".tooltip-inner").innerHTML&&(this._disposePopper(),this.tip.remove(),this.tip=null);const n=this.getTipElement(),s=getUID(this.constructor.NAME);n.setAttribute("id",s),this._element.setAttribute("aria-describedby",s),this._config.animation&&n.classList.add("fade");const o="function"==typeof this._config.placement?this._config.placement.call(this,n,this._element):this._config.placement,r=this._getAttachment(o);this._addAttachmentClass(r);const{container:a}=this._config;Data.set(n,this.constructor.DATA_KEY,this),this._element.ownerDocument.documentElement.contains(this.tip)||(a.append(n),EventHandler.trigger(this._element,this.constructor.Event.INSERTED)),this._popper?this._popper.update():this._popper=Popper.createPopper(this._element,n,this._getPopperConfig(r)),n.classList.add("show");const l=this._resolvePossibleFunction(this._config.customClass);l&&n.classList.add(...l.split(" ")),"ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((e=>{EventHandler.on(e,"mouseover",noop)}));const c=this.tip.classList.contains("fade");this._queueCallback((()=>{const e=this._hoverState;this._hoverState=null,EventHandler.trigger(this._element,this.constructor.Event.SHOWN),"out"===e&&this._leave(null,this)}),this.tip,c)}hide(){if(!this._popper)return;const e=this.getTipElement();if(EventHandler.trigger(this._element,this.constructor.Event.HIDE).defaultPrevented)return;e.classList.remove("show"),"ontouchstart"in document.documentElement&&[].concat(...document.body.children).forEach((e=>EventHandler.off(e,"mouseover",noop))),this._activeTrigger.click=!1,this._activeTrigger.focus=!1,this._activeTrigger.hover=!1;const t=this.tip.classList.contains("fade");this._queueCallback((()=>{this._isWithActiveTrigger()||("show"!==this._hoverState&&e.remove(),this._cleanTipClass(),this._element.removeAttribute("aria-describedby"),EventHandler.trigger(this._element,this.constructor.Event.HIDDEN),this._disposePopper())}),this.tip,t),this._hoverState=""}update(){null!==this._popper&&this._popper.update()}isWithContent(){return Boolean(this.getTitle())}getTipElement(){if(this.tip)return this.tip;const e=document.createElement("div");e.innerHTML=this._config.template;const t=e.children[0];return this.setContent(t),t.classList.remove("fade","show"),this.tip=t,this.tip}setContent(e){this._sanitizeAndSetContent(e,this.getTitle(),".tooltip-inner")}_sanitizeAndSetContent(e,t,i){const n=SelectorEngine.findOne(i,e);t||!n?this.setElementContent(n,t):n.remove()}setElementContent(e,t){if(null!==e)return isElement(t)?(t=getElement(t),void(this._config.html?t.parentNode!==e&&(e.innerHTML="",e.append(t)):e.textContent=t.textContent)):void(this._config.html?(this._config.sanitize&&(t=sanitizeHtml(t,this._config.allowList,this._config.sanitizeFn)),e.innerHTML=t):e.textContent=t)}getTitle(){const e=this._element.getAttribute("data-coreui-original-title")||this._config.title;return this._resolvePossibleFunction(e)}updateAttachment(e){return"right"===e?"end":"left"===e?"start":e}_initializeOnDelegatedTarget(e,t){return t||this.constructor.getOrCreateInstance(e.delegateTarget,this._getDelegateConfig())}_getOffset(){const{offset:e}=this._config;return"string"==typeof e?e.split(",").map((e=>Number.parseInt(e,10))):"function"==typeof e?t=>e(t,this._element):e}_resolvePossibleFunction(e){return"function"==typeof e?e.call(this._element):e}_getPopperConfig(e){const t={placement:e,modifiers:[{name:"flip",options:{fallbackPlacements:this._config.fallbackPlacements}},{name:"offset",options:{offset:this._getOffset()}},{name:"preventOverflow",options:{boundary:this._config.boundary}},{name:"arrow",options:{element:`.${this.constructor.NAME}-arrow`}},{name:"onChange",enabled:!0,phase:"afterWrite",fn:e=>this._handlePopperPlacementChange(e)}],onFirstUpdate:e=>{e.options.placement!==e.placement&&this._handlePopperPlacementChange(e)}};return{...t,..."function"==typeof this._config.popperConfig?this._config.popperConfig(t):this._config.popperConfig}}_addAttachmentClass(e){this.getTipElement().classList.add(`${this._getBasicClassPrefix()}-${this.updateAttachment(e)}`)}_getAttachment(e){return AttachmentMap[e.toUpperCase()]}_setListeners(){this._config.trigger.split(" ").forEach((e=>{if("click"===e)EventHandler.on(this._element,this.constructor.Event.CLICK,this._config.selector,(e=>this.toggle(e)));else if("manual"!==e){const t="hover"===e?this.constructor.Event.MOUSEENTER:this.constructor.Event.FOCUSIN,i="hover"===e?this.constructor.Event.MOUSELEAVE:this.constructor.Event.FOCUSOUT;EventHandler.on(this._element,t,this._config.selector,(e=>this._enter(e))),EventHandler.on(this._element,i,this._config.selector,(e=>this._leave(e)))}})),this._hideModalHandler=()=>{this._element&&this.hide()},EventHandler.on(this._element.closest(".modal"),EVENT_MODAL_HIDE,this._hideModalHandler),this._config.selector?this._config={...this._config,trigger:"manual",selector:""}:this._fixTitle()}_fixTitle(){const e=this._element.getAttribute("title"),t=typeof this._element.getAttribute("data-coreui-original-title");(e||"string"!==t)&&(this._element.setAttribute("data-coreui-original-title",e||""),!e||this._element.getAttribute("aria-label")||this._element.textContent||this._element.setAttribute("aria-label",e),this._element.setAttribute("title",""))}_enter(e,t){t=this._initializeOnDelegatedTarget(e,t),e&&(t._activeTrigger["focusin"===e.type?"focus":"hover"]=!0),t.getTipElement().classList.contains("show")||"show"===t._hoverState?t._hoverState="show":(clearTimeout(t._timeout),t._hoverState="show",t._config.delay&&t._config.delay.show?t._timeout=setTimeout((()=>{"show"===t._hoverState&&t.show()}),t._config.delay.show):t.show())}_leave(e,t){t=this._initializeOnDelegatedTarget(e,t),e&&(t._activeTrigger["focusout"===e.type?"focus":"hover"]=t._element.contains(e.relatedTarget)),t._isWithActiveTrigger()||(clearTimeout(t._timeout),t._hoverState="out",t._config.delay&&t._config.delay.hide?t._timeout=setTimeout((()=>{"out"===t._hoverState&&t.hide()}),t._config.delay.hide):t.hide())}_isWithActiveTrigger(){for(const e in this._activeTrigger)if(this._activeTrigger[e])return!0;return!1}_getConfig(e){const t=Manipulator.getDataAttributes(this._element);return Object.keys(t).forEach((e=>{DISALLOWED_ATTRIBUTES.has(e)&&delete t[e]})),(e={...this.constructor.Default,...t,..."object"==typeof e&&e?e:{}}).container=!1===e.container?document.body:getElement(e.container),"number"==typeof e.delay&&(e.delay={show:e.delay,hide:e.delay}),"number"==typeof e.title&&(e.title=e.title.toString()),"number"==typeof e.content&&(e.content=e.content.toString()),typeCheckConfig(NAME$5,e,this.constructor.DefaultType),e.sanitize&&(e.template=sanitizeHtml(e.template,e.allowList,e.sanitizeFn)),e}_getDelegateConfig(){const e={};for(const t in this._config)this.constructor.Default[t]!==this._config[t]&&(e[t]=this._config[t]);return e}_cleanTipClass(){const e=this.getTipElement(),t=new RegExp(`(^|\\s)${this._getBasicClassPrefix()}\\S+`,"g"),i=e.getAttribute("class").match(t);null!==i&&i.length>0&&i.map((e=>e.trim())).forEach((t=>e.classList.remove(t)))}_getBasicClassPrefix(){return"bs-tooltip"}_handlePopperPlacementChange(e){const{state:t}=e;t&&(this.tip=t.elements.popper,this._cleanTipClass(),this._addAttachmentClass(this._getAttachment(t.placement)))}_disposePopper(){this._popper&&(this._popper.destroy(),this._popper=null)}static jQueryInterface(e){return this.each((function(){const t=Tooltip.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]()}}))}}defineJQueryPlugin(Tooltip);const NAME$4="popover",DATA_KEY$4="coreui.popover",EVENT_KEY$4=`.${DATA_KEY$4}`,CLASS_PREFIX="bs-popover",Default$3={...Tooltip.Default,placement:"right",offset:[0,8],trigger:"click",content:"",template:'<div class="popover" role="tooltip"><div class="popover-arrow"></div><h3 class="popover-header"></h3><div class="popover-body"></div></div>'},DefaultType$3={...Tooltip.DefaultType,content:"(string|element|function)"},Event$1={HIDE:`hide${EVENT_KEY$4}`,HIDDEN:`hidden${EVENT_KEY$4}`,SHOW:`show${EVENT_KEY$4}`,SHOWN:`shown${EVENT_KEY$4}`,INSERTED:`inserted${EVENT_KEY$4}`,CLICK:`click${EVENT_KEY$4}`,FOCUSIN:`focusin${EVENT_KEY$4}`,FOCUSOUT:`focusout${EVENT_KEY$4}`,MOUSEENTER:`mouseenter${EVENT_KEY$4}`,MOUSELEAVE:`mouseleave${EVENT_KEY$4}`},SELECTOR_TITLE=".popover-header",SELECTOR_CONTENT=".popover-body";class Popover extends Tooltip{static get Default(){return Default$3}static get NAME(){return NAME$4}static get Event(){return Event$1}static get DefaultType(){return DefaultType$3}isWithContent(){return this.getTitle()||this._getContent()}setContent(e){this._sanitizeAndSetContent(e,this.getTitle(),SELECTOR_TITLE),this._sanitizeAndSetContent(e,this._getContent(),".popover-body")}_getContent(){return this._resolvePossibleFunction(this._config.content)}_getBasicClassPrefix(){return"bs-popover"}static jQueryInterface(e){return this.each((function(){const t=Popover.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]()}}))}}defineJQueryPlugin(Popover);const NAME$3="scrollspy",DATA_KEY$3="coreui.scrollspy",EVENT_KEY$3=`.${DATA_KEY$3}`,DATA_API_KEY$2=".data-api",Default$2={offset:10,method:"auto",target:""},DefaultType$2={offset:"number",method:"string",target:"(string|element)"},EVENT_ACTIVATE=`activate${EVENT_KEY$3}`,EVENT_SCROLL=`scroll${EVENT_KEY$3}`,EVENT_LOAD_DATA_API$1=`load${EVENT_KEY$3}.data-api`,CLASS_NAME_DROPDOWN_ITEM="dropdown-item",CLASS_NAME_ACTIVE$1="active",SELECTOR_DATA_SPY='[data-coreui-spy="scroll"]',SELECTOR_NAV_LIST_GROUP$1=".nav, .list-group",SELECTOR_NAV_LINKS=".nav-link",SELECTOR_NAV_ITEMS=".nav-item",SELECTOR_LIST_ITEMS=".list-group-item",SELECTOR_LINK_ITEMS=".nav-link, .list-group-item, .dropdown-item",SELECTOR_DROPDOWN$1=".dropdown",SELECTOR_DROPDOWN_TOGGLE$1=".dropdown-toggle",METHOD_OFFSET="offset",METHOD_POSITION="position";class ScrollSpy extends BaseComponent{constructor(e,t){super(e),this._scrollElement="BODY"===this._element.tagName?window:this._element,this._config=this._getConfig(t),this._offsets=[],this._targets=[],this._activeTarget=null,this._scrollHeight=0,EventHandler.on(this._scrollElement,EVENT_SCROLL,(()=>this._process())),this.refresh(),this._process()}static get Default(){return Default$2}static get NAME(){return NAME$3}refresh(){const e=this._scrollElement===this._scrollElement.window?"offset":"position",t="auto"===this._config.method?e:this._config.method,i="position"===t?this._getScrollTop():0;this._offsets=[],this._targets=[],this._scrollHeight=this._getScrollHeight(),SelectorEngine.find(SELECTOR_LINK_ITEMS,this._config.target).map((e=>{const n=getSelectorFromElement(e),s=n?SelectorEngine.findOne(n):null;if(s){const e=s.getBoundingClientRect();if(e.width||e.height)return[Manipulator[t](s).top+i,n]}return null})).filter((e=>e)).sort(((e,t)=>e[0]-t[0])).forEach((e=>{this._offsets.push(e[0]),this._targets.push(e[1])}))}dispose(){EventHandler.off(this._scrollElement,EVENT_KEY$3),super.dispose()}_getConfig(e){return(e={...Default$2,...Manipulator.getDataAttributes(this._element),..."object"==typeof e&&e?e:{}}).target=getElement(e.target)||document.documentElement,typeCheckConfig(NAME$3,e,DefaultType$2),e}_getScrollTop(){return this._scrollElement===window?this._scrollElement.pageYOffset:this._scrollElement.scrollTop}_getScrollHeight(){return this._scrollElement.scrollHeight||Math.max(document.body.scrollHeight,document.documentElement.scrollHeight)}_getOffsetHeight(){return this._scrollElement===window?window.innerHeight:this._scrollElement.getBoundingClientRect().height}_process(){const e=this._getScrollTop()+this._config.offset,t=this._getScrollHeight(),i=this._config.offset+t-this._getOffsetHeight();if(this._scrollHeight!==t&&this.refresh(),e>=i){const e=this._targets[this._targets.length-1];this._activeTarget!==e&&this._activate(e)}else{if(this._activeTarget&&e<this._offsets[0]&&this._offsets[0]>0)return this._activeTarget=null,void this._clear();for(let t=this._offsets.length;t--;)this._activeTarget!==this._targets[t]&&e>=this._offsets[t]&&(void 0===this._offsets[t+1]||e<this._offsets[t+1])&&this._activate(this._targets[t])}}_activate(e){this._activeTarget=e,this._clear();const t=SELECTOR_LINK_ITEMS.split(",").map((t=>`${t}[data-coreui-target="${e}"],${t}[href="${e}"]`)),i=SelectorEngine.findOne(t.join(","),this._config.target);i.classList.add("active"),i.classList.contains("dropdown-item")?SelectorEngine.findOne(".dropdown-toggle",i.closest(".dropdown")).classList.add("active"):SelectorEngine.parents(i,".nav, .list-group").forEach((e=>{SelectorEngine.prev(e,".nav-link, .list-group-item").forEach((e=>e.classList.add("active"))),SelectorEngine.prev(e,".nav-item").forEach((e=>{SelectorEngine.children(e,".nav-link").forEach((e=>e.classList.add("active")))}))})),EventHandler.trigger(this._scrollElement,EVENT_ACTIVATE,{relatedTarget:e})}_clear(){SelectorEngine.find(SELECTOR_LINK_ITEMS,this._config.target).filter((e=>e.classList.contains("active"))).forEach((e=>e.classList.remove("active")))}static jQueryInterface(e){return this.each((function(){const t=ScrollSpy.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]()}}))}}EventHandler.on(window,EVENT_LOAD_DATA_API$1,(()=>{SelectorEngine.find(SELECTOR_DATA_SPY).forEach((e=>new ScrollSpy(e)))})),defineJQueryPlugin(ScrollSpy);const NAME$2="sidebar",DATA_KEY$2="coreui.sidebar",EVENT_KEY$2=`.${DATA_KEY$2}`,DATA_API_KEY$1=".data-api",Default$1={},DefaultType$1={},CLASS_NAME_BACKDROP="sidebar-backdrop",CLASS_NAME_HIDE$1="hide",CLASS_NAME_SHOW$2="show",CLASS_NAME_SIDEBAR_NARROW="sidebar-narrow",CLASS_NAME_SIDEBAR_OVERLAID="sidebar-overlaid",CLASS_NAME_SIDEBAR_NARROW_UNFOLDABLE="sidebar-narrow-unfoldable",EVENT_HIDE$2=`hide${EVENT_KEY$2}`,EVENT_HIDDEN$2=`hidden${EVENT_KEY$2}`,EVENT_RESIZE="resize",EVENT_SHOW$2=`show${EVENT_KEY$2}`,EVENT_SHOWN$2=`shown${EVENT_KEY$2}`,EVENT_CLICK_DATA_API$1=`click${EVENT_KEY$2}.data-api`,EVENT_LOAD_DATA_API=`load${EVENT_KEY$2}.data-api`,SELECTOR_DATA_CLOSE='[data-coreui-close="sidebar"]',SELECTOR_DATA_TOGGLE$1="[data-coreui-toggle]",SELECTOR_SIDEBAR=".sidebar";class Sidebar extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._show=this._isVisible(),this._mobile=this._isMobile(),this._overlaid=this._isOverlaid(),this._narrow=this._isNarrow(),this._unfoldable=this._isUnfoldable(),this._backdrop=this._initializeBackDrop(),this._addEventListeners()}static get Default(){return Default$1}static get DefaultType(){return DefaultType$1}static get NAME(){return NAME$2}show(){EventHandler.trigger(this._element,EVENT_SHOW$2),this._element.classList.contains("hide")&&this._element.classList.remove("hide"),this._isMobile()&&(this._element.classList.add("show"),this._backdrop.show(),(new ScrollBarHelper).hide()),this._queueCallback((()=>{!0===this._isVisible()&&(this._show=!0,(this._isMobile()||this._isOverlaid())&&this._addClickOutListener(),EventHandler.trigger(this._element,EVENT_SHOWN$2))}),this._element,!0)}hide(){EventHandler.trigger(this._element,EVENT_HIDE$2),this._element.classList.contains("show")&&this._element.classList.remove("show"),this._isMobile()?(this._backdrop.hide(),(new ScrollBarHelper).reset()):this._element.classList.add("hide"),this._queueCallback((()=>{!1===this._isVisible()&&(this._show=!1,(this._isMobile()||this._isOverlaid())&&this._removeClickOutListener(),EventHandler.trigger(this._element,EVENT_HIDDEN$2))}),this._element,!0)}toggle(){this._isVisible()?this.hide():this.show()}narrow(){this._isMobile()||(this._addClassName("sidebar-narrow"),this._narrow=!0)}unfoldable(){this._isMobile()||(this._addClassName("sidebar-narrow-unfoldable"),this._unfoldable=!0)}reset(){this._isMobile()||(this._narrow&&(this._element.classList.remove("sidebar-narrow"),this._narrow=!1),this._unfoldable&&(this._element.classList.remove("sidebar-narrow-unfoldable"),this._unfoldable=!1))}toggleNarrow(){this._narrow?this.reset():this.narrow()}toggleUnfoldable(){this._unfoldable?this.reset():this.unfoldable()}_getConfig(e){return e={...Default$1,...Manipulator.getDataAttributes(this._element),..."object"==typeof e?e:{}},typeCheckConfig(NAME$2,e,DefaultType$1),e}_initializeBackDrop(){return new Backdrop({className:"sidebar-backdrop",isVisible:this._isMobile(),isAnimated:!0,rootElement:this._element.parentNode,clickCallback:()=>this.hide()})}_isMobile(){return Boolean(window.getComputedStyle(this._element,null).getPropertyValue("--cui-is-mobile"))}_isNarrow(){return this._element.classList.contains("sidebar-narrow")}_isOverlaid(){return this._element.classList.contains("sidebar-overlaid")}_isUnfoldable(){return this._element.classList.contains("sidebar-narrow-unfoldable")}_isVisible(){const e=this._element.getBoundingClientRect();return e.top>=0&&e.left>=0&&Math.floor(e.bottom)<=(window.innerHeight||document.documentElement.clientHeight)&&Math.floor(e.right)<=(window.innerWidth||document.documentElement.clientWidth)}_addClassName(e){this._element.classList.add(e)}_clickOutListener(e,t){null===e.target.closest(".sidebar")&&(e.preventDefault(),e.stopPropagation(),t.hide())}_addClickOutListener(){EventHandler.on(document,EVENT_CLICK_DATA_API$1,(e=>{this._clickOutListener(e,this)}))}_removeClickOutListener(){EventHandler.off(document,EVENT_CLICK_DATA_API$1)}_addEventListeners(){this._mobile&&this._show&&this._addClickOutListener(),this._overlaid&&this._show&&this._addClickOutListener(),EventHandler.on(this._element,EVENT_CLICK_DATA_API$1,"[data-coreui-toggle]",(e=>{e.preventDefault();const t=Manipulator.getDataAttribute(e.target,"toggle");"narrow"===t&&this.toggleNarrow(),"unfoldable"===t&&this.toggleUnfoldable()})),EventHandler.on(this._element,EVENT_CLICK_DATA_API$1,SELECTOR_DATA_CLOSE,(e=>{e.preventDefault(),this.hide()})),EventHandler.on(window,"resize",(()=>{this._isMobile()&&this._isVisible()&&(this.hide(),this._backdrop=this._initializeBackDrop())}))}static sidebarInterface(e,t){const i=Sidebar.getOrCreateInstance(e,t);if("string"==typeof t){if(void 0===i[t])throw new TypeError(`No method named "${t}"`);i[t]()}}static jQueryInterface(e){return this.each((function(){Sidebar.sidebarInterface(this,e)}))}}EventHandler.on(window,EVENT_LOAD_DATA_API,(()=>{Array.from(document.querySelectorAll(".sidebar")).forEach((e=>{Sidebar.sidebarInterface(e)}))})),defineJQueryPlugin(Sidebar);const NAME$1="tab",DATA_KEY$1="coreui.tab",EVENT_KEY$1=".coreui.tab",DATA_API_KEY=".data-api",EVENT_HIDE$1="hide.coreui.tab",EVENT_HIDDEN$1="hidden.coreui.tab",EVENT_SHOW$1="show.coreui.tab",EVENT_SHOWN$1="shown.coreui.tab",EVENT_CLICK_DATA_API="click.coreui.tab.data-api",CLASS_NAME_DROPDOWN_MENU="dropdown-menu",CLASS_NAME_ACTIVE="active",CLASS_NAME_FADE$1="fade",CLASS_NAME_SHOW$1="show",SELECTOR_DROPDOWN=".dropdown",SELECTOR_NAV_LIST_GROUP=".nav, .list-group",SELECTOR_ACTIVE=".active",SELECTOR_ACTIVE_UL=":scope > li > .active",SELECTOR_DATA_TOGGLE='[data-coreui-toggle="tab"], [data-coreui-toggle="pill"], [data-coreui-toggle="list"]',SELECTOR_DROPDOWN_TOGGLE=".dropdown-toggle",SELECTOR_DROPDOWN_ACTIVE_CHILD=":scope > .dropdown-menu .active";class Tab extends BaseComponent{static get NAME(){return"tab"}show(){if(this._element.parentNode&&this._element.parentNode.nodeType===Node.ELEMENT_NODE&&this._element.classList.contains("active"))return;let e;const t=getElementFromSelector(this._element),i=this._element.closest(".nav, .list-group");if(i){const t="UL"===i.nodeName||"OL"===i.nodeName?SELECTOR_ACTIVE_UL:".active";e=SelectorEngine.find(t,i),e=e[e.length-1]}const n=e?EventHandler.trigger(e,EVENT_HIDE$1,{relatedTarget:this._element}):null;if(EventHandler.trigger(this._element,EVENT_SHOW$1,{relatedTarget:e}).defaultPrevented||null!==n&&n.defaultPrevented)return;this._activate(this._element,i);const s=()=>{EventHandler.trigger(e,EVENT_HIDDEN$1,{relatedTarget:this._element}),EventHandler.trigger(this._element,EVENT_SHOWN$1,{relatedTarget:e})};t?this._activate(t,t.parentNode,s):s()}_activate(e,t,i){const n=(!t||"UL"!==t.nodeName&&"OL"!==t.nodeName?SelectorEngine.children(t,".active"):SelectorEngine.find(SELECTOR_ACTIVE_UL,t))[0],s=i&&n&&n.classList.contains("fade"),o=()=>this._transitionComplete(e,n,i);n&&s?(n.classList.remove("show"),this._queueCallback(o,e,!0)):o()}_transitionComplete(e,t,i){if(t){t.classList.remove("active");const e=SelectorEngine.findOne(SELECTOR_DROPDOWN_ACTIVE_CHILD,t.parentNode);e&&e.classList.remove("active"),"tab"===t.getAttribute("role")&&t.setAttribute("aria-selected",!1)}e.classList.add("active"),"tab"===e.getAttribute("role")&&e.setAttribute("aria-selected",!0),reflow(e),e.classList.contains("fade")&&e.classList.add("show");let n=e.parentNode;if(n&&"LI"===n.nodeName&&(n=n.parentNode),n&&n.classList.contains("dropdown-menu")){const t=e.closest(".dropdown");t&&SelectorEngine.find(".dropdown-toggle",t).forEach((e=>e.classList.add("active"))),e.setAttribute("aria-expanded",!0)}i&&i()}static jQueryInterface(e){return this.each((function(){const t=Tab.getOrCreateInstance(this);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e]()}}))}}EventHandler.on(document,EVENT_CLICK_DATA_API,SELECTOR_DATA_TOGGLE,(function(e){["A","AREA"].includes(this.tagName)&&e.preventDefault(),isDisabled(this)||Tab.getOrCreateInstance(this).show()})),defineJQueryPlugin(Tab);const NAME="toast",DATA_KEY="coreui.toast",EVENT_KEY=`.${DATA_KEY}`,EVENT_MOUSEOVER=`mouseover${EVENT_KEY}`,EVENT_MOUSEOUT=`mouseout${EVENT_KEY}`,EVENT_FOCUSIN=`focusin${EVENT_KEY}`,EVENT_FOCUSOUT=`focusout${EVENT_KEY}`,EVENT_HIDE=`hide${EVENT_KEY}`,EVENT_HIDDEN=`hidden${EVENT_KEY}`,EVENT_SHOW=`show${EVENT_KEY}`,EVENT_SHOWN=`shown${EVENT_KEY}`,CLASS_NAME_FADE="fade",CLASS_NAME_HIDE="hide",CLASS_NAME_SHOW="show",CLASS_NAME_SHOWING="showing",DefaultType={animation:"boolean",autohide:"boolean",delay:"number"},Default={animation:!0,autohide:!0,delay:5e3};class Toast extends BaseComponent{constructor(e,t){super(e),this._config=this._getConfig(t),this._timeout=null,this._hasMouseInteraction=!1,this._hasKeyboardInteraction=!1,this._setListeners()}static get DefaultType(){return DefaultType}static get Default(){return Default}static get NAME(){return NAME}show(){EventHandler.trigger(this._element,EVENT_SHOW).defaultPrevented||(this._clearTimeout(),this._config.animation&&this._element.classList.add("fade"),this._element.classList.remove("hide"),reflow(this._element),this._element.classList.add("show"),this._element.classList.add("showing"),this._queueCallback((()=>{this._element.classList.remove("showing"),EventHandler.trigger(this._element,EVENT_SHOWN),this._maybeScheduleHide()}),this._element,this._config.animation))}hide(){this._element.classList.contains("show")&&(EventHandler.trigger(this._element,EVENT_HIDE).defaultPrevented||(this._element.classList.add("showing"),this._queueCallback((()=>{this._element.classList.add("hide"),this._element.classList.remove("showing"),this._element.classList.remove("show"),EventHandler.trigger(this._element,EVENT_HIDDEN)}),this._element,this._config.animation)))}dispose(){this._clearTimeout(),this._element.classList.contains("show")&&this._element.classList.remove("show"),super.dispose()}_getConfig(e){return e={...Default,...Manipulator.getDataAttributes(this._element),..."object"==typeof e&&e?e:{}},typeCheckConfig(NAME,e,this.constructor.DefaultType),e}_maybeScheduleHide(){this._config.autohide&&(this._hasMouseInteraction||this._hasKeyboardInteraction||(this._timeout=setTimeout((()=>{this.hide()}),this._config.delay)))}_onInteraction(e,t){switch(e.type){case"mouseover":case"mouseout":this._hasMouseInteraction=t;break;case"focusin":case"focusout":this._hasKeyboardInteraction=t}if(t)return void this._clearTimeout();const i=e.relatedTarget;this._element===i||this._element.contains(i)||this._maybeScheduleHide()}_setListeners(){EventHandler.on(this._element,EVENT_MOUSEOVER,(e=>this._onInteraction(e,!0))),EventHandler.on(this._element,EVENT_MOUSEOUT,(e=>this._onInteraction(e,!1))),EventHandler.on(this._element,EVENT_FOCUSIN,(e=>this._onInteraction(e,!0))),EventHandler.on(this._element,EVENT_FOCUSOUT,(e=>this._onInteraction(e,!1)))}_clearTimeout(){clearTimeout(this._timeout),this._timeout=null}static jQueryInterface(e){return this.each((function(){const t=Toast.getOrCreateInstance(this,e);if("string"==typeof e){if(void 0===t[e])throw new TypeError(`No method named "${e}"`);t[e](this)}}))}}enableDismissTrigger(Toast),defineJQueryPlugin(Toast);export{Alert,Button,Carousel,Collapse,Dropdown,Modal,Navigation,Offcanvas,Popover,ScrollSpy,Sidebar,Tab,Toast,Tooltip};
//# sourceMappingURL=coreui.esm.min.js.map