/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * See:
 * - https://mochajs.org/#usage for more information on usage of mocha flags.
 * - https://github.com/karma-runner/karma-mocha for more information on all mocha flags which the
 *   karma runner supports.
 */

const config = {
  require: 'ts-node/register',
  timeout: 5000,
  retries: 5,
  exit: true
};

// use min reporter in CI to make it easy to spot failed tests
if (process.env.CI) {
  config.reporter = 'min';
}

// Firestore uses babel to compile tests in Nodejs
if (process.env.NO_TS_NODE) {
  delete config.require;
}

module.exports = config;
