## API Report File for "@firebase/storage"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { AppCheckInternalComponentName } from '@firebase/app-check-interop-types';
import { CompleteFn } from '@firebase/util';
import { EmulatorMockTokenOptions } from '@firebase/util';
import { FirebaseApp } from '@firebase/app';
import { FirebaseAuthInternalName } from '@firebase/auth-interop-types';
import { FirebaseError } from '@firebase/util';
import { _FirebaseService } from '@firebase/app';
import { NextFn } from '@firebase/util';
import { Provider } from '@firebase/component';
import { Subscribe } from '@firebase/util';
import { Unsubscribe } from '@firebase/util';

// @public
export function connectStorageEmulator(storage: FirebaseStorage, host: string, port: number, options?: {
    mockUserToken?: EmulatorMockTokenOptions | string;
}): void;

// Warning: (ae-forgotten-export) The symbol "StringData" needs to be exported by the entry point index.d.ts
//
// @internal (undocumented)
export function _dataFromString(format: StringFormat, stringData: string): StringData;

// @public
export function deleteObject(ref: StorageReference): Promise<void>;

export { EmulatorMockTokenOptions }

// @internal (undocumented)
export class _FbsBlob {
    constructor(data: Blob | Uint8Array | ArrayBuffer, elideCopy?: boolean);
    // (undocumented)
    static getBlob(...args: Array<string | _FbsBlob>): _FbsBlob | null;
    // (undocumented)
    size(): number;
    // (undocumented)
    slice(startByte: number, endByte: number): _FbsBlob | null;
    // (undocumented)
    type(): string;
    // (undocumented)
    uploadData(): Blob | Uint8Array;
}

// @public
export interface FirebaseStorage extends _FirebaseService {
    readonly app: FirebaseApp;
    maxOperationRetryTime: number;
    maxUploadRetryTime: number;
}

// @internal
export class _FirebaseStorageImpl implements FirebaseStorage {
    constructor(
    app: FirebaseApp, _authProvider: Provider<FirebaseAuthInternalName>,
    _appCheckProvider: Provider<AppCheckInternalComponentName>,
    _url?: string | undefined, _firebaseVersion?: string | undefined);
    readonly app: FirebaseApp;
    // (undocumented)
    readonly _appCheckProvider: Provider<AppCheckInternalComponentName>;
    // (undocumented)
    protected readonly _appId: string | null;
    // (undocumented)
    readonly _authProvider: Provider<FirebaseAuthInternalName>;
    // (undocumented)
    _bucket: _Location | null;
    _delete(): Promise<void>;
    // (undocumented)
    readonly _firebaseVersion?: string | undefined;
    // (undocumented)
    _getAppCheckToken(): Promise<string | null>;
    // (undocumented)
    _getAuthToken(): Promise<string | null>;
    get host(): string;
    set host(host: string);
    // Warning: (ae-forgotten-export) The symbol "ConnectionType" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "RequestInfo" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "Connection" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "Request" needs to be exported by the entry point index.d.ts
    //
    // (undocumented)
    _makeRequest<I extends ConnectionType, O>(requestInfo: RequestInfo_2<I, O>, requestFactory: () => Connection<I>, authToken: string | null, appCheckToken: string | null): Request_2<O>;
    // (undocumented)
    makeRequestWithTokens<I extends ConnectionType, O>(requestInfo: RequestInfo_2<I, O>, requestFactory: () => Connection<I>): Promise<O>;
    _makeStorageReference(loc: _Location): _Reference;
    get maxOperationRetryTime(): number;
    set maxOperationRetryTime(time: number);
    get maxUploadRetryTime(): number;
    set maxUploadRetryTime(time: number);
    // (undocumented)
    _overrideAuthToken?: string;
    // (undocumented)
    _protocol: string;
    // (undocumented)
    readonly _url?: string | undefined;
}

// @public
export interface FullMetadata extends UploadMetadata {
    bucket: string;
    downloadTokens: string[] | undefined;
    fullPath: string;
    generation: string;
    metageneration: string;
    name: string;
    ref?: StorageReference | undefined;
    size: number;
    timeCreated: string;
    updated: string;
}

// @public
export function getBlob(ref: StorageReference, maxDownloadSizeBytes?: number): Promise<Blob>;

// @public
export function getBytes(ref: StorageReference, maxDownloadSizeBytes?: number): Promise<ArrayBuffer>;

// @internal (undocumented)
export function _getChild(ref: StorageReference, childPath: string): _Reference;

// @public
export function getDownloadURL(ref: StorageReference): Promise<string>;

// @public
export function getMetadata(ref: StorageReference): Promise<FullMetadata>;

// @public
export function getStorage(app?: FirebaseApp, bucketUrl?: string): FirebaseStorage;

// @public
export function getStream(ref: StorageReference, maxDownloadSizeBytes?: number): NodeJS.ReadableStream;

// Warning: (ae-forgotten-export) The symbol "StorageError" needs to be exported by the entry point index.d.ts
//
// @internal (undocumented)
export function _invalidArgument(message: string): StorageError_2;

// @internal (undocumented)
export function _invalidRootOperation(name: string): StorageError_2;

// @public
export function list(ref: StorageReference, options?: ListOptions): Promise<ListResult>;

// @public
export function listAll(ref: StorageReference): Promise<ListResult>;

// @public
export interface ListOptions {
    maxResults?: number | null;
    pageToken?: string | null;
}

// @public
export interface ListResult {
    items: StorageReference[];
    nextPageToken?: string;
    prefixes: StorageReference[];
}

// @internal
export class _Location {
    constructor(bucket: string, path: string);
    // (undocumented)
    readonly bucket: string;
    // (undocumented)
    bucketOnlyServerUrl(): string;
    // (undocumented)
    fullServerUrl(): string;
    // (undocumented)
    get isRoot(): boolean;
    // (undocumented)
    static makeFromBucketSpec(bucketString: string, host: string): _Location;
    // (undocumented)
    static makeFromUrl(url: string, host: string): _Location;
    // (undocumented)
    get path(): string;
    }

// @public
export function ref(storage: FirebaseStorage, url?: string): StorageReference;

// @public
export function ref(storageOrRef: FirebaseStorage | StorageReference, path?: string): StorageReference;

// @internal
export class _Reference {
    constructor(_service: _FirebaseStorageImpl, location: string | _Location);
    get bucket(): string;
    get fullPath(): string;
    // (undocumented)
    _location: _Location;
    get name(): string;
    // (undocumented)
    protected _newRef(service: _FirebaseStorageImpl, location: _Location): _Reference;
    get parent(): _Reference | null;
    get root(): _Reference;
    get storage(): _FirebaseStorageImpl;
    _throwIfRoot(name: string): void;
    // @override
    toString(): string;
}

// @public
export interface SettableMetadata {
    cacheControl?: string | undefined;
    contentDisposition?: string | undefined;
    contentEncoding?: string | undefined;
    contentLanguage?: string | undefined;
    contentType?: string | undefined;
    customMetadata?: {
        [key: string]: string;
    } | undefined;
}

// @public
export interface StorageError extends FirebaseError {
    serverResponse: string | null;
}

// @public
export interface StorageObserver<T> {
    // (undocumented)
    complete?: CompleteFn | null;
    // (undocumented)
    error?: (error: StorageError) => void | null;
    // (undocumented)
    next?: NextFn<T> | null;
}

// @public
export interface StorageReference {
    bucket: string;
    fullPath: string;
    name: string;
    parent: StorageReference | null;
    root: StorageReference;
    storage: FirebaseStorage;
    toString(): string;
}

// @public
export type StringFormat = typeof StringFormat[keyof typeof StringFormat];

// @public
export const StringFormat: {
    readonly RAW: "raw";
    readonly BASE64: "base64";
    readonly BASE64URL: "base64url";
    readonly DATA_URL: "data_url";
};

// @public
export type TaskEvent = 'state_changed';

// @internal
export type _TaskEvent = string;

// @internal
export const _TaskEvent: {
    STATE_CHANGED: string;
};

// @public
export type TaskState = 'running' | 'paused' | 'success' | 'canceled' | 'error';

// @internal
export type _TaskState = typeof _TaskState[keyof typeof _TaskState];

// @internal
export const _TaskState: {
    readonly RUNNING: "running";
    readonly PAUSED: "paused";
    readonly SUCCESS: "success";
    readonly CANCELED: "canceled";
    readonly ERROR: "error";
};

// @public
export function updateMetadata(ref: StorageReference, metadata: SettableMetadata): Promise<FullMetadata>;

// @public
export function uploadBytes(ref: StorageReference, data: Blob | Uint8Array | ArrayBuffer, metadata?: UploadMetadata): Promise<UploadResult>;

// @public
export function uploadBytesResumable(ref: StorageReference, data: Blob | Uint8Array | ArrayBuffer, metadata?: UploadMetadata): UploadTask;

// @public
export interface UploadMetadata extends SettableMetadata {
    md5Hash?: string | undefined;
}

// @public
export interface UploadResult {
    readonly metadata: FullMetadata;
    readonly ref: StorageReference;
}

// @public
export function uploadString(ref: StorageReference, value: string, format?: StringFormat, metadata?: UploadMetadata): Promise<UploadResult>;

// @public
export interface UploadTask {
    cancel(): boolean;
    catch(onRejected: (error: StorageError) => unknown): Promise<unknown>;
    on(event: TaskEvent, nextOrObserver?: StorageObserver<UploadTaskSnapshot> | null | ((snapshot: UploadTaskSnapshot) => unknown), error?: ((a: StorageError) => unknown) | null, complete?: Unsubscribe | null): Unsubscribe | Subscribe<UploadTaskSnapshot>;
    pause(): boolean;
    resume(): boolean;
    snapshot: UploadTaskSnapshot;
    then(onFulfilled?: ((snapshot: UploadTaskSnapshot) => unknown) | null, onRejected?: ((error: StorageError) => unknown) | null): Promise<unknown>;
}

// @internal
export class _UploadTask {
    constructor(ref: _Reference, blob: _FbsBlob, metadata?: Metadata | null);
    _blob: _FbsBlob;
    cancel(): boolean;
    catch<T>(onRejected: (p1: StorageError_2) => T | Promise<T>): Promise<T>;
    // Warning: (ae-forgotten-export) The symbol "Metadata" needs to be exported by the entry point index.d.ts
    _metadata: Metadata | null;
    // Warning: (ae-forgotten-export) The symbol "Unsubscribe" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "Subscribe" needs to be exported by the entry point index.d.ts
    on(type: _TaskEvent, nextOrObserver?: StorageObserver<UploadTaskSnapshot> | null | ((snapshot: UploadTaskSnapshot) => unknown), error?: ((a: StorageError_2) => unknown) | null, completed?: Unsubscribe_2 | null): Unsubscribe_2 | Subscribe_2<UploadTaskSnapshot>;
    pause(): boolean;
    resume(): boolean;
    get snapshot(): UploadTaskSnapshot;
    // Warning: (ae-forgotten-export) The symbol "InternalTaskState" needs to be exported by the entry point index.d.ts
    _state: InternalTaskState;
    then<U>(onFulfilled?: ((value: UploadTaskSnapshot) => U | Promise<U>) | null, onRejected?: ((error: StorageError_2) => U | Promise<U>) | null): Promise<U>;
    _transferred: number;
    }

// @public
export interface UploadTaskSnapshot {
    bytesTransferred: number;
    metadata: FullMetadata;
    ref: StorageReference;
    state: TaskState;
    task: UploadTask;
    totalBytes: number;
}


```
