## API Report File for "@firebase/remote-config"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { FirebaseApp } from '@firebase/app';

// @public
export function activate(remoteConfig: RemoteConfig): Promise<boolean>;

// @public
export function ensureInitialized(remoteConfig: RemoteConfig): Promise<void>;

// @public
export function fetchAndActivate(remoteConfig: RemoteConfig): Promise<boolean>;

// @public
export function fetchConfig(remoteConfig: RemoteConfig): Promise<void>;

// @public
export type FetchStatus = 'no-fetch-yet' | 'success' | 'failure' | 'throttle';

// @public
export function getAll(remoteConfig: RemoteConfig): Record<string, Value>;

// @public
export function getBoolean(remoteConfig: RemoteConfig, key: string): boolean;

// @public
export function getNumber(remoteConfig: RemoteConfig, key: string): number;

// @public (undocumented)
export function getRemoteConfig(app?: FirebaseApp): RemoteConfig;

// @public
export function getString(remoteConfig: RemoteConfig, key: string): string;

// @public
export function getValue(remoteConfig: RemoteConfig, key: string): Value;

// @public
export function isSupported(): Promise<boolean>;

// @public
export type LogLevel = 'debug' | 'error' | 'silent';

// @public
export interface RemoteConfig {
    app: FirebaseApp;
    defaultConfig: {
        [key: string]: string | number | boolean;
    };
    fetchTimeMillis: number;
    lastFetchStatus: FetchStatus;
    settings: RemoteConfigSettings;
}

// @public
export interface RemoteConfigSettings {
    fetchTimeoutMillis: number;
    minimumFetchIntervalMillis: number;
}

// @public
export function setLogLevel(remoteConfig: RemoteConfig, logLevel: LogLevel): void;

// @public
export interface Value {
    asBoolean(): boolean;
    asNumber(): number;
    asString(): string;
    getSource(): ValueSource;
}

// @public
export type ValueSource = 'static' | 'default' | 'remote';


```
