## API Report File for "@firebase/firestore"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { EmulatorMockTokenOptions } from '@firebase/util';
import { FirebaseApp } from '@firebase/app';
import { FirebaseError } from '@firebase/util';
import { LogLevelString as LogLevel } from '@firebase/logger';

// @public
export function addDoc<T>(reference: CollectionReference<T>, data: WithFieldValue<T>): Promise<DocumentReference<T>>;

// @public
export type AddPrefixToKeys<Prefix extends string, T extends Record<string, unknown>> = {
    [K in keyof T & string as `${Prefix}.${K}`]+?: T[K];
};

// @public
export function arrayRemove(...elements: unknown[]): FieldValue;

// @public
export function arrayUnion(...elements: unknown[]): FieldValue;

// @public
export class Bytes {
    static fromBase64String(base64: string): Bytes;
    static fromUint8Array(array: Uint8Array): Bytes;
    isEqual(other: Bytes): boolean;
    toBase64(): string;
    toString(): string;
    toUint8Array(): Uint8Array;
}

// @public
export const CACHE_SIZE_UNLIMITED = -1;

// @public
export type ChildUpdateFields<K extends string, V> = V extends Record<string, unknown> ? AddPrefixToKeys<K, UpdateData<V>> : never;

// @public
export function clearIndexedDbPersistence(firestore: Firestore): Promise<void>;

// @public
export function collection(firestore: Firestore, path: string, ...pathSegments: string[]): CollectionReference<DocumentData>;

// @public
export function collection(reference: CollectionReference<unknown>, path: string, ...pathSegments: string[]): CollectionReference<DocumentData>;

// @public
export function collection(reference: DocumentReference, path: string, ...pathSegments: string[]): CollectionReference<DocumentData>;

// @public
export function collectionGroup(firestore: Firestore, collectionId: string): Query<DocumentData>;

// @public
export class CollectionReference<T = DocumentData> extends Query<T> {
    get id(): string;
    get parent(): DocumentReference<DocumentData> | null;
    get path(): string;
    readonly type = "collection";
    withConverter<U>(converter: FirestoreDataConverter<U>): CollectionReference<U>;
    withConverter(converter: null): CollectionReference<DocumentData>;
}

// @public
export function connectFirestoreEmulator(firestore: Firestore, host: string, port: number, options?: {
    mockUserToken?: EmulatorMockTokenOptions | string;
}): void;

// @public
export function deleteDoc(reference: DocumentReference<unknown>): Promise<void>;

// @public
export function deleteField(): FieldValue;

// @public
export function disableNetwork(firestore: Firestore): Promise<void>;

// @public
export function doc(firestore: Firestore, path: string, ...pathSegments: string[]): DocumentReference<DocumentData>;

// @public
export function doc<T>(reference: CollectionReference<T>, path?: string, ...pathSegments: string[]): DocumentReference<T>;

// @public
export function doc(reference: DocumentReference<unknown>, path: string, ...pathSegments: string[]): DocumentReference<DocumentData>;

// @public
export interface DocumentChange<T = DocumentData> {
    readonly doc: QueryDocumentSnapshot<T>;
    readonly newIndex: number;
    readonly oldIndex: number;
    readonly type: DocumentChangeType;
}

// @public
export type DocumentChangeType = 'added' | 'removed' | 'modified';

// @public
export interface DocumentData {
    [field: string]: any;
}

// @public
export function documentId(): FieldPath;

// @public
export class DocumentReference<T = DocumentData> {
    readonly converter: FirestoreDataConverter<T> | null;
    readonly firestore: Firestore;
    get id(): string;
    get parent(): CollectionReference<T>;
    get path(): string;
    readonly type = "document";
    withConverter<U>(converter: FirestoreDataConverter<U>): DocumentReference<U>;
    withConverter(converter: null): DocumentReference<DocumentData>;
}

// @public
export class DocumentSnapshot<T = DocumentData> {
    protected constructor();
    data(options?: SnapshotOptions): T | undefined;
    exists(): this is QueryDocumentSnapshot<T>;
    get(fieldPath: string | FieldPath, options?: SnapshotOptions): any;
    get id(): string;
    readonly metadata: SnapshotMetadata;
    get ref(): DocumentReference<T>;
}

export { EmulatorMockTokenOptions }

// @public
export function enableIndexedDbPersistence(firestore: Firestore, persistenceSettings?: PersistenceSettings): Promise<void>;

// @public
export function enableMultiTabIndexedDbPersistence(firestore: Firestore): Promise<void>;

// @public
export function enableNetwork(firestore: Firestore): Promise<void>;

// @public
export function endAt(snapshot: DocumentSnapshot<unknown>): QueryConstraint;

// @public
export function endAt(...fieldValues: unknown[]): QueryConstraint;

// @public
export function endBefore(snapshot: DocumentSnapshot<unknown>): QueryConstraint;

// @public
export function endBefore(...fieldValues: unknown[]): QueryConstraint;

// @public
export class FieldPath {
    constructor(...fieldNames: string[]);
    isEqual(other: FieldPath): boolean;
}

// @public
export abstract class FieldValue {
    abstract isEqual(other: FieldValue): boolean;
}

// @public
export class Firestore {
    get app(): FirebaseApp;
    toJSON(): object;
    type: 'firestore-lite' | 'firestore';
}

// @public
export interface FirestoreDataConverter<T> {
    fromFirestore(snapshot: QueryDocumentSnapshot<DocumentData>, options?: SnapshotOptions): T;
    toFirestore(modelObject: WithFieldValue<T>): DocumentData;
    toFirestore(modelObject: PartialWithFieldValue<T>, options: SetOptions): DocumentData;
}

// @public
export class FirestoreError extends FirebaseError {
    readonly code: FirestoreErrorCode;
    readonly message: string;
    readonly stack?: string;
}

// @public
export type FirestoreErrorCode = 'cancelled' | 'unknown' | 'invalid-argument' | 'deadline-exceeded' | 'not-found' | 'already-exists' | 'permission-denied' | 'resource-exhausted' | 'failed-precondition' | 'aborted' | 'out-of-range' | 'unimplemented' | 'internal' | 'unavailable' | 'data-loss' | 'unauthenticated';

// @public
export interface FirestoreSettings {
    cacheSizeBytes?: number;
    experimentalAutoDetectLongPolling?: boolean;
    experimentalForceLongPolling?: boolean;
    host?: string;
    ignoreUndefinedProperties?: boolean;
    ssl?: boolean;
}

// @public
export class GeoPoint {
    constructor(latitude: number, longitude: number);
    isEqual(other: GeoPoint): boolean;
    get latitude(): number;
    get longitude(): number;
    toJSON(): {
        latitude: number;
        longitude: number;
    };
}

// @public
export function getDoc<T>(reference: DocumentReference<T>): Promise<DocumentSnapshot<T>>;

// @public
export function getDocFromCache<T>(reference: DocumentReference<T>): Promise<DocumentSnapshot<T>>;

// @public
export function getDocFromServer<T>(reference: DocumentReference<T>): Promise<DocumentSnapshot<T>>;

// @public
export function getDocs<T>(query: Query<T>): Promise<QuerySnapshot<T>>;

// @public
export function getDocsFromCache<T>(query: Query<T>): Promise<QuerySnapshot<T>>;

// @public
export function getDocsFromServer<T>(query: Query<T>): Promise<QuerySnapshot<T>>;

// @public
export function getFirestore(app?: FirebaseApp): Firestore;

// @public
export function increment(n: number): FieldValue;

// @public
export function initializeFirestore(app: FirebaseApp, settings: FirestoreSettings): Firestore;

// @public
export function limit(limit: number): QueryConstraint;

// @public
export function limitToLast(limit: number): QueryConstraint;

// @public
export function loadBundle(firestore: Firestore, bundleData: ReadableStream<Uint8Array> | ArrayBuffer | string): LoadBundleTask;

// @public
export class LoadBundleTask implements PromiseLike<LoadBundleTaskProgress> {
    catch<R>(onRejected: (a: Error) => R | PromiseLike<R>): Promise<R | LoadBundleTaskProgress>;
    onProgress(next?: (progress: LoadBundleTaskProgress) => unknown, error?: (err: Error) => unknown, complete?: () => void): void;
    then<T, R>(onFulfilled?: (a: LoadBundleTaskProgress) => T | PromiseLike<T>, onRejected?: (a: Error) => R | PromiseLike<R>): Promise<T | R>;
}

// @public
export interface LoadBundleTaskProgress {
    bytesLoaded: number;
    documentsLoaded: number;
    taskState: TaskState;
    totalBytes: number;
    totalDocuments: number;
}

export { LogLevel }

// @public
export function namedQuery(firestore: Firestore, name: string): Promise<Query | null>;

// @public
export type NestedUpdateFields<T extends Record<string, unknown>> = UnionToIntersection<{
    [K in keyof T & string]: ChildUpdateFields<K, T[K]>;
}[keyof T & string]>;

// @public
export function onSnapshot<T>(reference: DocumentReference<T>, observer: {
    next?: (snapshot: DocumentSnapshot<T>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<T>(reference: DocumentReference<T>, options: SnapshotListenOptions, observer: {
    next?: (snapshot: DocumentSnapshot<T>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<T>(reference: DocumentReference<T>, onNext: (snapshot: DocumentSnapshot<T>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshot<T>(reference: DocumentReference<T>, options: SnapshotListenOptions, onNext: (snapshot: DocumentSnapshot<T>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshot<T>(query: Query<T>, observer: {
    next?: (snapshot: QuerySnapshot<T>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<T>(query: Query<T>, options: SnapshotListenOptions, observer: {
    next?: (snapshot: QuerySnapshot<T>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<T>(query: Query<T>, onNext: (snapshot: QuerySnapshot<T>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshot<T>(query: Query<T>, options: SnapshotListenOptions, onNext: (snapshot: QuerySnapshot<T>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshotsInSync(firestore: Firestore, observer: {
    next?: (value: void) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshotsInSync(firestore: Firestore, onSync: () => void): Unsubscribe;

// @public
export function orderBy(fieldPath: string | FieldPath, directionStr?: OrderByDirection): QueryConstraint;

// @public
export type OrderByDirection = 'desc' | 'asc';

// @public
export type PartialWithFieldValue<T> = Partial<T> | (T extends Primitive ? T : T extends {} ? {
    [K in keyof T]?: PartialWithFieldValue<T[K]> | FieldValue;
} : never);

// @public
export interface PersistenceSettings {
    forceOwnership?: boolean;
}

// @public
export type Primitive = string | number | boolean | undefined | null;

// @public
export class Query<T = DocumentData> {
    protected constructor();
    readonly converter: FirestoreDataConverter<T> | null;
    readonly firestore: Firestore;
    readonly type: 'query' | 'collection';
    withConverter(converter: null): Query<DocumentData>;
    withConverter<U>(converter: FirestoreDataConverter<U>): Query<U>;
}

// @public
export function query<T>(query: Query<T>, ...queryConstraints: QueryConstraint[]): Query<T>;

// @public
export abstract class QueryConstraint {
    abstract readonly type: QueryConstraintType;
}

// @public
export type QueryConstraintType = 'where' | 'orderBy' | 'limit' | 'limitToLast' | 'startAt' | 'startAfter' | 'endAt' | 'endBefore';

// @public
export class QueryDocumentSnapshot<T = DocumentData> extends DocumentSnapshot<T> {
    // @override
    data(options?: SnapshotOptions): T;
}

// @public
export function queryEqual<T>(left: Query<T>, right: Query<T>): boolean;

// @public
export class QuerySnapshot<T = DocumentData> {
    docChanges(options?: SnapshotListenOptions): Array<DocumentChange<T>>;
    get docs(): Array<QueryDocumentSnapshot<T>>;
    get empty(): boolean;
    forEach(callback: (result: QueryDocumentSnapshot<T>) => void, thisArg?: unknown): void;
    readonly metadata: SnapshotMetadata;
    readonly query: Query<T>;
    get size(): number;
}

// @public
export function refEqual<T>(left: DocumentReference<T> | CollectionReference<T>, right: DocumentReference<T> | CollectionReference<T>): boolean;

// @public
export function runTransaction<T>(firestore: Firestore, updateFunction: (transaction: Transaction) => Promise<T>, options?: TransactionOptions): Promise<T>;

// @public
export function serverTimestamp(): FieldValue;

// @public
export function setDoc<T>(reference: DocumentReference<T>, data: WithFieldValue<T>): Promise<void>;

// @public
export function setDoc<T>(reference: DocumentReference<T>, data: PartialWithFieldValue<T>, options: SetOptions): Promise<void>;

// @public
export function setLogLevel(logLevel: LogLevel): void;

// @public
export type SetOptions = {
    readonly merge?: boolean;
} | {
    readonly mergeFields?: Array<string | FieldPath>;
};

// @public
export function snapshotEqual<T>(left: DocumentSnapshot<T> | QuerySnapshot<T>, right: DocumentSnapshot<T> | QuerySnapshot<T>): boolean;

// @public
export interface SnapshotListenOptions {
    readonly includeMetadataChanges?: boolean;
}

// @public
export class SnapshotMetadata {
    readonly fromCache: boolean;
    readonly hasPendingWrites: boolean;
    isEqual(other: SnapshotMetadata): boolean;
}

// @public
export interface SnapshotOptions {
    readonly serverTimestamps?: 'estimate' | 'previous' | 'none';
}

// @public
export function startAfter(snapshot: DocumentSnapshot<unknown>): QueryConstraint;

// @public
export function startAfter(...fieldValues: unknown[]): QueryConstraint;

// @public
export function startAt(snapshot: DocumentSnapshot<unknown>): QueryConstraint;

// @public
export function startAt(...fieldValues: unknown[]): QueryConstraint;

// @public
export type TaskState = 'Error' | 'Running' | 'Success';

// @public
export function terminate(firestore: Firestore): Promise<void>;

// @public
export class Timestamp {
    constructor(
    seconds: number,
    nanoseconds: number);
    static fromDate(date: Date): Timestamp;
    static fromMillis(milliseconds: number): Timestamp;
    isEqual(other: Timestamp): boolean;
    readonly nanoseconds: number;
    static now(): Timestamp;
    readonly seconds: number;
    toDate(): Date;
    toJSON(): {
        seconds: number;
        nanoseconds: number;
    };
    toMillis(): number;
    toString(): string;
    valueOf(): string;
}

// @public
export class Transaction {
    delete(documentRef: DocumentReference<unknown>): this;
    get<T>(documentRef: DocumentReference<T>): Promise<DocumentSnapshot<T>>;
    set<T>(documentRef: DocumentReference<T>, data: WithFieldValue<T>): this;
    set<T>(documentRef: DocumentReference<T>, data: PartialWithFieldValue<T>, options: SetOptions): this;
    update<T>(documentRef: DocumentReference<T>, data: UpdateData<T>): this;
    update(documentRef: DocumentReference<unknown>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): this;
}

// @public
export interface TransactionOptions {
    readonly maxAttempts?: number;
}

// @public
export type UnionToIntersection<U> = (U extends unknown ? (k: U) => void : never) extends (k: infer I) => void ? I : never;

// @public
export interface Unsubscribe {
    (): void;
}

// @public
export type UpdateData<T> = T extends Primitive ? T : T extends {} ? {
    [K in keyof T]?: UpdateData<T[K]> | FieldValue;
} & NestedUpdateFields<T> : Partial<T>;

// @public
export function updateDoc<T>(reference: DocumentReference<T>, data: UpdateData<T>): Promise<void>;

// @public
export function updateDoc(reference: DocumentReference<unknown>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): Promise<void>;

// @public
export function waitForPendingWrites(firestore: Firestore): Promise<void>;

// @public
export function where(fieldPath: string | FieldPath, opStr: WhereFilterOp, value: unknown): QueryConstraint;

// @public
export type WhereFilterOp = '<' | '<=' | '==' | '!=' | '>=' | '>' | 'array-contains' | 'in' | 'array-contains-any' | 'not-in';

// @public
export type WithFieldValue<T> = T | (T extends Primitive ? T : T extends {} ? {
    [K in keyof T]: WithFieldValue<T[K]> | FieldValue;
} : never);

// @public
export class WriteBatch {
    commit(): Promise<void>;
    delete(documentRef: DocumentReference<unknown>): WriteBatch;
    set<T>(documentRef: DocumentReference<T>, data: WithFieldValue<T>): WriteBatch;
    set<T>(documentRef: DocumentReference<T>, data: PartialWithFieldValue<T>, options: SetOptions): WriteBatch;
    update<T>(documentRef: DocumentReference<T>, data: UpdateData<T>): WriteBatch;
    update(documentRef: DocumentReference<unknown>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): WriteBatch;
}

// @public
export function writeBatch(firestore: Firestore): WriteBatch;


```
