## API Report File for "@firebase/app-check"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { FirebaseApp } from '@firebase/app';
import { PartialObserver } from '@firebase/util';
import { Unsubscribe } from '@firebase/util';

// @public
export interface AppCheck {
    app: FirebaseApp;
}

// @internal (undocumented)
export type _AppCheckComponentName = 'app-check';

// @internal (undocumented)
export type _AppCheckInternalComponentName = 'app-check-internal';

// @public
export interface AppCheckOptions {
    isTokenAutoRefreshEnabled?: boolean;
    provider: CustomProvider | ReCaptchaV3Provider | ReCaptchaEnterpriseProvider;
}

// @public
export interface AppCheckToken {
    readonly expireTimeMillis: number;
    // (undocumented)
    readonly token: string;
}

// @public
export type AppCheckTokenListener = (token: AppCheckTokenResult) => void;

// @public
export interface AppCheckTokenResult {
    readonly token: string;
}

// Warning: (ae-forgotten-export) The symbol "AppCheckProvider" needs to be exported by the entry point index.d.ts
//
// @public
export class CustomProvider implements AppCheckProvider {
    constructor(_customProviderOptions: CustomProviderOptions);
    // Warning: (ae-forgotten-export) The symbol "AppCheckTokenInternal" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    getToken(): Promise<AppCheckTokenInternal>;
    // @internal (undocumented)
    initialize(app: FirebaseApp): void;
    // @internal (undocumented)
    isEqual(otherProvider: unknown): boolean;
}

// @public
export interface CustomProviderOptions {
    getToken: () => Promise<AppCheckToken>;
}

// @public
export function getToken(appCheckInstance: AppCheck, forceRefresh?: boolean): Promise<AppCheckTokenResult>;

// @public
export function initializeAppCheck(app: FirebaseApp | undefined, options: AppCheckOptions): AppCheck;

// @public
export function onTokenChanged(appCheckInstance: AppCheck, observer: PartialObserver<AppCheckTokenResult>): Unsubscribe;

// @public
export function onTokenChanged(appCheckInstance: AppCheck, onNext: (tokenResult: AppCheckTokenResult) => void, onError?: (error: Error) => void, onCompletion?: () => void): Unsubscribe;

export { PartialObserver }

// @public
export class ReCaptchaEnterpriseProvider implements AppCheckProvider {
    constructor(_siteKey: string);
    // @internal
    getToken(): Promise<AppCheckTokenInternal>;
    // @internal (undocumented)
    initialize(app: FirebaseApp): void;
    // @internal (undocumented)
    isEqual(otherProvider: unknown): boolean;
    }

// @public
export class ReCaptchaV3Provider implements AppCheckProvider {
    constructor(_siteKey: string);
    // @internal
    getToken(): Promise<AppCheckTokenInternal>;
    // @internal (undocumented)
    initialize(app: FirebaseApp): void;
    // @internal (undocumented)
    isEqual(otherProvider: unknown): boolean;
    }

// @public
export function setTokenAutoRefreshEnabled(appCheckInstance: AppCheck, isTokenAutoRefreshEnabled: boolean): void;

export { Unsubscribe }


```
