/* A polyfill for browsers that don't support ligatures. */
/* The script tag referring to this file must be placed before the ending body tag. */

/* To provide support for elements dynamically added, this script adds
   method 'icomoonLiga' to the window object. You can pass element references to this method.
*/
(function () {
	'use strict';
	function supportsProperty(p) {
		var prefixes = ['Webkit', 'Moz', 'O', 'ms'],
			i,
			div = document.createElement('div'),
			ret = p in div.style;
		if (!ret) {
			p = p.charAt(0).toUpperCase() + p.substr(1);
			for (i = 0; i < prefixes.length; i += 1) {
				ret = prefixes[i] + p in div.style;
				if (ret) {
					break;
				}
			}
		}
		return ret;
	}
	var icons;
	if (!supportsProperty('fontFeatureSettings')) {
		icons = {
			'home': '&#xe800;',
			'building': '&#xe800;',
			'apartment': '&#xe801;',
			'building2': '&#xe801;',
			'pencil': '&#xe802;',
			'write': '&#xe802;',
			'magic-wand': '&#xe803;',
			'tool': '&#xe803;',
			'drop': '&#xe804;',
			'droplet': '&#xe804;',
			'lighter': '&#xe805;',
			'fire': '&#xe805;',
			'poop': '&#xe806;',
			'toilet': '&#xe806;',
			'sun': '&#xe807;',
			'brightness': '&#xe807;',
			'moon': '&#xe808;',
			'night': '&#xe808;',
			'cloud': '&#xe809;',
			'weather': '&#xe809;',
			'cloud-upload': '&#xe80a;',
			'cloud2': '&#xe80a;',
			'cloud-download': '&#xe80b;',
			'cloud3': '&#xe80b;',
			'cloud-sync': '&#xe80c;',
			'cloud4': '&#xe80c;',
			'cloud-check': '&#xe80d;',
			'cloud5': '&#xe80d;',
			'database': '&#xe80e;',
			'storage': '&#xe80e;',
			'lock': '&#xe80f;',
			'privacy': '&#xe80f;',
			'cog': '&#xe810;',
			'gear': '&#xe810;',
			'trash': '&#xe811;',
			'bin': '&#xe811;',
			'dice': '&#xe812;',
			'game': '&#xe812;',
			'heart': '&#xe813;',
			'love': '&#xe813;',
			'star': '&#xe814;',
			'rating': '&#xe814;',
			'star-half': '&#xe815;',
			'rating2': '&#xe815;',
			'star-empty': '&#xe816;',
			'rating3': '&#xe816;',
			'flag': '&#xe817;',
			'report': '&#xe817;',
			'envelope': '&#xe818;',
			'mail': '&#xe818;',
			'paperclip': '&#xe819;',
			'attachment': '&#xe819;',
			'inbox': '&#xe81a;',
			'drawer': '&#xe81a;',
			'eye': '&#xe81b;',
			'vision': '&#xe81b;',
			'printer': '&#xe81c;',
			'print': '&#xe81c;',
			'file-empty': '&#xe81d;',
			'file': '&#xe81d;',
			'file-add': '&#xe81e;',
			'file2': '&#xe81e;',
			'enter': '&#xe81f;',
			'door': '&#xe81f;',
			'exit': '&#xe820;',
			'door2': '&#xe820;',
			'graduation-hat': '&#xe821;',
			'education': '&#xe821;',
			'license': '&#xe822;',
			'certificate': '&#xe822;',
			'music-note': '&#xe823;',
			'music': '&#xe823;',
			'film-play': '&#xe824;',
			'video': '&#xe824;',
			'camera-video': '&#xe825;',
			'video2': '&#xe825;',
			'camera': '&#xe826;',
			'photo': '&#xe826;',
			'picture': '&#xe827;',
			'photo2': '&#xe827;',
			'book': '&#xe828;',
			'read': '&#xe828;',
			'bookmark': '&#xe829;',
			'ribbon': '&#xe829;',
			'user': '&#xe82a;',
			'persona': '&#xe82a;',
			'users': '&#xe82b;',
			'group': '&#xe82b;',
			'shirt': '&#xe82c;',
			'clothing': '&#xe82c;',
			'store': '&#xe82d;',
			'shop': '&#xe82d;',
			'cart': '&#xe82e;',
			'shop2': '&#xe82e;',
			'tag': '&#xe82f;',
			'price': '&#xe82f;',
			'phone-handset': '&#xe830;',
			'telephone': '&#xe830;',
			'phone': '&#xe831;',
			'telephone2': '&#xe831;',
			'pushpin': '&#xe832;',
			'pin': '&#xe832;',
			'map-marker': '&#xe833;',
			'pin2': '&#xe833;',
			'map': '&#xe834;',
			'guide': '&#xe834;',
			'location': '&#xe835;',
			'compass': '&#xe835;',
			'calendar-full': '&#xe836;',
			'calendar': '&#xe836;',
			'keyboard': '&#xe837;',
			'type': '&#xe837;',
			'spell-check': '&#xe838;',
			'spelling': '&#xe838;',
			'screen': '&#xe839;',
			'monitor': '&#xe839;',
			'smartphone': '&#xe83a;',
			'mobile': '&#xe83a;',
			'tablet': '&#xe83b;',
			'mobile2': '&#xe83b;',
			'laptop': '&#xe83c;',
			'computer': '&#xe83c;',
			'laptop-phone': '&#xe83d;',
			'devices': '&#xe83d;',
			'power-switch': '&#xe83e;',
			'toggle': '&#xe83e;',
			'bubble': '&#xe83f;',
			'chat': '&#xe83f;',
			'heart-pulse': '&#xe840;',
			'health': '&#xe840;',
			'construction': '&#xe841;',
			'road-sign': '&#xe841;',
			'pie-chart': '&#xe842;',
			'chart': '&#xe842;',
			'chart-bars': '&#xe843;',
			'chart2': '&#xe843;',
			'gift': '&#xe844;',
			'birthday': '&#xe844;',
			'diamond': '&#xe845;',
			'jewelry': '&#xe845;',
			'linearicons': '&#xe846;',
			'perxis': '&#xe846;',
			'dinner': '&#xe847;',
			'food': '&#xe847;',
			'coffee-cup': '&#xe848;',
			'drink': '&#xe848;',
			'leaf': '&#xe849;',
			'nature': '&#xe849;',
			'paw': '&#xe84a;',
			'pet': '&#xe84a;',
			'rocket': '&#xe84b;',
			'spaceship': '&#xe84b;',
			'briefcase': '&#xe84c;',
			'suitcase': '&#xe84c;',
			'bus': '&#xe84d;',
			'travel': '&#xe84d;',
			'car': '&#xe84e;',
			'travel2': '&#xe84e;',
			'train': '&#xe84f;',
			'travel3': '&#xe84f;',
			'bicycle': '&#xe850;',
			'exercise': '&#xe850;',
			'wheelchair': '&#xe851;',
			'disabled': '&#xe851;',
			'select': '&#xe852;',
			'cursor': '&#xe852;',
			'earth': '&#xe853;',
			'globe': '&#xe853;',
			'smile': '&#xe854;',
			'emoticon': '&#xe854;',
			'sad': '&#xe855;',
			'emoticon2': '&#xe855;',
			'neutral': '&#xe856;',
			'emoticon3': '&#xe856;',
			'mustache': '&#xe857;',
			'emoticon4': '&#xe857;',
			'alarm': '&#xe858;',
			'bell': '&#xe858;',
			'bullhorn': '&#xe859;',
			'megaphone': '&#xe859;',
			'volume-high': '&#xe85a;',
			'speaker': '&#xe85a;',
			'volume-medium': '&#xe85b;',
			'speaker2': '&#xe85b;',
			'volume-low': '&#xe85c;',
			'speaker3': '&#xe85c;',
			'volume': '&#xe85d;',
			'speaker4': '&#xe85d;',
			'mic': '&#xe85e;',
			'voice': '&#xe85e;',
			'hourglass': '&#xe85f;',
			'loading': '&#xe85f;',
			'undo': '&#xe860;',
			'ccw': '&#xe860;',
			'redo': '&#xe861;',
			'cw': '&#xe861;',
			'sync': '&#xe862;',
			'spinner': '&#xe862;',
			'history': '&#xe863;',
			'archive': '&#xe863;',
			'clock': '&#xe864;',
			'time': '&#xe864;',
			'download': '&#xe865;',
			'down': '&#xe865;',
			'upload': '&#xe866;',
			'up': '&#xe866;',
			'enter-down': '&#xe867;',
			'down2': '&#xe867;',
			'exit-up': '&#xe868;',
			'up2': '&#xe868;',
			'bug': '&#xe869;',
			'insect': '&#xe869;',
			'code': '&#xe86a;',
			'embed': '&#xe86a;',
			'link': '&#xe86b;',
			'url': '&#xe86b;',
			'unlink': '&#xe86c;',
			'url2': '&#xe86c;',
			'thumbs-up': '&#xe86d;',
			'like': '&#xe86d;',
			'thumbs-down': '&#xe86e;',
			'dislike': '&#xe86e;',
			'magnifier': '&#xe86f;',
			'search': '&#xe86f;',
			'cross': '&#xe870;',
			'cancel': '&#xe870;',
			'menu': '&#xe871;',
			'options': '&#xe871;',
			'list': '&#xe872;',
			'options2': '&#xe872;',
			'chevron-up': '&#xe873;',
			'up3': '&#xe873;',
			'chevron-down': '&#xe874;',
			'down3': '&#xe874;',
			'chevron-left': '&#xe875;',
			'left': '&#xe875;',
			'chevron-right': '&#xe876;',
			'right': '&#xe876;',
			'arrow-up': '&#xe877;',
			'up4': '&#xe877;',
			'arrow-down': '&#xe878;',
			'down4': '&#xe878;',
			'arrow-left': '&#xe879;',
			'left2': '&#xe879;',
			'arrow-right': '&#xe87a;',
			'right2': '&#xe87a;',
			'move': '&#xe87b;',
			'arrows': '&#xe87b;',
			'warning': '&#xe87c;',
			'alert': '&#xe87c;',
			'question-circle': '&#xe87d;',
			'help': '&#xe87d;',
			'menu-circle': '&#xe87e;',
			'menu2': '&#xe87e;',
			'checkmark-circle': '&#xe87f;',
			'checkmark': '&#xe87f;',
			'cross-circle': '&#xe880;',
			'cross2': '&#xe880;',
			'plus-circle': '&#xe881;',
			'plus': '&#xe881;',
			'circle-minus': '&#xe882;',
			'minus': '&#xe882;',
			'arrow-up-circle': '&#xe883;',
			'up5': '&#xe883;',
			'arrow-down-circle': '&#xe884;',
			'down5': '&#xe884;',
			'arrow-left-circle': '&#xe885;',
			'left3': '&#xe885;',
			'arrow-right-circle': '&#xe886;',
			'right3': '&#xe886;',
			'chevron-up-circle': '&#xe887;',
			'up6': '&#xe887;',
			'chevron-down-circle': '&#xe888;',
			'down6': '&#xe888;',
			'chevron-left-circle': '&#xe889;',
			'left4': '&#xe889;',
			'chevron-right-circle': '&#xe88a;',
			'right4': '&#xe88a;',
			'crop': '&#xe88b;',
			'cut': '&#xe88b;',
			'frame-expand': '&#xe88c;',
			'maximize': '&#xe88c;',
			'frame-contract': '&#xe88d;',
			'minimize': '&#xe88d;',
			'layers': '&#xe88e;',
			'stack': '&#xe88e;',
			'funnel': '&#xe88f;',
			'filter': '&#xe88f;',
			'text-format': '&#xe890;',
			'typography': '&#xe890;',
			'text-format-remove': '&#xe891;',
			'typography2': '&#xe891;',
			'text-size': '&#xe892;',
			'typography3': '&#xe892;',
			'bold': '&#xe893;',
			'typography4': '&#xe893;',
			'italic': '&#xe894;',
			'typography5': '&#xe894;',
			'underline': '&#xe895;',
			'typography6': '&#xe895;',
			'strikethrough': '&#xe896;',
			'typography7': '&#xe896;',
			'highlight': '&#xe897;',
			'magic-marker': '&#xe897;',
			'text-align-left': '&#xe898;',
			'typography8': '&#xe898;',
			'text-align-center': '&#xe899;',
			'typography9': '&#xe899;',
			'text-align-right': '&#xe89a;',
			'typography10': '&#xe89a;',
			'text-align-justify': '&#xe89b;',
			'typography11': '&#xe89b;',
			'line-spacing': '&#xe89c;',
			'typography12': '&#xe89c;',
			'indent-increase': '&#xe89d;',
			'typography13': '&#xe89d;',
			'indent-decrease': '&#xe89e;',
			'typography14': '&#xe89e;',
			'pilcrow': '&#xe89f;',
			'typography15': '&#xe89f;',
			'direction-ltr': '&#xe8a0;',
			'typography16': '&#xe8a0;',
			'direction-rtl': '&#xe8a1;',
			'typography17': '&#xe8a1;',
			'page-break': '&#xe8a2;',
			'sort-alpha-asc': '&#xe8a3;',
			'sort': '&#xe8a3;',
			'sort-amount-asc': '&#xe8a4;',
			'sort2': '&#xe8a4;',
			'hand': '&#xe8a5;',
			'drag': '&#xe8a5;',
			'pointer-up': '&#xe8a6;',
			'hand2': '&#xe8a6;',
			'pointer-right': '&#xe8a7;',
			'hand3': '&#xe8a7;',
			'pointer-down': '&#xe8a8;',
			'hand4': '&#xe8a8;',
			'pointer-left': '&#xe8a9;',
			'hand5': '&#xe8a9;',
			'0': 0
		};
		delete icons['0'];
		window.icomoonLiga = function (els) {
			var classes,
				el,
				i,
				innerHTML,
				key;
			els = els || document.getElementsByTagName('*');
			if (!els.length) {
				els = [els];
			}
			for (i = 0; ; i += 1) {
				el = els[i];
				if (!el) {
					break;
				}
				classes = el.className;
				if (/lnr/.test(classes)) {
					innerHTML = el.innerHTML;
					if (innerHTML && innerHTML.length > 1) {
						for (key in icons) {
							if (icons.hasOwnProperty(key)) {
								innerHTML = innerHTML.replace(new RegExp(key, 'g'), icons[key]);
							}
						}
						el.innerHTML = innerHTML;
					}
				}
			}
		};
		window.icomoonLiga();
	}
}());