# Bibliography

Standards:

-   <https://www.opengl.org/registry/#oldspecs> Khronos standards

    From there you can reach for example:

    2.1 docs:

    - <https://www.opengl.org/registry/doc/glspec21.20061201.pdf> official spec
    - <https://www.opengl.org/sdk/docs/man2/> online reference

    Latest docs: (4.5 as of 2016):

    - <https://www.opengl.org/sdk/docs/man/>

    4.X docs:

    - <https://www.opengl.org/registry/doc/glspec45.compatibility.pdf>
    - <https://www.opengl.org/registry/doc/glspec45.core.pdf>
    - <https://www.opengl.org/sdk/docs/man4/>

    There is also a "compatibility profile", which includes deprecated functions like `glBegin`: <https://www.opengl.org/registry/doc/glspec45.compatibility.pdf> Deprecated parts are in red.

    -   Vulkan: <https://www.khronos.org/vulkan/>

Standard implementation level of implementations:

- <https://github.com/MightyCreak/mesamatrix>

Tutorials with runnable version tracked code:

-   <https://github.com/JoeyDeVries/LearnOpenGL> <http://learnopengl.com/> GLFW, retained, tutorial source also on GitHub, C++.
-   <https://github.com/opengl-tutorials/ogl> <http://www.opengl-tutorial.org/> GLFW, retained. Code WTF, tutorials CC-BY-NC-ND <http://www.opengl-tutorial.org/uncategorized/2014/02/18/license-changes/> on GitHub pages. By <https://github.com/Whiteseeker>, now UK Googler.
-   <https://github.com/capnramses/antons_opengl_tutorials_book> GLFW, retained, C. Tutorials proprietary: <https://capnramses.github.io/opengl/book_TOC.html> Examples very minimal and easy to extract
-   <https://github.com/Overv/Open.GL/tree/master/content/code> <https://open.gl/> GLFW, retained
-   <https://github.com/tomdalling/opengl-series> <http://www.tomdalling.com/blog/category/modern-opengl/> GLFW, retained
-   <https://gitlab.com/wikibooks-opengl/modern-tutorials>
-   GLES
    -   <https://github.com/danginsburg/opengles3-book>
    -   <https://github.com/McNopper/OpenGL_ES>

Samples without tutorial:

- <https://github.com/openglsuperbible/sb7code> MIT licensed samples from OpenGL superbible book by AMD employee. Very good.
- <https://github.com/g-truc/ogl-samples> Many precise examples of specific OpenGL API features, organized by API version.

Tutorials with runnable code that is not version tracked:

- <http://ogldev.atspace.co.uk/>

Tutorials without runnable source code:

- <https://www.opengl.org/wiki> official wiki, contains some useful insights.
- <http://www.lighthouse3d.com/>
- <http://nehe.gamedev.net>
- Jamie King's video tutorials: <https://www.youtube.com/playlist?list=PLRwVmtr-pp06qT6ckboaOhnm9FxmzHpbY> Some good info on minimal examples, but would benefit from a GitHub. Visual Studio, retained.

Old:

- <http://www.videotutorialsrock.com/>
- <http://www.glprogramming.com/red/>

Java:

- <https://github.com/OskarVeerhoek/YouTube-tutorials>

Demos:

- <https://github.com/prideout/recipes>
- <https://www.youtube.com/watch?v=H-3yPXXZUC8>

Unevaluated:

- <http://www.swiftless.com/>
