# OpenGL

1.  [About](about.md)
1.  [Introduction](introduction.md)
    1.  [Utility libraries](utility-libraries.md)
        1.  [GLUT](glut.md)
        1.  [GLFW](glfw.md)
    1.  [Lightning](lightning.md)
        1. [Ray tracing](ray-tracing.md)
    1.  [Benchmarks](benchmarks.md)
    1.  [Drivers](drivers.md)
    1.  [GLFW](glfw.md)
    1.  Alternatives
        1.  [Vulkan](vulkan.md)
        1.  [GLES](gles/)
    1.  [Software implementations](software-implementations.md)
1.  Examples
    1.  [GLUT hello world](hello_world.c)
    1.  [info](info.c)
    1.  [Triangle](triangle.c)
    1.  [Points](points.c)
    1.  [glOrtho](ortho.c)
    1.  [gluLookAt](look_at.c)
    1.  [glShadeModel](shade_model.c)
    1.  [glViewport](viewport.c)
    1.  [Depth](depth.c)
    1.  [Transparent](transparent.c)
    1.  [Texture](texture.c)
        1.  [Transparent texture](texture_transparent.c)
    1.  Transformations
        1.  [glTranslate](glTranslate.c)
    1.  Lightning
        1.  [Ambient](ambient.c)
        1.  Diffuse
            1.  [glNormal](normal.c)
            1.  [Diffuse infinity](diffuse_infinity.c)
            1.  [Diffuse shadow](diffuse_shadow.c)
            1.  [Diffuse attenuation](diffuse_attenuation.c)
    1.  [glDrawPixels (TODO)](draw_pixels.c)
    1.  [Culling](culling.c)
    1.  [Offscreen](offscreen.c)
    1.  Compute shader
        1.  [compute-shader.md](compute-shader.md)
        1.  [compute_shader.c](glfw_compute_shader.c)
        1.  [compute_shader_ssbo_inc.c](compute_shader_ssbo_inc.c)
        1.  [compute_shader_heat_equation.c](glfw_compute_shader_heat_equation.c)
        1.  [compute_shader_wave_equation.c](glfw_compute_shader_wave_equation.c.off)
    1.  GLUT
        1. [glutBitmapCharacter](bitmap_character.c)
        1. [Triangle rotate](triangle_rotate.c)
    1.  GLFW
        1.  [hello world](glfw_hello_world.c)
        1.  [triangle rotate](glfw_triangle_rotate.c)
    1.  Retained mode + shaders
        1.  [triangle](glfw_triangle_vbo.c)
        1.  [triangle no VBO](glfw_triangle_no_vbo.c)
        1.  [triangle VAO](glfw_triangle_vao.c)
        1.  [color](glfw_color.c)
        1.  [triangles](glfw_triangles.c)
        1.  [IBO](glfw_ibo.c)
        1.  [transform](glfw_transform.c)
        1.  [gl_FragCoord](glfw_gl_frag_coord.c)
        1.  [Texture](glfw_texture.c)
            1.  [Image processing](glfw_webcam_image_process.c)
            1.  [Recursive](glfw_recursive.c.off)
        1.  [heatmap](glfw_heatmap.c)
        1.  Naughty
            1.  [Infinite loop shader](glfw_infinite_loop_shader.c.off)
            1.  [Memory overflow shader](glfw_memory_overflow_shader.c.off)
    1.  Windowing
        1.  [GLX](glx.c)
    1.  Benchmarks
        1.  [Many triangles animation](many_triangles_animation.c)
1.  [main](main.cpp)
1.  Mini projects
    1.  bouncing_balls
        1. [one](bouncing_balls_one.cpp)
        1. [many](bouncing_balls_many.cpp)
    1.  [Texture FPS](texture_fps.cpp)
1.  [Bibliography](bibliography.md)
