/*    lex will use this file to generate a c file
    we compile this c file, and it will do what we want!

    the general goal of flex if to read the input file,
    use regexes on it, and take one action per regex

    this is often the first step of parsing.

    great man:

        info flex
*/

/*
    #substitution section

    here we can give names to patterns to make things clearer
*/

/*
TODO: this is wrong. Add failing test, and use the right one.
http://stackoverflow.com/questions/4755956/unix-flex-regex-for-multi-line-comments/15926440?noredirect=1#comment52516261_15926440
*/
mcom        \/\*([^*]|\*[^/])*\*+\/
digit       [0-9]
letter      [A-Za-z_]
space       [ ]*
float       {digit}*(\.{digit}+(e{digit}+)?)
int         {digit}+
identifier  {letter}({letter}|{digit})*

%{
    /*
        #code section

        stuff here is copied as is to the top of the generated .c file
    */

    /*
        #fileno warning

        i have tried everything to get rid of the fileno warning, but nothing works!

        TODO
    */
    /*#define _POSIX_C_SOURCE 200112L*/
    /*#define __USE_POSIX */
    /*#define _XOPEN_SOURCE 600*/

    #include <stdio.h>
    #include <stdlib.h>

    int yyntokens = 0;
%}
%%
    /*
        #rules section

        this is where flex does its magic

        what starts on line 1 is a rule
        what does not, is copied to the c file directly
    */

    /*
        #rule

        regex, very perl like, followed by action

        first match eats up. TODO confirm

        each match is called a #token.

        the program generated by lex is called a #tokenizer
    */

    /*
        #ECHO

        predefined a macro. Well, it echoes as:

            #define ECHO fwrite(yytext, yyleng, 1, yyout)

        default action for non-matching strings.

        #yytex

        matching string (char*)

        #yyleng

        length of matched string

        #yyout

        output file (FILE*)

        default: stdout.

        can be set at beginning.
    */

    /*
        #yylineno

        defined by flex (but not all versions) at beginning = 1
    */

    /* multiline comment */
    /*\/\*([^*]|\* /[])*\*\/{*/
{mcom} {
        fprintf(yyout, "MCOM: %s\n", yytext );
        yyntokens++;
    }

    /* a c identifier and echo */
{identifier} {
        fprintf(yyout, "ID: %s\n", yytext );
        yyntokens++;
    }

    /* c float */
{float} {
        fprintf(yyout, "FLOAT: %s\n", yytext );
        yyntokens++;
    }

    /* c int, because float did not match */
{int} {
        fprintf(yyout, "INT: %s\n", yytext );
        yyntokens++;
    }

    /* + character */
"+" {
        fprintf(yyout, "PLUS: %s\n", yytext );
        yyntokens++;
    }

"*" {
        fprintf(yyout, "MULT: %s\n", yytext );
        yyntokens++;
    }

    /* c string! */
    /*\"(\\\"|\\\\|[^\n"\\])*\" {*/
\"(\\.|[^\n"\\])*\" {
        fprintf( yyout, "STRING: %s\n", yytext );
        yyntokens++;
    }

    /* literal a+b tab followed by anything*/
    /*"a+b\t".* { fprintf(yyout, "%s\n", yytext ); yyntokens++; }

    /* literal doble quote */
    /*\" { fprintf(yyout, "%s\n", yytext ); yyntokens++; }

    /* literal backslash */
    /*\\ { fprintf(yyout, "%s\n", yytext ); yyntokens++; }*/

    /* anything except &, *even a newline!* */
    /*[^&] { fprintf(yyout, "%s\n", yytext ); yyntokens++; }*/

    /* ignore space */
{space} {}

    /*match line, print line number followed by line*/
    /*^(.*)\n {
            printf("%4d\t%s", yylineno, yytext);
            yyntokens++;
            yylineno++;
        }*/

    /* match newline and echo */
\n {
        fputs("\n",yyout);
        yylineno++;
    }

    /* match everything except newline and echo */
    /*. ECHO; */

    /* if any other weird char shows up, give an error */
.   {
        fputs( "error\n", stderr );
        exit(EXIT_FAILURE);
    }

%%
/*
    # Main section

        We are back to the normal C world here.

        This section is optional.
*/

/*
    This function
*/
int yywrap(void)
{
    return 1;
}

int main(int argc, char *argv[])
{
    /*
        # yyin

            The input FILE.

            In here, if there is no argv[1], opens stdin,
            if there is argv[1], opens the given file
    */
    yyin = fopen(argv[1], "r");

    /*
        # yylex

            yylex is the main function created by lex

            It reads input line by line, matches tokens,
            and takes the actions.

            It exits when file is over.
    */
    yylex();

    /*printf("nlines: %d\nyyntokens: %d\n", yylineno - 1, yyntokens);*/

    fclose(yyin);
    return 0;
}
