# Standards

Like C, C++ is standardized by ISO under the id: ISO/IEC 14882.

The latest standard costs 30 dollars as of 2013, but free drafts are also available.

Links to several versions: <http://stackoverflow.com/questions/81656/where-do-i-find-the-current-c-or-c-standard-documents>

Drafts are freely available at: <http://www.open-std.org/jtc1/sc22/wg21/docs/papers/2012/>. N3337 seems to be very close to C++11.

Like any standard C++ has several versions noted by year. There are also minor revisions knows as technical reports.

## C++89

First version.

## C++03

Bug fix release, not many new features.

## TR1

## Technical report 1

2005 draft for extending C++11.

Most of its propositions were accepted for C++11, and before that many compilers implemented its propositions.

## TR2

## Technical report 2

TODO when was it made?

Not in C++11, maybe C++1Y.

It proposes many inclusions from Boost.

## C++11

<https://en.wikipedia.org/wiki/C%2B%2B11>

Previously known as C++0x, but took too long to come out.

Unlike C++03, *lots* of new features: standard passes from 800 to 1300 lines.

In `gcc` used to be enabled via `-std=c++0x` flag, now `-std=c++11`. Still marked experimental, but good support for the basic features.

## C++14

Will come after C++11. Known as C++1Y as many have doubts it will come out in 2014.
