# C++

1.  Introduction
    1.  [Style guides](style-guides.md)
    1.  [Standards](standards.md)
    1.  [Trivia](trivia.md)
1.  Language
    1.  [main.cpp](main.cpp)
    1.  [Hello world](hello_world.cpp)
    1.  [goto crosses initialization of](goto-cross-initialization.cpp)
    1.  [const](const.cpp)
    1.  [enum](enum.cpp)
        1.  [enum_signed.cpp](enum_signed.cpp)
    1.  [RTTI](rtti.md)
    1.  [Value category](value_category.cpp)
    1.  Compile time magic
        1.  [constexpr](constexpr.cpp)
        1.  [static_assert](static_assert.cpp)
        1.  [typeid](typeid.cpp)
        1.  [auto](auto.cpp)
    1.  [nullptr](nullptr.cpp)
    1.  References
        1.  [reference](reference.cpp)
        1.  [rvalue reference](rvalue_reference.cpp)
        1.  [Value category cheatsheet](https://github.com/jeaye/value-category-cheatsheet/tree/14aef17fb5ab9c35416ec62ac0d45eb12729901f/resources/code)
    1.  [Function](function.cpp)
        1.  [Operator overload](operator_overload.cpp)
            1.  [Cast operator](cast_operator.cpp)
        1.  [Default parameters](default_parameters.cpp)
        1.  [Parameter without name](parameter_without_name.cpp)
        1.  [Lambda](lambda.cpp)
            1.  [Range switch cases](range_switch_case.cpp)
        1.  [Trailing return type](trailing_return_type.cpp)
    1.  [explicit](explicit.cpp)
    1.  [class](class.cpp)
        1.  Constructor
            1.  [Delegating constructor](delegating_constructor.cpp)
            1.  [Implicitly defined functions](implicitly_defined.cpp)
                1.  [Implicitly deleted constructor](implicitly_deleted_constructor.cpp)
            1.  [Constructor init object member](constructor_init_object_member.cpp)
            1.  [Aggregate](aggregate.cpp)
            1.  [static](static.cpp)
                1.  [Static constructor for private members](static_constructor_private.cpp)
            1.  [POD](pod.cpp)
        1.  Inheritance
            1.  [`override` identifier](override.cpp)
            1.  [Inheritance override](inheritance_override.cpp)
            1.  [Inherit overload_hide](inherit_overload_hide.cpp)
            1.  [Inheriting constructor](inheriting_constructor.cpp)
            1.  virtual
                1. [Method pointer, operator .* and operator ->*](method_pointer.cpp)
                1. [Pure virtual](pure_virtual.cpp)
                1. [Pure virtual from constructor](pure_virtual_from_constructor.cpp)
                1. [Covariant return](covariant_return.cpp)
                1. [Virtual inheritance](http://stackoverflow.com/questions/21558/in-c-what-is-a-virtual-base-class)
    1.  [namespace](namespace.cpp)
    1.  [exception](exception.cpp)
    1.  [typedef](typedef.cpp)
    1.  [typecast](typecast.cpp)
        1.  [const_cast](const_cast.cpp)
        1.  [static_cast](static_cast.cpp)
    1.  [new](new.cpp)
    1.  [Preprocessor](preprocessor.cpp)
    1.  using
        1. using type alias. TODO http://en.cppreference.com/w/cpp/language/type_alias
    1.  templates
        1.  [template instantiation](template_instantiation/)
1.  [Standard library](standard_library.md)
    1.  [Headers](common.hpp)
    1.  [Containers](containers.md)
        1.  [vector](vector.cpp)
        1.  [array](array.cpp)
        1.  [string](string.cpp)
            1.  [Raw string literal](raw_string_literal.cpp)
        1.  [list](list.cpp)
        1.  [set](set.cpp)
            1.  [unordered_set](unordered_set.cpp)
        1.  [valarray](valarray.cpp)
        1.  [deque](deque.cpp)
        1.  [bitset](bitset.cpp)
    1.  IO
        1.  [sstream](sstream.cpp)
        1.  [iostream](iostream.cpp)
        1.  [File IO](file_io.cpp)
    1.  [algorithm](algorithm.cpp)
        1.  [heap](heap.cpp)
    1.  [functional](functional.cpp)
    1.  [iterator](iterator.cpp)
    1.  [limits](limits.cpp)
        1.  [NaN](nan.cpp)
    1.  [memory](memory.cpp)
    1.  [regex](regex.cpp)
    1.  [utility](utility.cpp)
        1.  [pair](pair.cpp)
        1.  [tuple](tuple.cpp)
        1.  [std_move](std_move.cpp)
    1.  Smart pointers
        1.  [unique_ptr](unique_ptr.cpp)
        1.  [shared_ptr](shared_ptr.cpp)
            1.  [Function that maybe returns static](func_ret_maybe_static.cpp)
1.  Multi-file
    1.  [Inline variable](inline_variable/)
    1.  [extern const](extern_const/)
1.  [Interactive](interactive/)
    1.  [chrono](interactive/chrono.cpp)
1.  Applications
    1. [Design patterns](design_patterns.cpp)

WIP:

- [CRTP](crtp.cpp)
