# CMake

Good examples: <https://github.com/ttroy50/cmake-examples>

1. [hello](hello/)
1. [multi_executable](multi_executable/)
1. [multi_file](multi_file/)
1. [multi_file_recursive](multi_file_recursive/)
1. [shared_lib_external](shared_lib_external/)

Make alternative that aims to be portable.

Generates build files that work on Linux and Windows, e.g.:

- POSIX `Makefiles` on Linux,
- Code::Blocks project
- `cmd.exe` build scripts for Windows
- Visual Studio projects for Windows

So basically a compatibility wrapper to various build systems.

The configuration file is `CMakeLists.txt`, and are written in Yet Another Language.

The standard CMake build process is:

    mkdir build
    cd build
    cmake ..
    cmake --build .

All generated output will be put inside `build`, which should be gitignored.

Yes, you want to define:

    alias cmk='mkdir -p build && cd build && cmake .. && cmake --build .'

CMake also comes with a test driver, `ctest`, which you can use as:

    cd build
    ctest .

## Choose generator

    cmake --help

shows a list, then:

## Uninstall

Nope, not by default!

<http://stackoverflow.com/questions/19921017/cleaning-cmake-installed-files>

<https://cmake.org/Wiki/CMake_FAQ#Can_I_do_.22make_uninstall.22_with_CMake.3F>

`install_manifest.txt` contains a list of installed files and seems to be generated by default under `build/` upon install, so you can just do:

    sudo xargs rm <install_manifest.txt

## Show build commands

With the generated makefile:

    make VERBOSE=1

## Make shared library

    cmake .. -DBUILD_SHARED_LIBS=ON

<https://cmake.org/cmake/help/v3.0/variable/BUILD_SHARED_LIBS.html>

## Debug symbols

No (default it seems):

    cmake -DCMAKE_BUILD_TYPE=Release

Yes, no optimizations:

    cmake -DCMAKE_BUILD_TYPE=Debug

Both release optimizations and debug symbols:

    cmake -DCMAKE_BUILD_TYPE=RelWithDebInfo

Change what flags are passed;

    set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -Wall")
    set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -Wall")

## IDEs

<https://cmake.org/Wiki/CMake_Generator_Specific_Information>

Eclipse CDT:

- <http://stackoverflow.com/questions/18931278/project-generated-with-cmake-for-eclipse-cdt>
- <http://stackoverflow.com/questions/9453851/how-to-configure-eclipse-cdt-for-cmake>

Code::Blocks:

    cd build
    cmake .. -G 'CodeBlocks - Unix Makefiles'

## Makefile options

### Show commands

<http://stackoverflow.com/questions/2670121/using-cmake-with-gnu-make-how-can-i-see-the-exact-commands>

    make VERBOSE=1

### Change install destination without recompile

<http://stackoverflow.com/questions/13480846/how-to-modify-the-install-path-without-running-the-configure-script-cmake-again>

Says:

    make install DESTDIR=/opt/local

## ccmake

CMake ncurses interface.

Very convenient to see which options are available.
