# Style guides

-   <https://www.securecoding.cert.org/confluence/display/c/CERT+C+Coding+Standard>

    CERT C Coding Standard.

    Focus on security.

    By Carnegie Mellon University.

## MISRA C

<http://en.wikipedia.org/wiki/MISRA_C>

Popular non-free guide developed by / for big industries.

Aims at very high reliability.

There is also a C++ version.

More than a style-guide, MISRA can be called a subset of the language, as it forbids things like recursion.

This has led to the creation of program verification tools that target MISRA instead of full C, e.g. the proprietary Escher C verifier: <http://eschertech.com/products/ecv.php>

This comparison to SPARK 2014 (analogous Ada subset) shows several points of MISRA: <http://www.spark-2014.org/entries/detail/misra-c-2012-vs-spark-2014-the-subset-matching-game>
