# C

1.  Introduction
    1. [Standards](standards.md)
    1. [Implementations](implementations.md)
    1. [Undefined behaviour](undefined-behaviour.md)
    1. [Style guides](style-guides.md)
    1. [Pros and cons](pros-and-cons.md)
    1. [Trivia](trivia.md)
    1. [Bibliography](bibliography.md)
1.  Sanity
    1. [hello_world.c](hello_world.c)
    1. [min.c](min.c)
    1. [template.c](template.c)
1.  Insanity
    1. [infinite_loop.c](infinite_loop.c)
1.  Language
    1.  [main function](main_function.c)
        1.  [Command line arguments](interactive/command_line_arguments.c)
        1.  [Ugly grammar](interactive/ugly_grammar.c)
    1.  Data
        1.  [Identifier](identifier.c)
            1.  [Uninitialized variable](uninitialized_variable.c)
        1.  [Types](types.c)
            1.  [Basic types](basic_types.md)
            1.  [Incomplete types](incomplete_type.c)
            1.  [void](void.c)
            1.  [Array](array.c)
                1.  [Array designated initializer](array_designated_initializer.c)
                1.  [String](string.c)
                1.  [VLA](vla.c)
            1.  [Type qualifier](type_qualifier.c)
                1.  [const](const.c)
                1.  [restrict](restrict.c)
                1.  [auto](auto.c)
                1.  [register](register.c)
                1.  [volatile](volatile.c)
            1.  User defined types
                1.  [enum](enum.c)
                1.  [typedef](typedef.c)
                    1.  [typedef function](typedef function.c)
                1.  [struct](struct.c)
                    1.  [struct operators](struct_operators.c)
                    1.  [struct designated initializer](struct_designated_initializer.c)
                    1.  [Bitfield](bitfield.c)
                    1.  [Flexible array member](flexible_array_member.c)
                1.  [union](union.c)
        1.  [Literals](literals.c)
            1.  [Compound struct literal](compound_struct_literal.c)
            1.  [Hex float literal](hex_float.c)
        1.  [Typecast](typecast.c)
        1.  Compile time operations
            1.  [_Generic](generic.c)
            1.  [Constant expression](constant_expression.c)
                1.  [Static_assert](static_assert.c)
        1.  [Pointer](pointer.c)
            1.  [void pointer](void_pointer.c)
            1.  [Pointer to int typecast](pointer_to_int.c)
            1.  [NULL](null.c)
    1.  Branching
        1.  [if](if.c)
        1.  [while](while.c)
        1.  [switch](switch.c)
        1.  [goto](goto.c)
        1.  [Function](function.c)
            1.  [Function pointer](function_pointer.c)
            1.  [inline](inline.c)
            1.  Parameters
                1.  [Identifier list](identifier_list.c)
                1.  [Identifier list](identifier_list.c)
                1.  [Parameter without name](parameter_without_name.c)
                1.  [Static array argument](static_array_argument.c)
                1.  [void parameter](void_parameter.c)
            1.  return
                1.  [No return non-void](no_return_non_void.c)
                1.  [_Noreturn](noreturn.c)
    1.  [Global scope](global.c)
    1.  [Operator](operator.c)
        1. [sizeof()](sizeof.c)
    1.  [Sequence point](sequence_point.c)
    1.  [Lexer](lexer.c)
    1.  Preprocessor
        1. [Comments](comments.c)
        1. [Preprocessor inside C](preprocessor.c)
        1. [Preprocessor in isolation](preprocessor.sh)
    1.  [Signal](signal.c)
    1.  [Trigraph](trigraph.c)
    1.  Multi-file
        1.  [static](static/)
        1.  [extern](extern/)
1.  stdlib
    1.  [assert.h](assert_h.c)
        1.  [NDEBUG](ndebug.c)
    1.  [stdio.h](stdio_h.c)
        1.  [stderr](stderr.c)
        1.  [File write read numeric](file_write_read_numeric.c)
        1.  [printf](printf.c)
        1.  [getc stdin](interactive/getc.c)
        1.  [getchar](getchar.c)
        1.  [perror](perror.c)
    1.  [stdint.h](stdint_h.c)
    1.  [stdlib.h](stdlib_h.c)
        1.  Exit related
            1.  [exit()](exit.c)
            1.  [atexit()](atexit.c)
        1.  [abs()](abs.c)
        1.  [malloc()](malloc.c)
        1.  [getenv](getenv.c)
        1.  [offsetof()](offsetof.c)
    1.  [string.h](string_h.c)
    1.  [ctype.h](ctype_h.c)
    1.  [time.h](time_h.c)
        1. [clock()](interactive/clock.c)
        1. [strftime](strftime.c)
    1.  [limits.h](limits_h.c)
    1.  [stdbool.h](stdbool_h.c)
    1.  [float.h](float_h.c)
        1.  [Subnormal numbers](interactive/subnormal.c)
        1.  [float range](interactive/float_range.c)
    1.  [math.h](math_h.c)
        1.  [NaN](nan.c)
    1.  [complex.h](complex_h.c)
    1.  [varargs_h](varargs_h.c)
    1.  [errno.h](errno_h.c)
    1.  [iso646.h](iso646_h.c)
    1.  [setjmp.h](setjmp_h.c)
1.  Applications
    1.  [Design patterns](design_patterns.c)
        1.  [Polymorphism](polymorphism.c)
        1.  [C++ templates](template_cpp.c)
    1.  [String to int](string_to_int.c)
    1.  [User input](interactive/user_input.c.off)
    1.  [Memory layout](memory_layout.c)
    1.  [Profiling](interactive/profiling.c)
    1.  Audio generation
        1.  [interactive/audio_gen.c](interactive/audio_gen.c)
        1.  [How to programmatically synthesize music?](interactive/how-to-programmatically-synthesize-music.md)
