# Firebird .NET Data Provider

## Documentation

* [ADO.NET provider](docs/ado-net.md)
* [Entity Framework 6 provider](docs/entity-framework-6.md)
* [Entity Framework Core provider](docs/entity-framework-core.md)
* [Services - Backup](docs/services-backup.md)
* [Events](docs/events.md)
* [ADO.NET - Schema](docs/ado-net-schema.md)
* [Time zones](docs/time-zones.md)
* [DECFLOAT datatype](docs/decfloat.md)
* [INT128 datatype](docs/int128.md)
* [Batching](docs/batching.md)

## Packages

| NuGet | Version | Downloads |
|-------|---------|-----------|
| [FirebirdSql.Data.FirebirdClient](https://www.nuget.org/packages/FirebirdSql.Data.FirebirdClient) | ![FirebirdSql.Data.FirebirdClient](https://img.shields.io/nuget/v/FirebirdSql.Data.FirebirdClient.svg) | ![FirebirdSql.Data.FirebirdClient](https://img.shields.io/nuget/dt/FirebirdSql.Data.FirebirdClient.svg) |
| [EntityFramework.Firebird](https://www.nuget.org/packages/EntityFramework.Firebird) | ![EntityFramework.Firebird](https://img.shields.io/nuget/v/EntityFramework.Firebird.svg) | ![EntityFramework.Firebird](https://img.shields.io/nuget/dt/EntityFramework.Firebird.svg) |
| [FirebirdSql.EntityFrameworkCore.Firebird](https://www.nuget.org/packages/FirebirdSql.EntityFrameworkCore.Firebird) | ![FirebirdSql.EntityFrameworkCore.Firebird](https://img.shields.io/nuget/v/FirebirdSql.EntityFrameworkCore.Firebird.svg) | ![FirebirdSql.EntityFrameworkCore.Firebird](https://img.shields.io/nuget/dt/FirebirdSql.EntityFrameworkCore.Firebird.svg) |

## Resources

* [Downloads](https://github.com/FirebirdSQL/NETProvider/releases)
* [Issue tracker](https://github.com/FirebirdSQL/NETProvider/issues)
* [Development mailing list](https://groups.google.com/forum/#!forum/firebird-net-provider)

## Builds

[![GitHub Actions](https://github.com/FirebirdSQL/NETProvider/workflows/CI/badge.svg)](https://github.com/FirebirdSQL/NETProvider/actions)

## Misc

### Notable supporters

* Sean Leyne (Broadview Software)
* SMS-Timing

### 3rd party code

* For zlib compression the provider uses pieces from [DotNetZip](http://dotnetzip.codeplex.com/) library.
* For RC4 encryption the provider uses pieces from [Bouncy Castle](https://www.bouncycastle.org/csharp/index.html) library.
