﻿#pragma warning disable IDE0060 // Remove unused parameter

namespace Chubrik.XConsole;

using System.Threading;
#if NET
using System.Runtime.Versioning;
#endif

/// <summary>
/// Animation extensions for <see cref="ConsoleExtras"/>.
/// </summary>
#if NET
[UnsupportedOSPlatform("android")]
[UnsupportedOSPlatform("browser")]
[UnsupportedOSPlatform("ios")]
[UnsupportedOSPlatform("tvos")]
#endif
public static class ConsoleAnimationExtensions
{
    /// <summary>
    /// Starts an ellipsis animation at the current position.
    /// </summary>
    public static IConsoleAnimation AnimateEllipsis(
        this ConsoleExtras extras, CancellationToken? cancellationToken = null)
    {
        return XConsole.CursorPosition.AnimateEllipsis(cancellationToken);
    }

    /// <summary>
    /// Starts a spinner animation at the current position.
    /// </summary>
    public static IConsoleAnimation AnimateSpinner(
        this ConsoleExtras extras, CancellationToken? cancellationToken = null)
    {
        return XConsole.CursorPosition.AnimateSpinner(cancellationToken);
    }
}
