/**
 * \file include/config.h
 *
 * This file is distributed under the terms of the MIT License.
 * See the LICENSE file at the top of this tree, or if it is missing a copy can
 * be found at http://opensource.org/licenses/MIT
 */


#ifndef CONFIG_H
#define CONFIG_H

#ifdef _DEBUG
# define DEBUG 1
#else
# define DEBUG 0
#endif

/* Bit of a hack for macos - inline seems b0rked - probably
 * something I'm doing wrong
 */
#if !defined __GNUC_GNU_INLINE__ && defined __clang__
# define __GNUC_GNU_INLINE__ 1
#endif

#ifdef HAVE_CONFIG_H
#include "ac_config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h>
#endif
#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif
#ifdef HAVE_STDINT_H
# include <stdint.h>
#endif

#include "cc_config.h"

#endif /* CONFIG_H */

// vim: set softtabstop=4 shiftwidth=4 tabstop=4 expandtab:
