$ = document.querySelector.bind(document);
n = document.createElement.bind(document);
ns = "slingcode-widgets-order-form";
d = new Date();
fields = ["amount", "email", "type", "date"];

$("#date").value = d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();

$("#order").onclick = function(ev) {
  ev.preventDefault();
  var d = loaddata();
  d.push([$("#amount").value,
          $("#email").value,
          $("#type").value,
          $("#date").value,
         ]);
  savedata(d);
  render(d);
}

function remove(idx) {
  var d = loaddata();
  d.splice(idx, 1);
  savedata(d);
  render(d);
}

function loaddata() {
  try {
    return JSON.parse(localStorage[ns]);
  } catch(e) {
    return [];
  }
}

function savedata(update) {
  localStorage[ns] = JSON.stringify(update);
}

function table(d) {
  var t = $("#orders");
  t.innerHTML = "";
  var head = n("tr");
  t.appendChild(head);
  fields.concat([""]).forEach(function(h) {
    var col = n("th");
    col.innerText = h;
    head.appendChild(col);
  });
  for (r=0; r<d.length; r++) {
    var row = n("tr");
    t.appendChild(row);
    for (c=0; c<4; c++) {
      var col = n("td");
      col.innerText = d[r][c];
      row.appendChild(col);
    }
    col = n("td");
    col.classList.add("del");
    col.innerHTML = "x"
    col.onclick = remove.bind(null, r);
    row.appendChild(col);
  }
  return d;
}

function csv(d) {
  var csv = "data:text/csv;charset=utf-8,";
  csv += fields.join(",") + "\r\n"
  d.forEach(function(row) {
    csv += row.join(",") + "\r\n";
  });
  console.log(csv);
  $("#download").setAttribute("href", encodeURI(csv));
  return d;
}

function render(d) {
  table(d);
  csv(d);
  if (d.length) {
  	$("#download").style.display = "table";
  } else {
  	$("#download").style.display = "none";
  }
}

render(loaddata());