# sitefox.auth 


## `add-messages!`
``` clojure

(add-messages! [req messages])
```


Add messages to be displayed during the authentication process.

[Source](null/blob/null/src/sitefox/auth.cljs#L165-L168)
## `component:error`
``` clojure

(component:error [errors k])
```


Reagent component to display an error message for a field validation error.

[Source](null/blob/null/src/sitefox/auth.cljs#L428-L432)
## `component:messages`
``` clojure

(component:messages [req])
```


Reagent component to display messages related to authentication.

[Source](null/blob/null/src/sitefox/auth.cljs#L434-L443)
## `component:reset-password-email`
``` clojure

(component:reset-password-email [req verify-url])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L541-L546)
## `component:reset-password-email-form`
``` clojure

(component:reset-password-email-form [req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L524-L539)
## `component:reset-password-email-form-done`
``` clojure

(component:reset-password-email-form-done [req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L548-L554)
## `component:reset-password-form`
``` clojure

(component:reset-password-form [req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L556-L573)
## `component:sign-in-form`
``` clojure

(component:sign-in-form [req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L453-L473)
## `component:sign-up-email`
``` clojure

(component:sign-up-email [req verify-url])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L502-L507)
## `component:sign-up-form`
``` clojure

(component:sign-up-form [req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L477-L500)
## `component:sign-up-form-done`
``` clojure

(component:sign-up-form-done [req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L509-L515)
## `component:sign-up-success`
``` clojure

(component:sign-up-success [_req])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L517-L520)
## `component:simple-message`
``` clojure

(component:simple-message [req])
```


Reagent component to display messages related to authentication.

[Source](null/blob/null/src/sitefox/auth.cljs#L445-L449)
## `create-user`
``` clojure

(create-user [auth-key-type auth-key & [user-data]])
```


Creates a new user object in the user's kv table.
   Creates a lookup from `auth-key` to `user-id` for convenient retrieval using `get-user-by-key`.

[Source](null/blob/null/src/sitefox/auth.cljs#L195-L206)
## `decrypt-for-transit`
``` clojure

(decrypt-for-transit [encrypted])
```


Decrypts a piece of data using symmetric key cryptography and the server's own secret.

[Source](null/blob/null/src/sitefox/auth.cljs#L78-L125)
## `deserialize-user`
``` clojure

(deserialize-user [user cb])
```


Internal function used by passport to retrieve the user's full data from the session.

[Source](null/blob/null/src/sitefox/auth.cljs#L177-L183)
## `encrypt-for-transit`
``` clojure

(encrypt-for-transit [materials])
```


Encrypts a piece of data for transit using symmetric key cryptography and the server's own secret.

[Source](null/blob/null/src/sitefox/auth.cljs#L56-L76)
## `get-or-create-user-by-key`
``` clojure

(get-or-create-user-by-key [auth-key-type auth-key & [user-data]])
```


Try to find a user object by it's `auth-key` (i.e. username/email) and create a new user with that `auth-key` if it can't be found.

[Source](null/blob/null/src/sitefox/auth.cljs#L208-L212)
## `get-user-by-key`
``` clojure

(get-user-by-key [auth-key-type auth-key])
```


Get a user object from the user's kv table. The `auth-key` is the lookup token such as email or username.

[Source](null/blob/null/src/sitefox/auth.cljs#L185-L193)
## `hash-password`
``` clojure

(hash-password [pw & [salt]])
```


Hash a password for storage in a database.
  If `salt` (hex string) is not supplied it will be generated (it should be passed when comparing but not when generating).

[Source](null/blob/null/src/sitefox/auth.cljs#L35-L54)
## `make-hmac-token`
``` clojure

(make-hmac-token [secret size & materials])
```


Create an HMAC token to be used for verifying data was generated by the server and is unmodified.

[Source](null/blob/null/src/sitefox/auth.cljs#L24-L33)
## `make-middleware:reset-password-send-email`
``` clojure

(make-middleware:reset-password-send-email [reset-password-email-component email-subject from-address])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L343-L369)
## `make-middleware:sign-up-email`
``` clojure

(make-middleware:sign-up-email [email-view-component email-subject from-address])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L273-L301)
## `make-middleware:signed-in-redirect`
``` clojure

(make-middleware:signed-in-redirect [redirect-url])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L251-L255)
## `middleware:finalize-sign-up`
``` clojure

(middleware:finalize-sign-up [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L319-L330)
## `middleware:reset-password-email-submit`
``` clojure

(middleware:reset-password-email-submit [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L334-L341)
## `middleware:reset-password-submit`
``` clojure

(middleware:reset-password-submit [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L394-L403)
## `middleware:sign-in-submit`
``` clojure

(middleware:sign-in-submit [req res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L239-L249)
## `middleware:sign-up-submit`
``` clojure

(middleware:sign-up-submit [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L259-L271)
## `middleware:update-password`
``` clojure

(middleware:update-password [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L405-L424)
## `middleware:verify-reset-password`
``` clojure

(middleware:verify-reset-password [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L371-L392)
## `middleware:verify-sign-up`
``` clojure

(middleware:verify-sign-up [req _res done])
```


[Source](null/blob/null/src/sitefox/auth.cljs#L303-L317)
## `save-user`
``` clojure

(save-user [user-data])
```


Persist a user object back into the users kv table, overwriting the existing object.

[Source](null/blob/null/src/sitefox/auth.cljs#L214-L221)
## `serialize-user`
``` clojure

(serialize-user [user cb])
```


Internal function used by passport to store a user reference in the session.

[Source](null/blob/null/src/sitefox/auth.cljs#L172-L175)
## `setup-auth`
``` clojure

(setup-auth [app & [sign-out-redirect-url]])
```


Set up passport based authentication. The `sign-out-redirect-url` defaults to '/'.

[Source](null/blob/null/src/sitefox/auth.cljs#L577-L587)
## `setup-email-based-auth`
``` clojure

(setup-email-based-auth
 [app
  template
  selector
  &
  {:keys
   [sign-in-redirect
    sign-in-form-component
    sign-up-redirect
    sign-up-email-component
    sign-up-email-subject
    sign-up-from-address
    sign-up-form-component
    sign-up-form-done-component
    simple-message-component]}])
```


Set up passport email based authentication with all of the required forms and views.
  Pass in an HTML `template` string and `selector` where the auth UI should be be mounted.

  You can override various aspects of the UI using these keys:

  * `:sign-in-redirect` is the URL to redirect to after signing in (defaults to `/`).
  * `:sign-up-redirect` is the URL to redirect to after signing up successfully (defaults to `/`).
  * `:sign-in-form-component` is a Reagent component to render the sign-in form (defaults to `component:sign-in-form`).
  * `:sign-up-email-component` is a Reagent component to render the sign-up validation email (defaults to `component:sign-up-email`).
  * `:sign-up-email-subject` the subject line of the sign up verification email (defaults to `req.hostname + ' signup email.'`).
  * `:sign-up-form-component` is a Reagent component to render the sign-up form (defaults to `component:sign-up-form`).
  * `:sign-up-form-done-component` is a Reagent component to render the sign-up done page (defaults to `component:sign-up-form-done`).
  * `:simple-message-component` is a Reagent component to render error messages during the verification stage (defaults to `component:simple-message`).

[Source](null/blob/null/src/sitefox/auth.cljs#L589-L628)
## `setup-reset-password`
``` clojure

(setup-reset-password
 [app
  template
  selector
  &
  {:keys
   [reset-password-redirect
    reset-password-email-subject
    reset-password-from-address
    reset-password-email-component
    reset-password-email-form-component
    reset-password-email-form-done-component
    reset-password-form-component
    simple-message-component]}])
```


Add a 'reset password' flow to the app. Covers both 'change password' and 'forgot password' functionality.
  Pass in an HTML `template` string and `selector` where the auth UI should be mounted.

  You can override various aspects of the UI using these keys:

  * `:reset-redirect` is the URL to redirect to after the password has been reset successfully (defaults to `/`).
  * `:reset-password-email-form-component` is a Reagent component to render the reset-password email form (defaults to `component:reset-password-email-form`).
  * `:reset-password-form-component` is a Reagent component to render the reset-password form (defaults to `component:reset-password-form`).
  * `:simple-message-component` is a Reagent component to render error messages during the password reset process (defaults to `component:simple-message-component`).

[Source](null/blob/null/src/sitefox/auth.cljs#L630-L673)
## `timestamp-expired?`
``` clojure

(timestamp-expired? [time-stamp milliseconds])
```


Check if a timestamp (ms) has expired.

[Source](null/blob/null/src/sitefox/auth.cljs#L127-L143)
## `validate-post-data`
``` clojure

(validate-post-data [req fields & [warnings]])
```


Uses node-input-validator to validated post data and returns any validation errors.
   `fields` is a structure following the input validator format like: `{:email ["required" "email"]}`.
  `warnings` is similarly a structure overriding the default warnings like: `{:email "You must supply a valid email address"}`.

[Source](null/blob/null/src/sitefox/auth.cljs#L147-L163)
## `verify-kv-email-user`
``` clojure

(verify-kv-email-user [email password cb])
```


Verify the user's supplied email and password against that in the database.

[Source](null/blob/null/src/sitefox/auth.cljs#L223-L233)
# sitefox.db 


## `client`
``` clojure

(client [])
```


The database client that is connected to `DATABASE_URL`.
  This allows you to make raw queries against the database.

[Source](null/blob/null/src/sitefox/db.cljs#L23-L29)
## `database-url`

[Source](null/blob/null/src/sitefox/db.cljs#L12-L12)
## `kv`
``` clojure

(kv [kv-ns])
```


Access a database backed key-value store ([Keyv](https://github.com/lukechilds/keyv) instance).
  `kv-ns` is a namespace (i.e. table).
  The database to use can be configured with the `DATABASE_URL` environment variable.
  See the Keyv documentation for details.
  The promise based API has methods like `(.set kv ...)` and `(.get kv ...)` which do what you'd expect.

[Source](null/blob/null/src/sitefox/db.cljs#L14-L21)
## `ls`
``` clojure

(ls [kv-ns & [pre db]])
```


List all key-value entries matching a particular namespace and prefix.
   Returns a promise that resolves to rows of JSON.

[Source](null/blob/null/src/sitefox/db.cljs#L31-L41)
# sitefox.deps 


## `Keyv`

[Source](null/blob/null/src/sitefox/deps.cljc#L65-L65)
## `LocalStrategy`

[Source](null/blob/null/src/sitefox/deps.cljc#L67-L67)
## `body-parser`

[Source](null/blob/null/src/sitefox/deps.cljc#L59-L59)
## `cljs-loader`

[Source](null/blob/null/src/sitefox/deps.cljc#L68-L68)
## `cookies`

[Source](null/blob/null/src/sitefox/deps.cljc#L58-L58)
## `csrf`

[Source](null/blob/null/src/sitefox/deps.cljc#L61-L61)
## `express`

[Source](null/blob/null/src/sitefox/deps.cljc#L57-L57)
## `morgan`

[Source](null/blob/null/src/sitefox/deps.cljc#L63-L63)
## `parse-html`

[Source](null/blob/null/src/sitefox/deps.cljc#L64-L64)
## `passport`

[Source](null/blob/null/src/sitefox/deps.cljc#L66-L66)
## `serve-static`

[Source](null/blob/null/src/sitefox/deps.cljc#L62-L62)
## `session`

[Source](null/blob/null/src/sitefox/deps.cljc#L60-L60)
# sitefox.html 


## `$`
``` clojure

($ [template selector])
```


Shorthand for CSS style `querySelector` on parsed HTML `template`.

[Source](null/blob/null/src/sitefox/html.cljs#L11-L11)
## `$$`
``` clojure

($$ [template selector])
```


Shorthand for CSS style `querySelectorAll` on parsed HTML `template`.

[Source](null/blob/null/src/sitefox/html.cljs#L13-L13)
## `direct-to-template`
``` clojure

(direct-to-template [res template & selector-component-pairs])
```


Render `selector` `component` Reagent pairs into the HTML `template` string and use the express `res` to send the resulting HTML to the client.

[Source](null/blob/null/src/sitefox/html.cljs#L41-L49)
## `parse`
``` clojure

(parse [html-string])
```


Shorthand for parse-html.

[Source](null/blob/null/src/sitefox/html.cljs#L9-L9)
## `render`
``` clojure

(render [form])
```


Shorthand for Reagent's `render-to-static-markup`.

[Source](null/blob/null/src/sitefox/html.cljs#L15-L15)
## `render-into`
``` clojure

(render-into [html-string selector reagent-forms])
```


Render a Reagent component into the chosen element of an HTML document.
  
  * `html-string` is the HTML document to be modified.
  * `selector` is a CSS-style selector such as `#app` or `main`.
  * `reagent-forms` is a valid Reagent component.

[Source](null/blob/null/src/sitefox/html.cljs#L17-L39)
# sitefox.logging 


## `bail`
``` clojure

(bail [& msgs])
```


Print a message and then kill the current process.

[Source](null/blob/null/src/sitefox/logging.cljs#L46-L51)
## `bind-console-to-file`
``` clojure

(bind-console-to-file [])
```


Rebinds `console.log` and `console.error` so that they write to `./logs/error.log` as well as stdout.

[Source](null/blob/null/src/sitefox/logging.cljs#L20-L44)
## `flush-bound-console`
``` clojure

(flush-bound-console [cb])
```


[Source](null/blob/null/src/sitefox/logging.cljs#L9-L18)
## `log`
``` clojure

(log [file-path & args])
```


Console log with built-in file and time reference.

[Source](null/blob/null/src/sitefox/logging.cljs#L60-L63)
## `now`
``` clojure

(now [])
```


[Source](null/blob/null/src/sitefox/logging.cljs#L53-L58)
# sitefox.mail 


## `send-email`
``` clojure

(send-email [to from subject & {:keys [transport headers text html]}])
```


Send an email.

  Uses the `SMTP_SERVER` environment variable to configure the server to use for sending.
  For example: SMTP_SERVER=smtps://username:password@mail.someserver.com/?pool=true

  If you don't specify a server ethereal.email will be used and the viewing link will be returned in the `url` property of the result.
  You can use this for testing your emails in dev mode.

  * `to` and `from` are valid email addresses.
  * `to` can be an array of valid email addresses for multiple recipients.
  * `subject` is the text of the subject line.
  * Use `:text` for the body of the email in text format.
  * Use `:html` for the body of the email in html format.
  * Use `:smtp-transport` keyword argument if you want to re-use the transport to send multiple emails.
  * Use `:headers` to pass a map of additional headers.

[Source](null/blob/null/src/sitefox/mail.cljs#L28-L59)
## `smtp-transport`
``` clojure

(smtp-transport [])
```


Create the SMTP mail transport to be used by `send-email`.
  
  The `SMTP_SERVER` environment variable specifies the connection settings.
  If unset a test account at ethereal.email will be used.

[Source](null/blob/null/src/sitefox/mail.cljs#L9-L26)
# sitefox.reloader 


## `nbb-reloader`
``` clojure

(nbb-reloader [file callback])
```


Sets up filewatcher for development. Automatically re-evaluates this
  file on changes. Uses browser-sync to push changes to the browser.
  `file` can be a path (string) or a vec of strings.

[Source](null/blob/null/src/sitefox/reloader.cljs#L10-L50)
## `sync-browser`
``` clojure

(sync-browser [host port & [files]])
```


Sets up browser-sync for development. Hot-loads CSS and automatically
  refreshes on server code change.

[Source](null/blob/null/src/sitefox/reloader.cljs#L52-L65)
# sitefox.tracebacks 


## `handle-traceback`
``` clojure

(handle-traceback [email-address error])
```


[Source](null/blob/null/src/sitefox/tracebacks.cljs#L9-L15)
## `install-traceback-emailer`
``` clojure

(install-traceback-emailer [email-address])
```


Send any unhandledRejections or uncaughtExceptions to
  the email address specified and exit.

[Source](null/blob/null/src/sitefox/tracebacks.cljs#L17-L24)
# sitefox.ui 


## `check-time-interval`
``` clojure

(check-time-interval [seconds [divisor interval-name]])
```


[Source](null/blob/null/src/sitefox/ui.cljs#L8-L11)
## `log`
``` clojure

(log [& args])
```


[Source](null/blob/null/src/sitefox/ui.cljs#L6-L6)
## `simple-date-time`
``` clojure

(simple-date-time [dt])
```


Returns a simple string representation of the date and time in YYYY-MM-DD HH:MM:SS format.

[Source](null/blob/null/src/sitefox/ui.cljs#L34-L40)
## `slug`
``` clojure

(slug [text])
```


Converts `text` to a url-friendly slug.

[Source](null/blob/null/src/sitefox/ui.cljs#L44-L56)
## `slug-regex`

[Source](null/blob/null/src/sitefox/ui.cljs#L42-L42)
## `time-since`
``` clojure

(time-since [date-string & [from-date-string]])
```


Returns a string describing how long ago the date described in `date-string` was.

[Source](null/blob/null/src/sitefox/ui.cljs#L13-L32)
# sitefox.util 


## `btoa`
``` clojure

(btoa [s])
```


Server side version of browser JavaScript's btoa base64 encoding.

[Source](null/blob/null/src/sitefox/util.cljs#L25-L28)
## `env`
``` clojure

(env [k & [default]])
```


Returns the environment variable named in k with optional default value.

[Source](null/blob/null/src/sitefox/util.cljs#L7-L10)
## `env-required`
``` clojure

(env-required [k & [msg]])
```


Returns the environment variable named in k or exits the process if missing.
  The message printed on exit can be customised in msg.

[Source](null/blob/null/src/sitefox/util.cljs#L12-L16)
## `error-to-json`
``` clojure

(error-to-json [err])
```


Convert a JavaScript error into a form that can be returned as JSON data.

[Source](null/blob/null/src/sitefox/util.cljs#L18-L23)
# sitefox.web 


## `add-default-middleware`
``` clojure

(add-default-middleware [app])
```


Set up default express middleware for:

  * Writing rotating logs to `logs/access.log`.
  * Setting up sessions in the configured database.
  * Parse cookies and body.

[Source](null/blob/null/src/sitefox/web.cljs#L44-L75)
## `build-absolute-uri`
``` clojure

(build-absolute-uri [req path])
```


Creates an absolute URL including host and port.
  Use inside a route: `(build-absolute-uri req "/somewhere")`

[Source](null/blob/null/src/sitefox/web.cljs#L122-L131)
## `create`
``` clojure

(create [])
```


Create a new express app and add the default middleware.

[Source](null/blob/null/src/sitefox/web.cljs#L93-L97)
## `get-named-route`
``` clojure

(get-named-route [req route-name])
```


Retrieve a route that has previously been named.

[Source](null/blob/null/src/sitefox/web.cljs#L151-L154)
## `is-post?`
``` clojure

(is-post? [req])
```


Check whether an express request uses the POST method.

[Source](null/blob/null/src/sitefox/web.cljs#L39-L42)
## `name-route`
``` clojure

(name-route [app route route-name])
```


Attach a name to a route that can be recalled with `get-named-route`.

[Source](null/blob/null/src/sitefox/web.cljs#L145-L149)
## `reset-routes`
``` clojure

(reset-routes [app])
```


Remove all routes in the current app and re-add the default middleware.
  Useful for hot-reloading code.

[Source](null/blob/null/src/sitefox/web.cljs#L83-L91)
## `serve`
``` clojure

(serve [app])
```


Start serving an express app.

  Configure `BIND_ADDRESS` and `PORT` with environment variables.
  They default to `127.0.0.1:8000`.

[Source](null/blob/null/src/sitefox/web.cljs#L99-L110)
## `start`
``` clojure

(start [])
```


Create a new express app and start serving it.
  Runs (create) and then (serve) on the result.
  Returns a promise which resolves with [app host port] once the server is running.

[Source](null/blob/null/src/sitefox/web.cljs#L112-L120)
## `static-folder`
``` clojure

(static-folder [app route dir])
```


Express middleware to statically serve a `dir` on a `route` relative to working dir.

[Source](null/blob/null/src/sitefox/web.cljs#L77-L81)
## `strip-slash-redirect`
``` clojure

(strip-slash-redirect [req res n])
```


Express middleware to strip slashes from the end of any URL by redirecting to the non-slash version.
  Use: `(.use app strip-slash-redirect)

[Source](null/blob/null/src/sitefox/web.cljs#L133-L143)
