---
title: 'Getting started'
---

## Installation

Web Maker is available as a Web app and a Chrome extension. Web app is recommended for use as it has it more features and lesser restrictions due to Chrome extension policies.

**Web app**

The web app requires no installation. Just [goto the app url](/create/). Once you open the app, it is available for offline use in future.

**Chrome extension**

Here is the link to the Chrome extension 👉 [Chrome Web Store](https://chrome.google.com/webstore/detail/web-maker/lkfkkhfhhdkiemehlpkgjeojomhpccnh)

> Note: Chrome extension works in Brave and UC Browser also. Though, it hasn't been thoroughly tested on them.

## Starting Web Maker

**Web app**

As mentioned, the Web app can be simply opened by visiting [https://webmaker.app/create/](/create/).

**Chrome extension**

Once the Chrome extension is installed, you'll see a Web Maker icon in the right-top of your Chrome browser. Click it and Web Maker will open in a new tab.

## Your first creation

Okay, so now you might be wondering what do I do with Web Maker open in front of me? Web Maker lets you write HTML, CSS & JavaScript code and see it's instant preview. So let's write some code.

You should be seeing 3 code panes with the headings: **HTML**, **CSS** and **JS**. Each code pane is a dedicated place to write code in the respective languages. Go ahead and click inside the **HTML** code pane to focus it and then write the following HTML code:

```html
<h1>My first HTML</h1>
```

As soon as you paste the code, you should see the preview of your HTML in the white preview area.

![First code](/images/docs/first-code.png)

This is a very simple web page we just made. Going forward, you might want to put CSS and JavaScript too. You can write them in their respective code panes and see instant preview.

## Your first creation - the files way

You can write the same HTML, CSS and JavaScript in the usual files way as well. Click on **New** button in the top bar. Select the **Files mode** and click **Start blank** button. You'll notice that now you have a sidebar with some files listed and an area for editing any file, instead of 3 code panes for HTML, CSS and JavaScript.

Go ahead and put the same HTML from above in the `index.html` file. You get the same result. But with files mode you get the same old local-like environment inside Web Maker.
