/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */


export interface paths {
  "/auth/login": {
    /** Auth:Jwt.Login */
    post: operations["auth_jwt_login_auth_login_post"];
  };
  "/auth/logout": {
    /** Auth:Jwt.Logout */
    post: operations["auth_jwt_logout_auth_logout_post"];
  };
  "/auth/register": {
    /**
     * Register
     * @description 注册时不能指定setting，使用默认setting
     */
    post: operations["register_auth_register_post"];
  };
  "/user": {
    /** Get All Users */
    get: operations["get_all_users_user_get"];
  };
  "/user/me": {
    /** Get Me */
    get: operations["get_me_user_me_get"];
    /** Update Me */
    patch: operations["update_me_user_me_patch"];
  };
  "/user/{user_id}": {
    /** Admin Get User */
    get: operations["admin_get_user_user__user_id__get"];
    /** Admin Delete User */
    delete: operations["admin_delete_user_user__user_id__delete"];
    /** Admin Update User */
    patch: operations["admin_update_user_user__user_id__patch"];
  };
  "/user/{user_id}/setting": {
    /** Admin Update User Setting */
    patch: operations["admin_update_user_setting_user__user_id__setting_patch"];
  };
  "/conv": {
    /**
     * Get My Conversations
     * @description 返回自己的有效会话
     */
    get: operations["get_my_conversations_conv_get"];
    /** Delete All Conversation */
    delete: operations["delete_all_conversation_conv_delete"];
  };
  "/conv/all": {
    /** Get All Conversations */
    get: operations["get_all_conversations_conv_all_get"];
  };
  "/conv/{conversation_id}": {
    /** Get Conversation History */
    get: operations["get_conversation_history_conv__conversation_id__get"];
    /**
     * Delete Conversation
     * @description 软删除：标记为 invalid 并且从 chatgpt 账号中删除会话，但不会删除 mongodb 中的历史记录
     */
    delete: operations["delete_conversation_conv__conversation_id__delete"];
    /** Update Conversation Title */
    patch: operations["update_conversation_title_conv__conversation_id__patch"];
  };
  "/conv/{conversation_id}/cache": {
    /** Get Conversation History From Cache */
    get: operations["get_conversation_history_from_cache_conv__conversation_id__cache_get"];
  };
  "/conv/{conversation_id}/vanish": {
    /**
     * Vanish Conversation
     * @description 硬删除：删除数据库和账号中的对话和历史记录
     */
    delete: operations["vanish_conversation_conv__conversation_id__vanish_delete"];
  };
  "/conv/{conversation_id}/assign/{username}": {
    /** Assign Conversation */
    patch: operations["assign_conversation_conv__conversation_id__assign__username__patch"];
  };
  "/conv/{conversation_id}/gen_title": {
    /** Generate Conversation Title */
    patch: operations["generate_conversation_title_conv__conversation_id__gen_title_patch"];
  };
  "/conv/{conversation_id}/interpreter": {
    /** Get Conversation Interpreter Info */
    get: operations["get_conversation_interpreter_info_conv__conversation_id__interpreter_get"];
  };
  "/conv/{conversation_id}/interpreter/download-url": {
    /** Get Conversation Interpreter Download Url */
    get: operations["get_conversation_interpreter_download_url_conv__conversation_id__interpreter_download_url_get"];
  };
  "/chat/openai-plugins": {
    /** Get Openai Web Chat Plugins */
    get: operations["get_openai_web_chat_plugins_chat_openai_plugins_get"];
  };
  "/chat/openai-plugins/installed": {
    /** Get Installed Openai Web Chat Plugins */
    get: operations["get_installed_openai_web_chat_plugins_chat_openai_plugins_installed_get"];
  };
  "/chat/openai-plugins/installed/{plugin_id}": {
    /** Get Installed Openai Web Plugin */
    get: operations["get_installed_openai_web_plugin_chat_openai_plugins_installed__plugin_id__get"];
  };
  "/chat/openai-plugins/{plugin_id}/user-settings": {
    /** Update Chat Plugin User Settings */
    patch: operations["update_chat_plugin_user_settings_chat_openai_plugins__plugin_id__user_settings_patch"];
  };
  "/chat/__schema_types": {
    /**
     * Predict Schema Types
     * @description 只用来让 openapi 自动生成 schema，并不实际调用
     */
    get: operations["_predict_schema_types_chat___schema_types_get"];
  };
  "/system/info": {
    /** Get System Info */
    get: operations["get_system_info_system_info_get"];
  };
  "/system/stats/request": {
    /** Get Request Statistics */
    get: operations["get_request_statistics_system_stats_request_get"];
  };
  "/system/stats/ask": {
    /** Get Ask Statistics */
    get: operations["get_ask_statistics_system_stats_ask_get"];
  };
  "/system/config": {
    /** Get Config */
    get: operations["get_config_system_config_get"];
    /** Update Config */
    put: operations["update_config_system_config_put"];
  };
  "/system/credentials": {
    /** Get Credentials */
    get: operations["get_credentials_system_credentials_get"];
    /** Update Credentials */
    put: operations["update_credentials_system_credentials_put"];
  };
  "/system/action/sync-openai-web-conv": {
    /** Sync Openai Web Conversations */
    post: operations["sync_openai_web_conversations_system_action_sync_openai_web_conv_post"];
  };
  "/system/check-openai-web-account": {
    /** Check Openai Web Account */
    get: operations["check_openai_web_account_system_check_openai_web_account_get"];
  };
  "/logs/server": {
    /** Get Server Logs */
    post: operations["get_server_logs_logs_server_post"];
  };
  "/logs/completions": {
    /** Get Completion Logs */
    get: operations["get_completion_logs_logs_completions_get"];
  };
  "/status/common": {
    /** Get Server Status */
    get: operations["get_server_status_status_common_get"];
  };
  "/files/{file_id}/download-url": {
    /**
     * Get File Download Url
     * @description file_id: OpenAI 分配的 id，以 file- 开头
     */
    get: operations["get_file_download_url_files__file_id__download_url_get"];
  };
  "/files/local/upload": {
    /**
     * Upload File To Local
     * @description 上传文件到服务器。文件将被保存在服务器上，返回文件信息。
     * 仅当需要在服务器留存上传的文件时才使用.
     */
    post: operations["upload_file_to_local_files_local_upload_post"];
  };
  "/files/local/download/{file_id}": {
    /** Download File From Local */
    get: operations["download_file_from_local_files_local_download__file_id__get"];
  };
  "/files/openai-web/upload-start": {
    /**
     * Start Upload To Openai
     * @description 要上传文件到 OpenAI Web，前端需要先调用此接口.
     * 1. 若最终上传方法是前端直接上传 (Browser -> Azure Blob)，则获取上传地址并记录文件信息，响应中 upload_file_info 不为空
     * 2. 否则的话就是服务端中转上传（Browser -> Local -> Azure Blob，此时响应中 upload_file_info 为空，前端应当:
     *     a. 先调用 upload_file_to_local 接口上传文件到服务器，拿到文件的 uuid
     *     b. 再调用 upload_local_file_to_openai_web 接口，通知服务器上传文件到 OpenAI Web
     */
    post: operations["start_upload_to_openai_files_openai_web_upload_start_post"];
  };
  "/files/openai-web/__browser_upload_schema__": {
    /** Browser Upload Schema */
    options: operations["__browser_upload_schema___files_openai_web___browser_upload_schema___options"];
  };
  "/files/openai-web/upload-complete/{file_id}": {
    /** Complete Upload To Openai */
    post: operations["complete_upload_to_openai_files_openai_web_upload_complete__file_id__post"];
  };
  "/files/local/upload-to-openai-web/{file_id}": {
    /**
     * Upload Local File To Openai Web
     * @description 将服务器上已有的文件上传到 OpenAI Web（Azure blob）
     */
    post: operations["upload_local_file_to_openai_web_files_local_upload_to_openai_web__file_id__post"];
  };
  "/arkose/v2/{path}": {
    /**
     * Forward Arkose Request
     * @description TODO 经过转发，arkose 会报错 "API_REQUEST_ERROR"
     */
    get: operations["forward_arkose_request_arkose_v2__path__get"];
  };
  "/arkose/info": {
    /** Get Arkose Info */
    get: operations["get_arkose_info_arkose_info_get"];
  };
}

export type webhooks = Record<string, never>;

export interface components {
  schemas: {
    /** AskLogAggregation */
    AskLogAggregation: {
      _id?: components["schemas"]["AskLogAggregationID"] | null;
      /** Count */
      count: number;
      /** User Ids */
      user_ids?: (number | null)[];
      /** Total Queueing Time */
      total_queueing_time?: number | null;
      /** Total Ask Time */
      total_ask_time?: number | null;
    };
    /** AskLogAggregationID */
    AskLogAggregationID: {
      /**
       * Start Time
       * Format: date-time
       */
      start_time: string;
      /** Meta */
      meta?: (components["schemas"]["OpenaiWebAskLogMeta"] | components["schemas"]["OpenaiApiAskLogMeta"]) | null;
    };
    /** AskLogDocument */
    AskLogDocument: {
      /**
       * Id
       * @description MongoDB document ObjectID
       */
      _id?: string | null;
      /**
       * Time
       * Format: date-time
       */
      time?: string;
      /** Meta */
      meta: components["schemas"]["OpenaiWebAskLogMeta"] | components["schemas"]["OpenaiApiAskLogMeta"];
      /** User Id */
      user_id: number;
      /** Conversation Id */
      conversation_id?: string | null;
      /** Queueing Time */
      queueing_time: number | null;
      /** Ask Time */
      ask_time: number | null;
    };
    /** AskRequest */
    AskRequest: {
      source: components["schemas"]["ChatSourceTypes"];
      /** Model */
      model: string;
      /** New Conversation */
      new_conversation: boolean;
      /** New Title */
      new_title?: string | null;
      /** Conversation Id */
      conversation_id?: string | null;
      /** Parent */
      parent?: string | null;
      /** Api Context Message Count */
      api_context_message_count?: number | null;
      /** Text Content */
      text_content: string;
      /** Openai Web Plugin Ids */
      openai_web_plugin_ids?: string[] | null;
      /** Openai Web Attachments */
      openai_web_attachments?: components["schemas"]["OpenaiWebChatMessageMetadataAttachment"][] | null;
      /** Openai Web Multimodal Image Parts */
      openai_web_multimodal_image_parts?: components["schemas"]["OpenaiWebChatMessageMultimodalTextContentImagePart-Input"][] | null;
      /** Arkose Token */
      arkose_token?: string | null;
    };
    /** AskResponse */
    AskResponse: {
      type: components["schemas"]["AskResponseType"];
      /** Tip */
      tip?: string;
      /**
       * Conversation Id
       * Format: uuid
       */
      conversation_id?: string;
      /** Message */
      message?: (components["schemas"]["OpenaiWebChatMessage"] | components["schemas"]["OpenaiApiChatMessage"]) | null;
      /** Error Detail */
      error_detail?: string | null;
    };
    /**
     * AskResponseType
     * @enum {string}
     */
    AskResponseType: "waiting" | "queueing" | "message" | "error";
    /** AuthSetting */
    AuthSetting: {
      /**
       * Jwt Secret
       * @default MODIFY_THIS_TO_RANDOM_SECURE_STRING
       */
      jwt_secret: string;
      /**
       * Jwt Lifetime Seconds
       * @default 259200
       */
      jwt_lifetime_seconds: number;
      /**
       * Cookie Max Age
       * @default 259200
       */
      cookie_max_age: number;
      /**
       * User Secret
       * @default MODIFY_THIS_TO_ANOTHER_RANDOM_SECURE_STRING
       */
      user_secret: string;
    };
    /** BaseChatMessage */
    BaseChatMessage: {
      /**
       * Id
       * Format: uuid
       */
      id: string;
      /**
       * Source
       * @enum {string}
       */
      source: "openai_web" | "openai_api";
      /** Role */
      role: ("system" | "user" | "assistant" | "tool") | string;
      /** Author Name */
      author_name?: ("browser" | "python") | string | null;
      /** Model */
      model?: string | null;
      /** Create Time */
      create_time?: string | null;
      /** Parent */
      parent?: string | null;
      /** Children */
      children: string[];
      /** Content */
      content?: (components["schemas"]["OpenaiWebChatMessageTextContent"] | components["schemas"]["OpenaiWebChatMessageMultimodalTextContent"] | components["schemas"]["OpenaiWebChatMessageCodeContent"] | components["schemas"]["OpenaiWebChatMessageExecutionOutputContent"] | components["schemas"]["OpenaiWebChatMessageStderrContent"] | components["schemas"]["OpenaiWebChatMessageTetherBrowsingDisplayContent"] | components["schemas"]["OpenaiWebChatMessageTetherQuoteContent"] | components["schemas"]["OpenaiWebChatMessageSystemErrorContent"]) | components["schemas"]["OpenaiApiChatMessageTextContent"] | null;
      /** Metadata */
      metadata?: (components["schemas"]["OpenaiWebChatMessageMetadata"] | components["schemas"]["OpenaiApiChatMessageMetadata"]) | null;
      title?: string | null;
    };
    /** BaseConversationHistory */
    BaseConversationHistory: {
      /**
       * Id
       * Format: uuid
       */
      _id?: string;
      /**
       * Source
       * @enum {string}
       */
      source: "openai_web" | "openai_api";
      /** Title */
      title: string;
      /**
       * Create Time
       * Format: date-time
       */
      create_time: string;
      /**
       * Update Time
       * Format: date-time
       */
      update_time: string;
      /** Mapping */
      mapping: {
        [key: string]: components["schemas"]["BaseChatMessage"];
      };
      /**
       * Current Node
       * Format: uuid
       */
      current_node: string;
      /** Current Model */
      current_model?: string | null;
      /** Metadata */
      metadata?: (components["schemas"]["OpenaiWebConversationHistoryMeta"] | components["schemas"]["OpenaiApiConversationHistoryMeta"]) | null;
    };
    /** BaseConversationSchema */
    BaseConversationSchema: {
      /**
       * Id
       * @default -1
       */
      id: number;
      source: components["schemas"]["ChatSourceTypes"];
      /** Conversation Id */
      conversation_id?: string | null;
      /** Source Id */
      source_id?: string | null;
      /** Title */
      title?: string | null;
      /** User Id */
      user_id?: number | null;
      /**
       * Is Valid
       * @default true
       */
      is_valid: boolean;
      /** Current Model */
      current_model?: string | null;
      /** Create Time */
      create_time?: string | null;
      /** Update Time */
      update_time?: string | null;
    };
    /** Body_auth_jwt_login_auth_login_post */
    Body_auth_jwt_login_auth_login_post: {
      /** Grant Type */
      grant_type?: string | null;
      /** Username */
      username: string;
      /** Password */
      password: string;
      /**
       * Scope
       * @default
       */
      scope: string;
      /** Client Id */
      client_id?: string | null;
      /** Client Secret */
      client_secret?: string | null;
    };
    /** Body_upload_file_to_local_files_local_upload_post */
    Body_upload_file_to_local_files_local_upload_post: {
      /**
       * File
       * Format: binary
       */
      file: string;
    };
    /**
     * ChatSourceTypes
     * @enum {string}
     */
    ChatSourceTypes: "openai_web" | "openai_api";
    /** CommonSetting */
    CommonSetting: {
      /**
       * Print Sql
       * @default false
       */
      print_sql: boolean;
      /**
       * Print Traceback
       * @default true
       */
      print_traceback: boolean;
      /**
       * Create Initial Admin User
       * @default true
       */
      create_initial_admin_user: boolean;
      /**
       * Initial Admin User Username
       * @default admin
       */
      initial_admin_user_username: string;
      /**
       * Initial Admin User Password
       * @default password
       */
      initial_admin_user_password: string;
    };
    /** CommonStatusSchema */
    CommonStatusSchema: {
      /** Active User In 5M */
      active_user_in_5m?: number;
      /** Active User In 1H */
      active_user_in_1h?: number;
      /** Active User In 1D */
      active_user_in_1d?: number;
      /** Is Chatbot Busy */
      is_chatbot_busy?: boolean;
      /** Chatbot Waiting Count */
      chatbot_waiting_count?: number;
      /** Gpt4 Count In 3 Hours */
      gpt4_count_in_3_hours?: number;
    };
    /** ConfigModel */
    "ConfigModel-Input": {
      /**
       * @default {
       *   "enabled": true,
       *   "is_plus_account": true,
       *   "enable_team_subscription": false,
       *   "enable_arkose_endpoint": false,
       *   "common_timeout": 20,
       *   "ask_timeout": 600,
       *   "sync_conversations_on_startup": false,
       *   "sync_conversations_schedule": false,
       *   "sync_conversations_schedule_interval_hours": 12,
       *   "enabled_models": [
       *     "gpt_3_5",
       *     "gpt_4"
       *   ],
       *   "model_code_mapping": {
       *     "gpt_3_5": "text-davinci-002-render-sha",
       *     "gpt_3_5_mobile": "text-davinci-002-render-sha-mobile",
       *     "gpt_4": "gpt-4",
       *     "gpt_4o": "gpt-4o",
       *     "gpt_4_browsing": "gpt-4-browsing",
       *     "gpt_4_code_interpreter": "gpt-4-code-interpreter",
       *     "gpt_4_dalle": "gpt-4-dalle",
       *     "gpt_4_mobile": "gpt-4-mobile",
       *     "gpt_4_plugins": "gpt-4-plugins"
       *   },
       *   "file_upload_strategy": "browser_upload_only",
       *   "max_completion_concurrency": 1,
       *   "disable_uploading": false
       * }
       */
      openai_web: components["schemas"]["OpenaiWebChatGPTSetting"];
      /**
       * @default {
       *   "enabled": true,
       *   "openai_base_url": "https://api.openai.com/v1/",
       *   "connect_timeout": 10,
       *   "read_timeout": 20,
       *   "enabled_models": [
       *     "gpt_3_5",
       *     "gpt_4"
       *   ],
       *   "model_code_mapping": {
       *     "gpt_3_5": "gpt-3.5-turbo",
       *     "gpt_4": "gpt-4"
       *   }
       * }
       */
      openai_api: components["schemas"]["OpenaiApiSetting"];
      /**
       * @default {
       *   "print_sql": false,
       *   "print_traceback": true,
       *   "create_initial_admin_user": true,
       *   "initial_admin_user_username": "admin",
       *   "initial_admin_user_password": "password"
       * }
       */
      common: components["schemas"]["CommonSetting"];
      /**
       * @default {
       *   "host": "127.0.0.1",
       *   "port": 8000,
       *   "cors_allow_origins": [
       *     "http://localhost:8000",
       *     "http://localhost:5173",
       *     "http://127.0.0.1:8000",
       *     "http://127.0.0.1:5173"
       *   ]
       * }
       */
      http: components["schemas"]["HttpSetting"];
      /**
       * @default {
       *   "data_dir": "./data",
       *   "database_url": "sqlite+aiosqlite:///data/database.db",
       *   "mongodb_url": "mongodb://cws:password@mongo:27017",
       *   "mongodb_db_name": "cws",
       *   "run_migration": true,
       *   "max_file_upload_size": 104857600
       * }
       */
      data: components["schemas"]["DataSetting"];
      /**
       * @default {
       *   "jwt_secret": "MODIFY_THIS_TO_RANDOM_SECURE_STRING",
       *   "jwt_lifetime_seconds": 259200,
       *   "cookie_max_age": 259200,
       *   "user_secret": "MODIFY_THIS_TO_ANOTHER_RANDOM_SECURE_STRING"
       * }
       */
      auth: components["schemas"]["AuthSetting"];
      /**
       * @default {
       *   "ask_stats_ttl": 7776000,
       *   "request_stats_ttl": 2592000,
       *   "request_stats_filter_keywords": [
       *     "/status"
       *   ]
       * }
       */
      stats: components["schemas"]["StatsSetting"];
      /**
       * @default {
       *   "console_log_level": "INFO"
       * }
       */
      log: components["schemas"]["LogSetting"];
    };
    /** ConfigModel */
    "ConfigModel-Output": {
      /**
       * @default {
       *   "enabled": true,
       *   "is_plus_account": true,
       *   "enable_team_subscription": false,
       *   "enable_arkose_endpoint": false,
       *   "common_timeout": 20,
       *   "ask_timeout": 600,
       *   "sync_conversations_on_startup": false,
       *   "sync_conversations_schedule": false,
       *   "sync_conversations_schedule_interval_hours": 12,
       *   "enabled_models": [
       *     "gpt_3_5",
       *     "gpt_4"
       *   ],
       *   "model_code_mapping": {
       *     "gpt_3_5": "text-davinci-002-render-sha",
       *     "gpt_3_5_mobile": "text-davinci-002-render-sha-mobile",
       *     "gpt_4": "gpt-4",
       *     "gpt_4o": "gpt-4o",
       *     "gpt_4_browsing": "gpt-4-browsing",
       *     "gpt_4_code_interpreter": "gpt-4-code-interpreter",
       *     "gpt_4_dalle": "gpt-4-dalle",
       *     "gpt_4_mobile": "gpt-4-mobile",
       *     "gpt_4_plugins": "gpt-4-plugins"
       *   },
       *   "file_upload_strategy": "browser_upload_only",
       *   "max_completion_concurrency": 1,
       *   "disable_uploading": false
       * }
       */
      openai_web: components["schemas"]["OpenaiWebChatGPTSetting"];
      /**
       * @default {
       *   "enabled": true,
       *   "openai_base_url": "https://api.openai.com/v1/",
       *   "connect_timeout": 10,
       *   "read_timeout": 20,
       *   "enabled_models": [
       *     "gpt_3_5",
       *     "gpt_4"
       *   ],
       *   "model_code_mapping": {
       *     "gpt_3_5": "gpt-3.5-turbo",
       *     "gpt_4": "gpt-4"
       *   }
       * }
       */
      openai_api: components["schemas"]["OpenaiApiSetting"];
      /**
       * @default {
       *   "print_sql": false,
       *   "print_traceback": true,
       *   "create_initial_admin_user": true,
       *   "initial_admin_user_username": "admin",
       *   "initial_admin_user_password": "password"
       * }
       */
      common: components["schemas"]["CommonSetting"];
      /**
       * @default {
       *   "host": "127.0.0.1",
       *   "port": 8000,
       *   "cors_allow_origins": [
       *     "http://localhost:8000",
       *     "http://localhost:5173",
       *     "http://127.0.0.1:8000",
       *     "http://127.0.0.1:5173"
       *   ]
       * }
       */
      http: components["schemas"]["HttpSetting"];
      /**
       * @default {
       *   "data_dir": "./data",
       *   "database_url": "sqlite+aiosqlite:///data/database.db",
       *   "mongodb_url": "mongodb://cws:password@mongo:27017",
       *   "mongodb_db_name": "cws",
       *   "run_migration": true,
       *   "max_file_upload_size": 104857600
       * }
       */
      data: components["schemas"]["DataSetting"];
      /**
       * @default {
       *   "jwt_secret": "MODIFY_THIS_TO_RANDOM_SECURE_STRING",
       *   "jwt_lifetime_seconds": 259200,
       *   "cookie_max_age": 259200,
       *   "user_secret": "MODIFY_THIS_TO_ANOTHER_RANDOM_SECURE_STRING"
       * }
       */
      auth: components["schemas"]["AuthSetting"];
      /**
       * @default {
       *   "ask_stats_ttl": 7776000,
       *   "request_stats_ttl": 2592000,
       *   "request_stats_filter_keywords": [
       *     "/status"
       *   ]
       * }
       */
      stats: components["schemas"]["StatsSetting"];
      /**
       * @default {
       *   "console_log_level": "INFO"
       * }
       */
      log: components["schemas"]["LogSetting"];
    };
    /** CredentialsModel */
    CredentialsModel: {
      /** Openai Web Access Token */
      openai_web_access_token?: string | null;
      /** Openai Api Key */
      openai_api_key?: string | null;
    };
    /** CustomOpenaiApiSettings */
    CustomOpenaiApiSettings: {
      /** Url */
      url?: string | null;
      /** Key */
      key?: string | null;
    };
    /** DailyTimeSlot */
    DailyTimeSlot: {
      /**
       * Start Time
       * Format: time
       * @description 每天可使用的开始时间
       */
      start_time: string;
      /**
       * End Time
       * Format: time
       * @description 每天可使用的结束时间
       */
      end_time: string;
    };
    /** DataSetting */
    DataSetting: {
      /**
       * Data Dir
       * @default ./data
       */
      data_dir: string;
      /**
       * Database Url
       * @default sqlite+aiosqlite:///data/database.db
       */
      database_url: string;
      /**
       * Mongodb Url
       * @default mongodb://cws:password@mongo:27017
       */
      mongodb_url: string;
      /**
       * Mongodb Db Name
       * @default cws
       */
      mongodb_db_name: string;
      /**
       * Run Migration
       * @default true
       */
      run_migration: boolean;
      /**
       * Max File Upload Size
       * @default 104857600
       */
      max_file_upload_size: number;
    };
    /** HTTPValidationError */
    HTTPValidationError: {
      /** Detail */
      detail?: components["schemas"]["ValidationError"][];
    };
    /** HttpSetting */
    HttpSetting: {
      /**
       * Host
       * @default 127.0.0.1
       */
      host: string;
      /**
       * Port
       * @default 8000
       */
      port: number;
      /**
       * Cors Allow Origins
       * @default [
       *   "http://localhost:8000",
       *   "http://localhost:5173",
       *   "http://127.0.0.1:8000",
       *   "http://127.0.0.1:5173"
       * ]
       */
      cors_allow_origins: string[];
    };
    /** LogFilterOptions */
    LogFilterOptions: {
      /**
       * Max Lines
       * @default 100
       */
      max_lines: number;
      /** Exclude Keywords */
      exclude_keywords?: string[];
    };
    /** LogSetting */
    LogSetting: {
      /**
       * Console Log Level
       * @default INFO
       * @enum {string}
       */
      console_log_level: "INFO" | "DEBUG" | "WARNING";
    };
    /** OpenaiApiAskLogMeta */
    OpenaiApiAskLogMeta: {
      /**
       * Source
       * @constant
       */
      source: "openai_api";
      model: components["schemas"]["OpenaiApiChatModels"];
    };
    /** OpenaiApiChatMessage */
    OpenaiApiChatMessage: {
      /**
       * Id
       * Format: uuid
       */
      id: string;
      /**
       * Source
       * @constant
       */
      source: "openai_api";
      /** Role */
      role: ("system" | "user" | "assistant" | "tool") | string;
      /** Author Name */
      author_name?: ("browser" | "python") | string | null;
      /** Model */
      model?: string | null;
      /** Create Time */
      create_time?: string | null;
      /** Parent */
      parent?: string | null;
      /** Children */
      children: string[];
      content?: components["schemas"]["OpenaiApiChatMessageTextContent"] | null;
      /** Metadata */
      metadata?: (components["schemas"]["OpenaiWebChatMessageMetadata"] | components["schemas"]["OpenaiApiChatMessageMetadata"]) | null;
    };
    /** OpenaiApiChatMessageMetadata */
    OpenaiApiChatMessageMetadata: {
      /**
       * Source
       * @constant
       */
      source: "openai_api";
      usage?: components["schemas"]["OpenaiChatResponseUsage"] | null;
      /** Finish Reason */
      finish_reason?: string | null;
    };
    /** OpenaiApiChatMessageTextContent */
    OpenaiApiChatMessageTextContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "text";
      /** Text */
      text: string;
    };
    /**
     * OpenaiApiChatModels
     * @enum {string}
     */
    OpenaiApiChatModels: "gpt_3_5" | "gpt_4";
    /** OpenaiApiConversationHistoryDocument */
    OpenaiApiConversationHistoryDocument: {
      /**
       * Id
       * Format: uuid
       */
      _id?: string;
      /**
       * Source
       * @constant
       */
      source: "openai_api";
      /** Title */
      title: string;
      /**
       * Create Time
       * Format: date-time
       */
      create_time: string;
      /**
       * Update Time
       * Format: date-time
       */
      update_time: string;
      /** Mapping */
      mapping: {
        [key: string]: components["schemas"]["OpenaiApiChatMessage"];
      };
      /**
       * Current Node
       * Format: uuid
       */
      current_node: string;
      /** Current Model */
      current_model?: string | null;
      /** Metadata */
      metadata?: (components["schemas"]["OpenaiWebConversationHistoryMeta"] | components["schemas"]["OpenaiApiConversationHistoryMeta"]) | null;
    };
    /** OpenaiApiConversationHistoryMeta */
    OpenaiApiConversationHistoryMeta: {
      /**
       * Source
       * @constant
       */
      source: "openai_api";
    };
    /** OpenaiApiConversationSchema */
    OpenaiApiConversationSchema: {
      /**
       * Id
       * @default -1
       */
      id: number;
      /**
       * Source
       * @constant
       */
      source: "openai_api";
      /** Conversation Id */
      conversation_id?: string | null;
      /** Source Id */
      source_id?: string | null;
      /** Title */
      title?: string | null;
      /** User Id */
      user_id?: number | null;
      /**
       * Is Valid
       * @default true
       */
      is_valid: boolean;
      /** Current Model */
      current_model?: string | null;
      /** Create Time */
      create_time?: string | null;
      /** Update Time */
      update_time?: string | null;
    };
    /**
     * OpenaiApiPerModelAskCount
     * @default {
     *   "gpt_3_5": 0,
     *   "gpt_4": 0
     * }
     */
    OpenaiApiPerModelAskCount: {
      [key: string]: number;
    };
    /** OpenaiApiSetting */
    OpenaiApiSetting: {
      /**
       * Enabled
       * @default true
       */
      enabled: boolean;
      /**
       * Openai Base Url
       * @default https://api.openai.com/v1/
       */
      openai_base_url: string;
      /** Proxy */
      proxy?: string | null;
      /**
       * Connect Timeout
       * @default 10
       */
      connect_timeout: number;
      /**
       * Read Timeout
       * @default 20
       */
      read_timeout: number;
      /**
       * Enabled Models
       * @default [
       *   "gpt_3_5",
       *   "gpt_4"
       * ]
       */
      enabled_models: components["schemas"]["OpenaiApiChatModels"][];
      /**
       * Model Code Mapping
       * @default {
       *   "gpt_3_5": "gpt-3.5-turbo",
       *   "gpt_4": "gpt-4"
       * }
       */
      model_code_mapping: {
        [key: string]: string;
      };
    };
    /** OpenaiApiSourceSettingSchema */
    OpenaiApiSourceSettingSchema: {
      /** Allow To Use */
      allow_to_use: boolean;
      /** Valid Until */
      valid_until?: string | null;
      /** Max Conv Count */
      max_conv_count: number;
      /** Total Ask Count */
      total_ask_count: number;
      /** Rate Limits */
      rate_limits: components["schemas"]["TimeWindowRateLimit"][];
      /** Daily Available Time Slots */
      daily_available_time_slots: components["schemas"]["DailyTimeSlot"][];
      /** Available Models */
      available_models: components["schemas"]["OpenaiApiChatModels"][];
      per_model_ask_count: components["schemas"]["OpenaiApiPerModelAskCount"];
      /** Allow Custom Openai Api */
      allow_custom_openai_api: boolean;
      custom_openai_api_settings: components["schemas"]["CustomOpenaiApiSettings"];
    };
    /** OpenaiChatFileUploadUrlRequest */
    OpenaiChatFileUploadUrlRequest: {
      /** File Name */
      file_name: string;
      /** File Size */
      file_size: number;
      /**
       * Use Case
       * @enum {string}
       */
      use_case: "my_files" | "multimodal";
    };
    /** OpenaiChatInterpreterInfo */
    OpenaiChatInterpreterInfo: {
      /** Kernel Started */
      kernel_started?: boolean | null;
      /** Time Remaining Ms */
      time_remaining_ms?: number | null;
    };
    /** OpenaiChatPlugin */
    OpenaiChatPlugin: {
      /** Id */
      id?: string | null;
      /** Namespace */
      namespace?: string | null;
      manifest?: components["schemas"]["OpenaiChatPluginManifest"] | null;
      /** Categories */
      categories?: components["schemas"]["OpenaiChatPluginCategory"][] | null;
      /** Domain */
      domain?: string | null;
      /** Status */
      status?: "approved" | string | null;
      /** User Settings */
      user_settings?: components["schemas"]["OpenaiChatPluginUserSettings"] | Record<string, never> | null;
      /** Oauth Client Id */
      oauth_client_id?: string | null;
    };
    /** OpenaiChatPluginCategory */
    OpenaiChatPluginCategory: {
      /** Id */
      id?: string | null;
      /** Title */
      title?: string | null;
    };
    /** OpenaiChatPluginListResponse */
    OpenaiChatPluginListResponse: {
      /** Items */
      items: components["schemas"]["OpenaiChatPlugin"][];
      /** Count */
      count?: number | null;
    };
    /** OpenaiChatPluginManifest */
    OpenaiChatPluginManifest: {
      /** Schema Version */
      schema_version?: string | null;
      /** Name For Model */
      name_for_model?: string | null;
      /** Name For Human */
      name_for_human?: string | null;
      /** Description For Model */
      description_for_model?: string | null;
      /** Description For Human */
      description_for_human?: string | null;
      /** Api */
      api?: Record<string, never> | null;
      /** Auth */
      auth?: Record<string, never> | null;
      /** Logo Url */
      logo_url?: string | null;
      /** Contact Email */
      contact_email?: string | null;
      /** Legal Info Url */
      legal_info_url?: string | null;
    };
    /** OpenaiChatPluginUserSettings */
    OpenaiChatPluginUserSettings: {
      /** Is Authenticated */
      is_authenticated?: boolean | null;
      /** Is Installed */
      is_installed?: boolean | null;
    };
    /** OpenaiChatResponseUsage */
    OpenaiChatResponseUsage: {
      /** Prompt Tokens */
      prompt_tokens?: number | null;
      /** Completion Tokens */
      completion_tokens?: number | null;
    };
    /** OpenaiWebAccountsCheckAccount */
    OpenaiWebAccountsCheckAccount: {
      account: components["schemas"]["OpenaiWebAccountsCheckAccountDetail"];
      /** Features */
      features: string[];
      entitlement: components["schemas"]["OpenaiWebAccountsCheckEntitlement"];
      /** Last Active Subscription */
      last_active_subscription?: Record<string, never> | null;
      /** Is Eligible For Yearly Plus Subscription */
      is_eligible_for_yearly_plus_subscription: boolean;
    };
    /** OpenaiWebAccountsCheckAccountDetail */
    OpenaiWebAccountsCheckAccountDetail: {
      /** Account User Role */
      account_user_role: "account-owner" | string;
      /** Account User Id */
      account_user_id: string;
      /** Processor */
      processor: Record<string, never>;
      /** Account Id */
      account_id: string;
      /** Organization Id */
      organization_id?: string | null;
      /** Is Most Recent Expired Subscription Gratis */
      is_most_recent_expired_subscription_gratis: boolean;
      /** Has Previously Paid Subscription */
      has_previously_paid_subscription: boolean;
      /** Name */
      name?: string | null;
      /** Profile Picture Id */
      profile_picture_id?: string | null;
      /** Profile Picture Url */
      profile_picture_url?: string | null;
      /** Structure */
      structure: ("workspace" | "personal") | string;
      /** Plan Type */
      plan_type: ("team" | "free") | string;
      /** Is Deactivated */
      is_deactivated: boolean;
      /** Promo Data */
      promo_data: Record<string, never>;
    };
    /** OpenaiWebAccountsCheckEntitlement */
    OpenaiWebAccountsCheckEntitlement: {
      /** Subscription Id */
      subscription_id?: string | null;
      /** Has Active Subscription */
      has_active_subscription?: boolean;
      /** Subscription Plan */
      subscription_plan?: ("chatgptteamplan" | "chatgptplusplan") | string | null;
      /** Expires At */
      expires_at?: string | null;
      /** Billing Period */
      billing_period?: "monthly" | string | null;
    };
    /** OpenaiWebAccountsCheckResponse */
    OpenaiWebAccountsCheckResponse: {
      /** Accounts */
      accounts: {
        [key: string]: components["schemas"]["OpenaiWebAccountsCheckAccount"];
      };
      /** Account Ordering */
      account_ordering: string[];
    };
    /** OpenaiWebAskLogMeta */
    OpenaiWebAskLogMeta: {
      /**
       * Source
       * @constant
       */
      source: "openai_web";
      model: components["schemas"]["OpenaiWebChatModels"];
    };
    /** OpenaiWebChatGPTSetting */
    OpenaiWebChatGPTSetting: {
      /**
       * Enabled
       * @default true
       */
      enabled: boolean;
      /**
       * Is Plus Account
       * @default true
       */
      is_plus_account: boolean;
      /**
       * Enable Team Subscription
       * @default false
       */
      enable_team_subscription: boolean;
      /** Team Account Id */
      team_account_id?: string | null;
      /** Chatgpt Base Url */
      chatgpt_base_url?: string | null;
      /** Proxy */
      proxy?: string | null;
      /** Wss Proxy */
      wss_proxy?: string | null;
      /**
       * Enable Arkose Endpoint
       * @default false
       */
      enable_arkose_endpoint: boolean;
      /** Arkose Endpoint Base */
      arkose_endpoint_base?: string | null;
      /**
       * Common Timeout
       * @description Increase this value if timeout error occurs.
       * @default 20
       */
      common_timeout: number;
      /**
       * Ask Timeout
       * @default 600
       */
      ask_timeout: number;
      /**
       * Sync Conversations On Startup
       * @default false
       */
      sync_conversations_on_startup: boolean;
      /**
       * Sync Conversations Schedule
       * @default false
       */
      sync_conversations_schedule: boolean;
      /**
       * Sync Conversations Schedule Interval Hours
       * @default 12
       */
      sync_conversations_schedule_interval_hours: number;
      /**
       * Enabled Models
       * @default [
       *   "gpt_3_5",
       *   "gpt_4"
       * ]
       */
      enabled_models: components["schemas"]["OpenaiWebChatModels"][];
      /**
       * Model Code Mapping
       * @default {
       *   "gpt_3_5": "text-davinci-002-render-sha",
       *   "gpt_3_5_mobile": "text-davinci-002-render-sha-mobile",
       *   "gpt_4": "gpt-4",
       *   "gpt_4o": "gpt-4o",
       *   "gpt_4_mobile": "gpt-4-mobile",
       *   "gpt_4_browsing": "gpt-4-browsing",
       *   "gpt_4_plugins": "gpt-4-plugins",
       *   "gpt_4_code_interpreter": "gpt-4-code-interpreter",
       *   "gpt_4_dalle": "gpt-4-dalle"
       * }
       */
      model_code_mapping: {
        [key: string]: string;
      };
      /** @default browser_upload_only */
      file_upload_strategy: components["schemas"]["OpenaiWebFileUploadStrategyOption"];
      /**
       * Max Completion Concurrency
       * @default 1
       */
      max_completion_concurrency: number;
      /**
       * Disable Uploading
       * @default false
       */
      disable_uploading: boolean;
    };
    /** OpenaiWebChatMessage */
    OpenaiWebChatMessage: {
      /**
       * Id
       * Format: uuid
       */
      id: string;
      /**
       * Source
       * @constant
       */
      source: "openai_web";
      /** Role */
      role: ("system" | "user" | "assistant" | "tool") | string;
      /** Author Name */
      author_name?: ("browser" | "python") | string | null;
      /** Model */
      model?: string | null;
      /** Create Time */
      create_time?: string | null;
      /** Parent */
      parent?: string | null;
      /** Children */
      children: string[];
      /** Content */
      content?: (components["schemas"]["OpenaiWebChatMessageTextContent"] | components["schemas"]["OpenaiWebChatMessageMultimodalTextContent"] | components["schemas"]["OpenaiWebChatMessageCodeContent"] | components["schemas"]["OpenaiWebChatMessageExecutionOutputContent"] | components["schemas"]["OpenaiWebChatMessageStderrContent"] | components["schemas"]["OpenaiWebChatMessageTetherBrowsingDisplayContent"] | components["schemas"]["OpenaiWebChatMessageTetherQuoteContent"] | components["schemas"]["OpenaiWebChatMessageSystemErrorContent"]) | null;
      /** Metadata */
      metadata?: (components["schemas"]["OpenaiWebChatMessageMetadata"] | components["schemas"]["OpenaiApiChatMessageMetadata"]) | null;
    };
    /** OpenaiWebChatMessageCodeContent */
    OpenaiWebChatMessageCodeContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "code";
      /** Language */
      language?: string | null;
      /** Text */
      text?: string | null;
    };
    /** OpenaiWebChatMessageExecutionOutputContent */
    OpenaiWebChatMessageExecutionOutputContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "execution_output";
      /** Text */
      text?: string | null;
    };
    /** OpenaiWebChatMessageMetadata */
    OpenaiWebChatMessageMetadata: {
      /**
       * Source
       * @constant
       */
      source: "openai_web";
      /** Finish Details */
      finish_details?: Record<string, never> | null;
      /** Weight */
      weight?: number | null;
      /** End Turn */
      end_turn?: boolean | null;
      /** Message Status */
      message_status?: string | null;
      /** Recipient */
      recipient?: ("all" | "browser" | "python") | string | null;
      /** Fallback Content */
      fallback_content?: unknown;
      invoked_plugin?: components["schemas"]["OpenaiWebChatMessageMetadataPlugin"] | null;
      /** Command */
      command?: "search" | string | null;
      /** Args */
      args?: unknown[] | null;
      _cite_metadata?: components["schemas"]["OpenaiWebChatMessageMetadataCite"] | null;
      /** Citations */
      citations?: components["schemas"]["OpenaiWebChatMessageMetadataCitation"][] | null;
      /** Attachments */
      attachments?: components["schemas"]["OpenaiWebChatMessageMetadataAttachment"][] | null;
      /** Status */
      status?: "finished_successfully" | string | null;
      /** Is Complete */
      is_complete?: boolean | null;
      aggregate_result?: components["schemas"]["OpenaiWebChatMessageMetadataAggregateResult"] | null;
      /** Timestamp */
      timestamp_?: string | null;
    };
    /** OpenaiWebChatMessageMetadataAggregateResult */
    OpenaiWebChatMessageMetadataAggregateResult: {
      /** Status */
      status?: ("failed_with_in_kernel_exception" | "success") | string | null;
      /** Run Id */
      run_id?: string | null;
      /** Start Time */
      start_time?: number | null;
      /** Update Time */
      update_time?: number | null;
      /** End Time */
      end_time?: number | null;
      /** Final Expression Output */
      final_expression_output?: unknown;
      /** Code */
      code?: string | null;
      /** In Kernel Exception */
      in_kernel_exception?: Record<string, never> | null;
      /** Messages */
      messages?: components["schemas"]["OpenaiWebChatMessageMetadataAggregateResultMessage"][] | null;
      /** Jupyter Messages */
      jupyter_messages?: unknown[] | null;
    };
    /** OpenaiWebChatMessageMetadataAggregateResultMessage */
    OpenaiWebChatMessageMetadataAggregateResultMessage: {
      /** Message Type */
      message_type?: ("image" | "stream") | string | null;
      /** Time */
      time?: number | null;
      /** Sender */
      sender?: "server" | string | null;
      /** Image Url */
      image_url?: string | null;
      /** Stream Name */
      stream_name?: string | null;
      /** Text */
      text?: string | null;
    };
    /** OpenaiWebChatMessageMetadataAttachment */
    OpenaiWebChatMessageMetadataAttachment: {
      /** Name */
      name?: string | null;
      /** Id */
      id?: string | null;
      /** Size */
      size?: number | null;
      /** Height */
      height?: number | null;
      /** Width */
      width?: number | null;
      /** Mimetype */
      mimeType?: string | null;
    };
    /** OpenaiWebChatMessageMetadataCitation */
    OpenaiWebChatMessageMetadataCitation: {
      /** Start Ix */
      start_ix?: number | null;
      /** End Ix */
      end_ix?: number | null;
      metadata?: components["schemas"]["OpenaiWebChatMessageMetadataCiteData"] | null;
    };
    /** OpenaiWebChatMessageMetadataCite */
    OpenaiWebChatMessageMetadataCite: {
      /** Citation Format */
      citation_format?: Record<string, never> | null;
      /** Metadata List */
      metadata_list?: components["schemas"]["OpenaiWebChatMessageMetadataCiteData"][] | null;
    };
    /** OpenaiWebChatMessageMetadataCiteData */
    OpenaiWebChatMessageMetadataCiteData: {
      /** Title */
      title?: string | null;
      /** Url */
      url?: string | null;
      /** Text */
      text?: string | null;
    };
    /** OpenaiWebChatMessageMetadataPlugin */
    OpenaiWebChatMessageMetadataPlugin: {
      /** Http Response Status */
      http_response_status?: number | null;
      /** Namespace */
      namespace?: string | null;
      /** Plugin Id */
      plugin_id?: string | null;
      /** Type */
      type?: string | null;
    };
    /** OpenaiWebChatMessageMultimodalTextContent */
    OpenaiWebChatMessageMultimodalTextContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "multimodal_text";
      /** Parts */
      parts?: unknown[] | null;
    };
    /** OpenaiWebChatMessageMultimodalTextContentImagePart */
    "OpenaiWebChatMessageMultimodalTextContentImagePart-Input": {
      /** Asset Pointer */
      asset_pointer?: string | null;
      /** Size Bytes */
      size_bytes?: number | null;
      /** Width */
      width?: number | null;
      /** Height */
      height?: number | null;
      metadata?: components["schemas"]["OpenaiWebChatMessageMultimodalTextMetadata"] | null;
    };
    /** OpenaiWebChatMessageMultimodalTextContentImagePart */
    "OpenaiWebChatMessageMultimodalTextContentImagePart-Output": {
      /** Asset Pointer */
      asset_pointer?: string | null;
      /** Size Bytes */
      size_bytes?: number | null;
      /** Width */
      width?: number | null;
      /** Height */
      height?: number | null;
      metadata?: components["schemas"]["OpenaiWebChatMessageMultimodalTextMetadata"] | null;
    };
    /** OpenaiWebChatMessageMultimodalTextMetadata */
    OpenaiWebChatMessageMultimodalTextMetadata: {
      dalle?: components["schemas"]["OpenaiWebChatMessageMultimodalTextMetadataDalle"] | null;
    };
    /** OpenaiWebChatMessageMultimodalTextMetadataDalle */
    OpenaiWebChatMessageMultimodalTextMetadataDalle: {
      /** Prompt */
      prompt?: string | null;
      /** Seed */
      seed?: number | null;
      /** Serialization Title */
      serialization_title?: string | null;
    };
    /** OpenaiWebChatMessageStderrContent */
    OpenaiWebChatMessageStderrContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "stderr";
      /** Text */
      text?: string | null;
    };
    /** OpenaiWebChatMessageSystemErrorContent */
    OpenaiWebChatMessageSystemErrorContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "system_error";
      /** Name */
      name?: "tool_error" | string | null;
      /** Text */
      text?: string | null;
    };
    /** OpenaiWebChatMessageTetherBrowsingDisplayContent */
    OpenaiWebChatMessageTetherBrowsingDisplayContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "tether_browsing_display";
      /** Result */
      result?: string | null;
    };
    /** OpenaiWebChatMessageTetherQuoteContent */
    OpenaiWebChatMessageTetherQuoteContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "tether_quote";
      /** Url */
      url?: string | null;
      /** Domain */
      domain?: string | null;
      /** Text */
      text?: string | null;
      /** Title */
      title?: string | null;
    };
    /** OpenaiWebChatMessageTextContent */
    OpenaiWebChatMessageTextContent: {
      /**
       * Content Type
       * @constant
       */
      content_type: "text";
      /** Parts */
      parts?: string[] | null;
    };
    /**
     * OpenaiWebChatModels
     * @enum {string}
     */
    OpenaiWebChatModels: "gpt_3_5" | "gpt_3_5_mobile" | "gpt_4" | "gpt_4o"| "gpt_4_mobile" | "gpt_4_browsing" | "gpt_4_code_interpreter" | "gpt_4_plugins" | "gpt_4_dalle";
    /**
     * OpenaiWebChatStatus
     * @enum {string}
     */
    OpenaiWebChatStatus: "asking" | "queueing" | "idling";
    /** OpenaiWebConversationHistoryDocument */
    OpenaiWebConversationHistoryDocument: {
      /**
       * Id
       * Format: uuid
       */
      _id?: string;
      /**
       * Source
       * @constant
       */
      source: "openai_web";
      /** Title */
      title: string;
      /**
       * Create Time
       * Format: date-time
       */
      create_time: string;
      /**
       * Update Time
       * Format: date-time
       */
      update_time: string;
      /** Mapping */
      mapping: {
        [key: string]: components["schemas"]["OpenaiWebChatMessage"];
      };
      /**
       * Current Node
       * Format: uuid
       */
      current_node: string;
      /** Current Model */
      current_model?: string | null;
      metadata?: components["schemas"]["OpenaiWebConversationHistoryMeta"] | null;
    };
    /** OpenaiWebConversationHistoryMeta */
    OpenaiWebConversationHistoryMeta: {
      /**
       * Source
       * @constant
       */
      source: "openai_web";
      /** Moderation Results */
      moderation_results?: unknown[] | null;
      /** Plugin Ids */
      plugin_ids?: string[] | null;
      /** Gizmo Id */
      gizmo_id?: string | null;
      /** Is Archived */
      is_archived?: boolean | null;
      /** Conversation Template Id */
      conversation_template_id?: string | null;
    };
    /** OpenaiWebConversationSchema */
    OpenaiWebConversationSchema: {
      /**
       * Id
       * @default -1
       */
      id: number;
      /**
       * Source
       * @constant
       */
      source: "openai_web";
      /** Conversation Id */
      conversation_id?: string | null;
      /** Source Id */
      source_id?: string | null;
      /** Title */
      title?: string | null;
      /** User Id */
      user_id?: number | null;
      /**
       * Is Valid
       * @default true
       */
      is_valid: boolean;
      /** Current Model */
      current_model?: string | null;
      /** Create Time */
      create_time?: string | null;
      /** Update Time */
      update_time?: string | null;
    };
    /**
     * OpenaiWebFileUploadStrategyOption
     * @enum {string}
     */
    OpenaiWebFileUploadStrategyOption: "server_upload_only" | "browser_upload_only" | "browser_upload_when_file_size_exceed";
    /**
     * OpenaiWebPerModelAskCount
     * @default {
     *   "gpt_3_5": 0,
     *   "gpt_3_5_mobile": 0,
     *   "gpt_4": 0,
     *   "gpt_4o": 0,
     *   "gpt_4_mobile": 0,
     *   "gpt_4_browsing": 0,
     *   "gpt_4_code_interpreter": 0,
     *   "gpt_4_plugins": 0,
     *   "gpt_4_dalle": 0
     * }
     */
    OpenaiWebPerModelAskCount: {
      [key: string]: number;
    };
    /** OpenaiWebSourceSettingSchema */
    OpenaiWebSourceSettingSchema: {
      /** Allow To Use */
      allow_to_use: boolean;
      /** Valid Until */
      valid_until?: string | null;
      /** Max Conv Count */
      max_conv_count: number;
      /** Total Ask Count */
      total_ask_count: number;
      /** Rate Limits */
      rate_limits: components["schemas"]["TimeWindowRateLimit"][];
      /** Daily Available Time Slots */
      daily_available_time_slots: components["schemas"]["DailyTimeSlot"][];
      /** Available Models */
      available_models: components["schemas"]["OpenaiWebChatModels"][];
      per_model_ask_count: components["schemas"]["OpenaiWebPerModelAskCount"];
      /** Disable Uploading */
      disable_uploading: boolean;
      /** Use Team */
      use_team: boolean;
    };
    /** RequestLogAggregation */
    RequestLogAggregation: {
      _id: components["schemas"]["RequestLogAggregationID"];
      /** Count */
      count: number;
      /**
       * User Ids
       * @default []
       */
      user_ids: (number | null)[];
      /** Avg Elapsed Ms */
      avg_elapsed_ms?: number | null;
    };
    /** RequestLogAggregationID */
    RequestLogAggregationID: {
      /** Start Time */
      start_time?: string | null;
      /** Route Path */
      route_path?: string | null;
      /** Method */
      method?: string | null;
    };
    /** StartUploadRequestSchema */
    StartUploadRequestSchema: {
      /** File Name */
      file_name: string;
      /** File Size */
      file_size: number;
      /** Width */
      width?: number | null;
      /** Height */
      height?: number | null;
      /** Mime Type */
      mime_type?: string | null;
      /**
       * Use Case
       * @enum {string}
       */
      use_case: "my_files" | "multimodal";
    };
    /** StartUploadResponseSchema */
    StartUploadResponseSchema: {
      strategy: components["schemas"]["OpenaiWebFileUploadStrategyOption"];
      /** File Max Size */
      file_max_size: number;
      upload_file_info?: components["schemas"]["UploadedFileInfoSchema"] | null;
    };
    /** StatsSetting */
    StatsSetting: {
      /**
       * Ask Stats Ttl
       * @default 7776000
       */
      ask_stats_ttl: number;
      /**
       * Request Stats Ttl
       * @default 2592000
       */
      request_stats_ttl: number;
      /**
       * Request Stats Filter Keywords
       * @default [
       *   "/status"
       * ]
       */
      request_stats_filter_keywords: string[];
    };
    /** SystemInfo */
    SystemInfo: {
      /** Startup Time */
      startup_time: number;
      /** Total User Count */
      total_user_count: number;
      /** Total Conversation Count */
      total_conversation_count: number;
      /** Valid Conversation Count */
      valid_conversation_count: number;
    };
    /** TimeWindowRateLimit */
    TimeWindowRateLimit: {
      /**
       * Window Seconds
       * @description 时间窗口大小，单位为秒
       */
      window_seconds: number;
      /**
       * Max Requests
       * @description 在给定时间窗口内最多的请求次数
       */
      max_requests: number;
    };
    /** UploadedFileExtraInfo */
    UploadedFileExtraInfo: {
      /** Width */
      width?: number | null;
      /** Height */
      height?: number | null;
    };
    /** UploadedFileInfoSchema */
    UploadedFileInfoSchema: {
      /**
       * Id
       * Format: uuid
       */
      id: string;
      /** Original Filename */
      original_filename: string;
      /** Size */
      size: number;
      /** Storage Path */
      storage_path?: string | null;
      /** Content Type */
      content_type?: string | null;
      /**
       * Upload Time
       * Format: date-time
       */
      upload_time: string;
      /** Uploader Id */
      uploader_id: number;
      openai_web_info?: components["schemas"]["UploadedFileOpenaiWebInfo"] | null;
      extra_info?: components["schemas"]["UploadedFileExtraInfo"] | null;
    };
    /** UploadedFileOpenaiWebInfo */
    UploadedFileOpenaiWebInfo: {
      /** File Id */
      file_id?: string | null;
      /** Use Case */
      use_case?: ("my_files" | "multimodal") | string | null;
      /**
       * Upload Url
       * @description 上传文件的url, 上传后应清空该字段
       */
      upload_url?: string | null;
      /** Download Url */
      download_url?: string | null;
    };
    /** UserCreate */
    UserCreate: {
      /**
       * Email
       * Format: email
       */
      email: string;
      /** Password */
      password: string;
      /**
       * Is Active
       * @default true
       */
      is_active: boolean | null;
      /**
       * Is Superuser
       * @default false
       */
      is_superuser: boolean | null;
      /**
       * Is Verified
       * @default false
       */
      is_verified: boolean | null;
      /** Username */
      username: string;
      /** Nickname */
      nickname: string;
      /** Avatar */
      avatar?: string | null;
      /** Remark */
      remark?: string | null;
    };
    /** UserRead */
    UserRead: {
      /** Id */
      id: number;
      /**
       * Email
       * Format: email
       */
      email: string;
      /** Is Active */
      is_active: boolean;
      /** Is Superuser */
      is_superuser: boolean;
      /** Is Verified */
      is_verified: boolean;
      /** Username */
      username: string;
      /** Nickname */
      nickname: string;
      /** Last Active Time */
      last_active_time: string | null;
      /**
       * Create Time
       * Format: date-time
       */
      create_time: string;
      /** Avatar */
      avatar?: string | null;
      setting: components["schemas"]["UserSettingSchema-Output"];
    };
    /** UserReadAdmin */
    UserReadAdmin: {
      /** Id */
      id: number;
      /**
       * Email
       * Format: email
       */
      email: string;
      /** Is Active */
      is_active: boolean;
      /** Is Superuser */
      is_superuser: boolean;
      /** Is Verified */
      is_verified: boolean;
      /** Username */
      username: string;
      /** Nickname */
      nickname: string;
      /** Last Active Time */
      last_active_time: string | null;
      /**
       * Create Time
       * Format: date-time
       */
      create_time: string;
      /** Avatar */
      avatar?: string | null;
      setting: components["schemas"]["UserSettingSchema-Output"];
      /** Remark */
      remark?: string | null;
    };
    /** UserSettingSchema */
    "UserSettingSchema-Input": {
      /** Id */
      id?: number | null;
      /** User Id */
      user_id?: number | null;
      /** Credits */
      credits: number;
      openai_web_chat_status: components["schemas"]["OpenaiWebChatStatus"];
      openai_web: components["schemas"]["OpenaiWebSourceSettingSchema"];
      openai_api: components["schemas"]["OpenaiApiSourceSettingSchema"];
    };
    /** UserSettingSchema */
    "UserSettingSchema-Output": {
      /** Id */
      id?: number | null;
      /** User Id */
      user_id?: number | null;
      /** Credits */
      credits: number;
      openai_web_chat_status: components["schemas"]["OpenaiWebChatStatus"];
      openai_web: components["schemas"]["OpenaiWebSourceSettingSchema"];
      openai_api: components["schemas"]["OpenaiApiSourceSettingSchema"];
    };
    /** UserUpdate */
    UserUpdate: {
      /** Password */
      password?: string | null;
      /** Email */
      email?: string | null;
      /** Is Active */
      is_active?: boolean | null;
      /** Is Superuser */
      is_superuser?: boolean | null;
      /** Is Verified */
      is_verified?: boolean | null;
      /** Nickname */
      nickname?: string | null;
      /** Avatar */
      avatar?: string | null;
    };
    /** UserUpdateAdmin */
    UserUpdateAdmin: {
      /** Password */
      password?: string | null;
      /** Email */
      email?: string | null;
      /** Is Active */
      is_active?: boolean | null;
      /** Is Superuser */
      is_superuser?: boolean | null;
      /** Is Verified */
      is_verified?: boolean | null;
      /** Nickname */
      nickname?: string | null;
      /** Avatar */
      avatar?: string | null;
      /** Username */
      username?: string | null;
      /** Remark */
      remark?: string | null;
    };
    /** ValidationError */
    ValidationError: {
      /** Location */
      loc: (string | number)[];
      /** Message */
      msg: string;
      /** Error Type */
      type: string;
    };
  };
  responses: never;
  parameters: never;
  requestBodies: never;
  headers: never;
  pathItems: never;
}

export type $defs = Record<string, never>;

export type external = Record<string, never>;

export interface operations {

  /** Auth:Jwt.Login */
  auth_jwt_login_auth_login_post: {
    requestBody: {
      content: {
        "application/x-www-form-urlencoded": components["schemas"]["Body_auth_jwt_login_auth_login_post"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Auth:Jwt.Logout */
  auth_jwt_logout_auth_logout_post: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /**
   * Register
   * @description 注册时不能指定setting，使用默认setting
   */
  register_auth_register_post: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UserCreate"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get All Users */
  get_all_users_user_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Get Me */
  get_me_user_me_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Update Me */
  update_me_user_me_patch: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["UserUpdate"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Admin Get User */
  admin_get_user_user__user_id__get: {
    parameters: {
      path: {
        user_id: number;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Admin Delete User */
  admin_delete_user_user__user_id__delete: {
    parameters: {
      path: {
        user_id: number;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Admin Update User */
  admin_update_user_user__user_id__patch: {
    parameters: {
      path: {
        user_id: number;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UserUpdateAdmin"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Admin Update User Setting */
  admin_update_user_setting_user__user_id__setting_patch: {
    parameters: {
      path: {
        user_id: number;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["UserSettingSchema-Input"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Get My Conversations
   * @description 返回自己的有效会话
   */
  get_my_conversations_conv_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Delete All Conversation */
  delete_all_conversation_conv_delete: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Get All Conversations */
  get_all_conversations_conv_all_get: {
    parameters: {
      query?: {
        valid_only?: boolean;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Conversation History */
  get_conversation_history_conv__conversation_id__get: {
    parameters: {
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Delete Conversation
   * @description 软删除：标记为 invalid 并且从 chatgpt 账号中删除会话，但不会删除 mongodb 中的历史记录
   */
  delete_conversation_conv__conversation_id__delete: {
    parameters: {
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Update Conversation Title */
  update_conversation_title_conv__conversation_id__patch: {
    parameters: {
      query: {
        title: string;
      };
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Conversation History From Cache */
  get_conversation_history_from_cache_conv__conversation_id__cache_get: {
    parameters: {
      path: {
        conversation_id: unknown;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Vanish Conversation
   * @description 硬删除：删除数据库和账号中的对话和历史记录
   */
  vanish_conversation_conv__conversation_id__vanish_delete: {
    parameters: {
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Assign Conversation */
  assign_conversation_conv__conversation_id__assign__username__patch: {
    parameters: {
      path: {
        username: string;
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Generate Conversation Title */
  generate_conversation_title_conv__conversation_id__gen_title_patch: {
    parameters: {
      query: {
        message_id: string;
      };
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Conversation Interpreter Info */
  get_conversation_interpreter_info_conv__conversation_id__interpreter_get: {
    parameters: {
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Conversation Interpreter Download Url */
  get_conversation_interpreter_download_url_conv__conversation_id__interpreter_download_url_get: {
    parameters: {
      query: {
        message_id: string;
        sandbox_path: string;
      };
      path: {
        conversation_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Openai Web Chat Plugins */
  get_openai_web_chat_plugins_chat_openai_plugins_get: {
    parameters: {
      query?: {
        offset?: number;
        limit?: number;
        category?: string;
        search?: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Installed Openai Web Chat Plugins */
  get_installed_openai_web_chat_plugins_chat_openai_plugins_installed_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Get Installed Openai Web Plugin */
  get_installed_openai_web_plugin_chat_openai_plugins_installed__plugin_id__get: {
    parameters: {
      path: {
        plugin_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Update Chat Plugin User Settings */
  update_chat_plugin_user_settings_chat_openai_plugins__plugin_id__user_settings_patch: {
    parameters: {
      query?: {
        use_team?: boolean | null;
      };
      path: {
        plugin_id: string;
      };
    };
    requestBody: {
      content: {
        "application/json": components["schemas"]["OpenaiChatPluginUserSettings"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Predict Schema Types
   * @description 只用来让 openapi 自动生成 schema，并不实际调用
   */
  _predict_schema_types_chat___schema_types_get: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["AskRequest"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get System Info */
  get_system_info_system_info_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Get Request Statistics */
  get_request_statistics_system_stats_request_get: {
    parameters: {
      query?: {
        granularity?: number;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Ask Statistics */
  get_ask_statistics_system_stats_ask_get: {
    parameters: {
      query?: {
        granularity?: number;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Config */
  get_config_system_config_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Update Config */
  update_config_system_config_put: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["ConfigModel-Input"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Credentials */
  get_credentials_system_credentials_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Update Credentials */
  update_credentials_system_credentials_put: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["CredentialsModel"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Sync Openai Web Conversations */
  sync_openai_web_conversations_system_action_sync_openai_web_conv_post: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Check Openai Web Account */
  check_openai_web_account_system_check_openai_web_account_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Get Server Logs */
  get_server_logs_logs_server_post: {
    requestBody?: {
      content: {
        "application/json": components["schemas"]["LogFilterOptions"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Completion Logs */
  get_completion_logs_logs_completions_get: {
    parameters: {
      query?: {
        start_time?: string;
        end_time?: string;
        max_results?: number;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Server Status */
  get_server_status_status_common_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /**
   * Get File Download Url
   * @description file_id: OpenAI 分配的 id，以 file- 开头
   */
  get_file_download_url_files__file_id__download_url_get: {
    parameters: {
      path: {
        file_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Upload File To Local
   * @description 上传文件到服务器。文件将被保存在服务器上，返回文件信息。
   * 仅当需要在服务器留存上传的文件时才使用.
   */
  upload_file_to_local_files_local_upload_post: {
    requestBody: {
      content: {
        "multipart/form-data": components["schemas"]["Body_upload_file_to_local_files_local_upload_post"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Download File From Local */
  download_file_from_local_files_local_download__file_id__get: {
    parameters: {
      path: {
        file_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Start Upload To Openai
   * @description 要上传文件到 OpenAI Web，前端需要先调用此接口.
   * 1. 若最终上传方法是前端直接上传 (Browser -> Azure Blob)，则获取上传地址并记录文件信息，响应中 upload_file_info 不为空
   * 2. 否则的话就是服务端中转上传（Browser -> Local -> Azure Blob，此时响应中 upload_file_info 为空，前端应当:
   *     a. 先调用 upload_file_to_local 接口上传文件到服务器，拿到文件的 uuid
   *     b. 再调用 upload_local_file_to_openai_web 接口，通知服务器上传文件到 OpenAI Web
   */
  start_upload_to_openai_files_openai_web_upload_start_post: {
    requestBody: {
      content: {
        "application/json": components["schemas"]["StartUploadRequestSchema"];
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Browser Upload Schema */
  __browser_upload_schema___files_openai_web___browser_upload_schema___options: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
  /** Complete Upload To Openai */
  complete_upload_to_openai_files_openai_web_upload_complete__file_id__post: {
    parameters: {
      path: {
        file_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Upload Local File To Openai Web
   * @description 将服务器上已有的文件上传到 OpenAI Web（Azure blob）
   */
  upload_local_file_to_openai_web_files_local_upload_to_openai_web__file_id__post: {
    parameters: {
      path: {
        file_id: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /**
   * Forward Arkose Request
   * @description TODO 经过转发，arkose 会报错 "API_REQUEST_ERROR"
   */
  forward_arkose_request_arkose_v2__path__get: {
    parameters: {
      path: {
        path: string;
      };
    };
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
      /** @description Validation Error */
      422: {
        content: {
          "application/json": components["schemas"]["HTTPValidationError"];
        };
      };
    };
  };
  /** Get Arkose Info */
  get_arkose_info_arkose_info_get: {
    responses: {
      /** @description Successful Response */
      200: {
        content: {
          "application/json": string;
        };
      };
    };
  };
}
