﻿namespace CharacterMap.Models;

public class MakeBasicFilterAttribute : Attribute
{
    /*
     * "All" & "AllFilters" are generated in CharacterMap.Generators.FilterGen based on 
     * any NamedUnicodeRange with a [MakeBasicFilter] Attribute.
     */
}

public static partial class UnicodeRanges
{
    /* Created using https://dotnetfiddle.net/jexT5V */

    [MakeBasicFilter] public static NamedUnicodeRange BasicLatin = new(0x0000, 0x007F, "Basic Latin");
    [MakeBasicFilter] public static NamedUnicodeRange Latin1Supplement = new(0x0080, 0x00FF, "Latin-1 Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedA = new(0x0100, 0x017F, "Latin Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedB = new(0x0180, 0x024F, "Latin Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange IPAExtensions = new(0x0250, 0x02AF, "IPA Extensions");
    [MakeBasicFilter] public static NamedUnicodeRange SpacingModifierLetters = new(0x02B0, 0x02FF, "Spacing Modifier Letters");
    [MakeBasicFilter] public static NamedUnicodeRange CombiningDiacriticalMarks = new(0x0300, 0x036F, "Combining Diacritical Marks");
    [MakeBasicFilter] public static NamedUnicodeRange GreekAndCoptic = new(0x0370, 0x03FF, "Greek and Coptic");
    [MakeBasicFilter] public static NamedUnicodeRange Cyrillic = new(0x0400, 0x04FF, "Cyrillic");
    [MakeBasicFilter] public static NamedUnicodeRange CyrillicSupplement = new(0x0500, 0x052F, "Cyrillic Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Armenian = new(0x0530, 0x058F, "Armenian");
    [MakeBasicFilter] public static NamedUnicodeRange Hebrew = new(0x0590, 0x05FF, "Hebrew");
    [MakeBasicFilter] public static NamedUnicodeRange Arabic = new(0x0600, 0x06FF, "Arabic");
    [MakeBasicFilter] public static NamedUnicodeRange Syriac = new(0x0700, 0x074F, "Syriac");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicSupplement = new(0x0750, 0x077F, "Arabic Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Thaana = new(0x0780, 0x07BF, "Thaana");
    [MakeBasicFilter] public static NamedUnicodeRange NKo = new(0x07C0, 0x07FF, "NKo");
    [MakeBasicFilter] public static NamedUnicodeRange Samaritan = new(0x0800, 0x083F, "Samaritan");
    [MakeBasicFilter] public static NamedUnicodeRange Mandaic = new(0x0840, 0x085F, "Mandaic");
    [MakeBasicFilter] public static NamedUnicodeRange SyriacSupplement = new(0x0860, 0x086F, "Syriac Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicExtendedB = new(0x0870, 0x089F, "Arabic Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicExtendedA = new(0x08A0, 0x08FF, "Arabic Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange Devanagari = new(0x0900, 0x097F, "Devanagari");
    [MakeBasicFilter] public static NamedUnicodeRange Bengali = new(0x0980, 0x09FF, "Bengali");
    [MakeBasicFilter] public static NamedUnicodeRange Gurmukhi = new(0x0A00, 0x0A7F, "Gurmukhi");
    [MakeBasicFilter] public static NamedUnicodeRange Gujarati = new(0x0A80, 0x0AFF, "Gujarati");
    [MakeBasicFilter] public static NamedUnicodeRange Oriya = new(0x0B00, 0x0B7F, "Oriya");
    [MakeBasicFilter] public static NamedUnicodeRange Tamil = new(0x0B80, 0x0BFF, "Tamil");
    [MakeBasicFilter] public static NamedUnicodeRange Telugu = new(0x0C00, 0x0C7F, "Telugu");
    [MakeBasicFilter] public static NamedUnicodeRange Kannada = new(0x0C80, 0x0CFF, "Kannada");
    [MakeBasicFilter] public static NamedUnicodeRange Malayalam = new(0x0D00, 0x0D7F, "Malayalam");
    [MakeBasicFilter] public static NamedUnicodeRange Sinhala = new(0x0D80, 0x0DFF, "Sinhala");
    [MakeBasicFilter] public static NamedUnicodeRange Thai = new(0x0E00, 0x0E7F, "Thai");
    [MakeBasicFilter] public static NamedUnicodeRange Lao = new(0x0E80, 0x0EFF, "Lao");
    [MakeBasicFilter] public static NamedUnicodeRange Tibetan = new(0x0F00, 0x0FFF, "Tibetan");
    [MakeBasicFilter] public static NamedUnicodeRange Myanmar = new(0x1000, 0x109F, "Myanmar");
    [MakeBasicFilter] public static NamedUnicodeRange Georgian = new(0x10A0, 0x10FF, "Georgian");
    [MakeBasicFilter] public static NamedUnicodeRange HangulJamo = new(0x1100, 0x11FF, "Hangul Jamo");
    [MakeBasicFilter] public static NamedUnicodeRange Ethiopic = new(0x1200, 0x137F, "Ethiopic");
    [MakeBasicFilter] public static NamedUnicodeRange EthiopicSupplement = new(0x1380, 0x139F, "Ethiopic Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Cherokee = new(0x13A0, 0x13FF, "Cherokee");
    [MakeBasicFilter] public static NamedUnicodeRange UnifiedCanadianAboriginalSyllabics = new(0x1400, 0x167F, "Unified Canadian Aboriginal Syllabics");
    [MakeBasicFilter] public static NamedUnicodeRange Ogham = new(0x1680, 0x169F, "Ogham");
    [MakeBasicFilter] public static NamedUnicodeRange Runic = new(0x16A0, 0x16FF, "Runic");
    [MakeBasicFilter] public static NamedUnicodeRange Tagalog = new(0x1700, 0x171F, "Tagalog");
    [MakeBasicFilter] public static NamedUnicodeRange Hanunoo = new(0x1720, 0x173F, "Hanunoo");
    [MakeBasicFilter] public static NamedUnicodeRange Buhid = new(0x1740, 0x175F, "Buhid");
    [MakeBasicFilter] public static NamedUnicodeRange Tagbanwa = new(0x1760, 0x177F, "Tagbanwa");
    [MakeBasicFilter] public static NamedUnicodeRange Khmer = new(0x1780, 0x17FF, "Khmer");
    [MakeBasicFilter] public static NamedUnicodeRange Mongolian = new(0x1800, 0x18AF, "Mongolian");
    [MakeBasicFilter] public static NamedUnicodeRange UnifiedCanadianAboriginalSyllabicsExtended = new(0x18B0, 0x18FF, "Unified Canadian Aboriginal Syllabics Extended");
    [MakeBasicFilter] public static NamedUnicodeRange Limbu = new(0x1900, 0x194F, "Limbu");
    [MakeBasicFilter] public static NamedUnicodeRange TaiLe = new(0x1950, 0x197F, "Tai Le");
    [MakeBasicFilter] public static NamedUnicodeRange NewTaiLue = new(0x1980, 0x19DF, "New Tai Lue");
    [MakeBasicFilter] public static NamedUnicodeRange KhmerSymbols = new(0x19E0, 0x19FF, "Khmer Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange Buginese = new(0x1A00, 0x1A1F, "Buginese");
    [MakeBasicFilter] public static NamedUnicodeRange TaiTham = new(0x1A20, 0x1AAF, "Tai Tham");
    [MakeBasicFilter] public static NamedUnicodeRange CombiningDiacriticalMarksExtended = new(0x1AB0, 0x1AFF, "Combining Diacritical Marks Extended");
    [MakeBasicFilter] public static NamedUnicodeRange Balinese = new(0x1B00, 0x1B7F, "Balinese");
    [MakeBasicFilter] public static NamedUnicodeRange Sundanese = new(0x1B80, 0x1BBF, "Sundanese");
    [MakeBasicFilter] public static NamedUnicodeRange Batak = new(0x1BC0, 0x1BFF, "Batak");
    [MakeBasicFilter] public static NamedUnicodeRange Lepcha = new(0x1C00, 0x1C4F, "Lepcha");
    [MakeBasicFilter] public static NamedUnicodeRange OlChiki = new(0x1C50, 0x1C7F, "Ol Chiki");
    [MakeBasicFilter] public static NamedUnicodeRange CyrillicExtendedC = new(0x1C80, 0x1C8F, "Cyrillic Extended-C");
    [MakeBasicFilter] public static NamedUnicodeRange GeorgianExtended = new(0x1C90, 0x1CBF, "Georgian Extended");
    [MakeBasicFilter] public static NamedUnicodeRange SundaneseSupplement = new(0x1CC0, 0x1CCF, "Sundanese Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange VedicExtensions = new(0x1CD0, 0x1CFF, "Vedic Extensions");
    [MakeBasicFilter] public static NamedUnicodeRange PhoneticExtensions = new(0x1D00, 0x1D7F, "Phonetic Extensions");
    [MakeBasicFilter] public static NamedUnicodeRange PhoneticExtensionsSupplement = new(0x1D80, 0x1DBF, "Phonetic Extensions Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange CombiningDiacriticalMarksSupplement = new(0x1DC0, 0x1DFF, "Combining Diacritical Marks Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedAdditional = new(0x1E00, 0x1EFF, "Latin Extended Additional");
    [MakeBasicFilter] public static NamedUnicodeRange GreekExtended = new(0x1F00, 0x1FFF, "Greek Extended");
    [MakeBasicFilter] public static NamedUnicodeRange GeneralPunctuation = new(0x2000, 0x206F, "General Punctuation");
    [MakeBasicFilter] public static NamedUnicodeRange SuperscriptsAndSubscripts = new(0x2070, 0x209F, "Superscripts and Subscripts");
    [MakeBasicFilter] public static NamedUnicodeRange CurrencySymbols = new(0x20A0, 0x20CF, "Currency Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange CombiningDiacriticalMarksforSymbols = new(0x20D0, 0x20FF, "Combining Diacritical Marks for Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange LetterlikeSymbols = new(0x2100, 0x214F, "Letterlike Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange NumberForms = new(0x2150, 0x218F, "Number Forms");
    [MakeBasicFilter] public static NamedUnicodeRange Arrows = new(0x2190, 0x21FF, "Arrows");
    [MakeBasicFilter] public static NamedUnicodeRange MathematicalOperators = new(0x2200, 0x22FF, "Mathematical Operators");
    [MakeBasicFilter] public static NamedUnicodeRange MiscellaneousTechnical = new(0x2300, 0x23FF, "Miscellaneous Technical");
    [MakeBasicFilter] public static NamedUnicodeRange ControlPictures = new(0x2400, 0x243F, "Control Pictures");
    [MakeBasicFilter] public static NamedUnicodeRange OpticalCharacterRecognition = new(0x2440, 0x245F, "Optical Character Recognition");
    [MakeBasicFilter] public static NamedUnicodeRange EnclosedAlphanumerics = new(0x2460, 0x24FF, "Enclosed Alphanumerics");
    [MakeBasicFilter] public static NamedUnicodeRange BoxDrawing = new(0x2500, 0x257F, "Box Drawing");
    [MakeBasicFilter] public static NamedUnicodeRange BlockElements = new(0x2580, 0x259F, "Block Elements");
    [MakeBasicFilter] public static NamedUnicodeRange GeometricShapes = new(0x25A0, 0x25FF, "Geometric Shapes");
    [MakeBasicFilter] public static NamedUnicodeRange MiscellaneousSymbols = new(0x2600, 0x26FF, "Miscellaneous Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange Dingbats = new(0x2700, 0x27BF, "Dingbats");
    [MakeBasicFilter] public static NamedUnicodeRange MiscellaneousMathematicalSymbolsA = new(0x27C0, 0x27EF, "Miscellaneous Mathematical Symbols-A");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementalArrowsA = new(0x27F0, 0x27FF, "Supplemental Arrows-A");
    [MakeBasicFilter] public static NamedUnicodeRange BraillePatterns = new(0x2800, 0x28FF, "Braille Patterns");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementalArrowsB = new(0x2900, 0x297F, "Supplemental Arrows-B");
    [MakeBasicFilter] public static NamedUnicodeRange MiscellaneousMathematicalSymbolsB = new(0x2980, 0x29FF, "Miscellaneous Mathematical Symbols-B");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementalMathematicalOperators = new(0x2A00, 0x2AFF, "Supplemental Mathematical Operators");
    [MakeBasicFilter] public static NamedUnicodeRange MiscellaneousSymbolsAndArrows = new(0x2B00, 0x2BFF, "Miscellaneous Symbols and Arrows");
    [MakeBasicFilter] public static NamedUnicodeRange Glagolitic = new(0x2C00, 0x2C5F, "Glagolitic");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedC = new(0x2C60, 0x2C7F, "Latin Extended-C");
    [MakeBasicFilter] public static NamedUnicodeRange Coptic = new(0x2C80, 0x2CFF, "Coptic");
    [MakeBasicFilter] public static NamedUnicodeRange GeorgianSupplement = new(0x2D00, 0x2D2F, "Georgian Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Tifinagh = new(0x2D30, 0x2D7F, "Tifinagh");
    [MakeBasicFilter] public static NamedUnicodeRange EthiopicExtended = new(0x2D80, 0x2DDF, "Ethiopic Extended");
    [MakeBasicFilter] public static NamedUnicodeRange CyrillicExtendedA = new(0x2DE0, 0x2DFF, "Cyrillic Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementalPunctuation = new(0x2E00, 0x2E7F, "Supplemental Punctuation");
    [MakeBasicFilter] public static NamedUnicodeRange CJKRadicalsSupplement = new(0x2E80, 0x2EFF, "CJK Radicals Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange KangxiRadicals = new(0x2F00, 0x2FDF, "Kangxi Radicals");
    [MakeBasicFilter] public static NamedUnicodeRange IdeographicDescriptionCharacters = new(0x2FF0, 0x2FFF, "Ideographic Description Characters");
    [MakeBasicFilter] public static NamedUnicodeRange CJKSymbolsAndPunctuation = new(0x3000, 0x303F, "CJK Symbols and Punctuation");
    [MakeBasicFilter] public static NamedUnicodeRange Hiragana = new(0x3040, 0x309F, "Hiragana");
    [MakeBasicFilter] public static NamedUnicodeRange Katakana = new(0x30A0, 0x30FF, "Katakana");
    [MakeBasicFilter] public static NamedUnicodeRange Bopomofo = new(0x3100, 0x312F, "Bopomofo");
    [MakeBasicFilter] public static NamedUnicodeRange HangulCompatibilityJamo = new(0x3130, 0x318F, "Hangul Compatibility Jamo");
    [MakeBasicFilter] public static NamedUnicodeRange Kanbun = new(0x3190, 0x319F, "Kanbun");
    [MakeBasicFilter] public static NamedUnicodeRange BopomofoExtended = new(0x31A0, 0x31BF, "Bopomofo Extended");
    [MakeBasicFilter] public static NamedUnicodeRange CJKStrokes = new(0x31C0, 0x31EF, "CJK Strokes");
    [MakeBasicFilter] public static NamedUnicodeRange KatakanaPhoneticExtensions = new(0x31F0, 0x31FF, "Katakana Phonetic Extensions");
    [MakeBasicFilter] public static NamedUnicodeRange EnclosedCJKLettersAndMonths = new(0x3200, 0x32FF, "Enclosed CJK Letters and Months");
    [MakeBasicFilter] public static NamedUnicodeRange CJKCompatibility = new(0x3300, 0x33FF, "CJK Compatibility");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionA = new(0x3400, 0x4DBF, "CJK Unified Ideographs Extension A");
    [MakeBasicFilter] public static NamedUnicodeRange YijingHexagramSymbols = new(0x4DC0, 0x4DFF, "Yijing Hexagram Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographs = new(0x4E00, 0x9FFF, "CJK Unified Ideographs");
    [MakeBasicFilter] public static NamedUnicodeRange YiSyllables = new(0xA000, 0xA48F, "Yi Syllables");
    [MakeBasicFilter] public static NamedUnicodeRange YiRadicals = new(0xA490, 0xA4CF, "Yi Radicals");
    [MakeBasicFilter] public static NamedUnicodeRange Lisu = new(0xA4D0, 0xA4FF, "Lisu");
    [MakeBasicFilter] public static NamedUnicodeRange Vai = new(0xA500, 0xA63F, "Vai");
    [MakeBasicFilter] public static NamedUnicodeRange CyrillicExtendedB = new(0xA640, 0xA69F, "Cyrillic Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange Bamum = new(0xA6A0, 0xA6FF, "Bamum");
    [MakeBasicFilter] public static NamedUnicodeRange ModifierToneLetters = new(0xA700, 0xA71F, "Modifier Tone Letters");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedD = new(0xA720, 0xA7FF, "Latin Extended-D");
    [MakeBasicFilter] public static NamedUnicodeRange SylotiNagri = new(0xA800, 0xA82F, "Syloti Nagri");
    [MakeBasicFilter] public static NamedUnicodeRange CommonIndicNumberForms = new(0xA830, 0xA83F, "Common Indic Number Forms");
    [MakeBasicFilter] public static NamedUnicodeRange Phagspa = new(0xA840, 0xA87F, "Phags-pa");
    [MakeBasicFilter] public static NamedUnicodeRange Saurashtra = new(0xA880, 0xA8DF, "Saurashtra");
    [MakeBasicFilter] public static NamedUnicodeRange DevanagariExtended = new(0xA8E0, 0xA8FF, "Devanagari Extended");
    [MakeBasicFilter] public static NamedUnicodeRange KayahLi = new(0xA900, 0xA92F, "Kayah Li");
    [MakeBasicFilter] public static NamedUnicodeRange Rejang = new(0xA930, 0xA95F, "Rejang");
    [MakeBasicFilter] public static NamedUnicodeRange HangulJamoExtendedA = new(0xA960, 0xA97F, "Hangul Jamo Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange Javanese = new(0xA980, 0xA9DF, "Javanese");
    [MakeBasicFilter] public static NamedUnicodeRange MyanmarExtendedB = new(0xA9E0, 0xA9FF, "Myanmar Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange Cham = new(0xAA00, 0xAA5F, "Cham");
    [MakeBasicFilter] public static NamedUnicodeRange MyanmarExtendedA = new(0xAA60, 0xAA7F, "Myanmar Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange TaiViet = new(0xAA80, 0xAADF, "Tai Viet");
    [MakeBasicFilter] public static NamedUnicodeRange MeeteiMayekExtensions = new(0xAAE0, 0xAAFF, "Meetei Mayek Extensions");
    [MakeBasicFilter] public static NamedUnicodeRange EthiopicExtendedA = new(0xAB00, 0xAB2F, "Ethiopic Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedE = new(0xAB30, 0xAB6F, "Latin Extended-E");
    [MakeBasicFilter] public static NamedUnicodeRange CherokeeSupplement = new(0xAB70, 0xABBF, "Cherokee Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange MeeteiMayek = new(0xABC0, 0xABFF, "Meetei Mayek");
    [MakeBasicFilter] public static NamedUnicodeRange HangulSyllables = new(0xAC00, 0xD7AF, "Hangul Syllables");
    [MakeBasicFilter] public static NamedUnicodeRange HangulJamoExtendedB = new(0xD7B0, 0xD7FF, "Hangul Jamo Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange HighSurrogates = new(0xD800, 0xDB7F, "High Surrogates");
    [MakeBasicFilter] public static NamedUnicodeRange HighPrivateUseSurrogates = new(0xDB80, 0xDBFF, "High Private Use Surrogates");
    [MakeBasicFilter] public static NamedUnicodeRange LowSurrogates = new(0xDC00, 0xDFFF, "Low Surrogates");
    [MakeBasicFilter] public static NamedUnicodeRange PrivateUseArea = new(0xE000, 0xF8FF, "Private Use Area");
    [MakeBasicFilter] public static NamedUnicodeRange CJKCompatibilityIdeographs = new(0xF900, 0xFAFF, "CJK Compatibility Ideographs");
    [MakeBasicFilter] public static NamedUnicodeRange AlphabeticPresentationForms = new(0xFB00, 0xFB4F, "Alphabetic Presentation Forms");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicPresentationFormsA = new(0xFB50, 0xFDFF, "Arabic Presentation Forms-A");
    [MakeBasicFilter] public static NamedUnicodeRange VariationSelectors = new(0xFE00, 0xFE0F, "Variation Selectors");
    [MakeBasicFilter] public static NamedUnicodeRange VerticalForms = new(0xFE10, 0xFE1F, "Vertical Forms");
    [MakeBasicFilter] public static NamedUnicodeRange CombiningHalfMarks = new(0xFE20, 0xFE2F, "Combining Half Marks");
    [MakeBasicFilter] public static NamedUnicodeRange CJKCompatibilityForms = new(0xFE30, 0xFE4F, "CJK Compatibility Forms");
    [MakeBasicFilter] public static NamedUnicodeRange SmallFormVariants = new(0xFE50, 0xFE6F, "Small Form Variants");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicPresentationFormsB = new(0xFE70, 0xFEFF, "Arabic Presentation Forms-B");
    [MakeBasicFilter] public static NamedUnicodeRange HalfwidthAndFullwidthForms = new(0xFF00, 0xFFEF, "Halfwidth and Fullwidth Forms");
    [MakeBasicFilter] public static NamedUnicodeRange Specials = new(0xFFF0, 0xFFFF, "Specials");
    [MakeBasicFilter] public static NamedUnicodeRange LinearBSyllabary = new(0x10000, 0x1007F, "Linear B Syllabary");
    [MakeBasicFilter] public static NamedUnicodeRange LinearBIdeograms = new(0x10080, 0x100FF, "Linear B Ideograms");
    [MakeBasicFilter] public static NamedUnicodeRange AegeanNumbers = new(0x10100, 0x1013F, "Aegean Numbers");
    [MakeBasicFilter] public static NamedUnicodeRange AncientGreekNumbers = new(0x10140, 0x1018F, "Ancient Greek Numbers");
    [MakeBasicFilter] public static NamedUnicodeRange AncientSymbols = new(0x10190, 0x101CF, "Ancient Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange PhaistosDisc = new(0x101D0, 0x101FF, "Phaistos Disc");
    [MakeBasicFilter] public static NamedUnicodeRange Lycian = new(0x10280, 0x1029F, "Lycian");
    [MakeBasicFilter] public static NamedUnicodeRange Carian = new(0x102A0, 0x102DF, "Carian");
    [MakeBasicFilter] public static NamedUnicodeRange CopticEpactNumbers = new(0x102E0, 0x102FF, "Coptic Epact Numbers");
    [MakeBasicFilter] public static NamedUnicodeRange OldItalic = new(0x10300, 0x1032F, "Old Italic");
    [MakeBasicFilter] public static NamedUnicodeRange Gothic = new(0x10330, 0x1034F, "Gothic");
    [MakeBasicFilter] public static NamedUnicodeRange OldPermic = new(0x10350, 0x1037F, "Old Permic");
    [MakeBasicFilter] public static NamedUnicodeRange Ugaritic = new(0x10380, 0x1039F, "Ugaritic");
    [MakeBasicFilter] public static NamedUnicodeRange OldPersian = new(0x103A0, 0x103DF, "Old Persian");
    [MakeBasicFilter] public static NamedUnicodeRange Deseret = new(0x10400, 0x1044F, "Deseret");
    [MakeBasicFilter] public static NamedUnicodeRange Shavian = new(0x10450, 0x1047F, "Shavian");
    [MakeBasicFilter] public static NamedUnicodeRange Osmanya = new(0x10480, 0x104AF, "Osmanya");
    [MakeBasicFilter] public static NamedUnicodeRange Osage = new(0x104B0, 0x104FF, "Osage");
    [MakeBasicFilter] public static NamedUnicodeRange Elbasan = new(0x10500, 0x1052F, "Elbasan");
    [MakeBasicFilter] public static NamedUnicodeRange CaucasianAlbanian = new(0x10530, 0x1056F, "Caucasian Albanian");
    [MakeBasicFilter] public static NamedUnicodeRange Vithkuqi = new(0x10570, 0x105BF, "Vithkuqi");
    [MakeBasicFilter] public static NamedUnicodeRange LinearA = new(0x10600, 0x1077F, "Linear A");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedF = new(0x10780, 0x107BF, "Latin Extended-F");
    [MakeBasicFilter] public static NamedUnicodeRange CypriotSyllabary = new(0x10800, 0x1083F, "Cypriot Syllabary");
    [MakeBasicFilter] public static NamedUnicodeRange ImperialAramaic = new(0x10840, 0x1085F, "Imperial Aramaic");
    [MakeBasicFilter] public static NamedUnicodeRange Palmyrene = new(0x10860, 0x1087F, "Palmyrene");
    [MakeBasicFilter] public static NamedUnicodeRange Nabataean = new(0x10880, 0x108AF, "Nabataean");
    [MakeBasicFilter] public static NamedUnicodeRange Hatran = new(0x108E0, 0x108FF, "Hatran");
    [MakeBasicFilter] public static NamedUnicodeRange Phoenician = new(0x10900, 0x1091F, "Phoenician");
    [MakeBasicFilter] public static NamedUnicodeRange Lydian = new(0x10920, 0x1093F, "Lydian");
    [MakeBasicFilter] public static NamedUnicodeRange MeroiticHieroglyphs = new(0x10980, 0x1099F, "Meroitic Hieroglyphs");
    [MakeBasicFilter] public static NamedUnicodeRange MeroiticCursive = new(0x109A0, 0x109FF, "Meroitic Cursive");
    [MakeBasicFilter] public static NamedUnicodeRange Kharoshthi = new(0x10A00, 0x10A5F, "Kharoshthi");
    [MakeBasicFilter] public static NamedUnicodeRange OldSouthArabian = new(0x10A60, 0x10A7F, "Old South Arabian");
    [MakeBasicFilter] public static NamedUnicodeRange OldNorthArabian = new(0x10A80, 0x10A9F, "Old North Arabian");
    [MakeBasicFilter] public static NamedUnicodeRange Manichaean = new(0x10AC0, 0x10AFF, "Manichaean");
    [MakeBasicFilter] public static NamedUnicodeRange Avestan = new(0x10B00, 0x10B3F, "Avestan");
    [MakeBasicFilter] public static NamedUnicodeRange InscriptionalParthian = new(0x10B40, 0x10B5F, "Inscriptional Parthian");
    [MakeBasicFilter] public static NamedUnicodeRange InscriptionalPahlavi = new(0x10B60, 0x10B7F, "Inscriptional Pahlavi");
    [MakeBasicFilter] public static NamedUnicodeRange PsalterPahlavi = new(0x10B80, 0x10BAF, "Psalter Pahlavi");
    [MakeBasicFilter] public static NamedUnicodeRange OldTurkic = new(0x10C00, 0x10C4F, "Old Turkic");
    [MakeBasicFilter] public static NamedUnicodeRange OldHungarian = new(0x10C80, 0x10CFF, "Old Hungarian");
    [MakeBasicFilter] public static NamedUnicodeRange HanifiRohingya = new(0x10D00, 0x10D3F, "Hanifi Rohingya");
    [MakeBasicFilter] public static NamedUnicodeRange RumiNumeralSymbols = new(0x10E60, 0x10E7F, "Rumi Numeral Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange Yezidi = new(0x10E80, 0x10EBF, "Yezidi");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicExtendedC = new(0x10EC0, 0x10EFF, "Arabic Extended-C");
    [MakeBasicFilter] public static NamedUnicodeRange OldSogdian = new(0x10F00, 0x10F2F, "Old Sogdian");
    [MakeBasicFilter] public static NamedUnicodeRange Sogdian = new(0x10F30, 0x10F6F, "Sogdian");
    [MakeBasicFilter] public static NamedUnicodeRange OldUyghur = new(0x10F70, 0x10FAF, "Old Uyghur");
    [MakeBasicFilter] public static NamedUnicodeRange Chorasmian = new(0x10FB0, 0x10FDF, "Chorasmian");
    [MakeBasicFilter] public static NamedUnicodeRange Elymaic = new(0x10FE0, 0x10FFF, "Elymaic");
    [MakeBasicFilter] public static NamedUnicodeRange Brahmi = new(0x11000, 0x1107F, "Brahmi");
    [MakeBasicFilter] public static NamedUnicodeRange Kaithi = new(0x11080, 0x110CF, "Kaithi");
    [MakeBasicFilter] public static NamedUnicodeRange SoraSompeng = new(0x110D0, 0x110FF, "Sora Sompeng");
    [MakeBasicFilter] public static NamedUnicodeRange Chakma = new(0x11100, 0x1114F, "Chakma");
    [MakeBasicFilter] public static NamedUnicodeRange Mahajani = new(0x11150, 0x1117F, "Mahajani");
    [MakeBasicFilter] public static NamedUnicodeRange Sharada = new(0x11180, 0x111DF, "Sharada");
    [MakeBasicFilter] public static NamedUnicodeRange SinhalaArchaicNumbers = new(0x111E0, 0x111FF, "Sinhala Archaic Numbers");
    [MakeBasicFilter] public static NamedUnicodeRange Khojki = new(0x11200, 0x1124F, "Khojki");
    [MakeBasicFilter] public static NamedUnicodeRange Multani = new(0x11280, 0x112AF, "Multani");
    [MakeBasicFilter] public static NamedUnicodeRange Khudawadi = new(0x112B0, 0x112FF, "Khudawadi");
    [MakeBasicFilter] public static NamedUnicodeRange Grantha = new(0x11300, 0x1137F, "Grantha");
    [MakeBasicFilter] public static NamedUnicodeRange Newa = new(0x11400, 0x1147F, "Newa");
    [MakeBasicFilter] public static NamedUnicodeRange Tirhuta = new(0x11480, 0x114DF, "Tirhuta");
    [MakeBasicFilter] public static NamedUnicodeRange Siddham = new(0x11580, 0x115FF, "Siddham");
    [MakeBasicFilter] public static NamedUnicodeRange Modi = new(0x11600, 0x1165F, "Modi");
    [MakeBasicFilter] public static NamedUnicodeRange MongolianSupplement = new(0x11660, 0x1167F, "Mongolian Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Takri = new(0x11680, 0x116CF, "Takri");
    [MakeBasicFilter] public static NamedUnicodeRange Ahom = new(0x11700, 0x1174F, "Ahom");
    [MakeBasicFilter] public static NamedUnicodeRange Dogra = new(0x11800, 0x1184F, "Dogra");
    [MakeBasicFilter] public static NamedUnicodeRange WarangCiti = new(0x118A0, 0x118FF, "Warang Citi");
    [MakeBasicFilter] public static NamedUnicodeRange DivesAkuru = new(0x11900, 0x1195F, "Dives Akuru");
    [MakeBasicFilter] public static NamedUnicodeRange Nandinagari = new(0x119A0, 0x119FF, "Nandinagari");
    [MakeBasicFilter] public static NamedUnicodeRange ZanabazarSquare = new(0x11A00, 0x11A4F, "Zanabazar Square");
    [MakeBasicFilter] public static NamedUnicodeRange Soyombo = new(0x11A50, 0x11AAF, "Soyombo");
    [MakeBasicFilter] public static NamedUnicodeRange UnifiedCanadianAboriginalSyllabicsExtendedA = new(0x11AB0, 0x11ABF, "Unified Canadian Aboriginal Syllabics Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange PauCinHau = new(0x11AC0, 0x11AFF, "Pau Cin Hau");
    [MakeBasicFilter] public static NamedUnicodeRange DevanagariExtendedA = new(0x11B00, 0x11B5F, "Devanagari Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange Bhaiksuki = new(0x11C00, 0x11C6F, "Bhaiksuki");
    [MakeBasicFilter] public static NamedUnicodeRange Marchen = new(0x11C70, 0x11CBF, "Marchen");
    [MakeBasicFilter] public static NamedUnicodeRange MasaramGondi = new(0x11D00, 0x11D5F, "Masaram Gondi");
    [MakeBasicFilter] public static NamedUnicodeRange GunjalaGondi = new(0x11D60, 0x11DAF, "Gunjala Gondi");
    [MakeBasicFilter] public static NamedUnicodeRange Makasar = new(0x11EE0, 0x11EFF, "Makasar");
    [MakeBasicFilter] public static NamedUnicodeRange Kawi = new(0x11F00, 0x11F5F, "Kawi");
    [MakeBasicFilter] public static NamedUnicodeRange LisuSupplement = new(0x11FB0, 0x11FBF, "Lisu Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange TamilSupplement = new(0x11FC0, 0x11FFF, "Tamil Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Cuneiform = new(0x12000, 0x123FF, "Cuneiform");
    [MakeBasicFilter] public static NamedUnicodeRange CuneiformNumbersAndPunctuation = new(0x12400, 0x1247F, "Cuneiform Numbers and Punctuation");
    [MakeBasicFilter] public static NamedUnicodeRange EarlyDynasticCuneiform = new(0x12480, 0x1254F, "Early Dynastic Cuneiform");
    [MakeBasicFilter] public static NamedUnicodeRange CyproMinoan = new(0x12F90, 0x12FFF, "Cypro-Minoan");
    [MakeBasicFilter] public static NamedUnicodeRange EgyptianHieroglyphs = new(0x13000, 0x1342F, "Egyptian Hieroglyphs");
    [MakeBasicFilter] public static NamedUnicodeRange EgyptianHieroglyphFormatControls = new(0x13430, 0x1345F, "Egyptian Hieroglyph Format Controls");
    [MakeBasicFilter] public static NamedUnicodeRange AnatolianHieroglyphs = new(0x14400, 0x1467F, "Anatolian Hieroglyphs");
    [MakeBasicFilter] public static NamedUnicodeRange BamumSupplement = new(0x16800, 0x16A3F, "Bamum Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange Mro = new(0x16A40, 0x16A6F, "Mro");
    [MakeBasicFilter] public static NamedUnicodeRange Tangsa = new(0x16A70, 0x16ACF, "Tangsa");
    [MakeBasicFilter] public static NamedUnicodeRange BassaVah = new(0x16AD0, 0x16AFF, "Bassa Vah");
    [MakeBasicFilter] public static NamedUnicodeRange PahawhHmong = new(0x16B00, 0x16B8F, "Pahawh Hmong");
    [MakeBasicFilter] public static NamedUnicodeRange Medefaidrin = new(0x16E40, 0x16E9F, "Medefaidrin");
    [MakeBasicFilter] public static NamedUnicodeRange Miao = new(0x16F00, 0x16F9F, "Miao");
    [MakeBasicFilter] public static NamedUnicodeRange IdeographicSymbolsAndPunctuation = new(0x16FE0, 0x16FFF, "Ideographic Symbols and Punctuation");
    [MakeBasicFilter] public static NamedUnicodeRange Tangut = new(0x17000, 0x187FF, "Tangut");
    [MakeBasicFilter] public static NamedUnicodeRange TangutComponents = new(0x18800, 0x18AFF, "Tangut Components");
    [MakeBasicFilter] public static NamedUnicodeRange KhitanSmallScript = new(0x18B00, 0x18CFF, "Khitan Small Script");
    [MakeBasicFilter] public static NamedUnicodeRange TangutSupplement = new(0x18D00, 0x18D7F, "Tangut Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange KanaExtendedB = new(0x1AFF0, 0x1AFFF, "Kana Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange KanaSupplement = new(0x1B000, 0x1B0FF, "Kana Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange KanaExtendedA = new(0x1B100, 0x1B12F, "Kana Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange SmallKanaExtension = new(0x1B130, 0x1B16F, "Small Kana Extension");
    [MakeBasicFilter] public static NamedUnicodeRange Nushu = new(0x1B170, 0x1B2FF, "Nushu");
    [MakeBasicFilter] public static NamedUnicodeRange Duployan = new(0x1BC00, 0x1BC9F, "Duployan");
    [MakeBasicFilter] public static NamedUnicodeRange ShorthAndFormatControls = new(0x1BCA0, 0x1BCAF, "Shorthand Format Controls");
    [MakeBasicFilter] public static NamedUnicodeRange ZnamennyMusicalNotation = new(0x1CF00, 0x1CFCF, "Znamenny Musical Notation");
    [MakeBasicFilter] public static NamedUnicodeRange ByzantineMusicalSymbols = new(0x1D000, 0x1D0FF, "Byzantine Musical Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange MusicalSymbols = new(0x1D100, 0x1D1FF, "Musical Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange AncientGreekMusicalNotation = new(0x1D200, 0x1D24F, "Ancient Greek Musical Notation");
    [MakeBasicFilter] public static NamedUnicodeRange KaktovikNumerals = new(0x1D2C0, 0x1D2DF, "Kaktovik Numerals");
    [MakeBasicFilter] public static NamedUnicodeRange MayanNumerals = new(0x1D2E0, 0x1D2FF, "Mayan Numerals");
    [MakeBasicFilter] public static NamedUnicodeRange TaiXuanJingSymbols = new(0x1D300, 0x1D35F, "Tai Xuan Jing Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange CountingRodNumerals = new(0x1D360, 0x1D37F, "Counting Rod Numerals");
    [MakeBasicFilter] public static NamedUnicodeRange MathematicalAlphanumericSymbols = new(0x1D400, 0x1D7FF, "Mathematical Alphanumeric Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange SuttonSignWriting = new(0x1D800, 0x1DAAF, "Sutton SignWriting");
    [MakeBasicFilter] public static NamedUnicodeRange LatinExtendedG = new(0x1DF00, 0x1DFFF, "Latin Extended-G");
    [MakeBasicFilter] public static NamedUnicodeRange GlagoliticSupplement = new(0x1E000, 0x1E02F, "Glagolitic Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange CyrillicExtendedD = new(0x1E030, 0x1E08F, "Cyrillic Extended-D");
    [MakeBasicFilter] public static NamedUnicodeRange NyiakengPuachueHmong = new(0x1E100, 0x1E14F, "Nyiakeng Puachue Hmong");
    [MakeBasicFilter] public static NamedUnicodeRange Toto = new(0x1E290, 0x1E2BF, "Toto");
    [MakeBasicFilter] public static NamedUnicodeRange Wancho = new(0x1E2C0, 0x1E2FF, "Wancho");
    [MakeBasicFilter] public static NamedUnicodeRange NagMundari = new(0x1E4D0, 0x1E4FF, "Nag Mundari");
    [MakeBasicFilter] public static NamedUnicodeRange EthiopicExtendedB = new(0x1E7E0, 0x1E7FF, "Ethiopic Extended-B");
    [MakeBasicFilter] public static NamedUnicodeRange MendeKikakui = new(0x1E800, 0x1E8DF, "Mende Kikakui");
    [MakeBasicFilter] public static NamedUnicodeRange Adlam = new(0x1E900, 0x1E95F, "Adlam");
    [MakeBasicFilter] public static NamedUnicodeRange IndicSiyaqNumbers = new(0x1EC70, 0x1ECBF, "Indic Siyaq Numbers");
    [MakeBasicFilter] public static NamedUnicodeRange OttomanSiyaqNumbers = new(0x1ED00, 0x1ED4F, "Ottoman Siyaq Numbers");
    [MakeBasicFilter] public static NamedUnicodeRange ArabicMathematicalAlphabeticSymbols = new(0x1EE00, 0x1EEFF, "Arabic Mathematical Alphabetic Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange MahjongTiles = new(0x1F000, 0x1F02F, "Mahjong Tiles");
    [MakeBasicFilter] public static NamedUnicodeRange DominoTiles = new(0x1F030, 0x1F09F, "Domino Tiles");
    [MakeBasicFilter] public static NamedUnicodeRange PlayingCards = new(0x1F0A0, 0x1F0FF, "Playing Cards");
    [MakeBasicFilter] public static NamedUnicodeRange EnclosedAlphanumericSupplement = new(0x1F100, 0x1F1FF, "Enclosed Alphanumeric Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange EnclosedIdeographicSupplement = new(0x1F200, 0x1F2FF, "Enclosed Ideographic Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange MiscellaneousSymbolsAndPictographs = new(0x1F300, 0x1F5FF, "Miscellaneous Symbols and Pictographs");
    [MakeBasicFilter] public static NamedUnicodeRange Emoticons = new(0x1F600, 0x1F64F, "Emoticons");
    [MakeBasicFilter] public static NamedUnicodeRange OrnamentalDingbats = new(0x1F650, 0x1F67F, "Ornamental Dingbats");
    [MakeBasicFilter] public static NamedUnicodeRange TransportAndMapSymbols = new(0x1F680, 0x1F6FF, "Transport and Map Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange AlchemicalSymbols = new(0x1F700, 0x1F77F, "Alchemical Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange GeometricShapesExtended = new(0x1F780, 0x1F7FF, "Geometric Shapes Extended");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementalArrowsC = new(0x1F800, 0x1F8FF, "Supplemental Arrows-C");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementalSymbolsAndPictographs = new(0x1F900, 0x1F9FF, "Supplemental Symbols and Pictographs");
    [MakeBasicFilter] public static NamedUnicodeRange ChessSymbols = new(0x1FA00, 0x1FA6F, "Chess Symbols");
    [MakeBasicFilter] public static NamedUnicodeRange SymbolsAndPictographsExtendedA = new(0x1FA70, 0x1FAFF, "Symbols and Pictographs Extended-A");
    [MakeBasicFilter] public static NamedUnicodeRange SymbolsforLegacyComputing = new(0x1FB00, 0x1FBFF, "Symbols for Legacy Computing");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionB = new(0x20000, 0x2A6DF, "CJK Unified Ideographs Extension B");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionC = new(0x2A700, 0x2B73F, "CJK Unified Ideographs Extension C");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionD = new(0x2B740, 0x2B81F, "CJK Unified Ideographs Extension D");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionE = new(0x2B820, 0x2CEAF, "CJK Unified Ideographs Extension E");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionF = new(0x2CEB0, 0x2EBEF, "CJK Unified Ideographs Extension F");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionI = new(0x2EBF0, 0x2EE5F, "CJK Unified Ideographs Extension I");
    [MakeBasicFilter] public static NamedUnicodeRange CJKCompatibilityIdeographsSupplement = new(0x2F800, 0x2FA1F, "CJK Compatibility Ideographs Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionG = new(0x30000, 0x3134F, "CJK Unified Ideographs Extension G");
    [MakeBasicFilter] public static NamedUnicodeRange CJKUnifiedIdeographsExtensionH = new(0x31350, 0x323AF, "CJK Unified Ideographs Extension H");
    [MakeBasicFilter] public static NamedUnicodeRange Tags = new(0xE0000, 0xE007F, "Tags");
    [MakeBasicFilter] public static NamedUnicodeRange VariationSelectorsSupplement = new(0xE0100, 0xE01EF, "Variation Selectors Supplement");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementaryPrivateUseAreaA = new(0xF0000, 0xFFFFF, "Supplementary Private Use Area-A");
    [MakeBasicFilter] public static NamedUnicodeRange SupplementaryPrivateUseAreaB = new(0x100000, 0x10FFFF, "Supplementary Private Use Area-B");

    /* Manually added */
    [MakeBasicFilter] public static NamedUnicodeRange Unassigned = new("Unassigned", 0x110000, 200000);

    /* These are special cases for MDL2 and are not included in All */
    public static NamedUnicodeRange MDL2Deprecated = new("Deprecated", 0xE000, 0xE5FF - 0xE000 + 1);
    public static NamedUnicodeRange PrivateUseAreaMDL2 = new("Private Use Area", 58880, 4864);
}
