// This file is part of the Chaos Compiler Collection.
// SPDX-License-Identifier: MIT

#pragma once

namespace ccc::mips {

enum OpCode {
	OPCODE_SPECIAL  = 0b000000,
	OPCODE_REGIMM   = 0b000001,
	OPCODE_J        = 0b000010,
	OPCODE_JAL      = 0b000011,
	OPCODE_BEQ      = 0b000100,
	OPCODE_BNE      = 0b000101,
	OPCODE_BLEZ     = 0b000110,
	OPCODE_BGTZ     = 0b000111,
	OPCODE_ADDI     = 0b001000,
	OPCODE_ADDIU    = 0b001001,
	OPCODE_SLTI     = 0b001010,
	OPCODE_SLTIU    = 0b001011,
	OPCODE_ANDI     = 0b001100,
	OPCODE_ORI      = 0b001101,
	OPCODE_XORI     = 0b001110,
	OPCODE_LUI      = 0b001111,
	OPCODE_COP0     = 0b010000,
	OPCODE_COP1     = 0b010001,
	OPCODE_COP2     = 0b010010,
	OPCODE_RESVD_19 = 0b010011,
	OPCODE_BEQL     = 0b010100,
	OPCODE_BNEL     = 0b010101,
	OPCODE_BLEZL    = 0b010110,
	OPCODE_BGTZL    = 0b010111,
	OPCODE_DADDI    = 0b011000,
	OPCODE_DADDIU   = 0b011001,
	OPCODE_LDL      = 0b011010,
	OPCODE_LDR      = 0b011011,
	OPCODE_MMI      = 0b011100,
	OPCODE_RESVD_29 = 0b011101,
	OPCODE_LQ       = 0b011110,
	OPCODE_SQ       = 0b011111,
	OPCODE_LB       = 0b100000,
	OPCODE_LH       = 0b100001,
	OPCODE_LWL      = 0b100010,
	OPCODE_LW       = 0b100011,
	OPCODE_LBU      = 0b100100,
	OPCODE_LHU      = 0b100101,
	OPCODE_LWR      = 0b100110,
	OPCODE_LWU      = 0b100111,
	OPCODE_SB       = 0b101000,
	OPCODE_SH       = 0b101001,
	OPCODE_SWL      = 0b101010,
	OPCODE_SW       = 0b101011,
	OPCODE_SDL      = 0b101100,
	OPCODE_SDR      = 0b101101,
	OPCODE_SWR      = 0b101110,
	OPCODE_CACHE    = 0b101111,
	OPCODE_UNSUP_48 = 0b110000,
	OPCODE_LWC1     = 0b110001,
	OPCODE_UNSUP_50 = 0b110010,
	OPCODE_PREF     = 0b110011,
	OPCODE_UNSUP_52 = 0b110100,
	OPCODE_UNSUP_53 = 0b110101,
	OPCODE_LQC2     = 0b110110,
	OPCODE_LD       = 0b110111,
	OPCODE_UNSUP_56 = 0b111000,
	OPCODE_SWC1     = 0b111001,
	OPCODE_UNSUP_58 = 0b111010,
	OPCODE_RESVD_59 = 0b111011,
	OPCODE_UNSUP_60 = 0b111100,
	OPCODE_UNSUP_61 = 0b111101,
	OPCODE_SQC2     = 0b111110,
	OPCODE_SD       = 0b111111,
	MAX_OPCODE      = 64
};

enum Special {
	SPECIAL_SLL      = 0b000000,
	SPECIAL_RESVD_1  = 0b000001,
	SPECIAL_SRL      = 0b000010,
	SPECIAL_SRA      = 0b000011,
	SPECIAL_SLLV     = 0b000100,
	SPECIAL_RESVD_5  = 0b000101,
	SPECIAL_SRLV     = 0b000110,
	SPECIAL_SRAV     = 0b000111,
	SPECIAL_JR       = 0b001000,
	SPECIAL_JALR     = 0b001001,
	SPECIAL_MOVZ     = 0b001010,
	SPECIAL_MOVN     = 0b001011,
	SPECIAL_SYSCALL  = 0b001100,
	SPECIAL_BREAK    = 0b001101,
	SPECIAL_RESVD_14 = 0b001110,
	SPECIAL_SYNC     = 0b001111,
	SPECIAL_MFHI     = 0b010000,
	SPECIAL_MTHI     = 0b010001,
	SPECIAL_MFLO     = 0b010010,
	SPECIAL_MTLO     = 0b010011,
	SPECIAL_DSLLV    = 0b010100,
	SPECIAL_RESVD_   = 0b010101,
	SPECIAL_DSRLV    = 0b010110,
	SPECIAL_DSRAV    = 0b010111,
	SPECIAL_MULT     = 0b011000,
	SPECIAL_MULTU    = 0b011001,
	SPECIAL_DIV      = 0b011010,
	SPECIAL_DIVU     = 0b011011,
	SPECIAL_UNSUP_   = 0b011100,
	SPECIAL_UNSUP_29 = 0b011101,
	SPECIAL_UNSUP_30 = 0b011110,
	SPECIAL_UNSUP_31 = 0b011111,
	SPECIAL_ADD      = 0b100000,
	SPECIAL_ADDU     = 0b100001,
	SPECIAL_SUB      = 0b100010,
	SPECIAL_SUBU     = 0b100011,
	SPECIAL_AND      = 0b100100,
	SPECIAL_OR       = 0b100101,
	SPECIAL_XOR      = 0b100110,
	SPECIAL_NOR      = 0b100111,
	SPECIAL_MFSA     = 0b101000,
	SPECIAL_MTSA     = 0b101001,
	SPECIAL_SLT      = 0b101010,
	SPECIAL_SLTU     = 0b101011,
	SPECIAL_DADD     = 0b101100,
	SPECIAL_DADDU    = 0b101101,
	SPECIAL_DSUB     = 0b101110,
	SPECIAL_DSUBU    = 0b101111,
	SPECIAL_TGE      = 0b110000,
	SPECIAL_TGEU     = 0b110001,
	SPECIAL_TLT      = 0b110010,
	SPECIAL_TLTU     = 0b110011,
	SPECIAL_TEQ      = 0b110100,
	SPECIAL_RESVD_53 = 0b110101,
	SPECIAL_TNE      = 0b110110,
	SPECIAL_RESVD_55 = 0b110111,
	SPECIAL_DSLL     = 0b111000,
	SPECIAL_RESVD    = 0b111001,
	SPECIAL_DSRL     = 0b111010,
	SPECIAL_DSRA     = 0b111011,
	SPECIAL_DSLL32   = 0b111100,
	SPECIAL_RESVD_61 = 0b111101,
	SPECIAL_DSRL32   = 0b111110,
	SPECIAL_DSRA32   = 0b111111,
	MAX_SPECIAL      = 64
};

enum RegImm {
	REGIMM_BLTZ     = 0b00000,
	REGIMM_BGEZ     = 0b00001,
	REGIMM_BLTZL    = 0b00010,
	REGIMM_BGEZL    = 0b00011,
	REGIMM_RESVD_4  = 0b00100,
	REGIMM_RESVD_5  = 0b00101,
	REGIMM_RESVD_6  = 0b00110,
	REGIMM_RESVD_7  = 0b00111,
	REGIMM_TGEI     = 0b01000,
	REGIMM_TGEIU    = 0b01001,
	REGIMM_TLTI     = 0b01010,
	REGIMM_TLTIU    = 0b01011,
	REGIMM_TEQI     = 0b01100,
	REGIMM_RESVD_13 = 0b01101,
	REGIMM_TNEI     = 0b01110,
	REGIMM_RESVD_15 = 0b01111,
	REGIMM_BLTZAL   = 0b10000,
	REGIMM_BGEZAL   = 0b10001,
	REGIMM_BLTZALL  = 0b10010,
	REGIMM_BGEZALL  = 0b10011,
	REGIMM_RESVD_20 = 0b10100,
	REGIMM_RESVD_21 = 0b10101,
	REGIMM_RESVD_22 = 0b10110,
	REGIMM_RESVD_23 = 0b10111,
	REGIMM_MTSAB    = 0b11000,
	REGIMM_MTSAH    = 0b11001,
	REGIMM_RESVD_26 = 0b11010,
	REGIMM_RESVD_27 = 0b11011,
	REGIMM_RESVD_28 = 0b11100,
	REGIMM_RESVD_29 = 0b11101,
	REGIMM_RESVD_30 = 0b11110,
	REGIMM_RESVD_31 = 0b11111,
	MAX_REGIMM      = 32
};

enum MMI {
	MMI_MADD     = 0b000000,
	MMI_MADDU    = 0b000001,
	MMI_RESVD_2  = 0b000010,
	MMI_RESVD_3  = 0b000011,
	MMI_PLZCW    = 0b000100,
	MMI_RESVD_5  = 0b000101,
	MMI_RESVD_6  = 0b000110,
	MMI_RESVD_7  = 0b000111,
	MMI_MMI0    = 0b001000,
	MMI_MMI2     = 0b001001,
	MMI_RESVD_10 = 0b001010,
	MMI_RESVD_11 = 0b001011,
	MMI_RESVD_12 = 0b001100,
	MMI_RESVD_13 = 0b001101,
	MMI_RESVD_14 = 0b001110,
	MMI_RESVD_15 = 0b001111,
	MMI_MFHI1    = 0b010000,
	MMI_MTHI1    = 0b010001,
	MMI_MFLO1    = 0b010010,
	MMI_MTLO1    = 0b010011,
	MMI_RESVD_20 = 0b010100,
	MMI_RESVD_21 = 0b010101,
	MMI_RESVD_22 = 0b010110,
	MMI_RESVD_23 = 0b010111,
	MMI_MULT1    = 0b011000,
	MMI_MULTU1   = 0b011001,
	MMI_DIV1     = 0b011010,
	MMI_DIVU1    = 0b011011,
	MMI_RESVD_28 = 0b011100,
	MMI_RESVD_29 = 0b011101,
	MMI_RESVD_30 = 0b011110,
	MMI_RESVD_31 = 0b011111,
	MMI_MADD1    = 0b100000,
	MMI_MADDU1   = 0b100001,
	MMI_RESVD_34 = 0b100010,
	MMI_RESVD_35 = 0b100011,
	MMI_RESVD_36 = 0b100100,
	MMI_RESVD_37 = 0b100101,
	MMI_RESVD_38 = 0b100110,
	MMI_RESVD_39 = 0b100111,
	MMI_MMI1     = 0b101000,
	MMI_MMI3     = 0b101001,
	MMI_RESVD_42 = 0b101010,
	MMI_RESVD_43 = 0b101011,
	MMI_RESVD_44 = 0b101100,
	MMI_RESVD_45 = 0b101101,
	MMI_RESVD_46 = 0b101110,
	MMI_RESVD_47 = 0b101111,
	MMI_PMFHL    = 0b110000,
	MMI_PMTHL    = 0b110001,
	MMI_RESVD_50 = 0b110010,
	MMI_RESVD_51 = 0b110011,
	MMI_PSLLH    = 0b110100,
	MMI_RESVD_53 = 0b110101,
	MMI_PSRLH    = 0b110110,
	MMI_PSRAH    = 0b110111,
	MMI_RESVD_56 = 0b111000,
	MMI_RESVD_57 = 0b111001,
	MMI_RESVD_58 = 0b111010,
	MMI_RESVD_59 = 0b111011,
	MMI_PSLLW    = 0b111100,
	MMI_RESVD_61 = 0b111101,
	MMI_PSRLW    = 0b111110,
	MMI_PSRAW    = 0b111111,
	MAX_MMI      = 64
};

enum MMI0 {
	MMI0_PADDW    = 0b00000,
	MMI0_PSUBW    = 0b00001,
	MMI0_PCGTW    = 0b00010,
	MMI0_PMAXW    = 0b00011,
	MMI0_PADDH    = 0b00100,
	MMI0_PSUBH    = 0b00101,
	MMI0_PCGTH    = 0b00110,
	MMI0_PMAXH    = 0b00111,
	MMI0_PADDB    = 0b01000,
	MMI0_PSUBB    = 0b01001,
	MMI0_PCGTB    = 0b01010,
	MMI0_RESVD_11 = 0b01011,
	MMI0_RESVD_12 = 0b01100,
	MMI0_RESVD_13 = 0b01101,
	MMI0_RESVD_14 = 0b01110,
	MMI0_RESVD_15 = 0b01111,
	MMI0_PADDSW   = 0b10000,
	MMI0_PSUBSW   = 0b10001,
	MMI0_PEXTLW   = 0b10010,
	MMI0_PPACW    = 0b10011,
	MMI0_PADDSH   = 0b10100,
	MMI0_PSUBSH   = 0b10101,
	MMI0_PEXTLH   = 0b10110,
	MMI0_PPACH    = 0b10111,
	MMI0_PADDSB   = 0b11000,
	MMI0_PSUBSB   = 0b11001,
	MMI0_PEXTLB   = 0b11010,
	MMI0_PPACB    = 0b11011,
	MMI0_RESVD_28 = 0b11100,
	MMI0_RESVD_29 = 0b11101,
	MMI0_PEXT5    = 0b11110,
	MMI0_PPAC5    = 0b11111,
	MAX_MMI0      = 32
};

enum MMI1 {
	MMI1_RESVD_0  = 0b00000,
	MMI1_PABSW    = 0b00001,
	MMI1_PCEQW    = 0b00010,
	MMI1_PMINW    = 0b00011,
	MMI1_PADSBH   = 0b00100,
	MMI1_PABSH    = 0b00101,
	MMI1_PCEQH    = 0b00110,
	MMI1_PMINH    = 0b00111,
	MMI1_RESVD_8  = 0b01000,
	MMI1_RESVD_9  = 0b01001,
	MMI1_PCEQB    = 0b01010,
	MMI1_RESVD_11 = 0b01011,
	MMI1_RESVD_12 = 0b01100,
	MMI1_RESVD_13 = 0b01101,
	MMI1_RESVD_14 = 0b01110,
	MMI1_RESVD_15 = 0b01111,
	MMI1_PADDUW   = 0b10000,
	MMI1_PSUBUW   = 0b10001,
	MMI1_PEXTUW   = 0b10010,
	MMI1_RESVD_19 = 0b10011,
	MMI1_PADDUH   = 0b10100,
	MMI1_PSUBUH   = 0b10101,
	MMI1_PEXTUH   = 0b10110,
	MMI1_RESVD_23 = 0b10111,
	MMI1_PADDUB   = 0b11000,
	MMI1_PSUBUB   = 0b11001,
	MMI1_PEXTUB   = 0b11010,
	MMI1_QFSRV    = 0b11011,
	MMI1_RESVD_28 = 0b11100,
	MMI1_RESVD_29 = 0b11101,
	MMI1_RESVD_30 = 0b11110,
	MMI1_RESVD_31 = 0b11111,
	MAX_MMI1      = 32
};

enum MMI2 {
	MMI2_PMADDW   = 0b00000,
	MMI2_RESVD_1  = 0b00001,
	MMI2_PSLLVW   = 0b00010,
	MMI2_PSRLVW   = 0b00011,
	MMI2_PMSUBW   = 0b00100,
	MMI2_RESVD_5  = 0b00101,
	MMI2_RESVD_6  = 0b00110,
	MMI2_RESVD_7  = 0b00111,
	MMI2_PMFHI    = 0b01000,
	MMI2_PMFLO    = 0b01001,
	MMI2_PINTH    = 0b01010,
	MMI2_RESVD_11 = 0b01011,
	MMI2_PMULTW   = 0b01100,
	MMI2_PDIVW    = 0b01101,
	MMI2_PCPYLD   = 0b01110,
	MMI2_RESVD_15 = 0b01111,
	MMI2_PMADDH   = 0b10000,
	MMI2_PHMADH   = 0b10001,
	MMI2_PAND     = 0b10010,
	MMI2_PXOR     = 0b10011,
	MMI2_PMSUBH   = 0b10100,
	MMI2_PHMSBH   = 0b10101,
	MMI2_RESVD_22 = 0b10110,
	MMI2_RESVD_23 = 0b10111,
	MMI2_RESVD_24 = 0b11000,
	MMI2_RESVD_25 = 0b11001,
	MMI2_PEXEH    = 0b11010,
	MMI2_PREVH    = 0b11011,
	MMI2_PMULTH   = 0b11100,
	MMI2_PDIVBW   = 0b11101,
	MMI2_PEXEW    = 0b11110,
	MMI2_PROT3W   = 0b11111,
	MAX_MMI2      = 32
};

enum MMI3 {
	MMI3_PMADDUW  = 0b00000,
	MMI3_RESVD_1  = 0b00001,
	MMI3_RESVD_2  = 0b00010,
	MMI3_PSRAVW   = 0b00011,
	MMI3_RESVD_4  = 0b00100,
	MMI3_RESVD_5  = 0b00101,
	MMI3_RESVD_6  = 0b00110,
	MMI3_RESVD_7  = 0b00111,
	MMI3_PMTHI    = 0b01000,
	MMI3_PMTLO    = 0b01001,
	MMI3_PINTEH   = 0b01010,
	MMI3_RESVD_11 = 0b01011,
	MMI3_PMULTUW  = 0b01100,
	MMI3_PDIVUW   = 0b01101,
	MMI3_PCPYUD   = 0b01110,
	MMI3_RESVD_15 = 0b01111,
	MMI3_RESVD_16 = 0b10000,
	MMI3_RESVD_17 = 0b10001,
	MMI3_POR      = 0b10010,
	MMI3_PNOR     = 0b10011,
	MMI3_RESVD_20 = 0b10100,
	MMI3_RESVD_21 = 0b10101,
	MMI3_RESVD_22 = 0b10110,
	MMI3_RESVD_23 = 0b10111,
	MMI3_RESVD_24 = 0b11000,
	MMI3_RESVD_25 = 0b11001,
	MMI3_PEXCH    = 0b11010,
	MMI3_PCPYH    = 0b11011,
	MMI3_RESVD_28 = 0b11100,
	MMI3_RESVD_29 = 0b11101,
	MMI3_PEXCW    = 0b11110,
	MMI3_RESVD_31 = 0b11111,
	MAX_MMI3      = 32
};

enum COP0 {
	COP0_MF0      = 0b00000,
	COP0_RESVD_1  = 0b00001,
	COP0_RESVD_2  = 0b00010,
	COP0_RESVD_3  = 0b00011,
	COP0_MT0      = 0b00100,
	COP0_RESVD_5  = 0b00101,
	COP0_RESVD_6  = 0b00110,
	COP0_RESVD_7  = 0b00111,
	COP0_BC0      = 0b01000,
	COP0_RESVD_9  = 0b01001,
	COP0_RESVD_10 = 0b01010,
	COP0_RESVD_11 = 0b01011,
	COP0_RESVD_12 = 0b01100,
	COP0_RESVD_13 = 0b01101,
	COP0_RESVD_14 = 0b01110,
	COP0_RESVD_15 = 0b01111,
	COP0_C0       = 0b10000,
	COP0_RESVD_17 = 0b10001,
	COP0_RESVD_18 = 0b10010,
	COP0_RESVD_19 = 0b10011,
	COP0_RESVD_20 = 0b10100,
	COP0_RESVD_21 = 0b10101,
	COP0_RESVD_22 = 0b10110,
	COP0_RESVD_23 = 0b10111,
	COP0_RESVD_24 = 0b11000,
	COP0_RESVD_25 = 0b11001,
	COP0_RESVD_26 = 0b11010,
	COP0_RESVD_27 = 0b11011,
	COP0_RESVD_28 = 0b11100,
	COP0_RESVD_29 = 0b11101,
	COP0_RESVD_30 = 0b11110,
	COP0_RESVD_31 = 0b11111,
	MAX_COP0      = 32
};

enum BC0 {
	BC0_BC0F     = 0b00000,
	BC0_BC0T     = 0b00001,
	BC0_BC0FL    = 0b00010,
	BC0_BC0TL    = 0b00011,
	BC0_RESVD_4  = 0b00100,
	BC0_RESVD_5  = 0b00101,
	BC0_RESVD_6  = 0b00110,
	BC0_RESVD_7  = 0b00111,
	BC0_RESVD_8  = 0b01000,
	BC0_RESVD_9  = 0b01001,
	BC0_RESVD_10 = 0b01010,
	BC0_RESVD_11 = 0b01011,
	BC0_RESVD_12 = 0b01100,
	BC0_RESVD_13 = 0b01101,
	BC0_RESVD_14 = 0b01110,
	BC0_RESVD_15 = 0b01111,
	BC0_RESVD_16 = 0b10000,
	BC0_RESVD_17 = 0b10001,
	BC0_RESVD_18 = 0b10010,
	BC0_RESVD_19 = 0b10011,
	BC0_RESVD_20 = 0b10100,
	BC0_RESVD_21 = 0b10101,
	BC0_RESVD_22 = 0b10110,
	BC0_RESVD_23 = 0b10111,
	BC0_RESVD_24 = 0b11000,
	BC0_RESVD_25 = 0b11001,
	BC0_RESVD_26 = 0b11010,
	BC0_RESVD_27 = 0b11011,
	BC0_RESVD_28 = 0b11100,
	BC0_RESVD_29 = 0b11101,
	BC0_RESVD_30 = 0b11110,
	BC0_RESVD_31 = 0b11111,
	MAX_BC0      = 32
};

enum C0 {
	C0_UNDEF_0  = 0b000000,
	C0_TLBR     = 0b000001,
	C0_TLBWI    = 0b000010,
	C0_UNDEF_3  = 0b000011,
	C0_UNDEF_4  = 0b000100,
	C0_UNDEF_5  = 0b000101,
	C0_TLBWR    = 0b000110,
	C0_UNDEF_7  = 0b000111,
	C0_TLBP     = 0b001000,
	C0_UNDEF_9  = 0b001001,
	C0_UNDEF_10 = 0b001010,
	C0_UNDEF_11 = 0b001011,
	C0_UNDEF_12 = 0b001100,
	C0_UNDEF_13 = 0b001101,
	C0_UNDEF_14 = 0b001110,
	C0_UNDEF_15 = 0b001111,
	C0_UNDEF_16 = 0b010000,
	C0_UNDEF_17 = 0b010001,
	C0_UNDEF_18 = 0b010010,
	C0_UNDEF_19 = 0b010011,
	C0_UNDEF_20 = 0b010100,
	C0_UNDEF_21 = 0b010101,
	C0_UNDEF_22 = 0b010110,
	C0_UNDEF_23 = 0b010111,
	C0_ERET     = 0b011000,
	C0_UNDEF_25 = 0b011001,
	C0_UNDEF_26 = 0b011010,
	C0_UNDEF_27 = 0b011011,
	C0_UNDEF_28 = 0b011100,
	C0_UNDEF_29 = 0b011101,
	C0_UNDEF_30 = 0b011110,
	C0_UNDEF_31 = 0b011111,
	C0_UNDEF_32 = 0b100000,
	C0_UNDEF_33 = 0b100001,
	C0_UNDEF_34 = 0b100010,
	C0_UNDEF_35 = 0b100011,
	C0_UNDEF_36 = 0b100100,
	C0_UNDEF_37 = 0b100101,
	C0_UNDEF_38 = 0b100110,
	C0_UNDEF_39 = 0b100111,
	C0_UNDEF_40 = 0b101000,
	C0_UNDEF_41 = 0b101001,
	C0_UNDEF_42 = 0b101010,
	C0_UNDEF_43 = 0b101011,
	C0_UNDEF_44 = 0b101100,
	C0_UNDEF_45 = 0b101101,
	C0_UNDEF_46 = 0b101110,
	C0_UNDEF_47 = 0b101111,
	C0_UNDEF_48 = 0b110000,
	C0_UNDEF_49 = 0b110001,
	C0_UNDEF_50 = 0b110010,
	C0_UNDEF_51 = 0b110011,
	C0_UNDEF_52 = 0b110100,
	C0_UNDEF_53 = 0b110101,
	C0_UNDEF_54 = 0b110110,
	C0_UNDEF_55 = 0b110111,
	C0_EI       = 0b111000,
	C0_DI       = 0b111001,
	C0_UNDEF_58 = 0b111010,
	C0_UNDEF_59 = 0b111011,
	C0_UNDEF_60 = 0b111100,
	C0_UNDEF_61 = 0b111101,
	C0_UNDEF_62 = 0b111110,
	C0_UNDEF_63 = 0b111111,
	MAX_C0      = 64
};

enum COP1 {
	COP1_MFC1     = 0b00000,
	COP1_RESVD_1  = 0b00001,
	COP1_CFC1     = 0b00010,
	COP1_RESVD_3  = 0b00011,
	COP1_MTC1     = 0b00100,
	COP1_RESVD_5  = 0b00101,
	COP1_CTC1     = 0b00110,
	COP1_RESVD_7  = 0b00111,
	COP1_BC1      = 0b01000,
	COP1_RESVD_9  = 0b01001,
	COP1_RESVD_10 = 0b01010,
	COP1_RESVD_11 = 0b01011,
	COP1_RESVD_12 = 0b01100,
	COP1_RESVD_13 = 0b01101,
	COP1_RESVD_14 = 0b01110,
	COP1_RESVD_15 = 0b01111,
	COP1_S        = 0b10000,
	COP1_RESVD_17 = 0b10001,
	COP1_RESVD_18 = 0b10010,
	COP1_RESVD_19 = 0b10011,
	COP1_W        = 0b10100,
	COP1_RESVD_21 = 0b10101,
	COP1_RESVD_22 = 0b10110,
	COP1_RESVD_23 = 0b10111,
	COP1_RESVD_24 = 0b11000,
	COP1_RESVD_25 = 0b11001,
	COP1_RESVD_26 = 0b11010,
	COP1_RESVD_27 = 0b11011,
	COP1_RESVD_28 = 0b11100,
	COP1_RESVD_29 = 0b11101,
	COP1_RESVD_30 = 0b11110,
	COP1_RESVD_31 = 0b11111,
	MAX_COP1      = 32
};

enum BC1 {
	BC1_BC1F     = 0b00000,
	BC1_BC1T     = 0b00001,
	BC1_BC1FL    = 0b00010,
	BC1_BC1TL    = 0b00011,
	BC1_RESVD_4  = 0b00100,
	BC1_RESVD_5  = 0b00101,
	BC1_RESVD_6  = 0b00110,
	BC1_RESVD_7  = 0b00111,
	BC1_RESVD_8  = 0b01000,
	BC1_RESVD_9  = 0b01001,
	BC1_RESVD_10 = 0b01010,
	BC1_RESVD_11 = 0b01011,
	BC1_RESVD_12 = 0b01100,
	BC1_RESVD_13 = 0b01101,
	BC1_RESVD_14 = 0b01110,
	BC1_RESVD_15 = 0b01111,
	BC1_RESVD_16 = 0b10000,
	BC1_RESVD_17 = 0b10001,
	BC1_RESVD_18 = 0b10010,
	BC1_RESVD_19 = 0b10011,
	BC1_RESVD_20 = 0b10100,
	BC1_RESVD_21 = 0b10101,
	BC1_RESVD_22 = 0b10110,
	BC1_RESVD_23 = 0b10111,
	BC1_RESVD_24 = 0b11000,
	BC1_RESVD_25 = 0b11001,
	BC1_RESVD_26 = 0b11010,
	BC1_RESVD_27 = 0b11011,
	BC1_RESVD_28 = 0b11100,
	BC1_RESVD_29 = 0b11101,
	BC1_RESVD_30 = 0b11110,
	BC1_RESVD_31 = 0b11111,
	MAX_BC1      = 32
};

enum S {
	S_ADD      = 0b000000,
	S_SUB      = 0b000001,
	S_MUL      = 0b000010,
	S_DIV      = 0b000011,
	S_SQRT     = 0b000100,
	S_ABS      = 0b000101,
	S_MOV      = 0b000110,
	S_NEG      = 0b000111,
	S_UNDEF_8  = 0b001000,
	S_UNDEF_9  = 0b001001,
	S_UNDEF_10 = 0b001010,
	S_UNDEF_11 = 0b001011,
	S_UNDEF_12 = 0b001100,
	S_UNDEF_13 = 0b001101,
	S_UNDEF_14 = 0b001110,
	S_UNDEF_15 = 0b001111,
	S_UNDEF_16 = 0b010000,
	S_UNDEF_17 = 0b010001,
	S_UNDEF_18 = 0b010010,
	S_UNDEF_19 = 0b010011,
	S_UNDEF_20 = 0b010100,
	S_UNDEF_21 = 0b010101,
	S_RSQRT    = 0b010110,
	S_UNDEF_23 = 0b010111,
	S_ADDA     = 0b011000,
	S_SUBA     = 0b011001,
	S_MULA     = 0b011010,
	S_UNDEF_27 = 0b011011,
	S_MADD     = 0b011100,
	S_MSUB     = 0b011101,
	S_MADDA    = 0b011110,
	S_MSUBA    = 0b011111,
	S_UNDEF_32 = 0b100000,
	S_UNDEF_33 = 0b100001,
	S_UNDEF_34 = 0b100010,
	S_UNDEF_35 = 0b100011,
	S_CVTW     = 0b100100,
	S_UNDEF_37 = 0b100101,
	S_UNDEF_38 = 0b100110,
	S_UNDEF_39 = 0b100111,
	S_MAX      = 0b101000,
	S_MIN      = 0b101001,
	S_UNDEF_42 = 0b101010,
	S_UNDEF_43 = 0b101011,
	S_UNDEF_44 = 0b101100,
	S_UNDEF_45 = 0b101101,
	S_UNDEF_46 = 0b101110,
	S_UNDEF_47 = 0b101111,
	S_C_F      = 0b110000,
	S_UNDEF_49 = 0b110001,
	S_C_EQ     = 0b110010,
	S_UNDEF_51 = 0b110011,
	S_C_LT     = 0b110100,
	S_UNDEF_53 = 0b110101,
	S_C_LE     = 0b110110,
	S_UNDEF_55 = 0b110111,
	S_UNDEF_56 = 0b111000,
	S_UNDEF_57 = 0b111001,
	S_UNDEF_58 = 0b111010,
	S_UNDEF_59 = 0b111011,
	S_UNDEF_60 = 0b111100,
	S_UNDEF_61 = 0b111101,
	S_UNDEF_62 = 0b111110,
	S_UNDEF_63 = 0b111111,
	MAX_S      = 64
};

enum W {
	W_UNDEF_0  = 0b000000,
	W_UNDEF_1  = 0b000001,
	W_UNDEF_2  = 0b000010,
	W_UNDEF_3  = 0b000011,
	W_UNDEF_4  = 0b000100,
	W_UNDEF_5  = 0b000101,
	W_UNDEF_6  = 0b000110,
	W_UNDEF_7  = 0b000111,
	W_UNDEF_8  = 0b001000,
	W_UNDEF_9  = 0b001001,
	W_UNDEF_10 = 0b001010,
	W_UNDEF_11 = 0b001011,
	W_UNDEF_12 = 0b001100,
	W_UNDEF_13 = 0b001101,
	W_UNDEF_14 = 0b001110,
	W_UNDEF_15 = 0b001111,
	W_UNDEF_16 = 0b010000,
	W_UNDEF_17 = 0b010001,
	W_UNDEF_18 = 0b010010,
	W_UNDEF_19 = 0b010011,
	W_UNDEF_20 = 0b010100,
	W_UNDEF_21 = 0b010101,
	W_UNDEF_22 = 0b010110,
	W_UNDEF_23 = 0b010111,
	W_UNDEF_24 = 0b011000,
	W_UNDEF_25 = 0b011001,
	W_UNDEF_26 = 0b011010,
	W_UNDEF_27 = 0b011011,
	W_UNDEF_28 = 0b011100,
	W_UNDEF_29 = 0b011101,
	W_UNDEF_30 = 0b011110,
	W_UNDEF_31 = 0b011111,
	W_CVTS = 0b100000,
	W_UNDEF_33 = 0b100001,
	W_UNDEF_34 = 0b100010,
	W_UNDEF_35 = 0b100011,
	W_UNDEF_36 = 0b100100,
	W_UNDEF_37 = 0b100101,
	W_UNDEF_38 = 0b100110,
	W_UNDEF_39 = 0b100111,
	W_UNDEF_40 = 0b101000,
	W_UNDEF_41 = 0b101001,
	W_UNDEF_42 = 0b101010,
	W_UNDEF_43 = 0b101011,
	W_UNDEF_44 = 0b101100,
	W_UNDEF_45 = 0b101101,
	W_UNDEF_46 = 0b101110,
	W_UNDEF_47 = 0b101111,
	W_UNDEF_48 = 0b110000,
	W_UNDEF_49 = 0b110001,
	W_UNDEF_50 = 0b110010,
	W_UNDEF_51 = 0b110011,
	W_UNDEF_52 = 0b110100,
	W_UNDEF_53 = 0b110101,
	W_UNDEF_54 = 0b110110,
	W_UNDEF_55 = 0b110111,
	W_UNDEF_56 = 0b111000,
	W_UNDEF_57 = 0b111001,
	W_UNDEF_58 = 0b111010,
	W_UNDEF_59 = 0b111011,
	W_UNDEF_60 = 0b111100,
	W_UNDEF_61 = 0b111101,
	W_UNDEF_62 = 0b111110,
	W_UNDEF_63 = 0b111111,
	MAX_W      = 64
};

}
