# Project Structure

- src/demangle.cpp: Main file for demangle.
- src/fuzztest.cpp: Fuzzing harness for libfuzzer.
- src/objdump.cpp: Main file for objdump.
- src/stdump.cpp: Main file for stdump.
- src/tests.cpp: Test runner.
- src/uncc.cpp: Main file for uncc.
- src/ccc/ast.cpp: Defines a C++ AST structure for types.
- src/ccc/ast_json.cpp: Reads/writes the AST structure as JSON.
- src/ccc/data_refinement.cpp: Converts global variable data into structured initializer lists and literals.
- src/ccc/dependency.cpp: Tries to infer information about which types belong to which files.
- src/ccc/dwarf_attributes.cpp: Parses DWARF 1 attributes.
- src/ccc/dwarf_forge.cpp: Generates DWARF 1 symbol tables for testing purposes.
- src/ccc/dwarf_importer.cpp: Imports DWARF 1 symbol tables into the symbol database.
- src/ccc/dwarf_printer.cpp: Prints out DWARF 1 symbol tables.
- src/ccc/dwarf_section.cpp: Parses the DWARF 1 binary format.
- src/ccc/dwarf_to_ast.cpp: Converts DWARF 1 types into a C++ AST.
- src/ccc/elf.cpp: Parses ELF files.
- src/ccc/elf_symtab.cpp: Parses the ELF symbol table.
- src/ccc/importer_flags.cpp: An enum and help information printing for importer configuration flags.
- src/ccc/int128.cpp: 128-bit integer types.
- src/ccc/mdebug_analysis.cpp: Accepts a stream of symbols and imports the data.
- src/ccc/mdebug_importer.cpp: Imports .mdebug (STABS) symbol tables into the symbol database.
- src/ccc/mdebug_section.cpp: Parses the .mdebug binary format.
- src/ccc/mdebug_symbols.cpp: Parses symbols from the .mdebug section.
- src/ccc/print_cpp.cpp: Prints out AST nodes as C++ code.
- src/ccc/registers.cpp: Enums for EE core MIPS registers.
- src/ccc/sndll.cpp: Parses SNDLL files and imports symbols.
- src/ccc/stabs.cpp: Parses STABS types.
- src/ccc/stabs_to_ast.cpp: Converts parsed STABS types into a C++ AST.
- src/ccc/symbol_database.cpp: Data structures for storing symbols in memory.
- src/ccc/symbol_file.cpp: Top-level file for parsing files containing symbol tables.
- src/ccc/symbol_json.cpp: Reads/writes the symbol database as JSON.
- src/ccc/symbol_table.cpp: Top-level file for parsing symbol tables.
- src/ccc/util.cpp: Miscellaneous utilities.
- src/mips/insn.cpp: Parses EE core MIPS instructions.
- src/mips/opcodes.h: Enums for different types of EE core MIPS opcodes.
- src/mips/tables.cpp: Table of EE core MIPS instructions.
- src/platform/file.cpp: Utility functions for reading files.
- tests/: Unit tests.
