(function () {
  var mark = 0; // 拖动起点 
  var newMark = 0; // 拖动终点
  var open = false; // 展开状态
  var el = document.getElementById('move');
  var elBtn = document.getElementById('btn');
  var width = document.body.clientWidth;
  var changeWidth = width * 0.2;

  elBtn.onclick = function (e) {
    e.stopPropagation();
    if (open) {
      el.style.cssText = "transition: All 0.4s linear; transform: translate3d(0px,0,0);"
    } else {
      el.style.cssText = "transition: All 0.4s linear; transform: translate3d(300px,0,0);"
    }
    open = !open;
  }

  function touchmove(e) {
    newMark = e.touches[0].pageX
    var moveX = Math.ceil(newMark - mark);

    if (open) {
      if (moveX > 0) {
        return
      }
      moveX += 300
    }
    if (moveX > 0) {
      el.style.cssText = "transform: translate3d(" + moveX + "px,0,0);"
    }
  }

  function touchstart(e) {
    mark = newMark = e.touches[0].pageX;
  }

  function touchend(e) {
    if (!e.target.classList.contains("draggable")) {
      return;
    }
    var moveX = Math.abs(newMark - mark);
    if (open) { // 已打开
      if (moveX > changeWidth) {
        el.style.cssText = "transition: All 0.2s linear; transform: translate3d(0px,0,0);"
        open = !open
      } else {
        el.style.cssText = "transition: All 0.2s linear; transform: translate3d(300px,0,0);"
      }
    } else {
      if (moveX > changeWidth) {
        el.style.cssText = "transition: All 0.2s linear; transform: translate3d(300px,0,0);"
        open = !open
      } else {
        el.style.cssText = "transition: All 0.2s linear; transform: translate3d(0px,0,0);"
      }
    }
    mark = 0
    newMark = 0
  }

  el.addEventListener('touchmove', touchmove, false);
  el.addEventListener('touchstart', touchstart, false);
  el.addEventListener('touchend', touchend, false);
}())