import { createFilter } from "@rollup/pluginutils";
import fs from "fs";
import { transformWithEsbuild } from "vite";
function viteSvgr({
  exportAsDefault,
  svgrOptions,
  esbuildOptions,
  include = "**/*.svg",
  exclude
} = {}) {
  const filter = createFilter(include, exclude);
  return {
    name: "vite-plugin-svgr",
    async transform(code, id) {
      if (filter(id)) {
        const { transform } = await import("@svgr/core");
        const svgCode = await fs.promises.readFile(
          id.replace(/\?.*$/, ""),
          "utf8"
        );
        const componentCode = await transform(svgCode, svgrOptions, {
          filePath: id,
          caller: {
            previousExport: exportAsDefault ? null : code
          }
        });
        const res = await transformWithEsbuild(componentCode, id, {
          loader: "jsx",
          ...esbuildOptions
        });
        return {
          code: res.code,
          map: null
        };
      }
    }
  };
}
export {
  viteSvgr as default
};
