"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
const pluginutils = require("@rollup/pluginutils");
const fs = require("fs");
const vite = require("vite");
function viteSvgr({
  exportAsDefault,
  svgrOptions,
  esbuildOptions,
  include = "**/*.svg",
  exclude
} = {}) {
  const filter = pluginutils.createFilter(include, exclude);
  return {
    name: "vite-plugin-svgr",
    async transform(code, id) {
      if (filter(id)) {
        const { transform } = await import("@svgr/core");
        const svgCode = await fs.promises.readFile(
          id.replace(/\?.*$/, ""),
          "utf8"
        );
        const componentCode = await transform(svgCode, svgrOptions, {
          filePath: id,
          caller: {
            previousExport: exportAsDefault ? null : code
          }
        });
        const res = await vite.transformWithEsbuild(componentCode, id, {
          loader: "jsx",
          ...esbuildOptions
        });
        return {
          code: res.code,
          map: null
        };
      }
    }
  };
}
module.exports = viteSvgr;
