import type { Config } from '@svgr/core';
import { FilterPattern } from '@rollup/pluginutils';
import type { Plugin as Plugin_2 } from 'vite';
import { transformWithEsbuild } from 'vite';

declare function viteSvgr({ exportAsDefault, svgrOptions, esbuildOptions, include, exclude, }?: ViteSvgrOptions): Plugin_2;
export default viteSvgr;

export declare interface ViteSvgrOptions {
    /**
     * Export React component as default. Notice that it will overrides
     * the default behavior of Vite, which exports the URL as default
     *
     * @default false
     */
    exportAsDefault?: boolean;
    svgrOptions?: Config;
    esbuildOptions?: Parameters<typeof transformWithEsbuild>[2];
    exclude?: FilterPattern;
    include?: FilterPattern;
}

export { }
