import type { CanonicalPath } from '../create-program/shared';
import type { TSESTreeOptions } from '../parser-options';
/**
 * Normalizes, sanitizes, resolves and filters the provided project paths
 */
export declare function resolveProjectList(options: Readonly<{
    cacheLifetime?: TSESTreeOptions['cacheLifetime'];
    project: TSESTreeOptions['project'];
    projectFolderIgnoreList: TSESTreeOptions['projectFolderIgnoreList'];
    singleRun: boolean;
    tsconfigRootDir: string;
}>): readonly CanonicalPath[];
/**
 * Exported for testing purposes only
 * @internal
 */
export declare function clearGlobResolutionCache(): void;
//# sourceMappingURL=resolveProjectList.d.ts.map