community_icon_html = """<svg id="share-btn-share-icon" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32">
    <path d="M20.6081 3C21.7684 3 22.8053 3.49196 23.5284 4.38415C23.9756 4.93678 24.4428 5.82749 24.4808 7.16133C24.9674 7.01707 25.4353 6.93643 25.8725 6.93643C26.9833 6.93643 27.9865 7.37587 28.696 8.17411C29.6075 9.19872 30.0124 10.4579 29.8361 11.7177C29.7523 12.3177 29.5581 12.8555 29.2678 13.3534C29.8798 13.8646 30.3306 14.5763 30.5485 15.4322C30.719 16.1032 30.8939 17.5006 29.9808 18.9403C30.0389 19.0342 30.0934 19.1319 30.1442 19.2318C30.6932 20.3074 30.7283 21.5229 30.2439 22.6548C29.5093 24.3704 27.6841 25.7219 24.1397 27.1727C21.9347 28.0753 19.9174 28.6523 19.8994 28.6575C16.9842 29.4379 14.3477 29.8345 12.0653 29.8345C7.87017 29.8345 4.8668 28.508 3.13831 25.8921C0.356375 21.6797 0.754104 17.8269 4.35369 14.1131C6.34591 12.058 7.67023 9.02782 7.94613 8.36275C8.50224 6.39343 9.97271 4.20438 12.4172 4.20438H12.4179C12.6236 4.20438 12.8314 4.2214 13.0364 4.25468C14.107 4.42854 15.0428 5.06476 15.7115 6.02205C16.4331 5.09583 17.134 4.359 17.7682 3.94323C18.7242 3.31737 19.6794 3 20.6081 3ZM20.6081 5.95917C20.2427 5.95917 19.7963 6.1197 19.3039 6.44225C17.7754 7.44319 14.8258 12.6772 13.7458 14.7131C13.3839 15.3952 12.7655 15.6837 12.2086 15.6837C11.1036 15.6837 10.2408 14.5497 12.1076 13.1085C14.9146 10.9402 13.9299 7.39584 12.5898 7.1776C12.5311 7.16799 12.4731 7.16355 12.4172 7.16355C11.1989 7.16355 10.6615 9.33114 10.6615 9.33114C10.6615 9.33114 9.0863 13.4148 6.38031 16.206C3.67434 18.998 3.5346 21.2388 5.50675 24.2246C6.85185 26.2606 9.42666 26.8753 12.0653 26.8753C14.8021 26.8753 17.6077 26.2139 19.1799 25.793C19.2574 25.7723 28.8193 22.984 27.6081 20.6107C27.4046 20.212 27.0693 20.0522 26.6471 20.0522C24.9416 20.0522 21.8393 22.6726 20.5057 22.6726C20.2076 22.6726 19.9976 22.5416 19.9116 22.222C19.3433 20.1173 28.552 19.2325 27.7758 16.1839C27.639 15.6445 27.2677 15.4256 26.746 15.4263C24.4923 15.4263 19.4358 19.5181 18.3759 19.5181C18.2949 19.5181 18.2368 19.4937 18.2053 19.4419C17.6743 18.557 17.9653 17.9394 21.7082 15.6009C25.4511 13.2617 28.0783 11.8545 26.5841 10.1752C26.4121 9.98141 26.1684 9.8956 25.8725 9.8956C23.6001 9.89634 18.2311 14.9403 18.2311 14.9403C18.2311 14.9403 16.7821 16.496 15.9057 16.496C15.7043 16.496 15.533 16.4139 15.4169 16.2112C14.7956 15.1296 21.1879 10.1286 21.5484 8.06535C21.7928 6.66715 21.3771 5.95917 20.6081 5.95917Z" fill="#FF9D00"></path>
    <path d="M5.50686 24.2246C3.53472 21.2387 3.67446 18.9979 6.38043 16.206C9.08641 13.4147 10.6615 9.33111 10.6615 9.33111C10.6615 9.33111 11.2499 6.95933 12.59 7.17757C13.93 7.39581 14.9139 10.9401 12.1069 13.1084C9.29997 15.276 12.6659 16.7489 13.7459 14.713C14.8258 12.6772 17.7747 7.44316 19.304 6.44221C20.8326 5.44128 21.9089 6.00204 21.5484 8.06532C21.188 10.1286 14.795 15.1295 15.4171 16.2118C16.0391 17.2934 18.2312 14.9402 18.2312 14.9402C18.2312 14.9402 25.0907 8.49588 26.5842 10.1752C28.0776 11.8545 25.4512 13.2616 21.7082 15.6008C17.9646 17.9393 17.6744 18.557 18.2054 19.4418C18.7372 20.3266 26.9998 13.1351 27.7759 16.1838C28.5513 19.2324 19.3434 20.1173 19.9117 22.2219C20.48 24.3274 26.3979 18.2382 27.6082 20.6107C28.8193 22.9839 19.2574 25.7722 19.18 25.7929C16.0914 26.62 8.24723 28.3726 5.50686 24.2246Z" fill="#FFD21E"></path>
</svg>"""

loading_icon_html = """<svg id="share-btn-loading-icon" style="display:none;" class="animate-spin"
   style="color: #ffffff; 
"
   xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" fill="none" focusable="false" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 24 24"><circle style="opacity: 0.25;" cx="12" cy="12" r="10" stroke="white" stroke-width="4"></circle><path style="opacity: 0.75;" fill="white" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>"""

share_js = """async () => {
	async function uploadFile(file){
		const UPLOAD_URL = 'https://huggingface.co/uploads';
		const response = await fetch(UPLOAD_URL, {
			method: 'POST',
			headers: {
				'Content-Type': file.type,
				'X-Requested-With': 'XMLHttpRequest',
			},
			body: file, /// <- File inherits from Blob
		});
		const url = await response.text();
		return url;
	}
	
    async function getInputImgFile(imgEl){
        const res = await fetch(imgEl.src);
        const blob = await res.blob();
        const imgId = Date.now() % 200;
        const isPng = imgEl.src.startsWith(`data:image/png`);
        if(isPng){
            const fileName = `sd-perception-${{imgId}}.png`;
            return new File([blob], fileName, { type: 'image/png' });
        }else{
            const fileName = `sd-perception-${{imgId}}.jpg`;
            return new File([blob], fileName, { type: 'image/jpeg' });
        }
	}
    
    const gradioEl = document.querySelector("gradio-app").shadowRoot || document.querySelector('body > gradio-app');
    
    const inputPrompt = gradioEl.querySelector('#prompt textarea').value;
    const negativePrompt = gradioEl.querySelector('#negative_prompt textarea').value;
    const illusionStrength = gradioEl.querySelector('#illusion_strength input[type="number"]').value;
    const controlImage = gradioEl.querySelector('#control_image img');
    const outputImgEl = gradioEl.querySelector('#output img');
    
    const shareBtnEl = gradioEl.querySelector('#share-btn');
    const shareIconEl = gradioEl.querySelector('#share-btn-share-icon');
    const loadingIconEl = gradioEl.querySelector('#share-btn-loading-icon');
    
    shareBtnEl.style.pointerEvents = 'none';
    shareIconEl.style.display = 'none';
    loadingIconEl.style.removeProperty('display');
    
    const inputFile = await getInputImgFile(outputImgEl);
    const urlInputImg = await uploadFile(inputFile);

    const controlFile = await getInputImgFile(controlImage);
    const urlControlImg = await uploadFile(controlFile);
    
    const descriptionMd = `
### Prompt
- *Prompt*: ${inputPrompt}
- *Negative prompt*: ${negativePrompt}
- *Illusion strength*: ${illusionStrength}
#### Generated Image:
<img src="${urlInputImg}" />

#### Control Image: 
<img src="${urlControlImg}" />
`;
    const params = new URLSearchParams({
        title: inputPrompt,
        description: descriptionMd,
        preview: true
    });
	const paramsStr = params.toString();
	window.open(`https://huggingface.co/spaces/AP123/IllusionDiffusion/discussions/new?${paramsStr}`, '_blank');
    shareBtnEl.style.removeProperty('pointer-events');
    shareIconEl.style.removeProperty('display');
    loadingIconEl.style.display = 'none';
}"""