<!-- Congrats on creating an Awesome WireGuard entry! 🎉 -->

<!-- 
TLDR:
 * If paying service add :heavy_dollar_sign:
 * If WIP add :construction:
 * clear and short description of the project
 * project MUST have: How to setup/install
 * project MUST have: How to use (examples)
 * we can help you get there :)
-->

# Quality Standards

Note that we can help you achieve those standards, just try your best and be brave.
We'll guide you to the best of our abilities.

To be on the list, it would be **nice** if entries adhere to these quality standards:

- It should take less than 20 sec to find what is the project, how to install it and how to use it.
- Generally useful to the community.
- A project on GitHub with a well documented `README.md` file and plenty of examples is considered high quality.
- Clearly stating "what is it" i.e. which category it belongs to.
- Clearly stating "what is it for" i.e. mention a real problem it solves (even a small one). Make it clear for the next person.
- If it is a **WIP** (work in progress, not safe for production), please mention it.
- Always put the link to the GitHub project instead of the website!

To be on the list, the project **must** have:

- How to setup/install the project
- How to use the project (examples)

If your PR is not merged, we will tell you why so that you may be able to improve it.
But usually, we are pretty relaxed people, so just come and say hi, we'll figure something out together.

# Rules for Pull Request

- Each item should be limited to one link, no duplicates, no redirection (careful with `http` vs `https`!)
- The link should be the name of the package or project or website.
- Description should be clear and concise (read it out loud to be sure).
- Description should follow the link, on the same line.
- Entries are listed alphabetically, please respect the order.
- If you want to add more than one link, please don't do all PR on the exact same line, it usually results in conflicts and your PR cannot be automatically merged...

Please contribute links to packages/projects you have used or are familiar with. This will help ensure high-quality entries.

#### Your commit message will be a [tweet](https://twitter.com/awesome-wireguard) so write a [good commit message](https://chris.beams.io/posts/git-commit/), keep that in mind :)
