# Contributing to awesome-wireguard

First: if you're unsure or afraid of anything, just ask or submit the issue or pull request anyways. You won't be yelled at for giving your best effort. The worst that can happen is that you'll be politely asked to change something. We appreciate any sort of contributions, and don't want a wall of rules to get in the way of that.

However, for those individuals who want a bit more guidance on the best way to contribute to the project, read on. This document will cover what we're looking for. By addressing all the points we're looking for, it raises the chances we can quickly merge or address your contributions.

We appreciate and recognize [all contributors](https://github.com/cedrickchee/awesome-wireguard/graphs/contributors).

<!-- Please note that this project is released with a [Contributor Code of Conduct](https://github.com/cedrickchee/awesome-wireguard/blob/main/.github/CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms. -->

# Table of Contents

- [Mission Statement](#mission-statement)
- [Quality Standards](#quality-standards)
- [Contribution Guidelines](#contribution-guidelines)
- [New Collaborators](#new-collaborators)

# Mission Statement

`awesome-wireguard` is a hand-crafted list for high-quality information about WireGuard and its resources. It should be related or compatible with WireGuard.
If it's a **tutorial or a blog post**, they get outdated really quickly so we don't really put them on the list but if it is on a very advanced and/or specific topic, we will consider it!
If something is awesome, share it (pull request or [issue](https://github.com/cedrickchee/awesome-wireguard/issues/new) or [chat](https://gitter.im/cedrickchee/awesome-wireguard)), let us know why and we will help you!

# Quality Standards

Note that we can help you achieve those standards, just try your best and be brave.
We'll guide you to the best of our abilities.

To be on the list, it would be **nice** if entries adhere to these quality standards:

- It should take less than 20 sec to find what is the project, how to install it and how to use it.
- Generally useful to the community.
- A project on GitHub with a well documented `README.md` file and plenty of examples is considered high quality.
- Clearly stating "what is it" i.e. which category it belongs to.
- Clearly stating "what is it for" i.e. mention a real problem it solves (even a small one). Make it clear for the next person.
- If it is a **WIP** (work in progress, not safe for production), please mention it.
- Always put the link to the GitHub project instead of the website!

To be on the list, the project **must** have:

- How to setup/install the project
- How to use the project (examples)

If your PR is not merged, we will tell you why so that you may be able to improve it.
But usually, we are pretty relaxed people, so just come and say hi, we'll figure something out together.

# Contribution Guidelines

## I want to share a project, what should I do?

- **Adding to the list:** Submit a pull request or open an [issue](https://github.com/cedrickchee/awesome-wireguard/issues/new)
- **Removing from the list:** Submit a pull request or open an [issue](https://github.com/cedrickchee/awesome-wireguard/issues/new)
- Changing something else: Submit a pull request or open an [issue](https://github.com/cedrickchee/awesome-wireguard/issues/new)
- Don't know what to do: Open an [issue](https://github.com/cedrickchee/awesome-wireguard/issues/new) or join our [chat](https://gitter.im/cedrickchee/awesome-wireguard), let us know what's going on.

**join the chat:**

[![Join the chat at https://gitter.im/cedrickchee/awesome-wireguard](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/cedrickchee/awesome-wireguard)

or you can

**ping us on Twitter:**

* [cedric_chee](https://twitter.com/cedric_chee)

### Rules for Pull Request

- Each item should be limited to one link, no duplicates, no redirection (careful with `http` vs `https`!).
- The link should be the name of the package or project or website.
- Description should be clear and concise (read it out loud to be sure).
- Description should follow the link, on the same line.
- If you want to add more than one link, please don't do all PR on the exact same line, it usually results in conflicts and your PR cannot be automatically merged.
<!-- - Entries are listed alphabetically, please respect the order -->

Please contribute links to packages/projects you have used or are familiar with. This will help ensure high-quality entries.

<!-- #### Your commit message will be a [tweet](https://twitter.com/awesome-wireguard) so write a [good commit message](https://chris.beams.io/posts/git-commit/), keep that in mind :) -->

# New Collaborators

If you just joined the team of maintainers for this repo, first of all: WELCOME!

If it is your first time maintaining an open source project, read the [best practice guides for maintainers](https://opensource.guide/best-practices/).

Here are the few things you need to know:
* We don't push directly to the main branch. Every entry **MUST** be reviewed!
* Each entry should be in accordance to this quality standards and contribution guidelines.
* If something seems weird, i.e. if you don't understand what a project does or the documentation is poor, don't hesitate to (nicely) ask for more explanation (see previous point).
* Say thank you to people who contribute to this project! It may not seems like much but respect and gratitude are important :D
<!-- * To ask a contributor to make a change, just copy paste this message [here](https://github.com/cedrickchee/awesome-wireguard/pull/1#issuecomment-285608009) and change few things like names and stuff. **The main idea is to help people making great projects.** -->
