//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (1)
//--------------------------------------------------------------------------------
pub const PKEY_PIDSTR_MAX = @as(u32, 10);

//--------------------------------------------------------------------------------
// Section: Types (61)
//--------------------------------------------------------------------------------
pub const PROPERTYKEY = extern struct {
    fmtid: Guid,
    pid: u32,
};

const CLSID_InMemoryPropertyStore_Value = Guid.initString("9a02e012-6303-4e1e-b9a1-630f802592c5");
pub const CLSID_InMemoryPropertyStore = &CLSID_InMemoryPropertyStore_Value;

const CLSID_InMemoryPropertyStoreMarshalByValue_Value = Guid.initString("d4ca0e2d-6da7-4b75-a97c-5f306f0eaedc");
pub const CLSID_InMemoryPropertyStoreMarshalByValue = &CLSID_InMemoryPropertyStoreMarshalByValue_Value;

const CLSID_PropertySystem_Value = Guid.initString("b8967f85-58ae-4f46-9fb2-5d7904798f4b");
pub const CLSID_PropertySystem = &CLSID_PropertySystem_Value;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IInitializeWithFile_Value = Guid.initString("b7d14566-0509-4cce-a71f-0a554233bd9b");
pub const IID_IInitializeWithFile = &IID_IInitializeWithFile_Value;
pub const IInitializeWithFile = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IInitializeWithFile,
                pszFilePath: ?[*:0]const u16,
                grfMode: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IInitializeWithFile,
                pszFilePath: ?[*:0]const u16,
                grfMode: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IInitializeWithFile_Initialize(self: *const T, pszFilePath: ?[*:0]const u16, grfMode: u32) HRESULT {
                return @as(*const IInitializeWithFile.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IInitializeWithFile, @ptrCast(self)), pszFilePath, grfMode);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IInitializeWithStream_Value = Guid.initString("b824b49d-22ac-4161-ac8a-9916e8fa3f7f");
pub const IID_IInitializeWithStream = &IID_IInitializeWithStream_Value;
pub const IInitializeWithStream = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IInitializeWithStream,
                pstream: ?*IStream,
                grfMode: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IInitializeWithStream,
                pstream: ?*IStream,
                grfMode: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IInitializeWithStream_Initialize(self: *const T, pstream: ?*IStream, grfMode: u32) HRESULT {
                return @as(*const IInitializeWithStream.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IInitializeWithStream, @ptrCast(self)), pstream, grfMode);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IPropertyStore_Value = Guid.initString("886d8eeb-8cf2-4446-8d02-cdba1dbdcf99");
pub const IID_IPropertyStore = &IID_IPropertyStore_Value;
pub const IPropertyStore = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStore,
                cProps: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStore,
                cProps: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStore,
                iProp: u32,
                pkey: ?*PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStore,
                iProp: u32,
                pkey: ?*PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStore,
                key: ?*const PROPERTYKEY,
                pv: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStore,
                key: ?*const PROPERTYKEY,
                pv: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStore,
                key: ?*const PROPERTYKEY,
                propvar: ?*const PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStore,
                key: ?*const PROPERTYKEY,
                propvar: ?*const PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Commit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStore,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStore,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStore_GetCount(self: *const T, cProps: ?*u32) HRESULT {
                return @as(*const IPropertyStore.VTable, @ptrCast(self.vtable)).GetCount(@as(*const IPropertyStore, @ptrCast(self)), cProps);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStore_GetAt(self: *const T, iProp: u32, pkey: ?*PROPERTYKEY) HRESULT {
                return @as(*const IPropertyStore.VTable, @ptrCast(self.vtable)).GetAt(@as(*const IPropertyStore, @ptrCast(self)), iProp, pkey);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStore_GetValue(self: *const T, key: ?*const PROPERTYKEY, pv: ?*PROPVARIANT) HRESULT {
                return @as(*const IPropertyStore.VTable, @ptrCast(self.vtable)).GetValue(@as(*const IPropertyStore, @ptrCast(self)), key, pv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStore_SetValue(self: *const T, key: ?*const PROPERTYKEY, propvar: ?*const PROPVARIANT) HRESULT {
                return @as(*const IPropertyStore.VTable, @ptrCast(self.vtable)).SetValue(@as(*const IPropertyStore, @ptrCast(self)), key, propvar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStore_Commit(self: *const T) HRESULT {
                return @as(*const IPropertyStore.VTable, @ptrCast(self.vtable)).Commit(@as(*const IPropertyStore, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INamedPropertyStore_Value = Guid.initString("71604b0f-97b0-4764-8577-2f13e98a1422");
pub const IID_INamedPropertyStore = &IID_INamedPropertyStore_Value;
pub const INamedPropertyStore = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetNamedValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INamedPropertyStore,
                pszName: ?[*:0]const u16,
                ppropvar: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INamedPropertyStore,
                pszName: ?[*:0]const u16,
                ppropvar: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetNamedValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INamedPropertyStore,
                pszName: ?[*:0]const u16,
                propvar: ?*const PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INamedPropertyStore,
                pszName: ?[*:0]const u16,
                propvar: ?*const PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNameCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INamedPropertyStore,
                pdwCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INamedPropertyStore,
                pdwCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNameAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INamedPropertyStore,
                iProp: u32,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INamedPropertyStore,
                iProp: u32,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INamedPropertyStore_GetNamedValue(self: *const T, pszName: ?[*:0]const u16, ppropvar: ?*PROPVARIANT) HRESULT {
                return @as(*const INamedPropertyStore.VTable, @ptrCast(self.vtable)).GetNamedValue(@as(*const INamedPropertyStore, @ptrCast(self)), pszName, ppropvar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INamedPropertyStore_SetNamedValue(self: *const T, pszName: ?[*:0]const u16, propvar: ?*const PROPVARIANT) HRESULT {
                return @as(*const INamedPropertyStore.VTable, @ptrCast(self.vtable)).SetNamedValue(@as(*const INamedPropertyStore, @ptrCast(self)), pszName, propvar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INamedPropertyStore_GetNameCount(self: *const T, pdwCount: ?*u32) HRESULT {
                return @as(*const INamedPropertyStore.VTable, @ptrCast(self.vtable)).GetNameCount(@as(*const INamedPropertyStore, @ptrCast(self)), pdwCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INamedPropertyStore_GetNameAt(self: *const T, iProp: u32, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const INamedPropertyStore.VTable, @ptrCast(self.vtable)).GetNameAt(@as(*const INamedPropertyStore, @ptrCast(self)), iProp, pbstrName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const GETPROPERTYSTOREFLAGS = enum(i32) {
    DEFAULT = 0,
    HANDLERPROPERTIESONLY = 1,
    READWRITE = 2,
    TEMPORARY = 4,
    FASTPROPERTIESONLY = 8,
    OPENSLOWITEM = 16,
    DELAYCREATION = 32,
    BESTEFFORT = 64,
    NO_OPLOCK = 128,
    PREFERQUERYPROPERTIES = 256,
    EXTRINSICPROPERTIES = 512,
    EXTRINSICPROPERTIESONLY = 1024,
    VOLATILEPROPERTIES = 2048,
    VOLATILEPROPERTIESONLY = 4096,
    MASK_VALID = 8191,
};
pub const GPS_DEFAULT = GETPROPERTYSTOREFLAGS.DEFAULT;
pub const GPS_HANDLERPROPERTIESONLY = GETPROPERTYSTOREFLAGS.HANDLERPROPERTIESONLY;
pub const GPS_READWRITE = GETPROPERTYSTOREFLAGS.READWRITE;
pub const GPS_TEMPORARY = GETPROPERTYSTOREFLAGS.TEMPORARY;
pub const GPS_FASTPROPERTIESONLY = GETPROPERTYSTOREFLAGS.FASTPROPERTIESONLY;
pub const GPS_OPENSLOWITEM = GETPROPERTYSTOREFLAGS.OPENSLOWITEM;
pub const GPS_DELAYCREATION = GETPROPERTYSTOREFLAGS.DELAYCREATION;
pub const GPS_BESTEFFORT = GETPROPERTYSTOREFLAGS.BESTEFFORT;
pub const GPS_NO_OPLOCK = GETPROPERTYSTOREFLAGS.NO_OPLOCK;
pub const GPS_PREFERQUERYPROPERTIES = GETPROPERTYSTOREFLAGS.PREFERQUERYPROPERTIES;
pub const GPS_EXTRINSICPROPERTIES = GETPROPERTYSTOREFLAGS.EXTRINSICPROPERTIES;
pub const GPS_EXTRINSICPROPERTIESONLY = GETPROPERTYSTOREFLAGS.EXTRINSICPROPERTIESONLY;
pub const GPS_VOLATILEPROPERTIES = GETPROPERTYSTOREFLAGS.VOLATILEPROPERTIES;
pub const GPS_VOLATILEPROPERTIESONLY = GETPROPERTYSTOREFLAGS.VOLATILEPROPERTIESONLY;
pub const GPS_MASK_VALID = GETPROPERTYSTOREFLAGS.MASK_VALID;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IObjectWithPropertyKey_Value = Guid.initString("fc0ca0a7-c316-4fd2-9031-3e628e6d4f23");
pub const IID_IObjectWithPropertyKey = &IID_IObjectWithPropertyKey_Value;
pub const IObjectWithPropertyKey = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetPropertyKey: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IObjectWithPropertyKey,
                key: ?*const PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IObjectWithPropertyKey,
                key: ?*const PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyKey: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IObjectWithPropertyKey,
                pkey: ?*PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IObjectWithPropertyKey,
                pkey: ?*PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IObjectWithPropertyKey_SetPropertyKey(self: *const T, key: ?*const PROPERTYKEY) HRESULT {
                return @as(*const IObjectWithPropertyKey.VTable, @ptrCast(self.vtable)).SetPropertyKey(@as(*const IObjectWithPropertyKey, @ptrCast(self)), key);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IObjectWithPropertyKey_GetPropertyKey(self: *const T, pkey: ?*PROPERTYKEY) HRESULT {
                return @as(*const IObjectWithPropertyKey.VTable, @ptrCast(self.vtable)).GetPropertyKey(@as(*const IObjectWithPropertyKey, @ptrCast(self)), pkey);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PKA_FLAGS = enum(i32) {
    SET = 0,
    APPEND = 1,
    DELETE = 2,
};
pub const PKA_SET = PKA_FLAGS.SET;
pub const PKA_APPEND = PKA_FLAGS.APPEND;
pub const PKA_DELETE = PKA_FLAGS.DELETE;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyChange_Value = Guid.initString("f917bc8a-1bba-4478-a245-1bde03eb9431");
pub const IID_IPropertyChange = &IID_IPropertyChange_Value;
pub const IPropertyChange = extern struct {
    pub const VTable = extern struct {
        base: IObjectWithPropertyKey.VTable,
        ApplyToPropVariant: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChange,
                propvarIn: ?*const PROPVARIANT,
                ppropvarOut: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChange,
                propvarIn: ?*const PROPVARIANT,
                ppropvarOut: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IObjectWithPropertyKey.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChange_ApplyToPropVariant(self: *const T, propvarIn: ?*const PROPVARIANT, ppropvarOut: ?*PROPVARIANT) HRESULT {
                return @as(*const IPropertyChange.VTable, @ptrCast(self.vtable)).ApplyToPropVariant(@as(*const IPropertyChange, @ptrCast(self)), propvarIn, ppropvarOut);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyChangeArray_Value = Guid.initString("380f5cad-1b5e-42f2-805d-637fd392d31e");
pub const IID_IPropertyChangeArray = &IID_IPropertyChangeArray_Value;
pub const IPropertyChangeArray = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                pcOperations: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                pcOperations: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                iIndex: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                iIndex: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InsertAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                iIndex: u32,
                ppropChange: ?*IPropertyChange,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                iIndex: u32,
                ppropChange: ?*IPropertyChange,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Append: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                ppropChange: ?*IPropertyChange,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                ppropChange: ?*IPropertyChange,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AppendOrReplace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                ppropChange: ?*IPropertyChange,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                ppropChange: ?*IPropertyChange,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                iIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                iIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsKeyInArray: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyChangeArray,
                key: ?*const PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyChangeArray,
                key: ?*const PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_GetCount(self: *const T, pcOperations: ?*u32) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).GetCount(@as(*const IPropertyChangeArray, @ptrCast(self)), pcOperations);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_GetAt(self: *const T, iIndex: u32, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).GetAt(@as(*const IPropertyChangeArray, @ptrCast(self)), iIndex, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_InsertAt(self: *const T, iIndex: u32, ppropChange: ?*IPropertyChange) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).InsertAt(@as(*const IPropertyChangeArray, @ptrCast(self)), iIndex, ppropChange);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_Append(self: *const T, ppropChange: ?*IPropertyChange) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).Append(@as(*const IPropertyChangeArray, @ptrCast(self)), ppropChange);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_AppendOrReplace(self: *const T, ppropChange: ?*IPropertyChange) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).AppendOrReplace(@as(*const IPropertyChangeArray, @ptrCast(self)), ppropChange);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_RemoveAt(self: *const T, iIndex: u32) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).RemoveAt(@as(*const IPropertyChangeArray, @ptrCast(self)), iIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyChangeArray_IsKeyInArray(self: *const T, key: ?*const PROPERTYKEY) HRESULT {
                return @as(*const IPropertyChangeArray.VTable, @ptrCast(self.vtable)).IsKeyInArray(@as(*const IPropertyChangeArray, @ptrCast(self)), key);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyStoreCapabilities_Value = Guid.initString("c8e2d566-186e-4d49-bf41-6909ead56acc");
pub const IID_IPropertyStoreCapabilities = &IID_IPropertyStoreCapabilities_Value;
pub const IPropertyStoreCapabilities = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        IsPropertyWritable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreCapabilities,
                key: ?*const PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreCapabilities,
                key: ?*const PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreCapabilities_IsPropertyWritable(self: *const T, key: ?*const PROPERTYKEY) HRESULT {
                return @as(*const IPropertyStoreCapabilities.VTable, @ptrCast(self.vtable)).IsPropertyWritable(@as(*const IPropertyStoreCapabilities, @ptrCast(self)), key);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PSC_STATE = enum(i32) {
    NORMAL = 0,
    NOTINSOURCE = 1,
    DIRTY = 2,
    READONLY = 3,
};
pub const PSC_NORMAL = PSC_STATE.NORMAL;
pub const PSC_NOTINSOURCE = PSC_STATE.NOTINSOURCE;
pub const PSC_DIRTY = PSC_STATE.DIRTY;
pub const PSC_READONLY = PSC_STATE.READONLY;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyStoreCache_Value = Guid.initString("3017056d-9a91-4e90-937d-746c72abbf4f");
pub const IID_IPropertyStoreCache = &IID_IPropertyStoreCache_Value;
pub const IPropertyStoreCache = extern struct {
    pub const VTable = extern struct {
        base: IPropertyStore.VTable,
        GetState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                pstate: ?*PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                pstate: ?*PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetValueAndState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                ppropvar: ?*PROPVARIANT,
                pstate: ?*PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                ppropvar: ?*PROPVARIANT,
                pstate: ?*PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                state: PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                state: PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetValueAndState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                ppropvar: ?*const PROPVARIANT,
                state: PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreCache,
                key: ?*const PROPERTYKEY,
                ppropvar: ?*const PROPVARIANT,
                state: PSC_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyStore.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreCache_GetState(self: *const T, key: ?*const PROPERTYKEY, pstate: ?*PSC_STATE) HRESULT {
                return @as(*const IPropertyStoreCache.VTable, @ptrCast(self.vtable)).GetState(@as(*const IPropertyStoreCache, @ptrCast(self)), key, pstate);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreCache_GetValueAndState(self: *const T, key: ?*const PROPERTYKEY, ppropvar: ?*PROPVARIANT, pstate: ?*PSC_STATE) HRESULT {
                return @as(*const IPropertyStoreCache.VTable, @ptrCast(self.vtable)).GetValueAndState(@as(*const IPropertyStoreCache, @ptrCast(self)), key, ppropvar, pstate);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreCache_SetState(self: *const T, key: ?*const PROPERTYKEY, state: PSC_STATE) HRESULT {
                return @as(*const IPropertyStoreCache.VTable, @ptrCast(self.vtable)).SetState(@as(*const IPropertyStoreCache, @ptrCast(self)), key, state);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreCache_SetValueAndState(self: *const T, key: ?*const PROPERTYKEY, ppropvar: ?*const PROPVARIANT, state: PSC_STATE) HRESULT {
                return @as(*const IPropertyStoreCache.VTable, @ptrCast(self.vtable)).SetValueAndState(@as(*const IPropertyStoreCache, @ptrCast(self)), key, ppropvar, state);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PROPENUMTYPE = enum(i32) {
    DISCRETEVALUE = 0,
    RANGEDVALUE = 1,
    DEFAULTVALUE = 2,
    ENDRANGE = 3,
};
pub const PET_DISCRETEVALUE = PROPENUMTYPE.DISCRETEVALUE;
pub const PET_RANGEDVALUE = PROPENUMTYPE.RANGEDVALUE;
pub const PET_DEFAULTVALUE = PROPENUMTYPE.DEFAULTVALUE;
pub const PET_ENDRANGE = PROPENUMTYPE.ENDRANGE;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyEnumType_Value = Guid.initString("11e1fbf9-2d56-4a6b-8db3-7cd193a471f2");
pub const IID_IPropertyEnumType = &IID_IPropertyEnumType_Value;
pub const IPropertyEnumType = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetEnumType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumType,
                penumtype: ?*PROPENUMTYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumType,
                penumtype: ?*PROPENUMTYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumType,
                ppropvar: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumType,
                ppropvar: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRangeMinValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumType,
                ppropvarMin: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumType,
                ppropvarMin: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRangeSetValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumType,
                ppropvarSet: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumType,
                ppropvarSet: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDisplayText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumType,
                ppszDisplay: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumType,
                ppszDisplay: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumType_GetEnumType(self: *const T, penumtype: ?*PROPENUMTYPE) HRESULT {
                return @as(*const IPropertyEnumType.VTable, @ptrCast(self.vtable)).GetEnumType(@as(*const IPropertyEnumType, @ptrCast(self)), penumtype);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumType_GetValue(self: *const T, ppropvar: ?*PROPVARIANT) HRESULT {
                return @as(*const IPropertyEnumType.VTable, @ptrCast(self.vtable)).GetValue(@as(*const IPropertyEnumType, @ptrCast(self)), ppropvar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumType_GetRangeMinValue(self: *const T, ppropvarMin: ?*PROPVARIANT) HRESULT {
                return @as(*const IPropertyEnumType.VTable, @ptrCast(self.vtable)).GetRangeMinValue(@as(*const IPropertyEnumType, @ptrCast(self)), ppropvarMin);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumType_GetRangeSetValue(self: *const T, ppropvarSet: ?*PROPVARIANT) HRESULT {
                return @as(*const IPropertyEnumType.VTable, @ptrCast(self.vtable)).GetRangeSetValue(@as(*const IPropertyEnumType, @ptrCast(self)), ppropvarSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumType_GetDisplayText(self: *const T, ppszDisplay: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyEnumType.VTable, @ptrCast(self.vtable)).GetDisplayText(@as(*const IPropertyEnumType, @ptrCast(self)), ppszDisplay);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IPropertyEnumType2_Value = Guid.initString("9b6e051c-5ddd-4321-9070-fe2acb55e794");
pub const IID_IPropertyEnumType2 = &IID_IPropertyEnumType2_Value;
pub const IPropertyEnumType2 = extern struct {
    pub const VTable = extern struct {
        base: IPropertyEnumType.VTable,
        GetImageReference: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumType2,
                ppszImageRes: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumType2,
                ppszImageRes: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyEnumType.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumType2_GetImageReference(self: *const T, ppszImageRes: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyEnumType2.VTable, @ptrCast(self.vtable)).GetImageReference(@as(*const IPropertyEnumType2, @ptrCast(self)), ppszImageRes);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyEnumTypeList_Value = Guid.initString("a99400f4-3d84-4557-94ba-1242fb2cc9a6");
pub const IID_IPropertyEnumTypeList = &IID_IPropertyEnumTypeList_Value;
pub const IPropertyEnumTypeList = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumTypeList,
                pctypes: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumTypeList,
                pctypes: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumTypeList,
                itype: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumTypeList,
                itype: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConditionAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumTypeList,
                nIndex: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumTypeList,
                nIndex: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FindMatchingIndex: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyEnumTypeList,
                propvarCmp: ?*const PROPVARIANT,
                pnIndex: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyEnumTypeList,
                propvarCmp: ?*const PROPVARIANT,
                pnIndex: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumTypeList_GetCount(self: *const T, pctypes: ?*u32) HRESULT {
                return @as(*const IPropertyEnumTypeList.VTable, @ptrCast(self.vtable)).GetCount(@as(*const IPropertyEnumTypeList, @ptrCast(self)), pctypes);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumTypeList_GetAt(self: *const T, itype: u32, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyEnumTypeList.VTable, @ptrCast(self.vtable)).GetAt(@as(*const IPropertyEnumTypeList, @ptrCast(self)), itype, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumTypeList_GetConditionAt(self: *const T, nIndex: u32, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyEnumTypeList.VTable, @ptrCast(self.vtable)).GetConditionAt(@as(*const IPropertyEnumTypeList, @ptrCast(self)), nIndex, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyEnumTypeList_FindMatchingIndex(self: *const T, propvarCmp: ?*const PROPVARIANT, pnIndex: ?*u32) HRESULT {
                return @as(*const IPropertyEnumTypeList.VTable, @ptrCast(self.vtable)).FindMatchingIndex(@as(*const IPropertyEnumTypeList, @ptrCast(self)), propvarCmp, pnIndex);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PROPDESC_TYPE_FLAGS = enum(i32) {
    DEFAULT = 0,
    MULTIPLEVALUES = 1,
    ISINNATE = 2,
    ISGROUP = 4,
    CANGROUPBY = 8,
    CANSTACKBY = 16,
    ISTREEPROPERTY = 32,
    INCLUDEINFULLTEXTQUERY = 64,
    ISVIEWABLE = 128,
    ISQUERYABLE = 256,
    CANBEPURGED = 512,
    SEARCHRAWVALUE = 1024,
    DONTCOERCEEMPTYSTRINGS = 2048,
    ALWAYSINSUPPLEMENTALSTORE = 4096,
    ISSYSTEMPROPERTY = -2147483648,
    MASK_ALL = -2147475457,
};
pub const PDTF_DEFAULT = PROPDESC_TYPE_FLAGS.DEFAULT;
pub const PDTF_MULTIPLEVALUES = PROPDESC_TYPE_FLAGS.MULTIPLEVALUES;
pub const PDTF_ISINNATE = PROPDESC_TYPE_FLAGS.ISINNATE;
pub const PDTF_ISGROUP = PROPDESC_TYPE_FLAGS.ISGROUP;
pub const PDTF_CANGROUPBY = PROPDESC_TYPE_FLAGS.CANGROUPBY;
pub const PDTF_CANSTACKBY = PROPDESC_TYPE_FLAGS.CANSTACKBY;
pub const PDTF_ISTREEPROPERTY = PROPDESC_TYPE_FLAGS.ISTREEPROPERTY;
pub const PDTF_INCLUDEINFULLTEXTQUERY = PROPDESC_TYPE_FLAGS.INCLUDEINFULLTEXTQUERY;
pub const PDTF_ISVIEWABLE = PROPDESC_TYPE_FLAGS.ISVIEWABLE;
pub const PDTF_ISQUERYABLE = PROPDESC_TYPE_FLAGS.ISQUERYABLE;
pub const PDTF_CANBEPURGED = PROPDESC_TYPE_FLAGS.CANBEPURGED;
pub const PDTF_SEARCHRAWVALUE = PROPDESC_TYPE_FLAGS.SEARCHRAWVALUE;
pub const PDTF_DONTCOERCEEMPTYSTRINGS = PROPDESC_TYPE_FLAGS.DONTCOERCEEMPTYSTRINGS;
pub const PDTF_ALWAYSINSUPPLEMENTALSTORE = PROPDESC_TYPE_FLAGS.ALWAYSINSUPPLEMENTALSTORE;
pub const PDTF_ISSYSTEMPROPERTY = PROPDESC_TYPE_FLAGS.ISSYSTEMPROPERTY;
pub const PDTF_MASK_ALL = PROPDESC_TYPE_FLAGS.MASK_ALL;

pub const PROPDESC_VIEW_FLAGS = enum(i32) {
    DEFAULT = 0,
    CENTERALIGN = 1,
    RIGHTALIGN = 2,
    BEGINNEWGROUP = 4,
    FILLAREA = 8,
    SORTDESCENDING = 16,
    SHOWONLYIFPRESENT = 32,
    SHOWBYDEFAULT = 64,
    SHOWINPRIMARYLIST = 128,
    SHOWINSECONDARYLIST = 256,
    HIDELABEL = 512,
    HIDDEN = 2048,
    CANWRAP = 4096,
    MASK_ALL = 7167,
};
pub const PDVF_DEFAULT = PROPDESC_VIEW_FLAGS.DEFAULT;
pub const PDVF_CENTERALIGN = PROPDESC_VIEW_FLAGS.CENTERALIGN;
pub const PDVF_RIGHTALIGN = PROPDESC_VIEW_FLAGS.RIGHTALIGN;
pub const PDVF_BEGINNEWGROUP = PROPDESC_VIEW_FLAGS.BEGINNEWGROUP;
pub const PDVF_FILLAREA = PROPDESC_VIEW_FLAGS.FILLAREA;
pub const PDVF_SORTDESCENDING = PROPDESC_VIEW_FLAGS.SORTDESCENDING;
pub const PDVF_SHOWONLYIFPRESENT = PROPDESC_VIEW_FLAGS.SHOWONLYIFPRESENT;
pub const PDVF_SHOWBYDEFAULT = PROPDESC_VIEW_FLAGS.SHOWBYDEFAULT;
pub const PDVF_SHOWINPRIMARYLIST = PROPDESC_VIEW_FLAGS.SHOWINPRIMARYLIST;
pub const PDVF_SHOWINSECONDARYLIST = PROPDESC_VIEW_FLAGS.SHOWINSECONDARYLIST;
pub const PDVF_HIDELABEL = PROPDESC_VIEW_FLAGS.HIDELABEL;
pub const PDVF_HIDDEN = PROPDESC_VIEW_FLAGS.HIDDEN;
pub const PDVF_CANWRAP = PROPDESC_VIEW_FLAGS.CANWRAP;
pub const PDVF_MASK_ALL = PROPDESC_VIEW_FLAGS.MASK_ALL;

pub const PROPDESC_DISPLAYTYPE = enum(i32) {
    STRING = 0,
    NUMBER = 1,
    BOOLEAN = 2,
    DATETIME = 3,
    ENUMERATED = 4,
};
pub const PDDT_STRING = PROPDESC_DISPLAYTYPE.STRING;
pub const PDDT_NUMBER = PROPDESC_DISPLAYTYPE.NUMBER;
pub const PDDT_BOOLEAN = PROPDESC_DISPLAYTYPE.BOOLEAN;
pub const PDDT_DATETIME = PROPDESC_DISPLAYTYPE.DATETIME;
pub const PDDT_ENUMERATED = PROPDESC_DISPLAYTYPE.ENUMERATED;

pub const PROPDESC_GROUPING_RANGE = enum(i32) {
    DISCRETE = 0,
    ALPHANUMERIC = 1,
    SIZE = 2,
    DYNAMIC = 3,
    DATE = 4,
    PERCENT = 5,
    ENUMERATED = 6,
};
pub const PDGR_DISCRETE = PROPDESC_GROUPING_RANGE.DISCRETE;
pub const PDGR_ALPHANUMERIC = PROPDESC_GROUPING_RANGE.ALPHANUMERIC;
pub const PDGR_SIZE = PROPDESC_GROUPING_RANGE.SIZE;
pub const PDGR_DYNAMIC = PROPDESC_GROUPING_RANGE.DYNAMIC;
pub const PDGR_DATE = PROPDESC_GROUPING_RANGE.DATE;
pub const PDGR_PERCENT = PROPDESC_GROUPING_RANGE.PERCENT;
pub const PDGR_ENUMERATED = PROPDESC_GROUPING_RANGE.ENUMERATED;

pub const PROPDESC_FORMAT_FLAGS = enum(i32) {
    DEFAULT = 0,
    PREFIXNAME = 1,
    FILENAME = 2,
    ALWAYSKB = 4,
    RESERVED_RIGHTTOLEFT = 8,
    SHORTTIME = 16,
    LONGTIME = 32,
    HIDETIME = 64,
    SHORTDATE = 128,
    LONGDATE = 256,
    HIDEDATE = 512,
    RELATIVEDATE = 1024,
    USEEDITINVITATION = 2048,
    READONLY = 4096,
    NOAUTOREADINGORDER = 8192,
};
pub const PDFF_DEFAULT = PROPDESC_FORMAT_FLAGS.DEFAULT;
pub const PDFF_PREFIXNAME = PROPDESC_FORMAT_FLAGS.PREFIXNAME;
pub const PDFF_FILENAME = PROPDESC_FORMAT_FLAGS.FILENAME;
pub const PDFF_ALWAYSKB = PROPDESC_FORMAT_FLAGS.ALWAYSKB;
pub const PDFF_RESERVED_RIGHTTOLEFT = PROPDESC_FORMAT_FLAGS.RESERVED_RIGHTTOLEFT;
pub const PDFF_SHORTTIME = PROPDESC_FORMAT_FLAGS.SHORTTIME;
pub const PDFF_LONGTIME = PROPDESC_FORMAT_FLAGS.LONGTIME;
pub const PDFF_HIDETIME = PROPDESC_FORMAT_FLAGS.HIDETIME;
pub const PDFF_SHORTDATE = PROPDESC_FORMAT_FLAGS.SHORTDATE;
pub const PDFF_LONGDATE = PROPDESC_FORMAT_FLAGS.LONGDATE;
pub const PDFF_HIDEDATE = PROPDESC_FORMAT_FLAGS.HIDEDATE;
pub const PDFF_RELATIVEDATE = PROPDESC_FORMAT_FLAGS.RELATIVEDATE;
pub const PDFF_USEEDITINVITATION = PROPDESC_FORMAT_FLAGS.USEEDITINVITATION;
pub const PDFF_READONLY = PROPDESC_FORMAT_FLAGS.READONLY;
pub const PDFF_NOAUTOREADINGORDER = PROPDESC_FORMAT_FLAGS.NOAUTOREADINGORDER;

pub const PROPDESC_SORTDESCRIPTION = enum(i32) {
    GENERAL = 0,
    A_Z = 1,
    LOWEST_HIGHEST = 2,
    SMALLEST_BIGGEST = 3,
    OLDEST_NEWEST = 4,
};
pub const PDSD_GENERAL = PROPDESC_SORTDESCRIPTION.GENERAL;
pub const PDSD_A_Z = PROPDESC_SORTDESCRIPTION.A_Z;
pub const PDSD_LOWEST_HIGHEST = PROPDESC_SORTDESCRIPTION.LOWEST_HIGHEST;
pub const PDSD_SMALLEST_BIGGEST = PROPDESC_SORTDESCRIPTION.SMALLEST_BIGGEST;
pub const PDSD_OLDEST_NEWEST = PROPDESC_SORTDESCRIPTION.OLDEST_NEWEST;

pub const PROPDESC_RELATIVEDESCRIPTION_TYPE = enum(i32) {
    GENERAL = 0,
    DATE = 1,
    SIZE = 2,
    COUNT = 3,
    REVISION = 4,
    LENGTH = 5,
    DURATION = 6,
    SPEED = 7,
    RATE = 8,
    RATING = 9,
    PRIORITY = 10,
};
pub const PDRDT_GENERAL = PROPDESC_RELATIVEDESCRIPTION_TYPE.GENERAL;
pub const PDRDT_DATE = PROPDESC_RELATIVEDESCRIPTION_TYPE.DATE;
pub const PDRDT_SIZE = PROPDESC_RELATIVEDESCRIPTION_TYPE.SIZE;
pub const PDRDT_COUNT = PROPDESC_RELATIVEDESCRIPTION_TYPE.COUNT;
pub const PDRDT_REVISION = PROPDESC_RELATIVEDESCRIPTION_TYPE.REVISION;
pub const PDRDT_LENGTH = PROPDESC_RELATIVEDESCRIPTION_TYPE.LENGTH;
pub const PDRDT_DURATION = PROPDESC_RELATIVEDESCRIPTION_TYPE.DURATION;
pub const PDRDT_SPEED = PROPDESC_RELATIVEDESCRIPTION_TYPE.SPEED;
pub const PDRDT_RATE = PROPDESC_RELATIVEDESCRIPTION_TYPE.RATE;
pub const PDRDT_RATING = PROPDESC_RELATIVEDESCRIPTION_TYPE.RATING;
pub const PDRDT_PRIORITY = PROPDESC_RELATIVEDESCRIPTION_TYPE.PRIORITY;

pub const PROPDESC_AGGREGATION_TYPE = enum(i32) {
    DEFAULT = 0,
    FIRST = 1,
    SUM = 2,
    AVERAGE = 3,
    DATERANGE = 4,
    UNION = 5,
    MAX = 6,
    MIN = 7,
};
pub const PDAT_DEFAULT = PROPDESC_AGGREGATION_TYPE.DEFAULT;
pub const PDAT_FIRST = PROPDESC_AGGREGATION_TYPE.FIRST;
pub const PDAT_SUM = PROPDESC_AGGREGATION_TYPE.SUM;
pub const PDAT_AVERAGE = PROPDESC_AGGREGATION_TYPE.AVERAGE;
pub const PDAT_DATERANGE = PROPDESC_AGGREGATION_TYPE.DATERANGE;
pub const PDAT_UNION = PROPDESC_AGGREGATION_TYPE.UNION;
pub const PDAT_MAX = PROPDESC_AGGREGATION_TYPE.MAX;
pub const PDAT_MIN = PROPDESC_AGGREGATION_TYPE.MIN;

pub const PROPDESC_CONDITION_TYPE = enum(i32) {
    NONE = 0,
    STRING = 1,
    SIZE = 2,
    DATETIME = 3,
    BOOLEAN = 4,
    NUMBER = 5,
};
pub const PDCOT_NONE = PROPDESC_CONDITION_TYPE.NONE;
pub const PDCOT_STRING = PROPDESC_CONDITION_TYPE.STRING;
pub const PDCOT_SIZE = PROPDESC_CONDITION_TYPE.SIZE;
pub const PDCOT_DATETIME = PROPDESC_CONDITION_TYPE.DATETIME;
pub const PDCOT_BOOLEAN = PROPDESC_CONDITION_TYPE.BOOLEAN;
pub const PDCOT_NUMBER = PROPDESC_CONDITION_TYPE.NUMBER;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyDescription_Value = Guid.initString("6f79d558-3e96-4549-a1d1-7d75d2288814");
pub const IID_IPropertyDescription = &IID_IPropertyDescription_Value;
pub const IPropertyDescription = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetPropertyKey: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pkey: ?*PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pkey: ?*PROPERTYKEY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCanonicalName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                ppszName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                ppszName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pvartype: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pvartype: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDisplayName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                ppszName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                ppszName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEditInvitation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                ppszInvite: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                ppszInvite: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTypeFlags: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                mask: PROPDESC_TYPE_FLAGS,
                ppdtFlags: ?*PROPDESC_TYPE_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                mask: PROPDESC_TYPE_FLAGS,
                ppdtFlags: ?*PROPDESC_TYPE_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetViewFlags: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                ppdvFlags: ?*PROPDESC_VIEW_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                ppdvFlags: ?*PROPDESC_VIEW_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDefaultColumnWidth: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pcxChars: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pcxChars: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDisplayType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pdisplaytype: ?*PROPDESC_DISPLAYTYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pdisplaytype: ?*PROPDESC_DISPLAYTYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetColumnState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pcsFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pcsFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetGroupingRange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pgr: ?*PROPDESC_GROUPING_RANGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pgr: ?*PROPDESC_GROUPING_RANGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRelativeDescriptionType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                prdt: ?*PROPDESC_RELATIVEDESCRIPTION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                prdt: ?*PROPDESC_RELATIVEDESCRIPTION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRelativeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                propvar1: ?*const PROPVARIANT,
                propvar2: ?*const PROPVARIANT,
                ppszDesc1: ?*?PWSTR,
                ppszDesc2: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                propvar1: ?*const PROPVARIANT,
                propvar2: ?*const PROPVARIANT,
                ppszDesc1: ?*?PWSTR,
                ppszDesc2: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSortDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                psd: ?*PROPDESC_SORTDESCRIPTION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                psd: ?*PROPDESC_SORTDESCRIPTION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSortDescriptionLabel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                fDescending: BOOL,
                ppszDescription: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                fDescending: BOOL,
                ppszDescription: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAggregationType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                paggtype: ?*PROPDESC_AGGREGATION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                paggtype: ?*PROPDESC_AGGREGATION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConditionType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                pcontype: ?*PROPDESC_CONDITION_TYPE,
                popDefault: ?*CONDITION_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                pcontype: ?*PROPDESC_CONDITION_TYPE,
                popDefault: ?*CONDITION_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEnumTypeList: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CoerceToCanonicalValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                ppropvar: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                ppropvar: ?*PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FormatForDisplay: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                propvar: ?*const PROPVARIANT,
                pdfFlags: PROPDESC_FORMAT_FLAGS,
                ppszDisplay: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                propvar: ?*const PROPVARIANT,
                pdfFlags: PROPDESC_FORMAT_FLAGS,
                ppszDisplay: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsValueCanonical: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription,
                propvar: ?*const PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription,
                propvar: ?*const PROPVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetPropertyKey(self: *const T, pkey: ?*PROPERTYKEY) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetPropertyKey(@as(*const IPropertyDescription, @ptrCast(self)), pkey);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetCanonicalName(self: *const T, ppszName: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetCanonicalName(@as(*const IPropertyDescription, @ptrCast(self)), ppszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetPropertyType(self: *const T, pvartype: ?*u16) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetPropertyType(@as(*const IPropertyDescription, @ptrCast(self)), pvartype);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetDisplayName(self: *const T, ppszName: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetDisplayName(@as(*const IPropertyDescription, @ptrCast(self)), ppszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetEditInvitation(self: *const T, ppszInvite: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetEditInvitation(@as(*const IPropertyDescription, @ptrCast(self)), ppszInvite);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetTypeFlags(self: *const T, mask: PROPDESC_TYPE_FLAGS, ppdtFlags: ?*PROPDESC_TYPE_FLAGS) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetTypeFlags(@as(*const IPropertyDescription, @ptrCast(self)), mask, ppdtFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetViewFlags(self: *const T, ppdvFlags: ?*PROPDESC_VIEW_FLAGS) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetViewFlags(@as(*const IPropertyDescription, @ptrCast(self)), ppdvFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetDefaultColumnWidth(self: *const T, pcxChars: ?*u32) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetDefaultColumnWidth(@as(*const IPropertyDescription, @ptrCast(self)), pcxChars);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetDisplayType(self: *const T, pdisplaytype: ?*PROPDESC_DISPLAYTYPE) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetDisplayType(@as(*const IPropertyDescription, @ptrCast(self)), pdisplaytype);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetColumnState(self: *const T, pcsFlags: ?*u32) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetColumnState(@as(*const IPropertyDescription, @ptrCast(self)), pcsFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetGroupingRange(self: *const T, pgr: ?*PROPDESC_GROUPING_RANGE) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetGroupingRange(@as(*const IPropertyDescription, @ptrCast(self)), pgr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetRelativeDescriptionType(self: *const T, prdt: ?*PROPDESC_RELATIVEDESCRIPTION_TYPE) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetRelativeDescriptionType(@as(*const IPropertyDescription, @ptrCast(self)), prdt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetRelativeDescription(self: *const T, propvar1: ?*const PROPVARIANT, propvar2: ?*const PROPVARIANT, ppszDesc1: ?*?PWSTR, ppszDesc2: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetRelativeDescription(@as(*const IPropertyDescription, @ptrCast(self)), propvar1, propvar2, ppszDesc1, ppszDesc2);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetSortDescription(self: *const T, psd: ?*PROPDESC_SORTDESCRIPTION) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetSortDescription(@as(*const IPropertyDescription, @ptrCast(self)), psd);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetSortDescriptionLabel(self: *const T, fDescending: BOOL, ppszDescription: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetSortDescriptionLabel(@as(*const IPropertyDescription, @ptrCast(self)), fDescending, ppszDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetAggregationType(self: *const T, paggtype: ?*PROPDESC_AGGREGATION_TYPE) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetAggregationType(@as(*const IPropertyDescription, @ptrCast(self)), paggtype);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetConditionType(self: *const T, pcontype: ?*PROPDESC_CONDITION_TYPE, popDefault: ?*CONDITION_OPERATION) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetConditionType(@as(*const IPropertyDescription, @ptrCast(self)), pcontype, popDefault);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_GetEnumTypeList(self: *const T, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).GetEnumTypeList(@as(*const IPropertyDescription, @ptrCast(self)), riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_CoerceToCanonicalValue(self: *const T, ppropvar: ?*PROPVARIANT) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).CoerceToCanonicalValue(@as(*const IPropertyDescription, @ptrCast(self)), ppropvar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_FormatForDisplay(self: *const T, propvar: ?*const PROPVARIANT, pdfFlags: PROPDESC_FORMAT_FLAGS, ppszDisplay: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).FormatForDisplay(@as(*const IPropertyDescription, @ptrCast(self)), propvar, pdfFlags, ppszDisplay);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription_IsValueCanonical(self: *const T, propvar: ?*const PROPVARIANT) HRESULT {
                return @as(*const IPropertyDescription.VTable, @ptrCast(self.vtable)).IsValueCanonical(@as(*const IPropertyDescription, @ptrCast(self)), propvar);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IPropertyDescription2_Value = Guid.initString("57d2eded-5062-400e-b107-5dae79fe57a6");
pub const IID_IPropertyDescription2 = &IID_IPropertyDescription2_Value;
pub const IPropertyDescription2 = extern struct {
    pub const VTable = extern struct {
        base: IPropertyDescription.VTable,
        GetImageReferenceForValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescription2,
                propvar: ?*const PROPVARIANT,
                ppszImageRes: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescription2,
                propvar: ?*const PROPVARIANT,
                ppszImageRes: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyDescription.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescription2_GetImageReferenceForValue(self: *const T, propvar: ?*const PROPVARIANT, ppszImageRes: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescription2.VTable, @ptrCast(self.vtable)).GetImageReferenceForValue(@as(*const IPropertyDescription2, @ptrCast(self)), propvar, ppszImageRes);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyDescriptionAliasInfo_Value = Guid.initString("f67104fc-2af9-46fd-b32d-243c1404f3d1");
pub const IID_IPropertyDescriptionAliasInfo = &IID_IPropertyDescriptionAliasInfo_Value;
pub const IPropertyDescriptionAliasInfo = extern struct {
    pub const VTable = extern struct {
        base: IPropertyDescription.VTable,
        GetSortByAlias: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionAliasInfo,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionAliasInfo,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAdditionalSortByAliases: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionAliasInfo,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionAliasInfo,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyDescription.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionAliasInfo_GetSortByAlias(self: *const T, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyDescriptionAliasInfo.VTable, @ptrCast(self.vtable)).GetSortByAlias(@as(*const IPropertyDescriptionAliasInfo, @ptrCast(self)), riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionAliasInfo_GetAdditionalSortByAliases(self: *const T, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyDescriptionAliasInfo.VTable, @ptrCast(self.vtable)).GetAdditionalSortByAliases(@as(*const IPropertyDescriptionAliasInfo, @ptrCast(self)), riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PROPDESC_SEARCHINFO_FLAGS = enum(i32) {
    DEFAULT = 0,
    ININVERTEDINDEX = 1,
    ISCOLUMN = 2,
    ISCOLUMNSPARSE = 4,
    ALWAYSINCLUDE = 8,
    USEFORTYPEAHEAD = 16,
};
pub const PDSIF_DEFAULT = PROPDESC_SEARCHINFO_FLAGS.DEFAULT;
pub const PDSIF_ININVERTEDINDEX = PROPDESC_SEARCHINFO_FLAGS.ININVERTEDINDEX;
pub const PDSIF_ISCOLUMN = PROPDESC_SEARCHINFO_FLAGS.ISCOLUMN;
pub const PDSIF_ISCOLUMNSPARSE = PROPDESC_SEARCHINFO_FLAGS.ISCOLUMNSPARSE;
pub const PDSIF_ALWAYSINCLUDE = PROPDESC_SEARCHINFO_FLAGS.ALWAYSINCLUDE;
pub const PDSIF_USEFORTYPEAHEAD = PROPDESC_SEARCHINFO_FLAGS.USEFORTYPEAHEAD;

pub const PROPDESC_COLUMNINDEX_TYPE = enum(i32) {
    NONE = 0,
    ONDISK = 1,
    INMEMORY = 2,
    ONDEMAND = 3,
    ONDISKALL = 4,
    ONDISKVECTOR = 5,
};
pub const PDCIT_NONE = PROPDESC_COLUMNINDEX_TYPE.NONE;
pub const PDCIT_ONDISK = PROPDESC_COLUMNINDEX_TYPE.ONDISK;
pub const PDCIT_INMEMORY = PROPDESC_COLUMNINDEX_TYPE.INMEMORY;
pub const PDCIT_ONDEMAND = PROPDESC_COLUMNINDEX_TYPE.ONDEMAND;
pub const PDCIT_ONDISKALL = PROPDESC_COLUMNINDEX_TYPE.ONDISKALL;
pub const PDCIT_ONDISKVECTOR = PROPDESC_COLUMNINDEX_TYPE.ONDISKVECTOR;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyDescriptionSearchInfo_Value = Guid.initString("078f91bd-29a2-440f-924e-46a291524520");
pub const IID_IPropertyDescriptionSearchInfo = &IID_IPropertyDescriptionSearchInfo_Value;
pub const IPropertyDescriptionSearchInfo = extern struct {
    pub const VTable = extern struct {
        base: IPropertyDescription.VTable,
        GetSearchInfoFlags: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionSearchInfo,
                ppdsiFlags: ?*PROPDESC_SEARCHINFO_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionSearchInfo,
                ppdsiFlags: ?*PROPDESC_SEARCHINFO_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetColumnIndexType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionSearchInfo,
                ppdciType: ?*PROPDESC_COLUMNINDEX_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionSearchInfo,
                ppdciType: ?*PROPDESC_COLUMNINDEX_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProjectionString: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionSearchInfo,
                ppszProjection: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionSearchInfo,
                ppszProjection: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMaxSize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionSearchInfo,
                pcbMaxSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionSearchInfo,
                pcbMaxSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyDescription.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionSearchInfo_GetSearchInfoFlags(self: *const T, ppdsiFlags: ?*PROPDESC_SEARCHINFO_FLAGS) HRESULT {
                return @as(*const IPropertyDescriptionSearchInfo.VTable, @ptrCast(self.vtable)).GetSearchInfoFlags(@as(*const IPropertyDescriptionSearchInfo, @ptrCast(self)), ppdsiFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionSearchInfo_GetColumnIndexType(self: *const T, ppdciType: ?*PROPDESC_COLUMNINDEX_TYPE) HRESULT {
                return @as(*const IPropertyDescriptionSearchInfo.VTable, @ptrCast(self.vtable)).GetColumnIndexType(@as(*const IPropertyDescriptionSearchInfo, @ptrCast(self)), ppdciType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionSearchInfo_GetProjectionString(self: *const T, ppszProjection: ?*?PWSTR) HRESULT {
                return @as(*const IPropertyDescriptionSearchInfo.VTable, @ptrCast(self.vtable)).GetProjectionString(@as(*const IPropertyDescriptionSearchInfo, @ptrCast(self)), ppszProjection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionSearchInfo_GetMaxSize(self: *const T, pcbMaxSize: ?*u32) HRESULT {
                return @as(*const IPropertyDescriptionSearchInfo.VTable, @ptrCast(self.vtable)).GetMaxSize(@as(*const IPropertyDescriptionSearchInfo, @ptrCast(self)), pcbMaxSize);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IPropertyDescriptionRelatedPropertyInfo_Value = Guid.initString("507393f4-2a3d-4a60-b59e-d9c75716c2dd");
pub const IID_IPropertyDescriptionRelatedPropertyInfo = &IID_IPropertyDescriptionRelatedPropertyInfo_Value;
pub const IPropertyDescriptionRelatedPropertyInfo = extern struct {
    pub const VTable = extern struct {
        base: IPropertyDescription.VTable,
        GetRelatedProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionRelatedPropertyInfo,
                pszRelationshipName: ?[*:0]const u16,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionRelatedPropertyInfo,
                pszRelationshipName: ?[*:0]const u16,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyDescription.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionRelatedPropertyInfo_GetRelatedProperty(self: *const T, pszRelationshipName: ?[*:0]const u16, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyDescriptionRelatedPropertyInfo.VTable, @ptrCast(self.vtable)).GetRelatedProperty(@as(*const IPropertyDescriptionRelatedPropertyInfo, @ptrCast(self)), pszRelationshipName, riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PROPDESC_ENUMFILTER = enum(i32) {
    ALL = 0,
    SYSTEM = 1,
    NONSYSTEM = 2,
    VIEWABLE = 3,
    QUERYABLE = 4,
    INFULLTEXTQUERY = 5,
    COLUMN = 6,
};
pub const PDEF_ALL = PROPDESC_ENUMFILTER.ALL;
pub const PDEF_SYSTEM = PROPDESC_ENUMFILTER.SYSTEM;
pub const PDEF_NONSYSTEM = PROPDESC_ENUMFILTER.NONSYSTEM;
pub const PDEF_VIEWABLE = PROPDESC_ENUMFILTER.VIEWABLE;
pub const PDEF_QUERYABLE = PROPDESC_ENUMFILTER.QUERYABLE;
pub const PDEF_INFULLTEXTQUERY = PROPDESC_ENUMFILTER.INFULLTEXTQUERY;
pub const PDEF_COLUMN = PROPDESC_ENUMFILTER.COLUMN;

// TODO: this type is limited to platform 'windows5.1.2600'
const IID_IPropertySystem_Value = Guid.initString("ca724e8a-c3e6-442b-88a4-6fb0db8035a3");
pub const IID_IPropertySystem = &IID_IPropertySystem_Value;
pub const IPropertySystem = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetPropertyDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                propkey: ?*const PROPERTYKEY,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                propkey: ?*const PROPERTYKEY,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyDescriptionByName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                pszCanonicalName: ?[*:0]const u16,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                pszCanonicalName: ?[*:0]const u16,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyDescriptionListFromString: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                pszPropList: ?[*:0]const u16,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                pszPropList: ?[*:0]const u16,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EnumeratePropertyDescriptions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                filterOn: PROPDESC_ENUMFILTER,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                filterOn: PROPDESC_ENUMFILTER,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FormatForDisplay: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                key: ?*const PROPERTYKEY,
                propvar: ?*const PROPVARIANT,
                pdff: PROPDESC_FORMAT_FLAGS,
                pszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                key: ?*const PROPERTYKEY,
                propvar: ?*const PROPVARIANT,
                pdff: PROPDESC_FORMAT_FLAGS,
                pszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FormatForDisplayAlloc: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                key: ?*const PROPERTYKEY,
                propvar: ?*const PROPVARIANT,
                pdff: PROPDESC_FORMAT_FLAGS,
                ppszDisplay: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                key: ?*const PROPERTYKEY,
                propvar: ?*const PROPVARIANT,
                pdff: PROPDESC_FORMAT_FLAGS,
                ppszDisplay: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterPropertySchema: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnregisterPropertySchema: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RefreshPropertySchema: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_GetPropertyDescription(self: *const T, propkey: ?*const PROPERTYKEY, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).GetPropertyDescription(@as(*const IPropertySystem, @ptrCast(self)), propkey, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_GetPropertyDescriptionByName(self: *const T, pszCanonicalName: ?[*:0]const u16, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).GetPropertyDescriptionByName(@as(*const IPropertySystem, @ptrCast(self)), pszCanonicalName, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_GetPropertyDescriptionListFromString(self: *const T, pszPropList: ?[*:0]const u16, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).GetPropertyDescriptionListFromString(@as(*const IPropertySystem, @ptrCast(self)), pszPropList, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_EnumeratePropertyDescriptions(self: *const T, filterOn: PROPDESC_ENUMFILTER, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).EnumeratePropertyDescriptions(@as(*const IPropertySystem, @ptrCast(self)), filterOn, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_FormatForDisplay(self: *const T, key: ?*const PROPERTYKEY, propvar: ?*const PROPVARIANT, pdff: PROPDESC_FORMAT_FLAGS, pszText: [*:0]u16, cchText: u32) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).FormatForDisplay(@as(*const IPropertySystem, @ptrCast(self)), key, propvar, pdff, pszText, cchText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_FormatForDisplayAlloc(self: *const T, key: ?*const PROPERTYKEY, propvar: ?*const PROPVARIANT, pdff: PROPDESC_FORMAT_FLAGS, ppszDisplay: ?*?PWSTR) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).FormatForDisplayAlloc(@as(*const IPropertySystem, @ptrCast(self)), key, propvar, pdff, ppszDisplay);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_RegisterPropertySchema(self: *const T, pszPath: ?[*:0]const u16) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).RegisterPropertySchema(@as(*const IPropertySystem, @ptrCast(self)), pszPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_UnregisterPropertySchema(self: *const T, pszPath: ?[*:0]const u16) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).UnregisterPropertySchema(@as(*const IPropertySystem, @ptrCast(self)), pszPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystem_RefreshPropertySchema(self: *const T) HRESULT {
                return @as(*const IPropertySystem.VTable, @ptrCast(self.vtable)).RefreshPropertySchema(@as(*const IPropertySystem, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyDescriptionList_Value = Guid.initString("1f9fc1d0-c39b-4b26-817f-011967d3440e");
pub const IID_IPropertyDescriptionList = &IID_IPropertyDescriptionList_Value;
pub const IPropertyDescriptionList = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionList,
                pcElem: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionList,
                pcElem: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyDescriptionList,
                iElem: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyDescriptionList,
                iElem: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionList_GetCount(self: *const T, pcElem: ?*u32) HRESULT {
                return @as(*const IPropertyDescriptionList.VTable, @ptrCast(self.vtable)).GetCount(@as(*const IPropertyDescriptionList, @ptrCast(self)), pcElem);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyDescriptionList_GetAt(self: *const T, iElem: u32, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyDescriptionList.VTable, @ptrCast(self.vtable)).GetAt(@as(*const IPropertyDescriptionList, @ptrCast(self)), iElem, riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPropertyStoreFactory_Value = Guid.initString("bc110b6d-57e8-4148-a9c6-91015ab2f3a5");
pub const IID_IPropertyStoreFactory = &IID_IPropertyStoreFactory_Value;
pub const IPropertyStoreFactory = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetPropertyStore: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreFactory,
                flags: GETPROPERTYSTOREFLAGS,
                pUnkFactory: ?*IUnknown,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreFactory,
                flags: GETPROPERTYSTOREFLAGS,
                pUnkFactory: ?*IUnknown,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyStoreForKeys: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyStoreFactory,
                rgKeys: ?*const PROPERTYKEY,
                cKeys: u32,
                flags: GETPROPERTYSTOREFLAGS,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyStoreFactory,
                rgKeys: ?*const PROPERTYKEY,
                cKeys: u32,
                flags: GETPROPERTYSTOREFLAGS,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreFactory_GetPropertyStore(self: *const T, flags: GETPROPERTYSTOREFLAGS, pUnkFactory: ?*IUnknown, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyStoreFactory.VTable, @ptrCast(self.vtable)).GetPropertyStore(@as(*const IPropertyStoreFactory, @ptrCast(self)), flags, pUnkFactory, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyStoreFactory_GetPropertyStoreForKeys(self: *const T, rgKeys: ?*const PROPERTYKEY, cKeys: u32, flags: GETPROPERTYSTOREFLAGS, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IPropertyStoreFactory.VTable, @ptrCast(self.vtable)).GetPropertyStoreForKeys(@as(*const IPropertyStoreFactory, @ptrCast(self)), rgKeys, cKeys, flags, riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IDelayedPropertyStoreFactory_Value = Guid.initString("40d4577f-e237-4bdb-bd69-58f089431b6a");
pub const IID_IDelayedPropertyStoreFactory = &IID_IDelayedPropertyStoreFactory_Value;
pub const IDelayedPropertyStoreFactory = extern struct {
    pub const VTable = extern struct {
        base: IPropertyStoreFactory.VTable,
        GetDelayedPropertyStore: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDelayedPropertyStoreFactory,
                flags: GETPROPERTYSTOREFLAGS,
                dwStoreId: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDelayedPropertyStoreFactory,
                flags: GETPROPERTYSTOREFLAGS,
                dwStoreId: u32,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPropertyStoreFactory.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDelayedPropertyStoreFactory_GetDelayedPropertyStore(self: *const T, flags: GETPROPERTYSTOREFLAGS, dwStoreId: u32, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDelayedPropertyStoreFactory.VTable, @ptrCast(self.vtable)).GetDelayedPropertyStore(@as(*const IDelayedPropertyStoreFactory, @ptrCast(self)), flags, dwStoreId, riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const _PERSIST_SPROPSTORE_FLAGS = enum(i32) {
    DEFAULT = 0,
    READONLY = 1,
    TREAT_NEW_VALUES_AS_DIRTY = 2,
};
pub const FPSPS_DEFAULT = _PERSIST_SPROPSTORE_FLAGS.DEFAULT;
pub const FPSPS_READONLY = _PERSIST_SPROPSTORE_FLAGS.READONLY;
pub const FPSPS_TREAT_NEW_VALUES_AS_DIRTY = _PERSIST_SPROPSTORE_FLAGS.TREAT_NEW_VALUES_AS_DIRTY;

pub const SERIALIZEDPROPSTORAGE = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IPersistSerializedPropStorage_Value = Guid.initString("e318ad57-0aa0-450f-aca5-6fab7103d917");
pub const IID_IPersistSerializedPropStorage = &IID_IPersistSerializedPropStorage_Value;
pub const IPersistSerializedPropStorage = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetFlags: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPersistSerializedPropStorage,
                flags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPersistSerializedPropStorage,
                flags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPropertyStorage: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPersistSerializedPropStorage,
                // TODO: what to do with BytesParamIndex 1?
                psps: ?*SERIALIZEDPROPSTORAGE,
                cb: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPersistSerializedPropStorage,
                // TODO: what to do with BytesParamIndex 1?
                psps: ?*SERIALIZEDPROPSTORAGE,
                cb: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyStorage: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPersistSerializedPropStorage,
                ppsps: ?*?*SERIALIZEDPROPSTORAGE,
                pcb: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPersistSerializedPropStorage,
                ppsps: ?*?*SERIALIZEDPROPSTORAGE,
                pcb: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPersistSerializedPropStorage_SetFlags(self: *const T, flags: i32) HRESULT {
                return @as(*const IPersistSerializedPropStorage.VTable, @ptrCast(self.vtable)).SetFlags(@as(*const IPersistSerializedPropStorage, @ptrCast(self)), flags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPersistSerializedPropStorage_SetPropertyStorage(self: *const T, psps: ?*SERIALIZEDPROPSTORAGE, cb: u32) HRESULT {
                return @as(*const IPersistSerializedPropStorage.VTable, @ptrCast(self.vtable)).SetPropertyStorage(@as(*const IPersistSerializedPropStorage, @ptrCast(self)), psps, cb);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPersistSerializedPropStorage_GetPropertyStorage(self: *const T, ppsps: ?*?*SERIALIZEDPROPSTORAGE, pcb: ?*u32) HRESULT {
                return @as(*const IPersistSerializedPropStorage.VTable, @ptrCast(self.vtable)).GetPropertyStorage(@as(*const IPersistSerializedPropStorage, @ptrCast(self)), ppsps, pcb);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IPersistSerializedPropStorage2_Value = Guid.initString("77effa68-4f98-4366-ba72-573b3d880571");
pub const IID_IPersistSerializedPropStorage2 = &IID_IPersistSerializedPropStorage2_Value;
pub const IPersistSerializedPropStorage2 = extern struct {
    pub const VTable = extern struct {
        base: IPersistSerializedPropStorage.VTable,
        GetPropertyStorageSize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPersistSerializedPropStorage2,
                pcb: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPersistSerializedPropStorage2,
                pcb: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyStorageBuffer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPersistSerializedPropStorage2,
                // TODO: what to do with BytesParamIndex 1?
                psps: ?*SERIALIZEDPROPSTORAGE,
                cb: u32,
                pcbWritten: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPersistSerializedPropStorage2,
                // TODO: what to do with BytesParamIndex 1?
                psps: ?*SERIALIZEDPROPSTORAGE,
                cb: u32,
                pcbWritten: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IPersistSerializedPropStorage.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPersistSerializedPropStorage2_GetPropertyStorageSize(self: *const T, pcb: ?*u32) HRESULT {
                return @as(*const IPersistSerializedPropStorage2.VTable, @ptrCast(self.vtable)).GetPropertyStorageSize(@as(*const IPersistSerializedPropStorage2, @ptrCast(self)), pcb);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPersistSerializedPropStorage2_GetPropertyStorageBuffer(self: *const T, psps: ?*SERIALIZEDPROPSTORAGE, cb: u32, pcbWritten: ?*u32) HRESULT {
                return @as(*const IPersistSerializedPropStorage2.VTable, @ptrCast(self.vtable)).GetPropertyStorageBuffer(@as(*const IPersistSerializedPropStorage2, @ptrCast(self)), psps, cb, pcbWritten);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IPropertySystemChangeNotify_Value = Guid.initString("fa955fd9-38be-4879-a6ce-824cf52d609f");
pub const IID_IPropertySystemChangeNotify = &IID_IPropertySystemChangeNotify_Value;
pub const IPropertySystemChangeNotify = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SchemaRefreshed: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertySystemChangeNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertySystemChangeNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertySystemChangeNotify_SchemaRefreshed(self: *const T) HRESULT {
                return @as(*const IPropertySystemChangeNotify.VTable, @ptrCast(self.vtable)).SchemaRefreshed(@as(*const IPropertySystemChangeNotify, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_ICreateObject_Value = Guid.initString("75121952-e0d0-43e5-9380-1d80483acf72");
pub const IID_ICreateObject = &IID_ICreateObject_Value;
pub const ICreateObject = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateObject: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ICreateObject,
                clsid: ?*const Guid,
                pUnkOuter: ?*IUnknown,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ICreateObject,
                clsid: ?*const Guid,
                pUnkOuter: ?*IUnknown,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ICreateObject_CreateObject(self: *const T, clsid: ?*const Guid, pUnkOuter: ?*IUnknown, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const ICreateObject.VTable, @ptrCast(self.vtable)).CreateObject(@as(*const ICreateObject, @ptrCast(self)), clsid, pUnkOuter, riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PSTIME_FLAGS = enum(i32) {
    UTC = 0,
    LOCAL = 1,
};
pub const PSTF_UTC = PSTIME_FLAGS.UTC;
pub const PSTF_LOCAL = PSTIME_FLAGS.LOCAL;

pub const PROPVAR_COMPARE_UNIT = enum(i32) {
    DEFAULT = 0,
    SECOND = 1,
    MINUTE = 2,
    HOUR = 3,
    DAY = 4,
    MONTH = 5,
    YEAR = 6,
};
pub const PVCU_DEFAULT = PROPVAR_COMPARE_UNIT.DEFAULT;
pub const PVCU_SECOND = PROPVAR_COMPARE_UNIT.SECOND;
pub const PVCU_MINUTE = PROPVAR_COMPARE_UNIT.MINUTE;
pub const PVCU_HOUR = PROPVAR_COMPARE_UNIT.HOUR;
pub const PVCU_DAY = PROPVAR_COMPARE_UNIT.DAY;
pub const PVCU_MONTH = PROPVAR_COMPARE_UNIT.MONTH;
pub const PVCU_YEAR = PROPVAR_COMPARE_UNIT.YEAR;

pub const PROPVAR_COMPARE_FLAGS = enum(i32) {
    DEFAULT = 0,
    TREATEMPTYASGREATERTHAN = 1,
    USESTRCMP = 2,
    USESTRCMPC = 4,
    USESTRCMPI = 8,
    USESTRCMPIC = 16,
    DIGITSASNUMBERS_CASESENSITIVE = 32,
};
pub const PVCF_DEFAULT = PROPVAR_COMPARE_FLAGS.DEFAULT;
pub const PVCF_TREATEMPTYASGREATERTHAN = PROPVAR_COMPARE_FLAGS.TREATEMPTYASGREATERTHAN;
pub const PVCF_USESTRCMP = PROPVAR_COMPARE_FLAGS.USESTRCMP;
pub const PVCF_USESTRCMPC = PROPVAR_COMPARE_FLAGS.USESTRCMPC;
pub const PVCF_USESTRCMPI = PROPVAR_COMPARE_FLAGS.USESTRCMPI;
pub const PVCF_USESTRCMPIC = PROPVAR_COMPARE_FLAGS.USESTRCMPIC;
pub const PVCF_DIGITSASNUMBERS_CASESENSITIVE = PROPVAR_COMPARE_FLAGS.DIGITSASNUMBERS_CASESENSITIVE;

pub const PROPVAR_CHANGE_FLAGS = enum(i32) {
    DEFAULT = 0,
    NOVALUEPROP = 1,
    ALPHABOOL = 2,
    NOUSEROVERRIDE = 4,
    LOCALBOOL = 8,
    NOHEXSTRING = 16,
};
pub const PVCHF_DEFAULT = PROPVAR_CHANGE_FLAGS.DEFAULT;
pub const PVCHF_NOVALUEPROP = PROPVAR_CHANGE_FLAGS.NOVALUEPROP;
pub const PVCHF_ALPHABOOL = PROPVAR_CHANGE_FLAGS.ALPHABOOL;
pub const PVCHF_NOUSEROVERRIDE = PROPVAR_CHANGE_FLAGS.NOUSEROVERRIDE;
pub const PVCHF_LOCALBOOL = PROPVAR_CHANGE_FLAGS.LOCALBOOL;
pub const PVCHF_NOHEXSTRING = PROPVAR_CHANGE_FLAGS.NOHEXSTRING;

pub const DRAWPROGRESSFLAGS = enum(i32) {
    NONE = 0,
    MARQUEE = 1,
    MARQUEE_COMPLETE = 2,
    ERROR = 4,
    WARNING = 8,
    STOPPED = 16,
};
pub const DPF_NONE = DRAWPROGRESSFLAGS.NONE;
pub const DPF_MARQUEE = DRAWPROGRESSFLAGS.MARQUEE;
pub const DPF_MARQUEE_COMPLETE = DRAWPROGRESSFLAGS.MARQUEE_COMPLETE;
pub const DPF_ERROR = DRAWPROGRESSFLAGS.ERROR;
pub const DPF_WARNING = DRAWPROGRESSFLAGS.WARNING;
pub const DPF_STOPPED = DRAWPROGRESSFLAGS.STOPPED;

pub const SYNC_TRANSFER_STATUS = enum(i32) {
    NONE = 0,
    NEEDSUPLOAD = 1,
    NEEDSDOWNLOAD = 2,
    TRANSFERRING = 4,
    PAUSED = 8,
    HASERROR = 16,
    FETCHING_METADATA = 32,
    USER_REQUESTED_REFRESH = 64,
    HASWARNING = 128,
    EXCLUDED = 256,
    INCOMPLETE = 512,
    PLACEHOLDER_IFEMPTY = 1024,
};
pub const STS_NONE = SYNC_TRANSFER_STATUS.NONE;
pub const STS_NEEDSUPLOAD = SYNC_TRANSFER_STATUS.NEEDSUPLOAD;
pub const STS_NEEDSDOWNLOAD = SYNC_TRANSFER_STATUS.NEEDSDOWNLOAD;
pub const STS_TRANSFERRING = SYNC_TRANSFER_STATUS.TRANSFERRING;
pub const STS_PAUSED = SYNC_TRANSFER_STATUS.PAUSED;
pub const STS_HASERROR = SYNC_TRANSFER_STATUS.HASERROR;
pub const STS_FETCHING_METADATA = SYNC_TRANSFER_STATUS.FETCHING_METADATA;
pub const STS_USER_REQUESTED_REFRESH = SYNC_TRANSFER_STATUS.USER_REQUESTED_REFRESH;
pub const STS_HASWARNING = SYNC_TRANSFER_STATUS.HASWARNING;
pub const STS_EXCLUDED = SYNC_TRANSFER_STATUS.EXCLUDED;
pub const STS_INCOMPLETE = SYNC_TRANSFER_STATUS.INCOMPLETE;
pub const STS_PLACEHOLDER_IFEMPTY = SYNC_TRANSFER_STATUS.PLACEHOLDER_IFEMPTY;

pub const PLACEHOLDER_STATES = enum(i32) {
    NONE = 0,
    MARKED_FOR_OFFLINE_AVAILABILITY = 1,
    FULL_PRIMARY_STREAM_AVAILABLE = 2,
    CREATE_FILE_ACCESSIBLE = 4,
    CLOUDFILE_PLACEHOLDER = 8,
    DEFAULT = 7,
    ALL = 15,
};
pub const PS_NONE = PLACEHOLDER_STATES.NONE;
pub const PS_MARKED_FOR_OFFLINE_AVAILABILITY = PLACEHOLDER_STATES.MARKED_FOR_OFFLINE_AVAILABILITY;
pub const PS_FULL_PRIMARY_STREAM_AVAILABLE = PLACEHOLDER_STATES.FULL_PRIMARY_STREAM_AVAILABLE;
pub const PS_CREATE_FILE_ACCESSIBLE = PLACEHOLDER_STATES.CREATE_FILE_ACCESSIBLE;
pub const PS_CLOUDFILE_PLACEHOLDER = PLACEHOLDER_STATES.CLOUDFILE_PLACEHOLDER;
pub const PS_DEFAULT = PLACEHOLDER_STATES.DEFAULT;
pub const PS_ALL = PLACEHOLDER_STATES.ALL;

pub const PROPERTYUI_NAME_FLAGS = enum(i32) {
    DEFAULT = 0,
    MNEMONIC = 1,
};
pub const PUIFNF_DEFAULT = PROPERTYUI_NAME_FLAGS.DEFAULT;
pub const PUIFNF_MNEMONIC = PROPERTYUI_NAME_FLAGS.MNEMONIC;

pub const PROPERTYUI_FLAGS = enum(i32) {
    DEFAULT = 0,
    RIGHTALIGN = 1,
    NOLABELININFOTIP = 2,
};
pub const PUIF_DEFAULT = PROPERTYUI_FLAGS.DEFAULT;
pub const PUIF_RIGHTALIGN = PROPERTYUI_FLAGS.RIGHTALIGN;
pub const PUIF_NOLABELININFOTIP = PROPERTYUI_FLAGS.NOLABELININFOTIP;

pub const PROPERTYUI_FORMAT_FLAGS = enum(i32) {
    DEFAULT = 0,
    RIGHTTOLEFT = 1,
    SHORTFORMAT = 2,
    NOTIME = 4,
    FRIENDLYDATE = 8,
};
pub const PUIFFDF_DEFAULT = PROPERTYUI_FORMAT_FLAGS.DEFAULT;
pub const PUIFFDF_RIGHTTOLEFT = PROPERTYUI_FORMAT_FLAGS.RIGHTTOLEFT;
pub const PUIFFDF_SHORTFORMAT = PROPERTYUI_FORMAT_FLAGS.SHORTFORMAT;
pub const PUIFFDF_NOTIME = PROPERTYUI_FORMAT_FLAGS.NOTIME;
pub const PUIFFDF_FRIENDLYDATE = PROPERTYUI_FORMAT_FLAGS.FRIENDLYDATE;

// TODO: this type is limited to platform 'windows5.0'
const IID_IPropertyUI_Value = Guid.initString("757a7d9f-919a-4118-99d7-dbb208c8cc66");
pub const IID_IPropertyUI = &IID_IPropertyUI_Value;
pub const IPropertyUI = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ParsePropertyName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                pszName: ?[*:0]const u16,
                pfmtid: ?*Guid,
                ppid: ?*u32,
                pchEaten: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                pszName: ?[*:0]const u16,
                pfmtid: ?*Guid,
                ppid: ?*u32,
                pchEaten: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCannonicalName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDisplayName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                flags: PROPERTYUI_NAME_FLAGS,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                flags: PROPERTYUI_NAME_FLAGS,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDefaultWidth: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pcxChars: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pcxChars: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFlags: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pflags: ?*PROPERTYUI_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pflags: ?*PROPERTYUI_FLAGS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FormatForDisplay: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                ppropvar: ?*const PROPVARIANT,
                puiff: PROPERTYUI_FORMAT_FLAGS,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                ppropvar: ?*const PROPVARIANT,
                puiff: PROPERTYUI_FORMAT_FLAGS,
                pwszText: [*:0]u16,
                cchText: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetHelpInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pwszHelpFile: [*:0]u16,
                cch: u32,
                puHelpID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IPropertyUI,
                fmtid: ?*const Guid,
                pid: u32,
                pwszHelpFile: [*:0]u16,
                cch: u32,
                puHelpID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_ParsePropertyName(self: *const T, pszName: ?[*:0]const u16, pfmtid: ?*Guid, ppid: ?*u32, pchEaten: ?*u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).ParsePropertyName(@as(*const IPropertyUI, @ptrCast(self)), pszName, pfmtid, ppid, pchEaten);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_GetCannonicalName(self: *const T, fmtid: ?*const Guid, pid: u32, pwszText: [*:0]u16, cchText: u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).GetCannonicalName(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, pwszText, cchText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_GetDisplayName(self: *const T, fmtid: ?*const Guid, pid: u32, flags: PROPERTYUI_NAME_FLAGS, pwszText: [*:0]u16, cchText: u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).GetDisplayName(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, flags, pwszText, cchText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_GetPropertyDescription(self: *const T, fmtid: ?*const Guid, pid: u32, pwszText: [*:0]u16, cchText: u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).GetPropertyDescription(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, pwszText, cchText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_GetDefaultWidth(self: *const T, fmtid: ?*const Guid, pid: u32, pcxChars: ?*u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).GetDefaultWidth(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, pcxChars);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_GetFlags(self: *const T, fmtid: ?*const Guid, pid: u32, pflags: ?*PROPERTYUI_FLAGS) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).GetFlags(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, pflags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_FormatForDisplay(self: *const T, fmtid: ?*const Guid, pid: u32, ppropvar: ?*const PROPVARIANT, puiff: PROPERTYUI_FORMAT_FLAGS, pwszText: [*:0]u16, cchText: u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).FormatForDisplay(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, ppropvar, puiff, pwszText, cchText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IPropertyUI_GetHelpInfo(self: *const T, fmtid: ?*const Guid, pid: u32, pwszHelpFile: [*:0]u16, cch: u32, puHelpID: ?*u32) HRESULT {
                return @as(*const IPropertyUI.VTable, @ptrCast(self.vtable)).GetHelpInfo(@as(*const IPropertyUI, @ptrCast(self)), fmtid, pid, pwszHelpFile, cch, puHelpID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const PDOPSTATUS = enum(i32) {
    RUNNING = 1,
    PAUSED = 2,
    CANCELLED = 3,
    STOPPED = 4,
    ERRORS = 5,
};
pub const PDOPS_RUNNING = PDOPSTATUS.RUNNING;
pub const PDOPS_PAUSED = PDOPSTATUS.PAUSED;
pub const PDOPS_CANCELLED = PDOPSTATUS.CANCELLED;
pub const PDOPS_STOPPED = PDOPSTATUS.STOPPED;
pub const PDOPS_ERRORS = PDOPSTATUS.ERRORS;

pub const SYNC_ENGINE_STATE_FLAGS = enum(i32) {
    NONE = 0,
    SERVICE_QUOTA_NEARING_LIMIT = 1,
    SERVICE_QUOTA_EXCEEDED_LIMIT = 2,
    AUTHENTICATION_ERROR = 4,
    PAUSED_DUE_TO_METERED_NETWORK = 8,
    PAUSED_DUE_TO_DISK_SPACE_FULL = 16,
    PAUSED_DUE_TO_CLIENT_POLICY = 32,
    PAUSED_DUE_TO_SERVICE_POLICY = 64,
    SERVICE_UNAVAILABLE = 128,
    PAUSED_DUE_TO_USER_REQUEST = 256,
    ALL_FLAGS = 511,
};
pub const SESF_NONE = SYNC_ENGINE_STATE_FLAGS.NONE;
pub const SESF_SERVICE_QUOTA_NEARING_LIMIT = SYNC_ENGINE_STATE_FLAGS.SERVICE_QUOTA_NEARING_LIMIT;
pub const SESF_SERVICE_QUOTA_EXCEEDED_LIMIT = SYNC_ENGINE_STATE_FLAGS.SERVICE_QUOTA_EXCEEDED_LIMIT;
pub const SESF_AUTHENTICATION_ERROR = SYNC_ENGINE_STATE_FLAGS.AUTHENTICATION_ERROR;
pub const SESF_PAUSED_DUE_TO_METERED_NETWORK = SYNC_ENGINE_STATE_FLAGS.PAUSED_DUE_TO_METERED_NETWORK;
pub const SESF_PAUSED_DUE_TO_DISK_SPACE_FULL = SYNC_ENGINE_STATE_FLAGS.PAUSED_DUE_TO_DISK_SPACE_FULL;
pub const SESF_PAUSED_DUE_TO_CLIENT_POLICY = SYNC_ENGINE_STATE_FLAGS.PAUSED_DUE_TO_CLIENT_POLICY;
pub const SESF_PAUSED_DUE_TO_SERVICE_POLICY = SYNC_ENGINE_STATE_FLAGS.PAUSED_DUE_TO_SERVICE_POLICY;
pub const SESF_SERVICE_UNAVAILABLE = SYNC_ENGINE_STATE_FLAGS.SERVICE_UNAVAILABLE;
pub const SESF_PAUSED_DUE_TO_USER_REQUEST = SYNC_ENGINE_STATE_FLAGS.PAUSED_DUE_TO_USER_REQUEST;
pub const SESF_ALL_FLAGS = SYNC_ENGINE_STATE_FLAGS.ALL_FLAGS;

pub const PROPPRG = extern struct {
    flPrg: u16 align(1),
    flPrgInit: u16 align(1),
    achTitle: [30]CHAR align(1),
    achCmdLine: [128]CHAR align(1),
    achWorkDir: [64]CHAR align(1),
    wHotKey: u16 align(1),
    achIconFile: [80]CHAR align(1),
    wIconIndex: u16 align(1),
    dwEnhModeFlags: u32 align(1),
    dwRealModeFlags: u32 align(1),
    achOtherFile: [80]CHAR align(1),
    achPIFFile: [260]CHAR align(1),
};

//--------------------------------------------------------------------------------
// Section: Functions (227)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows8.0'
pub extern "propsys" fn PropVariantToWinRTPropertyValue(
    propvar: ?*const PROPVARIANT,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "propsys" fn WinRTPropertyValueToPropVariant(
    punkPropertyValue: ?*IUnknown,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "propsys" fn PSFormatForDisplay(
    propkey: ?*const PROPERTYKEY,
    propvar: ?*const PROPVARIANT,
    pdfFlags: PROPDESC_FORMAT_FLAGS,
    pwszText: [*:0]u16,
    cchText: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "propsys" fn PSFormatForDisplayAlloc(
    key: ?*const PROPERTYKEY,
    propvar: ?*const PROPVARIANT,
    pdff: PROPDESC_FORMAT_FLAGS,
    ppszDisplay: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "propsys" fn PSFormatPropertyValue(
    pps: ?*IPropertyStore,
    ppd: ?*IPropertyDescription,
    pdff: PROPDESC_FORMAT_FLAGS,
    ppszDisplay: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSGetImageReferenceForValue(
    propkey: ?*const PROPERTYKEY,
    propvar: ?*const PROPVARIANT,
    ppszImageRes: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSStringFromPropertyKey(
    pkey: ?*const PROPERTYKEY,
    psz: [*:0]u16,
    cch: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSPropertyKeyFromString(
    pszString: ?[*:0]const u16,
    pkey: ?*PROPERTYKEY,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreateMemoryPropertyStore(
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreateDelayedMultiplexPropertyStore(
    flags: GETPROPERTYSTOREFLAGS,
    pdpsf: ?*IDelayedPropertyStoreFactory,
    rgStoreIds: [*]const u32,
    cStores: u32,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreateMultiplexPropertyStore(
    prgpunkStores: [*]?*IUnknown,
    cStores: u32,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreatePropertyChangeArray(
    rgpropkey: ?[*]const PROPERTYKEY,
    rgflags: ?[*]const PKA_FLAGS,
    rgpropvar: ?[*]const PROPVARIANT,
    cChanges: u32,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreateSimplePropertyChange(
    flags: PKA_FLAGS,
    key: ?*const PROPERTYKEY,
    propvar: ?*const PROPVARIANT,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertyDescription(
    propkey: ?*const PROPERTYKEY,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertyDescriptionByName(
    pszCanonicalName: ?[*:0]const u16,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSLookupPropertyHandlerCLSID(
    pszFilePath: ?[*:0]const u16,
    pclsid: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetItemPropertyHandler(
    punkItem: ?*IUnknown,
    fReadWrite: BOOL,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetItemPropertyHandlerWithCreateObject(
    punkItem: ?*IUnknown,
    fReadWrite: BOOL,
    punkCreateObject: ?*IUnknown,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertyValue(
    pps: ?*IPropertyStore,
    ppd: ?*IPropertyDescription,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSSetPropertyValue(
    pps: ?*IPropertyStore,
    ppd: ?*IPropertyDescription,
    propvar: ?*const PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSRegisterPropertySchema(
    pszPath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSUnregisterPropertySchema(
    pszPath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSRefreshPropertySchema() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSEnumeratePropertyDescriptions(
    filterOn: PROPDESC_ENUMFILTER,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertyKeyFromName(
    pszName: ?[*:0]const u16,
    ppropkey: ?*PROPERTYKEY,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetNameFromPropertyKey(
    propkey: ?*const PROPERTYKEY,
    ppszCanonicalName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCoerceToCanonicalValue(
    key: ?*const PROPERTYKEY,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertyDescriptionListFromString(
    pszPropList: ?[*:0]const u16,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreatePropertyStoreFromPropertySetStorage(
    ppss: ?*IPropertySetStorage,
    grfMode: u32,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreatePropertyStoreFromObject(
    punk: ?*IUnknown,
    grfMode: u32,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSCreateAdapterFromPropertyStore(
    pps: ?*IPropertyStore,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertySystem(
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetPropertyFromPropertyStorage(
    // TODO: what to do with BytesParamIndex 1?
    psps: ?*SERIALIZEDPROPSTORAGE,
    cb: u32,
    rpkey: ?*const PROPERTYKEY,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PSGetNamedPropertyFromPropertyStorage(
    // TODO: what to do with BytesParamIndex 1?
    psps: ?*SERIALIZEDPROPSTORAGE,
    cb: u32,
    pszName: ?[*:0]const u16,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadType(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    @"var": ?*VARIANT,
    type: u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadStr(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: [*:0]u16,
    characterCount: i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadStrAlloc(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadBSTR(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteStr(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteBSTR(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadInt(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteInt(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadSHORT(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*i16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteSHORT(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: i16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadLONG(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteLONG(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadDWORD(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteDWORD(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadBOOL(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteBOOL(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadPOINTL(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*POINTL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WritePOINTL(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*const POINTL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadPOINTS(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*POINTS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WritePOINTS(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*const POINTS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadRECTL(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*RECTL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteRECTL(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*const RECTL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadStream(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*?*IStream,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteStream(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*IStream,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_Delete(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadULONGLONG(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteULONGLONG(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadUnknown(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteUnknown(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    punk: ?*IUnknown,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadGUID(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WriteGUID(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*const Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_ReadPropertyKey(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*PROPERTYKEY,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "propsys" fn PSPropertyBag_WritePropertyKey(
    propBag: ?*IPropertyBag,
    propName: ?[*:0]const u16,
    value: ?*const PROPERTYKEY,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromResource(
    hinst: ?HINSTANCE,
    id: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromBuffer(
    // TODO: what to do with BytesParamIndex 1?
    pv: ?*const anyopaque,
    cb: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromCLSID(
    clsid: ?*const Guid,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromGUIDAsString(
    guid: ?*const Guid,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromFileTime(
    pftIn: ?*const FILETIME,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromPropVariantVectorElem(
    propvarIn: ?*const PROPVARIANT,
    iElem: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantVectorFromPropVariant(
    propvarSingle: ?*const PROPVARIANT,
    ppropvarVector: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromStrRet(
    pstrret: ?*STRRET,
    pidl: ?*ITEMIDLIST,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromBooleanVector(
    prgf: ?[*]const BOOL,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromInt16Vector(
    prgn: ?[*]const i16,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromUInt16Vector(
    prgn: ?[*:0]const u16,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromInt32Vector(
    prgn: ?[*]const i32,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromUInt32Vector(
    prgn: ?[*]const u32,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromInt64Vector(
    prgn: ?[*]const i64,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromUInt64Vector(
    prgn: ?[*]const u64,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromDoubleVector(
    prgn: ?[*]const f64,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromFileTimeVector(
    prgft: ?[*]const FILETIME,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromStringVector(
    prgsz: ?[*]?PWSTR,
    cElems: u32,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitPropVariantFromStringAsVector(
    psz: ?[*:0]const u16,
    ppropvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToBooleanWithDefault(
    propvarIn: ?*const PROPVARIANT,
    fDefault: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt16WithDefault(
    propvarIn: ?*const PROPVARIANT,
    iDefault: i16,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt16WithDefault(
    propvarIn: ?*const PROPVARIANT,
    uiDefault: u16,
) callconv(@import("std").os.windows.WINAPI) u16;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt32WithDefault(
    propvarIn: ?*const PROPVARIANT,
    lDefault: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt32WithDefault(
    propvarIn: ?*const PROPVARIANT,
    ulDefault: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt64WithDefault(
    propvarIn: ?*const PROPVARIANT,
    llDefault: i64,
) callconv(@import("std").os.windows.WINAPI) i64;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt64WithDefault(
    propvarIn: ?*const PROPVARIANT,
    ullDefault: u64,
) callconv(@import("std").os.windows.WINAPI) u64;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToDoubleWithDefault(
    propvarIn: ?*const PROPVARIANT,
    dblDefault: f64,
) callconv(@import("std").os.windows.WINAPI) f64;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToStringWithDefault(
    propvarIn: ?*const PROPVARIANT,
    pszDefault: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToBoolean(
    propvarIn: ?*const PROPVARIANT,
    pfRet: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt16(
    propvarIn: ?*const PROPVARIANT,
    piRet: ?*i16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt16(
    propvarIn: ?*const PROPVARIANT,
    puiRet: ?*u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt32(
    propvarIn: ?*const PROPVARIANT,
    plRet: ?*i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt32(
    propvarIn: ?*const PROPVARIANT,
    pulRet: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt64(
    propvarIn: ?*const PROPVARIANT,
    pllRet: ?*i64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt64(
    propvarIn: ?*const PROPVARIANT,
    pullRet: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToDouble(
    propvarIn: ?*const PROPVARIANT,
    pdblRet: ?*f64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToBuffer(
    propvar: ?*const PROPVARIANT,
    // TODO: what to do with BytesParamIndex 2?
    pv: ?*anyopaque,
    cb: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToString(
    propvar: ?*const PROPVARIANT,
    psz: [*:0]u16,
    cch: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToGUID(
    propvar: ?*const PROPVARIANT,
    pguid: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToStringAlloc(
    propvar: ?*const PROPVARIANT,
    ppszOut: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToBSTR(
    propvar: ?*const PROPVARIANT,
    pbstrOut: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToStrRet(
    propvar: ?*const PROPVARIANT,
    pstrret: ?*STRRET,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToFileTime(
    propvar: ?*const PROPVARIANT,
    pstfOut: PSTIME_FLAGS,
    pftOut: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetElementCount(
    propvar: ?*const PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToBooleanVector(
    propvar: ?*const PROPVARIANT,
    prgf: [*]BOOL,
    crgf: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt16Vector(
    propvar: ?*const PROPVARIANT,
    prgn: [*]i16,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt16Vector(
    propvar: ?*const PROPVARIANT,
    prgn: [*:0]u16,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt32Vector(
    propvar: ?*const PROPVARIANT,
    prgn: [*]i32,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt32Vector(
    propvar: ?*const PROPVARIANT,
    prgn: [*]u32,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt64Vector(
    propvar: ?*const PROPVARIANT,
    prgn: [*]i64,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt64Vector(
    propvar: ?*const PROPVARIANT,
    prgn: [*]u64,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToDoubleVector(
    propvar: ?*const PROPVARIANT,
    prgn: [*]f64,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToFileTimeVector(
    propvar: ?*const PROPVARIANT,
    prgft: [*]FILETIME,
    crgft: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToStringVector(
    propvar: ?*const PROPVARIANT,
    prgsz: [*]?PWSTR,
    crgsz: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToBooleanVectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgf: ?*?*BOOL,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt16VectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*i16,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt16VectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*u16,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt32VectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*i32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt32VectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToInt64VectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*i64,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToUInt64VectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*u64,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToDoubleVectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgn: ?*?*f64,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToFileTimeVectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgft: ?*?*FILETIME,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantToStringVectorAlloc(
    propvar: ?*const PROPVARIANT,
    pprgsz: ?*?*?PWSTR,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetBooleanElem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pfVal: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetInt16Elem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*i16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetUInt16Elem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetInt32Elem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetUInt32Elem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetInt64Elem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*i64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetUInt64Elem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetDoubleElem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pnVal: ?*f64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetFileTimeElem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    pftVal: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantGetStringElem(
    propvar: ?*const PROPVARIANT,
    iElem: u32,
    ppszVal: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn ClearPropVariantArray(
    rgPropVar: [*]PROPVARIANT,
    cVars: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantCompareEx(
    propvar1: ?*const PROPVARIANT,
    propvar2: ?*const PROPVARIANT,
    unit: PROPVAR_COMPARE_UNIT,
    flags: PROPVAR_COMPARE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn PropVariantChangeType(
    ppropvarDest: ?*PROPVARIANT,
    propvarSrc: ?*const PROPVARIANT,
    flags: PROPVAR_CHANGE_FLAGS,
    vt: u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "propsys" fn PropVariantToVariant(
    pPropVar: ?*const PROPVARIANT,
    pVar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "propsys" fn VariantToPropVariant(
    pVar: ?*const VARIANT,
    pPropVar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromResource(
    hinst: ?HINSTANCE,
    id: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromBuffer(
    // TODO: what to do with BytesParamIndex 1?
    pv: ?*const anyopaque,
    cb: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromGUIDAsString(
    guid: ?*const Guid,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromFileTime(
    pft: ?*const FILETIME,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromFileTimeArray(
    prgft: ?[*]const FILETIME,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromStrRet(
    pstrret: ?*STRRET,
    pidl: ?*ITEMIDLIST,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromVariantArrayElem(
    varIn: ?*const VARIANT,
    iElem: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromBooleanArray(
    prgf: [*]const BOOL,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromInt16Array(
    prgn: [*]const i16,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromUInt16Array(
    prgn: [*:0]const u16,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromInt32Array(
    prgn: [*]const i32,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromUInt32Array(
    prgn: [*]const u32,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromInt64Array(
    prgn: [*]const i64,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromUInt64Array(
    prgn: [*]const u64,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromDoubleArray(
    prgn: [*]const f64,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn InitVariantFromStringArray(
    prgsz: [*]?PWSTR,
    cElems: u32,
    pvar: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToBooleanWithDefault(
    varIn: ?*const VARIANT,
    fDefault: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt16WithDefault(
    varIn: ?*const VARIANT,
    iDefault: i16,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt16WithDefault(
    varIn: ?*const VARIANT,
    uiDefault: u16,
) callconv(@import("std").os.windows.WINAPI) u16;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt32WithDefault(
    varIn: ?*const VARIANT,
    lDefault: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt32WithDefault(
    varIn: ?*const VARIANT,
    ulDefault: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt64WithDefault(
    varIn: ?*const VARIANT,
    llDefault: i64,
) callconv(@import("std").os.windows.WINAPI) i64;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt64WithDefault(
    varIn: ?*const VARIANT,
    ullDefault: u64,
) callconv(@import("std").os.windows.WINAPI) u64;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToDoubleWithDefault(
    varIn: ?*const VARIANT,
    dblDefault: f64,
) callconv(@import("std").os.windows.WINAPI) f64;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToStringWithDefault(
    varIn: ?*const VARIANT,
    pszDefault: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToBoolean(
    varIn: ?*const VARIANT,
    pfRet: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt16(
    varIn: ?*const VARIANT,
    piRet: ?*i16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt16(
    varIn: ?*const VARIANT,
    puiRet: ?*u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt32(
    varIn: ?*const VARIANT,
    plRet: ?*i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt32(
    varIn: ?*const VARIANT,
    pulRet: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt64(
    varIn: ?*const VARIANT,
    pllRet: ?*i64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt64(
    varIn: ?*const VARIANT,
    pullRet: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToDouble(
    varIn: ?*const VARIANT,
    pdblRet: ?*f64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToBuffer(
    varIn: ?*const VARIANT,
    // TODO: what to do with BytesParamIndex 2?
    pv: ?*anyopaque,
    cb: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToGUID(
    varIn: ?*const VARIANT,
    pguid: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToString(
    varIn: ?*const VARIANT,
    pszBuf: [*:0]u16,
    cchBuf: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToStringAlloc(
    varIn: ?*const VARIANT,
    ppszBuf: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToDosDateTime(
    varIn: ?*const VARIANT,
    pwDate: ?*u16,
    pwTime: ?*u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToStrRet(
    varIn: ?*const VARIANT,
    pstrret: ?*STRRET,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToFileTime(
    varIn: ?*const VARIANT,
    stfOut: PSTIME_FLAGS,
    pftOut: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetElementCount(
    varIn: ?*const VARIANT,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToBooleanArray(
    @"var": ?*const VARIANT,
    prgf: [*]BOOL,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt16Array(
    @"var": ?*const VARIANT,
    prgn: [*]i16,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt16Array(
    @"var": ?*const VARIANT,
    prgn: [*:0]u16,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt32Array(
    @"var": ?*const VARIANT,
    prgn: [*]i32,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt32Array(
    @"var": ?*const VARIANT,
    prgn: [*]u32,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt64Array(
    @"var": ?*const VARIANT,
    prgn: [*]i64,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt64Array(
    @"var": ?*const VARIANT,
    prgn: [*]u64,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToDoubleArray(
    @"var": ?*const VARIANT,
    prgn: [*]f64,
    crgn: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToStringArray(
    @"var": ?*const VARIANT,
    prgsz: [*]?PWSTR,
    crgsz: u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToBooleanArrayAlloc(
    @"var": ?*const VARIANT,
    pprgf: ?*?*BOOL,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt16ArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*i16,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt16ArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*u16,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt32ArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*i32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt32ArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*u32,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToInt64ArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*i64,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToUInt64ArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*u64,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToDoubleArrayAlloc(
    @"var": ?*const VARIANT,
    pprgn: ?*?*f64,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantToStringArrayAlloc(
    @"var": ?*const VARIANT,
    pprgsz: ?*?*?PWSTR,
    pcElem: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetBooleanElem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pfVal: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetInt16Elem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*i16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetUInt16Elem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetInt32Elem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*i32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetUInt32Elem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetInt64Elem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*i64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetUInt64Elem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetDoubleElem(
    @"var": ?*const VARIANT,
    iElem: u32,
    pnVal: ?*f64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantGetStringElem(
    @"var": ?*const VARIANT,
    iElem: u32,
    ppszVal: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn ClearVariantArray(
    pvars: [*]VARIANT,
    cvars: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "propsys" fn VariantCompare(
    var1: ?*const VARIANT,
    var2: ?*const VARIANT,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "shell32" fn SHGetPropertyStoreFromIDList(
    pidl: ?*ITEMIDLIST,
    flags: GETPROPERTYSTOREFLAGS,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "shell32" fn SHGetPropertyStoreFromParsingName(
    pszPath: ?[*:0]const u16,
    pbc: ?*IBindCtx,
    flags: GETPROPERTYSTOREFLAGS,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "shell32" fn SHAddDefaultPropertiesByExt(
    pszExt: ?[*:0]const u16,
    pPropStore: ?*IPropertyStore,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.0'
pub extern "shell32" fn PifMgr_OpenProperties(
    pszApp: ?[*:0]const u16,
    pszPIF: ?[*:0]const u16,
    hInf: u32,
    flOpt: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "shell32" fn PifMgr_GetProperties(
    hProps: ?HANDLE,
    pszGroup: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 3?
    lpProps: ?*anyopaque,
    cbProps: i32,
    flOpt: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "shell32" fn PifMgr_SetProperties(
    hProps: ?HANDLE,
    pszGroup: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 3?
    lpProps: ?*const anyopaque,
    cbProps: i32,
    flOpt: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "shell32" fn PifMgr_CloseProperties(
    hProps: ?HANDLE,
    flOpt: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "shell32" fn SHPropStgCreate(
    psstg: ?*IPropertySetStorage,
    fmtid: ?*const Guid,
    pclsid: ?*const Guid,
    grfFlags: u32,
    grfMode: u32,
    dwDisposition: u32,
    ppstg: ?*?*IPropertyStorage,
    puCodePage: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "shell32" fn SHPropStgReadMultiple(
    pps: ?*IPropertyStorage,
    uCodePage: u32,
    cpspec: u32,
    rgpspec: [*]const PROPSPEC,
    rgvar: ?*PROPVARIANT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "shell32" fn SHPropStgWriteMultiple(
    pps: ?*IPropertyStorage,
    puCodePage: ?*u32,
    cpspec: u32,
    rgpspec: [*]const PROPSPEC,
    rgvar: [*]PROPVARIANT,
    propidNameFirst: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "shell32" fn SHGetPropertyStoreForWindow(
    hwnd: ?HWND,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (26)
//--------------------------------------------------------------------------------
const Guid = @import("../../zig.zig").Guid;
const BOOL = @import("../../foundation.zig").BOOL;
const BSTR = @import("../../foundation.zig").BSTR;
const CHAR = @import("../../foundation.zig").CHAR;
const CONDITION_OPERATION = @import("../../system/search/common.zig").CONDITION_OPERATION;
const FILETIME = @import("../../foundation.zig").FILETIME;
const HANDLE = @import("../../foundation.zig").HANDLE;
const HINSTANCE = @import("../../foundation.zig").HINSTANCE;
const HRESULT = @import("../../foundation.zig").HRESULT;
const HWND = @import("../../foundation.zig").HWND;
const IBindCtx = @import("../../system/com.zig").IBindCtx;
const IPropertyBag = @import("../../system/com/structured_storage.zig").IPropertyBag;
const IPropertySetStorage = @import("../../system/com/structured_storage.zig").IPropertySetStorage;
const IPropertyStorage = @import("../../system/com/structured_storage.zig").IPropertyStorage;
const IStream = @import("../../system/com.zig").IStream;
const ITEMIDLIST = @import("../../ui/shell/common.zig").ITEMIDLIST;
const IUnknown = @import("../../system/com.zig").IUnknown;
const POINTL = @import("../../foundation.zig").POINTL;
const POINTS = @import("../../foundation.zig").POINTS;
const PROPSPEC = @import("../../system/com/structured_storage.zig").PROPSPEC;
const PROPVARIANT = @import("../../system/com/structured_storage.zig").PROPVARIANT;
const PSTR = @import("../../foundation.zig").PSTR;
const PWSTR = @import("../../foundation.zig").PWSTR;
const RECTL = @import("../../foundation.zig").RECTL;
const STRRET = @import("../../ui/shell/common.zig").STRRET;
const VARIANT = @import("../../system/com.zig").VARIANT;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
