//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (133)
//--------------------------------------------------------------------------------
pub const EXTENDED_BIT = @as(u32, 16777216);
pub const DONTCARE_BIT = @as(u32, 33554432);
pub const FAKE_KEYSTROKE = @as(u32, 33554432);
pub const KBDBASE = @as(u32, 0);
pub const KBDSHIFT = @as(u32, 1);
pub const KBDCTRL = @as(u32, 2);
pub const KBDALT = @as(u32, 4);
pub const KBDKANA = @as(u32, 8);
pub const KBDROYA = @as(u32, 16);
pub const KBDLOYA = @as(u32, 32);
pub const KBDGRPSELTAP = @as(u32, 128);
pub const GRAVE = @as(u32, 768);
pub const ACUTE = @as(u32, 769);
pub const CIRCUMFLEX = @as(u32, 770);
pub const TILDE = @as(u32, 771);
pub const MACRON = @as(u32, 772);
pub const OVERSCORE = @as(u32, 773);
pub const BREVE = @as(u32, 774);
pub const DOT_ABOVE = @as(u32, 775);
pub const UMLAUT = @as(u32, 776);
pub const DIARESIS = @as(u32, 776);
pub const HOOK_ABOVE = @as(u32, 777);
pub const RING = @as(u32, 778);
pub const DOUBLE_ACUTE = @as(u32, 779);
pub const HACEK = @as(u32, 780);
pub const CEDILLA = @as(u32, 807);
pub const OGONEK = @as(u32, 808);
pub const TONOS = @as(u32, 900);
pub const DIARESIS_TONOS = @as(u32, 901);
pub const SHFT_INVALID = @as(u32, 15);
pub const WCH_NONE = @as(u32, 61440);
pub const WCH_DEAD = @as(u32, 61441);
pub const WCH_LGTR = @as(u32, 61442);
pub const CAPLOK = @as(u32, 1);
pub const SGCAPS = @as(u32, 2);
pub const CAPLOKALTGR = @as(u32, 4);
pub const KANALOK = @as(u32, 8);
pub const GRPSELTAP = @as(u32, 128);
pub const DKF_DEAD = @as(u32, 1);
pub const KBD_VERSION = @as(u32, 1);
pub const KLLF_ALTGR = @as(u32, 1);
pub const KLLF_SHIFTLOCK = @as(u32, 2);
pub const KLLF_LRM_RLM = @as(u32, 4);
pub const KLLF_GLOBAL_ATTRS = @as(u32, 2);
pub const KBDTABLE_MULTI_MAX = @as(u32, 8);
pub const KEYBOARD_TYPE_GENERIC_101 = @as(u32, 4);
pub const KEYBOARD_TYPE_JAPAN = @as(u32, 7);
pub const KEYBOARD_TYPE_KOREA = @as(u32, 8);
pub const KEYBOARD_TYPE_UNKNOWN = @as(u32, 81);
pub const NLSKBD_OEM_MICROSOFT = @as(u32, 0);
pub const NLSKBD_OEM_AX = @as(u32, 1);
pub const NLSKBD_OEM_EPSON = @as(u32, 4);
pub const NLSKBD_OEM_FUJITSU = @as(u32, 5);
pub const NLSKBD_OEM_IBM = @as(u32, 7);
pub const NLSKBD_OEM_MATSUSHITA = @as(u32, 10);
pub const NLSKBD_OEM_NEC = @as(u32, 13);
pub const NLSKBD_OEM_TOSHIBA = @as(u32, 18);
pub const NLSKBD_OEM_DEC = @as(u32, 24);
pub const MICROSOFT_KBD_101_TYPE = @as(u32, 0);
pub const MICROSOFT_KBD_AX_TYPE = @as(u32, 1);
pub const MICROSOFT_KBD_106_TYPE = @as(u32, 2);
pub const MICROSOFT_KBD_002_TYPE = @as(u32, 3);
pub const MICROSOFT_KBD_001_TYPE = @as(u32, 4);
pub const MICROSOFT_KBD_FUNC = @as(u32, 12);
pub const AX_KBD_DESKTOP_TYPE = @as(u32, 1);
pub const FMR_KBD_JIS_TYPE = @as(u32, 0);
pub const FMR_KBD_OASYS_TYPE = @as(u32, 1);
pub const FMV_KBD_OASYS_TYPE = @as(u32, 2);
pub const NEC_KBD_NORMAL_TYPE = @as(u32, 1);
pub const NEC_KBD_N_MODE_TYPE = @as(u32, 2);
pub const NEC_KBD_H_MODE_TYPE = @as(u32, 3);
pub const NEC_KBD_LAPTOP_TYPE = @as(u32, 4);
pub const NEC_KBD_106_TYPE = @as(u32, 5);
pub const TOSHIBA_KBD_DESKTOP_TYPE = @as(u32, 13);
pub const TOSHIBA_KBD_LAPTOP_TYPE = @as(u32, 15);
pub const DEC_KBD_ANSI_LAYOUT_TYPE = @as(u32, 1);
pub const DEC_KBD_JIS_LAYOUT_TYPE = @as(u32, 2);
pub const MICROSOFT_KBD_101A_TYPE = @as(u32, 0);
pub const MICROSOFT_KBD_101B_TYPE = @as(u32, 4);
pub const MICROSOFT_KBD_101C_TYPE = @as(u32, 5);
pub const MICROSOFT_KBD_103_TYPE = @as(u32, 6);
pub const NLSKBD_INFO_SEND_IME_NOTIFICATION = @as(u32, 1);
pub const NLSKBD_INFO_ACCESSIBILITY_KEYMAP = @as(u32, 2);
pub const NLSKBD_INFO_EMURATE_101_KEYBOARD = @as(u32, 16);
pub const NLSKBD_INFO_EMURATE_106_KEYBOARD = @as(u32, 32);
pub const KBDNLS_TYPE_NULL = @as(u32, 0);
pub const KBDNLS_TYPE_NORMAL = @as(u32, 1);
pub const KBDNLS_TYPE_TOGGLE = @as(u32, 2);
pub const KBDNLS_INDEX_NORMAL = @as(u32, 1);
pub const KBDNLS_INDEX_ALT = @as(u32, 2);
pub const KBDNLS_NULL = @as(u32, 0);
pub const KBDNLS_NOEVENT = @as(u32, 1);
pub const KBDNLS_SEND_BASE_VK = @as(u32, 2);
pub const KBDNLS_SEND_PARAM_VK = @as(u32, 3);
pub const KBDNLS_KANALOCK = @as(u32, 4);
pub const KBDNLS_ALPHANUM = @as(u32, 5);
pub const KBDNLS_HIRAGANA = @as(u32, 6);
pub const KBDNLS_KATAKANA = @as(u32, 7);
pub const KBDNLS_SBCSDBCS = @as(u32, 8);
pub const KBDNLS_ROMAN = @as(u32, 9);
pub const KBDNLS_CODEINPUT = @as(u32, 10);
pub const KBDNLS_HELP_OR_END = @as(u32, 11);
pub const KBDNLS_HOME_OR_CLEAR = @as(u32, 12);
pub const KBDNLS_NUMPAD = @as(u32, 13);
pub const KBDNLS_KANAEVENT = @as(u32, 14);
pub const KBDNLS_CONV_OR_NONCONV = @as(u32, 15);
pub const KBD_TYPE = @as(u32, 4);
pub const VK__none_ = @as(u32, 255);
pub const VK_ABNT_C1 = @as(u32, 193);
pub const VK_ABNT_C2 = @as(u32, 194);
pub const SCANCODE_LSHIFT = @as(u32, 42);
pub const SCANCODE_RSHIFT = @as(u32, 54);
pub const SCANCODE_CTRL = @as(u32, 29);
pub const SCANCODE_ALT = @as(u32, 56);
pub const SCANCODE_NUMPAD_FIRST = @as(u32, 71);
pub const SCANCODE_NUMPAD_LAST = @as(u32, 82);
pub const SCANCODE_LWIN = @as(u32, 91);
pub const SCANCODE_RWIN = @as(u32, 92);
pub const SCANCODE_THAI_LAYOUT_TOGGLE = @as(u32, 41);
pub const VK_DBE_ALPHANUMERIC = @as(u32, 240);
pub const VK_DBE_KATAKANA = @as(u32, 241);
pub const VK_DBE_HIRAGANA = @as(u32, 242);
pub const VK_DBE_SBCSCHAR = @as(u32, 243);
pub const VK_DBE_DBCSCHAR = @as(u32, 244);
pub const VK_DBE_ROMAN = @as(u32, 245);
pub const VK_DBE_NOROMAN = @as(u32, 246);
pub const VK_DBE_ENTERWORDREGISTERMODE = @as(u32, 247);
pub const VK_DBE_ENTERIMECONFIGMODE = @as(u32, 248);
pub const VK_DBE_FLUSHSTRING = @as(u32, 249);
pub const VK_DBE_CODEINPUT = @as(u32, 250);
pub const VK_DBE_NOCODEINPUT = @as(u32, 251);
pub const VK_DBE_DETERMINESTRING = @as(u32, 252);
pub const VK_DBE_ENTERDLGCONVERSIONMODE = @as(u32, 253);

//--------------------------------------------------------------------------------
// Section: Types (44)
//--------------------------------------------------------------------------------
pub const HOT_KEY_MODIFIERS = enum(u32) {
    ALT = 1,
    CONTROL = 2,
    NOREPEAT = 16384,
    SHIFT = 4,
    WIN = 8,
    _,
    pub fn initFlags(o: struct {
        ALT: u1 = 0,
        CONTROL: u1 = 0,
        NOREPEAT: u1 = 0,
        SHIFT: u1 = 0,
        WIN: u1 = 0,
    }) HOT_KEY_MODIFIERS {
        return @as(HOT_KEY_MODIFIERS, @enumFromInt((if (o.ALT == 1) @intFromEnum(HOT_KEY_MODIFIERS.ALT) else 0) | (if (o.CONTROL == 1) @intFromEnum(HOT_KEY_MODIFIERS.CONTROL) else 0) | (if (o.NOREPEAT == 1) @intFromEnum(HOT_KEY_MODIFIERS.NOREPEAT) else 0) | (if (o.SHIFT == 1) @intFromEnum(HOT_KEY_MODIFIERS.SHIFT) else 0) | (if (o.WIN == 1) @intFromEnum(HOT_KEY_MODIFIERS.WIN) else 0)));
    }
};
pub const MOD_ALT = HOT_KEY_MODIFIERS.ALT;
pub const MOD_CONTROL = HOT_KEY_MODIFIERS.CONTROL;
pub const MOD_NOREPEAT = HOT_KEY_MODIFIERS.NOREPEAT;
pub const MOD_SHIFT = HOT_KEY_MODIFIERS.SHIFT;
pub const MOD_WIN = HOT_KEY_MODIFIERS.WIN;

pub const ACTIVATE_KEYBOARD_LAYOUT_FLAGS = enum(u32) {
    REORDER = 8,
    RESET = 1073741824,
    SETFORPROCESS = 256,
    SHIFTLOCK = 65536,
    ACTIVATE = 1,
    NOTELLSHELL = 128,
    REPLACELANG = 16,
    SUBSTITUTE_OK = 2,
};
pub const KLF_REORDER = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.REORDER;
pub const KLF_RESET = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.RESET;
pub const KLF_SETFORPROCESS = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.SETFORPROCESS;
pub const KLF_SHIFTLOCK = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.SHIFTLOCK;
pub const KLF_ACTIVATE = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.ACTIVATE;
pub const KLF_NOTELLSHELL = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.NOTELLSHELL;
pub const KLF_REPLACELANG = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.REPLACELANG;
pub const KLF_SUBSTITUTE_OK = ACTIVATE_KEYBOARD_LAYOUT_FLAGS.SUBSTITUTE_OK;

pub const GET_MOUSE_MOVE_POINTS_EX_RESOLUTION = enum(u32) {
    DISPLAY_POINTS = 1,
    HIGH_RESOLUTION_POINTS = 2,
};
pub const GMMP_USE_DISPLAY_POINTS = GET_MOUSE_MOVE_POINTS_EX_RESOLUTION.DISPLAY_POINTS;
pub const GMMP_USE_HIGH_RESOLUTION_POINTS = GET_MOUSE_MOVE_POINTS_EX_RESOLUTION.HIGH_RESOLUTION_POINTS;

pub const KEYBD_EVENT_FLAGS = enum(u32) {
    EXTENDEDKEY = 1,
    KEYUP = 2,
    SCANCODE = 8,
    UNICODE = 4,
    _,
    pub fn initFlags(o: struct {
        EXTENDEDKEY: u1 = 0,
        KEYUP: u1 = 0,
        SCANCODE: u1 = 0,
        UNICODE: u1 = 0,
    }) KEYBD_EVENT_FLAGS {
        return @as(KEYBD_EVENT_FLAGS, @enumFromInt((if (o.EXTENDEDKEY == 1) @intFromEnum(KEYBD_EVENT_FLAGS.EXTENDEDKEY) else 0) | (if (o.KEYUP == 1) @intFromEnum(KEYBD_EVENT_FLAGS.KEYUP) else 0) | (if (o.SCANCODE == 1) @intFromEnum(KEYBD_EVENT_FLAGS.SCANCODE) else 0) | (if (o.UNICODE == 1) @intFromEnum(KEYBD_EVENT_FLAGS.UNICODE) else 0)));
    }
};
pub const KEYEVENTF_EXTENDEDKEY = KEYBD_EVENT_FLAGS.EXTENDEDKEY;
pub const KEYEVENTF_KEYUP = KEYBD_EVENT_FLAGS.KEYUP;
pub const KEYEVENTF_SCANCODE = KEYBD_EVENT_FLAGS.SCANCODE;
pub const KEYEVENTF_UNICODE = KEYBD_EVENT_FLAGS.UNICODE;

pub const MOUSE_EVENT_FLAGS = enum(u32) {
    ABSOLUTE = 32768,
    LEFTDOWN = 2,
    LEFTUP = 4,
    MIDDLEDOWN = 32,
    MIDDLEUP = 64,
    MOVE = 1,
    RIGHTDOWN = 8,
    RIGHTUP = 16,
    WHEEL = 2048,
    XDOWN = 128,
    XUP = 256,
    HWHEEL = 4096,
    MOVE_NOCOALESCE = 8192,
    VIRTUALDESK = 16384,
    _,
    pub fn initFlags(o: struct {
        ABSOLUTE: u1 = 0,
        LEFTDOWN: u1 = 0,
        LEFTUP: u1 = 0,
        MIDDLEDOWN: u1 = 0,
        MIDDLEUP: u1 = 0,
        MOVE: u1 = 0,
        RIGHTDOWN: u1 = 0,
        RIGHTUP: u1 = 0,
        WHEEL: u1 = 0,
        XDOWN: u1 = 0,
        XUP: u1 = 0,
        HWHEEL: u1 = 0,
        MOVE_NOCOALESCE: u1 = 0,
        VIRTUALDESK: u1 = 0,
    }) MOUSE_EVENT_FLAGS {
        return @as(MOUSE_EVENT_FLAGS, @enumFromInt((if (o.ABSOLUTE == 1) @intFromEnum(MOUSE_EVENT_FLAGS.ABSOLUTE) else 0) | (if (o.LEFTDOWN == 1) @intFromEnum(MOUSE_EVENT_FLAGS.LEFTDOWN) else 0) | (if (o.LEFTUP == 1) @intFromEnum(MOUSE_EVENT_FLAGS.LEFTUP) else 0) | (if (o.MIDDLEDOWN == 1) @intFromEnum(MOUSE_EVENT_FLAGS.MIDDLEDOWN) else 0) | (if (o.MIDDLEUP == 1) @intFromEnum(MOUSE_EVENT_FLAGS.MIDDLEUP) else 0) | (if (o.MOVE == 1) @intFromEnum(MOUSE_EVENT_FLAGS.MOVE) else 0) | (if (o.RIGHTDOWN == 1) @intFromEnum(MOUSE_EVENT_FLAGS.RIGHTDOWN) else 0) | (if (o.RIGHTUP == 1) @intFromEnum(MOUSE_EVENT_FLAGS.RIGHTUP) else 0) | (if (o.WHEEL == 1) @intFromEnum(MOUSE_EVENT_FLAGS.WHEEL) else 0) | (if (o.XDOWN == 1) @intFromEnum(MOUSE_EVENT_FLAGS.XDOWN) else 0) | (if (o.XUP == 1) @intFromEnum(MOUSE_EVENT_FLAGS.XUP) else 0) | (if (o.HWHEEL == 1) @intFromEnum(MOUSE_EVENT_FLAGS.HWHEEL) else 0) | (if (o.MOVE_NOCOALESCE == 1) @intFromEnum(MOUSE_EVENT_FLAGS.MOVE_NOCOALESCE) else 0) | (if (o.VIRTUALDESK == 1) @intFromEnum(MOUSE_EVENT_FLAGS.VIRTUALDESK) else 0)));
    }
};
pub const MOUSEEVENTF_ABSOLUTE = MOUSE_EVENT_FLAGS.ABSOLUTE;
pub const MOUSEEVENTF_LEFTDOWN = MOUSE_EVENT_FLAGS.LEFTDOWN;
pub const MOUSEEVENTF_LEFTUP = MOUSE_EVENT_FLAGS.LEFTUP;
pub const MOUSEEVENTF_MIDDLEDOWN = MOUSE_EVENT_FLAGS.MIDDLEDOWN;
pub const MOUSEEVENTF_MIDDLEUP = MOUSE_EVENT_FLAGS.MIDDLEUP;
pub const MOUSEEVENTF_MOVE = MOUSE_EVENT_FLAGS.MOVE;
pub const MOUSEEVENTF_RIGHTDOWN = MOUSE_EVENT_FLAGS.RIGHTDOWN;
pub const MOUSEEVENTF_RIGHTUP = MOUSE_EVENT_FLAGS.RIGHTUP;
pub const MOUSEEVENTF_WHEEL = MOUSE_EVENT_FLAGS.WHEEL;
pub const MOUSEEVENTF_XDOWN = MOUSE_EVENT_FLAGS.XDOWN;
pub const MOUSEEVENTF_XUP = MOUSE_EVENT_FLAGS.XUP;
pub const MOUSEEVENTF_HWHEEL = MOUSE_EVENT_FLAGS.HWHEEL;
pub const MOUSEEVENTF_MOVE_NOCOALESCE = MOUSE_EVENT_FLAGS.MOVE_NOCOALESCE;
pub const MOUSEEVENTF_VIRTUALDESK = MOUSE_EVENT_FLAGS.VIRTUALDESK;

pub const INPUT_TYPE = enum(u32) {
    MOUSE = 0,
    KEYBOARD = 1,
    HARDWARE = 2,
};
pub const INPUT_MOUSE = INPUT_TYPE.MOUSE;
pub const INPUT_KEYBOARD = INPUT_TYPE.KEYBOARD;
pub const INPUT_HARDWARE = INPUT_TYPE.HARDWARE;

pub const TRACKMOUSEEVENT_FLAGS = enum(u32) {
    CANCEL = 2147483648,
    HOVER = 1,
    LEAVE = 2,
    NONCLIENT = 16,
    QUERY = 1073741824,
    _,
    pub fn initFlags(o: struct {
        CANCEL: u1 = 0,
        HOVER: u1 = 0,
        LEAVE: u1 = 0,
        NONCLIENT: u1 = 0,
        QUERY: u1 = 0,
    }) TRACKMOUSEEVENT_FLAGS {
        return @as(TRACKMOUSEEVENT_FLAGS, @enumFromInt((if (o.CANCEL == 1) @intFromEnum(TRACKMOUSEEVENT_FLAGS.CANCEL) else 0) | (if (o.HOVER == 1) @intFromEnum(TRACKMOUSEEVENT_FLAGS.HOVER) else 0) | (if (o.LEAVE == 1) @intFromEnum(TRACKMOUSEEVENT_FLAGS.LEAVE) else 0) | (if (o.NONCLIENT == 1) @intFromEnum(TRACKMOUSEEVENT_FLAGS.NONCLIENT) else 0) | (if (o.QUERY == 1) @intFromEnum(TRACKMOUSEEVENT_FLAGS.QUERY) else 0)));
    }
};
pub const TME_CANCEL = TRACKMOUSEEVENT_FLAGS.CANCEL;
pub const TME_HOVER = TRACKMOUSEEVENT_FLAGS.HOVER;
pub const TME_LEAVE = TRACKMOUSEEVENT_FLAGS.LEAVE;
pub const TME_NONCLIENT = TRACKMOUSEEVENT_FLAGS.NONCLIENT;
pub const TME_QUERY = TRACKMOUSEEVENT_FLAGS.QUERY;

pub const VIRTUAL_KEY = enum(u16) {
    @"0" = 48,
    @"1" = 49,
    @"2" = 50,
    @"3" = 51,
    @"4" = 52,
    @"5" = 53,
    @"6" = 54,
    @"7" = 55,
    @"8" = 56,
    @"9" = 57,
    A = 65,
    B = 66,
    C = 67,
    D = 68,
    E = 69,
    F = 70,
    G = 71,
    H = 72,
    I = 73,
    J = 74,
    K = 75,
    L = 76,
    M = 77,
    N = 78,
    O = 79,
    P = 80,
    Q = 81,
    R = 82,
    S = 83,
    T = 84,
    U = 85,
    V = 86,
    W = 87,
    X = 88,
    Y = 89,
    Z = 90,
    LBUTTON = 1,
    RBUTTON = 2,
    CANCEL = 3,
    MBUTTON = 4,
    XBUTTON1 = 5,
    XBUTTON2 = 6,
    BACK = 8,
    TAB = 9,
    CLEAR = 12,
    RETURN = 13,
    SHIFT = 16,
    CONTROL = 17,
    MENU = 18,
    PAUSE = 19,
    CAPITAL = 20,
    KANA = 21,
    // HANGEUL = 21, this enum value conflicts with KANA
    // HANGUL = 21, this enum value conflicts with KANA
    IME_ON = 22,
    JUNJA = 23,
    FINAL = 24,
    HANJA = 25,
    // KANJI = 25, this enum value conflicts with HANJA
    IME_OFF = 26,
    ESCAPE = 27,
    CONVERT = 28,
    NONCONVERT = 29,
    ACCEPT = 30,
    MODECHANGE = 31,
    SPACE = 32,
    PRIOR = 33,
    NEXT = 34,
    END = 35,
    HOME = 36,
    LEFT = 37,
    UP = 38,
    RIGHT = 39,
    DOWN = 40,
    SELECT = 41,
    PRINT = 42,
    EXECUTE = 43,
    SNAPSHOT = 44,
    INSERT = 45,
    DELETE = 46,
    HELP = 47,
    LWIN = 91,
    RWIN = 92,
    APPS = 93,
    SLEEP = 95,
    NUMPAD0 = 96,
    NUMPAD1 = 97,
    NUMPAD2 = 98,
    NUMPAD3 = 99,
    NUMPAD4 = 100,
    NUMPAD5 = 101,
    NUMPAD6 = 102,
    NUMPAD7 = 103,
    NUMPAD8 = 104,
    NUMPAD9 = 105,
    MULTIPLY = 106,
    ADD = 107,
    SEPARATOR = 108,
    SUBTRACT = 109,
    DECIMAL = 110,
    DIVIDE = 111,
    F1 = 112,
    F2 = 113,
    F3 = 114,
    F4 = 115,
    F5 = 116,
    F6 = 117,
    F7 = 118,
    F8 = 119,
    F9 = 120,
    F10 = 121,
    F11 = 122,
    F12 = 123,
    F13 = 124,
    F14 = 125,
    F15 = 126,
    F16 = 127,
    F17 = 128,
    F18 = 129,
    F19 = 130,
    F20 = 131,
    F21 = 132,
    F22 = 133,
    F23 = 134,
    F24 = 135,
    NAVIGATION_VIEW = 136,
    NAVIGATION_MENU = 137,
    NAVIGATION_UP = 138,
    NAVIGATION_DOWN = 139,
    NAVIGATION_LEFT = 140,
    NAVIGATION_RIGHT = 141,
    NAVIGATION_ACCEPT = 142,
    NAVIGATION_CANCEL = 143,
    NUMLOCK = 144,
    SCROLL = 145,
    OEM_NEC_EQUAL = 146,
    // OEM_FJ_JISHO = 146, this enum value conflicts with OEM_NEC_EQUAL
    OEM_FJ_MASSHOU = 147,
    OEM_FJ_TOUROKU = 148,
    OEM_FJ_LOYA = 149,
    OEM_FJ_ROYA = 150,
    LSHIFT = 160,
    RSHIFT = 161,
    LCONTROL = 162,
    RCONTROL = 163,
    LMENU = 164,
    RMENU = 165,
    BROWSER_BACK = 166,
    BROWSER_FORWARD = 167,
    BROWSER_REFRESH = 168,
    BROWSER_STOP = 169,
    BROWSER_SEARCH = 170,
    BROWSER_FAVORITES = 171,
    BROWSER_HOME = 172,
    VOLUME_MUTE = 173,
    VOLUME_DOWN = 174,
    VOLUME_UP = 175,
    MEDIA_NEXT_TRACK = 176,
    MEDIA_PREV_TRACK = 177,
    MEDIA_STOP = 178,
    MEDIA_PLAY_PAUSE = 179,
    LAUNCH_MAIL = 180,
    LAUNCH_MEDIA_SELECT = 181,
    LAUNCH_APP1 = 182,
    LAUNCH_APP2 = 183,
    OEM_1 = 186,
    OEM_PLUS = 187,
    OEM_COMMA = 188,
    OEM_MINUS = 189,
    OEM_PERIOD = 190,
    OEM_2 = 191,
    OEM_3 = 192,
    GAMEPAD_A = 195,
    GAMEPAD_B = 196,
    GAMEPAD_X = 197,
    GAMEPAD_Y = 198,
    GAMEPAD_RIGHT_SHOULDER = 199,
    GAMEPAD_LEFT_SHOULDER = 200,
    GAMEPAD_LEFT_TRIGGER = 201,
    GAMEPAD_RIGHT_TRIGGER = 202,
    GAMEPAD_DPAD_UP = 203,
    GAMEPAD_DPAD_DOWN = 204,
    GAMEPAD_DPAD_LEFT = 205,
    GAMEPAD_DPAD_RIGHT = 206,
    GAMEPAD_MENU = 207,
    GAMEPAD_VIEW = 208,
    GAMEPAD_LEFT_THUMBSTICK_BUTTON = 209,
    GAMEPAD_RIGHT_THUMBSTICK_BUTTON = 210,
    GAMEPAD_LEFT_THUMBSTICK_UP = 211,
    GAMEPAD_LEFT_THUMBSTICK_DOWN = 212,
    GAMEPAD_LEFT_THUMBSTICK_RIGHT = 213,
    GAMEPAD_LEFT_THUMBSTICK_LEFT = 214,
    GAMEPAD_RIGHT_THUMBSTICK_UP = 215,
    GAMEPAD_RIGHT_THUMBSTICK_DOWN = 216,
    GAMEPAD_RIGHT_THUMBSTICK_RIGHT = 217,
    GAMEPAD_RIGHT_THUMBSTICK_LEFT = 218,
    OEM_4 = 219,
    OEM_5 = 220,
    OEM_6 = 221,
    OEM_7 = 222,
    OEM_8 = 223,
    OEM_AX = 225,
    OEM_102 = 226,
    ICO_HELP = 227,
    ICO_00 = 228,
    PROCESSKEY = 229,
    ICO_CLEAR = 230,
    PACKET = 231,
    OEM_RESET = 233,
    OEM_JUMP = 234,
    OEM_PA1 = 235,
    OEM_PA2 = 236,
    OEM_PA3 = 237,
    OEM_WSCTRL = 238,
    OEM_CUSEL = 239,
    OEM_ATTN = 240,
    OEM_FINISH = 241,
    OEM_COPY = 242,
    OEM_AUTO = 243,
    OEM_ENLW = 244,
    OEM_BACKTAB = 245,
    ATTN = 246,
    CRSEL = 247,
    EXSEL = 248,
    EREOF = 249,
    PLAY = 250,
    ZOOM = 251,
    NONAME = 252,
    PA1 = 253,
    OEM_CLEAR = 254,
};
pub const VK_0 = VIRTUAL_KEY.@"0";
pub const VK_1 = VIRTUAL_KEY.@"1";
pub const VK_2 = VIRTUAL_KEY.@"2";
pub const VK_3 = VIRTUAL_KEY.@"3";
pub const VK_4 = VIRTUAL_KEY.@"4";
pub const VK_5 = VIRTUAL_KEY.@"5";
pub const VK_6 = VIRTUAL_KEY.@"6";
pub const VK_7 = VIRTUAL_KEY.@"7";
pub const VK_8 = VIRTUAL_KEY.@"8";
pub const VK_9 = VIRTUAL_KEY.@"9";
pub const VK_A = VIRTUAL_KEY.A;
pub const VK_B = VIRTUAL_KEY.B;
pub const VK_C = VIRTUAL_KEY.C;
pub const VK_D = VIRTUAL_KEY.D;
pub const VK_E = VIRTUAL_KEY.E;
pub const VK_F = VIRTUAL_KEY.F;
pub const VK_G = VIRTUAL_KEY.G;
pub const VK_H = VIRTUAL_KEY.H;
pub const VK_I = VIRTUAL_KEY.I;
pub const VK_J = VIRTUAL_KEY.J;
pub const VK_K = VIRTUAL_KEY.K;
pub const VK_L = VIRTUAL_KEY.L;
pub const VK_M = VIRTUAL_KEY.M;
pub const VK_N = VIRTUAL_KEY.N;
pub const VK_O = VIRTUAL_KEY.O;
pub const VK_P = VIRTUAL_KEY.P;
pub const VK_Q = VIRTUAL_KEY.Q;
pub const VK_R = VIRTUAL_KEY.R;
pub const VK_S = VIRTUAL_KEY.S;
pub const VK_T = VIRTUAL_KEY.T;
pub const VK_U = VIRTUAL_KEY.U;
pub const VK_V = VIRTUAL_KEY.V;
pub const VK_W = VIRTUAL_KEY.W;
pub const VK_X = VIRTUAL_KEY.X;
pub const VK_Y = VIRTUAL_KEY.Y;
pub const VK_Z = VIRTUAL_KEY.Z;
pub const VK_LBUTTON = VIRTUAL_KEY.LBUTTON;
pub const VK_RBUTTON = VIRTUAL_KEY.RBUTTON;
pub const VK_CANCEL = VIRTUAL_KEY.CANCEL;
pub const VK_MBUTTON = VIRTUAL_KEY.MBUTTON;
pub const VK_XBUTTON1 = VIRTUAL_KEY.XBUTTON1;
pub const VK_XBUTTON2 = VIRTUAL_KEY.XBUTTON2;
pub const VK_BACK = VIRTUAL_KEY.BACK;
pub const VK_TAB = VIRTUAL_KEY.TAB;
pub const VK_CLEAR = VIRTUAL_KEY.CLEAR;
pub const VK_RETURN = VIRTUAL_KEY.RETURN;
pub const VK_SHIFT = VIRTUAL_KEY.SHIFT;
pub const VK_CONTROL = VIRTUAL_KEY.CONTROL;
pub const VK_MENU = VIRTUAL_KEY.MENU;
pub const VK_PAUSE = VIRTUAL_KEY.PAUSE;
pub const VK_CAPITAL = VIRTUAL_KEY.CAPITAL;
pub const VK_KANA = VIRTUAL_KEY.KANA;
pub const VK_HANGEUL = VIRTUAL_KEY.KANA;
pub const VK_HANGUL = VIRTUAL_KEY.KANA;
pub const VK_IME_ON = VIRTUAL_KEY.IME_ON;
pub const VK_JUNJA = VIRTUAL_KEY.JUNJA;
pub const VK_FINAL = VIRTUAL_KEY.FINAL;
pub const VK_HANJA = VIRTUAL_KEY.HANJA;
pub const VK_KANJI = VIRTUAL_KEY.HANJA;
pub const VK_IME_OFF = VIRTUAL_KEY.IME_OFF;
pub const VK_ESCAPE = VIRTUAL_KEY.ESCAPE;
pub const VK_CONVERT = VIRTUAL_KEY.CONVERT;
pub const VK_NONCONVERT = VIRTUAL_KEY.NONCONVERT;
pub const VK_ACCEPT = VIRTUAL_KEY.ACCEPT;
pub const VK_MODECHANGE = VIRTUAL_KEY.MODECHANGE;
pub const VK_SPACE = VIRTUAL_KEY.SPACE;
pub const VK_PRIOR = VIRTUAL_KEY.PRIOR;
pub const VK_NEXT = VIRTUAL_KEY.NEXT;
pub const VK_END = VIRTUAL_KEY.END;
pub const VK_HOME = VIRTUAL_KEY.HOME;
pub const VK_LEFT = VIRTUAL_KEY.LEFT;
pub const VK_UP = VIRTUAL_KEY.UP;
pub const VK_RIGHT = VIRTUAL_KEY.RIGHT;
pub const VK_DOWN = VIRTUAL_KEY.DOWN;
pub const VK_SELECT = VIRTUAL_KEY.SELECT;
pub const VK_PRINT = VIRTUAL_KEY.PRINT;
pub const VK_EXECUTE = VIRTUAL_KEY.EXECUTE;
pub const VK_SNAPSHOT = VIRTUAL_KEY.SNAPSHOT;
pub const VK_INSERT = VIRTUAL_KEY.INSERT;
pub const VK_DELETE = VIRTUAL_KEY.DELETE;
pub const VK_HELP = VIRTUAL_KEY.HELP;
pub const VK_LWIN = VIRTUAL_KEY.LWIN;
pub const VK_RWIN = VIRTUAL_KEY.RWIN;
pub const VK_APPS = VIRTUAL_KEY.APPS;
pub const VK_SLEEP = VIRTUAL_KEY.SLEEP;
pub const VK_NUMPAD0 = VIRTUAL_KEY.NUMPAD0;
pub const VK_NUMPAD1 = VIRTUAL_KEY.NUMPAD1;
pub const VK_NUMPAD2 = VIRTUAL_KEY.NUMPAD2;
pub const VK_NUMPAD3 = VIRTUAL_KEY.NUMPAD3;
pub const VK_NUMPAD4 = VIRTUAL_KEY.NUMPAD4;
pub const VK_NUMPAD5 = VIRTUAL_KEY.NUMPAD5;
pub const VK_NUMPAD6 = VIRTUAL_KEY.NUMPAD6;
pub const VK_NUMPAD7 = VIRTUAL_KEY.NUMPAD7;
pub const VK_NUMPAD8 = VIRTUAL_KEY.NUMPAD8;
pub const VK_NUMPAD9 = VIRTUAL_KEY.NUMPAD9;
pub const VK_MULTIPLY = VIRTUAL_KEY.MULTIPLY;
pub const VK_ADD = VIRTUAL_KEY.ADD;
pub const VK_SEPARATOR = VIRTUAL_KEY.SEPARATOR;
pub const VK_SUBTRACT = VIRTUAL_KEY.SUBTRACT;
pub const VK_DECIMAL = VIRTUAL_KEY.DECIMAL;
pub const VK_DIVIDE = VIRTUAL_KEY.DIVIDE;
pub const VK_F1 = VIRTUAL_KEY.F1;
pub const VK_F2 = VIRTUAL_KEY.F2;
pub const VK_F3 = VIRTUAL_KEY.F3;
pub const VK_F4 = VIRTUAL_KEY.F4;
pub const VK_F5 = VIRTUAL_KEY.F5;
pub const VK_F6 = VIRTUAL_KEY.F6;
pub const VK_F7 = VIRTUAL_KEY.F7;
pub const VK_F8 = VIRTUAL_KEY.F8;
pub const VK_F9 = VIRTUAL_KEY.F9;
pub const VK_F10 = VIRTUAL_KEY.F10;
pub const VK_F11 = VIRTUAL_KEY.F11;
pub const VK_F12 = VIRTUAL_KEY.F12;
pub const VK_F13 = VIRTUAL_KEY.F13;
pub const VK_F14 = VIRTUAL_KEY.F14;
pub const VK_F15 = VIRTUAL_KEY.F15;
pub const VK_F16 = VIRTUAL_KEY.F16;
pub const VK_F17 = VIRTUAL_KEY.F17;
pub const VK_F18 = VIRTUAL_KEY.F18;
pub const VK_F19 = VIRTUAL_KEY.F19;
pub const VK_F20 = VIRTUAL_KEY.F20;
pub const VK_F21 = VIRTUAL_KEY.F21;
pub const VK_F22 = VIRTUAL_KEY.F22;
pub const VK_F23 = VIRTUAL_KEY.F23;
pub const VK_F24 = VIRTUAL_KEY.F24;
pub const VK_NAVIGATION_VIEW = VIRTUAL_KEY.NAVIGATION_VIEW;
pub const VK_NAVIGATION_MENU = VIRTUAL_KEY.NAVIGATION_MENU;
pub const VK_NAVIGATION_UP = VIRTUAL_KEY.NAVIGATION_UP;
pub const VK_NAVIGATION_DOWN = VIRTUAL_KEY.NAVIGATION_DOWN;
pub const VK_NAVIGATION_LEFT = VIRTUAL_KEY.NAVIGATION_LEFT;
pub const VK_NAVIGATION_RIGHT = VIRTUAL_KEY.NAVIGATION_RIGHT;
pub const VK_NAVIGATION_ACCEPT = VIRTUAL_KEY.NAVIGATION_ACCEPT;
pub const VK_NAVIGATION_CANCEL = VIRTUAL_KEY.NAVIGATION_CANCEL;
pub const VK_NUMLOCK = VIRTUAL_KEY.NUMLOCK;
pub const VK_SCROLL = VIRTUAL_KEY.SCROLL;
pub const VK_OEM_NEC_EQUAL = VIRTUAL_KEY.OEM_NEC_EQUAL;
pub const VK_OEM_FJ_JISHO = VIRTUAL_KEY.OEM_NEC_EQUAL;
pub const VK_OEM_FJ_MASSHOU = VIRTUAL_KEY.OEM_FJ_MASSHOU;
pub const VK_OEM_FJ_TOUROKU = VIRTUAL_KEY.OEM_FJ_TOUROKU;
pub const VK_OEM_FJ_LOYA = VIRTUAL_KEY.OEM_FJ_LOYA;
pub const VK_OEM_FJ_ROYA = VIRTUAL_KEY.OEM_FJ_ROYA;
pub const VK_LSHIFT = VIRTUAL_KEY.LSHIFT;
pub const VK_RSHIFT = VIRTUAL_KEY.RSHIFT;
pub const VK_LCONTROL = VIRTUAL_KEY.LCONTROL;
pub const VK_RCONTROL = VIRTUAL_KEY.RCONTROL;
pub const VK_LMENU = VIRTUAL_KEY.LMENU;
pub const VK_RMENU = VIRTUAL_KEY.RMENU;
pub const VK_BROWSER_BACK = VIRTUAL_KEY.BROWSER_BACK;
pub const VK_BROWSER_FORWARD = VIRTUAL_KEY.BROWSER_FORWARD;
pub const VK_BROWSER_REFRESH = VIRTUAL_KEY.BROWSER_REFRESH;
pub const VK_BROWSER_STOP = VIRTUAL_KEY.BROWSER_STOP;
pub const VK_BROWSER_SEARCH = VIRTUAL_KEY.BROWSER_SEARCH;
pub const VK_BROWSER_FAVORITES = VIRTUAL_KEY.BROWSER_FAVORITES;
pub const VK_BROWSER_HOME = VIRTUAL_KEY.BROWSER_HOME;
pub const VK_VOLUME_MUTE = VIRTUAL_KEY.VOLUME_MUTE;
pub const VK_VOLUME_DOWN = VIRTUAL_KEY.VOLUME_DOWN;
pub const VK_VOLUME_UP = VIRTUAL_KEY.VOLUME_UP;
pub const VK_MEDIA_NEXT_TRACK = VIRTUAL_KEY.MEDIA_NEXT_TRACK;
pub const VK_MEDIA_PREV_TRACK = VIRTUAL_KEY.MEDIA_PREV_TRACK;
pub const VK_MEDIA_STOP = VIRTUAL_KEY.MEDIA_STOP;
pub const VK_MEDIA_PLAY_PAUSE = VIRTUAL_KEY.MEDIA_PLAY_PAUSE;
pub const VK_LAUNCH_MAIL = VIRTUAL_KEY.LAUNCH_MAIL;
pub const VK_LAUNCH_MEDIA_SELECT = VIRTUAL_KEY.LAUNCH_MEDIA_SELECT;
pub const VK_LAUNCH_APP1 = VIRTUAL_KEY.LAUNCH_APP1;
pub const VK_LAUNCH_APP2 = VIRTUAL_KEY.LAUNCH_APP2;
pub const VK_OEM_1 = VIRTUAL_KEY.OEM_1;
pub const VK_OEM_PLUS = VIRTUAL_KEY.OEM_PLUS;
pub const VK_OEM_COMMA = VIRTUAL_KEY.OEM_COMMA;
pub const VK_OEM_MINUS = VIRTUAL_KEY.OEM_MINUS;
pub const VK_OEM_PERIOD = VIRTUAL_KEY.OEM_PERIOD;
pub const VK_OEM_2 = VIRTUAL_KEY.OEM_2;
pub const VK_OEM_3 = VIRTUAL_KEY.OEM_3;
pub const VK_GAMEPAD_A = VIRTUAL_KEY.GAMEPAD_A;
pub const VK_GAMEPAD_B = VIRTUAL_KEY.GAMEPAD_B;
pub const VK_GAMEPAD_X = VIRTUAL_KEY.GAMEPAD_X;
pub const VK_GAMEPAD_Y = VIRTUAL_KEY.GAMEPAD_Y;
pub const VK_GAMEPAD_RIGHT_SHOULDER = VIRTUAL_KEY.GAMEPAD_RIGHT_SHOULDER;
pub const VK_GAMEPAD_LEFT_SHOULDER = VIRTUAL_KEY.GAMEPAD_LEFT_SHOULDER;
pub const VK_GAMEPAD_LEFT_TRIGGER = VIRTUAL_KEY.GAMEPAD_LEFT_TRIGGER;
pub const VK_GAMEPAD_RIGHT_TRIGGER = VIRTUAL_KEY.GAMEPAD_RIGHT_TRIGGER;
pub const VK_GAMEPAD_DPAD_UP = VIRTUAL_KEY.GAMEPAD_DPAD_UP;
pub const VK_GAMEPAD_DPAD_DOWN = VIRTUAL_KEY.GAMEPAD_DPAD_DOWN;
pub const VK_GAMEPAD_DPAD_LEFT = VIRTUAL_KEY.GAMEPAD_DPAD_LEFT;
pub const VK_GAMEPAD_DPAD_RIGHT = VIRTUAL_KEY.GAMEPAD_DPAD_RIGHT;
pub const VK_GAMEPAD_MENU = VIRTUAL_KEY.GAMEPAD_MENU;
pub const VK_GAMEPAD_VIEW = VIRTUAL_KEY.GAMEPAD_VIEW;
pub const VK_GAMEPAD_LEFT_THUMBSTICK_BUTTON = VIRTUAL_KEY.GAMEPAD_LEFT_THUMBSTICK_BUTTON;
pub const VK_GAMEPAD_RIGHT_THUMBSTICK_BUTTON = VIRTUAL_KEY.GAMEPAD_RIGHT_THUMBSTICK_BUTTON;
pub const VK_GAMEPAD_LEFT_THUMBSTICK_UP = VIRTUAL_KEY.GAMEPAD_LEFT_THUMBSTICK_UP;
pub const VK_GAMEPAD_LEFT_THUMBSTICK_DOWN = VIRTUAL_KEY.GAMEPAD_LEFT_THUMBSTICK_DOWN;
pub const VK_GAMEPAD_LEFT_THUMBSTICK_RIGHT = VIRTUAL_KEY.GAMEPAD_LEFT_THUMBSTICK_RIGHT;
pub const VK_GAMEPAD_LEFT_THUMBSTICK_LEFT = VIRTUAL_KEY.GAMEPAD_LEFT_THUMBSTICK_LEFT;
pub const VK_GAMEPAD_RIGHT_THUMBSTICK_UP = VIRTUAL_KEY.GAMEPAD_RIGHT_THUMBSTICK_UP;
pub const VK_GAMEPAD_RIGHT_THUMBSTICK_DOWN = VIRTUAL_KEY.GAMEPAD_RIGHT_THUMBSTICK_DOWN;
pub const VK_GAMEPAD_RIGHT_THUMBSTICK_RIGHT = VIRTUAL_KEY.GAMEPAD_RIGHT_THUMBSTICK_RIGHT;
pub const VK_GAMEPAD_RIGHT_THUMBSTICK_LEFT = VIRTUAL_KEY.GAMEPAD_RIGHT_THUMBSTICK_LEFT;
pub const VK_OEM_4 = VIRTUAL_KEY.OEM_4;
pub const VK_OEM_5 = VIRTUAL_KEY.OEM_5;
pub const VK_OEM_6 = VIRTUAL_KEY.OEM_6;
pub const VK_OEM_7 = VIRTUAL_KEY.OEM_7;
pub const VK_OEM_8 = VIRTUAL_KEY.OEM_8;
pub const VK_OEM_AX = VIRTUAL_KEY.OEM_AX;
pub const VK_OEM_102 = VIRTUAL_KEY.OEM_102;
pub const VK_ICO_HELP = VIRTUAL_KEY.ICO_HELP;
pub const VK_ICO_00 = VIRTUAL_KEY.ICO_00;
pub const VK_PROCESSKEY = VIRTUAL_KEY.PROCESSKEY;
pub const VK_ICO_CLEAR = VIRTUAL_KEY.ICO_CLEAR;
pub const VK_PACKET = VIRTUAL_KEY.PACKET;
pub const VK_OEM_RESET = VIRTUAL_KEY.OEM_RESET;
pub const VK_OEM_JUMP = VIRTUAL_KEY.OEM_JUMP;
pub const VK_OEM_PA1 = VIRTUAL_KEY.OEM_PA1;
pub const VK_OEM_PA2 = VIRTUAL_KEY.OEM_PA2;
pub const VK_OEM_PA3 = VIRTUAL_KEY.OEM_PA3;
pub const VK_OEM_WSCTRL = VIRTUAL_KEY.OEM_WSCTRL;
pub const VK_OEM_CUSEL = VIRTUAL_KEY.OEM_CUSEL;
pub const VK_OEM_ATTN = VIRTUAL_KEY.OEM_ATTN;
pub const VK_OEM_FINISH = VIRTUAL_KEY.OEM_FINISH;
pub const VK_OEM_COPY = VIRTUAL_KEY.OEM_COPY;
pub const VK_OEM_AUTO = VIRTUAL_KEY.OEM_AUTO;
pub const VK_OEM_ENLW = VIRTUAL_KEY.OEM_ENLW;
pub const VK_OEM_BACKTAB = VIRTUAL_KEY.OEM_BACKTAB;
pub const VK_ATTN = VIRTUAL_KEY.ATTN;
pub const VK_CRSEL = VIRTUAL_KEY.CRSEL;
pub const VK_EXSEL = VIRTUAL_KEY.EXSEL;
pub const VK_EREOF = VIRTUAL_KEY.EREOF;
pub const VK_PLAY = VIRTUAL_KEY.PLAY;
pub const VK_ZOOM = VIRTUAL_KEY.ZOOM;
pub const VK_NONAME = VIRTUAL_KEY.NONAME;
pub const VK_PA1 = VIRTUAL_KEY.PA1;
pub const VK_OEM_CLEAR = VIRTUAL_KEY.OEM_CLEAR;

pub const VK_TO_BIT = extern struct {
    Vk: u8,
    ModBits: u8,
};

pub const MODIFIERS = extern struct {
    pVkToBit: ?*VK_TO_BIT,
    wMaxModBits: u16,
    ModNumber: [1]u8,
};

pub const VSC_VK = extern struct {
    Vsc: u8,
    Vk: u16,
};

pub const VK_VSC = extern struct {
    Vk: u8,
    Vsc: u8,
};

pub const VK_TO_WCHARS1 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [1]u16,
};

pub const VK_TO_WCHARS2 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [2]u16,
};

pub const VK_TO_WCHARS3 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [3]u16,
};

pub const VK_TO_WCHARS4 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [4]u16,
};

pub const VK_TO_WCHARS5 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [5]u16,
};

pub const VK_TO_WCHARS6 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [6]u16,
};

pub const VK_TO_WCHARS7 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [7]u16,
};

pub const VK_TO_WCHARS8 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [8]u16,
};

pub const VK_TO_WCHARS9 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [9]u16,
};

pub const VK_TO_WCHARS10 = extern struct {
    VirtualKey: u8,
    Attributes: u8,
    wch: [10]u16,
};

pub const VK_TO_WCHAR_TABLE = extern struct {
    pVkToWchars: ?*VK_TO_WCHARS1,
    nModifications: u8,
    cbSize: u8,
};

pub const DEADKEY = extern struct {
    dwBoth: u32,
    wchComposed: u16,
    uFlags: u16,
};

pub const LIGATURE1 = extern struct {
    VirtualKey: u8,
    ModificationNumber: u16,
    wch: [1]u16,
};

pub const LIGATURE2 = extern struct {
    VirtualKey: u8,
    ModificationNumber: u16,
    wch: [2]u16,
};

pub const LIGATURE3 = extern struct {
    VirtualKey: u8,
    ModificationNumber: u16,
    wch: [3]u16,
};

pub const LIGATURE4 = extern struct {
    VirtualKey: u8,
    ModificationNumber: u16,
    wch: [4]u16,
};

pub const LIGATURE5 = extern struct {
    VirtualKey: u8,
    ModificationNumber: u16,
    wch: [5]u16,
};

pub const VSC_LPWSTR = extern struct {
    vsc: u8,
    pwsz: ?PWSTR,
};

pub const tagKbdLayer = extern struct {
    pCharModifiers: ?*MODIFIERS,
    pVkToWcharTable: ?*VK_TO_WCHAR_TABLE,
    pDeadKey: ?*DEADKEY,
    pKeyNames: ?*VSC_LPWSTR,
    pKeyNamesExt: ?*VSC_LPWSTR,
    pKeyNamesDead: ?*?*u16,
    pusVSCtoVK: ?*u16,
    bMaxVSCtoVK: u8,
    pVSCtoVK_E0: ?*VSC_VK,
    pVSCtoVK_E1: ?*VSC_VK,
    fLocaleFlags: u32,
    nLgMax: u8,
    cbLgEntry: u8,
    pLigature: ?*LIGATURE1,
    dwType: u32,
    dwSubType: u32,
};

pub const _VK_FUNCTION_PARAM = extern struct {
    NLSFEProcIndex: u8,
    NLSFEProcParam: u32,
};

pub const _VK_TO_FUNCTION_TABLE = extern struct {
    Vk: u8,
    NLSFEProcType: u8,
    NLSFEProcCurrent: u8,
    NLSFEProcSwitch: u8,
    NLSFEProc: [8]_VK_FUNCTION_PARAM,
    NLSFEProcAlt: [8]_VK_FUNCTION_PARAM,
};

pub const tagKbdNlsLayer = extern struct {
    OEMIdentifier: u16,
    LayoutInformation: u16,
    NumOfVkToF: u32,
    pVkToF: ?*_VK_TO_FUNCTION_TABLE,
    NumOfMouseVKey: i32,
    pusMouseVKey: ?*u16,
};

pub const KBDTABLE_DESC = extern struct {
    wszDllName: [32]u16,
    dwType: u32,
    dwSubType: u32,
};

pub const KBDTABLE_MULTI = extern struct {
    nTables: u32,
    aKbdTables: [8]KBDTABLE_DESC,
};

pub const KBD_TYPE_INFO = extern struct {
    dwVersion: u32,
    dwType: u32,
    dwSubType: u32,
};

pub const MOUSEMOVEPOINT = extern struct {
    x: i32,
    y: i32,
    time: u32,
    dwExtraInfo: usize,
};

pub const TRACKMOUSEEVENT = extern struct {
    cbSize: u32,
    dwFlags: TRACKMOUSEEVENT_FLAGS,
    hwndTrack: ?HWND,
    dwHoverTime: u32,
};

pub const MOUSEINPUT = extern struct {
    dx: i32,
    dy: i32,
    mouseData: u32,
    dwFlags: MOUSE_EVENT_FLAGS,
    time: u32,
    dwExtraInfo: usize,
};

pub const KEYBDINPUT = extern struct {
    wVk: VIRTUAL_KEY,
    wScan: u16,
    dwFlags: KEYBD_EVENT_FLAGS,
    time: u32,
    dwExtraInfo: usize,
};

pub const HARDWAREINPUT = extern struct {
    uMsg: u32,
    wParamL: u16,
    wParamH: u16,
};

pub const INPUT = extern struct {
    type: INPUT_TYPE,
    Anonymous: extern union {
        mi: MOUSEINPUT,
        ki: KEYBDINPUT,
        hi: HARDWAREINPUT,
    },
};

pub const LASTINPUTINFO = extern struct {
    cbSize: u32,
    dwTime: u32,
};

//--------------------------------------------------------------------------------
// Section: Functions (52)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.0'
pub extern "comctl32" fn _TrackMouseEvent(
    lpEventTrack: ?*TRACKMOUSEEVENT,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn LoadKeyboardLayoutA(
    pwszKLID: ?[*:0]const u8,
    Flags: ACTIVATE_KEYBOARD_LAYOUT_FLAGS,
) callconv(@import("std").os.windows.WINAPI) ?HKL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn LoadKeyboardLayoutW(
    pwszKLID: ?[*:0]const u16,
    Flags: ACTIVATE_KEYBOARD_LAYOUT_FLAGS,
) callconv(@import("std").os.windows.WINAPI) ?HKL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn ActivateKeyboardLayout(
    hkl: ?HKL,
    Flags: ACTIVATE_KEYBOARD_LAYOUT_FLAGS,
) callconv(@import("std").os.windows.WINAPI) ?HKL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn ToUnicodeEx(
    wVirtKey: u32,
    wScanCode: u32,
    lpKeyState: *[256]u8,
    pwszBuff: [*:0]u16,
    cchBuff: i32,
    wFlags: u32,
    dwhkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn UnloadKeyboardLayout(
    hkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyboardLayoutNameA(
    pwszKLID: *[9]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyboardLayoutNameW(
    pwszKLID: *[9]u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyboardLayoutList(
    nBuff: i32,
    lpList: ?[*]?HKL,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyboardLayout(
    idThread: u32,
) callconv(@import("std").os.windows.WINAPI) ?HKL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetMouseMovePointsEx(
    cbSize: u32,
    lppt: ?*MOUSEMOVEPOINT,
    lpptBuf: [*]MOUSEMOVEPOINT,
    nBufPoints: i32,
    resolution: GET_MOUSE_MOVE_POINTS_EX_RESOLUTION,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn TrackMouseEvent(
    lpEventTrack: ?*TRACKMOUSEEVENT,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "user32" fn RegisterHotKey(
    hWnd: ?HWND,
    id: i32,
    fsModifiers: HOT_KEY_MODIFIERS,
    vk: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn UnregisterHotKey(
    hWnd: ?HWND,
    id: i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SwapMouseButton(
    fSwap: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetDoubleClickTime() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SetDoubleClickTime(
    param0: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SetFocus(
    hWnd: ?HWND,
) callconv(@import("std").os.windows.WINAPI) ?HWND;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetActiveWindow() callconv(@import("std").os.windows.WINAPI) ?HWND;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetFocus() callconv(@import("std").os.windows.WINAPI) ?HWND;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKBCodePage() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyState(
    nVirtKey: i32,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetAsyncKeyState(
    vKey: i32,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyboardState(
    lpKeyState: *[256]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SetKeyboardState(
    lpKeyState: *[256]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyNameTextA(
    lParam: i32,
    lpString: [*:0]u8,
    cchSize: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyNameTextW(
    lParam: i32,
    lpString: [*:0]u16,
    cchSize: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetKeyboardType(
    nTypeFlag: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn ToAscii(
    uVirtKey: u32,
    uScanCode: u32,
    lpKeyState: ?*[256]u8,
    lpChar: ?*u16,
    uFlags: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn ToAsciiEx(
    uVirtKey: u32,
    uScanCode: u32,
    lpKeyState: ?*[256]u8,
    lpChar: ?*u16,
    uFlags: u32,
    dwhkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn ToUnicode(
    wVirtKey: u32,
    wScanCode: u32,
    lpKeyState: ?*[256]u8,
    pwszBuff: [*:0]u16,
    cchBuff: i32,
    wFlags: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn OemKeyScan(
    wOemChar: u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn VkKeyScanA(
    ch: CHAR,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn VkKeyScanW(
    ch: u16,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn VkKeyScanExA(
    ch: CHAR,
    dwhkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn VkKeyScanExW(
    ch: u16,
    dwhkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) i16;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn keybd_event(
    bVk: u8,
    bScan: u8,
    dwFlags: KEYBD_EVENT_FLAGS,
    dwExtraInfo: usize,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn mouse_event(
    dwFlags: MOUSE_EVENT_FLAGS,
    dx: i32,
    dy: i32,
    dwData: u32,
    dwExtraInfo: usize,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SendInput(
    cInputs: u32,
    pInputs: [*]INPUT,
    cbSize: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetLastInputInfo(
    plii: ?*LASTINPUTINFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn MapVirtualKeyA(
    uCode: u32,
    uMapType: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn MapVirtualKeyW(
    uCode: u32,
    uMapType: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn MapVirtualKeyExA(
    uCode: u32,
    uMapType: u32,
    dwhkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn MapVirtualKeyExW(
    uCode: u32,
    uMapType: u32,
    dwhkl: ?HKL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn GetCapture() callconv(@import("std").os.windows.WINAPI) ?HWND;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SetCapture(
    hWnd: ?HWND,
) callconv(@import("std").os.windows.WINAPI) ?HWND;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn ReleaseCapture() callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn EnableWindow(
    hWnd: ?HWND,
    bEnable: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn IsWindowEnabled(
    hWnd: ?HWND,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn DragDetect(
    hwnd: ?HWND,
    pt: POINT,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn SetActiveWindow(
    hWnd: ?HWND,
) callconv(@import("std").os.windows.WINAPI) ?HWND;

// TODO: this type is limited to platform 'windows5.0'
pub extern "user32" fn BlockInput(
    fBlockIt: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (7)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const LoadKeyboardLayout = thismodule.LoadKeyboardLayoutA;
        pub const GetKeyboardLayoutName = thismodule.GetKeyboardLayoutNameA;
        pub const GetKeyNameText = thismodule.GetKeyNameTextA;
        pub const VkKeyScan = thismodule.VkKeyScanA;
        pub const VkKeyScanEx = thismodule.VkKeyScanExA;
        pub const MapVirtualKey = thismodule.MapVirtualKeyA;
        pub const MapVirtualKeyEx = thismodule.MapVirtualKeyExA;
    },
    .wide => struct {
        pub const LoadKeyboardLayout = thismodule.LoadKeyboardLayoutW;
        pub const GetKeyboardLayoutName = thismodule.GetKeyboardLayoutNameW;
        pub const GetKeyNameText = thismodule.GetKeyNameTextW;
        pub const VkKeyScan = thismodule.VkKeyScanW;
        pub const VkKeyScanEx = thismodule.VkKeyScanExW;
        pub const MapVirtualKey = thismodule.MapVirtualKeyW;
        pub const MapVirtualKeyEx = thismodule.MapVirtualKeyExW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const LoadKeyboardLayout = *opaque {};
        pub const GetKeyboardLayoutName = *opaque {};
        pub const GetKeyNameText = *opaque {};
        pub const VkKeyScan = *opaque {};
        pub const VkKeyScanEx = *opaque {};
        pub const MapVirtualKey = *opaque {};
        pub const MapVirtualKeyEx = *opaque {};
    } else struct {
        pub const LoadKeyboardLayout = @compileError("'LoadKeyboardLayout' requires that UNICODE be set to true or false in the root module");
        pub const GetKeyboardLayoutName = @compileError("'GetKeyboardLayoutName' requires that UNICODE be set to true or false in the root module");
        pub const GetKeyNameText = @compileError("'GetKeyNameText' requires that UNICODE be set to true or false in the root module");
        pub const VkKeyScan = @compileError("'VkKeyScan' requires that UNICODE be set to true or false in the root module");
        pub const VkKeyScanEx = @compileError("'VkKeyScanEx' requires that UNICODE be set to true or false in the root module");
        pub const MapVirtualKey = @compileError("'MapVirtualKey' requires that UNICODE be set to true or false in the root module");
        pub const MapVirtualKeyEx = @compileError("'MapVirtualKeyEx' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const BOOL = @import("../../foundation.zig").BOOL;
const CHAR = @import("../../foundation.zig").CHAR;
const HKL = @import("../../ui/text_services.zig").HKL;
const HWND = @import("../../foundation.zig").HWND;
const POINT = @import("../../foundation.zig").POINT;
const PSTR = @import("../../foundation.zig").PSTR;
const PWSTR = @import("../../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
