//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (83)
//--------------------------------------------------------------------------------
pub const CATID_WcsPlugin = Guid.initString("a0b402e0-8240-405f-8a16-8a5b4df2f0dd");
pub const MAX_COLOR_CHANNELS = @as(u32, 8);
pub const INTENT_PERCEPTUAL = @as(u32, 0);
pub const INTENT_RELATIVE_COLORIMETRIC = @as(u32, 1);
pub const INTENT_SATURATION = @as(u32, 2);
pub const INTENT_ABSOLUTE_COLORIMETRIC = @as(u32, 3);
pub const FLAG_EMBEDDEDPROFILE = @as(u32, 1);
pub const FLAG_DEPENDENTONDATA = @as(u32, 2);
pub const FLAG_ENABLE_CHROMATIC_ADAPTATION = @as(u32, 33554432);
pub const ATTRIB_TRANSPARENCY = @as(u32, 1);
pub const ATTRIB_MATTE = @as(u32, 2);
pub const PROFILE_FILENAME = @as(u32, 1);
pub const PROFILE_MEMBUFFER = @as(u32, 2);
pub const PROFILE_READ = @as(u32, 1);
pub const PROFILE_READWRITE = @as(u32, 2);
pub const INDEX_DONT_CARE = @as(u32, 0);
pub const CMM_FROM_PROFILE = @as(u32, 0);
pub const ENUM_TYPE_VERSION = @as(u32, 768);
pub const ET_DEVICENAME = @as(u32, 1);
pub const ET_MEDIATYPE = @as(u32, 2);
pub const ET_DITHERMODE = @as(u32, 4);
pub const ET_RESOLUTION = @as(u32, 8);
pub const ET_CMMTYPE = @as(u32, 16);
pub const ET_CLASS = @as(u32, 32);
pub const ET_DATACOLORSPACE = @as(u32, 64);
pub const ET_CONNECTIONSPACE = @as(u32, 128);
pub const ET_SIGNATURE = @as(u32, 256);
pub const ET_PLATFORM = @as(u32, 512);
pub const ET_PROFILEFLAGS = @as(u32, 1024);
pub const ET_MANUFACTURER = @as(u32, 2048);
pub const ET_MODEL = @as(u32, 4096);
pub const ET_ATTRIBUTES = @as(u32, 8192);
pub const ET_RENDERINGINTENT = @as(u32, 16384);
pub const ET_CREATOR = @as(u32, 32768);
pub const ET_DEVICECLASS = @as(u32, 65536);
pub const ET_STANDARDDISPLAYCOLOR = @as(u32, 131072);
pub const ET_EXTENDEDDISPLAYCOLOR = @as(u32, 262144);
pub const PROOF_MODE = @as(u32, 1);
pub const NORMAL_MODE = @as(u32, 2);
pub const BEST_MODE = @as(u32, 3);
pub const ENABLE_GAMUT_CHECKING = @as(u32, 65536);
pub const USE_RELATIVE_COLORIMETRIC = @as(u32, 131072);
pub const FAST_TRANSLATE = @as(u32, 262144);
pub const PRESERVEBLACK = @as(u32, 1048576);
pub const WCS_ALWAYS = @as(u32, 2097152);
pub const SEQUENTIAL_TRANSFORM = @as(u32, 2155872256);
pub const RESERVED = @as(u32, 2147483648);
pub const CSA_A = @as(u32, 1);
pub const CSA_ABC = @as(u32, 2);
pub const CSA_DEF = @as(u32, 3);
pub const CSA_DEFG = @as(u32, 4);
pub const CSA_GRAY = @as(u32, 5);
pub const CSA_RGB = @as(u32, 6);
pub const CSA_CMYK = @as(u32, 7);
pub const CSA_Lab = @as(u32, 8);
pub const CMM_WIN_VERSION = @as(u32, 0);
pub const CMM_IDENT = @as(u32, 1);
pub const CMM_DRIVER_VERSION = @as(u32, 2);
pub const CMM_DLL_VERSION = @as(u32, 3);
pub const CMM_VERSION = @as(u32, 4);
pub const CMM_DESCRIPTION = @as(u32, 5);
pub const CMM_LOGOICON = @as(u32, 6);
pub const CMS_FORWARD = @as(u32, 0);
pub const CMS_BACKWARD = @as(u32, 1);
pub const COLOR_MATCH_VERSION = @as(u32, 512);
pub const CMS_DISABLEICM = @as(u32, 1);
pub const CMS_ENABLEPROOFING = @as(u32, 2);
pub const CMS_SETRENDERINTENT = @as(u32, 4);
pub const CMS_SETPROOFINTENT = @as(u32, 8);
pub const CMS_SETMONITORPROFILE = @as(u32, 16);
pub const CMS_SETPRINTERPROFILE = @as(u32, 32);
pub const CMS_SETTARGETPROFILE = @as(u32, 64);
pub const CMS_USEHOOK = @as(u32, 128);
pub const CMS_USEAPPLYCALLBACK = @as(u32, 256);
pub const CMS_USEDESCRIPTION = @as(u32, 512);
pub const CMS_DISABLEINTENT = @as(u32, 1024);
pub const CMS_DISABLERENDERINTENT = @as(u32, 2048);
pub const CMS_MONITOROVERFLOW = @as(i32, -2147483648);
pub const CMS_PRINTEROVERFLOW = @as(i32, 1073741824);
pub const CMS_TARGETOVERFLOW = @as(i32, 536870912);
pub const DONT_USE_EMBEDDED_WCS_PROFILES = @as(i32, 1);
pub const WCS_DEFAULT = @as(i32, 0);
pub const WCS_ICCONLY = @as(i32, 65536);

//--------------------------------------------------------------------------------
// Section: Types (49)
//--------------------------------------------------------------------------------
pub const ICM_COMMAND = enum(u32) {
    ADDPROFILE = 1,
    DELETEPROFILE = 2,
    QUERYPROFILE = 3,
    SETDEFAULTPROFILE = 4,
    REGISTERICMATCHER = 5,
    UNREGISTERICMATCHER = 6,
    QUERYMATCH = 7,
};
pub const ICM_ADDPROFILE = ICM_COMMAND.ADDPROFILE;
pub const ICM_DELETEPROFILE = ICM_COMMAND.DELETEPROFILE;
pub const ICM_QUERYPROFILE = ICM_COMMAND.QUERYPROFILE;
pub const ICM_SETDEFAULTPROFILE = ICM_COMMAND.SETDEFAULTPROFILE;
pub const ICM_REGISTERICMATCHER = ICM_COMMAND.REGISTERICMATCHER;
pub const ICM_UNREGISTERICMATCHER = ICM_COMMAND.UNREGISTERICMATCHER;
pub const ICM_QUERYMATCH = ICM_COMMAND.QUERYMATCH;

pub const COLOR_MATCH_TO_TARGET_ACTION = enum(i32) {
    ENABLE = 1,
    DISABLE = 2,
    DELETE_TRANSFORM = 3,
};
pub const CS_ENABLE = COLOR_MATCH_TO_TARGET_ACTION.ENABLE;
pub const CS_DISABLE = COLOR_MATCH_TO_TARGET_ACTION.DISABLE;
pub const CS_DELETE_TRANSFORM = COLOR_MATCH_TO_TARGET_ACTION.DELETE_TRANSFORM;

// TODO: this type has a FreeFunc 'DeleteColorSpace', what can Zig do with this information?
pub const HCOLORSPACE = *opaque {};

pub const LOGCOLORSPACEA = extern struct {
    lcsSignature: u32,
    lcsVersion: u32,
    lcsSize: u32,
    lcsCSType: i32,
    lcsIntent: i32,
    lcsEndpoints: CIEXYZTRIPLE,
    lcsGammaRed: u32,
    lcsGammaGreen: u32,
    lcsGammaBlue: u32,
    lcsFilename: [260]CHAR,
};

pub const LOGCOLORSPACEW = extern struct {
    lcsSignature: u32,
    lcsVersion: u32,
    lcsSize: u32,
    lcsCSType: i32,
    lcsIntent: i32,
    lcsEndpoints: CIEXYZTRIPLE,
    lcsGammaRed: u32,
    lcsGammaGreen: u32,
    lcsGammaBlue: u32,
    lcsFilename: [260]u16,
};

pub const ICMENUMPROCA = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?PSTR,
        param1: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) i32,
    else => *const fn (
        param0: ?PSTR,
        param1: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) i32,
};

pub const ICMENUMPROCW = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?PWSTR,
        param1: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) i32,
    else => *const fn (
        param0: ?PWSTR,
        param1: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) i32,
};

pub const EMRCREATECOLORSPACE = extern struct {
    emr: EMR,
    ihCS: u32,
    lcs: LOGCOLORSPACEA,
};

pub const EMRCREATECOLORSPACEW = extern struct {
    emr: EMR,
    ihCS: u32,
    lcs: LOGCOLORSPACEW,
    dwFlags: u32,
    cbData: u32,
    Data: [1]u8,
};

pub const XYZColorF = extern struct {
    X: f32,
    Y: f32,
    Z: f32,
};

pub const JChColorF = extern struct {
    J: f32,
    C: f32,
    h: f32,
};

pub const JabColorF = extern struct {
    J: f32,
    a: f32,
    b: f32,
};

pub const GamutShellTriangle = extern struct {
    aVertexIndex: [3]u32,
};

pub const GamutShell = extern struct {
    JMin: f32,
    JMax: f32,
    cVertices: u32,
    cTriangles: u32,
    pVertices: ?*JabColorF,
    pTriangles: ?*GamutShellTriangle,
};

pub const PrimaryJabColors = extern struct {
    red: JabColorF,
    yellow: JabColorF,
    green: JabColorF,
    cyan: JabColorF,
    blue: JabColorF,
    magenta: JabColorF,
    black: JabColorF,
    white: JabColorF,
};

pub const PrimaryXYZColors = extern struct {
    red: XYZColorF,
    yellow: XYZColorF,
    green: XYZColorF,
    cyan: XYZColorF,
    blue: XYZColorF,
    magenta: XYZColorF,
    black: XYZColorF,
    white: XYZColorF,
};

pub const GamutBoundaryDescription = extern struct {
    pPrimaries: ?*PrimaryJabColors,
    cNeutralSamples: u32,
    pNeutralSamples: ?*JabColorF,
    pReferenceShell: ?*GamutShell,
    pPlausibleShell: ?*GamutShell,
    pPossibleShell: ?*GamutShell,
};

pub const BlackInformation = extern struct {
    fBlackOnly: BOOL,
    blackWeight: f32,
};

const IID_IDeviceModelPlugIn_Value = Guid.initString("1cd63475-07c4-46fe-a903-d655316d11fd");
pub const IID_IDeviceModelPlugIn = &IID_IDeviceModelPlugIn_Value;
pub const IDeviceModelPlugIn = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                bstrXml: ?BSTR,
                cNumModels: u32,
                iModelPosition: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                bstrXml: ?BSTR,
                cNumModels: u32,
                iModelPosition: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNumChannels: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                pNumChannels: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                pNumChannels: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeviceToColorimetricColors: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                cChannels: u32,
                pDeviceValues: ?*const f32,
                pXYZColors: [*]XYZColorF,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                cChannels: u32,
                pDeviceValues: ?*const f32,
                pXYZColors: [*]XYZColorF,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ColorimetricToDeviceColors: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                cChannels: u32,
                pXYZColors: [*]const XYZColorF,
                pDeviceValues: ?*f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                cChannels: u32,
                pXYZColors: [*]const XYZColorF,
                pDeviceValues: ?*f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ColorimetricToDeviceColorsWithBlack: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                cChannels: u32,
                pXYZColors: [*]const XYZColorF,
                pBlackInformation: [*]const BlackInformation,
                pDeviceValues: ?*f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                cChannels: u32,
                pXYZColors: [*]const XYZColorF,
                pBlackInformation: [*]const BlackInformation,
                pDeviceValues: ?*f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransformDeviceModelInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                iModelPosition: u32,
                pIDeviceModelOther: ?*IDeviceModelPlugIn,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                iModelPosition: u32,
                pIDeviceModelOther: ?*IDeviceModelPlugIn,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPrimarySamples: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                pPrimaryColor: ?*PrimaryXYZColors,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                pPrimaryColor: ?*PrimaryXYZColors,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetGamutBoundaryMeshSize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                pNumVertices: ?*u32,
                pNumTriangles: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                pNumVertices: ?*u32,
                pNumTriangles: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetGamutBoundaryMesh: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                cChannels: u32,
                cVertices: u32,
                cTriangles: u32,
                pVertices: ?*f32,
                pTriangles: [*]GamutShellTriangle,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                cChannels: u32,
                cVertices: u32,
                cTriangles: u32,
                pVertices: ?*f32,
                pTriangles: [*]GamutShellTriangle,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNeutralAxisSize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                pcColors: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                pcColors: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNeutralAxis: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                pXYZColors: [*]XYZColorF,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDeviceModelPlugIn,
                cColors: u32,
                pXYZColors: [*]XYZColorF,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_Initialize(self: *const T, bstrXml: ?BSTR, cNumModels: u32, iModelPosition: u32) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IDeviceModelPlugIn, @ptrCast(self)), bstrXml, cNumModels, iModelPosition);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_GetNumChannels(self: *const T, pNumChannels: ?*u32) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).GetNumChannels(@as(*const IDeviceModelPlugIn, @ptrCast(self)), pNumChannels);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_DeviceToColorimetricColors(self: *const T, cColors: u32, cChannels: u32, pDeviceValues: ?*const f32, pXYZColors: [*]XYZColorF) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).DeviceToColorimetricColors(@as(*const IDeviceModelPlugIn, @ptrCast(self)), cColors, cChannels, pDeviceValues, pXYZColors);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_ColorimetricToDeviceColors(self: *const T, cColors: u32, cChannels: u32, pXYZColors: [*]const XYZColorF, pDeviceValues: ?*f32) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).ColorimetricToDeviceColors(@as(*const IDeviceModelPlugIn, @ptrCast(self)), cColors, cChannels, pXYZColors, pDeviceValues);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_ColorimetricToDeviceColorsWithBlack(self: *const T, cColors: u32, cChannels: u32, pXYZColors: [*]const XYZColorF, pBlackInformation: [*]const BlackInformation, pDeviceValues: ?*f32) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).ColorimetricToDeviceColorsWithBlack(@as(*const IDeviceModelPlugIn, @ptrCast(self)), cColors, cChannels, pXYZColors, pBlackInformation, pDeviceValues);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_SetTransformDeviceModelInfo(self: *const T, iModelPosition: u32, pIDeviceModelOther: ?*IDeviceModelPlugIn) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).SetTransformDeviceModelInfo(@as(*const IDeviceModelPlugIn, @ptrCast(self)), iModelPosition, pIDeviceModelOther);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_GetPrimarySamples(self: *const T, pPrimaryColor: ?*PrimaryXYZColors) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).GetPrimarySamples(@as(*const IDeviceModelPlugIn, @ptrCast(self)), pPrimaryColor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_GetGamutBoundaryMeshSize(self: *const T, pNumVertices: ?*u32, pNumTriangles: ?*u32) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).GetGamutBoundaryMeshSize(@as(*const IDeviceModelPlugIn, @ptrCast(self)), pNumVertices, pNumTriangles);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_GetGamutBoundaryMesh(self: *const T, cChannels: u32, cVertices: u32, cTriangles: u32, pVertices: ?*f32, pTriangles: [*]GamutShellTriangle) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).GetGamutBoundaryMesh(@as(*const IDeviceModelPlugIn, @ptrCast(self)), cChannels, cVertices, cTriangles, pVertices, pTriangles);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_GetNeutralAxisSize(self: *const T, pcColors: ?*u32) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).GetNeutralAxisSize(@as(*const IDeviceModelPlugIn, @ptrCast(self)), pcColors);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDeviceModelPlugIn_GetNeutralAxis(self: *const T, cColors: u32, pXYZColors: [*]XYZColorF) HRESULT {
                return @as(*const IDeviceModelPlugIn.VTable, @ptrCast(self.vtable)).GetNeutralAxis(@as(*const IDeviceModelPlugIn, @ptrCast(self)), cColors, pXYZColors);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IGamutMapModelPlugIn_Value = Guid.initString("2dd80115-ad1e-41f6-a219-a4f4b583d1f9");
pub const IID_IGamutMapModelPlugIn = &IID_IGamutMapModelPlugIn_Value;
pub const IGamutMapModelPlugIn = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGamutMapModelPlugIn,
                bstrXml: ?BSTR,
                pSrcPlugIn: ?*IDeviceModelPlugIn,
                pDestPlugIn: ?*IDeviceModelPlugIn,
                pSrcGBD: ?*GamutBoundaryDescription,
                pDestGBD: ?*GamutBoundaryDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGamutMapModelPlugIn,
                bstrXml: ?BSTR,
                pSrcPlugIn: ?*IDeviceModelPlugIn,
                pDestPlugIn: ?*IDeviceModelPlugIn,
                pSrcGBD: ?*GamutBoundaryDescription,
                pDestGBD: ?*GamutBoundaryDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SourceToDestinationAppearanceColors: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGamutMapModelPlugIn,
                cColors: u32,
                pInputColors: [*]const JChColorF,
                pOutputColors: [*]JChColorF,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGamutMapModelPlugIn,
                cColors: u32,
                pInputColors: [*]const JChColorF,
                pOutputColors: [*]JChColorF,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGamutMapModelPlugIn_Initialize(self: *const T, bstrXml: ?BSTR, pSrcPlugIn: ?*IDeviceModelPlugIn, pDestPlugIn: ?*IDeviceModelPlugIn, pSrcGBD: ?*GamutBoundaryDescription, pDestGBD: ?*GamutBoundaryDescription) HRESULT {
                return @as(*const IGamutMapModelPlugIn.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IGamutMapModelPlugIn, @ptrCast(self)), bstrXml, pSrcPlugIn, pDestPlugIn, pSrcGBD, pDestGBD);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGamutMapModelPlugIn_SourceToDestinationAppearanceColors(self: *const T, cColors: u32, pInputColors: [*]const JChColorF, pOutputColors: [*]JChColorF) HRESULT {
                return @as(*const IGamutMapModelPlugIn.VTable, @ptrCast(self.vtable)).SourceToDestinationAppearanceColors(@as(*const IGamutMapModelPlugIn, @ptrCast(self)), cColors, pInputColors, pOutputColors);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const NAMED_PROFILE_INFO = extern struct {
    dwFlags: u32,
    dwCount: u32,
    dwCountDevCoordinates: u32,
    szPrefix: [32]i8,
    szSuffix: [32]i8,
};

pub const GRAYCOLOR = extern struct {
    gray: u16,
};

pub const RGBCOLOR = extern struct {
    red: u16,
    green: u16,
    blue: u16,
};

pub const CMYKCOLOR = extern struct {
    cyan: u16,
    magenta: u16,
    yellow: u16,
    black: u16,
};

pub const XYZCOLOR = extern struct {
    X: u16,
    Y: u16,
    Z: u16,
};

pub const YxyCOLOR = extern struct {
    Y: u16,
    x: u16,
    y: u16,
};

pub const LabCOLOR = extern struct {
    L: u16,
    a: u16,
    b: u16,
};

pub const GENERIC3CHANNEL = extern struct {
    ch1: u16,
    ch2: u16,
    ch3: u16,
};

pub const NAMEDCOLOR = extern struct {
    dwIndex: u32,
};

pub const HiFiCOLOR = extern struct {
    channel: [8]u8,
};

pub const COLOR = extern union {
    gray: GRAYCOLOR,
    rgb: RGBCOLOR,
    cmyk: CMYKCOLOR,
    XYZ: XYZCOLOR,
    Yxy: YxyCOLOR,
    Lab: LabCOLOR,
    gen3ch: GENERIC3CHANNEL,
    named: NAMEDCOLOR,
    hifi: HiFiCOLOR,
    Anonymous: extern struct {
        reserved1: u32,
        reserved2: ?*anyopaque,
    },
};

pub const COLORTYPE = enum(i32) {
    GRAY = 1,
    RGB = 2,
    XYZ = 3,
    Yxy = 4,
    Lab = 5,
    @"3_CHANNEL" = 6,
    CMYK = 7,
    @"5_CHANNEL" = 8,
    @"6_CHANNEL" = 9,
    @"7_CHANNEL" = 10,
    @"8_CHANNEL" = 11,
    NAMED = 12,
};
pub const COLOR_GRAY = COLORTYPE.GRAY;
pub const COLOR_RGB = COLORTYPE.RGB;
pub const COLOR_XYZ = COLORTYPE.XYZ;
pub const COLOR_Yxy = COLORTYPE.Yxy;
pub const COLOR_Lab = COLORTYPE.Lab;
pub const COLOR_3_CHANNEL = COLORTYPE.@"3_CHANNEL";
pub const COLOR_CMYK = COLORTYPE.CMYK;
pub const COLOR_5_CHANNEL = COLORTYPE.@"5_CHANNEL";
pub const COLOR_6_CHANNEL = COLORTYPE.@"6_CHANNEL";
pub const COLOR_7_CHANNEL = COLORTYPE.@"7_CHANNEL";
pub const COLOR_8_CHANNEL = COLORTYPE.@"8_CHANNEL";
pub const COLOR_NAMED = COLORTYPE.NAMED;

pub const COLORPROFILETYPE = enum(i32) {
    ICC = 0,
    DMP = 1,
    CAMP = 2,
    GMMP = 3,
};
pub const CPT_ICC = COLORPROFILETYPE.ICC;
pub const CPT_DMP = COLORPROFILETYPE.DMP;
pub const CPT_CAMP = COLORPROFILETYPE.CAMP;
pub const CPT_GMMP = COLORPROFILETYPE.GMMP;

pub const COLORPROFILESUBTYPE = enum(i32) {
    PERCEPTUAL = 0,
    RELATIVE_COLORIMETRIC = 1,
    SATURATION = 2,
    ABSOLUTE_COLORIMETRIC = 3,
    NONE = 4,
    RGB_WORKING_SPACE = 5,
    CUSTOM_WORKING_SPACE = 6,
    STANDARD_DISPLAY_COLOR_MODE = 7,
    EXTENDED_DISPLAY_COLOR_MODE = 8,
};
pub const CPST_PERCEPTUAL = COLORPROFILESUBTYPE.PERCEPTUAL;
pub const CPST_RELATIVE_COLORIMETRIC = COLORPROFILESUBTYPE.RELATIVE_COLORIMETRIC;
pub const CPST_SATURATION = COLORPROFILESUBTYPE.SATURATION;
pub const CPST_ABSOLUTE_COLORIMETRIC = COLORPROFILESUBTYPE.ABSOLUTE_COLORIMETRIC;
pub const CPST_NONE = COLORPROFILESUBTYPE.NONE;
pub const CPST_RGB_WORKING_SPACE = COLORPROFILESUBTYPE.RGB_WORKING_SPACE;
pub const CPST_CUSTOM_WORKING_SPACE = COLORPROFILESUBTYPE.CUSTOM_WORKING_SPACE;
pub const CPST_STANDARD_DISPLAY_COLOR_MODE = COLORPROFILESUBTYPE.STANDARD_DISPLAY_COLOR_MODE;
pub const CPST_EXTENDED_DISPLAY_COLOR_MODE = COLORPROFILESUBTYPE.EXTENDED_DISPLAY_COLOR_MODE;

pub const COLORDATATYPE = enum(i32) {
    BYTE = 1,
    WORD = 2,
    FLOAT = 3,
    S2DOT13FIXED = 4,
    @"10b_R10G10B10A2" = 5,
    @"10b_R10G10B10A2_XR" = 6,
    FLOAT16 = 7,
};
pub const COLOR_BYTE = COLORDATATYPE.BYTE;
pub const COLOR_WORD = COLORDATATYPE.WORD;
pub const COLOR_FLOAT = COLORDATATYPE.FLOAT;
pub const COLOR_S2DOT13FIXED = COLORDATATYPE.S2DOT13FIXED;
pub const COLOR_10b_R10G10B10A2 = COLORDATATYPE.@"10b_R10G10B10A2";
pub const COLOR_10b_R10G10B10A2_XR = COLORDATATYPE.@"10b_R10G10B10A2_XR";
pub const COLOR_FLOAT16 = COLORDATATYPE.FLOAT16;

pub const BMFORMAT = enum(i32) {
    x555RGB = 0,
    x555XYZ = 257,
    x555Yxy = 258,
    x555Lab = 259,
    x555G3CH = 260,
    RGBTRIPLETS = 2,
    BGRTRIPLETS = 4,
    XYZTRIPLETS = 513,
    YxyTRIPLETS = 514,
    LabTRIPLETS = 515,
    G3CHTRIPLETS = 516,
    @"5CHANNEL" = 517,
    @"6CHANNEL" = 518,
    @"7CHANNEL" = 519,
    @"8CHANNEL" = 520,
    GRAY = 521,
    xRGBQUADS = 8,
    xBGRQUADS = 16,
    xG3CHQUADS = 772,
    KYMCQUADS = 773,
    CMYKQUADS = 32,
    @"10b_RGB" = 9,
    @"10b_XYZ" = 1025,
    @"10b_Yxy" = 1026,
    @"10b_Lab" = 1027,
    @"10b_G3CH" = 1028,
    NAMED_INDEX = 1029,
    @"16b_RGB" = 10,
    @"16b_XYZ" = 1281,
    @"16b_Yxy" = 1282,
    @"16b_Lab" = 1283,
    @"16b_G3CH" = 1284,
    @"16b_GRAY" = 1285,
    @"565RGB" = 1,
    @"32b_scRGB" = 1537,
    @"32b_scARGB" = 1538,
    S2DOT13FIXED_scRGB = 1539,
    S2DOT13FIXED_scARGB = 1540,
    R10G10B10A2 = 1793,
    R10G10B10A2_XR = 1794,
    R16G16B16A16_FLOAT = 1795,
};
pub const BM_x555RGB = BMFORMAT.x555RGB;
pub const BM_x555XYZ = BMFORMAT.x555XYZ;
pub const BM_x555Yxy = BMFORMAT.x555Yxy;
pub const BM_x555Lab = BMFORMAT.x555Lab;
pub const BM_x555G3CH = BMFORMAT.x555G3CH;
pub const BM_RGBTRIPLETS = BMFORMAT.RGBTRIPLETS;
pub const BM_BGRTRIPLETS = BMFORMAT.BGRTRIPLETS;
pub const BM_XYZTRIPLETS = BMFORMAT.XYZTRIPLETS;
pub const BM_YxyTRIPLETS = BMFORMAT.YxyTRIPLETS;
pub const BM_LabTRIPLETS = BMFORMAT.LabTRIPLETS;
pub const BM_G3CHTRIPLETS = BMFORMAT.G3CHTRIPLETS;
pub const BM_5CHANNEL = BMFORMAT.@"5CHANNEL";
pub const BM_6CHANNEL = BMFORMAT.@"6CHANNEL";
pub const BM_7CHANNEL = BMFORMAT.@"7CHANNEL";
pub const BM_8CHANNEL = BMFORMAT.@"8CHANNEL";
pub const BM_GRAY = BMFORMAT.GRAY;
pub const BM_xRGBQUADS = BMFORMAT.xRGBQUADS;
pub const BM_xBGRQUADS = BMFORMAT.xBGRQUADS;
pub const BM_xG3CHQUADS = BMFORMAT.xG3CHQUADS;
pub const BM_KYMCQUADS = BMFORMAT.KYMCQUADS;
pub const BM_CMYKQUADS = BMFORMAT.CMYKQUADS;
pub const BM_10b_RGB = BMFORMAT.@"10b_RGB";
pub const BM_10b_XYZ = BMFORMAT.@"10b_XYZ";
pub const BM_10b_Yxy = BMFORMAT.@"10b_Yxy";
pub const BM_10b_Lab = BMFORMAT.@"10b_Lab";
pub const BM_10b_G3CH = BMFORMAT.@"10b_G3CH";
pub const BM_NAMED_INDEX = BMFORMAT.NAMED_INDEX;
pub const BM_16b_RGB = BMFORMAT.@"16b_RGB";
pub const BM_16b_XYZ = BMFORMAT.@"16b_XYZ";
pub const BM_16b_Yxy = BMFORMAT.@"16b_Yxy";
pub const BM_16b_Lab = BMFORMAT.@"16b_Lab";
pub const BM_16b_G3CH = BMFORMAT.@"16b_G3CH";
pub const BM_16b_GRAY = BMFORMAT.@"16b_GRAY";
pub const BM_565RGB = BMFORMAT.@"565RGB";
pub const BM_32b_scRGB = BMFORMAT.@"32b_scRGB";
pub const BM_32b_scARGB = BMFORMAT.@"32b_scARGB";
pub const BM_S2DOT13FIXED_scRGB = BMFORMAT.S2DOT13FIXED_scRGB;
pub const BM_S2DOT13FIXED_scARGB = BMFORMAT.S2DOT13FIXED_scARGB;
pub const BM_R10G10B10A2 = BMFORMAT.R10G10B10A2;
pub const BM_R10G10B10A2_XR = BMFORMAT.R10G10B10A2_XR;
pub const BM_R16G16B16A16_FLOAT = BMFORMAT.R16G16B16A16_FLOAT;

pub const LPBMCALLBACKFN = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: u32,
        param1: u32,
        param2: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        param0: u32,
        param1: u32,
        param2: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const PROFILEHEADER = extern struct {
    phSize: u32,
    phCMMType: u32,
    phVersion: u32,
    phClass: u32,
    phDataColorSpace: u32,
    phConnectionSpace: u32,
    phDateTime: [3]u32,
    phSignature: u32,
    phPlatform: u32,
    phProfileFlags: u32,
    phManufacturer: u32,
    phModel: u32,
    phAttributes: [2]u32,
    phRenderingIntent: u32,
    phIlluminant: CIEXYZ,
    phCreator: u32,
    phReserved: [44]u8,
};

pub const PROFILE = extern struct {
    dwType: u32,
    pProfileData: ?*anyopaque,
    cbDataSize: u32,
};

pub const ENUMTYPEA = extern struct {
    dwSize: u32,
    dwVersion: u32,
    dwFields: u32,
    pDeviceName: ?[*:0]const u8,
    dwMediaType: u32,
    dwDitheringMode: u32,
    dwResolution: [2]u32,
    dwCMMType: u32,
    dwClass: u32,
    dwDataColorSpace: u32,
    dwConnectionSpace: u32,
    dwSignature: u32,
    dwPlatform: u32,
    dwProfileFlags: u32,
    dwManufacturer: u32,
    dwModel: u32,
    dwAttributes: [2]u32,
    dwRenderingIntent: u32,
    dwCreator: u32,
    dwDeviceClass: u32,
};

pub const ENUMTYPEW = extern struct {
    dwSize: u32,
    dwVersion: u32,
    dwFields: u32,
    pDeviceName: ?[*:0]const u16,
    dwMediaType: u32,
    dwDitheringMode: u32,
    dwResolution: [2]u32,
    dwCMMType: u32,
    dwClass: u32,
    dwDataColorSpace: u32,
    dwConnectionSpace: u32,
    dwSignature: u32,
    dwPlatform: u32,
    dwProfileFlags: u32,
    dwManufacturer: u32,
    dwModel: u32,
    dwAttributes: [2]u32,
    dwRenderingIntent: u32,
    dwCreator: u32,
    dwDeviceClass: u32,
};

pub const WCS_PROFILE_MANAGEMENT_SCOPE = enum(i32) {
    SYSTEM_WIDE = 0,
    CURRENT_USER = 1,
};
pub const WCS_PROFILE_MANAGEMENT_SCOPE_SYSTEM_WIDE = WCS_PROFILE_MANAGEMENT_SCOPE.SYSTEM_WIDE;
pub const WCS_PROFILE_MANAGEMENT_SCOPE_CURRENT_USER = WCS_PROFILE_MANAGEMENT_SCOPE.CURRENT_USER;

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PCMSCALLBACKW = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PCMSCALLBACKA = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const COLORMATCHSETUPW = extern struct {
    dwSize: u32,
    dwVersion: u32,
    dwFlags: u32,
    hwndOwner: ?HWND,
    pSourceName: ?[*:0]const u16,
    pDisplayName: ?[*:0]const u16,
    pPrinterName: ?[*:0]const u16,
    dwRenderIntent: u32,
    dwProofingIntent: u32,
    pMonitorProfile: ?PWSTR,
    ccMonitorProfile: u32,
    pPrinterProfile: ?PWSTR,
    ccPrinterProfile: u32,
    pTargetProfile: ?PWSTR,
    ccTargetProfile: u32,
    lpfnHook: ?DLGPROC,
    lParam: LPARAM,
    lpfnApplyCallback: ?PCMSCALLBACKW,
    lParamApplyCallback: LPARAM,
};

pub const COLORMATCHSETUPA = extern struct {
    dwSize: u32,
    dwVersion: u32,
    dwFlags: u32,
    hwndOwner: ?HWND,
    pSourceName: ?[*:0]const u8,
    pDisplayName: ?[*:0]const u8,
    pPrinterName: ?[*:0]const u8,
    dwRenderIntent: u32,
    dwProofingIntent: u32,
    pMonitorProfile: ?PSTR,
    ccMonitorProfile: u32,
    pPrinterProfile: ?PSTR,
    ccPrinterProfile: u32,
    pTargetProfile: ?PSTR,
    ccTargetProfile: u32,
    lpfnHook: ?DLGPROC,
    lParam: LPARAM,
    lpfnApplyCallback: ?PCMSCALLBACKA,
    lParamApplyCallback: LPARAM,
};

pub const WCS_DEVICE_VCGT_CAPABILITIES = extern struct {
    Size: u32,
    SupportsVcgt: BOOL,
};

pub const WCS_DEVICE_MHC2_CAPABILITIES = extern struct {
    Size: u32,
    SupportsMhc2: BOOL,
    RegammaLutEntryCount: u32,
    CscXyzMatrixRows: u32,
    CscXyzMatrixColumns: u32,
};

pub const WCS_DEVICE_CAPABILITIES_TYPE = enum(i32) {
    VideoCardGammaTable = 1,
    MicrosoftHardwareColorV2 = 2,
};
pub const VideoCardGammaTable = WCS_DEVICE_CAPABILITIES_TYPE.VideoCardGammaTable;
pub const MicrosoftHardwareColorV2 = WCS_DEVICE_CAPABILITIES_TYPE.MicrosoftHardwareColorV2;

//--------------------------------------------------------------------------------
// Section: Functions (121)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn SetICMMode(
    hdc: ?HDC,
    mode: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn CheckColorsInGamut(
    hdc: ?HDC,
    lpRGBTriple: [*]RGBTRIPLE,
    // TODO: what to do with BytesParamIndex 3?
    dlpBuffer: ?*anyopaque,
    nCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn GetColorSpace(
    hdc: ?HDC,
) callconv(@import("std").os.windows.WINAPI) ?HCOLORSPACE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn GetLogColorSpaceA(
    hColorSpace: ?HCOLORSPACE,
    // TODO: what to do with BytesParamIndex 2?
    lpBuffer: ?*LOGCOLORSPACEA,
    nSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn GetLogColorSpaceW(
    hColorSpace: ?HCOLORSPACE,
    // TODO: what to do with BytesParamIndex 2?
    lpBuffer: ?*LOGCOLORSPACEW,
    nSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn CreateColorSpaceA(
    lplcs: ?*LOGCOLORSPACEA,
) callconv(@import("std").os.windows.WINAPI) ?HCOLORSPACE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn CreateColorSpaceW(
    lplcs: ?*LOGCOLORSPACEW,
) callconv(@import("std").os.windows.WINAPI) ?HCOLORSPACE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn SetColorSpace(
    hdc: ?HDC,
    hcs: ?HCOLORSPACE,
) callconv(@import("std").os.windows.WINAPI) ?HCOLORSPACE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn DeleteColorSpace(
    hcs: ?HCOLORSPACE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn GetICMProfileA(
    hdc: ?HDC,
    pBufSize: ?*u32,
    pszFilename: ?[*:0]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn GetICMProfileW(
    hdc: ?HDC,
    pBufSize: ?*u32,
    pszFilename: ?[*:0]u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn SetICMProfileA(
    hdc: ?HDC,
    lpFileName: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn SetICMProfileW(
    hdc: ?HDC,
    lpFileName: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn GetDeviceGammaRamp(
    hdc: ?HDC,
    lpRamp: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn SetDeviceGammaRamp(
    hdc: ?HDC,
    lpRamp: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn ColorMatchToTarget(
    hdc: ?HDC,
    hdcTarget: ?HDC,
    action: COLOR_MATCH_TO_TARGET_ACTION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn EnumICMProfilesA(
    hdc: ?HDC,
    proc: ?ICMENUMPROCA,
    param2: LPARAM,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn EnumICMProfilesW(
    hdc: ?HDC,
    proc: ?ICMENUMPROCW,
    param2: LPARAM,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn UpdateICMRegKeyA(
    reserved: u32,
    lpszCMID: ?PSTR,
    lpszFileName: ?PSTR,
    command: ICM_COMMAND,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn UpdateICMRegKeyW(
    reserved: u32,
    lpszCMID: ?PWSTR,
    lpszFileName: ?PWSTR,
    command: ICM_COMMAND,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "gdi32" fn ColorCorrectPalette(
    hdc: ?HDC,
    hPal: ?HPALETTE,
    deFirst: u32,
    num: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn OpenColorProfileA(
    pProfile: ?*PROFILE,
    dwDesiredAccess: u32,
    dwShareMode: u32,
    dwCreationMode: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn OpenColorProfileW(
    pProfile: ?*PROFILE,
    dwDesiredAccess: u32,
    dwShareMode: u32,
    dwCreationMode: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn CloseColorProfile(
    hProfile: isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetColorProfileFromHandle(
    hProfile: isize,
    // TODO: what to do with BytesParamIndex 2?
    pProfile: ?*u8,
    pcbProfile: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn IsColorProfileValid(
    hProfile: isize,
    pbValid: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn CreateProfileFromLogColorSpaceA(
    pLogColorSpace: ?*LOGCOLORSPACEA,
    pProfile: ?*?*u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn CreateProfileFromLogColorSpaceW(
    pLogColorSpace: ?*LOGCOLORSPACEW,
    pProfile: ?*?*u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetCountColorProfileElements(
    hProfile: isize,
    pnElementCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetColorProfileHeader(
    hProfile: isize,
    pHeader: ?*PROFILEHEADER,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetColorProfileElementTag(
    hProfile: isize,
    dwIndex: u32,
    pTag: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn IsColorProfileTagPresent(
    hProfile: isize,
    tag: u32,
    pbPresent: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetColorProfileElement(
    hProfile: isize,
    tag: u32,
    dwOffset: u32,
    pcbElement: ?*u32,
    // TODO: what to do with BytesParamIndex 3?
    pElement: ?*anyopaque,
    pbReference: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SetColorProfileHeader(
    hProfile: isize,
    pHeader: ?*PROFILEHEADER,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SetColorProfileElementSize(
    hProfile: isize,
    tagType: u32,
    pcbElement: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SetColorProfileElement(
    hProfile: isize,
    tag: u32,
    dwOffset: u32,
    pcbElement: ?*u32,
    pElement: [*]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SetColorProfileElementReference(
    hProfile: isize,
    newTag: u32,
    refTag: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetPS2ColorSpaceArray(
    hProfile: isize,
    dwIntent: u32,
    dwCSAType: u32,
    // TODO: what to do with BytesParamIndex 4?
    pPS2ColorSpaceArray: ?*u8,
    pcbPS2ColorSpaceArray: ?*u32,
    pbBinary: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetPS2ColorRenderingIntent(
    hProfile: isize,
    dwIntent: u32,
    // TODO: what to do with BytesParamIndex 3?
    pBuffer: ?*u8,
    pcbPS2ColorRenderingIntent: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetPS2ColorRenderingDictionary(
    hProfile: isize,
    dwIntent: u32,
    // TODO: what to do with BytesParamIndex 3?
    pPS2ColorRenderingDictionary: ?*u8,
    pcbPS2ColorRenderingDictionary: ?*u32,
    pbBinary: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetNamedProfileInfo(
    hProfile: isize,
    pNamedProfileInfo: ?*NAMED_PROFILE_INFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn ConvertColorNameToIndex(
    hProfile: isize,
    paColorName: [*]?*i8,
    paIndex: [*]u32,
    dwCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn ConvertIndexToColorName(
    hProfile: isize,
    paIndex: [*]u32,
    paColorName: [*]?*i8,
    dwCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn CreateDeviceLinkProfile(
    hProfile: [*]isize,
    nProfiles: u32,
    padwIntent: [*]u32,
    nIntents: u32,
    dwFlags: u32,
    pProfileData: ?*?*u8,
    indexPreferredCMM: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn CreateColorTransformA(
    pLogColorSpace: ?*LOGCOLORSPACEA,
    hDestProfile: isize,
    hTargetProfile: isize,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn CreateColorTransformW(
    pLogColorSpace: ?*LOGCOLORSPACEW,
    hDestProfile: isize,
    hTargetProfile: isize,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn CreateMultiProfileTransform(
    pahProfiles: [*]isize,
    nProfiles: u32,
    padwIntent: [*]u32,
    nIntents: u32,
    dwFlags: u32,
    indexPreferredCMM: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn DeleteColorTransform(
    hxform: isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn TranslateBitmapBits(
    hColorTransform: isize,
    pSrcBits: ?*anyopaque,
    bmInput: BMFORMAT,
    dwWidth: u32,
    dwHeight: u32,
    dwInputStride: u32,
    pDestBits: ?*anyopaque,
    bmOutput: BMFORMAT,
    dwOutputStride: u32,
    pfnCallBack: ?LPBMCALLBACKFN,
    ulCallbackData: LPARAM,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn CheckBitmapBits(
    hColorTransform: isize,
    pSrcBits: ?*anyopaque,
    bmInput: BMFORMAT,
    dwWidth: u32,
    dwHeight: u32,
    dwStride: u32,
    paResult: ?*u8,
    pfnCallback: ?LPBMCALLBACKFN,
    lpCallbackData: LPARAM,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn TranslateColors(
    hColorTransform: isize,
    paInputColors: [*]COLOR,
    nColors: u32,
    ctInput: COLORTYPE,
    paOutputColors: [*]COLOR,
    ctOutput: COLORTYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn CheckColors(
    hColorTransform: isize,
    paInputColors: [*]COLOR,
    nColors: u32,
    ctInput: COLORTYPE,
    paResult: [*:0]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetCMMInfo(
    hColorTransform: isize,
    param1: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "mscms" fn RegisterCMMA(
    pMachineName: ?[*:0]const u8,
    cmmID: u32,
    pCMMdll: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn RegisterCMMW(
    pMachineName: ?[*:0]const u16,
    cmmID: u32,
    pCMMdll: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn UnregisterCMMA(
    pMachineName: ?[*:0]const u8,
    cmmID: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn UnregisterCMMW(
    pMachineName: ?[*:0]const u16,
    cmmID: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SelectCMM(
    dwCMMType: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetColorDirectoryA(
    pMachineName: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?PSTR,
    pdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetColorDirectoryW(
    pMachineName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?PWSTR,
    pdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn InstallColorProfileA(
    pMachineName: ?[*:0]const u8,
    pProfileName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn InstallColorProfileW(
    pMachineName: ?[*:0]const u16,
    pProfileName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn UninstallColorProfileA(
    pMachineName: ?[*:0]const u8,
    pProfileName: ?[*:0]const u8,
    bDelete: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn UninstallColorProfileW(
    pMachineName: ?[*:0]const u16,
    pProfileName: ?[*:0]const u16,
    bDelete: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn EnumColorProfilesA(
    pMachineName: ?[*:0]const u8,
    pEnumRecord: ?*ENUMTYPEA,
    // TODO: what to do with BytesParamIndex 3?
    pEnumerationBuffer: ?*u8,
    pdwSizeOfEnumerationBuffer: ?*u32,
    pnProfiles: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn EnumColorProfilesW(
    pMachineName: ?[*:0]const u16,
    pEnumRecord: ?*ENUMTYPEW,
    // TODO: what to do with BytesParamIndex 3?
    pEnumerationBuffer: ?*u8,
    pdwSizeOfEnumerationBuffer: ?*u32,
    pnProfiles: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SetStandardColorSpaceProfileA(
    pMachineName: ?[*:0]const u8,
    dwProfileID: u32,
    pProfilename: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn SetStandardColorSpaceProfileW(
    pMachineName: ?[*:0]const u16,
    dwProfileID: u32,
    pProfileName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetStandardColorSpaceProfileA(
    pMachineName: ?[*:0]const u8,
    dwSCS: u32,
    // TODO: what to do with BytesParamIndex 3?
    pBuffer: ?PSTR,
    pcbSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn GetStandardColorSpaceProfileW(
    pMachineName: ?[*:0]const u16,
    dwSCS: u32,
    // TODO: what to do with BytesParamIndex 3?
    pBuffer: ?PWSTR,
    pcbSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn AssociateColorProfileWithDeviceA(
    pMachineName: ?[*:0]const u8,
    pProfileName: ?[*:0]const u8,
    pDeviceName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn AssociateColorProfileWithDeviceW(
    pMachineName: ?[*:0]const u16,
    pProfileName: ?[*:0]const u16,
    pDeviceName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn DisassociateColorProfileFromDeviceA(
    pMachineName: ?[*:0]const u8,
    pProfileName: ?[*:0]const u8,
    pDeviceName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn DisassociateColorProfileFromDeviceW(
    pMachineName: ?[*:0]const u16,
    pProfileName: ?[*:0]const u16,
    pDeviceName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icmui" fn SetupColorMatchingW(
    pcms: ?*COLORMATCHSETUPW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icmui" fn SetupColorMatchingA(
    pcms: ?*COLORMATCHSETUPA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsAssociateColorProfileWithDevice(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pProfileName: ?[*:0]const u16,
    pDeviceName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsDisassociateColorProfileFromDevice(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pProfileName: ?[*:0]const u16,
    pDeviceName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsEnumColorProfilesSize(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pEnumRecord: ?*ENUMTYPEW,
    pdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsEnumColorProfiles(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pEnumRecord: ?*ENUMTYPEW,
    // TODO: what to do with BytesParamIndex 3?
    pBuffer: ?*u8,
    dwSize: u32,
    pnProfiles: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsGetDefaultColorProfileSize(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pDeviceName: ?[*:0]const u16,
    cptColorProfileType: COLORPROFILETYPE,
    cpstColorProfileSubType: COLORPROFILESUBTYPE,
    dwProfileID: u32,
    pcbProfileName: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsGetDefaultColorProfile(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pDeviceName: ?[*:0]const u16,
    cptColorProfileType: COLORPROFILETYPE,
    cpstColorProfileSubType: COLORPROFILESUBTYPE,
    dwProfileID: u32,
    cbProfileName: u32,
    // TODO: what to do with BytesParamIndex 5?
    pProfileName: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsSetDefaultColorProfile(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pDeviceName: ?[*:0]const u16,
    cptColorProfileType: COLORPROFILETYPE,
    cpstColorProfileSubType: COLORPROFILESUBTYPE,
    dwProfileID: u32,
    pProfileName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsSetDefaultRenderingIntent(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    dwRenderingIntent: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsGetDefaultRenderingIntent(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    pdwRenderingIntent: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsGetUsePerUserProfiles(
    pDeviceName: ?[*:0]const u16,
    dwDeviceClass: u32,
    pUsePerUserProfiles: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsSetUsePerUserProfiles(
    pDeviceName: ?[*:0]const u16,
    dwDeviceClass: u32,
    usePerUserProfiles: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsTranslateColors(
    hColorTransform: isize,
    nColors: u32,
    nInputChannels: u32,
    cdtInput: COLORDATATYPE,
    cbInput: u32,
    // TODO: what to do with BytesParamIndex 4?
    pInputData: ?*anyopaque,
    nOutputChannels: u32,
    cdtOutput: COLORDATATYPE,
    cbOutput: u32,
    // TODO: what to do with BytesParamIndex 8?
    pOutputData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsCheckColors(
    hColorTransform: isize,
    nColors: u32,
    nInputChannels: u32,
    cdtInput: COLORDATATYPE,
    cbInput: u32,
    // TODO: what to do with BytesParamIndex 4?
    pInputData: ?*anyopaque,
    paResult: [*:0]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCheckColors(
    hcmTransform: isize,
    lpaInputColors: [*]COLOR,
    nColors: u32,
    ctInput: COLORTYPE,
    lpaResult: [*:0]u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCheckRGBs(
    hcmTransform: isize,
    lpSrcBits: ?*anyopaque,
    bmInput: BMFORMAT,
    dwWidth: u32,
    dwHeight: u32,
    dwStride: u32,
    lpaResult: ?*u8,
    pfnCallback: ?LPBMCALLBACKFN,
    ulCallbackData: LPARAM,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMConvertColorNameToIndex(
    hProfile: isize,
    paColorName: [*]?*i8,
    paIndex: [*]u32,
    dwCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMConvertIndexToColorName(
    hProfile: isize,
    paIndex: [*]u32,
    paColorName: [*]?*i8,
    dwCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCreateDeviceLinkProfile(
    pahProfiles: [*]isize,
    nProfiles: u32,
    padwIntents: [*]u32,
    nIntents: u32,
    dwFlags: u32,
    lpProfileData: ?*?*u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCreateMultiProfileTransform(
    pahProfiles: [*]isize,
    nProfiles: u32,
    padwIntents: [*]u32,
    nIntents: u32,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "icm32" fn CMCreateProfileW(
    lpColorSpace: ?*LOGCOLORSPACEW,
    lpProfileData: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCreateTransform(
    lpColorSpace: ?*LOGCOLORSPACEA,
    lpDevCharacter: ?*anyopaque,
    lpTargetDevCharacter: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "icm32" fn CMCreateTransformW(
    lpColorSpace: ?*LOGCOLORSPACEW,
    lpDevCharacter: ?*anyopaque,
    lpTargetDevCharacter: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "icm32" fn CMCreateTransformExt(
    lpColorSpace: ?*LOGCOLORSPACEA,
    lpDevCharacter: ?*anyopaque,
    lpTargetDevCharacter: ?*anyopaque,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "icm32" fn CMCheckColorsInGamut(
    hcmTransform: isize,
    lpaRGBTriple: [*]RGBTRIPLE,
    // TODO: what to do with BytesParamIndex 3?
    lpaResult: ?*u8,
    nCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCreateProfile(
    lpColorSpace: ?*LOGCOLORSPACEA,
    lpProfileData: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMTranslateRGB(
    hcmTransform: isize,
    ColorRef: u32,
    lpColorRef: ?*u32,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMTranslateRGBs(
    hcmTransform: isize,
    lpSrcBits: ?*anyopaque,
    bmInput: BMFORMAT,
    dwWidth: u32,
    dwHeight: u32,
    dwStride: u32,
    lpDestBits: ?*anyopaque,
    bmOutput: BMFORMAT,
    dwTranslateDirection: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMCreateTransformExtW(
    lpColorSpace: ?*LOGCOLORSPACEW,
    lpDevCharacter: ?*anyopaque,
    lpTargetDevCharacter: ?*anyopaque,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "icm32" fn CMDeleteTransform(
    hcmTransform: isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMGetInfo(
    dwInfo: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "icm32" fn CMGetNamedProfileInfo(
    hProfile: isize,
    pNamedProfileInfo: ?*NAMED_PROFILE_INFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMIsProfileValid(
    hProfile: isize,
    lpbValid: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMTranslateColors(
    hcmTransform: isize,
    lpaInputColors: [*]COLOR,
    nColors: u32,
    ctInput: COLORTYPE,
    lpaOutputColors: [*]COLOR,
    ctOutput: COLORTYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "icm32" fn CMTranslateRGBsExt(
    hcmTransform: isize,
    lpSrcBits: ?*anyopaque,
    bmInput: BMFORMAT,
    dwWidth: u32,
    dwHeight: u32,
    dwInputStride: u32,
    lpDestBits: ?*anyopaque,
    bmOutput: BMFORMAT,
    dwOutputStride: u32,
    lpfnCallback: ?LPBMCALLBACKFN,
    ulCallbackData: LPARAM,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsOpenColorProfileA(
    pCDMPProfile: ?*PROFILE,
    pCAMPProfile: ?*PROFILE,
    pGMMPProfile: ?*PROFILE,
    dwDesireAccess: u32,
    dwShareMode: u32,
    dwCreationMode: u32,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn WcsOpenColorProfileW(
    pCDMPProfile: ?*PROFILE,
    pCAMPProfile: ?*PROFILE,
    pGMMPProfile: ?*PROFILE,
    dwDesireAccess: u32,
    dwShareMode: u32,
    dwCreationMode: u32,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn WcsCreateIccProfile(
    hWcsProfile: isize,
    dwOptions: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

pub extern "mscms" fn WcsGetCalibrationManagementState(
    pbIsEnabled: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn WcsSetCalibrationManagementState(
    bIsEnabled: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "mscms" fn ColorProfileAddDisplayAssociation(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    profileName: ?[*:0]const u16,
    targetAdapterID: LUID,
    sourceID: u32,
    setAsDefault: BOOL,
    associateAsAdvancedColor: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "mscms" fn ColorProfileRemoveDisplayAssociation(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    profileName: ?[*:0]const u16,
    targetAdapterID: LUID,
    sourceID: u32,
    dissociateAdvancedColor: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "mscms" fn ColorProfileSetDisplayDefaultAssociation(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    profileName: ?[*:0]const u16,
    profileType: COLORPROFILETYPE,
    profileSubType: COLORPROFILESUBTYPE,
    targetAdapterID: LUID,
    sourceID: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "mscms" fn ColorProfileGetDisplayList(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    targetAdapterID: LUID,
    sourceID: u32,
    profileList: ?*?*?PWSTR,
    profileCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "mscms" fn ColorProfileGetDisplayDefault(
    scope: WCS_PROFILE_MANAGEMENT_SCOPE,
    targetAdapterID: LUID,
    sourceID: u32,
    profileType: COLORPROFILETYPE,
    profileSubType: COLORPROFILESUBTYPE,
    profileName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "mscms" fn ColorProfileGetDisplayUserScope(
    targetAdapterID: LUID,
    sourceID: u32,
    scope: ?*WCS_PROFILE_MANAGEMENT_SCOPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (26)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const LOGCOLORSPACE = thismodule.LOGCOLORSPACEA;
        pub const ICMENUMPROC = thismodule.ICMENUMPROCA;
        pub const ENUMTYPE = thismodule.ENUMTYPEA;
        pub const PCMSCALLBACK = thismodule.PCMSCALLBACKA;
        pub const COLORMATCHSETUP = thismodule.COLORMATCHSETUPA;
        pub const GetLogColorSpace = thismodule.GetLogColorSpaceA;
        pub const CreateColorSpace = thismodule.CreateColorSpaceA;
        pub const GetICMProfile = thismodule.GetICMProfileA;
        pub const SetICMProfile = thismodule.SetICMProfileA;
        pub const EnumICMProfiles = thismodule.EnumICMProfilesA;
        pub const UpdateICMRegKey = thismodule.UpdateICMRegKeyA;
        pub const OpenColorProfile = thismodule.OpenColorProfileA;
        pub const CreateProfileFromLogColorSpace = thismodule.CreateProfileFromLogColorSpaceA;
        pub const CreateColorTransform = thismodule.CreateColorTransformA;
        pub const RegisterCMM = thismodule.RegisterCMMA;
        pub const UnregisterCMM = thismodule.UnregisterCMMA;
        pub const GetColorDirectory = thismodule.GetColorDirectoryA;
        pub const InstallColorProfile = thismodule.InstallColorProfileA;
        pub const UninstallColorProfile = thismodule.UninstallColorProfileA;
        pub const EnumColorProfiles = thismodule.EnumColorProfilesA;
        pub const SetStandardColorSpaceProfile = thismodule.SetStandardColorSpaceProfileA;
        pub const GetStandardColorSpaceProfile = thismodule.GetStandardColorSpaceProfileA;
        pub const AssociateColorProfileWithDevice = thismodule.AssociateColorProfileWithDeviceA;
        pub const DisassociateColorProfileFromDevice = thismodule.DisassociateColorProfileFromDeviceA;
        pub const SetupColorMatching = thismodule.SetupColorMatchingA;
        pub const WcsOpenColorProfile = thismodule.WcsOpenColorProfileA;
    },
    .wide => struct {
        pub const LOGCOLORSPACE = thismodule.LOGCOLORSPACEW;
        pub const ICMENUMPROC = thismodule.ICMENUMPROCW;
        pub const ENUMTYPE = thismodule.ENUMTYPEW;
        pub const PCMSCALLBACK = thismodule.PCMSCALLBACKW;
        pub const COLORMATCHSETUP = thismodule.COLORMATCHSETUPW;
        pub const GetLogColorSpace = thismodule.GetLogColorSpaceW;
        pub const CreateColorSpace = thismodule.CreateColorSpaceW;
        pub const GetICMProfile = thismodule.GetICMProfileW;
        pub const SetICMProfile = thismodule.SetICMProfileW;
        pub const EnumICMProfiles = thismodule.EnumICMProfilesW;
        pub const UpdateICMRegKey = thismodule.UpdateICMRegKeyW;
        pub const OpenColorProfile = thismodule.OpenColorProfileW;
        pub const CreateProfileFromLogColorSpace = thismodule.CreateProfileFromLogColorSpaceW;
        pub const CreateColorTransform = thismodule.CreateColorTransformW;
        pub const RegisterCMM = thismodule.RegisterCMMW;
        pub const UnregisterCMM = thismodule.UnregisterCMMW;
        pub const GetColorDirectory = thismodule.GetColorDirectoryW;
        pub const InstallColorProfile = thismodule.InstallColorProfileW;
        pub const UninstallColorProfile = thismodule.UninstallColorProfileW;
        pub const EnumColorProfiles = thismodule.EnumColorProfilesW;
        pub const SetStandardColorSpaceProfile = thismodule.SetStandardColorSpaceProfileW;
        pub const GetStandardColorSpaceProfile = thismodule.GetStandardColorSpaceProfileW;
        pub const AssociateColorProfileWithDevice = thismodule.AssociateColorProfileWithDeviceW;
        pub const DisassociateColorProfileFromDevice = thismodule.DisassociateColorProfileFromDeviceW;
        pub const SetupColorMatching = thismodule.SetupColorMatchingW;
        pub const WcsOpenColorProfile = thismodule.WcsOpenColorProfileW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const LOGCOLORSPACE = *opaque {};
        pub const ICMENUMPROC = *opaque {};
        pub const ENUMTYPE = *opaque {};
        pub const PCMSCALLBACK = *opaque {};
        pub const COLORMATCHSETUP = *opaque {};
        pub const GetLogColorSpace = *opaque {};
        pub const CreateColorSpace = *opaque {};
        pub const GetICMProfile = *opaque {};
        pub const SetICMProfile = *opaque {};
        pub const EnumICMProfiles = *opaque {};
        pub const UpdateICMRegKey = *opaque {};
        pub const OpenColorProfile = *opaque {};
        pub const CreateProfileFromLogColorSpace = *opaque {};
        pub const CreateColorTransform = *opaque {};
        pub const RegisterCMM = *opaque {};
        pub const UnregisterCMM = *opaque {};
        pub const GetColorDirectory = *opaque {};
        pub const InstallColorProfile = *opaque {};
        pub const UninstallColorProfile = *opaque {};
        pub const EnumColorProfiles = *opaque {};
        pub const SetStandardColorSpaceProfile = *opaque {};
        pub const GetStandardColorSpaceProfile = *opaque {};
        pub const AssociateColorProfileWithDevice = *opaque {};
        pub const DisassociateColorProfileFromDevice = *opaque {};
        pub const SetupColorMatching = *opaque {};
        pub const WcsOpenColorProfile = *opaque {};
    } else struct {
        pub const LOGCOLORSPACE = @compileError("'LOGCOLORSPACE' requires that UNICODE be set to true or false in the root module");
        pub const ICMENUMPROC = @compileError("'ICMENUMPROC' requires that UNICODE be set to true or false in the root module");
        pub const ENUMTYPE = @compileError("'ENUMTYPE' requires that UNICODE be set to true or false in the root module");
        pub const PCMSCALLBACK = @compileError("'PCMSCALLBACK' requires that UNICODE be set to true or false in the root module");
        pub const COLORMATCHSETUP = @compileError("'COLORMATCHSETUP' requires that UNICODE be set to true or false in the root module");
        pub const GetLogColorSpace = @compileError("'GetLogColorSpace' requires that UNICODE be set to true or false in the root module");
        pub const CreateColorSpace = @compileError("'CreateColorSpace' requires that UNICODE be set to true or false in the root module");
        pub const GetICMProfile = @compileError("'GetICMProfile' requires that UNICODE be set to true or false in the root module");
        pub const SetICMProfile = @compileError("'SetICMProfile' requires that UNICODE be set to true or false in the root module");
        pub const EnumICMProfiles = @compileError("'EnumICMProfiles' requires that UNICODE be set to true or false in the root module");
        pub const UpdateICMRegKey = @compileError("'UpdateICMRegKey' requires that UNICODE be set to true or false in the root module");
        pub const OpenColorProfile = @compileError("'OpenColorProfile' requires that UNICODE be set to true or false in the root module");
        pub const CreateProfileFromLogColorSpace = @compileError("'CreateProfileFromLogColorSpace' requires that UNICODE be set to true or false in the root module");
        pub const CreateColorTransform = @compileError("'CreateColorTransform' requires that UNICODE be set to true or false in the root module");
        pub const RegisterCMM = @compileError("'RegisterCMM' requires that UNICODE be set to true or false in the root module");
        pub const UnregisterCMM = @compileError("'UnregisterCMM' requires that UNICODE be set to true or false in the root module");
        pub const GetColorDirectory = @compileError("'GetColorDirectory' requires that UNICODE be set to true or false in the root module");
        pub const InstallColorProfile = @compileError("'InstallColorProfile' requires that UNICODE be set to true or false in the root module");
        pub const UninstallColorProfile = @compileError("'UninstallColorProfile' requires that UNICODE be set to true or false in the root module");
        pub const EnumColorProfiles = @compileError("'EnumColorProfiles' requires that UNICODE be set to true or false in the root module");
        pub const SetStandardColorSpaceProfile = @compileError("'SetStandardColorSpaceProfile' requires that UNICODE be set to true or false in the root module");
        pub const GetStandardColorSpaceProfile = @compileError("'GetStandardColorSpaceProfile' requires that UNICODE be set to true or false in the root module");
        pub const AssociateColorProfileWithDevice = @compileError("'AssociateColorProfileWithDevice' requires that UNICODE be set to true or false in the root module");
        pub const DisassociateColorProfileFromDevice = @compileError("'DisassociateColorProfileFromDevice' requires that UNICODE be set to true or false in the root module");
        pub const SetupColorMatching = @compileError("'SetupColorMatching' requires that UNICODE be set to true or false in the root module");
        pub const WcsOpenColorProfile = @compileError("'WcsOpenColorProfile' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (18)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BSTR = @import("../foundation.zig").BSTR;
const CHAR = @import("../foundation.zig").CHAR;
const CIEXYZ = @import("../graphics/gdi.zig").CIEXYZ;
const CIEXYZTRIPLE = @import("../graphics/gdi.zig").CIEXYZTRIPLE;
const DLGPROC = @import("../ui/windows_and_messaging.zig").DLGPROC;
const EMR = @import("../graphics/gdi.zig").EMR;
const HDC = @import("../graphics/gdi.zig").HDC;
const HPALETTE = @import("../graphics/gdi.zig").HPALETTE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const IUnknown = @import("../system/com.zig").IUnknown;
const LPARAM = @import("../foundation.zig").LPARAM;
const LUID = @import("../foundation.zig").LUID;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const RGBTRIPLE = @import("../graphics/gdi.zig").RGBTRIPLE;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "ICMENUMPROCA")) {
        _ = ICMENUMPROCA;
    }
    if (@hasDecl(@This(), "ICMENUMPROCW")) {
        _ = ICMENUMPROCW;
    }
    if (@hasDecl(@This(), "LPBMCALLBACKFN")) {
        _ = LPBMCALLBACKFN;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
