//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (61)
//--------------------------------------------------------------------------------
pub const MI_FLAG_ANY = @as(u32, 127);
pub const MI_FLAG_VERSION = @as(u32, 469762048);
pub const MI_FLAG_ADOPT = @as(u32, 2147483648);
pub const MI_FLAG_CLASS = @as(u32, 1);
pub const MI_FLAG_METHOD = @as(u32, 2);
pub const MI_FLAG_PROPERTY = @as(u32, 4);
pub const MI_FLAG_PARAMETER = @as(u32, 8);
pub const MI_FLAG_ASSOCIATION = @as(u32, 16);
pub const MI_FLAG_INDICATION = @as(u32, 32);
pub const MI_FLAG_REFERENCE = @as(u32, 64);
pub const MI_FLAG_ENABLEOVERRIDE = @as(u32, 128);
pub const MI_FLAG_DISABLEOVERRIDE = @as(u32, 256);
pub const MI_FLAG_RESTRICTED = @as(u32, 512);
pub const MI_FLAG_TOSUBCLASS = @as(u32, 1024);
pub const MI_FLAG_TRANSLATABLE = @as(u32, 2048);
pub const MI_FLAG_KEY = @as(u32, 4096);
pub const MI_FLAG_IN = @as(u32, 8192);
pub const MI_FLAG_OUT = @as(u32, 16384);
pub const MI_FLAG_REQUIRED = @as(u32, 32768);
pub const MI_FLAG_STATIC = @as(u32, 65536);
pub const MI_FLAG_ABSTRACT = @as(u32, 131072);
pub const MI_FLAG_TERMINAL = @as(u32, 262144);
pub const MI_FLAG_EXPENSIVE = @as(u32, 524288);
pub const MI_FLAG_STREAM = @as(u32, 1048576);
pub const MI_FLAG_READONLY = @as(u32, 2097152);
pub const MI_FLAG_EXTENDED = @as(u32, 4096);
pub const MI_FLAG_NOT_MODIFIED = @as(u32, 33554432);
pub const MI_FLAG_NULL = @as(u32, 536870912);
pub const MI_FLAG_BORROW = @as(u32, 1073741824);
pub const MI_MODULE_FLAG_STANDARD_QUALIFIERS = @as(u32, 1);
pub const MI_MODULE_FLAG_DESCRIPTIONS = @as(u32, 2);
pub const MI_MODULE_FLAG_VALUES = @as(u32, 4);
pub const MI_MODULE_FLAG_MAPPING_STRINGS = @as(u32, 8);
pub const MI_MODULE_FLAG_BOOLEANS = @as(u32, 16);
pub const MI_MODULE_FLAG_CPLUSPLUS = @as(u32, 32);
pub const MI_MODULE_FLAG_LOCALIZED = @as(u32, 64);
pub const MI_MODULE_FLAG_FILTER_SUPPORT = @as(u32, 128);
pub const MI_MAX_LOCALE_SIZE = @as(u32, 128);
pub const MI_WRITEMESSAGE_CHANNEL_WARNING = @as(u32, 0);
pub const MI_WRITEMESSAGE_CHANNEL_VERBOSE = @as(u32, 1);
pub const MI_WRITEMESSAGE_CHANNEL_DEBUG = @as(u32, 2);
pub const MI_CALL_VERSION = @as(u32, 1);
pub const MI_OPERATIONFLAGS_MANUAL_ACK_RESULTS = @as(u32, 1);
pub const MI_OPERATIONFLAGS_NO_RTTI = @as(u32, 1024);
pub const MI_OPERATIONFLAGS_BASIC_RTTI = @as(u32, 2);
pub const MI_OPERATIONFLAGS_STANDARD_RTTI = @as(u32, 2048);
pub const MI_OPERATIONFLAGS_FULL_RTTI = @as(u32, 4);
pub const MI_OPERATIONFLAGS_DEFAULT_RTTI = @as(u32, 0);
pub const MI_OPERATIONFLAGS_LOCALIZED_QUALIFIERS = @as(u32, 8);
pub const MI_OPERATIONFLAGS_EXPENSIVE_PROPERTIES = @as(u32, 64);
pub const MI_OPERATIONFLAGS_POLYMORPHISM_SHALLOW = @as(u32, 128);
pub const MI_OPERATIONFLAGS_POLYMORPHISM_DEEP_BASE_PROPS_ONLY = @as(u32, 384);
pub const MI_OPERATIONFLAGS_REPORT_OPERATION_STARTED = @as(u32, 512);
pub const MI_SERIALIZER_FLAGS_CLASS_DEEP = @as(u32, 1);
pub const MI_SERIALIZER_FLAGS_INSTANCE_WITH_CLASS = @as(u32, 1);
pub const WBEMS_DISPID_DERIVATION = @as(u32, 23);
pub const WBEMS_DISPID_OBJECT_READY = @as(u32, 1);
pub const WBEMS_DISPID_COMPLETED = @as(u32, 2);
pub const WBEMS_DISPID_PROGRESS = @as(u32, 3);
pub const WBEMS_DISPID_OBJECT_PUT = @as(u32, 4);
pub const WBEMS_DISPID_CONNECTION_READY = @as(u32, 5);

//--------------------------------------------------------------------------------
// Section: Types (370)
//--------------------------------------------------------------------------------
pub const MI_Result = enum(i32) {
    OK = 0,
    FAILED = 1,
    ACCESS_DENIED = 2,
    INVALID_NAMESPACE = 3,
    INVALID_PARAMETER = 4,
    INVALID_CLASS = 5,
    NOT_FOUND = 6,
    NOT_SUPPORTED = 7,
    CLASS_HAS_CHILDREN = 8,
    CLASS_HAS_INSTANCES = 9,
    INVALID_SUPERCLASS = 10,
    ALREADY_EXISTS = 11,
    NO_SUCH_PROPERTY = 12,
    TYPE_MISMATCH = 13,
    QUERY_LANGUAGE_NOT_SUPPORTED = 14,
    INVALID_QUERY = 15,
    METHOD_NOT_AVAILABLE = 16,
    METHOD_NOT_FOUND = 17,
    NAMESPACE_NOT_EMPTY = 20,
    INVALID_ENUMERATION_CONTEXT = 21,
    INVALID_OPERATION_TIMEOUT = 22,
    PULL_HAS_BEEN_ABANDONED = 23,
    PULL_CANNOT_BE_ABANDONED = 24,
    FILTERED_ENUMERATION_NOT_SUPPORTED = 25,
    CONTINUATION_ON_ERROR_NOT_SUPPORTED = 26,
    SERVER_LIMITS_EXCEEDED = 27,
    SERVER_IS_SHUTTING_DOWN = 28,
};
pub const MI_RESULT_OK = MI_Result.OK;
pub const MI_RESULT_FAILED = MI_Result.FAILED;
pub const MI_RESULT_ACCESS_DENIED = MI_Result.ACCESS_DENIED;
pub const MI_RESULT_INVALID_NAMESPACE = MI_Result.INVALID_NAMESPACE;
pub const MI_RESULT_INVALID_PARAMETER = MI_Result.INVALID_PARAMETER;
pub const MI_RESULT_INVALID_CLASS = MI_Result.INVALID_CLASS;
pub const MI_RESULT_NOT_FOUND = MI_Result.NOT_FOUND;
pub const MI_RESULT_NOT_SUPPORTED = MI_Result.NOT_SUPPORTED;
pub const MI_RESULT_CLASS_HAS_CHILDREN = MI_Result.CLASS_HAS_CHILDREN;
pub const MI_RESULT_CLASS_HAS_INSTANCES = MI_Result.CLASS_HAS_INSTANCES;
pub const MI_RESULT_INVALID_SUPERCLASS = MI_Result.INVALID_SUPERCLASS;
pub const MI_RESULT_ALREADY_EXISTS = MI_Result.ALREADY_EXISTS;
pub const MI_RESULT_NO_SUCH_PROPERTY = MI_Result.NO_SUCH_PROPERTY;
pub const MI_RESULT_TYPE_MISMATCH = MI_Result.TYPE_MISMATCH;
pub const MI_RESULT_QUERY_LANGUAGE_NOT_SUPPORTED = MI_Result.QUERY_LANGUAGE_NOT_SUPPORTED;
pub const MI_RESULT_INVALID_QUERY = MI_Result.INVALID_QUERY;
pub const MI_RESULT_METHOD_NOT_AVAILABLE = MI_Result.METHOD_NOT_AVAILABLE;
pub const MI_RESULT_METHOD_NOT_FOUND = MI_Result.METHOD_NOT_FOUND;
pub const MI_RESULT_NAMESPACE_NOT_EMPTY = MI_Result.NAMESPACE_NOT_EMPTY;
pub const MI_RESULT_INVALID_ENUMERATION_CONTEXT = MI_Result.INVALID_ENUMERATION_CONTEXT;
pub const MI_RESULT_INVALID_OPERATION_TIMEOUT = MI_Result.INVALID_OPERATION_TIMEOUT;
pub const MI_RESULT_PULL_HAS_BEEN_ABANDONED = MI_Result.PULL_HAS_BEEN_ABANDONED;
pub const MI_RESULT_PULL_CANNOT_BE_ABANDONED = MI_Result.PULL_CANNOT_BE_ABANDONED;
pub const MI_RESULT_FILTERED_ENUMERATION_NOT_SUPPORTED = MI_Result.FILTERED_ENUMERATION_NOT_SUPPORTED;
pub const MI_RESULT_CONTINUATION_ON_ERROR_NOT_SUPPORTED = MI_Result.CONTINUATION_ON_ERROR_NOT_SUPPORTED;
pub const MI_RESULT_SERVER_LIMITS_EXCEEDED = MI_Result.SERVER_LIMITS_EXCEEDED;
pub const MI_RESULT_SERVER_IS_SHUTTING_DOWN = MI_Result.SERVER_IS_SHUTTING_DOWN;

pub const MI_ErrorCategory = enum(i32) {
    NOT_SPECIFIED = 0,
    OPEN_ERROR = 1,
    CLOS_EERROR = 2,
    DEVICE_ERROR = 3,
    DEADLOCK_DETECTED = 4,
    INVALID_ARGUMENT = 5,
    INVALID_DATA = 6,
    INVALID_OPERATION = 7,
    INVALID_RESULT = 8,
    INVALID_TYPE = 9,
    METADATA_ERROR = 10,
    NOT_IMPLEMENTED = 11,
    NOT_INSTALLED = 12,
    OBJECT_NOT_FOUND = 13,
    OPERATION_STOPPED = 14,
    OPERATION_TIMEOUT = 15,
    SYNTAX_ERROR = 16,
    PARSER_ERROR = 17,
    ACCESS_DENIED = 18,
    RESOURCE_BUSY = 19,
    RESOURCE_EXISTS = 20,
    RESOURCE_UNAVAILABLE = 21,
    READ_ERROR = 22,
    WRITE_ERROR = 23,
    FROM_STDERR = 24,
    SECURITY_ERROR = 25,
    PROTOCOL_ERROR = 26,
    CONNECTION_ERROR = 27,
    AUTHENTICATION_ERROR = 28,
    LIMITS_EXCEEDED = 29,
    QUOTA_EXCEEDED = 30,
    NOT_ENABLED = 31,
};
pub const MI_ERRORCATEGORY_NOT_SPECIFIED = MI_ErrorCategory.NOT_SPECIFIED;
pub const MI_ERRORCATEGORY_OPEN_ERROR = MI_ErrorCategory.OPEN_ERROR;
pub const MI_ERRORCATEGORY_CLOS_EERROR = MI_ErrorCategory.CLOS_EERROR;
pub const MI_ERRORCATEGORY_DEVICE_ERROR = MI_ErrorCategory.DEVICE_ERROR;
pub const MI_ERRORCATEGORY_DEADLOCK_DETECTED = MI_ErrorCategory.DEADLOCK_DETECTED;
pub const MI_ERRORCATEGORY_INVALID_ARGUMENT = MI_ErrorCategory.INVALID_ARGUMENT;
pub const MI_ERRORCATEGORY_INVALID_DATA = MI_ErrorCategory.INVALID_DATA;
pub const MI_ERRORCATEGORY_INVALID_OPERATION = MI_ErrorCategory.INVALID_OPERATION;
pub const MI_ERRORCATEGORY_INVALID_RESULT = MI_ErrorCategory.INVALID_RESULT;
pub const MI_ERRORCATEGORY_INVALID_TYPE = MI_ErrorCategory.INVALID_TYPE;
pub const MI_ERRORCATEGORY_METADATA_ERROR = MI_ErrorCategory.METADATA_ERROR;
pub const MI_ERRORCATEGORY_NOT_IMPLEMENTED = MI_ErrorCategory.NOT_IMPLEMENTED;
pub const MI_ERRORCATEGORY_NOT_INSTALLED = MI_ErrorCategory.NOT_INSTALLED;
pub const MI_ERRORCATEGORY_OBJECT_NOT_FOUND = MI_ErrorCategory.OBJECT_NOT_FOUND;
pub const MI_ERRORCATEGORY_OPERATION_STOPPED = MI_ErrorCategory.OPERATION_STOPPED;
pub const MI_ERRORCATEGORY_OPERATION_TIMEOUT = MI_ErrorCategory.OPERATION_TIMEOUT;
pub const MI_ERRORCATEGORY_SYNTAX_ERROR = MI_ErrorCategory.SYNTAX_ERROR;
pub const MI_ERRORCATEGORY_PARSER_ERROR = MI_ErrorCategory.PARSER_ERROR;
pub const MI_ERRORCATEGORY_ACCESS_DENIED = MI_ErrorCategory.ACCESS_DENIED;
pub const MI_ERRORCATEGORY_RESOURCE_BUSY = MI_ErrorCategory.RESOURCE_BUSY;
pub const MI_ERRORCATEGORY_RESOURCE_EXISTS = MI_ErrorCategory.RESOURCE_EXISTS;
pub const MI_ERRORCATEGORY_RESOURCE_UNAVAILABLE = MI_ErrorCategory.RESOURCE_UNAVAILABLE;
pub const MI_ERRORCATEGORY_READ_ERROR = MI_ErrorCategory.READ_ERROR;
pub const MI_ERRORCATEGORY_WRITE_ERROR = MI_ErrorCategory.WRITE_ERROR;
pub const MI_ERRORCATEGORY_FROM_STDERR = MI_ErrorCategory.FROM_STDERR;
pub const MI_ERRORCATEGORY_SECURITY_ERROR = MI_ErrorCategory.SECURITY_ERROR;
pub const MI_ERRORCATEGORY_PROTOCOL_ERROR = MI_ErrorCategory.PROTOCOL_ERROR;
pub const MI_ERRORCATEGORY_CONNECTION_ERROR = MI_ErrorCategory.CONNECTION_ERROR;
pub const MI_ERRORCATEGORY_AUTHENTICATION_ERROR = MI_ErrorCategory.AUTHENTICATION_ERROR;
pub const MI_ERRORCATEGORY_LIMITS_EXCEEDED = MI_ErrorCategory.LIMITS_EXCEEDED;
pub const MI_ERRORCATEGORY_QUOTA_EXCEEDED = MI_ErrorCategory.QUOTA_EXCEEDED;
pub const MI_ERRORCATEGORY_NOT_ENABLED = MI_ErrorCategory.NOT_ENABLED;

pub const MI_PromptType = enum(i32) {
    NORMAL = 0,
    CRITICAL = 1,
};
pub const MI_PROMPTTYPE_NORMAL = MI_PromptType.NORMAL;
pub const MI_PROMPTTYPE_CRITICAL = MI_PromptType.CRITICAL;

pub const MI_CallbackMode = enum(i32) {
    REPORT = 0,
    INQUIRE = 1,
    IGNORE = 2,
};
pub const MI_CALLBACKMODE_REPORT = MI_CallbackMode.REPORT;
pub const MI_CALLBACKMODE_INQUIRE = MI_CallbackMode.INQUIRE;
pub const MI_CALLBACKMODE_IGNORE = MI_CallbackMode.IGNORE;

pub const MI_ProviderArchitecture = enum(i32) {
    @"32BIT" = 0,
    @"64BIT" = 1,
};
pub const MI_PROVIDER_ARCHITECTURE_32BIT = MI_ProviderArchitecture.@"32BIT";
pub const MI_PROVIDER_ARCHITECTURE_64BIT = MI_ProviderArchitecture.@"64BIT";

pub const MI_Type = enum(i32) {
    BOOLEAN = 0,
    UINT8 = 1,
    SINT8 = 2,
    UINT16 = 3,
    SINT16 = 4,
    UINT32 = 5,
    SINT32 = 6,
    UINT64 = 7,
    SINT64 = 8,
    REAL32 = 9,
    REAL64 = 10,
    CHAR16 = 11,
    DATETIME = 12,
    STRING = 13,
    REFERENCE = 14,
    INSTANCE = 15,
    BOOLEANA = 16,
    UINT8A = 17,
    SINT8A = 18,
    UINT16A = 19,
    SINT16A = 20,
    UINT32A = 21,
    SINT32A = 22,
    UINT64A = 23,
    SINT64A = 24,
    REAL32A = 25,
    REAL64A = 26,
    CHAR16A = 27,
    DATETIMEA = 28,
    STRINGA = 29,
    REFERENCEA = 30,
    INSTANCEA = 31,
    // ARRAY = 16, this enum value conflicts with BOOLEANA
};
pub const MI_BOOLEAN = MI_Type.BOOLEAN;
pub const MI_UINT8 = MI_Type.UINT8;
pub const MI_SINT8 = MI_Type.SINT8;
pub const MI_UINT16 = MI_Type.UINT16;
pub const MI_SINT16 = MI_Type.SINT16;
pub const MI_UINT32 = MI_Type.UINT32;
pub const MI_SINT32 = MI_Type.SINT32;
pub const MI_UINT64 = MI_Type.UINT64;
pub const MI_SINT64 = MI_Type.SINT64;
pub const MI_REAL32 = MI_Type.REAL32;
pub const MI_REAL64 = MI_Type.REAL64;
pub const MI_CHAR16 = MI_Type.CHAR16;
pub const MI_DATETIME = MI_Type.DATETIME;
pub const MI_STRING = MI_Type.STRING;
pub const MI_REFERENCE = MI_Type.REFERENCE;
pub const MI_INSTANCE = MI_Type.INSTANCE;
pub const MI_BOOLEANA = MI_Type.BOOLEANA;
pub const MI_UINT8A = MI_Type.UINT8A;
pub const MI_SINT8A = MI_Type.SINT8A;
pub const MI_UINT16A = MI_Type.UINT16A;
pub const MI_SINT16A = MI_Type.SINT16A;
pub const MI_UINT32A = MI_Type.UINT32A;
pub const MI_SINT32A = MI_Type.SINT32A;
pub const MI_UINT64A = MI_Type.UINT64A;
pub const MI_SINT64A = MI_Type.SINT64A;
pub const MI_REAL32A = MI_Type.REAL32A;
pub const MI_REAL64A = MI_Type.REAL64A;
pub const MI_CHAR16A = MI_Type.CHAR16A;
pub const MI_DATETIMEA = MI_Type.DATETIMEA;
pub const MI_STRINGA = MI_Type.STRINGA;
pub const MI_REFERENCEA = MI_Type.REFERENCEA;
pub const MI_INSTANCEA = MI_Type.INSTANCEA;
pub const MI_ARRAY = MI_Type.BOOLEANA;

pub const MI_Timestamp = extern struct {
    year: u32,
    month: u32,
    day: u32,
    hour: u32,
    minute: u32,
    second: u32,
    microseconds: u32,
    utc: i32,
};

pub const MI_Interval = extern struct {
    days: u32,
    hours: u32,
    minutes: u32,
    seconds: u32,
    microseconds: u32,
    __padding1: u32,
    __padding2: u32,
    __padding3: u32,
};

pub const MI_Datetime = extern struct {
    isTimestamp: u32,
    u: extern union {
        timestamp: MI_Timestamp,
        interval: MI_Interval,
    },
};

pub const MI_BooleanA = extern struct {
    data: ?*u8,
    size: u32,
};

pub const MI_Uint8A = extern struct {
    data: ?*u8,
    size: u32,
};

pub const MI_Sint8A = extern struct {
    data: ?*i8,
    size: u32,
};

pub const MI_Uint16A = extern struct {
    data: ?*u16,
    size: u32,
};

pub const MI_Sint16A = extern struct {
    data: ?*i16,
    size: u32,
};

pub const MI_Uint32A = extern struct {
    data: ?*u32,
    size: u32,
};

pub const MI_Sint32A = extern struct {
    data: ?*i32,
    size: u32,
};

pub const MI_Uint64A = extern struct {
    data: ?*u64,
    size: u32,
};

pub const MI_Sint64A = extern struct {
    data: ?*i64,
    size: u32,
};

pub const MI_Real32A = extern struct {
    data: ?*f32,
    size: u32,
};

pub const MI_Real64A = extern struct {
    data: ?*f64,
    size: u32,
};

pub const MI_Char16A = extern struct {
    data: ?*u16,
    size: u32,
};

pub const MI_DatetimeA = extern struct {
    data: ?*MI_Datetime,
    size: u32,
};

pub const MI_StringA = extern struct {
    data: ?*?*u16,
    size: u32,
};

pub const MI_ReferenceA = extern struct {
    data: ?*?*MI_Instance,
    size: u32,
};

pub const MI_InstanceA = extern struct {
    data: ?*?*MI_Instance,
    size: u32,
};

pub const MI_Array = extern struct {
    data: ?*anyopaque,
    size: u32,
};

pub const MI_ConstBooleanA = extern struct {
    data: ?*const u8,
    size: u32,
};

pub const MI_ConstUint8A = extern struct {
    data: ?*const u8,
    size: u32,
};

pub const MI_ConstSint8A = extern struct {
    data: ?*const i8,
    size: u32,
};

pub const MI_ConstUint16A = extern struct {
    data: ?*const u16,
    size: u32,
};

pub const MI_ConstSint16A = extern struct {
    data: ?*const i16,
    size: u32,
};

pub const MI_ConstUint32A = extern struct {
    data: ?*const u32,
    size: u32,
};

pub const MI_ConstSint32A = extern struct {
    data: ?*const i32,
    size: u32,
};

pub const MI_ConstUint64A = extern struct {
    data: ?*const u64,
    size: u32,
};

pub const MI_ConstSint64A = extern struct {
    data: ?*const i64,
    size: u32,
};

pub const MI_ConstReal32A = extern struct {
    data: ?*const f32,
    size: u32,
};

pub const MI_ConstReal64A = extern struct {
    data: ?*const f64,
    size: u32,
};

pub const MI_ConstChar16A = extern struct {
    data: ?*const u16,
    size: u32,
};

pub const MI_ConstDatetimeA = extern struct {
    data: ?*const MI_Datetime,
    size: u32,
};

pub const MI_ConstStringA = extern struct {
    data: ?*const ?*u16,
    size: u32,
};

pub const MI_ConstReferenceA = extern struct {
    data: ?*const ?*MI_Instance,
    size: u32,
};

pub const MI_ConstInstanceA = extern struct {
    data: ?*const ?*MI_Instance,
    size: u32,
};

pub const MI_Value = extern union {
    boolean: u8,
    uint8: u8,
    sint8: i8,
    uint16: u16,
    sint16: i16,
    uint32: u32,
    sint32: i32,
    uint64: u64,
    sint64: i64,
    real32: f32,
    real64: f64,
    char16: u16,
    datetime: MI_Datetime,
    string: ?*u16,
    instance: ?*MI_Instance,
    reference: ?*MI_Instance,
    booleana: MI_BooleanA,
    uint8a: MI_Uint8A,
    sint8a: MI_Sint8A,
    uint16a: MI_Uint16A,
    sint16a: MI_Sint16A,
    uint32a: MI_Uint32A,
    sint32a: MI_Sint32A,
    uint64a: MI_Uint64A,
    sint64a: MI_Sint64A,
    real32a: MI_Real32A,
    real64a: MI_Real64A,
    char16a: MI_Char16A,
    datetimea: MI_DatetimeA,
    stringa: MI_StringA,
    referencea: MI_ReferenceA,
    instancea: MI_InstanceA,
    array: MI_Array,
};

pub const MI_BooleanField = extern struct {
    value: u8,
    exists: u8,
    flags: u8,
};

pub const MI_Sint8Field = extern struct {
    value: i8,
    exists: u8,
    flags: u8,
};

pub const MI_Uint8Field = extern struct {
    value: u8,
    exists: u8,
    flags: u8,
};

pub const MI_Sint16Field = extern struct {
    value: i16,
    exists: u8,
    flags: u8,
};

pub const MI_Uint16Field = extern struct {
    value: u16,
    exists: u8,
    flags: u8,
};

pub const MI_Sint32Field = extern struct {
    value: i32,
    exists: u8,
    flags: u8,
};

pub const MI_Uint32Field = extern struct {
    value: u32,
    exists: u8,
    flags: u8,
};

pub const MI_Sint64Field = extern struct {
    value: i64,
    exists: u8,
    flags: u8,
};

pub const MI_Uint64Field = extern struct {
    value: u64,
    exists: u8,
    flags: u8,
};

pub const MI_Real32Field = extern struct {
    value: f32,
    exists: u8,
    flags: u8,
};

pub const MI_Real64Field = extern struct {
    value: f64,
    exists: u8,
    flags: u8,
};

pub const MI_Char16Field = extern struct {
    value: u16,
    exists: u8,
    flags: u8,
};

pub const MI_DatetimeField = extern struct {
    value: MI_Datetime,
    exists: u8,
    flags: u8,
};

pub const MI_StringField = extern struct {
    value: ?*u16,
    exists: u8,
    flags: u8,
};

pub const MI_ReferenceField = extern struct {
    value: ?*MI_Instance,
    exists: u8,
    flags: u8,
};

pub const MI_InstanceField = extern struct {
    value: ?*MI_Instance,
    exists: u8,
    flags: u8,
};

pub const MI_BooleanAField = extern struct {
    value: MI_BooleanA,
    exists: u8,
    flags: u8,
};

pub const MI_Uint8AField = extern struct {
    value: MI_Uint8A,
    exists: u8,
    flags: u8,
};

pub const MI_Sint8AField = extern struct {
    value: MI_Sint8A,
    exists: u8,
    flags: u8,
};

pub const MI_Uint16AField = extern struct {
    value: MI_Uint16A,
    exists: u8,
    flags: u8,
};

pub const MI_Sint16AField = extern struct {
    value: MI_Sint16A,
    exists: u8,
    flags: u8,
};

pub const MI_Uint32AField = extern struct {
    value: MI_Uint32A,
    exists: u8,
    flags: u8,
};

pub const MI_Sint32AField = extern struct {
    value: MI_Sint32A,
    exists: u8,
    flags: u8,
};

pub const MI_Uint64AField = extern struct {
    value: MI_Uint64A,
    exists: u8,
    flags: u8,
};

pub const MI_Sint64AField = extern struct {
    value: MI_Sint64A,
    exists: u8,
    flags: u8,
};

pub const MI_Real32AField = extern struct {
    value: MI_Real32A,
    exists: u8,
    flags: u8,
};

pub const MI_Real64AField = extern struct {
    value: MI_Real64A,
    exists: u8,
    flags: u8,
};

pub const MI_Char16AField = extern struct {
    value: MI_Char16A,
    exists: u8,
    flags: u8,
};

pub const MI_DatetimeAField = extern struct {
    value: MI_DatetimeA,
    exists: u8,
    flags: u8,
};

pub const MI_StringAField = extern struct {
    value: MI_StringA,
    exists: u8,
    flags: u8,
};

pub const MI_ReferenceAField = extern struct {
    value: MI_ReferenceA,
    exists: u8,
    flags: u8,
};

pub const MI_InstanceAField = extern struct {
    value: MI_InstanceA,
    exists: u8,
    flags: u8,
};

pub const MI_ArrayField = extern struct {
    value: MI_Array,
    exists: u8,
    flags: u8,
};

pub const MI_ConstBooleanField = extern struct {
    value: u8,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint8Field = extern struct {
    value: i8,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint8Field = extern struct {
    value: u8,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint16Field = extern struct {
    value: i16,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint16Field = extern struct {
    value: u16,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint32Field = extern struct {
    value: i32,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint32Field = extern struct {
    value: u32,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint64Field = extern struct {
    value: i64,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint64Field = extern struct {
    value: u64,
    exists: u8,
    flags: u8,
};

pub const MI_ConstReal32Field = extern struct {
    value: f32,
    exists: u8,
    flags: u8,
};

pub const MI_ConstReal64Field = extern struct {
    value: f64,
    exists: u8,
    flags: u8,
};

pub const MI_ConstChar16Field = extern struct {
    value: u16,
    exists: u8,
    flags: u8,
};

pub const MI_ConstDatetimeField = extern struct {
    value: MI_Datetime,
    exists: u8,
    flags: u8,
};

pub const MI_ConstStringField = extern struct {
    value: ?*const u16,
    exists: u8,
    flags: u8,
};

pub const MI_ConstReferenceField = extern struct {
    value: ?*const MI_Instance,
    exists: u8,
    flags: u8,
};

pub const MI_ConstInstanceField = extern struct {
    value: ?*const MI_Instance,
    exists: u8,
    flags: u8,
};

pub const MI_ConstBooleanAField = extern struct {
    value: MI_ConstBooleanA,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint8AField = extern struct {
    value: MI_ConstUint8A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint8AField = extern struct {
    value: MI_ConstSint8A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint16AField = extern struct {
    value: MI_ConstUint16A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint16AField = extern struct {
    value: MI_ConstSint16A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint32AField = extern struct {
    value: MI_ConstUint32A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint32AField = extern struct {
    value: MI_ConstSint32A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstUint64AField = extern struct {
    value: MI_ConstUint64A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstSint64AField = extern struct {
    value: MI_ConstSint64A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstReal32AField = extern struct {
    value: MI_ConstReal32A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstReal64AField = extern struct {
    value: MI_ConstReal64A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstChar16AField = extern struct {
    value: MI_ConstChar16A,
    exists: u8,
    flags: u8,
};

pub const MI_ConstDatetimeAField = extern struct {
    value: MI_ConstDatetimeA,
    exists: u8,
    flags: u8,
};

pub const MI_ConstStringAField = extern struct {
    value: MI_ConstStringA,
    exists: u8,
    flags: u8,
};

pub const MI_ConstReferenceAField = extern struct {
    value: MI_ConstReferenceA,
    exists: u8,
    flags: u8,
};

pub const MI_ConstInstanceAField = extern struct {
    value: MI_ConstInstanceA,
    exists: u8,
    flags: u8,
};

pub const MI_ServerFT = extern struct {
    GetVersion: isize,
    GetSystemName: isize,
};

pub const MI_Server = extern struct {
    serverFT: ?*const MI_ServerFT,
    contextFT: ?*const MI_ContextFT,
    instanceFT: ?*const MI_InstanceFT,
    propertySetFT: ?*const MI_PropertySetFT,
    filterFT: ?*const MI_FilterFT,
};

pub const MI_FilterFT = extern struct {
    Evaluate: isize,
    GetExpression: isize,
};

pub const MI_Filter = extern struct {
    ft: ?*const MI_FilterFT,
    reserved: [3]isize,
};

pub const MI_PropertySetFT = extern struct {
    GetElementCount: isize,
    ContainsElement: isize,
    AddElement: isize,
    GetElementAt: isize,
    Clear: isize,
    Destruct: isize,
    Delete: isize,
    Clone: isize,
};

pub const MI_PropertySet = extern struct {
    ft: ?*const MI_PropertySetFT,
    reserved: [3]isize,
};

pub const MI_ObjectDecl = extern struct {
    flags: u32,
    code: u32,
    name: ?*const u16,
    qualifiers: ?*const ?*MI_Qualifier,
    numQualifiers: u32,
    properties: ?*const ?*MI_PropertyDecl,
    numProperties: u32,
    size: u32,
};

pub const MI_ClassDecl = extern struct {
    flags: u32,
    code: u32,
    name: ?*const u16,
    qualifiers: ?*const ?*MI_Qualifier,
    numQualifiers: u32,
    properties: ?*const ?*MI_PropertyDecl,
    numProperties: u32,
    size: u32,
    superClass: ?*const u16,
    superClassDecl: ?*const MI_ClassDecl,
    methods: ?*const ?*MI_MethodDecl,
    numMethods: u32,
    schema: ?*const MI_SchemaDecl,
    providerFT: ?*const MI_ProviderFT,
    owningClass: ?*MI_Class,
};

pub const MI_FeatureDecl = extern struct {
    flags: u32,
    code: u32,
    name: ?*const u16,
    qualifiers: ?*const ?*MI_Qualifier,
    numQualifiers: u32,
};

pub const MI_ParameterDecl = extern struct {
    flags: u32,
    code: u32,
    name: ?*const u16,
    qualifiers: ?*const ?*MI_Qualifier,
    numQualifiers: u32,
    type: u32,
    className: ?*const u16,
    subscript: u32,
    offset: u32,
};

pub const MI_PropertyDecl = extern struct {
    flags: u32,
    code: u32,
    name: ?*const u16,
    qualifiers: ?*const ?*MI_Qualifier,
    numQualifiers: u32,
    type: u32,
    className: ?*const u16,
    subscript: u32,
    offset: u32,
    origin: ?*const u16,
    propagator: ?*const u16,
    value: ?*const anyopaque,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_MethodDecl_Invoke = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_MethodDecl = extern struct {
    flags: u32,
    code: u32,
    name: ?*const u16,
    qualifiers: ?*const ?*MI_Qualifier,
    numQualifiers: u32,
    parameters: ?*const ?*MI_ParameterDecl,
    numParameters: u32,
    size: u32,
    returnType: u32,
    origin: ?*const u16,
    propagator: ?*const u16,
    schema: ?*const MI_SchemaDecl,
    function: ?MI_MethodDecl_Invoke,
};

pub const MI_QualifierDecl = extern struct {
    name: ?*const u16,
    type: u32,
    scope: u32,
    flavor: u32,
    subscript: u32,
    value: ?*const anyopaque,
};

pub const MI_Qualifier = extern struct {
    name: ?*const u16,
    type: u32,
    flavor: u32,
    value: ?*const anyopaque,
};

pub const MI_SchemaDecl = extern struct {
    qualifierDecls: ?*const ?*MI_QualifierDecl,
    numQualifierDecls: u32,
    classDecls: ?*const ?*MI_ClassDecl,
    numClassDecls: u32,
};

pub const MI_Module_Self = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const MI_ProviderFT_Load = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*?*anyopaque,
        selfModule: ?*MI_Module_Self,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*?*anyopaque,
        selfModule: ?*MI_Module_Self,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT_Unload = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_GetInstance = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT_EnumerateInstances = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
        propertySet: ?*const MI_PropertySet,
        keysOnly: u8,
        filter: ?*const MI_Filter,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
        propertySet: ?*const MI_PropertySet,
        keysOnly: u8,
        filter: ?*const MI_Filter,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_CreateInstance = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_ModifyInstance = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_DeleteInstance = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_AssociatorInstances = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_ReferenceInstances = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT_EnableIndications = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*anyopaque,
        indicationsContext: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*anyopaque,
        indicationsContext: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT_DisableIndications = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*anyopaque,
        indicationsContext: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*anyopaque,
        indicationsContext: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT_Subscribe = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
        filter: ?*const MI_Filter,
        bookmark: ?*const u16,
        subscriptionID: u64,
        subscriptionSelf: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
        filter: ?*const MI_Filter,
        bookmark: ?*const u16,
        subscriptionID: u64,
        subscriptionSelf: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT_Unsubscribe = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
        subscriptionID: u64,
        subscriptionSelf: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*anyopaque,
        context: ?*MI_Context,
        nameSpace: ?*const u16,
        className: ?*const u16,
        subscriptionID: u64,
        subscriptionSelf: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const MI_ProviderFT_Invoke = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ProviderFT = extern struct {
    Load: ?MI_ProviderFT_Load,
    Unload: ?MI_ProviderFT_Unload,
    GetInstance: ?MI_ProviderFT_GetInstance,
    EnumerateInstances: ?MI_ProviderFT_EnumerateInstances,
    CreateInstance: ?MI_ProviderFT_CreateInstance,
    ModifyInstance: ?MI_ProviderFT_ModifyInstance,
    DeleteInstance: ?MI_ProviderFT_DeleteInstance,
    AssociatorInstances: ?MI_ProviderFT_AssociatorInstances,
    ReferenceInstances: ?MI_ProviderFT_ReferenceInstances,
    EnableIndications: ?MI_ProviderFT_EnableIndications,
    DisableIndications: ?MI_ProviderFT_DisableIndications,
    Subscribe: ?MI_ProviderFT_Subscribe,
    Unsubscribe: ?MI_ProviderFT_Unsubscribe,
    Invoke: ?MI_ProviderFT_Invoke,
};

pub const MI_Module_Load = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*?*MI_Module_Self,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*?*MI_Module_Self,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_Module_Unload = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        self: ?*MI_Module_Self,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        self: ?*MI_Module_Self,
        context: ?*MI_Context,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_Module = extern struct {
    version: u32,
    generatorVersion: u32,
    flags: u32,
    charSize: u32,
    schemaDecl: ?*MI_SchemaDecl,
    Load: ?MI_Module_Load,
    Unload: ?MI_Module_Unload,
    dynamicProviderFT: ?*const MI_ProviderFT,
};

pub const MI_InstanceFT = extern struct {
    Clone: isize,
    Destruct: isize,
    Delete: isize,
    IsA: isize,
    GetClassNameA: isize,
    SetNameSpace: isize,
    GetNameSpace: isize,
    GetElementCount: isize,
    AddElement: isize,
    SetElement: isize,
    SetElementAt: isize,
    GetElement: isize,
    GetElementAt: isize,
    ClearElement: isize,
    ClearElementAt: isize,
    GetServerName: isize,
    SetServerName: isize,
    GetClass: isize,
};

pub const MI_InstanceExFT = extern struct {
    parent: MI_InstanceFT,
    Normalize: isize,
};

pub const MI_Instance = extern struct {
    ft: ?*const MI_InstanceFT,
    classDecl: ?*const MI_ClassDecl,
    serverName: ?*const u16,
    nameSpace: ?*const u16,
    reserved: [4]isize,
};

pub const MI_LocaleType = enum(i32) {
    REQUESTED_UI = 0,
    REQUESTED_DATA = 1,
    CLOSEST_UI = 2,
    CLOSEST_DATA = 3,
};
pub const MI_LOCALE_TYPE_REQUESTED_UI = MI_LocaleType.REQUESTED_UI;
pub const MI_LOCALE_TYPE_REQUESTED_DATA = MI_LocaleType.REQUESTED_DATA;
pub const MI_LOCALE_TYPE_CLOSEST_UI = MI_LocaleType.CLOSEST_UI;
pub const MI_LOCALE_TYPE_CLOSEST_DATA = MI_LocaleType.CLOSEST_DATA;

pub const MI_CancellationReason = enum(i32) {
    NONE = 0,
    TIMEOUT = 1,
    SHUTDOWN = 2,
    SERVICESTOP = 3,
};
pub const MI_REASON_NONE = MI_CancellationReason.NONE;
pub const MI_REASON_TIMEOUT = MI_CancellationReason.TIMEOUT;
pub const MI_REASON_SHUTDOWN = MI_CancellationReason.SHUTDOWN;
pub const MI_REASON_SERVICESTOP = MI_CancellationReason.SERVICESTOP;

pub const MI_CancelCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        reason: MI_CancellationReason,
        callbackData: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        reason: MI_CancellationReason,
        callbackData: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_ContextFT = extern struct {
    PostResult: isize,
    PostInstance: isize,
    PostIndication: isize,
    ConstructInstance: isize,
    ConstructParameters: isize,
    NewInstance: isize,
    NewDynamicInstance: isize,
    NewParameters: isize,
    Canceled: isize,
    GetLocale: isize,
    RegisterCancel: isize,
    RequestUnload: isize,
    RefuseUnload: isize,
    GetLocalSession: isize,
    SetStringOption: isize,
    GetStringOption: isize,
    GetNumberOption: isize,
    GetCustomOption: isize,
    GetCustomOptionCount: isize,
    GetCustomOptionAt: isize,
    WriteMessage: isize,
    WriteProgress: isize,
    WriteStreamParameter: isize,
    WriteCimError: isize,
    PromptUser: isize,
    ShouldProcess: isize,
    ShouldContinue: isize,
    PostError: isize,
    PostCimError: isize,
    WriteError: isize,
};

pub const MI_Context = extern struct {
    ft: ?*const MI_ContextFT,
    reserved: [3]isize,
};

pub const MI_MainFunction = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        server: ?*MI_Server,
    ) callconv(@import("std").os.windows.WINAPI) ?*MI_Module,
    else => *const fn (
        server: ?*MI_Server,
    ) callconv(@import("std").os.windows.WINAPI) ?*MI_Module,
};

pub const MI_QualifierSetFT = extern struct {
    GetQualifierCount: isize,
    GetQualifierAt: isize,
    GetQualifier: isize,
};

pub const MI_QualifierSet = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_QualifierSetFT,
};

pub const MI_ParameterSetFT = extern struct {
    GetMethodReturnType: isize,
    GetParameterCount: isize,
    GetParameterAt: isize,
    GetParameter: isize,
};

pub const MI_ParameterSet = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_ParameterSetFT,
};

pub const MI_ClassFT = extern struct {
    GetClassNameA: isize,
    GetNameSpace: isize,
    GetServerName: isize,
    GetElementCount: isize,
    GetElement: isize,
    GetElementAt: isize,
    GetClassQualifierSet: isize,
    GetMethodCount: isize,
    GetMethodAt: isize,
    GetMethod: isize,
    GetParentClassName: isize,
    GetParentClass: isize,
    Delete: isize,
    Clone: isize,
};

pub const MI_Class = extern struct {
    ft: ?*const MI_ClassFT,
    classDecl: ?*const MI_ClassDecl,
    namespaceName: ?*const u16,
    serverName: ?*const u16,
    reserved: [4]isize,
};

pub const MI_OperationCallback_ResponseType = enum(i32) {
    No = 0,
    Yes = 1,
    NoToAll = 2,
    YesToAll = 3,
};
pub const MI_OperationCallback_ResponseType_No = MI_OperationCallback_ResponseType.No;
pub const MI_OperationCallback_ResponseType_Yes = MI_OperationCallback_ResponseType.Yes;
pub const MI_OperationCallback_ResponseType_NoToAll = MI_OperationCallback_ResponseType.NoToAll;
pub const MI_OperationCallback_ResponseType_YesToAll = MI_OperationCallback_ResponseType.YesToAll;

pub const MI_OperationCallback_PromptUser = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        message: ?*const u16,
        promptType: MI_PromptType,
        promptUserResult: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        message: ?*const u16,
        promptType: MI_PromptType,
        promptUserResult: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_WriteError = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        instance: ?*MI_Instance,
        writeErrorResult: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        instance: ?*MI_Instance,
        writeErrorResult: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_WriteMessage = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        channel: u32,
        message: ?*const u16,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        channel: u32,
        message: ?*const u16,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_WriteProgress = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        activity: ?*const u16,
        currentOperation: ?*const u16,
        statusDescription: ?*const u16,
        percentageComplete: u32,
        secondsRemaining: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        activity: ?*const u16,
        currentOperation: ?*const u16,
        statusDescription: ?*const u16,
        percentageComplete: u32,
        secondsRemaining: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_Instance = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        instance: ?*const MI_Instance,
        moreResults: u8,
        resultCode: MI_Result,
        errorString: ?*const u16,
        errorDetails: ?*const MI_Instance,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        instance: ?*const MI_Instance,
        moreResults: u8,
        resultCode: MI_Result,
        errorString: ?*const u16,
        errorDetails: ?*const MI_Instance,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_StreamedParameter = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        parameterName: ?*const u16,
        resultType: MI_Type,
        result: ?*const MI_Value,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        parameterName: ?*const u16,
        resultType: MI_Type,
        result: ?*const MI_Value,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_Indication = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        instance: ?*const MI_Instance,
        bookmark: ?*const u16,
        machineID: ?*const u16,
        moreResults: u8,
        resultCode: MI_Result,
        errorString: ?*const u16,
        errorDetails: ?*const MI_Instance,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        instance: ?*const MI_Instance,
        bookmark: ?*const u16,
        machineID: ?*const u16,
        moreResults: u8,
        resultCode: MI_Result,
        errorString: ?*const u16,
        errorDetails: ?*const MI_Instance,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallback_Class = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        classResult: ?*const MI_Class,
        moreResults: u8,
        resultCode: MI_Result,
        errorString: ?*const u16,
        errorDetails: ?*const MI_Instance,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        operation: ?*MI_Operation,
        callbackContext: ?*anyopaque,
        classResult: ?*const MI_Class,
        moreResults: u8,
        resultCode: MI_Result,
        errorString: ?*const u16,
        errorDetails: ?*const MI_Instance,
        resultAcknowledgement: isize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const MI_OperationCallbacks = extern struct {
    callbackContext: ?*anyopaque,
    promptUser: ?MI_OperationCallback_PromptUser,
    writeError: ?MI_OperationCallback_WriteError,
    writeMessage: ?MI_OperationCallback_WriteMessage,
    writeProgress: ?MI_OperationCallback_WriteProgress,
    instanceResult: ?MI_OperationCallback_Instance,
    indicationResult: ?MI_OperationCallback_Indication,
    classResult: ?MI_OperationCallback_Class,
    streamedParameterResult: ?MI_OperationCallback_StreamedParameter,
};

pub const MI_SessionCallbacks = extern struct {
    callbackContext: ?*anyopaque,
    writeMessage: isize,
    writeError: isize,
};

pub const MI_UsernamePasswordCreds = extern struct {
    domain: ?*const u16,
    username: ?*const u16,
    password: ?*const u16,
};

pub const MI_UserCredentials = extern struct {
    authenticationType: ?*const u16,
    credentials: extern union {
        usernamePassword: MI_UsernamePasswordCreds,
        certificateThumbprint: ?*const u16,
    },
};

pub const MI_SubscriptionDeliveryType = enum(i32) {
    ll = 1,
    sh = 2,
};
pub const MI_SubscriptionDeliveryType_Pull = MI_SubscriptionDeliveryType.ll;
pub const MI_SubscriptionDeliveryType_Push = MI_SubscriptionDeliveryType.sh;

pub const MI_SubscriptionDeliveryOptionsFT = extern struct {
    SetString: isize,
    SetNumber: isize,
    SetDateTime: isize,
    SetInterval: isize,
    AddCredentials: isize,
    Delete: isize,
    GetString: isize,
    GetNumber: isize,
    GetDateTime: isize,
    GetInterval: isize,
    GetOptionCount: isize,
    GetOptionAt: isize,
    GetOption: isize,
    GetCredentialsCount: isize,
    GetCredentialsAt: isize,
    GetCredentialsPasswordAt: isize,
    Clone: isize,
};

pub const MI_SubscriptionDeliveryOptions = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_SubscriptionDeliveryOptionsFT,
};

pub const MI_Serializer = extern struct {
    reserved1: u64,
    reserved2: isize,
};

pub const MI_Deserializer = extern struct {
    reserved1: u64,
    reserved2: isize,
};

pub const MI_SerializerFT = extern struct {
    Close: isize,
    SerializeClass: isize,
    SerializeInstance: isize,
};

pub const MI_Deserializer_ClassObjectNeeded = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        context: ?*anyopaque,
        serverName: ?*const u16,
        namespaceName: ?*const u16,
        className: ?*const u16,
        requestedClassObject: ?*?*MI_Class,
    ) callconv(@import("std").os.windows.WINAPI) MI_Result,
    else => *const fn (
        context: ?*anyopaque,
        serverName: ?*const u16,
        namespaceName: ?*const u16,
        className: ?*const u16,
        requestedClassObject: ?*?*MI_Class,
    ) callconv(@import("std").os.windows.WINAPI) MI_Result,
};

pub const MI_DeserializerFT = extern struct {
    Close: isize,
    DeserializeClass: isize,
    Class_GetClassName: isize,
    Class_GetParentClassName: isize,
    DeserializeInstance: isize,
    Instance_GetClassName: isize,
};

pub const MI_ApplicationFT = extern struct {
    Close: isize,
    NewSession: isize,
    NewHostedProvider: isize,
    NewInstance: isize,
    NewDestinationOptions: isize,
    NewOperationOptions: isize,
    NewSubscriptionDeliveryOptions: isize,
    NewSerializer: isize,
    NewDeserializer: isize,
    NewInstanceFromClass: isize,
    NewClass: isize,
};

pub const MI_HostedProviderFT = extern struct {
    Close: isize,
    GetApplication: isize,
};

pub const MI_SessionFT = extern struct {
    Close: isize,
    GetApplication: isize,
    GetInstance: isize,
    ModifyInstance: isize,
    CreateInstance: isize,
    DeleteInstance: isize,
    Invoke: isize,
    EnumerateInstances: isize,
    QueryInstances: isize,
    AssociatorInstances: isize,
    ReferenceInstances: isize,
    Subscribe: isize,
    GetClass: isize,
    EnumerateClasses: isize,
    TestConnection: isize,
};

pub const MI_OperationFT = extern struct {
    Close: isize,
    Cancel: isize,
    GetSession: isize,
    GetInstance: isize,
    GetIndication: isize,
    GetClass: isize,
};

pub const MI_DestinationOptionsFT = extern struct {
    Delete: isize,
    SetString: isize,
    SetNumber: isize,
    AddCredentials: isize,
    GetString: isize,
    GetNumber: isize,
    GetOptionCount: isize,
    GetOptionAt: isize,
    GetOption: isize,
    GetCredentialsCount: isize,
    GetCredentialsAt: isize,
    GetCredentialsPasswordAt: isize,
    Clone: isize,
    SetInterval: isize,
    GetInterval: isize,
};

pub const MI_OperationOptionsFT = extern struct {
    Delete: isize,
    SetString: isize,
    SetNumber: isize,
    SetCustomOption: isize,
    GetString: isize,
    GetNumber: isize,
    GetOptionCount: isize,
    GetOptionAt: isize,
    GetOption: isize,
    GetEnabledChannels: isize,
    Clone: isize,
    SetInterval: isize,
    GetInterval: isize,
};

pub const MI_Application = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_ApplicationFT,
};

pub const MI_Session = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_SessionFT,
};

pub const MI_Operation = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_OperationFT,
};

pub const MI_HostedProvider = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_HostedProviderFT,
};

pub const MI_DestinationOptions = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_DestinationOptionsFT,
};

pub const MI_OperationOptions = extern struct {
    reserved1: u64,
    reserved2: isize,
    ft: ?*const MI_OperationOptionsFT,
};

pub const MI_UtilitiesFT = extern struct {
    MapErrorToMiErrorCategory: isize,
    CimErrorFromErrorCode: isize,
};

pub const MI_ClientFT_V1 = extern struct {
    applicationFT: ?*const MI_ApplicationFT,
    sessionFT: ?*const MI_SessionFT,
    operationFT: ?*const MI_OperationFT,
    hostedProviderFT: ?*const MI_HostedProviderFT,
    serializerFT: ?*const MI_SerializerFT,
    deserializerFT: ?*const MI_DeserializerFT,
    subscribeDeliveryOptionsFT: ?*const MI_SubscriptionDeliveryOptionsFT,
    destinationOptionsFT: ?*const MI_DestinationOptionsFT,
    operationOptionsFT: ?*const MI_OperationOptionsFT,
    utilitiesFT: ?*const MI_UtilitiesFT,
};

pub const MI_DestinationOptions_ImpersonationType = enum(i32) {
    Default = 0,
    None = 1,
    Identify = 2,
    Impersonate = 3,
    Delegate = 4,
};
pub const MI_DestinationOptions_ImpersonationType_Default = MI_DestinationOptions_ImpersonationType.Default;
pub const MI_DestinationOptions_ImpersonationType_None = MI_DestinationOptions_ImpersonationType.None;
pub const MI_DestinationOptions_ImpersonationType_Identify = MI_DestinationOptions_ImpersonationType.Identify;
pub const MI_DestinationOptions_ImpersonationType_Impersonate = MI_DestinationOptions_ImpersonationType.Impersonate;
pub const MI_DestinationOptions_ImpersonationType_Delegate = MI_DestinationOptions_ImpersonationType.Delegate;

const CLSID_WbemDefPath_Value = Guid.initString("cf4cc405-e2c5-4ddd-b3ce-5e7582d8c9fa");
pub const CLSID_WbemDefPath = &CLSID_WbemDefPath_Value;

const CLSID_WbemQuery_Value = Guid.initString("eac8a024-21e2-4523-ad73-a71a0aa2f56a");
pub const CLSID_WbemQuery = &CLSID_WbemQuery_Value;

pub const WBEM_PATH_STATUS_FLAG = enum(i32) {
    ANON_LOCAL_MACHINE = 1,
    HAS_MACHINE_NAME = 2,
    IS_CLASS_REF = 4,
    IS_INST_REF = 8,
    HAS_SUBSCOPES = 16,
    IS_COMPOUND = 32,
    HAS_V2_REF_PATHS = 64,
    HAS_IMPLIED_KEY = 128,
    CONTAINS_SINGLETON = 256,
    V1_COMPLIANT = 512,
    V2_COMPLIANT = 1024,
    CIM_COMPLIANT = 2048,
    IS_SINGLETON = 4096,
    IS_PARENT = 8192,
    SERVER_NAMESPACE_ONLY = 16384,
    NATIVE_PATH = 32768,
    WMI_PATH = 65536,
    PATH_HAD_SERVER = 131072,
};
pub const WBEMPATH_INFO_ANON_LOCAL_MACHINE = WBEM_PATH_STATUS_FLAG.ANON_LOCAL_MACHINE;
pub const WBEMPATH_INFO_HAS_MACHINE_NAME = WBEM_PATH_STATUS_FLAG.HAS_MACHINE_NAME;
pub const WBEMPATH_INFO_IS_CLASS_REF = WBEM_PATH_STATUS_FLAG.IS_CLASS_REF;
pub const WBEMPATH_INFO_IS_INST_REF = WBEM_PATH_STATUS_FLAG.IS_INST_REF;
pub const WBEMPATH_INFO_HAS_SUBSCOPES = WBEM_PATH_STATUS_FLAG.HAS_SUBSCOPES;
pub const WBEMPATH_INFO_IS_COMPOUND = WBEM_PATH_STATUS_FLAG.IS_COMPOUND;
pub const WBEMPATH_INFO_HAS_V2_REF_PATHS = WBEM_PATH_STATUS_FLAG.HAS_V2_REF_PATHS;
pub const WBEMPATH_INFO_HAS_IMPLIED_KEY = WBEM_PATH_STATUS_FLAG.HAS_IMPLIED_KEY;
pub const WBEMPATH_INFO_CONTAINS_SINGLETON = WBEM_PATH_STATUS_FLAG.CONTAINS_SINGLETON;
pub const WBEMPATH_INFO_V1_COMPLIANT = WBEM_PATH_STATUS_FLAG.V1_COMPLIANT;
pub const WBEMPATH_INFO_V2_COMPLIANT = WBEM_PATH_STATUS_FLAG.V2_COMPLIANT;
pub const WBEMPATH_INFO_CIM_COMPLIANT = WBEM_PATH_STATUS_FLAG.CIM_COMPLIANT;
pub const WBEMPATH_INFO_IS_SINGLETON = WBEM_PATH_STATUS_FLAG.IS_SINGLETON;
pub const WBEMPATH_INFO_IS_PARENT = WBEM_PATH_STATUS_FLAG.IS_PARENT;
pub const WBEMPATH_INFO_SERVER_NAMESPACE_ONLY = WBEM_PATH_STATUS_FLAG.SERVER_NAMESPACE_ONLY;
pub const WBEMPATH_INFO_NATIVE_PATH = WBEM_PATH_STATUS_FLAG.NATIVE_PATH;
pub const WBEMPATH_INFO_WMI_PATH = WBEM_PATH_STATUS_FLAG.WMI_PATH;
pub const WBEMPATH_INFO_PATH_HAD_SERVER = WBEM_PATH_STATUS_FLAG.PATH_HAD_SERVER;

pub const WBEM_PATH_CREATE_FLAG = enum(i32) {
    CREATE_ACCEPT_RELATIVE = 1,
    CREATE_ACCEPT_ABSOLUTE = 2,
    CREATE_ACCEPT_ALL = 4,
    TREAT_SINGLE_IDENT_AS_NS = 8,
};
pub const WBEMPATH_CREATE_ACCEPT_RELATIVE = WBEM_PATH_CREATE_FLAG.CREATE_ACCEPT_RELATIVE;
pub const WBEMPATH_CREATE_ACCEPT_ABSOLUTE = WBEM_PATH_CREATE_FLAG.CREATE_ACCEPT_ABSOLUTE;
pub const WBEMPATH_CREATE_ACCEPT_ALL = WBEM_PATH_CREATE_FLAG.CREATE_ACCEPT_ALL;
pub const WBEMPATH_TREAT_SINGLE_IDENT_AS_NS = WBEM_PATH_CREATE_FLAG.TREAT_SINGLE_IDENT_AS_NS;

pub const WBEM_GET_TEXT_FLAGS = enum(i32) {
    COMPRESSED = 1,
    GET_RELATIVE_ONLY = 2,
    GET_SERVER_TOO = 4,
    GET_SERVER_AND_NAMESPACE_ONLY = 8,
    GET_NAMESPACE_ONLY = 16,
    GET_ORIGINAL = 32,
};
pub const WBEMPATH_COMPRESSED = WBEM_GET_TEXT_FLAGS.COMPRESSED;
pub const WBEMPATH_GET_RELATIVE_ONLY = WBEM_GET_TEXT_FLAGS.GET_RELATIVE_ONLY;
pub const WBEMPATH_GET_SERVER_TOO = WBEM_GET_TEXT_FLAGS.GET_SERVER_TOO;
pub const WBEMPATH_GET_SERVER_AND_NAMESPACE_ONLY = WBEM_GET_TEXT_FLAGS.GET_SERVER_AND_NAMESPACE_ONLY;
pub const WBEMPATH_GET_NAMESPACE_ONLY = WBEM_GET_TEXT_FLAGS.GET_NAMESPACE_ONLY;
pub const WBEMPATH_GET_ORIGINAL = WBEM_GET_TEXT_FLAGS.GET_ORIGINAL;

pub const WBEM_GET_KEY_FLAGS = enum(i32) {
    TEXT = 1,
    QUOTEDTEXT = 2,
};
pub const WBEMPATH_TEXT = WBEM_GET_KEY_FLAGS.TEXT;
pub const WBEMPATH_QUOTEDTEXT = WBEM_GET_KEY_FLAGS.QUOTEDTEXT;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemPathKeyList_Value = Guid.initString("9ae62877-7544-4bb0-aa26-a13824659ed6");
pub const IID_IWbemPathKeyList = &IID_IWbemPathKeyList_Value;
pub const IWbemPathKeyList = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                puKeyCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                puKeyCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetKey: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                wszName: ?[*:0]const u16,
                uFlags: u32,
                uCimType: u32,
                pKeyVal: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                wszName: ?[*:0]const u16,
                uFlags: u32,
                uCimType: u32,
                pKeyVal: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetKey2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                wszName: ?[*:0]const u16,
                uFlags: u32,
                uCimType: u32,
                pKeyVal: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                wszName: ?[*:0]const u16,
                uFlags: u32,
                uCimType: u32,
                pKeyVal: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetKey: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                uKeyIx: u32,
                uFlags: u32,
                puNameBufSize: ?*u32,
                pszKeyName: ?[*:0]u16,
                puKeyValBufSize: ?*u32,
                pKeyVal: ?*anyopaque,
                puApparentCimType: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                uKeyIx: u32,
                uFlags: u32,
                puNameBufSize: ?*u32,
                pszKeyName: ?[*:0]u16,
                puKeyValBufSize: ?*u32,
                pKeyVal: ?*anyopaque,
                puApparentCimType: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetKey2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                uKeyIx: u32,
                uFlags: u32,
                puNameBufSize: ?*u32,
                pszKeyName: ?[*:0]u16,
                pKeyValue: ?*VARIANT,
                puApparentCimType: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                uKeyIx: u32,
                uFlags: u32,
                puNameBufSize: ?*u32,
                pszKeyName: ?[*:0]u16,
                pKeyValue: ?*VARIANT,
                puApparentCimType: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveKey: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                wszName: ?[*:0]const u16,
                uFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                wszName: ?[*:0]const u16,
                uFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAllKeys: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                uFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                uFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MakeSingleton: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                bSet: u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                bSet: u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                uRequestedInfo: u32,
                puResponse: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                uRequestedInfo: u32,
                puResponse: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPathKeyList,
                lFlags: i32,
                puBuffLength: ?*u32,
                pszText: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPathKeyList,
                lFlags: i32,
                puBuffLength: ?*u32,
                pszText: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_GetCount(self: *const T, puKeyCount: ?*u32) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).GetCount(@as(*const IWbemPathKeyList, @ptrCast(self)), puKeyCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_SetKey(self: *const T, wszName: ?[*:0]const u16, uFlags: u32, uCimType: u32, pKeyVal: ?*anyopaque) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).SetKey(@as(*const IWbemPathKeyList, @ptrCast(self)), wszName, uFlags, uCimType, pKeyVal);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_SetKey2(self: *const T, wszName: ?[*:0]const u16, uFlags: u32, uCimType: u32, pKeyVal: ?*VARIANT) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).SetKey2(@as(*const IWbemPathKeyList, @ptrCast(self)), wszName, uFlags, uCimType, pKeyVal);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_GetKey(self: *const T, uKeyIx: u32, uFlags: u32, puNameBufSize: ?*u32, pszKeyName: ?[*:0]u16, puKeyValBufSize: ?*u32, pKeyVal: ?*anyopaque, puApparentCimType: ?*u32) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).GetKey(@as(*const IWbemPathKeyList, @ptrCast(self)), uKeyIx, uFlags, puNameBufSize, pszKeyName, puKeyValBufSize, pKeyVal, puApparentCimType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_GetKey2(self: *const T, uKeyIx: u32, uFlags: u32, puNameBufSize: ?*u32, pszKeyName: ?[*:0]u16, pKeyValue: ?*VARIANT, puApparentCimType: ?*u32) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).GetKey2(@as(*const IWbemPathKeyList, @ptrCast(self)), uKeyIx, uFlags, puNameBufSize, pszKeyName, pKeyValue, puApparentCimType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_RemoveKey(self: *const T, wszName: ?[*:0]const u16, uFlags: u32) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).RemoveKey(@as(*const IWbemPathKeyList, @ptrCast(self)), wszName, uFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_RemoveAllKeys(self: *const T, uFlags: u32) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).RemoveAllKeys(@as(*const IWbemPathKeyList, @ptrCast(self)), uFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_MakeSingleton(self: *const T, bSet: u8) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).MakeSingleton(@as(*const IWbemPathKeyList, @ptrCast(self)), bSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_GetInfo(self: *const T, uRequestedInfo: u32, puResponse: ?*u64) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).GetInfo(@as(*const IWbemPathKeyList, @ptrCast(self)), uRequestedInfo, puResponse);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPathKeyList_GetText(self: *const T, lFlags: i32, puBuffLength: ?*u32, pszText: [*:0]u16) HRESULT {
                return @as(*const IWbemPathKeyList.VTable, @ptrCast(self.vtable)).GetText(@as(*const IWbemPathKeyList, @ptrCast(self)), lFlags, puBuffLength, pszText);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemPath_Value = Guid.initString("3bc15af2-736c-477e-9e51-238af8667dcc");
pub const IID_IWbemPath = &IID_IWbemPath_Value;
pub const IWbemPath = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uMode: u32,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uMode: u32,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                lFlags: i32,
                puBuffLength: ?*u32,
                pszText: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                lFlags: i32,
                puBuffLength: ?*u32,
                pszText: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uRequestedInfo: u32,
                puResponse: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uRequestedInfo: u32,
                puResponse: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetServer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                Name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                Name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetServer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                puNameBufLength: ?*u32,
                pName: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                puNameBufLength: ?*u32,
                pName: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNamespaceCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                puCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                puCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetNamespaceAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
                pszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
                pszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNamespaceAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
                puNameBufLength: ?*u32,
                pName: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
                puNameBufLength: ?*u32,
                pName: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveNamespaceAt: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAllNamespaces: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetScopeCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                puCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                puCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
                pszClass: ?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
                pszClass: ?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScopeFromText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
                pszText: ?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
                pszText: ?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetScope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
                puClassNameBufSize: ?*u32,
                pszClass: [*:0]u16,
                pKeyList: ?*?*IWbemPathKeyList,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
                puClassNameBufSize: ?*u32,
                pszClass: [*:0]u16,
                pKeyList: ?*?*IWbemPathKeyList,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetScopeAsText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
                puTextBufSize: ?*u32,
                pszText: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
                puTextBufSize: ?*u32,
                pszText: [*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveScope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                uIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                uIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAllScopes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClassName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                Name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                Name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetClassName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                puBuffLength: ?*u32,
                pszName: ?[*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                puBuffLength: ?*u32,
                pszName: ?[*:0]u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetKeyList: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                pOut: ?*?*IWbemPathKeyList,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                pOut: ?*?*IWbemPathKeyList,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateClassPart: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                lFlags: i32,
                Name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                lFlags: i32,
                Name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteClassPart: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPath,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsRelative: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                wszMachine: ?PWSTR,
                wszNamespace: ?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
            else => *const fn (
                self: *const IWbemPath,
                wszMachine: ?PWSTR,
                wszNamespace: ?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
        },
        IsRelativeOrChild: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                wszMachine: ?PWSTR,
                wszNamespace: ?PWSTR,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
            else => *const fn (
                self: *const IWbemPath,
                wszMachine: ?PWSTR,
                wszNamespace: ?PWSTR,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
        },
        IsLocal: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                wszMachine: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
            else => *const fn (
                self: *const IWbemPath,
                wszMachine: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
        },
        IsSameClassName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPath,
                wszClass: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
            else => *const fn (
                self: *const IWbemPath,
                wszClass: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_SetText(self: *const T, uMode: u32, pszPath: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).SetText(@as(*const IWbemPath, @ptrCast(self)), uMode, pszPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetText(self: *const T, lFlags: i32, puBuffLength: ?*u32, pszText: [*:0]u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetText(@as(*const IWbemPath, @ptrCast(self)), lFlags, puBuffLength, pszText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetInfo(self: *const T, uRequestedInfo: u32, puResponse: ?*u64) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetInfo(@as(*const IWbemPath, @ptrCast(self)), uRequestedInfo, puResponse);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_SetServer(self: *const T, Name: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).SetServer(@as(*const IWbemPath, @ptrCast(self)), Name);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetServer(self: *const T, puNameBufLength: ?*u32, pName: [*:0]u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetServer(@as(*const IWbemPath, @ptrCast(self)), puNameBufLength, pName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetNamespaceCount(self: *const T, puCount: ?*u32) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetNamespaceCount(@as(*const IWbemPath, @ptrCast(self)), puCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_SetNamespaceAt(self: *const T, uIndex: u32, pszName: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).SetNamespaceAt(@as(*const IWbemPath, @ptrCast(self)), uIndex, pszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetNamespaceAt(self: *const T, uIndex: u32, puNameBufLength: ?*u32, pName: [*:0]u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetNamespaceAt(@as(*const IWbemPath, @ptrCast(self)), uIndex, puNameBufLength, pName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_RemoveNamespaceAt(self: *const T, uIndex: u32) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).RemoveNamespaceAt(@as(*const IWbemPath, @ptrCast(self)), uIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_RemoveAllNamespaces(self: *const T) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).RemoveAllNamespaces(@as(*const IWbemPath, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetScopeCount(self: *const T, puCount: ?*u32) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetScopeCount(@as(*const IWbemPath, @ptrCast(self)), puCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_SetScope(self: *const T, uIndex: u32, pszClass: ?PWSTR) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).SetScope(@as(*const IWbemPath, @ptrCast(self)), uIndex, pszClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_SetScopeFromText(self: *const T, uIndex: u32, pszText: ?PWSTR) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).SetScopeFromText(@as(*const IWbemPath, @ptrCast(self)), uIndex, pszText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetScope(self: *const T, uIndex: u32, puClassNameBufSize: ?*u32, pszClass: [*:0]u16, pKeyList: ?*?*IWbemPathKeyList) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetScope(@as(*const IWbemPath, @ptrCast(self)), uIndex, puClassNameBufSize, pszClass, pKeyList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetScopeAsText(self: *const T, uIndex: u32, puTextBufSize: ?*u32, pszText: [*:0]u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetScopeAsText(@as(*const IWbemPath, @ptrCast(self)), uIndex, puTextBufSize, pszText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_RemoveScope(self: *const T, uIndex: u32) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).RemoveScope(@as(*const IWbemPath, @ptrCast(self)), uIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_RemoveAllScopes(self: *const T) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).RemoveAllScopes(@as(*const IWbemPath, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_SetClassName(self: *const T, Name: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).SetClassName(@as(*const IWbemPath, @ptrCast(self)), Name);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetClassName(self: *const T, puBuffLength: ?*u32, pszName: ?[*:0]u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetClassName(@as(*const IWbemPath, @ptrCast(self)), puBuffLength, pszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_GetKeyList(self: *const T, pOut: ?*?*IWbemPathKeyList) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).GetKeyList(@as(*const IWbemPath, @ptrCast(self)), pOut);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_CreateClassPart(self: *const T, lFlags: i32, Name: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).CreateClassPart(@as(*const IWbemPath, @ptrCast(self)), lFlags, Name);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_DeleteClassPart(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).DeleteClassPart(@as(*const IWbemPath, @ptrCast(self)), lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_IsRelative(self: *const T, wszMachine: ?PWSTR, wszNamespace: ?PWSTR) BOOL {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).IsRelative(@as(*const IWbemPath, @ptrCast(self)), wszMachine, wszNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_IsRelativeOrChild(self: *const T, wszMachine: ?PWSTR, wszNamespace: ?PWSTR, lFlags: i32) BOOL {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).IsRelativeOrChild(@as(*const IWbemPath, @ptrCast(self)), wszMachine, wszNamespace, lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_IsLocal(self: *const T, wszMachine: ?[*:0]const u16) BOOL {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).IsLocal(@as(*const IWbemPath, @ptrCast(self)), wszMachine);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPath_IsSameClassName(self: *const T, wszClass: ?[*:0]const u16) BOOL {
                return @as(*const IWbemPath.VTable, @ptrCast(self.vtable)).IsSameClassName(@as(*const IWbemPath, @ptrCast(self)), wszClass);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemQuery_Value = Guid.initString("81166f58-dd98-11d3-a120-00105a1f515a");
pub const IID_IWbemQuery = &IID_IWbemQuery_Value;
pub const IWbemQuery = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Empty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetLanguageFeatures: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
                uFlags: u32,
                uArraySize: u32,
                puFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
                uFlags: u32,
                uArraySize: u32,
                puFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        TestLanguageFeatures: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
                uFlags: u32,
                uArraySize: ?*u32,
                puFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
                uFlags: u32,
                uArraySize: ?*u32,
                puFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Parse: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
                pszLang: ?[*:0]const u16,
                pszQuery: ?[*:0]const u16,
                uFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
                pszLang: ?[*:0]const u16,
                pszQuery: ?[*:0]const u16,
                uFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAnalysis: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
                uAnalysisType: u32,
                uFlags: u32,
                pAnalysis: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
                uAnalysisType: u32,
                uFlags: u32,
                pAnalysis: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FreeMemory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
                pMem: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
                pMem: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetQueryInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQuery,
                uAnalysisType: u32,
                uInfoId: u32,
                uBufSize: u32,
                pDestBuf: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQuery,
                uAnalysisType: u32,
                uInfoId: u32,
                uBufSize: u32,
                pDestBuf: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_Empty(self: *const T) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).Empty(@as(*const IWbemQuery, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_SetLanguageFeatures(self: *const T, uFlags: u32, uArraySize: u32, puFeatures: ?*u32) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).SetLanguageFeatures(@as(*const IWbemQuery, @ptrCast(self)), uFlags, uArraySize, puFeatures);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_TestLanguageFeatures(self: *const T, uFlags: u32, uArraySize: ?*u32, puFeatures: ?*u32) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).TestLanguageFeatures(@as(*const IWbemQuery, @ptrCast(self)), uFlags, uArraySize, puFeatures);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_Parse(self: *const T, pszLang: ?[*:0]const u16, pszQuery: ?[*:0]const u16, uFlags: u32) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).Parse(@as(*const IWbemQuery, @ptrCast(self)), pszLang, pszQuery, uFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_GetAnalysis(self: *const T, uAnalysisType: u32, uFlags: u32, pAnalysis: ?*?*anyopaque) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).GetAnalysis(@as(*const IWbemQuery, @ptrCast(self)), uAnalysisType, uFlags, pAnalysis);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_FreeMemory(self: *const T, pMem: ?*anyopaque) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).FreeMemory(@as(*const IWbemQuery, @ptrCast(self)), pMem);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQuery_GetQueryInfo(self: *const T, uAnalysisType: u32, uInfoId: u32, uBufSize: u32, pDestBuf: ?*anyopaque) HRESULT {
                return @as(*const IWbemQuery.VTable, @ptrCast(self.vtable)).GetQueryInfo(@as(*const IWbemQuery, @ptrCast(self)), uAnalysisType, uInfoId, uBufSize, pDestBuf);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WMIQ_ANALYSIS_TYPE = enum(i32) {
    RPN_SEQUENCE = 1,
    ASSOC_QUERY = 2,
    PROP_ANALYSIS_MATRIX = 3,
    QUERY_TEXT = 4,
    RESERVED = 134217728,
};
pub const WMIQ_ANALYSIS_RPN_SEQUENCE = WMIQ_ANALYSIS_TYPE.RPN_SEQUENCE;
pub const WMIQ_ANALYSIS_ASSOC_QUERY = WMIQ_ANALYSIS_TYPE.ASSOC_QUERY;
pub const WMIQ_ANALYSIS_PROP_ANALYSIS_MATRIX = WMIQ_ANALYSIS_TYPE.PROP_ANALYSIS_MATRIX;
pub const WMIQ_ANALYSIS_QUERY_TEXT = WMIQ_ANALYSIS_TYPE.QUERY_TEXT;
pub const WMIQ_ANALYSIS_RESERVED = WMIQ_ANALYSIS_TYPE.RESERVED;

pub const WMIQ_RPN_TOKEN_FLAGS = enum(i32) {
    TOKEN_EXPRESSION = 1,
    TOKEN_AND = 2,
    TOKEN_OR = 3,
    TOKEN_NOT = 4,
    OP_UNDEFINED = 0,
    // OP_EQ = 1, this enum value conflicts with TOKEN_EXPRESSION
    // OP_NE = 2, this enum value conflicts with TOKEN_AND
    // OP_GE = 3, this enum value conflicts with TOKEN_OR
    // OP_LE = 4, this enum value conflicts with TOKEN_NOT
    OP_LT = 5,
    OP_GT = 6,
    OP_LIKE = 7,
    OP_ISA = 8,
    OP_ISNOTA = 9,
    OP_ISNULL = 10,
    OP_ISNOTNULL = 11,
    // LEFT_PROPERTY_NAME = 1, this enum value conflicts with TOKEN_EXPRESSION
    // RIGHT_PROPERTY_NAME = 2, this enum value conflicts with TOKEN_AND
    // CONST2 = 4, this enum value conflicts with TOKEN_NOT
    // CONST = 8, this enum value conflicts with OP_ISA
    RELOP = 16,
    LEFT_FUNCTION = 32,
    RIGHT_FUNCTION = 64,
    // GET_TOKEN_TYPE = 1, this enum value conflicts with TOKEN_EXPRESSION
    // GET_EXPR_SHAPE = 2, this enum value conflicts with TOKEN_AND
    // GET_LEFT_FUNCTION = 3, this enum value conflicts with TOKEN_OR
    // GET_RIGHT_FUNCTION = 4, this enum value conflicts with TOKEN_NOT
    // GET_RELOP = 5, this enum value conflicts with OP_LT
    // NEXT_TOKEN = 1, this enum value conflicts with TOKEN_EXPRESSION
    // FROM_UNARY = 1, this enum value conflicts with TOKEN_EXPRESSION
    // FROM_PATH = 2, this enum value conflicts with TOKEN_AND
    // FROM_CLASS_LIST = 4, this enum value conflicts with TOKEN_NOT
    // FROM_MULTIPLE = 8, this enum value conflicts with OP_ISA
};
pub const WMIQ_RPN_TOKEN_EXPRESSION = WMIQ_RPN_TOKEN_FLAGS.TOKEN_EXPRESSION;
pub const WMIQ_RPN_TOKEN_AND = WMIQ_RPN_TOKEN_FLAGS.TOKEN_AND;
pub const WMIQ_RPN_TOKEN_OR = WMIQ_RPN_TOKEN_FLAGS.TOKEN_OR;
pub const WMIQ_RPN_TOKEN_NOT = WMIQ_RPN_TOKEN_FLAGS.TOKEN_NOT;
pub const WMIQ_RPN_OP_UNDEFINED = WMIQ_RPN_TOKEN_FLAGS.OP_UNDEFINED;
pub const WMIQ_RPN_OP_EQ = WMIQ_RPN_TOKEN_FLAGS.TOKEN_EXPRESSION;
pub const WMIQ_RPN_OP_NE = WMIQ_RPN_TOKEN_FLAGS.TOKEN_AND;
pub const WMIQ_RPN_OP_GE = WMIQ_RPN_TOKEN_FLAGS.TOKEN_OR;
pub const WMIQ_RPN_OP_LE = WMIQ_RPN_TOKEN_FLAGS.TOKEN_NOT;
pub const WMIQ_RPN_OP_LT = WMIQ_RPN_TOKEN_FLAGS.OP_LT;
pub const WMIQ_RPN_OP_GT = WMIQ_RPN_TOKEN_FLAGS.OP_GT;
pub const WMIQ_RPN_OP_LIKE = WMIQ_RPN_TOKEN_FLAGS.OP_LIKE;
pub const WMIQ_RPN_OP_ISA = WMIQ_RPN_TOKEN_FLAGS.OP_ISA;
pub const WMIQ_RPN_OP_ISNOTA = WMIQ_RPN_TOKEN_FLAGS.OP_ISNOTA;
pub const WMIQ_RPN_OP_ISNULL = WMIQ_RPN_TOKEN_FLAGS.OP_ISNULL;
pub const WMIQ_RPN_OP_ISNOTNULL = WMIQ_RPN_TOKEN_FLAGS.OP_ISNOTNULL;
pub const WMIQ_RPN_LEFT_PROPERTY_NAME = WMIQ_RPN_TOKEN_FLAGS.TOKEN_EXPRESSION;
pub const WMIQ_RPN_RIGHT_PROPERTY_NAME = WMIQ_RPN_TOKEN_FLAGS.TOKEN_AND;
pub const WMIQ_RPN_CONST2 = WMIQ_RPN_TOKEN_FLAGS.TOKEN_NOT;
pub const WMIQ_RPN_CONST = WMIQ_RPN_TOKEN_FLAGS.OP_ISA;
pub const WMIQ_RPN_RELOP = WMIQ_RPN_TOKEN_FLAGS.RELOP;
pub const WMIQ_RPN_LEFT_FUNCTION = WMIQ_RPN_TOKEN_FLAGS.LEFT_FUNCTION;
pub const WMIQ_RPN_RIGHT_FUNCTION = WMIQ_RPN_TOKEN_FLAGS.RIGHT_FUNCTION;
pub const WMIQ_RPN_GET_TOKEN_TYPE = WMIQ_RPN_TOKEN_FLAGS.TOKEN_EXPRESSION;
pub const WMIQ_RPN_GET_EXPR_SHAPE = WMIQ_RPN_TOKEN_FLAGS.TOKEN_AND;
pub const WMIQ_RPN_GET_LEFT_FUNCTION = WMIQ_RPN_TOKEN_FLAGS.TOKEN_OR;
pub const WMIQ_RPN_GET_RIGHT_FUNCTION = WMIQ_RPN_TOKEN_FLAGS.TOKEN_NOT;
pub const WMIQ_RPN_GET_RELOP = WMIQ_RPN_TOKEN_FLAGS.OP_LT;
pub const WMIQ_RPN_NEXT_TOKEN = WMIQ_RPN_TOKEN_FLAGS.TOKEN_EXPRESSION;
pub const WMIQ_RPN_FROM_UNARY = WMIQ_RPN_TOKEN_FLAGS.TOKEN_EXPRESSION;
pub const WMIQ_RPN_FROM_PATH = WMIQ_RPN_TOKEN_FLAGS.TOKEN_AND;
pub const WMIQ_RPN_FROM_CLASS_LIST = WMIQ_RPN_TOKEN_FLAGS.TOKEN_NOT;
pub const WMIQ_RPN_FROM_MULTIPLE = WMIQ_RPN_TOKEN_FLAGS.OP_ISA;

pub const WMIQ_ASSOCQ_FLAGS = enum(i32) {
    ASSOCIATORS = 1,
    REFERENCES = 2,
    RESULTCLASS = 4,
    ASSOCCLASS = 8,
    ROLE = 16,
    RESULTROLE = 32,
    REQUIREDQUALIFIER = 64,
    REQUIREDASSOCQUALIFIER = 128,
    CLASSDEFSONLY = 256,
    KEYSONLY = 512,
    SCHEMAONLY = 1024,
    CLASSREFSONLY = 2048,
};
pub const WMIQ_ASSOCQ_ASSOCIATORS = WMIQ_ASSOCQ_FLAGS.ASSOCIATORS;
pub const WMIQ_ASSOCQ_REFERENCES = WMIQ_ASSOCQ_FLAGS.REFERENCES;
pub const WMIQ_ASSOCQ_RESULTCLASS = WMIQ_ASSOCQ_FLAGS.RESULTCLASS;
pub const WMIQ_ASSOCQ_ASSOCCLASS = WMIQ_ASSOCQ_FLAGS.ASSOCCLASS;
pub const WMIQ_ASSOCQ_ROLE = WMIQ_ASSOCQ_FLAGS.ROLE;
pub const WMIQ_ASSOCQ_RESULTROLE = WMIQ_ASSOCQ_FLAGS.RESULTROLE;
pub const WMIQ_ASSOCQ_REQUIREDQUALIFIER = WMIQ_ASSOCQ_FLAGS.REQUIREDQUALIFIER;
pub const WMIQ_ASSOCQ_REQUIREDASSOCQUALIFIER = WMIQ_ASSOCQ_FLAGS.REQUIREDASSOCQUALIFIER;
pub const WMIQ_ASSOCQ_CLASSDEFSONLY = WMIQ_ASSOCQ_FLAGS.CLASSDEFSONLY;
pub const WMIQ_ASSOCQ_KEYSONLY = WMIQ_ASSOCQ_FLAGS.KEYSONLY;
pub const WMIQ_ASSOCQ_SCHEMAONLY = WMIQ_ASSOCQ_FLAGS.SCHEMAONLY;
pub const WMIQ_ASSOCQ_CLASSREFSONLY = WMIQ_ASSOCQ_FLAGS.CLASSREFSONLY;

pub const SWbemQueryQualifiedName = extern struct {
    m_uVersion: u32,
    m_uTokenType: u32,
    m_uNameListSize: u32,
    m_ppszNameList: ?*?PWSTR,
    m_bArraysUsed: BOOL,
    m_pbArrayElUsed: ?*BOOL,
    m_puArrayIndex: ?*u32,
};

pub const SWbemRpnConst = extern union {
    m_pszStrVal: ?[*:0]const u16,
    m_bBoolVal: BOOL,
    m_lLongVal: i32,
    m_uLongVal: u32,
    m_dblVal: f64,
    m_lVal64: i64,
    m_uVal64: i64,
};

pub const SWbemRpnQueryToken = extern struct {
    m_uVersion: u32,
    m_uTokenType: u32,
    m_uSubexpressionShape: u32,
    m_uOperator: u32,
    m_pRightIdent: ?*SWbemQueryQualifiedName,
    m_pLeftIdent: ?*SWbemQueryQualifiedName,
    m_uConstApparentType: u32,
    m_Const: SWbemRpnConst,
    m_uConst2ApparentType: u32,
    m_Const2: SWbemRpnConst,
    m_pszRightFunc: ?[*:0]const u16,
    m_pszLeftFunc: ?[*:0]const u16,
};

pub const SWbemRpnTokenList = extern struct {
    m_uVersion: u32,
    m_uTokenType: u32,
    m_uNumTokens: u32,
};

pub const WMIQ_LANGUAGE_FEATURES = enum(i32) {
    @"1_BASIC_SELECT" = 1,
    @"2_CLASS_NAME_IN_QUERY" = 2,
    @"3_STRING_CASE_FUNCTIONS" = 3,
    @"4_PROP_TO_PROP_TESTS" = 4,
    @"5_COUNT_STAR" = 5,
    @"6_ORDER_BY" = 6,
    @"7_DISTINCT" = 7,
    @"8_ISA" = 8,
    @"9_THIS" = 9,
    @"10_COMPEX_SUBEXPRESSIONS" = 10,
    @"11_ALIASING" = 11,
    @"12_GROUP_BY_HAVING" = 12,
    @"13_WMI_WITHIN" = 13,
    @"14_SQL_WRITE_OPERATIONS" = 14,
    @"15_GO" = 15,
    @"16_SINGLE_LEVEL_TRANSACTIONS" = 16,
    @"17_QUALIFIED_NAMES" = 17,
    @"18_ASSOCIATONS" = 18,
    @"19_SYSTEM_PROPERTIES" = 19,
    @"20_EXTENDED_SYSTEM_PROPERTIES" = 20,
    @"21_SQL89_JOINS" = 21,
    @"22_SQL92_JOINS" = 22,
    @"23_SUBSELECTS" = 23,
    @"24_UMI_EXTENSIONS" = 24,
    @"25_DATEPART" = 25,
    @"26_LIKE" = 26,
    @"27_CIM_TEMPORAL_CONSTRUCTS" = 27,
    @"28_STANDARD_AGGREGATES" = 28,
    @"29_MULTI_LEVEL_ORDER_BY" = 29,
    @"30_WMI_PRAGMAS" = 30,
    @"31_QUALIFIER_TESTS" = 31,
    @"32_SP_EXECUTE" = 32,
    @"33_ARRAY_ACCESS" = 33,
    @"34_UNION" = 34,
    @"35_COMPLEX_SELECT_TARGET" = 35,
    @"36_REFERENCE_TESTS" = 36,
    @"37_SELECT_INTO" = 37,
    @"38_BASIC_DATETIME_TESTS" = 38,
    @"39_COUNT_COLUMN" = 39,
    @"40_BETWEEN" = 40,
    // _LAST = 40, this enum value conflicts with @"40_BETWEEN"
};
pub const WMIQ_LF1_BASIC_SELECT = WMIQ_LANGUAGE_FEATURES.@"1_BASIC_SELECT";
pub const WMIQ_LF2_CLASS_NAME_IN_QUERY = WMIQ_LANGUAGE_FEATURES.@"2_CLASS_NAME_IN_QUERY";
pub const WMIQ_LF3_STRING_CASE_FUNCTIONS = WMIQ_LANGUAGE_FEATURES.@"3_STRING_CASE_FUNCTIONS";
pub const WMIQ_LF4_PROP_TO_PROP_TESTS = WMIQ_LANGUAGE_FEATURES.@"4_PROP_TO_PROP_TESTS";
pub const WMIQ_LF5_COUNT_STAR = WMIQ_LANGUAGE_FEATURES.@"5_COUNT_STAR";
pub const WMIQ_LF6_ORDER_BY = WMIQ_LANGUAGE_FEATURES.@"6_ORDER_BY";
pub const WMIQ_LF7_DISTINCT = WMIQ_LANGUAGE_FEATURES.@"7_DISTINCT";
pub const WMIQ_LF8_ISA = WMIQ_LANGUAGE_FEATURES.@"8_ISA";
pub const WMIQ_LF9_THIS = WMIQ_LANGUAGE_FEATURES.@"9_THIS";
pub const WMIQ_LF10_COMPEX_SUBEXPRESSIONS = WMIQ_LANGUAGE_FEATURES.@"10_COMPEX_SUBEXPRESSIONS";
pub const WMIQ_LF11_ALIASING = WMIQ_LANGUAGE_FEATURES.@"11_ALIASING";
pub const WMIQ_LF12_GROUP_BY_HAVING = WMIQ_LANGUAGE_FEATURES.@"12_GROUP_BY_HAVING";
pub const WMIQ_LF13_WMI_WITHIN = WMIQ_LANGUAGE_FEATURES.@"13_WMI_WITHIN";
pub const WMIQ_LF14_SQL_WRITE_OPERATIONS = WMIQ_LANGUAGE_FEATURES.@"14_SQL_WRITE_OPERATIONS";
pub const WMIQ_LF15_GO = WMIQ_LANGUAGE_FEATURES.@"15_GO";
pub const WMIQ_LF16_SINGLE_LEVEL_TRANSACTIONS = WMIQ_LANGUAGE_FEATURES.@"16_SINGLE_LEVEL_TRANSACTIONS";
pub const WMIQ_LF17_QUALIFIED_NAMES = WMIQ_LANGUAGE_FEATURES.@"17_QUALIFIED_NAMES";
pub const WMIQ_LF18_ASSOCIATONS = WMIQ_LANGUAGE_FEATURES.@"18_ASSOCIATONS";
pub const WMIQ_LF19_SYSTEM_PROPERTIES = WMIQ_LANGUAGE_FEATURES.@"19_SYSTEM_PROPERTIES";
pub const WMIQ_LF20_EXTENDED_SYSTEM_PROPERTIES = WMIQ_LANGUAGE_FEATURES.@"20_EXTENDED_SYSTEM_PROPERTIES";
pub const WMIQ_LF21_SQL89_JOINS = WMIQ_LANGUAGE_FEATURES.@"21_SQL89_JOINS";
pub const WMIQ_LF22_SQL92_JOINS = WMIQ_LANGUAGE_FEATURES.@"22_SQL92_JOINS";
pub const WMIQ_LF23_SUBSELECTS = WMIQ_LANGUAGE_FEATURES.@"23_SUBSELECTS";
pub const WMIQ_LF24_UMI_EXTENSIONS = WMIQ_LANGUAGE_FEATURES.@"24_UMI_EXTENSIONS";
pub const WMIQ_LF25_DATEPART = WMIQ_LANGUAGE_FEATURES.@"25_DATEPART";
pub const WMIQ_LF26_LIKE = WMIQ_LANGUAGE_FEATURES.@"26_LIKE";
pub const WMIQ_LF27_CIM_TEMPORAL_CONSTRUCTS = WMIQ_LANGUAGE_FEATURES.@"27_CIM_TEMPORAL_CONSTRUCTS";
pub const WMIQ_LF28_STANDARD_AGGREGATES = WMIQ_LANGUAGE_FEATURES.@"28_STANDARD_AGGREGATES";
pub const WMIQ_LF29_MULTI_LEVEL_ORDER_BY = WMIQ_LANGUAGE_FEATURES.@"29_MULTI_LEVEL_ORDER_BY";
pub const WMIQ_LF30_WMI_PRAGMAS = WMIQ_LANGUAGE_FEATURES.@"30_WMI_PRAGMAS";
pub const WMIQ_LF31_QUALIFIER_TESTS = WMIQ_LANGUAGE_FEATURES.@"31_QUALIFIER_TESTS";
pub const WMIQ_LF32_SP_EXECUTE = WMIQ_LANGUAGE_FEATURES.@"32_SP_EXECUTE";
pub const WMIQ_LF33_ARRAY_ACCESS = WMIQ_LANGUAGE_FEATURES.@"33_ARRAY_ACCESS";
pub const WMIQ_LF34_UNION = WMIQ_LANGUAGE_FEATURES.@"34_UNION";
pub const WMIQ_LF35_COMPLEX_SELECT_TARGET = WMIQ_LANGUAGE_FEATURES.@"35_COMPLEX_SELECT_TARGET";
pub const WMIQ_LF36_REFERENCE_TESTS = WMIQ_LANGUAGE_FEATURES.@"36_REFERENCE_TESTS";
pub const WMIQ_LF37_SELECT_INTO = WMIQ_LANGUAGE_FEATURES.@"37_SELECT_INTO";
pub const WMIQ_LF38_BASIC_DATETIME_TESTS = WMIQ_LANGUAGE_FEATURES.@"38_BASIC_DATETIME_TESTS";
pub const WMIQ_LF39_COUNT_COLUMN = WMIQ_LANGUAGE_FEATURES.@"39_COUNT_COLUMN";
pub const WMIQ_LF40_BETWEEN = WMIQ_LANGUAGE_FEATURES.@"40_BETWEEN";
pub const WMIQ_LF_LAST = WMIQ_LANGUAGE_FEATURES.@"40_BETWEEN";

pub const WMIQ_RPNQ_FEATURE = enum(i32) {
    WHERE_CLAUSE_PRESENT = 1,
    QUERY_IS_CONJUNCTIVE = 2,
    QUERY_IS_DISJUNCTIVE = 4,
    PROJECTION = 8,
    FEATURE_SELECT_STAR = 16,
    EQUALITY_TESTS_ONLY = 32,
    COUNT_STAR = 64,
    QUALIFIED_NAMES_USED = 128,
    SYSPROP_CLASS_USED = 256,
    PROP_TO_PROP_TESTS = 512,
    ORDER_BY = 1024,
    ISA_USED = 2048,
    GROUP_BY_HAVING = 4096,
    ARRAY_ACCESS_USED = 8192,
};
pub const WMIQ_RPNF_WHERE_CLAUSE_PRESENT = WMIQ_RPNQ_FEATURE.WHERE_CLAUSE_PRESENT;
pub const WMIQ_RPNF_QUERY_IS_CONJUNCTIVE = WMIQ_RPNQ_FEATURE.QUERY_IS_CONJUNCTIVE;
pub const WMIQ_RPNF_QUERY_IS_DISJUNCTIVE = WMIQ_RPNQ_FEATURE.QUERY_IS_DISJUNCTIVE;
pub const WMIQ_RPNF_PROJECTION = WMIQ_RPNQ_FEATURE.PROJECTION;
pub const WMIQ_RPNF_FEATURE_SELECT_STAR = WMIQ_RPNQ_FEATURE.FEATURE_SELECT_STAR;
pub const WMIQ_RPNF_EQUALITY_TESTS_ONLY = WMIQ_RPNQ_FEATURE.EQUALITY_TESTS_ONLY;
pub const WMIQ_RPNF_COUNT_STAR = WMIQ_RPNQ_FEATURE.COUNT_STAR;
pub const WMIQ_RPNF_QUALIFIED_NAMES_USED = WMIQ_RPNQ_FEATURE.QUALIFIED_NAMES_USED;
pub const WMIQ_RPNF_SYSPROP_CLASS_USED = WMIQ_RPNQ_FEATURE.SYSPROP_CLASS_USED;
pub const WMIQ_RPNF_PROP_TO_PROP_TESTS = WMIQ_RPNQ_FEATURE.PROP_TO_PROP_TESTS;
pub const WMIQ_RPNF_ORDER_BY = WMIQ_RPNQ_FEATURE.ORDER_BY;
pub const WMIQ_RPNF_ISA_USED = WMIQ_RPNQ_FEATURE.ISA_USED;
pub const WMIQ_RPNF_GROUP_BY_HAVING = WMIQ_RPNQ_FEATURE.GROUP_BY_HAVING;
pub const WMIQ_RPNF_ARRAY_ACCESS_USED = WMIQ_RPNQ_FEATURE.ARRAY_ACCESS_USED;

pub const SWbemRpnEncodedQuery = extern struct {
    m_uVersion: u32,
    m_uTokenType: u32,
    m_uParsedFeatureMask: u64,
    m_uDetectedArraySize: u32,
    m_puDetectedFeatures: ?*u32,
    m_uSelectListSize: u32,
    m_ppSelectList: ?*?*SWbemQueryQualifiedName,
    m_uFromTargetType: u32,
    m_pszOptionalFromPath: ?[*:0]const u16,
    m_uFromListSize: u32,
    m_ppszFromList: ?*?PWSTR,
    m_uWhereClauseSize: u32,
    m_ppRpnWhereClause: ?*?*SWbemRpnQueryToken,
    m_dblWithinPolling: f64,
    m_dblWithinWindow: f64,
    m_uOrderByListSize: u32,
    m_ppszOrderByList: ?*?PWSTR,
    m_uOrderDirectionEl: ?*u32,
};

pub const SWbemAnalysisMatrix = extern struct {
    m_uVersion: u32,
    m_uMatrixType: u32,
    m_pszProperty: ?[*:0]const u16,
    m_uPropertyType: u32,
    m_uEntries: u32,
    m_pValues: ?*?*anyopaque,
    m_pbTruthTable: ?*BOOL,
};

pub const SWbemAnalysisMatrixList = extern struct {
    m_uVersion: u32,
    m_uMatrixType: u32,
    m_uNumMatrices: u32,
    m_pMatrices: ?*SWbemAnalysisMatrix,
};

pub const SWbemAssocQueryInf = extern struct {
    m_uVersion: u32,
    m_uAnalysisType: u32,
    m_uFeatureMask: u32,
    m_pPath: ?*IWbemPath,
    m_pszPath: ?PWSTR,
    m_pszQueryText: ?PWSTR,
    m_pszResultClass: ?PWSTR,
    m_pszAssocClass: ?PWSTR,
    m_pszRole: ?PWSTR,
    m_pszResultRole: ?PWSTR,
    m_pszRequiredQualifier: ?PWSTR,
    m_pszRequiredAssocQualifier: ?PWSTR,
};

const CLSID_WbemLocator_Value = Guid.initString("4590f811-1d3a-11d0-891f-00aa004b2e24");
pub const CLSID_WbemLocator = &CLSID_WbemLocator_Value;

const CLSID_WbemContext_Value = Guid.initString("674b6698-ee92-11d0-ad71-00c04fd8fdff");
pub const CLSID_WbemContext = &CLSID_WbemContext_Value;

const CLSID_UnsecuredApartment_Value = Guid.initString("49bd2028-1523-11d1-ad79-00c04fd8fdff");
pub const CLSID_UnsecuredApartment = &CLSID_UnsecuredApartment_Value;

const CLSID_WbemClassObject_Value = Guid.initString("9a653086-174f-11d2-b5f9-00104b703efd");
pub const CLSID_WbemClassObject = &CLSID_WbemClassObject_Value;

const CLSID_MofCompiler_Value = Guid.initString("6daf9757-2e37-11d2-aec9-00c04fb68820");
pub const CLSID_MofCompiler = &CLSID_MofCompiler_Value;

const CLSID_WbemStatusCodeText_Value = Guid.initString("eb87e1bd-3233-11d2-aec9-00c04fb68820");
pub const CLSID_WbemStatusCodeText = &CLSID_WbemStatusCodeText_Value;

const CLSID_WbemBackupRestore_Value = Guid.initString("c49e32c6-bc8b-11d2-85d4-00105a1f8304");
pub const CLSID_WbemBackupRestore = &CLSID_WbemBackupRestore_Value;

const CLSID_WbemRefresher_Value = Guid.initString("c71566f2-561e-11d1-ad87-00c04fd8fdff");
pub const CLSID_WbemRefresher = &CLSID_WbemRefresher_Value;

const CLSID_WbemObjectTextSrc_Value = Guid.initString("8d1c559d-84f0-4bb3-a7d5-56a7435a9ba6");
pub const CLSID_WbemObjectTextSrc = &CLSID_WbemObjectTextSrc_Value;

pub const WBEM_GENUS_TYPE = enum(i32) {
    CLASS = 1,
    INSTANCE = 2,
};
pub const WBEM_GENUS_CLASS = WBEM_GENUS_TYPE.CLASS;
pub const WBEM_GENUS_INSTANCE = WBEM_GENUS_TYPE.INSTANCE;

pub const WBEM_CHANGE_FLAG_TYPE = enum(i32) {
    FLAG_CREATE_OR_UPDATE = 0,
    FLAG_UPDATE_ONLY = 1,
    FLAG_CREATE_ONLY = 2,
    // FLAG_UPDATE_COMPATIBLE = 0, this enum value conflicts with FLAG_CREATE_OR_UPDATE
    FLAG_UPDATE_SAFE_MODE = 32,
    FLAG_UPDATE_FORCE_MODE = 64,
    MASK_UPDATE_MODE = 96,
    FLAG_ADVISORY = 65536,
};
pub const WBEM_FLAG_CREATE_OR_UPDATE = WBEM_CHANGE_FLAG_TYPE.FLAG_CREATE_OR_UPDATE;
pub const WBEM_FLAG_UPDATE_ONLY = WBEM_CHANGE_FLAG_TYPE.FLAG_UPDATE_ONLY;
pub const WBEM_FLAG_CREATE_ONLY = WBEM_CHANGE_FLAG_TYPE.FLAG_CREATE_ONLY;
pub const WBEM_FLAG_UPDATE_COMPATIBLE = WBEM_CHANGE_FLAG_TYPE.FLAG_CREATE_OR_UPDATE;
pub const WBEM_FLAG_UPDATE_SAFE_MODE = WBEM_CHANGE_FLAG_TYPE.FLAG_UPDATE_SAFE_MODE;
pub const WBEM_FLAG_UPDATE_FORCE_MODE = WBEM_CHANGE_FLAG_TYPE.FLAG_UPDATE_FORCE_MODE;
pub const WBEM_MASK_UPDATE_MODE = WBEM_CHANGE_FLAG_TYPE.MASK_UPDATE_MODE;
pub const WBEM_FLAG_ADVISORY = WBEM_CHANGE_FLAG_TYPE.FLAG_ADVISORY;

pub const WBEM_GENERIC_FLAG_TYPE = enum(i32) {
    FLAG_RETURN_IMMEDIATELY = 16,
    FLAG_RETURN_WBEM_COMPLETE = 0,
    // FLAG_BIDIRECTIONAL = 0, this enum value conflicts with FLAG_RETURN_WBEM_COMPLETE
    FLAG_FORWARD_ONLY = 32,
    FLAG_NO_ERROR_OBJECT = 64,
    // FLAG_RETURN_ERROR_OBJECT = 0, this enum value conflicts with FLAG_RETURN_WBEM_COMPLETE
    FLAG_SEND_STATUS = 128,
    // FLAG_DONT_SEND_STATUS = 0, this enum value conflicts with FLAG_RETURN_WBEM_COMPLETE
    FLAG_ENSURE_LOCATABLE = 256,
    FLAG_DIRECT_READ = 512,
    // FLAG_SEND_ONLY_SELECTED = 0, this enum value conflicts with FLAG_RETURN_WBEM_COMPLETE
    // RETURN_WHEN_COMPLETE = 0, this enum value conflicts with FLAG_RETURN_WBEM_COMPLETE
    // RETURN_IMMEDIATELY = 16, this enum value conflicts with FLAG_RETURN_IMMEDIATELY
    MASK_RESERVED_FLAGS = 126976,
    FLAG_USE_AMENDED_QUALIFIERS = 131072,
    FLAG_STRONG_VALIDATION = 1048576,
};
pub const WBEM_FLAG_RETURN_IMMEDIATELY = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_IMMEDIATELY;
pub const WBEM_FLAG_RETURN_WBEM_COMPLETE = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_WBEM_COMPLETE;
pub const WBEM_FLAG_BIDIRECTIONAL = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_WBEM_COMPLETE;
pub const WBEM_FLAG_FORWARD_ONLY = WBEM_GENERIC_FLAG_TYPE.FLAG_FORWARD_ONLY;
pub const WBEM_FLAG_NO_ERROR_OBJECT = WBEM_GENERIC_FLAG_TYPE.FLAG_NO_ERROR_OBJECT;
pub const WBEM_FLAG_RETURN_ERROR_OBJECT = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_WBEM_COMPLETE;
pub const WBEM_FLAG_SEND_STATUS = WBEM_GENERIC_FLAG_TYPE.FLAG_SEND_STATUS;
pub const WBEM_FLAG_DONT_SEND_STATUS = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_WBEM_COMPLETE;
pub const WBEM_FLAG_ENSURE_LOCATABLE = WBEM_GENERIC_FLAG_TYPE.FLAG_ENSURE_LOCATABLE;
pub const WBEM_FLAG_DIRECT_READ = WBEM_GENERIC_FLAG_TYPE.FLAG_DIRECT_READ;
pub const WBEM_FLAG_SEND_ONLY_SELECTED = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_WBEM_COMPLETE;
pub const WBEM_RETURN_WHEN_COMPLETE = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_WBEM_COMPLETE;
pub const WBEM_RETURN_IMMEDIATELY = WBEM_GENERIC_FLAG_TYPE.FLAG_RETURN_IMMEDIATELY;
pub const WBEM_MASK_RESERVED_FLAGS = WBEM_GENERIC_FLAG_TYPE.MASK_RESERVED_FLAGS;
pub const WBEM_FLAG_USE_AMENDED_QUALIFIERS = WBEM_GENERIC_FLAG_TYPE.FLAG_USE_AMENDED_QUALIFIERS;
pub const WBEM_FLAG_STRONG_VALIDATION = WBEM_GENERIC_FLAG_TYPE.FLAG_STRONG_VALIDATION;

pub const WBEM_STATUS_TYPE = enum(i32) {
    COMPLETE = 0,
    REQUIREMENTS = 1,
    PROGRESS = 2,
    LOGGING_INFORMATION = 256,
    LOGGING_INFORMATION_PROVIDER = 512,
    LOGGING_INFORMATION_HOST = 1024,
    LOGGING_INFORMATION_REPOSITORY = 2048,
    LOGGING_INFORMATION_ESS = 4096,
};
pub const WBEM_STATUS_COMPLETE = WBEM_STATUS_TYPE.COMPLETE;
pub const WBEM_STATUS_REQUIREMENTS = WBEM_STATUS_TYPE.REQUIREMENTS;
pub const WBEM_STATUS_PROGRESS = WBEM_STATUS_TYPE.PROGRESS;
pub const WBEM_STATUS_LOGGING_INFORMATION = WBEM_STATUS_TYPE.LOGGING_INFORMATION;
pub const WBEM_STATUS_LOGGING_INFORMATION_PROVIDER = WBEM_STATUS_TYPE.LOGGING_INFORMATION_PROVIDER;
pub const WBEM_STATUS_LOGGING_INFORMATION_HOST = WBEM_STATUS_TYPE.LOGGING_INFORMATION_HOST;
pub const WBEM_STATUS_LOGGING_INFORMATION_REPOSITORY = WBEM_STATUS_TYPE.LOGGING_INFORMATION_REPOSITORY;
pub const WBEM_STATUS_LOGGING_INFORMATION_ESS = WBEM_STATUS_TYPE.LOGGING_INFORMATION_ESS;

pub const WBEM_TIMEOUT_TYPE = enum(i32) {
    NO_WAIT = 0,
    INFINITE = -1,
};
pub const WBEM_NO_WAIT = WBEM_TIMEOUT_TYPE.NO_WAIT;
pub const WBEM_INFINITE = WBEM_TIMEOUT_TYPE.INFINITE;

pub const WBEM_CONDITION_FLAG_TYPE = enum(i32) {
    FLAG_ALWAYS = 0,
    FLAG_ONLY_IF_TRUE = 1,
    FLAG_ONLY_IF_FALSE = 2,
    FLAG_ONLY_IF_IDENTICAL = 3,
    // MASK_PRIMARY_CONDITION = 3, this enum value conflicts with FLAG_ONLY_IF_IDENTICAL
    FLAG_KEYS_ONLY = 4,
    FLAG_REFS_ONLY = 8,
    FLAG_LOCAL_ONLY = 16,
    FLAG_PROPAGATED_ONLY = 32,
    FLAG_SYSTEM_ONLY = 48,
    FLAG_NONSYSTEM_ONLY = 64,
    MASK_CONDITION_ORIGIN = 112,
    FLAG_CLASS_OVERRIDES_ONLY = 256,
    FLAG_CLASS_LOCAL_AND_OVERRIDES = 512,
    MASK_CLASS_CONDITION = 768,
};
pub const WBEM_FLAG_ALWAYS = WBEM_CONDITION_FLAG_TYPE.FLAG_ALWAYS;
pub const WBEM_FLAG_ONLY_IF_TRUE = WBEM_CONDITION_FLAG_TYPE.FLAG_ONLY_IF_TRUE;
pub const WBEM_FLAG_ONLY_IF_FALSE = WBEM_CONDITION_FLAG_TYPE.FLAG_ONLY_IF_FALSE;
pub const WBEM_FLAG_ONLY_IF_IDENTICAL = WBEM_CONDITION_FLAG_TYPE.FLAG_ONLY_IF_IDENTICAL;
pub const WBEM_MASK_PRIMARY_CONDITION = WBEM_CONDITION_FLAG_TYPE.FLAG_ONLY_IF_IDENTICAL;
pub const WBEM_FLAG_KEYS_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_KEYS_ONLY;
pub const WBEM_FLAG_REFS_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_REFS_ONLY;
pub const WBEM_FLAG_LOCAL_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_LOCAL_ONLY;
pub const WBEM_FLAG_PROPAGATED_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_PROPAGATED_ONLY;
pub const WBEM_FLAG_SYSTEM_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_SYSTEM_ONLY;
pub const WBEM_FLAG_NONSYSTEM_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_NONSYSTEM_ONLY;
pub const WBEM_MASK_CONDITION_ORIGIN = WBEM_CONDITION_FLAG_TYPE.MASK_CONDITION_ORIGIN;
pub const WBEM_FLAG_CLASS_OVERRIDES_ONLY = WBEM_CONDITION_FLAG_TYPE.FLAG_CLASS_OVERRIDES_ONLY;
pub const WBEM_FLAG_CLASS_LOCAL_AND_OVERRIDES = WBEM_CONDITION_FLAG_TYPE.FLAG_CLASS_LOCAL_AND_OVERRIDES;
pub const WBEM_MASK_CLASS_CONDITION = WBEM_CONDITION_FLAG_TYPE.MASK_CLASS_CONDITION;

pub const WBEM_FLAVOR_TYPE = enum(i32) {
    DONT_PROPAGATE = 0,
    FLAG_PROPAGATE_TO_INSTANCE = 1,
    FLAG_PROPAGATE_TO_DERIVED_CLASS = 2,
    MASK_PROPAGATION = 15,
    // OVERRIDABLE = 0, this enum value conflicts with DONT_PROPAGATE
    NOT_OVERRIDABLE = 16,
    // MASK_PERMISSIONS = 16, this enum value conflicts with NOT_OVERRIDABLE
    // ORIGIN_LOCAL = 0, this enum value conflicts with DONT_PROPAGATE
    ORIGIN_PROPAGATED = 32,
    ORIGIN_SYSTEM = 64,
    MASK_ORIGIN = 96,
    // NOT_AMENDED = 0, this enum value conflicts with DONT_PROPAGATE
    AMENDED = 128,
    // MASK_AMENDED = 128, this enum value conflicts with AMENDED
};
pub const WBEM_FLAVOR_DONT_PROPAGATE = WBEM_FLAVOR_TYPE.DONT_PROPAGATE;
pub const WBEM_FLAVOR_FLAG_PROPAGATE_TO_INSTANCE = WBEM_FLAVOR_TYPE.FLAG_PROPAGATE_TO_INSTANCE;
pub const WBEM_FLAVOR_FLAG_PROPAGATE_TO_DERIVED_CLASS = WBEM_FLAVOR_TYPE.FLAG_PROPAGATE_TO_DERIVED_CLASS;
pub const WBEM_FLAVOR_MASK_PROPAGATION = WBEM_FLAVOR_TYPE.MASK_PROPAGATION;
pub const WBEM_FLAVOR_OVERRIDABLE = WBEM_FLAVOR_TYPE.DONT_PROPAGATE;
pub const WBEM_FLAVOR_NOT_OVERRIDABLE = WBEM_FLAVOR_TYPE.NOT_OVERRIDABLE;
pub const WBEM_FLAVOR_MASK_PERMISSIONS = WBEM_FLAVOR_TYPE.NOT_OVERRIDABLE;
pub const WBEM_FLAVOR_ORIGIN_LOCAL = WBEM_FLAVOR_TYPE.DONT_PROPAGATE;
pub const WBEM_FLAVOR_ORIGIN_PROPAGATED = WBEM_FLAVOR_TYPE.ORIGIN_PROPAGATED;
pub const WBEM_FLAVOR_ORIGIN_SYSTEM = WBEM_FLAVOR_TYPE.ORIGIN_SYSTEM;
pub const WBEM_FLAVOR_MASK_ORIGIN = WBEM_FLAVOR_TYPE.MASK_ORIGIN;
pub const WBEM_FLAVOR_NOT_AMENDED = WBEM_FLAVOR_TYPE.DONT_PROPAGATE;
pub const WBEM_FLAVOR_AMENDED = WBEM_FLAVOR_TYPE.AMENDED;
pub const WBEM_FLAVOR_MASK_AMENDED = WBEM_FLAVOR_TYPE.AMENDED;

pub const WBEM_QUERY_FLAG_TYPE = enum(i32) {
    DEEP = 0,
    SHALLOW = 1,
    PROTOTYPE = 2,
};
pub const WBEM_FLAG_DEEP = WBEM_QUERY_FLAG_TYPE.DEEP;
pub const WBEM_FLAG_SHALLOW = WBEM_QUERY_FLAG_TYPE.SHALLOW;
pub const WBEM_FLAG_PROTOTYPE = WBEM_QUERY_FLAG_TYPE.PROTOTYPE;

pub const WBEM_SECURITY_FLAGS = enum(i32) {
    ENABLE = 1,
    METHOD_EXECUTE = 2,
    FULL_WRITE_REP = 4,
    PARTIAL_WRITE_REP = 8,
    WRITE_PROVIDER = 16,
    REMOTE_ACCESS = 32,
    RIGHT_SUBSCRIBE = 64,
    RIGHT_PUBLISH = 128,
};
pub const WBEM_ENABLE = WBEM_SECURITY_FLAGS.ENABLE;
pub const WBEM_METHOD_EXECUTE = WBEM_SECURITY_FLAGS.METHOD_EXECUTE;
pub const WBEM_FULL_WRITE_REP = WBEM_SECURITY_FLAGS.FULL_WRITE_REP;
pub const WBEM_PARTIAL_WRITE_REP = WBEM_SECURITY_FLAGS.PARTIAL_WRITE_REP;
pub const WBEM_WRITE_PROVIDER = WBEM_SECURITY_FLAGS.WRITE_PROVIDER;
pub const WBEM_REMOTE_ACCESS = WBEM_SECURITY_FLAGS.REMOTE_ACCESS;
pub const WBEM_RIGHT_SUBSCRIBE = WBEM_SECURITY_FLAGS.RIGHT_SUBSCRIBE;
pub const WBEM_RIGHT_PUBLISH = WBEM_SECURITY_FLAGS.RIGHT_PUBLISH;

pub const WBEM_LIMITATION_FLAG_TYPE = enum(i32) {
    OBJECT_QUALIFIERS = 16,
    PROPERTY_QUALIFIERS = 32,
};
pub const WBEM_FLAG_EXCLUDE_OBJECT_QUALIFIERS = WBEM_LIMITATION_FLAG_TYPE.OBJECT_QUALIFIERS;
pub const WBEM_FLAG_EXCLUDE_PROPERTY_QUALIFIERS = WBEM_LIMITATION_FLAG_TYPE.PROPERTY_QUALIFIERS;

pub const WBEM_TEXT_FLAG_TYPE = enum(i32) {
    S = 1,
};
pub const WBEM_FLAG_NO_FLAVORS = WBEM_TEXT_FLAG_TYPE.S;

pub const WBEM_COMPARISON_FLAG = enum(i32) {
    COMPARISON_INCLUDE_ALL = 0,
    FLAG_IGNORE_QUALIFIERS = 1,
    FLAG_IGNORE_OBJECT_SOURCE = 2,
    FLAG_IGNORE_DEFAULT_VALUES = 4,
    FLAG_IGNORE_CLASS = 8,
    FLAG_IGNORE_CASE = 16,
    FLAG_IGNORE_FLAVOR = 32,
};
pub const WBEM_COMPARISON_INCLUDE_ALL = WBEM_COMPARISON_FLAG.COMPARISON_INCLUDE_ALL;
pub const WBEM_FLAG_IGNORE_QUALIFIERS = WBEM_COMPARISON_FLAG.FLAG_IGNORE_QUALIFIERS;
pub const WBEM_FLAG_IGNORE_OBJECT_SOURCE = WBEM_COMPARISON_FLAG.FLAG_IGNORE_OBJECT_SOURCE;
pub const WBEM_FLAG_IGNORE_DEFAULT_VALUES = WBEM_COMPARISON_FLAG.FLAG_IGNORE_DEFAULT_VALUES;
pub const WBEM_FLAG_IGNORE_CLASS = WBEM_COMPARISON_FLAG.FLAG_IGNORE_CLASS;
pub const WBEM_FLAG_IGNORE_CASE = WBEM_COMPARISON_FLAG.FLAG_IGNORE_CASE;
pub const WBEM_FLAG_IGNORE_FLAVOR = WBEM_COMPARISON_FLAG.FLAG_IGNORE_FLAVOR;

pub const WBEM_LOCKING = enum(i32) {
    D = 1,
};
pub const WBEM_FLAG_ALLOW_READ = WBEM_LOCKING.D;

pub const CIMTYPE_ENUMERATION = enum(i32) {
    ILLEGAL = 4095,
    EMPTY = 0,
    SINT8 = 16,
    UINT8 = 17,
    SINT16 = 2,
    UINT16 = 18,
    SINT32 = 3,
    UINT32 = 19,
    SINT64 = 20,
    UINT64 = 21,
    REAL32 = 4,
    REAL64 = 5,
    BOOLEAN = 11,
    STRING = 8,
    DATETIME = 101,
    REFERENCE = 102,
    CHAR16 = 103,
    OBJECT = 13,
    FLAG_ARRAY = 8192,
};
pub const CIM_ILLEGAL = CIMTYPE_ENUMERATION.ILLEGAL;
pub const CIM_EMPTY = CIMTYPE_ENUMERATION.EMPTY;
pub const CIM_SINT8 = CIMTYPE_ENUMERATION.SINT8;
pub const CIM_UINT8 = CIMTYPE_ENUMERATION.UINT8;
pub const CIM_SINT16 = CIMTYPE_ENUMERATION.SINT16;
pub const CIM_UINT16 = CIMTYPE_ENUMERATION.UINT16;
pub const CIM_SINT32 = CIMTYPE_ENUMERATION.SINT32;
pub const CIM_UINT32 = CIMTYPE_ENUMERATION.UINT32;
pub const CIM_SINT64 = CIMTYPE_ENUMERATION.SINT64;
pub const CIM_UINT64 = CIMTYPE_ENUMERATION.UINT64;
pub const CIM_REAL32 = CIMTYPE_ENUMERATION.REAL32;
pub const CIM_REAL64 = CIMTYPE_ENUMERATION.REAL64;
pub const CIM_BOOLEAN = CIMTYPE_ENUMERATION.BOOLEAN;
pub const CIM_STRING = CIMTYPE_ENUMERATION.STRING;
pub const CIM_DATETIME = CIMTYPE_ENUMERATION.DATETIME;
pub const CIM_REFERENCE = CIMTYPE_ENUMERATION.REFERENCE;
pub const CIM_CHAR16 = CIMTYPE_ENUMERATION.CHAR16;
pub const CIM_OBJECT = CIMTYPE_ENUMERATION.OBJECT;
pub const CIM_FLAG_ARRAY = CIMTYPE_ENUMERATION.FLAG_ARRAY;

pub const WBEM_BACKUP_RESTORE_FLAGS = enum(i32) {
    DEFAULT = 0,
    FORCE_SHUTDOWN = 1,
};
pub const WBEM_FLAG_BACKUP_RESTORE_DEFAULT = WBEM_BACKUP_RESTORE_FLAGS.DEFAULT;
pub const WBEM_FLAG_BACKUP_RESTORE_FORCE_SHUTDOWN = WBEM_BACKUP_RESTORE_FLAGS.FORCE_SHUTDOWN;

pub const WBEM_REFRESHER_FLAGS = enum(i32) {
    AUTO_RECONNECT = 0,
    NO_AUTO_RECONNECT = 1,
};
pub const WBEM_FLAG_REFRESH_AUTO_RECONNECT = WBEM_REFRESHER_FLAGS.AUTO_RECONNECT;
pub const WBEM_FLAG_REFRESH_NO_AUTO_RECONNECT = WBEM_REFRESHER_FLAGS.NO_AUTO_RECONNECT;

pub const WBEM_SHUTDOWN_FLAGS = enum(i32) {
    UNLOAD_COMPONENT = 1,
    WMI = 2,
    OS = 3,
};
pub const WBEM_SHUTDOWN_UNLOAD_COMPONENT = WBEM_SHUTDOWN_FLAGS.UNLOAD_COMPONENT;
pub const WBEM_SHUTDOWN_WMI = WBEM_SHUTDOWN_FLAGS.WMI;
pub const WBEM_SHUTDOWN_OS = WBEM_SHUTDOWN_FLAGS.OS;

pub const WBEMSTATUS_FORMAT = enum(i32) {
    EWLINE = 0,
    O_NEWLINE = 1,
};
pub const WBEMSTATUS_FORMAT_NEWLINE = WBEMSTATUS_FORMAT.EWLINE;
pub const WBEMSTATUS_FORMAT_NO_NEWLINE = WBEMSTATUS_FORMAT.O_NEWLINE;

pub const WBEM_LIMITS = enum(i32) {
    IDENTIFIER = 4096,
    QUERY = 16384,
    PATH = 8192,
    OBJECT_NESTING = 64,
    USER_PROPERTIES = 1024,
};
pub const WBEM_MAX_IDENTIFIER = WBEM_LIMITS.IDENTIFIER;
pub const WBEM_MAX_QUERY = WBEM_LIMITS.QUERY;
pub const WBEM_MAX_PATH = WBEM_LIMITS.PATH;
pub const WBEM_MAX_OBJECT_NESTING = WBEM_LIMITS.OBJECT_NESTING;
pub const WBEM_MAX_USER_PROPERTIES = WBEM_LIMITS.USER_PROPERTIES;

pub const WBEMSTATUS = enum(i32) {
    _NO_ERROR = 0,
    // _S_NO_ERROR = 0, this enum value conflicts with _NO_ERROR
    // _S_SAME = 0, this enum value conflicts with _NO_ERROR
    _S_FALSE = 1,
    _S_ALREADY_EXISTS = 262145,
    _S_RESET_TO_DEFAULT = 262146,
    _S_DIFFERENT = 262147,
    _S_TIMEDOUT = 262148,
    _S_NO_MORE_DATA = 262149,
    _S_OPERATION_CANCELLED = 262150,
    _S_PENDING = 262151,
    _S_DUPLICATE_OBJECTS = 262152,
    _S_ACCESS_DENIED = 262153,
    _S_PARTIAL_RESULTS = 262160,
    _S_SOURCE_NOT_AVAILABLE = 262167,
    _E_FAILED = -2147217407,
    _E_NOT_FOUND = -2147217406,
    _E_ACCESS_DENIED = -2147217405,
    _E_PROVIDER_FAILURE = -2147217404,
    _E_TYPE_MISMATCH = -2147217403,
    _E_OUT_OF_MEMORY = -2147217402,
    _E_INVALID_CONTEXT = -2147217401,
    _E_INVALID_PARAMETER = -2147217400,
    _E_NOT_AVAILABLE = -2147217399,
    _E_CRITICAL_ERROR = -2147217398,
    _E_INVALID_STREAM = -2147217397,
    _E_NOT_SUPPORTED = -2147217396,
    _E_INVALID_SUPERCLASS = -2147217395,
    _E_INVALID_NAMESPACE = -2147217394,
    _E_INVALID_OBJECT = -2147217393,
    _E_INVALID_CLASS = -2147217392,
    _E_PROVIDER_NOT_FOUND = -2147217391,
    _E_INVALID_PROVIDER_REGISTRATION = -2147217390,
    _E_PROVIDER_LOAD_FAILURE = -2147217389,
    _E_INITIALIZATION_FAILURE = -2147217388,
    _E_TRANSPORT_FAILURE = -2147217387,
    _E_INVALID_OPERATION = -2147217386,
    _E_INVALID_QUERY = -2147217385,
    _E_INVALID_QUERY_TYPE = -2147217384,
    _E_ALREADY_EXISTS = -2147217383,
    _E_OVERRIDE_NOT_ALLOWED = -2147217382,
    _E_PROPAGATED_QUALIFIER = -2147217381,
    _E_PROPAGATED_PROPERTY = -2147217380,
    _E_UNEXPECTED = -2147217379,
    _E_ILLEGAL_OPERATION = -2147217378,
    _E_CANNOT_BE_KEY = -2147217377,
    _E_INCOMPLETE_CLASS = -2147217376,
    _E_INVALID_SYNTAX = -2147217375,
    _E_NONDECORATED_OBJECT = -2147217374,
    _E_READ_ONLY = -2147217373,
    _E_PROVIDER_NOT_CAPABLE = -2147217372,
    _E_CLASS_HAS_CHILDREN = -2147217371,
    _E_CLASS_HAS_INSTANCES = -2147217370,
    _E_QUERY_NOT_IMPLEMENTED = -2147217369,
    _E_ILLEGAL_NULL = -2147217368,
    _E_INVALID_QUALIFIER_TYPE = -2147217367,
    _E_INVALID_PROPERTY_TYPE = -2147217366,
    _E_VALUE_OUT_OF_RANGE = -2147217365,
    _E_CANNOT_BE_SINGLETON = -2147217364,
    _E_INVALID_CIM_TYPE = -2147217363,
    _E_INVALID_METHOD = -2147217362,
    _E_INVALID_METHOD_PARAMETERS = -2147217361,
    _E_SYSTEM_PROPERTY = -2147217360,
    _E_INVALID_PROPERTY = -2147217359,
    _E_CALL_CANCELLED = -2147217358,
    _E_SHUTTING_DOWN = -2147217357,
    _E_PROPAGATED_METHOD = -2147217356,
    _E_UNSUPPORTED_PARAMETER = -2147217355,
    _E_MISSING_PARAMETER_ID = -2147217354,
    _E_INVALID_PARAMETER_ID = -2147217353,
    _E_NONCONSECUTIVE_PARAMETER_IDS = -2147217352,
    _E_PARAMETER_ID_ON_RETVAL = -2147217351,
    _E_INVALID_OBJECT_PATH = -2147217350,
    _E_OUT_OF_DISK_SPACE = -2147217349,
    _E_BUFFER_TOO_SMALL = -2147217348,
    _E_UNSUPPORTED_PUT_EXTENSION = -2147217347,
    _E_UNKNOWN_OBJECT_TYPE = -2147217346,
    _E_UNKNOWN_PACKET_TYPE = -2147217345,
    _E_MARSHAL_VERSION_MISMATCH = -2147217344,
    _E_MARSHAL_INVALID_SIGNATURE = -2147217343,
    _E_INVALID_QUALIFIER = -2147217342,
    _E_INVALID_DUPLICATE_PARAMETER = -2147217341,
    _E_TOO_MUCH_DATA = -2147217340,
    _E_SERVER_TOO_BUSY = -2147217339,
    _E_INVALID_FLAVOR = -2147217338,
    _E_CIRCULAR_REFERENCE = -2147217337,
    _E_UNSUPPORTED_CLASS_UPDATE = -2147217336,
    _E_CANNOT_CHANGE_KEY_INHERITANCE = -2147217335,
    _E_CANNOT_CHANGE_INDEX_INHERITANCE = -2147217328,
    _E_TOO_MANY_PROPERTIES = -2147217327,
    _E_UPDATE_TYPE_MISMATCH = -2147217326,
    _E_UPDATE_OVERRIDE_NOT_ALLOWED = -2147217325,
    _E_UPDATE_PROPAGATED_METHOD = -2147217324,
    _E_METHOD_NOT_IMPLEMENTED = -2147217323,
    _E_METHOD_DISABLED = -2147217322,
    _E_REFRESHER_BUSY = -2147217321,
    _E_UNPARSABLE_QUERY = -2147217320,
    _E_NOT_EVENT_CLASS = -2147217319,
    _E_MISSING_GROUP_WITHIN = -2147217318,
    _E_MISSING_AGGREGATION_LIST = -2147217317,
    _E_PROPERTY_NOT_AN_OBJECT = -2147217316,
    _E_AGGREGATING_BY_OBJECT = -2147217315,
    _E_UNINTERPRETABLE_PROVIDER_QUERY = -2147217313,
    _E_BACKUP_RESTORE_WINMGMT_RUNNING = -2147217312,
    _E_QUEUE_OVERFLOW = -2147217311,
    _E_PRIVILEGE_NOT_HELD = -2147217310,
    _E_INVALID_OPERATOR = -2147217309,
    _E_LOCAL_CREDENTIALS = -2147217308,
    _E_CANNOT_BE_ABSTRACT = -2147217307,
    _E_AMENDED_OBJECT = -2147217306,
    _E_CLIENT_TOO_SLOW = -2147217305,
    _E_NULL_SECURITY_DESCRIPTOR = -2147217304,
    _E_TIMED_OUT = -2147217303,
    _E_INVALID_ASSOCIATION = -2147217302,
    _E_AMBIGUOUS_OPERATION = -2147217301,
    _E_QUOTA_VIOLATION = -2147217300,
    _E_RESERVED_001 = -2147217299,
    _E_RESERVED_002 = -2147217298,
    _E_UNSUPPORTED_LOCALE = -2147217297,
    _E_HANDLE_OUT_OF_DATE = -2147217296,
    _E_CONNECTION_FAILED = -2147217295,
    _E_INVALID_HANDLE_REQUEST = -2147217294,
    _E_PROPERTY_NAME_TOO_WIDE = -2147217293,
    _E_CLASS_NAME_TOO_WIDE = -2147217292,
    _E_METHOD_NAME_TOO_WIDE = -2147217291,
    _E_QUALIFIER_NAME_TOO_WIDE = -2147217290,
    _E_RERUN_COMMAND = -2147217289,
    _E_DATABASE_VER_MISMATCH = -2147217288,
    _E_VETO_DELETE = -2147217287,
    _E_VETO_PUT = -2147217286,
    _E_INVALID_LOCALE = -2147217280,
    _E_PROVIDER_SUSPENDED = -2147217279,
    _E_SYNCHRONIZATION_REQUIRED = -2147217278,
    _E_NO_SCHEMA = -2147217277,
    _E_PROVIDER_ALREADY_REGISTERED = -2147217276,
    _E_PROVIDER_NOT_REGISTERED = -2147217275,
    _E_FATAL_TRANSPORT_ERROR = -2147217274,
    _E_ENCRYPTED_CONNECTION_REQUIRED = -2147217273,
    _E_PROVIDER_TIMED_OUT = -2147217272,
    _E_NO_KEY = -2147217271,
    _E_PROVIDER_DISABLED = -2147217270,
    ESS_E_REGISTRATION_TOO_BROAD = -2147213311,
    ESS_E_REGISTRATION_TOO_PRECISE = -2147213310,
    ESS_E_AUTHZ_NOT_PRIVILEGED = -2147213309,
    MOF_E_EXPECTED_QUALIFIER_NAME = -2147205119,
    MOF_E_EXPECTED_SEMI = -2147205118,
    MOF_E_EXPECTED_OPEN_BRACE = -2147205117,
    MOF_E_EXPECTED_CLOSE_BRACE = -2147205116,
    MOF_E_EXPECTED_CLOSE_BRACKET = -2147205115,
    MOF_E_EXPECTED_CLOSE_PAREN = -2147205114,
    MOF_E_ILLEGAL_CONSTANT_VALUE = -2147205113,
    MOF_E_EXPECTED_TYPE_IDENTIFIER = -2147205112,
    MOF_E_EXPECTED_OPEN_PAREN = -2147205111,
    MOF_E_UNRECOGNIZED_TOKEN = -2147205110,
    MOF_E_UNRECOGNIZED_TYPE = -2147205109,
    MOF_E_EXPECTED_PROPERTY_NAME = -2147205108,
    MOF_E_TYPEDEF_NOT_SUPPORTED = -2147205107,
    MOF_E_UNEXPECTED_ALIAS = -2147205106,
    MOF_E_UNEXPECTED_ARRAY_INIT = -2147205105,
    MOF_E_INVALID_AMENDMENT_SYNTAX = -2147205104,
    MOF_E_INVALID_DUPLICATE_AMENDMENT = -2147205103,
    MOF_E_INVALID_PRAGMA = -2147205102,
    MOF_E_INVALID_NAMESPACE_SYNTAX = -2147205101,
    MOF_E_EXPECTED_CLASS_NAME = -2147205100,
    MOF_E_TYPE_MISMATCH = -2147205099,
    MOF_E_EXPECTED_ALIAS_NAME = -2147205098,
    MOF_E_INVALID_CLASS_DECLARATION = -2147205097,
    MOF_E_INVALID_INSTANCE_DECLARATION = -2147205096,
    MOF_E_EXPECTED_DOLLAR = -2147205095,
    MOF_E_CIMTYPE_QUALIFIER = -2147205094,
    MOF_E_DUPLICATE_PROPERTY = -2147205093,
    MOF_E_INVALID_NAMESPACE_SPECIFICATION = -2147205092,
    MOF_E_OUT_OF_RANGE = -2147205091,
    MOF_E_INVALID_FILE = -2147205090,
    MOF_E_ALIASES_IN_EMBEDDED = -2147205089,
    MOF_E_NULL_ARRAY_ELEM = -2147205088,
    MOF_E_DUPLICATE_QUALIFIER = -2147205087,
    MOF_E_EXPECTED_FLAVOR_TYPE = -2147205086,
    MOF_E_INCOMPATIBLE_FLAVOR_TYPES = -2147205085,
    MOF_E_MULTIPLE_ALIASES = -2147205084,
    MOF_E_INCOMPATIBLE_FLAVOR_TYPES2 = -2147205083,
    MOF_E_NO_ARRAYS_RETURNED = -2147205082,
    MOF_E_MUST_BE_IN_OR_OUT = -2147205081,
    MOF_E_INVALID_FLAGS_SYNTAX = -2147205080,
    MOF_E_EXPECTED_BRACE_OR_BAD_TYPE = -2147205079,
    MOF_E_UNSUPPORTED_CIMV22_QUAL_VALUE = -2147205078,
    MOF_E_UNSUPPORTED_CIMV22_DATA_TYPE = -2147205077,
    MOF_E_INVALID_DELETEINSTANCE_SYNTAX = -2147205076,
    MOF_E_INVALID_QUALIFIER_SYNTAX = -2147205075,
    MOF_E_QUALIFIER_USED_OUTSIDE_SCOPE = -2147205074,
    MOF_E_ERROR_CREATING_TEMP_FILE = -2147205073,
    MOF_E_ERROR_INVALID_INCLUDE_FILE = -2147205072,
    MOF_E_INVALID_DELETECLASS_SYNTAX = -2147205071,
};
pub const WBEM_NO_ERROR = WBEMSTATUS._NO_ERROR;
pub const WBEM_S_NO_ERROR = WBEMSTATUS._NO_ERROR;
pub const WBEM_S_SAME = WBEMSTATUS._NO_ERROR;
pub const WBEM_S_FALSE = WBEMSTATUS._S_FALSE;
pub const WBEM_S_ALREADY_EXISTS = WBEMSTATUS._S_ALREADY_EXISTS;
pub const WBEM_S_RESET_TO_DEFAULT = WBEMSTATUS._S_RESET_TO_DEFAULT;
pub const WBEM_S_DIFFERENT = WBEMSTATUS._S_DIFFERENT;
pub const WBEM_S_TIMEDOUT = WBEMSTATUS._S_TIMEDOUT;
pub const WBEM_S_NO_MORE_DATA = WBEMSTATUS._S_NO_MORE_DATA;
pub const WBEM_S_OPERATION_CANCELLED = WBEMSTATUS._S_OPERATION_CANCELLED;
pub const WBEM_S_PENDING = WBEMSTATUS._S_PENDING;
pub const WBEM_S_DUPLICATE_OBJECTS = WBEMSTATUS._S_DUPLICATE_OBJECTS;
pub const WBEM_S_ACCESS_DENIED = WBEMSTATUS._S_ACCESS_DENIED;
pub const WBEM_S_PARTIAL_RESULTS = WBEMSTATUS._S_PARTIAL_RESULTS;
pub const WBEM_S_SOURCE_NOT_AVAILABLE = WBEMSTATUS._S_SOURCE_NOT_AVAILABLE;
pub const WBEM_E_FAILED = WBEMSTATUS._E_FAILED;
pub const WBEM_E_NOT_FOUND = WBEMSTATUS._E_NOT_FOUND;
pub const WBEM_E_ACCESS_DENIED = WBEMSTATUS._E_ACCESS_DENIED;
pub const WBEM_E_PROVIDER_FAILURE = WBEMSTATUS._E_PROVIDER_FAILURE;
pub const WBEM_E_TYPE_MISMATCH = WBEMSTATUS._E_TYPE_MISMATCH;
pub const WBEM_E_OUT_OF_MEMORY = WBEMSTATUS._E_OUT_OF_MEMORY;
pub const WBEM_E_INVALID_CONTEXT = WBEMSTATUS._E_INVALID_CONTEXT;
pub const WBEM_E_INVALID_PARAMETER = WBEMSTATUS._E_INVALID_PARAMETER;
pub const WBEM_E_NOT_AVAILABLE = WBEMSTATUS._E_NOT_AVAILABLE;
pub const WBEM_E_CRITICAL_ERROR = WBEMSTATUS._E_CRITICAL_ERROR;
pub const WBEM_E_INVALID_STREAM = WBEMSTATUS._E_INVALID_STREAM;
pub const WBEM_E_NOT_SUPPORTED = WBEMSTATUS._E_NOT_SUPPORTED;
pub const WBEM_E_INVALID_SUPERCLASS = WBEMSTATUS._E_INVALID_SUPERCLASS;
pub const WBEM_E_INVALID_NAMESPACE = WBEMSTATUS._E_INVALID_NAMESPACE;
pub const WBEM_E_INVALID_OBJECT = WBEMSTATUS._E_INVALID_OBJECT;
pub const WBEM_E_INVALID_CLASS = WBEMSTATUS._E_INVALID_CLASS;
pub const WBEM_E_PROVIDER_NOT_FOUND = WBEMSTATUS._E_PROVIDER_NOT_FOUND;
pub const WBEM_E_INVALID_PROVIDER_REGISTRATION = WBEMSTATUS._E_INVALID_PROVIDER_REGISTRATION;
pub const WBEM_E_PROVIDER_LOAD_FAILURE = WBEMSTATUS._E_PROVIDER_LOAD_FAILURE;
pub const WBEM_E_INITIALIZATION_FAILURE = WBEMSTATUS._E_INITIALIZATION_FAILURE;
pub const WBEM_E_TRANSPORT_FAILURE = WBEMSTATUS._E_TRANSPORT_FAILURE;
pub const WBEM_E_INVALID_OPERATION = WBEMSTATUS._E_INVALID_OPERATION;
pub const WBEM_E_INVALID_QUERY = WBEMSTATUS._E_INVALID_QUERY;
pub const WBEM_E_INVALID_QUERY_TYPE = WBEMSTATUS._E_INVALID_QUERY_TYPE;
pub const WBEM_E_ALREADY_EXISTS = WBEMSTATUS._E_ALREADY_EXISTS;
pub const WBEM_E_OVERRIDE_NOT_ALLOWED = WBEMSTATUS._E_OVERRIDE_NOT_ALLOWED;
pub const WBEM_E_PROPAGATED_QUALIFIER = WBEMSTATUS._E_PROPAGATED_QUALIFIER;
pub const WBEM_E_PROPAGATED_PROPERTY = WBEMSTATUS._E_PROPAGATED_PROPERTY;
pub const WBEM_E_UNEXPECTED = WBEMSTATUS._E_UNEXPECTED;
pub const WBEM_E_ILLEGAL_OPERATION = WBEMSTATUS._E_ILLEGAL_OPERATION;
pub const WBEM_E_CANNOT_BE_KEY = WBEMSTATUS._E_CANNOT_BE_KEY;
pub const WBEM_E_INCOMPLETE_CLASS = WBEMSTATUS._E_INCOMPLETE_CLASS;
pub const WBEM_E_INVALID_SYNTAX = WBEMSTATUS._E_INVALID_SYNTAX;
pub const WBEM_E_NONDECORATED_OBJECT = WBEMSTATUS._E_NONDECORATED_OBJECT;
pub const WBEM_E_READ_ONLY = WBEMSTATUS._E_READ_ONLY;
pub const WBEM_E_PROVIDER_NOT_CAPABLE = WBEMSTATUS._E_PROVIDER_NOT_CAPABLE;
pub const WBEM_E_CLASS_HAS_CHILDREN = WBEMSTATUS._E_CLASS_HAS_CHILDREN;
pub const WBEM_E_CLASS_HAS_INSTANCES = WBEMSTATUS._E_CLASS_HAS_INSTANCES;
pub const WBEM_E_QUERY_NOT_IMPLEMENTED = WBEMSTATUS._E_QUERY_NOT_IMPLEMENTED;
pub const WBEM_E_ILLEGAL_NULL = WBEMSTATUS._E_ILLEGAL_NULL;
pub const WBEM_E_INVALID_QUALIFIER_TYPE = WBEMSTATUS._E_INVALID_QUALIFIER_TYPE;
pub const WBEM_E_INVALID_PROPERTY_TYPE = WBEMSTATUS._E_INVALID_PROPERTY_TYPE;
pub const WBEM_E_VALUE_OUT_OF_RANGE = WBEMSTATUS._E_VALUE_OUT_OF_RANGE;
pub const WBEM_E_CANNOT_BE_SINGLETON = WBEMSTATUS._E_CANNOT_BE_SINGLETON;
pub const WBEM_E_INVALID_CIM_TYPE = WBEMSTATUS._E_INVALID_CIM_TYPE;
pub const WBEM_E_INVALID_METHOD = WBEMSTATUS._E_INVALID_METHOD;
pub const WBEM_E_INVALID_METHOD_PARAMETERS = WBEMSTATUS._E_INVALID_METHOD_PARAMETERS;
pub const WBEM_E_SYSTEM_PROPERTY = WBEMSTATUS._E_SYSTEM_PROPERTY;
pub const WBEM_E_INVALID_PROPERTY = WBEMSTATUS._E_INVALID_PROPERTY;
pub const WBEM_E_CALL_CANCELLED = WBEMSTATUS._E_CALL_CANCELLED;
pub const WBEM_E_SHUTTING_DOWN = WBEMSTATUS._E_SHUTTING_DOWN;
pub const WBEM_E_PROPAGATED_METHOD = WBEMSTATUS._E_PROPAGATED_METHOD;
pub const WBEM_E_UNSUPPORTED_PARAMETER = WBEMSTATUS._E_UNSUPPORTED_PARAMETER;
pub const WBEM_E_MISSING_PARAMETER_ID = WBEMSTATUS._E_MISSING_PARAMETER_ID;
pub const WBEM_E_INVALID_PARAMETER_ID = WBEMSTATUS._E_INVALID_PARAMETER_ID;
pub const WBEM_E_NONCONSECUTIVE_PARAMETER_IDS = WBEMSTATUS._E_NONCONSECUTIVE_PARAMETER_IDS;
pub const WBEM_E_PARAMETER_ID_ON_RETVAL = WBEMSTATUS._E_PARAMETER_ID_ON_RETVAL;
pub const WBEM_E_INVALID_OBJECT_PATH = WBEMSTATUS._E_INVALID_OBJECT_PATH;
pub const WBEM_E_OUT_OF_DISK_SPACE = WBEMSTATUS._E_OUT_OF_DISK_SPACE;
pub const WBEM_E_BUFFER_TOO_SMALL = WBEMSTATUS._E_BUFFER_TOO_SMALL;
pub const WBEM_E_UNSUPPORTED_PUT_EXTENSION = WBEMSTATUS._E_UNSUPPORTED_PUT_EXTENSION;
pub const WBEM_E_UNKNOWN_OBJECT_TYPE = WBEMSTATUS._E_UNKNOWN_OBJECT_TYPE;
pub const WBEM_E_UNKNOWN_PACKET_TYPE = WBEMSTATUS._E_UNKNOWN_PACKET_TYPE;
pub const WBEM_E_MARSHAL_VERSION_MISMATCH = WBEMSTATUS._E_MARSHAL_VERSION_MISMATCH;
pub const WBEM_E_MARSHAL_INVALID_SIGNATURE = WBEMSTATUS._E_MARSHAL_INVALID_SIGNATURE;
pub const WBEM_E_INVALID_QUALIFIER = WBEMSTATUS._E_INVALID_QUALIFIER;
pub const WBEM_E_INVALID_DUPLICATE_PARAMETER = WBEMSTATUS._E_INVALID_DUPLICATE_PARAMETER;
pub const WBEM_E_TOO_MUCH_DATA = WBEMSTATUS._E_TOO_MUCH_DATA;
pub const WBEM_E_SERVER_TOO_BUSY = WBEMSTATUS._E_SERVER_TOO_BUSY;
pub const WBEM_E_INVALID_FLAVOR = WBEMSTATUS._E_INVALID_FLAVOR;
pub const WBEM_E_CIRCULAR_REFERENCE = WBEMSTATUS._E_CIRCULAR_REFERENCE;
pub const WBEM_E_UNSUPPORTED_CLASS_UPDATE = WBEMSTATUS._E_UNSUPPORTED_CLASS_UPDATE;
pub const WBEM_E_CANNOT_CHANGE_KEY_INHERITANCE = WBEMSTATUS._E_CANNOT_CHANGE_KEY_INHERITANCE;
pub const WBEM_E_CANNOT_CHANGE_INDEX_INHERITANCE = WBEMSTATUS._E_CANNOT_CHANGE_INDEX_INHERITANCE;
pub const WBEM_E_TOO_MANY_PROPERTIES = WBEMSTATUS._E_TOO_MANY_PROPERTIES;
pub const WBEM_E_UPDATE_TYPE_MISMATCH = WBEMSTATUS._E_UPDATE_TYPE_MISMATCH;
pub const WBEM_E_UPDATE_OVERRIDE_NOT_ALLOWED = WBEMSTATUS._E_UPDATE_OVERRIDE_NOT_ALLOWED;
pub const WBEM_E_UPDATE_PROPAGATED_METHOD = WBEMSTATUS._E_UPDATE_PROPAGATED_METHOD;
pub const WBEM_E_METHOD_NOT_IMPLEMENTED = WBEMSTATUS._E_METHOD_NOT_IMPLEMENTED;
pub const WBEM_E_METHOD_DISABLED = WBEMSTATUS._E_METHOD_DISABLED;
pub const WBEM_E_REFRESHER_BUSY = WBEMSTATUS._E_REFRESHER_BUSY;
pub const WBEM_E_UNPARSABLE_QUERY = WBEMSTATUS._E_UNPARSABLE_QUERY;
pub const WBEM_E_NOT_EVENT_CLASS = WBEMSTATUS._E_NOT_EVENT_CLASS;
pub const WBEM_E_MISSING_GROUP_WITHIN = WBEMSTATUS._E_MISSING_GROUP_WITHIN;
pub const WBEM_E_MISSING_AGGREGATION_LIST = WBEMSTATUS._E_MISSING_AGGREGATION_LIST;
pub const WBEM_E_PROPERTY_NOT_AN_OBJECT = WBEMSTATUS._E_PROPERTY_NOT_AN_OBJECT;
pub const WBEM_E_AGGREGATING_BY_OBJECT = WBEMSTATUS._E_AGGREGATING_BY_OBJECT;
pub const WBEM_E_UNINTERPRETABLE_PROVIDER_QUERY = WBEMSTATUS._E_UNINTERPRETABLE_PROVIDER_QUERY;
pub const WBEM_E_BACKUP_RESTORE_WINMGMT_RUNNING = WBEMSTATUS._E_BACKUP_RESTORE_WINMGMT_RUNNING;
pub const WBEM_E_QUEUE_OVERFLOW = WBEMSTATUS._E_QUEUE_OVERFLOW;
pub const WBEM_E_PRIVILEGE_NOT_HELD = WBEMSTATUS._E_PRIVILEGE_NOT_HELD;
pub const WBEM_E_INVALID_OPERATOR = WBEMSTATUS._E_INVALID_OPERATOR;
pub const WBEM_E_LOCAL_CREDENTIALS = WBEMSTATUS._E_LOCAL_CREDENTIALS;
pub const WBEM_E_CANNOT_BE_ABSTRACT = WBEMSTATUS._E_CANNOT_BE_ABSTRACT;
pub const WBEM_E_AMENDED_OBJECT = WBEMSTATUS._E_AMENDED_OBJECT;
pub const WBEM_E_CLIENT_TOO_SLOW = WBEMSTATUS._E_CLIENT_TOO_SLOW;
pub const WBEM_E_NULL_SECURITY_DESCRIPTOR = WBEMSTATUS._E_NULL_SECURITY_DESCRIPTOR;
pub const WBEM_E_TIMED_OUT = WBEMSTATUS._E_TIMED_OUT;
pub const WBEM_E_INVALID_ASSOCIATION = WBEMSTATUS._E_INVALID_ASSOCIATION;
pub const WBEM_E_AMBIGUOUS_OPERATION = WBEMSTATUS._E_AMBIGUOUS_OPERATION;
pub const WBEM_E_QUOTA_VIOLATION = WBEMSTATUS._E_QUOTA_VIOLATION;
pub const WBEM_E_RESERVED_001 = WBEMSTATUS._E_RESERVED_001;
pub const WBEM_E_RESERVED_002 = WBEMSTATUS._E_RESERVED_002;
pub const WBEM_E_UNSUPPORTED_LOCALE = WBEMSTATUS._E_UNSUPPORTED_LOCALE;
pub const WBEM_E_HANDLE_OUT_OF_DATE = WBEMSTATUS._E_HANDLE_OUT_OF_DATE;
pub const WBEM_E_CONNECTION_FAILED = WBEMSTATUS._E_CONNECTION_FAILED;
pub const WBEM_E_INVALID_HANDLE_REQUEST = WBEMSTATUS._E_INVALID_HANDLE_REQUEST;
pub const WBEM_E_PROPERTY_NAME_TOO_WIDE = WBEMSTATUS._E_PROPERTY_NAME_TOO_WIDE;
pub const WBEM_E_CLASS_NAME_TOO_WIDE = WBEMSTATUS._E_CLASS_NAME_TOO_WIDE;
pub const WBEM_E_METHOD_NAME_TOO_WIDE = WBEMSTATUS._E_METHOD_NAME_TOO_WIDE;
pub const WBEM_E_QUALIFIER_NAME_TOO_WIDE = WBEMSTATUS._E_QUALIFIER_NAME_TOO_WIDE;
pub const WBEM_E_RERUN_COMMAND = WBEMSTATUS._E_RERUN_COMMAND;
pub const WBEM_E_DATABASE_VER_MISMATCH = WBEMSTATUS._E_DATABASE_VER_MISMATCH;
pub const WBEM_E_VETO_DELETE = WBEMSTATUS._E_VETO_DELETE;
pub const WBEM_E_VETO_PUT = WBEMSTATUS._E_VETO_PUT;
pub const WBEM_E_INVALID_LOCALE = WBEMSTATUS._E_INVALID_LOCALE;
pub const WBEM_E_PROVIDER_SUSPENDED = WBEMSTATUS._E_PROVIDER_SUSPENDED;
pub const WBEM_E_SYNCHRONIZATION_REQUIRED = WBEMSTATUS._E_SYNCHRONIZATION_REQUIRED;
pub const WBEM_E_NO_SCHEMA = WBEMSTATUS._E_NO_SCHEMA;
pub const WBEM_E_PROVIDER_ALREADY_REGISTERED = WBEMSTATUS._E_PROVIDER_ALREADY_REGISTERED;
pub const WBEM_E_PROVIDER_NOT_REGISTERED = WBEMSTATUS._E_PROVIDER_NOT_REGISTERED;
pub const WBEM_E_FATAL_TRANSPORT_ERROR = WBEMSTATUS._E_FATAL_TRANSPORT_ERROR;
pub const WBEM_E_ENCRYPTED_CONNECTION_REQUIRED = WBEMSTATUS._E_ENCRYPTED_CONNECTION_REQUIRED;
pub const WBEM_E_PROVIDER_TIMED_OUT = WBEMSTATUS._E_PROVIDER_TIMED_OUT;
pub const WBEM_E_NO_KEY = WBEMSTATUS._E_NO_KEY;
pub const WBEM_E_PROVIDER_DISABLED = WBEMSTATUS._E_PROVIDER_DISABLED;
pub const WBEMESS_E_REGISTRATION_TOO_BROAD = WBEMSTATUS.ESS_E_REGISTRATION_TOO_BROAD;
pub const WBEMESS_E_REGISTRATION_TOO_PRECISE = WBEMSTATUS.ESS_E_REGISTRATION_TOO_PRECISE;
pub const WBEMESS_E_AUTHZ_NOT_PRIVILEGED = WBEMSTATUS.ESS_E_AUTHZ_NOT_PRIVILEGED;
pub const WBEMMOF_E_EXPECTED_QUALIFIER_NAME = WBEMSTATUS.MOF_E_EXPECTED_QUALIFIER_NAME;
pub const WBEMMOF_E_EXPECTED_SEMI = WBEMSTATUS.MOF_E_EXPECTED_SEMI;
pub const WBEMMOF_E_EXPECTED_OPEN_BRACE = WBEMSTATUS.MOF_E_EXPECTED_OPEN_BRACE;
pub const WBEMMOF_E_EXPECTED_CLOSE_BRACE = WBEMSTATUS.MOF_E_EXPECTED_CLOSE_BRACE;
pub const WBEMMOF_E_EXPECTED_CLOSE_BRACKET = WBEMSTATUS.MOF_E_EXPECTED_CLOSE_BRACKET;
pub const WBEMMOF_E_EXPECTED_CLOSE_PAREN = WBEMSTATUS.MOF_E_EXPECTED_CLOSE_PAREN;
pub const WBEMMOF_E_ILLEGAL_CONSTANT_VALUE = WBEMSTATUS.MOF_E_ILLEGAL_CONSTANT_VALUE;
pub const WBEMMOF_E_EXPECTED_TYPE_IDENTIFIER = WBEMSTATUS.MOF_E_EXPECTED_TYPE_IDENTIFIER;
pub const WBEMMOF_E_EXPECTED_OPEN_PAREN = WBEMSTATUS.MOF_E_EXPECTED_OPEN_PAREN;
pub const WBEMMOF_E_UNRECOGNIZED_TOKEN = WBEMSTATUS.MOF_E_UNRECOGNIZED_TOKEN;
pub const WBEMMOF_E_UNRECOGNIZED_TYPE = WBEMSTATUS.MOF_E_UNRECOGNIZED_TYPE;
pub const WBEMMOF_E_EXPECTED_PROPERTY_NAME = WBEMSTATUS.MOF_E_EXPECTED_PROPERTY_NAME;
pub const WBEMMOF_E_TYPEDEF_NOT_SUPPORTED = WBEMSTATUS.MOF_E_TYPEDEF_NOT_SUPPORTED;
pub const WBEMMOF_E_UNEXPECTED_ALIAS = WBEMSTATUS.MOF_E_UNEXPECTED_ALIAS;
pub const WBEMMOF_E_UNEXPECTED_ARRAY_INIT = WBEMSTATUS.MOF_E_UNEXPECTED_ARRAY_INIT;
pub const WBEMMOF_E_INVALID_AMENDMENT_SYNTAX = WBEMSTATUS.MOF_E_INVALID_AMENDMENT_SYNTAX;
pub const WBEMMOF_E_INVALID_DUPLICATE_AMENDMENT = WBEMSTATUS.MOF_E_INVALID_DUPLICATE_AMENDMENT;
pub const WBEMMOF_E_INVALID_PRAGMA = WBEMSTATUS.MOF_E_INVALID_PRAGMA;
pub const WBEMMOF_E_INVALID_NAMESPACE_SYNTAX = WBEMSTATUS.MOF_E_INVALID_NAMESPACE_SYNTAX;
pub const WBEMMOF_E_EXPECTED_CLASS_NAME = WBEMSTATUS.MOF_E_EXPECTED_CLASS_NAME;
pub const WBEMMOF_E_TYPE_MISMATCH = WBEMSTATUS.MOF_E_TYPE_MISMATCH;
pub const WBEMMOF_E_EXPECTED_ALIAS_NAME = WBEMSTATUS.MOF_E_EXPECTED_ALIAS_NAME;
pub const WBEMMOF_E_INVALID_CLASS_DECLARATION = WBEMSTATUS.MOF_E_INVALID_CLASS_DECLARATION;
pub const WBEMMOF_E_INVALID_INSTANCE_DECLARATION = WBEMSTATUS.MOF_E_INVALID_INSTANCE_DECLARATION;
pub const WBEMMOF_E_EXPECTED_DOLLAR = WBEMSTATUS.MOF_E_EXPECTED_DOLLAR;
pub const WBEMMOF_E_CIMTYPE_QUALIFIER = WBEMSTATUS.MOF_E_CIMTYPE_QUALIFIER;
pub const WBEMMOF_E_DUPLICATE_PROPERTY = WBEMSTATUS.MOF_E_DUPLICATE_PROPERTY;
pub const WBEMMOF_E_INVALID_NAMESPACE_SPECIFICATION = WBEMSTATUS.MOF_E_INVALID_NAMESPACE_SPECIFICATION;
pub const WBEMMOF_E_OUT_OF_RANGE = WBEMSTATUS.MOF_E_OUT_OF_RANGE;
pub const WBEMMOF_E_INVALID_FILE = WBEMSTATUS.MOF_E_INVALID_FILE;
pub const WBEMMOF_E_ALIASES_IN_EMBEDDED = WBEMSTATUS.MOF_E_ALIASES_IN_EMBEDDED;
pub const WBEMMOF_E_NULL_ARRAY_ELEM = WBEMSTATUS.MOF_E_NULL_ARRAY_ELEM;
pub const WBEMMOF_E_DUPLICATE_QUALIFIER = WBEMSTATUS.MOF_E_DUPLICATE_QUALIFIER;
pub const WBEMMOF_E_EXPECTED_FLAVOR_TYPE = WBEMSTATUS.MOF_E_EXPECTED_FLAVOR_TYPE;
pub const WBEMMOF_E_INCOMPATIBLE_FLAVOR_TYPES = WBEMSTATUS.MOF_E_INCOMPATIBLE_FLAVOR_TYPES;
pub const WBEMMOF_E_MULTIPLE_ALIASES = WBEMSTATUS.MOF_E_MULTIPLE_ALIASES;
pub const WBEMMOF_E_INCOMPATIBLE_FLAVOR_TYPES2 = WBEMSTATUS.MOF_E_INCOMPATIBLE_FLAVOR_TYPES2;
pub const WBEMMOF_E_NO_ARRAYS_RETURNED = WBEMSTATUS.MOF_E_NO_ARRAYS_RETURNED;
pub const WBEMMOF_E_MUST_BE_IN_OR_OUT = WBEMSTATUS.MOF_E_MUST_BE_IN_OR_OUT;
pub const WBEMMOF_E_INVALID_FLAGS_SYNTAX = WBEMSTATUS.MOF_E_INVALID_FLAGS_SYNTAX;
pub const WBEMMOF_E_EXPECTED_BRACE_OR_BAD_TYPE = WBEMSTATUS.MOF_E_EXPECTED_BRACE_OR_BAD_TYPE;
pub const WBEMMOF_E_UNSUPPORTED_CIMV22_QUAL_VALUE = WBEMSTATUS.MOF_E_UNSUPPORTED_CIMV22_QUAL_VALUE;
pub const WBEMMOF_E_UNSUPPORTED_CIMV22_DATA_TYPE = WBEMSTATUS.MOF_E_UNSUPPORTED_CIMV22_DATA_TYPE;
pub const WBEMMOF_E_INVALID_DELETEINSTANCE_SYNTAX = WBEMSTATUS.MOF_E_INVALID_DELETEINSTANCE_SYNTAX;
pub const WBEMMOF_E_INVALID_QUALIFIER_SYNTAX = WBEMSTATUS.MOF_E_INVALID_QUALIFIER_SYNTAX;
pub const WBEMMOF_E_QUALIFIER_USED_OUTSIDE_SCOPE = WBEMSTATUS.MOF_E_QUALIFIER_USED_OUTSIDE_SCOPE;
pub const WBEMMOF_E_ERROR_CREATING_TEMP_FILE = WBEMSTATUS.MOF_E_ERROR_CREATING_TEMP_FILE;
pub const WBEMMOF_E_ERROR_INVALID_INCLUDE_FILE = WBEMSTATUS.MOF_E_ERROR_INVALID_INCLUDE_FILE;
pub const WBEMMOF_E_INVALID_DELETECLASS_SYNTAX = WBEMSTATUS.MOF_E_INVALID_DELETECLASS_SYNTAX;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemClassObject_Value = Guid.initString("dc12a681-737f-11cf-884d-00aa004b2e24");
pub const IID_IWbemClassObject = &IID_IWbemClassObject_Value;
pub const IWbemClassObject = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetQualifierSet: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                ppQualSet: ?*?*IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                ppQualSet: ?*?*IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Get: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pVal: ?*VARIANT,
                pType: ?*i32,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pVal: ?*VARIANT,
                pType: ?*i32,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Put: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pVal: ?*VARIANT,
                Type: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pVal: ?*VARIANT,
                Type: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Delete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNames: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszQualifierName: ?[*:0]const u16,
                lFlags: i32,
                pQualifierVal: ?*VARIANT,
                pNames: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszQualifierName: ?[*:0]const u16,
                lFlags: i32,
                pQualifierVal: ?*VARIANT,
                pNames: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lEnumFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lEnumFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                strName: ?*?BSTR,
                pVal: ?*VARIANT,
                pType: ?*i32,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                strName: ?*?BSTR,
                pVal: ?*VARIANT,
                pType: ?*i32,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyQualifierSet: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszProperty: ?[*:0]const u16,
                ppQualSet: ?*?*IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszProperty: ?[*:0]const u16,
                ppQualSet: ?*?*IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                ppCopy: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                ppCopy: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetObjectText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                pstrObjectText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                pstrObjectText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SpawnDerivedClass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                ppNewClass: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                ppNewClass: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SpawnInstance: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                ppNewInstance: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                ppNewInstance: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CompareTo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                pCompareTo: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                pCompareTo: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyOrigin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                pstrClassName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                pstrClassName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InheritsFrom: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                strAncestor: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                strAncestor: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMethod: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                ppInSignature: ?*?*IWbemClassObject,
                ppOutSignature: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                ppInSignature: ?*?*IWbemClassObject,
                ppOutSignature: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutMethod: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pInSignature: ?*IWbemClassObject,
                pOutSignature: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pInSignature: ?*IWbemClassObject,
                pOutSignature: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteMethod: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginMethodEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lEnumFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lEnumFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NextMethod: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                pstrName: ?*?BSTR,
                ppInSignature: ?*?*IWbemClassObject,
                ppOutSignature: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                lFlags: i32,
                pstrName: ?*?BSTR,
                ppInSignature: ?*?*IWbemClassObject,
                ppOutSignature: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndMethodEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMethodQualifierSet: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszMethod: ?[*:0]const u16,
                ppQualSet: ?*?*IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszMethod: ?[*:0]const u16,
                ppQualSet: ?*?*IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMethodOrigin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClassObject,
                wszMethodName: ?[*:0]const u16,
                pstrClassName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClassObject,
                wszMethodName: ?[*:0]const u16,
                pstrClassName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetQualifierSet(self: *const T, ppQualSet: ?*?*IWbemQualifierSet) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetQualifierSet(@as(*const IWbemClassObject, @ptrCast(self)), ppQualSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_Get(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, pVal: ?*VARIANT, pType: ?*i32, plFlavor: ?*i32) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).Get(@as(*const IWbemClassObject, @ptrCast(self)), wszName, lFlags, pVal, pType, plFlavor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_Put(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, pVal: ?*VARIANT, Type: i32) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).Put(@as(*const IWbemClassObject, @ptrCast(self)), wszName, lFlags, pVal, Type);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_Delete(self: *const T, wszName: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).Delete(@as(*const IWbemClassObject, @ptrCast(self)), wszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetNames(self: *const T, wszQualifierName: ?[*:0]const u16, lFlags: i32, pQualifierVal: ?*VARIANT, pNames: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetNames(@as(*const IWbemClassObject, @ptrCast(self)), wszQualifierName, lFlags, pQualifierVal, pNames);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_BeginEnumeration(self: *const T, lEnumFlags: i32) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).BeginEnumeration(@as(*const IWbemClassObject, @ptrCast(self)), lEnumFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_Next(self: *const T, lFlags: i32, strName: ?*?BSTR, pVal: ?*VARIANT, pType: ?*i32, plFlavor: ?*i32) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).Next(@as(*const IWbemClassObject, @ptrCast(self)), lFlags, strName, pVal, pType, plFlavor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_EndEnumeration(self: *const T) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).EndEnumeration(@as(*const IWbemClassObject, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetPropertyQualifierSet(self: *const T, wszProperty: ?[*:0]const u16, ppQualSet: ?*?*IWbemQualifierSet) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetPropertyQualifierSet(@as(*const IWbemClassObject, @ptrCast(self)), wszProperty, ppQualSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_Clone(self: *const T, ppCopy: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).Clone(@as(*const IWbemClassObject, @ptrCast(self)), ppCopy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetObjectText(self: *const T, lFlags: i32, pstrObjectText: ?*?BSTR) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetObjectText(@as(*const IWbemClassObject, @ptrCast(self)), lFlags, pstrObjectText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_SpawnDerivedClass(self: *const T, lFlags: i32, ppNewClass: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).SpawnDerivedClass(@as(*const IWbemClassObject, @ptrCast(self)), lFlags, ppNewClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_SpawnInstance(self: *const T, lFlags: i32, ppNewInstance: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).SpawnInstance(@as(*const IWbemClassObject, @ptrCast(self)), lFlags, ppNewInstance);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_CompareTo(self: *const T, lFlags: i32, pCompareTo: ?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).CompareTo(@as(*const IWbemClassObject, @ptrCast(self)), lFlags, pCompareTo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetPropertyOrigin(self: *const T, wszName: ?[*:0]const u16, pstrClassName: ?*?BSTR) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetPropertyOrigin(@as(*const IWbemClassObject, @ptrCast(self)), wszName, pstrClassName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_InheritsFrom(self: *const T, strAncestor: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).InheritsFrom(@as(*const IWbemClassObject, @ptrCast(self)), strAncestor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetMethod(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, ppInSignature: ?*?*IWbemClassObject, ppOutSignature: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetMethod(@as(*const IWbemClassObject, @ptrCast(self)), wszName, lFlags, ppInSignature, ppOutSignature);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_PutMethod(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, pInSignature: ?*IWbemClassObject, pOutSignature: ?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).PutMethod(@as(*const IWbemClassObject, @ptrCast(self)), wszName, lFlags, pInSignature, pOutSignature);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_DeleteMethod(self: *const T, wszName: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).DeleteMethod(@as(*const IWbemClassObject, @ptrCast(self)), wszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_BeginMethodEnumeration(self: *const T, lEnumFlags: i32) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).BeginMethodEnumeration(@as(*const IWbemClassObject, @ptrCast(self)), lEnumFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_NextMethod(self: *const T, lFlags: i32, pstrName: ?*?BSTR, ppInSignature: ?*?*IWbemClassObject, ppOutSignature: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).NextMethod(@as(*const IWbemClassObject, @ptrCast(self)), lFlags, pstrName, ppInSignature, ppOutSignature);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_EndMethodEnumeration(self: *const T) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).EndMethodEnumeration(@as(*const IWbemClassObject, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetMethodQualifierSet(self: *const T, wszMethod: ?[*:0]const u16, ppQualSet: ?*?*IWbemQualifierSet) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetMethodQualifierSet(@as(*const IWbemClassObject, @ptrCast(self)), wszMethod, ppQualSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClassObject_GetMethodOrigin(self: *const T, wszMethodName: ?[*:0]const u16, pstrClassName: ?*?BSTR) HRESULT {
                return @as(*const IWbemClassObject.VTable, @ptrCast(self.vtable)).GetMethodOrigin(@as(*const IWbemClassObject, @ptrCast(self)), wszMethodName, pstrClassName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemObjectAccess_Value = Guid.initString("49353c9a-516b-11d1-aea6-00c04fb68820");
pub const IID_IWbemObjectAccess = &IID_IWbemObjectAccess_Value;
pub const IWbemObjectAccess = extern struct {
    pub const VTable = extern struct {
        base: IWbemClassObject.VTable,
        GetPropertyHandle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                wszPropertyName: ?[*:0]const u16,
                pType: ?*i32,
                plHandle: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                wszPropertyName: ?[*:0]const u16,
                pType: ?*i32,
                plHandle: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WritePropertyValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                lNumBytes: i32,
                aData: [*:0]const u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                lNumBytes: i32,
                aData: [*:0]const u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReadPropertyValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                lBufferSize: i32,
                plNumBytes: ?*i32,
                aData: [*:0]u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                lBufferSize: i32,
                plNumBytes: ?*i32,
                aData: [*:0]u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReadDWORD: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pdw: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pdw: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WriteDWORD: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                dw: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                dw: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReadQWORD: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pqw: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pqw: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WriteQWORD: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pw: u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pw: u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertyInfoByHandle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pstrName: ?*?BSTR,
                pType: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lHandle: i32,
                pstrName: ?*?BSTR,
                pType: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Lock: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Unlock: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectAccess,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectAccess,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWbemClassObject.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_GetPropertyHandle(self: *const T, wszPropertyName: ?[*:0]const u16, pType: ?*i32, plHandle: ?*i32) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).GetPropertyHandle(@as(*const IWbemObjectAccess, @ptrCast(self)), wszPropertyName, pType, plHandle);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_WritePropertyValue(self: *const T, lHandle: i32, lNumBytes: i32, aData: [*:0]const u8) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).WritePropertyValue(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, lNumBytes, aData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_ReadPropertyValue(self: *const T, lHandle: i32, lBufferSize: i32, plNumBytes: ?*i32, aData: [*:0]u8) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).ReadPropertyValue(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, lBufferSize, plNumBytes, aData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_ReadDWORD(self: *const T, lHandle: i32, pdw: ?*u32) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).ReadDWORD(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, pdw);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_WriteDWORD(self: *const T, lHandle: i32, dw: u32) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).WriteDWORD(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, dw);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_ReadQWORD(self: *const T, lHandle: i32, pqw: ?*u64) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).ReadQWORD(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, pqw);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_WriteQWORD(self: *const T, lHandle: i32, pw: u64) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).WriteQWORD(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, pw);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_GetPropertyInfoByHandle(self: *const T, lHandle: i32, pstrName: ?*?BSTR, pType: ?*i32) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).GetPropertyInfoByHandle(@as(*const IWbemObjectAccess, @ptrCast(self)), lHandle, pstrName, pType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_Lock(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).Lock(@as(*const IWbemObjectAccess, @ptrCast(self)), lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectAccess_Unlock(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemObjectAccess.VTable, @ptrCast(self.vtable)).Unlock(@as(*const IWbemObjectAccess, @ptrCast(self)), lFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemQualifierSet_Value = Guid.initString("dc12a680-737f-11cf-884d-00aa004b2e24");
pub const IID_IWbemQualifierSet = &IID_IWbemQualifierSet_Value;
pub const IWbemQualifierSet = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Get: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pVal: ?*VARIANT,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pVal: ?*VARIANT,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Put: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
                wszName: ?[*:0]const u16,
                pVal: ?*VARIANT,
                lFlavor: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
                wszName: ?[*:0]const u16,
                pVal: ?*VARIANT,
                lFlavor: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Delete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
                wszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
                wszName: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNames: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
                lFlags: i32,
                pNames: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
                lFlags: i32,
                pNames: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
                lFlags: i32,
                pstrName: ?*?BSTR,
                pVal: ?*VARIANT,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
                lFlags: i32,
                pstrName: ?*?BSTR,
                pVal: ?*VARIANT,
                plFlavor: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_Get(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, pVal: ?*VARIANT, plFlavor: ?*i32) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).Get(@as(*const IWbemQualifierSet, @ptrCast(self)), wszName, lFlags, pVal, plFlavor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_Put(self: *const T, wszName: ?[*:0]const u16, pVal: ?*VARIANT, lFlavor: i32) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).Put(@as(*const IWbemQualifierSet, @ptrCast(self)), wszName, pVal, lFlavor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_Delete(self: *const T, wszName: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).Delete(@as(*const IWbemQualifierSet, @ptrCast(self)), wszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_GetNames(self: *const T, lFlags: i32, pNames: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).GetNames(@as(*const IWbemQualifierSet, @ptrCast(self)), lFlags, pNames);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_BeginEnumeration(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).BeginEnumeration(@as(*const IWbemQualifierSet, @ptrCast(self)), lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_Next(self: *const T, lFlags: i32, pstrName: ?*?BSTR, pVal: ?*VARIANT, plFlavor: ?*i32) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).Next(@as(*const IWbemQualifierSet, @ptrCast(self)), lFlags, pstrName, pVal, plFlavor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemQualifierSet_EndEnumeration(self: *const T) HRESULT {
                return @as(*const IWbemQualifierSet.VTable, @ptrCast(self.vtable)).EndEnumeration(@as(*const IWbemQualifierSet, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemServices_Value = Guid.initString("9556dc99-828c-11cf-a37e-00aa003240c7");
pub const IID_IWbemServices = &IID_IWbemServices_Value;
pub const IWbemServices = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OpenNamespace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strNamespace: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppWorkingNamespace: ?*?*IWbemServices,
                ppResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strNamespace: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppWorkingNamespace: ?*?*IWbemServices,
                ppResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CancelAsyncCall: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                pSink: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                pSink: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        QueryObjectSink: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                lFlags: i32,
                ppResponseHandler: ?*?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                lFlags: i32,
                ppResponseHandler: ?*?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetObject: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppObject: ?*?*IWbemClassObject,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppObject: ?*?*IWbemClassObject,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetObjectAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutClass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                pObject: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                pObject: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutClassAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                pObject: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                pObject: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteClass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strClass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strClass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteClassAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strClass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strClass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateClassEnum: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strSuperclass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strSuperclass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateClassEnumAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strSuperclass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strSuperclass: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutInstance: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                pInst: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                pInst: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutInstanceAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                pInst: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                pInst: ?*IWbemClassObject,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteInstance: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteInstanceAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateInstanceEnum: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strFilter: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strFilter: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateInstanceEnumAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strFilter: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strFilter: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecQuery: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecQueryAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecNotificationQuery: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecNotificationQueryAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strQueryLanguage: ?BSTR,
                strQuery: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecMethod: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pInParams: ?*IWbemClassObject,
                ppOutParams: ?*?*IWbemClassObject,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pInParams: ?*IWbemClassObject,
                ppOutParams: ?*?*IWbemClassObject,
                ppCallResult: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecMethodAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pInParams: ?*IWbemClassObject,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemServices,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pInParams: ?*IWbemClassObject,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_OpenNamespace(self: *const T, strNamespace: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppWorkingNamespace: ?*?*IWbemServices, ppResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).OpenNamespace(@as(*const IWbemServices, @ptrCast(self)), strNamespace, lFlags, pCtx, ppWorkingNamespace, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_CancelAsyncCall(self: *const T, pSink: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).CancelAsyncCall(@as(*const IWbemServices, @ptrCast(self)), pSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_QueryObjectSink(self: *const T, lFlags: i32, ppResponseHandler: ?*?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).QueryObjectSink(@as(*const IWbemServices, @ptrCast(self)), lFlags, ppResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_GetObject(self: *const T, strObjectPath: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppObject: ?*?*IWbemClassObject, ppCallResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).GetObject(@as(*const IWbemServices, @ptrCast(self)), strObjectPath, lFlags, pCtx, ppObject, ppCallResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_GetObjectAsync(self: *const T, strObjectPath: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).GetObjectAsync(@as(*const IWbemServices, @ptrCast(self)), strObjectPath, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_PutClass(self: *const T, pObject: ?*IWbemClassObject, lFlags: i32, pCtx: ?*IWbemContext, ppCallResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).PutClass(@as(*const IWbemServices, @ptrCast(self)), pObject, lFlags, pCtx, ppCallResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_PutClassAsync(self: *const T, pObject: ?*IWbemClassObject, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).PutClassAsync(@as(*const IWbemServices, @ptrCast(self)), pObject, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_DeleteClass(self: *const T, strClass: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppCallResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).DeleteClass(@as(*const IWbemServices, @ptrCast(self)), strClass, lFlags, pCtx, ppCallResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_DeleteClassAsync(self: *const T, strClass: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).DeleteClassAsync(@as(*const IWbemServices, @ptrCast(self)), strClass, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_CreateClassEnum(self: *const T, strSuperclass: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppEnum: ?*?*IEnumWbemClassObject) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).CreateClassEnum(@as(*const IWbemServices, @ptrCast(self)), strSuperclass, lFlags, pCtx, ppEnum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_CreateClassEnumAsync(self: *const T, strSuperclass: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).CreateClassEnumAsync(@as(*const IWbemServices, @ptrCast(self)), strSuperclass, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_PutInstance(self: *const T, pInst: ?*IWbemClassObject, lFlags: i32, pCtx: ?*IWbemContext, ppCallResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).PutInstance(@as(*const IWbemServices, @ptrCast(self)), pInst, lFlags, pCtx, ppCallResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_PutInstanceAsync(self: *const T, pInst: ?*IWbemClassObject, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).PutInstanceAsync(@as(*const IWbemServices, @ptrCast(self)), pInst, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_DeleteInstance(self: *const T, strObjectPath: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppCallResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).DeleteInstance(@as(*const IWbemServices, @ptrCast(self)), strObjectPath, lFlags, pCtx, ppCallResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_DeleteInstanceAsync(self: *const T, strObjectPath: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).DeleteInstanceAsync(@as(*const IWbemServices, @ptrCast(self)), strObjectPath, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_CreateInstanceEnum(self: *const T, strFilter: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppEnum: ?*?*IEnumWbemClassObject) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).CreateInstanceEnum(@as(*const IWbemServices, @ptrCast(self)), strFilter, lFlags, pCtx, ppEnum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_CreateInstanceEnumAsync(self: *const T, strFilter: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).CreateInstanceEnumAsync(@as(*const IWbemServices, @ptrCast(self)), strFilter, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_ExecQuery(self: *const T, strQueryLanguage: ?BSTR, strQuery: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppEnum: ?*?*IEnumWbemClassObject) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).ExecQuery(@as(*const IWbemServices, @ptrCast(self)), strQueryLanguage, strQuery, lFlags, pCtx, ppEnum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_ExecQueryAsync(self: *const T, strQueryLanguage: ?BSTR, strQuery: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).ExecQueryAsync(@as(*const IWbemServices, @ptrCast(self)), strQueryLanguage, strQuery, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_ExecNotificationQuery(self: *const T, strQueryLanguage: ?BSTR, strQuery: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, ppEnum: ?*?*IEnumWbemClassObject) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).ExecNotificationQuery(@as(*const IWbemServices, @ptrCast(self)), strQueryLanguage, strQuery, lFlags, pCtx, ppEnum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_ExecNotificationQueryAsync(self: *const T, strQueryLanguage: ?BSTR, strQuery: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).ExecNotificationQueryAsync(@as(*const IWbemServices, @ptrCast(self)), strQueryLanguage, strQuery, lFlags, pCtx, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_ExecMethod(self: *const T, strObjectPath: ?BSTR, strMethodName: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pInParams: ?*IWbemClassObject, ppOutParams: ?*?*IWbemClassObject, ppCallResult: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).ExecMethod(@as(*const IWbemServices, @ptrCast(self)), strObjectPath, strMethodName, lFlags, pCtx, pInParams, ppOutParams, ppCallResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemServices_ExecMethodAsync(self: *const T, strObjectPath: ?BSTR, strMethodName: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, pInParams: ?*IWbemClassObject, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemServices.VTable, @ptrCast(self.vtable)).ExecMethodAsync(@as(*const IWbemServices, @ptrCast(self)), strObjectPath, strMethodName, lFlags, pCtx, pInParams, pResponseHandler);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemLocator_Value = Guid.initString("dc12a687-737f-11cf-884d-00aa004b2e24");
pub const IID_IWbemLocator = &IID_IWbemLocator_Value;
pub const IWbemLocator = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ConnectServer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemLocator,
                strNetworkResource: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lSecurityFlags: i32,
                strAuthority: ?BSTR,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemLocator,
                strNetworkResource: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lSecurityFlags: i32,
                strAuthority: ?BSTR,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemLocator_ConnectServer(self: *const T, strNetworkResource: ?BSTR, strUser: ?BSTR, strPassword: ?BSTR, strLocale: ?BSTR, lSecurityFlags: i32, strAuthority: ?BSTR, pCtx: ?*IWbemContext, ppNamespace: ?*?*IWbemServices) HRESULT {
                return @as(*const IWbemLocator.VTable, @ptrCast(self.vtable)).ConnectServer(@as(*const IWbemLocator, @ptrCast(self)), strNetworkResource, strUser, strPassword, strLocale, lSecurityFlags, strAuthority, pCtx, ppNamespace);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemObjectSink_Value = Guid.initString("7c857801-7381-11cf-884d-00aa004b2e24");
pub const IID_IWbemObjectSink = &IID_IWbemObjectSink_Value;
pub const IWbemObjectSink = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Indicate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSink,
                lObjectCount: i32,
                apObjArray: [*]?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSink,
                lObjectCount: i32,
                apObjArray: [*]?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSink,
                lFlags: i32,
                hResult: HRESULT,
                strParam: ?BSTR,
                pObjParam: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSink,
                lFlags: i32,
                hResult: HRESULT,
                strParam: ?BSTR,
                pObjParam: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSink_Indicate(self: *const T, lObjectCount: i32, apObjArray: [*]?*IWbemClassObject) HRESULT {
                return @as(*const IWbemObjectSink.VTable, @ptrCast(self.vtable)).Indicate(@as(*const IWbemObjectSink, @ptrCast(self)), lObjectCount, apObjArray);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSink_SetStatus(self: *const T, lFlags: i32, hResult: HRESULT, strParam: ?BSTR, pObjParam: ?*IWbemClassObject) HRESULT {
                return @as(*const IWbemObjectSink.VTable, @ptrCast(self.vtable)).SetStatus(@as(*const IWbemObjectSink, @ptrCast(self)), lFlags, hResult, strParam, pObjParam);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IEnumWbemClassObject_Value = Guid.initString("027947e1-d731-11ce-a357-000000000001");
pub const IID_IEnumWbemClassObject = &IID_IEnumWbemClassObject_Value;
pub const IEnumWbemClassObject = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumWbemClassObject,
                lTimeout: i32,
                uCount: u32,
                apObjects: [*]?*IWbemClassObject,
                puReturned: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumWbemClassObject,
                lTimeout: i32,
                uCount: u32,
                apObjects: [*]?*IWbemClassObject,
                puReturned: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NextAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumWbemClassObject,
                uCount: u32,
                pSink: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumWbemClassObject,
                uCount: u32,
                pSink: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumWbemClassObject,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumWbemClassObject,
                ppEnum: ?*?*IEnumWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Skip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumWbemClassObject,
                lTimeout: i32,
                nCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumWbemClassObject,
                lTimeout: i32,
                nCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumWbemClassObject_Reset(self: *const T) HRESULT {
                return @as(*const IEnumWbemClassObject.VTable, @ptrCast(self.vtable)).Reset(@as(*const IEnumWbemClassObject, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumWbemClassObject_Next(self: *const T, lTimeout: i32, uCount: u32, apObjects: [*]?*IWbemClassObject, puReturned: ?*u32) HRESULT {
                return @as(*const IEnumWbemClassObject.VTable, @ptrCast(self.vtable)).Next(@as(*const IEnumWbemClassObject, @ptrCast(self)), lTimeout, uCount, apObjects, puReturned);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumWbemClassObject_NextAsync(self: *const T, uCount: u32, pSink: ?*IWbemObjectSink) HRESULT {
                return @as(*const IEnumWbemClassObject.VTable, @ptrCast(self.vtable)).NextAsync(@as(*const IEnumWbemClassObject, @ptrCast(self)), uCount, pSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumWbemClassObject_Clone(self: *const T, ppEnum: ?*?*IEnumWbemClassObject) HRESULT {
                return @as(*const IEnumWbemClassObject.VTable, @ptrCast(self.vtable)).Clone(@as(*const IEnumWbemClassObject, @ptrCast(self)), ppEnum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumWbemClassObject_Skip(self: *const T, lTimeout: i32, nCount: u32) HRESULT {
                return @as(*const IEnumWbemClassObject.VTable, @ptrCast(self.vtable)).Skip(@as(*const IEnumWbemClassObject, @ptrCast(self)), lTimeout, nCount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemCallResult_Value = Guid.initString("44aca675-e8fc-11d0-a07c-00c04fb68820");
pub const IID_IWbemCallResult = &IID_IWbemCallResult_Value;
pub const IWbemCallResult = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetResultObject: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                ppResultObject: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                ppResultObject: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetResultString: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                pstrResultString: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                pstrResultString: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetResultServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                ppServices: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                ppServices: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCallStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                plStatus: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemCallResult,
                lTimeout: i32,
                plStatus: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemCallResult_GetResultObject(self: *const T, lTimeout: i32, ppResultObject: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemCallResult.VTable, @ptrCast(self.vtable)).GetResultObject(@as(*const IWbemCallResult, @ptrCast(self)), lTimeout, ppResultObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemCallResult_GetResultString(self: *const T, lTimeout: i32, pstrResultString: ?*?BSTR) HRESULT {
                return @as(*const IWbemCallResult.VTable, @ptrCast(self.vtable)).GetResultString(@as(*const IWbemCallResult, @ptrCast(self)), lTimeout, pstrResultString);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemCallResult_GetResultServices(self: *const T, lTimeout: i32, ppServices: ?*?*IWbemServices) HRESULT {
                return @as(*const IWbemCallResult.VTable, @ptrCast(self.vtable)).GetResultServices(@as(*const IWbemCallResult, @ptrCast(self)), lTimeout, ppServices);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemCallResult_GetCallStatus(self: *const T, lTimeout: i32, plStatus: ?*i32) HRESULT {
                return @as(*const IWbemCallResult.VTable, @ptrCast(self.vtable)).GetCallStatus(@as(*const IWbemCallResult, @ptrCast(self)), lTimeout, plStatus);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemContext_Value = Guid.initString("44aca674-e8fc-11d0-a07c-00c04fb68820");
pub const IID_IWbemContext = &IID_IWbemContext_Value;
pub const IWbemContext = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                ppNewCopy: ?*?*IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                ppNewCopy: ?*?*IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNames: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                lFlags: i32,
                pNames: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                lFlags: i32,
                pNames: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                lFlags: i32,
                pstrName: ?*?BSTR,
                pValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                lFlags: i32,
                pstrName: ?*?BSTR,
                pValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndEnumeration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                wszName: ?[*:0]const u16,
                lFlags: i32,
                pValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
                wszName: ?[*:0]const u16,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
                wszName: ?[*:0]const u16,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_Clone(self: *const T, ppNewCopy: ?*?*IWbemContext) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).Clone(@as(*const IWbemContext, @ptrCast(self)), ppNewCopy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_GetNames(self: *const T, lFlags: i32, pNames: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).GetNames(@as(*const IWbemContext, @ptrCast(self)), lFlags, pNames);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_BeginEnumeration(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).BeginEnumeration(@as(*const IWbemContext, @ptrCast(self)), lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_Next(self: *const T, lFlags: i32, pstrName: ?*?BSTR, pValue: ?*VARIANT) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).Next(@as(*const IWbemContext, @ptrCast(self)), lFlags, pstrName, pValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_EndEnumeration(self: *const T) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).EndEnumeration(@as(*const IWbemContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_SetValue(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, pValue: ?*VARIANT) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).SetValue(@as(*const IWbemContext, @ptrCast(self)), wszName, lFlags, pValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_GetValue(self: *const T, wszName: ?[*:0]const u16, lFlags: i32, pValue: ?*VARIANT) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).GetValue(@as(*const IWbemContext, @ptrCast(self)), wszName, lFlags, pValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_DeleteValue(self: *const T, wszName: ?[*:0]const u16, lFlags: i32) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).DeleteValue(@as(*const IWbemContext, @ptrCast(self)), wszName, lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemContext_DeleteAll(self: *const T) HRESULT {
                return @as(*const IWbemContext.VTable, @ptrCast(self.vtable)).DeleteAll(@as(*const IWbemContext, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IUnsecuredApartment_Value = Guid.initString("1cfaba8c-1523-11d1-ad79-00c04fd8fdff");
pub const IID_IUnsecuredApartment = &IID_IUnsecuredApartment_Value;
pub const IUnsecuredApartment = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateObjectStub: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IUnsecuredApartment,
                pObject: ?*IUnknown,
                ppStub: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IUnsecuredApartment,
                pObject: ?*IUnknown,
                ppStub: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IUnsecuredApartment_CreateObjectStub(self: *const T, pObject: ?*IUnknown, ppStub: ?*?*IUnknown) HRESULT {
                return @as(*const IUnsecuredApartment.VTable, @ptrCast(self.vtable)).CreateObjectStub(@as(*const IUnsecuredApartment, @ptrCast(self)), pObject, ppStub);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWbemUnsecuredApartment_Value = Guid.initString("31739d04-3471-4cf4-9a7c-57a44ae71956");
pub const IID_IWbemUnsecuredApartment = &IID_IWbemUnsecuredApartment_Value;
pub const IWbemUnsecuredApartment = extern struct {
    pub const VTable = extern struct {
        base: IUnsecuredApartment.VTable,
        CreateSinkStub: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemUnsecuredApartment,
                pSink: ?*IWbemObjectSink,
                dwFlags: u32,
                wszReserved: ?[*:0]const u16,
                ppStub: ?*?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemUnsecuredApartment,
                pSink: ?*IWbemObjectSink,
                dwFlags: u32,
                wszReserved: ?[*:0]const u16,
                ppStub: ?*?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnsecuredApartment.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemUnsecuredApartment_CreateSinkStub(self: *const T, pSink: ?*IWbemObjectSink, dwFlags: u32, wszReserved: ?[*:0]const u16, ppStub: ?*?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemUnsecuredApartment.VTable, @ptrCast(self.vtable)).CreateSinkStub(@as(*const IWbemUnsecuredApartment, @ptrCast(self)), pSink, dwFlags, wszReserved, ppStub);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemStatusCodeText_Value = Guid.initString("eb87e1bc-3233-11d2-aec9-00c04fb68820");
pub const IID_IWbemStatusCodeText = &IID_IWbemStatusCodeText_Value;
pub const IWbemStatusCodeText = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetErrorCodeText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemStatusCodeText,
                hRes: HRESULT,
                LocaleId: u32,
                lFlags: i32,
                MessageText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemStatusCodeText,
                hRes: HRESULT,
                LocaleId: u32,
                lFlags: i32,
                MessageText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFacilityCodeText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemStatusCodeText,
                hRes: HRESULT,
                LocaleId: u32,
                lFlags: i32,
                MessageText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemStatusCodeText,
                hRes: HRESULT,
                LocaleId: u32,
                lFlags: i32,
                MessageText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemStatusCodeText_GetErrorCodeText(self: *const T, hRes: HRESULT, LocaleId: u32, lFlags: i32, MessageText: ?*?BSTR) HRESULT {
                return @as(*const IWbemStatusCodeText.VTable, @ptrCast(self.vtable)).GetErrorCodeText(@as(*const IWbemStatusCodeText, @ptrCast(self)), hRes, LocaleId, lFlags, MessageText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemStatusCodeText_GetFacilityCodeText(self: *const T, hRes: HRESULT, LocaleId: u32, lFlags: i32, MessageText: ?*?BSTR) HRESULT {
                return @as(*const IWbemStatusCodeText.VTable, @ptrCast(self.vtable)).GetFacilityCodeText(@as(*const IWbemStatusCodeText, @ptrCast(self)), hRes, LocaleId, lFlags, MessageText);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemBackupRestore_Value = Guid.initString("c49e32c7-bc8b-11d2-85d4-00105a1f8304");
pub const IID_IWbemBackupRestore = &IID_IWbemBackupRestore_Value;
pub const IWbemBackupRestore = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Backup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemBackupRestore,
                strBackupToFile: ?[*:0]const u16,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemBackupRestore,
                strBackupToFile: ?[*:0]const u16,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Restore: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemBackupRestore,
                strRestoreFromFile: ?[*:0]const u16,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemBackupRestore,
                strRestoreFromFile: ?[*:0]const u16,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemBackupRestore_Backup(self: *const T, strBackupToFile: ?[*:0]const u16, lFlags: i32) HRESULT {
                return @as(*const IWbemBackupRestore.VTable, @ptrCast(self.vtable)).Backup(@as(*const IWbemBackupRestore, @ptrCast(self)), strBackupToFile, lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemBackupRestore_Restore(self: *const T, strRestoreFromFile: ?[*:0]const u16, lFlags: i32) HRESULT {
                return @as(*const IWbemBackupRestore.VTable, @ptrCast(self.vtable)).Restore(@as(*const IWbemBackupRestore, @ptrCast(self)), strRestoreFromFile, lFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemBackupRestoreEx_Value = Guid.initString("a359dec5-e813-4834-8a2a-ba7f1d777d76");
pub const IID_IWbemBackupRestoreEx = &IID_IWbemBackupRestoreEx_Value;
pub const IWbemBackupRestoreEx = extern struct {
    pub const VTable = extern struct {
        base: IWbemBackupRestore.VTable,
        Pause: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemBackupRestoreEx,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemBackupRestoreEx,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Resume: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemBackupRestoreEx,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemBackupRestoreEx,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWbemBackupRestore.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemBackupRestoreEx_Pause(self: *const T) HRESULT {
                return @as(*const IWbemBackupRestoreEx.VTable, @ptrCast(self.vtable)).Pause(@as(*const IWbemBackupRestoreEx, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemBackupRestoreEx_Resume(self: *const T) HRESULT {
                return @as(*const IWbemBackupRestoreEx.VTable, @ptrCast(self.vtable)).Resume(@as(*const IWbemBackupRestoreEx, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemRefresher_Value = Guid.initString("49353c99-516b-11d1-aea6-00c04fb68820");
pub const IID_IWbemRefresher = &IID_IWbemRefresher_Value;
pub const IWbemRefresher = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Refresh: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemRefresher,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemRefresher,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemRefresher_Refresh(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemRefresher.VTable, @ptrCast(self.vtable)).Refresh(@as(*const IWbemRefresher, @ptrCast(self)), lFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemHiPerfEnum_Value = Guid.initString("2705c288-79ae-11d2-b348-00105a1f8177");
pub const IID_IWbemHiPerfEnum = &IID_IWbemHiPerfEnum_Value;
pub const IWbemHiPerfEnum = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AddObjects: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
                uNumObjects: u32,
                apIds: [*]i32,
                apObj: [*]?*IWbemObjectAccess,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
                uNumObjects: u32,
                apIds: [*]i32,
                apObj: [*]?*IWbemObjectAccess,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveObjects: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
                uNumObjects: u32,
                apIds: [*]i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
                uNumObjects: u32,
                apIds: [*]i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetObjects: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
                uNumObjects: u32,
                apObj: [*]?*IWbemObjectAccess,
                puReturned: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
                uNumObjects: u32,
                apObj: [*]?*IWbemObjectAccess,
                puReturned: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfEnum,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfEnum_AddObjects(self: *const T, lFlags: i32, uNumObjects: u32, apIds: [*]i32, apObj: [*]?*IWbemObjectAccess) HRESULT {
                return @as(*const IWbemHiPerfEnum.VTable, @ptrCast(self.vtable)).AddObjects(@as(*const IWbemHiPerfEnum, @ptrCast(self)), lFlags, uNumObjects, apIds, apObj);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfEnum_RemoveObjects(self: *const T, lFlags: i32, uNumObjects: u32, apIds: [*]i32) HRESULT {
                return @as(*const IWbemHiPerfEnum.VTable, @ptrCast(self.vtable)).RemoveObjects(@as(*const IWbemHiPerfEnum, @ptrCast(self)), lFlags, uNumObjects, apIds);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfEnum_GetObjects(self: *const T, lFlags: i32, uNumObjects: u32, apObj: [*]?*IWbemObjectAccess, puReturned: ?*u32) HRESULT {
                return @as(*const IWbemHiPerfEnum.VTable, @ptrCast(self.vtable)).GetObjects(@as(*const IWbemHiPerfEnum, @ptrCast(self)), lFlags, uNumObjects, apObj, puReturned);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfEnum_RemoveAll(self: *const T, lFlags: i32) HRESULT {
                return @as(*const IWbemHiPerfEnum.VTable, @ptrCast(self.vtable)).RemoveAll(@as(*const IWbemHiPerfEnum, @ptrCast(self)), lFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemConfigureRefresher_Value = Guid.initString("49353c92-516b-11d1-aea6-00c04fb68820");
pub const IID_IWbemConfigureRefresher = &IID_IWbemConfigureRefresher_Value;
pub const IWbemConfigureRefresher = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AddObjectByPath: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConfigureRefresher,
                pNamespace: ?*IWbemServices,
                wszPath: ?[*:0]const u16,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppRefreshable: ?*?*IWbemClassObject,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConfigureRefresher,
                pNamespace: ?*IWbemServices,
                wszPath: ?[*:0]const u16,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppRefreshable: ?*?*IWbemClassObject,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddObjectByTemplate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConfigureRefresher,
                pNamespace: ?*IWbemServices,
                pTemplate: ?*IWbemClassObject,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppRefreshable: ?*?*IWbemClassObject,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConfigureRefresher,
                pNamespace: ?*IWbemServices,
                pTemplate: ?*IWbemClassObject,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppRefreshable: ?*?*IWbemClassObject,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddRefresher: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConfigureRefresher,
                pRefresher: ?*IWbemRefresher,
                lFlags: i32,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConfigureRefresher,
                pRefresher: ?*IWbemRefresher,
                lFlags: i32,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConfigureRefresher,
                lId: i32,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConfigureRefresher,
                lId: i32,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddEnum: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConfigureRefresher,
                pNamespace: ?*IWbemServices,
                wszClassName: ?[*:0]const u16,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppEnum: ?*?*IWbemHiPerfEnum,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConfigureRefresher,
                pNamespace: ?*IWbemServices,
                wszClassName: ?[*:0]const u16,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppEnum: ?*?*IWbemHiPerfEnum,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConfigureRefresher_AddObjectByPath(self: *const T, pNamespace: ?*IWbemServices, wszPath: ?[*:0]const u16, lFlags: i32, pContext: ?*IWbemContext, ppRefreshable: ?*?*IWbemClassObject, plId: ?*i32) HRESULT {
                return @as(*const IWbemConfigureRefresher.VTable, @ptrCast(self.vtable)).AddObjectByPath(@as(*const IWbemConfigureRefresher, @ptrCast(self)), pNamespace, wszPath, lFlags, pContext, ppRefreshable, plId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConfigureRefresher_AddObjectByTemplate(self: *const T, pNamespace: ?*IWbemServices, pTemplate: ?*IWbemClassObject, lFlags: i32, pContext: ?*IWbemContext, ppRefreshable: ?*?*IWbemClassObject, plId: ?*i32) HRESULT {
                return @as(*const IWbemConfigureRefresher.VTable, @ptrCast(self.vtable)).AddObjectByTemplate(@as(*const IWbemConfigureRefresher, @ptrCast(self)), pNamespace, pTemplate, lFlags, pContext, ppRefreshable, plId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConfigureRefresher_AddRefresher(self: *const T, pRefresher: ?*IWbemRefresher, lFlags: i32, plId: ?*i32) HRESULT {
                return @as(*const IWbemConfigureRefresher.VTable, @ptrCast(self.vtable)).AddRefresher(@as(*const IWbemConfigureRefresher, @ptrCast(self)), pRefresher, lFlags, plId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConfigureRefresher_Remove(self: *const T, lId: i32, lFlags: i32) HRESULT {
                return @as(*const IWbemConfigureRefresher.VTable, @ptrCast(self.vtable)).Remove(@as(*const IWbemConfigureRefresher, @ptrCast(self)), lId, lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConfigureRefresher_AddEnum(self: *const T, pNamespace: ?*IWbemServices, wszClassName: ?[*:0]const u16, lFlags: i32, pContext: ?*IWbemContext, ppEnum: ?*?*IWbemHiPerfEnum, plId: ?*i32) HRESULT {
                return @as(*const IWbemConfigureRefresher.VTable, @ptrCast(self.vtable)).AddEnum(@as(*const IWbemConfigureRefresher, @ptrCast(self)), pNamespace, wszClassName, lFlags, pContext, ppEnum, plId);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemObjectSinkEx_Value = Guid.initString("e7d35cfa-348b-485e-b524-252725d697ca");
pub const IID_IWbemObjectSinkEx = &IID_IWbemObjectSinkEx_Value;
pub const IWbemObjectSinkEx = extern struct {
    pub const VTable = extern struct {
        base: IWbemObjectSink.VTable,
        WriteMessage: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSinkEx,
                uChannel: u32,
                strMessage: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSinkEx,
                uChannel: u32,
                strMessage: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WriteError: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSinkEx,
                pObjError: ?*IWbemClassObject,
                puReturned: ?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSinkEx,
                pObjError: ?*IWbemClassObject,
                puReturned: ?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PromptUser: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSinkEx,
                strMessage: ?BSTR,
                uPromptType: u8,
                puReturned: ?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSinkEx,
                strMessage: ?BSTR,
                uPromptType: u8,
                puReturned: ?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WriteProgress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSinkEx,
                strActivity: ?BSTR,
                strCurrentOperation: ?BSTR,
                strStatusDescription: ?BSTR,
                uPercentComplete: u32,
                uSecondsRemaining: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSinkEx,
                strActivity: ?BSTR,
                strCurrentOperation: ?BSTR,
                strStatusDescription: ?BSTR,
                uPercentComplete: u32,
                uSecondsRemaining: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WriteStreamParameter: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectSinkEx,
                strName: ?BSTR,
                vtValue: ?*VARIANT,
                ulType: u32,
                ulFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectSinkEx,
                strName: ?BSTR,
                vtValue: ?*VARIANT,
                ulType: u32,
                ulFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWbemObjectSink.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSinkEx_WriteMessage(self: *const T, uChannel: u32, strMessage: ?BSTR) HRESULT {
                return @as(*const IWbemObjectSinkEx.VTable, @ptrCast(self.vtable)).WriteMessage(@as(*const IWbemObjectSinkEx, @ptrCast(self)), uChannel, strMessage);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSinkEx_WriteError(self: *const T, pObjError: ?*IWbemClassObject, puReturned: ?*u8) HRESULT {
                return @as(*const IWbemObjectSinkEx.VTable, @ptrCast(self.vtable)).WriteError(@as(*const IWbemObjectSinkEx, @ptrCast(self)), pObjError, puReturned);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSinkEx_PromptUser(self: *const T, strMessage: ?BSTR, uPromptType: u8, puReturned: ?*u8) HRESULT {
                return @as(*const IWbemObjectSinkEx.VTable, @ptrCast(self.vtable)).PromptUser(@as(*const IWbemObjectSinkEx, @ptrCast(self)), strMessage, uPromptType, puReturned);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSinkEx_WriteProgress(self: *const T, strActivity: ?BSTR, strCurrentOperation: ?BSTR, strStatusDescription: ?BSTR, uPercentComplete: u32, uSecondsRemaining: u32) HRESULT {
                return @as(*const IWbemObjectSinkEx.VTable, @ptrCast(self.vtable)).WriteProgress(@as(*const IWbemObjectSinkEx, @ptrCast(self)), strActivity, strCurrentOperation, strStatusDescription, uPercentComplete, uSecondsRemaining);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectSinkEx_WriteStreamParameter(self: *const T, strName: ?BSTR, vtValue: ?*VARIANT, ulType: u32, ulFlags: u32) HRESULT {
                return @as(*const IWbemObjectSinkEx.VTable, @ptrCast(self.vtable)).WriteStreamParameter(@as(*const IWbemObjectSinkEx, @ptrCast(self)), strName, vtValue, ulType, ulFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemShutdown_Value = Guid.initString("b7b31df9-d515-11d3-a11c-00105a1f515a");
pub const IID_IWbemShutdown = &IID_IWbemShutdown_Value;
pub const IWbemShutdown = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Shutdown: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemShutdown,
                uReason: i32,
                uMaxMilliseconds: u32,
                pCtx: ?*IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemShutdown,
                uReason: i32,
                uMaxMilliseconds: u32,
                pCtx: ?*IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemShutdown_Shutdown(self: *const T, uReason: i32, uMaxMilliseconds: u32, pCtx: ?*IWbemContext) HRESULT {
                return @as(*const IWbemShutdown.VTable, @ptrCast(self.vtable)).Shutdown(@as(*const IWbemShutdown, @ptrCast(self)), uReason, uMaxMilliseconds, pCtx);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WMI_OBJ_TEXT = enum(i32) {
    CIM_DTD_2_0 = 1,
    WMI_DTD_2_0 = 2,
    WMI_EXT1 = 3,
    WMI_EXT2 = 4,
    WMI_EXT3 = 5,
    WMI_EXT4 = 6,
    WMI_EXT5 = 7,
    WMI_EXT6 = 8,
    WMI_EXT7 = 9,
    WMI_EXT8 = 10,
    WMI_EXT9 = 11,
    WMI_EXT10 = 12,
    LAST = 13,
};
pub const WMI_OBJ_TEXT_CIM_DTD_2_0 = WMI_OBJ_TEXT.CIM_DTD_2_0;
pub const WMI_OBJ_TEXT_WMI_DTD_2_0 = WMI_OBJ_TEXT.WMI_DTD_2_0;
pub const WMI_OBJ_TEXT_WMI_EXT1 = WMI_OBJ_TEXT.WMI_EXT1;
pub const WMI_OBJ_TEXT_WMI_EXT2 = WMI_OBJ_TEXT.WMI_EXT2;
pub const WMI_OBJ_TEXT_WMI_EXT3 = WMI_OBJ_TEXT.WMI_EXT3;
pub const WMI_OBJ_TEXT_WMI_EXT4 = WMI_OBJ_TEXT.WMI_EXT4;
pub const WMI_OBJ_TEXT_WMI_EXT5 = WMI_OBJ_TEXT.WMI_EXT5;
pub const WMI_OBJ_TEXT_WMI_EXT6 = WMI_OBJ_TEXT.WMI_EXT6;
pub const WMI_OBJ_TEXT_WMI_EXT7 = WMI_OBJ_TEXT.WMI_EXT7;
pub const WMI_OBJ_TEXT_WMI_EXT8 = WMI_OBJ_TEXT.WMI_EXT8;
pub const WMI_OBJ_TEXT_WMI_EXT9 = WMI_OBJ_TEXT.WMI_EXT9;
pub const WMI_OBJ_TEXT_WMI_EXT10 = WMI_OBJ_TEXT.WMI_EXT10;
pub const WMI_OBJ_TEXT_LAST = WMI_OBJ_TEXT.LAST;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemObjectTextSrc_Value = Guid.initString("bfbf883a-cad7-11d3-a11b-00105a1f515a");
pub const IID_IWbemObjectTextSrc = &IID_IWbemObjectTextSrc_Value;
pub const IWbemObjectTextSrc = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectTextSrc,
                lFlags: i32,
                pObj: ?*IWbemClassObject,
                uObjTextFormat: u32,
                pCtx: ?*IWbemContext,
                strText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectTextSrc,
                lFlags: i32,
                pObj: ?*IWbemClassObject,
                uObjTextFormat: u32,
                pCtx: ?*IWbemContext,
                strText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateFromText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemObjectTextSrc,
                lFlags: i32,
                strText: ?BSTR,
                uObjTextFormat: u32,
                pCtx: ?*IWbemContext,
                pNewObj: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemObjectTextSrc,
                lFlags: i32,
                strText: ?BSTR,
                uObjTextFormat: u32,
                pCtx: ?*IWbemContext,
                pNewObj: ?*?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectTextSrc_GetText(self: *const T, lFlags: i32, pObj: ?*IWbemClassObject, uObjTextFormat: u32, pCtx: ?*IWbemContext, strText: ?*?BSTR) HRESULT {
                return @as(*const IWbemObjectTextSrc.VTable, @ptrCast(self.vtable)).GetText(@as(*const IWbemObjectTextSrc, @ptrCast(self)), lFlags, pObj, uObjTextFormat, pCtx, strText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemObjectTextSrc_CreateFromText(self: *const T, lFlags: i32, strText: ?BSTR, uObjTextFormat: u32, pCtx: ?*IWbemContext, pNewObj: ?*?*IWbemClassObject) HRESULT {
                return @as(*const IWbemObjectTextSrc.VTable, @ptrCast(self.vtable)).CreateFromText(@as(*const IWbemObjectTextSrc, @ptrCast(self)), lFlags, strText, uObjTextFormat, pCtx, pNewObj);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WBEM_COMPILE_STATUS_INFO = extern struct {
    lPhaseError: i32,
    hRes: HRESULT,
    ObjectNum: i32,
    FirstLine: i32,
    LastLine: i32,
    dwOutFlags: u32,
};

pub const WBEM_COMPILER_OPTIONS = enum(i32) {
    CHECK_ONLY = 1,
    AUTORECOVER = 2,
    WMI_CHECK = 4,
    CONSOLE_PRINT = 8,
    DONT_ADD_TO_LIST = 16,
    SPLIT_FILES = 32,
    STORE_FILE = 256,
};
pub const WBEM_FLAG_CHECK_ONLY = WBEM_COMPILER_OPTIONS.CHECK_ONLY;
pub const WBEM_FLAG_AUTORECOVER = WBEM_COMPILER_OPTIONS.AUTORECOVER;
pub const WBEM_FLAG_WMI_CHECK = WBEM_COMPILER_OPTIONS.WMI_CHECK;
pub const WBEM_FLAG_CONSOLE_PRINT = WBEM_COMPILER_OPTIONS.CONSOLE_PRINT;
pub const WBEM_FLAG_DONT_ADD_TO_LIST = WBEM_COMPILER_OPTIONS.DONT_ADD_TO_LIST;
pub const WBEM_FLAG_SPLIT_FILES = WBEM_COMPILER_OPTIONS.SPLIT_FILES;
pub const WBEM_FLAG_STORE_FILE = WBEM_COMPILER_OPTIONS.STORE_FILE;

pub const WBEM_CONNECT_OPTIONS = enum(i32) {
    REPOSITORY_ONLY = 64,
    USE_MAX_WAIT = 128,
    PROVIDERS = 256,
};
pub const WBEM_FLAG_CONNECT_REPOSITORY_ONLY = WBEM_CONNECT_OPTIONS.REPOSITORY_ONLY;
pub const WBEM_FLAG_CONNECT_USE_MAX_WAIT = WBEM_CONNECT_OPTIONS.USE_MAX_WAIT;
pub const WBEM_FLAG_CONNECT_PROVIDERS = WBEM_CONNECT_OPTIONS.PROVIDERS;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IMofCompiler_Value = Guid.initString("6daf974e-2e37-11d2-aec9-00c04fb68820");
pub const IID_IMofCompiler = &IID_IMofCompiler_Value;
pub const IMofCompiler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CompileFile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMofCompiler,
                FileName: ?PWSTR,
                ServerAndNamespace: ?PWSTR,
                User: ?PWSTR,
                Authority: ?PWSTR,
                Password: ?PWSTR,
                lOptionFlags: i32,
                lClassFlags: i32,
                lInstanceFlags: i32,
                pInfo: ?*WBEM_COMPILE_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMofCompiler,
                FileName: ?PWSTR,
                ServerAndNamespace: ?PWSTR,
                User: ?PWSTR,
                Authority: ?PWSTR,
                Password: ?PWSTR,
                lOptionFlags: i32,
                lClassFlags: i32,
                lInstanceFlags: i32,
                pInfo: ?*WBEM_COMPILE_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CompileBuffer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMofCompiler,
                BuffSize: i32,
                // TODO: what to do with BytesParamIndex 0?
                pBuffer: ?*u8,
                ServerAndNamespace: ?PWSTR,
                User: ?PWSTR,
                Authority: ?PWSTR,
                Password: ?PWSTR,
                lOptionFlags: i32,
                lClassFlags: i32,
                lInstanceFlags: i32,
                pInfo: ?*WBEM_COMPILE_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMofCompiler,
                BuffSize: i32,
                // TODO: what to do with BytesParamIndex 0?
                pBuffer: ?*u8,
                ServerAndNamespace: ?PWSTR,
                User: ?PWSTR,
                Authority: ?PWSTR,
                Password: ?PWSTR,
                lOptionFlags: i32,
                lClassFlags: i32,
                lInstanceFlags: i32,
                pInfo: ?*WBEM_COMPILE_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBMOF: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMofCompiler,
                TextFileName: ?PWSTR,
                BMOFFileName: ?PWSTR,
                ServerAndNamespace: ?PWSTR,
                lOptionFlags: i32,
                lClassFlags: i32,
                lInstanceFlags: i32,
                pInfo: ?*WBEM_COMPILE_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMofCompiler,
                TextFileName: ?PWSTR,
                BMOFFileName: ?PWSTR,
                ServerAndNamespace: ?PWSTR,
                lOptionFlags: i32,
                lClassFlags: i32,
                lInstanceFlags: i32,
                pInfo: ?*WBEM_COMPILE_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMofCompiler_CompileFile(self: *const T, FileName: ?PWSTR, ServerAndNamespace: ?PWSTR, User: ?PWSTR, Authority: ?PWSTR, Password: ?PWSTR, lOptionFlags: i32, lClassFlags: i32, lInstanceFlags: i32, pInfo: ?*WBEM_COMPILE_STATUS_INFO) HRESULT {
                return @as(*const IMofCompiler.VTable, @ptrCast(self.vtable)).CompileFile(@as(*const IMofCompiler, @ptrCast(self)), FileName, ServerAndNamespace, User, Authority, Password, lOptionFlags, lClassFlags, lInstanceFlags, pInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMofCompiler_CompileBuffer(self: *const T, BuffSize: i32, pBuffer: ?*u8, ServerAndNamespace: ?PWSTR, User: ?PWSTR, Authority: ?PWSTR, Password: ?PWSTR, lOptionFlags: i32, lClassFlags: i32, lInstanceFlags: i32, pInfo: ?*WBEM_COMPILE_STATUS_INFO) HRESULT {
                return @as(*const IMofCompiler.VTable, @ptrCast(self.vtable)).CompileBuffer(@as(*const IMofCompiler, @ptrCast(self)), BuffSize, pBuffer, ServerAndNamespace, User, Authority, Password, lOptionFlags, lClassFlags, lInstanceFlags, pInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMofCompiler_CreateBMOF(self: *const T, TextFileName: ?PWSTR, BMOFFileName: ?PWSTR, ServerAndNamespace: ?PWSTR, lOptionFlags: i32, lClassFlags: i32, lInstanceFlags: i32, pInfo: ?*WBEM_COMPILE_STATUS_INFO) HRESULT {
                return @as(*const IMofCompiler.VTable, @ptrCast(self.vtable)).CreateBMOF(@as(*const IMofCompiler, @ptrCast(self)), TextFileName, BMOFFileName, ServerAndNamespace, lOptionFlags, lClassFlags, lInstanceFlags, pInfo);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WBEM_UNSECAPP_FLAG_TYPE = enum(i32) {
    DEFAULT_CHECK_ACCESS = 0,
    CHECK_ACCESS = 1,
    DONT_CHECK_ACCESS = 2,
};
pub const WBEM_FLAG_UNSECAPP_DEFAULT_CHECK_ACCESS = WBEM_UNSECAPP_FLAG_TYPE.DEFAULT_CHECK_ACCESS;
pub const WBEM_FLAG_UNSECAPP_CHECK_ACCESS = WBEM_UNSECAPP_FLAG_TYPE.CHECK_ACCESS;
pub const WBEM_FLAG_UNSECAPP_DONT_CHECK_ACCESS = WBEM_UNSECAPP_FLAG_TYPE.DONT_CHECK_ACCESS;

pub const WBEM_INFORMATION_FLAG_TYPE = enum(i32) {
    SHORT_NAME = 1,
    LONG_NAME = 2,
};
pub const WBEM_FLAG_SHORT_NAME = WBEM_INFORMATION_FLAG_TYPE.SHORT_NAME;
pub const WBEM_FLAG_LONG_NAME = WBEM_INFORMATION_FLAG_TYPE.LONG_NAME;

const CLSID_WbemAdministrativeLocator_Value = Guid.initString("cb8555cc-9128-11d1-ad9b-00c04fd8fdff");
pub const CLSID_WbemAdministrativeLocator = &CLSID_WbemAdministrativeLocator_Value;

const CLSID_WbemAuthenticatedLocator_Value = Guid.initString("cd184336-9128-11d1-ad9b-00c04fd8fdff");
pub const CLSID_WbemAuthenticatedLocator = &CLSID_WbemAuthenticatedLocator_Value;

const CLSID_WbemUnauthenticatedLocator_Value = Guid.initString("443e7b79-de31-11d2-b340-00104bcc4b4a");
pub const CLSID_WbemUnauthenticatedLocator = &CLSID_WbemUnauthenticatedLocator_Value;

const CLSID_WbemDecoupledRegistrar_Value = Guid.initString("4cfc7932-0f9d-4bef-9c32-8ea2a6b56fcb");
pub const CLSID_WbemDecoupledRegistrar = &CLSID_WbemDecoupledRegistrar_Value;

const CLSID_WbemDecoupledBasicEventProvider_Value = Guid.initString("f5f75737-2843-4f22-933d-c76a97cda62f");
pub const CLSID_WbemDecoupledBasicEventProvider = &CLSID_WbemDecoupledBasicEventProvider_Value;

pub const WBEM_PROVIDER_REQUIREMENTS_TYPE = enum(i32) {
    START_POSTFILTER = 0,
    STOP_POSTFILTER = 1,
    RECHECK_SUBSCRIPTIONS = 2,
};
pub const WBEM_REQUIREMENTS_START_POSTFILTER = WBEM_PROVIDER_REQUIREMENTS_TYPE.START_POSTFILTER;
pub const WBEM_REQUIREMENTS_STOP_POSTFILTER = WBEM_PROVIDER_REQUIREMENTS_TYPE.STOP_POSTFILTER;
pub const WBEM_REQUIREMENTS_RECHECK_SUBSCRIPTIONS = WBEM_PROVIDER_REQUIREMENTS_TYPE.RECHECK_SUBSCRIPTIONS;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemPropertyProvider_Value = Guid.initString("ce61e841-65bc-11d0-b6bd-00aa003240c7");
pub const IID_IWbemPropertyProvider = &IID_IWbemPropertyProvider_Value;
pub const IWbemPropertyProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPropertyProvider,
                lFlags: i32,
                strLocale: ?BSTR,
                strClassMapping: ?BSTR,
                strInstMapping: ?BSTR,
                strPropMapping: ?BSTR,
                pvValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPropertyProvider,
                lFlags: i32,
                strLocale: ?BSTR,
                strClassMapping: ?BSTR,
                strInstMapping: ?BSTR,
                strPropMapping: ?BSTR,
                pvValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemPropertyProvider,
                lFlags: i32,
                strLocale: ?BSTR,
                strClassMapping: ?BSTR,
                strInstMapping: ?BSTR,
                strPropMapping: ?BSTR,
                pvValue: ?*const VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemPropertyProvider,
                lFlags: i32,
                strLocale: ?BSTR,
                strClassMapping: ?BSTR,
                strInstMapping: ?BSTR,
                strPropMapping: ?BSTR,
                pvValue: ?*const VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPropertyProvider_GetProperty(self: *const T, lFlags: i32, strLocale: ?BSTR, strClassMapping: ?BSTR, strInstMapping: ?BSTR, strPropMapping: ?BSTR, pvValue: ?*VARIANT) HRESULT {
                return @as(*const IWbemPropertyProvider.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IWbemPropertyProvider, @ptrCast(self)), lFlags, strLocale, strClassMapping, strInstMapping, strPropMapping, pvValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemPropertyProvider_PutProperty(self: *const T, lFlags: i32, strLocale: ?BSTR, strClassMapping: ?BSTR, strInstMapping: ?BSTR, strPropMapping: ?BSTR, pvValue: ?*const VARIANT) HRESULT {
                return @as(*const IWbemPropertyProvider.VTable, @ptrCast(self.vtable)).PutProperty(@as(*const IWbemPropertyProvider, @ptrCast(self)), lFlags, strLocale, strClassMapping, strInstMapping, strPropMapping, pvValue);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemUnboundObjectSink_Value = Guid.initString("e246107b-b06e-11d0-ad61-00c04fd8fdff");
pub const IID_IWbemUnboundObjectSink = &IID_IWbemUnboundObjectSink_Value;
pub const IWbemUnboundObjectSink = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        IndicateToConsumer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemUnboundObjectSink,
                pLogicalConsumer: ?*IWbemClassObject,
                lNumObjects: i32,
                apObjects: [*]?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemUnboundObjectSink,
                pLogicalConsumer: ?*IWbemClassObject,
                lNumObjects: i32,
                apObjects: [*]?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemUnboundObjectSink_IndicateToConsumer(self: *const T, pLogicalConsumer: ?*IWbemClassObject, lNumObjects: i32, apObjects: [*]?*IWbemClassObject) HRESULT {
                return @as(*const IWbemUnboundObjectSink.VTable, @ptrCast(self.vtable)).IndicateToConsumer(@as(*const IWbemUnboundObjectSink, @ptrCast(self)), pLogicalConsumer, lNumObjects, apObjects);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemEventProvider_Value = Guid.initString("e245105b-b06e-11d0-ad61-00c04fd8fdff");
pub const IID_IWbemEventProvider = &IID_IWbemEventProvider_Value;
pub const IWbemEventProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ProvideEvents: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventProvider,
                pSink: ?*IWbemObjectSink,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventProvider,
                pSink: ?*IWbemObjectSink,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventProvider_ProvideEvents(self: *const T, pSink: ?*IWbemObjectSink, lFlags: i32) HRESULT {
                return @as(*const IWbemEventProvider.VTable, @ptrCast(self.vtable)).ProvideEvents(@as(*const IWbemEventProvider, @ptrCast(self)), pSink, lFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemEventProviderQuerySink_Value = Guid.initString("580acaf8-fa1c-11d0-ad72-00c04fd8fdff");
pub const IID_IWbemEventProviderQuerySink = &IID_IWbemEventProviderQuerySink_Value;
pub const IWbemEventProviderQuerySink = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        NewQuery: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventProviderQuerySink,
                dwId: u32,
                wszQueryLanguage: ?*u16,
                wszQuery: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventProviderQuerySink,
                dwId: u32,
                wszQueryLanguage: ?*u16,
                wszQuery: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CancelQuery: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventProviderQuerySink,
                dwId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventProviderQuerySink,
                dwId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventProviderQuerySink_NewQuery(self: *const T, dwId: u32, wszQueryLanguage: ?*u16, wszQuery: ?*u16) HRESULT {
                return @as(*const IWbemEventProviderQuerySink.VTable, @ptrCast(self.vtable)).NewQuery(@as(*const IWbemEventProviderQuerySink, @ptrCast(self)), dwId, wszQueryLanguage, wszQuery);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventProviderQuerySink_CancelQuery(self: *const T, dwId: u32) HRESULT {
                return @as(*const IWbemEventProviderQuerySink.VTable, @ptrCast(self.vtable)).CancelQuery(@as(*const IWbemEventProviderQuerySink, @ptrCast(self)), dwId);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemEventProviderSecurity_Value = Guid.initString("631f7d96-d993-11d2-b339-00105a1f4aaf");
pub const IID_IWbemEventProviderSecurity = &IID_IWbemEventProviderSecurity_Value;
pub const IWbemEventProviderSecurity = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AccessCheck: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventProviderSecurity,
                wszQueryLanguage: ?*u16,
                wszQuery: ?*u16,
                lSidLength: i32,
                pSid: [*:0]const u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventProviderSecurity,
                wszQueryLanguage: ?*u16,
                wszQuery: ?*u16,
                lSidLength: i32,
                pSid: [*:0]const u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventProviderSecurity_AccessCheck(self: *const T, wszQueryLanguage: ?*u16, wszQuery: ?*u16, lSidLength: i32, pSid: [*:0]const u8) HRESULT {
                return @as(*const IWbemEventProviderSecurity.VTable, @ptrCast(self.vtable)).AccessCheck(@as(*const IWbemEventProviderSecurity, @ptrCast(self)), wszQueryLanguage, wszQuery, lSidLength, pSid);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemEventConsumerProvider_Value = Guid.initString("e246107a-b06e-11d0-ad61-00c04fd8fdff");
pub const IID_IWbemEventConsumerProvider = &IID_IWbemEventConsumerProvider_Value;
pub const IWbemEventConsumerProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        FindConsumer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventConsumerProvider,
                pLogicalConsumer: ?*IWbemClassObject,
                ppConsumer: ?*?*IWbemUnboundObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventConsumerProvider,
                pLogicalConsumer: ?*IWbemClassObject,
                ppConsumer: ?*?*IWbemUnboundObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventConsumerProvider_FindConsumer(self: *const T, pLogicalConsumer: ?*IWbemClassObject, ppConsumer: ?*?*IWbemUnboundObjectSink) HRESULT {
                return @as(*const IWbemEventConsumerProvider.VTable, @ptrCast(self.vtable)).FindConsumer(@as(*const IWbemEventConsumerProvider, @ptrCast(self)), pLogicalConsumer, ppConsumer);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemProviderInitSink_Value = Guid.initString("1be41571-91dd-11d1-aeb2-00c04fb68820");
pub const IID_IWbemProviderInitSink = &IID_IWbemProviderInitSink_Value;
pub const IWbemProviderInitSink = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemProviderInitSink,
                lStatus: i32,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemProviderInitSink,
                lStatus: i32,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemProviderInitSink_SetStatus(self: *const T, lStatus: i32, lFlags: i32) HRESULT {
                return @as(*const IWbemProviderInitSink.VTable, @ptrCast(self.vtable)).SetStatus(@as(*const IWbemProviderInitSink, @ptrCast(self)), lStatus, lFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemProviderInit_Value = Guid.initString("1be41572-91dd-11d1-aeb2-00c04fb68820");
pub const IID_IWbemProviderInit = &IID_IWbemProviderInit_Value;
pub const IWbemProviderInit = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemProviderInit,
                wszUser: ?PWSTR,
                lFlags: i32,
                wszNamespace: ?PWSTR,
                wszLocale: ?PWSTR,
                pNamespace: ?*IWbemServices,
                pCtx: ?*IWbemContext,
                pInitSink: ?*IWbemProviderInitSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemProviderInit,
                wszUser: ?PWSTR,
                lFlags: i32,
                wszNamespace: ?PWSTR,
                wszLocale: ?PWSTR,
                pNamespace: ?*IWbemServices,
                pCtx: ?*IWbemContext,
                pInitSink: ?*IWbemProviderInitSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemProviderInit_Initialize(self: *const T, wszUser: ?PWSTR, lFlags: i32, wszNamespace: ?PWSTR, wszLocale: ?PWSTR, pNamespace: ?*IWbemServices, pCtx: ?*IWbemContext, pInitSink: ?*IWbemProviderInitSink) HRESULT {
                return @as(*const IWbemProviderInit.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IWbemProviderInit, @ptrCast(self)), wszUser, lFlags, wszNamespace, wszLocale, pNamespace, pCtx, pInitSink);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemHiPerfProvider_Value = Guid.initString("49353c93-516b-11d1-aea6-00c04fb68820");
pub const IID_IWbemHiPerfProvider = &IID_IWbemHiPerfProvider_Value;
pub const IWbemHiPerfProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        QueryInstances: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                wszClass: ?PWSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pSink: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                wszClass: ?PWSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                pSink: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRefresher: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                lFlags: i32,
                ppRefresher: ?*?*IWbemRefresher,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                lFlags: i32,
                ppRefresher: ?*?*IWbemRefresher,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRefreshableObject: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                pTemplate: ?*IWbemObjectAccess,
                pRefresher: ?*IWbemRefresher,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppRefreshable: ?*?*IWbemObjectAccess,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                pTemplate: ?*IWbemObjectAccess,
                pRefresher: ?*IWbemRefresher,
                lFlags: i32,
                pContext: ?*IWbemContext,
                ppRefreshable: ?*?*IWbemObjectAccess,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StopRefreshing: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfProvider,
                pRefresher: ?*IWbemRefresher,
                lId: i32,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfProvider,
                pRefresher: ?*IWbemRefresher,
                lId: i32,
                lFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRefreshableEnum: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                wszClass: ?[*:0]const u16,
                pRefresher: ?*IWbemRefresher,
                lFlags: i32,
                pContext: ?*IWbemContext,
                pHiPerfEnum: ?*IWbemHiPerfEnum,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                wszClass: ?[*:0]const u16,
                pRefresher: ?*IWbemRefresher,
                lFlags: i32,
                pContext: ?*IWbemContext,
                pHiPerfEnum: ?*IWbemHiPerfEnum,
                plId: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetObjects: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                lNumObjects: i32,
                apObj: [*]?*IWbemObjectAccess,
                lFlags: i32,
                pContext: ?*IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemHiPerfProvider,
                pNamespace: ?*IWbemServices,
                lNumObjects: i32,
                apObj: [*]?*IWbemObjectAccess,
                lFlags: i32,
                pContext: ?*IWbemContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfProvider_QueryInstances(self: *const T, pNamespace: ?*IWbemServices, wszClass: ?PWSTR, lFlags: i32, pCtx: ?*IWbemContext, pSink: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemHiPerfProvider.VTable, @ptrCast(self.vtable)).QueryInstances(@as(*const IWbemHiPerfProvider, @ptrCast(self)), pNamespace, wszClass, lFlags, pCtx, pSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfProvider_CreateRefresher(self: *const T, pNamespace: ?*IWbemServices, lFlags: i32, ppRefresher: ?*?*IWbemRefresher) HRESULT {
                return @as(*const IWbemHiPerfProvider.VTable, @ptrCast(self.vtable)).CreateRefresher(@as(*const IWbemHiPerfProvider, @ptrCast(self)), pNamespace, lFlags, ppRefresher);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfProvider_CreateRefreshableObject(self: *const T, pNamespace: ?*IWbemServices, pTemplate: ?*IWbemObjectAccess, pRefresher: ?*IWbemRefresher, lFlags: i32, pContext: ?*IWbemContext, ppRefreshable: ?*?*IWbemObjectAccess, plId: ?*i32) HRESULT {
                return @as(*const IWbemHiPerfProvider.VTable, @ptrCast(self.vtable)).CreateRefreshableObject(@as(*const IWbemHiPerfProvider, @ptrCast(self)), pNamespace, pTemplate, pRefresher, lFlags, pContext, ppRefreshable, plId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfProvider_StopRefreshing(self: *const T, pRefresher: ?*IWbemRefresher, lId: i32, lFlags: i32) HRESULT {
                return @as(*const IWbemHiPerfProvider.VTable, @ptrCast(self.vtable)).StopRefreshing(@as(*const IWbemHiPerfProvider, @ptrCast(self)), pRefresher, lId, lFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfProvider_CreateRefreshableEnum(self: *const T, pNamespace: ?*IWbemServices, wszClass: ?[*:0]const u16, pRefresher: ?*IWbemRefresher, lFlags: i32, pContext: ?*IWbemContext, pHiPerfEnum: ?*IWbemHiPerfEnum, plId: ?*i32) HRESULT {
                return @as(*const IWbemHiPerfProvider.VTable, @ptrCast(self.vtable)).CreateRefreshableEnum(@as(*const IWbemHiPerfProvider, @ptrCast(self)), pNamespace, wszClass, pRefresher, lFlags, pContext, pHiPerfEnum, plId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemHiPerfProvider_GetObjects(self: *const T, pNamespace: ?*IWbemServices, lNumObjects: i32, apObj: [*]?*IWbemObjectAccess, lFlags: i32, pContext: ?*IWbemContext) HRESULT {
                return @as(*const IWbemHiPerfProvider.VTable, @ptrCast(self.vtable)).GetObjects(@as(*const IWbemHiPerfProvider, @ptrCast(self)), pNamespace, lNumObjects, apObj, lFlags, pContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemDecoupledRegistrar_Value = Guid.initString("1005cbcf-e64f-4646-bcd3-3a089d8a84b4");
pub const IID_IWbemDecoupledRegistrar = &IID_IWbemDecoupledRegistrar_Value;
pub const IWbemDecoupledRegistrar = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Register: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemDecoupledRegistrar,
                a_Flags: i32,
                a_Context: ?*IWbemContext,
                a_User: ?[*:0]const u16,
                a_Locale: ?[*:0]const u16,
                a_Scope: ?[*:0]const u16,
                a_Registration: ?[*:0]const u16,
                pIUnknown: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemDecoupledRegistrar,
                a_Flags: i32,
                a_Context: ?*IWbemContext,
                a_User: ?[*:0]const u16,
                a_Locale: ?[*:0]const u16,
                a_Scope: ?[*:0]const u16,
                a_Registration: ?[*:0]const u16,
                pIUnknown: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnRegister: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemDecoupledRegistrar,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemDecoupledRegistrar,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemDecoupledRegistrar_Register(self: *const T, a_Flags: i32, a_Context: ?*IWbemContext, a_User: ?[*:0]const u16, a_Locale: ?[*:0]const u16, a_Scope: ?[*:0]const u16, a_Registration: ?[*:0]const u16, pIUnknown: ?*IUnknown) HRESULT {
                return @as(*const IWbemDecoupledRegistrar.VTable, @ptrCast(self.vtable)).Register(@as(*const IWbemDecoupledRegistrar, @ptrCast(self)), a_Flags, a_Context, a_User, a_Locale, a_Scope, a_Registration, pIUnknown);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemDecoupledRegistrar_UnRegister(self: *const T) HRESULT {
                return @as(*const IWbemDecoupledRegistrar.VTable, @ptrCast(self.vtable)).UnRegister(@as(*const IWbemDecoupledRegistrar, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemProviderIdentity_Value = Guid.initString("631f7d97-d993-11d2-b339-00105a1f4aaf");
pub const IID_IWbemProviderIdentity = &IID_IWbemProviderIdentity_Value;
pub const IWbemProviderIdentity = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetRegistrationObject: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemProviderIdentity,
                lFlags: i32,
                pProvReg: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemProviderIdentity,
                lFlags: i32,
                pProvReg: ?*IWbemClassObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemProviderIdentity_SetRegistrationObject(self: *const T, lFlags: i32, pProvReg: ?*IWbemClassObject) HRESULT {
                return @as(*const IWbemProviderIdentity.VTable, @ptrCast(self.vtable)).SetRegistrationObject(@as(*const IWbemProviderIdentity, @ptrCast(self)), lFlags, pProvReg);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WBEM_EXTRA_RETURN_CODES = enum(i32) {
    S_INITIALIZED = 0,
    S_LIMITED_SERVICE = 274433,
    S_INDIRECTLY_UPDATED = 274434,
    S_SUBJECT_TO_SDS = 274435,
    E_RETRY_LATER = -2147209215,
    E_RESOURCE_CONTENTION = -2147209214,
};
pub const WBEM_S_INITIALIZED = WBEM_EXTRA_RETURN_CODES.S_INITIALIZED;
pub const WBEM_S_LIMITED_SERVICE = WBEM_EXTRA_RETURN_CODES.S_LIMITED_SERVICE;
pub const WBEM_S_INDIRECTLY_UPDATED = WBEM_EXTRA_RETURN_CODES.S_INDIRECTLY_UPDATED;
pub const WBEM_S_SUBJECT_TO_SDS = WBEM_EXTRA_RETURN_CODES.S_SUBJECT_TO_SDS;
pub const WBEM_E_RETRY_LATER = WBEM_EXTRA_RETURN_CODES.E_RETRY_LATER;
pub const WBEM_E_RESOURCE_CONTENTION = WBEM_EXTRA_RETURN_CODES.E_RESOURCE_CONTENTION;

pub const WBEM_PROVIDER_FLAGS = enum(i32) {
    E = 65536,
};
pub const WBEM_FLAG_OWNER_UPDATE = WBEM_PROVIDER_FLAGS.E;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemDecoupledBasicEventProvider_Value = Guid.initString("86336d20-ca11-4786-9ef1-bc8a946b42fc");
pub const IID_IWbemDecoupledBasicEventProvider = &IID_IWbemDecoupledBasicEventProvider_Value;
pub const IWbemDecoupledBasicEventProvider = extern struct {
    pub const VTable = extern struct {
        base: IWbemDecoupledRegistrar.VTable,
        GetSink: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemDecoupledBasicEventProvider,
                a_Flags: i32,
                a_Context: ?*IWbemContext,
                a_Sink: ?*?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemDecoupledBasicEventProvider,
                a_Flags: i32,
                a_Context: ?*IWbemContext,
                a_Sink: ?*?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemDecoupledBasicEventProvider,
                a_Flags: i32,
                a_Context: ?*IWbemContext,
                a_Service: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemDecoupledBasicEventProvider,
                a_Flags: i32,
                a_Context: ?*IWbemContext,
                a_Service: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWbemDecoupledRegistrar.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemDecoupledBasicEventProvider_GetSink(self: *const T, a_Flags: i32, a_Context: ?*IWbemContext, a_Sink: ?*?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemDecoupledBasicEventProvider.VTable, @ptrCast(self.vtable)).GetSink(@as(*const IWbemDecoupledBasicEventProvider, @ptrCast(self)), a_Flags, a_Context, a_Sink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemDecoupledBasicEventProvider_GetService(self: *const T, a_Flags: i32, a_Context: ?*IWbemContext, a_Service: ?*?*IWbemServices) HRESULT {
                return @as(*const IWbemDecoupledBasicEventProvider.VTable, @ptrCast(self.vtable)).GetService(@as(*const IWbemDecoupledBasicEventProvider, @ptrCast(self)), a_Flags, a_Context, a_Service);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WBEM_BATCH_TYPE = enum(i32) {
    BATCH_IF_NEEDED = 0,
    MUST_BATCH = 1,
    MUST_NOT_BATCH = 2,
};
pub const WBEM_FLAG_BATCH_IF_NEEDED = WBEM_BATCH_TYPE.BATCH_IF_NEEDED;
pub const WBEM_FLAG_MUST_BATCH = WBEM_BATCH_TYPE.MUST_BATCH;
pub const WBEM_FLAG_MUST_NOT_BATCH = WBEM_BATCH_TYPE.MUST_NOT_BATCH;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWbemEventSink_Value = Guid.initString("3ae0080a-7e3a-4366-bf89-0feedc931659");
pub const IID_IWbemEventSink = &IID_IWbemEventSink_Value;
pub const IWbemEventSink = extern struct {
    pub const VTable = extern struct {
        base: IWbemObjectSink.VTable,
        SetSinkSecurity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventSink,
                lSDLength: i32,
                pSD: [*:0]u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventSink,
                lSDLength: i32,
                pSD: [*:0]u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsActive: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRestrictedSink: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventSink,
                lNumQueries: i32,
                awszQueries: [*]const ?[*:0]const u16,
                pCallback: ?*IUnknown,
                ppSink: ?*?*IWbemEventSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventSink,
                lNumQueries: i32,
                awszQueries: [*]const ?[*:0]const u16,
                pCallback: ?*IUnknown,
                ppSink: ?*?*IWbemEventSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBatchingParameters: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemEventSink,
                lFlags: i32,
                dwMaxBufferSize: u32,
                dwMaxSendLatency: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemEventSink,
                lFlags: i32,
                dwMaxBufferSize: u32,
                dwMaxSendLatency: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWbemObjectSink.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventSink_SetSinkSecurity(self: *const T, lSDLength: i32, pSD: [*:0]u8) HRESULT {
                return @as(*const IWbemEventSink.VTable, @ptrCast(self.vtable)).SetSinkSecurity(@as(*const IWbemEventSink, @ptrCast(self)), lSDLength, pSD);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventSink_IsActive(self: *const T) HRESULT {
                return @as(*const IWbemEventSink.VTable, @ptrCast(self.vtable)).IsActive(@as(*const IWbemEventSink, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventSink_GetRestrictedSink(self: *const T, lNumQueries: i32, awszQueries: [*]const ?[*:0]const u16, pCallback: ?*IUnknown, ppSink: ?*?*IWbemEventSink) HRESULT {
                return @as(*const IWbemEventSink.VTable, @ptrCast(self.vtable)).GetRestrictedSink(@as(*const IWbemEventSink, @ptrCast(self)), lNumQueries, awszQueries, pCallback, ppSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemEventSink_SetBatchingParameters(self: *const T, lFlags: i32, dwMaxBufferSize: u32, dwMaxSendLatency: u32) HRESULT {
                return @as(*const IWbemEventSink.VTable, @ptrCast(self.vtable)).SetBatchingParameters(@as(*const IWbemEventSink, @ptrCast(self)), lFlags, dwMaxBufferSize, dwMaxSendLatency);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const CLSID_SWbemLocator_Value = Guid.initString("76a64158-cb41-11d1-8b02-00600806d9b6");
pub const CLSID_SWbemLocator = &CLSID_SWbemLocator_Value;

const CLSID_SWbemNamedValueSet_Value = Guid.initString("9aed384e-ce8b-11d1-8b05-00600806d9b6");
pub const CLSID_SWbemNamedValueSet = &CLSID_SWbemNamedValueSet_Value;

const CLSID_SWbemObjectPath_Value = Guid.initString("5791bc26-ce9c-11d1-97bf-0000f81e849c");
pub const CLSID_SWbemObjectPath = &CLSID_SWbemObjectPath_Value;

const CLSID_SWbemLastError_Value = Guid.initString("c2feeeac-cfcd-11d1-8b05-00600806d9b6");
pub const CLSID_SWbemLastError = &CLSID_SWbemLastError_Value;

const CLSID_SWbemSink_Value = Guid.initString("75718c9a-f029-11d1-a1ac-00c04fb6c223");
pub const CLSID_SWbemSink = &CLSID_SWbemSink_Value;

const CLSID_SWbemDateTime_Value = Guid.initString("47dfbe54-cf76-11d3-b38f-00105a1f473a");
pub const CLSID_SWbemDateTime = &CLSID_SWbemDateTime_Value;

const CLSID_SWbemRefresher_Value = Guid.initString("d269bf5c-d9c1-11d3-b38f-00105a1f473a");
pub const CLSID_SWbemRefresher = &CLSID_SWbemRefresher_Value;

const CLSID_SWbemServices_Value = Guid.initString("04b83d63-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemServices = &CLSID_SWbemServices_Value;

const CLSID_SWbemServicesEx_Value = Guid.initString("62e522dc-8cf3-40a8-8b2e-37d595651e40");
pub const CLSID_SWbemServicesEx = &CLSID_SWbemServicesEx_Value;

const CLSID_SWbemObject_Value = Guid.initString("04b83d62-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemObject = &CLSID_SWbemObject_Value;

const CLSID_SWbemObjectEx_Value = Guid.initString("d6bdafb2-9435-491f-bb87-6aa0f0bc31a2");
pub const CLSID_SWbemObjectEx = &CLSID_SWbemObjectEx_Value;

const CLSID_SWbemObjectSet_Value = Guid.initString("04b83d61-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemObjectSet = &CLSID_SWbemObjectSet_Value;

const CLSID_SWbemNamedValue_Value = Guid.initString("04b83d60-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemNamedValue = &CLSID_SWbemNamedValue_Value;

const CLSID_SWbemQualifier_Value = Guid.initString("04b83d5f-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemQualifier = &CLSID_SWbemQualifier_Value;

const CLSID_SWbemQualifierSet_Value = Guid.initString("04b83d5e-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemQualifierSet = &CLSID_SWbemQualifierSet_Value;

const CLSID_SWbemProperty_Value = Guid.initString("04b83d5d-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemProperty = &CLSID_SWbemProperty_Value;

const CLSID_SWbemPropertySet_Value = Guid.initString("04b83d5c-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemPropertySet = &CLSID_SWbemPropertySet_Value;

const CLSID_SWbemMethod_Value = Guid.initString("04b83d5b-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemMethod = &CLSID_SWbemMethod_Value;

const CLSID_SWbemMethodSet_Value = Guid.initString("04b83d5a-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemMethodSet = &CLSID_SWbemMethodSet_Value;

const CLSID_SWbemEventSource_Value = Guid.initString("04b83d58-21ae-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemEventSource = &CLSID_SWbemEventSource_Value;

const CLSID_SWbemSecurity_Value = Guid.initString("b54d66e9-2287-11d2-8b33-00600806d9b6");
pub const CLSID_SWbemSecurity = &CLSID_SWbemSecurity_Value;

const CLSID_SWbemPrivilege_Value = Guid.initString("26ee67bc-5804-11d2-8b4a-00600806d9b6");
pub const CLSID_SWbemPrivilege = &CLSID_SWbemPrivilege_Value;

const CLSID_SWbemPrivilegeSet_Value = Guid.initString("26ee67be-5804-11d2-8b4a-00600806d9b6");
pub const CLSID_SWbemPrivilegeSet = &CLSID_SWbemPrivilegeSet_Value;

const CLSID_SWbemRefreshableItem_Value = Guid.initString("8c6854bc-de4b-11d3-b390-00105a1f473a");
pub const CLSID_SWbemRefreshableItem = &CLSID_SWbemRefreshableItem_Value;

pub const WbemChangeFlagEnum = enum(i32) {
    CreateOrUpdate = 0,
    UpdateOnly = 1,
    CreateOnly = 2,
    // UpdateCompatible = 0, this enum value conflicts with CreateOrUpdate
    UpdateSafeMode = 32,
    UpdateForceMode = 64,
    StrongValidation = 128,
    Advisory = 65536,
};
pub const wbemChangeFlagCreateOrUpdate = WbemChangeFlagEnum.CreateOrUpdate;
pub const wbemChangeFlagUpdateOnly = WbemChangeFlagEnum.UpdateOnly;
pub const wbemChangeFlagCreateOnly = WbemChangeFlagEnum.CreateOnly;
pub const wbemChangeFlagUpdateCompatible = WbemChangeFlagEnum.CreateOrUpdate;
pub const wbemChangeFlagUpdateSafeMode = WbemChangeFlagEnum.UpdateSafeMode;
pub const wbemChangeFlagUpdateForceMode = WbemChangeFlagEnum.UpdateForceMode;
pub const wbemChangeFlagStrongValidation = WbemChangeFlagEnum.StrongValidation;
pub const wbemChangeFlagAdvisory = WbemChangeFlagEnum.Advisory;

pub const WbemFlagEnum = enum(i32) {
    ReturnImmediately = 16,
    ReturnWhenComplete = 0,
    // Bidirectional = 0, this enum value conflicts with ReturnWhenComplete
    ForwardOnly = 32,
    NoErrorObject = 64,
    // ReturnErrorObject = 0, this enum value conflicts with ReturnWhenComplete
    SendStatus = 128,
    // DontSendStatus = 0, this enum value conflicts with ReturnWhenComplete
    EnsureLocatable = 256,
    DirectRead = 512,
    // SendOnlySelected = 0, this enum value conflicts with ReturnWhenComplete
    UseAmendedQualifiers = 131072,
    // GetDefault = 0, this enum value conflicts with ReturnWhenComplete
    SpawnInstance = 1,
    // UseCurrentTime = 1, this enum value conflicts with SpawnInstance
};
pub const wbemFlagReturnImmediately = WbemFlagEnum.ReturnImmediately;
pub const wbemFlagReturnWhenComplete = WbemFlagEnum.ReturnWhenComplete;
pub const wbemFlagBidirectional = WbemFlagEnum.ReturnWhenComplete;
pub const wbemFlagForwardOnly = WbemFlagEnum.ForwardOnly;
pub const wbemFlagNoErrorObject = WbemFlagEnum.NoErrorObject;
pub const wbemFlagReturnErrorObject = WbemFlagEnum.ReturnWhenComplete;
pub const wbemFlagSendStatus = WbemFlagEnum.SendStatus;
pub const wbemFlagDontSendStatus = WbemFlagEnum.ReturnWhenComplete;
pub const wbemFlagEnsureLocatable = WbemFlagEnum.EnsureLocatable;
pub const wbemFlagDirectRead = WbemFlagEnum.DirectRead;
pub const wbemFlagSendOnlySelected = WbemFlagEnum.ReturnWhenComplete;
pub const wbemFlagUseAmendedQualifiers = WbemFlagEnum.UseAmendedQualifiers;
pub const wbemFlagGetDefault = WbemFlagEnum.ReturnWhenComplete;
pub const wbemFlagSpawnInstance = WbemFlagEnum.SpawnInstance;
pub const wbemFlagUseCurrentTime = WbemFlagEnum.SpawnInstance;

pub const WbemQueryFlagEnum = enum(i32) {
    Deep = 0,
    Shallow = 1,
    Prototype = 2,
};
pub const wbemQueryFlagDeep = WbemQueryFlagEnum.Deep;
pub const wbemQueryFlagShallow = WbemQueryFlagEnum.Shallow;
pub const wbemQueryFlagPrototype = WbemQueryFlagEnum.Prototype;

pub const WbemTextFlagEnum = enum(i32) {
    s = 1,
};
pub const wbemTextFlagNoFlavors = WbemTextFlagEnum.s;

pub const WbemTimeout = enum(i32) {
    e = -1,
};
pub const wbemTimeoutInfinite = WbemTimeout.e;

pub const WbemComparisonFlagEnum = enum(i32) {
    ncludeAll = 0,
    gnoreQualifiers = 1,
    gnoreObjectSource = 2,
    gnoreDefaultValues = 4,
    gnoreClass = 8,
    gnoreCase = 16,
    gnoreFlavor = 32,
};
pub const wbemComparisonFlagIncludeAll = WbemComparisonFlagEnum.ncludeAll;
pub const wbemComparisonFlagIgnoreQualifiers = WbemComparisonFlagEnum.gnoreQualifiers;
pub const wbemComparisonFlagIgnoreObjectSource = WbemComparisonFlagEnum.gnoreObjectSource;
pub const wbemComparisonFlagIgnoreDefaultValues = WbemComparisonFlagEnum.gnoreDefaultValues;
pub const wbemComparisonFlagIgnoreClass = WbemComparisonFlagEnum.gnoreClass;
pub const wbemComparisonFlagIgnoreCase = WbemComparisonFlagEnum.gnoreCase;
pub const wbemComparisonFlagIgnoreFlavor = WbemComparisonFlagEnum.gnoreFlavor;

pub const WbemCimtypeEnum = enum(i32) {
    Sint8 = 16,
    Uint8 = 17,
    Sint16 = 2,
    Uint16 = 18,
    Sint32 = 3,
    Uint32 = 19,
    Sint64 = 20,
    Uint64 = 21,
    Real32 = 4,
    Real64 = 5,
    Boolean = 11,
    String = 8,
    Datetime = 101,
    Reference = 102,
    Char16 = 103,
    Object = 13,
};
pub const wbemCimtypeSint8 = WbemCimtypeEnum.Sint8;
pub const wbemCimtypeUint8 = WbemCimtypeEnum.Uint8;
pub const wbemCimtypeSint16 = WbemCimtypeEnum.Sint16;
pub const wbemCimtypeUint16 = WbemCimtypeEnum.Uint16;
pub const wbemCimtypeSint32 = WbemCimtypeEnum.Sint32;
pub const wbemCimtypeUint32 = WbemCimtypeEnum.Uint32;
pub const wbemCimtypeSint64 = WbemCimtypeEnum.Sint64;
pub const wbemCimtypeUint64 = WbemCimtypeEnum.Uint64;
pub const wbemCimtypeReal32 = WbemCimtypeEnum.Real32;
pub const wbemCimtypeReal64 = WbemCimtypeEnum.Real64;
pub const wbemCimtypeBoolean = WbemCimtypeEnum.Boolean;
pub const wbemCimtypeString = WbemCimtypeEnum.String;
pub const wbemCimtypeDatetime = WbemCimtypeEnum.Datetime;
pub const wbemCimtypeReference = WbemCimtypeEnum.Reference;
pub const wbemCimtypeChar16 = WbemCimtypeEnum.Char16;
pub const wbemCimtypeObject = WbemCimtypeEnum.Object;

pub const WbemErrorEnum = enum(i32) {
    NoErr = 0,
    ErrFailed = -2147217407,
    ErrNotFound = -2147217406,
    ErrAccessDenied = -2147217405,
    ErrProviderFailure = -2147217404,
    ErrTypeMismatch = -2147217403,
    ErrOutOfMemory = -2147217402,
    ErrInvalidContext = -2147217401,
    ErrInvalidParameter = -2147217400,
    ErrNotAvailable = -2147217399,
    ErrCriticalError = -2147217398,
    ErrInvalidStream = -2147217397,
    ErrNotSupported = -2147217396,
    ErrInvalidSuperclass = -2147217395,
    ErrInvalidNamespace = -2147217394,
    ErrInvalidObject = -2147217393,
    ErrInvalidClass = -2147217392,
    ErrProviderNotFound = -2147217391,
    ErrInvalidProviderRegistration = -2147217390,
    ErrProviderLoadFailure = -2147217389,
    ErrInitializationFailure = -2147217388,
    ErrTransportFailure = -2147217387,
    ErrInvalidOperation = -2147217386,
    ErrInvalidQuery = -2147217385,
    ErrInvalidQueryType = -2147217384,
    ErrAlreadyExists = -2147217383,
    ErrOverrideNotAllowed = -2147217382,
    ErrPropagatedQualifier = -2147217381,
    ErrPropagatedProperty = -2147217380,
    ErrUnexpected = -2147217379,
    ErrIllegalOperation = -2147217378,
    ErrCannotBeKey = -2147217377,
    ErrIncompleteClass = -2147217376,
    ErrInvalidSyntax = -2147217375,
    ErrNondecoratedObject = -2147217374,
    ErrReadOnly = -2147217373,
    ErrProviderNotCapable = -2147217372,
    ErrClassHasChildren = -2147217371,
    ErrClassHasInstances = -2147217370,
    ErrQueryNotImplemented = -2147217369,
    ErrIllegalNull = -2147217368,
    ErrInvalidQualifierType = -2147217367,
    ErrInvalidPropertyType = -2147217366,
    ErrValueOutOfRange = -2147217365,
    ErrCannotBeSingleton = -2147217364,
    ErrInvalidCimType = -2147217363,
    ErrInvalidMethod = -2147217362,
    ErrInvalidMethodParameters = -2147217361,
    ErrSystemProperty = -2147217360,
    ErrInvalidProperty = -2147217359,
    ErrCallCancelled = -2147217358,
    ErrShuttingDown = -2147217357,
    ErrPropagatedMethod = -2147217356,
    ErrUnsupportedParameter = -2147217355,
    ErrMissingParameter = -2147217354,
    ErrInvalidParameterId = -2147217353,
    ErrNonConsecutiveParameterIds = -2147217352,
    ErrParameterIdOnRetval = -2147217351,
    ErrInvalidObjectPath = -2147217350,
    ErrOutOfDiskSpace = -2147217349,
    ErrBufferTooSmall = -2147217348,
    ErrUnsupportedPutExtension = -2147217347,
    ErrUnknownObjectType = -2147217346,
    ErrUnknownPacketType = -2147217345,
    ErrMarshalVersionMismatch = -2147217344,
    ErrMarshalInvalidSignature = -2147217343,
    ErrInvalidQualifier = -2147217342,
    ErrInvalidDuplicateParameter = -2147217341,
    ErrTooMuchData = -2147217340,
    ErrServerTooBusy = -2147217339,
    ErrInvalidFlavor = -2147217338,
    ErrCircularReference = -2147217337,
    ErrUnsupportedClassUpdate = -2147217336,
    ErrCannotChangeKeyInheritance = -2147217335,
    ErrCannotChangeIndexInheritance = -2147217328,
    ErrTooManyProperties = -2147217327,
    ErrUpdateTypeMismatch = -2147217326,
    ErrUpdateOverrideNotAllowed = -2147217325,
    ErrUpdatePropagatedMethod = -2147217324,
    ErrMethodNotImplemented = -2147217323,
    ErrMethodDisabled = -2147217322,
    ErrRefresherBusy = -2147217321,
    ErrUnparsableQuery = -2147217320,
    ErrNotEventClass = -2147217319,
    ErrMissingGroupWithin = -2147217318,
    ErrMissingAggregationList = -2147217317,
    ErrPropertyNotAnObject = -2147217316,
    ErrAggregatingByObject = -2147217315,
    ErrUninterpretableProviderQuery = -2147217313,
    ErrBackupRestoreWinmgmtRunning = -2147217312,
    ErrQueueOverflow = -2147217311,
    ErrPrivilegeNotHeld = -2147217310,
    ErrInvalidOperator = -2147217309,
    ErrLocalCredentials = -2147217308,
    ErrCannotBeAbstract = -2147217307,
    ErrAmendedObject = -2147217306,
    ErrClientTooSlow = -2147217305,
    ErrNullSecurityDescriptor = -2147217304,
    ErrTimeout = -2147217303,
    ErrInvalidAssociation = -2147217302,
    ErrAmbiguousOperation = -2147217301,
    ErrQuotaViolation = -2147217300,
    ErrTransactionConflict = -2147217299,
    ErrForcedRollback = -2147217298,
    ErrUnsupportedLocale = -2147217297,
    ErrHandleOutOfDate = -2147217296,
    ErrConnectionFailed = -2147217295,
    ErrInvalidHandleRequest = -2147217294,
    ErrPropertyNameTooWide = -2147217293,
    ErrClassNameTooWide = -2147217292,
    ErrMethodNameTooWide = -2147217291,
    ErrQualifierNameTooWide = -2147217290,
    ErrRerunCommand = -2147217289,
    ErrDatabaseVerMismatch = -2147217288,
    ErrVetoPut = -2147217287,
    ErrVetoDelete = -2147217286,
    ErrInvalidLocale = -2147217280,
    ErrProviderSuspended = -2147217279,
    ErrSynchronizationRequired = -2147217278,
    ErrNoSchema = -2147217277,
    ErrProviderAlreadyRegistered = -2147217276,
    ErrProviderNotRegistered = -2147217275,
    ErrFatalTransportError = -2147217274,
    ErrEncryptedConnectionRequired = -2147217273,
    ErrRegistrationTooBroad = -2147213311,
    ErrRegistrationTooPrecise = -2147213310,
    ErrTimedout = -2147209215,
    ErrResetToDefault = -2147209214,
};
pub const wbemNoErr = WbemErrorEnum.NoErr;
pub const wbemErrFailed = WbemErrorEnum.ErrFailed;
pub const wbemErrNotFound = WbemErrorEnum.ErrNotFound;
pub const wbemErrAccessDenied = WbemErrorEnum.ErrAccessDenied;
pub const wbemErrProviderFailure = WbemErrorEnum.ErrProviderFailure;
pub const wbemErrTypeMismatch = WbemErrorEnum.ErrTypeMismatch;
pub const wbemErrOutOfMemory = WbemErrorEnum.ErrOutOfMemory;
pub const wbemErrInvalidContext = WbemErrorEnum.ErrInvalidContext;
pub const wbemErrInvalidParameter = WbemErrorEnum.ErrInvalidParameter;
pub const wbemErrNotAvailable = WbemErrorEnum.ErrNotAvailable;
pub const wbemErrCriticalError = WbemErrorEnum.ErrCriticalError;
pub const wbemErrInvalidStream = WbemErrorEnum.ErrInvalidStream;
pub const wbemErrNotSupported = WbemErrorEnum.ErrNotSupported;
pub const wbemErrInvalidSuperclass = WbemErrorEnum.ErrInvalidSuperclass;
pub const wbemErrInvalidNamespace = WbemErrorEnum.ErrInvalidNamespace;
pub const wbemErrInvalidObject = WbemErrorEnum.ErrInvalidObject;
pub const wbemErrInvalidClass = WbemErrorEnum.ErrInvalidClass;
pub const wbemErrProviderNotFound = WbemErrorEnum.ErrProviderNotFound;
pub const wbemErrInvalidProviderRegistration = WbemErrorEnum.ErrInvalidProviderRegistration;
pub const wbemErrProviderLoadFailure = WbemErrorEnum.ErrProviderLoadFailure;
pub const wbemErrInitializationFailure = WbemErrorEnum.ErrInitializationFailure;
pub const wbemErrTransportFailure = WbemErrorEnum.ErrTransportFailure;
pub const wbemErrInvalidOperation = WbemErrorEnum.ErrInvalidOperation;
pub const wbemErrInvalidQuery = WbemErrorEnum.ErrInvalidQuery;
pub const wbemErrInvalidQueryType = WbemErrorEnum.ErrInvalidQueryType;
pub const wbemErrAlreadyExists = WbemErrorEnum.ErrAlreadyExists;
pub const wbemErrOverrideNotAllowed = WbemErrorEnum.ErrOverrideNotAllowed;
pub const wbemErrPropagatedQualifier = WbemErrorEnum.ErrPropagatedQualifier;
pub const wbemErrPropagatedProperty = WbemErrorEnum.ErrPropagatedProperty;
pub const wbemErrUnexpected = WbemErrorEnum.ErrUnexpected;
pub const wbemErrIllegalOperation = WbemErrorEnum.ErrIllegalOperation;
pub const wbemErrCannotBeKey = WbemErrorEnum.ErrCannotBeKey;
pub const wbemErrIncompleteClass = WbemErrorEnum.ErrIncompleteClass;
pub const wbemErrInvalidSyntax = WbemErrorEnum.ErrInvalidSyntax;
pub const wbemErrNondecoratedObject = WbemErrorEnum.ErrNondecoratedObject;
pub const wbemErrReadOnly = WbemErrorEnum.ErrReadOnly;
pub const wbemErrProviderNotCapable = WbemErrorEnum.ErrProviderNotCapable;
pub const wbemErrClassHasChildren = WbemErrorEnum.ErrClassHasChildren;
pub const wbemErrClassHasInstances = WbemErrorEnum.ErrClassHasInstances;
pub const wbemErrQueryNotImplemented = WbemErrorEnum.ErrQueryNotImplemented;
pub const wbemErrIllegalNull = WbemErrorEnum.ErrIllegalNull;
pub const wbemErrInvalidQualifierType = WbemErrorEnum.ErrInvalidQualifierType;
pub const wbemErrInvalidPropertyType = WbemErrorEnum.ErrInvalidPropertyType;
pub const wbemErrValueOutOfRange = WbemErrorEnum.ErrValueOutOfRange;
pub const wbemErrCannotBeSingleton = WbemErrorEnum.ErrCannotBeSingleton;
pub const wbemErrInvalidCimType = WbemErrorEnum.ErrInvalidCimType;
pub const wbemErrInvalidMethod = WbemErrorEnum.ErrInvalidMethod;
pub const wbemErrInvalidMethodParameters = WbemErrorEnum.ErrInvalidMethodParameters;
pub const wbemErrSystemProperty = WbemErrorEnum.ErrSystemProperty;
pub const wbemErrInvalidProperty = WbemErrorEnum.ErrInvalidProperty;
pub const wbemErrCallCancelled = WbemErrorEnum.ErrCallCancelled;
pub const wbemErrShuttingDown = WbemErrorEnum.ErrShuttingDown;
pub const wbemErrPropagatedMethod = WbemErrorEnum.ErrPropagatedMethod;
pub const wbemErrUnsupportedParameter = WbemErrorEnum.ErrUnsupportedParameter;
pub const wbemErrMissingParameter = WbemErrorEnum.ErrMissingParameter;
pub const wbemErrInvalidParameterId = WbemErrorEnum.ErrInvalidParameterId;
pub const wbemErrNonConsecutiveParameterIds = WbemErrorEnum.ErrNonConsecutiveParameterIds;
pub const wbemErrParameterIdOnRetval = WbemErrorEnum.ErrParameterIdOnRetval;
pub const wbemErrInvalidObjectPath = WbemErrorEnum.ErrInvalidObjectPath;
pub const wbemErrOutOfDiskSpace = WbemErrorEnum.ErrOutOfDiskSpace;
pub const wbemErrBufferTooSmall = WbemErrorEnum.ErrBufferTooSmall;
pub const wbemErrUnsupportedPutExtension = WbemErrorEnum.ErrUnsupportedPutExtension;
pub const wbemErrUnknownObjectType = WbemErrorEnum.ErrUnknownObjectType;
pub const wbemErrUnknownPacketType = WbemErrorEnum.ErrUnknownPacketType;
pub const wbemErrMarshalVersionMismatch = WbemErrorEnum.ErrMarshalVersionMismatch;
pub const wbemErrMarshalInvalidSignature = WbemErrorEnum.ErrMarshalInvalidSignature;
pub const wbemErrInvalidQualifier = WbemErrorEnum.ErrInvalidQualifier;
pub const wbemErrInvalidDuplicateParameter = WbemErrorEnum.ErrInvalidDuplicateParameter;
pub const wbemErrTooMuchData = WbemErrorEnum.ErrTooMuchData;
pub const wbemErrServerTooBusy = WbemErrorEnum.ErrServerTooBusy;
pub const wbemErrInvalidFlavor = WbemErrorEnum.ErrInvalidFlavor;
pub const wbemErrCircularReference = WbemErrorEnum.ErrCircularReference;
pub const wbemErrUnsupportedClassUpdate = WbemErrorEnum.ErrUnsupportedClassUpdate;
pub const wbemErrCannotChangeKeyInheritance = WbemErrorEnum.ErrCannotChangeKeyInheritance;
pub const wbemErrCannotChangeIndexInheritance = WbemErrorEnum.ErrCannotChangeIndexInheritance;
pub const wbemErrTooManyProperties = WbemErrorEnum.ErrTooManyProperties;
pub const wbemErrUpdateTypeMismatch = WbemErrorEnum.ErrUpdateTypeMismatch;
pub const wbemErrUpdateOverrideNotAllowed = WbemErrorEnum.ErrUpdateOverrideNotAllowed;
pub const wbemErrUpdatePropagatedMethod = WbemErrorEnum.ErrUpdatePropagatedMethod;
pub const wbemErrMethodNotImplemented = WbemErrorEnum.ErrMethodNotImplemented;
pub const wbemErrMethodDisabled = WbemErrorEnum.ErrMethodDisabled;
pub const wbemErrRefresherBusy = WbemErrorEnum.ErrRefresherBusy;
pub const wbemErrUnparsableQuery = WbemErrorEnum.ErrUnparsableQuery;
pub const wbemErrNotEventClass = WbemErrorEnum.ErrNotEventClass;
pub const wbemErrMissingGroupWithin = WbemErrorEnum.ErrMissingGroupWithin;
pub const wbemErrMissingAggregationList = WbemErrorEnum.ErrMissingAggregationList;
pub const wbemErrPropertyNotAnObject = WbemErrorEnum.ErrPropertyNotAnObject;
pub const wbemErrAggregatingByObject = WbemErrorEnum.ErrAggregatingByObject;
pub const wbemErrUninterpretableProviderQuery = WbemErrorEnum.ErrUninterpretableProviderQuery;
pub const wbemErrBackupRestoreWinmgmtRunning = WbemErrorEnum.ErrBackupRestoreWinmgmtRunning;
pub const wbemErrQueueOverflow = WbemErrorEnum.ErrQueueOverflow;
pub const wbemErrPrivilegeNotHeld = WbemErrorEnum.ErrPrivilegeNotHeld;
pub const wbemErrInvalidOperator = WbemErrorEnum.ErrInvalidOperator;
pub const wbemErrLocalCredentials = WbemErrorEnum.ErrLocalCredentials;
pub const wbemErrCannotBeAbstract = WbemErrorEnum.ErrCannotBeAbstract;
pub const wbemErrAmendedObject = WbemErrorEnum.ErrAmendedObject;
pub const wbemErrClientTooSlow = WbemErrorEnum.ErrClientTooSlow;
pub const wbemErrNullSecurityDescriptor = WbemErrorEnum.ErrNullSecurityDescriptor;
pub const wbemErrTimeout = WbemErrorEnum.ErrTimeout;
pub const wbemErrInvalidAssociation = WbemErrorEnum.ErrInvalidAssociation;
pub const wbemErrAmbiguousOperation = WbemErrorEnum.ErrAmbiguousOperation;
pub const wbemErrQuotaViolation = WbemErrorEnum.ErrQuotaViolation;
pub const wbemErrTransactionConflict = WbemErrorEnum.ErrTransactionConflict;
pub const wbemErrForcedRollback = WbemErrorEnum.ErrForcedRollback;
pub const wbemErrUnsupportedLocale = WbemErrorEnum.ErrUnsupportedLocale;
pub const wbemErrHandleOutOfDate = WbemErrorEnum.ErrHandleOutOfDate;
pub const wbemErrConnectionFailed = WbemErrorEnum.ErrConnectionFailed;
pub const wbemErrInvalidHandleRequest = WbemErrorEnum.ErrInvalidHandleRequest;
pub const wbemErrPropertyNameTooWide = WbemErrorEnum.ErrPropertyNameTooWide;
pub const wbemErrClassNameTooWide = WbemErrorEnum.ErrClassNameTooWide;
pub const wbemErrMethodNameTooWide = WbemErrorEnum.ErrMethodNameTooWide;
pub const wbemErrQualifierNameTooWide = WbemErrorEnum.ErrQualifierNameTooWide;
pub const wbemErrRerunCommand = WbemErrorEnum.ErrRerunCommand;
pub const wbemErrDatabaseVerMismatch = WbemErrorEnum.ErrDatabaseVerMismatch;
pub const wbemErrVetoPut = WbemErrorEnum.ErrVetoPut;
pub const wbemErrVetoDelete = WbemErrorEnum.ErrVetoDelete;
pub const wbemErrInvalidLocale = WbemErrorEnum.ErrInvalidLocale;
pub const wbemErrProviderSuspended = WbemErrorEnum.ErrProviderSuspended;
pub const wbemErrSynchronizationRequired = WbemErrorEnum.ErrSynchronizationRequired;
pub const wbemErrNoSchema = WbemErrorEnum.ErrNoSchema;
pub const wbemErrProviderAlreadyRegistered = WbemErrorEnum.ErrProviderAlreadyRegistered;
pub const wbemErrProviderNotRegistered = WbemErrorEnum.ErrProviderNotRegistered;
pub const wbemErrFatalTransportError = WbemErrorEnum.ErrFatalTransportError;
pub const wbemErrEncryptedConnectionRequired = WbemErrorEnum.ErrEncryptedConnectionRequired;
pub const wbemErrRegistrationTooBroad = WbemErrorEnum.ErrRegistrationTooBroad;
pub const wbemErrRegistrationTooPrecise = WbemErrorEnum.ErrRegistrationTooPrecise;
pub const wbemErrTimedout = WbemErrorEnum.ErrTimedout;
pub const wbemErrResetToDefault = WbemErrorEnum.ErrResetToDefault;

pub const WbemAuthenticationLevelEnum = enum(i32) {
    Default = 0,
    None = 1,
    Connect = 2,
    Call = 3,
    Pkt = 4,
    PktIntegrity = 5,
    PktPrivacy = 6,
};
pub const wbemAuthenticationLevelDefault = WbemAuthenticationLevelEnum.Default;
pub const wbemAuthenticationLevelNone = WbemAuthenticationLevelEnum.None;
pub const wbemAuthenticationLevelConnect = WbemAuthenticationLevelEnum.Connect;
pub const wbemAuthenticationLevelCall = WbemAuthenticationLevelEnum.Call;
pub const wbemAuthenticationLevelPkt = WbemAuthenticationLevelEnum.Pkt;
pub const wbemAuthenticationLevelPktIntegrity = WbemAuthenticationLevelEnum.PktIntegrity;
pub const wbemAuthenticationLevelPktPrivacy = WbemAuthenticationLevelEnum.PktPrivacy;

pub const WbemImpersonationLevelEnum = enum(i32) {
    Anonymous = 1,
    Identify = 2,
    Impersonate = 3,
    Delegate = 4,
};
pub const wbemImpersonationLevelAnonymous = WbemImpersonationLevelEnum.Anonymous;
pub const wbemImpersonationLevelIdentify = WbemImpersonationLevelEnum.Identify;
pub const wbemImpersonationLevelImpersonate = WbemImpersonationLevelEnum.Impersonate;
pub const wbemImpersonationLevelDelegate = WbemImpersonationLevelEnum.Delegate;

pub const WbemPrivilegeEnum = enum(i32) {
    CreateToken = 1,
    PrimaryToken = 2,
    LockMemory = 3,
    IncreaseQuota = 4,
    MachineAccount = 5,
    Tcb = 6,
    Security = 7,
    TakeOwnership = 8,
    LoadDriver = 9,
    SystemProfile = 10,
    Systemtime = 11,
    ProfileSingleProcess = 12,
    IncreaseBasePriority = 13,
    CreatePagefile = 14,
    CreatePermanent = 15,
    Backup = 16,
    Restore = 17,
    Shutdown = 18,
    Debug = 19,
    Audit = 20,
    SystemEnvironment = 21,
    ChangeNotify = 22,
    RemoteShutdown = 23,
    Undock = 24,
    SyncAgent = 25,
    EnableDelegation = 26,
    ManageVolume = 27,
};
pub const wbemPrivilegeCreateToken = WbemPrivilegeEnum.CreateToken;
pub const wbemPrivilegePrimaryToken = WbemPrivilegeEnum.PrimaryToken;
pub const wbemPrivilegeLockMemory = WbemPrivilegeEnum.LockMemory;
pub const wbemPrivilegeIncreaseQuota = WbemPrivilegeEnum.IncreaseQuota;
pub const wbemPrivilegeMachineAccount = WbemPrivilegeEnum.MachineAccount;
pub const wbemPrivilegeTcb = WbemPrivilegeEnum.Tcb;
pub const wbemPrivilegeSecurity = WbemPrivilegeEnum.Security;
pub const wbemPrivilegeTakeOwnership = WbemPrivilegeEnum.TakeOwnership;
pub const wbemPrivilegeLoadDriver = WbemPrivilegeEnum.LoadDriver;
pub const wbemPrivilegeSystemProfile = WbemPrivilegeEnum.SystemProfile;
pub const wbemPrivilegeSystemtime = WbemPrivilegeEnum.Systemtime;
pub const wbemPrivilegeProfileSingleProcess = WbemPrivilegeEnum.ProfileSingleProcess;
pub const wbemPrivilegeIncreaseBasePriority = WbemPrivilegeEnum.IncreaseBasePriority;
pub const wbemPrivilegeCreatePagefile = WbemPrivilegeEnum.CreatePagefile;
pub const wbemPrivilegeCreatePermanent = WbemPrivilegeEnum.CreatePermanent;
pub const wbemPrivilegeBackup = WbemPrivilegeEnum.Backup;
pub const wbemPrivilegeRestore = WbemPrivilegeEnum.Restore;
pub const wbemPrivilegeShutdown = WbemPrivilegeEnum.Shutdown;
pub const wbemPrivilegeDebug = WbemPrivilegeEnum.Debug;
pub const wbemPrivilegeAudit = WbemPrivilegeEnum.Audit;
pub const wbemPrivilegeSystemEnvironment = WbemPrivilegeEnum.SystemEnvironment;
pub const wbemPrivilegeChangeNotify = WbemPrivilegeEnum.ChangeNotify;
pub const wbemPrivilegeRemoteShutdown = WbemPrivilegeEnum.RemoteShutdown;
pub const wbemPrivilegeUndock = WbemPrivilegeEnum.Undock;
pub const wbemPrivilegeSyncAgent = WbemPrivilegeEnum.SyncAgent;
pub const wbemPrivilegeEnableDelegation = WbemPrivilegeEnum.EnableDelegation;
pub const wbemPrivilegeManageVolume = WbemPrivilegeEnum.ManageVolume;

pub const WbemObjectTextFormatEnum = enum(i32) {
    CIMDTD20 = 1,
    WMIDTD20 = 2,
};
pub const wbemObjectTextFormatCIMDTD20 = WbemObjectTextFormatEnum.CIMDTD20;
pub const wbemObjectTextFormatWMIDTD20 = WbemObjectTextFormatEnum.WMIDTD20;

pub const WbemConnectOptionsEnum = enum(i32) {
    t = 128,
};
pub const wbemConnectFlagUseMaxWait = WbemConnectOptionsEnum.t;

const IID_ISWbemServices_Value = Guid.initString("76a6415c-cb41-11d1-8b02-00600806d9b6");
pub const IID_ISWbemServices = &IID_ISWbemServices_Value;
pub const ISWbemServices = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        Get: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Delete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InstancesOf: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strClass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strClass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InstancesOfAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strClass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strClass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SubclassesOf: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strSuperclass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strSuperclass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SubclassesOfAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strSuperclass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strSuperclass: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecQuery: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecQueryAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                lFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                lFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AssociatorsOf: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AssociatorsOfAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReferencesTo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReferencesToAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecNotificationQuery: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemEventSource: ?*?*ISWbemEventSource,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemEventSource: ?*?*ISWbemEventSource,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecNotificationQueryAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strQuery: ?BSTR,
                strQueryLanguage: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecMethod: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemOutParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemOutParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecMethodAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSink: ?*IDispatch,
                strObjectPath: ?BSTR,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Security_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemServices,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemServices,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_Get(self: *const T, strObjectPath: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).Get(@as(*const ISWbemServices, @ptrCast(self)), strObjectPath, iFlags, objWbemNamedValueSet, objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_GetAsync(self: *const T, objWbemSink: ?*IDispatch, strObjectPath: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).GetAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strObjectPath, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_Delete(self: *const T, strObjectPath: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).Delete(@as(*const ISWbemServices, @ptrCast(self)), strObjectPath, iFlags, objWbemNamedValueSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_DeleteAsync(self: *const T, objWbemSink: ?*IDispatch, strObjectPath: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).DeleteAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strObjectPath, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_InstancesOf(self: *const T, strClass: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).InstancesOf(@as(*const ISWbemServices, @ptrCast(self)), strClass, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_InstancesOfAsync(self: *const T, objWbemSink: ?*IDispatch, strClass: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).InstancesOfAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strClass, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_SubclassesOf(self: *const T, strSuperclass: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).SubclassesOf(@as(*const ISWbemServices, @ptrCast(self)), strSuperclass, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_SubclassesOfAsync(self: *const T, objWbemSink: ?*IDispatch, strSuperclass: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).SubclassesOfAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strSuperclass, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ExecQuery(self: *const T, strQuery: ?BSTR, strQueryLanguage: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ExecQuery(@as(*const ISWbemServices, @ptrCast(self)), strQuery, strQueryLanguage, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ExecQueryAsync(self: *const T, objWbemSink: ?*IDispatch, strQuery: ?BSTR, strQueryLanguage: ?BSTR, lFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ExecQueryAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strQuery, strQueryLanguage, lFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_AssociatorsOf(self: *const T, strObjectPath: ?BSTR, strAssocClass: ?BSTR, strResultClass: ?BSTR, strResultRole: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredAssocQualifier: ?BSTR, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).AssociatorsOf(@as(*const ISWbemServices, @ptrCast(self)), strObjectPath, strAssocClass, strResultClass, strResultRole, strRole, bClassesOnly, bSchemaOnly, strRequiredAssocQualifier, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_AssociatorsOfAsync(self: *const T, objWbemSink: ?*IDispatch, strObjectPath: ?BSTR, strAssocClass: ?BSTR, strResultClass: ?BSTR, strResultRole: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredAssocQualifier: ?BSTR, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).AssociatorsOfAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strObjectPath, strAssocClass, strResultClass, strResultRole, strRole, bClassesOnly, bSchemaOnly, strRequiredAssocQualifier, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ReferencesTo(self: *const T, strObjectPath: ?BSTR, strResultClass: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ReferencesTo(@as(*const ISWbemServices, @ptrCast(self)), strObjectPath, strResultClass, strRole, bClassesOnly, bSchemaOnly, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ReferencesToAsync(self: *const T, objWbemSink: ?*IDispatch, strObjectPath: ?BSTR, strResultClass: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ReferencesToAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strObjectPath, strResultClass, strRole, bClassesOnly, bSchemaOnly, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ExecNotificationQuery(self: *const T, strQuery: ?BSTR, strQueryLanguage: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemEventSource: ?*?*ISWbemEventSource) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ExecNotificationQuery(@as(*const ISWbemServices, @ptrCast(self)), strQuery, strQueryLanguage, iFlags, objWbemNamedValueSet, objWbemEventSource);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ExecNotificationQueryAsync(self: *const T, objWbemSink: ?*IDispatch, strQuery: ?BSTR, strQueryLanguage: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ExecNotificationQueryAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strQuery, strQueryLanguage, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ExecMethod(self: *const T, strObjectPath: ?BSTR, strMethodName: ?BSTR, objWbemInParameters: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemOutParameters: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ExecMethod(@as(*const ISWbemServices, @ptrCast(self)), strObjectPath, strMethodName, objWbemInParameters, iFlags, objWbemNamedValueSet, objWbemOutParameters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_ExecMethodAsync(self: *const T, objWbemSink: ?*IDispatch, strObjectPath: ?BSTR, strMethodName: ?BSTR, objWbemInParameters: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).ExecMethodAsync(@as(*const ISWbemServices, @ptrCast(self)), objWbemSink, strObjectPath, strMethodName, objWbemInParameters, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServices_get_Security_(self: *const T, objWbemSecurity: ?*?*ISWbemSecurity) HRESULT {
                return @as(*const ISWbemServices.VTable, @ptrCast(self.vtable)).get_Security_(@as(*const ISWbemServices, @ptrCast(self)), objWbemSecurity);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemLocator_Value = Guid.initString("76a6415b-cb41-11d1-8b02-00600806d9b6");
pub const IID_ISWbemLocator = &IID_ISWbemLocator_Value;
pub const ISWbemLocator = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        ConnectServer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemLocator,
                strServer: ?BSTR,
                strNamespace: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                strAuthority: ?BSTR,
                iSecurityFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemServices: ?*?*ISWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemLocator,
                strServer: ?BSTR,
                strNamespace: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                strAuthority: ?BSTR,
                iSecurityFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemServices: ?*?*ISWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Security_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemLocator,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemLocator,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemLocator_ConnectServer(self: *const T, strServer: ?BSTR, strNamespace: ?BSTR, strUser: ?BSTR, strPassword: ?BSTR, strLocale: ?BSTR, strAuthority: ?BSTR, iSecurityFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemServices: ?*?*ISWbemServices) HRESULT {
                return @as(*const ISWbemLocator.VTable, @ptrCast(self.vtable)).ConnectServer(@as(*const ISWbemLocator, @ptrCast(self)), strServer, strNamespace, strUser, strPassword, strLocale, strAuthority, iSecurityFlags, objWbemNamedValueSet, objWbemServices);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemLocator_get_Security_(self: *const T, objWbemSecurity: ?*?*ISWbemSecurity) HRESULT {
                return @as(*const ISWbemLocator.VTable, @ptrCast(self.vtable)).get_Security_(@as(*const ISWbemLocator, @ptrCast(self)), objWbemSecurity);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemObject_Value = Guid.initString("76a6415a-cb41-11d1-8b02-00600806d9b6");
pub const IID_ISWbemObject = &IID_ISWbemObject_Value;
pub const ISWbemObject = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        Put_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectPath: ?*?*ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectPath: ?*?*ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Delete_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Instances_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InstancesAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Subclasses_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SubclassesAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Associators_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AssociatorsAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                strAssocClass: ?BSTR,
                strResultClass: ?BSTR,
                strResultRole: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredAssocQualifier: ?BSTR,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        References_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReferencesAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                strResultClass: ?BSTR,
                strRole: ?BSTR,
                bClassesOnly: i16,
                bSchemaOnly: i16,
                strRequiredQualifier: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecMethod_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemOutParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemOutParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ExecMethodAsync_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSink: ?*IDispatch,
                strMethodName: ?BSTR,
                objWbemInParameters: ?*IDispatch,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetObjectText_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                strObjectText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                strObjectText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SpawnDerivedClass_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SpawnInstance_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                iFlags: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CompareTo_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemObject: ?*IDispatch,
                iFlags: i32,
                bResult: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObject,
                objWbemObject: ?*IDispatch,
                iFlags: i32,
                bResult: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Qualifiers_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemQualifierSet: ?*?*ISWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObject,
                objWbemQualifierSet: ?*?*ISWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Properties_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemPropertySet: ?*?*ISWbemPropertySet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObject,
                objWbemPropertySet: ?*?*ISWbemPropertySet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Methods_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemMethodSet: ?*?*ISWbemMethodSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObject,
                objWbemMethodSet: ?*?*ISWbemMethodSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Derivation_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObject,
                strClassNameArray: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObject,
                strClassNameArray: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Path_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemObjectPath: ?*?*ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObject,
                objWbemObjectPath: ?*?*ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Security_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObject,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObject,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_Put_(self: *const T, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectPath: ?*?*ISWbemObjectPath) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).Put_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, objWbemNamedValueSet, objWbemObjectPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_PutAsync_(self: *const T, objWbemSink: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).PutAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_Delete_(self: *const T, iFlags: i32, objWbemNamedValueSet: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).Delete_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, objWbemNamedValueSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_DeleteAsync_(self: *const T, objWbemSink: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).DeleteAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_Instances_(self: *const T, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).Instances_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_InstancesAsync_(self: *const T, objWbemSink: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).InstancesAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_Subclasses_(self: *const T, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).Subclasses_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_SubclassesAsync_(self: *const T, objWbemSink: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).SubclassesAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_Associators_(self: *const T, strAssocClass: ?BSTR, strResultClass: ?BSTR, strResultRole: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredAssocQualifier: ?BSTR, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).Associators_(@as(*const ISWbemObject, @ptrCast(self)), strAssocClass, strResultClass, strResultRole, strRole, bClassesOnly, bSchemaOnly, strRequiredAssocQualifier, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_AssociatorsAsync_(self: *const T, objWbemSink: ?*IDispatch, strAssocClass: ?BSTR, strResultClass: ?BSTR, strResultRole: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredAssocQualifier: ?BSTR, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).AssociatorsAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, strAssocClass, strResultClass, strResultRole, strRole, bClassesOnly, bSchemaOnly, strRequiredAssocQualifier, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_References_(self: *const T, strResultClass: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).References_(@as(*const ISWbemObject, @ptrCast(self)), strResultClass, strRole, bClassesOnly, bSchemaOnly, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_ReferencesAsync_(self: *const T, objWbemSink: ?*IDispatch, strResultClass: ?BSTR, strRole: ?BSTR, bClassesOnly: i16, bSchemaOnly: i16, strRequiredQualifier: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).ReferencesAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, strResultClass, strRole, bClassesOnly, bSchemaOnly, strRequiredQualifier, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_ExecMethod_(self: *const T, strMethodName: ?BSTR, objWbemInParameters: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemOutParameters: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).ExecMethod_(@as(*const ISWbemObject, @ptrCast(self)), strMethodName, objWbemInParameters, iFlags, objWbemNamedValueSet, objWbemOutParameters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_ExecMethodAsync_(self: *const T, objWbemSink: ?*IDispatch, strMethodName: ?BSTR, objWbemInParameters: ?*IDispatch, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).ExecMethodAsync_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSink, strMethodName, objWbemInParameters, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_Clone_(self: *const T, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).Clone_(@as(*const ISWbemObject, @ptrCast(self)), objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_GetObjectText_(self: *const T, iFlags: i32, strObjectText: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).GetObjectText_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, strObjectText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_SpawnDerivedClass_(self: *const T, iFlags: i32, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).SpawnDerivedClass_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_SpawnInstance_(self: *const T, iFlags: i32, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).SpawnInstance_(@as(*const ISWbemObject, @ptrCast(self)), iFlags, objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_CompareTo_(self: *const T, objWbemObject: ?*IDispatch, iFlags: i32, bResult: ?*i16) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).CompareTo_(@as(*const ISWbemObject, @ptrCast(self)), objWbemObject, iFlags, bResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_get_Qualifiers_(self: *const T, objWbemQualifierSet: ?*?*ISWbemQualifierSet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).get_Qualifiers_(@as(*const ISWbemObject, @ptrCast(self)), objWbemQualifierSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_get_Properties_(self: *const T, objWbemPropertySet: ?*?*ISWbemPropertySet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).get_Properties_(@as(*const ISWbemObject, @ptrCast(self)), objWbemPropertySet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_get_Methods_(self: *const T, objWbemMethodSet: ?*?*ISWbemMethodSet) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).get_Methods_(@as(*const ISWbemObject, @ptrCast(self)), objWbemMethodSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_get_Derivation_(self: *const T, strClassNameArray: ?*VARIANT) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).get_Derivation_(@as(*const ISWbemObject, @ptrCast(self)), strClassNameArray);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_get_Path_(self: *const T, objWbemObjectPath: ?*?*ISWbemObjectPath) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).get_Path_(@as(*const ISWbemObject, @ptrCast(self)), objWbemObjectPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObject_get_Security_(self: *const T, objWbemSecurity: ?*?*ISWbemSecurity) HRESULT {
                return @as(*const ISWbemObject.VTable, @ptrCast(self.vtable)).get_Security_(@as(*const ISWbemObject, @ptrCast(self)), objWbemSecurity);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemObjectSet_Value = Guid.initString("76a6415f-cb41-11d1-8b02-00600806d9b6");
pub const IID_ISWbemObjectSet = &IID_ISWbemObjectSet_Value;
pub const ISWbemObjectSet = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectSet,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectSet,
                strObjectPath: ?BSTR,
                iFlags: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Security_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectSet,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectSet,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ItemIndex: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectSet,
                lIndex: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectSet,
                lIndex: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectSet_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemObjectSet.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemObjectSet, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectSet_Item(self: *const T, strObjectPath: ?BSTR, iFlags: i32, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemObjectSet.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemObjectSet, @ptrCast(self)), strObjectPath, iFlags, objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectSet_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemObjectSet.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemObjectSet, @ptrCast(self)), iCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectSet_get_Security_(self: *const T, objWbemSecurity: ?*?*ISWbemSecurity) HRESULT {
                return @as(*const ISWbemObjectSet.VTable, @ptrCast(self.vtable)).get_Security_(@as(*const ISWbemObjectSet, @ptrCast(self)), objWbemSecurity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectSet_ItemIndex(self: *const T, lIndex: i32, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemObjectSet.VTable, @ptrCast(self.vtable)).ItemIndex(@as(*const ISWbemObjectSet, @ptrCast(self)), lIndex, objWbemObject);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemNamedValue_Value = Guid.initString("76a64164-cb41-11d1-8b02-00600806d9b6");
pub const IID_ISWbemNamedValue = &IID_ISWbemNamedValue_Value;
pub const ISWbemNamedValue = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemNamedValue,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemNamedValue,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemNamedValue,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemNamedValue,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemNamedValue,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemNamedValue,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValue_get_Value(self: *const T, varValue: ?*VARIANT) HRESULT {
                return @as(*const ISWbemNamedValue.VTable, @ptrCast(self.vtable)).get_Value(@as(*const ISWbemNamedValue, @ptrCast(self)), varValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValue_put_Value(self: *const T, varValue: ?*VARIANT) HRESULT {
                return @as(*const ISWbemNamedValue.VTable, @ptrCast(self.vtable)).put_Value(@as(*const ISWbemNamedValue, @ptrCast(self)), varValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValue_get_Name(self: *const T, strName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemNamedValue.VTable, @ptrCast(self.vtable)).get_Name(@as(*const ISWbemNamedValue, @ptrCast(self)), strName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemNamedValueSet_Value = Guid.initString("cf2376ea-ce8c-11d1-8b05-00600806d9b6");
pub const IID_ISWbemNamedValueSet = &IID_ISWbemNamedValueSet_Value;
pub const ISWbemNamedValueSet = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemNamedValueSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
                strName: ?BSTR,
                iFlags: i32,
                objWbemNamedValue: ?*?*ISWbemNamedValue,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemNamedValueSet,
                strName: ?BSTR,
                iFlags: i32,
                objWbemNamedValue: ?*?*ISWbemNamedValue,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemNamedValueSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Add: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
                strName: ?BSTR,
                varValue: ?*VARIANT,
                iFlags: i32,
                objWbemNamedValue: ?*?*ISWbemNamedValue,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemNamedValueSet,
                strName: ?BSTR,
                varValue: ?*VARIANT,
                iFlags: i32,
                objWbemNamedValue: ?*?*ISWbemNamedValue,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
                strName: ?BSTR,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemNamedValueSet,
                strName: ?BSTR,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
                objWbemNamedValueSet: ?*?*ISWbemNamedValueSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemNamedValueSet,
                objWbemNamedValueSet: ?*?*ISWbemNamedValueSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemNamedValueSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemNamedValueSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemNamedValueSet, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_Item(self: *const T, strName: ?BSTR, iFlags: i32, objWbemNamedValue: ?*?*ISWbemNamedValue) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemNamedValueSet, @ptrCast(self)), strName, iFlags, objWbemNamedValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemNamedValueSet, @ptrCast(self)), iCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_Add(self: *const T, strName: ?BSTR, varValue: ?*VARIANT, iFlags: i32, objWbemNamedValue: ?*?*ISWbemNamedValue) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).Add(@as(*const ISWbemNamedValueSet, @ptrCast(self)), strName, varValue, iFlags, objWbemNamedValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_Remove(self: *const T, strName: ?BSTR, iFlags: i32) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).Remove(@as(*const ISWbemNamedValueSet, @ptrCast(self)), strName, iFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_Clone(self: *const T, objWbemNamedValueSet: ?*?*ISWbemNamedValueSet) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).Clone(@as(*const ISWbemNamedValueSet, @ptrCast(self)), objWbemNamedValueSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemNamedValueSet_DeleteAll(self: *const T) HRESULT {
                return @as(*const ISWbemNamedValueSet.VTable, @ptrCast(self.vtable)).DeleteAll(@as(*const ISWbemNamedValueSet, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemQualifier_Value = Guid.initString("79b05932-d3b7-11d1-8b06-00600806d9b6");
pub const IID_ISWbemQualifier = &IID_ISWbemQualifier_Value;
pub const ISWbemQualifier = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsLocal: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bIsLocal: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bIsLocal: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PropagatesToSubclass: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bPropagatesToSubclass: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bPropagatesToSubclass: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_PropagatesToSubclass: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bPropagatesToSubclass: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bPropagatesToSubclass: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PropagatesToInstance: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bPropagatesToInstance: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bPropagatesToInstance: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_PropagatesToInstance: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bPropagatesToInstance: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bPropagatesToInstance: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsOverridable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bIsOverridable: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bIsOverridable: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_IsOverridable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bIsOverridable: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bIsOverridable: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsAmended: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifier,
                bIsAmended: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifier,
                bIsAmended: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_Value(self: *const T, varValue: ?*VARIANT) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_Value(@as(*const ISWbemQualifier, @ptrCast(self)), varValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_put_Value(self: *const T, varValue: ?*VARIANT) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).put_Value(@as(*const ISWbemQualifier, @ptrCast(self)), varValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_Name(self: *const T, strName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_Name(@as(*const ISWbemQualifier, @ptrCast(self)), strName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_IsLocal(self: *const T, bIsLocal: ?*i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_IsLocal(@as(*const ISWbemQualifier, @ptrCast(self)), bIsLocal);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_PropagatesToSubclass(self: *const T, bPropagatesToSubclass: ?*i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_PropagatesToSubclass(@as(*const ISWbemQualifier, @ptrCast(self)), bPropagatesToSubclass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_put_PropagatesToSubclass(self: *const T, bPropagatesToSubclass: i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).put_PropagatesToSubclass(@as(*const ISWbemQualifier, @ptrCast(self)), bPropagatesToSubclass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_PropagatesToInstance(self: *const T, bPropagatesToInstance: ?*i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_PropagatesToInstance(@as(*const ISWbemQualifier, @ptrCast(self)), bPropagatesToInstance);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_put_PropagatesToInstance(self: *const T, bPropagatesToInstance: i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).put_PropagatesToInstance(@as(*const ISWbemQualifier, @ptrCast(self)), bPropagatesToInstance);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_IsOverridable(self: *const T, bIsOverridable: ?*i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_IsOverridable(@as(*const ISWbemQualifier, @ptrCast(self)), bIsOverridable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_put_IsOverridable(self: *const T, bIsOverridable: i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).put_IsOverridable(@as(*const ISWbemQualifier, @ptrCast(self)), bIsOverridable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifier_get_IsAmended(self: *const T, bIsAmended: ?*i16) HRESULT {
                return @as(*const ISWbemQualifier.VTable, @ptrCast(self.vtable)).get_IsAmended(@as(*const ISWbemQualifier, @ptrCast(self)), bIsAmended);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemQualifierSet_Value = Guid.initString("9b16ed16-d3df-11d1-8b08-00600806d9b6");
pub const IID_ISWbemQualifierSet = &IID_ISWbemQualifierSet_Value;
pub const ISWbemQualifierSet = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifierSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifierSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemQualifierSet,
                name: ?BSTR,
                iFlags: i32,
                objWbemQualifier: ?*?*ISWbemQualifier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemQualifierSet,
                name: ?BSTR,
                iFlags: i32,
                objWbemQualifier: ?*?*ISWbemQualifier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemQualifierSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemQualifierSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Add: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemQualifierSet,
                strName: ?BSTR,
                varVal: ?*VARIANT,
                bPropagatesToSubclass: i16,
                bPropagatesToInstance: i16,
                bIsOverridable: i16,
                iFlags: i32,
                objWbemQualifier: ?*?*ISWbemQualifier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemQualifierSet,
                strName: ?BSTR,
                varVal: ?*VARIANT,
                bPropagatesToSubclass: i16,
                bPropagatesToInstance: i16,
                bIsOverridable: i16,
                iFlags: i32,
                objWbemQualifier: ?*?*ISWbemQualifier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemQualifierSet,
                strName: ?BSTR,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemQualifierSet,
                strName: ?BSTR,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifierSet_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemQualifierSet.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemQualifierSet, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifierSet_Item(self: *const T, name: ?BSTR, iFlags: i32, objWbemQualifier: ?*?*ISWbemQualifier) HRESULT {
                return @as(*const ISWbemQualifierSet.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemQualifierSet, @ptrCast(self)), name, iFlags, objWbemQualifier);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifierSet_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemQualifierSet.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemQualifierSet, @ptrCast(self)), iCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifierSet_Add(self: *const T, strName: ?BSTR, varVal: ?*VARIANT, bPropagatesToSubclass: i16, bPropagatesToInstance: i16, bIsOverridable: i16, iFlags: i32, objWbemQualifier: ?*?*ISWbemQualifier) HRESULT {
                return @as(*const ISWbemQualifierSet.VTable, @ptrCast(self.vtable)).Add(@as(*const ISWbemQualifierSet, @ptrCast(self)), strName, varVal, bPropagatesToSubclass, bPropagatesToInstance, bIsOverridable, iFlags, objWbemQualifier);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemQualifierSet_Remove(self: *const T, strName: ?BSTR, iFlags: i32) HRESULT {
                return @as(*const ISWbemQualifierSet.VTable, @ptrCast(self.vtable)).Remove(@as(*const ISWbemQualifierSet, @ptrCast(self)), strName, iFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemProperty_Value = Guid.initString("1a388f98-d4ba-11d1-8b09-00600806d9b6");
pub const IID_ISWbemProperty = &IID_ISWbemProperty_Value;
pub const ISWbemProperty = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                varValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsLocal: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                bIsLocal: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                bIsLocal: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Origin: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                strOrigin: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                strOrigin: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_CIMType: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                iCimType: ?*WbemCimtypeEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                iCimType: ?*WbemCimtypeEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Qualifiers_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                objWbemQualifierSet: ?*?*ISWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                objWbemQualifierSet: ?*?*ISWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsArray: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemProperty,
                bIsArray: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemProperty,
                bIsArray: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_Value(self: *const T, varValue: ?*VARIANT) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_Value(@as(*const ISWbemProperty, @ptrCast(self)), varValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_put_Value(self: *const T, varValue: ?*VARIANT) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).put_Value(@as(*const ISWbemProperty, @ptrCast(self)), varValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_Name(self: *const T, strName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_Name(@as(*const ISWbemProperty, @ptrCast(self)), strName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_IsLocal(self: *const T, bIsLocal: ?*i16) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_IsLocal(@as(*const ISWbemProperty, @ptrCast(self)), bIsLocal);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_Origin(self: *const T, strOrigin: ?*?BSTR) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_Origin(@as(*const ISWbemProperty, @ptrCast(self)), strOrigin);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_CIMType(self: *const T, iCimType: ?*WbemCimtypeEnum) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_CIMType(@as(*const ISWbemProperty, @ptrCast(self)), iCimType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_Qualifiers_(self: *const T, objWbemQualifierSet: ?*?*ISWbemQualifierSet) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_Qualifiers_(@as(*const ISWbemProperty, @ptrCast(self)), objWbemQualifierSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemProperty_get_IsArray(self: *const T, bIsArray: ?*i16) HRESULT {
                return @as(*const ISWbemProperty.VTable, @ptrCast(self.vtable)).get_IsArray(@as(*const ISWbemProperty, @ptrCast(self)), bIsArray);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemPropertySet_Value = Guid.initString("dea0a7b2-d4ba-11d1-8b09-00600806d9b6");
pub const IID_ISWbemPropertySet = &IID_ISWbemPropertySet_Value;
pub const ISWbemPropertySet = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPropertySet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPropertySet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPropertySet,
                strName: ?BSTR,
                iFlags: i32,
                objWbemProperty: ?*?*ISWbemProperty,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPropertySet,
                strName: ?BSTR,
                iFlags: i32,
                objWbemProperty: ?*?*ISWbemProperty,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPropertySet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPropertySet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Add: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPropertySet,
                strName: ?BSTR,
                iCIMType: WbemCimtypeEnum,
                bIsArray: i16,
                iFlags: i32,
                objWbemProperty: ?*?*ISWbemProperty,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPropertySet,
                strName: ?BSTR,
                iCIMType: WbemCimtypeEnum,
                bIsArray: i16,
                iFlags: i32,
                objWbemProperty: ?*?*ISWbemProperty,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPropertySet,
                strName: ?BSTR,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPropertySet,
                strName: ?BSTR,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPropertySet_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemPropertySet.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemPropertySet, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPropertySet_Item(self: *const T, strName: ?BSTR, iFlags: i32, objWbemProperty: ?*?*ISWbemProperty) HRESULT {
                return @as(*const ISWbemPropertySet.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemPropertySet, @ptrCast(self)), strName, iFlags, objWbemProperty);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPropertySet_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemPropertySet.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemPropertySet, @ptrCast(self)), iCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPropertySet_Add(self: *const T, strName: ?BSTR, iCIMType: WbemCimtypeEnum, bIsArray: i16, iFlags: i32, objWbemProperty: ?*?*ISWbemProperty) HRESULT {
                return @as(*const ISWbemPropertySet.VTable, @ptrCast(self.vtable)).Add(@as(*const ISWbemPropertySet, @ptrCast(self)), strName, iCIMType, bIsArray, iFlags, objWbemProperty);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPropertySet_Remove(self: *const T, strName: ?BSTR, iFlags: i32) HRESULT {
                return @as(*const ISWbemPropertySet.VTable, @ptrCast(self.vtable)).Remove(@as(*const ISWbemPropertySet, @ptrCast(self)), strName, iFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemMethod_Value = Guid.initString("422e8e90-d955-11d1-8b09-00600806d9b6");
pub const IID_ISWbemMethod = &IID_ISWbemMethod_Value;
pub const ISWbemMethod = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethod,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethod,
                strName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Origin: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethod,
                strOrigin: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethod,
                strOrigin: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_InParameters: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethod,
                objWbemInParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethod,
                objWbemInParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_OutParameters: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethod,
                objWbemOutParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethod,
                objWbemOutParameters: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Qualifiers_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethod,
                objWbemQualifierSet: ?*?*ISWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethod,
                objWbemQualifierSet: ?*?*ISWbemQualifierSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethod_get_Name(self: *const T, strName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemMethod.VTable, @ptrCast(self.vtable)).get_Name(@as(*const ISWbemMethod, @ptrCast(self)), strName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethod_get_Origin(self: *const T, strOrigin: ?*?BSTR) HRESULT {
                return @as(*const ISWbemMethod.VTable, @ptrCast(self.vtable)).get_Origin(@as(*const ISWbemMethod, @ptrCast(self)), strOrigin);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethod_get_InParameters(self: *const T, objWbemInParameters: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemMethod.VTable, @ptrCast(self.vtable)).get_InParameters(@as(*const ISWbemMethod, @ptrCast(self)), objWbemInParameters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethod_get_OutParameters(self: *const T, objWbemOutParameters: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemMethod.VTable, @ptrCast(self.vtable)).get_OutParameters(@as(*const ISWbemMethod, @ptrCast(self)), objWbemOutParameters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethod_get_Qualifiers_(self: *const T, objWbemQualifierSet: ?*?*ISWbemQualifierSet) HRESULT {
                return @as(*const ISWbemMethod.VTable, @ptrCast(self.vtable)).get_Qualifiers_(@as(*const ISWbemMethod, @ptrCast(self)), objWbemQualifierSet);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemMethodSet_Value = Guid.initString("c93ba292-d955-11d1-8b09-00600806d9b6");
pub const IID_ISWbemMethodSet = &IID_ISWbemMethodSet_Value;
pub const ISWbemMethodSet = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethodSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethodSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemMethodSet,
                strName: ?BSTR,
                iFlags: i32,
                objWbemMethod: ?*?*ISWbemMethod,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemMethodSet,
                strName: ?BSTR,
                iFlags: i32,
                objWbemMethod: ?*?*ISWbemMethod,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemMethodSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemMethodSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethodSet_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemMethodSet.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemMethodSet, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethodSet_Item(self: *const T, strName: ?BSTR, iFlags: i32, objWbemMethod: ?*?*ISWbemMethod) HRESULT {
                return @as(*const ISWbemMethodSet.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemMethodSet, @ptrCast(self)), strName, iFlags, objWbemMethod);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemMethodSet_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemMethodSet.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemMethodSet, @ptrCast(self)), iCount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemEventSource_Value = Guid.initString("27d54d92-0ebe-11d2-8b22-00600806d9b6");
pub const IID_ISWbemEventSource = &IID_ISWbemEventSource_Value;
pub const ISWbemEventSource = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        NextEvent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemEventSource,
                iTimeoutMs: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemEventSource,
                iTimeoutMs: i32,
                objWbemObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Security_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemEventSource,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemEventSource,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemEventSource_NextEvent(self: *const T, iTimeoutMs: i32, objWbemObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const ISWbemEventSource.VTable, @ptrCast(self.vtable)).NextEvent(@as(*const ISWbemEventSource, @ptrCast(self)), iTimeoutMs, objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemEventSource_get_Security_(self: *const T, objWbemSecurity: ?*?*ISWbemSecurity) HRESULT {
                return @as(*const ISWbemEventSource.VTable, @ptrCast(self.vtable)).get_Security_(@as(*const ISWbemEventSource, @ptrCast(self)), objWbemSecurity);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemObjectPath_Value = Guid.initString("5791bc27-ce9c-11d1-97bf-0000f81e849c");
pub const IID_ISWbemObjectPath = &IID_ISWbemObjectPath_Value;
pub const ISWbemObjectPath = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Path: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strPath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strPath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Path: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strPath: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strPath: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RelPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strRelPath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strRelPath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_RelPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strRelPath: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strRelPath: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Server: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strServer: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strServer: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Server: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strServer: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strServer: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Namespace: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strNamespace: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strNamespace: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Namespace: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strNamespace: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strNamespace: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ParentNamespace: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strParentNamespace: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strParentNamespace: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DisplayName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strDisplayName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strDisplayName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_DisplayName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strDisplayName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strDisplayName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Class: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strClass: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strClass: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Class: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strClass: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strClass: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsClass: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                bIsClass: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                bIsClass: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAsClass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsSingleton: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                bIsSingleton: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                bIsSingleton: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAsSingleton: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Keys: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                objWbemNamedValueSet: ?*?*ISWbemNamedValueSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                objWbemNamedValueSet: ?*?*ISWbemNamedValueSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Security_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                objWbemSecurity: ?*?*ISWbemSecurity,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Locale: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strLocale: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strLocale: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Locale: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strLocale: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strLocale: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Authority: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strAuthority: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strAuthority: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Authority: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectPath,
                strAuthority: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectPath,
                strAuthority: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Path(self: *const T, strPath: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Path(@as(*const ISWbemObjectPath, @ptrCast(self)), strPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_Path(self: *const T, strPath: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_Path(@as(*const ISWbemObjectPath, @ptrCast(self)), strPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_RelPath(self: *const T, strRelPath: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_RelPath(@as(*const ISWbemObjectPath, @ptrCast(self)), strRelPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_RelPath(self: *const T, strRelPath: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_RelPath(@as(*const ISWbemObjectPath, @ptrCast(self)), strRelPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Server(self: *const T, strServer: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Server(@as(*const ISWbemObjectPath, @ptrCast(self)), strServer);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_Server(self: *const T, strServer: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_Server(@as(*const ISWbemObjectPath, @ptrCast(self)), strServer);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Namespace(self: *const T, strNamespace: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Namespace(@as(*const ISWbemObjectPath, @ptrCast(self)), strNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_Namespace(self: *const T, strNamespace: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_Namespace(@as(*const ISWbemObjectPath, @ptrCast(self)), strNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_ParentNamespace(self: *const T, strParentNamespace: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_ParentNamespace(@as(*const ISWbemObjectPath, @ptrCast(self)), strParentNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_DisplayName(self: *const T, strDisplayName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_DisplayName(@as(*const ISWbemObjectPath, @ptrCast(self)), strDisplayName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_DisplayName(self: *const T, strDisplayName: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_DisplayName(@as(*const ISWbemObjectPath, @ptrCast(self)), strDisplayName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Class(self: *const T, strClass: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Class(@as(*const ISWbemObjectPath, @ptrCast(self)), strClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_Class(self: *const T, strClass: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_Class(@as(*const ISWbemObjectPath, @ptrCast(self)), strClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_IsClass(self: *const T, bIsClass: ?*i16) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_IsClass(@as(*const ISWbemObjectPath, @ptrCast(self)), bIsClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_SetAsClass(self: *const T) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).SetAsClass(@as(*const ISWbemObjectPath, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_IsSingleton(self: *const T, bIsSingleton: ?*i16) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_IsSingleton(@as(*const ISWbemObjectPath, @ptrCast(self)), bIsSingleton);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_SetAsSingleton(self: *const T) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).SetAsSingleton(@as(*const ISWbemObjectPath, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Keys(self: *const T, objWbemNamedValueSet: ?*?*ISWbemNamedValueSet) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Keys(@as(*const ISWbemObjectPath, @ptrCast(self)), objWbemNamedValueSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Security_(self: *const T, objWbemSecurity: ?*?*ISWbemSecurity) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Security_(@as(*const ISWbemObjectPath, @ptrCast(self)), objWbemSecurity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Locale(self: *const T, strLocale: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Locale(@as(*const ISWbemObjectPath, @ptrCast(self)), strLocale);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_Locale(self: *const T, strLocale: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_Locale(@as(*const ISWbemObjectPath, @ptrCast(self)), strLocale);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_get_Authority(self: *const T, strAuthority: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).get_Authority(@as(*const ISWbemObjectPath, @ptrCast(self)), strAuthority);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectPath_put_Authority(self: *const T, strAuthority: ?BSTR) HRESULT {
                return @as(*const ISWbemObjectPath.VTable, @ptrCast(self.vtable)).put_Authority(@as(*const ISWbemObjectPath, @ptrCast(self)), strAuthority);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemLastError_Value = Guid.initString("d962db84-d4bb-11d1-8b09-00600806d9b6");
pub const IID_ISWbemLastError = &IID_ISWbemLastError_Value;
pub const ISWbemLastError = extern struct {
    pub const VTable = extern struct {
        base: ISWbemObject.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace ISWbemObject.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemSinkEvents_Value = Guid.initString("75718ca0-f029-11d1-a1ac-00c04fb6c223");
pub const IID_ISWbemSinkEvents = &IID_ISWbemSinkEvents_Value;
pub const ISWbemSinkEvents = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemSink_Value = Guid.initString("75718c9f-f029-11d1-a1ac-00c04fb6c223");
pub const IID_ISWbemSink = &IID_ISWbemSink_Value;
pub const ISWbemSink = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        Cancel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemSink_Cancel(self: *const T) HRESULT {
                return @as(*const ISWbemSink.VTable, @ptrCast(self.vtable)).Cancel(@as(*const ISWbemSink, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemSecurity_Value = Guid.initString("b54d66e6-2287-11d2-8b33-00600806d9b6");
pub const IID_ISWbemSecurity = &IID_ISWbemSecurity_Value;
pub const ISWbemSecurity = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ImpersonationLevel: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemSecurity,
                iImpersonationLevel: ?*WbemImpersonationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemSecurity,
                iImpersonationLevel: ?*WbemImpersonationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ImpersonationLevel: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemSecurity,
                iImpersonationLevel: WbemImpersonationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemSecurity,
                iImpersonationLevel: WbemImpersonationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AuthenticationLevel: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemSecurity,
                iAuthenticationLevel: ?*WbemAuthenticationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemSecurity,
                iAuthenticationLevel: ?*WbemAuthenticationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_AuthenticationLevel: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemSecurity,
                iAuthenticationLevel: WbemAuthenticationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemSecurity,
                iAuthenticationLevel: WbemAuthenticationLevelEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Privileges: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemSecurity,
                objWbemPrivilegeSet: ?*?*ISWbemPrivilegeSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemSecurity,
                objWbemPrivilegeSet: ?*?*ISWbemPrivilegeSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemSecurity_get_ImpersonationLevel(self: *const T, iImpersonationLevel: ?*WbemImpersonationLevelEnum) HRESULT {
                return @as(*const ISWbemSecurity.VTable, @ptrCast(self.vtable)).get_ImpersonationLevel(@as(*const ISWbemSecurity, @ptrCast(self)), iImpersonationLevel);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemSecurity_put_ImpersonationLevel(self: *const T, iImpersonationLevel: WbemImpersonationLevelEnum) HRESULT {
                return @as(*const ISWbemSecurity.VTable, @ptrCast(self.vtable)).put_ImpersonationLevel(@as(*const ISWbemSecurity, @ptrCast(self)), iImpersonationLevel);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemSecurity_get_AuthenticationLevel(self: *const T, iAuthenticationLevel: ?*WbemAuthenticationLevelEnum) HRESULT {
                return @as(*const ISWbemSecurity.VTable, @ptrCast(self.vtable)).get_AuthenticationLevel(@as(*const ISWbemSecurity, @ptrCast(self)), iAuthenticationLevel);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemSecurity_put_AuthenticationLevel(self: *const T, iAuthenticationLevel: WbemAuthenticationLevelEnum) HRESULT {
                return @as(*const ISWbemSecurity.VTable, @ptrCast(self.vtable)).put_AuthenticationLevel(@as(*const ISWbemSecurity, @ptrCast(self)), iAuthenticationLevel);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemSecurity_get_Privileges(self: *const T, objWbemPrivilegeSet: ?*?*ISWbemPrivilegeSet) HRESULT {
                return @as(*const ISWbemSecurity.VTable, @ptrCast(self.vtable)).get_Privileges(@as(*const ISWbemSecurity, @ptrCast(self)), objWbemPrivilegeSet);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemPrivilege_Value = Guid.initString("26ee67bd-5804-11d2-8b4a-00600806d9b6");
pub const IID_ISWbemPrivilege = &IID_ISWbemPrivilege_Value;
pub const ISWbemPrivilege = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsEnabled: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilege,
                bIsEnabled: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilege,
                bIsEnabled: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_IsEnabled: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilege,
                bIsEnabled: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilege,
                bIsEnabled: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilege,
                strDisplayName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilege,
                strDisplayName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DisplayName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilege,
                strDisplayName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilege,
                strDisplayName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Identifier: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilege,
                iPrivilege: ?*WbemPrivilegeEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilege,
                iPrivilege: ?*WbemPrivilegeEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilege_get_IsEnabled(self: *const T, bIsEnabled: ?*i16) HRESULT {
                return @as(*const ISWbemPrivilege.VTable, @ptrCast(self.vtable)).get_IsEnabled(@as(*const ISWbemPrivilege, @ptrCast(self)), bIsEnabled);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilege_put_IsEnabled(self: *const T, bIsEnabled: i16) HRESULT {
                return @as(*const ISWbemPrivilege.VTable, @ptrCast(self.vtable)).put_IsEnabled(@as(*const ISWbemPrivilege, @ptrCast(self)), bIsEnabled);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilege_get_Name(self: *const T, strDisplayName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemPrivilege.VTable, @ptrCast(self.vtable)).get_Name(@as(*const ISWbemPrivilege, @ptrCast(self)), strDisplayName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilege_get_DisplayName(self: *const T, strDisplayName: ?*?BSTR) HRESULT {
                return @as(*const ISWbemPrivilege.VTable, @ptrCast(self.vtable)).get_DisplayName(@as(*const ISWbemPrivilege, @ptrCast(self)), strDisplayName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilege_get_Identifier(self: *const T, iPrivilege: ?*WbemPrivilegeEnum) HRESULT {
                return @as(*const ISWbemPrivilege.VTable, @ptrCast(self.vtable)).get_Identifier(@as(*const ISWbemPrivilege, @ptrCast(self)), iPrivilege);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemPrivilegeSet_Value = Guid.initString("26ee67bf-5804-11d2-8b4a-00600806d9b6");
pub const IID_ISWbemPrivilegeSet = &IID_ISWbemPrivilegeSet_Value;
pub const ISWbemPrivilegeSet = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
                iPrivilege: WbemPrivilegeEnum,
                objWbemPrivilege: ?*?*ISWbemPrivilege,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
                iPrivilege: WbemPrivilegeEnum,
                objWbemPrivilege: ?*?*ISWbemPrivilege,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Add: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
                iPrivilege: WbemPrivilegeEnum,
                bIsEnabled: i16,
                objWbemPrivilege: ?*?*ISWbemPrivilege,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
                iPrivilege: WbemPrivilegeEnum,
                bIsEnabled: i16,
                objWbemPrivilege: ?*?*ISWbemPrivilege,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
                iPrivilege: WbemPrivilegeEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
                iPrivilege: WbemPrivilegeEnum,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddAsString: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemPrivilegeSet,
                strPrivilege: ?BSTR,
                bIsEnabled: i16,
                objWbemPrivilege: ?*?*ISWbemPrivilege,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemPrivilegeSet,
                strPrivilege: ?BSTR,
                bIsEnabled: i16,
                objWbemPrivilege: ?*?*ISWbemPrivilege,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemPrivilegeSet, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_Item(self: *const T, iPrivilege: WbemPrivilegeEnum, objWbemPrivilege: ?*?*ISWbemPrivilege) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemPrivilegeSet, @ptrCast(self)), iPrivilege, objWbemPrivilege);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemPrivilegeSet, @ptrCast(self)), iCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_Add(self: *const T, iPrivilege: WbemPrivilegeEnum, bIsEnabled: i16, objWbemPrivilege: ?*?*ISWbemPrivilege) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).Add(@as(*const ISWbemPrivilegeSet, @ptrCast(self)), iPrivilege, bIsEnabled, objWbemPrivilege);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_Remove(self: *const T, iPrivilege: WbemPrivilegeEnum) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).Remove(@as(*const ISWbemPrivilegeSet, @ptrCast(self)), iPrivilege);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_DeleteAll(self: *const T) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).DeleteAll(@as(*const ISWbemPrivilegeSet, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemPrivilegeSet_AddAsString(self: *const T, strPrivilege: ?BSTR, bIsEnabled: i16, objWbemPrivilege: ?*?*ISWbemPrivilege) HRESULT {
                return @as(*const ISWbemPrivilegeSet.VTable, @ptrCast(self.vtable)).AddAsString(@as(*const ISWbemPrivilegeSet, @ptrCast(self)), strPrivilege, bIsEnabled, objWbemPrivilege);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemServicesEx_Value = Guid.initString("d2f68443-85dc-427e-91d8-366554cc754c");
pub const IID_ISWbemServicesEx = &IID_ISWbemServicesEx_Value;
pub const ISWbemServicesEx = extern struct {
    pub const VTable = extern struct {
        base: ISWbemServices.VTable,
        Put: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServicesEx,
                objWbemObject: ?*ISWbemObjectEx,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectPath: ?*?*ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServicesEx,
                objWbemObject: ?*ISWbemObjectEx,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemObjectPath: ?*?*ISWbemObjectPath,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PutAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemServicesEx,
                objWbemSink: ?*ISWbemSink,
                objWbemObject: ?*ISWbemObjectEx,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemServicesEx,
                objWbemSink: ?*ISWbemSink,
                objWbemObject: ?*ISWbemObjectEx,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemAsyncContext: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace ISWbemServices.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServicesEx_Put(self: *const T, objWbemObject: ?*ISWbemObjectEx, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemObjectPath: ?*?*ISWbemObjectPath) HRESULT {
                return @as(*const ISWbemServicesEx.VTable, @ptrCast(self.vtable)).Put(@as(*const ISWbemServicesEx, @ptrCast(self)), objWbemObject, iFlags, objWbemNamedValueSet, objWbemObjectPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemServicesEx_PutAsync(self: *const T, objWbemSink: ?*ISWbemSink, objWbemObject: ?*ISWbemObjectEx, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemAsyncContext: ?*IDispatch) HRESULT {
                return @as(*const ISWbemServicesEx.VTable, @ptrCast(self.vtable)).PutAsync(@as(*const ISWbemServicesEx, @ptrCast(self)), objWbemSink, objWbemObject, iFlags, objWbemNamedValueSet, objWbemAsyncContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemObjectEx_Value = Guid.initString("269ad56a-8a67-4129-bc8c-0506dcfe9880");
pub const IID_ISWbemObjectEx = &IID_ISWbemObjectEx_Value;
pub const ISWbemObjectEx = extern struct {
    pub const VTable = extern struct {
        base: ISWbemObject.VTable,
        Refresh_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectEx,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectEx,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SystemProperties_: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemObjectEx,
                objWbemPropertySet: ?*?*ISWbemPropertySet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemObjectEx,
                objWbemPropertySet: ?*?*ISWbemPropertySet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetText_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectEx,
                iObjectTextFormat: WbemObjectTextFormatEnum,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                bsText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectEx,
                iObjectTextFormat: WbemObjectTextFormatEnum,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                bsText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetFromText_: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemObjectEx,
                bsText: ?BSTR,
                iObjectTextFormat: WbemObjectTextFormatEnum,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemObjectEx,
                bsText: ?BSTR,
                iObjectTextFormat: WbemObjectTextFormatEnum,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace ISWbemObject.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectEx_Refresh_(self: *const T, iFlags: i32, objWbemNamedValueSet: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObjectEx.VTable, @ptrCast(self.vtable)).Refresh_(@as(*const ISWbemObjectEx, @ptrCast(self)), iFlags, objWbemNamedValueSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectEx_get_SystemProperties_(self: *const T, objWbemPropertySet: ?*?*ISWbemPropertySet) HRESULT {
                return @as(*const ISWbemObjectEx.VTable, @ptrCast(self.vtable)).get_SystemProperties_(@as(*const ISWbemObjectEx, @ptrCast(self)), objWbemPropertySet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectEx_GetText_(self: *const T, iObjectTextFormat: WbemObjectTextFormatEnum, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, bsText: ?*?BSTR) HRESULT {
                return @as(*const ISWbemObjectEx.VTable, @ptrCast(self.vtable)).GetText_(@as(*const ISWbemObjectEx, @ptrCast(self)), iObjectTextFormat, iFlags, objWbemNamedValueSet, bsText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemObjectEx_SetFromText_(self: *const T, bsText: ?BSTR, iObjectTextFormat: WbemObjectTextFormatEnum, iFlags: i32, objWbemNamedValueSet: ?*IDispatch) HRESULT {
                return @as(*const ISWbemObjectEx.VTable, @ptrCast(self.vtable)).SetFromText_(@as(*const ISWbemObjectEx, @ptrCast(self)), bsText, iObjectTextFormat, iFlags, objWbemNamedValueSet);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemDateTime_Value = Guid.initString("5e97458a-cf77-11d3-b38f-00105a1f473a");
pub const IID_ISWbemDateTime = &IID_ISWbemDateTime_Value;
pub const ISWbemDateTime = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                strValue: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                strValue: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Value: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                strValue: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                strValue: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Year: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iYear: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iYear: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Year: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iYear: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iYear: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_YearSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bYearSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bYearSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_YearSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bYearSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bYearSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Month: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iMonth: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iMonth: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Month: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iMonth: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iMonth: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MonthSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bMonthSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bMonthSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_MonthSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bMonthSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bMonthSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Day: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iDay: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iDay: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Day: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iDay: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iDay: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DaySpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bDaySpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bDaySpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_DaySpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bDaySpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bDaySpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Hours: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iHours: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iHours: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Hours: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iHours: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iHours: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_HoursSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bHoursSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bHoursSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_HoursSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bHoursSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bHoursSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Minutes: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iMinutes: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iMinutes: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Minutes: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iMinutes: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iMinutes: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MinutesSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bMinutesSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bMinutesSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_MinutesSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bMinutesSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bMinutesSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Seconds: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iSeconds: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iSeconds: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Seconds: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iSeconds: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iSeconds: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SecondsSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bSecondsSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bSecondsSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_SecondsSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bSecondsSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bSecondsSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Microseconds: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iMicroseconds: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iMicroseconds: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Microseconds: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iMicroseconds: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iMicroseconds: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MicrosecondsSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bMicrosecondsSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bMicrosecondsSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_MicrosecondsSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bMicrosecondsSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bMicrosecondsSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UTC: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iUTC: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iUTC: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_UTC: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                iUTC: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                iUTC: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UTCSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bUTCSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bUTCSpecified: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_UTCSpecified: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bUTCSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bUTCSpecified: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsInterval: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bIsInterval: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bIsInterval: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_IsInterval: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bIsInterval: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemDateTime,
                bIsInterval: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetVarDate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bIsLocal: i16,
                dVarDate: ?*f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemDateTime,
                bIsLocal: i16,
                dVarDate: ?*f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetVarDate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemDateTime,
                dVarDate: f64,
                bIsLocal: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemDateTime,
                dVarDate: f64,
                bIsLocal: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFileTime: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemDateTime,
                bIsLocal: i16,
                strFileTime: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemDateTime,
                bIsLocal: i16,
                strFileTime: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetFileTime: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemDateTime,
                strFileTime: ?BSTR,
                bIsLocal: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemDateTime,
                strFileTime: ?BSTR,
                bIsLocal: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Value(self: *const T, strValue: ?*?BSTR) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Value(@as(*const ISWbemDateTime, @ptrCast(self)), strValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Value(self: *const T, strValue: ?BSTR) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Value(@as(*const ISWbemDateTime, @ptrCast(self)), strValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Year(self: *const T, iYear: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Year(@as(*const ISWbemDateTime, @ptrCast(self)), iYear);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Year(self: *const T, iYear: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Year(@as(*const ISWbemDateTime, @ptrCast(self)), iYear);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_YearSpecified(self: *const T, bYearSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_YearSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bYearSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_YearSpecified(self: *const T, bYearSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_YearSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bYearSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Month(self: *const T, iMonth: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Month(@as(*const ISWbemDateTime, @ptrCast(self)), iMonth);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Month(self: *const T, iMonth: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Month(@as(*const ISWbemDateTime, @ptrCast(self)), iMonth);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_MonthSpecified(self: *const T, bMonthSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_MonthSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bMonthSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_MonthSpecified(self: *const T, bMonthSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_MonthSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bMonthSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Day(self: *const T, iDay: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Day(@as(*const ISWbemDateTime, @ptrCast(self)), iDay);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Day(self: *const T, iDay: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Day(@as(*const ISWbemDateTime, @ptrCast(self)), iDay);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_DaySpecified(self: *const T, bDaySpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_DaySpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bDaySpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_DaySpecified(self: *const T, bDaySpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_DaySpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bDaySpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Hours(self: *const T, iHours: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Hours(@as(*const ISWbemDateTime, @ptrCast(self)), iHours);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Hours(self: *const T, iHours: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Hours(@as(*const ISWbemDateTime, @ptrCast(self)), iHours);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_HoursSpecified(self: *const T, bHoursSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_HoursSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bHoursSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_HoursSpecified(self: *const T, bHoursSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_HoursSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bHoursSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Minutes(self: *const T, iMinutes: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Minutes(@as(*const ISWbemDateTime, @ptrCast(self)), iMinutes);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Minutes(self: *const T, iMinutes: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Minutes(@as(*const ISWbemDateTime, @ptrCast(self)), iMinutes);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_MinutesSpecified(self: *const T, bMinutesSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_MinutesSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bMinutesSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_MinutesSpecified(self: *const T, bMinutesSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_MinutesSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bMinutesSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Seconds(self: *const T, iSeconds: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Seconds(@as(*const ISWbemDateTime, @ptrCast(self)), iSeconds);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Seconds(self: *const T, iSeconds: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Seconds(@as(*const ISWbemDateTime, @ptrCast(self)), iSeconds);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_SecondsSpecified(self: *const T, bSecondsSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_SecondsSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bSecondsSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_SecondsSpecified(self: *const T, bSecondsSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_SecondsSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bSecondsSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_Microseconds(self: *const T, iMicroseconds: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_Microseconds(@as(*const ISWbemDateTime, @ptrCast(self)), iMicroseconds);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_Microseconds(self: *const T, iMicroseconds: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_Microseconds(@as(*const ISWbemDateTime, @ptrCast(self)), iMicroseconds);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_MicrosecondsSpecified(self: *const T, bMicrosecondsSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_MicrosecondsSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bMicrosecondsSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_MicrosecondsSpecified(self: *const T, bMicrosecondsSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_MicrosecondsSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bMicrosecondsSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_UTC(self: *const T, iUTC: ?*i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_UTC(@as(*const ISWbemDateTime, @ptrCast(self)), iUTC);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_UTC(self: *const T, iUTC: i32) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_UTC(@as(*const ISWbemDateTime, @ptrCast(self)), iUTC);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_UTCSpecified(self: *const T, bUTCSpecified: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_UTCSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bUTCSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_UTCSpecified(self: *const T, bUTCSpecified: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_UTCSpecified(@as(*const ISWbemDateTime, @ptrCast(self)), bUTCSpecified);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_get_IsInterval(self: *const T, bIsInterval: ?*i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).get_IsInterval(@as(*const ISWbemDateTime, @ptrCast(self)), bIsInterval);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_put_IsInterval(self: *const T, bIsInterval: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).put_IsInterval(@as(*const ISWbemDateTime, @ptrCast(self)), bIsInterval);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_GetVarDate(self: *const T, bIsLocal: i16, dVarDate: ?*f64) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).GetVarDate(@as(*const ISWbemDateTime, @ptrCast(self)), bIsLocal, dVarDate);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_SetVarDate(self: *const T, dVarDate: f64, bIsLocal: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).SetVarDate(@as(*const ISWbemDateTime, @ptrCast(self)), dVarDate, bIsLocal);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_GetFileTime(self: *const T, bIsLocal: i16, strFileTime: ?*?BSTR) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).GetFileTime(@as(*const ISWbemDateTime, @ptrCast(self)), bIsLocal, strFileTime);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemDateTime_SetFileTime(self: *const T, strFileTime: ?BSTR, bIsLocal: i16) HRESULT {
                return @as(*const ISWbemDateTime.VTable, @ptrCast(self.vtable)).SetFileTime(@as(*const ISWbemDateTime, @ptrCast(self)), strFileTime, bIsLocal);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemRefresher_Value = Guid.initString("14d8250e-d9c2-11d3-b38f-00105a1f473a");
pub const IID_ISWbemRefresher = &IID_ISWbemRefresher_Value;
pub const ISWbemRefresher = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefresher,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefresher,
                pUnk: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Item: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefresher,
                iIndex: i32,
                objWbemRefreshableItem: ?*?*ISWbemRefreshableItem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefresher,
                iIndex: i32,
                objWbemRefreshableItem: ?*?*ISWbemRefreshableItem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefresher,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefresher,
                iCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Add: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefresher,
                objWbemServices: ?*ISWbemServicesEx,
                bsInstancePath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemRefreshableItem: ?*?*ISWbemRefreshableItem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefresher,
                objWbemServices: ?*ISWbemServicesEx,
                bsInstancePath: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemRefreshableItem: ?*?*ISWbemRefreshableItem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddEnum: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefresher,
                objWbemServices: ?*ISWbemServicesEx,
                bsClassName: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemRefreshableItem: ?*?*ISWbemRefreshableItem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefresher,
                objWbemServices: ?*ISWbemServicesEx,
                bsClassName: ?BSTR,
                iFlags: i32,
                objWbemNamedValueSet: ?*IDispatch,
                objWbemRefreshableItem: ?*?*ISWbemRefreshableItem,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefresher,
                iIndex: i32,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefresher,
                iIndex: i32,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Refresh: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefresher,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefresher,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AutoReconnect: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefresher,
                bCount: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefresher,
                bCount: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_AutoReconnect: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefresher,
                bCount: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefresher,
                bCount: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefresher,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefresher,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_get__NewEnum(self: *const T, pUnk: ?*?*IUnknown) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const ISWbemRefresher, @ptrCast(self)), pUnk);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_Item(self: *const T, iIndex: i32, objWbemRefreshableItem: ?*?*ISWbemRefreshableItem) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).Item(@as(*const ISWbemRefresher, @ptrCast(self)), iIndex, objWbemRefreshableItem);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_get_Count(self: *const T, iCount: ?*i32) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).get_Count(@as(*const ISWbemRefresher, @ptrCast(self)), iCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_Add(self: *const T, objWbemServices: ?*ISWbemServicesEx, bsInstancePath: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemRefreshableItem: ?*?*ISWbemRefreshableItem) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).Add(@as(*const ISWbemRefresher, @ptrCast(self)), objWbemServices, bsInstancePath, iFlags, objWbemNamedValueSet, objWbemRefreshableItem);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_AddEnum(self: *const T, objWbemServices: ?*ISWbemServicesEx, bsClassName: ?BSTR, iFlags: i32, objWbemNamedValueSet: ?*IDispatch, objWbemRefreshableItem: ?*?*ISWbemRefreshableItem) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).AddEnum(@as(*const ISWbemRefresher, @ptrCast(self)), objWbemServices, bsClassName, iFlags, objWbemNamedValueSet, objWbemRefreshableItem);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_Remove(self: *const T, iIndex: i32, iFlags: i32) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).Remove(@as(*const ISWbemRefresher, @ptrCast(self)), iIndex, iFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_Refresh(self: *const T, iFlags: i32) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).Refresh(@as(*const ISWbemRefresher, @ptrCast(self)), iFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_get_AutoReconnect(self: *const T, bCount: ?*i16) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).get_AutoReconnect(@as(*const ISWbemRefresher, @ptrCast(self)), bCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_put_AutoReconnect(self: *const T, bCount: i16) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).put_AutoReconnect(@as(*const ISWbemRefresher, @ptrCast(self)), bCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefresher_DeleteAll(self: *const T) HRESULT {
                return @as(*const ISWbemRefresher.VTable, @ptrCast(self.vtable)).DeleteAll(@as(*const ISWbemRefresher, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_ISWbemRefreshableItem_Value = Guid.initString("5ad4bf92-daab-11d3-b38f-00105a1f473a");
pub const IID_ISWbemRefreshableItem = &IID_ISWbemRefreshableItem_Value;
pub const ISWbemRefreshableItem = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Index: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefreshableItem,
                iIndex: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefreshableItem,
                iIndex: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Refresher: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefreshableItem,
                objWbemRefresher: ?*?*ISWbemRefresher,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefreshableItem,
                objWbemRefresher: ?*?*ISWbemRefresher,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsSet: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefreshableItem,
                bIsSet: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefreshableItem,
                bIsSet: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Object: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefreshableItem,
                objWbemObject: ?*?*ISWbemObjectEx,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefreshableItem,
                objWbemObject: ?*?*ISWbemObjectEx,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ObjectSet: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const ISWbemRefreshableItem,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const ISWbemRefreshableItem,
                objWbemObjectSet: ?*?*ISWbemObjectSet,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISWbemRefreshableItem,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISWbemRefreshableItem,
                iFlags: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefreshableItem_get_Index(self: *const T, iIndex: ?*i32) HRESULT {
                return @as(*const ISWbemRefreshableItem.VTable, @ptrCast(self.vtable)).get_Index(@as(*const ISWbemRefreshableItem, @ptrCast(self)), iIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefreshableItem_get_Refresher(self: *const T, objWbemRefresher: ?*?*ISWbemRefresher) HRESULT {
                return @as(*const ISWbemRefreshableItem.VTable, @ptrCast(self.vtable)).get_Refresher(@as(*const ISWbemRefreshableItem, @ptrCast(self)), objWbemRefresher);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefreshableItem_get_IsSet(self: *const T, bIsSet: ?*i16) HRESULT {
                return @as(*const ISWbemRefreshableItem.VTable, @ptrCast(self.vtable)).get_IsSet(@as(*const ISWbemRefreshableItem, @ptrCast(self)), bIsSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefreshableItem_get_Object(self: *const T, objWbemObject: ?*?*ISWbemObjectEx) HRESULT {
                return @as(*const ISWbemRefreshableItem.VTable, @ptrCast(self.vtable)).get_Object(@as(*const ISWbemRefreshableItem, @ptrCast(self)), objWbemObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefreshableItem_get_ObjectSet(self: *const T, objWbemObjectSet: ?*?*ISWbemObjectSet) HRESULT {
                return @as(*const ISWbemRefreshableItem.VTable, @ptrCast(self.vtable)).get_ObjectSet(@as(*const ISWbemRefreshableItem, @ptrCast(self)), objWbemObjectSet);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISWbemRefreshableItem_Remove(self: *const T, iFlags: i32) HRESULT {
                return @as(*const ISWbemRefreshableItem.VTable, @ptrCast(self.vtable)).Remove(@as(*const ISWbemRefreshableItem, @ptrCast(self)), iFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const CLSID_WMIExtension_Value = Guid.initString("f0975afe-5c7f-11d2-8b74-00104b2afb41");
pub const CLSID_WMIExtension = &CLSID_WMIExtension_Value;

const IID_IWMIExtension_Value = Guid.initString("adc1f06e-5c7e-11d2-8b74-00104b2afb41");
pub const IID_IWMIExtension = &IID_IWMIExtension_Value;
pub const IWMIExtension = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_WMIObjectPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWMIExtension,
                strWMIObjectPath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWMIExtension,
                strWMIObjectPath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetWMIObject: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWMIExtension,
                objWMIObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWMIExtension,
                objWMIObject: ?*?*ISWbemObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetWMIServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWMIExtension,
                objWMIServices: ?*?*ISWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWMIExtension,
                objWMIServices: ?*?*ISWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWMIExtension_get_WMIObjectPath(self: *const T, strWMIObjectPath: ?*?BSTR) HRESULT {
                return @as(*const IWMIExtension.VTable, @ptrCast(self.vtable)).get_WMIObjectPath(@as(*const IWMIExtension, @ptrCast(self)), strWMIObjectPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWMIExtension_GetWMIObject(self: *const T, objWMIObject: ?*?*ISWbemObject) HRESULT {
                return @as(*const IWMIExtension.VTable, @ptrCast(self.vtable)).GetWMIObject(@as(*const IWMIExtension, @ptrCast(self)), objWMIObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWMIExtension_GetWMIServices(self: *const T, objWMIServices: ?*?*ISWbemServices) HRESULT {
                return @as(*const IWMIExtension.VTable, @ptrCast(self.vtable)).GetWMIServices(@as(*const IWMIExtension, @ptrCast(self)), objWMIServices);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const CLSID_WbemLevel1Login_Value = Guid.initString("8bc3f05e-d86b-11d0-a075-00c04fb68820");
pub const CLSID_WbemLevel1Login = &CLSID_WbemLevel1Login_Value;

const CLSID_WbemLocalAddrRes_Value = Guid.initString("a1044801-8f7e-11d1-9e7c-00c04fc324a8");
pub const CLSID_WbemLocalAddrRes = &CLSID_WbemLocalAddrRes_Value;

const CLSID_WbemUninitializedClassObject_Value = Guid.initString("7a0227f6-7108-11d1-ad90-00c04fd8fdff");
pub const CLSID_WbemUninitializedClassObject = &CLSID_WbemUninitializedClassObject_Value;

const CLSID_WbemDCOMTransport_Value = Guid.initString("f7ce2e13-8c90-11d1-9e7b-00c04fc324a8");
pub const CLSID_WbemDCOMTransport = &CLSID_WbemDCOMTransport_Value;

pub const tag_WBEM_LOGIN_TYPE = enum(i32) {
    FLAG_INPROC_LOGIN = 0,
    FLAG_LOCAL_LOGIN = 1,
    FLAG_REMOTE_LOGIN = 2,
    AUTHENTICATION_METHOD_MASK = 15,
    FLAG_USE_MULTIPLE_CHALLENGES = 16,
};
pub const WBEM_FLAG_INPROC_LOGIN = tag_WBEM_LOGIN_TYPE.FLAG_INPROC_LOGIN;
pub const WBEM_FLAG_LOCAL_LOGIN = tag_WBEM_LOGIN_TYPE.FLAG_LOCAL_LOGIN;
pub const WBEM_FLAG_REMOTE_LOGIN = tag_WBEM_LOGIN_TYPE.FLAG_REMOTE_LOGIN;
pub const WBEM_AUTHENTICATION_METHOD_MASK = tag_WBEM_LOGIN_TYPE.AUTHENTICATION_METHOD_MASK;
pub const WBEM_FLAG_USE_MULTIPLE_CHALLENGES = tag_WBEM_LOGIN_TYPE.FLAG_USE_MULTIPLE_CHALLENGES;

const IID_IWbemTransport_Value = Guid.initString("553fe584-2156-11d0-b6ae-00aa003240c7");
pub const IID_IWbemTransport = &IID_IWbemTransport_Value;
pub const IWbemTransport = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemTransport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemTransport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemTransport_Initialize(self: *const T) HRESULT {
                return @as(*const IWbemTransport.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IWbemTransport, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IWbemLevel1Login_Value = Guid.initString("f309ad18-d86a-11d0-a075-00c04fb68820");
pub const IID_IWbemLevel1Login = &IID_IWbemLevel1Login_Value;
pub const IWbemLevel1Login = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        EstablishPosition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemLevel1Login,
                wszLocaleList: ?PWSTR,
                dwNumLocales: u32,
                reserved: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemLevel1Login,
                wszLocaleList: ?PWSTR,
                dwNumLocales: u32,
                reserved: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RequestChallenge: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemLevel1Login,
                wszNetworkResource: ?PWSTR,
                wszUser: ?PWSTR,
                Nonce: ?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemLevel1Login,
                wszNetworkResource: ?PWSTR,
                wszUser: ?PWSTR,
                Nonce: ?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WBEMLogin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemLevel1Login,
                wszPreferredLocale: ?PWSTR,
                AccessToken: ?*u8,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemLevel1Login,
                wszPreferredLocale: ?PWSTR,
                AccessToken: ?*u8,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NTLMLogin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemLevel1Login,
                wszNetworkResource: ?PWSTR,
                wszPreferredLocale: ?PWSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemLevel1Login,
                wszNetworkResource: ?PWSTR,
                wszPreferredLocale: ?PWSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemLevel1Login_EstablishPosition(self: *const T, wszLocaleList: ?PWSTR, dwNumLocales: u32, reserved: ?*u32) HRESULT {
                return @as(*const IWbemLevel1Login.VTable, @ptrCast(self.vtable)).EstablishPosition(@as(*const IWbemLevel1Login, @ptrCast(self)), wszLocaleList, dwNumLocales, reserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemLevel1Login_RequestChallenge(self: *const T, wszNetworkResource: ?PWSTR, wszUser: ?PWSTR, Nonce: ?*u8) HRESULT {
                return @as(*const IWbemLevel1Login.VTable, @ptrCast(self.vtable)).RequestChallenge(@as(*const IWbemLevel1Login, @ptrCast(self)), wszNetworkResource, wszUser, Nonce);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemLevel1Login_WBEMLogin(self: *const T, wszPreferredLocale: ?PWSTR, AccessToken: ?*u8, lFlags: i32, pCtx: ?*IWbemContext, ppNamespace: ?*?*IWbemServices) HRESULT {
                return @as(*const IWbemLevel1Login.VTable, @ptrCast(self.vtable)).WBEMLogin(@as(*const IWbemLevel1Login, @ptrCast(self)), wszPreferredLocale, AccessToken, lFlags, pCtx, ppNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemLevel1Login_NTLMLogin(self: *const T, wszNetworkResource: ?PWSTR, wszPreferredLocale: ?PWSTR, lFlags: i32, pCtx: ?*IWbemContext, ppNamespace: ?*?*IWbemServices) HRESULT {
                return @as(*const IWbemLevel1Login.VTable, @ptrCast(self.vtable)).NTLMLogin(@as(*const IWbemLevel1Login, @ptrCast(self)), wszNetworkResource, wszPreferredLocale, lFlags, pCtx, ppNamespace);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IWbemConnectorLogin_Value = Guid.initString("d8ec9cb1-b135-4f10-8b1b-c7188bb0d186");
pub const IID_IWbemConnectorLogin = &IID_IWbemConnectorLogin_Value;
pub const IWbemConnectorLogin = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ConnectorLogin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConnectorLogin,
                wszNetworkResource: ?PWSTR,
                wszPreferredLocale: ?PWSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                riid: ?*const Guid,
                pInterface: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConnectorLogin,
                wszNetworkResource: ?PWSTR,
                wszPreferredLocale: ?PWSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                riid: ?*const Guid,
                pInterface: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConnectorLogin_ConnectorLogin(self: *const T, wszNetworkResource: ?PWSTR, wszPreferredLocale: ?PWSTR, lFlags: i32, pCtx: ?*IWbemContext, riid: ?*const Guid, pInterface: ?*?*anyopaque) HRESULT {
                return @as(*const IWbemConnectorLogin.VTable, @ptrCast(self.vtable)).ConnectorLogin(@as(*const IWbemConnectorLogin, @ptrCast(self)), wszNetworkResource, wszPreferredLocale, lFlags, pCtx, riid, pInterface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IWbemAddressResolution_Value = Guid.initString("f7ce2e12-8c90-11d1-9e7b-00c04fc324a8");
pub const IID_IWbemAddressResolution = &IID_IWbemAddressResolution_Value;
pub const IWbemAddressResolution = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Resolve: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemAddressResolution,
                wszNamespacePath: ?PWSTR,
                wszAddressType: ?PWSTR,
                pdwAddressLength: ?*u32,
                pabBinaryAddress: ?*?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemAddressResolution,
                wszNamespacePath: ?PWSTR,
                wszAddressType: ?PWSTR,
                pdwAddressLength: ?*u32,
                pabBinaryAddress: ?*?*u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemAddressResolution_Resolve(self: *const T, wszNamespacePath: ?PWSTR, wszAddressType: ?PWSTR, pdwAddressLength: ?*u32, pabBinaryAddress: ?*?*u8) HRESULT {
                return @as(*const IWbemAddressResolution.VTable, @ptrCast(self.vtable)).Resolve(@as(*const IWbemAddressResolution, @ptrCast(self)), wszNamespacePath, wszAddressType, pdwAddressLength, pabBinaryAddress);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IWbemClientTransport_Value = Guid.initString("f7ce2e11-8c90-11d1-9e7b-00c04fc324a8");
pub const IID_IWbemClientTransport = &IID_IWbemClientTransport_Value;
pub const IWbemClientTransport = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ConnectServer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClientTransport,
                strAddressType: ?BSTR,
                dwBinaryAddressLength: u32,
                abBinaryAddress: [*:0]u8,
                strNetworkResource: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lSecurityFlags: i32,
                strAuthority: ?BSTR,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClientTransport,
                strAddressType: ?BSTR,
                dwBinaryAddressLength: u32,
                abBinaryAddress: [*:0]u8,
                strNetworkResource: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lSecurityFlags: i32,
                strAuthority: ?BSTR,
                pCtx: ?*IWbemContext,
                ppNamespace: ?*?*IWbemServices,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClientTransport_ConnectServer(self: *const T, strAddressType: ?BSTR, dwBinaryAddressLength: u32, abBinaryAddress: [*:0]u8, strNetworkResource: ?BSTR, strUser: ?BSTR, strPassword: ?BSTR, strLocale: ?BSTR, lSecurityFlags: i32, strAuthority: ?BSTR, pCtx: ?*IWbemContext, ppNamespace: ?*?*IWbemServices) HRESULT {
                return @as(*const IWbemClientTransport.VTable, @ptrCast(self.vtable)).ConnectServer(@as(*const IWbemClientTransport, @ptrCast(self)), strAddressType, dwBinaryAddressLength, abBinaryAddress, strNetworkResource, strUser, strPassword, strLocale, lSecurityFlags, strAuthority, pCtx, ppNamespace);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IWbemClientConnectionTransport_Value = Guid.initString("a889c72a-fcc1-4a9e-af61-ed071333fb5b");
pub const IID_IWbemClientConnectionTransport = &IID_IWbemClientConnectionTransport_Value;
pub const IWbemClientConnectionTransport = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Open: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClientConnectionTransport,
                strAddressType: ?BSTR,
                dwBinaryAddressLength: u32,
                abBinaryAddress: [*:0]u8,
                strObject: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                riid: ?*const Guid,
                pInterface: ?*?*anyopaque,
                pCallRes: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClientConnectionTransport,
                strAddressType: ?BSTR,
                dwBinaryAddressLength: u32,
                abBinaryAddress: [*:0]u8,
                strObject: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                riid: ?*const Guid,
                pInterface: ?*?*anyopaque,
                pCallRes: ?*?*IWbemCallResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClientConnectionTransport,
                strAddressType: ?BSTR,
                dwBinaryAddressLength: u32,
                abBinaryAddress: [*:0]u8,
                strObject: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                riid: ?*const Guid,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClientConnectionTransport,
                strAddressType: ?BSTR,
                dwBinaryAddressLength: u32,
                abBinaryAddress: [*:0]u8,
                strObject: ?BSTR,
                strUser: ?BSTR,
                strPassword: ?BSTR,
                strLocale: ?BSTR,
                lFlags: i32,
                pCtx: ?*IWbemContext,
                riid: ?*const Guid,
                pResponseHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Cancel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemClientConnectionTransport,
                lFlags: i32,
                pHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemClientConnectionTransport,
                lFlags: i32,
                pHandler: ?*IWbemObjectSink,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClientConnectionTransport_Open(self: *const T, strAddressType: ?BSTR, dwBinaryAddressLength: u32, abBinaryAddress: [*:0]u8, strObject: ?BSTR, strUser: ?BSTR, strPassword: ?BSTR, strLocale: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, riid: ?*const Guid, pInterface: ?*?*anyopaque, pCallRes: ?*?*IWbemCallResult) HRESULT {
                return @as(*const IWbemClientConnectionTransport.VTable, @ptrCast(self.vtable)).Open(@as(*const IWbemClientConnectionTransport, @ptrCast(self)), strAddressType, dwBinaryAddressLength, abBinaryAddress, strObject, strUser, strPassword, strLocale, lFlags, pCtx, riid, pInterface, pCallRes);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClientConnectionTransport_OpenAsync(self: *const T, strAddressType: ?BSTR, dwBinaryAddressLength: u32, abBinaryAddress: [*:0]u8, strObject: ?BSTR, strUser: ?BSTR, strPassword: ?BSTR, strLocale: ?BSTR, lFlags: i32, pCtx: ?*IWbemContext, riid: ?*const Guid, pResponseHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemClientConnectionTransport.VTable, @ptrCast(self.vtable)).OpenAsync(@as(*const IWbemClientConnectionTransport, @ptrCast(self)), strAddressType, dwBinaryAddressLength, abBinaryAddress, strObject, strUser, strPassword, strLocale, lFlags, pCtx, riid, pResponseHandler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemClientConnectionTransport_Cancel(self: *const T, lFlags: i32, pHandler: ?*IWbemObjectSink) HRESULT {
                return @as(*const IWbemClientConnectionTransport.VTable, @ptrCast(self.vtable)).Cancel(@as(*const IWbemClientConnectionTransport, @ptrCast(self)), lFlags, pHandler);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IWbemConstructClassObject_Value = Guid.initString("9ef76194-70d5-11d1-ad90-00c04fd8fdff");
pub const IID_IWbemConstructClassObject = &IID_IWbemConstructClassObject_Value;
pub const IWbemConstructClassObject = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetInheritanceChain: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConstructClassObject,
                lNumAntecedents: i32,
                // TODO: what to do with BytesParamIndex 0?
                awszAntecedents: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConstructClassObject,
                lNumAntecedents: i32,
                // TODO: what to do with BytesParamIndex 0?
                awszAntecedents: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPropertyOrigin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConstructClassObject,
                wszPropertyName: ?[*:0]const u16,
                lOriginIndex: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConstructClassObject,
                wszPropertyName: ?[*:0]const u16,
                lOriginIndex: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMethodOrigin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConstructClassObject,
                wszMethodName: ?[*:0]const u16,
                lOriginIndex: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConstructClassObject,
                wszMethodName: ?[*:0]const u16,
                lOriginIndex: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetServerNamespace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWbemConstructClassObject,
                wszServer: ?[*:0]const u16,
                wszNamespace: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWbemConstructClassObject,
                wszServer: ?[*:0]const u16,
                wszNamespace: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConstructClassObject_SetInheritanceChain(self: *const T, lNumAntecedents: i32, awszAntecedents: ?*?PWSTR) HRESULT {
                return @as(*const IWbemConstructClassObject.VTable, @ptrCast(self.vtable)).SetInheritanceChain(@as(*const IWbemConstructClassObject, @ptrCast(self)), lNumAntecedents, awszAntecedents);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConstructClassObject_SetPropertyOrigin(self: *const T, wszPropertyName: ?[*:0]const u16, lOriginIndex: i32) HRESULT {
                return @as(*const IWbemConstructClassObject.VTable, @ptrCast(self.vtable)).SetPropertyOrigin(@as(*const IWbemConstructClassObject, @ptrCast(self)), wszPropertyName, lOriginIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConstructClassObject_SetMethodOrigin(self: *const T, wszMethodName: ?[*:0]const u16, lOriginIndex: i32) HRESULT {
                return @as(*const IWbemConstructClassObject.VTable, @ptrCast(self.vtable)).SetMethodOrigin(@as(*const IWbemConstructClassObject, @ptrCast(self)), wszMethodName, lOriginIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWbemConstructClassObject_SetServerNamespace(self: *const T, wszServer: ?[*:0]const u16, wszNamespace: ?[*:0]const u16) HRESULT {
                return @as(*const IWbemConstructClassObject.VTable, @ptrCast(self.vtable)).SetServerNamespace(@as(*const IWbemConstructClassObject, @ptrCast(self)), wszServer, wszNamespace);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (1)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows8.0'
pub extern "mi" fn MI_Application_InitializeV1(
    flags: u32,
    applicationID: ?*const u16,
    extendedError: ?*?*MI_Instance,
    application: ?*MI_Application,
) callconv(@import("std").os.windows.WINAPI) MI_Result;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (9)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BSTR = @import("../foundation.zig").BSTR;
const HRESULT = @import("../foundation.zig").HRESULT;
const IDispatch = @import("../system/com.zig").IDispatch;
const IUnknown = @import("../system/com.zig").IUnknown;
const PWSTR = @import("../foundation.zig").PWSTR;
const SAFEARRAY = @import("../system/com.zig").SAFEARRAY;
const VARIANT = @import("../system/com.zig").VARIANT;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "MI_ProviderFT_Load")) {
        _ = MI_ProviderFT_Load;
    }
    if (@hasDecl(@This(), "MI_ProviderFT_Unload")) {
        _ = MI_ProviderFT_Unload;
    }
    if (@hasDecl(@This(), "MI_ProviderFT_EnumerateInstances")) {
        _ = MI_ProviderFT_EnumerateInstances;
    }
    if (@hasDecl(@This(), "MI_ProviderFT_EnableIndications")) {
        _ = MI_ProviderFT_EnableIndications;
    }
    if (@hasDecl(@This(), "MI_ProviderFT_DisableIndications")) {
        _ = MI_ProviderFT_DisableIndications;
    }
    if (@hasDecl(@This(), "MI_ProviderFT_Subscribe")) {
        _ = MI_ProviderFT_Subscribe;
    }
    if (@hasDecl(@This(), "MI_ProviderFT_Unsubscribe")) {
        _ = MI_ProviderFT_Unsubscribe;
    }
    if (@hasDecl(@This(), "MI_Module_Load")) {
        _ = MI_Module_Load;
    }
    if (@hasDecl(@This(), "MI_Module_Unload")) {
        _ = MI_Module_Unload;
    }
    if (@hasDecl(@This(), "MI_CancelCallback")) {
        _ = MI_CancelCallback;
    }
    if (@hasDecl(@This(), "MI_MainFunction")) {
        _ = MI_MainFunction;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_PromptUser")) {
        _ = MI_OperationCallback_PromptUser;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_WriteError")) {
        _ = MI_OperationCallback_WriteError;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_WriteMessage")) {
        _ = MI_OperationCallback_WriteMessage;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_WriteProgress")) {
        _ = MI_OperationCallback_WriteProgress;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_Instance")) {
        _ = MI_OperationCallback_Instance;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_StreamedParameter")) {
        _ = MI_OperationCallback_StreamedParameter;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_Indication")) {
        _ = MI_OperationCallback_Indication;
    }
    if (@hasDecl(@This(), "MI_OperationCallback_Class")) {
        _ = MI_OperationCallback_Class;
    }
    if (@hasDecl(@This(), "MI_Deserializer_ClassObjectNeeded")) {
        _ = MI_Deserializer_ClassObjectNeeded;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
