//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (29)
//--------------------------------------------------------------------------------
pub const WAIT_OBJECT_0 = @as(u32, 0);
pub const WAIT_ABANDONED = @as(u32, 128);
pub const WAIT_ABANDONED_0 = @as(u32, 128);
pub const WAIT_IO_COMPLETION = @as(u32, 192);
pub const PRIVATE_NAMESPACE_FLAG_DESTROY = @as(u32, 1);
pub const PROC_THREAD_ATTRIBUTE_REPLACE_VALUE = @as(u32, 1);
pub const THREAD_POWER_THROTTLING_CURRENT_VERSION = @as(u32, 1);
pub const THREAD_POWER_THROTTLING_EXECUTION_SPEED = @as(u32, 1);
pub const THREAD_POWER_THROTTLING_VALID_FLAGS = @as(u32, 1);
pub const PME_CURRENT_VERSION = @as(u32, 1);
pub const PME_FAILFAST_ON_COMMIT_FAIL_DISABLE = @as(u32, 0);
pub const PME_FAILFAST_ON_COMMIT_FAIL_ENABLE = @as(u32, 1);
pub const PROCESS_POWER_THROTTLING_CURRENT_VERSION = @as(u32, 1);
pub const PROCESS_POWER_THROTTLING_EXECUTION_SPEED = @as(u32, 1);
pub const PROCESS_POWER_THROTTLING_IGNORE_TIMER_RESOLUTION = @as(u32, 4);
pub const PROCESS_LEAP_SECOND_INFO_FLAG_ENABLE_SIXTY_SECOND = @as(u32, 1);
pub const PROCESS_LEAP_SECOND_INFO_VALID_FLAGS = @as(u32, 1);
pub const INIT_ONCE_CHECK_ONLY = @as(u32, 1);
pub const INIT_ONCE_ASYNC = @as(u32, 2);
pub const INIT_ONCE_INIT_FAILED = @as(u32, 4);
pub const INIT_ONCE_CTX_RESERVED_BITS = @as(u32, 2);
pub const CONDITION_VARIABLE_LOCKMODE_SHARED = @as(u32, 1);
pub const MUTEX_MODIFY_STATE = @as(u32, 1);
pub const CREATE_MUTEX_INITIAL_OWNER = @as(u32, 1);
pub const CREATE_WAITABLE_TIMER_MANUAL_RESET = @as(u32, 1);
pub const CREATE_WAITABLE_TIMER_HIGH_RESOLUTION = @as(u32, 2);
pub const SYNCHRONIZATION_BARRIER_FLAGS_SPIN_ONLY = @as(u32, 1);
pub const SYNCHRONIZATION_BARRIER_FLAGS_BLOCK_ONLY = @as(u32, 2);
pub const SYNCHRONIZATION_BARRIER_FLAGS_NO_DELETE = @as(u32, 4);

//--------------------------------------------------------------------------------
// Section: Types (84)
//--------------------------------------------------------------------------------
pub const THREAD_CREATION_FLAGS = enum(u32) {
    THREAD_CREATE_RUN_IMMEDIATELY = 0,
    THREAD_CREATE_SUSPENDED = 4,
    STACK_SIZE_PARAM_IS_A_RESERVATION = 65536,
    _,
    pub fn initFlags(o: struct {
        THREAD_CREATE_RUN_IMMEDIATELY: u1 = 0,
        THREAD_CREATE_SUSPENDED: u1 = 0,
        STACK_SIZE_PARAM_IS_A_RESERVATION: u1 = 0,
    }) THREAD_CREATION_FLAGS {
        return @as(THREAD_CREATION_FLAGS, @enumFromInt((if (o.THREAD_CREATE_RUN_IMMEDIATELY == 1) @intFromEnum(THREAD_CREATION_FLAGS.THREAD_CREATE_RUN_IMMEDIATELY) else 0) | (if (o.THREAD_CREATE_SUSPENDED == 1) @intFromEnum(THREAD_CREATION_FLAGS.THREAD_CREATE_SUSPENDED) else 0) | (if (o.STACK_SIZE_PARAM_IS_A_RESERVATION == 1) @intFromEnum(THREAD_CREATION_FLAGS.STACK_SIZE_PARAM_IS_A_RESERVATION) else 0)));
    }
};
pub const THREAD_CREATE_RUN_IMMEDIATELY = THREAD_CREATION_FLAGS.THREAD_CREATE_RUN_IMMEDIATELY;
pub const THREAD_CREATE_SUSPENDED = THREAD_CREATION_FLAGS.THREAD_CREATE_SUSPENDED;
pub const STACK_SIZE_PARAM_IS_A_RESERVATION = THREAD_CREATION_FLAGS.STACK_SIZE_PARAM_IS_A_RESERVATION;

pub const THREAD_PRIORITY = enum(i32) {
    MODE_BACKGROUND_BEGIN = 65536,
    MODE_BACKGROUND_END = 131072,
    PRIORITY_ABOVE_NORMAL = 1,
    PRIORITY_BELOW_NORMAL = -1,
    PRIORITY_HIGHEST = 2,
    PRIORITY_IDLE = -15,
    PRIORITY_MIN = -2,
    // PRIORITY_LOWEST = -2, this enum value conflicts with PRIORITY_MIN
    PRIORITY_NORMAL = 0,
    PRIORITY_TIME_CRITICAL = 15,
};
pub const THREAD_MODE_BACKGROUND_BEGIN = THREAD_PRIORITY.MODE_BACKGROUND_BEGIN;
pub const THREAD_MODE_BACKGROUND_END = THREAD_PRIORITY.MODE_BACKGROUND_END;
pub const THREAD_PRIORITY_ABOVE_NORMAL = THREAD_PRIORITY.PRIORITY_ABOVE_NORMAL;
pub const THREAD_PRIORITY_BELOW_NORMAL = THREAD_PRIORITY.PRIORITY_BELOW_NORMAL;
pub const THREAD_PRIORITY_HIGHEST = THREAD_PRIORITY.PRIORITY_HIGHEST;
pub const THREAD_PRIORITY_IDLE = THREAD_PRIORITY.PRIORITY_IDLE;
pub const THREAD_PRIORITY_MIN = THREAD_PRIORITY.PRIORITY_MIN;
pub const THREAD_PRIORITY_LOWEST = THREAD_PRIORITY.PRIORITY_MIN;
pub const THREAD_PRIORITY_NORMAL = THREAD_PRIORITY.PRIORITY_NORMAL;
pub const THREAD_PRIORITY_TIME_CRITICAL = THREAD_PRIORITY.PRIORITY_TIME_CRITICAL;

pub const WORKER_THREAD_FLAGS = enum(u32) {
    EXECUTEDEFAULT = 0,
    EXECUTEINIOTHREAD = 1,
    EXECUTEINPERSISTENTTHREAD = 128,
    EXECUTEINWAITTHREAD = 4,
    EXECUTELONGFUNCTION = 16,
    EXECUTEONLYONCE = 8,
    TRANSFER_IMPERSONATION = 256,
    EXECUTEINTIMERTHREAD = 32,
    _,
    pub fn initFlags(o: struct {
        EXECUTEDEFAULT: u1 = 0,
        EXECUTEINIOTHREAD: u1 = 0,
        EXECUTEINPERSISTENTTHREAD: u1 = 0,
        EXECUTEINWAITTHREAD: u1 = 0,
        EXECUTELONGFUNCTION: u1 = 0,
        EXECUTEONLYONCE: u1 = 0,
        TRANSFER_IMPERSONATION: u1 = 0,
        EXECUTEINTIMERTHREAD: u1 = 0,
    }) WORKER_THREAD_FLAGS {
        return @as(WORKER_THREAD_FLAGS, @enumFromInt((if (o.EXECUTEDEFAULT == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTEDEFAULT) else 0) | (if (o.EXECUTEINIOTHREAD == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTEINIOTHREAD) else 0) | (if (o.EXECUTEINPERSISTENTTHREAD == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTEINPERSISTENTTHREAD) else 0) | (if (o.EXECUTEINWAITTHREAD == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTEINWAITTHREAD) else 0) | (if (o.EXECUTELONGFUNCTION == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTELONGFUNCTION) else 0) | (if (o.EXECUTEONLYONCE == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTEONLYONCE) else 0) | (if (o.TRANSFER_IMPERSONATION == 1) @intFromEnum(WORKER_THREAD_FLAGS.TRANSFER_IMPERSONATION) else 0) | (if (o.EXECUTEINTIMERTHREAD == 1) @intFromEnum(WORKER_THREAD_FLAGS.EXECUTEINTIMERTHREAD) else 0)));
    }
};
pub const WT_EXECUTEDEFAULT = WORKER_THREAD_FLAGS.EXECUTEDEFAULT;
pub const WT_EXECUTEINIOTHREAD = WORKER_THREAD_FLAGS.EXECUTEINIOTHREAD;
pub const WT_EXECUTEINPERSISTENTTHREAD = WORKER_THREAD_FLAGS.EXECUTEINPERSISTENTTHREAD;
pub const WT_EXECUTEINWAITTHREAD = WORKER_THREAD_FLAGS.EXECUTEINWAITTHREAD;
pub const WT_EXECUTELONGFUNCTION = WORKER_THREAD_FLAGS.EXECUTELONGFUNCTION;
pub const WT_EXECUTEONLYONCE = WORKER_THREAD_FLAGS.EXECUTEONLYONCE;
pub const WT_TRANSFER_IMPERSONATION = WORKER_THREAD_FLAGS.TRANSFER_IMPERSONATION;
pub const WT_EXECUTEINTIMERTHREAD = WORKER_THREAD_FLAGS.EXECUTEINTIMERTHREAD;

pub const CREATE_EVENT = enum(u32) {
    INITIAL_SET = 2,
    MANUAL_RESET = 1,
    _,
    pub fn initFlags(o: struct {
        INITIAL_SET: u1 = 0,
        MANUAL_RESET: u1 = 0,
    }) CREATE_EVENT {
        return @as(CREATE_EVENT, @enumFromInt((if (o.INITIAL_SET == 1) @intFromEnum(CREATE_EVENT.INITIAL_SET) else 0) | (if (o.MANUAL_RESET == 1) @intFromEnum(CREATE_EVENT.MANUAL_RESET) else 0)));
    }
};
pub const CREATE_EVENT_INITIAL_SET = CREATE_EVENT.INITIAL_SET;
pub const CREATE_EVENT_MANUAL_RESET = CREATE_EVENT.MANUAL_RESET;

pub const CREATE_PROCESS_LOGON_FLAGS = enum(u32) {
    WITH_PROFILE = 1,
    NETCREDENTIALS_ONLY = 2,
};
pub const LOGON_WITH_PROFILE = CREATE_PROCESS_LOGON_FLAGS.WITH_PROFILE;
pub const LOGON_NETCREDENTIALS_ONLY = CREATE_PROCESS_LOGON_FLAGS.NETCREDENTIALS_ONLY;

pub const PROCESS_AFFINITY_AUTO_UPDATE_FLAGS = enum(u32) {
    DISABLE_AUTO_UPDATE = 0,
    ENABLE_AUTO_UPDATE = 1,
};
pub const PROCESS_AFFINITY_DISABLE_AUTO_UPDATE = PROCESS_AFFINITY_AUTO_UPDATE_FLAGS.DISABLE_AUTO_UPDATE;
pub const PROCESS_AFFINITY_ENABLE_AUTO_UPDATE = PROCESS_AFFINITY_AUTO_UPDATE_FLAGS.ENABLE_AUTO_UPDATE;

pub const PROCESS_DEP_FLAGS = enum(u32) {
    ENABLE = 1,
    DISABLE_ATL_THUNK_EMULATION = 2,
    NONE = 0,
    _,
    pub fn initFlags(o: struct {
        ENABLE: u1 = 0,
        DISABLE_ATL_THUNK_EMULATION: u1 = 0,
        NONE: u1 = 0,
    }) PROCESS_DEP_FLAGS {
        return @as(PROCESS_DEP_FLAGS, @enumFromInt((if (o.ENABLE == 1) @intFromEnum(PROCESS_DEP_FLAGS.ENABLE) else 0) | (if (o.DISABLE_ATL_THUNK_EMULATION == 1) @intFromEnum(PROCESS_DEP_FLAGS.DISABLE_ATL_THUNK_EMULATION) else 0) | (if (o.NONE == 1) @intFromEnum(PROCESS_DEP_FLAGS.NONE) else 0)));
    }
};
pub const PROCESS_DEP_ENABLE = PROCESS_DEP_FLAGS.ENABLE;
pub const PROCESS_DEP_DISABLE_ATL_THUNK_EMULATION = PROCESS_DEP_FLAGS.DISABLE_ATL_THUNK_EMULATION;
pub const PROCESS_DEP_NONE = PROCESS_DEP_FLAGS.NONE;

pub const PROCESS_NAME_FORMAT = enum(u32) {
    WIN32 = 0,
    NATIVE = 1,
};
pub const PROCESS_NAME_WIN32 = PROCESS_NAME_FORMAT.WIN32;
pub const PROCESS_NAME_NATIVE = PROCESS_NAME_FORMAT.NATIVE;

pub const PROCESSOR_FEATURE_ID = enum(u32) {
    ARM_64BIT_LOADSTORE_ATOMIC = 25,
    ARM_DIVIDE_INSTRUCTION_AVAILABLE = 24,
    ARM_EXTERNAL_CACHE_AVAILABLE = 26,
    ARM_FMAC_INSTRUCTIONS_AVAILABLE = 27,
    ARM_VFP_32_REGISTERS_AVAILABLE = 18,
    @"3DNOW_INSTRUCTIONS_AVAILABLE" = 7,
    CHANNELS_ENABLED = 16,
    COMPARE_EXCHANGE_DOUBLE = 2,
    COMPARE_EXCHANGE128 = 14,
    COMPARE64_EXCHANGE128 = 15,
    FASTFAIL_AVAILABLE = 23,
    FLOATING_POINT_EMULATED = 1,
    FLOATING_POINT_PRECISION_ERRATA = 0,
    MMX_INSTRUCTIONS_AVAILABLE = 3,
    NX_ENABLED = 12,
    PAE_ENABLED = 9,
    RDTSC_INSTRUCTION_AVAILABLE = 8,
    RDWRFSGSBASE_AVAILABLE = 22,
    SECOND_LEVEL_ADDRESS_TRANSLATION = 20,
    SSE3_INSTRUCTIONS_AVAILABLE = 13,
    VIRT_FIRMWARE_ENABLED = 21,
    XMMI_INSTRUCTIONS_AVAILABLE = 6,
    XMMI64_INSTRUCTIONS_AVAILABLE = 10,
    XSAVE_ENABLED = 17,
    ARM_V8_INSTRUCTIONS_AVAILABLE = 29,
    ARM_V8_CRYPTO_INSTRUCTIONS_AVAILABLE = 30,
    ARM_V8_CRC32_INSTRUCTIONS_AVAILABLE = 31,
    ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE = 34,
};
pub const PF_ARM_64BIT_LOADSTORE_ATOMIC = PROCESSOR_FEATURE_ID.ARM_64BIT_LOADSTORE_ATOMIC;
pub const PF_ARM_DIVIDE_INSTRUCTION_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_DIVIDE_INSTRUCTION_AVAILABLE;
pub const PF_ARM_EXTERNAL_CACHE_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_EXTERNAL_CACHE_AVAILABLE;
pub const PF_ARM_FMAC_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_FMAC_INSTRUCTIONS_AVAILABLE;
pub const PF_ARM_VFP_32_REGISTERS_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_VFP_32_REGISTERS_AVAILABLE;
pub const PF_3DNOW_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.@"3DNOW_INSTRUCTIONS_AVAILABLE";
pub const PF_CHANNELS_ENABLED = PROCESSOR_FEATURE_ID.CHANNELS_ENABLED;
pub const PF_COMPARE_EXCHANGE_DOUBLE = PROCESSOR_FEATURE_ID.COMPARE_EXCHANGE_DOUBLE;
pub const PF_COMPARE_EXCHANGE128 = PROCESSOR_FEATURE_ID.COMPARE_EXCHANGE128;
pub const PF_COMPARE64_EXCHANGE128 = PROCESSOR_FEATURE_ID.COMPARE64_EXCHANGE128;
pub const PF_FASTFAIL_AVAILABLE = PROCESSOR_FEATURE_ID.FASTFAIL_AVAILABLE;
pub const PF_FLOATING_POINT_EMULATED = PROCESSOR_FEATURE_ID.FLOATING_POINT_EMULATED;
pub const PF_FLOATING_POINT_PRECISION_ERRATA = PROCESSOR_FEATURE_ID.FLOATING_POINT_PRECISION_ERRATA;
pub const PF_MMX_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.MMX_INSTRUCTIONS_AVAILABLE;
pub const PF_NX_ENABLED = PROCESSOR_FEATURE_ID.NX_ENABLED;
pub const PF_PAE_ENABLED = PROCESSOR_FEATURE_ID.PAE_ENABLED;
pub const PF_RDTSC_INSTRUCTION_AVAILABLE = PROCESSOR_FEATURE_ID.RDTSC_INSTRUCTION_AVAILABLE;
pub const PF_RDWRFSGSBASE_AVAILABLE = PROCESSOR_FEATURE_ID.RDWRFSGSBASE_AVAILABLE;
pub const PF_SECOND_LEVEL_ADDRESS_TRANSLATION = PROCESSOR_FEATURE_ID.SECOND_LEVEL_ADDRESS_TRANSLATION;
pub const PF_SSE3_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.SSE3_INSTRUCTIONS_AVAILABLE;
pub const PF_VIRT_FIRMWARE_ENABLED = PROCESSOR_FEATURE_ID.VIRT_FIRMWARE_ENABLED;
pub const PF_XMMI_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.XMMI_INSTRUCTIONS_AVAILABLE;
pub const PF_XMMI64_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.XMMI64_INSTRUCTIONS_AVAILABLE;
pub const PF_XSAVE_ENABLED = PROCESSOR_FEATURE_ID.XSAVE_ENABLED;
pub const PF_ARM_V8_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_V8_INSTRUCTIONS_AVAILABLE;
pub const PF_ARM_V8_CRYPTO_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_V8_CRYPTO_INSTRUCTIONS_AVAILABLE;
pub const PF_ARM_V8_CRC32_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_V8_CRC32_INSTRUCTIONS_AVAILABLE;
pub const PF_ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE = PROCESSOR_FEATURE_ID.ARM_V81_ATOMIC_INSTRUCTIONS_AVAILABLE;

pub const GET_GUI_RESOURCES_FLAGS = enum(u32) {
    GDIOBJECTS = 0,
    GDIOBJECTS_PEAK = 2,
    USEROBJECTS = 1,
    USEROBJECTS_PEAK = 4,
};
pub const GR_GDIOBJECTS = GET_GUI_RESOURCES_FLAGS.GDIOBJECTS;
pub const GR_GDIOBJECTS_PEAK = GET_GUI_RESOURCES_FLAGS.GDIOBJECTS_PEAK;
pub const GR_USEROBJECTS = GET_GUI_RESOURCES_FLAGS.USEROBJECTS;
pub const GR_USEROBJECTS_PEAK = GET_GUI_RESOURCES_FLAGS.USEROBJECTS_PEAK;

pub const STARTUPINFOW_FLAGS = enum(u32) {
    FORCEONFEEDBACK = 64,
    FORCEOFFFEEDBACK = 128,
    PREVENTPINNING = 8192,
    RUNFULLSCREEN = 32,
    TITLEISAPPID = 4096,
    TITLEISLINKNAME = 2048,
    UNTRUSTEDSOURCE = 32768,
    USECOUNTCHARS = 8,
    USEFILLATTRIBUTE = 16,
    USEHOTKEY = 512,
    USEPOSITION = 4,
    USESHOWWINDOW = 1,
    USESIZE = 2,
    USESTDHANDLES = 256,
    _,
    pub fn initFlags(o: struct {
        FORCEONFEEDBACK: u1 = 0,
        FORCEOFFFEEDBACK: u1 = 0,
        PREVENTPINNING: u1 = 0,
        RUNFULLSCREEN: u1 = 0,
        TITLEISAPPID: u1 = 0,
        TITLEISLINKNAME: u1 = 0,
        UNTRUSTEDSOURCE: u1 = 0,
        USECOUNTCHARS: u1 = 0,
        USEFILLATTRIBUTE: u1 = 0,
        USEHOTKEY: u1 = 0,
        USEPOSITION: u1 = 0,
        USESHOWWINDOW: u1 = 0,
        USESIZE: u1 = 0,
        USESTDHANDLES: u1 = 0,
    }) STARTUPINFOW_FLAGS {
        return @as(STARTUPINFOW_FLAGS, @enumFromInt((if (o.FORCEONFEEDBACK == 1) @intFromEnum(STARTUPINFOW_FLAGS.FORCEONFEEDBACK) else 0) | (if (o.FORCEOFFFEEDBACK == 1) @intFromEnum(STARTUPINFOW_FLAGS.FORCEOFFFEEDBACK) else 0) | (if (o.PREVENTPINNING == 1) @intFromEnum(STARTUPINFOW_FLAGS.PREVENTPINNING) else 0) | (if (o.RUNFULLSCREEN == 1) @intFromEnum(STARTUPINFOW_FLAGS.RUNFULLSCREEN) else 0) | (if (o.TITLEISAPPID == 1) @intFromEnum(STARTUPINFOW_FLAGS.TITLEISAPPID) else 0) | (if (o.TITLEISLINKNAME == 1) @intFromEnum(STARTUPINFOW_FLAGS.TITLEISLINKNAME) else 0) | (if (o.UNTRUSTEDSOURCE == 1) @intFromEnum(STARTUPINFOW_FLAGS.UNTRUSTEDSOURCE) else 0) | (if (o.USECOUNTCHARS == 1) @intFromEnum(STARTUPINFOW_FLAGS.USECOUNTCHARS) else 0) | (if (o.USEFILLATTRIBUTE == 1) @intFromEnum(STARTUPINFOW_FLAGS.USEFILLATTRIBUTE) else 0) | (if (o.USEHOTKEY == 1) @intFromEnum(STARTUPINFOW_FLAGS.USEHOTKEY) else 0) | (if (o.USEPOSITION == 1) @intFromEnum(STARTUPINFOW_FLAGS.USEPOSITION) else 0) | (if (o.USESHOWWINDOW == 1) @intFromEnum(STARTUPINFOW_FLAGS.USESHOWWINDOW) else 0) | (if (o.USESIZE == 1) @intFromEnum(STARTUPINFOW_FLAGS.USESIZE) else 0) | (if (o.USESTDHANDLES == 1) @intFromEnum(STARTUPINFOW_FLAGS.USESTDHANDLES) else 0)));
    }
};
pub const STARTF_FORCEONFEEDBACK = STARTUPINFOW_FLAGS.FORCEONFEEDBACK;
pub const STARTF_FORCEOFFFEEDBACK = STARTUPINFOW_FLAGS.FORCEOFFFEEDBACK;
pub const STARTF_PREVENTPINNING = STARTUPINFOW_FLAGS.PREVENTPINNING;
pub const STARTF_RUNFULLSCREEN = STARTUPINFOW_FLAGS.RUNFULLSCREEN;
pub const STARTF_TITLEISAPPID = STARTUPINFOW_FLAGS.TITLEISAPPID;
pub const STARTF_TITLEISLINKNAME = STARTUPINFOW_FLAGS.TITLEISLINKNAME;
pub const STARTF_UNTRUSTEDSOURCE = STARTUPINFOW_FLAGS.UNTRUSTEDSOURCE;
pub const STARTF_USECOUNTCHARS = STARTUPINFOW_FLAGS.USECOUNTCHARS;
pub const STARTF_USEFILLATTRIBUTE = STARTUPINFOW_FLAGS.USEFILLATTRIBUTE;
pub const STARTF_USEHOTKEY = STARTUPINFOW_FLAGS.USEHOTKEY;
pub const STARTF_USEPOSITION = STARTUPINFOW_FLAGS.USEPOSITION;
pub const STARTF_USESHOWWINDOW = STARTUPINFOW_FLAGS.USESHOWWINDOW;
pub const STARTF_USESIZE = STARTUPINFOW_FLAGS.USESIZE;
pub const STARTF_USESTDHANDLES = STARTUPINFOW_FLAGS.USESTDHANDLES;

pub const MEMORY_PRIORITY = enum(u32) {
    VERY_LOW = 1,
    LOW = 2,
    MEDIUM = 3,
    BELOW_NORMAL = 4,
    NORMAL = 5,
};
pub const MEMORY_PRIORITY_VERY_LOW = MEMORY_PRIORITY.VERY_LOW;
pub const MEMORY_PRIORITY_LOW = MEMORY_PRIORITY.LOW;
pub const MEMORY_PRIORITY_MEDIUM = MEMORY_PRIORITY.MEDIUM;
pub const MEMORY_PRIORITY_BELOW_NORMAL = MEMORY_PRIORITY.BELOW_NORMAL;
pub const MEMORY_PRIORITY_NORMAL = MEMORY_PRIORITY.NORMAL;

pub const PROCESS_PROTECTION_LEVEL = enum(u32) {
    WINTCB_LIGHT = 0,
    WINDOWS = 1,
    WINDOWS_LIGHT = 2,
    ANTIMALWARE_LIGHT = 3,
    LSA_LIGHT = 4,
    WINTCB = 5,
    CODEGEN_LIGHT = 6,
    AUTHENTICODE = 7,
    PPL_APP = 8,
    NONE = 4294967294,
};
pub const PROTECTION_LEVEL_WINTCB_LIGHT = PROCESS_PROTECTION_LEVEL.WINTCB_LIGHT;
pub const PROTECTION_LEVEL_WINDOWS = PROCESS_PROTECTION_LEVEL.WINDOWS;
pub const PROTECTION_LEVEL_WINDOWS_LIGHT = PROCESS_PROTECTION_LEVEL.WINDOWS_LIGHT;
pub const PROTECTION_LEVEL_ANTIMALWARE_LIGHT = PROCESS_PROTECTION_LEVEL.ANTIMALWARE_LIGHT;
pub const PROTECTION_LEVEL_LSA_LIGHT = PROCESS_PROTECTION_LEVEL.LSA_LIGHT;
pub const PROTECTION_LEVEL_WINTCB = PROCESS_PROTECTION_LEVEL.WINTCB;
pub const PROTECTION_LEVEL_CODEGEN_LIGHT = PROCESS_PROTECTION_LEVEL.CODEGEN_LIGHT;
pub const PROTECTION_LEVEL_AUTHENTICODE = PROCESS_PROTECTION_LEVEL.AUTHENTICODE;
pub const PROTECTION_LEVEL_PPL_APP = PROCESS_PROTECTION_LEVEL.PPL_APP;
pub const PROTECTION_LEVEL_NONE = PROCESS_PROTECTION_LEVEL.NONE;

pub const POWER_REQUEST_CONTEXT_FLAGS = enum(u32) {
    DETAILED_STRING = 2,
    SIMPLE_STRING = 1,
};
pub const POWER_REQUEST_CONTEXT_DETAILED_STRING = POWER_REQUEST_CONTEXT_FLAGS.DETAILED_STRING;
pub const POWER_REQUEST_CONTEXT_SIMPLE_STRING = POWER_REQUEST_CONTEXT_FLAGS.SIMPLE_STRING;

pub const THREAD_ACCESS_RIGHTS = enum(u32) {
    TERMINATE = 1,
    SUSPEND_RESUME = 2,
    GET_CONTEXT = 8,
    SET_CONTEXT = 16,
    SET_INFORMATION = 32,
    QUERY_INFORMATION = 64,
    SET_THREAD_TOKEN = 128,
    IMPERSONATE = 256,
    DIRECT_IMPERSONATION = 512,
    SET_LIMITED_INFORMATION = 1024,
    QUERY_LIMITED_INFORMATION = 2048,
    RESUME = 4096,
    ALL_ACCESS = 2097151,
    DELETE = 65536,
    READ_CONTROL = 131072,
    WRITE_DAC = 262144,
    WRITE_OWNER = 524288,
    SYNCHRONIZE = 1048576,
    STANDARD_RIGHTS_REQUIRED = 983040,
    _,
    pub fn initFlags(o: struct {
        TERMINATE: u1 = 0,
        SUSPEND_RESUME: u1 = 0,
        GET_CONTEXT: u1 = 0,
        SET_CONTEXT: u1 = 0,
        SET_INFORMATION: u1 = 0,
        QUERY_INFORMATION: u1 = 0,
        SET_THREAD_TOKEN: u1 = 0,
        IMPERSONATE: u1 = 0,
        DIRECT_IMPERSONATION: u1 = 0,
        SET_LIMITED_INFORMATION: u1 = 0,
        QUERY_LIMITED_INFORMATION: u1 = 0,
        RESUME: u1 = 0,
        ALL_ACCESS: u1 = 0,
        DELETE: u1 = 0,
        READ_CONTROL: u1 = 0,
        WRITE_DAC: u1 = 0,
        WRITE_OWNER: u1 = 0,
        SYNCHRONIZE: u1 = 0,
        STANDARD_RIGHTS_REQUIRED: u1 = 0,
    }) THREAD_ACCESS_RIGHTS {
        return @as(THREAD_ACCESS_RIGHTS, @enumFromInt((if (o.TERMINATE == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.TERMINATE) else 0) | (if (o.SUSPEND_RESUME == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.SUSPEND_RESUME) else 0) | (if (o.GET_CONTEXT == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.GET_CONTEXT) else 0) | (if (o.SET_CONTEXT == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.SET_CONTEXT) else 0) | (if (o.SET_INFORMATION == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.SET_INFORMATION) else 0) | (if (o.QUERY_INFORMATION == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.QUERY_INFORMATION) else 0) | (if (o.SET_THREAD_TOKEN == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.SET_THREAD_TOKEN) else 0) | (if (o.IMPERSONATE == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.IMPERSONATE) else 0) | (if (o.DIRECT_IMPERSONATION == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.DIRECT_IMPERSONATION) else 0) | (if (o.SET_LIMITED_INFORMATION == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.SET_LIMITED_INFORMATION) else 0) | (if (o.QUERY_LIMITED_INFORMATION == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.QUERY_LIMITED_INFORMATION) else 0) | (if (o.RESUME == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.RESUME) else 0) | (if (o.ALL_ACCESS == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.ALL_ACCESS) else 0) | (if (o.DELETE == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.DELETE) else 0) | (if (o.READ_CONTROL == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.READ_CONTROL) else 0) | (if (o.WRITE_DAC == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.WRITE_DAC) else 0) | (if (o.WRITE_OWNER == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.WRITE_OWNER) else 0) | (if (o.SYNCHRONIZE == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.SYNCHRONIZE) else 0) | (if (o.STANDARD_RIGHTS_REQUIRED == 1) @intFromEnum(THREAD_ACCESS_RIGHTS.STANDARD_RIGHTS_REQUIRED) else 0)));
    }
};
pub const THREAD_TERMINATE = THREAD_ACCESS_RIGHTS.TERMINATE;
pub const THREAD_SUSPEND_RESUME = THREAD_ACCESS_RIGHTS.SUSPEND_RESUME;
pub const THREAD_GET_CONTEXT = THREAD_ACCESS_RIGHTS.GET_CONTEXT;
pub const THREAD_SET_CONTEXT = THREAD_ACCESS_RIGHTS.SET_CONTEXT;
pub const THREAD_SET_INFORMATION = THREAD_ACCESS_RIGHTS.SET_INFORMATION;
pub const THREAD_QUERY_INFORMATION = THREAD_ACCESS_RIGHTS.QUERY_INFORMATION;
pub const THREAD_SET_THREAD_TOKEN = THREAD_ACCESS_RIGHTS.SET_THREAD_TOKEN;
pub const THREAD_IMPERSONATE = THREAD_ACCESS_RIGHTS.IMPERSONATE;
pub const THREAD_DIRECT_IMPERSONATION = THREAD_ACCESS_RIGHTS.DIRECT_IMPERSONATION;
pub const THREAD_SET_LIMITED_INFORMATION = THREAD_ACCESS_RIGHTS.SET_LIMITED_INFORMATION;
pub const THREAD_QUERY_LIMITED_INFORMATION = THREAD_ACCESS_RIGHTS.QUERY_LIMITED_INFORMATION;
pub const THREAD_RESUME = THREAD_ACCESS_RIGHTS.RESUME;
pub const THREAD_ALL_ACCESS = THREAD_ACCESS_RIGHTS.ALL_ACCESS;
pub const THREAD_DELETE = THREAD_ACCESS_RIGHTS.DELETE;
pub const THREAD_READ_CONTROL = THREAD_ACCESS_RIGHTS.READ_CONTROL;
pub const THREAD_WRITE_DAC = THREAD_ACCESS_RIGHTS.WRITE_DAC;
pub const THREAD_WRITE_OWNER = THREAD_ACCESS_RIGHTS.WRITE_OWNER;
pub const THREAD_SYNCHRONIZE = THREAD_ACCESS_RIGHTS.SYNCHRONIZE;
pub const THREAD_STANDARD_RIGHTS_REQUIRED = THREAD_ACCESS_RIGHTS.STANDARD_RIGHTS_REQUIRED;

pub const PROCESS_CREATION_FLAGS = enum(u32) {
    DEBUG_PROCESS = 1,
    DEBUG_ONLY_THIS_PROCESS = 2,
    CREATE_SUSPENDED = 4,
    DETACHED_PROCESS = 8,
    CREATE_NEW_CONSOLE = 16,
    NORMAL_PRIORITY_CLASS = 32,
    IDLE_PRIORITY_CLASS = 64,
    HIGH_PRIORITY_CLASS = 128,
    REALTIME_PRIORITY_CLASS = 256,
    CREATE_NEW_PROCESS_GROUP = 512,
    CREATE_UNICODE_ENVIRONMENT = 1024,
    CREATE_SEPARATE_WOW_VDM = 2048,
    CREATE_SHARED_WOW_VDM = 4096,
    CREATE_FORCEDOS = 8192,
    BELOW_NORMAL_PRIORITY_CLASS = 16384,
    ABOVE_NORMAL_PRIORITY_CLASS = 32768,
    INHERIT_PARENT_AFFINITY = 65536,
    INHERIT_CALLER_PRIORITY = 131072,
    CREATE_PROTECTED_PROCESS = 262144,
    EXTENDED_STARTUPINFO_PRESENT = 524288,
    PROCESS_MODE_BACKGROUND_BEGIN = 1048576,
    PROCESS_MODE_BACKGROUND_END = 2097152,
    CREATE_SECURE_PROCESS = 4194304,
    CREATE_BREAKAWAY_FROM_JOB = 16777216,
    CREATE_PRESERVE_CODE_AUTHZ_LEVEL = 33554432,
    CREATE_DEFAULT_ERROR_MODE = 67108864,
    CREATE_NO_WINDOW = 134217728,
    PROFILE_USER = 268435456,
    PROFILE_KERNEL = 536870912,
    PROFILE_SERVER = 1073741824,
    CREATE_IGNORE_SYSTEM_DEFAULT = 2147483648,
    _,
    pub fn initFlags(o: struct {
        DEBUG_PROCESS: u1 = 0,
        DEBUG_ONLY_THIS_PROCESS: u1 = 0,
        CREATE_SUSPENDED: u1 = 0,
        DETACHED_PROCESS: u1 = 0,
        CREATE_NEW_CONSOLE: u1 = 0,
        NORMAL_PRIORITY_CLASS: u1 = 0,
        IDLE_PRIORITY_CLASS: u1 = 0,
        HIGH_PRIORITY_CLASS: u1 = 0,
        REALTIME_PRIORITY_CLASS: u1 = 0,
        CREATE_NEW_PROCESS_GROUP: u1 = 0,
        CREATE_UNICODE_ENVIRONMENT: u1 = 0,
        CREATE_SEPARATE_WOW_VDM: u1 = 0,
        CREATE_SHARED_WOW_VDM: u1 = 0,
        CREATE_FORCEDOS: u1 = 0,
        BELOW_NORMAL_PRIORITY_CLASS: u1 = 0,
        ABOVE_NORMAL_PRIORITY_CLASS: u1 = 0,
        INHERIT_PARENT_AFFINITY: u1 = 0,
        INHERIT_CALLER_PRIORITY: u1 = 0,
        CREATE_PROTECTED_PROCESS: u1 = 0,
        EXTENDED_STARTUPINFO_PRESENT: u1 = 0,
        PROCESS_MODE_BACKGROUND_BEGIN: u1 = 0,
        PROCESS_MODE_BACKGROUND_END: u1 = 0,
        CREATE_SECURE_PROCESS: u1 = 0,
        CREATE_BREAKAWAY_FROM_JOB: u1 = 0,
        CREATE_PRESERVE_CODE_AUTHZ_LEVEL: u1 = 0,
        CREATE_DEFAULT_ERROR_MODE: u1 = 0,
        CREATE_NO_WINDOW: u1 = 0,
        PROFILE_USER: u1 = 0,
        PROFILE_KERNEL: u1 = 0,
        PROFILE_SERVER: u1 = 0,
        CREATE_IGNORE_SYSTEM_DEFAULT: u1 = 0,
    }) PROCESS_CREATION_FLAGS {
        return @as(PROCESS_CREATION_FLAGS, @enumFromInt((if (o.DEBUG_PROCESS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.DEBUG_PROCESS) else 0) | (if (o.DEBUG_ONLY_THIS_PROCESS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.DEBUG_ONLY_THIS_PROCESS) else 0) | (if (o.CREATE_SUSPENDED == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_SUSPENDED) else 0) | (if (o.DETACHED_PROCESS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.DETACHED_PROCESS) else 0) | (if (o.CREATE_NEW_CONSOLE == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_NEW_CONSOLE) else 0) | (if (o.NORMAL_PRIORITY_CLASS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.NORMAL_PRIORITY_CLASS) else 0) | (if (o.IDLE_PRIORITY_CLASS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.IDLE_PRIORITY_CLASS) else 0) | (if (o.HIGH_PRIORITY_CLASS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.HIGH_PRIORITY_CLASS) else 0) | (if (o.REALTIME_PRIORITY_CLASS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.REALTIME_PRIORITY_CLASS) else 0) | (if (o.CREATE_NEW_PROCESS_GROUP == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_NEW_PROCESS_GROUP) else 0) | (if (o.CREATE_UNICODE_ENVIRONMENT == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_UNICODE_ENVIRONMENT) else 0) | (if (o.CREATE_SEPARATE_WOW_VDM == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_SEPARATE_WOW_VDM) else 0) | (if (o.CREATE_SHARED_WOW_VDM == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_SHARED_WOW_VDM) else 0) | (if (o.CREATE_FORCEDOS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_FORCEDOS) else 0) | (if (o.BELOW_NORMAL_PRIORITY_CLASS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.BELOW_NORMAL_PRIORITY_CLASS) else 0) | (if (o.ABOVE_NORMAL_PRIORITY_CLASS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.ABOVE_NORMAL_PRIORITY_CLASS) else 0) | (if (o.INHERIT_PARENT_AFFINITY == 1) @intFromEnum(PROCESS_CREATION_FLAGS.INHERIT_PARENT_AFFINITY) else 0) | (if (o.INHERIT_CALLER_PRIORITY == 1) @intFromEnum(PROCESS_CREATION_FLAGS.INHERIT_CALLER_PRIORITY) else 0) | (if (o.CREATE_PROTECTED_PROCESS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_PROTECTED_PROCESS) else 0) | (if (o.EXTENDED_STARTUPINFO_PRESENT == 1) @intFromEnum(PROCESS_CREATION_FLAGS.EXTENDED_STARTUPINFO_PRESENT) else 0) | (if (o.PROCESS_MODE_BACKGROUND_BEGIN == 1) @intFromEnum(PROCESS_CREATION_FLAGS.PROCESS_MODE_BACKGROUND_BEGIN) else 0) | (if (o.PROCESS_MODE_BACKGROUND_END == 1) @intFromEnum(PROCESS_CREATION_FLAGS.PROCESS_MODE_BACKGROUND_END) else 0) | (if (o.CREATE_SECURE_PROCESS == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_SECURE_PROCESS) else 0) | (if (o.CREATE_BREAKAWAY_FROM_JOB == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_BREAKAWAY_FROM_JOB) else 0) | (if (o.CREATE_PRESERVE_CODE_AUTHZ_LEVEL == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_PRESERVE_CODE_AUTHZ_LEVEL) else 0) | (if (o.CREATE_DEFAULT_ERROR_MODE == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_DEFAULT_ERROR_MODE) else 0) | (if (o.CREATE_NO_WINDOW == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_NO_WINDOW) else 0) | (if (o.PROFILE_USER == 1) @intFromEnum(PROCESS_CREATION_FLAGS.PROFILE_USER) else 0) | (if (o.PROFILE_KERNEL == 1) @intFromEnum(PROCESS_CREATION_FLAGS.PROFILE_KERNEL) else 0) | (if (o.PROFILE_SERVER == 1) @intFromEnum(PROCESS_CREATION_FLAGS.PROFILE_SERVER) else 0) | (if (o.CREATE_IGNORE_SYSTEM_DEFAULT == 1) @intFromEnum(PROCESS_CREATION_FLAGS.CREATE_IGNORE_SYSTEM_DEFAULT) else 0)));
    }
};
pub const DEBUG_PROCESS = PROCESS_CREATION_FLAGS.DEBUG_PROCESS;
pub const DEBUG_ONLY_THIS_PROCESS = PROCESS_CREATION_FLAGS.DEBUG_ONLY_THIS_PROCESS;
pub const CREATE_SUSPENDED = PROCESS_CREATION_FLAGS.CREATE_SUSPENDED;
pub const DETACHED_PROCESS = PROCESS_CREATION_FLAGS.DETACHED_PROCESS;
pub const CREATE_NEW_CONSOLE = PROCESS_CREATION_FLAGS.CREATE_NEW_CONSOLE;
pub const NORMAL_PRIORITY_CLASS = PROCESS_CREATION_FLAGS.NORMAL_PRIORITY_CLASS;
pub const IDLE_PRIORITY_CLASS = PROCESS_CREATION_FLAGS.IDLE_PRIORITY_CLASS;
pub const HIGH_PRIORITY_CLASS = PROCESS_CREATION_FLAGS.HIGH_PRIORITY_CLASS;
pub const REALTIME_PRIORITY_CLASS = PROCESS_CREATION_FLAGS.REALTIME_PRIORITY_CLASS;
pub const CREATE_NEW_PROCESS_GROUP = PROCESS_CREATION_FLAGS.CREATE_NEW_PROCESS_GROUP;
pub const CREATE_UNICODE_ENVIRONMENT = PROCESS_CREATION_FLAGS.CREATE_UNICODE_ENVIRONMENT;
pub const CREATE_SEPARATE_WOW_VDM = PROCESS_CREATION_FLAGS.CREATE_SEPARATE_WOW_VDM;
pub const CREATE_SHARED_WOW_VDM = PROCESS_CREATION_FLAGS.CREATE_SHARED_WOW_VDM;
pub const CREATE_FORCEDOS = PROCESS_CREATION_FLAGS.CREATE_FORCEDOS;
pub const BELOW_NORMAL_PRIORITY_CLASS = PROCESS_CREATION_FLAGS.BELOW_NORMAL_PRIORITY_CLASS;
pub const ABOVE_NORMAL_PRIORITY_CLASS = PROCESS_CREATION_FLAGS.ABOVE_NORMAL_PRIORITY_CLASS;
pub const INHERIT_PARENT_AFFINITY = PROCESS_CREATION_FLAGS.INHERIT_PARENT_AFFINITY;
pub const INHERIT_CALLER_PRIORITY = PROCESS_CREATION_FLAGS.INHERIT_CALLER_PRIORITY;
pub const CREATE_PROTECTED_PROCESS = PROCESS_CREATION_FLAGS.CREATE_PROTECTED_PROCESS;
pub const EXTENDED_STARTUPINFO_PRESENT = PROCESS_CREATION_FLAGS.EXTENDED_STARTUPINFO_PRESENT;
pub const PROCESS_MODE_BACKGROUND_BEGIN = PROCESS_CREATION_FLAGS.PROCESS_MODE_BACKGROUND_BEGIN;
pub const PROCESS_MODE_BACKGROUND_END = PROCESS_CREATION_FLAGS.PROCESS_MODE_BACKGROUND_END;
pub const CREATE_SECURE_PROCESS = PROCESS_CREATION_FLAGS.CREATE_SECURE_PROCESS;
pub const CREATE_BREAKAWAY_FROM_JOB = PROCESS_CREATION_FLAGS.CREATE_BREAKAWAY_FROM_JOB;
pub const CREATE_PRESERVE_CODE_AUTHZ_LEVEL = PROCESS_CREATION_FLAGS.CREATE_PRESERVE_CODE_AUTHZ_LEVEL;
pub const CREATE_DEFAULT_ERROR_MODE = PROCESS_CREATION_FLAGS.CREATE_DEFAULT_ERROR_MODE;
pub const CREATE_NO_WINDOW = PROCESS_CREATION_FLAGS.CREATE_NO_WINDOW;
pub const PROFILE_USER = PROCESS_CREATION_FLAGS.PROFILE_USER;
pub const PROFILE_KERNEL = PROCESS_CREATION_FLAGS.PROFILE_KERNEL;
pub const PROFILE_SERVER = PROCESS_CREATION_FLAGS.PROFILE_SERVER;
pub const CREATE_IGNORE_SYSTEM_DEFAULT = PROCESS_CREATION_FLAGS.CREATE_IGNORE_SYSTEM_DEFAULT;

pub const PROCESS_ACCESS_RIGHTS = enum(u32) {
    TERMINATE = 1,
    CREATE_THREAD = 2,
    SET_SESSIONID = 4,
    VM_OPERATION = 8,
    VM_READ = 16,
    VM_WRITE = 32,
    DUP_HANDLE = 64,
    CREATE_PROCESS = 128,
    SET_QUOTA = 256,
    SET_INFORMATION = 512,
    QUERY_INFORMATION = 1024,
    SUSPEND_RESUME = 2048,
    QUERY_LIMITED_INFORMATION = 4096,
    SET_LIMITED_INFORMATION = 8192,
    ALL_ACCESS = 2097151,
    DELETE = 65536,
    READ_CONTROL = 131072,
    WRITE_DAC = 262144,
    WRITE_OWNER = 524288,
    SYNCHRONIZE = 1048576,
    STANDARD_RIGHTS_REQUIRED = 983040,
    _,
    pub fn initFlags(o: struct {
        TERMINATE: u1 = 0,
        CREATE_THREAD: u1 = 0,
        SET_SESSIONID: u1 = 0,
        VM_OPERATION: u1 = 0,
        VM_READ: u1 = 0,
        VM_WRITE: u1 = 0,
        DUP_HANDLE: u1 = 0,
        CREATE_PROCESS: u1 = 0,
        SET_QUOTA: u1 = 0,
        SET_INFORMATION: u1 = 0,
        QUERY_INFORMATION: u1 = 0,
        SUSPEND_RESUME: u1 = 0,
        QUERY_LIMITED_INFORMATION: u1 = 0,
        SET_LIMITED_INFORMATION: u1 = 0,
        ALL_ACCESS: u1 = 0,
        DELETE: u1 = 0,
        READ_CONTROL: u1 = 0,
        WRITE_DAC: u1 = 0,
        WRITE_OWNER: u1 = 0,
        SYNCHRONIZE: u1 = 0,
        STANDARD_RIGHTS_REQUIRED: u1 = 0,
    }) PROCESS_ACCESS_RIGHTS {
        return @as(PROCESS_ACCESS_RIGHTS, @enumFromInt((if (o.TERMINATE == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.TERMINATE) else 0) | (if (o.CREATE_THREAD == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.CREATE_THREAD) else 0) | (if (o.SET_SESSIONID == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.SET_SESSIONID) else 0) | (if (o.VM_OPERATION == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.VM_OPERATION) else 0) | (if (o.VM_READ == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.VM_READ) else 0) | (if (o.VM_WRITE == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.VM_WRITE) else 0) | (if (o.DUP_HANDLE == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.DUP_HANDLE) else 0) | (if (o.CREATE_PROCESS == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.CREATE_PROCESS) else 0) | (if (o.SET_QUOTA == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.SET_QUOTA) else 0) | (if (o.SET_INFORMATION == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.SET_INFORMATION) else 0) | (if (o.QUERY_INFORMATION == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.QUERY_INFORMATION) else 0) | (if (o.SUSPEND_RESUME == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.SUSPEND_RESUME) else 0) | (if (o.QUERY_LIMITED_INFORMATION == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.QUERY_LIMITED_INFORMATION) else 0) | (if (o.SET_LIMITED_INFORMATION == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.SET_LIMITED_INFORMATION) else 0) | (if (o.ALL_ACCESS == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.ALL_ACCESS) else 0) | (if (o.DELETE == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.DELETE) else 0) | (if (o.READ_CONTROL == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.READ_CONTROL) else 0) | (if (o.WRITE_DAC == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.WRITE_DAC) else 0) | (if (o.WRITE_OWNER == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.WRITE_OWNER) else 0) | (if (o.SYNCHRONIZE == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.SYNCHRONIZE) else 0) | (if (o.STANDARD_RIGHTS_REQUIRED == 1) @intFromEnum(PROCESS_ACCESS_RIGHTS.STANDARD_RIGHTS_REQUIRED) else 0)));
    }
};
pub const PROCESS_TERMINATE = PROCESS_ACCESS_RIGHTS.TERMINATE;
pub const PROCESS_CREATE_THREAD = PROCESS_ACCESS_RIGHTS.CREATE_THREAD;
pub const PROCESS_SET_SESSIONID = PROCESS_ACCESS_RIGHTS.SET_SESSIONID;
pub const PROCESS_VM_OPERATION = PROCESS_ACCESS_RIGHTS.VM_OPERATION;
pub const PROCESS_VM_READ = PROCESS_ACCESS_RIGHTS.VM_READ;
pub const PROCESS_VM_WRITE = PROCESS_ACCESS_RIGHTS.VM_WRITE;
pub const PROCESS_DUP_HANDLE = PROCESS_ACCESS_RIGHTS.DUP_HANDLE;
pub const PROCESS_CREATE_PROCESS = PROCESS_ACCESS_RIGHTS.CREATE_PROCESS;
pub const PROCESS_SET_QUOTA = PROCESS_ACCESS_RIGHTS.SET_QUOTA;
pub const PROCESS_SET_INFORMATION = PROCESS_ACCESS_RIGHTS.SET_INFORMATION;
pub const PROCESS_QUERY_INFORMATION = PROCESS_ACCESS_RIGHTS.QUERY_INFORMATION;
pub const PROCESS_SUSPEND_RESUME = PROCESS_ACCESS_RIGHTS.SUSPEND_RESUME;
pub const PROCESS_QUERY_LIMITED_INFORMATION = PROCESS_ACCESS_RIGHTS.QUERY_LIMITED_INFORMATION;
pub const PROCESS_SET_LIMITED_INFORMATION = PROCESS_ACCESS_RIGHTS.SET_LIMITED_INFORMATION;
pub const PROCESS_ALL_ACCESS = PROCESS_ACCESS_RIGHTS.ALL_ACCESS;
pub const PROCESS_DELETE = PROCESS_ACCESS_RIGHTS.DELETE;
pub const PROCESS_READ_CONTROL = PROCESS_ACCESS_RIGHTS.READ_CONTROL;
pub const PROCESS_WRITE_DAC = PROCESS_ACCESS_RIGHTS.WRITE_DAC;
pub const PROCESS_WRITE_OWNER = PROCESS_ACCESS_RIGHTS.WRITE_OWNER;
pub const PROCESS_SYNCHRONIZE = PROCESS_ACCESS_RIGHTS.SYNCHRONIZE;
pub const PROCESS_STANDARD_RIGHTS_REQUIRED = PROCESS_ACCESS_RIGHTS.STANDARD_RIGHTS_REQUIRED;

pub const TP_CALLBACK_INSTANCE = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const TP_WORK = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const TP_TIMER = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const TP_WAIT = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const TP_IO = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

// TODO: this type has a FreeFunc 'DeleteTimerQueueEx', what can Zig do with this information?
pub const TimerQueueHandle = isize;

// TODO: this type has a FreeFunc 'CloseThreadpool', what can Zig do with this information?
pub const PTP_POOL = isize;

// TODO: this type has a FreeFunc 'ClosePrivateNamespace', what can Zig do with this information?
pub const NamespaceHandle = isize;

// TODO: this type has a FreeFunc 'DeleteBoundaryDescriptor', what can Zig do with this information?
pub const BoundaryDescriptorHandle = isize;

pub const LPPROC_THREAD_ATTRIBUTE_LIST = *anyopaque;

pub const REASON_CONTEXT = extern struct {
    Version: u32,
    Flags: POWER_REQUEST_CONTEXT_FLAGS,
    Reason: extern union {
        Detailed: extern struct {
            LocalizedReasonModule: ?HINSTANCE,
            LocalizedReasonId: u32,
            ReasonStringCount: u32,
            ReasonStrings: ?*?PWSTR,
        },
        SimpleReasonString: ?PWSTR,
    },
};

pub const LPTHREAD_START_ROUTINE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        lpThreadParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        lpThreadParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const PINIT_ONCE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        InitOnce: ?*RTL_RUN_ONCE,
        Parameter: ?*anyopaque,
        Context: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        InitOnce: ?*RTL_RUN_ONCE,
        Parameter: ?*anyopaque,
        Context: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const PTIMERAPCROUTINE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        lpArgToCompletionRoutine: ?*anyopaque,
        dwTimerLowValue: u32,
        dwTimerHighValue: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        lpArgToCompletionRoutine: ?*anyopaque,
        dwTimerLowValue: u32,
        dwTimerHighValue: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PROCESS_INFORMATION = extern struct {
    hProcess: ?HANDLE,
    hThread: ?HANDLE,
    dwProcessId: u32,
    dwThreadId: u32,
};

pub const STARTUPINFOA = extern struct {
    cb: u32,
    lpReserved: ?PSTR,
    lpDesktop: ?PSTR,
    lpTitle: ?PSTR,
    dwX: u32,
    dwY: u32,
    dwXSize: u32,
    dwYSize: u32,
    dwXCountChars: u32,
    dwYCountChars: u32,
    dwFillAttribute: u32,
    dwFlags: STARTUPINFOW_FLAGS,
    wShowWindow: u16,
    cbReserved2: u16,
    lpReserved2: ?*u8,
    hStdInput: ?HANDLE,
    hStdOutput: ?HANDLE,
    hStdError: ?HANDLE,
};

pub const STARTUPINFOW = extern struct {
    cb: u32,
    lpReserved: ?PWSTR,
    lpDesktop: ?PWSTR,
    lpTitle: ?PWSTR,
    dwX: u32,
    dwY: u32,
    dwXSize: u32,
    dwYSize: u32,
    dwXCountChars: u32,
    dwYCountChars: u32,
    dwFillAttribute: u32,
    dwFlags: STARTUPINFOW_FLAGS,
    wShowWindow: u16,
    cbReserved2: u16,
    lpReserved2: ?*u8,
    hStdInput: ?HANDLE,
    hStdOutput: ?HANDLE,
    hStdError: ?HANDLE,
};

pub const QUEUE_USER_APC_FLAGS = enum(i32) {
    NONE = 0,
    SPECIAL_USER_APC = 1,
};
pub const QUEUE_USER_APC_FLAGS_NONE = QUEUE_USER_APC_FLAGS.NONE;
pub const QUEUE_USER_APC_FLAGS_SPECIAL_USER_APC = QUEUE_USER_APC_FLAGS.SPECIAL_USER_APC;

pub const THREAD_INFORMATION_CLASS = enum(i32) {
    MemoryPriority = 0,
    AbsoluteCpuPriority = 1,
    DynamicCodePolicy = 2,
    PowerThrottling = 3,
    InformationClassMax = 4,
};
pub const ThreadMemoryPriority = THREAD_INFORMATION_CLASS.MemoryPriority;
pub const ThreadAbsoluteCpuPriority = THREAD_INFORMATION_CLASS.AbsoluteCpuPriority;
pub const ThreadDynamicCodePolicy = THREAD_INFORMATION_CLASS.DynamicCodePolicy;
pub const ThreadPowerThrottling = THREAD_INFORMATION_CLASS.PowerThrottling;
pub const ThreadInformationClassMax = THREAD_INFORMATION_CLASS.InformationClassMax;

pub const MEMORY_PRIORITY_INFORMATION = extern struct {
    MemoryPriority: MEMORY_PRIORITY,
};

pub const THREAD_POWER_THROTTLING_STATE = extern struct {
    Version: u32,
    ControlMask: u32,
    StateMask: u32,
};

pub const PROCESS_INFORMATION_CLASS = enum(i32) {
    MemoryPriority = 0,
    MemoryExhaustionInfo = 1,
    AppMemoryInfo = 2,
    InPrivateInfo = 3,
    PowerThrottling = 4,
    ReservedValue1 = 5,
    TelemetryCoverageInfo = 6,
    ProtectionLevelInfo = 7,
    LeapSecondInfo = 8,
    MachineTypeInfo = 9,
    InformationClassMax = 10,
};
pub const ProcessMemoryPriority = PROCESS_INFORMATION_CLASS.MemoryPriority;
pub const ProcessMemoryExhaustionInfo = PROCESS_INFORMATION_CLASS.MemoryExhaustionInfo;
pub const ProcessAppMemoryInfo = PROCESS_INFORMATION_CLASS.AppMemoryInfo;
pub const ProcessInPrivateInfo = PROCESS_INFORMATION_CLASS.InPrivateInfo;
pub const ProcessPowerThrottling = PROCESS_INFORMATION_CLASS.PowerThrottling;
pub const ProcessReservedValue1 = PROCESS_INFORMATION_CLASS.ReservedValue1;
pub const ProcessTelemetryCoverageInfo = PROCESS_INFORMATION_CLASS.TelemetryCoverageInfo;
pub const ProcessProtectionLevelInfo = PROCESS_INFORMATION_CLASS.ProtectionLevelInfo;
pub const ProcessLeapSecondInfo = PROCESS_INFORMATION_CLASS.LeapSecondInfo;
pub const ProcessMachineTypeInfo = PROCESS_INFORMATION_CLASS.MachineTypeInfo;
pub const ProcessInformationClassMax = PROCESS_INFORMATION_CLASS.InformationClassMax;

pub const APP_MEMORY_INFORMATION = extern struct {
    AvailableCommit: u64,
    PrivateCommitUsage: u64,
    PeakPrivateCommitUsage: u64,
    TotalCommitUsage: u64,
};

pub const MACHINE_ATTRIBUTES = enum(u32) {
    UserEnabled = 1,
    KernelEnabled = 2,
    Wow64Container = 4,
    _,
    pub fn initFlags(o: struct {
        UserEnabled: u1 = 0,
        KernelEnabled: u1 = 0,
        Wow64Container: u1 = 0,
    }) MACHINE_ATTRIBUTES {
        return @as(MACHINE_ATTRIBUTES, @enumFromInt((if (o.UserEnabled == 1) @intFromEnum(MACHINE_ATTRIBUTES.UserEnabled) else 0) | (if (o.KernelEnabled == 1) @intFromEnum(MACHINE_ATTRIBUTES.KernelEnabled) else 0) | (if (o.Wow64Container == 1) @intFromEnum(MACHINE_ATTRIBUTES.Wow64Container) else 0)));
    }
};
pub const UserEnabled = MACHINE_ATTRIBUTES.UserEnabled;
pub const KernelEnabled = MACHINE_ATTRIBUTES.KernelEnabled;
pub const Wow64Container = MACHINE_ATTRIBUTES.Wow64Container;

pub const PROCESS_MACHINE_INFORMATION = extern struct {
    ProcessMachine: u16,
    Res0: u16,
    MachineAttributes: MACHINE_ATTRIBUTES,
};

pub const PROCESS_MEMORY_EXHAUSTION_TYPE = enum(i32) {
    FailFastOnCommitFailure = 0,
    Max = 1,
};
pub const PMETypeFailFastOnCommitFailure = PROCESS_MEMORY_EXHAUSTION_TYPE.FailFastOnCommitFailure;
pub const PMETypeMax = PROCESS_MEMORY_EXHAUSTION_TYPE.Max;

pub const PROCESS_MEMORY_EXHAUSTION_INFO = extern struct {
    Version: u16,
    Reserved: u16,
    Type: PROCESS_MEMORY_EXHAUSTION_TYPE,
    Value: usize,
};

pub const PROCESS_POWER_THROTTLING_STATE = extern struct {
    Version: u32,
    ControlMask: u32,
    StateMask: u32,
};

pub const PROCESS_PROTECTION_LEVEL_INFORMATION = extern struct {
    ProtectionLevel: PROCESS_PROTECTION_LEVEL,
};

pub const PROCESS_LEAP_SECOND_INFO = extern struct {
    Flags: u32,
    Reserved: u32,
};

pub const PTP_WIN32_IO_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Overlapped: ?*anyopaque,
        IoResult: u32,
        NumberOfBytesTransferred: usize,
        Io: ?*TP_IO,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Overlapped: ?*anyopaque,
        IoResult: u32,
        NumberOfBytesTransferred: usize,
        Io: ?*TP_IO,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PROCESS_DYNAMIC_EH_CONTINUATION_TARGET = extern struct {
    TargetAddress: usize,
    Flags: usize,
};

pub const PROCESS_DYNAMIC_EH_CONTINUATION_TARGETS_INFORMATION = extern struct {
    NumberOfTargets: u16,
    Reserved: u16,
    Reserved2: u32,
    Targets: ?*PROCESS_DYNAMIC_EH_CONTINUATION_TARGET,
};

pub const PROCESS_DYNAMIC_ENFORCED_ADDRESS_RANGE = extern struct {
    BaseAddress: usize,
    Size: usize,
    Flags: u32,
};

pub const PROCESS_DYNAMIC_ENFORCED_ADDRESS_RANGES_INFORMATION = extern struct {
    NumberOfRanges: u16,
    Reserved: u16,
    Reserved2: u32,
    Ranges: ?*PROCESS_DYNAMIC_ENFORCED_ADDRESS_RANGE,
};

pub const IO_COUNTERS = extern struct {
    ReadOperationCount: u64,
    WriteOperationCount: u64,
    OtherOperationCount: u64,
    ReadTransferCount: u64,
    WriteTransferCount: u64,
    OtherTransferCount: u64,
};

pub const PROCESS_MITIGATION_POLICY = enum(i32) {
    ProcessDEPPolicy = 0,
    ProcessASLRPolicy = 1,
    ProcessDynamicCodePolicy = 2,
    ProcessStrictHandleCheckPolicy = 3,
    ProcessSystemCallDisablePolicy = 4,
    ProcessMitigationOptionsMask = 5,
    ProcessExtensionPointDisablePolicy = 6,
    ProcessControlFlowGuardPolicy = 7,
    ProcessSignaturePolicy = 8,
    ProcessFontDisablePolicy = 9,
    ProcessImageLoadPolicy = 10,
    ProcessSystemCallFilterPolicy = 11,
    ProcessPayloadRestrictionPolicy = 12,
    ProcessChildProcessPolicy = 13,
    ProcessSideChannelIsolationPolicy = 14,
    ProcessUserShadowStackPolicy = 15,
    ProcessRedirectionTrustPolicy = 16,
    MaxProcessMitigationPolicy = 17,
};
pub const ProcessDEPPolicy = PROCESS_MITIGATION_POLICY.ProcessDEPPolicy;
pub const ProcessASLRPolicy = PROCESS_MITIGATION_POLICY.ProcessASLRPolicy;
pub const ProcessDynamicCodePolicy = PROCESS_MITIGATION_POLICY.ProcessDynamicCodePolicy;
pub const ProcessStrictHandleCheckPolicy = PROCESS_MITIGATION_POLICY.ProcessStrictHandleCheckPolicy;
pub const ProcessSystemCallDisablePolicy = PROCESS_MITIGATION_POLICY.ProcessSystemCallDisablePolicy;
pub const ProcessMitigationOptionsMask = PROCESS_MITIGATION_POLICY.ProcessMitigationOptionsMask;
pub const ProcessExtensionPointDisablePolicy = PROCESS_MITIGATION_POLICY.ProcessExtensionPointDisablePolicy;
pub const ProcessControlFlowGuardPolicy = PROCESS_MITIGATION_POLICY.ProcessControlFlowGuardPolicy;
pub const ProcessSignaturePolicy = PROCESS_MITIGATION_POLICY.ProcessSignaturePolicy;
pub const ProcessFontDisablePolicy = PROCESS_MITIGATION_POLICY.ProcessFontDisablePolicy;
pub const ProcessImageLoadPolicy = PROCESS_MITIGATION_POLICY.ProcessImageLoadPolicy;
pub const ProcessSystemCallFilterPolicy = PROCESS_MITIGATION_POLICY.ProcessSystemCallFilterPolicy;
pub const ProcessPayloadRestrictionPolicy = PROCESS_MITIGATION_POLICY.ProcessPayloadRestrictionPolicy;
pub const ProcessChildProcessPolicy = PROCESS_MITIGATION_POLICY.ProcessChildProcessPolicy;
pub const ProcessSideChannelIsolationPolicy = PROCESS_MITIGATION_POLICY.ProcessSideChannelIsolationPolicy;
pub const ProcessUserShadowStackPolicy = PROCESS_MITIGATION_POLICY.ProcessUserShadowStackPolicy;
pub const ProcessRedirectionTrustPolicy = PROCESS_MITIGATION_POLICY.ProcessRedirectionTrustPolicy;
pub const MaxProcessMitigationPolicy = PROCESS_MITIGATION_POLICY.MaxProcessMitigationPolicy;

pub const RTL_RUN_ONCE = extern union {
    Ptr: ?*anyopaque,
};

pub const RTL_BARRIER = extern struct {
    Reserved1: u32,
    Reserved2: u32,
    Reserved3: [2]usize,
    Reserved4: u32,
    Reserved5: u32,
};

pub const RTL_UMS_THREAD_INFO_CLASS = enum(i32) {
    InvalidInfoClass = 0,
    UserContext = 1,
    Priority = 2,
    Affinity = 3,
    Teb = 4,
    IsSuspended = 5,
    IsTerminated = 6,
    MaxInfoClass = 7,
};
pub const UmsThreadInvalidInfoClass = RTL_UMS_THREAD_INFO_CLASS.InvalidInfoClass;
pub const UmsThreadUserContext = RTL_UMS_THREAD_INFO_CLASS.UserContext;
pub const UmsThreadPriority = RTL_UMS_THREAD_INFO_CLASS.Priority;
pub const UmsThreadAffinity = RTL_UMS_THREAD_INFO_CLASS.Affinity;
pub const UmsThreadTeb = RTL_UMS_THREAD_INFO_CLASS.Teb;
pub const UmsThreadIsSuspended = RTL_UMS_THREAD_INFO_CLASS.IsSuspended;
pub const UmsThreadIsTerminated = RTL_UMS_THREAD_INFO_CLASS.IsTerminated;
pub const UmsThreadMaxInfoClass = RTL_UMS_THREAD_INFO_CLASS.MaxInfoClass;

pub const PRTL_UMS_SCHEDULER_ENTRY_POINT = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Reason: RTL_UMS_SCHEDULER_REASON,
        ActivationPayload: usize,
        SchedulerParam: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        Reason: RTL_UMS_SCHEDULER_REASON,
        ActivationPayload: usize,
        SchedulerParam: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const RTL_CRITICAL_SECTION_DEBUG = extern struct {
    Type: u16,
    CreatorBackTraceIndex: u16,
    CriticalSection: ?*RTL_CRITICAL_SECTION,
    ProcessLocksList: LIST_ENTRY,
    EntryCount: u32,
    ContentionCount: u32,
    Flags: u32,
    CreatorBackTraceIndexHigh: u16,
    SpareWORD: u16,
};

pub const RTL_CRITICAL_SECTION = extern struct {
    DebugInfo: ?*RTL_CRITICAL_SECTION_DEBUG,
    LockCount: i32,
    RecursionCount: i32,
    OwningThread: ?HANDLE,
    LockSemaphore: ?HANDLE,
    SpinCount: usize,
};

pub const RTL_SRWLOCK = extern struct {
    Ptr: ?*anyopaque,
};

pub const RTL_CONDITION_VARIABLE = extern struct {
    Ptr: ?*anyopaque,
};

pub const WAITORTIMERCALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?*anyopaque,
        param1: BOOLEAN,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        param0: ?*anyopaque,
        param1: BOOLEAN,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFLS_CALLBACK_FUNCTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        lpFlsData: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        lpFlsData: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PTP_SIMPLE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const TP_CALLBACK_PRIORITY = enum(i32) {
    HIGH = 0,
    NORMAL = 1,
    LOW = 2,
    INVALID = 3,
    // COUNT = 3, this enum value conflicts with INVALID
};
pub const TP_CALLBACK_PRIORITY_HIGH = TP_CALLBACK_PRIORITY.HIGH;
pub const TP_CALLBACK_PRIORITY_NORMAL = TP_CALLBACK_PRIORITY.NORMAL;
pub const TP_CALLBACK_PRIORITY_LOW = TP_CALLBACK_PRIORITY.LOW;
pub const TP_CALLBACK_PRIORITY_INVALID = TP_CALLBACK_PRIORITY.INVALID;
pub const TP_CALLBACK_PRIORITY_COUNT = TP_CALLBACK_PRIORITY.INVALID;

pub const TP_POOL_STACK_INFORMATION = extern struct {
    StackReserve: usize,
    StackCommit: usize,
};

pub const PTP_CLEANUP_GROUP_CANCEL_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        ObjectContext: ?*anyopaque,
        CleanupContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        ObjectContext: ?*anyopaque,
        CleanupContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const TP_CALLBACK_ENVIRON_V3 = extern struct {
    pub const _ACTIVATION_CONTEXT = extern struct {
        placeholder: usize, // TODO: why is this type empty?
    };
    Version: u32,
    Pool: PTP_POOL,
    CleanupGroup: isize,
    CleanupGroupCancelCallback: ?PTP_CLEANUP_GROUP_CANCEL_CALLBACK,
    RaceDll: ?*anyopaque,
    ActivationContext: isize,
    FinalizationCallback: ?PTP_SIMPLE_CALLBACK,
    u: extern union {
        Flags: u32,
        s: extern struct {
            _bitfield: u32,
        },
    },
    CallbackPriority: TP_CALLBACK_PRIORITY,
    Size: u32,
};

pub const PTP_WORK_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Work: ?*TP_WORK,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Work: ?*TP_WORK,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PTP_TIMER_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Timer: ?*TP_TIMER,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Timer: ?*TP_TIMER,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PTP_WAIT_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Wait: ?*TP_WAIT,
        WaitResult: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        Instance: ?*TP_CALLBACK_INSTANCE,
        Context: ?*anyopaque,
        Wait: ?*TP_WAIT,
        WaitResult: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const LPFIBER_START_ROUTINE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        lpFiberParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        lpFiberParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const UMS_SCHEDULER_STARTUP_INFO = extern struct {
    UmsVersion: u32,
    CompletionList: ?*anyopaque,
    SchedulerProc: ?PRTL_UMS_SCHEDULER_ENTRY_POINT,
    SchedulerParam: ?*anyopaque,
};

pub const UMS_SYSTEM_THREAD_INFORMATION = extern struct {
    UmsVersion: u32,
    Anonymous: extern union {
        Anonymous: extern struct {
            _bitfield: u32,
        },
        ThreadUmsFlags: u32,
    },
};

pub const STARTUPINFOEXA = extern struct {
    StartupInfo: STARTUPINFOA,
    lpAttributeList: ?LPPROC_THREAD_ATTRIBUTE_LIST,
};

pub const STARTUPINFOEXW = extern struct {
    StartupInfo: STARTUPINFOW,
    lpAttributeList: ?LPPROC_THREAD_ATTRIBUTE_LIST,
};

pub const PEB_LDR_DATA = extern struct {
    Reserved1: [8]u8,
    Reserved2: [3]?*anyopaque,
    InMemoryOrderModuleList: LIST_ENTRY,
};

pub const RTL_USER_PROCESS_PARAMETERS = extern struct {
    Reserved1: [16]u8,
    Reserved2: [10]?*anyopaque,
    ImagePathName: UNICODE_STRING,
    CommandLine: UNICODE_STRING,
};

pub const PPS_POST_PROCESS_INIT_ROUTINE = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const PEB = extern struct {
    Reserved1: [2]u8,
    BeingDebugged: u8,
    Reserved2: [1]u8,
    Reserved3: [2]?*anyopaque,
    Ldr: ?*PEB_LDR_DATA,
    ProcessParameters: ?*RTL_USER_PROCESS_PARAMETERS,
    Reserved4: [3]?*anyopaque,
    AtlThunkSListPtr: ?*anyopaque,
    Reserved5: ?*anyopaque,
    Reserved6: u32,
    Reserved7: ?*anyopaque,
    Reserved8: u32,
    AtlThunkSListPtr32: u32,
    Reserved9: [45]?*anyopaque,
    Reserved10: [96]u8,
    PostProcessInitRoutine: ?PPS_POST_PROCESS_INIT_ROUTINE,
    Reserved11: [128]u8,
    Reserved12: [1]?*anyopaque,
    SessionId: u32,
};

pub const PROCESS_BASIC_INFORMATION = extern struct {
    Reserved1: ?*anyopaque,
    PebBaseAddress: ?*PEB,
    Reserved2: [2]?*anyopaque,
    UniqueProcessId: usize,
    Reserved3: ?*anyopaque,
};

pub const PROCESSINFOCLASS = enum(i32) {
    BasicInformation = 0,
    DebugPort = 7,
    Wow64Information = 26,
    ImageFileName = 27,
    BreakOnTermination = 29,
};
pub const ProcessBasicInformation = PROCESSINFOCLASS.BasicInformation;
pub const ProcessDebugPort = PROCESSINFOCLASS.DebugPort;
pub const ProcessWow64Information = PROCESSINFOCLASS.Wow64Information;
pub const ProcessImageFileName = PROCESSINFOCLASS.ImageFileName;
pub const ProcessBreakOnTermination = PROCESSINFOCLASS.BreakOnTermination;

pub const THREADINFOCLASS = enum(i32) {
    IsIoPending = 16,
    NameInformation = 38,
};
pub const ThreadIsIoPending = THREADINFOCLASS.IsIoPending;
pub const ThreadNameInformation = THREADINFOCLASS.NameInformation;

//--------------------------------------------------------------------------------
// Section: Functions (284)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessWorkingSetSize(
    hProcess: ?HANDLE,
    lpMinimumWorkingSetSize: ?*usize,
    lpMaximumWorkingSetSize: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetProcessWorkingSetSize(
    hProcess: ?HANDLE,
    dwMinimumWorkingSetSize: usize,
    dwMaximumWorkingSetSize: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn FlsAlloc(
    lpCallback: ?PFLS_CALLBACK_FUNCTION,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn FlsGetValue(
    dwFlsIndex: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn FlsSetValue(
    dwFlsIndex: u32,
    lpFlsData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn FlsFree(
    dwFlsIndex: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn IsThreadAFiber() callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitializeSRWLock(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ReleaseSRWLockExclusive(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ReleaseSRWLockShared(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn AcquireSRWLockExclusive(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn AcquireSRWLockShared(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn TryAcquireSRWLockExclusive(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn TryAcquireSRWLockShared(
    SRWLock: ?*RTL_SRWLOCK,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn InitializeCriticalSection(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn EnterCriticalSection(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LeaveCriticalSection(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn InitializeCriticalSectionAndSpinCount(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
    dwSpinCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitializeCriticalSectionEx(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
    dwSpinCount: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetCriticalSectionSpinCount(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
    dwSpinCount: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TryEnterCriticalSection(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn DeleteCriticalSection(
    lpCriticalSection: ?*RTL_CRITICAL_SECTION,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitOnceInitialize(
    InitOnce: ?*RTL_RUN_ONCE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitOnceExecuteOnce(
    InitOnce: ?*RTL_RUN_ONCE,
    InitFn: ?PINIT_ONCE_FN,
    Parameter: ?*anyopaque,
    Context: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitOnceBeginInitialize(
    lpInitOnce: ?*RTL_RUN_ONCE,
    dwFlags: u32,
    fPending: ?*BOOL,
    lpContext: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitOnceComplete(
    lpInitOnce: ?*RTL_RUN_ONCE,
    dwFlags: u32,
    lpContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitializeConditionVariable(
    ConditionVariable: ?*RTL_CONDITION_VARIABLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn WakeConditionVariable(
    ConditionVariable: ?*RTL_CONDITION_VARIABLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn WakeAllConditionVariable(
    ConditionVariable: ?*RTL_CONDITION_VARIABLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SleepConditionVariableCS(
    ConditionVariable: ?*RTL_CONDITION_VARIABLE,
    CriticalSection: ?*RTL_CRITICAL_SECTION,
    dwMilliseconds: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SleepConditionVariableSRW(
    ConditionVariable: ?*RTL_CONDITION_VARIABLE,
    SRWLock: ?*RTL_SRWLOCK,
    dwMilliseconds: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetEvent(
    hEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ResetEvent(
    hEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ReleaseSemaphore(
    hSemaphore: ?HANDLE,
    lReleaseCount: i32,
    lpPreviousCount: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ReleaseMutex(
    hMutex: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn WaitForSingleObject(
    hHandle: ?HANDLE,
    dwMilliseconds: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SleepEx(
    dwMilliseconds: u32,
    bAlertable: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn WaitForSingleObjectEx(
    hHandle: ?HANDLE,
    dwMilliseconds: u32,
    bAlertable: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn WaitForMultipleObjectsEx(
    nCount: u32,
    lpHandles: [*]const ?HANDLE,
    bWaitAll: BOOL,
    dwMilliseconds: u32,
    bAlertable: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateMutexA(
    lpMutexAttributes: ?*SECURITY_ATTRIBUTES,
    bInitialOwner: BOOL,
    lpName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateMutexW(
    lpMutexAttributes: ?*SECURITY_ATTRIBUTES,
    bInitialOwner: BOOL,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenMutexW(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateEventA(
    lpEventAttributes: ?*SECURITY_ATTRIBUTES,
    bManualReset: BOOL,
    bInitialState: BOOL,
    lpName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateEventW(
    lpEventAttributes: ?*SECURITY_ATTRIBUTES,
    bManualReset: BOOL,
    bInitialState: BOOL,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenEventA(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenEventW(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenSemaphoreW(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenWaitableTimerW(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpTimerName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn SetWaitableTimerEx(
    hTimer: ?HANDLE,
    lpDueTime: ?*const LARGE_INTEGER,
    lPeriod: i32,
    pfnCompletionRoutine: ?PTIMERAPCROUTINE,
    lpArgToCompletionRoutine: ?*anyopaque,
    WakeContext: ?*REASON_CONTEXT,
    TolerableDelay: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetWaitableTimer(
    hTimer: ?HANDLE,
    lpDueTime: ?*const LARGE_INTEGER,
    lPeriod: i32,
    pfnCompletionRoutine: ?PTIMERAPCROUTINE,
    lpArgToCompletionRoutine: ?*anyopaque,
    fResume: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CancelWaitableTimer(
    hTimer: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateMutexExA(
    lpMutexAttributes: ?*SECURITY_ATTRIBUTES,
    lpName: ?[*:0]const u8,
    dwFlags: u32,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateMutexExW(
    lpMutexAttributes: ?*SECURITY_ATTRIBUTES,
    lpName: ?[*:0]const u16,
    dwFlags: u32,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateEventExA(
    lpEventAttributes: ?*SECURITY_ATTRIBUTES,
    lpName: ?[*:0]const u8,
    dwFlags: CREATE_EVENT,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateEventExW(
    lpEventAttributes: ?*SECURITY_ATTRIBUTES,
    lpName: ?[*:0]const u16,
    dwFlags: CREATE_EVENT,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateSemaphoreExW(
    lpSemaphoreAttributes: ?*SECURITY_ATTRIBUTES,
    lInitialCount: i32,
    lMaximumCount: i32,
    lpName: ?[*:0]const u16,
    dwFlags: u32,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateWaitableTimerExW(
    lpTimerAttributes: ?*SECURITY_ATTRIBUTES,
    lpTimerName: ?[*:0]const u16,
    dwFlags: u32,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn EnterSynchronizationBarrier(
    lpBarrier: ?*RTL_BARRIER,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn InitializeSynchronizationBarrier(
    lpBarrier: ?*RTL_BARRIER,
    lTotalThreads: i32,
    lSpinCount: i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn DeleteSynchronizationBarrier(
    lpBarrier: ?*RTL_BARRIER,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn Sleep(
    dwMilliseconds: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows8.0'
pub extern "vertdll" fn WaitOnAddress(
    // TODO: what to do with BytesParamIndex 2?
    Address: ?*anyopaque,
    // TODO: what to do with BytesParamIndex 2?
    CompareAddress: ?*anyopaque,
    AddressSize: usize,
    dwMilliseconds: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "vertdll" fn WakeByAddressSingle(
    Address: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows8.0'
pub extern "vertdll" fn WakeByAddressAll(
    Address: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn WaitForMultipleObjects(
    nCount: u32,
    lpHandles: [*]const ?HANDLE,
    bWaitAll: BOOL,
    dwMilliseconds: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateSemaphoreW(
    lpSemaphoreAttributes: ?*SECURITY_ATTRIBUTES,
    lInitialCount: i32,
    lMaximumCount: i32,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateWaitableTimerW(
    lpTimerAttributes: ?*SECURITY_ATTRIBUTES,
    bManualReset: BOOL,
    lpTimerName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn InitializeSListHead(
    ListHead: ?*SLIST_HEADER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn InterlockedPopEntrySList(
    ListHead: ?*SLIST_HEADER,
) callconv(@import("std").os.windows.WINAPI) ?*SLIST_ENTRY;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn InterlockedPushEntrySList(
    ListHead: ?*SLIST_HEADER,
    ListEntry: ?*SLIST_ENTRY,
) callconv(@import("std").os.windows.WINAPI) ?*SLIST_ENTRY;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn InterlockedPushListSListEx(
    ListHead: ?*SLIST_HEADER,
    List: ?*SLIST_ENTRY,
    ListEnd: ?*SLIST_ENTRY,
    Count: u32,
) callconv(@import("std").os.windows.WINAPI) ?*SLIST_ENTRY;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn InterlockedFlushSList(
    ListHead: ?*SLIST_HEADER,
) callconv(@import("std").os.windows.WINAPI) ?*SLIST_ENTRY;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn QueryDepthSList(
    ListHead: ?*SLIST_HEADER,
) callconv(@import("std").os.windows.WINAPI) u16;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn QueueUserAPC(
    pfnAPC: ?PAPCFUNC,
    hThread: ?HANDLE,
    dwData: usize,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "kernel32" fn QueueUserAPC2(
    ApcRoutine: ?PAPCFUNC,
    Thread: ?HANDLE,
    Data: usize,
    Flags: QUEUE_USER_APC_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessTimes(
    hProcess: ?HANDLE,
    lpCreationTime: ?*FILETIME,
    lpExitTime: ?*FILETIME,
    lpKernelTime: ?*FILETIME,
    lpUserTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCurrentProcess() callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCurrentProcessId() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ExitProcess(
    uExitCode: u32,
) callconv(@import("std").os.windows.WINAPI) noreturn;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TerminateProcess(
    hProcess: ?HANDLE,
    uExitCode: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetExitCodeProcess(
    hProcess: ?HANDLE,
    lpExitCode: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SwitchToThread() callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateThread(
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    dwStackSize: usize,
    lpStartAddress: ?LPTHREAD_START_ROUTINE,
    lpParameter: ?*anyopaque,
    dwCreationFlags: THREAD_CREATION_FLAGS,
    lpThreadId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateRemoteThread(
    hProcess: ?HANDLE,
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    dwStackSize: usize,
    lpStartAddress: ?LPTHREAD_START_ROUTINE,
    lpParameter: ?*anyopaque,
    dwCreationFlags: u32,
    lpThreadId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCurrentThread() callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCurrentThreadId() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenThread(
    dwDesiredAccess: THREAD_ACCESS_RIGHTS,
    bInheritHandle: BOOL,
    dwThreadId: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetThreadPriority(
    hThread: ?HANDLE,
    nPriority: THREAD_PRIORITY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetThreadPriorityBoost(
    hThread: ?HANDLE,
    bDisablePriorityBoost: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetThreadPriorityBoost(
    hThread: ?HANDLE,
    pDisablePriorityBoost: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetThreadPriority(
    hThread: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ExitThread(
    dwExitCode: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TerminateThread(
    hThread: ?HANDLE,
    dwExitCode: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetExitCodeThread(
    hThread: ?HANDLE,
    lpExitCode: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SuspendThread(
    hThread: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ResumeThread(
    hThread: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TlsAlloc() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TlsGetValue(
    dwTlsIndex: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TlsSetValue(
    dwTlsIndex: u32,
    lpTlsValue: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TlsFree(
    dwTlsIndex: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateProcessA(
    lpApplicationName: ?[*:0]const u8,
    lpCommandLine: ?PSTR,
    lpProcessAttributes: ?*SECURITY_ATTRIBUTES,
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    bInheritHandles: BOOL,
    dwCreationFlags: PROCESS_CREATION_FLAGS,
    lpEnvironment: ?*anyopaque,
    lpCurrentDirectory: ?[*:0]const u8,
    lpStartupInfo: ?*STARTUPINFOA,
    lpProcessInformation: ?*PROCESS_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateProcessW(
    lpApplicationName: ?[*:0]const u16,
    lpCommandLine: ?PWSTR,
    lpProcessAttributes: ?*SECURITY_ATTRIBUTES,
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    bInheritHandles: BOOL,
    dwCreationFlags: PROCESS_CREATION_FLAGS,
    lpEnvironment: ?*anyopaque,
    lpCurrentDirectory: ?[*:0]const u16,
    lpStartupInfo: ?*STARTUPINFOW,
    lpProcessInformation: ?*PROCESS_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetProcessShutdownParameters(
    dwLevel: u32,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessVersion(
    ProcessId: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetStartupInfoW(
    lpStartupInfo: ?*STARTUPINFOW,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateProcessAsUserW(
    hToken: ?HANDLE,
    lpApplicationName: ?[*:0]const u16,
    lpCommandLine: ?PWSTR,
    lpProcessAttributes: ?*SECURITY_ATTRIBUTES,
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    bInheritHandles: BOOL,
    dwCreationFlags: u32,
    lpEnvironment: ?*anyopaque,
    lpCurrentDirectory: ?[*:0]const u16,
    lpStartupInfo: ?*STARTUPINFOW,
    lpProcessInformation: ?*PROCESS_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetThreadToken(
    Thread: ?*?HANDLE,
    Token: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn OpenProcessToken(
    ProcessHandle: ?HANDLE,
    DesiredAccess: TOKEN_ACCESS_MASK,
    TokenHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn OpenThreadToken(
    ThreadHandle: ?HANDLE,
    DesiredAccess: TOKEN_ACCESS_MASK,
    OpenAsSelf: BOOL,
    TokenHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetPriorityClass(
    hProcess: ?HANDLE,
    dwPriorityClass: PROCESS_CREATION_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetPriorityClass(
    hProcess: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetThreadStackGuarantee(
    StackSizeInBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetProcessId(
    Process: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetThreadId(
    Thread: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn FlushProcessWriteBuffers() callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetProcessIdOfThread(
    Thread: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn InitializeProcThreadAttributeList(
    // TODO: what to do with BytesParamIndex 3?
    lpAttributeList: ?LPPROC_THREAD_ATTRIBUTE_LIST,
    dwAttributeCount: u32,
    dwFlags: u32,
    lpSize: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn DeleteProcThreadAttributeList(
    lpAttributeList: ?LPPROC_THREAD_ATTRIBUTE_LIST,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn UpdateProcThreadAttribute(
    lpAttributeList: ?LPPROC_THREAD_ATTRIBUTE_LIST,
    dwFlags: u32,
    Attribute: usize,
    // TODO: what to do with BytesParamIndex 4?
    lpValue: ?*anyopaque,
    cbSize: usize,
    // TODO: what to do with BytesParamIndex 4?
    lpPreviousValue: ?*anyopaque,
    lpReturnSize: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetProcessDynamicEHContinuationTargets(
    Process: ?HANDLE,
    NumberOfTargets: u16,
    Targets: [*]PROCESS_DYNAMIC_EH_CONTINUATION_TARGET,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetProcessDynamicEnforcedCetCompatibleRanges(
    Process: ?HANDLE,
    NumberOfRanges: u16,
    Ranges: [*]PROCESS_DYNAMIC_ENFORCED_ADDRESS_RANGE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetProcessAffinityUpdateMode(
    hProcess: ?HANDLE,
    dwFlags: PROCESS_AFFINITY_AUTO_UPDATE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn QueryProcessAffinityUpdateMode(
    hProcess: ?HANDLE,
    lpdwFlags: ?*PROCESS_AFFINITY_AUTO_UPDATE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn CreateRemoteThreadEx(
    hProcess: ?HANDLE,
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    dwStackSize: usize,
    lpStartAddress: ?LPTHREAD_START_ROUTINE,
    lpParameter: ?*anyopaque,
    dwCreationFlags: u32,
    lpAttributeList: ?LPPROC_THREAD_ATTRIBUTE_LIST,
    lpThreadId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn GetCurrentThreadStackLimits(
    LowLimit: ?*usize,
    HighLimit: ?*usize,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn GetProcessMitigationPolicy(
    hProcess: ?HANDLE,
    MitigationPolicy: PROCESS_MITIGATION_POLICY,
    // TODO: what to do with BytesParamIndex 3?
    lpBuffer: ?*anyopaque,
    dwLength: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn SetProcessMitigationPolicy(
    MitigationPolicy: PROCESS_MITIGATION_POLICY,
    // TODO: what to do with BytesParamIndex 2?
    lpBuffer: ?*anyopaque,
    dwLength: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetThreadTimes(
    hThread: ?HANDLE,
    lpCreationTime: ?*FILETIME,
    lpExitTime: ?*FILETIME,
    lpKernelTime: ?*FILETIME,
    lpUserTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenProcess(
    dwDesiredAccess: PROCESS_ACCESS_RIGHTS,
    bInheritHandle: BOOL,
    dwProcessId: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn IsProcessorFeaturePresent(
    ProcessorFeature: PROCESSOR_FEATURE_ID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetProcessHandleCount(
    hProcess: ?HANDLE,
    pdwHandleCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetCurrentProcessorNumber() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn SetThreadIdealProcessorEx(
    hThread: ?HANDLE,
    lpIdealProcessor: ?*PROCESSOR_NUMBER,
    lpPreviousIdealProcessor: ?*PROCESSOR_NUMBER,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetThreadIdealProcessorEx(
    hThread: ?HANDLE,
    lpIdealProcessor: ?*PROCESSOR_NUMBER,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetCurrentProcessorNumberEx(
    ProcNumber: ?*PROCESSOR_NUMBER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessPriorityBoost(
    hProcess: ?HANDLE,
    pDisablePriorityBoost: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetProcessPriorityBoost(
    hProcess: ?HANDLE,
    bDisablePriorityBoost: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetThreadIOPendingFlag(
    hThread: ?HANDLE,
    lpIOIsPending: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetSystemTimes(
    lpIdleTime: ?*FILETIME,
    lpKernelTime: ?*FILETIME,
    lpUserTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn GetThreadInformation(
    hThread: ?HANDLE,
    ThreadInformationClass: THREAD_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    ThreadInformation: ?*anyopaque,
    ThreadInformationSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn SetThreadInformation(
    hThread: ?HANDLE,
    ThreadInformationClass: THREAD_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    ThreadInformation: ?*anyopaque,
    ThreadInformationSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn IsProcessCritical(
    hProcess: ?HANDLE,
    Critical: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn SetProtectedPolicy(
    PolicyGuid: ?*const Guid,
    PolicyValue: usize,
    OldPolicyValue: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn QueryProtectedPolicy(
    PolicyGuid: ?*const Guid,
    PolicyValue: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetThreadIdealProcessor(
    hThread: ?HANDLE,
    dwIdealProcessor: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn SetProcessInformation(
    hProcess: ?HANDLE,
    ProcessInformationClass: PROCESS_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    ProcessInformation: ?*anyopaque,
    ProcessInformationSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn GetProcessInformation(
    hProcess: ?HANDLE,
    ProcessInformationClass: PROCESS_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    ProcessInformation: ?*anyopaque,
    ProcessInformationSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetProcessDefaultCpuSets(
    Process: ?HANDLE,
    CpuSetIds: ?[*]u32,
    CpuSetIdCount: u32,
    RequiredIdCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetProcessDefaultCpuSets(
    Process: ?HANDLE,
    CpuSetIds: ?[*]const u32,
    CpuSetIdCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetThreadSelectedCpuSets(
    Thread: ?HANDLE,
    CpuSetIds: ?[*]u32,
    CpuSetIdCount: u32,
    RequiredIdCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetThreadSelectedCpuSets(
    Thread: ?HANDLE,
    CpuSetIds: [*]const u32,
    CpuSetIdCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateProcessAsUserA(
    hToken: ?HANDLE,
    lpApplicationName: ?[*:0]const u8,
    lpCommandLine: ?PSTR,
    lpProcessAttributes: ?*SECURITY_ATTRIBUTES,
    lpThreadAttributes: ?*SECURITY_ATTRIBUTES,
    bInheritHandles: BOOL,
    dwCreationFlags: u32,
    lpEnvironment: ?*anyopaque,
    lpCurrentDirectory: ?[*:0]const u8,
    lpStartupInfo: ?*STARTUPINFOA,
    lpProcessInformation: ?*PROCESS_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessShutdownParameters(
    lpdwLevel: ?*u32,
    lpdwFlags: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetProcessDefaultCpuSetMasks(
    Process: ?HANDLE,
    CpuSetMasks: ?[*]GROUP_AFFINITY,
    CpuSetMaskCount: u16,
    RequiredMaskCount: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetProcessDefaultCpuSetMasks(
    Process: ?HANDLE,
    CpuSetMasks: ?[*]GROUP_AFFINITY,
    CpuSetMaskCount: u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetThreadSelectedCpuSetMasks(
    Thread: ?HANDLE,
    CpuSetMasks: ?[*]GROUP_AFFINITY,
    CpuSetMaskCount: u16,
    RequiredMaskCount: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetThreadSelectedCpuSetMasks(
    Thread: ?HANDLE,
    CpuSetMasks: ?[*]GROUP_AFFINITY,
    CpuSetMaskCount: u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetMachineTypeAttributes(
    Machine: u16,
    MachineTypeAttributes: ?*MACHINE_ATTRIBUTES,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.14393'
pub extern "kernel32" fn SetThreadDescription(
    hThread: ?HANDLE,
    lpThreadDescription: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.14393'
pub extern "kernel32" fn GetThreadDescription(
    hThread: ?HANDLE,
    ppszThreadDescription: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn QueueUserWorkItem(
    Function: ?LPTHREAD_START_ROUTINE,
    Context: ?*anyopaque,
    Flags: WORKER_THREAD_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn UnregisterWaitEx(
    WaitHandle: ?HANDLE,
    CompletionEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateTimerQueue() callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateTimerQueueTimer(
    phNewTimer: ?*?HANDLE,
    TimerQueue: ?HANDLE,
    Callback: ?WAITORTIMERCALLBACK,
    Parameter: ?*anyopaque,
    DueTime: u32,
    Period: u32,
    Flags: WORKER_THREAD_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ChangeTimerQueueTimer(
    TimerQueue: ?HANDLE,
    Timer: ?HANDLE,
    DueTime: u32,
    Period: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn DeleteTimerQueueTimer(
    TimerQueue: ?HANDLE,
    Timer: ?HANDLE,
    CompletionEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn DeleteTimerQueue(
    TimerQueue: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn DeleteTimerQueueEx(
    TimerQueue: ?HANDLE,
    CompletionEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateThreadpool(
    reserved: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) PTP_POOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetThreadpoolThreadMaximum(
    ptpp: PTP_POOL,
    cthrdMost: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetThreadpoolThreadMinimum(
    ptpp: PTP_POOL,
    cthrdMic: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn SetThreadpoolStackInformation(
    ptpp: PTP_POOL,
    ptpsi: ?*TP_POOL_STACK_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn QueryThreadpoolStackInformation(
    ptpp: PTP_POOL,
    ptpsi: ?*TP_POOL_STACK_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpool(
    ptpp: PTP_POOL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateThreadpoolCleanupGroup() callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpoolCleanupGroupMembers(
    ptpcg: isize,
    fCancelPendingCallbacks: BOOL,
    pvCleanupContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpoolCleanupGroup(
    ptpcg: isize,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetEventWhenCallbackReturns(
    pci: ?*TP_CALLBACK_INSTANCE,
    evt: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ReleaseSemaphoreWhenCallbackReturns(
    pci: ?*TP_CALLBACK_INSTANCE,
    sem: ?HANDLE,
    crel: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ReleaseMutexWhenCallbackReturns(
    pci: ?*TP_CALLBACK_INSTANCE,
    mut: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn LeaveCriticalSectionWhenCallbackReturns(
    pci: ?*TP_CALLBACK_INSTANCE,
    pcs: ?*RTL_CRITICAL_SECTION,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn FreeLibraryWhenCallbackReturns(
    pci: ?*TP_CALLBACK_INSTANCE,
    mod: ?HINSTANCE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CallbackMayRunLong(
    pci: ?*TP_CALLBACK_INSTANCE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn DisassociateCurrentThreadFromCallback(
    pci: ?*TP_CALLBACK_INSTANCE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn TrySubmitThreadpoolCallback(
    pfns: ?PTP_SIMPLE_CALLBACK,
    pv: ?*anyopaque,
    pcbe: ?*TP_CALLBACK_ENVIRON_V3,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateThreadpoolWork(
    pfnwk: ?PTP_WORK_CALLBACK,
    pv: ?*anyopaque,
    pcbe: ?*TP_CALLBACK_ENVIRON_V3,
) callconv(@import("std").os.windows.WINAPI) ?*TP_WORK;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SubmitThreadpoolWork(
    pwk: ?*TP_WORK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn WaitForThreadpoolWorkCallbacks(
    pwk: ?*TP_WORK,
    fCancelPendingCallbacks: BOOL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpoolWork(
    pwk: ?*TP_WORK,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateThreadpoolTimer(
    pfnti: ?PTP_TIMER_CALLBACK,
    pv: ?*anyopaque,
    pcbe: ?*TP_CALLBACK_ENVIRON_V3,
) callconv(@import("std").os.windows.WINAPI) ?*TP_TIMER;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetThreadpoolTimer(
    pti: ?*TP_TIMER,
    pftDueTime: ?*FILETIME,
    msPeriod: u32,
    msWindowLength: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn IsThreadpoolTimerSet(
    pti: ?*TP_TIMER,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn WaitForThreadpoolTimerCallbacks(
    pti: ?*TP_TIMER,
    fCancelPendingCallbacks: BOOL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpoolTimer(
    pti: ?*TP_TIMER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateThreadpoolWait(
    pfnwa: ?PTP_WAIT_CALLBACK,
    pv: ?*anyopaque,
    pcbe: ?*TP_CALLBACK_ENVIRON_V3,
) callconv(@import("std").os.windows.WINAPI) ?*TP_WAIT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetThreadpoolWait(
    pwa: ?*TP_WAIT,
    h: ?HANDLE,
    pftTimeout: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn WaitForThreadpoolWaitCallbacks(
    pwa: ?*TP_WAIT,
    fCancelPendingCallbacks: BOOL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpoolWait(
    pwa: ?*TP_WAIT,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateThreadpoolIo(
    fl: ?HANDLE,
    pfnio: ?PTP_WIN32_IO_CALLBACK,
    pv: ?*anyopaque,
    pcbe: ?*TP_CALLBACK_ENVIRON_V3,
) callconv(@import("std").os.windows.WINAPI) ?*TP_IO;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn StartThreadpoolIo(
    pio: ?*TP_IO,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CancelThreadpoolIo(
    pio: ?*TP_IO,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn WaitForThreadpoolIoCallbacks(
    pio: ?*TP_IO,
    fCancelPendingCallbacks: BOOL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CloseThreadpoolIo(
    pio: ?*TP_IO,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn SetThreadpoolTimerEx(
    pti: ?*TP_TIMER,
    pftDueTime: ?*FILETIME,
    msPeriod: u32,
    msWindowLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn SetThreadpoolWaitEx(
    pwa: ?*TP_WAIT,
    h: ?HANDLE,
    pftTimeout: ?*FILETIME,
    Reserved: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn IsWow64Process(
    hProcess: ?HANDLE,
    Wow64Process: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "api-ms-win-core-wow64-l1-1-1" fn Wow64SetThreadDefaultGuestMachine(
    Machine: u16,
) callconv(@import("std").os.windows.WINAPI) u16;

// TODO: this type is limited to platform 'windows10.0.10586'
pub extern "kernel32" fn IsWow64Process2(
    hProcess: ?HANDLE,
    pProcessMachine: ?*u16,
    pNativeMachine: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn Wow64SuspendThread(
    hThread: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "kernel32" fn CreatePrivateNamespaceW(
    lpPrivateNamespaceAttributes: ?*SECURITY_ATTRIBUTES,
    lpBoundaryDescriptor: ?*anyopaque,
    lpAliasPrefix: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) NamespaceHandle;

pub extern "kernel32" fn OpenPrivateNamespaceW(
    lpBoundaryDescriptor: ?*anyopaque,
    lpAliasPrefix: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) NamespaceHandle;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ClosePrivateNamespace(
    Handle: NamespaceHandle,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

pub extern "kernel32" fn CreateBoundaryDescriptorW(
    Name: ?[*:0]const u16,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BoundaryDescriptorHandle;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn AddSIDToBoundaryDescriptor(
    BoundaryDescriptor: ?*?HANDLE,
    RequiredSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn DeleteBoundaryDescriptor(
    BoundaryDescriptor: BoundaryDescriptorHandle,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNumaHighestNodeNumber(
    HighestNodeNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetNumaNodeProcessorMaskEx(
    Node: u16,
    ProcessorMask: ?*GROUP_AFFINITY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetNumaNodeProcessorMask2(
    NodeNumber: u16,
    ProcessorMasks: ?[*]GROUP_AFFINITY,
    ProcessorMaskCount: u16,
    RequiredMaskCount: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetNumaProximityNodeEx(
    ProximityId: u32,
    NodeNumber: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetProcessGroupAffinity(
    hProcess: ?HANDLE,
    GroupCount: ?*u16,
    GroupArray: [*:0]u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetThreadGroupAffinity(
    hThread: ?HANDLE,
    GroupAffinity: ?*GROUP_AFFINITY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn SetThreadGroupAffinity(
    hThread: ?HANDLE,
    GroupAffinity: ?*const GROUP_AFFINITY,
    PreviousGroupAffinity: ?*GROUP_AFFINITY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "user32" fn AttachThreadInput(
    idAttach: u32,
    idAttachTo: u32,
    fAttach: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "user32" fn WaitForInputIdle(
    hProcess: ?HANDLE,
    dwMilliseconds: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "user32" fn GetGuiResources(
    hProcess: ?HANDLE,
    uiFlags: GET_GUI_RESOURCES_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "user32" fn IsImmersiveProcess(
    hProcess: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "user32" fn SetProcessRestrictionExemption(
    fEnableExemption: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessAffinityMask(
    hProcess: ?HANDLE,
    lpProcessAffinityMask: ?*usize,
    lpSystemAffinityMask: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetProcessAffinityMask(
    hProcess: ?HANDLE,
    dwProcessAffinityMask: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessIoCounters(
    hProcess: ?HANDLE,
    lpIoCounters: ?*IO_COUNTERS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SwitchToFiber(
    lpFiber: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn DeleteFiber(
    lpFiber: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ConvertFiberToThread() callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateFiberEx(
    dwStackCommitSize: usize,
    dwStackReserveSize: usize,
    dwFlags: u32,
    lpStartAddress: ?LPFIBER_START_ROUTINE,
    lpParameter: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn ConvertThreadToFiberEx(
    lpParameter: ?*anyopaque,
    dwFlags: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateFiber(
    dwStackSize: usize,
    lpStartAddress: ?LPFIBER_START_ROUTINE,
    lpParameter: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ConvertThreadToFiber(
    lpParameter: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn CreateUmsCompletionList(
    UmsCompletionList: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn DequeueUmsCompletionListItems(
    UmsCompletionList: ?*anyopaque,
    WaitTimeOut: u32,
    UmsThreadList: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetUmsCompletionListEvent(
    UmsCompletionList: ?*anyopaque,
    UmsCompletionEvent: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn ExecuteUmsThread(
    UmsThread: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn UmsThreadYield(
    SchedulerParam: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn DeleteUmsCompletionList(
    UmsCompletionList: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetCurrentUmsThread() callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetNextUmsListItem(
    UmsContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn QueryUmsThreadInformation(
    UmsThread: ?*anyopaque,
    UmsThreadInfoClass: RTL_UMS_THREAD_INFO_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    UmsThreadInformation: ?*anyopaque,
    UmsThreadInformationLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn SetUmsThreadInformation(
    UmsThread: ?*anyopaque,
    UmsThreadInfoClass: RTL_UMS_THREAD_INFO_CLASS,
    UmsThreadInformation: ?*anyopaque,
    UmsThreadInformationLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn DeleteUmsThreadContext(
    UmsThread: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn CreateUmsThreadContext(
    lpUmsThread: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn EnterUmsSchedulingMode(
    SchedulerStartupInfo: ?*UMS_SCHEDULER_STARTUP_INFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetUmsSystemThreadInformation(
    ThreadHandle: ?HANDLE,
    SystemThreadInfo: ?*UMS_SYSTEM_THREAD_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetThreadAffinityMask(
    hThread: ?HANDLE,
    dwThreadAffinityMask: usize,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetProcessDEPPolicy(
    dwFlags: PROCESS_DEP_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetProcessDEPPolicy(
    hProcess: ?HANDLE,
    lpFlags: ?*u32,
    lpPermanent: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn PulseEvent(
    hEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn WinExec(
    lpCmdLine: ?[*:0]const u8,
    uCmdShow: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateSemaphoreA(
    lpSemaphoreAttributes: ?*SECURITY_ATTRIBUTES,
    lInitialCount: i32,
    lMaximumCount: i32,
    lpName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateSemaphoreExA(
    lpSemaphoreAttributes: ?*SECURITY_ATTRIBUTES,
    lInitialCount: i32,
    lMaximumCount: i32,
    lpName: ?[*:0]const u8,
    dwFlags: u32,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn QueryFullProcessImageNameA(
    hProcess: ?HANDLE,
    dwFlags: PROCESS_NAME_FORMAT,
    lpExeName: [*:0]u8,
    lpdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn QueryFullProcessImageNameW(
    hProcess: ?HANDLE,
    dwFlags: PROCESS_NAME_FORMAT,
    lpExeName: [*:0]u16,
    lpdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetStartupInfoA(
    lpStartupInfo: ?*STARTUPINFOA,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateProcessWithLogonW(
    lpUsername: ?[*:0]const u16,
    lpDomain: ?[*:0]const u16,
    lpPassword: ?[*:0]const u16,
    dwLogonFlags: CREATE_PROCESS_LOGON_FLAGS,
    lpApplicationName: ?[*:0]const u16,
    lpCommandLine: ?PWSTR,
    dwCreationFlags: u32,
    lpEnvironment: ?*anyopaque,
    lpCurrentDirectory: ?[*:0]const u16,
    lpStartupInfo: ?*STARTUPINFOW,
    lpProcessInformation: ?*PROCESS_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CreateProcessWithTokenW(
    hToken: ?HANDLE,
    dwLogonFlags: CREATE_PROCESS_LOGON_FLAGS,
    lpApplicationName: ?[*:0]const u16,
    lpCommandLine: ?PWSTR,
    dwCreationFlags: u32,
    lpEnvironment: ?*anyopaque,
    lpCurrentDirectory: ?[*:0]const u16,
    lpStartupInfo: ?*STARTUPINFOW,
    lpProcessInformation: ?*PROCESS_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn RegisterWaitForSingleObject(
    phNewWaitObject: ?*?HANDLE,
    hObject: ?HANDLE,
    Callback: ?WAITORTIMERCALLBACK,
    Context: ?*anyopaque,
    dwMilliseconds: u32,
    dwFlags: WORKER_THREAD_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn UnregisterWait(
    WaitHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetTimerQueueTimer(
    TimerQueue: ?HANDLE,
    Callback: ?WAITORTIMERCALLBACK,
    Parameter: ?*anyopaque,
    DueTime: u32,
    Period: u32,
    PreferIo: BOOL,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreatePrivateNamespaceA(
    lpPrivateNamespaceAttributes: ?*SECURITY_ATTRIBUTES,
    lpBoundaryDescriptor: ?*anyopaque,
    lpAliasPrefix: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) NamespaceHandle;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn OpenPrivateNamespaceA(
    lpBoundaryDescriptor: ?*anyopaque,
    lpAliasPrefix: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) NamespaceHandle;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateBoundaryDescriptorA(
    Name: ?[*:0]const u8,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BoundaryDescriptorHandle;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn AddIntegrityLabelToBoundaryDescriptor(
    BoundaryDescriptor: ?*?HANDLE,
    IntegrityLabel: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetActiveProcessorGroupCount() callconv(@import("std").os.windows.WINAPI) u16;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetMaximumProcessorGroupCount() callconv(@import("std").os.windows.WINAPI) u16;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetActiveProcessorCount(
    GroupNumber: u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetMaximumProcessorCount(
    GroupNumber: u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNumaProcessorNode(
    Processor: u8,
    NodeNumber: ?*u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetNumaNodeNumberFromHandle(
    hFile: ?HANDLE,
    NodeNumber: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetNumaProcessorNodeEx(
    Processor: ?*PROCESSOR_NUMBER,
    NodeNumber: ?*u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNumaNodeProcessorMask(
    Node: u8,
    ProcessorMask: ?*u64,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNumaAvailableMemoryNode(
    Node: u8,
    AvailableBytes: ?*u64,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "kernel32" fn GetNumaAvailableMemoryNodeEx(
    Node: u16,
    AvailableBytes: ?*u64,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNumaProximityNode(
    ProximityId: u32,
    NodeNumber: ?*u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "ntdll" fn NtQueryInformationProcess(
    ProcessHandle: ?HANDLE,
    ProcessInformationClass: PROCESSINFOCLASS,
    ProcessInformation: ?*anyopaque,
    ProcessInformationLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) NTSTATUS;

pub extern "ntdll" fn NtQueryInformationThread(
    ThreadHandle: ?HANDLE,
    ThreadInformationClass: THREADINFOCLASS,
    ThreadInformation: ?*anyopaque,
    ThreadInformationLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) NTSTATUS;

pub extern "ntdll" fn NtSetInformationThread(
    ThreadHandle: ?HANDLE,
    ThreadInformationClass: THREADINFOCLASS,
    // TODO: what to do with BytesParamIndex 3?
    ThreadInformation: ?*anyopaque,
    ThreadInformationLength: u32,
) callconv(@import("std").os.windows.WINAPI) NTSTATUS;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (16)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const STARTUPINFO = thismodule.STARTUPINFOA;
        pub const STARTUPINFOEX = thismodule.STARTUPINFOEXA;
        pub const CreateMutex = thismodule.CreateMutexA;
        pub const CreateEvent = thismodule.CreateEventA;
        pub const OpenEvent = thismodule.OpenEventA;
        pub const CreateMutexEx = thismodule.CreateMutexExA;
        pub const CreateEventEx = thismodule.CreateEventExA;
        pub const CreateSemaphoreEx = thismodule.CreateSemaphoreExA;
        pub const CreateSemaphore = thismodule.CreateSemaphoreA;
        pub const CreateProcess = thismodule.CreateProcessA;
        pub const GetStartupInfo = thismodule.GetStartupInfoA;
        pub const CreateProcessAsUser = thismodule.CreateProcessAsUserA;
        pub const CreatePrivateNamespace = thismodule.CreatePrivateNamespaceA;
        pub const OpenPrivateNamespace = thismodule.OpenPrivateNamespaceA;
        pub const CreateBoundaryDescriptor = thismodule.CreateBoundaryDescriptorA;
        pub const QueryFullProcessImageName = thismodule.QueryFullProcessImageNameA;
    },
    .wide => struct {
        pub const STARTUPINFO = thismodule.STARTUPINFOW;
        pub const STARTUPINFOEX = thismodule.STARTUPINFOEXW;
        pub const CreateMutex = thismodule.CreateMutexW;
        pub const CreateEvent = thismodule.CreateEventW;
        pub const OpenEvent = thismodule.OpenEventW;
        pub const CreateMutexEx = thismodule.CreateMutexExW;
        pub const CreateEventEx = thismodule.CreateEventExW;
        pub const CreateSemaphoreEx = thismodule.CreateSemaphoreExW;
        pub const CreateSemaphore = thismodule.CreateSemaphoreW;
        pub const CreateProcess = thismodule.CreateProcessW;
        pub const GetStartupInfo = thismodule.GetStartupInfoW;
        pub const CreateProcessAsUser = thismodule.CreateProcessAsUserW;
        pub const CreatePrivateNamespace = thismodule.CreatePrivateNamespaceW;
        pub const OpenPrivateNamespace = thismodule.OpenPrivateNamespaceW;
        pub const CreateBoundaryDescriptor = thismodule.CreateBoundaryDescriptorW;
        pub const QueryFullProcessImageName = thismodule.QueryFullProcessImageNameW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const STARTUPINFO = *opaque {};
        pub const STARTUPINFOEX = *opaque {};
        pub const CreateMutex = *opaque {};
        pub const CreateEvent = *opaque {};
        pub const OpenEvent = *opaque {};
        pub const CreateMutexEx = *opaque {};
        pub const CreateEventEx = *opaque {};
        pub const CreateSemaphoreEx = *opaque {};
        pub const CreateSemaphore = *opaque {};
        pub const CreateProcess = *opaque {};
        pub const GetStartupInfo = *opaque {};
        pub const CreateProcessAsUser = *opaque {};
        pub const CreatePrivateNamespace = *opaque {};
        pub const OpenPrivateNamespace = *opaque {};
        pub const CreateBoundaryDescriptor = *opaque {};
        pub const QueryFullProcessImageName = *opaque {};
    } else struct {
        pub const STARTUPINFO = @compileError("'STARTUPINFO' requires that UNICODE be set to true or false in the root module");
        pub const STARTUPINFOEX = @compileError("'STARTUPINFOEX' requires that UNICODE be set to true or false in the root module");
        pub const CreateMutex = @compileError("'CreateMutex' requires that UNICODE be set to true or false in the root module");
        pub const CreateEvent = @compileError("'CreateEvent' requires that UNICODE be set to true or false in the root module");
        pub const OpenEvent = @compileError("'OpenEvent' requires that UNICODE be set to true or false in the root module");
        pub const CreateMutexEx = @compileError("'CreateMutexEx' requires that UNICODE be set to true or false in the root module");
        pub const CreateEventEx = @compileError("'CreateEventEx' requires that UNICODE be set to true or false in the root module");
        pub const CreateSemaphoreEx = @compileError("'CreateSemaphoreEx' requires that UNICODE be set to true or false in the root module");
        pub const CreateSemaphore = @compileError("'CreateSemaphore' requires that UNICODE be set to true or false in the root module");
        pub const CreateProcess = @compileError("'CreateProcess' requires that UNICODE be set to true or false in the root module");
        pub const GetStartupInfo = @compileError("'GetStartupInfo' requires that UNICODE be set to true or false in the root module");
        pub const CreateProcessAsUser = @compileError("'CreateProcessAsUser' requires that UNICODE be set to true or false in the root module");
        pub const CreatePrivateNamespace = @compileError("'CreatePrivateNamespace' requires that UNICODE be set to true or false in the root module");
        pub const OpenPrivateNamespace = @compileError("'OpenPrivateNamespace' requires that UNICODE be set to true or false in the root module");
        pub const CreateBoundaryDescriptor = @compileError("'CreateBoundaryDescriptor' requires that UNICODE be set to true or false in the root module");
        pub const QueryFullProcessImageName = @compileError("'QueryFullProcessImageName' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (22)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const FILETIME = @import("../foundation.zig").FILETIME;
const GROUP_AFFINITY = @import("../system/system_information.zig").GROUP_AFFINITY;
const HANDLE = @import("../foundation.zig").HANDLE;
const HINSTANCE = @import("../foundation.zig").HINSTANCE;
const HRESULT = @import("../foundation.zig").HRESULT;
const LARGE_INTEGER = @import("../foundation.zig").LARGE_INTEGER;
const LIST_ENTRY = @import("../system/kernel.zig").LIST_ENTRY;
const NTSTATUS = @import("../foundation.zig").NTSTATUS;
const PAPCFUNC = @import("../foundation.zig").PAPCFUNC;
const PROCESSOR_NUMBER = @import("../system/kernel.zig").PROCESSOR_NUMBER;
const PSID = @import("../foundation.zig").PSID;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const RTL_UMS_SCHEDULER_REASON = @import("../system/system_services.zig").RTL_UMS_SCHEDULER_REASON;
const SECURITY_ATTRIBUTES = @import("../security.zig").SECURITY_ATTRIBUTES;
const SLIST_ENTRY = @import("../system/kernel.zig").SLIST_ENTRY;
const SLIST_HEADER = @import("../system/kernel.zig").SLIST_HEADER;
const TOKEN_ACCESS_MASK = @import("../security.zig").TOKEN_ACCESS_MASK;
const UNICODE_STRING = @import("../foundation.zig").UNICODE_STRING;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "LPTHREAD_START_ROUTINE")) {
        _ = LPTHREAD_START_ROUTINE;
    }
    if (@hasDecl(@This(), "PINIT_ONCE_FN")) {
        _ = PINIT_ONCE_FN;
    }
    if (@hasDecl(@This(), "PTIMERAPCROUTINE")) {
        _ = PTIMERAPCROUTINE;
    }
    if (@hasDecl(@This(), "PTP_WIN32_IO_CALLBACK")) {
        _ = PTP_WIN32_IO_CALLBACK;
    }
    if (@hasDecl(@This(), "PRTL_UMS_SCHEDULER_ENTRY_POINT")) {
        _ = PRTL_UMS_SCHEDULER_ENTRY_POINT;
    }
    if (@hasDecl(@This(), "WAITORTIMERCALLBACK")) {
        _ = WAITORTIMERCALLBACK;
    }
    if (@hasDecl(@This(), "PFLS_CALLBACK_FUNCTION")) {
        _ = PFLS_CALLBACK_FUNCTION;
    }
    if (@hasDecl(@This(), "PTP_SIMPLE_CALLBACK")) {
        _ = PTP_SIMPLE_CALLBACK;
    }
    if (@hasDecl(@This(), "PTP_CLEANUP_GROUP_CANCEL_CALLBACK")) {
        _ = PTP_CLEANUP_GROUP_CANCEL_CALLBACK;
    }
    if (@hasDecl(@This(), "PTP_WORK_CALLBACK")) {
        _ = PTP_WORK_CALLBACK;
    }
    if (@hasDecl(@This(), "PTP_TIMER_CALLBACK")) {
        _ = PTP_TIMER_CALLBACK;
    }
    if (@hasDecl(@This(), "PTP_WAIT_CALLBACK")) {
        _ = PTP_WAIT_CALLBACK;
    }
    if (@hasDecl(@This(), "LPFIBER_START_ROUTINE")) {
        _ = LPFIBER_START_ROUTINE;
    }
    if (@hasDecl(@This(), "PPS_POST_PROCESS_INIT_ROUTINE")) {
        _ = PPS_POST_PROCESS_INIT_ROUTINE;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
