//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (123)
//--------------------------------------------------------------------------------
pub const SERVICE_ALL_ACCESS = @as(u32, 983551);
pub const SC_MANAGER_ALL_ACCESS = @as(u32, 983103);
pub const SERVICE_NO_CHANGE = @as(u32, 4294967295);
pub const SERVICE_CONTROL_STOP = @as(u32, 1);
pub const SERVICE_CONTROL_PAUSE = @as(u32, 2);
pub const SERVICE_CONTROL_CONTINUE = @as(u32, 3);
pub const SERVICE_CONTROL_INTERROGATE = @as(u32, 4);
pub const SERVICE_CONTROL_SHUTDOWN = @as(u32, 5);
pub const SERVICE_CONTROL_PARAMCHANGE = @as(u32, 6);
pub const SERVICE_CONTROL_NETBINDADD = @as(u32, 7);
pub const SERVICE_CONTROL_NETBINDREMOVE = @as(u32, 8);
pub const SERVICE_CONTROL_NETBINDENABLE = @as(u32, 9);
pub const SERVICE_CONTROL_NETBINDDISABLE = @as(u32, 10);
pub const SERVICE_CONTROL_DEVICEEVENT = @as(u32, 11);
pub const SERVICE_CONTROL_HARDWAREPROFILECHANGE = @as(u32, 12);
pub const SERVICE_CONTROL_POWEREVENT = @as(u32, 13);
pub const SERVICE_CONTROL_SESSIONCHANGE = @as(u32, 14);
pub const SERVICE_CONTROL_PRESHUTDOWN = @as(u32, 15);
pub const SERVICE_CONTROL_TIMECHANGE = @as(u32, 16);
pub const SERVICE_CONTROL_TRIGGEREVENT = @as(u32, 32);
pub const SERVICE_CONTROL_LOWRESOURCES = @as(u32, 96);
pub const SERVICE_CONTROL_SYSTEMLOWRESOURCES = @as(u32, 97);
pub const SERVICE_ACCEPT_STOP = @as(u32, 1);
pub const SERVICE_ACCEPT_PAUSE_CONTINUE = @as(u32, 2);
pub const SERVICE_ACCEPT_SHUTDOWN = @as(u32, 4);
pub const SERVICE_ACCEPT_PARAMCHANGE = @as(u32, 8);
pub const SERVICE_ACCEPT_NETBINDCHANGE = @as(u32, 16);
pub const SERVICE_ACCEPT_HARDWAREPROFILECHANGE = @as(u32, 32);
pub const SERVICE_ACCEPT_POWEREVENT = @as(u32, 64);
pub const SERVICE_ACCEPT_SESSIONCHANGE = @as(u32, 128);
pub const SERVICE_ACCEPT_PRESHUTDOWN = @as(u32, 256);
pub const SERVICE_ACCEPT_TIMECHANGE = @as(u32, 512);
pub const SERVICE_ACCEPT_TRIGGEREVENT = @as(u32, 1024);
pub const SERVICE_ACCEPT_USER_LOGOFF = @as(u32, 2048);
pub const SERVICE_ACCEPT_LOWRESOURCES = @as(u32, 8192);
pub const SERVICE_ACCEPT_SYSTEMLOWRESOURCES = @as(u32, 16384);
pub const SC_MANAGER_CONNECT = @as(u32, 1);
pub const SC_MANAGER_CREATE_SERVICE = @as(u32, 2);
pub const SC_MANAGER_ENUMERATE_SERVICE = @as(u32, 4);
pub const SC_MANAGER_LOCK = @as(u32, 8);
pub const SC_MANAGER_QUERY_LOCK_STATUS = @as(u32, 16);
pub const SC_MANAGER_MODIFY_BOOT_CONFIG = @as(u32, 32);
pub const SERVICE_QUERY_CONFIG = @as(u32, 1);
pub const SERVICE_CHANGE_CONFIG = @as(u32, 2);
pub const SERVICE_QUERY_STATUS = @as(u32, 4);
pub const SERVICE_ENUMERATE_DEPENDENTS = @as(u32, 8);
pub const SERVICE_START = @as(u32, 16);
pub const SERVICE_STOP = @as(u32, 32);
pub const SERVICE_PAUSE_CONTINUE = @as(u32, 64);
pub const SERVICE_INTERROGATE = @as(u32, 128);
pub const SERVICE_USER_DEFINED_CONTROL = @as(u32, 256);
pub const SERVICE_NOTIFY_STATUS_CHANGE_1 = @as(u32, 1);
pub const SERVICE_NOTIFY_STATUS_CHANGE_2 = @as(u32, 2);
pub const SERVICE_NOTIFY_STATUS_CHANGE = @as(u32, 2);
pub const SERVICE_STOP_REASON_FLAG_MIN = @as(u32, 0);
pub const SERVICE_STOP_REASON_FLAG_UNPLANNED = @as(u32, 268435456);
pub const SERVICE_STOP_REASON_FLAG_CUSTOM = @as(u32, 536870912);
pub const SERVICE_STOP_REASON_FLAG_PLANNED = @as(u32, 1073741824);
pub const SERVICE_STOP_REASON_FLAG_MAX = @as(u32, 2147483648);
pub const SERVICE_STOP_REASON_MAJOR_MIN = @as(u32, 0);
pub const SERVICE_STOP_REASON_MAJOR_OTHER = @as(u32, 65536);
pub const SERVICE_STOP_REASON_MAJOR_HARDWARE = @as(u32, 131072);
pub const SERVICE_STOP_REASON_MAJOR_OPERATINGSYSTEM = @as(u32, 196608);
pub const SERVICE_STOP_REASON_MAJOR_SOFTWARE = @as(u32, 262144);
pub const SERVICE_STOP_REASON_MAJOR_APPLICATION = @as(u32, 327680);
pub const SERVICE_STOP_REASON_MAJOR_NONE = @as(u32, 393216);
pub const SERVICE_STOP_REASON_MAJOR_MAX = @as(u32, 458752);
pub const SERVICE_STOP_REASON_MAJOR_MIN_CUSTOM = @as(u32, 4194304);
pub const SERVICE_STOP_REASON_MAJOR_MAX_CUSTOM = @as(u32, 16711680);
pub const SERVICE_STOP_REASON_MINOR_MIN = @as(u32, 0);
pub const SERVICE_STOP_REASON_MINOR_OTHER = @as(u32, 1);
pub const SERVICE_STOP_REASON_MINOR_MAINTENANCE = @as(u32, 2);
pub const SERVICE_STOP_REASON_MINOR_INSTALLATION = @as(u32, 3);
pub const SERVICE_STOP_REASON_MINOR_UPGRADE = @as(u32, 4);
pub const SERVICE_STOP_REASON_MINOR_RECONFIG = @as(u32, 5);
pub const SERVICE_STOP_REASON_MINOR_HUNG = @as(u32, 6);
pub const SERVICE_STOP_REASON_MINOR_UNSTABLE = @as(u32, 7);
pub const SERVICE_STOP_REASON_MINOR_DISK = @as(u32, 8);
pub const SERVICE_STOP_REASON_MINOR_NETWORKCARD = @as(u32, 9);
pub const SERVICE_STOP_REASON_MINOR_ENVIRONMENT = @as(u32, 10);
pub const SERVICE_STOP_REASON_MINOR_HARDWARE_DRIVER = @as(u32, 11);
pub const SERVICE_STOP_REASON_MINOR_OTHERDRIVER = @as(u32, 12);
pub const SERVICE_STOP_REASON_MINOR_SERVICEPACK = @as(u32, 13);
pub const SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE = @as(u32, 14);
pub const SERVICE_STOP_REASON_MINOR_SECURITYFIX = @as(u32, 15);
pub const SERVICE_STOP_REASON_MINOR_SECURITY = @as(u32, 16);
pub const SERVICE_STOP_REASON_MINOR_NETWORK_CONNECTIVITY = @as(u32, 17);
pub const SERVICE_STOP_REASON_MINOR_WMI = @as(u32, 18);
pub const SERVICE_STOP_REASON_MINOR_SERVICEPACK_UNINSTALL = @as(u32, 19);
pub const SERVICE_STOP_REASON_MINOR_SOFTWARE_UPDATE_UNINSTALL = @as(u32, 20);
pub const SERVICE_STOP_REASON_MINOR_SECURITYFIX_UNINSTALL = @as(u32, 21);
pub const SERVICE_STOP_REASON_MINOR_MMC = @as(u32, 22);
pub const SERVICE_STOP_REASON_MINOR_NONE = @as(u32, 23);
pub const SERVICE_STOP_REASON_MINOR_MEMOTYLIMIT = @as(u32, 24);
pub const SERVICE_STOP_REASON_MINOR_MAX = @as(u32, 25);
pub const SERVICE_STOP_REASON_MINOR_MIN_CUSTOM = @as(u32, 256);
pub const SERVICE_STOP_REASON_MINOR_MAX_CUSTOM = @as(u32, 65535);
pub const SERVICE_CONTROL_STATUS_REASON_INFO = @as(u32, 1);
pub const SERVICE_SID_TYPE_NONE = @as(u32, 0);
pub const SERVICE_SID_TYPE_UNRESTRICTED = @as(u32, 1);
pub const SERVICE_TRIGGER_TYPE_CUSTOM_SYSTEM_STATE_CHANGE = @as(u32, 7);
pub const SERVICE_TRIGGER_TYPE_AGGREGATE = @as(u32, 30);
pub const SERVICE_START_REASON_DEMAND = @as(u32, 1);
pub const SERVICE_START_REASON_AUTO = @as(u32, 2);
pub const SERVICE_START_REASON_TRIGGER = @as(u32, 4);
pub const SERVICE_START_REASON_RESTART_ON_FAILURE = @as(u32, 8);
pub const SERVICE_START_REASON_DELAYEDAUTO = @as(u32, 16);
pub const SERVICE_DYNAMIC_INFORMATION_LEVEL_START_REASON = @as(u32, 1);
pub const SERVICE_LAUNCH_PROTECTED_NONE = @as(u32, 0);
pub const SERVICE_LAUNCH_PROTECTED_WINDOWS = @as(u32, 1);
pub const SERVICE_LAUNCH_PROTECTED_WINDOWS_LIGHT = @as(u32, 2);
pub const SERVICE_LAUNCH_PROTECTED_ANTIMALWARE_LIGHT = @as(u32, 3);
pub const NETWORK_MANAGER_FIRST_IP_ADDRESS_ARRIVAL_GUID = Guid.initString("4f27f2de-14e2-430b-a549-7cd48cbc8245");
pub const NETWORK_MANAGER_LAST_IP_ADDRESS_REMOVAL_GUID = Guid.initString("cc4ba62a-162e-4648-847a-b6bdf993e335");
pub const DOMAIN_JOIN_GUID = Guid.initString("1ce20aba-9851-4421-9430-1ddeb766e809");
pub const DOMAIN_LEAVE_GUID = Guid.initString("ddaf516e-58c2-4866-9574-c3b615d42ea1");
pub const FIREWALL_PORT_OPEN_GUID = Guid.initString("b7569e07-8421-4ee0-ad10-86915afdad09");
pub const FIREWALL_PORT_CLOSE_GUID = Guid.initString("a144ed38-8e12-4de4-9d96-e64740b1a524");
pub const MACHINE_POLICY_PRESENT_GUID = Guid.initString("659fcae6-5bdb-4da9-b1ff-ca2a178d46e0");
pub const USER_POLICY_PRESENT_GUID = Guid.initString("54fb46c8-f089-464c-b1fd-59d1b62c3b50");
pub const RPC_INTERFACE_EVENT_GUID = Guid.initString("bc90d167-9470-4139-a9ba-be0bbbf5b74d");
pub const NAMED_PIPE_EVENT_GUID = Guid.initString("1f81d131-3fac-4537-9e0c-7e7b0c2f4b55");
pub const CUSTOM_SYSTEM_STATE_CHANGE_EVENT_GUID = Guid.initString("2d7a2816-0c5e-45fc-9ce7-570e5ecde9c9");

//--------------------------------------------------------------------------------
// Section: Types (68)
//--------------------------------------------------------------------------------
pub const ENUM_SERVICE_STATE = enum(u32) {
    ACTIVE = 1,
    INACTIVE = 2,
    STATE_ALL = 3,
};
pub const SERVICE_ACTIVE = ENUM_SERVICE_STATE.ACTIVE;
pub const SERVICE_INACTIVE = ENUM_SERVICE_STATE.INACTIVE;
pub const SERVICE_STATE_ALL = ENUM_SERVICE_STATE.STATE_ALL;

pub const SERVICE_ERROR = enum(u32) {
    CRITICAL = 3,
    IGNORE = 0,
    NORMAL = 1,
    SEVERE = 2,
};
pub const SERVICE_ERROR_CRITICAL = SERVICE_ERROR.CRITICAL;
pub const SERVICE_ERROR_IGNORE = SERVICE_ERROR.IGNORE;
pub const SERVICE_ERROR_NORMAL = SERVICE_ERROR.NORMAL;
pub const SERVICE_ERROR_SEVERE = SERVICE_ERROR.SEVERE;

pub const SERVICE_CONFIG = enum(u32) {
    DELAYED_AUTO_START_INFO = 3,
    DESCRIPTION = 1,
    FAILURE_ACTIONS = 2,
    FAILURE_ACTIONS_FLAG = 4,
    PREFERRED_NODE = 9,
    PRESHUTDOWN_INFO = 7,
    REQUIRED_PRIVILEGES_INFO = 6,
    SERVICE_SID_INFO = 5,
    TRIGGER_INFO = 8,
    LAUNCH_PROTECTED = 12,
};
pub const SERVICE_CONFIG_DELAYED_AUTO_START_INFO = SERVICE_CONFIG.DELAYED_AUTO_START_INFO;
pub const SERVICE_CONFIG_DESCRIPTION = SERVICE_CONFIG.DESCRIPTION;
pub const SERVICE_CONFIG_FAILURE_ACTIONS = SERVICE_CONFIG.FAILURE_ACTIONS;
pub const SERVICE_CONFIG_FAILURE_ACTIONS_FLAG = SERVICE_CONFIG.FAILURE_ACTIONS_FLAG;
pub const SERVICE_CONFIG_PREFERRED_NODE = SERVICE_CONFIG.PREFERRED_NODE;
pub const SERVICE_CONFIG_PRESHUTDOWN_INFO = SERVICE_CONFIG.PRESHUTDOWN_INFO;
pub const SERVICE_CONFIG_REQUIRED_PRIVILEGES_INFO = SERVICE_CONFIG.REQUIRED_PRIVILEGES_INFO;
pub const SERVICE_CONFIG_SERVICE_SID_INFO = SERVICE_CONFIG.SERVICE_SID_INFO;
pub const SERVICE_CONFIG_TRIGGER_INFO = SERVICE_CONFIG.TRIGGER_INFO;
pub const SERVICE_CONFIG_LAUNCH_PROTECTED = SERVICE_CONFIG.LAUNCH_PROTECTED;

pub const ENUM_SERVICE_TYPE = enum(u32) {
    DRIVER = 11,
    FILE_SYSTEM_DRIVER_ = 2,
    KERNEL_DRIVER = 1,
    WIN32 = 48,
    WIN32_OWN_PROCESS_ = 16,
    WIN32_SHARE_PROCESS = 32,
    ADAPTER = 4,
    // FILE_SYSTEM_DRIVER = 2, this enum value conflicts with FILE_SYSTEM_DRIVER_
    RECOGNIZER_DRIVER = 8,
    // WIN32_OWN_PROCESS = 16, this enum value conflicts with WIN32_OWN_PROCESS_
    USER_OWN_PROCESS = 80,
    USER_SHARE_PROCESS = 96,
    _,
    pub fn initFlags(o: struct {
        DRIVER: u1 = 0,
        FILE_SYSTEM_DRIVER_: u1 = 0,
        KERNEL_DRIVER: u1 = 0,
        WIN32: u1 = 0,
        WIN32_OWN_PROCESS_: u1 = 0,
        WIN32_SHARE_PROCESS: u1 = 0,
        ADAPTER: u1 = 0,
        RECOGNIZER_DRIVER: u1 = 0,
        USER_OWN_PROCESS: u1 = 0,
        USER_SHARE_PROCESS: u1 = 0,
    }) ENUM_SERVICE_TYPE {
        return @as(ENUM_SERVICE_TYPE, @enumFromInt((if (o.DRIVER == 1) @intFromEnum(ENUM_SERVICE_TYPE.DRIVER) else 0) | (if (o.FILE_SYSTEM_DRIVER_ == 1) @intFromEnum(ENUM_SERVICE_TYPE.FILE_SYSTEM_DRIVER_) else 0) | (if (o.KERNEL_DRIVER == 1) @intFromEnum(ENUM_SERVICE_TYPE.KERNEL_DRIVER) else 0) | (if (o.WIN32 == 1) @intFromEnum(ENUM_SERVICE_TYPE.WIN32) else 0) | (if (o.WIN32_OWN_PROCESS_ == 1) @intFromEnum(ENUM_SERVICE_TYPE.WIN32_OWN_PROCESS_) else 0) | (if (o.WIN32_SHARE_PROCESS == 1) @intFromEnum(ENUM_SERVICE_TYPE.WIN32_SHARE_PROCESS) else 0) | (if (o.ADAPTER == 1) @intFromEnum(ENUM_SERVICE_TYPE.ADAPTER) else 0) | (if (o.RECOGNIZER_DRIVER == 1) @intFromEnum(ENUM_SERVICE_TYPE.RECOGNIZER_DRIVER) else 0) | (if (o.USER_OWN_PROCESS == 1) @intFromEnum(ENUM_SERVICE_TYPE.USER_OWN_PROCESS) else 0) | (if (o.USER_SHARE_PROCESS == 1) @intFromEnum(ENUM_SERVICE_TYPE.USER_SHARE_PROCESS) else 0)));
    }
};
pub const SERVICE_DRIVER = ENUM_SERVICE_TYPE.DRIVER;
pub const SERVICE_FILE_SYSTEM_DRIVER_ = ENUM_SERVICE_TYPE.FILE_SYSTEM_DRIVER_;
pub const SERVICE_KERNEL_DRIVER = ENUM_SERVICE_TYPE.KERNEL_DRIVER;
pub const SERVICE_WIN32 = ENUM_SERVICE_TYPE.WIN32;
pub const SERVICE_WIN32_OWN_PROCESS_ = ENUM_SERVICE_TYPE.WIN32_OWN_PROCESS_;
pub const SERVICE_WIN32_SHARE_PROCESS = ENUM_SERVICE_TYPE.WIN32_SHARE_PROCESS;
pub const SERVICE_ADAPTER = ENUM_SERVICE_TYPE.ADAPTER;
pub const SERVICE_FILE_SYSTEM_DRIVER = ENUM_SERVICE_TYPE.FILE_SYSTEM_DRIVER_;
pub const SERVICE_RECOGNIZER_DRIVER = ENUM_SERVICE_TYPE.RECOGNIZER_DRIVER;
pub const SERVICE_WIN32_OWN_PROCESS = ENUM_SERVICE_TYPE.WIN32_OWN_PROCESS_;
pub const SERVICE_USER_OWN_PROCESS = ENUM_SERVICE_TYPE.USER_OWN_PROCESS;
pub const SERVICE_USER_SHARE_PROCESS = ENUM_SERVICE_TYPE.USER_SHARE_PROCESS;

pub const SERVICE_START_TYPE = enum(u32) {
    AUTO_START = 2,
    BOOT_START = 0,
    DEMAND_START = 3,
    DISABLED = 4,
    SYSTEM_START = 1,
};
pub const SERVICE_AUTO_START = SERVICE_START_TYPE.AUTO_START;
pub const SERVICE_BOOT_START = SERVICE_START_TYPE.BOOT_START;
pub const SERVICE_DEMAND_START = SERVICE_START_TYPE.DEMAND_START;
pub const SERVICE_DISABLED = SERVICE_START_TYPE.DISABLED;
pub const SERVICE_SYSTEM_START = SERVICE_START_TYPE.SYSTEM_START;

pub const SERVICE_NOTIFY = enum(u32) {
    CREATED = 128,
    CONTINUE_PENDING = 16,
    DELETE_PENDING = 512,
    DELETED = 256,
    PAUSE_PENDING = 32,
    PAUSED = 64,
    RUNNING = 8,
    START_PENDING = 2,
    STOP_PENDING = 4,
    STOPPED = 1,
    _,
    pub fn initFlags(o: struct {
        CREATED: u1 = 0,
        CONTINUE_PENDING: u1 = 0,
        DELETE_PENDING: u1 = 0,
        DELETED: u1 = 0,
        PAUSE_PENDING: u1 = 0,
        PAUSED: u1 = 0,
        RUNNING: u1 = 0,
        START_PENDING: u1 = 0,
        STOP_PENDING: u1 = 0,
        STOPPED: u1 = 0,
    }) SERVICE_NOTIFY {
        return @as(SERVICE_NOTIFY, @enumFromInt((if (o.CREATED == 1) @intFromEnum(SERVICE_NOTIFY.CREATED) else 0) | (if (o.CONTINUE_PENDING == 1) @intFromEnum(SERVICE_NOTIFY.CONTINUE_PENDING) else 0) | (if (o.DELETE_PENDING == 1) @intFromEnum(SERVICE_NOTIFY.DELETE_PENDING) else 0) | (if (o.DELETED == 1) @intFromEnum(SERVICE_NOTIFY.DELETED) else 0) | (if (o.PAUSE_PENDING == 1) @intFromEnum(SERVICE_NOTIFY.PAUSE_PENDING) else 0) | (if (o.PAUSED == 1) @intFromEnum(SERVICE_NOTIFY.PAUSED) else 0) | (if (o.RUNNING == 1) @intFromEnum(SERVICE_NOTIFY.RUNNING) else 0) | (if (o.START_PENDING == 1) @intFromEnum(SERVICE_NOTIFY.START_PENDING) else 0) | (if (o.STOP_PENDING == 1) @intFromEnum(SERVICE_NOTIFY.STOP_PENDING) else 0) | (if (o.STOPPED == 1) @intFromEnum(SERVICE_NOTIFY.STOPPED) else 0)));
    }
};
pub const SERVICE_NOTIFY_CREATED = SERVICE_NOTIFY.CREATED;
pub const SERVICE_NOTIFY_CONTINUE_PENDING = SERVICE_NOTIFY.CONTINUE_PENDING;
pub const SERVICE_NOTIFY_DELETE_PENDING = SERVICE_NOTIFY.DELETE_PENDING;
pub const SERVICE_NOTIFY_DELETED = SERVICE_NOTIFY.DELETED;
pub const SERVICE_NOTIFY_PAUSE_PENDING = SERVICE_NOTIFY.PAUSE_PENDING;
pub const SERVICE_NOTIFY_PAUSED = SERVICE_NOTIFY.PAUSED;
pub const SERVICE_NOTIFY_RUNNING = SERVICE_NOTIFY.RUNNING;
pub const SERVICE_NOTIFY_START_PENDING = SERVICE_NOTIFY.START_PENDING;
pub const SERVICE_NOTIFY_STOP_PENDING = SERVICE_NOTIFY.STOP_PENDING;
pub const SERVICE_NOTIFY_STOPPED = SERVICE_NOTIFY.STOPPED;

pub const SERVICE_RUNS_IN_PROCESS = enum(u32) {
    NON_SYSTEM_OR_NOT_RUNNING = 0,
    SYSTEM_PROCESS = 1,
};
pub const SERVICE_RUNS_IN_NON_SYSTEM_OR_NOT_RUNNING = SERVICE_RUNS_IN_PROCESS.NON_SYSTEM_OR_NOT_RUNNING;
pub const SERVICE_RUNS_IN_SYSTEM_PROCESS = SERVICE_RUNS_IN_PROCESS.SYSTEM_PROCESS;

pub const SERVICE_TRIGGER_ACTION = enum(u32) {
    ART = 1,
    OP = 2,
};
pub const SERVICE_TRIGGER_ACTION_SERVICE_START = SERVICE_TRIGGER_ACTION.ART;
pub const SERVICE_TRIGGER_ACTION_SERVICE_STOP = SERVICE_TRIGGER_ACTION.OP;

pub const SERVICE_TRIGGER_TYPE = enum(u32) {
    CUSTOM = 20,
    DEVICE_INTERFACE_ARRIVAL = 1,
    DOMAIN_JOIN = 3,
    FIREWALL_PORT_EVENT = 4,
    GROUP_POLICY = 5,
    IP_ADDRESS_AVAILABILITY = 2,
    NETWORK_ENDPOINT = 6,
};
pub const SERVICE_TRIGGER_TYPE_CUSTOM = SERVICE_TRIGGER_TYPE.CUSTOM;
pub const SERVICE_TRIGGER_TYPE_DEVICE_INTERFACE_ARRIVAL = SERVICE_TRIGGER_TYPE.DEVICE_INTERFACE_ARRIVAL;
pub const SERVICE_TRIGGER_TYPE_DOMAIN_JOIN = SERVICE_TRIGGER_TYPE.DOMAIN_JOIN;
pub const SERVICE_TRIGGER_TYPE_FIREWALL_PORT_EVENT = SERVICE_TRIGGER_TYPE.FIREWALL_PORT_EVENT;
pub const SERVICE_TRIGGER_TYPE_GROUP_POLICY = SERVICE_TRIGGER_TYPE.GROUP_POLICY;
pub const SERVICE_TRIGGER_TYPE_IP_ADDRESS_AVAILABILITY = SERVICE_TRIGGER_TYPE.IP_ADDRESS_AVAILABILITY;
pub const SERVICE_TRIGGER_TYPE_NETWORK_ENDPOINT = SERVICE_TRIGGER_TYPE.NETWORK_ENDPOINT;

pub const SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE = enum(u32) {
    BINARY = 1,
    STRING = 2,
    LEVEL = 3,
    KEYWORD_ANY = 4,
    KEYWORD_ALL = 5,
};
pub const SERVICE_TRIGGER_DATA_TYPE_BINARY = SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE.BINARY;
pub const SERVICE_TRIGGER_DATA_TYPE_STRING = SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE.STRING;
pub const SERVICE_TRIGGER_DATA_TYPE_LEVEL = SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE.LEVEL;
pub const SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ANY = SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE.KEYWORD_ANY;
pub const SERVICE_TRIGGER_DATA_TYPE_KEYWORD_ALL = SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE.KEYWORD_ALL;

pub const SERVICE_STATUS_CURRENT_STATE = enum(u32) {
    CONTINUE_PENDING = 5,
    PAUSE_PENDING = 6,
    PAUSED = 7,
    RUNNING = 4,
    START_PENDING = 2,
    STOP_PENDING = 3,
    STOPPED = 1,
};
pub const SERVICE_CONTINUE_PENDING = SERVICE_STATUS_CURRENT_STATE.CONTINUE_PENDING;
pub const SERVICE_PAUSE_PENDING = SERVICE_STATUS_CURRENT_STATE.PAUSE_PENDING;
pub const SERVICE_PAUSED = SERVICE_STATUS_CURRENT_STATE.PAUSED;
pub const SERVICE_RUNNING = SERVICE_STATUS_CURRENT_STATE.RUNNING;
pub const SERVICE_START_PENDING = SERVICE_STATUS_CURRENT_STATE.START_PENDING;
pub const SERVICE_STOP_PENDING = SERVICE_STATUS_CURRENT_STATE.STOP_PENDING;
pub const SERVICE_STOPPED = SERVICE_STATUS_CURRENT_STATE.STOPPED;

pub const SERVICE_STATUS_HANDLE = isize;

pub const SERVICE_TRIGGER_CUSTOM_STATE_ID = extern struct {
    Data: [2]u32,
};

pub const SERVICE_CUSTOM_SYSTEM_STATE_CHANGE_DATA_ITEM = extern struct {
    u: extern union {
        CustomStateId: SERVICE_TRIGGER_CUSTOM_STATE_ID,
        s: extern struct {
            DataOffset: u32,
            Data: [1]u8,
        },
    },
};

pub const SERVICE_DESCRIPTIONA = extern struct {
    lpDescription: ?PSTR,
};

pub const SERVICE_DESCRIPTIONW = extern struct {
    lpDescription: ?PWSTR,
};

pub const SC_ACTION_TYPE = enum(i32) {
    NONE = 0,
    RESTART = 1,
    REBOOT = 2,
    RUN_COMMAND = 3,
    OWN_RESTART = 4,
};
pub const SC_ACTION_NONE = SC_ACTION_TYPE.NONE;
pub const SC_ACTION_RESTART = SC_ACTION_TYPE.RESTART;
pub const SC_ACTION_REBOOT = SC_ACTION_TYPE.REBOOT;
pub const SC_ACTION_RUN_COMMAND = SC_ACTION_TYPE.RUN_COMMAND;
pub const SC_ACTION_OWN_RESTART = SC_ACTION_TYPE.OWN_RESTART;

pub const SC_ACTION = extern struct {
    Type: SC_ACTION_TYPE,
    Delay: u32,
};

pub const SERVICE_FAILURE_ACTIONSA = extern struct {
    dwResetPeriod: u32,
    lpRebootMsg: ?PSTR,
    lpCommand: ?PSTR,
    cActions: u32,
    lpsaActions: ?*SC_ACTION,
};

pub const SERVICE_FAILURE_ACTIONSW = extern struct {
    dwResetPeriod: u32,
    lpRebootMsg: ?PWSTR,
    lpCommand: ?PWSTR,
    cActions: u32,
    lpsaActions: ?*SC_ACTION,
};

pub const SERVICE_DELAYED_AUTO_START_INFO = extern struct {
    fDelayedAutostart: BOOL,
};

pub const SERVICE_FAILURE_ACTIONS_FLAG = extern struct {
    fFailureActionsOnNonCrashFailures: BOOL,
};

pub const SERVICE_SID_INFO = extern struct {
    dwServiceSidType: u32,
};

pub const SERVICE_REQUIRED_PRIVILEGES_INFOA = extern struct {
    pmszRequiredPrivileges: ?PSTR,
};

pub const SERVICE_REQUIRED_PRIVILEGES_INFOW = extern struct {
    pmszRequiredPrivileges: ?PWSTR,
};

pub const SERVICE_PRESHUTDOWN_INFO = extern struct {
    dwPreshutdownTimeout: u32,
};

pub const SERVICE_TRIGGER_SPECIFIC_DATA_ITEM = extern struct {
    dwDataType: SERVICE_TRIGGER_SPECIFIC_DATA_ITEM_DATA_TYPE,
    cbData: u32,
    pData: ?*u8,
};

pub const SERVICE_TRIGGER = extern struct {
    dwTriggerType: SERVICE_TRIGGER_TYPE,
    dwAction: SERVICE_TRIGGER_ACTION,
    pTriggerSubtype: ?*Guid,
    cDataItems: u32,
    pDataItems: ?*SERVICE_TRIGGER_SPECIFIC_DATA_ITEM,
};

pub const SERVICE_TRIGGER_INFO = extern struct {
    cTriggers: u32,
    pTriggers: ?*SERVICE_TRIGGER,
    pReserved: ?*u8,
};

pub const SERVICE_PREFERRED_NODE_INFO = extern struct {
    usPreferredNode: u16,
    fDelete: BOOLEAN,
};

pub const SERVICE_TIMECHANGE_INFO = extern struct {
    liNewTime: LARGE_INTEGER,
    liOldTime: LARGE_INTEGER,
};

pub const SERVICE_LAUNCH_PROTECTED_INFO = extern struct {
    dwLaunchProtected: u32,
};

pub const SC_STATUS_TYPE = enum(i32) {
    O = 0,
};
pub const SC_STATUS_PROCESS_INFO = SC_STATUS_TYPE.O;

pub const SC_ENUM_TYPE = enum(i32) {
    O = 0,
};
pub const SC_ENUM_PROCESS_INFO = SC_ENUM_TYPE.O;

pub const SERVICE_STATUS = extern struct {
    dwServiceType: ENUM_SERVICE_TYPE,
    dwCurrentState: SERVICE_STATUS_CURRENT_STATE,
    dwControlsAccepted: u32,
    dwWin32ExitCode: u32,
    dwServiceSpecificExitCode: u32,
    dwCheckPoint: u32,
    dwWaitHint: u32,
};

pub const SERVICE_STATUS_PROCESS = extern struct {
    dwServiceType: ENUM_SERVICE_TYPE,
    dwCurrentState: SERVICE_STATUS_CURRENT_STATE,
    dwControlsAccepted: u32,
    dwWin32ExitCode: u32,
    dwServiceSpecificExitCode: u32,
    dwCheckPoint: u32,
    dwWaitHint: u32,
    dwProcessId: u32,
    dwServiceFlags: SERVICE_RUNS_IN_PROCESS,
};

pub const ENUM_SERVICE_STATUSA = extern struct {
    lpServiceName: ?PSTR,
    lpDisplayName: ?PSTR,
    ServiceStatus: SERVICE_STATUS,
};

pub const ENUM_SERVICE_STATUSW = extern struct {
    lpServiceName: ?PWSTR,
    lpDisplayName: ?PWSTR,
    ServiceStatus: SERVICE_STATUS,
};

pub const ENUM_SERVICE_STATUS_PROCESSA = extern struct {
    lpServiceName: ?PSTR,
    lpDisplayName: ?PSTR,
    ServiceStatusProcess: SERVICE_STATUS_PROCESS,
};

pub const ENUM_SERVICE_STATUS_PROCESSW = extern struct {
    lpServiceName: ?PWSTR,
    lpDisplayName: ?PWSTR,
    ServiceStatusProcess: SERVICE_STATUS_PROCESS,
};

pub const QUERY_SERVICE_LOCK_STATUSA = extern struct {
    fIsLocked: u32,
    lpLockOwner: ?PSTR,
    dwLockDuration: u32,
};

pub const QUERY_SERVICE_LOCK_STATUSW = extern struct {
    fIsLocked: u32,
    lpLockOwner: ?PWSTR,
    dwLockDuration: u32,
};

pub const QUERY_SERVICE_CONFIGA = extern struct {
    dwServiceType: ENUM_SERVICE_TYPE,
    dwStartType: SERVICE_START_TYPE,
    dwErrorControl: SERVICE_ERROR,
    lpBinaryPathName: ?PSTR,
    lpLoadOrderGroup: ?PSTR,
    dwTagId: u32,
    lpDependencies: ?PSTR,
    lpServiceStartName: ?PSTR,
    lpDisplayName: ?PSTR,
};

pub const QUERY_SERVICE_CONFIGW = extern struct {
    dwServiceType: ENUM_SERVICE_TYPE,
    dwStartType: SERVICE_START_TYPE,
    dwErrorControl: SERVICE_ERROR,
    lpBinaryPathName: ?PWSTR,
    lpLoadOrderGroup: ?PWSTR,
    dwTagId: u32,
    lpDependencies: ?PWSTR,
    lpServiceStartName: ?PWSTR,
    lpDisplayName: ?PWSTR,
};

pub const SERVICE_MAIN_FUNCTIONW = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?PWSTR,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?PWSTR,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const SERVICE_MAIN_FUNCTIONA = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?*i8,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?*i8,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const LPSERVICE_MAIN_FUNCTIONW = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?PWSTR,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?PWSTR,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const LPSERVICE_MAIN_FUNCTIONA = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?PSTR,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwNumServicesArgs: u32,
        lpServiceArgVectors: ?*?PSTR,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const SERVICE_TABLE_ENTRYA = extern struct {
    lpServiceName: ?PSTR,
    lpServiceProc: ?LPSERVICE_MAIN_FUNCTIONA,
};

pub const SERVICE_TABLE_ENTRYW = extern struct {
    lpServiceName: ?PWSTR,
    lpServiceProc: ?LPSERVICE_MAIN_FUNCTIONW,
};

pub const HANDLER_FUNCTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwControl: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwControl: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const HANDLER_FUNCTION_EX = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwControl: u32,
        dwEventType: u32,
        lpEventData: ?*anyopaque,
        lpContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        dwControl: u32,
        dwEventType: u32,
        lpEventData: ?*anyopaque,
        lpContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const LPHANDLER_FUNCTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwControl: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwControl: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const LPHANDLER_FUNCTION_EX = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwControl: u32,
        dwEventType: u32,
        lpEventData: ?*anyopaque,
        lpContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        dwControl: u32,
        dwEventType: u32,
        lpEventData: ?*anyopaque,
        lpContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const PFN_SC_NOTIFY_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        pParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const SERVICE_NOTIFY_1 = extern struct {
    dwVersion: u32,
    pfnNotifyCallback: ?PFN_SC_NOTIFY_CALLBACK,
    pContext: ?*anyopaque,
    dwNotificationStatus: u32,
    ServiceStatus: SERVICE_STATUS_PROCESS,
};

pub const SERVICE_NOTIFY_2A = extern struct {
    dwVersion: u32,
    pfnNotifyCallback: ?PFN_SC_NOTIFY_CALLBACK,
    pContext: ?*anyopaque,
    dwNotificationStatus: u32,
    ServiceStatus: SERVICE_STATUS_PROCESS,
    dwNotificationTriggered: u32,
    pszServiceNames: ?PSTR,
};

pub const SERVICE_NOTIFY_2W = extern struct {
    dwVersion: u32,
    pfnNotifyCallback: ?PFN_SC_NOTIFY_CALLBACK,
    pContext: ?*anyopaque,
    dwNotificationStatus: u32,
    ServiceStatus: SERVICE_STATUS_PROCESS,
    dwNotificationTriggered: u32,
    pszServiceNames: ?PWSTR,
};

pub const SERVICE_CONTROL_STATUS_REASON_PARAMSA = extern struct {
    dwReason: u32,
    pszComment: ?PSTR,
    ServiceStatus: SERVICE_STATUS_PROCESS,
};

pub const SERVICE_CONTROL_STATUS_REASON_PARAMSW = extern struct {
    dwReason: u32,
    pszComment: ?PWSTR,
    ServiceStatus: SERVICE_STATUS_PROCESS,
};

pub const SERVICE_START_REASON = extern struct {
    dwReason: u32,
};

pub const SC_EVENT_TYPE = enum(i32) {
    DATABASE_CHANGE = 0,
    PROPERTY_CHANGE = 1,
    STATUS_CHANGE = 2,
};
pub const SC_EVENT_DATABASE_CHANGE = SC_EVENT_TYPE.DATABASE_CHANGE;
pub const SC_EVENT_PROPERTY_CHANGE = SC_EVENT_TYPE.PROPERTY_CHANGE;
pub const SC_EVENT_STATUS_CHANGE = SC_EVENT_TYPE.STATUS_CHANGE;

pub const PSC_NOTIFICATION_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwNotify: u32,
        pCallbackContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwNotify: u32,
        pCallbackContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const _SC_NOTIFICATION_REGISTRATION = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const SERVICE_REGISTRY_STATE_TYPE = enum(i32) {
    ServiceRegistryStateParameters = 0,
    ServiceRegistryStatePersistent = 1,
    MaxServiceRegistryStateType = 2,
};
pub const ServiceRegistryStateParameters = SERVICE_REGISTRY_STATE_TYPE.ServiceRegistryStateParameters;
pub const ServiceRegistryStatePersistent = SERVICE_REGISTRY_STATE_TYPE.ServiceRegistryStatePersistent;
pub const MaxServiceRegistryStateType = SERVICE_REGISTRY_STATE_TYPE.MaxServiceRegistryStateType;

pub const SERVICE_DIRECTORY_TYPE = enum(i32) {
    PersistentState = 0,
    TypeMax = 1,
};
pub const ServiceDirectoryPersistentState = SERVICE_DIRECTORY_TYPE.PersistentState;
pub const ServiceDirectoryTypeMax = SERVICE_DIRECTORY_TYPE.TypeMax;

pub const SERVICE_SHARED_REGISTRY_STATE_TYPE = enum(i32) {
    e = 0,
};
pub const ServiceSharedRegistryPersistentState = SERVICE_SHARED_REGISTRY_STATE_TYPE.e;

pub const SERVICE_SHARED_DIRECTORY_TYPE = enum(i32) {
    e = 0,
};
pub const ServiceSharedDirectoryPersistentState = SERVICE_SHARED_DIRECTORY_TYPE.e;

//--------------------------------------------------------------------------------
// Section: Functions (56)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetServiceBits(
    hServiceStatus: SERVICE_STATUS_HANDLE,
    dwServiceBits: u32,
    bSetBitsOn: BOOL,
    bUpdateImmediately: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ChangeServiceConfigA(
    hService: SC_HANDLE,
    dwServiceType: u32,
    dwStartType: SERVICE_START_TYPE,
    dwErrorControl: SERVICE_ERROR,
    lpBinaryPathName: ?[*:0]const u8,
    lpLoadOrderGroup: ?[*:0]const u8,
    lpdwTagId: ?*u32,
    lpDependencies: ?[*:0]const u8,
    lpServiceStartName: ?[*:0]const u8,
    lpPassword: ?[*:0]const u8,
    lpDisplayName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ChangeServiceConfigW(
    hService: SC_HANDLE,
    dwServiceType: u32,
    dwStartType: SERVICE_START_TYPE,
    dwErrorControl: SERVICE_ERROR,
    lpBinaryPathName: ?[*:0]const u16,
    lpLoadOrderGroup: ?[*:0]const u16,
    lpdwTagId: ?*u32,
    lpDependencies: ?[*:0]const u16,
    lpServiceStartName: ?[*:0]const u16,
    lpPassword: ?[*:0]const u16,
    lpDisplayName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ChangeServiceConfig2A(
    hService: SC_HANDLE,
    dwInfoLevel: SERVICE_CONFIG,
    lpInfo: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ChangeServiceConfig2W(
    hService: SC_HANDLE,
    dwInfoLevel: SERVICE_CONFIG,
    lpInfo: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CloseServiceHandle(
    hSCObject: SC_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ControlService(
    hService: SC_HANDLE,
    dwControl: u32,
    lpServiceStatus: ?*SERVICE_STATUS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateServiceA(
    hSCManager: SC_HANDLE,
    lpServiceName: ?[*:0]const u8,
    lpDisplayName: ?[*:0]const u8,
    dwDesiredAccess: u32,
    dwServiceType: ENUM_SERVICE_TYPE,
    dwStartType: SERVICE_START_TYPE,
    dwErrorControl: SERVICE_ERROR,
    lpBinaryPathName: ?[*:0]const u8,
    lpLoadOrderGroup: ?[*:0]const u8,
    lpdwTagId: ?*u32,
    lpDependencies: ?[*:0]const u8,
    lpServiceStartName: ?[*:0]const u8,
    lpPassword: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) SC_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateServiceW(
    hSCManager: SC_HANDLE,
    lpServiceName: ?[*:0]const u16,
    lpDisplayName: ?[*:0]const u16,
    dwDesiredAccess: u32,
    dwServiceType: ENUM_SERVICE_TYPE,
    dwStartType: SERVICE_START_TYPE,
    dwErrorControl: SERVICE_ERROR,
    lpBinaryPathName: ?[*:0]const u16,
    lpLoadOrderGroup: ?[*:0]const u16,
    lpdwTagId: ?*u32,
    lpDependencies: ?[*:0]const u16,
    lpServiceStartName: ?[*:0]const u16,
    lpPassword: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) SC_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn DeleteService(
    hService: SC_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EnumDependentServicesA(
    hService: SC_HANDLE,
    dwServiceState: ENUM_SERVICE_STATE,
    // TODO: what to do with BytesParamIndex 3?
    lpServices: ?*ENUM_SERVICE_STATUSA,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
    lpServicesReturned: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EnumDependentServicesW(
    hService: SC_HANDLE,
    dwServiceState: ENUM_SERVICE_STATE,
    // TODO: what to do with BytesParamIndex 3?
    lpServices: ?*ENUM_SERVICE_STATUSW,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
    lpServicesReturned: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EnumServicesStatusA(
    hSCManager: SC_HANDLE,
    dwServiceType: ENUM_SERVICE_TYPE,
    dwServiceState: ENUM_SERVICE_STATE,
    // TODO: what to do with BytesParamIndex 4?
    lpServices: ?*ENUM_SERVICE_STATUSA,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
    lpServicesReturned: ?*u32,
    lpResumeHandle: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EnumServicesStatusW(
    hSCManager: SC_HANDLE,
    dwServiceType: ENUM_SERVICE_TYPE,
    dwServiceState: ENUM_SERVICE_STATE,
    // TODO: what to do with BytesParamIndex 4?
    lpServices: ?*ENUM_SERVICE_STATUSW,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
    lpServicesReturned: ?*u32,
    lpResumeHandle: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EnumServicesStatusExA(
    hSCManager: SC_HANDLE,
    InfoLevel: SC_ENUM_TYPE,
    dwServiceType: ENUM_SERVICE_TYPE,
    dwServiceState: ENUM_SERVICE_STATE,
    // TODO: what to do with BytesParamIndex 5?
    lpServices: ?*u8,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
    lpServicesReturned: ?*u32,
    lpResumeHandle: ?*u32,
    pszGroupName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EnumServicesStatusExW(
    hSCManager: SC_HANDLE,
    InfoLevel: SC_ENUM_TYPE,
    dwServiceType: ENUM_SERVICE_TYPE,
    dwServiceState: ENUM_SERVICE_STATE,
    // TODO: what to do with BytesParamIndex 5?
    lpServices: ?*u8,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
    lpServicesReturned: ?*u32,
    lpResumeHandle: ?*u32,
    pszGroupName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetServiceKeyNameA(
    hSCManager: SC_HANDLE,
    lpDisplayName: ?[*:0]const u8,
    lpServiceName: ?[*:0]u8,
    lpcchBuffer: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetServiceKeyNameW(
    hSCManager: SC_HANDLE,
    lpDisplayName: ?[*:0]const u16,
    lpServiceName: ?[*:0]u16,
    lpcchBuffer: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetServiceDisplayNameA(
    hSCManager: SC_HANDLE,
    lpServiceName: ?[*:0]const u8,
    lpDisplayName: ?[*:0]u8,
    lpcchBuffer: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetServiceDisplayNameW(
    hSCManager: SC_HANDLE,
    lpServiceName: ?[*:0]const u16,
    lpDisplayName: ?[*:0]u16,
    lpcchBuffer: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LockServiceDatabase(
    hSCManager: SC_HANDLE,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn NotifyBootConfigStatus(
    BootAcceptable: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn OpenSCManagerA(
    lpMachineName: ?[*:0]const u8,
    lpDatabaseName: ?[*:0]const u8,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) SC_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn OpenSCManagerW(
    lpMachineName: ?[*:0]const u16,
    lpDatabaseName: ?[*:0]const u16,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) SC_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn OpenServiceA(
    hSCManager: SC_HANDLE,
    lpServiceName: ?[*:0]const u8,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) SC_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn OpenServiceW(
    hSCManager: SC_HANDLE,
    lpServiceName: ?[*:0]const u16,
    dwDesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) SC_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceConfigA(
    hService: SC_HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpServiceConfig: ?*QUERY_SERVICE_CONFIGA,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceConfigW(
    hService: SC_HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpServiceConfig: ?*QUERY_SERVICE_CONFIGW,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceConfig2A(
    hService: SC_HANDLE,
    dwInfoLevel: SERVICE_CONFIG,
    // TODO: what to do with BytesParamIndex 3?
    lpBuffer: ?*u8,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceConfig2W(
    hService: SC_HANDLE,
    dwInfoLevel: SERVICE_CONFIG,
    // TODO: what to do with BytesParamIndex 3?
    lpBuffer: ?*u8,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceLockStatusA(
    hSCManager: SC_HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpLockStatus: ?*QUERY_SERVICE_LOCK_STATUSA,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceLockStatusW(
    hSCManager: SC_HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpLockStatus: ?*QUERY_SERVICE_LOCK_STATUSW,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceObjectSecurity(
    hService: SC_HANDLE,
    dwSecurityInformation: u32,
    // TODO: what to do with BytesParamIndex 3?
    lpSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceStatus(
    hService: SC_HANDLE,
    lpServiceStatus: ?*SERVICE_STATUS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn QueryServiceStatusEx(
    hService: SC_HANDLE,
    InfoLevel: SC_STATUS_TYPE,
    // TODO: what to do with BytesParamIndex 3?
    lpBuffer: ?*u8,
    cbBufSize: u32,
    pcbBytesNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn RegisterServiceCtrlHandlerA(
    lpServiceName: ?[*:0]const u8,
    lpHandlerProc: ?LPHANDLER_FUNCTION,
) callconv(@import("std").os.windows.WINAPI) SERVICE_STATUS_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn RegisterServiceCtrlHandlerW(
    lpServiceName: ?[*:0]const u16,
    lpHandlerProc: ?LPHANDLER_FUNCTION,
) callconv(@import("std").os.windows.WINAPI) SERVICE_STATUS_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn RegisterServiceCtrlHandlerExA(
    lpServiceName: ?[*:0]const u8,
    lpHandlerProc: ?LPHANDLER_FUNCTION_EX,
    lpContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) SERVICE_STATUS_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn RegisterServiceCtrlHandlerExW(
    lpServiceName: ?[*:0]const u16,
    lpHandlerProc: ?LPHANDLER_FUNCTION_EX,
    lpContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) SERVICE_STATUS_HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetServiceObjectSecurity(
    hService: SC_HANDLE,
    dwSecurityInformation: OBJECT_SECURITY_INFORMATION,
    lpSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetServiceStatus(
    hServiceStatus: SERVICE_STATUS_HANDLE,
    lpServiceStatus: ?*SERVICE_STATUS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn StartServiceCtrlDispatcherA(
    lpServiceStartTable: ?*const SERVICE_TABLE_ENTRYA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn StartServiceCtrlDispatcherW(
    lpServiceStartTable: ?*const SERVICE_TABLE_ENTRYW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn StartServiceA(
    hService: SC_HANDLE,
    dwNumServiceArgs: u32,
    lpServiceArgVectors: ?[*]?PSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn StartServiceW(
    hService: SC_HANDLE,
    dwNumServiceArgs: u32,
    lpServiceArgVectors: ?[*]?PWSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn UnlockServiceDatabase(
    ScLock: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn NotifyServiceStatusChangeA(
    hService: SC_HANDLE,
    dwNotifyMask: SERVICE_NOTIFY,
    pNotifyBuffer: ?*SERVICE_NOTIFY_2A,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn NotifyServiceStatusChangeW(
    hService: SC_HANDLE,
    dwNotifyMask: SERVICE_NOTIFY,
    pNotifyBuffer: ?*SERVICE_NOTIFY_2W,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn ControlServiceExA(
    hService: SC_HANDLE,
    dwControl: u32,
    dwInfoLevel: u32,
    pControlParams: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn ControlServiceExW(
    hService: SC_HANDLE,
    dwControl: u32,
    dwInfoLevel: u32,
    pControlParams: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "advapi32" fn QueryServiceDynamicInformation(
    hServiceStatus: SERVICE_STATUS_HANDLE,
    dwInfoLevel: u32,
    ppDynamicInfo: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn WaitServiceState(
    hService: SC_HANDLE,
    dwNotify: u32,
    dwTimeout: u32,
    hCancelEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.19041'
pub extern "api-ms-win-service-core-l1-1-3" fn GetServiceRegistryStateKey(
    ServiceStatusHandle: SERVICE_STATUS_HANDLE,
    StateType: SERVICE_REGISTRY_STATE_TYPE,
    AccessMask: u32,
    ServiceStateKey: ?*?HKEY,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.19041'
pub extern "api-ms-win-service-core-l1-1-4" fn GetServiceDirectory(
    hServiceStatus: SERVICE_STATUS_HANDLE,
    eDirectoryType: SERVICE_DIRECTORY_TYPE,
    lpPathBuffer: ?[*]u16,
    cchPathBufferLength: u32,
    lpcchRequiredBufferLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "api-ms-win-service-core-l1-1-5" fn GetSharedServiceRegistryStateKey(
    ServiceHandle: SC_HANDLE,
    StateType: SERVICE_SHARED_REGISTRY_STATE_TYPE,
    AccessMask: u32,
    ServiceStateKey: ?*?HKEY,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "api-ms-win-service-core-l1-1-5" fn GetSharedServiceDirectory(
    ServiceHandle: SC_HANDLE,
    DirectoryType: SERVICE_SHARED_DIRECTORY_TYPE,
    PathBuffer: ?[*]u16,
    PathBufferLength: u32,
    RequiredBufferLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (31)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const SERVICE_DESCRIPTION = thismodule.SERVICE_DESCRIPTIONA;
        pub const SERVICE_FAILURE_ACTIONS = thismodule.SERVICE_FAILURE_ACTIONSA;
        pub const SERVICE_REQUIRED_PRIVILEGES_INFO = thismodule.SERVICE_REQUIRED_PRIVILEGES_INFOA;
        pub const ENUM_SERVICE_STATUS = thismodule.ENUM_SERVICE_STATUSA;
        pub const ENUM_SERVICE_STATUS_PROCESS = thismodule.ENUM_SERVICE_STATUS_PROCESSA;
        pub const QUERY_SERVICE_LOCK_STATUS = thismodule.QUERY_SERVICE_LOCK_STATUSA;
        pub const QUERY_SERVICE_CONFIG = thismodule.QUERY_SERVICE_CONFIGA;
        pub const SERVICE_MAIN_FUNCTION = thismodule.SERVICE_MAIN_FUNCTIONA;
        pub const LPSERVICE_MAIN_FUNCTION = thismodule.LPSERVICE_MAIN_FUNCTIONA;
        pub const SERVICE_TABLE_ENTRY = thismodule.SERVICE_TABLE_ENTRYA;
        pub const SERVICE_NOTIFY_2 = thismodule.SERVICE_NOTIFY_2A;
        pub const SERVICE_CONTROL_STATUS_REASON_PARAMS = thismodule.SERVICE_CONTROL_STATUS_REASON_PARAMSA;
        pub const ChangeServiceConfig = thismodule.ChangeServiceConfigA;
        pub const ChangeServiceConfig2 = thismodule.ChangeServiceConfig2A;
        pub const CreateService = thismodule.CreateServiceA;
        pub const EnumDependentServices = thismodule.EnumDependentServicesA;
        pub const EnumServicesStatus = thismodule.EnumServicesStatusA;
        pub const EnumServicesStatusEx = thismodule.EnumServicesStatusExA;
        pub const GetServiceKeyName = thismodule.GetServiceKeyNameA;
        pub const GetServiceDisplayName = thismodule.GetServiceDisplayNameA;
        pub const OpenSCManager = thismodule.OpenSCManagerA;
        pub const OpenService = thismodule.OpenServiceA;
        pub const QueryServiceConfig = thismodule.QueryServiceConfigA;
        pub const QueryServiceConfig2 = thismodule.QueryServiceConfig2A;
        pub const QueryServiceLockStatus = thismodule.QueryServiceLockStatusA;
        pub const RegisterServiceCtrlHandler = thismodule.RegisterServiceCtrlHandlerA;
        pub const RegisterServiceCtrlHandlerEx = thismodule.RegisterServiceCtrlHandlerExA;
        pub const StartServiceCtrlDispatcher = thismodule.StartServiceCtrlDispatcherA;
        pub const StartService = thismodule.StartServiceA;
        pub const NotifyServiceStatusChange = thismodule.NotifyServiceStatusChangeA;
        pub const ControlServiceEx = thismodule.ControlServiceExA;
    },
    .wide => struct {
        pub const SERVICE_DESCRIPTION = thismodule.SERVICE_DESCRIPTIONW;
        pub const SERVICE_FAILURE_ACTIONS = thismodule.SERVICE_FAILURE_ACTIONSW;
        pub const SERVICE_REQUIRED_PRIVILEGES_INFO = thismodule.SERVICE_REQUIRED_PRIVILEGES_INFOW;
        pub const ENUM_SERVICE_STATUS = thismodule.ENUM_SERVICE_STATUSW;
        pub const ENUM_SERVICE_STATUS_PROCESS = thismodule.ENUM_SERVICE_STATUS_PROCESSW;
        pub const QUERY_SERVICE_LOCK_STATUS = thismodule.QUERY_SERVICE_LOCK_STATUSW;
        pub const QUERY_SERVICE_CONFIG = thismodule.QUERY_SERVICE_CONFIGW;
        pub const SERVICE_MAIN_FUNCTION = thismodule.SERVICE_MAIN_FUNCTIONW;
        pub const LPSERVICE_MAIN_FUNCTION = thismodule.LPSERVICE_MAIN_FUNCTIONW;
        pub const SERVICE_TABLE_ENTRY = thismodule.SERVICE_TABLE_ENTRYW;
        pub const SERVICE_NOTIFY_2 = thismodule.SERVICE_NOTIFY_2W;
        pub const SERVICE_CONTROL_STATUS_REASON_PARAMS = thismodule.SERVICE_CONTROL_STATUS_REASON_PARAMSW;
        pub const ChangeServiceConfig = thismodule.ChangeServiceConfigW;
        pub const ChangeServiceConfig2 = thismodule.ChangeServiceConfig2W;
        pub const CreateService = thismodule.CreateServiceW;
        pub const EnumDependentServices = thismodule.EnumDependentServicesW;
        pub const EnumServicesStatus = thismodule.EnumServicesStatusW;
        pub const EnumServicesStatusEx = thismodule.EnumServicesStatusExW;
        pub const GetServiceKeyName = thismodule.GetServiceKeyNameW;
        pub const GetServiceDisplayName = thismodule.GetServiceDisplayNameW;
        pub const OpenSCManager = thismodule.OpenSCManagerW;
        pub const OpenService = thismodule.OpenServiceW;
        pub const QueryServiceConfig = thismodule.QueryServiceConfigW;
        pub const QueryServiceConfig2 = thismodule.QueryServiceConfig2W;
        pub const QueryServiceLockStatus = thismodule.QueryServiceLockStatusW;
        pub const RegisterServiceCtrlHandler = thismodule.RegisterServiceCtrlHandlerW;
        pub const RegisterServiceCtrlHandlerEx = thismodule.RegisterServiceCtrlHandlerExW;
        pub const StartServiceCtrlDispatcher = thismodule.StartServiceCtrlDispatcherW;
        pub const StartService = thismodule.StartServiceW;
        pub const NotifyServiceStatusChange = thismodule.NotifyServiceStatusChangeW;
        pub const ControlServiceEx = thismodule.ControlServiceExW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const SERVICE_DESCRIPTION = *opaque {};
        pub const SERVICE_FAILURE_ACTIONS = *opaque {};
        pub const SERVICE_REQUIRED_PRIVILEGES_INFO = *opaque {};
        pub const ENUM_SERVICE_STATUS = *opaque {};
        pub const ENUM_SERVICE_STATUS_PROCESS = *opaque {};
        pub const QUERY_SERVICE_LOCK_STATUS = *opaque {};
        pub const QUERY_SERVICE_CONFIG = *opaque {};
        pub const SERVICE_MAIN_FUNCTION = *opaque {};
        pub const LPSERVICE_MAIN_FUNCTION = *opaque {};
        pub const SERVICE_TABLE_ENTRY = *opaque {};
        pub const SERVICE_NOTIFY_2 = *opaque {};
        pub const SERVICE_CONTROL_STATUS_REASON_PARAMS = *opaque {};
        pub const ChangeServiceConfig = *opaque {};
        pub const ChangeServiceConfig2 = *opaque {};
        pub const CreateService = *opaque {};
        pub const EnumDependentServices = *opaque {};
        pub const EnumServicesStatus = *opaque {};
        pub const EnumServicesStatusEx = *opaque {};
        pub const GetServiceKeyName = *opaque {};
        pub const GetServiceDisplayName = *opaque {};
        pub const OpenSCManager = *opaque {};
        pub const OpenService = *opaque {};
        pub const QueryServiceConfig = *opaque {};
        pub const QueryServiceConfig2 = *opaque {};
        pub const QueryServiceLockStatus = *opaque {};
        pub const RegisterServiceCtrlHandler = *opaque {};
        pub const RegisterServiceCtrlHandlerEx = *opaque {};
        pub const StartServiceCtrlDispatcher = *opaque {};
        pub const StartService = *opaque {};
        pub const NotifyServiceStatusChange = *opaque {};
        pub const ControlServiceEx = *opaque {};
    } else struct {
        pub const SERVICE_DESCRIPTION = @compileError("'SERVICE_DESCRIPTION' requires that UNICODE be set to true or false in the root module");
        pub const SERVICE_FAILURE_ACTIONS = @compileError("'SERVICE_FAILURE_ACTIONS' requires that UNICODE be set to true or false in the root module");
        pub const SERVICE_REQUIRED_PRIVILEGES_INFO = @compileError("'SERVICE_REQUIRED_PRIVILEGES_INFO' requires that UNICODE be set to true or false in the root module");
        pub const ENUM_SERVICE_STATUS = @compileError("'ENUM_SERVICE_STATUS' requires that UNICODE be set to true or false in the root module");
        pub const ENUM_SERVICE_STATUS_PROCESS = @compileError("'ENUM_SERVICE_STATUS_PROCESS' requires that UNICODE be set to true or false in the root module");
        pub const QUERY_SERVICE_LOCK_STATUS = @compileError("'QUERY_SERVICE_LOCK_STATUS' requires that UNICODE be set to true or false in the root module");
        pub const QUERY_SERVICE_CONFIG = @compileError("'QUERY_SERVICE_CONFIG' requires that UNICODE be set to true or false in the root module");
        pub const SERVICE_MAIN_FUNCTION = @compileError("'SERVICE_MAIN_FUNCTION' requires that UNICODE be set to true or false in the root module");
        pub const LPSERVICE_MAIN_FUNCTION = @compileError("'LPSERVICE_MAIN_FUNCTION' requires that UNICODE be set to true or false in the root module");
        pub const SERVICE_TABLE_ENTRY = @compileError("'SERVICE_TABLE_ENTRY' requires that UNICODE be set to true or false in the root module");
        pub const SERVICE_NOTIFY_2 = @compileError("'SERVICE_NOTIFY_2' requires that UNICODE be set to true or false in the root module");
        pub const SERVICE_CONTROL_STATUS_REASON_PARAMS = @compileError("'SERVICE_CONTROL_STATUS_REASON_PARAMS' requires that UNICODE be set to true or false in the root module");
        pub const ChangeServiceConfig = @compileError("'ChangeServiceConfig' requires that UNICODE be set to true or false in the root module");
        pub const ChangeServiceConfig2 = @compileError("'ChangeServiceConfig2' requires that UNICODE be set to true or false in the root module");
        pub const CreateService = @compileError("'CreateService' requires that UNICODE be set to true or false in the root module");
        pub const EnumDependentServices = @compileError("'EnumDependentServices' requires that UNICODE be set to true or false in the root module");
        pub const EnumServicesStatus = @compileError("'EnumServicesStatus' requires that UNICODE be set to true or false in the root module");
        pub const EnumServicesStatusEx = @compileError("'EnumServicesStatusEx' requires that UNICODE be set to true or false in the root module");
        pub const GetServiceKeyName = @compileError("'GetServiceKeyName' requires that UNICODE be set to true or false in the root module");
        pub const GetServiceDisplayName = @compileError("'GetServiceDisplayName' requires that UNICODE be set to true or false in the root module");
        pub const OpenSCManager = @compileError("'OpenSCManager' requires that UNICODE be set to true or false in the root module");
        pub const OpenService = @compileError("'OpenService' requires that UNICODE be set to true or false in the root module");
        pub const QueryServiceConfig = @compileError("'QueryServiceConfig' requires that UNICODE be set to true or false in the root module");
        pub const QueryServiceConfig2 = @compileError("'QueryServiceConfig2' requires that UNICODE be set to true or false in the root module");
        pub const QueryServiceLockStatus = @compileError("'QueryServiceLockStatus' requires that UNICODE be set to true or false in the root module");
        pub const RegisterServiceCtrlHandler = @compileError("'RegisterServiceCtrlHandler' requires that UNICODE be set to true or false in the root module");
        pub const RegisterServiceCtrlHandlerEx = @compileError("'RegisterServiceCtrlHandlerEx' requires that UNICODE be set to true or false in the root module");
        pub const StartServiceCtrlDispatcher = @compileError("'StartServiceCtrlDispatcher' requires that UNICODE be set to true or false in the root module");
        pub const StartService = @compileError("'StartService' requires that UNICODE be set to true or false in the root module");
        pub const NotifyServiceStatusChange = @compileError("'NotifyServiceStatusChange' requires that UNICODE be set to true or false in the root module");
        pub const ControlServiceEx = @compileError("'ControlServiceEx' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (11)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const HANDLE = @import("../foundation.zig").HANDLE;
const HKEY = @import("../system/registry.zig").HKEY;
const LARGE_INTEGER = @import("../foundation.zig").LARGE_INTEGER;
const OBJECT_SECURITY_INFORMATION = @import("../security.zig").OBJECT_SECURITY_INFORMATION;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const SC_HANDLE = @import("../security.zig").SC_HANDLE;
const SECURITY_DESCRIPTOR = @import("../security.zig").SECURITY_DESCRIPTOR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "SERVICE_MAIN_FUNCTIONW")) {
        _ = SERVICE_MAIN_FUNCTIONW;
    }
    if (@hasDecl(@This(), "SERVICE_MAIN_FUNCTIONA")) {
        _ = SERVICE_MAIN_FUNCTIONA;
    }
    if (@hasDecl(@This(), "LPSERVICE_MAIN_FUNCTIONW")) {
        _ = LPSERVICE_MAIN_FUNCTIONW;
    }
    if (@hasDecl(@This(), "LPSERVICE_MAIN_FUNCTIONA")) {
        _ = LPSERVICE_MAIN_FUNCTIONA;
    }
    if (@hasDecl(@This(), "HANDLER_FUNCTION")) {
        _ = HANDLER_FUNCTION;
    }
    if (@hasDecl(@This(), "HANDLER_FUNCTION_EX")) {
        _ = HANDLER_FUNCTION_EX;
    }
    if (@hasDecl(@This(), "LPHANDLER_FUNCTION")) {
        _ = LPHANDLER_FUNCTION;
    }
    if (@hasDecl(@This(), "LPHANDLER_FUNCTION_EX")) {
        _ = LPHANDLER_FUNCTION_EX;
    }
    if (@hasDecl(@This(), "PFN_SC_NOTIFY_CALLBACK")) {
        _ = PFN_SC_NOTIFY_CALLBACK;
    }
    if (@hasDecl(@This(), "PSC_NOTIFICATION_CALLBACK")) {
        _ = PSC_NOTIFICATION_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
