//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (4)
//--------------------------------------------------------------------------------
pub const PIPE_UNLIMITED_INSTANCES = @as(u32, 255);
pub const NMPWAIT_WAIT_FOREVER = @as(u32, 4294967295);
pub const NMPWAIT_NOWAIT = @as(u32, 1);
pub const NMPWAIT_USE_DEFAULT_WAIT = @as(u32, 0);

//--------------------------------------------------------------------------------
// Section: Types (1)
//--------------------------------------------------------------------------------
pub const NAMED_PIPE_MODE = enum(u32) {
    WAIT = 0,
    NOWAIT = 1,
    // READMODE_BYTE = 0, this enum value conflicts with WAIT
    READMODE_MESSAGE = 2,
    // CLIENT_END = 0, this enum value conflicts with WAIT
    // SERVER_END = 1, this enum value conflicts with NOWAIT
    // TYPE_BYTE = 0, this enum value conflicts with WAIT
    TYPE_MESSAGE = 4,
    // ACCEPT_REMOTE_CLIENTS = 0, this enum value conflicts with WAIT
    REJECT_REMOTE_CLIENTS = 8,
    _,
    pub fn initFlags(o: struct {
        WAIT: u1 = 0,
        NOWAIT: u1 = 0,
        READMODE_MESSAGE: u1 = 0,
        TYPE_MESSAGE: u1 = 0,
        REJECT_REMOTE_CLIENTS: u1 = 0,
    }) NAMED_PIPE_MODE {
        return @as(NAMED_PIPE_MODE, @enumFromInt((if (o.WAIT == 1) @intFromEnum(NAMED_PIPE_MODE.WAIT) else 0) | (if (o.NOWAIT == 1) @intFromEnum(NAMED_PIPE_MODE.NOWAIT) else 0) | (if (o.READMODE_MESSAGE == 1) @intFromEnum(NAMED_PIPE_MODE.READMODE_MESSAGE) else 0) | (if (o.TYPE_MESSAGE == 1) @intFromEnum(NAMED_PIPE_MODE.TYPE_MESSAGE) else 0) | (if (o.REJECT_REMOTE_CLIENTS == 1) @intFromEnum(NAMED_PIPE_MODE.REJECT_REMOTE_CLIENTS) else 0)));
    }
};
pub const PIPE_WAIT = NAMED_PIPE_MODE.WAIT;
pub const PIPE_NOWAIT = NAMED_PIPE_MODE.NOWAIT;
pub const PIPE_READMODE_BYTE = NAMED_PIPE_MODE.WAIT;
pub const PIPE_READMODE_MESSAGE = NAMED_PIPE_MODE.READMODE_MESSAGE;
pub const PIPE_CLIENT_END = NAMED_PIPE_MODE.WAIT;
pub const PIPE_SERVER_END = NAMED_PIPE_MODE.NOWAIT;
pub const PIPE_TYPE_BYTE = NAMED_PIPE_MODE.WAIT;
pub const PIPE_TYPE_MESSAGE = NAMED_PIPE_MODE.TYPE_MESSAGE;
pub const PIPE_ACCEPT_REMOTE_CLIENTS = NAMED_PIPE_MODE.WAIT;
pub const PIPE_REJECT_REMOTE_CLIENTS = NAMED_PIPE_MODE.REJECT_REMOTE_CLIENTS;

//--------------------------------------------------------------------------------
// Section: Functions (22)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn CreatePipe(
    hReadPipe: ?*?HANDLE,
    hWritePipe: ?*?HANDLE,
    lpPipeAttributes: ?*SECURITY_ATTRIBUTES,
    nSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn ConnectNamedPipe(
    hNamedPipe: ?HANDLE,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn DisconnectNamedPipe(
    hNamedPipe: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn SetNamedPipeHandleState(
    hNamedPipe: ?HANDLE,
    lpMode: ?*NAMED_PIPE_MODE,
    lpMaxCollectionCount: ?*u32,
    lpCollectDataTimeout: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn PeekNamedPipe(
    hNamedPipe: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpBuffer: ?*anyopaque,
    nBufferSize: u32,
    lpBytesRead: ?*u32,
    lpTotalBytesAvail: ?*u32,
    lpBytesLeftThisMessage: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn TransactNamedPipe(
    hNamedPipe: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpInBuffer: ?*anyopaque,
    nInBufferSize: u32,
    // TODO: what to do with BytesParamIndex 4?
    lpOutBuffer: ?*anyopaque,
    nOutBufferSize: u32,
    lpBytesRead: ?*u32,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn CreateNamedPipeW(
    lpName: ?[*:0]const u16,
    dwOpenMode: FILE_FLAGS_AND_ATTRIBUTES,
    dwPipeMode: NAMED_PIPE_MODE,
    nMaxInstances: u32,
    nOutBufferSize: u32,
    nInBufferSize: u32,
    nDefaultTimeOut: u32,
    lpSecurityAttributes: ?*SECURITY_ATTRIBUTES,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

pub extern "kernel32" fn WaitNamedPipeW(
    lpNamedPipeName: ?[*:0]const u16,
    nTimeOut: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetNamedPipeClientComputerNameW(
    Pipe: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    ClientComputerName: ?PWSTR,
    ClientComputerNameLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ImpersonateNamedPipeClient(
    hNamedPipe: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn GetNamedPipeInfo(
    hNamedPipe: ?HANDLE,
    lpFlags: ?*NAMED_PIPE_MODE,
    lpOutBufferSize: ?*u32,
    lpInBufferSize: ?*u32,
    lpMaxInstances: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetNamedPipeHandleStateW(
    hNamedPipe: ?HANDLE,
    lpState: ?*NAMED_PIPE_MODE,
    lpCurInstances: ?*u32,
    lpMaxCollectionCount: ?*u32,
    lpCollectDataTimeout: ?*u32,
    lpUserName: ?[*:0]u16,
    nMaxUserNameSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn CallNamedPipeW(
    lpNamedPipeName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 2?
    lpInBuffer: ?*anyopaque,
    nInBufferSize: u32,
    // TODO: what to do with BytesParamIndex 4?
    lpOutBuffer: ?*anyopaque,
    nOutBufferSize: u32,
    lpBytesRead: ?*u32,
    nTimeOut: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn CreateNamedPipeA(
    lpName: ?[*:0]const u8,
    dwOpenMode: FILE_FLAGS_AND_ATTRIBUTES,
    dwPipeMode: NAMED_PIPE_MODE,
    nMaxInstances: u32,
    nOutBufferSize: u32,
    nInBufferSize: u32,
    nDefaultTimeOut: u32,
    lpSecurityAttributes: ?*SECURITY_ATTRIBUTES,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn GetNamedPipeHandleStateA(
    hNamedPipe: ?HANDLE,
    lpState: ?*NAMED_PIPE_MODE,
    lpCurInstances: ?*u32,
    lpMaxCollectionCount: ?*u32,
    lpCollectDataTimeout: ?*u32,
    lpUserName: ?[*:0]u8,
    nMaxUserNameSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn CallNamedPipeA(
    lpNamedPipeName: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 2?
    lpInBuffer: ?*anyopaque,
    nInBufferSize: u32,
    // TODO: what to do with BytesParamIndex 4?
    lpOutBuffer: ?*anyopaque,
    nOutBufferSize: u32,
    lpBytesRead: ?*u32,
    nTimeOut: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.0'
pub extern "kernel32" fn WaitNamedPipeA(
    lpNamedPipeName: ?[*:0]const u8,
    nTimeOut: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNamedPipeClientComputerNameA(
    Pipe: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    ClientComputerName: ?PSTR,
    ClientComputerNameLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNamedPipeClientProcessId(
    Pipe: ?HANDLE,
    ClientProcessId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNamedPipeClientSessionId(
    Pipe: ?HANDLE,
    ClientSessionId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNamedPipeServerProcessId(
    Pipe: ?HANDLE,
    ServerProcessId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetNamedPipeServerSessionId(
    Pipe: ?HANDLE,
    ServerSessionId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (5)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const CreateNamedPipe = thismodule.CreateNamedPipeA;
        pub const WaitNamedPipe = thismodule.WaitNamedPipeA;
        pub const GetNamedPipeClientComputerName = thismodule.GetNamedPipeClientComputerNameA;
        pub const GetNamedPipeHandleState = thismodule.GetNamedPipeHandleStateA;
        pub const CallNamedPipe = thismodule.CallNamedPipeA;
    },
    .wide => struct {
        pub const CreateNamedPipe = thismodule.CreateNamedPipeW;
        pub const WaitNamedPipe = thismodule.WaitNamedPipeW;
        pub const GetNamedPipeClientComputerName = thismodule.GetNamedPipeClientComputerNameW;
        pub const GetNamedPipeHandleState = thismodule.GetNamedPipeHandleStateW;
        pub const CallNamedPipe = thismodule.CallNamedPipeW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const CreateNamedPipe = *opaque {};
        pub const WaitNamedPipe = *opaque {};
        pub const GetNamedPipeClientComputerName = *opaque {};
        pub const GetNamedPipeHandleState = *opaque {};
        pub const CallNamedPipe = *opaque {};
    } else struct {
        pub const CreateNamedPipe = @compileError("'CreateNamedPipe' requires that UNICODE be set to true or false in the root module");
        pub const WaitNamedPipe = @compileError("'WaitNamedPipe' requires that UNICODE be set to true or false in the root module");
        pub const GetNamedPipeClientComputerName = @compileError("'GetNamedPipeClientComputerName' requires that UNICODE be set to true or false in the root module");
        pub const GetNamedPipeHandleState = @compileError("'GetNamedPipeHandleState' requires that UNICODE be set to true or false in the root module");
        pub const CallNamedPipe = @compileError("'CallNamedPipe' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const BOOL = @import("../foundation.zig").BOOL;
const FILE_FLAGS_AND_ATTRIBUTES = @import("../storage/file_system.zig").FILE_FLAGS_AND_ATTRIBUTES;
const HANDLE = @import("../foundation.zig").HANDLE;
const OVERLAPPED = @import("../system/io.zig").OVERLAPPED;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const SECURITY_ATTRIBUTES = @import("../security.zig").SECURITY_ATTRIBUTES;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
