//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (5)
//--------------------------------------------------------------------------------
pub const FILE_CACHE_MAX_HARD_ENABLE = @as(u32, 1);
pub const FILE_CACHE_MAX_HARD_DISABLE = @as(u32, 2);
pub const FILE_CACHE_MIN_HARD_ENABLE = @as(u32, 4);
pub const FILE_CACHE_MIN_HARD_DISABLE = @as(u32, 8);
pub const MEHC_PATROL_SCRUBBER_PRESENT = @as(u32, 1);

//--------------------------------------------------------------------------------
// Section: Types (29)
//--------------------------------------------------------------------------------
pub const FILE_MAP = enum(u32) {
    WRITE = 2,
    READ = 4,
    ALL_ACCESS = 983071,
    EXECUTE = 32,
    COPY = 1,
    RESERVE = 2147483648,
    TARGETS_INVALID = 1073741824,
    LARGE_PAGES = 536870912,
    _,
    pub fn initFlags(o: struct {
        WRITE: u1 = 0,
        READ: u1 = 0,
        ALL_ACCESS: u1 = 0,
        EXECUTE: u1 = 0,
        COPY: u1 = 0,
        RESERVE: u1 = 0,
        TARGETS_INVALID: u1 = 0,
        LARGE_PAGES: u1 = 0,
    }) FILE_MAP {
        return @as(FILE_MAP, @enumFromInt((if (o.WRITE == 1) @intFromEnum(FILE_MAP.WRITE) else 0) | (if (o.READ == 1) @intFromEnum(FILE_MAP.READ) else 0) | (if (o.ALL_ACCESS == 1) @intFromEnum(FILE_MAP.ALL_ACCESS) else 0) | (if (o.EXECUTE == 1) @intFromEnum(FILE_MAP.EXECUTE) else 0) | (if (o.COPY == 1) @intFromEnum(FILE_MAP.COPY) else 0) | (if (o.RESERVE == 1) @intFromEnum(FILE_MAP.RESERVE) else 0) | (if (o.TARGETS_INVALID == 1) @intFromEnum(FILE_MAP.TARGETS_INVALID) else 0) | (if (o.LARGE_PAGES == 1) @intFromEnum(FILE_MAP.LARGE_PAGES) else 0)));
    }
};
pub const FILE_MAP_WRITE = FILE_MAP.WRITE;
pub const FILE_MAP_READ = FILE_MAP.READ;
pub const FILE_MAP_ALL_ACCESS = FILE_MAP.ALL_ACCESS;
pub const FILE_MAP_EXECUTE = FILE_MAP.EXECUTE;
pub const FILE_MAP_COPY = FILE_MAP.COPY;
pub const FILE_MAP_RESERVE = FILE_MAP.RESERVE;
pub const FILE_MAP_TARGETS_INVALID = FILE_MAP.TARGETS_INVALID;
pub const FILE_MAP_LARGE_PAGES = FILE_MAP.LARGE_PAGES;

pub const HEAP_FLAGS = enum(u32) {
    NONE = 0,
    NO_SERIALIZE = 1,
    GROWABLE = 2,
    GENERATE_EXCEPTIONS = 4,
    ZERO_MEMORY = 8,
    REALLOC_IN_PLACE_ONLY = 16,
    TAIL_CHECKING_ENABLED = 32,
    FREE_CHECKING_ENABLED = 64,
    DISABLE_COALESCE_ON_FREE = 128,
    CREATE_ALIGN_16 = 65536,
    CREATE_ENABLE_TRACING = 131072,
    CREATE_ENABLE_EXECUTE = 262144,
    MAXIMUM_TAG = 4095,
    PSEUDO_TAG_FLAG = 32768,
    TAG_SHIFT = 18,
    CREATE_SEGMENT_HEAP = 256,
    CREATE_HARDENED = 512,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        NO_SERIALIZE: u1 = 0,
        GROWABLE: u1 = 0,
        GENERATE_EXCEPTIONS: u1 = 0,
        ZERO_MEMORY: u1 = 0,
        REALLOC_IN_PLACE_ONLY: u1 = 0,
        TAIL_CHECKING_ENABLED: u1 = 0,
        FREE_CHECKING_ENABLED: u1 = 0,
        DISABLE_COALESCE_ON_FREE: u1 = 0,
        CREATE_ALIGN_16: u1 = 0,
        CREATE_ENABLE_TRACING: u1 = 0,
        CREATE_ENABLE_EXECUTE: u1 = 0,
        MAXIMUM_TAG: u1 = 0,
        PSEUDO_TAG_FLAG: u1 = 0,
        TAG_SHIFT: u1 = 0,
        CREATE_SEGMENT_HEAP: u1 = 0,
        CREATE_HARDENED: u1 = 0,
    }) HEAP_FLAGS {
        return @as(HEAP_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(HEAP_FLAGS.NONE) else 0) | (if (o.NO_SERIALIZE == 1) @intFromEnum(HEAP_FLAGS.NO_SERIALIZE) else 0) | (if (o.GROWABLE == 1) @intFromEnum(HEAP_FLAGS.GROWABLE) else 0) | (if (o.GENERATE_EXCEPTIONS == 1) @intFromEnum(HEAP_FLAGS.GENERATE_EXCEPTIONS) else 0) | (if (o.ZERO_MEMORY == 1) @intFromEnum(HEAP_FLAGS.ZERO_MEMORY) else 0) | (if (o.REALLOC_IN_PLACE_ONLY == 1) @intFromEnum(HEAP_FLAGS.REALLOC_IN_PLACE_ONLY) else 0) | (if (o.TAIL_CHECKING_ENABLED == 1) @intFromEnum(HEAP_FLAGS.TAIL_CHECKING_ENABLED) else 0) | (if (o.FREE_CHECKING_ENABLED == 1) @intFromEnum(HEAP_FLAGS.FREE_CHECKING_ENABLED) else 0) | (if (o.DISABLE_COALESCE_ON_FREE == 1) @intFromEnum(HEAP_FLAGS.DISABLE_COALESCE_ON_FREE) else 0) | (if (o.CREATE_ALIGN_16 == 1) @intFromEnum(HEAP_FLAGS.CREATE_ALIGN_16) else 0) | (if (o.CREATE_ENABLE_TRACING == 1) @intFromEnum(HEAP_FLAGS.CREATE_ENABLE_TRACING) else 0) | (if (o.CREATE_ENABLE_EXECUTE == 1) @intFromEnum(HEAP_FLAGS.CREATE_ENABLE_EXECUTE) else 0) | (if (o.MAXIMUM_TAG == 1) @intFromEnum(HEAP_FLAGS.MAXIMUM_TAG) else 0) | (if (o.PSEUDO_TAG_FLAG == 1) @intFromEnum(HEAP_FLAGS.PSEUDO_TAG_FLAG) else 0) | (if (o.TAG_SHIFT == 1) @intFromEnum(HEAP_FLAGS.TAG_SHIFT) else 0) | (if (o.CREATE_SEGMENT_HEAP == 1) @intFromEnum(HEAP_FLAGS.CREATE_SEGMENT_HEAP) else 0) | (if (o.CREATE_HARDENED == 1) @intFromEnum(HEAP_FLAGS.CREATE_HARDENED) else 0)));
    }
};
pub const HEAP_NONE = HEAP_FLAGS.NONE;
pub const HEAP_NO_SERIALIZE = HEAP_FLAGS.NO_SERIALIZE;
pub const HEAP_GROWABLE = HEAP_FLAGS.GROWABLE;
pub const HEAP_GENERATE_EXCEPTIONS = HEAP_FLAGS.GENERATE_EXCEPTIONS;
pub const HEAP_ZERO_MEMORY = HEAP_FLAGS.ZERO_MEMORY;
pub const HEAP_REALLOC_IN_PLACE_ONLY = HEAP_FLAGS.REALLOC_IN_PLACE_ONLY;
pub const HEAP_TAIL_CHECKING_ENABLED = HEAP_FLAGS.TAIL_CHECKING_ENABLED;
pub const HEAP_FREE_CHECKING_ENABLED = HEAP_FLAGS.FREE_CHECKING_ENABLED;
pub const HEAP_DISABLE_COALESCE_ON_FREE = HEAP_FLAGS.DISABLE_COALESCE_ON_FREE;
pub const HEAP_CREATE_ALIGN_16 = HEAP_FLAGS.CREATE_ALIGN_16;
pub const HEAP_CREATE_ENABLE_TRACING = HEAP_FLAGS.CREATE_ENABLE_TRACING;
pub const HEAP_CREATE_ENABLE_EXECUTE = HEAP_FLAGS.CREATE_ENABLE_EXECUTE;
pub const HEAP_MAXIMUM_TAG = HEAP_FLAGS.MAXIMUM_TAG;
pub const HEAP_PSEUDO_TAG_FLAG = HEAP_FLAGS.PSEUDO_TAG_FLAG;
pub const HEAP_TAG_SHIFT = HEAP_FLAGS.TAG_SHIFT;
pub const HEAP_CREATE_SEGMENT_HEAP = HEAP_FLAGS.CREATE_SEGMENT_HEAP;
pub const HEAP_CREATE_HARDENED = HEAP_FLAGS.CREATE_HARDENED;

pub const PAGE_PROTECTION_FLAGS = enum(u32) {
    PAGE_NOACCESS = 1,
    PAGE_READONLY = 2,
    PAGE_READWRITE = 4,
    PAGE_WRITECOPY = 8,
    PAGE_EXECUTE = 16,
    PAGE_EXECUTE_READ = 32,
    PAGE_EXECUTE_READWRITE = 64,
    PAGE_EXECUTE_WRITECOPY = 128,
    PAGE_GUARD = 256,
    PAGE_NOCACHE = 512,
    PAGE_WRITECOMBINE = 1024,
    PAGE_GRAPHICS_NOACCESS = 2048,
    PAGE_GRAPHICS_READONLY = 4096,
    PAGE_GRAPHICS_READWRITE = 8192,
    PAGE_GRAPHICS_EXECUTE = 16384,
    PAGE_GRAPHICS_EXECUTE_READ = 32768,
    PAGE_GRAPHICS_EXECUTE_READWRITE = 65536,
    PAGE_GRAPHICS_COHERENT = 131072,
    PAGE_GRAPHICS_NOCACHE = 262144,
    PAGE_ENCLAVE_THREAD_CONTROL = 2147483648,
    // PAGE_REVERT_TO_FILE_MAP = 2147483648, this enum value conflicts with PAGE_ENCLAVE_THREAD_CONTROL
    PAGE_TARGETS_NO_UPDATE = 1073741824,
    // PAGE_TARGETS_INVALID = 1073741824, this enum value conflicts with PAGE_TARGETS_NO_UPDATE
    PAGE_ENCLAVE_UNVALIDATED = 536870912,
    PAGE_ENCLAVE_MASK = 268435456,
    // PAGE_ENCLAVE_DECOMMIT = 268435456, this enum value conflicts with PAGE_ENCLAVE_MASK
    PAGE_ENCLAVE_SS_FIRST = 268435457,
    PAGE_ENCLAVE_SS_REST = 268435458,
    // SEC_PARTITION_OWNER_HANDLE = 262144, this enum value conflicts with PAGE_GRAPHICS_NOCACHE
    SEC_64K_PAGES = 524288,
    SEC_FILE = 8388608,
    SEC_IMAGE = 16777216,
    SEC_PROTECTED_IMAGE = 33554432,
    SEC_RESERVE = 67108864,
    SEC_COMMIT = 134217728,
    // SEC_NOCACHE = 268435456, this enum value conflicts with PAGE_ENCLAVE_MASK
    // SEC_WRITECOMBINE = 1073741824, this enum value conflicts with PAGE_TARGETS_NO_UPDATE
    // SEC_LARGE_PAGES = 2147483648, this enum value conflicts with PAGE_ENCLAVE_THREAD_CONTROL
    SEC_IMAGE_NO_EXECUTE = 285212672,
    _,
    pub fn initFlags(o: struct {
        PAGE_NOACCESS: u1 = 0,
        PAGE_READONLY: u1 = 0,
        PAGE_READWRITE: u1 = 0,
        PAGE_WRITECOPY: u1 = 0,
        PAGE_EXECUTE: u1 = 0,
        PAGE_EXECUTE_READ: u1 = 0,
        PAGE_EXECUTE_READWRITE: u1 = 0,
        PAGE_EXECUTE_WRITECOPY: u1 = 0,
        PAGE_GUARD: u1 = 0,
        PAGE_NOCACHE: u1 = 0,
        PAGE_WRITECOMBINE: u1 = 0,
        PAGE_GRAPHICS_NOACCESS: u1 = 0,
        PAGE_GRAPHICS_READONLY: u1 = 0,
        PAGE_GRAPHICS_READWRITE: u1 = 0,
        PAGE_GRAPHICS_EXECUTE: u1 = 0,
        PAGE_GRAPHICS_EXECUTE_READ: u1 = 0,
        PAGE_GRAPHICS_EXECUTE_READWRITE: u1 = 0,
        PAGE_GRAPHICS_COHERENT: u1 = 0,
        PAGE_GRAPHICS_NOCACHE: u1 = 0,
        PAGE_ENCLAVE_THREAD_CONTROL: u1 = 0,
        PAGE_TARGETS_NO_UPDATE: u1 = 0,
        PAGE_ENCLAVE_UNVALIDATED: u1 = 0,
        PAGE_ENCLAVE_MASK: u1 = 0,
        PAGE_ENCLAVE_SS_FIRST: u1 = 0,
        PAGE_ENCLAVE_SS_REST: u1 = 0,
        SEC_64K_PAGES: u1 = 0,
        SEC_FILE: u1 = 0,
        SEC_IMAGE: u1 = 0,
        SEC_PROTECTED_IMAGE: u1 = 0,
        SEC_RESERVE: u1 = 0,
        SEC_COMMIT: u1 = 0,
        SEC_IMAGE_NO_EXECUTE: u1 = 0,
    }) PAGE_PROTECTION_FLAGS {
        return @as(PAGE_PROTECTION_FLAGS, @enumFromInt((if (o.PAGE_NOACCESS == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_NOACCESS) else 0) | (if (o.PAGE_READONLY == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_READONLY) else 0) | (if (o.PAGE_READWRITE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_READWRITE) else 0) | (if (o.PAGE_WRITECOPY == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_WRITECOPY) else 0) | (if (o.PAGE_EXECUTE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_EXECUTE) else 0) | (if (o.PAGE_EXECUTE_READ == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_EXECUTE_READ) else 0) | (if (o.PAGE_EXECUTE_READWRITE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_EXECUTE_READWRITE) else 0) | (if (o.PAGE_EXECUTE_WRITECOPY == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_EXECUTE_WRITECOPY) else 0) | (if (o.PAGE_GUARD == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GUARD) else 0) | (if (o.PAGE_NOCACHE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_NOCACHE) else 0) | (if (o.PAGE_WRITECOMBINE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_WRITECOMBINE) else 0) | (if (o.PAGE_GRAPHICS_NOACCESS == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_NOACCESS) else 0) | (if (o.PAGE_GRAPHICS_READONLY == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_READONLY) else 0) | (if (o.PAGE_GRAPHICS_READWRITE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_READWRITE) else 0) | (if (o.PAGE_GRAPHICS_EXECUTE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_EXECUTE) else 0) | (if (o.PAGE_GRAPHICS_EXECUTE_READ == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_EXECUTE_READ) else 0) | (if (o.PAGE_GRAPHICS_EXECUTE_READWRITE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_EXECUTE_READWRITE) else 0) | (if (o.PAGE_GRAPHICS_COHERENT == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_COHERENT) else 0) | (if (o.PAGE_GRAPHICS_NOCACHE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_NOCACHE) else 0) | (if (o.PAGE_ENCLAVE_THREAD_CONTROL == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_THREAD_CONTROL) else 0) | (if (o.PAGE_TARGETS_NO_UPDATE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_TARGETS_NO_UPDATE) else 0) | (if (o.PAGE_ENCLAVE_UNVALIDATED == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_UNVALIDATED) else 0) | (if (o.PAGE_ENCLAVE_MASK == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_MASK) else 0) | (if (o.PAGE_ENCLAVE_SS_FIRST == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_SS_FIRST) else 0) | (if (o.PAGE_ENCLAVE_SS_REST == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_SS_REST) else 0) | (if (o.SEC_64K_PAGES == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_64K_PAGES) else 0) | (if (o.SEC_FILE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_FILE) else 0) | (if (o.SEC_IMAGE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_IMAGE) else 0) | (if (o.SEC_PROTECTED_IMAGE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_PROTECTED_IMAGE) else 0) | (if (o.SEC_RESERVE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_RESERVE) else 0) | (if (o.SEC_COMMIT == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_COMMIT) else 0) | (if (o.SEC_IMAGE_NO_EXECUTE == 1) @intFromEnum(PAGE_PROTECTION_FLAGS.SEC_IMAGE_NO_EXECUTE) else 0)));
    }
};
pub const PAGE_NOACCESS = PAGE_PROTECTION_FLAGS.PAGE_NOACCESS;
pub const PAGE_READONLY = PAGE_PROTECTION_FLAGS.PAGE_READONLY;
pub const PAGE_READWRITE = PAGE_PROTECTION_FLAGS.PAGE_READWRITE;
pub const PAGE_WRITECOPY = PAGE_PROTECTION_FLAGS.PAGE_WRITECOPY;
pub const PAGE_EXECUTE = PAGE_PROTECTION_FLAGS.PAGE_EXECUTE;
pub const PAGE_EXECUTE_READ = PAGE_PROTECTION_FLAGS.PAGE_EXECUTE_READ;
pub const PAGE_EXECUTE_READWRITE = PAGE_PROTECTION_FLAGS.PAGE_EXECUTE_READWRITE;
pub const PAGE_EXECUTE_WRITECOPY = PAGE_PROTECTION_FLAGS.PAGE_EXECUTE_WRITECOPY;
pub const PAGE_GUARD = PAGE_PROTECTION_FLAGS.PAGE_GUARD;
pub const PAGE_NOCACHE = PAGE_PROTECTION_FLAGS.PAGE_NOCACHE;
pub const PAGE_WRITECOMBINE = PAGE_PROTECTION_FLAGS.PAGE_WRITECOMBINE;
pub const PAGE_GRAPHICS_NOACCESS = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_NOACCESS;
pub const PAGE_GRAPHICS_READONLY = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_READONLY;
pub const PAGE_GRAPHICS_READWRITE = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_READWRITE;
pub const PAGE_GRAPHICS_EXECUTE = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_EXECUTE;
pub const PAGE_GRAPHICS_EXECUTE_READ = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_EXECUTE_READ;
pub const PAGE_GRAPHICS_EXECUTE_READWRITE = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_EXECUTE_READWRITE;
pub const PAGE_GRAPHICS_COHERENT = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_COHERENT;
pub const PAGE_GRAPHICS_NOCACHE = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_NOCACHE;
pub const PAGE_ENCLAVE_THREAD_CONTROL = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_THREAD_CONTROL;
pub const PAGE_REVERT_TO_FILE_MAP = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_THREAD_CONTROL;
pub const PAGE_TARGETS_NO_UPDATE = PAGE_PROTECTION_FLAGS.PAGE_TARGETS_NO_UPDATE;
pub const PAGE_TARGETS_INVALID = PAGE_PROTECTION_FLAGS.PAGE_TARGETS_NO_UPDATE;
pub const PAGE_ENCLAVE_UNVALIDATED = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_UNVALIDATED;
pub const PAGE_ENCLAVE_MASK = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_MASK;
pub const PAGE_ENCLAVE_DECOMMIT = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_MASK;
pub const PAGE_ENCLAVE_SS_FIRST = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_SS_FIRST;
pub const PAGE_ENCLAVE_SS_REST = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_SS_REST;
pub const SEC_PARTITION_OWNER_HANDLE = PAGE_PROTECTION_FLAGS.PAGE_GRAPHICS_NOCACHE;
pub const SEC_64K_PAGES = PAGE_PROTECTION_FLAGS.SEC_64K_PAGES;
pub const SEC_FILE = PAGE_PROTECTION_FLAGS.SEC_FILE;
pub const SEC_IMAGE = PAGE_PROTECTION_FLAGS.SEC_IMAGE;
pub const SEC_PROTECTED_IMAGE = PAGE_PROTECTION_FLAGS.SEC_PROTECTED_IMAGE;
pub const SEC_RESERVE = PAGE_PROTECTION_FLAGS.SEC_RESERVE;
pub const SEC_COMMIT = PAGE_PROTECTION_FLAGS.SEC_COMMIT;
pub const SEC_NOCACHE = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_MASK;
pub const SEC_WRITECOMBINE = PAGE_PROTECTION_FLAGS.PAGE_TARGETS_NO_UPDATE;
pub const SEC_LARGE_PAGES = PAGE_PROTECTION_FLAGS.PAGE_ENCLAVE_THREAD_CONTROL;
pub const SEC_IMAGE_NO_EXECUTE = PAGE_PROTECTION_FLAGS.SEC_IMAGE_NO_EXECUTE;

pub const UNMAP_VIEW_OF_FILE_FLAGS = enum(u32) {
    UNMAP_NONE = 0,
    UNMAP_WITH_TRANSIENT_BOOST = 1,
    PRESERVE_PLACEHOLDER = 2,
};
pub const MEM_UNMAP_NONE = UNMAP_VIEW_OF_FILE_FLAGS.UNMAP_NONE;
pub const MEM_UNMAP_WITH_TRANSIENT_BOOST = UNMAP_VIEW_OF_FILE_FLAGS.UNMAP_WITH_TRANSIENT_BOOST;
pub const MEM_PRESERVE_PLACEHOLDER = UNMAP_VIEW_OF_FILE_FLAGS.PRESERVE_PLACEHOLDER;

pub const VIRTUAL_FREE_TYPE = enum(u32) {
    DECOMMIT = 16384,
    RELEASE = 32768,
};
pub const MEM_DECOMMIT = VIRTUAL_FREE_TYPE.DECOMMIT;
pub const MEM_RELEASE = VIRTUAL_FREE_TYPE.RELEASE;

pub const VIRTUAL_ALLOCATION_TYPE = enum(u32) {
    COMMIT = 4096,
    RESERVE = 8192,
    RESET = 524288,
    RESET_UNDO = 16777216,
    REPLACE_PLACEHOLDER = 16384,
    LARGE_PAGES = 536870912,
    RESERVE_PLACEHOLDER = 262144,
    FREE = 65536,
    _,
    pub fn initFlags(o: struct {
        COMMIT: u1 = 0,
        RESERVE: u1 = 0,
        RESET: u1 = 0,
        RESET_UNDO: u1 = 0,
        REPLACE_PLACEHOLDER: u1 = 0,
        LARGE_PAGES: u1 = 0,
        RESERVE_PLACEHOLDER: u1 = 0,
        FREE: u1 = 0,
    }) VIRTUAL_ALLOCATION_TYPE {
        return @as(VIRTUAL_ALLOCATION_TYPE, @enumFromInt((if (o.COMMIT == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.COMMIT) else 0) | (if (o.RESERVE == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.RESERVE) else 0) | (if (o.RESET == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.RESET) else 0) | (if (o.RESET_UNDO == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.RESET_UNDO) else 0) | (if (o.REPLACE_PLACEHOLDER == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.REPLACE_PLACEHOLDER) else 0) | (if (o.LARGE_PAGES == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.LARGE_PAGES) else 0) | (if (o.RESERVE_PLACEHOLDER == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.RESERVE_PLACEHOLDER) else 0) | (if (o.FREE == 1) @intFromEnum(VIRTUAL_ALLOCATION_TYPE.FREE) else 0)));
    }
};
pub const MEM_COMMIT = VIRTUAL_ALLOCATION_TYPE.COMMIT;
pub const MEM_RESERVE = VIRTUAL_ALLOCATION_TYPE.RESERVE;
pub const MEM_RESET = VIRTUAL_ALLOCATION_TYPE.RESET;
pub const MEM_RESET_UNDO = VIRTUAL_ALLOCATION_TYPE.RESET_UNDO;
pub const MEM_REPLACE_PLACEHOLDER = VIRTUAL_ALLOCATION_TYPE.REPLACE_PLACEHOLDER;
pub const MEM_LARGE_PAGES = VIRTUAL_ALLOCATION_TYPE.LARGE_PAGES;
pub const MEM_RESERVE_PLACEHOLDER = VIRTUAL_ALLOCATION_TYPE.RESERVE_PLACEHOLDER;
pub const MEM_FREE = VIRTUAL_ALLOCATION_TYPE.FREE;

pub const LOCAL_ALLOC_FLAGS = enum(u32) {
    LHND = 66,
    LMEM_FIXED = 0,
    LMEM_MOVEABLE = 2,
    LMEM_ZEROINIT = 64,
    // LPTR = 64, this enum value conflicts with LMEM_ZEROINIT
    // NONZEROLHND = 2, this enum value conflicts with LMEM_MOVEABLE
    // NONZEROLPTR = 0, this enum value conflicts with LMEM_FIXED
    _,
    pub fn initFlags(o: struct {
        LHND: u1 = 0,
        LMEM_FIXED: u1 = 0,
        LMEM_MOVEABLE: u1 = 0,
        LMEM_ZEROINIT: u1 = 0,
    }) LOCAL_ALLOC_FLAGS {
        return @as(LOCAL_ALLOC_FLAGS, @enumFromInt((if (o.LHND == 1) @intFromEnum(LOCAL_ALLOC_FLAGS.LHND) else 0) | (if (o.LMEM_FIXED == 1) @intFromEnum(LOCAL_ALLOC_FLAGS.LMEM_FIXED) else 0) | (if (o.LMEM_MOVEABLE == 1) @intFromEnum(LOCAL_ALLOC_FLAGS.LMEM_MOVEABLE) else 0) | (if (o.LMEM_ZEROINIT == 1) @intFromEnum(LOCAL_ALLOC_FLAGS.LMEM_ZEROINIT) else 0)));
    }
};
pub const LHND = LOCAL_ALLOC_FLAGS.LHND;
pub const LMEM_FIXED = LOCAL_ALLOC_FLAGS.LMEM_FIXED;
pub const LMEM_MOVEABLE = LOCAL_ALLOC_FLAGS.LMEM_MOVEABLE;
pub const LMEM_ZEROINIT = LOCAL_ALLOC_FLAGS.LMEM_ZEROINIT;
pub const LPTR = LOCAL_ALLOC_FLAGS.LMEM_ZEROINIT;
pub const NONZEROLHND = LOCAL_ALLOC_FLAGS.LMEM_MOVEABLE;
pub const NONZEROLPTR = LOCAL_ALLOC_FLAGS.LMEM_FIXED;

pub const GLOBAL_ALLOC_FLAGS = enum(u32) {
    HND = 66,
    MEM_FIXED = 0,
    MEM_MOVEABLE = 2,
    MEM_ZEROINIT = 64,
    // PTR = 64, this enum value conflicts with MEM_ZEROINIT
    _,
    pub fn initFlags(o: struct {
        HND: u1 = 0,
        MEM_FIXED: u1 = 0,
        MEM_MOVEABLE: u1 = 0,
        MEM_ZEROINIT: u1 = 0,
    }) GLOBAL_ALLOC_FLAGS {
        return @as(GLOBAL_ALLOC_FLAGS, @enumFromInt((if (o.HND == 1) @intFromEnum(GLOBAL_ALLOC_FLAGS.HND) else 0) | (if (o.MEM_FIXED == 1) @intFromEnum(GLOBAL_ALLOC_FLAGS.MEM_FIXED) else 0) | (if (o.MEM_MOVEABLE == 1) @intFromEnum(GLOBAL_ALLOC_FLAGS.MEM_MOVEABLE) else 0) | (if (o.MEM_ZEROINIT == 1) @intFromEnum(GLOBAL_ALLOC_FLAGS.MEM_ZEROINIT) else 0)));
    }
};
pub const GHND = GLOBAL_ALLOC_FLAGS.HND;
pub const GMEM_FIXED = GLOBAL_ALLOC_FLAGS.MEM_FIXED;
pub const GMEM_MOVEABLE = GLOBAL_ALLOC_FLAGS.MEM_MOVEABLE;
pub const GMEM_ZEROINIT = GLOBAL_ALLOC_FLAGS.MEM_ZEROINIT;
pub const GPTR = GLOBAL_ALLOC_FLAGS.MEM_ZEROINIT;

pub const PAGE_TYPE = enum(u32) {
    PRIVATE = 131072,
    MAPPED = 262144,
    IMAGE = 16777216,
    _,
    pub fn initFlags(o: struct {
        PRIVATE: u1 = 0,
        MAPPED: u1 = 0,
        IMAGE: u1 = 0,
    }) PAGE_TYPE {
        return @as(PAGE_TYPE, @enumFromInt((if (o.PRIVATE == 1) @intFromEnum(PAGE_TYPE.PRIVATE) else 0) | (if (o.MAPPED == 1) @intFromEnum(PAGE_TYPE.MAPPED) else 0) | (if (o.IMAGE == 1) @intFromEnum(PAGE_TYPE.IMAGE) else 0)));
    }
};
pub const MEM_PRIVATE = PAGE_TYPE.PRIVATE;
pub const MEM_MAPPED = PAGE_TYPE.MAPPED;
pub const MEM_IMAGE = PAGE_TYPE.IMAGE;

// TODO: this type has a FreeFunc 'HeapDestroy', what can Zig do with this information?
pub const HeapHandle = *opaque {};

pub const PROCESS_HEAP_ENTRY = extern struct {
    lpData: ?*anyopaque,
    cbData: u32,
    cbOverhead: u8,
    iRegionIndex: u8,
    wFlags: u16,
    Anonymous: extern union {
        Block: extern struct {
            hMem: ?HANDLE,
            dwReserved: [3]u32,
        },
        Region: extern struct {
            dwCommittedSize: u32,
            dwUnCommittedSize: u32,
            lpFirstBlock: ?*anyopaque,
            lpLastBlock: ?*anyopaque,
        },
    },
};

pub const HEAP_SUMMARY = extern struct {
    cb: u32,
    cbAllocated: usize,
    cbCommitted: usize,
    cbReserved: usize,
    cbMaxReserve: usize,
};

pub const MEMORY_RESOURCE_NOTIFICATION_TYPE = enum(i32) {
    LowMemoryResourceNotification = 0,
    HighMemoryResourceNotification = 1,
};
pub const LowMemoryResourceNotification = MEMORY_RESOURCE_NOTIFICATION_TYPE.LowMemoryResourceNotification;
pub const HighMemoryResourceNotification = MEMORY_RESOURCE_NOTIFICATION_TYPE.HighMemoryResourceNotification;

pub const WIN32_MEMORY_RANGE_ENTRY = extern struct {
    VirtualAddress: ?*anyopaque,
    NumberOfBytes: usize,
};

pub const PBAD_MEMORY_CALLBACK_ROUTINE = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const OFFER_PRIORITY = enum(i32) {
    VeryLow = 1,
    Low = 2,
    BelowNormal = 3,
    Normal = 4,
};
pub const VmOfferPriorityVeryLow = OFFER_PRIORITY.VeryLow;
pub const VmOfferPriorityLow = OFFER_PRIORITY.Low;
pub const VmOfferPriorityBelowNormal = OFFER_PRIORITY.BelowNormal;
pub const VmOfferPriorityNormal = OFFER_PRIORITY.Normal;

pub const WIN32_MEMORY_INFORMATION_CLASS = enum(i32) {
    o = 0,
};
pub const MemoryRegionInfo = WIN32_MEMORY_INFORMATION_CLASS.o;

pub const WIN32_MEMORY_REGION_INFORMATION = extern struct {
    AllocationBase: ?*anyopaque,
    AllocationProtect: u32,
    Anonymous: extern union {
        Flags: u32,
        Anonymous: extern struct {
            _bitfield: u32,
        },
    },
    RegionSize: usize,
    CommitSize: usize,
};

pub const WIN32_MEMORY_PARTITION_INFORMATION_CLASS = enum(i32) {
    Info = 0,
    DedicatedMemoryInfo = 1,
};
pub const MemoryPartitionInfo = WIN32_MEMORY_PARTITION_INFORMATION_CLASS.Info;
pub const MemoryPartitionDedicatedMemoryInfo = WIN32_MEMORY_PARTITION_INFORMATION_CLASS.DedicatedMemoryInfo;

pub const WIN32_MEMORY_PARTITION_INFORMATION = extern struct {
    Flags: u32,
    NumaNode: u32,
    Channel: u32,
    NumberOfNumaNodes: u32,
    ResidentAvailablePages: u64,
    CommittedPages: u64,
    CommitLimit: u64,
    PeakCommitment: u64,
    TotalNumberOfPages: u64,
    AvailablePages: u64,
    ZeroPages: u64,
    FreePages: u64,
    StandbyPages: u64,
    Reserved: [16]u64,
    MaximumCommitLimit: u64,
    Reserved2: u64,
    PartitionId: u32,
};

pub const MEMORY_BASIC_INFORMATION32 = extern struct {
    BaseAddress: u32,
    AllocationBase: u32,
    AllocationProtect: PAGE_PROTECTION_FLAGS,
    RegionSize: u32,
    State: VIRTUAL_ALLOCATION_TYPE,
    Protect: PAGE_PROTECTION_FLAGS,
    Type: PAGE_TYPE,
};

pub const MEMORY_BASIC_INFORMATION64 = extern struct {
    BaseAddress: u64,
    AllocationBase: u64,
    AllocationProtect: PAGE_PROTECTION_FLAGS,
    __alignment1: u32,
    RegionSize: u64,
    State: VIRTUAL_ALLOCATION_TYPE,
    Protect: PAGE_PROTECTION_FLAGS,
    Type: PAGE_TYPE,
    __alignment2: u32,
};

pub const CFG_CALL_TARGET_INFO = extern struct {
    Offset: usize,
    Flags: usize,
};

pub const MEM_EXTENDED_PARAMETER_TYPE = enum(i32) {
    InvalidType = 0,
    AddressRequirements = 1,
    NumaNode = 2,
    PartitionHandle = 3,
    UserPhysicalHandle = 4,
    AttributeFlags = 5,
    ImageMachine = 6,
    Max = 7,
};
pub const MemExtendedParameterInvalidType = MEM_EXTENDED_PARAMETER_TYPE.InvalidType;
pub const MemExtendedParameterAddressRequirements = MEM_EXTENDED_PARAMETER_TYPE.AddressRequirements;
pub const MemExtendedParameterNumaNode = MEM_EXTENDED_PARAMETER_TYPE.NumaNode;
pub const MemExtendedParameterPartitionHandle = MEM_EXTENDED_PARAMETER_TYPE.PartitionHandle;
pub const MemExtendedParameterUserPhysicalHandle = MEM_EXTENDED_PARAMETER_TYPE.UserPhysicalHandle;
pub const MemExtendedParameterAttributeFlags = MEM_EXTENDED_PARAMETER_TYPE.AttributeFlags;
pub const MemExtendedParameterImageMachine = MEM_EXTENDED_PARAMETER_TYPE.ImageMachine;
pub const MemExtendedParameterMax = MEM_EXTENDED_PARAMETER_TYPE.Max;

pub const MEM_EXTENDED_PARAMETER = extern struct {
    Anonymous1: extern struct {
        _bitfield: u64,
    },
    Anonymous2: extern union {
        ULong64: u64,
        Pointer: ?*anyopaque,
        Size: usize,
        Handle: ?HANDLE,
        ULong: u32,
    },
};

pub const HEAP_INFORMATION_CLASS = enum(i32) {
    CompatibilityInformation = 0,
    EnableTerminationOnCorruption = 1,
    OptimizeResources = 3,
    Tag = 7,
};
pub const HeapCompatibilityInformation = HEAP_INFORMATION_CLASS.CompatibilityInformation;
pub const HeapEnableTerminationOnCorruption = HEAP_INFORMATION_CLASS.EnableTerminationOnCorruption;
pub const HeapOptimizeResources = HEAP_INFORMATION_CLASS.OptimizeResources;
pub const HeapTag = HEAP_INFORMATION_CLASS.Tag;

pub const PSECURE_MEMORY_CACHE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        // TODO: what to do with BytesParamIndex 1?
        Addr: ?*anyopaque,
        Range: usize,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
    else => *const fn (
        // TODO: what to do with BytesParamIndex 1?
        Addr: ?*anyopaque,
        Range: usize,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
};

pub const MEMORY_BASIC_INFORMATION = switch (@import("../zig.zig").arch) {
    .X64, .Arm64 => extern struct {
        BaseAddress: ?*anyopaque,
        AllocationBase: ?*anyopaque,
        AllocationProtect: PAGE_PROTECTION_FLAGS,
        PartitionId: u16,
        RegionSize: usize,
        State: VIRTUAL_ALLOCATION_TYPE,
        Protect: PAGE_PROTECTION_FLAGS,
        Type: PAGE_TYPE,
    },
    .X86 => extern struct {
        BaseAddress: ?*anyopaque,
        AllocationBase: ?*anyopaque,
        AllocationProtect: PAGE_PROTECTION_FLAGS,
        RegionSize: usize,
        State: VIRTUAL_ALLOCATION_TYPE,
        Protect: PAGE_PROTECTION_FLAGS,
        Type: PAGE_TYPE,
    },
};

//--------------------------------------------------------------------------------
// Section: Functions (106)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapCreate(
    flOptions: HEAP_FLAGS,
    dwInitialSize: usize,
    dwMaximumSize: usize,
) callconv(@import("std").os.windows.WINAPI) ?HeapHandle;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapDestroy(
    hHeap: ?HeapHandle,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapAlloc(
    hHeap: ?HeapHandle,
    dwFlags: HEAP_FLAGS,
    dwBytes: usize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapReAlloc(
    hHeap: ?HeapHandle,
    dwFlags: HEAP_FLAGS,
    lpMem: ?*anyopaque,
    dwBytes: usize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapFree(
    hHeap: ?HeapHandle,
    dwFlags: HEAP_FLAGS,
    lpMem: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapSize(
    hHeap: ?HeapHandle,
    dwFlags: HEAP_FLAGS,
    lpMem: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessHeap() callconv(@import("std").os.windows.WINAPI) ?HeapHandle;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapCompact(
    hHeap: ?HeapHandle,
    dwFlags: HEAP_FLAGS,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapSetInformation(
    HeapHandle: ?HeapHandle,
    HeapInformationClass: HEAP_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    HeapInformation: ?*anyopaque,
    HeapInformationLength: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapValidate(
    hHeap: ?HeapHandle,
    dwFlags: HEAP_FLAGS,
    lpMem: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn HeapSummary(
    hHeap: ?HANDLE,
    dwFlags: u32,
    lpSummary: ?*HEAP_SUMMARY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetProcessHeaps(
    NumberOfHeaps: u32,
    ProcessHeaps: [*]?HeapHandle,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapLock(
    hHeap: ?HeapHandle,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapUnlock(
    hHeap: ?HeapHandle,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapWalk(
    hHeap: ?HeapHandle,
    lpEntry: ?*PROCESS_HEAP_ENTRY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn HeapQueryInformation(
    HeapHandle: ?HeapHandle,
    HeapInformationClass: HEAP_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    HeapInformation: ?*anyopaque,
    HeapInformationLength: usize,
    ReturnLength: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualAlloc(
    lpAddress: ?*anyopaque,
    dwSize: usize,
    flAllocationType: VIRTUAL_ALLOCATION_TYPE,
    flProtect: PAGE_PROTECTION_FLAGS,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualProtect(
    lpAddress: ?*anyopaque,
    dwSize: usize,
    flNewProtect: PAGE_PROTECTION_FLAGS,
    lpflOldProtect: ?*PAGE_PROTECTION_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualFree(
    lpAddress: ?*anyopaque,
    dwSize: usize,
    dwFreeType: VIRTUAL_FREE_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualQuery(
    lpAddress: ?*const anyopaque,
    // TODO: what to do with BytesParamIndex 2?
    lpBuffer: ?*MEMORY_BASIC_INFORMATION,
    dwLength: usize,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualAllocEx(
    hProcess: ?HANDLE,
    lpAddress: ?*anyopaque,
    dwSize: usize,
    flAllocationType: VIRTUAL_ALLOCATION_TYPE,
    flProtect: PAGE_PROTECTION_FLAGS,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualProtectEx(
    hProcess: ?HANDLE,
    lpAddress: ?*anyopaque,
    dwSize: usize,
    flNewProtect: PAGE_PROTECTION_FLAGS,
    lpflOldProtect: ?*PAGE_PROTECTION_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualQueryEx(
    hProcess: ?HANDLE,
    lpAddress: ?*const anyopaque,
    // TODO: what to do with BytesParamIndex 3?
    lpBuffer: ?*MEMORY_BASIC_INFORMATION,
    dwLength: usize,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateFileMappingW(
    hFile: ?HANDLE,
    lpFileMappingAttributes: ?*SECURITY_ATTRIBUTES,
    flProtect: PAGE_PROTECTION_FLAGS,
    dwMaximumSizeHigh: u32,
    dwMaximumSizeLow: u32,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenFileMappingW(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn MapViewOfFile(
    hFileMappingObject: ?HANDLE,
    dwDesiredAccess: FILE_MAP,
    dwFileOffsetHigh: u32,
    dwFileOffsetLow: u32,
    dwNumberOfBytesToMap: usize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn MapViewOfFileEx(
    hFileMappingObject: ?HANDLE,
    dwDesiredAccess: FILE_MAP,
    dwFileOffsetHigh: u32,
    dwFileOffsetLow: u32,
    dwNumberOfBytesToMap: usize,
    lpBaseAddress: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualFreeEx(
    hProcess: ?HANDLE,
    lpAddress: ?*anyopaque,
    dwSize: usize,
    dwFreeType: VIRTUAL_FREE_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn FlushViewOfFile(
    lpBaseAddress: ?*const anyopaque,
    dwNumberOfBytesToFlush: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn UnmapViewOfFile(
    lpBaseAddress: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetLargePageMinimum() callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetProcessWorkingSetSizeEx(
    hProcess: ?HANDLE,
    lpMinimumWorkingSetSize: ?*usize,
    lpMaximumWorkingSetSize: ?*usize,
    Flags: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetProcessWorkingSetSizeEx(
    hProcess: ?HANDLE,
    dwMinimumWorkingSetSize: usize,
    dwMaximumWorkingSetSize: usize,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualLock(
    lpAddress: ?*anyopaque,
    dwSize: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn VirtualUnlock(
    lpAddress: ?*anyopaque,
    dwSize: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetWriteWatch(
    dwFlags: u32,
    lpBaseAddress: ?*anyopaque,
    dwRegionSize: usize,
    lpAddresses: ?[*]?*anyopaque,
    lpdwCount: ?*usize,
    lpdwGranularity: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ResetWriteWatch(
    lpBaseAddress: ?*anyopaque,
    dwRegionSize: usize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateMemoryResourceNotification(
    NotificationType: MEMORY_RESOURCE_NOTIFICATION_TYPE,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn QueryMemoryResourceNotification(
    ResourceNotificationHandle: ?HANDLE,
    ResourceState: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn GetSystemFileCacheSize(
    lpMinimumFileCacheSize: ?*usize,
    lpMaximumFileCacheSize: ?*usize,
    lpFlags: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn SetSystemFileCacheSize(
    MinimumFileCacheSize: usize,
    MaximumFileCacheSize: usize,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateFileMappingNumaW(
    hFile: ?HANDLE,
    lpFileMappingAttributes: ?*SECURITY_ATTRIBUTES,
    flProtect: PAGE_PROTECTION_FLAGS,
    dwMaximumSizeHigh: u32,
    dwMaximumSizeLow: u32,
    lpName: ?[*:0]const u16,
    nndPreferred: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn PrefetchVirtualMemory(
    hProcess: ?HANDLE,
    NumberOfEntries: usize,
    VirtualAddresses: [*]WIN32_MEMORY_RANGE_ENTRY,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn CreateFileMappingFromApp(
    hFile: ?HANDLE,
    SecurityAttributes: ?*SECURITY_ATTRIBUTES,
    PageProtection: PAGE_PROTECTION_FLAGS,
    MaximumSize: u64,
    Name: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn MapViewOfFileFromApp(
    hFileMappingObject: ?HANDLE,
    DesiredAccess: FILE_MAP,
    FileOffset: u64,
    NumberOfBytesToMap: usize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn UnmapViewOfFileEx(
    BaseAddress: ?*anyopaque,
    UnmapFlags: UNMAP_VIEW_OF_FILE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn AllocateUserPhysicalPages(
    hProcess: ?HANDLE,
    NumberOfPages: ?*usize,
    PageArray: [*]usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn FreeUserPhysicalPages(
    hProcess: ?HANDLE,
    NumberOfPages: ?*usize,
    PageArray: [*]usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn MapUserPhysicalPages(
    VirtualAddress: ?*anyopaque,
    NumberOfPages: usize,
    PageArray: ?[*]usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn AllocateUserPhysicalPagesNuma(
    hProcess: ?HANDLE,
    NumberOfPages: ?*usize,
    PageArray: [*]usize,
    nndPreferred: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn VirtualAllocExNuma(
    hProcess: ?HANDLE,
    lpAddress: ?*anyopaque,
    dwSize: usize,
    flAllocationType: VIRTUAL_ALLOCATION_TYPE,
    flProtect: u32,
    nndPreferred: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn GetMemoryErrorHandlingCapabilities(
    Capabilities: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn RegisterBadMemoryNotification(
    Callback: ?PBAD_MEMORY_CALLBACK_ROUTINE,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn UnregisterBadMemoryNotification(
    RegistrationHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn OfferVirtualMemory(
    VirtualAddress: [*]u8,
    Size: usize,
    Priority: OFFER_PRIORITY,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn ReclaimVirtualMemory(
    VirtualAddress: [*]const u8,
    Size: usize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn DiscardVirtualMemory(
    VirtualAddress: [*]u8,
    Size: usize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-3" fn SetProcessValidCallTargets(
    hProcess: ?HANDLE,
    VirtualAddress: ?*anyopaque,
    RegionSize: usize,
    NumberOfOffsets: u32,
    OffsetInformation: [*]CFG_CALL_TARGET_INFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "api-ms-win-core-memory-l1-1-7" fn SetProcessValidCallTargetsForMappedView(
    Process: ?HANDLE,
    VirtualAddress: ?*anyopaque,
    RegionSize: usize,
    NumberOfOffsets: u32,
    OffsetInformation: [*]CFG_CALL_TARGET_INFO,
    Section: ?HANDLE,
    ExpectedFileOffset: u64,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-3" fn VirtualAllocFromApp(
    BaseAddress: ?*anyopaque,
    Size: usize,
    AllocationType: VIRTUAL_ALLOCATION_TYPE,
    Protection: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-3" fn VirtualProtectFromApp(
    Address: ?*anyopaque,
    Size: usize,
    NewProtection: u32,
    OldProtection: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-3" fn OpenFileMappingFromApp(
    DesiredAccess: u32,
    InheritHandle: BOOL,
    Name: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows10.0.14393'
pub extern "api-ms-win-core-memory-l1-1-4" fn QueryVirtualMemoryInformation(
    Process: ?HANDLE,
    VirtualAddress: ?*const anyopaque,
    MemoryInformationClass: WIN32_MEMORY_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 4?
    MemoryInformation: ?*anyopaque,
    MemoryInformationSize: usize,
    ReturnSize: ?*usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows10.0.15063'
pub extern "api-ms-win-core-memory-l1-1-5" fn MapViewOfFileNuma2(
    FileMappingHandle: ?HANDLE,
    ProcessHandle: ?HANDLE,
    Offset: u64,
    BaseAddress: ?*anyopaque,
    ViewSize: usize,
    AllocationType: u32,
    PageProtection: u32,
    PreferredNode: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows10.0.15063'
pub extern "api-ms-win-core-memory-l1-1-5" fn UnmapViewOfFile2(
    Process: ?HANDLE,
    BaseAddress: ?*anyopaque,
    UnmapFlags: UNMAP_VIEW_OF_FILE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "api-ms-win-core-memory-l1-1-5" fn VirtualUnlockEx(
    Process: ?HANDLE,
    Address: ?*anyopaque,
    Size: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-6" fn VirtualAlloc2(
    Process: ?HANDLE,
    BaseAddress: ?*anyopaque,
    Size: usize,
    AllocationType: VIRTUAL_ALLOCATION_TYPE,
    PageProtection: u32,
    ExtendedParameters: ?[*]MEM_EXTENDED_PARAMETER,
    ParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows10.0.17134'
pub extern "api-ms-win-core-memory-l1-1-6" fn MapViewOfFile3(
    FileMapping: ?HANDLE,
    Process: ?HANDLE,
    BaseAddress: ?*anyopaque,
    Offset: u64,
    ViewSize: usize,
    AllocationType: VIRTUAL_ALLOCATION_TYPE,
    PageProtection: u32,
    ExtendedParameters: ?[*]MEM_EXTENDED_PARAMETER,
    ParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-6" fn VirtualAlloc2FromApp(
    Process: ?HANDLE,
    BaseAddress: ?*anyopaque,
    Size: usize,
    AllocationType: VIRTUAL_ALLOCATION_TYPE,
    PageProtection: u32,
    ExtendedParameters: ?[*]MEM_EXTENDED_PARAMETER,
    ParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "api-ms-win-core-memory-l1-1-6" fn MapViewOfFile3FromApp(
    FileMapping: ?HANDLE,
    Process: ?HANDLE,
    BaseAddress: ?*anyopaque,
    Offset: u64,
    ViewSize: usize,
    AllocationType: VIRTUAL_ALLOCATION_TYPE,
    PageProtection: u32,
    ExtendedParameters: ?[*]MEM_EXTENDED_PARAMETER,
    ParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

pub extern "api-ms-win-core-memory-l1-1-7" fn CreateFileMapping2(
    File: ?HANDLE,
    SecurityAttributes: ?*SECURITY_ATTRIBUTES,
    DesiredAccess: u32,
    PageProtection: PAGE_PROTECTION_FLAGS,
    AllocationAttributes: u32,
    MaximumSize: u64,
    Name: ?[*:0]const u16,
    ExtendedParameters: ?[*]MEM_EXTENDED_PARAMETER,
    ParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

pub extern "api-ms-win-core-memory-l1-1-8" fn AllocateUserPhysicalPages2(
    ObjectHandle: ?HANDLE,
    NumberOfPages: ?*usize,
    PageArray: [*]usize,
    ExtendedParameters: ?[*]MEM_EXTENDED_PARAMETER,
    ExtendedParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "api-ms-win-core-memory-l1-1-8" fn OpenDedicatedMemoryPartition(
    Partition: ?HANDLE,
    DedicatedMemoryTypeId: u64,
    DesiredAccess: u32,
    InheritHandle: BOOL,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

pub extern "api-ms-win-core-memory-l1-1-8" fn QueryPartitionInformation(
    Partition: ?HANDLE,
    PartitionInformationClass: WIN32_MEMORY_PARTITION_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    PartitionInformation: ?*anyopaque,
    PartitionInformationLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn RtlCompareMemory(
    Source1: ?*const anyopaque,
    Source2: ?*const anyopaque,
    Length: usize,
) callconv(@import("std").os.windows.WINAPI) usize;

pub extern "ntdll" fn RtlCrc32(
    // TODO: what to do with BytesParamIndex 1?
    Buffer: ?*const anyopaque,
    Size: usize,
    InitialCrc: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "ntdll" fn RtlCrc64(
    // TODO: what to do with BytesParamIndex 1?
    Buffer: ?*const anyopaque,
    Size: usize,
    InitialCrc: u64,
) callconv(@import("std").os.windows.WINAPI) u64;

pub extern "ntdll" fn RtlIsZeroMemory(
    Buffer: ?*anyopaque,
    Length: usize,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalAlloc(
    uFlags: GLOBAL_ALLOC_FLAGS,
    dwBytes: usize,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalReAlloc(
    hMem: isize,
    dwBytes: usize,
    uFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalSize(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalUnlock(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalLock(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalFlags(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalHandle(
    pMem: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GlobalFree(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalAlloc(
    uFlags: LOCAL_ALLOC_FLAGS,
    uBytes: usize,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalReAlloc(
    hMem: isize,
    uBytes: usize,
    uFlags: u32,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalLock(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalHandle(
    pMem: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalUnlock(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalSize(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) usize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalFlags(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn LocalFree(
    hMem: isize,
) callconv(@import("std").os.windows.WINAPI) isize;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CreateFileMappingA(
    hFile: ?HANDLE,
    lpFileMappingAttributes: ?*SECURITY_ATTRIBUTES,
    flProtect: PAGE_PROTECTION_FLAGS,
    dwMaximumSizeHigh: u32,
    dwMaximumSizeLow: u32,
    lpName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn CreateFileMappingNumaA(
    hFile: ?HANDLE,
    lpFileMappingAttributes: ?*SECURITY_ATTRIBUTES,
    flProtect: PAGE_PROTECTION_FLAGS,
    dwMaximumSizeHigh: u32,
    dwMaximumSizeLow: u32,
    lpName: ?[*:0]const u8,
    nndPreferred: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn OpenFileMappingA(
    dwDesiredAccess: u32,
    bInheritHandle: BOOL,
    lpName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn MapViewOfFileExNuma(
    hFileMappingObject: ?HANDLE,
    dwDesiredAccess: FILE_MAP,
    dwFileOffsetHigh: u32,
    dwFileOffsetLow: u32,
    dwNumberOfBytesToMap: usize,
    lpBaseAddress: ?*anyopaque,
    nndPreferred: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn IsBadReadPtr(
    lp: ?*const anyopaque,
    ucb: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn IsBadWritePtr(
    lp: ?*anyopaque,
    ucb: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn IsBadCodePtr(
    lpfn: ?FARPROC,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn IsBadStringPtrA(
    lpsz: ?[*:0]const u8,
    ucchMax: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn IsBadStringPtrW(
    lpsz: ?[*:0]const u16,
    ucchMax: usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn MapUserPhysicalPagesScatter(
    VirtualAddresses: [*]?*anyopaque,
    NumberOfPages: usize,
    PageArray: ?[*]usize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn AddSecureMemoryCacheCallback(
    pfnCallBack: ?PSECURE_MEMORY_CACHE_CALLBACK,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "kernel32" fn RemoveSecureMemoryCacheCallback(
    pfnCallBack: ?PSECURE_MEMORY_CACHE_CALLBACK,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (4)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const CreateFileMapping = thismodule.CreateFileMappingA;
        pub const OpenFileMapping = thismodule.OpenFileMappingA;
        pub const CreateFileMappingNuma = thismodule.CreateFileMappingNumaA;
        pub const IsBadStringPtr = thismodule.IsBadStringPtrA;
    },
    .wide => struct {
        pub const CreateFileMapping = thismodule.CreateFileMappingW;
        pub const OpenFileMapping = thismodule.OpenFileMappingW;
        pub const CreateFileMappingNuma = thismodule.CreateFileMappingNumaW;
        pub const IsBadStringPtr = thismodule.IsBadStringPtrW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const CreateFileMapping = *opaque {};
        pub const OpenFileMapping = *opaque {};
        pub const CreateFileMappingNuma = *opaque {};
        pub const IsBadStringPtr = *opaque {};
    } else struct {
        pub const CreateFileMapping = @compileError("'CreateFileMapping' requires that UNICODE be set to true or false in the root module");
        pub const OpenFileMapping = @compileError("'OpenFileMapping' requires that UNICODE be set to true or false in the root module");
        pub const CreateFileMappingNuma = @compileError("'CreateFileMappingNuma' requires that UNICODE be set to true or false in the root module");
        pub const IsBadStringPtr = @compileError("'IsBadStringPtr' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const BOOL = @import("../foundation.zig").BOOL;
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const FARPROC = @import("../foundation.zig").FARPROC;
const HANDLE = @import("../foundation.zig").HANDLE;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const SECURITY_ATTRIBUTES = @import("../security.zig").SECURITY_ATTRIBUTES;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PBAD_MEMORY_CALLBACK_ROUTINE")) {
        _ = PBAD_MEMORY_CALLBACK_ROUTINE;
    }
    if (@hasDecl(@This(), "PSECURE_MEMORY_CACHE_CALLBACK")) {
        _ = PSECURE_MEMORY_CACHE_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
//--------------------------------------------------------------------------------
// Section: SubModules (1)
//--------------------------------------------------------------------------------
pub const non_volatile = @import("memory/non_volatile.zig");
