//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (1)
//--------------------------------------------------------------------------------
pub const JS_SOURCE_CONTEXT_NONE = @as(u64, 18446744073709551615);

//--------------------------------------------------------------------------------
// Section: Types (11)
//--------------------------------------------------------------------------------
pub const JsRuntimeVersion = enum(i32) {
    @"10" = 0,
    @"11" = 1,
    Edge = -1,
};
// TODO: enum 'JsRuntimeVersion' has known issues with its value aliases

pub const JsErrorCode = enum(u32) {
    NoError = 0,
    ErrorCategoryUsage = 65536,
    ErrorInvalidArgument = 65537,
    ErrorNullArgument = 65538,
    ErrorNoCurrentContext = 65539,
    ErrorInExceptionState = 65540,
    ErrorNotImplemented = 65541,
    ErrorWrongThread = 65542,
    ErrorRuntimeInUse = 65543,
    ErrorBadSerializedScript = 65544,
    ErrorInDisabledState = 65545,
    ErrorCannotDisableExecution = 65546,
    ErrorHeapEnumInProgress = 65547,
    ErrorArgumentNotObject = 65548,
    ErrorInProfileCallback = 65549,
    ErrorInThreadServiceCallback = 65550,
    ErrorCannotSerializeDebugScript = 65551,
    ErrorAlreadyDebuggingContext = 65552,
    ErrorAlreadyProfilingContext = 65553,
    ErrorIdleNotEnabled = 65554,
    ErrorCategoryEngine = 131072,
    ErrorOutOfMemory = 131073,
    ErrorCategoryScript = 196608,
    ErrorScriptException = 196609,
    ErrorScriptCompile = 196610,
    ErrorScriptTerminated = 196611,
    ErrorScriptEvalDisabled = 196612,
    ErrorCategoryFatal = 262144,
    ErrorFatal = 262145,
};
pub const JsNoError = JsErrorCode.NoError;
pub const JsErrorCategoryUsage = JsErrorCode.ErrorCategoryUsage;
pub const JsErrorInvalidArgument = JsErrorCode.ErrorInvalidArgument;
pub const JsErrorNullArgument = JsErrorCode.ErrorNullArgument;
pub const JsErrorNoCurrentContext = JsErrorCode.ErrorNoCurrentContext;
pub const JsErrorInExceptionState = JsErrorCode.ErrorInExceptionState;
pub const JsErrorNotImplemented = JsErrorCode.ErrorNotImplemented;
pub const JsErrorWrongThread = JsErrorCode.ErrorWrongThread;
pub const JsErrorRuntimeInUse = JsErrorCode.ErrorRuntimeInUse;
pub const JsErrorBadSerializedScript = JsErrorCode.ErrorBadSerializedScript;
pub const JsErrorInDisabledState = JsErrorCode.ErrorInDisabledState;
pub const JsErrorCannotDisableExecution = JsErrorCode.ErrorCannotDisableExecution;
pub const JsErrorHeapEnumInProgress = JsErrorCode.ErrorHeapEnumInProgress;
pub const JsErrorArgumentNotObject = JsErrorCode.ErrorArgumentNotObject;
pub const JsErrorInProfileCallback = JsErrorCode.ErrorInProfileCallback;
pub const JsErrorInThreadServiceCallback = JsErrorCode.ErrorInThreadServiceCallback;
pub const JsErrorCannotSerializeDebugScript = JsErrorCode.ErrorCannotSerializeDebugScript;
pub const JsErrorAlreadyDebuggingContext = JsErrorCode.ErrorAlreadyDebuggingContext;
pub const JsErrorAlreadyProfilingContext = JsErrorCode.ErrorAlreadyProfilingContext;
pub const JsErrorIdleNotEnabled = JsErrorCode.ErrorIdleNotEnabled;
pub const JsErrorCategoryEngine = JsErrorCode.ErrorCategoryEngine;
pub const JsErrorOutOfMemory = JsErrorCode.ErrorOutOfMemory;
pub const JsErrorCategoryScript = JsErrorCode.ErrorCategoryScript;
pub const JsErrorScriptException = JsErrorCode.ErrorScriptException;
pub const JsErrorScriptCompile = JsErrorCode.ErrorScriptCompile;
pub const JsErrorScriptTerminated = JsErrorCode.ErrorScriptTerminated;
pub const JsErrorScriptEvalDisabled = JsErrorCode.ErrorScriptEvalDisabled;
pub const JsErrorCategoryFatal = JsErrorCode.ErrorCategoryFatal;
pub const JsErrorFatal = JsErrorCode.ErrorFatal;

pub const JsRuntimeAttributes = enum(i32) {
    None = 0,
    DisableBackgroundWork = 1,
    AllowScriptInterrupt = 2,
    EnableIdleProcessing = 4,
    DisableNativeCodeGeneration = 8,
    DisableEval = 16,
};
pub const JsRuntimeAttributeNone = JsRuntimeAttributes.None;
pub const JsRuntimeAttributeDisableBackgroundWork = JsRuntimeAttributes.DisableBackgroundWork;
pub const JsRuntimeAttributeAllowScriptInterrupt = JsRuntimeAttributes.AllowScriptInterrupt;
pub const JsRuntimeAttributeEnableIdleProcessing = JsRuntimeAttributes.EnableIdleProcessing;
pub const JsRuntimeAttributeDisableNativeCodeGeneration = JsRuntimeAttributes.DisableNativeCodeGeneration;
pub const JsRuntimeAttributeDisableEval = JsRuntimeAttributes.DisableEval;

pub const JsMemoryEventType = enum(i32) {
    Allocate = 0,
    Free = 1,
    Failure = 2,
};
pub const JsMemoryAllocate = JsMemoryEventType.Allocate;
pub const JsMemoryFree = JsMemoryEventType.Free;
pub const JsMemoryFailure = JsMemoryEventType.Failure;

pub const JsMemoryAllocationCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        callbackState: ?*anyopaque,
        allocationEvent: JsMemoryEventType,
        allocationSize: usize,
    ) callconv(@import("std").os.windows.WINAPI) bool,
    else => *const fn (
        callbackState: ?*anyopaque,
        allocationEvent: JsMemoryEventType,
        allocationSize: usize,
    ) callconv(@import("std").os.windows.WINAPI) bool,
};

pub const JsBeforeCollectCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const JsBackgroundWorkItemCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const JsThreadServiceCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        callback: ?JsBackgroundWorkItemCallback,
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) bool,
    else => *const fn (
        callback: ?JsBackgroundWorkItemCallback,
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) bool,
};

pub const JsValueType = enum(i32) {
    Undefined = 0,
    Null = 1,
    Number = 2,
    String = 3,
    Boolean = 4,
    Object = 5,
    Function = 6,
    Error = 7,
    Array = 8,
};
pub const JsUndefined = JsValueType.Undefined;
pub const JsNull = JsValueType.Null;
pub const JsNumber = JsValueType.Number;
pub const JsString = JsValueType.String;
pub const JsBoolean = JsValueType.Boolean;
pub const JsObject = JsValueType.Object;
pub const JsFunction = JsValueType.Function;
pub const JsError = JsValueType.Error;
pub const JsArray = JsValueType.Array;

pub const JsFinalizeCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        data: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        data: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const JsNativeFunction = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        callee: ?*anyopaque,
        isConstructCall: bool,
        arguments: ?*?*anyopaque,
        argumentCount: u16,
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) ?*anyopaque,
    else => *const fn (
        callee: ?*anyopaque,
        isConstructCall: bool,
        arguments: ?*?*anyopaque,
        argumentCount: u16,
        callbackState: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) ?*anyopaque,
};

//--------------------------------------------------------------------------------
// Section: Functions (87)
//--------------------------------------------------------------------------------
pub extern "chakra" fn JsCreateRuntime(
    attributes: JsRuntimeAttributes,
    runtimeVersion: JsRuntimeVersion,
    threadService: ?JsThreadServiceCallback,
    runtime: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCollectGarbage(
    runtime: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsDisposeRuntime(
    runtime: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetRuntimeMemoryUsage(
    runtime: ?*anyopaque,
    memoryUsage: ?*usize,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetRuntimeMemoryLimit(
    runtime: ?*anyopaque,
    memoryLimit: ?*usize,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetRuntimeMemoryLimit(
    runtime: ?*anyopaque,
    memoryLimit: usize,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetRuntimeMemoryAllocationCallback(
    runtime: ?*anyopaque,
    callbackState: ?*anyopaque,
    allocationCallback: ?JsMemoryAllocationCallback,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetRuntimeBeforeCollectCallback(
    runtime: ?*anyopaque,
    callbackState: ?*anyopaque,
    beforeCollectCallback: ?JsBeforeCollectCallback,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsAddRef(
    ref: ?*anyopaque,
    count: ?*u32,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsRelease(
    ref: ?*anyopaque,
    count: ?*u32,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub usingnamespace switch (@import("../zig.zig").arch) {
    .X64, .Arm64 => struct {
        pub extern "chakra" fn JsCreateContext(
            runtime: ?*anyopaque,
            debugApplication: ?*IDebugApplication64,
            newContext: ?*?*anyopaque,
        ) callconv(@import("std").os.windows.WINAPI) JsErrorCode;
    },
    else => struct {},
};

pub extern "chakra" fn JsGetCurrentContext(
    currentContext: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetCurrentContext(
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetRuntime(
    context: ?*anyopaque,
    runtime: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub usingnamespace switch (@import("../zig.zig").arch) {
    .X64, .Arm64 => struct {
        pub extern "chakra" fn JsStartDebugging(
            debugApplication: ?*IDebugApplication64,
        ) callconv(@import("std").os.windows.WINAPI) JsErrorCode;
    },
    else => struct {},
};

pub extern "chakra" fn JsIdle(
    nextIdleTick: ?*u32,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsParseScript(
    script: ?[*:0]const u16,
    sourceContext: usize,
    sourceUrl: ?[*:0]const u16,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsRunScript(
    script: ?[*:0]const u16,
    sourceContext: usize,
    sourceUrl: ?[*:0]const u16,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSerializeScript(
    script: ?[*:0]const u16,
    buffer: ?[*:0]u8,
    bufferSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsParseSerializedScript(
    script: ?[*:0]const u16,
    buffer: ?*u8,
    sourceContext: usize,
    sourceUrl: ?[*:0]const u16,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsRunSerializedScript(
    script: ?[*:0]const u16,
    buffer: ?*u8,
    sourceContext: usize,
    sourceUrl: ?[*:0]const u16,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetPropertyIdFromName(
    name: ?[*:0]const u16,
    propertyId: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetPropertyNameFromId(
    propertyId: ?*anyopaque,
    name: ?*const ?*u16,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetUndefinedValue(
    undefinedValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetNullValue(
    nullValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetTrueValue(
    trueValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetFalseValue(
    falseValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsBoolToBoolean(
    value: u8,
    booleanValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsBooleanToBool(
    value: ?*anyopaque,
    boolValue: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsConvertValueToBoolean(
    value: ?*anyopaque,
    booleanValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetValueType(
    value: ?*anyopaque,
    type: ?*JsValueType,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsDoubleToNumber(
    doubleValue: f64,
    value: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsIntToNumber(
    intValue: i32,
    value: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsNumberToDouble(
    value: ?*anyopaque,
    doubleValue: ?*f64,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsConvertValueToNumber(
    value: ?*anyopaque,
    numberValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetStringLength(
    stringValue: ?*anyopaque,
    length: ?*i32,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsPointerToString(
    stringValue: [*:0]const u16,
    stringLength: usize,
    value: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsStringToPointer(
    value: ?*anyopaque,
    stringValue: ?*const ?*u16,
    stringLength: ?*usize,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsConvertValueToString(
    value: ?*anyopaque,
    stringValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsVariantToValue(
    variant: ?*VARIANT,
    value: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsValueToVariant(
    object: ?*anyopaque,
    variant: ?*VARIANT,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetGlobalObject(
    globalObject: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateObject(
    object: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateExternalObject(
    data: ?*anyopaque,
    finalizeCallback: ?JsFinalizeCallback,
    object: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsConvertValueToObject(
    value: ?*anyopaque,
    object: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetPrototype(
    object: ?*anyopaque,
    prototypeObject: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetPrototype(
    object: ?*anyopaque,
    prototypeObject: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetExtensionAllowed(
    object: ?*anyopaque,
    value: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsPreventExtension(
    object: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetProperty(
    object: ?*anyopaque,
    propertyId: ?*anyopaque,
    value: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetOwnPropertyDescriptor(
    object: ?*anyopaque,
    propertyId: ?*anyopaque,
    propertyDescriptor: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetOwnPropertyNames(
    object: ?*anyopaque,
    propertyNames: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetProperty(
    object: ?*anyopaque,
    propertyId: ?*anyopaque,
    value: ?*anyopaque,
    useStrictRules: u8,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsHasProperty(
    object: ?*anyopaque,
    propertyId: ?*anyopaque,
    hasProperty: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsDeleteProperty(
    object: ?*anyopaque,
    propertyId: ?*anyopaque,
    useStrictRules: u8,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsDefineProperty(
    object: ?*anyopaque,
    propertyId: ?*anyopaque,
    propertyDescriptor: ?*anyopaque,
    result: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsHasIndexedProperty(
    object: ?*anyopaque,
    index: ?*anyopaque,
    result: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetIndexedProperty(
    object: ?*anyopaque,
    index: ?*anyopaque,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetIndexedProperty(
    object: ?*anyopaque,
    index: ?*anyopaque,
    value: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsDeleteIndexedProperty(
    object: ?*anyopaque,
    index: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsEquals(
    object1: ?*anyopaque,
    object2: ?*anyopaque,
    result: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsStrictEquals(
    object1: ?*anyopaque,
    object2: ?*anyopaque,
    result: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsHasExternalData(
    object: ?*anyopaque,
    value: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetExternalData(
    object: ?*anyopaque,
    externalData: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetExternalData(
    object: ?*anyopaque,
    externalData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateArray(
    length: u32,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCallFunction(
    function: ?*anyopaque,
    arguments: [*]?*anyopaque,
    argumentCount: u16,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsConstructObject(
    function: ?*anyopaque,
    arguments: [*]?*anyopaque,
    argumentCount: u16,
    result: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateFunction(
    nativeFunction: ?JsNativeFunction,
    callbackState: ?*anyopaque,
    function: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateError(
    message: ?*anyopaque,
    @"error": ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateRangeError(
    message: ?*anyopaque,
    @"error": ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateReferenceError(
    message: ?*anyopaque,
    @"error": ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateSyntaxError(
    message: ?*anyopaque,
    @"error": ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateTypeError(
    message: ?*anyopaque,
    @"error": ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsCreateURIError(
    message: ?*anyopaque,
    @"error": ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsHasException(
    hasException: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsGetAndClearException(
    exception: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsSetException(
    exception: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsDisableRuntimeExecution(
    runtime: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsEnableRuntimeExecution(
    runtime: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsIsRuntimeExecutionDisabled(
    runtime: ?*anyopaque,
    isDisabled: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsStartProfiling(
    callback: ?*IActiveScriptProfilerCallback,
    eventMask: PROFILER_EVENT_MASK,
    context: u32,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsStopProfiling(
    reason: HRESULT,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsEnumerateHeap(
    enumerator: ?*?*IActiveScriptProfilerHeapEnum,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub extern "chakra" fn JsIsEnumeratingHeap(
    isEnumeratingHeap: ?*bool,
) callconv(@import("std").os.windows.WINAPI) JsErrorCode;

pub usingnamespace switch (@import("../zig.zig").arch) {
    .X86 => struct {
        pub extern "chakra" fn JsCreateContext(
            runtime: ?*anyopaque,
            debugApplication: ?*IDebugApplication32,
            newContext: ?*?*anyopaque,
        ) callconv(@import("std").os.windows.WINAPI) JsErrorCode;
    },
    else => struct {},
};

pub usingnamespace switch (@import("../zig.zig").arch) {
    .X86 => struct {
        pub extern "chakra" fn JsStartDebugging(
            debugApplication: ?*IDebugApplication32,
        ) callconv(@import("std").os.windows.WINAPI) JsErrorCode;
    },
    else => struct {},
};

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const HRESULT = @import("../foundation.zig").HRESULT;
const IActiveScriptProfilerCallback = @import("../system/diagnostics/debug.zig").IActiveScriptProfilerCallback;
const IActiveScriptProfilerHeapEnum = @import("../system/diagnostics/debug.zig").IActiveScriptProfilerHeapEnum;
const PROFILER_EVENT_MASK = @import("../system/diagnostics/debug.zig").PROFILER_EVENT_MASK;
const PWSTR = @import("../foundation.zig").PWSTR;
const VARIANT = @import("../system/com.zig").VARIANT;
// 2 arch-specific imports
const IDebugApplication32 = switch (@import("../zig.zig").arch) {
    .X86 => @import("../system/diagnostics/debug.zig").IDebugApplication32,
    else => usize, // NOTE: this should be a @compileError but can't because of https://github.com/ziglang/zig/issues/9682
};
const IDebugApplication64 = switch (@import("../zig.zig").arch) {
    .X64, .Arm64 => @import("../system/diagnostics/debug.zig").IDebugApplication64,
    else => usize, // NOTE: this should be a @compileError but can't because of https://github.com/ziglang/zig/issues/9682
};

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "JsMemoryAllocationCallback")) {
        _ = JsMemoryAllocationCallback;
    }
    if (@hasDecl(@This(), "JsBeforeCollectCallback")) {
        _ = JsBeforeCollectCallback;
    }
    if (@hasDecl(@This(), "JsBackgroundWorkItemCallback")) {
        _ = JsBackgroundWorkItemCallback;
    }
    if (@hasDecl(@This(), "JsThreadServiceCallback")) {
        _ = JsThreadServiceCallback;
    }
    if (@hasDecl(@This(), "JsFinalizeCallback")) {
        _ = JsFinalizeCallback;
    }
    if (@hasDecl(@This(), "JsNativeFunction")) {
        _ = JsNativeFunction;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
