//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (24)
//--------------------------------------------------------------------------------
pub const HVSOCKET_CONNECT_TIMEOUT = @as(u32, 1);
pub const HVSOCKET_CONNECT_TIMEOUT_MAX = @as(u32, 300000);
pub const HVSOCKET_CONTAINER_PASSTHRU = @as(u32, 2);
pub const HVSOCKET_CONNECTED_SUSPEND = @as(u32, 4);
pub const HV_PROTOCOL_RAW = @as(u32, 1);
pub const HVSOCKET_ADDRESS_FLAG_PASSTHRU = @as(u32, 1);
pub const WHV_PROCESSOR_FEATURES_BANKS_COUNT = @as(u32, 2);
pub const WHV_SYNTHETIC_PROCESSOR_FEATURES_BANKS_COUNT = @as(u32, 1);
pub const WHV_READ_WRITE_GPA_RANGE_MAX_SIZE = @as(u32, 16);
pub const WHV_HYPERCALL_CONTEXT_MAX_XMM_REGISTERS = @as(u32, 6);
pub const WHV_MAX_DEVICE_ID_SIZE_IN_CHARS = @as(u32, 200);
pub const WHV_VPCI_TYPE0_BAR_COUNT = @as(u32, 6);
pub const WHV_ANY_VP = @as(u32, 4294967295);
pub const WHV_SYNIC_MESSAGE_SIZE = @as(u32, 256);
pub const IOCTL_VMGENCOUNTER_READ = @as(u32, 3325956);
pub const HDV_PCI_BAR_COUNT = @as(u32, 6);
pub const HV_GUID_ZERO = Guid.initString("00000000-0000-0000-0000-000000000000");
pub const HV_GUID_BROADCAST = Guid.initString("ffffffff-ffff-ffff-ffff-ffffffffffff");
pub const HV_GUID_CHILDREN = Guid.initString("90db8b89-0d35-4f79-8ce9-49ea0ac8b7cd");
pub const HV_GUID_LOOPBACK = Guid.initString("e0e16197-dd56-4a10-9195-5ee7a155a838");
pub const HV_GUID_PARENT = Guid.initString("a42e7cda-d03f-480c-9cc2-a4de20abb878");
pub const HV_GUID_SILOHOST = Guid.initString("36bd0c5c-7276-4223-88ba-7d03b654c568");
pub const HV_GUID_VSOCK_TEMPLATE = Guid.initString("00000000-facb-11e6-bd58-64006a7986d3");
pub const GUID_DEVINTERFACE_VM_GENCOUNTER = Guid.initString("3ff2c92b-6598-4e60-8e1c-0ccf4927e319");

//--------------------------------------------------------------------------------
// Section: Types (162)
//--------------------------------------------------------------------------------
// TODO: this type has a FreeFunc 'WHvDeletePartition', what can Zig do with this information?
pub const WHV_PARTITION_HANDLE = isize;

pub const WHV_CAPABILITY_CODE = enum(i32) {
    HypervisorPresent = 0,
    Features = 1,
    ExtendedVmExits = 2,
    ExceptionExitBitmap = 3,
    X64MsrExitBitmap = 4,
    GpaRangePopulateFlags = 5,
    SchedulerFeatures = 6,
    ProcessorVendor = 4096,
    ProcessorFeatures = 4097,
    ProcessorClFlushSize = 4098,
    ProcessorXsaveFeatures = 4099,
    ProcessorClockFrequency = 4100,
    InterruptClockFrequency = 4101,
    ProcessorFeaturesBanks = 4102,
    ProcessorFrequencyCap = 4103,
    SyntheticProcessorFeaturesBanks = 4104,
    ProcessorPerfmonFeatures = 4105,
};
pub const WHvCapabilityCodeHypervisorPresent = WHV_CAPABILITY_CODE.HypervisorPresent;
pub const WHvCapabilityCodeFeatures = WHV_CAPABILITY_CODE.Features;
pub const WHvCapabilityCodeExtendedVmExits = WHV_CAPABILITY_CODE.ExtendedVmExits;
pub const WHvCapabilityCodeExceptionExitBitmap = WHV_CAPABILITY_CODE.ExceptionExitBitmap;
pub const WHvCapabilityCodeX64MsrExitBitmap = WHV_CAPABILITY_CODE.X64MsrExitBitmap;
pub const WHvCapabilityCodeGpaRangePopulateFlags = WHV_CAPABILITY_CODE.GpaRangePopulateFlags;
pub const WHvCapabilityCodeSchedulerFeatures = WHV_CAPABILITY_CODE.SchedulerFeatures;
pub const WHvCapabilityCodeProcessorVendor = WHV_CAPABILITY_CODE.ProcessorVendor;
pub const WHvCapabilityCodeProcessorFeatures = WHV_CAPABILITY_CODE.ProcessorFeatures;
pub const WHvCapabilityCodeProcessorClFlushSize = WHV_CAPABILITY_CODE.ProcessorClFlushSize;
pub const WHvCapabilityCodeProcessorXsaveFeatures = WHV_CAPABILITY_CODE.ProcessorXsaveFeatures;
pub const WHvCapabilityCodeProcessorClockFrequency = WHV_CAPABILITY_CODE.ProcessorClockFrequency;
pub const WHvCapabilityCodeInterruptClockFrequency = WHV_CAPABILITY_CODE.InterruptClockFrequency;
pub const WHvCapabilityCodeProcessorFeaturesBanks = WHV_CAPABILITY_CODE.ProcessorFeaturesBanks;
pub const WHvCapabilityCodeProcessorFrequencyCap = WHV_CAPABILITY_CODE.ProcessorFrequencyCap;
pub const WHvCapabilityCodeSyntheticProcessorFeaturesBanks = WHV_CAPABILITY_CODE.SyntheticProcessorFeaturesBanks;
pub const WHvCapabilityCodeProcessorPerfmonFeatures = WHV_CAPABILITY_CODE.ProcessorPerfmonFeatures;

pub const WHV_CAPABILITY_FEATURES = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_EXTENDED_VM_EXITS = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_PROCESSOR_VENDOR = enum(i32) {
    Amd = 0,
    Intel = 1,
    Hygon = 2,
};
pub const WHvProcessorVendorAmd = WHV_PROCESSOR_VENDOR.Amd;
pub const WHvProcessorVendorIntel = WHV_PROCESSOR_VENDOR.Intel;
pub const WHvProcessorVendorHygon = WHV_PROCESSOR_VENDOR.Hygon;

pub const WHV_PROCESSOR_FEATURES = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_PROCESSOR_FEATURES1 = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_PROCESSOR_FEATURES_BANKS = extern struct {
    BanksCount: u32,
    Reserved0: u32,
    Anonymous: extern union {
        Anonymous: extern struct {
            Bank0: WHV_PROCESSOR_FEATURES,
            Bank1: WHV_PROCESSOR_FEATURES1,
        },
        AsUINT64: [2]u64,
    },
};

pub const WHV_SYNTHETIC_PROCESSOR_FEATURES = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_SYNTHETIC_PROCESSOR_FEATURES_BANKS = extern struct {
    BanksCount: u32,
    Reserved0: u32,
    Anonymous: extern union {
        Anonymous: extern struct {
            Bank0: WHV_SYNTHETIC_PROCESSOR_FEATURES,
        },
        AsUINT64: [1]u64,
    },
};

pub const WHV_PARTITION_PROPERTY_CODE = enum(i32) {
    ExtendedVmExits = 1,
    ExceptionExitBitmap = 2,
    SeparateSecurityDomain = 3,
    NestedVirtualization = 4,
    X64MsrExitBitmap = 5,
    PrimaryNumaNode = 6,
    CpuReserve = 7,
    CpuCap = 8,
    CpuWeight = 9,
    CpuGroupId = 10,
    ProcessorFrequencyCap = 11,
    AllowDeviceAssignment = 12,
    DisableSmt = 13,
    ProcessorFeatures = 4097,
    ProcessorClFlushSize = 4098,
    CpuidExitList = 4099,
    CpuidResultList = 4100,
    LocalApicEmulationMode = 4101,
    ProcessorXsaveFeatures = 4102,
    ProcessorClockFrequency = 4103,
    InterruptClockFrequency = 4104,
    ApicRemoteReadSupport = 4105,
    ProcessorFeaturesBanks = 4106,
    ReferenceTime = 4107,
    SyntheticProcessorFeaturesBanks = 4108,
    CpuidResultList2 = 4109,
    ProcessorPerfmonFeatures = 4110,
    MsrActionList = 4111,
    UnimplementedMsrAction = 4112,
    ProcessorCount = 8191,
};
pub const WHvPartitionPropertyCodeExtendedVmExits = WHV_PARTITION_PROPERTY_CODE.ExtendedVmExits;
pub const WHvPartitionPropertyCodeExceptionExitBitmap = WHV_PARTITION_PROPERTY_CODE.ExceptionExitBitmap;
pub const WHvPartitionPropertyCodeSeparateSecurityDomain = WHV_PARTITION_PROPERTY_CODE.SeparateSecurityDomain;
pub const WHvPartitionPropertyCodeNestedVirtualization = WHV_PARTITION_PROPERTY_CODE.NestedVirtualization;
pub const WHvPartitionPropertyCodeX64MsrExitBitmap = WHV_PARTITION_PROPERTY_CODE.X64MsrExitBitmap;
pub const WHvPartitionPropertyCodePrimaryNumaNode = WHV_PARTITION_PROPERTY_CODE.PrimaryNumaNode;
pub const WHvPartitionPropertyCodeCpuReserve = WHV_PARTITION_PROPERTY_CODE.CpuReserve;
pub const WHvPartitionPropertyCodeCpuCap = WHV_PARTITION_PROPERTY_CODE.CpuCap;
pub const WHvPartitionPropertyCodeCpuWeight = WHV_PARTITION_PROPERTY_CODE.CpuWeight;
pub const WHvPartitionPropertyCodeCpuGroupId = WHV_PARTITION_PROPERTY_CODE.CpuGroupId;
pub const WHvPartitionPropertyCodeProcessorFrequencyCap = WHV_PARTITION_PROPERTY_CODE.ProcessorFrequencyCap;
pub const WHvPartitionPropertyCodeAllowDeviceAssignment = WHV_PARTITION_PROPERTY_CODE.AllowDeviceAssignment;
pub const WHvPartitionPropertyCodeDisableSmt = WHV_PARTITION_PROPERTY_CODE.DisableSmt;
pub const WHvPartitionPropertyCodeProcessorFeatures = WHV_PARTITION_PROPERTY_CODE.ProcessorFeatures;
pub const WHvPartitionPropertyCodeProcessorClFlushSize = WHV_PARTITION_PROPERTY_CODE.ProcessorClFlushSize;
pub const WHvPartitionPropertyCodeCpuidExitList = WHV_PARTITION_PROPERTY_CODE.CpuidExitList;
pub const WHvPartitionPropertyCodeCpuidResultList = WHV_PARTITION_PROPERTY_CODE.CpuidResultList;
pub const WHvPartitionPropertyCodeLocalApicEmulationMode = WHV_PARTITION_PROPERTY_CODE.LocalApicEmulationMode;
pub const WHvPartitionPropertyCodeProcessorXsaveFeatures = WHV_PARTITION_PROPERTY_CODE.ProcessorXsaveFeatures;
pub const WHvPartitionPropertyCodeProcessorClockFrequency = WHV_PARTITION_PROPERTY_CODE.ProcessorClockFrequency;
pub const WHvPartitionPropertyCodeInterruptClockFrequency = WHV_PARTITION_PROPERTY_CODE.InterruptClockFrequency;
pub const WHvPartitionPropertyCodeApicRemoteReadSupport = WHV_PARTITION_PROPERTY_CODE.ApicRemoteReadSupport;
pub const WHvPartitionPropertyCodeProcessorFeaturesBanks = WHV_PARTITION_PROPERTY_CODE.ProcessorFeaturesBanks;
pub const WHvPartitionPropertyCodeReferenceTime = WHV_PARTITION_PROPERTY_CODE.ReferenceTime;
pub const WHvPartitionPropertyCodeSyntheticProcessorFeaturesBanks = WHV_PARTITION_PROPERTY_CODE.SyntheticProcessorFeaturesBanks;
pub const WHvPartitionPropertyCodeCpuidResultList2 = WHV_PARTITION_PROPERTY_CODE.CpuidResultList2;
pub const WHvPartitionPropertyCodeProcessorPerfmonFeatures = WHV_PARTITION_PROPERTY_CODE.ProcessorPerfmonFeatures;
pub const WHvPartitionPropertyCodeMsrActionList = WHV_PARTITION_PROPERTY_CODE.MsrActionList;
pub const WHvPartitionPropertyCodeUnimplementedMsrAction = WHV_PARTITION_PROPERTY_CODE.UnimplementedMsrAction;
pub const WHvPartitionPropertyCodeProcessorCount = WHV_PARTITION_PROPERTY_CODE.ProcessorCount;

pub const WHV_PROCESSOR_XSAVE_FEATURES = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_PROCESSOR_PERFMON_FEATURES = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_X64_MSR_EXIT_BITMAP = extern union {
    AsUINT64: u64,
    Anonymous: extern struct {
        _bitfield: u64,
    },
};

pub const WHV_MEMORY_RANGE_ENTRY = extern struct {
    GuestAddress: u64,
    SizeInBytes: u64,
};

pub const WHV_ADVISE_GPA_RANGE_POPULATE_FLAGS = extern union {
    AsUINT32: u32,
    Anonymous: extern struct {
        _bitfield: u32,
    },
};

pub const WHV_MEMORY_ACCESS_TYPE = enum(i32) {
    Read = 0,
    Write = 1,
    Execute = 2,
};
pub const WHvMemoryAccessRead = WHV_MEMORY_ACCESS_TYPE.Read;
pub const WHvMemoryAccessWrite = WHV_MEMORY_ACCESS_TYPE.Write;
pub const WHvMemoryAccessExecute = WHV_MEMORY_ACCESS_TYPE.Execute;

pub const WHV_ADVISE_GPA_RANGE_POPULATE = extern struct {
    Flags: WHV_ADVISE_GPA_RANGE_POPULATE_FLAGS,
    AccessType: WHV_MEMORY_ACCESS_TYPE,
};

pub const WHV_CAPABILITY_PROCESSOR_FREQUENCY_CAP = extern struct {
    _bitfield: u32,
    HighestFrequencyMhz: u32,
    NominalFrequencyMhz: u32,
    LowestFrequencyMhz: u32,
    FrequencyStepMhz: u32,
};

pub const WHV_SCHEDULER_FEATURES = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_CAPABILITY = extern union {
    HypervisorPresent: BOOL,
    Features: WHV_CAPABILITY_FEATURES,
    ExtendedVmExits: WHV_EXTENDED_VM_EXITS,
    ProcessorVendor: WHV_PROCESSOR_VENDOR,
    ProcessorFeatures: WHV_PROCESSOR_FEATURES,
    SyntheticProcessorFeaturesBanks: WHV_SYNTHETIC_PROCESSOR_FEATURES_BANKS,
    ProcessorXsaveFeatures: WHV_PROCESSOR_XSAVE_FEATURES,
    ProcessorClFlushSize: u8,
    ExceptionExitBitmap: u64,
    X64MsrExitBitmap: WHV_X64_MSR_EXIT_BITMAP,
    ProcessorClockFrequency: u64,
    InterruptClockFrequency: u64,
    ProcessorFeaturesBanks: WHV_PROCESSOR_FEATURES_BANKS,
    GpaRangePopulateFlags: WHV_ADVISE_GPA_RANGE_POPULATE_FLAGS,
    ProcessorFrequencyCap: WHV_CAPABILITY_PROCESSOR_FREQUENCY_CAP,
    ProcessorPerfmonFeatures: WHV_PROCESSOR_PERFMON_FEATURES,
    SchedulerFeatures: WHV_SCHEDULER_FEATURES,
};

pub const WHV_X64_CPUID_RESULT = extern struct {
    Function: u32,
    Reserved: [3]u32,
    Eax: u32,
    Ebx: u32,
    Ecx: u32,
    Edx: u32,
};

pub const WHV_X64_CPUID_RESULT2_FLAGS = enum(u32) {
    SubleafSpecific = 1,
    VpSpecific = 2,
    _,
    pub fn initFlags(o: struct {
        SubleafSpecific: u1 = 0,
        VpSpecific: u1 = 0,
    }) WHV_X64_CPUID_RESULT2_FLAGS {
        return @as(WHV_X64_CPUID_RESULT2_FLAGS, @enumFromInt((if (o.SubleafSpecific == 1) @intFromEnum(WHV_X64_CPUID_RESULT2_FLAGS.SubleafSpecific) else 0) | (if (o.VpSpecific == 1) @intFromEnum(WHV_X64_CPUID_RESULT2_FLAGS.VpSpecific) else 0)));
    }
};
pub const WHvX64CpuidResult2FlagSubleafSpecific = WHV_X64_CPUID_RESULT2_FLAGS.SubleafSpecific;
pub const WHvX64CpuidResult2FlagVpSpecific = WHV_X64_CPUID_RESULT2_FLAGS.VpSpecific;

pub const WHV_CPUID_OUTPUT = extern struct {
    Eax: u32,
    Ebx: u32,
    Ecx: u32,
    Edx: u32,
};

pub const WHV_X64_CPUID_RESULT2 = extern struct {
    Function: u32,
    Index: u32,
    VpIndex: u32,
    Flags: WHV_X64_CPUID_RESULT2_FLAGS,
    Output: WHV_CPUID_OUTPUT,
    Mask: WHV_CPUID_OUTPUT,
};

pub const WHV_MSR_ACTION_ENTRY = extern struct {
    Index: u32,
    ReadAction: u8,
    WriteAction: u8,
    Reserved: u16,
};

pub const WHV_MSR_ACTION = enum(i32) {
    ArchitectureDefault = 0,
    IgnoreWriteReadZero = 1,
    Exit = 2,
};
pub const WHvMsrActionArchitectureDefault = WHV_MSR_ACTION.ArchitectureDefault;
pub const WHvMsrActionIgnoreWriteReadZero = WHV_MSR_ACTION.IgnoreWriteReadZero;
pub const WHvMsrActionExit = WHV_MSR_ACTION.Exit;

pub const WHV_EXCEPTION_TYPE = enum(i32) {
    DivideErrorFault = 0,
    DebugTrapOrFault = 1,
    BreakpointTrap = 3,
    OverflowTrap = 4,
    BoundRangeFault = 5,
    InvalidOpcodeFault = 6,
    DeviceNotAvailableFault = 7,
    DoubleFaultAbort = 8,
    InvalidTaskStateSegmentFault = 10,
    SegmentNotPresentFault = 11,
    StackFault = 12,
    GeneralProtectionFault = 13,
    PageFault = 14,
    FloatingPointErrorFault = 16,
    AlignmentCheckFault = 17,
    MachineCheckAbort = 18,
    SimdFloatingPointFault = 19,
};
pub const WHvX64ExceptionTypeDivideErrorFault = WHV_EXCEPTION_TYPE.DivideErrorFault;
pub const WHvX64ExceptionTypeDebugTrapOrFault = WHV_EXCEPTION_TYPE.DebugTrapOrFault;
pub const WHvX64ExceptionTypeBreakpointTrap = WHV_EXCEPTION_TYPE.BreakpointTrap;
pub const WHvX64ExceptionTypeOverflowTrap = WHV_EXCEPTION_TYPE.OverflowTrap;
pub const WHvX64ExceptionTypeBoundRangeFault = WHV_EXCEPTION_TYPE.BoundRangeFault;
pub const WHvX64ExceptionTypeInvalidOpcodeFault = WHV_EXCEPTION_TYPE.InvalidOpcodeFault;
pub const WHvX64ExceptionTypeDeviceNotAvailableFault = WHV_EXCEPTION_TYPE.DeviceNotAvailableFault;
pub const WHvX64ExceptionTypeDoubleFaultAbort = WHV_EXCEPTION_TYPE.DoubleFaultAbort;
pub const WHvX64ExceptionTypeInvalidTaskStateSegmentFault = WHV_EXCEPTION_TYPE.InvalidTaskStateSegmentFault;
pub const WHvX64ExceptionTypeSegmentNotPresentFault = WHV_EXCEPTION_TYPE.SegmentNotPresentFault;
pub const WHvX64ExceptionTypeStackFault = WHV_EXCEPTION_TYPE.StackFault;
pub const WHvX64ExceptionTypeGeneralProtectionFault = WHV_EXCEPTION_TYPE.GeneralProtectionFault;
pub const WHvX64ExceptionTypePageFault = WHV_EXCEPTION_TYPE.PageFault;
pub const WHvX64ExceptionTypeFloatingPointErrorFault = WHV_EXCEPTION_TYPE.FloatingPointErrorFault;
pub const WHvX64ExceptionTypeAlignmentCheckFault = WHV_EXCEPTION_TYPE.AlignmentCheckFault;
pub const WHvX64ExceptionTypeMachineCheckAbort = WHV_EXCEPTION_TYPE.MachineCheckAbort;
pub const WHvX64ExceptionTypeSimdFloatingPointFault = WHV_EXCEPTION_TYPE.SimdFloatingPointFault;

pub const WHV_X64_LOCAL_APIC_EMULATION_MODE = enum(i32) {
    None = 0,
    XApic = 1,
    X2Apic = 2,
};
pub const WHvX64LocalApicEmulationModeNone = WHV_X64_LOCAL_APIC_EMULATION_MODE.None;
pub const WHvX64LocalApicEmulationModeXApic = WHV_X64_LOCAL_APIC_EMULATION_MODE.XApic;
pub const WHvX64LocalApicEmulationModeX2Apic = WHV_X64_LOCAL_APIC_EMULATION_MODE.X2Apic;

pub const WHV_PARTITION_PROPERTY = extern union {
    ExtendedVmExits: WHV_EXTENDED_VM_EXITS,
    ProcessorFeatures: WHV_PROCESSOR_FEATURES,
    SyntheticProcessorFeaturesBanks: WHV_SYNTHETIC_PROCESSOR_FEATURES_BANKS,
    ProcessorXsaveFeatures: WHV_PROCESSOR_XSAVE_FEATURES,
    ProcessorClFlushSize: u8,
    ProcessorCount: u32,
    CpuidExitList: [1]u32,
    CpuidResultList: [1]WHV_X64_CPUID_RESULT,
    CpuidResultList2: [1]WHV_X64_CPUID_RESULT2,
    MsrActionList: [1]WHV_MSR_ACTION_ENTRY,
    UnimplementedMsrAction: WHV_MSR_ACTION,
    ExceptionExitBitmap: u64,
    LocalApicEmulationMode: WHV_X64_LOCAL_APIC_EMULATION_MODE,
    SeparateSecurityDomain: BOOL,
    NestedVirtualization: BOOL,
    X64MsrExitBitmap: WHV_X64_MSR_EXIT_BITMAP,
    ProcessorClockFrequency: u64,
    InterruptClockFrequency: u64,
    ApicRemoteRead: BOOL,
    ProcessorFeaturesBanks: WHV_PROCESSOR_FEATURES_BANKS,
    ReferenceTime: u64,
    PrimaryNumaNode: u16,
    CpuReserve: u32,
    CpuCap: u32,
    CpuWeight: u32,
    CpuGroupId: u64,
    ProcessorFrequencyCap: u32,
    AllowDeviceAssignment: BOOL,
    ProcessorPerfmonFeatures: WHV_PROCESSOR_PERFMON_FEATURES,
    DisableSmt: BOOL,
};

pub const WHV_MAP_GPA_RANGE_FLAGS = enum(u32) {
    None = 0,
    Read = 1,
    Write = 2,
    Execute = 4,
    TrackDirtyPages = 8,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        Read: u1 = 0,
        Write: u1 = 0,
        Execute: u1 = 0,
        TrackDirtyPages: u1 = 0,
    }) WHV_MAP_GPA_RANGE_FLAGS {
        return @as(WHV_MAP_GPA_RANGE_FLAGS, @enumFromInt((if (o.None == 1) @intFromEnum(WHV_MAP_GPA_RANGE_FLAGS.None) else 0) | (if (o.Read == 1) @intFromEnum(WHV_MAP_GPA_RANGE_FLAGS.Read) else 0) | (if (o.Write == 1) @intFromEnum(WHV_MAP_GPA_RANGE_FLAGS.Write) else 0) | (if (o.Execute == 1) @intFromEnum(WHV_MAP_GPA_RANGE_FLAGS.Execute) else 0) | (if (o.TrackDirtyPages == 1) @intFromEnum(WHV_MAP_GPA_RANGE_FLAGS.TrackDirtyPages) else 0)));
    }
};
pub const WHvMapGpaRangeFlagNone = WHV_MAP_GPA_RANGE_FLAGS.None;
pub const WHvMapGpaRangeFlagRead = WHV_MAP_GPA_RANGE_FLAGS.Read;
pub const WHvMapGpaRangeFlagWrite = WHV_MAP_GPA_RANGE_FLAGS.Write;
pub const WHvMapGpaRangeFlagExecute = WHV_MAP_GPA_RANGE_FLAGS.Execute;
pub const WHvMapGpaRangeFlagTrackDirtyPages = WHV_MAP_GPA_RANGE_FLAGS.TrackDirtyPages;

pub const WHV_TRANSLATE_GVA_FLAGS = enum(u32) {
    None = 0,
    ValidateRead = 1,
    ValidateWrite = 2,
    ValidateExecute = 4,
    PrivilegeExempt = 8,
    SetPageTableBits = 16,
    EnforceSmap = 256,
    OverrideSmap = 512,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        ValidateRead: u1 = 0,
        ValidateWrite: u1 = 0,
        ValidateExecute: u1 = 0,
        PrivilegeExempt: u1 = 0,
        SetPageTableBits: u1 = 0,
        EnforceSmap: u1 = 0,
        OverrideSmap: u1 = 0,
    }) WHV_TRANSLATE_GVA_FLAGS {
        return @as(WHV_TRANSLATE_GVA_FLAGS, @enumFromInt((if (o.None == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.None) else 0) | (if (o.ValidateRead == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.ValidateRead) else 0) | (if (o.ValidateWrite == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.ValidateWrite) else 0) | (if (o.ValidateExecute == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.ValidateExecute) else 0) | (if (o.PrivilegeExempt == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.PrivilegeExempt) else 0) | (if (o.SetPageTableBits == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.SetPageTableBits) else 0) | (if (o.EnforceSmap == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.EnforceSmap) else 0) | (if (o.OverrideSmap == 1) @intFromEnum(WHV_TRANSLATE_GVA_FLAGS.OverrideSmap) else 0)));
    }
};
pub const WHvTranslateGvaFlagNone = WHV_TRANSLATE_GVA_FLAGS.None;
pub const WHvTranslateGvaFlagValidateRead = WHV_TRANSLATE_GVA_FLAGS.ValidateRead;
pub const WHvTranslateGvaFlagValidateWrite = WHV_TRANSLATE_GVA_FLAGS.ValidateWrite;
pub const WHvTranslateGvaFlagValidateExecute = WHV_TRANSLATE_GVA_FLAGS.ValidateExecute;
pub const WHvTranslateGvaFlagPrivilegeExempt = WHV_TRANSLATE_GVA_FLAGS.PrivilegeExempt;
pub const WHvTranslateGvaFlagSetPageTableBits = WHV_TRANSLATE_GVA_FLAGS.SetPageTableBits;
pub const WHvTranslateGvaFlagEnforceSmap = WHV_TRANSLATE_GVA_FLAGS.EnforceSmap;
pub const WHvTranslateGvaFlagOverrideSmap = WHV_TRANSLATE_GVA_FLAGS.OverrideSmap;

pub const WHV_TRANSLATE_GVA_RESULT_CODE = enum(i32) {
    Success = 0,
    PageNotPresent = 1,
    PrivilegeViolation = 2,
    InvalidPageTableFlags = 3,
    GpaUnmapped = 4,
    GpaNoReadAccess = 5,
    GpaNoWriteAccess = 6,
    GpaIllegalOverlayAccess = 7,
    Intercept = 8,
};
pub const WHvTranslateGvaResultSuccess = WHV_TRANSLATE_GVA_RESULT_CODE.Success;
pub const WHvTranslateGvaResultPageNotPresent = WHV_TRANSLATE_GVA_RESULT_CODE.PageNotPresent;
pub const WHvTranslateGvaResultPrivilegeViolation = WHV_TRANSLATE_GVA_RESULT_CODE.PrivilegeViolation;
pub const WHvTranslateGvaResultInvalidPageTableFlags = WHV_TRANSLATE_GVA_RESULT_CODE.InvalidPageTableFlags;
pub const WHvTranslateGvaResultGpaUnmapped = WHV_TRANSLATE_GVA_RESULT_CODE.GpaUnmapped;
pub const WHvTranslateGvaResultGpaNoReadAccess = WHV_TRANSLATE_GVA_RESULT_CODE.GpaNoReadAccess;
pub const WHvTranslateGvaResultGpaNoWriteAccess = WHV_TRANSLATE_GVA_RESULT_CODE.GpaNoWriteAccess;
pub const WHvTranslateGvaResultGpaIllegalOverlayAccess = WHV_TRANSLATE_GVA_RESULT_CODE.GpaIllegalOverlayAccess;
pub const WHvTranslateGvaResultIntercept = WHV_TRANSLATE_GVA_RESULT_CODE.Intercept;

pub const WHV_TRANSLATE_GVA_RESULT = extern struct {
    ResultCode: WHV_TRANSLATE_GVA_RESULT_CODE,
    Reserved: u32,
};

pub const WHV_ADVISE_GPA_RANGE = extern union {
    Populate: WHV_ADVISE_GPA_RANGE_POPULATE,
};

pub const WHV_CACHE_TYPE = enum(i32) {
    Uncached = 0,
    WriteCombining = 1,
    WriteThrough = 4,
    WriteProtected = 5,
    WriteBack = 6,
};
pub const WHvCacheTypeUncached = WHV_CACHE_TYPE.Uncached;
pub const WHvCacheTypeWriteCombining = WHV_CACHE_TYPE.WriteCombining;
pub const WHvCacheTypeWriteThrough = WHV_CACHE_TYPE.WriteThrough;
pub const WHvCacheTypeWriteProtected = WHV_CACHE_TYPE.WriteProtected;
pub const WHvCacheTypeWriteBack = WHV_CACHE_TYPE.WriteBack;

pub const WHV_ACCESS_GPA_CONTROLS = extern union {
    AsUINT64: u64,
    Anonymous: extern struct {
        CacheType: WHV_CACHE_TYPE,
        Reserved: u32,
    },
};

pub const WHV_REGISTER_NAME = enum(i32) {
    X64RegisterRax = 0,
    X64RegisterRcx = 1,
    X64RegisterRdx = 2,
    X64RegisterRbx = 3,
    X64RegisterRsp = 4,
    X64RegisterRbp = 5,
    X64RegisterRsi = 6,
    X64RegisterRdi = 7,
    X64RegisterR8 = 8,
    X64RegisterR9 = 9,
    X64RegisterR10 = 10,
    X64RegisterR11 = 11,
    X64RegisterR12 = 12,
    X64RegisterR13 = 13,
    X64RegisterR14 = 14,
    X64RegisterR15 = 15,
    X64RegisterRip = 16,
    X64RegisterRflags = 17,
    X64RegisterEs = 18,
    X64RegisterCs = 19,
    X64RegisterSs = 20,
    X64RegisterDs = 21,
    X64RegisterFs = 22,
    X64RegisterGs = 23,
    X64RegisterLdtr = 24,
    X64RegisterTr = 25,
    X64RegisterIdtr = 26,
    X64RegisterGdtr = 27,
    X64RegisterCr0 = 28,
    X64RegisterCr2 = 29,
    X64RegisterCr3 = 30,
    X64RegisterCr4 = 31,
    X64RegisterCr8 = 32,
    X64RegisterDr0 = 33,
    X64RegisterDr1 = 34,
    X64RegisterDr2 = 35,
    X64RegisterDr3 = 36,
    X64RegisterDr6 = 37,
    X64RegisterDr7 = 38,
    X64RegisterXCr0 = 39,
    X64RegisterVirtualCr0 = 40,
    X64RegisterVirtualCr3 = 41,
    X64RegisterVirtualCr4 = 42,
    X64RegisterVirtualCr8 = 43,
    X64RegisterXmm0 = 4096,
    X64RegisterXmm1 = 4097,
    X64RegisterXmm2 = 4098,
    X64RegisterXmm3 = 4099,
    X64RegisterXmm4 = 4100,
    X64RegisterXmm5 = 4101,
    X64RegisterXmm6 = 4102,
    X64RegisterXmm7 = 4103,
    X64RegisterXmm8 = 4104,
    X64RegisterXmm9 = 4105,
    X64RegisterXmm10 = 4106,
    X64RegisterXmm11 = 4107,
    X64RegisterXmm12 = 4108,
    X64RegisterXmm13 = 4109,
    X64RegisterXmm14 = 4110,
    X64RegisterXmm15 = 4111,
    X64RegisterFpMmx0 = 4112,
    X64RegisterFpMmx1 = 4113,
    X64RegisterFpMmx2 = 4114,
    X64RegisterFpMmx3 = 4115,
    X64RegisterFpMmx4 = 4116,
    X64RegisterFpMmx5 = 4117,
    X64RegisterFpMmx6 = 4118,
    X64RegisterFpMmx7 = 4119,
    X64RegisterFpControlStatus = 4120,
    X64RegisterXmmControlStatus = 4121,
    X64RegisterTsc = 8192,
    X64RegisterEfer = 8193,
    X64RegisterKernelGsBase = 8194,
    X64RegisterApicBase = 8195,
    X64RegisterPat = 8196,
    X64RegisterSysenterCs = 8197,
    X64RegisterSysenterEip = 8198,
    X64RegisterSysenterEsp = 8199,
    X64RegisterStar = 8200,
    X64RegisterLstar = 8201,
    X64RegisterCstar = 8202,
    X64RegisterSfmask = 8203,
    X64RegisterInitialApicId = 8204,
    X64RegisterMsrMtrrCap = 8205,
    X64RegisterMsrMtrrDefType = 8206,
    X64RegisterMsrMtrrPhysBase0 = 8208,
    X64RegisterMsrMtrrPhysBase1 = 8209,
    X64RegisterMsrMtrrPhysBase2 = 8210,
    X64RegisterMsrMtrrPhysBase3 = 8211,
    X64RegisterMsrMtrrPhysBase4 = 8212,
    X64RegisterMsrMtrrPhysBase5 = 8213,
    X64RegisterMsrMtrrPhysBase6 = 8214,
    X64RegisterMsrMtrrPhysBase7 = 8215,
    X64RegisterMsrMtrrPhysBase8 = 8216,
    X64RegisterMsrMtrrPhysBase9 = 8217,
    X64RegisterMsrMtrrPhysBaseA = 8218,
    X64RegisterMsrMtrrPhysBaseB = 8219,
    X64RegisterMsrMtrrPhysBaseC = 8220,
    X64RegisterMsrMtrrPhysBaseD = 8221,
    X64RegisterMsrMtrrPhysBaseE = 8222,
    X64RegisterMsrMtrrPhysBaseF = 8223,
    X64RegisterMsrMtrrPhysMask0 = 8256,
    X64RegisterMsrMtrrPhysMask1 = 8257,
    X64RegisterMsrMtrrPhysMask2 = 8258,
    X64RegisterMsrMtrrPhysMask3 = 8259,
    X64RegisterMsrMtrrPhysMask4 = 8260,
    X64RegisterMsrMtrrPhysMask5 = 8261,
    X64RegisterMsrMtrrPhysMask6 = 8262,
    X64RegisterMsrMtrrPhysMask7 = 8263,
    X64RegisterMsrMtrrPhysMask8 = 8264,
    X64RegisterMsrMtrrPhysMask9 = 8265,
    X64RegisterMsrMtrrPhysMaskA = 8266,
    X64RegisterMsrMtrrPhysMaskB = 8267,
    X64RegisterMsrMtrrPhysMaskC = 8268,
    X64RegisterMsrMtrrPhysMaskD = 8269,
    X64RegisterMsrMtrrPhysMaskE = 8270,
    X64RegisterMsrMtrrPhysMaskF = 8271,
    X64RegisterMsrMtrrFix64k00000 = 8304,
    X64RegisterMsrMtrrFix16k80000 = 8305,
    X64RegisterMsrMtrrFix16kA0000 = 8306,
    X64RegisterMsrMtrrFix4kC0000 = 8307,
    X64RegisterMsrMtrrFix4kC8000 = 8308,
    X64RegisterMsrMtrrFix4kD0000 = 8309,
    X64RegisterMsrMtrrFix4kD8000 = 8310,
    X64RegisterMsrMtrrFix4kE0000 = 8311,
    X64RegisterMsrMtrrFix4kE8000 = 8312,
    X64RegisterMsrMtrrFix4kF0000 = 8313,
    X64RegisterMsrMtrrFix4kF8000 = 8314,
    X64RegisterTscAux = 8315,
    X64RegisterBndcfgs = 8316,
    X64RegisterMCount = 8318,
    X64RegisterACount = 8319,
    X64RegisterSpecCtrl = 8324,
    X64RegisterPredCmd = 8325,
    X64RegisterTscVirtualOffset = 8327,
    X64RegisterTsxCtrl = 8328,
    X64RegisterXss = 8331,
    X64RegisterUCet = 8332,
    X64RegisterSCet = 8333,
    X64RegisterSsp = 8334,
    X64RegisterPl0Ssp = 8335,
    X64RegisterPl1Ssp = 8336,
    X64RegisterPl2Ssp = 8337,
    X64RegisterPl3Ssp = 8338,
    X64RegisterInterruptSspTableAddr = 8339,
    X64RegisterTscDeadline = 8341,
    X64RegisterTscAdjust = 8342,
    X64RegisterUmwaitControl = 8344,
    X64RegisterXfd = 8345,
    X64RegisterXfdErr = 8346,
    X64RegisterApicId = 12290,
    X64RegisterApicVersion = 12291,
    X64RegisterApicTpr = 12296,
    X64RegisterApicPpr = 12298,
    X64RegisterApicEoi = 12299,
    X64RegisterApicLdr = 12301,
    X64RegisterApicSpurious = 12303,
    X64RegisterApicIsr0 = 12304,
    X64RegisterApicIsr1 = 12305,
    X64RegisterApicIsr2 = 12306,
    X64RegisterApicIsr3 = 12307,
    X64RegisterApicIsr4 = 12308,
    X64RegisterApicIsr5 = 12309,
    X64RegisterApicIsr6 = 12310,
    X64RegisterApicIsr7 = 12311,
    X64RegisterApicTmr0 = 12312,
    X64RegisterApicTmr1 = 12313,
    X64RegisterApicTmr2 = 12314,
    X64RegisterApicTmr3 = 12315,
    X64RegisterApicTmr4 = 12316,
    X64RegisterApicTmr5 = 12317,
    X64RegisterApicTmr6 = 12318,
    X64RegisterApicTmr7 = 12319,
    X64RegisterApicIrr0 = 12320,
    X64RegisterApicIrr1 = 12321,
    X64RegisterApicIrr2 = 12322,
    X64RegisterApicIrr3 = 12323,
    X64RegisterApicIrr4 = 12324,
    X64RegisterApicIrr5 = 12325,
    X64RegisterApicIrr6 = 12326,
    X64RegisterApicIrr7 = 12327,
    X64RegisterApicEse = 12328,
    X64RegisterApicIcr = 12336,
    X64RegisterApicLvtTimer = 12338,
    X64RegisterApicLvtThermal = 12339,
    X64RegisterApicLvtPerfmon = 12340,
    X64RegisterApicLvtLint0 = 12341,
    X64RegisterApicLvtLint1 = 12342,
    X64RegisterApicLvtError = 12343,
    X64RegisterApicInitCount = 12344,
    X64RegisterApicCurrentCount = 12345,
    X64RegisterApicDivide = 12350,
    X64RegisterApicSelfIpi = 12351,
    RegisterSint0 = 16384,
    RegisterSint1 = 16385,
    RegisterSint2 = 16386,
    RegisterSint3 = 16387,
    RegisterSint4 = 16388,
    RegisterSint5 = 16389,
    RegisterSint6 = 16390,
    RegisterSint7 = 16391,
    RegisterSint8 = 16392,
    RegisterSint9 = 16393,
    RegisterSint10 = 16394,
    RegisterSint11 = 16395,
    RegisterSint12 = 16396,
    RegisterSint13 = 16397,
    RegisterSint14 = 16398,
    RegisterSint15 = 16399,
    RegisterScontrol = 16400,
    RegisterSversion = 16401,
    RegisterSiefp = 16402,
    RegisterSimp = 16403,
    RegisterEom = 16404,
    RegisterVpRuntime = 20480,
    X64RegisterHypercall = 20481,
    RegisterGuestOsId = 20482,
    RegisterVpAssistPage = 20499,
    RegisterReferenceTsc = 20503,
    RegisterReferenceTscSequence = 20506,
    RegisterPendingInterruption = -2147483648,
    RegisterInterruptState = -2147483647,
    RegisterPendingEvent = -2147483646,
    X64RegisterDeliverabilityNotifications = -2147483644,
    RegisterInternalActivityState = -2147483643,
    X64RegisterPendingDebugException = -2147483642,
};
pub const WHvX64RegisterRax = WHV_REGISTER_NAME.X64RegisterRax;
pub const WHvX64RegisterRcx = WHV_REGISTER_NAME.X64RegisterRcx;
pub const WHvX64RegisterRdx = WHV_REGISTER_NAME.X64RegisterRdx;
pub const WHvX64RegisterRbx = WHV_REGISTER_NAME.X64RegisterRbx;
pub const WHvX64RegisterRsp = WHV_REGISTER_NAME.X64RegisterRsp;
pub const WHvX64RegisterRbp = WHV_REGISTER_NAME.X64RegisterRbp;
pub const WHvX64RegisterRsi = WHV_REGISTER_NAME.X64RegisterRsi;
pub const WHvX64RegisterRdi = WHV_REGISTER_NAME.X64RegisterRdi;
pub const WHvX64RegisterR8 = WHV_REGISTER_NAME.X64RegisterR8;
pub const WHvX64RegisterR9 = WHV_REGISTER_NAME.X64RegisterR9;
pub const WHvX64RegisterR10 = WHV_REGISTER_NAME.X64RegisterR10;
pub const WHvX64RegisterR11 = WHV_REGISTER_NAME.X64RegisterR11;
pub const WHvX64RegisterR12 = WHV_REGISTER_NAME.X64RegisterR12;
pub const WHvX64RegisterR13 = WHV_REGISTER_NAME.X64RegisterR13;
pub const WHvX64RegisterR14 = WHV_REGISTER_NAME.X64RegisterR14;
pub const WHvX64RegisterR15 = WHV_REGISTER_NAME.X64RegisterR15;
pub const WHvX64RegisterRip = WHV_REGISTER_NAME.X64RegisterRip;
pub const WHvX64RegisterRflags = WHV_REGISTER_NAME.X64RegisterRflags;
pub const WHvX64RegisterEs = WHV_REGISTER_NAME.X64RegisterEs;
pub const WHvX64RegisterCs = WHV_REGISTER_NAME.X64RegisterCs;
pub const WHvX64RegisterSs = WHV_REGISTER_NAME.X64RegisterSs;
pub const WHvX64RegisterDs = WHV_REGISTER_NAME.X64RegisterDs;
pub const WHvX64RegisterFs = WHV_REGISTER_NAME.X64RegisterFs;
pub const WHvX64RegisterGs = WHV_REGISTER_NAME.X64RegisterGs;
pub const WHvX64RegisterLdtr = WHV_REGISTER_NAME.X64RegisterLdtr;
pub const WHvX64RegisterTr = WHV_REGISTER_NAME.X64RegisterTr;
pub const WHvX64RegisterIdtr = WHV_REGISTER_NAME.X64RegisterIdtr;
pub const WHvX64RegisterGdtr = WHV_REGISTER_NAME.X64RegisterGdtr;
pub const WHvX64RegisterCr0 = WHV_REGISTER_NAME.X64RegisterCr0;
pub const WHvX64RegisterCr2 = WHV_REGISTER_NAME.X64RegisterCr2;
pub const WHvX64RegisterCr3 = WHV_REGISTER_NAME.X64RegisterCr3;
pub const WHvX64RegisterCr4 = WHV_REGISTER_NAME.X64RegisterCr4;
pub const WHvX64RegisterCr8 = WHV_REGISTER_NAME.X64RegisterCr8;
pub const WHvX64RegisterDr0 = WHV_REGISTER_NAME.X64RegisterDr0;
pub const WHvX64RegisterDr1 = WHV_REGISTER_NAME.X64RegisterDr1;
pub const WHvX64RegisterDr2 = WHV_REGISTER_NAME.X64RegisterDr2;
pub const WHvX64RegisterDr3 = WHV_REGISTER_NAME.X64RegisterDr3;
pub const WHvX64RegisterDr6 = WHV_REGISTER_NAME.X64RegisterDr6;
pub const WHvX64RegisterDr7 = WHV_REGISTER_NAME.X64RegisterDr7;
pub const WHvX64RegisterXCr0 = WHV_REGISTER_NAME.X64RegisterXCr0;
pub const WHvX64RegisterVirtualCr0 = WHV_REGISTER_NAME.X64RegisterVirtualCr0;
pub const WHvX64RegisterVirtualCr3 = WHV_REGISTER_NAME.X64RegisterVirtualCr3;
pub const WHvX64RegisterVirtualCr4 = WHV_REGISTER_NAME.X64RegisterVirtualCr4;
pub const WHvX64RegisterVirtualCr8 = WHV_REGISTER_NAME.X64RegisterVirtualCr8;
pub const WHvX64RegisterXmm0 = WHV_REGISTER_NAME.X64RegisterXmm0;
pub const WHvX64RegisterXmm1 = WHV_REGISTER_NAME.X64RegisterXmm1;
pub const WHvX64RegisterXmm2 = WHV_REGISTER_NAME.X64RegisterXmm2;
pub const WHvX64RegisterXmm3 = WHV_REGISTER_NAME.X64RegisterXmm3;
pub const WHvX64RegisterXmm4 = WHV_REGISTER_NAME.X64RegisterXmm4;
pub const WHvX64RegisterXmm5 = WHV_REGISTER_NAME.X64RegisterXmm5;
pub const WHvX64RegisterXmm6 = WHV_REGISTER_NAME.X64RegisterXmm6;
pub const WHvX64RegisterXmm7 = WHV_REGISTER_NAME.X64RegisterXmm7;
pub const WHvX64RegisterXmm8 = WHV_REGISTER_NAME.X64RegisterXmm8;
pub const WHvX64RegisterXmm9 = WHV_REGISTER_NAME.X64RegisterXmm9;
pub const WHvX64RegisterXmm10 = WHV_REGISTER_NAME.X64RegisterXmm10;
pub const WHvX64RegisterXmm11 = WHV_REGISTER_NAME.X64RegisterXmm11;
pub const WHvX64RegisterXmm12 = WHV_REGISTER_NAME.X64RegisterXmm12;
pub const WHvX64RegisterXmm13 = WHV_REGISTER_NAME.X64RegisterXmm13;
pub const WHvX64RegisterXmm14 = WHV_REGISTER_NAME.X64RegisterXmm14;
pub const WHvX64RegisterXmm15 = WHV_REGISTER_NAME.X64RegisterXmm15;
pub const WHvX64RegisterFpMmx0 = WHV_REGISTER_NAME.X64RegisterFpMmx0;
pub const WHvX64RegisterFpMmx1 = WHV_REGISTER_NAME.X64RegisterFpMmx1;
pub const WHvX64RegisterFpMmx2 = WHV_REGISTER_NAME.X64RegisterFpMmx2;
pub const WHvX64RegisterFpMmx3 = WHV_REGISTER_NAME.X64RegisterFpMmx3;
pub const WHvX64RegisterFpMmx4 = WHV_REGISTER_NAME.X64RegisterFpMmx4;
pub const WHvX64RegisterFpMmx5 = WHV_REGISTER_NAME.X64RegisterFpMmx5;
pub const WHvX64RegisterFpMmx6 = WHV_REGISTER_NAME.X64RegisterFpMmx6;
pub const WHvX64RegisterFpMmx7 = WHV_REGISTER_NAME.X64RegisterFpMmx7;
pub const WHvX64RegisterFpControlStatus = WHV_REGISTER_NAME.X64RegisterFpControlStatus;
pub const WHvX64RegisterXmmControlStatus = WHV_REGISTER_NAME.X64RegisterXmmControlStatus;
pub const WHvX64RegisterTsc = WHV_REGISTER_NAME.X64RegisterTsc;
pub const WHvX64RegisterEfer = WHV_REGISTER_NAME.X64RegisterEfer;
pub const WHvX64RegisterKernelGsBase = WHV_REGISTER_NAME.X64RegisterKernelGsBase;
pub const WHvX64RegisterApicBase = WHV_REGISTER_NAME.X64RegisterApicBase;
pub const WHvX64RegisterPat = WHV_REGISTER_NAME.X64RegisterPat;
pub const WHvX64RegisterSysenterCs = WHV_REGISTER_NAME.X64RegisterSysenterCs;
pub const WHvX64RegisterSysenterEip = WHV_REGISTER_NAME.X64RegisterSysenterEip;
pub const WHvX64RegisterSysenterEsp = WHV_REGISTER_NAME.X64RegisterSysenterEsp;
pub const WHvX64RegisterStar = WHV_REGISTER_NAME.X64RegisterStar;
pub const WHvX64RegisterLstar = WHV_REGISTER_NAME.X64RegisterLstar;
pub const WHvX64RegisterCstar = WHV_REGISTER_NAME.X64RegisterCstar;
pub const WHvX64RegisterSfmask = WHV_REGISTER_NAME.X64RegisterSfmask;
pub const WHvX64RegisterInitialApicId = WHV_REGISTER_NAME.X64RegisterInitialApicId;
pub const WHvX64RegisterMsrMtrrCap = WHV_REGISTER_NAME.X64RegisterMsrMtrrCap;
pub const WHvX64RegisterMsrMtrrDefType = WHV_REGISTER_NAME.X64RegisterMsrMtrrDefType;
pub const WHvX64RegisterMsrMtrrPhysBase0 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase0;
pub const WHvX64RegisterMsrMtrrPhysBase1 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase1;
pub const WHvX64RegisterMsrMtrrPhysBase2 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase2;
pub const WHvX64RegisterMsrMtrrPhysBase3 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase3;
pub const WHvX64RegisterMsrMtrrPhysBase4 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase4;
pub const WHvX64RegisterMsrMtrrPhysBase5 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase5;
pub const WHvX64RegisterMsrMtrrPhysBase6 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase6;
pub const WHvX64RegisterMsrMtrrPhysBase7 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase7;
pub const WHvX64RegisterMsrMtrrPhysBase8 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase8;
pub const WHvX64RegisterMsrMtrrPhysBase9 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBase9;
pub const WHvX64RegisterMsrMtrrPhysBaseA = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBaseA;
pub const WHvX64RegisterMsrMtrrPhysBaseB = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBaseB;
pub const WHvX64RegisterMsrMtrrPhysBaseC = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBaseC;
pub const WHvX64RegisterMsrMtrrPhysBaseD = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBaseD;
pub const WHvX64RegisterMsrMtrrPhysBaseE = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBaseE;
pub const WHvX64RegisterMsrMtrrPhysBaseF = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysBaseF;
pub const WHvX64RegisterMsrMtrrPhysMask0 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask0;
pub const WHvX64RegisterMsrMtrrPhysMask1 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask1;
pub const WHvX64RegisterMsrMtrrPhysMask2 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask2;
pub const WHvX64RegisterMsrMtrrPhysMask3 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask3;
pub const WHvX64RegisterMsrMtrrPhysMask4 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask4;
pub const WHvX64RegisterMsrMtrrPhysMask5 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask5;
pub const WHvX64RegisterMsrMtrrPhysMask6 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask6;
pub const WHvX64RegisterMsrMtrrPhysMask7 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask7;
pub const WHvX64RegisterMsrMtrrPhysMask8 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask8;
pub const WHvX64RegisterMsrMtrrPhysMask9 = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMask9;
pub const WHvX64RegisterMsrMtrrPhysMaskA = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMaskA;
pub const WHvX64RegisterMsrMtrrPhysMaskB = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMaskB;
pub const WHvX64RegisterMsrMtrrPhysMaskC = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMaskC;
pub const WHvX64RegisterMsrMtrrPhysMaskD = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMaskD;
pub const WHvX64RegisterMsrMtrrPhysMaskE = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMaskE;
pub const WHvX64RegisterMsrMtrrPhysMaskF = WHV_REGISTER_NAME.X64RegisterMsrMtrrPhysMaskF;
pub const WHvX64RegisterMsrMtrrFix64k00000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix64k00000;
pub const WHvX64RegisterMsrMtrrFix16k80000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix16k80000;
pub const WHvX64RegisterMsrMtrrFix16kA0000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix16kA0000;
pub const WHvX64RegisterMsrMtrrFix4kC0000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kC0000;
pub const WHvX64RegisterMsrMtrrFix4kC8000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kC8000;
pub const WHvX64RegisterMsrMtrrFix4kD0000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kD0000;
pub const WHvX64RegisterMsrMtrrFix4kD8000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kD8000;
pub const WHvX64RegisterMsrMtrrFix4kE0000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kE0000;
pub const WHvX64RegisterMsrMtrrFix4kE8000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kE8000;
pub const WHvX64RegisterMsrMtrrFix4kF0000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kF0000;
pub const WHvX64RegisterMsrMtrrFix4kF8000 = WHV_REGISTER_NAME.X64RegisterMsrMtrrFix4kF8000;
pub const WHvX64RegisterTscAux = WHV_REGISTER_NAME.X64RegisterTscAux;
pub const WHvX64RegisterBndcfgs = WHV_REGISTER_NAME.X64RegisterBndcfgs;
pub const WHvX64RegisterMCount = WHV_REGISTER_NAME.X64RegisterMCount;
pub const WHvX64RegisterACount = WHV_REGISTER_NAME.X64RegisterACount;
pub const WHvX64RegisterSpecCtrl = WHV_REGISTER_NAME.X64RegisterSpecCtrl;
pub const WHvX64RegisterPredCmd = WHV_REGISTER_NAME.X64RegisterPredCmd;
pub const WHvX64RegisterTscVirtualOffset = WHV_REGISTER_NAME.X64RegisterTscVirtualOffset;
pub const WHvX64RegisterTsxCtrl = WHV_REGISTER_NAME.X64RegisterTsxCtrl;
pub const WHvX64RegisterXss = WHV_REGISTER_NAME.X64RegisterXss;
pub const WHvX64RegisterUCet = WHV_REGISTER_NAME.X64RegisterUCet;
pub const WHvX64RegisterSCet = WHV_REGISTER_NAME.X64RegisterSCet;
pub const WHvX64RegisterSsp = WHV_REGISTER_NAME.X64RegisterSsp;
pub const WHvX64RegisterPl0Ssp = WHV_REGISTER_NAME.X64RegisterPl0Ssp;
pub const WHvX64RegisterPl1Ssp = WHV_REGISTER_NAME.X64RegisterPl1Ssp;
pub const WHvX64RegisterPl2Ssp = WHV_REGISTER_NAME.X64RegisterPl2Ssp;
pub const WHvX64RegisterPl3Ssp = WHV_REGISTER_NAME.X64RegisterPl3Ssp;
pub const WHvX64RegisterInterruptSspTableAddr = WHV_REGISTER_NAME.X64RegisterInterruptSspTableAddr;
pub const WHvX64RegisterTscDeadline = WHV_REGISTER_NAME.X64RegisterTscDeadline;
pub const WHvX64RegisterTscAdjust = WHV_REGISTER_NAME.X64RegisterTscAdjust;
pub const WHvX64RegisterUmwaitControl = WHV_REGISTER_NAME.X64RegisterUmwaitControl;
pub const WHvX64RegisterXfd = WHV_REGISTER_NAME.X64RegisterXfd;
pub const WHvX64RegisterXfdErr = WHV_REGISTER_NAME.X64RegisterXfdErr;
pub const WHvX64RegisterApicId = WHV_REGISTER_NAME.X64RegisterApicId;
pub const WHvX64RegisterApicVersion = WHV_REGISTER_NAME.X64RegisterApicVersion;
pub const WHvX64RegisterApicTpr = WHV_REGISTER_NAME.X64RegisterApicTpr;
pub const WHvX64RegisterApicPpr = WHV_REGISTER_NAME.X64RegisterApicPpr;
pub const WHvX64RegisterApicEoi = WHV_REGISTER_NAME.X64RegisterApicEoi;
pub const WHvX64RegisterApicLdr = WHV_REGISTER_NAME.X64RegisterApicLdr;
pub const WHvX64RegisterApicSpurious = WHV_REGISTER_NAME.X64RegisterApicSpurious;
pub const WHvX64RegisterApicIsr0 = WHV_REGISTER_NAME.X64RegisterApicIsr0;
pub const WHvX64RegisterApicIsr1 = WHV_REGISTER_NAME.X64RegisterApicIsr1;
pub const WHvX64RegisterApicIsr2 = WHV_REGISTER_NAME.X64RegisterApicIsr2;
pub const WHvX64RegisterApicIsr3 = WHV_REGISTER_NAME.X64RegisterApicIsr3;
pub const WHvX64RegisterApicIsr4 = WHV_REGISTER_NAME.X64RegisterApicIsr4;
pub const WHvX64RegisterApicIsr5 = WHV_REGISTER_NAME.X64RegisterApicIsr5;
pub const WHvX64RegisterApicIsr6 = WHV_REGISTER_NAME.X64RegisterApicIsr6;
pub const WHvX64RegisterApicIsr7 = WHV_REGISTER_NAME.X64RegisterApicIsr7;
pub const WHvX64RegisterApicTmr0 = WHV_REGISTER_NAME.X64RegisterApicTmr0;
pub const WHvX64RegisterApicTmr1 = WHV_REGISTER_NAME.X64RegisterApicTmr1;
pub const WHvX64RegisterApicTmr2 = WHV_REGISTER_NAME.X64RegisterApicTmr2;
pub const WHvX64RegisterApicTmr3 = WHV_REGISTER_NAME.X64RegisterApicTmr3;
pub const WHvX64RegisterApicTmr4 = WHV_REGISTER_NAME.X64RegisterApicTmr4;
pub const WHvX64RegisterApicTmr5 = WHV_REGISTER_NAME.X64RegisterApicTmr5;
pub const WHvX64RegisterApicTmr6 = WHV_REGISTER_NAME.X64RegisterApicTmr6;
pub const WHvX64RegisterApicTmr7 = WHV_REGISTER_NAME.X64RegisterApicTmr7;
pub const WHvX64RegisterApicIrr0 = WHV_REGISTER_NAME.X64RegisterApicIrr0;
pub const WHvX64RegisterApicIrr1 = WHV_REGISTER_NAME.X64RegisterApicIrr1;
pub const WHvX64RegisterApicIrr2 = WHV_REGISTER_NAME.X64RegisterApicIrr2;
pub const WHvX64RegisterApicIrr3 = WHV_REGISTER_NAME.X64RegisterApicIrr3;
pub const WHvX64RegisterApicIrr4 = WHV_REGISTER_NAME.X64RegisterApicIrr4;
pub const WHvX64RegisterApicIrr5 = WHV_REGISTER_NAME.X64RegisterApicIrr5;
pub const WHvX64RegisterApicIrr6 = WHV_REGISTER_NAME.X64RegisterApicIrr6;
pub const WHvX64RegisterApicIrr7 = WHV_REGISTER_NAME.X64RegisterApicIrr7;
pub const WHvX64RegisterApicEse = WHV_REGISTER_NAME.X64RegisterApicEse;
pub const WHvX64RegisterApicIcr = WHV_REGISTER_NAME.X64RegisterApicIcr;
pub const WHvX64RegisterApicLvtTimer = WHV_REGISTER_NAME.X64RegisterApicLvtTimer;
pub const WHvX64RegisterApicLvtThermal = WHV_REGISTER_NAME.X64RegisterApicLvtThermal;
pub const WHvX64RegisterApicLvtPerfmon = WHV_REGISTER_NAME.X64RegisterApicLvtPerfmon;
pub const WHvX64RegisterApicLvtLint0 = WHV_REGISTER_NAME.X64RegisterApicLvtLint0;
pub const WHvX64RegisterApicLvtLint1 = WHV_REGISTER_NAME.X64RegisterApicLvtLint1;
pub const WHvX64RegisterApicLvtError = WHV_REGISTER_NAME.X64RegisterApicLvtError;
pub const WHvX64RegisterApicInitCount = WHV_REGISTER_NAME.X64RegisterApicInitCount;
pub const WHvX64RegisterApicCurrentCount = WHV_REGISTER_NAME.X64RegisterApicCurrentCount;
pub const WHvX64RegisterApicDivide = WHV_REGISTER_NAME.X64RegisterApicDivide;
pub const WHvX64RegisterApicSelfIpi = WHV_REGISTER_NAME.X64RegisterApicSelfIpi;
pub const WHvRegisterSint0 = WHV_REGISTER_NAME.RegisterSint0;
pub const WHvRegisterSint1 = WHV_REGISTER_NAME.RegisterSint1;
pub const WHvRegisterSint2 = WHV_REGISTER_NAME.RegisterSint2;
pub const WHvRegisterSint3 = WHV_REGISTER_NAME.RegisterSint3;
pub const WHvRegisterSint4 = WHV_REGISTER_NAME.RegisterSint4;
pub const WHvRegisterSint5 = WHV_REGISTER_NAME.RegisterSint5;
pub const WHvRegisterSint6 = WHV_REGISTER_NAME.RegisterSint6;
pub const WHvRegisterSint7 = WHV_REGISTER_NAME.RegisterSint7;
pub const WHvRegisterSint8 = WHV_REGISTER_NAME.RegisterSint8;
pub const WHvRegisterSint9 = WHV_REGISTER_NAME.RegisterSint9;
pub const WHvRegisterSint10 = WHV_REGISTER_NAME.RegisterSint10;
pub const WHvRegisterSint11 = WHV_REGISTER_NAME.RegisterSint11;
pub const WHvRegisterSint12 = WHV_REGISTER_NAME.RegisterSint12;
pub const WHvRegisterSint13 = WHV_REGISTER_NAME.RegisterSint13;
pub const WHvRegisterSint14 = WHV_REGISTER_NAME.RegisterSint14;
pub const WHvRegisterSint15 = WHV_REGISTER_NAME.RegisterSint15;
pub const WHvRegisterScontrol = WHV_REGISTER_NAME.RegisterScontrol;
pub const WHvRegisterSversion = WHV_REGISTER_NAME.RegisterSversion;
pub const WHvRegisterSiefp = WHV_REGISTER_NAME.RegisterSiefp;
pub const WHvRegisterSimp = WHV_REGISTER_NAME.RegisterSimp;
pub const WHvRegisterEom = WHV_REGISTER_NAME.RegisterEom;
pub const WHvRegisterVpRuntime = WHV_REGISTER_NAME.RegisterVpRuntime;
pub const WHvX64RegisterHypercall = WHV_REGISTER_NAME.X64RegisterHypercall;
pub const WHvRegisterGuestOsId = WHV_REGISTER_NAME.RegisterGuestOsId;
pub const WHvRegisterVpAssistPage = WHV_REGISTER_NAME.RegisterVpAssistPage;
pub const WHvRegisterReferenceTsc = WHV_REGISTER_NAME.RegisterReferenceTsc;
pub const WHvRegisterReferenceTscSequence = WHV_REGISTER_NAME.RegisterReferenceTscSequence;
pub const WHvRegisterPendingInterruption = WHV_REGISTER_NAME.RegisterPendingInterruption;
pub const WHvRegisterInterruptState = WHV_REGISTER_NAME.RegisterInterruptState;
pub const WHvRegisterPendingEvent = WHV_REGISTER_NAME.RegisterPendingEvent;
pub const WHvX64RegisterDeliverabilityNotifications = WHV_REGISTER_NAME.X64RegisterDeliverabilityNotifications;
pub const WHvRegisterInternalActivityState = WHV_REGISTER_NAME.RegisterInternalActivityState;
pub const WHvX64RegisterPendingDebugException = WHV_REGISTER_NAME.X64RegisterPendingDebugException;

pub const WHV_UINT128 = extern union {
    Anonymous: extern struct {
        Low64: u64,
        High64: u64,
    },
    Dword: [4]u32,
};

pub const WHV_X64_FP_REGISTER = extern union {
    Anonymous: extern struct {
        Mantissa: u64,
        _bitfield: u64,
    },
    AsUINT128: WHV_UINT128,
};

pub const WHV_X64_FP_CONTROL_STATUS_REGISTER = extern union {
    Anonymous: extern struct {
        FpControl: u16,
        FpStatus: u16,
        FpTag: u8,
        Reserved: u8,
        LastFpOp: u16,
        Anonymous: extern union {
            LastFpRip: u64,
            Anonymous: extern struct {
                LastFpEip: u32,
                LastFpCs: u16,
                Reserved2: u16,
            },
        },
    },
    AsUINT128: WHV_UINT128,
};

pub const WHV_X64_XMM_CONTROL_STATUS_REGISTER = extern union {
    Anonymous: extern struct {
        Anonymous: extern union {
            LastFpRdp: u64,
            Anonymous: extern struct {
                LastFpDp: u32,
                LastFpDs: u16,
                Reserved: u16,
            },
        },
        XmmStatusControl: u32,
        XmmStatusControlMask: u32,
    },
    AsUINT128: WHV_UINT128,
};

pub const WHV_X64_SEGMENT_REGISTER = extern struct {
    Base: u64,
    Limit: u32,
    Selector: u16,
    Anonymous: extern union {
        Anonymous: extern struct {
            _bitfield: u16,
        },
        Attributes: u16,
    },
};

pub const WHV_X64_TABLE_REGISTER = extern struct {
    Pad: [3]u16,
    Limit: u16,
    Base: u64,
};

pub const WHV_X64_INTERRUPT_STATE_REGISTER = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_X64_PENDING_INTERRUPTION_REGISTER = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
        ErrorCode: u32,
    },
    AsUINT64: u64,
};

pub const WHV_X64_DELIVERABILITY_NOTIFICATIONS_REGISTER = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_X64_PENDING_EVENT_TYPE = enum(i32) {
    ception = 0,
    tInt = 5,
};
pub const WHvX64PendingEventException = WHV_X64_PENDING_EVENT_TYPE.ception;
pub const WHvX64PendingEventExtInt = WHV_X64_PENDING_EVENT_TYPE.tInt;

pub const WHV_X64_PENDING_EXCEPTION_EVENT = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
        ErrorCode: u32,
        ExceptionParameter: u64,
    },
    AsUINT128: WHV_UINT128,
};

pub const WHV_X64_PENDING_EXT_INT_EVENT = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
        Reserved2: u64,
    },
    AsUINT128: WHV_UINT128,
};

pub const WHV_INTERNAL_ACTIVITY_REGISTER = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_X64_PENDING_DEBUG_EXCEPTION = extern union {
    AsUINT64: u64,
    Anonymous: extern struct {
        _bitfield: u64,
    },
};

pub const WHV_SYNIC_SINT_DELIVERABLE_CONTEXT = extern struct {
    DeliverableSints: u16,
    Reserved1: u16,
    Reserved2: u32,
};

pub const WHV_REGISTER_VALUE = extern union {
    Reg128: WHV_UINT128,
    Reg64: u64,
    Reg32: u32,
    Reg16: u16,
    Reg8: u8,
    Fp: WHV_X64_FP_REGISTER,
    FpControlStatus: WHV_X64_FP_CONTROL_STATUS_REGISTER,
    XmmControlStatus: WHV_X64_XMM_CONTROL_STATUS_REGISTER,
    Segment: WHV_X64_SEGMENT_REGISTER,
    Table: WHV_X64_TABLE_REGISTER,
    InterruptState: WHV_X64_INTERRUPT_STATE_REGISTER,
    PendingInterruption: WHV_X64_PENDING_INTERRUPTION_REGISTER,
    DeliverabilityNotifications: WHV_X64_DELIVERABILITY_NOTIFICATIONS_REGISTER,
    ExceptionEvent: WHV_X64_PENDING_EXCEPTION_EVENT,
    ExtIntEvent: WHV_X64_PENDING_EXT_INT_EVENT,
    InternalActivity: WHV_INTERNAL_ACTIVITY_REGISTER,
    PendingDebugException: WHV_X64_PENDING_DEBUG_EXCEPTION,
};

pub const WHV_RUN_VP_EXIT_REASON = enum(i32) {
    None = 0,
    MemoryAccess = 1,
    X64IoPortAccess = 2,
    UnrecoverableException = 4,
    InvalidVpRegisterValue = 5,
    UnsupportedFeature = 6,
    X64InterruptWindow = 7,
    X64Halt = 8,
    X64ApicEoi = 9,
    SynicSintDeliverable = 10,
    X64MsrAccess = 4096,
    X64Cpuid = 4097,
    Exception = 4098,
    X64Rdtsc = 4099,
    X64ApicSmiTrap = 4100,
    Hypercall = 4101,
    X64ApicInitSipiTrap = 4102,
    X64ApicWriteTrap = 4103,
    Canceled = 8193,
};
pub const WHvRunVpExitReasonNone = WHV_RUN_VP_EXIT_REASON.None;
pub const WHvRunVpExitReasonMemoryAccess = WHV_RUN_VP_EXIT_REASON.MemoryAccess;
pub const WHvRunVpExitReasonX64IoPortAccess = WHV_RUN_VP_EXIT_REASON.X64IoPortAccess;
pub const WHvRunVpExitReasonUnrecoverableException = WHV_RUN_VP_EXIT_REASON.UnrecoverableException;
pub const WHvRunVpExitReasonInvalidVpRegisterValue = WHV_RUN_VP_EXIT_REASON.InvalidVpRegisterValue;
pub const WHvRunVpExitReasonUnsupportedFeature = WHV_RUN_VP_EXIT_REASON.UnsupportedFeature;
pub const WHvRunVpExitReasonX64InterruptWindow = WHV_RUN_VP_EXIT_REASON.X64InterruptWindow;
pub const WHvRunVpExitReasonX64Halt = WHV_RUN_VP_EXIT_REASON.X64Halt;
pub const WHvRunVpExitReasonX64ApicEoi = WHV_RUN_VP_EXIT_REASON.X64ApicEoi;
pub const WHvRunVpExitReasonSynicSintDeliverable = WHV_RUN_VP_EXIT_REASON.SynicSintDeliverable;
pub const WHvRunVpExitReasonX64MsrAccess = WHV_RUN_VP_EXIT_REASON.X64MsrAccess;
pub const WHvRunVpExitReasonX64Cpuid = WHV_RUN_VP_EXIT_REASON.X64Cpuid;
pub const WHvRunVpExitReasonException = WHV_RUN_VP_EXIT_REASON.Exception;
pub const WHvRunVpExitReasonX64Rdtsc = WHV_RUN_VP_EXIT_REASON.X64Rdtsc;
pub const WHvRunVpExitReasonX64ApicSmiTrap = WHV_RUN_VP_EXIT_REASON.X64ApicSmiTrap;
pub const WHvRunVpExitReasonHypercall = WHV_RUN_VP_EXIT_REASON.Hypercall;
pub const WHvRunVpExitReasonX64ApicInitSipiTrap = WHV_RUN_VP_EXIT_REASON.X64ApicInitSipiTrap;
pub const WHvRunVpExitReasonX64ApicWriteTrap = WHV_RUN_VP_EXIT_REASON.X64ApicWriteTrap;
pub const WHvRunVpExitReasonCanceled = WHV_RUN_VP_EXIT_REASON.Canceled;

pub const WHV_X64_VP_EXECUTION_STATE = extern union {
    Anonymous: extern struct {
        _bitfield: u16,
    },
    AsUINT16: u16,
};

pub const WHV_VP_EXIT_CONTEXT = extern struct {
    ExecutionState: WHV_X64_VP_EXECUTION_STATE,
    _bitfield: u8,
    Reserved: u8,
    Reserved2: u32,
    Cs: WHV_X64_SEGMENT_REGISTER,
    Rip: u64,
    Rflags: u64,
};

pub const WHV_MEMORY_ACCESS_INFO = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
    },
    AsUINT32: u32,
};

pub const WHV_MEMORY_ACCESS_CONTEXT = extern struct {
    InstructionByteCount: u8,
    Reserved: [3]u8,
    InstructionBytes: [16]u8,
    AccessInfo: WHV_MEMORY_ACCESS_INFO,
    Gpa: u64,
    Gva: u64,
};

pub const WHV_X64_IO_PORT_ACCESS_INFO = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
    },
    AsUINT32: u32,
};

pub const WHV_X64_IO_PORT_ACCESS_CONTEXT = extern struct {
    InstructionByteCount: u8,
    Reserved: [3]u8,
    InstructionBytes: [16]u8,
    AccessInfo: WHV_X64_IO_PORT_ACCESS_INFO,
    PortNumber: u16,
    Reserved2: [3]u16,
    Rax: u64,
    Rcx: u64,
    Rsi: u64,
    Rdi: u64,
    Ds: WHV_X64_SEGMENT_REGISTER,
    Es: WHV_X64_SEGMENT_REGISTER,
};

pub const WHV_X64_MSR_ACCESS_INFO = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
    },
    AsUINT32: u32,
};

pub const WHV_X64_MSR_ACCESS_CONTEXT = extern struct {
    AccessInfo: WHV_X64_MSR_ACCESS_INFO,
    MsrNumber: u32,
    Rax: u64,
    Rdx: u64,
};

pub const WHV_X64_CPUID_ACCESS_CONTEXT = extern struct {
    Rax: u64,
    Rcx: u64,
    Rdx: u64,
    Rbx: u64,
    DefaultResultRax: u64,
    DefaultResultRcx: u64,
    DefaultResultRdx: u64,
    DefaultResultRbx: u64,
};

pub const WHV_VP_EXCEPTION_INFO = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
    },
    AsUINT32: u32,
};

pub const WHV_VP_EXCEPTION_CONTEXT = extern struct {
    InstructionByteCount: u8,
    Reserved: [3]u8,
    InstructionBytes: [16]u8,
    ExceptionInfo: WHV_VP_EXCEPTION_INFO,
    ExceptionType: u8,
    Reserved2: [3]u8,
    ErrorCode: u32,
    ExceptionParameter: u64,
};

pub const WHV_X64_UNSUPPORTED_FEATURE_CODE = enum(i32) {
    Intercept = 1,
    TaskSwitchTss = 2,
};
pub const WHvUnsupportedFeatureIntercept = WHV_X64_UNSUPPORTED_FEATURE_CODE.Intercept;
pub const WHvUnsupportedFeatureTaskSwitchTss = WHV_X64_UNSUPPORTED_FEATURE_CODE.TaskSwitchTss;

pub const WHV_X64_UNSUPPORTED_FEATURE_CONTEXT = extern struct {
    FeatureCode: WHV_X64_UNSUPPORTED_FEATURE_CODE,
    Reserved: u32,
    FeatureParameter: u64,
};

pub const WHV_RUN_VP_CANCEL_REASON = enum(i32) {
    r = 0,
};
pub const WHvRunVpCancelReasonUser = WHV_RUN_VP_CANCEL_REASON.r;

pub const WHV_RUN_VP_CANCELED_CONTEXT = extern struct {
    CancelReason: WHV_RUN_VP_CANCEL_REASON,
};

pub const WHV_X64_PENDING_INTERRUPTION_TYPE = enum(i32) {
    Interrupt = 0,
    Nmi = 2,
    Exception = 3,
};
pub const WHvX64PendingInterrupt = WHV_X64_PENDING_INTERRUPTION_TYPE.Interrupt;
pub const WHvX64PendingNmi = WHV_X64_PENDING_INTERRUPTION_TYPE.Nmi;
pub const WHvX64PendingException = WHV_X64_PENDING_INTERRUPTION_TYPE.Exception;

pub const WHV_X64_INTERRUPTION_DELIVERABLE_CONTEXT = extern struct {
    DeliverableType: WHV_X64_PENDING_INTERRUPTION_TYPE,
};

pub const WHV_X64_APIC_EOI_CONTEXT = extern struct {
    InterruptVector: u32,
};

pub const WHV_X64_RDTSC_INFO = extern union {
    Anonymous: extern struct {
        _bitfield: u64,
    },
    AsUINT64: u64,
};

pub const WHV_X64_RDTSC_CONTEXT = extern struct {
    TscAux: u64,
    VirtualOffset: u64,
    Tsc: u64,
    ReferenceTime: u64,
    RdtscInfo: WHV_X64_RDTSC_INFO,
};

pub const WHV_X64_APIC_SMI_CONTEXT = extern struct {
    ApicIcr: u64,
};

pub const WHV_HYPERCALL_CONTEXT = extern struct {
    Rax: u64,
    Rbx: u64,
    Rcx: u64,
    Rdx: u64,
    R8: u64,
    Rsi: u64,
    Rdi: u64,
    Reserved0: u64,
    XmmRegisters: [6]WHV_UINT128,
    Reserved1: [2]u64,
};

pub const WHV_X64_APIC_INIT_SIPI_CONTEXT = extern struct {
    ApicIcr: u64,
};

pub const WHV_X64_APIC_WRITE_TYPE = enum(i32) {
    Ldr = 208,
    Dfr = 224,
    Svr = 240,
    Lint0 = 848,
    Lint1 = 864,
};
pub const WHvX64ApicWriteTypeLdr = WHV_X64_APIC_WRITE_TYPE.Ldr;
pub const WHvX64ApicWriteTypeDfr = WHV_X64_APIC_WRITE_TYPE.Dfr;
pub const WHvX64ApicWriteTypeSvr = WHV_X64_APIC_WRITE_TYPE.Svr;
pub const WHvX64ApicWriteTypeLint0 = WHV_X64_APIC_WRITE_TYPE.Lint0;
pub const WHvX64ApicWriteTypeLint1 = WHV_X64_APIC_WRITE_TYPE.Lint1;

pub const WHV_X64_APIC_WRITE_CONTEXT = extern struct {
    Type: WHV_X64_APIC_WRITE_TYPE,
    Reserved: u32,
    WriteValue: u64,
};

pub const WHV_RUN_VP_EXIT_CONTEXT = extern struct {
    ExitReason: WHV_RUN_VP_EXIT_REASON,
    Reserved: u32,
    VpContext: WHV_VP_EXIT_CONTEXT,
    Anonymous: extern union {
        MemoryAccess: WHV_MEMORY_ACCESS_CONTEXT,
        IoPortAccess: WHV_X64_IO_PORT_ACCESS_CONTEXT,
        MsrAccess: WHV_X64_MSR_ACCESS_CONTEXT,
        CpuidAccess: WHV_X64_CPUID_ACCESS_CONTEXT,
        VpException: WHV_VP_EXCEPTION_CONTEXT,
        InterruptWindow: WHV_X64_INTERRUPTION_DELIVERABLE_CONTEXT,
        UnsupportedFeature: WHV_X64_UNSUPPORTED_FEATURE_CONTEXT,
        CancelReason: WHV_RUN_VP_CANCELED_CONTEXT,
        ApicEoi: WHV_X64_APIC_EOI_CONTEXT,
        ReadTsc: WHV_X64_RDTSC_CONTEXT,
        ApicSmi: WHV_X64_APIC_SMI_CONTEXT,
        Hypercall: WHV_HYPERCALL_CONTEXT,
        ApicInitSipi: WHV_X64_APIC_INIT_SIPI_CONTEXT,
        ApicWrite: WHV_X64_APIC_WRITE_CONTEXT,
        SynicSintDeliverable: WHV_SYNIC_SINT_DELIVERABLE_CONTEXT,
    },
};

pub const WHV_INTERRUPT_TYPE = enum(i32) {
    Fixed = 0,
    LowestPriority = 1,
    Nmi = 4,
    Init = 5,
    Sipi = 6,
    LocalInt1 = 9,
};
pub const WHvX64InterruptTypeFixed = WHV_INTERRUPT_TYPE.Fixed;
pub const WHvX64InterruptTypeLowestPriority = WHV_INTERRUPT_TYPE.LowestPriority;
pub const WHvX64InterruptTypeNmi = WHV_INTERRUPT_TYPE.Nmi;
pub const WHvX64InterruptTypeInit = WHV_INTERRUPT_TYPE.Init;
pub const WHvX64InterruptTypeSipi = WHV_INTERRUPT_TYPE.Sipi;
pub const WHvX64InterruptTypeLocalInt1 = WHV_INTERRUPT_TYPE.LocalInt1;

pub const WHV_INTERRUPT_DESTINATION_MODE = enum(i32) {
    Physical = 0,
    Logical = 1,
};
pub const WHvX64InterruptDestinationModePhysical = WHV_INTERRUPT_DESTINATION_MODE.Physical;
pub const WHvX64InterruptDestinationModeLogical = WHV_INTERRUPT_DESTINATION_MODE.Logical;

pub const WHV_INTERRUPT_TRIGGER_MODE = enum(i32) {
    Edge = 0,
    Level = 1,
};
pub const WHvX64InterruptTriggerModeEdge = WHV_INTERRUPT_TRIGGER_MODE.Edge;
pub const WHvX64InterruptTriggerModeLevel = WHV_INTERRUPT_TRIGGER_MODE.Level;

pub const WHV_INTERRUPT_CONTROL = extern struct {
    _bitfield: u64,
    Destination: u32,
    Vector: u32,
};

pub const WHV_DOORBELL_MATCH_DATA = extern struct {
    GuestAddress: u64,
    Value: u64,
    Length: u32,
    _bitfield: u32,
};

pub const WHV_PARTITION_COUNTER_SET = enum(i32) {
    y = 0,
};
pub const WHvPartitionCounterSetMemory = WHV_PARTITION_COUNTER_SET.y;

pub const WHV_PARTITION_MEMORY_COUNTERS = extern struct {
    Mapped4KPageCount: u64,
    Mapped2MPageCount: u64,
    Mapped1GPageCount: u64,
};

pub const WHV_PROCESSOR_COUNTER_SET = enum(i32) {
    Runtime = 0,
    Intercepts = 1,
    Events = 2,
    Apic = 3,
    SyntheticFeatures = 4,
};
pub const WHvProcessorCounterSetRuntime = WHV_PROCESSOR_COUNTER_SET.Runtime;
pub const WHvProcessorCounterSetIntercepts = WHV_PROCESSOR_COUNTER_SET.Intercepts;
pub const WHvProcessorCounterSetEvents = WHV_PROCESSOR_COUNTER_SET.Events;
pub const WHvProcessorCounterSetApic = WHV_PROCESSOR_COUNTER_SET.Apic;
pub const WHvProcessorCounterSetSyntheticFeatures = WHV_PROCESSOR_COUNTER_SET.SyntheticFeatures;

pub const WHV_PROCESSOR_RUNTIME_COUNTERS = extern struct {
    TotalRuntime100ns: u64,
    HypervisorRuntime100ns: u64,
};

pub const WHV_PROCESSOR_INTERCEPT_COUNTER = extern struct {
    Count: u64,
    Time100ns: u64,
};

pub const WHV_PROCESSOR_INTERCEPT_COUNTERS = extern struct {
    PageInvalidations: WHV_PROCESSOR_INTERCEPT_COUNTER,
    ControlRegisterAccesses: WHV_PROCESSOR_INTERCEPT_COUNTER,
    IoInstructions: WHV_PROCESSOR_INTERCEPT_COUNTER,
    HaltInstructions: WHV_PROCESSOR_INTERCEPT_COUNTER,
    CpuidInstructions: WHV_PROCESSOR_INTERCEPT_COUNTER,
    MsrAccesses: WHV_PROCESSOR_INTERCEPT_COUNTER,
    OtherIntercepts: WHV_PROCESSOR_INTERCEPT_COUNTER,
    PendingInterrupts: WHV_PROCESSOR_INTERCEPT_COUNTER,
    EmulatedInstructions: WHV_PROCESSOR_INTERCEPT_COUNTER,
    DebugRegisterAccesses: WHV_PROCESSOR_INTERCEPT_COUNTER,
    PageFaultIntercepts: WHV_PROCESSOR_INTERCEPT_COUNTER,
    NestedPageFaultIntercepts: WHV_PROCESSOR_INTERCEPT_COUNTER,
    Hypercalls: WHV_PROCESSOR_INTERCEPT_COUNTER,
    RdpmcInstructions: WHV_PROCESSOR_INTERCEPT_COUNTER,
};

pub const WHV_PROCESSOR_EVENT_COUNTERS = extern struct {
    PageFaultCount: u64,
    ExceptionCount: u64,
    InterruptCount: u64,
};

pub const WHV_PROCESSOR_APIC_COUNTERS = extern struct {
    MmioAccessCount: u64,
    EoiAccessCount: u64,
    TprAccessCount: u64,
    SentIpiCount: u64,
    SelfIpiCount: u64,
};

pub const WHV_PROCESSOR_SYNTHETIC_FEATURES_COUNTERS = extern struct {
    SyntheticInterruptsCount: u64,
    LongSpinWaitHypercallsCount: u64,
    OtherHypercallsCount: u64,
    SyntheticInterruptHypercallsCount: u64,
    VirtualInterruptHypercallsCount: u64,
    VirtualMmuHypercallsCount: u64,
};

pub const WHV_ADVISE_GPA_RANGE_CODE = enum(i32) {
    Populate = 0,
    Pin = 1,
    Unpin = 2,
};
pub const WHvAdviseGpaRangeCodePopulate = WHV_ADVISE_GPA_RANGE_CODE.Populate;
pub const WHvAdviseGpaRangeCodePin = WHV_ADVISE_GPA_RANGE_CODE.Pin;
pub const WHvAdviseGpaRangeCodeUnpin = WHV_ADVISE_GPA_RANGE_CODE.Unpin;

pub const WHV_VIRTUAL_PROCESSOR_STATE_TYPE = enum(i32) {
    SynicMessagePage = 0,
    SynicEventFlagPage = 1,
    SynicTimerState = 2,
    InterruptControllerState2 = 4096,
    XsaveState = 4097,
};
pub const WHvVirtualProcessorStateTypeSynicMessagePage = WHV_VIRTUAL_PROCESSOR_STATE_TYPE.SynicMessagePage;
pub const WHvVirtualProcessorStateTypeSynicEventFlagPage = WHV_VIRTUAL_PROCESSOR_STATE_TYPE.SynicEventFlagPage;
pub const WHvVirtualProcessorStateTypeSynicTimerState = WHV_VIRTUAL_PROCESSOR_STATE_TYPE.SynicTimerState;
pub const WHvVirtualProcessorStateTypeInterruptControllerState2 = WHV_VIRTUAL_PROCESSOR_STATE_TYPE.InterruptControllerState2;
pub const WHvVirtualProcessorStateTypeXsaveState = WHV_VIRTUAL_PROCESSOR_STATE_TYPE.XsaveState;

pub const WHV_SYNIC_EVENT_PARAMETERS = extern struct {
    VpIndex: u32,
    TargetSint: u8,
    Reserved: u8,
    FlagNumber: u16,
};

pub const WHV_ALLOCATE_VPCI_RESOURCE_FLAGS = enum(u32) {
    None = 0,
    AllowDirectP2P = 1,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        AllowDirectP2P: u1 = 0,
    }) WHV_ALLOCATE_VPCI_RESOURCE_FLAGS {
        return @as(WHV_ALLOCATE_VPCI_RESOURCE_FLAGS, @enumFromInt((if (o.None == 1) @intFromEnum(WHV_ALLOCATE_VPCI_RESOURCE_FLAGS.None) else 0) | (if (o.AllowDirectP2P == 1) @intFromEnum(WHV_ALLOCATE_VPCI_RESOURCE_FLAGS.AllowDirectP2P) else 0)));
    }
};
pub const WHvAllocateVpciResourceFlagNone = WHV_ALLOCATE_VPCI_RESOURCE_FLAGS.None;
pub const WHvAllocateVpciResourceFlagAllowDirectP2P = WHV_ALLOCATE_VPCI_RESOURCE_FLAGS.AllowDirectP2P;

pub const WHV_SRIOV_RESOURCE_DESCRIPTOR = extern struct {
    PnpInstanceId: [200]u16,
    VirtualFunctionId: LUID,
    VirtualFunctionIndex: u16,
    Reserved: u16,
};

pub const WHV_VPCI_DEVICE_NOTIFICATION_TYPE = enum(i32) {
    Undefined = 0,
    MmioRemapping = 1,
    SurpriseRemoval = 2,
};
pub const WHvVpciDeviceNotificationUndefined = WHV_VPCI_DEVICE_NOTIFICATION_TYPE.Undefined;
pub const WHvVpciDeviceNotificationMmioRemapping = WHV_VPCI_DEVICE_NOTIFICATION_TYPE.MmioRemapping;
pub const WHvVpciDeviceNotificationSurpriseRemoval = WHV_VPCI_DEVICE_NOTIFICATION_TYPE.SurpriseRemoval;

pub const WHV_VPCI_DEVICE_NOTIFICATION = extern struct {
    NotificationType: WHV_VPCI_DEVICE_NOTIFICATION_TYPE,
    Reserved1: u32,
    Anonymous: extern union {
        Reserved2: u64,
    },
};

pub const WHV_CREATE_VPCI_DEVICE_FLAGS = enum(u32) {
    None = 0,
    PhysicallyBacked = 1,
    UseLogicalInterrupts = 2,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        PhysicallyBacked: u1 = 0,
        UseLogicalInterrupts: u1 = 0,
    }) WHV_CREATE_VPCI_DEVICE_FLAGS {
        return @as(WHV_CREATE_VPCI_DEVICE_FLAGS, @enumFromInt((if (o.None == 1) @intFromEnum(WHV_CREATE_VPCI_DEVICE_FLAGS.None) else 0) | (if (o.PhysicallyBacked == 1) @intFromEnum(WHV_CREATE_VPCI_DEVICE_FLAGS.PhysicallyBacked) else 0) | (if (o.UseLogicalInterrupts == 1) @intFromEnum(WHV_CREATE_VPCI_DEVICE_FLAGS.UseLogicalInterrupts) else 0)));
    }
};
pub const WHvCreateVpciDeviceFlagNone = WHV_CREATE_VPCI_DEVICE_FLAGS.None;
pub const WHvCreateVpciDeviceFlagPhysicallyBacked = WHV_CREATE_VPCI_DEVICE_FLAGS.PhysicallyBacked;
pub const WHvCreateVpciDeviceFlagUseLogicalInterrupts = WHV_CREATE_VPCI_DEVICE_FLAGS.UseLogicalInterrupts;

pub const WHV_VPCI_DEVICE_PROPERTY_CODE = enum(i32) {
    Undefined = 0,
    HardwareIDs = 1,
    ProbedBARs = 2,
};
pub const WHvVpciDevicePropertyCodeUndefined = WHV_VPCI_DEVICE_PROPERTY_CODE.Undefined;
pub const WHvVpciDevicePropertyCodeHardwareIDs = WHV_VPCI_DEVICE_PROPERTY_CODE.HardwareIDs;
pub const WHvVpciDevicePropertyCodeProbedBARs = WHV_VPCI_DEVICE_PROPERTY_CODE.ProbedBARs;

pub const WHV_VPCI_HARDWARE_IDS = extern struct {
    VendorID: u16,
    DeviceID: u16,
    RevisionID: u8,
    ProgIf: u8,
    SubClass: u8,
    BaseClass: u8,
    SubVendorID: u16,
    SubSystemID: u16,
};

pub const WHV_VPCI_PROBED_BARS = extern struct {
    Value: [6]u32,
};

pub const WHV_VPCI_MMIO_RANGE_FLAGS = enum(u32) {
    ReadAccess = 1,
    WriteAccess = 2,
    _,
    pub fn initFlags(o: struct {
        ReadAccess: u1 = 0,
        WriteAccess: u1 = 0,
    }) WHV_VPCI_MMIO_RANGE_FLAGS {
        return @as(WHV_VPCI_MMIO_RANGE_FLAGS, @enumFromInt((if (o.ReadAccess == 1) @intFromEnum(WHV_VPCI_MMIO_RANGE_FLAGS.ReadAccess) else 0) | (if (o.WriteAccess == 1) @intFromEnum(WHV_VPCI_MMIO_RANGE_FLAGS.WriteAccess) else 0)));
    }
};
pub const WHvVpciMmioRangeFlagReadAccess = WHV_VPCI_MMIO_RANGE_FLAGS.ReadAccess;
pub const WHvVpciMmioRangeFlagWriteAccess = WHV_VPCI_MMIO_RANGE_FLAGS.WriteAccess;

pub const WHV_VPCI_DEVICE_REGISTER_SPACE = enum(i32) {
    ConfigSpace = -1,
    Bar0 = 0,
    Bar1 = 1,
    Bar2 = 2,
    Bar3 = 3,
    Bar4 = 4,
    Bar5 = 5,
};
pub const WHvVpciConfigSpace = WHV_VPCI_DEVICE_REGISTER_SPACE.ConfigSpace;
pub const WHvVpciBar0 = WHV_VPCI_DEVICE_REGISTER_SPACE.Bar0;
pub const WHvVpciBar1 = WHV_VPCI_DEVICE_REGISTER_SPACE.Bar1;
pub const WHvVpciBar2 = WHV_VPCI_DEVICE_REGISTER_SPACE.Bar2;
pub const WHvVpciBar3 = WHV_VPCI_DEVICE_REGISTER_SPACE.Bar3;
pub const WHvVpciBar4 = WHV_VPCI_DEVICE_REGISTER_SPACE.Bar4;
pub const WHvVpciBar5 = WHV_VPCI_DEVICE_REGISTER_SPACE.Bar5;

pub const WHV_VPCI_MMIO_MAPPING = extern struct {
    Location: WHV_VPCI_DEVICE_REGISTER_SPACE,
    Flags: WHV_VPCI_MMIO_RANGE_FLAGS,
    SizeInBytes: u64,
    OffsetInBytes: u64,
    VirtualAddress: ?*anyopaque,
};

pub const WHV_VPCI_DEVICE_REGISTER = extern struct {
    Location: WHV_VPCI_DEVICE_REGISTER_SPACE,
    SizeInBytes: u32,
    OffsetInBytes: u64,
};

pub const WHV_VPCI_INTERRUPT_TARGET_FLAGS = enum(u32) {
    None = 0,
    Multicast = 1,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        Multicast: u1 = 0,
    }) WHV_VPCI_INTERRUPT_TARGET_FLAGS {
        return @as(WHV_VPCI_INTERRUPT_TARGET_FLAGS, @enumFromInt((if (o.None == 1) @intFromEnum(WHV_VPCI_INTERRUPT_TARGET_FLAGS.None) else 0) | (if (o.Multicast == 1) @intFromEnum(WHV_VPCI_INTERRUPT_TARGET_FLAGS.Multicast) else 0)));
    }
};
pub const WHvVpciInterruptTargetFlagNone = WHV_VPCI_INTERRUPT_TARGET_FLAGS.None;
pub const WHvVpciInterruptTargetFlagMulticast = WHV_VPCI_INTERRUPT_TARGET_FLAGS.Multicast;

pub const WHV_VPCI_INTERRUPT_TARGET = extern struct {
    Vector: u32,
    Flags: WHV_VPCI_INTERRUPT_TARGET_FLAGS,
    ProcessorCount: u32,
    Processors: [1]u32,
};

pub const WHV_TRIGGER_TYPE = enum(i32) {
    Interrupt = 0,
    SynicEvent = 1,
    DeviceInterrupt = 2,
};
pub const WHvTriggerTypeInterrupt = WHV_TRIGGER_TYPE.Interrupt;
pub const WHvTriggerTypeSynicEvent = WHV_TRIGGER_TYPE.SynicEvent;
pub const WHvTriggerTypeDeviceInterrupt = WHV_TRIGGER_TYPE.DeviceInterrupt;

pub const WHV_TRIGGER_PARAMETERS = extern struct {
    TriggerType: WHV_TRIGGER_TYPE,
    Reserved: u32,
    Anonymous: extern union {
        Interrupt: WHV_INTERRUPT_CONTROL,
        SynicEvent: WHV_SYNIC_EVENT_PARAMETERS,
        DeviceInterrupt: extern struct {
            LogicalDeviceId: u64,
            MsiAddress: u64,
            MsiData: u32,
            Reserved: u32,
        },
    },
};

pub const WHV_VIRTUAL_PROCESSOR_PROPERTY_CODE = enum(i32) {
    e = 0,
};
pub const WHvVirtualProcessorPropertyCodeNumaNode = WHV_VIRTUAL_PROCESSOR_PROPERTY_CODE.e;

pub const WHV_VIRTUAL_PROCESSOR_PROPERTY = extern struct {
    PropertyCode: WHV_VIRTUAL_PROCESSOR_PROPERTY_CODE,
    Reserved: u32,
    Anonymous: extern union {
        NumaNode: u16,
        Padding: u64,
    },
};

pub const WHV_NOTIFICATION_PORT_TYPE = enum(i32) {
    Event = 2,
    Doorbell = 4,
};
pub const WHvNotificationPortTypeEvent = WHV_NOTIFICATION_PORT_TYPE.Event;
pub const WHvNotificationPortTypeDoorbell = WHV_NOTIFICATION_PORT_TYPE.Doorbell;

pub const WHV_NOTIFICATION_PORT_PARAMETERS = extern struct {
    NotificationPortType: WHV_NOTIFICATION_PORT_TYPE,
    Reserved: u32,
    Anonymous: extern union {
        Doorbell: WHV_DOORBELL_MATCH_DATA,
        Event: extern struct {
            ConnectionId: u32,
        },
    },
};

pub const WHV_NOTIFICATION_PORT_PROPERTY_CODE = enum(i32) {
    Vp = 1,
    Duration = 5,
};
pub const WHvNotificationPortPropertyPreferredTargetVp = WHV_NOTIFICATION_PORT_PROPERTY_CODE.Vp;
pub const WHvNotificationPortPropertyPreferredTargetDuration = WHV_NOTIFICATION_PORT_PROPERTY_CODE.Duration;

pub const WHV_EMULATOR_STATUS = extern union {
    Anonymous: extern struct {
        _bitfield: u32,
    },
    AsUINT32: u32,
};

pub const WHV_EMULATOR_MEMORY_ACCESS_INFO = extern struct {
    GpaAddress: u64,
    Direction: u8,
    AccessSize: u8,
    Data: [8]u8,
};

pub const WHV_EMULATOR_IO_ACCESS_INFO = extern struct {
    Direction: u8,
    Port: u16,
    AccessSize: u16,
    Data: u32,
};

pub const WHV_EMULATOR_IO_PORT_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Context: ?*anyopaque,
        IoAccess: ?*WHV_EMULATOR_IO_ACCESS_INFO,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        Context: ?*anyopaque,
        IoAccess: ?*WHV_EMULATOR_IO_ACCESS_INFO,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const WHV_EMULATOR_MEMORY_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Context: ?*anyopaque,
        MemoryAccess: ?*WHV_EMULATOR_MEMORY_ACCESS_INFO,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        Context: ?*anyopaque,
        MemoryAccess: ?*WHV_EMULATOR_MEMORY_ACCESS_INFO,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const WHV_EMULATOR_GET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Context: ?*anyopaque,
        RegisterNames: [*]const WHV_REGISTER_NAME,
        RegisterCount: u32,
        RegisterValues: [*]WHV_REGISTER_VALUE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        Context: ?*anyopaque,
        RegisterNames: [*]const WHV_REGISTER_NAME,
        RegisterCount: u32,
        RegisterValues: [*]WHV_REGISTER_VALUE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const WHV_EMULATOR_SET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Context: ?*anyopaque,
        RegisterNames: [*]const WHV_REGISTER_NAME,
        RegisterCount: u32,
        RegisterValues: [*]const WHV_REGISTER_VALUE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        Context: ?*anyopaque,
        RegisterNames: [*]const WHV_REGISTER_NAME,
        RegisterCount: u32,
        RegisterValues: [*]const WHV_REGISTER_VALUE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const WHV_EMULATOR_TRANSLATE_GVA_PAGE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Context: ?*anyopaque,
        Gva: u64,
        TranslateFlags: WHV_TRANSLATE_GVA_FLAGS,
        TranslationResult: ?*WHV_TRANSLATE_GVA_RESULT_CODE,
        Gpa: ?*u64,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        Context: ?*anyopaque,
        Gva: u64,
        TranslateFlags: WHV_TRANSLATE_GVA_FLAGS,
        TranslationResult: ?*WHV_TRANSLATE_GVA_RESULT_CODE,
        Gpa: ?*u64,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const WHV_EMULATOR_CALLBACKS = extern struct {
    Size: u32,
    Reserved: u32,
    WHvEmulatorIoPortCallback: ?WHV_EMULATOR_IO_PORT_CALLBACK,
    WHvEmulatorMemoryCallback: ?WHV_EMULATOR_MEMORY_CALLBACK,
    WHvEmulatorGetVirtualProcessorRegisters: ?WHV_EMULATOR_GET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK,
    WHvEmulatorSetVirtualProcessorRegisters: ?WHV_EMULATOR_SET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK,
    WHvEmulatorTranslateGvaPage: ?WHV_EMULATOR_TRANSLATE_GVA_PAGE_CALLBACK,
};

pub const SOCKADDR_HV = extern struct {
    Family: u16,
    Reserved: u16,
    VmId: Guid,
    ServiceId: Guid,
};

pub const HVSOCKET_ADDRESS_INFO = extern struct {
    SystemId: Guid,
    VirtualMachineId: Guid,
    SiloId: Guid,
    Flags: u32,
};

pub const VM_GENCOUNTER = extern struct {
    GenerationCount: u64,
    GenerationCountHigh: u64,
};

pub const HDV_DEVICE_TYPE = enum(i32) {
    Undefined = 0,
    PCI = 1,
};
pub const HdvDeviceTypeUndefined = HDV_DEVICE_TYPE.Undefined;
pub const HdvDeviceTypePCI = HDV_DEVICE_TYPE.PCI;

pub const HDV_PCI_PNP_ID = extern struct {
    VendorID: u16,
    DeviceID: u16,
    RevisionID: u8,
    ProgIf: u8,
    SubClass: u8,
    BaseClass: u8,
    SubVendorID: u16,
    SubSystemID: u16,
};

pub const HDV_PCI_BAR_SELECTOR = enum(i32) {
    @"0" = 0,
    @"1" = 1,
    @"2" = 2,
    @"3" = 3,
    @"4" = 4,
    @"5" = 5,
};
pub const HDV_PCI_BAR0 = HDV_PCI_BAR_SELECTOR.@"0";
pub const HDV_PCI_BAR1 = HDV_PCI_BAR_SELECTOR.@"1";
pub const HDV_PCI_BAR2 = HDV_PCI_BAR_SELECTOR.@"2";
pub const HDV_PCI_BAR3 = HDV_PCI_BAR_SELECTOR.@"3";
pub const HDV_PCI_BAR4 = HDV_PCI_BAR_SELECTOR.@"4";
pub const HDV_PCI_BAR5 = HDV_PCI_BAR_SELECTOR.@"5";

pub const HDV_DOORBELL_FLAGS = enum(i32) {
    SIZE_ANY = 0,
    SIZE_BYTE = 1,
    SIZE_WORD = 2,
    SIZE_DWORD = 3,
    SIZE_QWORD = 4,
    ANY_VALUE = -2147483648,
};
pub const HDV_DOORBELL_FLAG_TRIGGER_SIZE_ANY = HDV_DOORBELL_FLAGS.SIZE_ANY;
pub const HDV_DOORBELL_FLAG_TRIGGER_SIZE_BYTE = HDV_DOORBELL_FLAGS.SIZE_BYTE;
pub const HDV_DOORBELL_FLAG_TRIGGER_SIZE_WORD = HDV_DOORBELL_FLAGS.SIZE_WORD;
pub const HDV_DOORBELL_FLAG_TRIGGER_SIZE_DWORD = HDV_DOORBELL_FLAGS.SIZE_DWORD;
pub const HDV_DOORBELL_FLAG_TRIGGER_SIZE_QWORD = HDV_DOORBELL_FLAGS.SIZE_QWORD;
pub const HDV_DOORBELL_FLAG_TRIGGER_ANY_VALUE = HDV_DOORBELL_FLAGS.ANY_VALUE;

pub const HDV_MMIO_MAPPING_FLAGS = enum(u32) {
    None = 0,
    Writeable = 1,
    Executable = 2,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        Writeable: u1 = 0,
        Executable: u1 = 0,
    }) HDV_MMIO_MAPPING_FLAGS {
        return @as(HDV_MMIO_MAPPING_FLAGS, @enumFromInt((if (o.None == 1) @intFromEnum(HDV_MMIO_MAPPING_FLAGS.None) else 0) | (if (o.Writeable == 1) @intFromEnum(HDV_MMIO_MAPPING_FLAGS.Writeable) else 0) | (if (o.Executable == 1) @intFromEnum(HDV_MMIO_MAPPING_FLAGS.Executable) else 0)));
    }
};
pub const HdvMmioMappingFlagNone = HDV_MMIO_MAPPING_FLAGS.None;
pub const HdvMmioMappingFlagWriteable = HDV_MMIO_MAPPING_FLAGS.Writeable;
pub const HdvMmioMappingFlagExecutable = HDV_MMIO_MAPPING_FLAGS.Executable;

pub const HDV_PCI_DEVICE_INITIALIZE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_DEVICE_TEARDOWN = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const HDV_PCI_DEVICE_SET_CONFIGURATION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
        configurationValueCount: u32,
        configurationValues: [*]const ?[*:0]const u16,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
        configurationValueCount: u32,
        configurationValues: [*]const ?[*:0]const u16,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_DEVICE_GET_DETAILS = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
        pnpId: ?*HDV_PCI_PNP_ID,
        probedBarsCount: u32,
        probedBars: [*]u32,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
        pnpId: ?*HDV_PCI_PNP_ID,
        probedBarsCount: u32,
        probedBars: [*]u32,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_DEVICE_START = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_DEVICE_STOP = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        deviceContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const HDV_PCI_READ_CONFIG_SPACE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
        offset: u32,
        value: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
        offset: u32,
        value: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_WRITE_CONFIG_SPACE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
        offset: u32,
        value: u32,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
        offset: u32,
        value: u32,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_READ_INTERCEPTED_MEMORY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
        barIndex: HDV_PCI_BAR_SELECTOR,
        offset: u64,
        length: u64,
        value: [*:0]u8,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
        barIndex: HDV_PCI_BAR_SELECTOR,
        offset: u64,
        length: u64,
        value: [*:0]u8,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_WRITE_INTERCEPTED_MEMORY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        deviceContext: ?*anyopaque,
        barIndex: HDV_PCI_BAR_SELECTOR,
        offset: u64,
        length: u64,
        value: [*:0]const u8,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        deviceContext: ?*anyopaque,
        barIndex: HDV_PCI_BAR_SELECTOR,
        offset: u64,
        length: u64,
        value: [*:0]const u8,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const HDV_PCI_INTERFACE_VERSION = enum(i32) {
    Invalid = 0,
    @"1" = 1,
};
pub const HdvPciDeviceInterfaceVersionInvalid = HDV_PCI_INTERFACE_VERSION.Invalid;
pub const HdvPciDeviceInterfaceVersion1 = HDV_PCI_INTERFACE_VERSION.@"1";

pub const HDV_PCI_DEVICE_INTERFACE = extern struct {
    Version: HDV_PCI_INTERFACE_VERSION,
    Initialize: ?HDV_PCI_DEVICE_INITIALIZE,
    Teardown: ?HDV_PCI_DEVICE_TEARDOWN,
    SetConfiguration: ?HDV_PCI_DEVICE_SET_CONFIGURATION,
    GetDetails: ?HDV_PCI_DEVICE_GET_DETAILS,
    Start: ?HDV_PCI_DEVICE_START,
    Stop: ?HDV_PCI_DEVICE_STOP,
    ReadConfigSpace: ?HDV_PCI_READ_CONFIG_SPACE,
    WriteConfigSpace: ?HDV_PCI_WRITE_CONFIG_SPACE,
    ReadInterceptedMemory: ?HDV_PCI_READ_INTERCEPTED_MEMORY,
    WriteInterceptedMemory: ?HDV_PCI_WRITE_INTERCEPTED_MEMORY,
};

pub const PAGING_MODE = enum(i32) {
    Invalid = 0,
    NonPaged = 1,
    @"32Bit" = 2,
    Pae = 3,
    Long = 4,
    Armv8 = 5,
};
pub const Paging_Invalid = PAGING_MODE.Invalid;
pub const Paging_NonPaged = PAGING_MODE.NonPaged;
pub const Paging_32Bit = PAGING_MODE.@"32Bit";
pub const Paging_Pae = PAGING_MODE.Pae;
pub const Paging_Long = PAGING_MODE.Long;
pub const Paging_Armv8 = PAGING_MODE.Armv8;

pub const GPA_MEMORY_CHUNK = extern struct {
    GuestPhysicalStartPageIndex: u64,
    PageCount: u64,
};

pub const VIRTUAL_PROCESSOR_ARCH = enum(i32) {
    Unknown = 0,
    x86 = 1,
    x64 = 2,
    Armv8 = 3,
};
pub const Arch_Unknown = VIRTUAL_PROCESSOR_ARCH.Unknown;
pub const Arch_x86 = VIRTUAL_PROCESSOR_ARCH.x86;
pub const Arch_x64 = VIRTUAL_PROCESSOR_ARCH.x64;
pub const Arch_Armv8 = VIRTUAL_PROCESSOR_ARCH.Armv8;

pub const VIRTUAL_PROCESSOR_VENDOR = enum(i32) {
    Unknown = 0,
    Amd = 1,
    Intel = 2,
    Hygon = 3,
    Arm = 4,
};
pub const ProcessorVendor_Unknown = VIRTUAL_PROCESSOR_VENDOR.Unknown;
pub const ProcessorVendor_Amd = VIRTUAL_PROCESSOR_VENDOR.Amd;
pub const ProcessorVendor_Intel = VIRTUAL_PROCESSOR_VENDOR.Intel;
pub const ProcessorVendor_Hygon = VIRTUAL_PROCESSOR_VENDOR.Hygon;
pub const ProcessorVendor_Arm = VIRTUAL_PROCESSOR_VENDOR.Arm;

pub const GUEST_OS_VENDOR = enum(i32) {
    Undefined = 0,
    Microsoft = 1,
    HPE = 2,
    LANCOM = 512,
};
pub const GuestOsVendorUndefined = GUEST_OS_VENDOR.Undefined;
pub const GuestOsVendorMicrosoft = GUEST_OS_VENDOR.Microsoft;
pub const GuestOsVendorHPE = GUEST_OS_VENDOR.HPE;
pub const GuestOsVendorLANCOM = GUEST_OS_VENDOR.LANCOM;

pub const GUEST_OS_MICROSOFT_IDS = enum(i32) {
    Undefined = 0,
    MSDOS = 1,
    Windows3x = 2,
    Windows9x = 3,
    WindowsNT = 4,
    WindowsCE = 5,
};
pub const GuestOsMicrosoftUndefined = GUEST_OS_MICROSOFT_IDS.Undefined;
pub const GuestOsMicrosoftMSDOS = GUEST_OS_MICROSOFT_IDS.MSDOS;
pub const GuestOsMicrosoftWindows3x = GUEST_OS_MICROSOFT_IDS.Windows3x;
pub const GuestOsMicrosoftWindows9x = GUEST_OS_MICROSOFT_IDS.Windows9x;
pub const GuestOsMicrosoftWindowsNT = GUEST_OS_MICROSOFT_IDS.WindowsNT;
pub const GuestOsMicrosoftWindowsCE = GUEST_OS_MICROSOFT_IDS.WindowsCE;

pub const GUEST_OS_OPENSOURCE_IDS = enum(i32) {
    Undefined = 0,
    Linux = 1,
    FreeBSD = 2,
    Xen = 3,
    Illumos = 4,
};
pub const GuestOsOpenSourceUndefined = GUEST_OS_OPENSOURCE_IDS.Undefined;
pub const GuestOsOpenSourceLinux = GUEST_OS_OPENSOURCE_IDS.Linux;
pub const GuestOsOpenSourceFreeBSD = GUEST_OS_OPENSOURCE_IDS.FreeBSD;
pub const GuestOsOpenSourceXen = GUEST_OS_OPENSOURCE_IDS.Xen;
pub const GuestOsOpenSourceIllumos = GUEST_OS_OPENSOURCE_IDS.Illumos;

pub const GUEST_OS_INFO = extern union {
    AsUINT64: u64,
    ClosedSource: extern struct {
        _bitfield: u64,
    },
    OpenSource: extern struct {
        _bitfield: u64,
    },
};

pub const REGISTER_ID = enum(i32) {
    X64_RegisterRax = 0,
    X64_RegisterRcx = 1,
    X64_RegisterRdx = 2,
    X64_RegisterRbx = 3,
    X64_RegisterRsp = 4,
    X64_RegisterRbp = 5,
    X64_RegisterRsi = 6,
    X64_RegisterRdi = 7,
    X64_RegisterR8 = 8,
    X64_RegisterR9 = 9,
    X64_RegisterR10 = 10,
    X64_RegisterR11 = 11,
    X64_RegisterR12 = 12,
    X64_RegisterR13 = 13,
    X64_RegisterR14 = 14,
    X64_RegisterR15 = 15,
    X64_RegisterRip = 16,
    X64_RegisterRFlags = 17,
    X64_RegisterXmm0 = 18,
    X64_RegisterXmm1 = 19,
    X64_RegisterXmm2 = 20,
    X64_RegisterXmm3 = 21,
    X64_RegisterXmm4 = 22,
    X64_RegisterXmm5 = 23,
    X64_RegisterXmm6 = 24,
    X64_RegisterXmm7 = 25,
    X64_RegisterXmm8 = 26,
    X64_RegisterXmm9 = 27,
    X64_RegisterXmm10 = 28,
    X64_RegisterXmm11 = 29,
    X64_RegisterXmm12 = 30,
    X64_RegisterXmm13 = 31,
    X64_RegisterXmm14 = 32,
    X64_RegisterXmm15 = 33,
    X64_RegisterFpMmx0 = 34,
    X64_RegisterFpMmx1 = 35,
    X64_RegisterFpMmx2 = 36,
    X64_RegisterFpMmx3 = 37,
    X64_RegisterFpMmx4 = 38,
    X64_RegisterFpMmx5 = 39,
    X64_RegisterFpMmx6 = 40,
    X64_RegisterFpMmx7 = 41,
    X64_RegisterFpControlStatus = 42,
    X64_RegisterXmmControlStatus = 43,
    X64_RegisterCr0 = 44,
    X64_RegisterCr2 = 45,
    X64_RegisterCr3 = 46,
    X64_RegisterCr4 = 47,
    X64_RegisterCr8 = 48,
    X64_RegisterEfer = 49,
    X64_RegisterDr0 = 50,
    X64_RegisterDr1 = 51,
    X64_RegisterDr2 = 52,
    X64_RegisterDr3 = 53,
    X64_RegisterDr6 = 54,
    X64_RegisterDr7 = 55,
    X64_RegisterEs = 56,
    X64_RegisterCs = 57,
    X64_RegisterSs = 58,
    X64_RegisterDs = 59,
    X64_RegisterFs = 60,
    X64_RegisterGs = 61,
    X64_RegisterLdtr = 62,
    X64_RegisterTr = 63,
    X64_RegisterIdtr = 64,
    X64_RegisterGdtr = 65,
    X64_RegisterMax = 66,
    ARM64_RegisterX0 = 67,
    ARM64_RegisterX1 = 68,
    ARM64_RegisterX2 = 69,
    ARM64_RegisterX3 = 70,
    ARM64_RegisterX4 = 71,
    ARM64_RegisterX5 = 72,
    ARM64_RegisterX6 = 73,
    ARM64_RegisterX7 = 74,
    ARM64_RegisterX8 = 75,
    ARM64_RegisterX9 = 76,
    ARM64_RegisterX10 = 77,
    ARM64_RegisterX11 = 78,
    ARM64_RegisterX12 = 79,
    ARM64_RegisterX13 = 80,
    ARM64_RegisterX14 = 81,
    ARM64_RegisterX15 = 82,
    ARM64_RegisterX16 = 83,
    ARM64_RegisterX17 = 84,
    ARM64_RegisterX18 = 85,
    ARM64_RegisterX19 = 86,
    ARM64_RegisterX20 = 87,
    ARM64_RegisterX21 = 88,
    ARM64_RegisterX22 = 89,
    ARM64_RegisterX23 = 90,
    ARM64_RegisterX24 = 91,
    ARM64_RegisterX25 = 92,
    ARM64_RegisterX26 = 93,
    ARM64_RegisterX27 = 94,
    ARM64_RegisterX28 = 95,
    ARM64_RegisterXFp = 96,
    ARM64_RegisterXLr = 97,
    ARM64_RegisterPc = 98,
    ARM64_RegisterSpEl0 = 99,
    ARM64_RegisterSpEl1 = 100,
    ARM64_RegisterCpsr = 101,
    ARM64_RegisterQ0 = 102,
    ARM64_RegisterQ1 = 103,
    ARM64_RegisterQ2 = 104,
    ARM64_RegisterQ3 = 105,
    ARM64_RegisterQ4 = 106,
    ARM64_RegisterQ5 = 107,
    ARM64_RegisterQ6 = 108,
    ARM64_RegisterQ7 = 109,
    ARM64_RegisterQ8 = 110,
    ARM64_RegisterQ9 = 111,
    ARM64_RegisterQ10 = 112,
    ARM64_RegisterQ11 = 113,
    ARM64_RegisterQ12 = 114,
    ARM64_RegisterQ13 = 115,
    ARM64_RegisterQ14 = 116,
    ARM64_RegisterQ15 = 117,
    ARM64_RegisterQ16 = 118,
    ARM64_RegisterQ17 = 119,
    ARM64_RegisterQ18 = 120,
    ARM64_RegisterQ19 = 121,
    ARM64_RegisterQ20 = 122,
    ARM64_RegisterQ21 = 123,
    ARM64_RegisterQ22 = 124,
    ARM64_RegisterQ23 = 125,
    ARM64_RegisterQ24 = 126,
    ARM64_RegisterQ25 = 127,
    ARM64_RegisterQ26 = 128,
    ARM64_RegisterQ27 = 129,
    ARM64_RegisterQ28 = 130,
    ARM64_RegisterQ29 = 131,
    ARM64_RegisterQ30 = 132,
    ARM64_RegisterQ31 = 133,
    ARM64_RegisterFpStatus = 134,
    ARM64_RegisterFpControl = 135,
    ARM64_RegisterEsrEl1 = 136,
    ARM64_RegisterSpsrEl1 = 137,
    ARM64_RegisterFarEl1 = 138,
    ARM64_RegisterParEl1 = 139,
    ARM64_RegisterElrEl1 = 140,
    ARM64_RegisterTtbr0El1 = 141,
    ARM64_RegisterTtbr1El1 = 142,
    ARM64_RegisterVbarEl1 = 143,
    ARM64_RegisterSctlrEl1 = 144,
    ARM64_RegisterActlrEl1 = 145,
    ARM64_RegisterTcrEl1 = 146,
    ARM64_RegisterMairEl1 = 147,
    ARM64_RegisterAmairEl1 = 148,
    ARM64_RegisterTpidrEl0 = 149,
    ARM64_RegisterTpidrroEl0 = 150,
    ARM64_RegisterTpidrEl1 = 151,
    ARM64_RegisterContextIdrEl1 = 152,
    ARM64_RegisterCpacrEl1 = 153,
    ARM64_RegisterCsselrEl1 = 154,
    ARM64_RegisterCntkctlEl1 = 155,
    ARM64_RegisterCntvCvalEl0 = 156,
    ARM64_RegisterCntvCtlEl0 = 157,
    ARM64_RegisterMax = 158,
};
pub const X64_RegisterRax = REGISTER_ID.X64_RegisterRax;
pub const X64_RegisterRcx = REGISTER_ID.X64_RegisterRcx;
pub const X64_RegisterRdx = REGISTER_ID.X64_RegisterRdx;
pub const X64_RegisterRbx = REGISTER_ID.X64_RegisterRbx;
pub const X64_RegisterRsp = REGISTER_ID.X64_RegisterRsp;
pub const X64_RegisterRbp = REGISTER_ID.X64_RegisterRbp;
pub const X64_RegisterRsi = REGISTER_ID.X64_RegisterRsi;
pub const X64_RegisterRdi = REGISTER_ID.X64_RegisterRdi;
pub const X64_RegisterR8 = REGISTER_ID.X64_RegisterR8;
pub const X64_RegisterR9 = REGISTER_ID.X64_RegisterR9;
pub const X64_RegisterR10 = REGISTER_ID.X64_RegisterR10;
pub const X64_RegisterR11 = REGISTER_ID.X64_RegisterR11;
pub const X64_RegisterR12 = REGISTER_ID.X64_RegisterR12;
pub const X64_RegisterR13 = REGISTER_ID.X64_RegisterR13;
pub const X64_RegisterR14 = REGISTER_ID.X64_RegisterR14;
pub const X64_RegisterR15 = REGISTER_ID.X64_RegisterR15;
pub const X64_RegisterRip = REGISTER_ID.X64_RegisterRip;
pub const X64_RegisterRFlags = REGISTER_ID.X64_RegisterRFlags;
pub const X64_RegisterXmm0 = REGISTER_ID.X64_RegisterXmm0;
pub const X64_RegisterXmm1 = REGISTER_ID.X64_RegisterXmm1;
pub const X64_RegisterXmm2 = REGISTER_ID.X64_RegisterXmm2;
pub const X64_RegisterXmm3 = REGISTER_ID.X64_RegisterXmm3;
pub const X64_RegisterXmm4 = REGISTER_ID.X64_RegisterXmm4;
pub const X64_RegisterXmm5 = REGISTER_ID.X64_RegisterXmm5;
pub const X64_RegisterXmm6 = REGISTER_ID.X64_RegisterXmm6;
pub const X64_RegisterXmm7 = REGISTER_ID.X64_RegisterXmm7;
pub const X64_RegisterXmm8 = REGISTER_ID.X64_RegisterXmm8;
pub const X64_RegisterXmm9 = REGISTER_ID.X64_RegisterXmm9;
pub const X64_RegisterXmm10 = REGISTER_ID.X64_RegisterXmm10;
pub const X64_RegisterXmm11 = REGISTER_ID.X64_RegisterXmm11;
pub const X64_RegisterXmm12 = REGISTER_ID.X64_RegisterXmm12;
pub const X64_RegisterXmm13 = REGISTER_ID.X64_RegisterXmm13;
pub const X64_RegisterXmm14 = REGISTER_ID.X64_RegisterXmm14;
pub const X64_RegisterXmm15 = REGISTER_ID.X64_RegisterXmm15;
pub const X64_RegisterFpMmx0 = REGISTER_ID.X64_RegisterFpMmx0;
pub const X64_RegisterFpMmx1 = REGISTER_ID.X64_RegisterFpMmx1;
pub const X64_RegisterFpMmx2 = REGISTER_ID.X64_RegisterFpMmx2;
pub const X64_RegisterFpMmx3 = REGISTER_ID.X64_RegisterFpMmx3;
pub const X64_RegisterFpMmx4 = REGISTER_ID.X64_RegisterFpMmx4;
pub const X64_RegisterFpMmx5 = REGISTER_ID.X64_RegisterFpMmx5;
pub const X64_RegisterFpMmx6 = REGISTER_ID.X64_RegisterFpMmx6;
pub const X64_RegisterFpMmx7 = REGISTER_ID.X64_RegisterFpMmx7;
pub const X64_RegisterFpControlStatus = REGISTER_ID.X64_RegisterFpControlStatus;
pub const X64_RegisterXmmControlStatus = REGISTER_ID.X64_RegisterXmmControlStatus;
pub const X64_RegisterCr0 = REGISTER_ID.X64_RegisterCr0;
pub const X64_RegisterCr2 = REGISTER_ID.X64_RegisterCr2;
pub const X64_RegisterCr3 = REGISTER_ID.X64_RegisterCr3;
pub const X64_RegisterCr4 = REGISTER_ID.X64_RegisterCr4;
pub const X64_RegisterCr8 = REGISTER_ID.X64_RegisterCr8;
pub const X64_RegisterEfer = REGISTER_ID.X64_RegisterEfer;
pub const X64_RegisterDr0 = REGISTER_ID.X64_RegisterDr0;
pub const X64_RegisterDr1 = REGISTER_ID.X64_RegisterDr1;
pub const X64_RegisterDr2 = REGISTER_ID.X64_RegisterDr2;
pub const X64_RegisterDr3 = REGISTER_ID.X64_RegisterDr3;
pub const X64_RegisterDr6 = REGISTER_ID.X64_RegisterDr6;
pub const X64_RegisterDr7 = REGISTER_ID.X64_RegisterDr7;
pub const X64_RegisterEs = REGISTER_ID.X64_RegisterEs;
pub const X64_RegisterCs = REGISTER_ID.X64_RegisterCs;
pub const X64_RegisterSs = REGISTER_ID.X64_RegisterSs;
pub const X64_RegisterDs = REGISTER_ID.X64_RegisterDs;
pub const X64_RegisterFs = REGISTER_ID.X64_RegisterFs;
pub const X64_RegisterGs = REGISTER_ID.X64_RegisterGs;
pub const X64_RegisterLdtr = REGISTER_ID.X64_RegisterLdtr;
pub const X64_RegisterTr = REGISTER_ID.X64_RegisterTr;
pub const X64_RegisterIdtr = REGISTER_ID.X64_RegisterIdtr;
pub const X64_RegisterGdtr = REGISTER_ID.X64_RegisterGdtr;
pub const X64_RegisterMax = REGISTER_ID.X64_RegisterMax;
pub const ARM64_RegisterX0 = REGISTER_ID.ARM64_RegisterX0;
pub const ARM64_RegisterX1 = REGISTER_ID.ARM64_RegisterX1;
pub const ARM64_RegisterX2 = REGISTER_ID.ARM64_RegisterX2;
pub const ARM64_RegisterX3 = REGISTER_ID.ARM64_RegisterX3;
pub const ARM64_RegisterX4 = REGISTER_ID.ARM64_RegisterX4;
pub const ARM64_RegisterX5 = REGISTER_ID.ARM64_RegisterX5;
pub const ARM64_RegisterX6 = REGISTER_ID.ARM64_RegisterX6;
pub const ARM64_RegisterX7 = REGISTER_ID.ARM64_RegisterX7;
pub const ARM64_RegisterX8 = REGISTER_ID.ARM64_RegisterX8;
pub const ARM64_RegisterX9 = REGISTER_ID.ARM64_RegisterX9;
pub const ARM64_RegisterX10 = REGISTER_ID.ARM64_RegisterX10;
pub const ARM64_RegisterX11 = REGISTER_ID.ARM64_RegisterX11;
pub const ARM64_RegisterX12 = REGISTER_ID.ARM64_RegisterX12;
pub const ARM64_RegisterX13 = REGISTER_ID.ARM64_RegisterX13;
pub const ARM64_RegisterX14 = REGISTER_ID.ARM64_RegisterX14;
pub const ARM64_RegisterX15 = REGISTER_ID.ARM64_RegisterX15;
pub const ARM64_RegisterX16 = REGISTER_ID.ARM64_RegisterX16;
pub const ARM64_RegisterX17 = REGISTER_ID.ARM64_RegisterX17;
pub const ARM64_RegisterX18 = REGISTER_ID.ARM64_RegisterX18;
pub const ARM64_RegisterX19 = REGISTER_ID.ARM64_RegisterX19;
pub const ARM64_RegisterX20 = REGISTER_ID.ARM64_RegisterX20;
pub const ARM64_RegisterX21 = REGISTER_ID.ARM64_RegisterX21;
pub const ARM64_RegisterX22 = REGISTER_ID.ARM64_RegisterX22;
pub const ARM64_RegisterX23 = REGISTER_ID.ARM64_RegisterX23;
pub const ARM64_RegisterX24 = REGISTER_ID.ARM64_RegisterX24;
pub const ARM64_RegisterX25 = REGISTER_ID.ARM64_RegisterX25;
pub const ARM64_RegisterX26 = REGISTER_ID.ARM64_RegisterX26;
pub const ARM64_RegisterX27 = REGISTER_ID.ARM64_RegisterX27;
pub const ARM64_RegisterX28 = REGISTER_ID.ARM64_RegisterX28;
pub const ARM64_RegisterXFp = REGISTER_ID.ARM64_RegisterXFp;
pub const ARM64_RegisterXLr = REGISTER_ID.ARM64_RegisterXLr;
pub const ARM64_RegisterPc = REGISTER_ID.ARM64_RegisterPc;
pub const ARM64_RegisterSpEl0 = REGISTER_ID.ARM64_RegisterSpEl0;
pub const ARM64_RegisterSpEl1 = REGISTER_ID.ARM64_RegisterSpEl1;
pub const ARM64_RegisterCpsr = REGISTER_ID.ARM64_RegisterCpsr;
pub const ARM64_RegisterQ0 = REGISTER_ID.ARM64_RegisterQ0;
pub const ARM64_RegisterQ1 = REGISTER_ID.ARM64_RegisterQ1;
pub const ARM64_RegisterQ2 = REGISTER_ID.ARM64_RegisterQ2;
pub const ARM64_RegisterQ3 = REGISTER_ID.ARM64_RegisterQ3;
pub const ARM64_RegisterQ4 = REGISTER_ID.ARM64_RegisterQ4;
pub const ARM64_RegisterQ5 = REGISTER_ID.ARM64_RegisterQ5;
pub const ARM64_RegisterQ6 = REGISTER_ID.ARM64_RegisterQ6;
pub const ARM64_RegisterQ7 = REGISTER_ID.ARM64_RegisterQ7;
pub const ARM64_RegisterQ8 = REGISTER_ID.ARM64_RegisterQ8;
pub const ARM64_RegisterQ9 = REGISTER_ID.ARM64_RegisterQ9;
pub const ARM64_RegisterQ10 = REGISTER_ID.ARM64_RegisterQ10;
pub const ARM64_RegisterQ11 = REGISTER_ID.ARM64_RegisterQ11;
pub const ARM64_RegisterQ12 = REGISTER_ID.ARM64_RegisterQ12;
pub const ARM64_RegisterQ13 = REGISTER_ID.ARM64_RegisterQ13;
pub const ARM64_RegisterQ14 = REGISTER_ID.ARM64_RegisterQ14;
pub const ARM64_RegisterQ15 = REGISTER_ID.ARM64_RegisterQ15;
pub const ARM64_RegisterQ16 = REGISTER_ID.ARM64_RegisterQ16;
pub const ARM64_RegisterQ17 = REGISTER_ID.ARM64_RegisterQ17;
pub const ARM64_RegisterQ18 = REGISTER_ID.ARM64_RegisterQ18;
pub const ARM64_RegisterQ19 = REGISTER_ID.ARM64_RegisterQ19;
pub const ARM64_RegisterQ20 = REGISTER_ID.ARM64_RegisterQ20;
pub const ARM64_RegisterQ21 = REGISTER_ID.ARM64_RegisterQ21;
pub const ARM64_RegisterQ22 = REGISTER_ID.ARM64_RegisterQ22;
pub const ARM64_RegisterQ23 = REGISTER_ID.ARM64_RegisterQ23;
pub const ARM64_RegisterQ24 = REGISTER_ID.ARM64_RegisterQ24;
pub const ARM64_RegisterQ25 = REGISTER_ID.ARM64_RegisterQ25;
pub const ARM64_RegisterQ26 = REGISTER_ID.ARM64_RegisterQ26;
pub const ARM64_RegisterQ27 = REGISTER_ID.ARM64_RegisterQ27;
pub const ARM64_RegisterQ28 = REGISTER_ID.ARM64_RegisterQ28;
pub const ARM64_RegisterQ29 = REGISTER_ID.ARM64_RegisterQ29;
pub const ARM64_RegisterQ30 = REGISTER_ID.ARM64_RegisterQ30;
pub const ARM64_RegisterQ31 = REGISTER_ID.ARM64_RegisterQ31;
pub const ARM64_RegisterFpStatus = REGISTER_ID.ARM64_RegisterFpStatus;
pub const ARM64_RegisterFpControl = REGISTER_ID.ARM64_RegisterFpControl;
pub const ARM64_RegisterEsrEl1 = REGISTER_ID.ARM64_RegisterEsrEl1;
pub const ARM64_RegisterSpsrEl1 = REGISTER_ID.ARM64_RegisterSpsrEl1;
pub const ARM64_RegisterFarEl1 = REGISTER_ID.ARM64_RegisterFarEl1;
pub const ARM64_RegisterParEl1 = REGISTER_ID.ARM64_RegisterParEl1;
pub const ARM64_RegisterElrEl1 = REGISTER_ID.ARM64_RegisterElrEl1;
pub const ARM64_RegisterTtbr0El1 = REGISTER_ID.ARM64_RegisterTtbr0El1;
pub const ARM64_RegisterTtbr1El1 = REGISTER_ID.ARM64_RegisterTtbr1El1;
pub const ARM64_RegisterVbarEl1 = REGISTER_ID.ARM64_RegisterVbarEl1;
pub const ARM64_RegisterSctlrEl1 = REGISTER_ID.ARM64_RegisterSctlrEl1;
pub const ARM64_RegisterActlrEl1 = REGISTER_ID.ARM64_RegisterActlrEl1;
pub const ARM64_RegisterTcrEl1 = REGISTER_ID.ARM64_RegisterTcrEl1;
pub const ARM64_RegisterMairEl1 = REGISTER_ID.ARM64_RegisterMairEl1;
pub const ARM64_RegisterAmairEl1 = REGISTER_ID.ARM64_RegisterAmairEl1;
pub const ARM64_RegisterTpidrEl0 = REGISTER_ID.ARM64_RegisterTpidrEl0;
pub const ARM64_RegisterTpidrroEl0 = REGISTER_ID.ARM64_RegisterTpidrroEl0;
pub const ARM64_RegisterTpidrEl1 = REGISTER_ID.ARM64_RegisterTpidrEl1;
pub const ARM64_RegisterContextIdrEl1 = REGISTER_ID.ARM64_RegisterContextIdrEl1;
pub const ARM64_RegisterCpacrEl1 = REGISTER_ID.ARM64_RegisterCpacrEl1;
pub const ARM64_RegisterCsselrEl1 = REGISTER_ID.ARM64_RegisterCsselrEl1;
pub const ARM64_RegisterCntkctlEl1 = REGISTER_ID.ARM64_RegisterCntkctlEl1;
pub const ARM64_RegisterCntvCvalEl0 = REGISTER_ID.ARM64_RegisterCntvCvalEl0;
pub const ARM64_RegisterCntvCtlEl0 = REGISTER_ID.ARM64_RegisterCntvCtlEl0;
pub const ARM64_RegisterMax = REGISTER_ID.ARM64_RegisterMax;

pub const VIRTUAL_PROCESSOR_REGISTER = extern union {
    Reg64: u64,
    Reg32: u32,
    Reg16: u16,
    Reg8: u8,
    Reg128: extern struct {
        Low64: u64,
        High64: u64,
    },
    X64: extern union {
        Segment: extern struct {
            Base: u64,
            Limit: u32,
            Selector: u16,
            Anonymous: extern union {
                Attributes: u16,
                Anonymous: extern struct {
                    _bitfield: u16,
                },
            },
        },
        Table: extern struct {
            Limit: u16,
            Base: u64,
        },
        FpControlStatus: extern struct {
            FpControl: u16,
            FpStatus: u16,
            FpTag: u8,
            Reserved: u8,
            LastFpOp: u16,
            Anonymous: extern union {
                LastFpRip: u64,
                Anonymous: extern struct {
                    LastFpEip: u32,
                    LastFpCs: u16,
                },
            },
        },
        XmmControlStatus: extern struct {
            Anonymous: extern union {
                LastFpRdp: u64,
                Anonymous: extern struct {
                    LastFpDp: u32,
                    LastFpDs: u16,
                },
            },
            XmmStatusControl: u32,
            XmmStatusControlMask: u32,
        },
    },
};

pub const DOS_IMAGE_INFO = extern struct {
    PdbName: ?[*:0]const u8,
    ImageBaseAddress: u64,
    ImageSize: u32,
    Timestamp: u32,
};

pub const GUEST_SYMBOLS_PROVIDER_DEBUG_INFO_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        InfoMessage: ?[*:0]const u8,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        InfoMessage: ?[*:0]const u8,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const FOUND_IMAGE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Context: ?*anyopaque,
        ImageInfo: ?*DOS_IMAGE_INFO,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        Context: ?*anyopaque,
        ImageInfo: ?*DOS_IMAGE_INFO,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const MODULE_INFO = extern struct {
    ProcessImageName: ?[*:0]const u8,
    Image: DOS_IMAGE_INFO,
};

//--------------------------------------------------------------------------------
// Section: Functions (125)
//--------------------------------------------------------------------------------
pub extern "winhvplatform" fn WHvGetCapability(
    CapabilityCode: WHV_CAPABILITY_CODE,
    // TODO: what to do with BytesParamIndex 2?
    CapabilityBuffer: ?*anyopaque,
    CapabilityBufferSizeInBytes: u32,
    WrittenSizeInBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCreatePartition(
    Partition: ?*WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetupPartition(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvResetPartition(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvDeletePartition(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetPartitionProperty(
    Partition: WHV_PARTITION_HANDLE,
    PropertyCode: WHV_PARTITION_PROPERTY_CODE,
    // TODO: what to do with BytesParamIndex 3?
    PropertyBuffer: ?*anyopaque,
    PropertyBufferSizeInBytes: u32,
    WrittenSizeInBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetPartitionProperty(
    Partition: WHV_PARTITION_HANDLE,
    PropertyCode: WHV_PARTITION_PROPERTY_CODE,
    // TODO: what to do with BytesParamIndex 3?
    PropertyBuffer: ?*const anyopaque,
    PropertyBufferSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSuspendPartitionTime(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvResumePartitionTime(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvMapGpaRange(
    Partition: WHV_PARTITION_HANDLE,
    SourceAddress: ?*anyopaque,
    GuestAddress: u64,
    SizeInBytes: u64,
    Flags: WHV_MAP_GPA_RANGE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvMapGpaRange2(
    Partition: WHV_PARTITION_HANDLE,
    Process: ?HANDLE,
    SourceAddress: ?*anyopaque,
    GuestAddress: u64,
    SizeInBytes: u64,
    Flags: WHV_MAP_GPA_RANGE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvUnmapGpaRange(
    Partition: WHV_PARTITION_HANDLE,
    GuestAddress: u64,
    SizeInBytes: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvTranslateGva(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    Gva: u64,
    TranslateFlags: WHV_TRANSLATE_GVA_FLAGS,
    TranslationResult: ?*WHV_TRANSLATE_GVA_RESULT,
    Gpa: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCreateVirtualProcessor(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCreateVirtualProcessor2(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    Properties: [*]const WHV_VIRTUAL_PROCESSOR_PROPERTY,
    PropertyCount: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvDeleteVirtualProcessor(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvRunVirtualProcessor(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    ExitContext: ?*anyopaque,
    ExitContextSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCancelRunVirtualProcessor(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorRegisters(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    RegisterNames: [*]const WHV_REGISTER_NAME,
    RegisterCount: u32,
    RegisterValues: [*]WHV_REGISTER_VALUE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetVirtualProcessorRegisters(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    RegisterNames: [*]const WHV_REGISTER_NAME,
    RegisterCount: u32,
    RegisterValues: [*]const WHV_REGISTER_VALUE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorInterruptControllerState(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    State: ?*anyopaque,
    StateSize: u32,
    WrittenSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetVirtualProcessorInterruptControllerState(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    State: ?*const anyopaque,
    StateSize: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvRequestInterrupt(
    Partition: WHV_PARTITION_HANDLE,
    Interrupt: ?*const WHV_INTERRUPT_CONTROL,
    InterruptControlSize: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorXsaveState(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    Buffer: ?*anyopaque,
    BufferSizeInBytes: u32,
    BytesWritten: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetVirtualProcessorXsaveState(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    Buffer: ?*const anyopaque,
    BufferSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvQueryGpaRangeDirtyBitmap(
    Partition: WHV_PARTITION_HANDLE,
    GuestAddress: u64,
    RangeSizeInBytes: u64,
    // TODO: what to do with BytesParamIndex 4?
    Bitmap: ?*u64,
    BitmapSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetPartitionCounters(
    Partition: WHV_PARTITION_HANDLE,
    CounterSet: WHV_PARTITION_COUNTER_SET,
    // TODO: what to do with BytesParamIndex 3?
    Buffer: ?*anyopaque,
    BufferSizeInBytes: u32,
    BytesWritten: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorCounters(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    CounterSet: WHV_PROCESSOR_COUNTER_SET,
    // TODO: what to do with BytesParamIndex 4?
    Buffer: ?*anyopaque,
    BufferSizeInBytes: u32,
    BytesWritten: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorInterruptControllerState2(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    State: ?*anyopaque,
    StateSize: u32,
    WrittenSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetVirtualProcessorInterruptControllerState2(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    // TODO: what to do with BytesParamIndex 3?
    State: ?*const anyopaque,
    StateSize: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvRegisterPartitionDoorbellEvent(
    Partition: WHV_PARTITION_HANDLE,
    MatchData: ?*const WHV_DOORBELL_MATCH_DATA,
    EventHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvUnregisterPartitionDoorbellEvent(
    Partition: WHV_PARTITION_HANDLE,
    MatchData: ?*const WHV_DOORBELL_MATCH_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvAdviseGpaRange(
    Partition: WHV_PARTITION_HANDLE,
    GpaRanges: [*]const WHV_MEMORY_RANGE_ENTRY,
    GpaRangesCount: u32,
    Advice: WHV_ADVISE_GPA_RANGE_CODE,
    // TODO: what to do with BytesParamIndex 5?
    AdviceBuffer: ?*const anyopaque,
    AdviceBufferSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvReadGpaRange(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    GuestAddress: u64,
    Controls: WHV_ACCESS_GPA_CONTROLS,
    // TODO: what to do with BytesParamIndex 5?
    Data: ?*anyopaque,
    DataSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvWriteGpaRange(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    GuestAddress: u64,
    Controls: WHV_ACCESS_GPA_CONTROLS,
    // TODO: what to do with BytesParamIndex 5?
    Data: ?*const anyopaque,
    DataSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSignalVirtualProcessorSynicEvent(
    Partition: WHV_PARTITION_HANDLE,
    SynicEvent: WHV_SYNIC_EVENT_PARAMETERS,
    NewlySignaled: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorState(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    StateType: WHV_VIRTUAL_PROCESSOR_STATE_TYPE,
    // TODO: what to do with BytesParamIndex 4?
    Buffer: ?*anyopaque,
    BufferSizeInBytes: u32,
    BytesWritten: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetVirtualProcessorState(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    StateType: WHV_VIRTUAL_PROCESSOR_STATE_TYPE,
    // TODO: what to do with BytesParamIndex 4?
    Buffer: ?*const anyopaque,
    BufferSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvAllocateVpciResource(
    ProviderId: ?*const Guid,
    Flags: WHV_ALLOCATE_VPCI_RESOURCE_FLAGS,
    ResourceDescriptor: ?[*]const u8,
    ResourceDescriptorSizeInBytes: u32,
    VpciResource: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCreateVpciDevice(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    VpciResource: ?HANDLE,
    Flags: WHV_CREATE_VPCI_DEVICE_FLAGS,
    NotificationEventHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvDeleteVpciDevice(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVpciDeviceProperty(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    PropertyCode: WHV_VPCI_DEVICE_PROPERTY_CODE,
    // TODO: what to do with BytesParamIndex 4?
    PropertyBuffer: ?*anyopaque,
    PropertyBufferSizeInBytes: u32,
    WrittenSizeInBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVpciDeviceNotification(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    // TODO: what to do with BytesParamIndex 3?
    Notification: ?*WHV_VPCI_DEVICE_NOTIFICATION,
    NotificationSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvMapVpciDeviceMmioRanges(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    MappingCount: ?*u32,
    Mappings: ?*?*WHV_VPCI_MMIO_MAPPING,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvUnmapVpciDeviceMmioRanges(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetVpciDevicePowerState(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    PowerState: DEVICE_POWER_STATE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvReadVpciDeviceRegister(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    Register: ?*const WHV_VPCI_DEVICE_REGISTER,
    Data: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvWriteVpciDeviceRegister(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    Register: ?*const WHV_VPCI_DEVICE_REGISTER,
    Data: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvMapVpciDeviceInterrupt(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    Index: u32,
    MessageCount: u32,
    Target: ?*const WHV_VPCI_INTERRUPT_TARGET,
    MsiAddress: ?*u64,
    MsiData: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvUnmapVpciDeviceInterrupt(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    Index: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvRetargetVpciDeviceInterrupt(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    MsiAddress: u64,
    MsiData: u32,
    Target: ?*const WHV_VPCI_INTERRUPT_TARGET,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvRequestVpciDeviceInterrupt(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    MsiAddress: u64,
    MsiData: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVpciDeviceInterruptTarget(
    Partition: WHV_PARTITION_HANDLE,
    LogicalDeviceId: u64,
    Index: u32,
    MultiMessageNumber: u32,
    // TODO: what to do with BytesParamIndex 5?
    Target: ?*WHV_VPCI_INTERRUPT_TARGET,
    TargetSizeInBytes: u32,
    BytesWritten: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCreateTrigger(
    Partition: WHV_PARTITION_HANDLE,
    Parameters: ?*const WHV_TRIGGER_PARAMETERS,
    TriggerHandle: ?*?*anyopaque,
    EventHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvUpdateTriggerParameters(
    Partition: WHV_PARTITION_HANDLE,
    Parameters: ?*const WHV_TRIGGER_PARAMETERS,
    TriggerHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvDeleteTrigger(
    Partition: WHV_PARTITION_HANDLE,
    TriggerHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCreateNotificationPort(
    Partition: WHV_PARTITION_HANDLE,
    Parameters: ?*const WHV_NOTIFICATION_PORT_PARAMETERS,
    EventHandle: ?HANDLE,
    PortHandle: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvSetNotificationPortProperty(
    Partition: WHV_PARTITION_HANDLE,
    PortHandle: ?*anyopaque,
    PropertyCode: WHV_NOTIFICATION_PORT_PROPERTY_CODE,
    PropertyValue: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvDeleteNotificationPort(
    Partition: WHV_PARTITION_HANDLE,
    PortHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvPostVirtualProcessorSynicMessage(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    SintIndex: u32,
    // TODO: what to do with BytesParamIndex 4?
    Message: ?*const anyopaque,
    MessageSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetVirtualProcessorCpuidOutput(
    Partition: WHV_PARTITION_HANDLE,
    VpIndex: u32,
    Eax: u32,
    Ecx: u32,
    CpuidOutput: ?*WHV_CPUID_OUTPUT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvGetInterruptTargetVpSet(
    Partition: WHV_PARTITION_HANDLE,
    Destination: u64,
    DestinationMode: WHV_INTERRUPT_DESTINATION_MODE,
    TargetVps: [*]u32,
    VpCount: u32,
    TargetVpCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvStartPartitionMigration(
    Partition: WHV_PARTITION_HANDLE,
    MigrationHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCancelPartitionMigration(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvCompletePartitionMigration(
    Partition: WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvplatform" fn WHvAcceptPartitionMigration(
    MigrationHandle: ?HANDLE,
    Partition: ?*WHV_PARTITION_HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvemulation" fn WHvEmulatorCreateEmulator(
    Callbacks: ?*const WHV_EMULATOR_CALLBACKS,
    Emulator: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvemulation" fn WHvEmulatorDestroyEmulator(
    Emulator: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvemulation" fn WHvEmulatorTryIoEmulation(
    Emulator: ?*anyopaque,
    Context: ?*anyopaque,
    VpContext: ?*const WHV_VP_EXIT_CONTEXT,
    IoInstructionContext: ?*const WHV_X64_IO_PORT_ACCESS_CONTEXT,
    EmulatorReturnStatus: ?*WHV_EMULATOR_STATUS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winhvemulation" fn WHvEmulatorTryMmioEmulation(
    Emulator: ?*anyopaque,
    Context: ?*anyopaque,
    VpContext: ?*const WHV_VP_EXIT_CONTEXT,
    MmioInstructionContext: ?*const WHV_MEMORY_ACCESS_CONTEXT,
    EmulatorReturnStatus: ?*WHV_EMULATOR_STATUS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvInitializeDeviceHost(
    computeSystem: HCS_SYSTEM,
    deviceHostHandle: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvTeardownDeviceHost(
    deviceHostHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvCreateDeviceInstance(
    deviceHostHandle: ?*anyopaque,
    deviceType: HDV_DEVICE_TYPE,
    deviceClassId: ?*const Guid,
    deviceInstanceId: ?*const Guid,
    deviceInterface: ?*const anyopaque,
    deviceContext: ?*anyopaque,
    deviceHandle: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvReadGuestMemory(
    requestor: ?*anyopaque,
    guestPhysicalAddress: u64,
    byteCount: u32,
    buffer: [*:0]u8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvWriteGuestMemory(
    requestor: ?*anyopaque,
    guestPhysicalAddress: u64,
    byteCount: u32,
    buffer: [*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvCreateGuestMemoryAperture(
    requestor: ?*anyopaque,
    guestPhysicalAddress: u64,
    byteCount: u32,
    writeProtected: BOOL,
    mappedAddress: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvDestroyGuestMemoryAperture(
    requestor: ?*anyopaque,
    mappedAddress: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvDeliverGuestInterrupt(
    requestor: ?*anyopaque,
    msiAddress: u64,
    msiData: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvRegisterDoorbell(
    requestor: ?*anyopaque,
    BarIndex: HDV_PCI_BAR_SELECTOR,
    BarOffset: u64,
    TriggerValue: u64,
    Flags: u64,
    DoorbellEvent: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvUnregisterDoorbell(
    requestor: ?*anyopaque,
    BarIndex: HDV_PCI_BAR_SELECTOR,
    BarOffset: u64,
    TriggerValue: u64,
    Flags: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvCreateSectionBackedMmioRange(
    requestor: ?*anyopaque,
    barIndex: HDV_PCI_BAR_SELECTOR,
    offsetInPages: u64,
    lengthInPages: u64,
    MappingFlags: HDV_MMIO_MAPPING_FLAGS,
    sectionHandle: ?HANDLE,
    sectionOffsetInPages: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmdevicehost" fn HdvDestroySectionBackedMmioRange(
    requestor: ?*anyopaque,
    barIndex: HDV_PCI_BAR_SELECTOR,
    offsetInPages: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn LocateSavedStateFiles(
    vmName: ?[*:0]const u16,
    snapshotName: ?[*:0]const u16,
    binPath: ?*?PWSTR,
    vsvPath: ?*?PWSTR,
    vmrsPath: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn LoadSavedStateFile(
    vmrsFile: ?[*:0]const u16,
    vmSavedStateDumpHandle: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ApplyPendingSavedStateFileReplayLog(
    vmrsFile: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn LoadSavedStateFiles(
    binFile: ?[*:0]const u16,
    vsvFile: ?[*:0]const u16,
    vmSavedStateDumpHandle: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ReleaseSavedStateFiles(
    vmSavedStateDumpHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetGuestEnabledVirtualTrustLevels(
    vmSavedStateDumpHandle: ?*anyopaque,
    virtualTrustLevels: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetGuestOsInfo(
    vmSavedStateDumpHandle: ?*anyopaque,
    virtualTrustLevel: u8,
    guestOsInfo: ?*GUEST_OS_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetVpCount(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetArchitecture(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    architecture: ?*VIRTUAL_PROCESSOR_ARCH,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ForceArchitecture(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    architecture: VIRTUAL_PROCESSOR_ARCH,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetActiveVirtualTrustLevel(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    virtualTrustLevel: ?*u8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetEnabledVirtualTrustLevels(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    virtualTrustLevels: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ForceActiveVirtualTrustLevel(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    virtualTrustLevel: u8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn IsActiveVirtualTrustLevelEnabled(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    activeVirtualTrustLevelEnabled: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn IsNestedVirtualizationEnabled(
    vmSavedStateDumpHandle: ?*anyopaque,
    enabled: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetNestedVirtualizationMode(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    enabled: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ForceNestedHostMode(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    hostMode: BOOL,
    oldMode: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn InKernelSpace(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    inKernelSpace: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetRegisterValue(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    registerId: u32,
    registerValue: ?*VIRTUAL_PROCESSOR_REGISTER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetPagingMode(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    pagingMode: ?*PAGING_MODE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ForcePagingMode(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    pagingMode: PAGING_MODE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ReadGuestPhysicalAddress(
    vmSavedStateDumpHandle: ?*anyopaque,
    physicalAddress: u64,
    // TODO: what to do with BytesParamIndex 3?
    buffer: ?*anyopaque,
    bufferSize: u32,
    bytesRead: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GuestVirtualAddressToPhysicalAddress(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    virtualAddress: u64,
    physicalAddress: ?*u64,
    unmappedRegionSize: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetGuestPhysicalMemoryChunks(
    vmSavedStateDumpHandle: ?*anyopaque,
    memoryChunkPageSize: ?*u64,
    memoryChunks: ?*GPA_MEMORY_CHUNK,
    memoryChunkCount: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GuestPhysicalAddressToRawSavedMemoryOffset(
    vmSavedStateDumpHandle: ?*anyopaque,
    physicalAddress: u64,
    rawSavedMemoryOffset: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ReadGuestRawSavedMemory(
    vmSavedStateDumpHandle: ?*anyopaque,
    rawSavedMemoryOffset: u64,
    // TODO: what to do with BytesParamIndex 3?
    buffer: ?*anyopaque,
    bufferSize: u32,
    bytesRead: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetGuestRawSavedMemorySize(
    vmSavedStateDumpHandle: ?*anyopaque,
    guestRawSavedMemorySize: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn SetMemoryBlockCacheLimit(
    vmSavedStateDumpHandle: ?*anyopaque,
    memoryBlockCacheLimit: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetMemoryBlockCacheLimit(
    vmSavedStateDumpHandle: ?*anyopaque,
    memoryBlockCacheLimit: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ApplyGuestMemoryFix(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    virtualAddress: u64,
    fixBuffer: ?*anyopaque,
    fixBufferSize: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn LoadSavedStateSymbolProvider(
    vmSavedStateDumpHandle: ?*anyopaque,
    userSymbols: ?[*:0]const u16,
    force: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ReleaseSavedStateSymbolProvider(
    vmSavedStateDumpHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetSavedStateSymbolProviderHandle(
    vmSavedStateDumpHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

pub extern "vmsavedstatedumpprovider" fn SetSavedStateSymbolProviderDebugInfoCallback(
    vmSavedStateDumpHandle: ?*anyopaque,
    Callback: ?GUEST_SYMBOLS_PROVIDER_DEBUG_INFO_CALLBACK,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn LoadSavedStateModuleSymbols(
    vmSavedStateDumpHandle: ?*anyopaque,
    imageName: ?[*:0]const u8,
    moduleName: ?[*:0]const u8,
    baseAddress: u64,
    sizeOfBase: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn LoadSavedStateModuleSymbolsEx(
    vmSavedStateDumpHandle: ?*anyopaque,
    imageName: ?[*:0]const u8,
    imageTimestamp: u32,
    moduleName: ?[*:0]const u8,
    baseAddress: u64,
    sizeOfBase: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ResolveSavedStateGlobalVariableAddress(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    globalName: ?[*:0]const u8,
    virtualAddress: ?*u64,
    size: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ReadSavedStateGlobalVariable(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    globalName: ?[*:0]const u8,
    buffer: ?*anyopaque,
    bufferSize: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetSavedStateSymbolTypeSize(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    typeName: ?[*:0]const u8,
    size: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn FindSavedStateSymbolFieldInType(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    typeName: ?[*:0]const u8,
    fieldName: ?[*:0]const u16,
    offset: ?*u32,
    found: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn GetSavedStateSymbolFieldInfo(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    typeName: ?[*:0]const u8,
    typeFieldInfoMap: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn ScanMemoryForDosImages(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    startAddress: u64,
    endAddress: u64,
    callbackContext: ?*anyopaque,
    foundImageCallback: ?FOUND_IMAGE_CALLBACK,
    standaloneAddress: ?*u64,
    standaloneAddressCount: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "vmsavedstatedumpprovider" fn CallStackUnwind(
    vmSavedStateDumpHandle: ?*anyopaque,
    vpId: u32,
    imageInfo: ?*MODULE_INFO,
    imageInfoCount: u32,
    frameCount: u32,
    callStack: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (9)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const DEVICE_POWER_STATE = @import("../system/power.zig").DEVICE_POWER_STATE;
const HANDLE = @import("../foundation.zig").HANDLE;
const HCS_SYSTEM = @import("../system/host_compute_system.zig").HCS_SYSTEM;
const HRESULT = @import("../foundation.zig").HRESULT;
const LUID = @import("../foundation.zig").LUID;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "WHV_EMULATOR_IO_PORT_CALLBACK")) {
        _ = WHV_EMULATOR_IO_PORT_CALLBACK;
    }
    if (@hasDecl(@This(), "WHV_EMULATOR_MEMORY_CALLBACK")) {
        _ = WHV_EMULATOR_MEMORY_CALLBACK;
    }
    if (@hasDecl(@This(), "WHV_EMULATOR_GET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK")) {
        _ = WHV_EMULATOR_GET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK;
    }
    if (@hasDecl(@This(), "WHV_EMULATOR_SET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK")) {
        _ = WHV_EMULATOR_SET_VIRTUAL_PROCESSOR_REGISTERS_CALLBACK;
    }
    if (@hasDecl(@This(), "WHV_EMULATOR_TRANSLATE_GVA_PAGE_CALLBACK")) {
        _ = WHV_EMULATOR_TRANSLATE_GVA_PAGE_CALLBACK;
    }
    if (@hasDecl(@This(), "HDV_PCI_DEVICE_INITIALIZE")) {
        _ = HDV_PCI_DEVICE_INITIALIZE;
    }
    if (@hasDecl(@This(), "HDV_PCI_DEVICE_TEARDOWN")) {
        _ = HDV_PCI_DEVICE_TEARDOWN;
    }
    if (@hasDecl(@This(), "HDV_PCI_DEVICE_SET_CONFIGURATION")) {
        _ = HDV_PCI_DEVICE_SET_CONFIGURATION;
    }
    if (@hasDecl(@This(), "HDV_PCI_DEVICE_GET_DETAILS")) {
        _ = HDV_PCI_DEVICE_GET_DETAILS;
    }
    if (@hasDecl(@This(), "HDV_PCI_DEVICE_START")) {
        _ = HDV_PCI_DEVICE_START;
    }
    if (@hasDecl(@This(), "HDV_PCI_DEVICE_STOP")) {
        _ = HDV_PCI_DEVICE_STOP;
    }
    if (@hasDecl(@This(), "HDV_PCI_READ_CONFIG_SPACE")) {
        _ = HDV_PCI_READ_CONFIG_SPACE;
    }
    if (@hasDecl(@This(), "HDV_PCI_WRITE_CONFIG_SPACE")) {
        _ = HDV_PCI_WRITE_CONFIG_SPACE;
    }
    if (@hasDecl(@This(), "HDV_PCI_READ_INTERCEPTED_MEMORY")) {
        _ = HDV_PCI_READ_INTERCEPTED_MEMORY;
    }
    if (@hasDecl(@This(), "HDV_PCI_WRITE_INTERCEPTED_MEMORY")) {
        _ = HDV_PCI_WRITE_INTERCEPTED_MEMORY;
    }
    if (@hasDecl(@This(), "GUEST_SYMBOLS_PROVIDER_DEBUG_INFO_CALLBACK")) {
        _ = GUEST_SYMBOLS_PROVIDER_DEBUG_INFO_CALLBACK;
    }
    if (@hasDecl(@This(), "FOUND_IMAGE_CALLBACK")) {
        _ = FOUND_IMAGE_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
