//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (12)
//--------------------------------------------------------------------------------
pub const NETWORK_ALIVE_LAN = @as(u32, 1);
pub const NETWORK_ALIVE_WAN = @as(u32, 2);
pub const NETWORK_ALIVE_AOL = @as(u32, 4);
pub const NETWORK_ALIVE_INTERNET = @as(u32, 8);
pub const CONNECTION_AOL = @as(u32, 4);
pub const SENSGUID_PUBLISHER = Guid.initString("5fee1bd6-5b9b-11d1-8dd2-00aa004abd5e");
pub const SENSGUID_SUBSCRIBER_LCE = Guid.initString("d3938ab0-5b9d-11d1-8dd2-00aa004abd5e");
pub const SENSGUID_SUBSCRIBER_WININET = Guid.initString("d3938ab5-5b9d-11d1-8dd2-00aa004abd5e");
pub const SENSGUID_EVENTCLASS_NETWORK = Guid.initString("d5978620-5b9f-11d1-8dd2-00aa004abd5e");
pub const SENSGUID_EVENTCLASS_LOGON = Guid.initString("d5978630-5b9f-11d1-8dd2-00aa004abd5e");
pub const SENSGUID_EVENTCLASS_ONNOW = Guid.initString("d5978640-5b9f-11d1-8dd2-00aa004abd5e");
pub const SENSGUID_EVENTCLASS_LOGON2 = Guid.initString("d5978650-5b9f-11d1-8dd2-00aa004abd5e");

//--------------------------------------------------------------------------------
// Section: Types (8)
//--------------------------------------------------------------------------------
pub const SENS_CONNECTION_TYPE = enum(u32) {
    LAN = 0,
    WAN = 1,
};
pub const CONNECTION_LAN = SENS_CONNECTION_TYPE.LAN;
pub const CONNECTION_WAN = SENS_CONNECTION_TYPE.WAN;

pub const QOCINFO = extern struct {
    dwSize: u32,
    dwFlags: u32,
    dwInSpeed: u32,
    dwOutSpeed: u32,
};

const CLSID_SENS_Value = Guid.initString("d597cafe-5b9f-11d1-8dd2-00aa004abd5e");
pub const CLSID_SENS = &CLSID_SENS_Value;

pub const SENS_QOCINFO = extern struct {
    dwSize: u32,
    dwFlags: u32,
    dwOutSpeed: u32,
    dwInSpeed: u32,
};

// TODO: this type is limited to platform 'windows5.1.2600'
const IID_ISensNetwork_Value = Guid.initString("d597bab1-5b9f-11d1-8dd2-00aa004abd5e");
pub const IID_ISensNetwork = &IID_ISensNetwork_Value;
pub const ISensNetwork = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        ConnectionMade: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensNetwork,
                bstrConnection: ?BSTR,
                ulType: u32,
                lpQOCInfo: ?*SENS_QOCINFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensNetwork,
                bstrConnection: ?BSTR,
                ulType: u32,
                lpQOCInfo: ?*SENS_QOCINFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ConnectionMadeNoQOCInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensNetwork,
                bstrConnection: ?BSTR,
                ulType: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensNetwork,
                bstrConnection: ?BSTR,
                ulType: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ConnectionLost: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensNetwork,
                bstrConnection: ?BSTR,
                ulType: SENS_CONNECTION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensNetwork,
                bstrConnection: ?BSTR,
                ulType: SENS_CONNECTION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DestinationReachable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensNetwork,
                bstrDestination: ?BSTR,
                bstrConnection: ?BSTR,
                ulType: u32,
                lpQOCInfo: ?*SENS_QOCINFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensNetwork,
                bstrDestination: ?BSTR,
                bstrConnection: ?BSTR,
                ulType: u32,
                lpQOCInfo: ?*SENS_QOCINFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DestinationReachableNoQOCInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensNetwork,
                bstrDestination: ?BSTR,
                bstrConnection: ?BSTR,
                ulType: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensNetwork,
                bstrDestination: ?BSTR,
                bstrConnection: ?BSTR,
                ulType: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensNetwork_ConnectionMade(self: *const T, bstrConnection: ?BSTR, ulType: u32, lpQOCInfo: ?*SENS_QOCINFO) HRESULT {
                return @as(*const ISensNetwork.VTable, @ptrCast(self.vtable)).ConnectionMade(@as(*const ISensNetwork, @ptrCast(self)), bstrConnection, ulType, lpQOCInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensNetwork_ConnectionMadeNoQOCInfo(self: *const T, bstrConnection: ?BSTR, ulType: u32) HRESULT {
                return @as(*const ISensNetwork.VTable, @ptrCast(self.vtable)).ConnectionMadeNoQOCInfo(@as(*const ISensNetwork, @ptrCast(self)), bstrConnection, ulType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensNetwork_ConnectionLost(self: *const T, bstrConnection: ?BSTR, ulType: SENS_CONNECTION_TYPE) HRESULT {
                return @as(*const ISensNetwork.VTable, @ptrCast(self.vtable)).ConnectionLost(@as(*const ISensNetwork, @ptrCast(self)), bstrConnection, ulType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensNetwork_DestinationReachable(self: *const T, bstrDestination: ?BSTR, bstrConnection: ?BSTR, ulType: u32, lpQOCInfo: ?*SENS_QOCINFO) HRESULT {
                return @as(*const ISensNetwork.VTable, @ptrCast(self.vtable)).DestinationReachable(@as(*const ISensNetwork, @ptrCast(self)), bstrDestination, bstrConnection, ulType, lpQOCInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensNetwork_DestinationReachableNoQOCInfo(self: *const T, bstrDestination: ?BSTR, bstrConnection: ?BSTR, ulType: u32) HRESULT {
                return @as(*const ISensNetwork.VTable, @ptrCast(self.vtable)).DestinationReachableNoQOCInfo(@as(*const ISensNetwork, @ptrCast(self)), bstrDestination, bstrConnection, ulType);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows5.1.2600'
const IID_ISensOnNow_Value = Guid.initString("d597bab2-5b9f-11d1-8dd2-00aa004abd5e");
pub const IID_ISensOnNow = &IID_ISensOnNow_Value;
pub const ISensOnNow = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        OnACPower: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensOnNow,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensOnNow,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnBatteryPower: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensOnNow,
                dwBatteryLifePercent: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensOnNow,
                dwBatteryLifePercent: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BatteryLow: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensOnNow,
                dwBatteryLifePercent: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensOnNow,
                dwBatteryLifePercent: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensOnNow_OnACPower(self: *const T) HRESULT {
                return @as(*const ISensOnNow.VTable, @ptrCast(self.vtable)).OnACPower(@as(*const ISensOnNow, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensOnNow_OnBatteryPower(self: *const T, dwBatteryLifePercent: u32) HRESULT {
                return @as(*const ISensOnNow.VTable, @ptrCast(self.vtable)).OnBatteryPower(@as(*const ISensOnNow, @ptrCast(self)), dwBatteryLifePercent);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensOnNow_BatteryLow(self: *const T, dwBatteryLifePercent: u32) HRESULT {
                return @as(*const ISensOnNow.VTable, @ptrCast(self.vtable)).BatteryLow(@as(*const ISensOnNow, @ptrCast(self)), dwBatteryLifePercent);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows5.1.2600'
const IID_ISensLogon_Value = Guid.initString("d597bab3-5b9f-11d1-8dd2-00aa004abd5e");
pub const IID_ISensLogon = &IID_ISensLogon_Value;
pub const ISensLogon = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        Logon: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Logoff: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StartShell: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisplayLock: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisplayUnlock: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StartScreenSaver: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StopScreenSaver: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon,
                bstrUserName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_Logon(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).Logon(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_Logoff(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).Logoff(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_StartShell(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).StartShell(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_DisplayLock(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).DisplayLock(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_DisplayUnlock(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).DisplayUnlock(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_StartScreenSaver(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).StartScreenSaver(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon_StopScreenSaver(self: *const T, bstrUserName: ?BSTR) HRESULT {
                return @as(*const ISensLogon.VTable, @ptrCast(self.vtable)).StopScreenSaver(@as(*const ISensLogon, @ptrCast(self)), bstrUserName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows5.1.2600'
const IID_ISensLogon2_Value = Guid.initString("d597bab4-5b9f-11d1-8dd2-00aa004abd5e");
pub const IID_ISensLogon2 = &IID_ISensLogon2_Value;
pub const ISensLogon2 = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        Logon: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Logoff: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SessionDisconnect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SessionReconnect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PostShell: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const ISensLogon2,
                bstrUserName: ?BSTR,
                dwSessionId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon2_Logon(self: *const T, bstrUserName: ?BSTR, dwSessionId: u32) HRESULT {
                return @as(*const ISensLogon2.VTable, @ptrCast(self.vtable)).Logon(@as(*const ISensLogon2, @ptrCast(self)), bstrUserName, dwSessionId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon2_Logoff(self: *const T, bstrUserName: ?BSTR, dwSessionId: u32) HRESULT {
                return @as(*const ISensLogon2.VTable, @ptrCast(self.vtable)).Logoff(@as(*const ISensLogon2, @ptrCast(self)), bstrUserName, dwSessionId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon2_SessionDisconnect(self: *const T, bstrUserName: ?BSTR, dwSessionId: u32) HRESULT {
                return @as(*const ISensLogon2.VTable, @ptrCast(self.vtable)).SessionDisconnect(@as(*const ISensLogon2, @ptrCast(self)), bstrUserName, dwSessionId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon2_SessionReconnect(self: *const T, bstrUserName: ?BSTR, dwSessionId: u32) HRESULT {
                return @as(*const ISensLogon2.VTable, @ptrCast(self.vtable)).SessionReconnect(@as(*const ISensLogon2, @ptrCast(self)), bstrUserName, dwSessionId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn ISensLogon2_PostShell(self: *const T, bstrUserName: ?BSTR, dwSessionId: u32) HRESULT {
                return @as(*const ISensLogon2.VTable, @ptrCast(self.vtable)).PostShell(@as(*const ISensLogon2, @ptrCast(self)), bstrUserName, dwSessionId);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (3)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "sensapi" fn IsDestinationReachableA(
    lpszDestination: ?[*:0]const u8,
    lpQOCInfo: ?*QOCINFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "sensapi" fn IsDestinationReachableW(
    lpszDestination: ?[*:0]const u16,
    lpQOCInfo: ?*QOCINFO,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "sensapi" fn IsNetworkAlive(
    lpdwFlags: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (1)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const IsDestinationReachable = thismodule.IsDestinationReachableA;
    },
    .wide => struct {
        pub const IsDestinationReachable = thismodule.IsDestinationReachableW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const IsDestinationReachable = *opaque {};
    } else struct {
        pub const IsDestinationReachable = @compileError("'IsDestinationReachable' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BSTR = @import("../foundation.zig").BSTR;
const HRESULT = @import("../foundation.zig").HRESULT;
const IDispatch = @import("../system/com.zig").IDispatch;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
