//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (197)
//--------------------------------------------------------------------------------
pub const WDS_CLI_TRANSFER_ASYNCHRONOUS = @as(u32, 1);
pub const WDS_CLI_NO_SPARSE_FILE = @as(u32, 2);
pub const PXE_DHCP_SERVER_PORT = @as(u32, 67);
pub const PXE_DHCP_CLIENT_PORT = @as(u32, 68);
pub const PXE_SERVER_PORT = @as(u32, 4011);
pub const PXE_DHCPV6_SERVER_PORT = @as(u32, 547);
pub const PXE_DHCPV6_CLIENT_PORT = @as(u32, 546);
pub const PXE_DHCP_FILE_SIZE = @as(u32, 128);
pub const PXE_DHCP_SERVER_SIZE = @as(u32, 64);
pub const PXE_DHCP_HWAADR_SIZE = @as(u32, 16);
pub const PXE_DHCP_MAGIC_COOKIE_SIZE = @as(u32, 4);
pub const PXE_REG_INDEX_TOP = @as(u32, 0);
pub const PXE_REG_INDEX_BOTTOM = @as(u32, 4294967295);
pub const PXE_CALLBACK_RECV_REQUEST = @as(u32, 0);
pub const PXE_CALLBACK_SHUTDOWN = @as(u32, 1);
pub const PXE_CALLBACK_SERVICE_CONTROL = @as(u32, 2);
pub const PXE_CALLBACK_MAX = @as(u32, 3);
pub const PXE_GSI_TRACE_ENABLED = @as(u32, 1);
pub const PXE_GSI_SERVER_DUID = @as(u32, 2);
pub const PXE_MAX_ADDRESS = @as(u32, 16);
pub const PXE_ADDR_BROADCAST = @as(u32, 1);
pub const PXE_ADDR_USE_PORT = @as(u32, 2);
pub const PXE_ADDR_USE_ADDR = @as(u32, 4);
pub const PXE_ADDR_USE_DHCP_RULES = @as(u32, 8);
pub const PXE_DHCPV6_RELAY_HOP_COUNT_LIMIT = @as(u32, 32);
pub const PXE_BA_NBP = @as(u32, 1);
pub const PXE_BA_CUSTOM = @as(u32, 2);
pub const PXE_BA_IGNORE = @as(u32, 3);
pub const PXE_BA_REJECTED = @as(u32, 4);
pub const PXE_TRACE_VERBOSE = @as(u32, 65536);
pub const PXE_TRACE_INFO = @as(u32, 131072);
pub const PXE_TRACE_WARNING = @as(u32, 262144);
pub const PXE_TRACE_ERROR = @as(u32, 524288);
pub const PXE_TRACE_FATAL = @as(u32, 1048576);
pub const PXE_PROV_ATTR_FILTER = @as(u32, 0);
pub const PXE_PROV_ATTR_FILTER_IPV6 = @as(u32, 1);
pub const PXE_PROV_ATTR_IPV6_CAPABLE = @as(u32, 2);
pub const PXE_PROV_FILTER_ALL = @as(u32, 0);
pub const PXE_PROV_FILTER_DHCP_ONLY = @as(u32, 1);
pub const PXE_PROV_FILTER_PXE_ONLY = @as(u32, 2);
pub const MC_SERVER_CURRENT_VERSION = @as(u32, 1);
pub const TRANSPORTPROVIDER_CURRENT_VERSION = @as(u32, 1);
pub const WDS_MC_TRACE_VERBOSE = @as(u32, 65536);
pub const WDS_MC_TRACE_INFO = @as(u32, 131072);
pub const WDS_MC_TRACE_WARNING = @as(u32, 262144);
pub const WDS_MC_TRACE_ERROR = @as(u32, 524288);
pub const WDS_MC_TRACE_FATAL = @as(u32, 1048576);
pub const WDS_TRANSPORTCLIENT_CURRENT_API_VERSION = @as(u32, 1);
pub const WDS_TRANSPORTCLIENT_PROTOCOL_MULTICAST = @as(u32, 1);
pub const WDS_TRANSPORTCLIENT_NO_CACHE = @as(u32, 0);
pub const WDS_TRANSPORTCLIENT_STATUS_IN_PROGRESS = @as(u32, 1);
pub const WDS_TRANSPORTCLIENT_STATUS_SUCCESS = @as(u32, 2);
pub const WDS_TRANSPORTCLIENT_STATUS_FAILURE = @as(u32, 3);
pub const WDSTRANSPORT_RESOURCE_UTILIZATION_UNKNOWN = @as(u32, 255);
pub const WDSBP_PK_TYPE_DHCP = @as(u32, 1);
pub const WDSBP_PK_TYPE_WDSNBP = @as(u32, 2);
pub const WDSBP_PK_TYPE_BCD = @as(u32, 4);
pub const WDSBP_PK_TYPE_DHCPV6 = @as(u32, 8);
pub const WDSBP_OPT_TYPE_NONE = @as(u32, 0);
pub const WDSBP_OPT_TYPE_BYTE = @as(u32, 1);
pub const WDSBP_OPT_TYPE_USHORT = @as(u32, 2);
pub const WDSBP_OPT_TYPE_ULONG = @as(u32, 3);
pub const WDSBP_OPT_TYPE_WSTR = @as(u32, 4);
pub const WDSBP_OPT_TYPE_STR = @as(u32, 5);
pub const WDSBP_OPT_TYPE_IP4 = @as(u32, 6);
pub const WDSBP_OPT_TYPE_IP6 = @as(u32, 7);
pub const WDSBP_OPTVAL_ACTION_APPROVAL = @as(u32, 1);
pub const WDSBP_OPTVAL_ACTION_REFERRAL = @as(u32, 3);
pub const WDSBP_OPTVAL_ACTION_ABORT = @as(u32, 5);
pub const WDSBP_OPTVAL_PXE_PROMPT_OPTIN = @as(u32, 1);
pub const WDSBP_OPTVAL_PXE_PROMPT_NOPROMPT = @as(u32, 2);
pub const WDSBP_OPTVAL_PXE_PROMPT_OPTOUT = @as(u32, 3);
pub const WDSBP_OPTVAL_NBP_VER_7 = @as(u32, 1792);
pub const WDSBP_OPTVAL_NBP_VER_8 = @as(u32, 2048);
pub const FACILITY_WDSMCSERVER = @as(u32, 289);
pub const FACILITY_WDSMCCLIENT = @as(u32, 290);
pub const WDSMCSERVER_CATEGORY = @import("../zig.zig").typedConst(HRESULT, @as(i32, 1));
pub const WDSMCCLIENT_CATEGORY = @import("../zig.zig").typedConst(HRESULT, @as(i32, 2));
pub const WDSMCS_E_SESSION_SHUTDOWN_IN_PROGRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801664));
pub const WDSMCS_E_REQCALLBACKS_NOT_REG = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801663));
pub const WDSMCS_E_INCOMPATIBLE_VERSION = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801662));
pub const WDSMCS_E_CONTENT_NOT_FOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801661));
pub const WDSMCS_E_CLIENT_NOT_FOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801660));
pub const WDSMCS_E_NAMESPACE_NOT_FOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801659));
pub const WDSMCS_E_CONTENT_PROVIDER_NOT_FOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801658));
pub const WDSMCS_E_NAMESPACE_ALREADY_EXISTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801657));
pub const WDSMCS_E_NAMESPACE_SHUTDOWN_IN_PROGRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801656));
pub const WDSMCS_E_NAMESPACE_ALREADY_STARTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801655));
pub const WDSMCS_E_NS_START_FAILED_NO_CLIENTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801654));
pub const WDSMCS_E_START_TIME_IN_PAST = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801653));
pub const WDSMCS_E_PACKET_NOT_HASHED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801652));
pub const WDSMCS_E_PACKET_NOT_SIGNED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801651));
pub const WDSMCS_E_PACKET_HAS_SECURITY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801650));
pub const WDSMCS_E_PACKET_NOT_CHECKSUMED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801649));
pub const WDSMCS_E_CLIENT_DOESNOT_SUPPORT_SECURITY_MODE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801648));
pub const EVT_WDSMCS_S_PARAMETERS_READ = @import("../zig.zig").typedConst(HRESULT, @as(i32, 1092682240));
pub const EVT_WDSMCS_E_PARAMETERS_READ_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801407));
pub const EVT_WDSMCS_E_DUPLICATE_MULTICAST_ADDR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801406));
pub const EVT_WDSMCS_E_NON_WDS_DUPLICATE_MULTICAST_ADDR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801405));
pub const EVT_WDSMCS_E_CP_DLL_LOAD_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801328));
pub const EVT_WDSMCS_E_CP_INIT_FUNC_MISSING = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801327));
pub const EVT_WDSMCS_E_CP_INIT_FUNC_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801326));
pub const EVT_WDSMCS_E_CP_INCOMPATIBLE_SERVER_VERSION = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801325));
pub const EVT_WDSMCS_E_CP_CALLBACKS_NOT_REG = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801324));
pub const EVT_WDSMCS_E_CP_SHUTDOWN_FUNC_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801323));
pub const EVT_WDSMCS_E_CP_MEMORY_LEAK = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801322));
pub const EVT_WDSMCS_E_CP_OPEN_INSTANCE_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801321));
pub const EVT_WDSMCS_E_CP_CLOSE_INSTANCE_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801320));
pub const EVT_WDSMCS_E_CP_OPEN_CONTENT_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801319));
pub const EVT_WDSMCS_W_CP_DLL_LOAD_FAILED_NOT_CRITICAL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2128543142));
pub const EVT_WDSMCS_E_CP_DLL_LOAD_FAILED_CRITICAL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801317));
pub const EVT_WDSMCS_E_NSREG_START_TIME_IN_PAST = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801152));
pub const EVT_WDSMCS_E_NSREG_CONTENT_PROVIDER_NOT_REG = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801151));
pub const EVT_WDSMCS_E_NSREG_NAMESPACE_EXISTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801150));
pub const EVT_WDSMCS_E_NSREG_FAILURE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054801149));
pub const WDSTPC_E_CALLBACKS_NOT_REG = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735616));
pub const WDSTPC_E_ALREADY_COMPLETED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735615));
pub const WDSTPC_E_ALREADY_IN_PROGRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735614));
pub const WDSTPC_E_UNKNOWN_ERROR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735613));
pub const WDSTPC_E_NOT_INITIALIZED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735612));
pub const WDSTPC_E_KICKED_POLICY_NOT_MET = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735611));
pub const WDSTPC_E_KICKED_FALLBACK = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735610));
pub const WDSTPC_E_KICKED_FAIL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735609));
pub const WDSTPC_E_KICKED_UNKNOWN = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735608));
pub const WDSTPC_E_MULTISTREAM_NOT_ENABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735607));
pub const WDSTPC_E_ALREADY_IN_LOWEST_SESSION = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735606));
pub const WDSTPC_E_CLIENT_DEMOTE_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735605));
pub const WDSTPC_E_NO_IP4_INTERFACE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735604));
pub const WDSTPTC_E_WIM_APPLY_REQUIRES_REFERENCE_IMAGE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1054735603));
pub const FACILITY_WDSTPTMGMT = @as(u32, 272);
pub const WDSTPTMGMT_CATEGORY = @import("../zig.zig").typedConst(HRESULT, @as(i32, 1));
pub const WDSTPTMGMT_E_INVALID_PROPERTY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915776));
pub const WDSTPTMGMT_E_INVALID_OPERATION = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915775));
pub const WDSTPTMGMT_E_INVALID_CLASS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915774));
pub const WDSTPTMGMT_E_CONTENT_PROVIDER_ALREADY_REGISTERED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915773));
pub const WDSTPTMGMT_E_CONTENT_PROVIDER_NOT_REGISTERED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915772));
pub const WDSTPTMGMT_E_INVALID_CONTENT_PROVIDER_NAME = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915771));
pub const WDSTPTMGMT_E_TRANSPORT_SERVER_ROLE_NOT_CONFIGURED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915770));
pub const WDSTPTMGMT_E_NAMESPACE_ALREADY_REGISTERED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915769));
pub const WDSTPTMGMT_E_NAMESPACE_NOT_REGISTERED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915768));
pub const WDSTPTMGMT_E_CANNOT_REINITIALIZE_OBJECT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915767));
pub const WDSTPTMGMT_E_INVALID_NAMESPACE_NAME = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915766));
pub const WDSTPTMGMT_E_INVALID_NAMESPACE_DATA = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915765));
pub const WDSTPTMGMT_E_NAMESPACE_READ_ONLY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915764));
pub const WDSTPTMGMT_E_INVALID_NAMESPACE_START_TIME = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915763));
pub const WDSTPTMGMT_E_INVALID_DIAGNOSTICS_COMPONENTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915762));
pub const WDSTPTMGMT_E_CANNOT_REFRESH_DIRTY_OBJECT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915761));
pub const WDSTPTMGMT_E_INVALID_SERVICE_IP_ADDRESS_RANGE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915760));
pub const WDSTPTMGMT_E_INVALID_SERVICE_PORT_RANGE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915759));
pub const WDSTPTMGMT_E_INVALID_NAMESPACE_START_PARAMETERS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915758));
pub const WDSTPTMGMT_E_TRANSPORT_SERVER_UNAVAILABLE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915757));
pub const WDSTPTMGMT_E_NAMESPACE_NOT_ON_SERVER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915756));
pub const WDSTPTMGMT_E_NAMESPACE_REMOVED_FROM_SERVER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915755));
pub const WDSTPTMGMT_E_INVALID_IP_ADDRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915754));
pub const WDSTPTMGMT_E_INVALID_IPV4_MULTICAST_ADDRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915753));
pub const WDSTPTMGMT_E_INVALID_IPV6_MULTICAST_ADDRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915752));
pub const WDSTPTMGMT_E_IPV6_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915751));
pub const WDSTPTMGMT_E_INVALID_IPV6_MULTICAST_ADDRESS_SOURCE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915750));
pub const WDSTPTMGMT_E_INVALID_MULTISTREAM_STREAM_COUNT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915749));
pub const WDSTPTMGMT_E_INVALID_AUTO_DISCONNECT_THRESHOLD = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915748));
pub const WDSTPTMGMT_E_MULTICAST_SESSION_POLICY_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915747));
pub const WDSTPTMGMT_E_INVALID_SLOW_CLIENT_HANDLING_TYPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915746));
pub const WDSTPTMGMT_E_NETWORK_PROFILES_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915745));
pub const WDSTPTMGMT_E_UDP_PORT_POLICY_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915744));
pub const WDSTPTMGMT_E_TFTP_MAX_BLOCKSIZE_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915743));
pub const WDSTPTMGMT_E_TFTP_VAR_WINDOW_NOT_SUPPORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915742));
pub const WDSTPTMGMT_E_INVALID_TFTP_MAX_BLOCKSIZE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -1055915741));
pub const WdsCliFlagEnumFilterVersion = @as(i32, 1);
pub const WdsCliFlagEnumFilterFirmware = @as(i32, 2);
pub const WDS_LOG_TYPE_CLIENT_ERROR = @as(i32, 1);
pub const WDS_LOG_TYPE_CLIENT_STARTED = @as(i32, 2);
pub const WDS_LOG_TYPE_CLIENT_FINISHED = @as(i32, 3);
pub const WDS_LOG_TYPE_CLIENT_IMAGE_SELECTED = @as(i32, 4);
pub const WDS_LOG_TYPE_CLIENT_APPLY_STARTED = @as(i32, 5);
pub const WDS_LOG_TYPE_CLIENT_APPLY_FINISHED = @as(i32, 6);
pub const WDS_LOG_TYPE_CLIENT_GENERIC_MESSAGE = @as(i32, 7);
pub const WDS_LOG_TYPE_CLIENT_UNATTEND_MODE = @as(i32, 8);
pub const WDS_LOG_TYPE_CLIENT_TRANSFER_START = @as(i32, 9);
pub const WDS_LOG_TYPE_CLIENT_TRANSFER_END = @as(i32, 10);
pub const WDS_LOG_TYPE_CLIENT_TRANSFER_DOWNGRADE = @as(i32, 11);
pub const WDS_LOG_TYPE_CLIENT_DOMAINJOINERROR = @as(i32, 12);
pub const WDS_LOG_TYPE_CLIENT_POST_ACTIONS_START = @as(i32, 13);
pub const WDS_LOG_TYPE_CLIENT_POST_ACTIONS_END = @as(i32, 14);
pub const WDS_LOG_TYPE_CLIENT_APPLY_STARTED_2 = @as(i32, 15);
pub const WDS_LOG_TYPE_CLIENT_APPLY_FINISHED_2 = @as(i32, 16);
pub const WDS_LOG_TYPE_CLIENT_DOMAINJOINERROR_2 = @as(i32, 17);
pub const WDS_LOG_TYPE_CLIENT_DRIVER_PACKAGE_NOT_ACCESSIBLE = @as(i32, 18);
pub const WDS_LOG_TYPE_CLIENT_OFFLINE_DRIVER_INJECTION_START = @as(i32, 19);
pub const WDS_LOG_TYPE_CLIENT_OFFLINE_DRIVER_INJECTION_END = @as(i32, 20);
pub const WDS_LOG_TYPE_CLIENT_OFFLINE_DRIVER_INJECTION_FAILURE = @as(i32, 21);
pub const WDS_LOG_TYPE_CLIENT_IMAGE_SELECTED2 = @as(i32, 22);
pub const WDS_LOG_TYPE_CLIENT_IMAGE_SELECTED3 = @as(i32, 23);
pub const WDS_LOG_TYPE_CLIENT_MAX_CODE = @as(i32, 24);
pub const WDS_LOG_LEVEL_DISABLED = @as(i32, 0);
pub const WDS_LOG_LEVEL_ERROR = @as(i32, 1);
pub const WDS_LOG_LEVEL_WARNING = @as(i32, 2);
pub const WDS_LOG_LEVEL_INFO = @as(i32, 3);

//--------------------------------------------------------------------------------
// Section: Types (89)
//--------------------------------------------------------------------------------
pub const CPU_ARCHITECTURE = enum(u32) {
    AMD64 = 9,
    IA64 = 6,
    INTEL = 0,
};
pub const CPU_ARCHITECTURE_AMD64 = CPU_ARCHITECTURE.AMD64;
pub const CPU_ARCHITECTURE_IA64 = CPU_ARCHITECTURE.IA64;
pub const CPU_ARCHITECTURE_INTEL = CPU_ARCHITECTURE.INTEL;

pub const PFN_WDS_CLI_CALLBACK_MESSAGE_ID = enum(u32) {
    START = 0,
    COMPLETE = 1,
    PROGRESS = 2,
    TEXT = 3,
};
// TODO: enum 'PFN_WDS_CLI_CALLBACK_MESSAGE_ID' has known issues with its value aliases

pub const WDS_TRANSPORTCLIENT_REQUEST_AUTH_LEVEL = enum(u32) {
    AUTH = 1,
    NO_AUTH = 2,
};
pub const WDS_TRANSPORTCLIENT_AUTH = WDS_TRANSPORTCLIENT_REQUEST_AUTH_LEVEL.AUTH;
pub const WDS_TRANSPORTCLIENT_NO_AUTH = WDS_TRANSPORTCLIENT_REQUEST_AUTH_LEVEL.NO_AUTH;

pub const WDS_CLI_CRED = extern struct {
    pwszUserName: ?[*:0]const u16,
    pwszDomain: ?[*:0]const u16,
    pwszPassword: ?[*:0]const u16,
};

pub const PFN_WdsCliTraceFunction = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pwszFormat: ?[*:0]const u16,
        Params: ?*i8,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        pwszFormat: ?[*:0]const u16,
        Params: ?*i8,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const WDS_CLI_IMAGE_TYPE = enum(i32) {
    UNKNOWN = 0,
    WIM = 1,
    VHD = 2,
    VHDX = 3,
};
pub const WDS_CLI_IMAGE_TYPE_UNKNOWN = WDS_CLI_IMAGE_TYPE.UNKNOWN;
pub const WDS_CLI_IMAGE_TYPE_WIM = WDS_CLI_IMAGE_TYPE.WIM;
pub const WDS_CLI_IMAGE_TYPE_VHD = WDS_CLI_IMAGE_TYPE.VHD;
pub const WDS_CLI_IMAGE_TYPE_VHDX = WDS_CLI_IMAGE_TYPE.VHDX;

pub const WDS_CLI_FIRMWARE_TYPE = enum(i32) {
    UNKNOWN = 0,
    BIOS = 1,
    EFI = 2,
};
pub const WDS_CLI_FIRMWARE_UNKNOWN = WDS_CLI_FIRMWARE_TYPE.UNKNOWN;
pub const WDS_CLI_FIRMWARE_BIOS = WDS_CLI_FIRMWARE_TYPE.BIOS;
pub const WDS_CLI_FIRMWARE_EFI = WDS_CLI_FIRMWARE_TYPE.EFI;

pub const WDS_CLI_IMAGE_PARAM_TYPE = enum(i32) {
    UNKNOWN = 0,
    SPARSE_FILE = 1,
    SUPPORTED_FIRMWARES = 2,
};
pub const WDS_CLI_IMAGE_PARAM_UNKNOWN = WDS_CLI_IMAGE_PARAM_TYPE.UNKNOWN;
pub const WDS_CLI_IMAGE_PARAM_SPARSE_FILE = WDS_CLI_IMAGE_PARAM_TYPE.SPARSE_FILE;
pub const WDS_CLI_IMAGE_PARAM_SUPPORTED_FIRMWARES = WDS_CLI_IMAGE_PARAM_TYPE.SUPPORTED_FIRMWARES;

pub const PFN_WdsCliCallback = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        dwMessageId: PFN_WDS_CLI_CALLBACK_MESSAGE_ID,
        wParam: WPARAM,
        lParam: LPARAM,
        pvUserData: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        dwMessageId: PFN_WDS_CLI_CALLBACK_MESSAGE_ID,
        wParam: WPARAM,
        lParam: LPARAM,
        pvUserData: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PXE_DHCP_OPTION = extern struct {
    OptionType: u8,
    OptionLength: u8,
    OptionValue: [1]u8,
};

pub const PXE_DHCP_MESSAGE = extern struct {
    Operation: u8 align(1),
    HardwareAddressType: u8 align(1),
    HardwareAddressLength: u8 align(1),
    HopCount: u8 align(1),
    TransactionID: u32 align(1),
    SecondsSinceBoot: u16 align(1),
    Reserved: u16 align(1),
    ClientIpAddress: u32 align(1),
    YourIpAddress: u32 align(1),
    BootstrapServerAddress: u32 align(1),
    RelayAgentIpAddress: u32 align(1),
    HardwareAddress: [16]u8 align(1),
    HostName: [64]u8 align(1),
    BootFileName: [128]u8 align(1),
    Anonymous: extern union {
        bMagicCookie: [4]u8 align(1),
        uMagicCookie: u32 align(1),
    } align(1),
    Option: PXE_DHCP_OPTION align(1),
};

pub const PXE_DHCPV6_OPTION = extern struct {
    OptionCode: u16 align(1),
    DataLength: u16 align(1),
    Data: [1]u8 align(1),
};

pub const PXE_DHCPV6_MESSAGE_HEADER = extern struct {
    MessageType: u8,
    Message: [1]u8,
};

pub const PXE_DHCPV6_MESSAGE = extern struct {
    MessageType: u8,
    TransactionIDByte1: u8,
    TransactionIDByte2: u8,
    TransactionIDByte3: u8,
    Options: [1]PXE_DHCPV6_OPTION,
};

pub const PXE_DHCPV6_RELAY_MESSAGE = extern struct {
    MessageType: u8,
    HopCount: u8,
    LinkAddress: [16]u8,
    PeerAddress: [16]u8,
    Options: [1]PXE_DHCPV6_OPTION,
};

pub const PXE_PROVIDER = extern struct {
    uSizeOfStruct: u32,
    pwszName: ?PWSTR,
    pwszFilePath: ?PWSTR,
    bIsCritical: BOOL,
    uIndex: u32,
};

pub const PXE_ADDRESS = extern struct {
    uFlags: u32,
    Anonymous: extern union {
        bAddress: [16]u8,
        uIpAddress: u32,
    },
    uAddrLen: u32,
    uPort: u16,
};

pub const PXE_DHCPV6_NESTED_RELAY_MESSAGE = extern struct {
    pRelayMessage: ?*PXE_DHCPV6_RELAY_MESSAGE,
    cbRelayMessage: u32,
    pInterfaceIdOption: ?*anyopaque,
    cbInterfaceIdOption: u16,
};

pub const TRANSPORTPROVIDER_CALLBACK_ID = enum(i32) {
    CREATE_INSTANCE = 0,
    COMPARE_CONTENT = 1,
    OPEN_CONTENT = 2,
    USER_ACCESS_CHECK = 3,
    GET_CONTENT_SIZE = 4,
    READ_CONTENT = 5,
    CLOSE_CONTENT = 6,
    CLOSE_INSTANCE = 7,
    SHUTDOWN = 8,
    DUMP_STATE = 9,
    REFRESH_SETTINGS = 10,
    GET_CONTENT_METADATA = 11,
    MAX_CALLBACKS = 12,
};
pub const WDS_TRANSPORTPROVIDER_CREATE_INSTANCE = TRANSPORTPROVIDER_CALLBACK_ID.CREATE_INSTANCE;
pub const WDS_TRANSPORTPROVIDER_COMPARE_CONTENT = TRANSPORTPROVIDER_CALLBACK_ID.COMPARE_CONTENT;
pub const WDS_TRANSPORTPROVIDER_OPEN_CONTENT = TRANSPORTPROVIDER_CALLBACK_ID.OPEN_CONTENT;
pub const WDS_TRANSPORTPROVIDER_USER_ACCESS_CHECK = TRANSPORTPROVIDER_CALLBACK_ID.USER_ACCESS_CHECK;
pub const WDS_TRANSPORTPROVIDER_GET_CONTENT_SIZE = TRANSPORTPROVIDER_CALLBACK_ID.GET_CONTENT_SIZE;
pub const WDS_TRANSPORTPROVIDER_READ_CONTENT = TRANSPORTPROVIDER_CALLBACK_ID.READ_CONTENT;
pub const WDS_TRANSPORTPROVIDER_CLOSE_CONTENT = TRANSPORTPROVIDER_CALLBACK_ID.CLOSE_CONTENT;
pub const WDS_TRANSPORTPROVIDER_CLOSE_INSTANCE = TRANSPORTPROVIDER_CALLBACK_ID.CLOSE_INSTANCE;
pub const WDS_TRANSPORTPROVIDER_SHUTDOWN = TRANSPORTPROVIDER_CALLBACK_ID.SHUTDOWN;
pub const WDS_TRANSPORTPROVIDER_DUMP_STATE = TRANSPORTPROVIDER_CALLBACK_ID.DUMP_STATE;
pub const WDS_TRANSPORTPROVIDER_REFRESH_SETTINGS = TRANSPORTPROVIDER_CALLBACK_ID.REFRESH_SETTINGS;
pub const WDS_TRANSPORTPROVIDER_GET_CONTENT_METADATA = TRANSPORTPROVIDER_CALLBACK_ID.GET_CONTENT_METADATA;
pub const WDS_TRANSPORTPROVIDER_MAX_CALLBACKS = TRANSPORTPROVIDER_CALLBACK_ID.MAX_CALLBACKS;

pub const WDS_TRANSPORTPROVIDER_INIT_PARAMS = extern struct {
    ulLength: u32,
    ulMcServerVersion: u32,
    hRegistryKey: ?HKEY,
    hProvider: ?HANDLE,
};

pub const WDS_TRANSPORTPROVIDER_SETTINGS = extern struct {
    ulLength: u32,
    ulProviderVersion: u32,
};

pub const TRANSPORTCLIENT_CALLBACK_ID = enum(i32) {
    SESSION_START = 0,
    RECEIVE_CONTENTS = 1,
    SESSION_COMPLETE = 2,
    RECEIVE_METADATA = 3,
    SESSION_STARTEX = 4,
    SESSION_NEGOTIATE = 5,
    MAX_CALLBACKS = 6,
};
pub const WDS_TRANSPORTCLIENT_SESSION_START = TRANSPORTCLIENT_CALLBACK_ID.SESSION_START;
pub const WDS_TRANSPORTCLIENT_RECEIVE_CONTENTS = TRANSPORTCLIENT_CALLBACK_ID.RECEIVE_CONTENTS;
pub const WDS_TRANSPORTCLIENT_SESSION_COMPLETE = TRANSPORTCLIENT_CALLBACK_ID.SESSION_COMPLETE;
pub const WDS_TRANSPORTCLIENT_RECEIVE_METADATA = TRANSPORTCLIENT_CALLBACK_ID.RECEIVE_METADATA;
pub const WDS_TRANSPORTCLIENT_SESSION_STARTEX = TRANSPORTCLIENT_CALLBACK_ID.SESSION_STARTEX;
pub const WDS_TRANSPORTCLIENT_SESSION_NEGOTIATE = TRANSPORTCLIENT_CALLBACK_ID.SESSION_NEGOTIATE;
pub const WDS_TRANSPORTCLIENT_MAX_CALLBACKS = TRANSPORTCLIENT_CALLBACK_ID.MAX_CALLBACKS;

pub const TRANSPORTCLIENT_SESSION_INFO = extern struct {
    ulStructureLength: u32,
    ullFileSize: ULARGE_INTEGER,
    ulBlockSize: u32,
};

pub const PFN_WdsTransportClientSessionStart = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        ullFileSize: ?*ULARGE_INTEGER,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        ullFileSize: ?*ULARGE_INTEGER,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFN_WdsTransportClientSessionStartEx = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        Info: ?*TRANSPORTCLIENT_SESSION_INFO,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        Info: ?*TRANSPORTCLIENT_SESSION_INFO,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFN_WdsTransportClientReceiveMetadata = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        // TODO: what to do with BytesParamIndex 3?
        pMetadata: ?*anyopaque,
        ulSize: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        // TODO: what to do with BytesParamIndex 3?
        pMetadata: ?*anyopaque,
        ulSize: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFN_WdsTransportClientReceiveContents = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        // TODO: what to do with BytesParamIndex 3?
        pContents: ?*anyopaque,
        ulSize: u32,
        pullContentOffset: ?*ULARGE_INTEGER,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        // TODO: what to do with BytesParamIndex 3?
        pContents: ?*anyopaque,
        ulSize: u32,
        pullContentOffset: ?*ULARGE_INTEGER,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFN_WdsTransportClientSessionComplete = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        dwError: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        dwError: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFN_WdsTransportClientSessionNegotiate = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        pInfo: ?*TRANSPORTCLIENT_SESSION_INFO,
        hNegotiateKey: ?HANDLE,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hSessionKey: ?HANDLE,
        pCallerData: ?*anyopaque,
        pInfo: ?*TRANSPORTCLIENT_SESSION_INFO,
        hNegotiateKey: ?HANDLE,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const WDS_TRANSPORTCLIENT_REQUEST = extern struct {
    ulLength: u32,
    ulApiVersion: u32,
    ulAuthLevel: WDS_TRANSPORTCLIENT_REQUEST_AUTH_LEVEL,
    pwszServer: ?[*:0]const u16,
    pwszNamespace: ?[*:0]const u16,
    pwszObjectName: ?[*:0]const u16,
    ulCacheSize: u32,
    ulProtocol: u32,
    pvProtocolData: ?*anyopaque,
    ulProtocolDataLength: u32,
};

pub const WDS_TRANSPORTCLIENT_CALLBACKS = extern struct {
    SessionStart: ?PFN_WdsTransportClientSessionStart,
    SessionStartEx: ?PFN_WdsTransportClientSessionStartEx,
    ReceiveContents: ?PFN_WdsTransportClientReceiveContents,
    ReceiveMetadata: ?PFN_WdsTransportClientReceiveMetadata,
    SessionComplete: ?PFN_WdsTransportClientSessionComplete,
    SessionNegotiate: ?PFN_WdsTransportClientSessionNegotiate,
};

const CLSID_WdsTransportCacheable_Value = Guid.initString("70590b16-f146-46bd-bd9d-4aaa90084bf5");
pub const CLSID_WdsTransportCacheable = &CLSID_WdsTransportCacheable_Value;

const CLSID_WdsTransportCollection_Value = Guid.initString("c7f18b09-391e-436e-b10b-c3ef46f2c34f");
pub const CLSID_WdsTransportCollection = &CLSID_WdsTransportCollection_Value;

const CLSID_WdsTransportManager_Value = Guid.initString("f21523f6-837c-4a58-af99-8a7e27f8ff59");
pub const CLSID_WdsTransportManager = &CLSID_WdsTransportManager_Value;

const CLSID_WdsTransportServer_Value = Guid.initString("ea19b643-4adf-4413-942c-14f379118760");
pub const CLSID_WdsTransportServer = &CLSID_WdsTransportServer_Value;

const CLSID_WdsTransportSetupManager_Value = Guid.initString("c7beeaad-9f04-4923-9f0c-fbf52bc7590f");
pub const CLSID_WdsTransportSetupManager = &CLSID_WdsTransportSetupManager_Value;

const CLSID_WdsTransportConfigurationManager_Value = Guid.initString("8743f674-904c-47ca-8512-35fe98f6b0ac");
pub const CLSID_WdsTransportConfigurationManager = &CLSID_WdsTransportConfigurationManager_Value;

const CLSID_WdsTransportNamespaceManager_Value = Guid.initString("f08cdb63-85de-4a28-a1a9-5ca3e7efda73");
pub const CLSID_WdsTransportNamespaceManager = &CLSID_WdsTransportNamespaceManager_Value;

const CLSID_WdsTransportServicePolicy_Value = Guid.initString("65aceadc-2f0b-4f43-9f4d-811865d8cead");
pub const CLSID_WdsTransportServicePolicy = &CLSID_WdsTransportServicePolicy_Value;

const CLSID_WdsTransportDiagnosticsPolicy_Value = Guid.initString("eb3333e1-a7ad-46f5-80d6-6b740204e509");
pub const CLSID_WdsTransportDiagnosticsPolicy = &CLSID_WdsTransportDiagnosticsPolicy_Value;

const CLSID_WdsTransportMulticastSessionPolicy_Value = Guid.initString("3c6bc3f4-6418-472a-b6f1-52d457195437");
pub const CLSID_WdsTransportMulticastSessionPolicy = &CLSID_WdsTransportMulticastSessionPolicy_Value;

const CLSID_WdsTransportNamespace_Value = Guid.initString("d8385768-0732-4ec1-95ea-16da581908a1");
pub const CLSID_WdsTransportNamespace = &CLSID_WdsTransportNamespace_Value;

const CLSID_WdsTransportNamespaceAutoCast_Value = Guid.initString("b091f5a8-6a99-478d-b23b-09e8fee04574");
pub const CLSID_WdsTransportNamespaceAutoCast = &CLSID_WdsTransportNamespaceAutoCast_Value;

const CLSID_WdsTransportNamespaceScheduledCast_Value = Guid.initString("badc1897-7025-44eb-9108-fb61c4055792");
pub const CLSID_WdsTransportNamespaceScheduledCast = &CLSID_WdsTransportNamespaceScheduledCast_Value;

const CLSID_WdsTransportNamespaceScheduledCastManualStart_Value = Guid.initString("d3e1a2aa-caac-460e-b98a-47f9f318a1fa");
pub const CLSID_WdsTransportNamespaceScheduledCastManualStart = &CLSID_WdsTransportNamespaceScheduledCastManualStart_Value;

const CLSID_WdsTransportNamespaceScheduledCastAutoStart_Value = Guid.initString("a1107052-122c-4b81-9b7c-386e6855383f");
pub const CLSID_WdsTransportNamespaceScheduledCastAutoStart = &CLSID_WdsTransportNamespaceScheduledCastAutoStart_Value;

const CLSID_WdsTransportContent_Value = Guid.initString("0a891fe7-4a3f-4c65-b6f2-1467619679ea");
pub const CLSID_WdsTransportContent = &CLSID_WdsTransportContent_Value;

const CLSID_WdsTransportSession_Value = Guid.initString("749ac4e0-67bc-4743-bfe5-cacb1f26f57f");
pub const CLSID_WdsTransportSession = &CLSID_WdsTransportSession_Value;

const CLSID_WdsTransportClient_Value = Guid.initString("66d2c5e9-0ff6-49ec-9733-dafb1e01df1c");
pub const CLSID_WdsTransportClient = &CLSID_WdsTransportClient_Value;

const CLSID_WdsTransportTftpClient_Value = Guid.initString("50343925-7c5c-4c8c-96c4-ad9fa5005fba");
pub const CLSID_WdsTransportTftpClient = &CLSID_WdsTransportTftpClient_Value;

const CLSID_WdsTransportTftpManager_Value = Guid.initString("c8e9dca2-3241-4e4d-b806-bc74019dfeda");
pub const CLSID_WdsTransportTftpManager = &CLSID_WdsTransportTftpManager_Value;

const CLSID_WdsTransportContentProvider_Value = Guid.initString("e0be741f-5a75-4eb9-8a2d-5e189b45f327");
pub const CLSID_WdsTransportContentProvider = &CLSID_WdsTransportContentProvider_Value;

pub const WDSTRANSPORT_FEATURE_FLAGS = enum(i32) {
    AdminPack = 1,
    TransportServer = 2,
    DeploymentServer = 4,
};
pub const WdsTptFeatureAdminPack = WDSTRANSPORT_FEATURE_FLAGS.AdminPack;
pub const WdsTptFeatureTransportServer = WDSTRANSPORT_FEATURE_FLAGS.TransportServer;
pub const WdsTptFeatureDeploymentServer = WDSTRANSPORT_FEATURE_FLAGS.DeploymentServer;

pub const WDSTRANSPORT_PROTOCOL_FLAGS = enum(i32) {
    Unicast = 1,
    Multicast = 2,
};
pub const WdsTptProtocolUnicast = WDSTRANSPORT_PROTOCOL_FLAGS.Unicast;
pub const WdsTptProtocolMulticast = WDSTRANSPORT_PROTOCOL_FLAGS.Multicast;

pub const WDSTRANSPORT_NAMESPACE_TYPE = enum(i32) {
    Unknown = 0,
    AutoCast = 1,
    ScheduledCastManualStart = 2,
    ScheduledCastAutoStart = 3,
};
pub const WdsTptNamespaceTypeUnknown = WDSTRANSPORT_NAMESPACE_TYPE.Unknown;
pub const WdsTptNamespaceTypeAutoCast = WDSTRANSPORT_NAMESPACE_TYPE.AutoCast;
pub const WdsTptNamespaceTypeScheduledCastManualStart = WDSTRANSPORT_NAMESPACE_TYPE.ScheduledCastManualStart;
pub const WdsTptNamespaceTypeScheduledCastAutoStart = WDSTRANSPORT_NAMESPACE_TYPE.ScheduledCastAutoStart;

pub const WDSTRANSPORT_DISCONNECT_TYPE = enum(i32) {
    Unknown = 0,
    Fallback = 1,
    Abort = 2,
};
pub const WdsTptDisconnectUnknown = WDSTRANSPORT_DISCONNECT_TYPE.Unknown;
pub const WdsTptDisconnectFallback = WDSTRANSPORT_DISCONNECT_TYPE.Fallback;
pub const WdsTptDisconnectAbort = WDSTRANSPORT_DISCONNECT_TYPE.Abort;

pub const WDSTRANSPORT_SERVICE_NOTIFICATION = enum(i32) {
    Unknown = 0,
    ReadSettings = 1,
};
pub const WdsTptServiceNotifyUnknown = WDSTRANSPORT_SERVICE_NOTIFICATION.Unknown;
pub const WdsTptServiceNotifyReadSettings = WDSTRANSPORT_SERVICE_NOTIFICATION.ReadSettings;

pub const WDSTRANSPORT_IP_ADDRESS_TYPE = enum(i32) {
    Unknown = 0,
    Ipv4 = 1,
    Ipv6 = 2,
};
pub const WdsTptIpAddressUnknown = WDSTRANSPORT_IP_ADDRESS_TYPE.Unknown;
pub const WdsTptIpAddressIpv4 = WDSTRANSPORT_IP_ADDRESS_TYPE.Ipv4;
pub const WdsTptIpAddressIpv6 = WDSTRANSPORT_IP_ADDRESS_TYPE.Ipv6;

pub const WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE = enum(i32) {
    Unknown = 0,
    Dhcp = 1,
    Range = 2,
};
pub const WdsTptIpAddressSourceUnknown = WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE.Unknown;
pub const WdsTptIpAddressSourceDhcp = WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE.Dhcp;
pub const WdsTptIpAddressSourceRange = WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE.Range;

pub const WDSTRANSPORT_NETWORK_PROFILE_TYPE = enum(i32) {
    Unknown = 0,
    Custom = 1,
    @"10Mbps" = 2,
    @"100Mbps" = 3,
    @"1Gbps" = 4,
};
pub const WdsTptNetworkProfileUnknown = WDSTRANSPORT_NETWORK_PROFILE_TYPE.Unknown;
pub const WdsTptNetworkProfileCustom = WDSTRANSPORT_NETWORK_PROFILE_TYPE.Custom;
pub const WdsTptNetworkProfile10Mbps = WDSTRANSPORT_NETWORK_PROFILE_TYPE.@"10Mbps";
pub const WdsTptNetworkProfile100Mbps = WDSTRANSPORT_NETWORK_PROFILE_TYPE.@"100Mbps";
pub const WdsTptNetworkProfile1Gbps = WDSTRANSPORT_NETWORK_PROFILE_TYPE.@"1Gbps";

pub const WDSTRANSPORT_DIAGNOSTICS_COMPONENT_FLAGS = enum(i32) {
    Pxe = 1,
    Tftp = 2,
    ImageServer = 4,
    Multicast = 8,
};
pub const WdsTptDiagnosticsComponentPxe = WDSTRANSPORT_DIAGNOSTICS_COMPONENT_FLAGS.Pxe;
pub const WdsTptDiagnosticsComponentTftp = WDSTRANSPORT_DIAGNOSTICS_COMPONENT_FLAGS.Tftp;
pub const WdsTptDiagnosticsComponentImageServer = WDSTRANSPORT_DIAGNOSTICS_COMPONENT_FLAGS.ImageServer;
pub const WdsTptDiagnosticsComponentMulticast = WDSTRANSPORT_DIAGNOSTICS_COMPONENT_FLAGS.Multicast;

pub const WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE = enum(i32) {
    Unknown = 0,
    None = 1,
    AutoDisconnect = 2,
    Multistream = 3,
};
pub const WdsTptSlowClientHandlingUnknown = WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE.Unknown;
pub const WdsTptSlowClientHandlingNone = WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE.None;
pub const WdsTptSlowClientHandlingAutoDisconnect = WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE.AutoDisconnect;
pub const WdsTptSlowClientHandlingMultistream = WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE.Multistream;

pub const WDSTRANSPORT_UDP_PORT_POLICY = enum(i32) {
    Dynamic = 0,
    Fixed = 1,
};
pub const WdsTptUdpPortPolicyDynamic = WDSTRANSPORT_UDP_PORT_POLICY.Dynamic;
pub const WdsTptUdpPortPolicyFixed = WDSTRANSPORT_UDP_PORT_POLICY.Fixed;

pub const WDSTRANSPORT_TFTP_CAPABILITY = enum(i32) {
    MaximumBlockSize = 1,
    VariableWindow = 2,
};
pub const WdsTptTftpCapMaximumBlockSize = WDSTRANSPORT_TFTP_CAPABILITY.MaximumBlockSize;
pub const WdsTptTftpCapVariableWindow = WDSTRANSPORT_TFTP_CAPABILITY.VariableWindow;

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportCacheable_Value = Guid.initString("46ad894b-0bab-47dc-84b2-7b553f1d8f80");
pub const IID_IWdsTransportCacheable = &IID_IWdsTransportCacheable_Value;
pub const IWdsTransportCacheable = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Dirty: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportCacheable,
                pbDirty: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportCacheable,
                pbDirty: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Discard: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportCacheable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportCacheable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Refresh: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportCacheable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportCacheable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Commit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportCacheable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportCacheable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCacheable_get_Dirty(self: *const T, pbDirty: ?*i16) HRESULT {
                return @as(*const IWdsTransportCacheable.VTable, @ptrCast(self.vtable)).get_Dirty(@as(*const IWdsTransportCacheable, @ptrCast(self)), pbDirty);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCacheable_Discard(self: *const T) HRESULT {
                return @as(*const IWdsTransportCacheable.VTable, @ptrCast(self.vtable)).Discard(@as(*const IWdsTransportCacheable, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCacheable_Refresh(self: *const T) HRESULT {
                return @as(*const IWdsTransportCacheable.VTable, @ptrCast(self.vtable)).Refresh(@as(*const IWdsTransportCacheable, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCacheable_Commit(self: *const T) HRESULT {
                return @as(*const IWdsTransportCacheable.VTable, @ptrCast(self.vtable)).Commit(@as(*const IWdsTransportCacheable, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportCollection_Value = Guid.initString("b8ba4b1a-2ff4-43ab-996c-b2b10a91a6eb");
pub const IID_IWdsTransportCollection = &IID_IWdsTransportCollection_Value;
pub const IWdsTransportCollection = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportCollection,
                pulCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportCollection,
                pulCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportCollection,
                ulIndex: u32,
                ppVal: ?*?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportCollection,
                ulIndex: u32,
                ppVal: ?*?*IDispatch,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportCollection,
                ppVal: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportCollection,
                ppVal: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCollection_get_Count(self: *const T, pulCount: ?*u32) HRESULT {
                return @as(*const IWdsTransportCollection.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IWdsTransportCollection, @ptrCast(self)), pulCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCollection_get_Item(self: *const T, ulIndex: u32, ppVal: ?*?*IDispatch) HRESULT {
                return @as(*const IWdsTransportCollection.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IWdsTransportCollection, @ptrCast(self)), ulIndex, ppVal);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportCollection_get__NewEnum(self: *const T, ppVal: ?*?*IUnknown) HRESULT {
                return @as(*const IWdsTransportCollection.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IWdsTransportCollection, @ptrCast(self)), ppVal);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportManager_Value = Guid.initString("5b0d35f5-1b13-4afd-b878-6526dc340b5d");
pub const IID_IWdsTransportManager = &IID_IWdsTransportManager_Value;
pub const IWdsTransportManager = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        GetWdsTransportServer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportManager,
                bszServerName: ?BSTR,
                ppWdsTransportServer: ?*?*IWdsTransportServer,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportManager,
                bszServerName: ?BSTR,
                ppWdsTransportServer: ?*?*IWdsTransportServer,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportManager_GetWdsTransportServer(self: *const T, bszServerName: ?BSTR, ppWdsTransportServer: ?*?*IWdsTransportServer) HRESULT {
                return @as(*const IWdsTransportManager.VTable, @ptrCast(self.vtable)).GetWdsTransportServer(@as(*const IWdsTransportManager, @ptrCast(self)), bszServerName, ppWdsTransportServer);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportServer_Value = Guid.initString("09ccd093-830d-4344-a30a-73ae8e8fca90");
pub const IID_IWdsTransportServer = &IID_IWdsTransportServer_Value;
pub const IWdsTransportServer = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServer,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServer,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SetupManager: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServer,
                ppWdsTransportSetupManager: ?*?*IWdsTransportSetupManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServer,
                ppWdsTransportSetupManager: ?*?*IWdsTransportSetupManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ConfigurationManager: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServer,
                ppWdsTransportConfigurationManager: ?*?*IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServer,
                ppWdsTransportConfigurationManager: ?*?*IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NamespaceManager: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServer,
                ppWdsTransportNamespaceManager: ?*?*IWdsTransportNamespaceManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServer,
                ppWdsTransportNamespaceManager: ?*?*IWdsTransportNamespaceManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisconnectClient: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportServer,
                ulClientId: u32,
                DisconnectionType: WDSTRANSPORT_DISCONNECT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportServer,
                ulClientId: u32,
                DisconnectionType: WDSTRANSPORT_DISCONNECT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServer_get_Name(self: *const T, pbszName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportServer.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IWdsTransportServer, @ptrCast(self)), pbszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServer_get_SetupManager(self: *const T, ppWdsTransportSetupManager: ?*?*IWdsTransportSetupManager) HRESULT {
                return @as(*const IWdsTransportServer.VTable, @ptrCast(self.vtable)).get_SetupManager(@as(*const IWdsTransportServer, @ptrCast(self)), ppWdsTransportSetupManager);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServer_get_ConfigurationManager(self: *const T, ppWdsTransportConfigurationManager: ?*?*IWdsTransportConfigurationManager) HRESULT {
                return @as(*const IWdsTransportServer.VTable, @ptrCast(self.vtable)).get_ConfigurationManager(@as(*const IWdsTransportServer, @ptrCast(self)), ppWdsTransportConfigurationManager);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServer_get_NamespaceManager(self: *const T, ppWdsTransportNamespaceManager: ?*?*IWdsTransportNamespaceManager) HRESULT {
                return @as(*const IWdsTransportServer.VTable, @ptrCast(self.vtable)).get_NamespaceManager(@as(*const IWdsTransportServer, @ptrCast(self)), ppWdsTransportNamespaceManager);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServer_DisconnectClient(self: *const T, ulClientId: u32, DisconnectionType: WDSTRANSPORT_DISCONNECT_TYPE) HRESULT {
                return @as(*const IWdsTransportServer.VTable, @ptrCast(self.vtable)).DisconnectClient(@as(*const IWdsTransportServer, @ptrCast(self)), ulClientId, DisconnectionType);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2012'
const IID_IWdsTransportServer2_Value = Guid.initString("256e999f-6df4-4538-81b9-857b9ab8fb47");
pub const IID_IWdsTransportServer2 = &IID_IWdsTransportServer2_Value;
pub const IWdsTransportServer2 = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportServer.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TftpManager: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServer2,
                ppWdsTransportTftpManager: ?*?*IWdsTransportTftpManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServer2,
                ppWdsTransportTftpManager: ?*?*IWdsTransportTftpManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportServer.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServer2_get_TftpManager(self: *const T, ppWdsTransportTftpManager: ?*?*IWdsTransportTftpManager) HRESULT {
                return @as(*const IWdsTransportServer2.VTable, @ptrCast(self.vtable)).get_TftpManager(@as(*const IWdsTransportServer2, @ptrCast(self)), ppWdsTransportTftpManager);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportSetupManager_Value = Guid.initString("f7238425-efa8-40a4-aef9-c98d969c0b75");
pub const IID_IWdsTransportSetupManager = &IID_IWdsTransportSetupManager_Value;
pub const IWdsTransportSetupManager = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Version: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSetupManager,
                pullVersion: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSetupManager,
                pullVersion: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_InstalledFeatures: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSetupManager,
                pulInstalledFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSetupManager,
                pulInstalledFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Protocols: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSetupManager,
                pulProtocols: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSetupManager,
                pulProtocols: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterContentProvider: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportSetupManager,
                bszName: ?BSTR,
                bszDescription: ?BSTR,
                bszFilePath: ?BSTR,
                bszInitializationRoutine: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportSetupManager,
                bszName: ?BSTR,
                bszDescription: ?BSTR,
                bszFilePath: ?BSTR,
                bszInitializationRoutine: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeregisterContentProvider: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportSetupManager,
                bszName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportSetupManager,
                bszName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager_get_Version(self: *const T, pullVersion: ?*u64) HRESULT {
                return @as(*const IWdsTransportSetupManager.VTable, @ptrCast(self.vtable)).get_Version(@as(*const IWdsTransportSetupManager, @ptrCast(self)), pullVersion);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager_get_InstalledFeatures(self: *const T, pulInstalledFeatures: ?*u32) HRESULT {
                return @as(*const IWdsTransportSetupManager.VTable, @ptrCast(self.vtable)).get_InstalledFeatures(@as(*const IWdsTransportSetupManager, @ptrCast(self)), pulInstalledFeatures);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager_get_Protocols(self: *const T, pulProtocols: ?*u32) HRESULT {
                return @as(*const IWdsTransportSetupManager.VTable, @ptrCast(self.vtable)).get_Protocols(@as(*const IWdsTransportSetupManager, @ptrCast(self)), pulProtocols);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager_RegisterContentProvider(self: *const T, bszName: ?BSTR, bszDescription: ?BSTR, bszFilePath: ?BSTR, bszInitializationRoutine: ?BSTR) HRESULT {
                return @as(*const IWdsTransportSetupManager.VTable, @ptrCast(self.vtable)).RegisterContentProvider(@as(*const IWdsTransportSetupManager, @ptrCast(self)), bszName, bszDescription, bszFilePath, bszInitializationRoutine);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager_DeregisterContentProvider(self: *const T, bszName: ?BSTR) HRESULT {
                return @as(*const IWdsTransportSetupManager.VTable, @ptrCast(self.vtable)).DeregisterContentProvider(@as(*const IWdsTransportSetupManager, @ptrCast(self)), bszName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2012'
const IID_IWdsTransportSetupManager2_Value = Guid.initString("02be79da-7e9e-4366-8b6e-2aa9a91be47f");
pub const IID_IWdsTransportSetupManager2 = &IID_IWdsTransportSetupManager2_Value;
pub const IWdsTransportSetupManager2 = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportSetupManager.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TftpCapabilities: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSetupManager2,
                pulTftpCapabilities: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSetupManager2,
                pulTftpCapabilities: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ContentProviders: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSetupManager2,
                ppProviderCollection: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSetupManager2,
                ppProviderCollection: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportSetupManager.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager2_get_TftpCapabilities(self: *const T, pulTftpCapabilities: ?*u32) HRESULT {
                return @as(*const IWdsTransportSetupManager2.VTable, @ptrCast(self.vtable)).get_TftpCapabilities(@as(*const IWdsTransportSetupManager2, @ptrCast(self)), pulTftpCapabilities);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSetupManager2_get_ContentProviders(self: *const T, ppProviderCollection: ?*?*IWdsTransportCollection) HRESULT {
                return @as(*const IWdsTransportSetupManager2.VTable, @ptrCast(self.vtable)).get_ContentProviders(@as(*const IWdsTransportSetupManager2, @ptrCast(self)), ppProviderCollection);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportConfigurationManager_Value = Guid.initString("84cc4779-42dd-4792-891e-1321d6d74b44");
pub const IID_IWdsTransportConfigurationManager = &IID_IWdsTransportConfigurationManager_Value;
pub const IWdsTransportConfigurationManager = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ServicePolicy: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
                ppWdsTransportServicePolicy: ?*?*IWdsTransportServicePolicy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
                ppWdsTransportServicePolicy: ?*?*IWdsTransportServicePolicy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DiagnosticsPolicy: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
                ppWdsTransportDiagnosticsPolicy: ?*?*IWdsTransportDiagnosticsPolicy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
                ppWdsTransportDiagnosticsPolicy: ?*?*IWdsTransportDiagnosticsPolicy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_WdsTransportServicesRunning: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
                bRealtimeStatus: i16,
                pbServicesRunning: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
                bRealtimeStatus: i16,
                pbServicesRunning: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EnableWdsTransportServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisableWdsTransportServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StartWdsTransportServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StopWdsTransportServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RestartWdsTransportServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NotifyWdsTransportServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager,
                ServiceNotification: WDSTRANSPORT_SERVICE_NOTIFICATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportConfigurationManager,
                ServiceNotification: WDSTRANSPORT_SERVICE_NOTIFICATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_get_ServicePolicy(self: *const T, ppWdsTransportServicePolicy: ?*?*IWdsTransportServicePolicy) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).get_ServicePolicy(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)), ppWdsTransportServicePolicy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_get_DiagnosticsPolicy(self: *const T, ppWdsTransportDiagnosticsPolicy: ?*?*IWdsTransportDiagnosticsPolicy) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).get_DiagnosticsPolicy(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)), ppWdsTransportDiagnosticsPolicy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_get_WdsTransportServicesRunning(self: *const T, bRealtimeStatus: i16, pbServicesRunning: ?*i16) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).get_WdsTransportServicesRunning(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)), bRealtimeStatus, pbServicesRunning);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_EnableWdsTransportServices(self: *const T) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).EnableWdsTransportServices(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_DisableWdsTransportServices(self: *const T) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).DisableWdsTransportServices(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_StartWdsTransportServices(self: *const T) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).StartWdsTransportServices(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_StopWdsTransportServices(self: *const T) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).StopWdsTransportServices(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_RestartWdsTransportServices(self: *const T) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).RestartWdsTransportServices(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager_NotifyWdsTransportServices(self: *const T, ServiceNotification: WDSTRANSPORT_SERVICE_NOTIFICATION) HRESULT {
                return @as(*const IWdsTransportConfigurationManager.VTable, @ptrCast(self.vtable)).NotifyWdsTransportServices(@as(*const IWdsTransportConfigurationManager, @ptrCast(self)), ServiceNotification);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportConfigurationManager2_Value = Guid.initString("d0d85caf-a153-4f1d-a9dd-96f431c50717");
pub const IID_IWdsTransportConfigurationManager2 = &IID_IWdsTransportConfigurationManager2_Value;
pub const IWdsTransportConfigurationManager2 = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportConfigurationManager.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MulticastSessionPolicy: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportConfigurationManager2,
                ppWdsTransportMulticastSessionPolicy: ?*?*IWdsTransportMulticastSessionPolicy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportConfigurationManager2,
                ppWdsTransportMulticastSessionPolicy: ?*?*IWdsTransportMulticastSessionPolicy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportConfigurationManager.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportConfigurationManager2_get_MulticastSessionPolicy(self: *const T, ppWdsTransportMulticastSessionPolicy: ?*?*IWdsTransportMulticastSessionPolicy) HRESULT {
                return @as(*const IWdsTransportConfigurationManager2.VTable, @ptrCast(self.vtable)).get_MulticastSessionPolicy(@as(*const IWdsTransportConfigurationManager2, @ptrCast(self)), ppWdsTransportMulticastSessionPolicy);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportNamespaceManager_Value = Guid.initString("3e22d9f6-3777-4d98-83e1-f98696717ba3");
pub const IID_IWdsTransportNamespaceManager = &IID_IWdsTransportNamespaceManager_Value;
pub const IWdsTransportNamespaceManager = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        CreateNamespace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespaceManager,
                NamespaceType: WDSTRANSPORT_NAMESPACE_TYPE,
                bszNamespaceName: ?BSTR,
                bszContentProvider: ?BSTR,
                bszConfiguration: ?BSTR,
                ppWdsTransportNamespace: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespaceManager,
                NamespaceType: WDSTRANSPORT_NAMESPACE_TYPE,
                bszNamespaceName: ?BSTR,
                bszContentProvider: ?BSTR,
                bszConfiguration: ?BSTR,
                ppWdsTransportNamespace: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RetrieveNamespace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespaceManager,
                bszNamespaceName: ?BSTR,
                ppWdsTransportNamespace: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespaceManager,
                bszNamespaceName: ?BSTR,
                ppWdsTransportNamespace: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RetrieveNamespaces: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespaceManager,
                bszContentProvider: ?BSTR,
                bszNamespaceName: ?BSTR,
                bIncludeTombstones: i16,
                ppWdsTransportNamespaces: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespaceManager,
                bszContentProvider: ?BSTR,
                bszNamespaceName: ?BSTR,
                bIncludeTombstones: i16,
                ppWdsTransportNamespaces: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceManager_CreateNamespace(self: *const T, NamespaceType: WDSTRANSPORT_NAMESPACE_TYPE, bszNamespaceName: ?BSTR, bszContentProvider: ?BSTR, bszConfiguration: ?BSTR, ppWdsTransportNamespace: ?*?*IWdsTransportNamespace) HRESULT {
                return @as(*const IWdsTransportNamespaceManager.VTable, @ptrCast(self.vtable)).CreateNamespace(@as(*const IWdsTransportNamespaceManager, @ptrCast(self)), NamespaceType, bszNamespaceName, bszContentProvider, bszConfiguration, ppWdsTransportNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceManager_RetrieveNamespace(self: *const T, bszNamespaceName: ?BSTR, ppWdsTransportNamespace: ?*?*IWdsTransportNamespace) HRESULT {
                return @as(*const IWdsTransportNamespaceManager.VTable, @ptrCast(self.vtable)).RetrieveNamespace(@as(*const IWdsTransportNamespaceManager, @ptrCast(self)), bszNamespaceName, ppWdsTransportNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceManager_RetrieveNamespaces(self: *const T, bszContentProvider: ?BSTR, bszNamespaceName: ?BSTR, bIncludeTombstones: i16, ppWdsTransportNamespaces: ?*?*IWdsTransportCollection) HRESULT {
                return @as(*const IWdsTransportNamespaceManager.VTable, @ptrCast(self.vtable)).RetrieveNamespaces(@as(*const IWdsTransportNamespaceManager, @ptrCast(self)), bszContentProvider, bszNamespaceName, bIncludeTombstones, ppWdsTransportNamespaces);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2012'
const IID_IWdsTransportTftpManager_Value = Guid.initString("1327a7c8-ae8a-4fb3-8150-136227c37e9a");
pub const IID_IWdsTransportTftpManager = &IID_IWdsTransportTftpManager_Value;
pub const IWdsTransportTftpManager = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        RetrieveTftpClients: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportTftpManager,
                ppWdsTransportTftpClients: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportTftpManager,
                ppWdsTransportTftpClients: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpManager_RetrieveTftpClients(self: *const T, ppWdsTransportTftpClients: ?*?*IWdsTransportCollection) HRESULT {
                return @as(*const IWdsTransportTftpManager.VTable, @ptrCast(self.vtable)).RetrieveTftpClients(@as(*const IWdsTransportTftpManager, @ptrCast(self)), ppWdsTransportTftpClients);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportServicePolicy_Value = Guid.initString("b9468578-9f2b-48cc-b27a-a60799c2750c");
pub const IID_IWdsTransportServicePolicy = &IID_IWdsTransportServicePolicy_Value;
pub const IWdsTransportServicePolicy = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportCacheable.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IpAddressSource: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                pSourceType: ?*WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                pSourceType: ?*WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_IpAddressSource: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                SourceType: WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                SourceType: WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_StartIpAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                pbszStartIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                pbszStartIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_StartIpAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                bszStartIpAddress: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                bszStartIpAddress: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_EndIpAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                pbszEndIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                pbszEndIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_EndIpAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                bszEndIpAddress: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE,
                bszEndIpAddress: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_StartPort: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                pulStartPort: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                pulStartPort: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_StartPort: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                ulStartPort: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                ulStartPort: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_EndPort: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                pulEndPort: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                pulEndPort: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_EndPort: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                ulEndPort: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                ulEndPort: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NetworkProfile: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                pProfileType: ?*WDSTRANSPORT_NETWORK_PROFILE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                pProfileType: ?*WDSTRANSPORT_NETWORK_PROFILE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_NetworkProfile: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy,
                ProfileType: WDSTRANSPORT_NETWORK_PROFILE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy,
                ProfileType: WDSTRANSPORT_NETWORK_PROFILE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportCacheable.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_get_IpAddressSource(self: *const T, AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE, pSourceType: ?*WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).get_IpAddressSource(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), AddressType, pSourceType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_put_IpAddressSource(self: *const T, AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE, SourceType: WDSTRANSPORT_IP_ADDRESS_SOURCE_TYPE) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).put_IpAddressSource(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), AddressType, SourceType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_get_StartIpAddress(self: *const T, AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE, pbszStartIpAddress: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).get_StartIpAddress(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), AddressType, pbszStartIpAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_put_StartIpAddress(self: *const T, AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE, bszStartIpAddress: ?BSTR) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).put_StartIpAddress(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), AddressType, bszStartIpAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_get_EndIpAddress(self: *const T, AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE, pbszEndIpAddress: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).get_EndIpAddress(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), AddressType, pbszEndIpAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_put_EndIpAddress(self: *const T, AddressType: WDSTRANSPORT_IP_ADDRESS_TYPE, bszEndIpAddress: ?BSTR) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).put_EndIpAddress(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), AddressType, bszEndIpAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_get_StartPort(self: *const T, pulStartPort: ?*u32) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).get_StartPort(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), pulStartPort);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_put_StartPort(self: *const T, ulStartPort: u32) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).put_StartPort(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), ulStartPort);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_get_EndPort(self: *const T, pulEndPort: ?*u32) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).get_EndPort(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), pulEndPort);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_put_EndPort(self: *const T, ulEndPort: u32) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).put_EndPort(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), ulEndPort);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_get_NetworkProfile(self: *const T, pProfileType: ?*WDSTRANSPORT_NETWORK_PROFILE_TYPE) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).get_NetworkProfile(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), pProfileType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy_put_NetworkProfile(self: *const T, ProfileType: WDSTRANSPORT_NETWORK_PROFILE_TYPE) HRESULT {
                return @as(*const IWdsTransportServicePolicy.VTable, @ptrCast(self.vtable)).put_NetworkProfile(@as(*const IWdsTransportServicePolicy, @ptrCast(self)), ProfileType);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2012'
const IID_IWdsTransportServicePolicy2_Value = Guid.initString("65c19e5c-aa7e-4b91-8944-91e0e5572797");
pub const IID_IWdsTransportServicePolicy2 = &IID_IWdsTransportServicePolicy2_Value;
pub const IWdsTransportServicePolicy2 = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportServicePolicy.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UdpPortPolicy: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy2,
                pUdpPortPolicy: ?*WDSTRANSPORT_UDP_PORT_POLICY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy2,
                pUdpPortPolicy: ?*WDSTRANSPORT_UDP_PORT_POLICY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_UdpPortPolicy: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy2,
                UdpPortPolicy: WDSTRANSPORT_UDP_PORT_POLICY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy2,
                UdpPortPolicy: WDSTRANSPORT_UDP_PORT_POLICY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TftpMaximumBlockSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy2,
                pulTftpMaximumBlockSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy2,
                pulTftpMaximumBlockSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_TftpMaximumBlockSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy2,
                ulTftpMaximumBlockSize: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy2,
                ulTftpMaximumBlockSize: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_EnableTftpVariableWindowExtension: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy2,
                pbEnableTftpVariableWindowExtension: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy2,
                pbEnableTftpVariableWindowExtension: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_EnableTftpVariableWindowExtension: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportServicePolicy2,
                bEnableTftpVariableWindowExtension: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportServicePolicy2,
                bEnableTftpVariableWindowExtension: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportServicePolicy.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy2_get_UdpPortPolicy(self: *const T, pUdpPortPolicy: ?*WDSTRANSPORT_UDP_PORT_POLICY) HRESULT {
                return @as(*const IWdsTransportServicePolicy2.VTable, @ptrCast(self.vtable)).get_UdpPortPolicy(@as(*const IWdsTransportServicePolicy2, @ptrCast(self)), pUdpPortPolicy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy2_put_UdpPortPolicy(self: *const T, UdpPortPolicy: WDSTRANSPORT_UDP_PORT_POLICY) HRESULT {
                return @as(*const IWdsTransportServicePolicy2.VTable, @ptrCast(self.vtable)).put_UdpPortPolicy(@as(*const IWdsTransportServicePolicy2, @ptrCast(self)), UdpPortPolicy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy2_get_TftpMaximumBlockSize(self: *const T, pulTftpMaximumBlockSize: ?*u32) HRESULT {
                return @as(*const IWdsTransportServicePolicy2.VTable, @ptrCast(self.vtable)).get_TftpMaximumBlockSize(@as(*const IWdsTransportServicePolicy2, @ptrCast(self)), pulTftpMaximumBlockSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy2_put_TftpMaximumBlockSize(self: *const T, ulTftpMaximumBlockSize: u32) HRESULT {
                return @as(*const IWdsTransportServicePolicy2.VTable, @ptrCast(self.vtable)).put_TftpMaximumBlockSize(@as(*const IWdsTransportServicePolicy2, @ptrCast(self)), ulTftpMaximumBlockSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy2_get_EnableTftpVariableWindowExtension(self: *const T, pbEnableTftpVariableWindowExtension: ?*i16) HRESULT {
                return @as(*const IWdsTransportServicePolicy2.VTable, @ptrCast(self.vtable)).get_EnableTftpVariableWindowExtension(@as(*const IWdsTransportServicePolicy2, @ptrCast(self)), pbEnableTftpVariableWindowExtension);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportServicePolicy2_put_EnableTftpVariableWindowExtension(self: *const T, bEnableTftpVariableWindowExtension: i16) HRESULT {
                return @as(*const IWdsTransportServicePolicy2.VTable, @ptrCast(self.vtable)).put_EnableTftpVariableWindowExtension(@as(*const IWdsTransportServicePolicy2, @ptrCast(self)), bEnableTftpVariableWindowExtension);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportDiagnosticsPolicy_Value = Guid.initString("13b33efc-7856-4f61-9a59-8de67b6b87b6");
pub const IID_IWdsTransportDiagnosticsPolicy = &IID_IWdsTransportDiagnosticsPolicy_Value;
pub const IWdsTransportDiagnosticsPolicy = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportCacheable.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Enabled: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                pbEnabled: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                pbEnabled: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Enabled: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                bEnabled: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                bEnabled: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Components: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                pulComponents: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                pulComponents: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Components: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                ulComponents: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportDiagnosticsPolicy,
                ulComponents: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportCacheable.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportDiagnosticsPolicy_get_Enabled(self: *const T, pbEnabled: ?*i16) HRESULT {
                return @as(*const IWdsTransportDiagnosticsPolicy.VTable, @ptrCast(self.vtable)).get_Enabled(@as(*const IWdsTransportDiagnosticsPolicy, @ptrCast(self)), pbEnabled);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportDiagnosticsPolicy_put_Enabled(self: *const T, bEnabled: i16) HRESULT {
                return @as(*const IWdsTransportDiagnosticsPolicy.VTable, @ptrCast(self.vtable)).put_Enabled(@as(*const IWdsTransportDiagnosticsPolicy, @ptrCast(self)), bEnabled);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportDiagnosticsPolicy_get_Components(self: *const T, pulComponents: ?*u32) HRESULT {
                return @as(*const IWdsTransportDiagnosticsPolicy.VTable, @ptrCast(self.vtable)).get_Components(@as(*const IWdsTransportDiagnosticsPolicy, @ptrCast(self)), pulComponents);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportDiagnosticsPolicy_put_Components(self: *const T, ulComponents: u32) HRESULT {
                return @as(*const IWdsTransportDiagnosticsPolicy.VTable, @ptrCast(self.vtable)).put_Components(@as(*const IWdsTransportDiagnosticsPolicy, @ptrCast(self)), ulComponents);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportMulticastSessionPolicy_Value = Guid.initString("4e5753cf-68ec-4504-a951-4a003266606b");
pub const IID_IWdsTransportMulticastSessionPolicy = &IID_IWdsTransportMulticastSessionPolicy_Value;
pub const IWdsTransportMulticastSessionPolicy = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportCacheable.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SlowClientHandling: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pSlowClientHandling: ?*WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pSlowClientHandling: ?*WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_SlowClientHandling: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                SlowClientHandling: WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                SlowClientHandling: WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AutoDisconnectThreshold: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pulThreshold: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pulThreshold: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_AutoDisconnectThreshold: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                ulThreshold: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                ulThreshold: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MultistreamStreamCount: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pulStreamCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pulStreamCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_MultistreamStreamCount: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                ulStreamCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                ulStreamCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SlowClientFallback: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pbClientFallback: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                pbClientFallback: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_SlowClientFallback: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                bClientFallback: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportMulticastSessionPolicy,
                bClientFallback: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportCacheable.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_get_SlowClientHandling(self: *const T, pSlowClientHandling: ?*WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).get_SlowClientHandling(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), pSlowClientHandling);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_put_SlowClientHandling(self: *const T, SlowClientHandling: WDSTRANSPORT_SLOW_CLIENT_HANDLING_TYPE) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).put_SlowClientHandling(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), SlowClientHandling);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_get_AutoDisconnectThreshold(self: *const T, pulThreshold: ?*u32) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).get_AutoDisconnectThreshold(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), pulThreshold);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_put_AutoDisconnectThreshold(self: *const T, ulThreshold: u32) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).put_AutoDisconnectThreshold(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), ulThreshold);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_get_MultistreamStreamCount(self: *const T, pulStreamCount: ?*u32) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).get_MultistreamStreamCount(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), pulStreamCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_put_MultistreamStreamCount(self: *const T, ulStreamCount: u32) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).put_MultistreamStreamCount(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), ulStreamCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_get_SlowClientFallback(self: *const T, pbClientFallback: ?*i16) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).get_SlowClientFallback(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), pbClientFallback);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportMulticastSessionPolicy_put_SlowClientFallback(self: *const T, bClientFallback: i16) HRESULT {
                return @as(*const IWdsTransportMulticastSessionPolicy.VTable, @ptrCast(self.vtable)).put_SlowClientFallback(@as(*const IWdsTransportMulticastSessionPolicy, @ptrCast(self)), bClientFallback);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportNamespace_Value = Guid.initString("fa561f57-fbef-4ed3-b056-127cb1b33b84");
pub const IID_IWdsTransportNamespace = &IID_IWdsTransportNamespace_Value;
pub const IWdsTransportNamespace = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Type: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pType: ?*WDSTRANSPORT_NAMESPACE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pType: ?*WDSTRANSPORT_NAMESPACE_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Id: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                bszName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                bszName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_FriendlyName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbszFriendlyName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbszFriendlyName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_FriendlyName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                bszFriendlyName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                bszFriendlyName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbszDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbszDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                bszDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                bszDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ContentProvider: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbszContentProvider: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbszContentProvider: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ContentProvider: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                bszContentProvider: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                bszContentProvider: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Configuration: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbszConfiguration: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbszConfiguration: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Configuration: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                bszConfiguration: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                bszConfiguration: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Registered: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbRegistered: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbRegistered: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Tombstoned: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbTombstoned: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbTombstoned: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TombstoneTime: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pTombstoneTime: ?*f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pTombstoneTime: ?*f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TransmissionStarted: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                pbTransmissionStarted: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespace,
                pbTransmissionStarted: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Register: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Deregister: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                bTerminateSessions: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespace,
                bTerminateSessions: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                ppWdsTransportNamespaceClone: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespace,
                ppWdsTransportNamespaceClone: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Refresh: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RetrieveContents: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespace,
                ppWdsTransportContents: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespace,
                ppWdsTransportContents: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Type(self: *const T, pType: ?*WDSTRANSPORT_NAMESPACE_TYPE) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Type(@as(*const IWdsTransportNamespace, @ptrCast(self)), pType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Id(self: *const T, pulId: ?*u32) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Id(@as(*const IWdsTransportNamespace, @ptrCast(self)), pulId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Name(self: *const T, pbszName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_put_Name(self: *const T, bszName: ?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IWdsTransportNamespace, @ptrCast(self)), bszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_FriendlyName(self: *const T, pbszFriendlyName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_FriendlyName(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbszFriendlyName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_put_FriendlyName(self: *const T, bszFriendlyName: ?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).put_FriendlyName(@as(*const IWdsTransportNamespace, @ptrCast(self)), bszFriendlyName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Description(self: *const T, pbszDescription: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbszDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_put_Description(self: *const T, bszDescription: ?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IWdsTransportNamespace, @ptrCast(self)), bszDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_ContentProvider(self: *const T, pbszContentProvider: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_ContentProvider(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbszContentProvider);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_put_ContentProvider(self: *const T, bszContentProvider: ?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).put_ContentProvider(@as(*const IWdsTransportNamespace, @ptrCast(self)), bszContentProvider);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Configuration(self: *const T, pbszConfiguration: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Configuration(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbszConfiguration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_put_Configuration(self: *const T, bszConfiguration: ?BSTR) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).put_Configuration(@as(*const IWdsTransportNamespace, @ptrCast(self)), bszConfiguration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Registered(self: *const T, pbRegistered: ?*i16) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Registered(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbRegistered);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_Tombstoned(self: *const T, pbTombstoned: ?*i16) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_Tombstoned(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbTombstoned);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_TombstoneTime(self: *const T, pTombstoneTime: ?*f64) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_TombstoneTime(@as(*const IWdsTransportNamespace, @ptrCast(self)), pTombstoneTime);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_get_TransmissionStarted(self: *const T, pbTransmissionStarted: ?*i16) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).get_TransmissionStarted(@as(*const IWdsTransportNamespace, @ptrCast(self)), pbTransmissionStarted);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_Register(self: *const T) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).Register(@as(*const IWdsTransportNamespace, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_Deregister(self: *const T, bTerminateSessions: i16) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).Deregister(@as(*const IWdsTransportNamespace, @ptrCast(self)), bTerminateSessions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_Clone(self: *const T, ppWdsTransportNamespaceClone: ?*?*IWdsTransportNamespace) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).Clone(@as(*const IWdsTransportNamespace, @ptrCast(self)), ppWdsTransportNamespaceClone);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_Refresh(self: *const T) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).Refresh(@as(*const IWdsTransportNamespace, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespace_RetrieveContents(self: *const T, ppWdsTransportContents: ?*?*IWdsTransportCollection) HRESULT {
                return @as(*const IWdsTransportNamespace.VTable, @ptrCast(self.vtable)).RetrieveContents(@as(*const IWdsTransportNamespace, @ptrCast(self)), ppWdsTransportContents);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportNamespaceAutoCast_Value = Guid.initString("ad931a72-c4bd-4c41-8fbc-59c9c748df9e");
pub const IID_IWdsTransportNamespaceAutoCast = &IID_IWdsTransportNamespaceAutoCast_Value;
pub const IWdsTransportNamespaceAutoCast = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportNamespace.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportNamespace.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportNamespaceScheduledCast_Value = Guid.initString("3840cecf-d76c-416e-a4cc-31c741d2874b");
pub const IID_IWdsTransportNamespaceScheduledCast = &IID_IWdsTransportNamespaceScheduledCast_Value;
pub const IWdsTransportNamespaceScheduledCast = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportNamespace.VTable,
        StartTransmission: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportNamespaceScheduledCast,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportNamespaceScheduledCast,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportNamespace.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceScheduledCast_StartTransmission(self: *const T) HRESULT {
                return @as(*const IWdsTransportNamespaceScheduledCast.VTable, @ptrCast(self.vtable)).StartTransmission(@as(*const IWdsTransportNamespaceScheduledCast, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportNamespaceScheduledCastManualStart_Value = Guid.initString("013e6e4c-e6a7-4fb5-b7ff-d9f5da805c31");
pub const IID_IWdsTransportNamespaceScheduledCastManualStart = &IID_IWdsTransportNamespaceScheduledCastManualStart_Value;
pub const IWdsTransportNamespaceScheduledCastManualStart = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportNamespaceScheduledCast.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportNamespaceScheduledCast.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportNamespaceScheduledCastAutoStart_Value = Guid.initString("d606af3d-ea9c-4219-961e-7491d618d9b9");
pub const IID_IWdsTransportNamespaceScheduledCastAutoStart = &IID_IWdsTransportNamespaceScheduledCastAutoStart_Value;
pub const IWdsTransportNamespaceScheduledCastAutoStart = extern struct {
    pub const VTable = extern struct {
        base: IWdsTransportNamespaceScheduledCast.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MinimumClients: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                pulMinimumClients: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                pulMinimumClients: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_MinimumClients: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                ulMinimumClients: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                ulMinimumClients: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_StartTime: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                pStartTime: ?*f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                pStartTime: ?*f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_StartTime: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                StartTime: f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportNamespaceScheduledCastAutoStart,
                StartTime: f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWdsTransportNamespaceScheduledCast.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceScheduledCastAutoStart_get_MinimumClients(self: *const T, pulMinimumClients: ?*u32) HRESULT {
                return @as(*const IWdsTransportNamespaceScheduledCastAutoStart.VTable, @ptrCast(self.vtable)).get_MinimumClients(@as(*const IWdsTransportNamespaceScheduledCastAutoStart, @ptrCast(self)), pulMinimumClients);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceScheduledCastAutoStart_put_MinimumClients(self: *const T, ulMinimumClients: u32) HRESULT {
                return @as(*const IWdsTransportNamespaceScheduledCastAutoStart.VTable, @ptrCast(self.vtable)).put_MinimumClients(@as(*const IWdsTransportNamespaceScheduledCastAutoStart, @ptrCast(self)), ulMinimumClients);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceScheduledCastAutoStart_get_StartTime(self: *const T, pStartTime: ?*f64) HRESULT {
                return @as(*const IWdsTransportNamespaceScheduledCastAutoStart.VTable, @ptrCast(self.vtable)).get_StartTime(@as(*const IWdsTransportNamespaceScheduledCastAutoStart, @ptrCast(self)), pStartTime);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportNamespaceScheduledCastAutoStart_put_StartTime(self: *const T, StartTime: f64) HRESULT {
                return @as(*const IWdsTransportNamespaceScheduledCastAutoStart.VTable, @ptrCast(self.vtable)).put_StartTime(@as(*const IWdsTransportNamespaceScheduledCastAutoStart, @ptrCast(self)), StartTime);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportContent_Value = Guid.initString("d405d711-0296-4ab4-a860-ac7d32e65798");
pub const IID_IWdsTransportContent = &IID_IWdsTransportContent_Value;
pub const IWdsTransportContent = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Namespace: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContent,
                ppWdsTransportNamespace: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContent,
                ppWdsTransportNamespace: ?*?*IWdsTransportNamespace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Id: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContent,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContent,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContent,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContent,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RetrieveSessions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportContent,
                ppWdsTransportSessions: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportContent,
                ppWdsTransportSessions: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Terminate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContent_get_Namespace(self: *const T, ppWdsTransportNamespace: ?*?*IWdsTransportNamespace) HRESULT {
                return @as(*const IWdsTransportContent.VTable, @ptrCast(self.vtable)).get_Namespace(@as(*const IWdsTransportContent, @ptrCast(self)), ppWdsTransportNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContent_get_Id(self: *const T, pulId: ?*u32) HRESULT {
                return @as(*const IWdsTransportContent.VTable, @ptrCast(self.vtable)).get_Id(@as(*const IWdsTransportContent, @ptrCast(self)), pulId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContent_get_Name(self: *const T, pbszName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportContent.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IWdsTransportContent, @ptrCast(self)), pbszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContent_RetrieveSessions(self: *const T, ppWdsTransportSessions: ?*?*IWdsTransportCollection) HRESULT {
                return @as(*const IWdsTransportContent.VTable, @ptrCast(self.vtable)).RetrieveSessions(@as(*const IWdsTransportContent, @ptrCast(self)), ppWdsTransportSessions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContent_Terminate(self: *const T) HRESULT {
                return @as(*const IWdsTransportContent.VTable, @ptrCast(self.vtable)).Terminate(@as(*const IWdsTransportContent, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportSession_Value = Guid.initString("f4efea88-65b1-4f30-a4b9-2793987796fb");
pub const IID_IWdsTransportSession = &IID_IWdsTransportSession_Value;
pub const IWdsTransportSession = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Content: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSession,
                ppWdsTransportContent: ?*?*IWdsTransportContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSession,
                ppWdsTransportContent: ?*?*IWdsTransportContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Id: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSession,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSession,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NetworkInterfaceName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSession,
                pbszNetworkInterfaceName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSession,
                pbszNetworkInterfaceName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NetworkInterfaceAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSession,
                pbszNetworkInterfaceAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSession,
                pbszNetworkInterfaceAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TransferRate: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSession,
                pulTransferRate: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSession,
                pulTransferRate: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MasterClientId: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportSession,
                pulMasterClientId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportSession,
                pulMasterClientId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RetrieveClients: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportSession,
                ppWdsTransportClients: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportSession,
                ppWdsTransportClients: ?*?*IWdsTransportCollection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Terminate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportSession,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportSession,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_get_Content(self: *const T, ppWdsTransportContent: ?*?*IWdsTransportContent) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).get_Content(@as(*const IWdsTransportSession, @ptrCast(self)), ppWdsTransportContent);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_get_Id(self: *const T, pulId: ?*u32) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).get_Id(@as(*const IWdsTransportSession, @ptrCast(self)), pulId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_get_NetworkInterfaceName(self: *const T, pbszNetworkInterfaceName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).get_NetworkInterfaceName(@as(*const IWdsTransportSession, @ptrCast(self)), pbszNetworkInterfaceName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_get_NetworkInterfaceAddress(self: *const T, pbszNetworkInterfaceAddress: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).get_NetworkInterfaceAddress(@as(*const IWdsTransportSession, @ptrCast(self)), pbszNetworkInterfaceAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_get_TransferRate(self: *const T, pulTransferRate: ?*u32) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).get_TransferRate(@as(*const IWdsTransportSession, @ptrCast(self)), pulTransferRate);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_get_MasterClientId(self: *const T, pulMasterClientId: ?*u32) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).get_MasterClientId(@as(*const IWdsTransportSession, @ptrCast(self)), pulMasterClientId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_RetrieveClients(self: *const T, ppWdsTransportClients: ?*?*IWdsTransportCollection) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).RetrieveClients(@as(*const IWdsTransportSession, @ptrCast(self)), ppWdsTransportClients);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportSession_Terminate(self: *const T) HRESULT {
                return @as(*const IWdsTransportSession.VTable, @ptrCast(self.vtable)).Terminate(@as(*const IWdsTransportSession, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IWdsTransportClient_Value = Guid.initString("b5dbc93a-cabe-46ca-837f-3e44e93c6545");
pub const IID_IWdsTransportClient = &IID_IWdsTransportClient_Value;
pub const IWdsTransportClient = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Session: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                ppWdsTransportSession: ?*?*IWdsTransportSession,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                ppWdsTransportSession: ?*?*IWdsTransportSession,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Id: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pulId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MacAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pbszMacAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pbszMacAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IpAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pbszIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pbszIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PercentCompletion: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pulPercentCompletion: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pulPercentCompletion: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_JoinDuration: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pulJoinDuration: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pulJoinDuration: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_CpuUtilization: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pulCpuUtilization: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pulCpuUtilization: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MemoryUtilization: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pulMemoryUtilization: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pulMemoryUtilization: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NetworkUtilization: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pulNetworkUtilization: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pulNetworkUtilization: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserIdentity: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportClient,
                pbszUserIdentity: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportClient,
                pbszUserIdentity: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Disconnect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWdsTransportClient,
                DisconnectionType: WDSTRANSPORT_DISCONNECT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWdsTransportClient,
                DisconnectionType: WDSTRANSPORT_DISCONNECT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_Session(self: *const T, ppWdsTransportSession: ?*?*IWdsTransportSession) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_Session(@as(*const IWdsTransportClient, @ptrCast(self)), ppWdsTransportSession);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_Id(self: *const T, pulId: ?*u32) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_Id(@as(*const IWdsTransportClient, @ptrCast(self)), pulId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_Name(self: *const T, pbszName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IWdsTransportClient, @ptrCast(self)), pbszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_MacAddress(self: *const T, pbszMacAddress: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_MacAddress(@as(*const IWdsTransportClient, @ptrCast(self)), pbszMacAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_IpAddress(self: *const T, pbszIpAddress: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_IpAddress(@as(*const IWdsTransportClient, @ptrCast(self)), pbszIpAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_PercentCompletion(self: *const T, pulPercentCompletion: ?*u32) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_PercentCompletion(@as(*const IWdsTransportClient, @ptrCast(self)), pulPercentCompletion);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_JoinDuration(self: *const T, pulJoinDuration: ?*u32) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_JoinDuration(@as(*const IWdsTransportClient, @ptrCast(self)), pulJoinDuration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_CpuUtilization(self: *const T, pulCpuUtilization: ?*u32) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_CpuUtilization(@as(*const IWdsTransportClient, @ptrCast(self)), pulCpuUtilization);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_MemoryUtilization(self: *const T, pulMemoryUtilization: ?*u32) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_MemoryUtilization(@as(*const IWdsTransportClient, @ptrCast(self)), pulMemoryUtilization);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_NetworkUtilization(self: *const T, pulNetworkUtilization: ?*u32) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_NetworkUtilization(@as(*const IWdsTransportClient, @ptrCast(self)), pulNetworkUtilization);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_get_UserIdentity(self: *const T, pbszUserIdentity: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).get_UserIdentity(@as(*const IWdsTransportClient, @ptrCast(self)), pbszUserIdentity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportClient_Disconnect(self: *const T, DisconnectionType: WDSTRANSPORT_DISCONNECT_TYPE) HRESULT {
                return @as(*const IWdsTransportClient.VTable, @ptrCast(self.vtable)).Disconnect(@as(*const IWdsTransportClient, @ptrCast(self)), DisconnectionType);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2012'
const IID_IWdsTransportTftpClient_Value = Guid.initString("b022d3ae-884d-4d85-b146-53320e76ef62");
pub const IID_IWdsTransportTftpClient = &IID_IWdsTransportTftpClient_Value;
pub const IWdsTransportTftpClient = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_FileName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pbszFileName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pbszFileName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IpAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pbszIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pbszIpAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Timeout: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pulTimeout: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pulTimeout: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_CurrentFileOffset: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pul64CurrentOffset: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pul64CurrentOffset: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_FileSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pul64FileSize: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pul64FileSize: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BlockSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pulBlockSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pulBlockSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_WindowSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportTftpClient,
                pulWindowSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportTftpClient,
                pulWindowSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_FileName(self: *const T, pbszFileName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_FileName(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pbszFileName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_IpAddress(self: *const T, pbszIpAddress: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_IpAddress(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pbszIpAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_Timeout(self: *const T, pulTimeout: ?*u32) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_Timeout(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pulTimeout);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_CurrentFileOffset(self: *const T, pul64CurrentOffset: ?*u64) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_CurrentFileOffset(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pul64CurrentOffset);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_FileSize(self: *const T, pul64FileSize: ?*u64) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_FileSize(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pul64FileSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_BlockSize(self: *const T, pulBlockSize: ?*u32) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_BlockSize(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pulBlockSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportTftpClient_get_WindowSize(self: *const T, pulWindowSize: ?*u32) HRESULT {
                return @as(*const IWdsTransportTftpClient.VTable, @ptrCast(self.vtable)).get_WindowSize(@as(*const IWdsTransportTftpClient, @ptrCast(self)), pulWindowSize);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2012'
const IID_IWdsTransportContentProvider_Value = Guid.initString("b9489f24-f219-4acf-aad7-265c7c08a6ae");
pub const IID_IWdsTransportContentProvider = &IID_IWdsTransportContentProvider_Value;
pub const IWdsTransportContentProvider = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContentProvider,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContentProvider,
                pbszName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContentProvider,
                pbszDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContentProvider,
                pbszDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_FilePath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContentProvider,
                pbszFilePath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContentProvider,
                pbszFilePath: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_InitializationRoutine: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IWdsTransportContentProvider,
                pbszInitializationRoutine: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IWdsTransportContentProvider,
                pbszInitializationRoutine: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContentProvider_get_Name(self: *const T, pbszName: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportContentProvider.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IWdsTransportContentProvider, @ptrCast(self)), pbszName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContentProvider_get_Description(self: *const T, pbszDescription: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportContentProvider.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IWdsTransportContentProvider, @ptrCast(self)), pbszDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContentProvider_get_FilePath(self: *const T, pbszFilePath: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportContentProvider.VTable, @ptrCast(self.vtable)).get_FilePath(@as(*const IWdsTransportContentProvider, @ptrCast(self)), pbszFilePath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWdsTransportContentProvider_get_InitializationRoutine(self: *const T, pbszInitializationRoutine: ?*?BSTR) HRESULT {
                return @as(*const IWdsTransportContentProvider.VTable, @ptrCast(self.vtable)).get_InitializationRoutine(@as(*const IWdsTransportContentProvider, @ptrCast(self)), pbszInitializationRoutine);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (94)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliClose(
    Handle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliRegisterTrace(
    pfn: ?PFN_WdsCliTraceFunction,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wdsclientapi" fn WdsCliFreeStringArray(
    ppwszArray: ?[*]?PWSTR,
    ulCount: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliFindFirstImage(
    hSession: ?HANDLE,
    phFindHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliFindNextImage(
    Handle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetEnumerationFlags(
    Handle: ?HANDLE,
    pdwFlags: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageHandleFromFindHandle(
    FindHandle: ?HANDLE,
    phImageHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageHandleFromTransferHandle(
    hTransfer: ?HANDLE,
    phImageHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliCreateSession(
    pwszServer: ?PWSTR,
    pCred: ?*WDS_CLI_CRED,
    phSession: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliAuthorizeSession(
    hSession: ?HANDLE,
    pCred: ?*WDS_CLI_CRED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliInitializeLog(
    hSession: ?HANDLE,
    ulClientArchitecture: CPU_ARCHITECTURE,
    pwszClientId: ?PWSTR,
    pwszClientAddress: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliLog(
    hSession: ?HANDLE,
    ulLogLevel: u32,
    ulMessageCode: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageName(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageDescription(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "wdsclientapi" fn WdsCliGetImageType(
    hIfh: ?HANDLE,
    pImageType: ?*WDS_CLI_IMAGE_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "wdsclientapi" fn WdsCliGetImageFiles(
    hIfh: ?HANDLE,
    pppwszFiles: ?*?*?PWSTR,
    pdwCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageLanguage(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageLanguages(
    hIfh: ?HANDLE,
    pppszValues: ?*?*?*i8,
    pdwNumValues: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageVersion(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImagePath(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageIndex(
    hIfh: ?HANDLE,
    pdwValue: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageArchitecture(
    hIfh: ?HANDLE,
    pdwValue: ?*CPU_ARCHITECTURE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageLastModifiedTime(
    hIfh: ?HANDLE,
    ppSysTimeValue: ?*?*SYSTEMTIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageSize(
    hIfh: ?HANDLE,
    pullValue: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageHalName(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageGroup(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetImageNamespace(
    hIfh: ?HANDLE,
    ppwszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "wdsclientapi" fn WdsCliGetImageParameter(
    hIfh: ?HANDLE,
    ParamType: WDS_CLI_IMAGE_PARAM_TYPE,
    // TODO: what to do with BytesParamIndex 3?
    pResponse: ?*anyopaque,
    uResponseLen: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliGetTransferSize(
    hIfh: ?HANDLE,
    pullValue: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "wdsclientapi" fn WdsCliSetTransferBufferSize(
    ulSizeInBytes: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliTransferImage(
    hImage: ?HANDLE,
    pwszLocalPath: ?PWSTR,
    dwFlags: u32,
    dwReserved: u32,
    pfnWdsCliCallback: ?PFN_WdsCliCallback,
    pvUserData: ?*anyopaque,
    phTransfer: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliTransferFile(
    pwszServer: ?[*:0]const u16,
    pwszNamespace: ?[*:0]const u16,
    pwszRemoteFilePath: ?[*:0]const u16,
    pwszLocalFilePath: ?[*:0]const u16,
    dwFlags: u32,
    dwReserved: u32,
    pfnWdsCliCallback: ?PFN_WdsCliCallback,
    pvUserData: ?*anyopaque,
    phTransfer: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliCancelTransfer(
    hTransfer: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsclientapi" fn WdsCliWaitForTransfer(
    hTransfer: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wdsclientapi" fn WdsCliObtainDriverPackages(
    hImage: ?HANDLE,
    ppwszServerName: ?*?PWSTR,
    pppwszDriverPackages: ?*?*?PWSTR,
    pulCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdsclientapi" fn WdsCliObtainDriverPackagesEx(
    hSession: ?HANDLE,
    pwszMachineInfo: ?PWSTR,
    ppwszServerName: ?*?PWSTR,
    pppwszDriverPackages: ?*?*?PWSTR,
    pulCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdsclientapi" fn WdsCliGetDriverQueryXml(
    pwszWinDirPath: ?PWSTR,
    ppwszDriverQuery: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderRegister(
    pszProviderName: ?[*:0]const u16,
    pszModulePath: ?[*:0]const u16,
    Index: u32,
    bIsCritical: BOOL,
    phProviderKey: ?*?HKEY,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderUnRegister(
    pszProviderName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderQueryIndex(
    pszProviderName: ?[*:0]const u16,
    puIndex: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderEnumFirst(
    phEnum: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderEnumNext(
    hEnum: ?HANDLE,
    ppProvider: ?*?*PXE_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderEnumClose(
    hEnum: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderFreeInfo(
    pProvider: ?*PXE_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeRegisterCallback(
    hProvider: ?HANDLE,
    CallbackType: u32,
    pCallbackFunction: ?*anyopaque,
    pContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeSendReply(
    hClientRequest: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    pAddress: ?*PXE_ADDRESS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeAsyncRecvDone(
    hClientRequest: ?HANDLE,
    Action: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeTrace(
    hProvider: ?HANDLE,
    Severity: u32,
    pszFormat: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "wdspxe" fn PxeTraceV(
    hProvider: ?HANDLE,
    Severity: u32,
    pszFormat: ?[*:0]const u16,
    Params: ?*i8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxePacketAllocate(
    hProvider: ?HANDLE,
    hClientRequest: ?HANDLE,
    uSize: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxePacketFree(
    hProvider: ?HANDLE,
    hClientRequest: ?HANDLE,
    pPacket: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeProviderSetAttribute(
    hProvider: ?HANDLE,
    Attribute: u32,
    // TODO: what to do with BytesParamIndex 3?
    pParameterBuffer: ?*anyopaque,
    uParamLen: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeDhcpInitialize(
    // TODO: what to do with BytesParamIndex 1?
    pRecvPacket: ?*anyopaque,
    uRecvPacketLen: u32,
    // TODO: what to do with BytesParamIndex 3?
    pReplyPacket: ?*anyopaque,
    uMaxReplyPacketLen: u32,
    puReplyPacketLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6Initialize(
    // TODO: what to do with BytesParamIndex 1?
    pRequest: ?*anyopaque,
    cbRequest: u32,
    // TODO: what to do with BytesParamIndex 3?
    pReply: ?*anyopaque,
    cbReply: u32,
    pcbReplyUsed: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeDhcpAppendOption(
    // TODO: what to do with BytesParamIndex 1?
    pReplyPacket: ?*anyopaque,
    uMaxReplyPacketLen: u32,
    puReplyPacketLen: ?*u32,
    bOption: u8,
    bOptionLen: u8,
    // TODO: what to do with BytesParamIndex 4?
    pValue: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6AppendOption(
    // TODO: what to do with BytesParamIndex 1?
    pReply: ?*anyopaque,
    cbReply: u32,
    pcbReplyUsed: ?*u32,
    wOptionType: u16,
    cbOption: u16,
    // TODO: what to do with BytesParamIndex 4?
    pOption: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeDhcpAppendOptionRaw(
    // TODO: what to do with BytesParamIndex 1?
    pReplyPacket: ?*anyopaque,
    uMaxReplyPacketLen: u32,
    puReplyPacketLen: ?*u32,
    uBufferLen: u16,
    // TODO: what to do with BytesParamIndex 3?
    pBuffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6AppendOptionRaw(
    // TODO: what to do with BytesParamIndex 1?
    pReply: ?*anyopaque,
    cbReply: u32,
    pcbReplyUsed: ?*u32,
    cbBuffer: u16,
    // TODO: what to do with BytesParamIndex 3?
    pBuffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeDhcpIsValid(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    bRequestPacket: BOOL,
    pbPxeOptionPresent: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6IsValid(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    bRequestPacket: BOOL,
    pbPxeOptionPresent: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeDhcpGetOptionValue(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    uInstance: u32,
    bOption: u8,
    pbOptionLen: ?*u8,
    ppOptionValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6GetOptionValue(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    uInstance: u32,
    wOption: u16,
    pwOptionLen: ?*u16,
    ppOptionValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeDhcpGetVendorOptionValue(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    bOption: u8,
    uInstance: u32,
    pbOptionLen: ?*u8,
    ppOptionValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6GetVendorOptionValue(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    dwEnterpriseNumber: u32,
    wOption: u16,
    uInstance: u32,
    pwOptionLen: ?*u16,
    ppOptionValue: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6ParseRelayForw(
    // TODO: what to do with BytesParamIndex 1?
    pRelayForwPacket: ?*anyopaque,
    uRelayForwPacketLen: u32,
    pRelayMessages: [*]PXE_DHCPV6_NESTED_RELAY_MESSAGE,
    nRelayMessages: u32,
    pnRelayMessages: ?*u32,
    ppInnerPacket: ?*?*u8,
    pcbInnerPacket: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeDhcpv6CreateRelayRepl(
    pRelayMessages: [*]PXE_DHCPV6_NESTED_RELAY_MESSAGE,
    nRelayMessages: u32,
    // TODO: what to do with BytesParamIndex 3?
    pInnerPacket: ?*u8,
    cbInnerPacket: u32,
    // TODO: what to do with BytesParamIndex 5?
    pReplyBuffer: ?*anyopaque,
    cbReplyBuffer: u32,
    pcbReplyBuffer: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdspxe" fn PxeGetServerInfo(
    uInfoType: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*anyopaque,
    uBufferLen: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdspxe" fn PxeGetServerInfoEx(
    uInfoType: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*anyopaque,
    uBufferLen: u32,
    puBufferUsed: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdsmc" fn WdsTransportServerRegisterCallback(
    hProvider: ?HANDLE,
    CallbackId: TRANSPORTPROVIDER_CALLBACK_ID,
    pfnCallback: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdsmc" fn WdsTransportServerCompleteRead(
    hProvider: ?HANDLE,
    ulBytesRead: u32,
    pvUserData: ?*anyopaque,
    hReadResult: HRESULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdsmc" fn WdsTransportServerTrace(
    hProvider: ?HANDLE,
    Severity: u32,
    pwszFormat: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdsmc" fn WdsTransportServerTraceV(
    hProvider: ?HANDLE,
    Severity: u32,
    pwszFormat: ?[*:0]const u16,
    Params: ?*i8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdsmc" fn WdsTransportServerAllocateBuffer(
    hProvider: ?HANDLE,
    ulBufferSize: u32,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "wdsmc" fn WdsTransportServerFreeBuffer(
    hProvider: ?HANDLE,
    pvBuffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientInitialize() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientInitializeSession(
    pSessionRequest: ?*WDS_TRANSPORTCLIENT_REQUEST,
    pCallerData: ?*anyopaque,
    hSessionKey: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientRegisterCallback(
    hSessionKey: ?HANDLE,
    CallbackId: TRANSPORTCLIENT_CALLBACK_ID,
    pfnCallback: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientStartSession(
    hSessionKey: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientCompleteReceive(
    hSessionKey: ?HANDLE,
    ulSize: u32,
    pullOffset: ?*ULARGE_INTEGER,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientCancelSession(
    hSessionKey: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "wdstptc" fn WdsTransportClientCancelSessionEx(
    hSessionKey: ?HANDLE,
    dwErrorCode: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientWaitForCompletion(
    hSessionKey: ?HANDLE,
    uTimeout: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientQueryStatus(
    hSessionKey: ?HANDLE,
    puStatus: ?*u32,
    puErrorCode: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientCloseSession(
    hSessionKey: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientAddRefBuffer(
    pvBuffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientReleaseBuffer(
    pvBuffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdstptc" fn WdsTransportClientShutdown() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsbp" fn WdsBpParseInitialize(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    pbPacketType: ?*u8,
    phHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "wdsbp" fn WdsBpParseInitializev6(
    // TODO: what to do with BytesParamIndex 1?
    pPacket: ?*anyopaque,
    uPacketLen: u32,
    pbPacketType: ?*u8,
    phHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsbp" fn WdsBpInitialize(
    bPacketType: u8,
    phHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsbp" fn WdsBpCloseHandle(
    hHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsbp" fn WdsBpQueryOption(
    hHandle: ?HANDLE,
    uOption: u32,
    uValueLen: u32,
    // TODO: what to do with BytesParamIndex 2?
    pValue: ?*anyopaque,
    puBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsbp" fn WdsBpAddOption(
    hHandle: ?HANDLE,
    uOption: u32,
    uValueLen: u32,
    // TODO: what to do with BytesParamIndex 2?
    pValue: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wdsbp" fn WdsBpGetOptionBuffer(
    hHandle: ?HANDLE,
    uBufferLen: u32,
    // TODO: what to do with BytesParamIndex 1?
    pBuffer: ?*anyopaque,
    puBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (13)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BSTR = @import("../foundation.zig").BSTR;
const HANDLE = @import("../foundation.zig").HANDLE;
const HKEY = @import("../system/registry.zig").HKEY;
const HRESULT = @import("../foundation.zig").HRESULT;
const IDispatch = @import("../system/com.zig").IDispatch;
const IUnknown = @import("../system/com.zig").IUnknown;
const LPARAM = @import("../foundation.zig").LPARAM;
const PWSTR = @import("../foundation.zig").PWSTR;
const SYSTEMTIME = @import("../foundation.zig").SYSTEMTIME;
const ULARGE_INTEGER = @import("../foundation.zig").ULARGE_INTEGER;
const WPARAM = @import("../foundation.zig").WPARAM;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PFN_WdsCliTraceFunction")) {
        _ = PFN_WdsCliTraceFunction;
    }
    if (@hasDecl(@This(), "PFN_WdsCliCallback")) {
        _ = PFN_WdsCliCallback;
    }
    if (@hasDecl(@This(), "PFN_WdsTransportClientSessionStart")) {
        _ = PFN_WdsTransportClientSessionStart;
    }
    if (@hasDecl(@This(), "PFN_WdsTransportClientSessionStartEx")) {
        _ = PFN_WdsTransportClientSessionStartEx;
    }
    if (@hasDecl(@This(), "PFN_WdsTransportClientReceiveMetadata")) {
        _ = PFN_WdsTransportClientReceiveMetadata;
    }
    if (@hasDecl(@This(), "PFN_WdsTransportClientReceiveContents")) {
        _ = PFN_WdsTransportClientReceiveContents;
    }
    if (@hasDecl(@This(), "PFN_WdsTransportClientSessionComplete")) {
        _ = PFN_WdsTransportClientSessionComplete;
    }
    if (@hasDecl(@This(), "PFN_WdsTransportClientSessionNegotiate")) {
        _ = PFN_WdsTransportClientSessionNegotiate;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
