//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (1)
//--------------------------------------------------------------------------------
pub const AVRF_MAX_TRACES = @as(u32, 32);

//--------------------------------------------------------------------------------
// Section: Types (12)
//--------------------------------------------------------------------------------
pub const VERIFIER_ENUM_RESOURCE_FLAGS = enum(u32) {
    DONT_RESOLVE_TRACES = 2,
    SUSPEND = 1,
    _,
    pub fn initFlags(o: struct {
        DONT_RESOLVE_TRACES: u1 = 0,
        SUSPEND: u1 = 0,
    }) VERIFIER_ENUM_RESOURCE_FLAGS {
        return @as(VERIFIER_ENUM_RESOURCE_FLAGS, @enumFromInt((if (o.DONT_RESOLVE_TRACES == 1) @intFromEnum(VERIFIER_ENUM_RESOURCE_FLAGS.DONT_RESOLVE_TRACES) else 0) | (if (o.SUSPEND == 1) @intFromEnum(VERIFIER_ENUM_RESOURCE_FLAGS.SUSPEND) else 0)));
    }
};
pub const AVRF_ENUM_RESOURCES_FLAGS_DONT_RESOLVE_TRACES = VERIFIER_ENUM_RESOURCE_FLAGS.DONT_RESOLVE_TRACES;
pub const AVRF_ENUM_RESOURCES_FLAGS_SUSPEND = VERIFIER_ENUM_RESOURCE_FLAGS.SUSPEND;

pub const AVRF_BACKTRACE_INFORMATION = extern struct {
    Depth: u32,
    Index: u32,
    ReturnAddresses: [32]u64,
};

pub const eUserAllocationState = enum(i32) {
    Unknown = 0,
    Busy = 1,
    Free = 2,
};
pub const AllocationStateUnknown = eUserAllocationState.Unknown;
pub const AllocationStateBusy = eUserAllocationState.Busy;
pub const AllocationStateFree = eUserAllocationState.Free;

pub const eHeapAllocationState = enum(i32) {
    FullPageHeap = 1073741824,
    Metadata = -2147483648,
    StateMask = -65536,
};
pub const HeapFullPageHeap = eHeapAllocationState.FullPageHeap;
pub const HeapMetadata = eHeapAllocationState.Metadata;
pub const HeapStateMask = eHeapAllocationState.StateMask;

pub const eHeapEnumerationLevel = enum(i32) {
    Everything = 0,
    Stop = -1,
};
pub const HeapEnumerationEverything = eHeapEnumerationLevel.Everything;
pub const HeapEnumerationStop = eHeapEnumerationLevel.Stop;

pub const AVRF_HEAP_ALLOCATION = extern struct {
    HeapHandle: u64,
    UserAllocation: u64,
    UserAllocationSize: u64,
    Allocation: u64,
    AllocationSize: u64,
    UserAllocationState: u32,
    HeapState: u32,
    HeapContext: u64,
    BackTraceInformation: ?*AVRF_BACKTRACE_INFORMATION,
};

pub const eHANDLE_TRACE_OPERATIONS = enum(i32) {
    Unused = 0,
    OPEN = 1,
    CLOSE = 2,
    BADREF = 3,
};
pub const OperationDbUnused = eHANDLE_TRACE_OPERATIONS.Unused;
pub const OperationDbOPEN = eHANDLE_TRACE_OPERATIONS.OPEN;
pub const OperationDbCLOSE = eHANDLE_TRACE_OPERATIONS.CLOSE;
pub const OperationDbBADREF = eHANDLE_TRACE_OPERATIONS.BADREF;

pub const AVRF_HANDLE_OPERATION = extern struct {
    Handle: u64,
    ProcessId: u32,
    ThreadId: u32,
    OperationType: u32,
    Spare0: u32,
    BackTraceInformation: AVRF_BACKTRACE_INFORMATION,
};

pub const eAvrfResourceTypes = enum(i32) {
    HeapAllocation = 0,
    HandleTrace = 1,
    Max = 2,
};
pub const AvrfResourceHeapAllocation = eAvrfResourceTypes.HeapAllocation;
pub const AvrfResourceHandleTrace = eAvrfResourceTypes.HandleTrace;
pub const AvrfResourceMax = eAvrfResourceTypes.Max;

pub const AVRF_RESOURCE_ENUMERATE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        ResourceDescription: ?*anyopaque,
        EnumerationContext: ?*anyopaque,
        EnumerationLevel: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        ResourceDescription: ?*anyopaque,
        EnumerationContext: ?*anyopaque,
        EnumerationLevel: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const AVRF_HEAPALLOCATION_ENUMERATE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        HeapAllocation: ?*AVRF_HEAP_ALLOCATION,
        EnumerationContext: ?*anyopaque,
        EnumerationLevel: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        HeapAllocation: ?*AVRF_HEAP_ALLOCATION,
        EnumerationContext: ?*anyopaque,
        EnumerationLevel: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const AVRF_HANDLEOPERATION_ENUMERATE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        HandleOperation: ?*AVRF_HANDLE_OPERATION,
        EnumerationContext: ?*anyopaque,
        EnumerationLevel: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        HandleOperation: ?*AVRF_HANDLE_OPERATION,
        EnumerationContext: ?*anyopaque,
        EnumerationLevel: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

//--------------------------------------------------------------------------------
// Section: Functions (1)
//--------------------------------------------------------------------------------
pub extern "verifier" fn VerifierEnumerateResource(
    Process: ?HANDLE,
    Flags: VERIFIER_ENUM_RESOURCE_FLAGS,
    ResourceType: eAvrfResourceTypes,
    ResourceCallback: ?AVRF_RESOURCE_ENUMERATE_CALLBACK,
    EnumerationContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (1)
//--------------------------------------------------------------------------------
const HANDLE = @import("../foundation.zig").HANDLE;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "AVRF_RESOURCE_ENUMERATE_CALLBACK")) {
        _ = AVRF_RESOURCE_ENUMERATE_CALLBACK;
    }
    if (@hasDecl(@This(), "AVRF_HEAPALLOCATION_ENUMERATE_CALLBACK")) {
        _ = AVRF_HEAPALLOCATION_ENUMERATE_CALLBACK;
    }
    if (@hasDecl(@This(), "AVRF_HANDLEOPERATION_ENUMERATE_CALLBACK")) {
        _ = AVRF_HANDLEOPERATION_ENUMERATE_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
