//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Types (20)
//--------------------------------------------------------------------------------
pub const AMSI_RESULT = enum(i32) {
    CLEAN = 0,
    NOT_DETECTED = 1,
    BLOCKED_BY_ADMIN_START = 16384,
    BLOCKED_BY_ADMIN_END = 20479,
    DETECTED = 32768,
};
pub const AMSI_RESULT_CLEAN = AMSI_RESULT.CLEAN;
pub const AMSI_RESULT_NOT_DETECTED = AMSI_RESULT.NOT_DETECTED;
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_START = AMSI_RESULT.BLOCKED_BY_ADMIN_START;
pub const AMSI_RESULT_BLOCKED_BY_ADMIN_END = AMSI_RESULT.BLOCKED_BY_ADMIN_END;
pub const AMSI_RESULT_DETECTED = AMSI_RESULT.DETECTED;

pub const AMSI_ATTRIBUTE = enum(i32) {
    APP_NAME = 0,
    CONTENT_NAME = 1,
    CONTENT_SIZE = 2,
    CONTENT_ADDRESS = 3,
    SESSION = 4,
    REDIRECT_CHAIN_SIZE = 5,
    REDIRECT_CHAIN_ADDRESS = 6,
    ALL_SIZE = 7,
    ALL_ADDRESS = 8,
    QUIET = 9,
};
pub const AMSI_ATTRIBUTE_APP_NAME = AMSI_ATTRIBUTE.APP_NAME;
pub const AMSI_ATTRIBUTE_CONTENT_NAME = AMSI_ATTRIBUTE.CONTENT_NAME;
pub const AMSI_ATTRIBUTE_CONTENT_SIZE = AMSI_ATTRIBUTE.CONTENT_SIZE;
pub const AMSI_ATTRIBUTE_CONTENT_ADDRESS = AMSI_ATTRIBUTE.CONTENT_ADDRESS;
pub const AMSI_ATTRIBUTE_SESSION = AMSI_ATTRIBUTE.SESSION;
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_SIZE = AMSI_ATTRIBUTE.REDIRECT_CHAIN_SIZE;
pub const AMSI_ATTRIBUTE_REDIRECT_CHAIN_ADDRESS = AMSI_ATTRIBUTE.REDIRECT_CHAIN_ADDRESS;
pub const AMSI_ATTRIBUTE_ALL_SIZE = AMSI_ATTRIBUTE.ALL_SIZE;
pub const AMSI_ATTRIBUTE_ALL_ADDRESS = AMSI_ATTRIBUTE.ALL_ADDRESS;
pub const AMSI_ATTRIBUTE_QUIET = AMSI_ATTRIBUTE.QUIET;

pub const AMSI_UAC_REQUEST_TYPE = enum(i32) {
    EXE = 0,
    COM = 1,
    MSI = 2,
    AX = 3,
    PACKAGED_APP = 4,
    MAX = 5,
};
pub const AMSI_UAC_REQUEST_TYPE_EXE = AMSI_UAC_REQUEST_TYPE.EXE;
pub const AMSI_UAC_REQUEST_TYPE_COM = AMSI_UAC_REQUEST_TYPE.COM;
pub const AMSI_UAC_REQUEST_TYPE_MSI = AMSI_UAC_REQUEST_TYPE.MSI;
pub const AMSI_UAC_REQUEST_TYPE_AX = AMSI_UAC_REQUEST_TYPE.AX;
pub const AMSI_UAC_REQUEST_TYPE_PACKAGED_APP = AMSI_UAC_REQUEST_TYPE.PACKAGED_APP;
pub const AMSI_UAC_REQUEST_TYPE_MAX = AMSI_UAC_REQUEST_TYPE.MAX;

pub const AMSI_UAC_TRUST_STATE = enum(i32) {
    TRUSTED = 0,
    UNTRUSTED = 1,
    BLOCKED = 2,
    MAX = 3,
};
pub const AMSI_UAC_TRUST_STATE_TRUSTED = AMSI_UAC_TRUST_STATE.TRUSTED;
pub const AMSI_UAC_TRUST_STATE_UNTRUSTED = AMSI_UAC_TRUST_STATE.UNTRUSTED;
pub const AMSI_UAC_TRUST_STATE_BLOCKED = AMSI_UAC_TRUST_STATE.BLOCKED;
pub const AMSI_UAC_TRUST_STATE_MAX = AMSI_UAC_TRUST_STATE.MAX;

pub const AMSI_UAC_MSI_ACTION = enum(i32) {
    INSTALL = 0,
    UNINSTALL = 1,
    UPDATE = 2,
    MAINTENANCE = 3,
    MAX = 4,
};
pub const AMSI_UAC_MSI_ACTION_INSTALL = AMSI_UAC_MSI_ACTION.INSTALL;
pub const AMSI_UAC_MSI_ACTION_UNINSTALL = AMSI_UAC_MSI_ACTION.UNINSTALL;
pub const AMSI_UAC_MSI_ACTION_UPDATE = AMSI_UAC_MSI_ACTION.UPDATE;
pub const AMSI_UAC_MSI_ACTION_MAINTENANCE = AMSI_UAC_MSI_ACTION.MAINTENANCE;
pub const AMSI_UAC_MSI_ACTION_MAX = AMSI_UAC_MSI_ACTION.MAX;

pub const AMSI_UAC_REQUEST_EXE_INFO = extern struct {
    ulLength: u32,
    lpwszApplicationName: ?PWSTR,
    lpwszCommandLine: ?PWSTR,
    lpwszDLLParameter: ?PWSTR,
};

pub const AMSI_UAC_REQUEST_COM_INFO = extern struct {
    ulLength: u32,
    lpwszServerBinary: ?PWSTR,
    lpwszRequestor: ?PWSTR,
    Clsid: Guid,
};

pub const AMSI_UAC_REQUEST_MSI_INFO = extern struct {
    ulLength: u32,
    MsiAction: AMSI_UAC_MSI_ACTION,
    lpwszProductName: ?PWSTR,
    lpwszVersion: ?PWSTR,
    lpwszLanguage: ?PWSTR,
    lpwszManufacturer: ?PWSTR,
    lpwszPackagePath: ?PWSTR,
    lpwszPackageSource: ?PWSTR,
    ulUpdates: u32,
    ppwszUpdates: ?*?PWSTR,
    ppwszUpdateSources: ?*?PWSTR,
};

pub const AMSI_UAC_REQUEST_AX_INFO = extern struct {
    ulLength: u32,
    lpwszLocalInstallPath: ?PWSTR,
    lpwszSourceURL: ?PWSTR,
};

pub const AMSI_UAC_REQUEST_PACKAGED_APP_INFO = extern struct {
    ulLength: u32,
    lpwszApplicationName: ?PWSTR,
    lpwszCommandLine: ?PWSTR,
    lpPackageFamilyName: ?PWSTR,
    lpApplicationId: ?PWSTR,
};

pub const AMSI_UAC_REQUEST_CONTEXT = extern struct {
    ulLength: u32,
    ulRequestorProcessId: u32,
    UACTrustState: AMSI_UAC_TRUST_STATE,
    Type: AMSI_UAC_REQUEST_TYPE,
    RequestType: extern union {
        ExeInfo: AMSI_UAC_REQUEST_EXE_INFO,
        ComInfo: AMSI_UAC_REQUEST_COM_INFO,
        MsiInfo: AMSI_UAC_REQUEST_MSI_INFO,
        ActiveXInfo: AMSI_UAC_REQUEST_AX_INFO,
        PackagedAppInfo: AMSI_UAC_REQUEST_PACKAGED_APP_INFO,
    },
    bAutoElevateRequest: BOOL,
};

// TODO: this type is limited to platform 'windows10.0.10240'
const IID_IAmsiStream_Value = Guid.initString("3e47f2e5-81d4-4d3b-897f-545096770373");
pub const IID_IAmsiStream = &IID_IAmsiStream_Value;
pub const IAmsiStream = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetAttribute: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAmsiStream,
                attribute: AMSI_ATTRIBUTE,
                dataSize: u32,
                data: [*:0]u8,
                retData: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAmsiStream,
                attribute: AMSI_ATTRIBUTE,
                dataSize: u32,
                data: [*:0]u8,
                retData: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Read: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAmsiStream,
                position: u64,
                size: u32,
                buffer: [*:0]u8,
                readSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAmsiStream,
                position: u64,
                size: u32,
                buffer: [*:0]u8,
                readSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAmsiStream_GetAttribute(self: *const T, attribute: AMSI_ATTRIBUTE, dataSize: u32, data: [*:0]u8, retData: ?*u32) HRESULT {
                return @as(*const IAmsiStream.VTable, @ptrCast(self.vtable)).GetAttribute(@as(*const IAmsiStream, @ptrCast(self)), attribute, dataSize, data, retData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAmsiStream_Read(self: *const T, position: u64, size: u32, buffer: [*:0]u8, readSize: ?*u32) HRESULT {
                return @as(*const IAmsiStream.VTable, @ptrCast(self.vtable)).Read(@as(*const IAmsiStream, @ptrCast(self)), position, size, buffer, readSize);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.10240'
const IID_IAntimalwareProvider_Value = Guid.initString("b2cabfe3-fe04-42b1-a5df-08d483d4d125");
pub const IID_IAntimalwareProvider = &IID_IAntimalwareProvider_Value;
pub const IAntimalwareProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Scan: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalwareProvider,
                stream: ?*IAmsiStream,
                result: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalwareProvider,
                stream: ?*IAmsiStream,
                result: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CloseSession: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalwareProvider,
                session: u64,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IAntimalwareProvider,
                session: u64,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        DisplayName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalwareProvider,
                displayName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalwareProvider,
                displayName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalwareProvider_Scan(self: *const T, stream: ?*IAmsiStream, result: ?*AMSI_RESULT) HRESULT {
                return @as(*const IAntimalwareProvider.VTable, @ptrCast(self.vtable)).Scan(@as(*const IAntimalwareProvider, @ptrCast(self)), stream, result);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalwareProvider_CloseSession(self: *const T, session: u64) void {
                return @as(*const IAntimalwareProvider.VTable, @ptrCast(self.vtable)).CloseSession(@as(*const IAntimalwareProvider, @ptrCast(self)), session);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalwareProvider_DisplayName(self: *const T, displayName: ?*?PWSTR) HRESULT {
                return @as(*const IAntimalwareProvider.VTable, @ptrCast(self.vtable)).DisplayName(@as(*const IAntimalwareProvider, @ptrCast(self)), displayName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IAntimalwareUacProvider_Value = Guid.initString("b2cabfe4-fe04-42b1-a5df-08d483d4d125");
pub const IID_IAntimalwareUacProvider = &IID_IAntimalwareUacProvider_Value;
pub const IAntimalwareUacProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        UacScan: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalwareUacProvider,
                context: ?*AMSI_UAC_REQUEST_CONTEXT,
                result: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalwareUacProvider,
                context: ?*AMSI_UAC_REQUEST_CONTEXT,
                result: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisplayName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalwareUacProvider,
                displayName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalwareUacProvider,
                displayName: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalwareUacProvider_UacScan(self: *const T, context: ?*AMSI_UAC_REQUEST_CONTEXT, result: ?*AMSI_RESULT) HRESULT {
                return @as(*const IAntimalwareUacProvider.VTable, @ptrCast(self.vtable)).UacScan(@as(*const IAntimalwareUacProvider, @ptrCast(self)), context, result);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalwareUacProvider_DisplayName(self: *const T, displayName: ?*?PWSTR) HRESULT {
                return @as(*const IAntimalwareUacProvider.VTable, @ptrCast(self.vtable)).DisplayName(@as(*const IAntimalwareUacProvider, @ptrCast(self)), displayName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IAntimalwareProvider2_Value = Guid.initString("7c1e6570-3f73-4e0f-8ad4-98b94cd3290f");
pub const IID_IAntimalwareProvider2 = &IID_IAntimalwareProvider2_Value;
pub const IAntimalwareProvider2 = extern struct {
    pub const VTable = extern struct {
        base: IAntimalwareProvider.VTable,
        Notify: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalwareProvider2,
                buffer: ?*anyopaque,
                length: u32,
                contentName: ?[*:0]const u16,
                appName: ?[*:0]const u16,
                pResult: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalwareProvider2,
                buffer: ?*anyopaque,
                length: u32,
                contentName: ?[*:0]const u16,
                appName: ?[*:0]const u16,
                pResult: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAntimalwareProvider.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalwareProvider2_Notify(self: *const T, buffer: ?*anyopaque, length: u32, contentName: ?[*:0]const u16, appName: ?[*:0]const u16, pResult: ?*AMSI_RESULT) HRESULT {
                return @as(*const IAntimalwareProvider2.VTable, @ptrCast(self.vtable)).Notify(@as(*const IAntimalwareProvider2, @ptrCast(self)), buffer, length, contentName, appName, pResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.10240'
const IID_IAntimalware_Value = Guid.initString("82d29c2e-f062-44e6-b5c9-3d9a2f24a2df");
pub const IID_IAntimalware = &IID_IAntimalware_Value;
pub const IAntimalware = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Scan: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalware,
                stream: ?*IAmsiStream,
                result: ?*AMSI_RESULT,
                provider: ?*?*IAntimalwareProvider,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalware,
                stream: ?*IAmsiStream,
                result: ?*AMSI_RESULT,
                provider: ?*?*IAntimalwareProvider,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CloseSession: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalware,
                session: u64,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IAntimalware,
                session: u64,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalware_Scan(self: *const T, stream: ?*IAmsiStream, result: ?*AMSI_RESULT, provider: ?*?*IAntimalwareProvider) HRESULT {
                return @as(*const IAntimalware.VTable, @ptrCast(self.vtable)).Scan(@as(*const IAntimalware, @ptrCast(self)), stream, result, provider);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalware_CloseSession(self: *const T, session: u64) void {
                return @as(*const IAntimalware.VTable, @ptrCast(self.vtable)).CloseSession(@as(*const IAntimalware, @ptrCast(self)), session);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IAntimalware2_Value = Guid.initString("301035b5-2d42-4f56-8c65-2dcaa7fb3cdc");
pub const IID_IAntimalware2 = &IID_IAntimalware2_Value;
pub const IAntimalware2 = extern struct {
    pub const VTable = extern struct {
        base: IAntimalware.VTable,
        Notify: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAntimalware2,
                buffer: ?*anyopaque,
                length: u32,
                contentName: ?[*:0]const u16,
                appName: ?[*:0]const u16,
                pResult: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAntimalware2,
                buffer: ?*anyopaque,
                length: u32,
                contentName: ?[*:0]const u16,
                appName: ?[*:0]const u16,
                pResult: ?*AMSI_RESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAntimalware.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAntimalware2_Notify(self: *const T, buffer: ?*anyopaque, length: u32, contentName: ?[*:0]const u16, appName: ?[*:0]const u16, pResult: ?*AMSI_RESULT) HRESULT {
                return @as(*const IAntimalware2.VTable, @ptrCast(self.vtable)).Notify(@as(*const IAntimalware2, @ptrCast(self)), buffer, length, contentName, appName, pResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const CLSID_CAntimalware_Value = Guid.initString("fdb00e52-a214-4aa1-8fba-4357bb0072ec");
pub const CLSID_CAntimalware = &CLSID_CAntimalware_Value;

pub const HAMSICONTEXT = *opaque {};

pub const HAMSISESSION = *opaque {};

//--------------------------------------------------------------------------------
// Section: Functions (8)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "amsi" fn AmsiInitialize(
    appName: ?[*:0]const u16,
    amsiContext: ?*?HAMSICONTEXT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "amsi" fn AmsiUninitialize(
    amsiContext: ?HAMSICONTEXT,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "amsi" fn AmsiOpenSession(
    amsiContext: ?HAMSICONTEXT,
    amsiSession: ?*?HAMSISESSION,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "amsi" fn AmsiCloseSession(
    amsiContext: ?HAMSICONTEXT,
    amsiSession: ?HAMSISESSION,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "amsi" fn AmsiScanBuffer(
    amsiContext: ?HAMSICONTEXT,
    // TODO: what to do with BytesParamIndex 2?
    buffer: ?*anyopaque,
    length: u32,
    contentName: ?[*:0]const u16,
    amsiSession: ?HAMSISESSION,
    result: ?*AMSI_RESULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "amsi" fn AmsiNotifyOperation(
    amsiContext: ?HAMSICONTEXT,
    // TODO: what to do with BytesParamIndex 2?
    buffer: ?*anyopaque,
    length: u32,
    contentName: ?[*:0]const u16,
    result: ?*AMSI_RESULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "amsi" fn AmsiScanString(
    amsiContext: ?HAMSICONTEXT,
    string: ?[*:0]const u16,
    contentName: ?[*:0]const u16,
    amsiSession: ?HAMSISESSION,
    result: ?*AMSI_RESULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.1'
pub extern "kernel32" fn InstallELAMCertificateInfo(
    ELAMFile: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (6)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const IUnknown = @import("../system/com.zig").IUnknown;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
