//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (12)
//--------------------------------------------------------------------------------
pub const VIRTUAL_STORAGE_TYPE_VENDOR_UNKNOWN = Guid.initString("00000000-0000-0000-0000-000000000000");
pub const VIRTUAL_STORAGE_TYPE_VENDOR_MICROSOFT = Guid.initString("ec984aec-a0f9-47e9-901f-71415a66345b");
pub const VIRTUAL_STORAGE_TYPE_DEVICE_UNKNOWN = @as(u32, 0);
pub const VIRTUAL_STORAGE_TYPE_DEVICE_ISO = @as(u32, 1);
pub const VIRTUAL_STORAGE_TYPE_DEVICE_VHD = @as(u32, 2);
pub const VIRTUAL_STORAGE_TYPE_DEVICE_VHDX = @as(u32, 3);
pub const VIRTUAL_STORAGE_TYPE_DEVICE_VHDSET = @as(u32, 4);
pub const OPEN_VIRTUAL_DISK_RW_DEPTH_DEFAULT = @as(u32, 1);
pub const CREATE_VIRTUAL_DISK_PARAMETERS_DEFAULT_BLOCK_SIZE = @as(u32, 0);
pub const CREATE_VIRTUAL_DISK_PARAMETERS_DEFAULT_SECTOR_SIZE = @as(u32, 0);
pub const VIRTUAL_DISK_MAXIMUM_CHANGE_TRACKING_ID_LENGTH = @as(u32, 256);
pub const MERGE_VIRTUAL_DISK_DEFAULT_MERGE_DEPTH = @as(u32, 1);

//--------------------------------------------------------------------------------
// Section: Types (59)
//--------------------------------------------------------------------------------
pub const VIRTUAL_STORAGE_TYPE = extern struct {
    DeviceId: u32,
    VendorId: Guid,
};

pub const OPEN_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
    @"2" = 2,
    @"3" = 3,
};
pub const OPEN_VIRTUAL_DISK_VERSION_UNSPECIFIED = OPEN_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const OPEN_VIRTUAL_DISK_VERSION_1 = OPEN_VIRTUAL_DISK_VERSION.@"1";
pub const OPEN_VIRTUAL_DISK_VERSION_2 = OPEN_VIRTUAL_DISK_VERSION.@"2";
pub const OPEN_VIRTUAL_DISK_VERSION_3 = OPEN_VIRTUAL_DISK_VERSION.@"3";

pub const OPEN_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: OPEN_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            RWDepth: u32,
        },
        Version2: extern struct {
            GetInfoOnly: BOOL,
            ReadOnly: BOOL,
            ResiliencyGuid: Guid,
        },
        Version3: extern struct {
            GetInfoOnly: BOOL,
            ReadOnly: BOOL,
            ResiliencyGuid: Guid,
            SnapshotId: Guid,
        },
    },
};

pub const VIRTUAL_DISK_ACCESS_MASK = enum(u32) {
    NONE = 0,
    ATTACH_RO = 65536,
    ATTACH_RW = 131072,
    DETACH = 262144,
    GET_INFO = 524288,
    CREATE = 1048576,
    METAOPS = 2097152,
    READ = 851968,
    ALL = 4128768,
    WRITABLE = 3276800,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        ATTACH_RO: u1 = 0,
        ATTACH_RW: u1 = 0,
        DETACH: u1 = 0,
        GET_INFO: u1 = 0,
        CREATE: u1 = 0,
        METAOPS: u1 = 0,
        READ: u1 = 0,
        ALL: u1 = 0,
        WRITABLE: u1 = 0,
    }) VIRTUAL_DISK_ACCESS_MASK {
        return @as(VIRTUAL_DISK_ACCESS_MASK, @enumFromInt((if (o.NONE == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.NONE) else 0) | (if (o.ATTACH_RO == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.ATTACH_RO) else 0) | (if (o.ATTACH_RW == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.ATTACH_RW) else 0) | (if (o.DETACH == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.DETACH) else 0) | (if (o.GET_INFO == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.GET_INFO) else 0) | (if (o.CREATE == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.CREATE) else 0) | (if (o.METAOPS == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.METAOPS) else 0) | (if (o.READ == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.READ) else 0) | (if (o.ALL == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.ALL) else 0) | (if (o.WRITABLE == 1) @intFromEnum(VIRTUAL_DISK_ACCESS_MASK.WRITABLE) else 0)));
    }
};
pub const VIRTUAL_DISK_ACCESS_NONE = VIRTUAL_DISK_ACCESS_MASK.NONE;
pub const VIRTUAL_DISK_ACCESS_ATTACH_RO = VIRTUAL_DISK_ACCESS_MASK.ATTACH_RO;
pub const VIRTUAL_DISK_ACCESS_ATTACH_RW = VIRTUAL_DISK_ACCESS_MASK.ATTACH_RW;
pub const VIRTUAL_DISK_ACCESS_DETACH = VIRTUAL_DISK_ACCESS_MASK.DETACH;
pub const VIRTUAL_DISK_ACCESS_GET_INFO = VIRTUAL_DISK_ACCESS_MASK.GET_INFO;
pub const VIRTUAL_DISK_ACCESS_CREATE = VIRTUAL_DISK_ACCESS_MASK.CREATE;
pub const VIRTUAL_DISK_ACCESS_METAOPS = VIRTUAL_DISK_ACCESS_MASK.METAOPS;
pub const VIRTUAL_DISK_ACCESS_READ = VIRTUAL_DISK_ACCESS_MASK.READ;
pub const VIRTUAL_DISK_ACCESS_ALL = VIRTUAL_DISK_ACCESS_MASK.ALL;
pub const VIRTUAL_DISK_ACCESS_WRITABLE = VIRTUAL_DISK_ACCESS_MASK.WRITABLE;

pub const OPEN_VIRTUAL_DISK_FLAG = enum(u32) {
    NONE = 0,
    NO_PARENTS = 1,
    BLANK_FILE = 2,
    BOOT_DRIVE = 4,
    CACHED_IO = 8,
    CUSTOM_DIFF_CHAIN = 16,
    PARENT_CACHED_IO = 32,
    VHDSET_FILE_ONLY = 64,
    IGNORE_RELATIVE_PARENT_LOCATOR = 128,
    NO_WRITE_HARDENING = 256,
    SUPPORT_COMPRESSED_VOLUMES = 512,
    SUPPORT_SPARSE_FILES_ANY_FS = 1024,
    SUPPORT_ENCRYPTED_FILES = 2048,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        NO_PARENTS: u1 = 0,
        BLANK_FILE: u1 = 0,
        BOOT_DRIVE: u1 = 0,
        CACHED_IO: u1 = 0,
        CUSTOM_DIFF_CHAIN: u1 = 0,
        PARENT_CACHED_IO: u1 = 0,
        VHDSET_FILE_ONLY: u1 = 0,
        IGNORE_RELATIVE_PARENT_LOCATOR: u1 = 0,
        NO_WRITE_HARDENING: u1 = 0,
        SUPPORT_COMPRESSED_VOLUMES: u1 = 0,
        SUPPORT_SPARSE_FILES_ANY_FS: u1 = 0,
        SUPPORT_ENCRYPTED_FILES: u1 = 0,
    }) OPEN_VIRTUAL_DISK_FLAG {
        return @as(OPEN_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.NONE) else 0) | (if (o.NO_PARENTS == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.NO_PARENTS) else 0) | (if (o.BLANK_FILE == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.BLANK_FILE) else 0) | (if (o.BOOT_DRIVE == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.BOOT_DRIVE) else 0) | (if (o.CACHED_IO == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.CACHED_IO) else 0) | (if (o.CUSTOM_DIFF_CHAIN == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.CUSTOM_DIFF_CHAIN) else 0) | (if (o.PARENT_CACHED_IO == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.PARENT_CACHED_IO) else 0) | (if (o.VHDSET_FILE_ONLY == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.VHDSET_FILE_ONLY) else 0) | (if (o.IGNORE_RELATIVE_PARENT_LOCATOR == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.IGNORE_RELATIVE_PARENT_LOCATOR) else 0) | (if (o.NO_WRITE_HARDENING == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.NO_WRITE_HARDENING) else 0) | (if (o.SUPPORT_COMPRESSED_VOLUMES == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.SUPPORT_COMPRESSED_VOLUMES) else 0) | (if (o.SUPPORT_SPARSE_FILES_ANY_FS == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.SUPPORT_SPARSE_FILES_ANY_FS) else 0) | (if (o.SUPPORT_ENCRYPTED_FILES == 1) @intFromEnum(OPEN_VIRTUAL_DISK_FLAG.SUPPORT_ENCRYPTED_FILES) else 0)));
    }
};
pub const OPEN_VIRTUAL_DISK_FLAG_NONE = OPEN_VIRTUAL_DISK_FLAG.NONE;
pub const OPEN_VIRTUAL_DISK_FLAG_NO_PARENTS = OPEN_VIRTUAL_DISK_FLAG.NO_PARENTS;
pub const OPEN_VIRTUAL_DISK_FLAG_BLANK_FILE = OPEN_VIRTUAL_DISK_FLAG.BLANK_FILE;
pub const OPEN_VIRTUAL_DISK_FLAG_BOOT_DRIVE = OPEN_VIRTUAL_DISK_FLAG.BOOT_DRIVE;
pub const OPEN_VIRTUAL_DISK_FLAG_CACHED_IO = OPEN_VIRTUAL_DISK_FLAG.CACHED_IO;
pub const OPEN_VIRTUAL_DISK_FLAG_CUSTOM_DIFF_CHAIN = OPEN_VIRTUAL_DISK_FLAG.CUSTOM_DIFF_CHAIN;
pub const OPEN_VIRTUAL_DISK_FLAG_PARENT_CACHED_IO = OPEN_VIRTUAL_DISK_FLAG.PARENT_CACHED_IO;
pub const OPEN_VIRTUAL_DISK_FLAG_VHDSET_FILE_ONLY = OPEN_VIRTUAL_DISK_FLAG.VHDSET_FILE_ONLY;
pub const OPEN_VIRTUAL_DISK_FLAG_IGNORE_RELATIVE_PARENT_LOCATOR = OPEN_VIRTUAL_DISK_FLAG.IGNORE_RELATIVE_PARENT_LOCATOR;
pub const OPEN_VIRTUAL_DISK_FLAG_NO_WRITE_HARDENING = OPEN_VIRTUAL_DISK_FLAG.NO_WRITE_HARDENING;
pub const OPEN_VIRTUAL_DISK_FLAG_SUPPORT_COMPRESSED_VOLUMES = OPEN_VIRTUAL_DISK_FLAG.SUPPORT_COMPRESSED_VOLUMES;
pub const OPEN_VIRTUAL_DISK_FLAG_SUPPORT_SPARSE_FILES_ANY_FS = OPEN_VIRTUAL_DISK_FLAG.SUPPORT_SPARSE_FILES_ANY_FS;
pub const OPEN_VIRTUAL_DISK_FLAG_SUPPORT_ENCRYPTED_FILES = OPEN_VIRTUAL_DISK_FLAG.SUPPORT_ENCRYPTED_FILES;

pub const CREATE_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
    @"2" = 2,
    @"3" = 3,
    @"4" = 4,
};
pub const CREATE_VIRTUAL_DISK_VERSION_UNSPECIFIED = CREATE_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const CREATE_VIRTUAL_DISK_VERSION_1 = CREATE_VIRTUAL_DISK_VERSION.@"1";
pub const CREATE_VIRTUAL_DISK_VERSION_2 = CREATE_VIRTUAL_DISK_VERSION.@"2";
pub const CREATE_VIRTUAL_DISK_VERSION_3 = CREATE_VIRTUAL_DISK_VERSION.@"3";
pub const CREATE_VIRTUAL_DISK_VERSION_4 = CREATE_VIRTUAL_DISK_VERSION.@"4";

pub const CREATE_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: CREATE_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            UniqueId: Guid,
            MaximumSize: u64,
            BlockSizeInBytes: u32,
            SectorSizeInBytes: u32,
            ParentPath: ?[*:0]const u16,
            SourcePath: ?[*:0]const u16,
        },
        Version2: extern struct {
            UniqueId: Guid,
            MaximumSize: u64,
            BlockSizeInBytes: u32,
            SectorSizeInBytes: u32,
            PhysicalSectorSizeInBytes: u32,
            ParentPath: ?[*:0]const u16,
            SourcePath: ?[*:0]const u16,
            OpenFlags: OPEN_VIRTUAL_DISK_FLAG,
            ParentVirtualStorageType: VIRTUAL_STORAGE_TYPE,
            SourceVirtualStorageType: VIRTUAL_STORAGE_TYPE,
            ResiliencyGuid: Guid,
        },
        Version3: extern struct {
            UniqueId: Guid,
            MaximumSize: u64,
            BlockSizeInBytes: u32,
            SectorSizeInBytes: u32,
            PhysicalSectorSizeInBytes: u32,
            ParentPath: ?[*:0]const u16,
            SourcePath: ?[*:0]const u16,
            OpenFlags: OPEN_VIRTUAL_DISK_FLAG,
            ParentVirtualStorageType: VIRTUAL_STORAGE_TYPE,
            SourceVirtualStorageType: VIRTUAL_STORAGE_TYPE,
            ResiliencyGuid: Guid,
            SourceLimitPath: ?[*:0]const u16,
            BackingStorageType: VIRTUAL_STORAGE_TYPE,
        },
        Version4: extern struct {
            UniqueId: Guid,
            MaximumSize: u64,
            BlockSizeInBytes: u32,
            SectorSizeInBytes: u32,
            PhysicalSectorSizeInBytes: u32,
            ParentPath: ?[*:0]const u16,
            SourcePath: ?[*:0]const u16,
            OpenFlags: OPEN_VIRTUAL_DISK_FLAG,
            ParentVirtualStorageType: VIRTUAL_STORAGE_TYPE,
            SourceVirtualStorageType: VIRTUAL_STORAGE_TYPE,
            ResiliencyGuid: Guid,
            SourceLimitPath: ?[*:0]const u16,
            BackingStorageType: VIRTUAL_STORAGE_TYPE,
            PmemAddressAbstractionType: Guid,
            DataAlignment: u64,
        },
    },
};

pub const CREATE_VIRTUAL_DISK_FLAG = enum(u32) {
    NONE = 0,
    FULL_PHYSICAL_ALLOCATION = 1,
    PREVENT_WRITES_TO_SOURCE_DISK = 2,
    DO_NOT_COPY_METADATA_FROM_PARENT = 4,
    CREATE_BACKING_STORAGE = 8,
    USE_CHANGE_TRACKING_SOURCE_LIMIT = 16,
    PRESERVE_PARENT_CHANGE_TRACKING_STATE = 32,
    VHD_SET_USE_ORIGINAL_BACKING_STORAGE = 64,
    SPARSE_FILE = 128,
    PMEM_COMPATIBLE = 256,
    SUPPORT_COMPRESSED_VOLUMES = 512,
    SUPPORT_SPARSE_FILES_ANY_FS = 1024,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        FULL_PHYSICAL_ALLOCATION: u1 = 0,
        PREVENT_WRITES_TO_SOURCE_DISK: u1 = 0,
        DO_NOT_COPY_METADATA_FROM_PARENT: u1 = 0,
        CREATE_BACKING_STORAGE: u1 = 0,
        USE_CHANGE_TRACKING_SOURCE_LIMIT: u1 = 0,
        PRESERVE_PARENT_CHANGE_TRACKING_STATE: u1 = 0,
        VHD_SET_USE_ORIGINAL_BACKING_STORAGE: u1 = 0,
        SPARSE_FILE: u1 = 0,
        PMEM_COMPATIBLE: u1 = 0,
        SUPPORT_COMPRESSED_VOLUMES: u1 = 0,
        SUPPORT_SPARSE_FILES_ANY_FS: u1 = 0,
    }) CREATE_VIRTUAL_DISK_FLAG {
        return @as(CREATE_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.NONE) else 0) | (if (o.FULL_PHYSICAL_ALLOCATION == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.FULL_PHYSICAL_ALLOCATION) else 0) | (if (o.PREVENT_WRITES_TO_SOURCE_DISK == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.PREVENT_WRITES_TO_SOURCE_DISK) else 0) | (if (o.DO_NOT_COPY_METADATA_FROM_PARENT == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.DO_NOT_COPY_METADATA_FROM_PARENT) else 0) | (if (o.CREATE_BACKING_STORAGE == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.CREATE_BACKING_STORAGE) else 0) | (if (o.USE_CHANGE_TRACKING_SOURCE_LIMIT == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.USE_CHANGE_TRACKING_SOURCE_LIMIT) else 0) | (if (o.PRESERVE_PARENT_CHANGE_TRACKING_STATE == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.PRESERVE_PARENT_CHANGE_TRACKING_STATE) else 0) | (if (o.VHD_SET_USE_ORIGINAL_BACKING_STORAGE == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.VHD_SET_USE_ORIGINAL_BACKING_STORAGE) else 0) | (if (o.SPARSE_FILE == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.SPARSE_FILE) else 0) | (if (o.PMEM_COMPATIBLE == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.PMEM_COMPATIBLE) else 0) | (if (o.SUPPORT_COMPRESSED_VOLUMES == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.SUPPORT_COMPRESSED_VOLUMES) else 0) | (if (o.SUPPORT_SPARSE_FILES_ANY_FS == 1) @intFromEnum(CREATE_VIRTUAL_DISK_FLAG.SUPPORT_SPARSE_FILES_ANY_FS) else 0)));
    }
};
pub const CREATE_VIRTUAL_DISK_FLAG_NONE = CREATE_VIRTUAL_DISK_FLAG.NONE;
pub const CREATE_VIRTUAL_DISK_FLAG_FULL_PHYSICAL_ALLOCATION = CREATE_VIRTUAL_DISK_FLAG.FULL_PHYSICAL_ALLOCATION;
pub const CREATE_VIRTUAL_DISK_FLAG_PREVENT_WRITES_TO_SOURCE_DISK = CREATE_VIRTUAL_DISK_FLAG.PREVENT_WRITES_TO_SOURCE_DISK;
pub const CREATE_VIRTUAL_DISK_FLAG_DO_NOT_COPY_METADATA_FROM_PARENT = CREATE_VIRTUAL_DISK_FLAG.DO_NOT_COPY_METADATA_FROM_PARENT;
pub const CREATE_VIRTUAL_DISK_FLAG_CREATE_BACKING_STORAGE = CREATE_VIRTUAL_DISK_FLAG.CREATE_BACKING_STORAGE;
pub const CREATE_VIRTUAL_DISK_FLAG_USE_CHANGE_TRACKING_SOURCE_LIMIT = CREATE_VIRTUAL_DISK_FLAG.USE_CHANGE_TRACKING_SOURCE_LIMIT;
pub const CREATE_VIRTUAL_DISK_FLAG_PRESERVE_PARENT_CHANGE_TRACKING_STATE = CREATE_VIRTUAL_DISK_FLAG.PRESERVE_PARENT_CHANGE_TRACKING_STATE;
pub const CREATE_VIRTUAL_DISK_FLAG_VHD_SET_USE_ORIGINAL_BACKING_STORAGE = CREATE_VIRTUAL_DISK_FLAG.VHD_SET_USE_ORIGINAL_BACKING_STORAGE;
pub const CREATE_VIRTUAL_DISK_FLAG_SPARSE_FILE = CREATE_VIRTUAL_DISK_FLAG.SPARSE_FILE;
pub const CREATE_VIRTUAL_DISK_FLAG_PMEM_COMPATIBLE = CREATE_VIRTUAL_DISK_FLAG.PMEM_COMPATIBLE;
pub const CREATE_VIRTUAL_DISK_FLAG_SUPPORT_COMPRESSED_VOLUMES = CREATE_VIRTUAL_DISK_FLAG.SUPPORT_COMPRESSED_VOLUMES;
pub const CREATE_VIRTUAL_DISK_FLAG_SUPPORT_SPARSE_FILES_ANY_FS = CREATE_VIRTUAL_DISK_FLAG.SUPPORT_SPARSE_FILES_ANY_FS;

pub const ATTACH_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
    @"2" = 2,
};
pub const ATTACH_VIRTUAL_DISK_VERSION_UNSPECIFIED = ATTACH_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const ATTACH_VIRTUAL_DISK_VERSION_1 = ATTACH_VIRTUAL_DISK_VERSION.@"1";
pub const ATTACH_VIRTUAL_DISK_VERSION_2 = ATTACH_VIRTUAL_DISK_VERSION.@"2";

pub const ATTACH_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: ATTACH_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            Reserved: u32,
        },
        Version2: extern struct {
            RestrictedOffset: u64,
            RestrictedLength: u64,
        },
    },
};

pub const ATTACH_VIRTUAL_DISK_FLAG = enum(u32) {
    NONE = 0,
    READ_ONLY = 1,
    NO_DRIVE_LETTER = 2,
    PERMANENT_LIFETIME = 4,
    NO_LOCAL_HOST = 8,
    NO_SECURITY_DESCRIPTOR = 16,
    BYPASS_DEFAULT_ENCRYPTION_POLICY = 32,
    NON_PNP = 64,
    RESTRICTED_RANGE = 128,
    SINGLE_PARTITION = 256,
    REGISTER_VOLUME = 512,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        READ_ONLY: u1 = 0,
        NO_DRIVE_LETTER: u1 = 0,
        PERMANENT_LIFETIME: u1 = 0,
        NO_LOCAL_HOST: u1 = 0,
        NO_SECURITY_DESCRIPTOR: u1 = 0,
        BYPASS_DEFAULT_ENCRYPTION_POLICY: u1 = 0,
        NON_PNP: u1 = 0,
        RESTRICTED_RANGE: u1 = 0,
        SINGLE_PARTITION: u1 = 0,
        REGISTER_VOLUME: u1 = 0,
    }) ATTACH_VIRTUAL_DISK_FLAG {
        return @as(ATTACH_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.NONE) else 0) | (if (o.READ_ONLY == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.READ_ONLY) else 0) | (if (o.NO_DRIVE_LETTER == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.NO_DRIVE_LETTER) else 0) | (if (o.PERMANENT_LIFETIME == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.PERMANENT_LIFETIME) else 0) | (if (o.NO_LOCAL_HOST == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.NO_LOCAL_HOST) else 0) | (if (o.NO_SECURITY_DESCRIPTOR == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.NO_SECURITY_DESCRIPTOR) else 0) | (if (o.BYPASS_DEFAULT_ENCRYPTION_POLICY == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.BYPASS_DEFAULT_ENCRYPTION_POLICY) else 0) | (if (o.NON_PNP == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.NON_PNP) else 0) | (if (o.RESTRICTED_RANGE == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.RESTRICTED_RANGE) else 0) | (if (o.SINGLE_PARTITION == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.SINGLE_PARTITION) else 0) | (if (o.REGISTER_VOLUME == 1) @intFromEnum(ATTACH_VIRTUAL_DISK_FLAG.REGISTER_VOLUME) else 0)));
    }
};
pub const ATTACH_VIRTUAL_DISK_FLAG_NONE = ATTACH_VIRTUAL_DISK_FLAG.NONE;
pub const ATTACH_VIRTUAL_DISK_FLAG_READ_ONLY = ATTACH_VIRTUAL_DISK_FLAG.READ_ONLY;
pub const ATTACH_VIRTUAL_DISK_FLAG_NO_DRIVE_LETTER = ATTACH_VIRTUAL_DISK_FLAG.NO_DRIVE_LETTER;
pub const ATTACH_VIRTUAL_DISK_FLAG_PERMANENT_LIFETIME = ATTACH_VIRTUAL_DISK_FLAG.PERMANENT_LIFETIME;
pub const ATTACH_VIRTUAL_DISK_FLAG_NO_LOCAL_HOST = ATTACH_VIRTUAL_DISK_FLAG.NO_LOCAL_HOST;
pub const ATTACH_VIRTUAL_DISK_FLAG_NO_SECURITY_DESCRIPTOR = ATTACH_VIRTUAL_DISK_FLAG.NO_SECURITY_DESCRIPTOR;
pub const ATTACH_VIRTUAL_DISK_FLAG_BYPASS_DEFAULT_ENCRYPTION_POLICY = ATTACH_VIRTUAL_DISK_FLAG.BYPASS_DEFAULT_ENCRYPTION_POLICY;
pub const ATTACH_VIRTUAL_DISK_FLAG_NON_PNP = ATTACH_VIRTUAL_DISK_FLAG.NON_PNP;
pub const ATTACH_VIRTUAL_DISK_FLAG_RESTRICTED_RANGE = ATTACH_VIRTUAL_DISK_FLAG.RESTRICTED_RANGE;
pub const ATTACH_VIRTUAL_DISK_FLAG_SINGLE_PARTITION = ATTACH_VIRTUAL_DISK_FLAG.SINGLE_PARTITION;
pub const ATTACH_VIRTUAL_DISK_FLAG_REGISTER_VOLUME = ATTACH_VIRTUAL_DISK_FLAG.REGISTER_VOLUME;

pub const DETACH_VIRTUAL_DISK_FLAG = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) DETACH_VIRTUAL_DISK_FLAG {
        return @as(DETACH_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.E == 1) @intFromEnum(DETACH_VIRTUAL_DISK_FLAG.E) else 0)));
    }
};
pub const DETACH_VIRTUAL_DISK_FLAG_NONE = DETACH_VIRTUAL_DISK_FLAG.E;

pub const DEPENDENT_DISK_FLAG = enum(u32) {
    NONE = 0,
    MULT_BACKING_FILES = 1,
    FULLY_ALLOCATED = 2,
    READ_ONLY = 4,
    REMOTE = 8,
    SYSTEM_VOLUME = 16,
    SYSTEM_VOLUME_PARENT = 32,
    REMOVABLE = 64,
    NO_DRIVE_LETTER = 128,
    PARENT = 256,
    NO_HOST_DISK = 512,
    PERMANENT_LIFETIME = 1024,
    SUPPORT_COMPRESSED_VOLUMES = 2048,
    ALWAYS_ALLOW_SPARSE = 4096,
    SUPPORT_ENCRYPTED_FILES = 8192,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        MULT_BACKING_FILES: u1 = 0,
        FULLY_ALLOCATED: u1 = 0,
        READ_ONLY: u1 = 0,
        REMOTE: u1 = 0,
        SYSTEM_VOLUME: u1 = 0,
        SYSTEM_VOLUME_PARENT: u1 = 0,
        REMOVABLE: u1 = 0,
        NO_DRIVE_LETTER: u1 = 0,
        PARENT: u1 = 0,
        NO_HOST_DISK: u1 = 0,
        PERMANENT_LIFETIME: u1 = 0,
        SUPPORT_COMPRESSED_VOLUMES: u1 = 0,
        ALWAYS_ALLOW_SPARSE: u1 = 0,
        SUPPORT_ENCRYPTED_FILES: u1 = 0,
    }) DEPENDENT_DISK_FLAG {
        return @as(DEPENDENT_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(DEPENDENT_DISK_FLAG.NONE) else 0) | (if (o.MULT_BACKING_FILES == 1) @intFromEnum(DEPENDENT_DISK_FLAG.MULT_BACKING_FILES) else 0) | (if (o.FULLY_ALLOCATED == 1) @intFromEnum(DEPENDENT_DISK_FLAG.FULLY_ALLOCATED) else 0) | (if (o.READ_ONLY == 1) @intFromEnum(DEPENDENT_DISK_FLAG.READ_ONLY) else 0) | (if (o.REMOTE == 1) @intFromEnum(DEPENDENT_DISK_FLAG.REMOTE) else 0) | (if (o.SYSTEM_VOLUME == 1) @intFromEnum(DEPENDENT_DISK_FLAG.SYSTEM_VOLUME) else 0) | (if (o.SYSTEM_VOLUME_PARENT == 1) @intFromEnum(DEPENDENT_DISK_FLAG.SYSTEM_VOLUME_PARENT) else 0) | (if (o.REMOVABLE == 1) @intFromEnum(DEPENDENT_DISK_FLAG.REMOVABLE) else 0) | (if (o.NO_DRIVE_LETTER == 1) @intFromEnum(DEPENDENT_DISK_FLAG.NO_DRIVE_LETTER) else 0) | (if (o.PARENT == 1) @intFromEnum(DEPENDENT_DISK_FLAG.PARENT) else 0) | (if (o.NO_HOST_DISK == 1) @intFromEnum(DEPENDENT_DISK_FLAG.NO_HOST_DISK) else 0) | (if (o.PERMANENT_LIFETIME == 1) @intFromEnum(DEPENDENT_DISK_FLAG.PERMANENT_LIFETIME) else 0) | (if (o.SUPPORT_COMPRESSED_VOLUMES == 1) @intFromEnum(DEPENDENT_DISK_FLAG.SUPPORT_COMPRESSED_VOLUMES) else 0) | (if (o.ALWAYS_ALLOW_SPARSE == 1) @intFromEnum(DEPENDENT_DISK_FLAG.ALWAYS_ALLOW_SPARSE) else 0) | (if (o.SUPPORT_ENCRYPTED_FILES == 1) @intFromEnum(DEPENDENT_DISK_FLAG.SUPPORT_ENCRYPTED_FILES) else 0)));
    }
};
pub const DEPENDENT_DISK_FLAG_NONE = DEPENDENT_DISK_FLAG.NONE;
pub const DEPENDENT_DISK_FLAG_MULT_BACKING_FILES = DEPENDENT_DISK_FLAG.MULT_BACKING_FILES;
pub const DEPENDENT_DISK_FLAG_FULLY_ALLOCATED = DEPENDENT_DISK_FLAG.FULLY_ALLOCATED;
pub const DEPENDENT_DISK_FLAG_READ_ONLY = DEPENDENT_DISK_FLAG.READ_ONLY;
pub const DEPENDENT_DISK_FLAG_REMOTE = DEPENDENT_DISK_FLAG.REMOTE;
pub const DEPENDENT_DISK_FLAG_SYSTEM_VOLUME = DEPENDENT_DISK_FLAG.SYSTEM_VOLUME;
pub const DEPENDENT_DISK_FLAG_SYSTEM_VOLUME_PARENT = DEPENDENT_DISK_FLAG.SYSTEM_VOLUME_PARENT;
pub const DEPENDENT_DISK_FLAG_REMOVABLE = DEPENDENT_DISK_FLAG.REMOVABLE;
pub const DEPENDENT_DISK_FLAG_NO_DRIVE_LETTER = DEPENDENT_DISK_FLAG.NO_DRIVE_LETTER;
pub const DEPENDENT_DISK_FLAG_PARENT = DEPENDENT_DISK_FLAG.PARENT;
pub const DEPENDENT_DISK_FLAG_NO_HOST_DISK = DEPENDENT_DISK_FLAG.NO_HOST_DISK;
pub const DEPENDENT_DISK_FLAG_PERMANENT_LIFETIME = DEPENDENT_DISK_FLAG.PERMANENT_LIFETIME;
pub const DEPENDENT_DISK_FLAG_SUPPORT_COMPRESSED_VOLUMES = DEPENDENT_DISK_FLAG.SUPPORT_COMPRESSED_VOLUMES;
pub const DEPENDENT_DISK_FLAG_ALWAYS_ALLOW_SPARSE = DEPENDENT_DISK_FLAG.ALWAYS_ALLOW_SPARSE;
pub const DEPENDENT_DISK_FLAG_SUPPORT_ENCRYPTED_FILES = DEPENDENT_DISK_FLAG.SUPPORT_ENCRYPTED_FILES;

pub const STORAGE_DEPENDENCY_INFO_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
    @"2" = 2,
};
pub const STORAGE_DEPENDENCY_INFO_VERSION_UNSPECIFIED = STORAGE_DEPENDENCY_INFO_VERSION.UNSPECIFIED;
pub const STORAGE_DEPENDENCY_INFO_VERSION_1 = STORAGE_DEPENDENCY_INFO_VERSION.@"1";
pub const STORAGE_DEPENDENCY_INFO_VERSION_2 = STORAGE_DEPENDENCY_INFO_VERSION.@"2";

pub const STORAGE_DEPENDENCY_INFO_TYPE_1 = extern struct {
    DependencyTypeFlags: DEPENDENT_DISK_FLAG,
    ProviderSpecificFlags: u32,
    VirtualStorageType: VIRTUAL_STORAGE_TYPE,
};

pub const STORAGE_DEPENDENCY_INFO_TYPE_2 = extern struct {
    DependencyTypeFlags: DEPENDENT_DISK_FLAG,
    ProviderSpecificFlags: u32,
    VirtualStorageType: VIRTUAL_STORAGE_TYPE,
    AncestorLevel: u32,
    DependencyDeviceName: ?PWSTR,
    HostVolumeName: ?PWSTR,
    DependentVolumeName: ?PWSTR,
    DependentVolumeRelativePath: ?PWSTR,
};

pub const STORAGE_DEPENDENCY_INFO = extern struct {
    Version: STORAGE_DEPENDENCY_INFO_VERSION,
    NumberEntries: u32,
    Anonymous: extern union {
        Version1Entries: [1]STORAGE_DEPENDENCY_INFO_TYPE_1,
        Version2Entries: [1]STORAGE_DEPENDENCY_INFO_TYPE_2,
    },
};

pub const GET_STORAGE_DEPENDENCY_FLAG = enum(u32) {
    NONE = 0,
    HOST_VOLUMES = 1,
    DISK_HANDLE = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        HOST_VOLUMES: u1 = 0,
        DISK_HANDLE: u1 = 0,
    }) GET_STORAGE_DEPENDENCY_FLAG {
        return @as(GET_STORAGE_DEPENDENCY_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(GET_STORAGE_DEPENDENCY_FLAG.NONE) else 0) | (if (o.HOST_VOLUMES == 1) @intFromEnum(GET_STORAGE_DEPENDENCY_FLAG.HOST_VOLUMES) else 0) | (if (o.DISK_HANDLE == 1) @intFromEnum(GET_STORAGE_DEPENDENCY_FLAG.DISK_HANDLE) else 0)));
    }
};
pub const GET_STORAGE_DEPENDENCY_FLAG_NONE = GET_STORAGE_DEPENDENCY_FLAG.NONE;
pub const GET_STORAGE_DEPENDENCY_FLAG_HOST_VOLUMES = GET_STORAGE_DEPENDENCY_FLAG.HOST_VOLUMES;
pub const GET_STORAGE_DEPENDENCY_FLAG_DISK_HANDLE = GET_STORAGE_DEPENDENCY_FLAG.DISK_HANDLE;

pub const GET_VIRTUAL_DISK_INFO_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    SIZE = 1,
    IDENTIFIER = 2,
    PARENT_LOCATION = 3,
    PARENT_IDENTIFIER = 4,
    PARENT_TIMESTAMP = 5,
    VIRTUAL_STORAGE_TYPE = 6,
    PROVIDER_SUBTYPE = 7,
    IS_4K_ALIGNED = 8,
    PHYSICAL_DISK = 9,
    VHD_PHYSICAL_SECTOR_SIZE = 10,
    SMALLEST_SAFE_VIRTUAL_SIZE = 11,
    FRAGMENTATION = 12,
    IS_LOADED = 13,
    VIRTUAL_DISK_ID = 14,
    CHANGE_TRACKING_STATE = 15,
};
pub const GET_VIRTUAL_DISK_INFO_UNSPECIFIED = GET_VIRTUAL_DISK_INFO_VERSION.UNSPECIFIED;
pub const GET_VIRTUAL_DISK_INFO_SIZE = GET_VIRTUAL_DISK_INFO_VERSION.SIZE;
pub const GET_VIRTUAL_DISK_INFO_IDENTIFIER = GET_VIRTUAL_DISK_INFO_VERSION.IDENTIFIER;
pub const GET_VIRTUAL_DISK_INFO_PARENT_LOCATION = GET_VIRTUAL_DISK_INFO_VERSION.PARENT_LOCATION;
pub const GET_VIRTUAL_DISK_INFO_PARENT_IDENTIFIER = GET_VIRTUAL_DISK_INFO_VERSION.PARENT_IDENTIFIER;
pub const GET_VIRTUAL_DISK_INFO_PARENT_TIMESTAMP = GET_VIRTUAL_DISK_INFO_VERSION.PARENT_TIMESTAMP;
pub const GET_VIRTUAL_DISK_INFO_VIRTUAL_STORAGE_TYPE = GET_VIRTUAL_DISK_INFO_VERSION.VIRTUAL_STORAGE_TYPE;
pub const GET_VIRTUAL_DISK_INFO_PROVIDER_SUBTYPE = GET_VIRTUAL_DISK_INFO_VERSION.PROVIDER_SUBTYPE;
pub const GET_VIRTUAL_DISK_INFO_IS_4K_ALIGNED = GET_VIRTUAL_DISK_INFO_VERSION.IS_4K_ALIGNED;
pub const GET_VIRTUAL_DISK_INFO_PHYSICAL_DISK = GET_VIRTUAL_DISK_INFO_VERSION.PHYSICAL_DISK;
pub const GET_VIRTUAL_DISK_INFO_VHD_PHYSICAL_SECTOR_SIZE = GET_VIRTUAL_DISK_INFO_VERSION.VHD_PHYSICAL_SECTOR_SIZE;
pub const GET_VIRTUAL_DISK_INFO_SMALLEST_SAFE_VIRTUAL_SIZE = GET_VIRTUAL_DISK_INFO_VERSION.SMALLEST_SAFE_VIRTUAL_SIZE;
pub const GET_VIRTUAL_DISK_INFO_FRAGMENTATION = GET_VIRTUAL_DISK_INFO_VERSION.FRAGMENTATION;
pub const GET_VIRTUAL_DISK_INFO_IS_LOADED = GET_VIRTUAL_DISK_INFO_VERSION.IS_LOADED;
pub const GET_VIRTUAL_DISK_INFO_VIRTUAL_DISK_ID = GET_VIRTUAL_DISK_INFO_VERSION.VIRTUAL_DISK_ID;
pub const GET_VIRTUAL_DISK_INFO_CHANGE_TRACKING_STATE = GET_VIRTUAL_DISK_INFO_VERSION.CHANGE_TRACKING_STATE;

pub const GET_VIRTUAL_DISK_INFO = extern struct {
    Version: GET_VIRTUAL_DISK_INFO_VERSION,
    Anonymous: extern union {
        Size: extern struct {
            VirtualSize: u64,
            PhysicalSize: u64,
            BlockSize: u32,
            SectorSize: u32,
        },
        Identifier: Guid,
        ParentLocation: extern struct {
            ParentResolved: BOOL,
            ParentLocationBuffer: [1]u16,
        },
        ParentIdentifier: Guid,
        ParentTimestamp: u32,
        VirtualStorageType: VIRTUAL_STORAGE_TYPE,
        ProviderSubtype: u32,
        Is4kAligned: BOOL,
        IsLoaded: BOOL,
        PhysicalDisk: extern struct {
            LogicalSectorSize: u32,
            PhysicalSectorSize: u32,
            IsRemote: BOOL,
        },
        VhdPhysicalSectorSize: u32,
        SmallestSafeVirtualSize: u64,
        FragmentationPercentage: u32,
        VirtualDiskId: Guid,
        ChangeTrackingState: extern struct {
            Enabled: BOOL,
            NewerChanges: BOOL,
            MostRecentId: [1]u16,
        },
    },
};

pub const SET_VIRTUAL_DISK_INFO_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    PARENT_PATH = 1,
    IDENTIFIER = 2,
    PARENT_PATH_WITH_DEPTH = 3,
    PHYSICAL_SECTOR_SIZE = 4,
    VIRTUAL_DISK_ID = 5,
    CHANGE_TRACKING_STATE = 6,
    PARENT_LOCATOR = 7,
};
pub const SET_VIRTUAL_DISK_INFO_UNSPECIFIED = SET_VIRTUAL_DISK_INFO_VERSION.UNSPECIFIED;
pub const SET_VIRTUAL_DISK_INFO_PARENT_PATH = SET_VIRTUAL_DISK_INFO_VERSION.PARENT_PATH;
pub const SET_VIRTUAL_DISK_INFO_IDENTIFIER = SET_VIRTUAL_DISK_INFO_VERSION.IDENTIFIER;
pub const SET_VIRTUAL_DISK_INFO_PARENT_PATH_WITH_DEPTH = SET_VIRTUAL_DISK_INFO_VERSION.PARENT_PATH_WITH_DEPTH;
pub const SET_VIRTUAL_DISK_INFO_PHYSICAL_SECTOR_SIZE = SET_VIRTUAL_DISK_INFO_VERSION.PHYSICAL_SECTOR_SIZE;
pub const SET_VIRTUAL_DISK_INFO_VIRTUAL_DISK_ID = SET_VIRTUAL_DISK_INFO_VERSION.VIRTUAL_DISK_ID;
pub const SET_VIRTUAL_DISK_INFO_CHANGE_TRACKING_STATE = SET_VIRTUAL_DISK_INFO_VERSION.CHANGE_TRACKING_STATE;
pub const SET_VIRTUAL_DISK_INFO_PARENT_LOCATOR = SET_VIRTUAL_DISK_INFO_VERSION.PARENT_LOCATOR;

pub const SET_VIRTUAL_DISK_INFO = extern struct {
    Version: SET_VIRTUAL_DISK_INFO_VERSION,
    Anonymous: extern union {
        ParentFilePath: ?[*:0]const u16,
        UniqueIdentifier: Guid,
        ParentPathWithDepthInfo: extern struct {
            ChildDepth: u32,
            ParentFilePath: ?[*:0]const u16,
        },
        VhdPhysicalSectorSize: u32,
        VirtualDiskId: Guid,
        ChangeTrackingEnabled: BOOL,
        ParentLocator: extern struct {
            LinkageId: Guid,
            ParentFilePath: ?[*:0]const u16,
        },
    },
};

pub const VIRTUAL_DISK_PROGRESS = extern struct {
    OperationStatus: u32,
    CurrentValue: u64,
    CompletionValue: u64,
};

pub const COMPACT_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const COMPACT_VIRTUAL_DISK_VERSION_UNSPECIFIED = COMPACT_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const COMPACT_VIRTUAL_DISK_VERSION_1 = COMPACT_VIRTUAL_DISK_VERSION.@"1";

pub const COMPACT_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: COMPACT_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            Reserved: u32,
        },
    },
};

pub const COMPACT_VIRTUAL_DISK_FLAG = enum(u32) {
    NE = 0,
    _ZERO_SCAN = 1,
    _BLOCK_MOVES = 2,
    _,
    pub fn initFlags(o: struct {
        NE: u1 = 0,
        _ZERO_SCAN: u1 = 0,
        _BLOCK_MOVES: u1 = 0,
    }) COMPACT_VIRTUAL_DISK_FLAG {
        return @as(COMPACT_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NE == 1) @intFromEnum(COMPACT_VIRTUAL_DISK_FLAG.NE) else 0) | (if (o._ZERO_SCAN == 1) @intFromEnum(COMPACT_VIRTUAL_DISK_FLAG._ZERO_SCAN) else 0) | (if (o._BLOCK_MOVES == 1) @intFromEnum(COMPACT_VIRTUAL_DISK_FLAG._BLOCK_MOVES) else 0)));
    }
};
pub const COMPACT_VIRTUAL_DISK_FLAG_NONE = COMPACT_VIRTUAL_DISK_FLAG.NE;
pub const COMPACT_VIRTUAL_DISK_FLAG_NO_ZERO_SCAN = COMPACT_VIRTUAL_DISK_FLAG._ZERO_SCAN;
pub const COMPACT_VIRTUAL_DISK_FLAG_NO_BLOCK_MOVES = COMPACT_VIRTUAL_DISK_FLAG._BLOCK_MOVES;

pub const MERGE_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
    @"2" = 2,
};
pub const MERGE_VIRTUAL_DISK_VERSION_UNSPECIFIED = MERGE_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const MERGE_VIRTUAL_DISK_VERSION_1 = MERGE_VIRTUAL_DISK_VERSION.@"1";
pub const MERGE_VIRTUAL_DISK_VERSION_2 = MERGE_VIRTUAL_DISK_VERSION.@"2";

pub const MERGE_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: MERGE_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            MergeDepth: u32,
        },
        Version2: extern struct {
            MergeSourceDepth: u32,
            MergeTargetDepth: u32,
        },
    },
};

pub const MERGE_VIRTUAL_DISK_FLAG = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) MERGE_VIRTUAL_DISK_FLAG {
        return @as(MERGE_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.E == 1) @intFromEnum(MERGE_VIRTUAL_DISK_FLAG.E) else 0)));
    }
};
pub const MERGE_VIRTUAL_DISK_FLAG_NONE = MERGE_VIRTUAL_DISK_FLAG.E;

pub const EXPAND_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const EXPAND_VIRTUAL_DISK_VERSION_UNSPECIFIED = EXPAND_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const EXPAND_VIRTUAL_DISK_VERSION_1 = EXPAND_VIRTUAL_DISK_VERSION.@"1";

pub const EXPAND_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: EXPAND_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            NewSize: u64,
        },
    },
};

pub const EXPAND_VIRTUAL_DISK_FLAG = enum(u32) {
    NE = 0,
    TIFY_CHANGE = 1,
    _,
    pub fn initFlags(o: struct {
        NE: u1 = 0,
        TIFY_CHANGE: u1 = 0,
    }) EXPAND_VIRTUAL_DISK_FLAG {
        return @as(EXPAND_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NE == 1) @intFromEnum(EXPAND_VIRTUAL_DISK_FLAG.NE) else 0) | (if (o.TIFY_CHANGE == 1) @intFromEnum(EXPAND_VIRTUAL_DISK_FLAG.TIFY_CHANGE) else 0)));
    }
};
pub const EXPAND_VIRTUAL_DISK_FLAG_NONE = EXPAND_VIRTUAL_DISK_FLAG.NE;
pub const EXPAND_VIRTUAL_DISK_FLAG_NOTIFY_CHANGE = EXPAND_VIRTUAL_DISK_FLAG.TIFY_CHANGE;

pub const RESIZE_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const RESIZE_VIRTUAL_DISK_VERSION_UNSPECIFIED = RESIZE_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const RESIZE_VIRTUAL_DISK_VERSION_1 = RESIZE_VIRTUAL_DISK_VERSION.@"1";

pub const RESIZE_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: RESIZE_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            NewSize: u64,
        },
    },
};

pub const RESIZE_VIRTUAL_DISK_FLAG = enum(u32) {
    NONE = 0,
    ALLOW_UNSAFE_VIRTUAL_SIZE = 1,
    RESIZE_TO_SMALLEST_SAFE_VIRTUAL_SIZE = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        ALLOW_UNSAFE_VIRTUAL_SIZE: u1 = 0,
        RESIZE_TO_SMALLEST_SAFE_VIRTUAL_SIZE: u1 = 0,
    }) RESIZE_VIRTUAL_DISK_FLAG {
        return @as(RESIZE_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(RESIZE_VIRTUAL_DISK_FLAG.NONE) else 0) | (if (o.ALLOW_UNSAFE_VIRTUAL_SIZE == 1) @intFromEnum(RESIZE_VIRTUAL_DISK_FLAG.ALLOW_UNSAFE_VIRTUAL_SIZE) else 0) | (if (o.RESIZE_TO_SMALLEST_SAFE_VIRTUAL_SIZE == 1) @intFromEnum(RESIZE_VIRTUAL_DISK_FLAG.RESIZE_TO_SMALLEST_SAFE_VIRTUAL_SIZE) else 0)));
    }
};
pub const RESIZE_VIRTUAL_DISK_FLAG_NONE = RESIZE_VIRTUAL_DISK_FLAG.NONE;
pub const RESIZE_VIRTUAL_DISK_FLAG_ALLOW_UNSAFE_VIRTUAL_SIZE = RESIZE_VIRTUAL_DISK_FLAG.ALLOW_UNSAFE_VIRTUAL_SIZE;
pub const RESIZE_VIRTUAL_DISK_FLAG_RESIZE_TO_SMALLEST_SAFE_VIRTUAL_SIZE = RESIZE_VIRTUAL_DISK_FLAG.RESIZE_TO_SMALLEST_SAFE_VIRTUAL_SIZE;

pub const MIRROR_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const MIRROR_VIRTUAL_DISK_VERSION_UNSPECIFIED = MIRROR_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const MIRROR_VIRTUAL_DISK_VERSION_1 = MIRROR_VIRTUAL_DISK_VERSION.@"1";

pub const MIRROR_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: MIRROR_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            MirrorVirtualDiskPath: ?[*:0]const u16,
        },
    },
};

pub const MIRROR_VIRTUAL_DISK_FLAG = enum(u32) {
    NONE = 0,
    EXISTING_FILE = 1,
    SKIP_MIRROR_ACTIVATION = 2,
    ENABLE_SMB_COMPRESSION = 4,
    IS_LIVE_MIGRATION = 8,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        EXISTING_FILE: u1 = 0,
        SKIP_MIRROR_ACTIVATION: u1 = 0,
        ENABLE_SMB_COMPRESSION: u1 = 0,
        IS_LIVE_MIGRATION: u1 = 0,
    }) MIRROR_VIRTUAL_DISK_FLAG {
        return @as(MIRROR_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(MIRROR_VIRTUAL_DISK_FLAG.NONE) else 0) | (if (o.EXISTING_FILE == 1) @intFromEnum(MIRROR_VIRTUAL_DISK_FLAG.EXISTING_FILE) else 0) | (if (o.SKIP_MIRROR_ACTIVATION == 1) @intFromEnum(MIRROR_VIRTUAL_DISK_FLAG.SKIP_MIRROR_ACTIVATION) else 0) | (if (o.ENABLE_SMB_COMPRESSION == 1) @intFromEnum(MIRROR_VIRTUAL_DISK_FLAG.ENABLE_SMB_COMPRESSION) else 0) | (if (o.IS_LIVE_MIGRATION == 1) @intFromEnum(MIRROR_VIRTUAL_DISK_FLAG.IS_LIVE_MIGRATION) else 0)));
    }
};
pub const MIRROR_VIRTUAL_DISK_FLAG_NONE = MIRROR_VIRTUAL_DISK_FLAG.NONE;
pub const MIRROR_VIRTUAL_DISK_FLAG_EXISTING_FILE = MIRROR_VIRTUAL_DISK_FLAG.EXISTING_FILE;
pub const MIRROR_VIRTUAL_DISK_FLAG_SKIP_MIRROR_ACTIVATION = MIRROR_VIRTUAL_DISK_FLAG.SKIP_MIRROR_ACTIVATION;
pub const MIRROR_VIRTUAL_DISK_FLAG_ENABLE_SMB_COMPRESSION = MIRROR_VIRTUAL_DISK_FLAG.ENABLE_SMB_COMPRESSION;
pub const MIRROR_VIRTUAL_DISK_FLAG_IS_LIVE_MIGRATION = MIRROR_VIRTUAL_DISK_FLAG.IS_LIVE_MIGRATION;

pub const QUERY_CHANGES_VIRTUAL_DISK_RANGE = extern struct {
    ByteOffset: u64,
    ByteLength: u64,
    Reserved: u64,
};

pub const QUERY_CHANGES_VIRTUAL_DISK_FLAG = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) QUERY_CHANGES_VIRTUAL_DISK_FLAG {
        return @as(QUERY_CHANGES_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.E == 1) @intFromEnum(QUERY_CHANGES_VIRTUAL_DISK_FLAG.E) else 0)));
    }
};
pub const QUERY_CHANGES_VIRTUAL_DISK_FLAG_NONE = QUERY_CHANGES_VIRTUAL_DISK_FLAG.E;

pub const TAKE_SNAPSHOT_VHDSET_FLAG = enum(u32) {
    NONE = 0,
    WRITEABLE = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        WRITEABLE: u1 = 0,
    }) TAKE_SNAPSHOT_VHDSET_FLAG {
        return @as(TAKE_SNAPSHOT_VHDSET_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(TAKE_SNAPSHOT_VHDSET_FLAG.NONE) else 0) | (if (o.WRITEABLE == 1) @intFromEnum(TAKE_SNAPSHOT_VHDSET_FLAG.WRITEABLE) else 0)));
    }
};
pub const TAKE_SNAPSHOT_VHDSET_FLAG_NONE = TAKE_SNAPSHOT_VHDSET_FLAG.NONE;
pub const TAKE_SNAPSHOT_VHDSET_FLAG_WRITEABLE = TAKE_SNAPSHOT_VHDSET_FLAG.WRITEABLE;

pub const TAKE_SNAPSHOT_VHDSET_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const TAKE_SNAPSHOT_VHDSET_VERSION_UNSPECIFIED = TAKE_SNAPSHOT_VHDSET_VERSION.UNSPECIFIED;
pub const TAKE_SNAPSHOT_VHDSET_VERSION_1 = TAKE_SNAPSHOT_VHDSET_VERSION.@"1";

pub const TAKE_SNAPSHOT_VHDSET_PARAMETERS = extern struct {
    Version: TAKE_SNAPSHOT_VHDSET_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            SnapshotId: Guid,
        },
    },
};

pub const DELETE_SNAPSHOT_VHDSET_FLAG = enum(u32) {
    NONE = 0,
    PERSIST_RCT = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        PERSIST_RCT: u1 = 0,
    }) DELETE_SNAPSHOT_VHDSET_FLAG {
        return @as(DELETE_SNAPSHOT_VHDSET_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(DELETE_SNAPSHOT_VHDSET_FLAG.NONE) else 0) | (if (o.PERSIST_RCT == 1) @intFromEnum(DELETE_SNAPSHOT_VHDSET_FLAG.PERSIST_RCT) else 0)));
    }
};
pub const DELETE_SNAPSHOT_VHDSET_FLAG_NONE = DELETE_SNAPSHOT_VHDSET_FLAG.NONE;
pub const DELETE_SNAPSHOT_VHDSET_FLAG_PERSIST_RCT = DELETE_SNAPSHOT_VHDSET_FLAG.PERSIST_RCT;

pub const DELETE_SNAPSHOT_VHDSET_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const DELETE_SNAPSHOT_VHDSET_VERSION_UNSPECIFIED = DELETE_SNAPSHOT_VHDSET_VERSION.UNSPECIFIED;
pub const DELETE_SNAPSHOT_VHDSET_VERSION_1 = DELETE_SNAPSHOT_VHDSET_VERSION.@"1";

pub const DELETE_SNAPSHOT_VHDSET_PARAMETERS = extern struct {
    Version: DELETE_SNAPSHOT_VHDSET_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            SnapshotId: Guid,
        },
    },
};

pub const MODIFY_VHDSET_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    SNAPSHOT_PATH = 1,
    REMOVE_SNAPSHOT = 2,
    DEFAULT_SNAPSHOT_PATH = 3,
};
pub const MODIFY_VHDSET_UNSPECIFIED = MODIFY_VHDSET_VERSION.UNSPECIFIED;
pub const MODIFY_VHDSET_SNAPSHOT_PATH = MODIFY_VHDSET_VERSION.SNAPSHOT_PATH;
pub const MODIFY_VHDSET_REMOVE_SNAPSHOT = MODIFY_VHDSET_VERSION.REMOVE_SNAPSHOT;
pub const MODIFY_VHDSET_DEFAULT_SNAPSHOT_PATH = MODIFY_VHDSET_VERSION.DEFAULT_SNAPSHOT_PATH;

pub const MODIFY_VHDSET_FLAG = enum(u32) {
    NONE = 0,
    WRITEABLE_SNAPSHOT = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        WRITEABLE_SNAPSHOT: u1 = 0,
    }) MODIFY_VHDSET_FLAG {
        return @as(MODIFY_VHDSET_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(MODIFY_VHDSET_FLAG.NONE) else 0) | (if (o.WRITEABLE_SNAPSHOT == 1) @intFromEnum(MODIFY_VHDSET_FLAG.WRITEABLE_SNAPSHOT) else 0)));
    }
};
pub const MODIFY_VHDSET_FLAG_NONE = MODIFY_VHDSET_FLAG.NONE;
pub const MODIFY_VHDSET_FLAG_WRITEABLE_SNAPSHOT = MODIFY_VHDSET_FLAG.WRITEABLE_SNAPSHOT;

pub const MODIFY_VHDSET_PARAMETERS = extern struct {
    Version: MODIFY_VHDSET_VERSION,
    Anonymous: extern union {
        SnapshotPath: extern struct {
            SnapshotId: Guid,
            SnapshotFilePath: ?[*:0]const u16,
        },
        SnapshotId: Guid,
        DefaultFilePath: ?[*:0]const u16,
    },
};

pub const APPLY_SNAPSHOT_VHDSET_FLAG = enum(u32) {
    NONE = 0,
    WRITEABLE = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        WRITEABLE: u1 = 0,
    }) APPLY_SNAPSHOT_VHDSET_FLAG {
        return @as(APPLY_SNAPSHOT_VHDSET_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(APPLY_SNAPSHOT_VHDSET_FLAG.NONE) else 0) | (if (o.WRITEABLE == 1) @intFromEnum(APPLY_SNAPSHOT_VHDSET_FLAG.WRITEABLE) else 0)));
    }
};
pub const APPLY_SNAPSHOT_VHDSET_FLAG_NONE = APPLY_SNAPSHOT_VHDSET_FLAG.NONE;
pub const APPLY_SNAPSHOT_VHDSET_FLAG_WRITEABLE = APPLY_SNAPSHOT_VHDSET_FLAG.WRITEABLE;

pub const APPLY_SNAPSHOT_VHDSET_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const APPLY_SNAPSHOT_VHDSET_VERSION_UNSPECIFIED = APPLY_SNAPSHOT_VHDSET_VERSION.UNSPECIFIED;
pub const APPLY_SNAPSHOT_VHDSET_VERSION_1 = APPLY_SNAPSHOT_VHDSET_VERSION.@"1";

pub const APPLY_SNAPSHOT_VHDSET_PARAMETERS = extern struct {
    Version: APPLY_SNAPSHOT_VHDSET_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            SnapshotId: Guid,
            LeafSnapshotId: Guid,
        },
    },
};

pub const RAW_SCSI_VIRTUAL_DISK_FLAG = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) RAW_SCSI_VIRTUAL_DISK_FLAG {
        return @as(RAW_SCSI_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.E == 1) @intFromEnum(RAW_SCSI_VIRTUAL_DISK_FLAG.E) else 0)));
    }
};
pub const RAW_SCSI_VIRTUAL_DISK_FLAG_NONE = RAW_SCSI_VIRTUAL_DISK_FLAG.E;

pub const RAW_SCSI_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const RAW_SCSI_VIRTUAL_DISK_VERSION_UNSPECIFIED = RAW_SCSI_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const RAW_SCSI_VIRTUAL_DISK_VERSION_1 = RAW_SCSI_VIRTUAL_DISK_VERSION.@"1";

pub const RAW_SCSI_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: RAW_SCSI_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            RSVDHandle: BOOL,
            DataIn: u8,
            CdbLength: u8,
            SenseInfoLength: u8,
            SrbFlags: u32,
            DataTransferLength: u32,
            DataBuffer: ?*anyopaque,
            SenseInfo: ?*u8,
            Cdb: ?*u8,
        },
    },
};

pub const RAW_SCSI_VIRTUAL_DISK_RESPONSE = extern struct {
    Version: RAW_SCSI_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            ScsiStatus: u8,
            SenseInfoLength: u8,
            DataTransferLength: u32,
        },
    },
};

pub const FORK_VIRTUAL_DISK_VERSION = enum(i32) {
    UNSPECIFIED = 0,
    @"1" = 1,
};
pub const FORK_VIRTUAL_DISK_VERSION_UNSPECIFIED = FORK_VIRTUAL_DISK_VERSION.UNSPECIFIED;
pub const FORK_VIRTUAL_DISK_VERSION_1 = FORK_VIRTUAL_DISK_VERSION.@"1";

pub const FORK_VIRTUAL_DISK_PARAMETERS = extern struct {
    Version: FORK_VIRTUAL_DISK_VERSION,
    Anonymous: extern union {
        Version1: extern struct {
            ForkedVirtualDiskPath: ?[*:0]const u16,
        },
    },
};

pub const FORK_VIRTUAL_DISK_FLAG = enum(u32) {
    NONE = 0,
    EXISTING_FILE = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        EXISTING_FILE: u1 = 0,
    }) FORK_VIRTUAL_DISK_FLAG {
        return @as(FORK_VIRTUAL_DISK_FLAG, @enumFromInt((if (o.NONE == 1) @intFromEnum(FORK_VIRTUAL_DISK_FLAG.NONE) else 0) | (if (o.EXISTING_FILE == 1) @intFromEnum(FORK_VIRTUAL_DISK_FLAG.EXISTING_FILE) else 0)));
    }
};
pub const FORK_VIRTUAL_DISK_FLAG_NONE = FORK_VIRTUAL_DISK_FLAG.NONE;
pub const FORK_VIRTUAL_DISK_FLAG_EXISTING_FILE = FORK_VIRTUAL_DISK_FLAG.EXISTING_FILE;

//--------------------------------------------------------------------------------
// Section: Functions (29)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn OpenVirtualDisk(
    VirtualStorageType: ?*VIRTUAL_STORAGE_TYPE,
    Path: ?[*:0]const u16,
    VirtualDiskAccessMask: VIRTUAL_DISK_ACCESS_MASK,
    Flags: OPEN_VIRTUAL_DISK_FLAG,
    Parameters: ?*OPEN_VIRTUAL_DISK_PARAMETERS,
    Handle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn CreateVirtualDisk(
    VirtualStorageType: ?*VIRTUAL_STORAGE_TYPE,
    Path: ?[*:0]const u16,
    VirtualDiskAccessMask: VIRTUAL_DISK_ACCESS_MASK,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    Flags: CREATE_VIRTUAL_DISK_FLAG,
    ProviderSpecificFlags: u32,
    Parameters: ?*CREATE_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
    Handle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn AttachVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    Flags: ATTACH_VIRTUAL_DISK_FLAG,
    ProviderSpecificFlags: u32,
    Parameters: ?*ATTACH_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn DetachVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: DETACH_VIRTUAL_DISK_FLAG,
    ProviderSpecificFlags: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn GetVirtualDiskPhysicalPath(
    VirtualDiskHandle: ?HANDLE,
    DiskPathSizeInBytes: ?*u32,
    // TODO: what to do with BytesParamIndex 1?
    DiskPath: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "virtdisk" fn GetAllAttachedVirtualDiskPhysicalPaths(
    PathsBufferSizeInBytes: ?*u32,
    // TODO: what to do with BytesParamIndex 0?
    PathsBuffer: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn GetStorageDependencyInformation(
    ObjectHandle: ?HANDLE,
    Flags: GET_STORAGE_DEPENDENCY_FLAG,
    StorageDependencyInfoSize: u32,
    StorageDependencyInfo: ?*STORAGE_DEPENDENCY_INFO,
    SizeUsed: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn GetVirtualDiskInformation(
    VirtualDiskHandle: ?HANDLE,
    VirtualDiskInfoSize: ?*u32,
    // TODO: what to do with BytesParamIndex 1?
    VirtualDiskInfo: ?*GET_VIRTUAL_DISK_INFO,
    SizeUsed: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn SetVirtualDiskInformation(
    VirtualDiskHandle: ?HANDLE,
    VirtualDiskInfo: ?*SET_VIRTUAL_DISK_INFO,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn EnumerateVirtualDiskMetadata(
    VirtualDiskHandle: ?HANDLE,
    NumberOfItems: ?*u32,
    Items: [*]Guid,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn GetVirtualDiskMetadata(
    VirtualDiskHandle: ?HANDLE,
    Item: ?*const Guid,
    MetaDataSize: ?*u32,
    // TODO: what to do with BytesParamIndex 2?
    MetaData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn SetVirtualDiskMetadata(
    VirtualDiskHandle: ?HANDLE,
    Item: ?*const Guid,
    MetaDataSize: u32,
    // TODO: what to do with BytesParamIndex 2?
    MetaData: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn DeleteVirtualDiskMetadata(
    VirtualDiskHandle: ?HANDLE,
    Item: ?*const Guid,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn GetVirtualDiskOperationProgress(
    VirtualDiskHandle: ?HANDLE,
    Overlapped: ?*OVERLAPPED,
    Progress: ?*VIRTUAL_DISK_PROGRESS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn CompactVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: COMPACT_VIRTUAL_DISK_FLAG,
    Parameters: ?*COMPACT_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn MergeVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: MERGE_VIRTUAL_DISK_FLAG,
    Parameters: ?*MERGE_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "virtdisk" fn ExpandVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: EXPAND_VIRTUAL_DISK_FLAG,
    Parameters: ?*EXPAND_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn ResizeVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: RESIZE_VIRTUAL_DISK_FLAG,
    Parameters: ?*RESIZE_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn MirrorVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: MIRROR_VIRTUAL_DISK_FLAG,
    Parameters: ?*MIRROR_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn BreakMirrorVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "virtdisk" fn AddVirtualDiskParent(
    VirtualDiskHandle: ?HANDLE,
    ParentPath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "virtdisk" fn QueryChangesVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    ChangeTrackingId: ?[*:0]const u16,
    ByteOffset: u64,
    ByteLength: u64,
    Flags: QUERY_CHANGES_VIRTUAL_DISK_FLAG,
    Ranges: [*]QUERY_CHANGES_VIRTUAL_DISK_RANGE,
    RangeCount: ?*u32,
    ProcessedLength: ?*u64,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "virtdisk" fn TakeSnapshotVhdSet(
    VirtualDiskHandle: ?HANDLE,
    Parameters: ?*const TAKE_SNAPSHOT_VHDSET_PARAMETERS,
    Flags: TAKE_SNAPSHOT_VHDSET_FLAG,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "virtdisk" fn DeleteSnapshotVhdSet(
    VirtualDiskHandle: ?HANDLE,
    Parameters: ?*const DELETE_SNAPSHOT_VHDSET_PARAMETERS,
    Flags: DELETE_SNAPSHOT_VHDSET_FLAG,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "virtdisk" fn ModifyVhdSet(
    VirtualDiskHandle: ?HANDLE,
    Parameters: ?*const MODIFY_VHDSET_PARAMETERS,
    Flags: MODIFY_VHDSET_FLAG,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "virtdisk" fn ApplySnapshotVhdSet(
    VirtualDiskHandle: ?HANDLE,
    Parameters: ?*const APPLY_SNAPSHOT_VHDSET_PARAMETERS,
    Flags: APPLY_SNAPSHOT_VHDSET_FLAG,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "virtdisk" fn RawSCSIVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Parameters: ?*const RAW_SCSI_VIRTUAL_DISK_PARAMETERS,
    Flags: RAW_SCSI_VIRTUAL_DISK_FLAG,
    Response: ?*RAW_SCSI_VIRTUAL_DISK_RESPONSE,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "virtdisk" fn ForkVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
    Flags: FORK_VIRTUAL_DISK_FLAG,
    Parameters: ?*const FORK_VIRTUAL_DISK_PARAMETERS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "virtdisk" fn CompleteForkVirtualDisk(
    VirtualDiskHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (6)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const HANDLE = @import("../foundation.zig").HANDLE;
const OVERLAPPED = @import("../system/io.zig").OVERLAPPED;
const PWSTR = @import("../foundation.zig").PWSTR;
const SECURITY_DESCRIPTOR = @import("../security.zig").SECURITY_DESCRIPTOR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
