//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (5)
//--------------------------------------------------------------------------------
pub const CF_REQUEST_KEY_DEFAULT = @as(u32, 0);
pub const CF_PLACEHOLDER_MAX_FILE_IDENTITY_LENGTH = @as(u32, 4096);
pub const CF_MAX_PRIORITY_HINT = @as(u32, 15);
pub const CF_MAX_PROVIDER_NAME_LENGTH = @as(u32, 255);
pub const CF_MAX_PROVIDER_VERSION_LENGTH = @as(u32, 255);

//--------------------------------------------------------------------------------
// Section: Types (75)
//--------------------------------------------------------------------------------
pub const CF_CONNECTION_KEY = isize;

pub const CF_FS_METADATA = extern struct {
    BasicInfo: FILE_BASIC_INFO,
    FileSize: LARGE_INTEGER,
};

pub const CF_PLACEHOLDER_CREATE_FLAGS = enum(u32) {
    NONE = 0,
    DISABLE_ON_DEMAND_POPULATION = 1,
    MARK_IN_SYNC = 2,
    SUPERSEDE = 4,
    ALWAYS_FULL = 8,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        DISABLE_ON_DEMAND_POPULATION: u1 = 0,
        MARK_IN_SYNC: u1 = 0,
        SUPERSEDE: u1 = 0,
        ALWAYS_FULL: u1 = 0,
    }) CF_PLACEHOLDER_CREATE_FLAGS {
        return @as(CF_PLACEHOLDER_CREATE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_PLACEHOLDER_CREATE_FLAGS.NONE) else 0) | (if (o.DISABLE_ON_DEMAND_POPULATION == 1) @intFromEnum(CF_PLACEHOLDER_CREATE_FLAGS.DISABLE_ON_DEMAND_POPULATION) else 0) | (if (o.MARK_IN_SYNC == 1) @intFromEnum(CF_PLACEHOLDER_CREATE_FLAGS.MARK_IN_SYNC) else 0) | (if (o.SUPERSEDE == 1) @intFromEnum(CF_PLACEHOLDER_CREATE_FLAGS.SUPERSEDE) else 0) | (if (o.ALWAYS_FULL == 1) @intFromEnum(CF_PLACEHOLDER_CREATE_FLAGS.ALWAYS_FULL) else 0)));
    }
};
pub const CF_PLACEHOLDER_CREATE_FLAG_NONE = CF_PLACEHOLDER_CREATE_FLAGS.NONE;
pub const CF_PLACEHOLDER_CREATE_FLAG_DISABLE_ON_DEMAND_POPULATION = CF_PLACEHOLDER_CREATE_FLAGS.DISABLE_ON_DEMAND_POPULATION;
pub const CF_PLACEHOLDER_CREATE_FLAG_MARK_IN_SYNC = CF_PLACEHOLDER_CREATE_FLAGS.MARK_IN_SYNC;
pub const CF_PLACEHOLDER_CREATE_FLAG_SUPERSEDE = CF_PLACEHOLDER_CREATE_FLAGS.SUPERSEDE;
pub const CF_PLACEHOLDER_CREATE_FLAG_ALWAYS_FULL = CF_PLACEHOLDER_CREATE_FLAGS.ALWAYS_FULL;

pub const CF_PLACEHOLDER_CREATE_INFO = extern struct {
    RelativeFileName: ?[*:0]const u16,
    FsMetadata: CF_FS_METADATA,
    FileIdentity: ?*const anyopaque,
    FileIdentityLength: u32,
    Flags: CF_PLACEHOLDER_CREATE_FLAGS,
    Result: HRESULT,
    CreateUsn: i64,
};

pub const CF_SYNC_PROVIDER_STATUS = enum(u32) {
    DISCONNECTED = 0,
    IDLE = 1,
    POPULATE_NAMESPACE = 2,
    POPULATE_METADATA = 4,
    POPULATE_CONTENT = 8,
    SYNC_INCREMENTAL = 16,
    SYNC_FULL = 32,
    CONNECTIVITY_LOST = 64,
    CLEAR_FLAGS = 2147483648,
    TERMINATED = 3221225473,
    ERROR = 3221225474,
    _,
    pub fn initFlags(o: struct {
        DISCONNECTED: u1 = 0,
        IDLE: u1 = 0,
        POPULATE_NAMESPACE: u1 = 0,
        POPULATE_METADATA: u1 = 0,
        POPULATE_CONTENT: u1 = 0,
        SYNC_INCREMENTAL: u1 = 0,
        SYNC_FULL: u1 = 0,
        CONNECTIVITY_LOST: u1 = 0,
        CLEAR_FLAGS: u1 = 0,
        TERMINATED: u1 = 0,
        ERROR: u1 = 0,
    }) CF_SYNC_PROVIDER_STATUS {
        return @as(CF_SYNC_PROVIDER_STATUS, @enumFromInt((if (o.DISCONNECTED == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.DISCONNECTED) else 0) | (if (o.IDLE == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.IDLE) else 0) | (if (o.POPULATE_NAMESPACE == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.POPULATE_NAMESPACE) else 0) | (if (o.POPULATE_METADATA == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.POPULATE_METADATA) else 0) | (if (o.POPULATE_CONTENT == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.POPULATE_CONTENT) else 0) | (if (o.SYNC_INCREMENTAL == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.SYNC_INCREMENTAL) else 0) | (if (o.SYNC_FULL == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.SYNC_FULL) else 0) | (if (o.CONNECTIVITY_LOST == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.CONNECTIVITY_LOST) else 0) | (if (o.CLEAR_FLAGS == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.CLEAR_FLAGS) else 0) | (if (o.TERMINATED == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.TERMINATED) else 0) | (if (o.ERROR == 1) @intFromEnum(CF_SYNC_PROVIDER_STATUS.ERROR) else 0)));
    }
};
pub const CF_PROVIDER_STATUS_DISCONNECTED = CF_SYNC_PROVIDER_STATUS.DISCONNECTED;
pub const CF_PROVIDER_STATUS_IDLE = CF_SYNC_PROVIDER_STATUS.IDLE;
pub const CF_PROVIDER_STATUS_POPULATE_NAMESPACE = CF_SYNC_PROVIDER_STATUS.POPULATE_NAMESPACE;
pub const CF_PROVIDER_STATUS_POPULATE_METADATA = CF_SYNC_PROVIDER_STATUS.POPULATE_METADATA;
pub const CF_PROVIDER_STATUS_POPULATE_CONTENT = CF_SYNC_PROVIDER_STATUS.POPULATE_CONTENT;
pub const CF_PROVIDER_STATUS_SYNC_INCREMENTAL = CF_SYNC_PROVIDER_STATUS.SYNC_INCREMENTAL;
pub const CF_PROVIDER_STATUS_SYNC_FULL = CF_SYNC_PROVIDER_STATUS.SYNC_FULL;
pub const CF_PROVIDER_STATUS_CONNECTIVITY_LOST = CF_SYNC_PROVIDER_STATUS.CONNECTIVITY_LOST;
pub const CF_PROVIDER_STATUS_CLEAR_FLAGS = CF_SYNC_PROVIDER_STATUS.CLEAR_FLAGS;
pub const CF_PROVIDER_STATUS_TERMINATED = CF_SYNC_PROVIDER_STATUS.TERMINATED;
pub const CF_PROVIDER_STATUS_ERROR = CF_SYNC_PROVIDER_STATUS.ERROR;

pub const CF_PROCESS_INFO = extern struct {
    StructSize: u32,
    ProcessId: u32,
    ImagePath: ?[*:0]const u16,
    PackageName: ?[*:0]const u16,
    ApplicationId: ?[*:0]const u16,
    CommandLine: ?[*:0]const u16,
    SessionId: u32,
};

pub const CF_PLATFORM_INFO = extern struct {
    BuildNumber: u32,
    RevisionNumber: u32,
    IntegrationNumber: u32,
};

pub const CF_REGISTER_FLAGS = enum(u32) {
    NONE = 0,
    UPDATE = 1,
    DISABLE_ON_DEMAND_POPULATION_ON_ROOT = 2,
    MARK_IN_SYNC_ON_ROOT = 4,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        UPDATE: u1 = 0,
        DISABLE_ON_DEMAND_POPULATION_ON_ROOT: u1 = 0,
        MARK_IN_SYNC_ON_ROOT: u1 = 0,
    }) CF_REGISTER_FLAGS {
        return @as(CF_REGISTER_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_REGISTER_FLAGS.NONE) else 0) | (if (o.UPDATE == 1) @intFromEnum(CF_REGISTER_FLAGS.UPDATE) else 0) | (if (o.DISABLE_ON_DEMAND_POPULATION_ON_ROOT == 1) @intFromEnum(CF_REGISTER_FLAGS.DISABLE_ON_DEMAND_POPULATION_ON_ROOT) else 0) | (if (o.MARK_IN_SYNC_ON_ROOT == 1) @intFromEnum(CF_REGISTER_FLAGS.MARK_IN_SYNC_ON_ROOT) else 0)));
    }
};
pub const CF_REGISTER_FLAG_NONE = CF_REGISTER_FLAGS.NONE;
pub const CF_REGISTER_FLAG_UPDATE = CF_REGISTER_FLAGS.UPDATE;
pub const CF_REGISTER_FLAG_DISABLE_ON_DEMAND_POPULATION_ON_ROOT = CF_REGISTER_FLAGS.DISABLE_ON_DEMAND_POPULATION_ON_ROOT;
pub const CF_REGISTER_FLAG_MARK_IN_SYNC_ON_ROOT = CF_REGISTER_FLAGS.MARK_IN_SYNC_ON_ROOT;

pub const CF_HYDRATION_POLICY_PRIMARY = enum(u16) {
    PARTIAL = 0,
    PROGRESSIVE = 1,
    FULL = 2,
    ALWAYS_FULL = 3,
};
pub const CF_HYDRATION_POLICY_PARTIAL = CF_HYDRATION_POLICY_PRIMARY.PARTIAL;
pub const CF_HYDRATION_POLICY_PROGRESSIVE = CF_HYDRATION_POLICY_PRIMARY.PROGRESSIVE;
pub const CF_HYDRATION_POLICY_FULL = CF_HYDRATION_POLICY_PRIMARY.FULL;
pub const CF_HYDRATION_POLICY_ALWAYS_FULL = CF_HYDRATION_POLICY_PRIMARY.ALWAYS_FULL;

pub const CF_HYDRATION_POLICY_PRIMARY_USHORT = extern struct {
    us: u16,
};

pub const CF_HYDRATION_POLICY_MODIFIER = enum(u16) {
    NONE = 0,
    VALIDATION_REQUIRED = 1,
    STREAMING_ALLOWED = 2,
    AUTO_DEHYDRATION_ALLOWED = 4,
    ALLOW_FULL_RESTART_HYDRATION = 8,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        VALIDATION_REQUIRED: u1 = 0,
        STREAMING_ALLOWED: u1 = 0,
        AUTO_DEHYDRATION_ALLOWED: u1 = 0,
        ALLOW_FULL_RESTART_HYDRATION: u1 = 0,
    }) CF_HYDRATION_POLICY_MODIFIER {
        return @as(CF_HYDRATION_POLICY_MODIFIER, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_HYDRATION_POLICY_MODIFIER.NONE) else 0) | (if (o.VALIDATION_REQUIRED == 1) @intFromEnum(CF_HYDRATION_POLICY_MODIFIER.VALIDATION_REQUIRED) else 0) | (if (o.STREAMING_ALLOWED == 1) @intFromEnum(CF_HYDRATION_POLICY_MODIFIER.STREAMING_ALLOWED) else 0) | (if (o.AUTO_DEHYDRATION_ALLOWED == 1) @intFromEnum(CF_HYDRATION_POLICY_MODIFIER.AUTO_DEHYDRATION_ALLOWED) else 0) | (if (o.ALLOW_FULL_RESTART_HYDRATION == 1) @intFromEnum(CF_HYDRATION_POLICY_MODIFIER.ALLOW_FULL_RESTART_HYDRATION) else 0)));
    }
};
pub const CF_HYDRATION_POLICY_MODIFIER_NONE = CF_HYDRATION_POLICY_MODIFIER.NONE;
pub const CF_HYDRATION_POLICY_MODIFIER_VALIDATION_REQUIRED = CF_HYDRATION_POLICY_MODIFIER.VALIDATION_REQUIRED;
pub const CF_HYDRATION_POLICY_MODIFIER_STREAMING_ALLOWED = CF_HYDRATION_POLICY_MODIFIER.STREAMING_ALLOWED;
pub const CF_HYDRATION_POLICY_MODIFIER_AUTO_DEHYDRATION_ALLOWED = CF_HYDRATION_POLICY_MODIFIER.AUTO_DEHYDRATION_ALLOWED;
pub const CF_HYDRATION_POLICY_MODIFIER_ALLOW_FULL_RESTART_HYDRATION = CF_HYDRATION_POLICY_MODIFIER.ALLOW_FULL_RESTART_HYDRATION;

pub const CF_HYDRATION_POLICY_MODIFIER_USHORT = extern struct {
    us: u16,
};

pub const CF_HYDRATION_POLICY = extern struct {
    Primary: CF_HYDRATION_POLICY_PRIMARY_USHORT,
    Modifier: CF_HYDRATION_POLICY_MODIFIER_USHORT,
};

pub const CF_POPULATION_POLICY_PRIMARY = enum(u16) {
    PARTIAL = 0,
    FULL = 2,
    ALWAYS_FULL = 3,
};
pub const CF_POPULATION_POLICY_PARTIAL = CF_POPULATION_POLICY_PRIMARY.PARTIAL;
pub const CF_POPULATION_POLICY_FULL = CF_POPULATION_POLICY_PRIMARY.FULL;
pub const CF_POPULATION_POLICY_ALWAYS_FULL = CF_POPULATION_POLICY_PRIMARY.ALWAYS_FULL;

pub const CF_POPULATION_POLICY_PRIMARY_USHORT = extern struct {
    us: u16,
};

pub const CF_POPULATION_POLICY_MODIFIER = enum(u16) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_POPULATION_POLICY_MODIFIER {
        return @as(CF_POPULATION_POLICY_MODIFIER, @enumFromInt((if (o.E == 1) @intFromEnum(CF_POPULATION_POLICY_MODIFIER.E) else 0)));
    }
};
pub const CF_POPULATION_POLICY_MODIFIER_NONE = CF_POPULATION_POLICY_MODIFIER.E;

pub const CF_POPULATION_POLICY_MODIFIER_USHORT = extern struct {
    us: u16,
};

pub const CF_POPULATION_POLICY = extern struct {
    Primary: CF_POPULATION_POLICY_PRIMARY_USHORT,
    Modifier: CF_POPULATION_POLICY_MODIFIER_USHORT,
};

pub const CF_PLACEHOLDER_MANAGEMENT_POLICY = enum(i32) {
    DEFAULT = 0,
    CREATE_UNRESTRICTED = 1,
    CONVERT_TO_UNRESTRICTED = 2,
    UPDATE_UNRESTRICTED = 4,
};
pub const CF_PLACEHOLDER_MANAGEMENT_POLICY_DEFAULT = CF_PLACEHOLDER_MANAGEMENT_POLICY.DEFAULT;
pub const CF_PLACEHOLDER_MANAGEMENT_POLICY_CREATE_UNRESTRICTED = CF_PLACEHOLDER_MANAGEMENT_POLICY.CREATE_UNRESTRICTED;
pub const CF_PLACEHOLDER_MANAGEMENT_POLICY_CONVERT_TO_UNRESTRICTED = CF_PLACEHOLDER_MANAGEMENT_POLICY.CONVERT_TO_UNRESTRICTED;
pub const CF_PLACEHOLDER_MANAGEMENT_POLICY_UPDATE_UNRESTRICTED = CF_PLACEHOLDER_MANAGEMENT_POLICY.UPDATE_UNRESTRICTED;

pub const CF_INSYNC_POLICY = enum(u32) {
    NONE = 0,
    TRACK_FILE_CREATION_TIME = 1,
    TRACK_FILE_READONLY_ATTRIBUTE = 2,
    TRACK_FILE_HIDDEN_ATTRIBUTE = 4,
    TRACK_FILE_SYSTEM_ATTRIBUTE = 8,
    TRACK_DIRECTORY_CREATION_TIME = 16,
    TRACK_DIRECTORY_READONLY_ATTRIBUTE = 32,
    TRACK_DIRECTORY_HIDDEN_ATTRIBUTE = 64,
    TRACK_DIRECTORY_SYSTEM_ATTRIBUTE = 128,
    TRACK_FILE_LAST_WRITE_TIME = 256,
    TRACK_DIRECTORY_LAST_WRITE_TIME = 512,
    TRACK_FILE_ALL = 5592335,
    TRACK_DIRECTORY_ALL = 11184880,
    TRACK_ALL = 16777215,
    PRESERVE_INSYNC_FOR_SYNC_ENGINE = 2147483648,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        TRACK_FILE_CREATION_TIME: u1 = 0,
        TRACK_FILE_READONLY_ATTRIBUTE: u1 = 0,
        TRACK_FILE_HIDDEN_ATTRIBUTE: u1 = 0,
        TRACK_FILE_SYSTEM_ATTRIBUTE: u1 = 0,
        TRACK_DIRECTORY_CREATION_TIME: u1 = 0,
        TRACK_DIRECTORY_READONLY_ATTRIBUTE: u1 = 0,
        TRACK_DIRECTORY_HIDDEN_ATTRIBUTE: u1 = 0,
        TRACK_DIRECTORY_SYSTEM_ATTRIBUTE: u1 = 0,
        TRACK_FILE_LAST_WRITE_TIME: u1 = 0,
        TRACK_DIRECTORY_LAST_WRITE_TIME: u1 = 0,
        TRACK_FILE_ALL: u1 = 0,
        TRACK_DIRECTORY_ALL: u1 = 0,
        TRACK_ALL: u1 = 0,
        PRESERVE_INSYNC_FOR_SYNC_ENGINE: u1 = 0,
    }) CF_INSYNC_POLICY {
        return @as(CF_INSYNC_POLICY, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_INSYNC_POLICY.NONE) else 0) | (if (o.TRACK_FILE_CREATION_TIME == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_FILE_CREATION_TIME) else 0) | (if (o.TRACK_FILE_READONLY_ATTRIBUTE == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_FILE_READONLY_ATTRIBUTE) else 0) | (if (o.TRACK_FILE_HIDDEN_ATTRIBUTE == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_FILE_HIDDEN_ATTRIBUTE) else 0) | (if (o.TRACK_FILE_SYSTEM_ATTRIBUTE == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_FILE_SYSTEM_ATTRIBUTE) else 0) | (if (o.TRACK_DIRECTORY_CREATION_TIME == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_DIRECTORY_CREATION_TIME) else 0) | (if (o.TRACK_DIRECTORY_READONLY_ATTRIBUTE == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_DIRECTORY_READONLY_ATTRIBUTE) else 0) | (if (o.TRACK_DIRECTORY_HIDDEN_ATTRIBUTE == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_DIRECTORY_HIDDEN_ATTRIBUTE) else 0) | (if (o.TRACK_DIRECTORY_SYSTEM_ATTRIBUTE == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_DIRECTORY_SYSTEM_ATTRIBUTE) else 0) | (if (o.TRACK_FILE_LAST_WRITE_TIME == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_FILE_LAST_WRITE_TIME) else 0) | (if (o.TRACK_DIRECTORY_LAST_WRITE_TIME == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_DIRECTORY_LAST_WRITE_TIME) else 0) | (if (o.TRACK_FILE_ALL == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_FILE_ALL) else 0) | (if (o.TRACK_DIRECTORY_ALL == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_DIRECTORY_ALL) else 0) | (if (o.TRACK_ALL == 1) @intFromEnum(CF_INSYNC_POLICY.TRACK_ALL) else 0) | (if (o.PRESERVE_INSYNC_FOR_SYNC_ENGINE == 1) @intFromEnum(CF_INSYNC_POLICY.PRESERVE_INSYNC_FOR_SYNC_ENGINE) else 0)));
    }
};
pub const CF_INSYNC_POLICY_NONE = CF_INSYNC_POLICY.NONE;
pub const CF_INSYNC_POLICY_TRACK_FILE_CREATION_TIME = CF_INSYNC_POLICY.TRACK_FILE_CREATION_TIME;
pub const CF_INSYNC_POLICY_TRACK_FILE_READONLY_ATTRIBUTE = CF_INSYNC_POLICY.TRACK_FILE_READONLY_ATTRIBUTE;
pub const CF_INSYNC_POLICY_TRACK_FILE_HIDDEN_ATTRIBUTE = CF_INSYNC_POLICY.TRACK_FILE_HIDDEN_ATTRIBUTE;
pub const CF_INSYNC_POLICY_TRACK_FILE_SYSTEM_ATTRIBUTE = CF_INSYNC_POLICY.TRACK_FILE_SYSTEM_ATTRIBUTE;
pub const CF_INSYNC_POLICY_TRACK_DIRECTORY_CREATION_TIME = CF_INSYNC_POLICY.TRACK_DIRECTORY_CREATION_TIME;
pub const CF_INSYNC_POLICY_TRACK_DIRECTORY_READONLY_ATTRIBUTE = CF_INSYNC_POLICY.TRACK_DIRECTORY_READONLY_ATTRIBUTE;
pub const CF_INSYNC_POLICY_TRACK_DIRECTORY_HIDDEN_ATTRIBUTE = CF_INSYNC_POLICY.TRACK_DIRECTORY_HIDDEN_ATTRIBUTE;
pub const CF_INSYNC_POLICY_TRACK_DIRECTORY_SYSTEM_ATTRIBUTE = CF_INSYNC_POLICY.TRACK_DIRECTORY_SYSTEM_ATTRIBUTE;
pub const CF_INSYNC_POLICY_TRACK_FILE_LAST_WRITE_TIME = CF_INSYNC_POLICY.TRACK_FILE_LAST_WRITE_TIME;
pub const CF_INSYNC_POLICY_TRACK_DIRECTORY_LAST_WRITE_TIME = CF_INSYNC_POLICY.TRACK_DIRECTORY_LAST_WRITE_TIME;
pub const CF_INSYNC_POLICY_TRACK_FILE_ALL = CF_INSYNC_POLICY.TRACK_FILE_ALL;
pub const CF_INSYNC_POLICY_TRACK_DIRECTORY_ALL = CF_INSYNC_POLICY.TRACK_DIRECTORY_ALL;
pub const CF_INSYNC_POLICY_TRACK_ALL = CF_INSYNC_POLICY.TRACK_ALL;
pub const CF_INSYNC_POLICY_PRESERVE_INSYNC_FOR_SYNC_ENGINE = CF_INSYNC_POLICY.PRESERVE_INSYNC_FOR_SYNC_ENGINE;

pub const CF_HARDLINK_POLICY = enum(u32) {
    NONE = 0,
    ALLOWED = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        ALLOWED: u1 = 0,
    }) CF_HARDLINK_POLICY {
        return @as(CF_HARDLINK_POLICY, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_HARDLINK_POLICY.NONE) else 0) | (if (o.ALLOWED == 1) @intFromEnum(CF_HARDLINK_POLICY.ALLOWED) else 0)));
    }
};
pub const CF_HARDLINK_POLICY_NONE = CF_HARDLINK_POLICY.NONE;
pub const CF_HARDLINK_POLICY_ALLOWED = CF_HARDLINK_POLICY.ALLOWED;

pub const CF_SYNC_POLICIES = extern struct {
    StructSize: u32,
    Hydration: CF_HYDRATION_POLICY,
    Population: CF_POPULATION_POLICY,
    InSync: CF_INSYNC_POLICY,
    HardLink: CF_HARDLINK_POLICY,
    PlaceholderManagement: CF_PLACEHOLDER_MANAGEMENT_POLICY,
};

pub const CF_SYNC_REGISTRATION = extern struct {
    StructSize: u32,
    ProviderName: ?[*:0]const u16,
    ProviderVersion: ?[*:0]const u16,
    SyncRootIdentity: ?*const anyopaque,
    SyncRootIdentityLength: u32,
    FileIdentity: ?*const anyopaque,
    FileIdentityLength: u32,
    ProviderId: Guid,
};

pub const CF_CALLBACK_INFO = extern struct {
    StructSize: u32,
    ConnectionKey: CF_CONNECTION_KEY,
    CallbackContext: ?*anyopaque,
    VolumeGuidName: ?[*:0]const u16,
    VolumeDosName: ?[*:0]const u16,
    VolumeSerialNumber: u32,
    SyncRootFileId: LARGE_INTEGER,
    SyncRootIdentity: ?*const anyopaque,
    SyncRootIdentityLength: u32,
    FileId: LARGE_INTEGER,
    FileSize: LARGE_INTEGER,
    FileIdentity: ?*const anyopaque,
    FileIdentityLength: u32,
    NormalizedPath: ?[*:0]const u16,
    TransferKey: LARGE_INTEGER,
    PriorityHint: u8,
    CorrelationVector: ?*CORRELATION_VECTOR,
    ProcessInfo: ?*CF_PROCESS_INFO,
    RequestKey: LARGE_INTEGER,
};

pub const CF_CALLBACK_CANCEL_FLAGS = enum(u32) {
    NONE = 0,
    IO_TIMEOUT = 1,
    IO_ABORTED = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        IO_TIMEOUT: u1 = 0,
        IO_ABORTED: u1 = 0,
    }) CF_CALLBACK_CANCEL_FLAGS {
        return @as(CF_CALLBACK_CANCEL_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_CANCEL_FLAGS.NONE) else 0) | (if (o.IO_TIMEOUT == 1) @intFromEnum(CF_CALLBACK_CANCEL_FLAGS.IO_TIMEOUT) else 0) | (if (o.IO_ABORTED == 1) @intFromEnum(CF_CALLBACK_CANCEL_FLAGS.IO_ABORTED) else 0)));
    }
};
pub const CF_CALLBACK_CANCEL_FLAG_NONE = CF_CALLBACK_CANCEL_FLAGS.NONE;
pub const CF_CALLBACK_CANCEL_FLAG_IO_TIMEOUT = CF_CALLBACK_CANCEL_FLAGS.IO_TIMEOUT;
pub const CF_CALLBACK_CANCEL_FLAG_IO_ABORTED = CF_CALLBACK_CANCEL_FLAGS.IO_ABORTED;

pub const CF_CALLBACK_FETCH_DATA_FLAGS = enum(u32) {
    NONE = 0,
    RECOVERY = 1,
    EXPLICIT_HYDRATION = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        RECOVERY: u1 = 0,
        EXPLICIT_HYDRATION: u1 = 0,
    }) CF_CALLBACK_FETCH_DATA_FLAGS {
        return @as(CF_CALLBACK_FETCH_DATA_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_FETCH_DATA_FLAGS.NONE) else 0) | (if (o.RECOVERY == 1) @intFromEnum(CF_CALLBACK_FETCH_DATA_FLAGS.RECOVERY) else 0) | (if (o.EXPLICIT_HYDRATION == 1) @intFromEnum(CF_CALLBACK_FETCH_DATA_FLAGS.EXPLICIT_HYDRATION) else 0)));
    }
};
pub const CF_CALLBACK_FETCH_DATA_FLAG_NONE = CF_CALLBACK_FETCH_DATA_FLAGS.NONE;
pub const CF_CALLBACK_FETCH_DATA_FLAG_RECOVERY = CF_CALLBACK_FETCH_DATA_FLAGS.RECOVERY;
pub const CF_CALLBACK_FETCH_DATA_FLAG_EXPLICIT_HYDRATION = CF_CALLBACK_FETCH_DATA_FLAGS.EXPLICIT_HYDRATION;

pub const CF_CALLBACK_VALIDATE_DATA_FLAGS = enum(u32) {
    NONE = 0,
    EXPLICIT_HYDRATION = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        EXPLICIT_HYDRATION: u1 = 0,
    }) CF_CALLBACK_VALIDATE_DATA_FLAGS {
        return @as(CF_CALLBACK_VALIDATE_DATA_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_VALIDATE_DATA_FLAGS.NONE) else 0) | (if (o.EXPLICIT_HYDRATION == 1) @intFromEnum(CF_CALLBACK_VALIDATE_DATA_FLAGS.EXPLICIT_HYDRATION) else 0)));
    }
};
pub const CF_CALLBACK_VALIDATE_DATA_FLAG_NONE = CF_CALLBACK_VALIDATE_DATA_FLAGS.NONE;
pub const CF_CALLBACK_VALIDATE_DATA_FLAG_EXPLICIT_HYDRATION = CF_CALLBACK_VALIDATE_DATA_FLAGS.EXPLICIT_HYDRATION;

pub const CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS {
        return @as(CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS.E) else 0)));
    }
};
pub const CF_CALLBACK_FETCH_PLACEHOLDERS_FLAG_NONE = CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS.E;

pub const CF_CALLBACK_OPEN_COMPLETION_FLAGS = enum(u32) {
    NONE = 0,
    PLACEHOLDER_UNKNOWN = 1,
    PLACEHOLDER_UNSUPPORTED = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        PLACEHOLDER_UNKNOWN: u1 = 0,
        PLACEHOLDER_UNSUPPORTED: u1 = 0,
    }) CF_CALLBACK_OPEN_COMPLETION_FLAGS {
        return @as(CF_CALLBACK_OPEN_COMPLETION_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_OPEN_COMPLETION_FLAGS.NONE) else 0) | (if (o.PLACEHOLDER_UNKNOWN == 1) @intFromEnum(CF_CALLBACK_OPEN_COMPLETION_FLAGS.PLACEHOLDER_UNKNOWN) else 0) | (if (o.PLACEHOLDER_UNSUPPORTED == 1) @intFromEnum(CF_CALLBACK_OPEN_COMPLETION_FLAGS.PLACEHOLDER_UNSUPPORTED) else 0)));
    }
};
pub const CF_CALLBACK_OPEN_COMPLETION_FLAG_NONE = CF_CALLBACK_OPEN_COMPLETION_FLAGS.NONE;
pub const CF_CALLBACK_OPEN_COMPLETION_FLAG_PLACEHOLDER_UNKNOWN = CF_CALLBACK_OPEN_COMPLETION_FLAGS.PLACEHOLDER_UNKNOWN;
pub const CF_CALLBACK_OPEN_COMPLETION_FLAG_PLACEHOLDER_UNSUPPORTED = CF_CALLBACK_OPEN_COMPLETION_FLAGS.PLACEHOLDER_UNSUPPORTED;

pub const CF_CALLBACK_CLOSE_COMPLETION_FLAGS = enum(u32) {
    NONE = 0,
    DELETED = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        DELETED: u1 = 0,
    }) CF_CALLBACK_CLOSE_COMPLETION_FLAGS {
        return @as(CF_CALLBACK_CLOSE_COMPLETION_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_CLOSE_COMPLETION_FLAGS.NONE) else 0) | (if (o.DELETED == 1) @intFromEnum(CF_CALLBACK_CLOSE_COMPLETION_FLAGS.DELETED) else 0)));
    }
};
pub const CF_CALLBACK_CLOSE_COMPLETION_FLAG_NONE = CF_CALLBACK_CLOSE_COMPLETION_FLAGS.NONE;
pub const CF_CALLBACK_CLOSE_COMPLETION_FLAG_DELETED = CF_CALLBACK_CLOSE_COMPLETION_FLAGS.DELETED;

pub const CF_CALLBACK_DEHYDRATE_FLAGS = enum(u32) {
    NONE = 0,
    BACKGROUND = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        BACKGROUND: u1 = 0,
    }) CF_CALLBACK_DEHYDRATE_FLAGS {
        return @as(CF_CALLBACK_DEHYDRATE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_DEHYDRATE_FLAGS.NONE) else 0) | (if (o.BACKGROUND == 1) @intFromEnum(CF_CALLBACK_DEHYDRATE_FLAGS.BACKGROUND) else 0)));
    }
};
pub const CF_CALLBACK_DEHYDRATE_FLAG_NONE = CF_CALLBACK_DEHYDRATE_FLAGS.NONE;
pub const CF_CALLBACK_DEHYDRATE_FLAG_BACKGROUND = CF_CALLBACK_DEHYDRATE_FLAGS.BACKGROUND;

pub const CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS = enum(u32) {
    NONE = 0,
    BACKGROUND = 1,
    DEHYDRATED = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        BACKGROUND: u1 = 0,
        DEHYDRATED: u1 = 0,
    }) CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS {
        return @as(CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS.NONE) else 0) | (if (o.BACKGROUND == 1) @intFromEnum(CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS.BACKGROUND) else 0) | (if (o.DEHYDRATED == 1) @intFromEnum(CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS.DEHYDRATED) else 0)));
    }
};
pub const CF_CALLBACK_DEHYDRATE_COMPLETION_FLAG_NONE = CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS.NONE;
pub const CF_CALLBACK_DEHYDRATE_COMPLETION_FLAG_BACKGROUND = CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS.BACKGROUND;
pub const CF_CALLBACK_DEHYDRATE_COMPLETION_FLAG_DEHYDRATED = CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS.DEHYDRATED;

pub const CF_CALLBACK_DELETE_FLAGS = enum(u32) {
    NONE = 0,
    IS_DIRECTORY = 1,
    IS_UNDELETE = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        IS_DIRECTORY: u1 = 0,
        IS_UNDELETE: u1 = 0,
    }) CF_CALLBACK_DELETE_FLAGS {
        return @as(CF_CALLBACK_DELETE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_DELETE_FLAGS.NONE) else 0) | (if (o.IS_DIRECTORY == 1) @intFromEnum(CF_CALLBACK_DELETE_FLAGS.IS_DIRECTORY) else 0) | (if (o.IS_UNDELETE == 1) @intFromEnum(CF_CALLBACK_DELETE_FLAGS.IS_UNDELETE) else 0)));
    }
};
pub const CF_CALLBACK_DELETE_FLAG_NONE = CF_CALLBACK_DELETE_FLAGS.NONE;
pub const CF_CALLBACK_DELETE_FLAG_IS_DIRECTORY = CF_CALLBACK_DELETE_FLAGS.IS_DIRECTORY;
pub const CF_CALLBACK_DELETE_FLAG_IS_UNDELETE = CF_CALLBACK_DELETE_FLAGS.IS_UNDELETE;

pub const CF_CALLBACK_DELETE_COMPLETION_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_CALLBACK_DELETE_COMPLETION_FLAGS {
        return @as(CF_CALLBACK_DELETE_COMPLETION_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_CALLBACK_DELETE_COMPLETION_FLAGS.E) else 0)));
    }
};
pub const CF_CALLBACK_DELETE_COMPLETION_FLAG_NONE = CF_CALLBACK_DELETE_COMPLETION_FLAGS.E;

pub const CF_CALLBACK_RENAME_FLAGS = enum(u32) {
    NONE = 0,
    IS_DIRECTORY = 1,
    SOURCE_IN_SCOPE = 2,
    TARGET_IN_SCOPE = 4,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        IS_DIRECTORY: u1 = 0,
        SOURCE_IN_SCOPE: u1 = 0,
        TARGET_IN_SCOPE: u1 = 0,
    }) CF_CALLBACK_RENAME_FLAGS {
        return @as(CF_CALLBACK_RENAME_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CALLBACK_RENAME_FLAGS.NONE) else 0) | (if (o.IS_DIRECTORY == 1) @intFromEnum(CF_CALLBACK_RENAME_FLAGS.IS_DIRECTORY) else 0) | (if (o.SOURCE_IN_SCOPE == 1) @intFromEnum(CF_CALLBACK_RENAME_FLAGS.SOURCE_IN_SCOPE) else 0) | (if (o.TARGET_IN_SCOPE == 1) @intFromEnum(CF_CALLBACK_RENAME_FLAGS.TARGET_IN_SCOPE) else 0)));
    }
};
pub const CF_CALLBACK_RENAME_FLAG_NONE = CF_CALLBACK_RENAME_FLAGS.NONE;
pub const CF_CALLBACK_RENAME_FLAG_IS_DIRECTORY = CF_CALLBACK_RENAME_FLAGS.IS_DIRECTORY;
pub const CF_CALLBACK_RENAME_FLAG_SOURCE_IN_SCOPE = CF_CALLBACK_RENAME_FLAGS.SOURCE_IN_SCOPE;
pub const CF_CALLBACK_RENAME_FLAG_TARGET_IN_SCOPE = CF_CALLBACK_RENAME_FLAGS.TARGET_IN_SCOPE;

pub const CF_CALLBACK_RENAME_COMPLETION_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_CALLBACK_RENAME_COMPLETION_FLAGS {
        return @as(CF_CALLBACK_RENAME_COMPLETION_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_CALLBACK_RENAME_COMPLETION_FLAGS.E) else 0)));
    }
};
pub const CF_CALLBACK_RENAME_COMPLETION_FLAG_NONE = CF_CALLBACK_RENAME_COMPLETION_FLAGS.E;

pub const CF_CALLBACK_DEHYDRATION_REASON = enum(i32) {
    NONE = 0,
    USER_MANUAL = 1,
    SYSTEM_LOW_SPACE = 2,
    SYSTEM_INACTIVITY = 3,
    SYSTEM_OS_UPGRADE = 4,
};
pub const CF_CALLBACK_DEHYDRATION_REASON_NONE = CF_CALLBACK_DEHYDRATION_REASON.NONE;
pub const CF_CALLBACK_DEHYDRATION_REASON_USER_MANUAL = CF_CALLBACK_DEHYDRATION_REASON.USER_MANUAL;
pub const CF_CALLBACK_DEHYDRATION_REASON_SYSTEM_LOW_SPACE = CF_CALLBACK_DEHYDRATION_REASON.SYSTEM_LOW_SPACE;
pub const CF_CALLBACK_DEHYDRATION_REASON_SYSTEM_INACTIVITY = CF_CALLBACK_DEHYDRATION_REASON.SYSTEM_INACTIVITY;
pub const CF_CALLBACK_DEHYDRATION_REASON_SYSTEM_OS_UPGRADE = CF_CALLBACK_DEHYDRATION_REASON.SYSTEM_OS_UPGRADE;

pub const CF_CALLBACK_PARAMETERS = extern struct {
    ParamSize: u32,
    Anonymous: extern union {
        Cancel: extern struct {
            Flags: CF_CALLBACK_CANCEL_FLAGS,
            Anonymous: extern union {
                FetchData: extern struct {
                    FileOffset: LARGE_INTEGER,
                    Length: LARGE_INTEGER,
                },
            },
        },
        FetchData: extern struct {
            Flags: CF_CALLBACK_FETCH_DATA_FLAGS,
            RequiredFileOffset: LARGE_INTEGER,
            RequiredLength: LARGE_INTEGER,
            OptionalFileOffset: LARGE_INTEGER,
            OptionalLength: LARGE_INTEGER,
            LastDehydrationTime: LARGE_INTEGER,
            LastDehydrationReason: CF_CALLBACK_DEHYDRATION_REASON,
        },
        ValidateData: extern struct {
            Flags: CF_CALLBACK_VALIDATE_DATA_FLAGS,
            RequiredFileOffset: LARGE_INTEGER,
            RequiredLength: LARGE_INTEGER,
        },
        FetchPlaceholders: extern struct {
            Flags: CF_CALLBACK_FETCH_PLACEHOLDERS_FLAGS,
            Pattern: ?[*:0]const u16,
        },
        OpenCompletion: extern struct {
            Flags: CF_CALLBACK_OPEN_COMPLETION_FLAGS,
        },
        CloseCompletion: extern struct {
            Flags: CF_CALLBACK_CLOSE_COMPLETION_FLAGS,
        },
        Dehydrate: extern struct {
            Flags: CF_CALLBACK_DEHYDRATE_FLAGS,
            Reason: CF_CALLBACK_DEHYDRATION_REASON,
        },
        DehydrateCompletion: extern struct {
            Flags: CF_CALLBACK_DEHYDRATE_COMPLETION_FLAGS,
            Reason: CF_CALLBACK_DEHYDRATION_REASON,
        },
        Delete: extern struct {
            Flags: CF_CALLBACK_DELETE_FLAGS,
        },
        DeleteCompletion: extern struct {
            Flags: CF_CALLBACK_DELETE_COMPLETION_FLAGS,
        },
        Rename: extern struct {
            Flags: CF_CALLBACK_RENAME_FLAGS,
            TargetPath: ?[*:0]const u16,
        },
        RenameCompletion: extern struct {
            Flags: CF_CALLBACK_RENAME_COMPLETION_FLAGS,
            SourcePath: ?[*:0]const u16,
        },
    },
};

pub const CF_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        CallbackInfo: ?*const CF_CALLBACK_INFO,
        CallbackParameters: ?*const CF_CALLBACK_PARAMETERS,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        CallbackInfo: ?*const CF_CALLBACK_INFO,
        CallbackParameters: ?*const CF_CALLBACK_PARAMETERS,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const CF_CALLBACK_TYPE = enum(i32) {
    FETCH_DATA = 0,
    VALIDATE_DATA = 1,
    CANCEL_FETCH_DATA = 2,
    FETCH_PLACEHOLDERS = 3,
    CANCEL_FETCH_PLACEHOLDERS = 4,
    NOTIFY_FILE_OPEN_COMPLETION = 5,
    NOTIFY_FILE_CLOSE_COMPLETION = 6,
    NOTIFY_DEHYDRATE = 7,
    NOTIFY_DEHYDRATE_COMPLETION = 8,
    NOTIFY_DELETE = 9,
    NOTIFY_DELETE_COMPLETION = 10,
    NOTIFY_RENAME = 11,
    NOTIFY_RENAME_COMPLETION = 12,
    NONE = -1,
};
pub const CF_CALLBACK_TYPE_FETCH_DATA = CF_CALLBACK_TYPE.FETCH_DATA;
pub const CF_CALLBACK_TYPE_VALIDATE_DATA = CF_CALLBACK_TYPE.VALIDATE_DATA;
pub const CF_CALLBACK_TYPE_CANCEL_FETCH_DATA = CF_CALLBACK_TYPE.CANCEL_FETCH_DATA;
pub const CF_CALLBACK_TYPE_FETCH_PLACEHOLDERS = CF_CALLBACK_TYPE.FETCH_PLACEHOLDERS;
pub const CF_CALLBACK_TYPE_CANCEL_FETCH_PLACEHOLDERS = CF_CALLBACK_TYPE.CANCEL_FETCH_PLACEHOLDERS;
pub const CF_CALLBACK_TYPE_NOTIFY_FILE_OPEN_COMPLETION = CF_CALLBACK_TYPE.NOTIFY_FILE_OPEN_COMPLETION;
pub const CF_CALLBACK_TYPE_NOTIFY_FILE_CLOSE_COMPLETION = CF_CALLBACK_TYPE.NOTIFY_FILE_CLOSE_COMPLETION;
pub const CF_CALLBACK_TYPE_NOTIFY_DEHYDRATE = CF_CALLBACK_TYPE.NOTIFY_DEHYDRATE;
pub const CF_CALLBACK_TYPE_NOTIFY_DEHYDRATE_COMPLETION = CF_CALLBACK_TYPE.NOTIFY_DEHYDRATE_COMPLETION;
pub const CF_CALLBACK_TYPE_NOTIFY_DELETE = CF_CALLBACK_TYPE.NOTIFY_DELETE;
pub const CF_CALLBACK_TYPE_NOTIFY_DELETE_COMPLETION = CF_CALLBACK_TYPE.NOTIFY_DELETE_COMPLETION;
pub const CF_CALLBACK_TYPE_NOTIFY_RENAME = CF_CALLBACK_TYPE.NOTIFY_RENAME;
pub const CF_CALLBACK_TYPE_NOTIFY_RENAME_COMPLETION = CF_CALLBACK_TYPE.NOTIFY_RENAME_COMPLETION;
pub const CF_CALLBACK_TYPE_NONE = CF_CALLBACK_TYPE.NONE;

pub const CF_CALLBACK_REGISTRATION = extern struct {
    Type: CF_CALLBACK_TYPE,
    Callback: ?CF_CALLBACK,
};

pub const CF_CONNECT_FLAGS = enum(u32) {
    NONE = 0,
    REQUIRE_PROCESS_INFO = 2,
    REQUIRE_FULL_FILE_PATH = 4,
    BLOCK_SELF_IMPLICIT_HYDRATION = 8,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        REQUIRE_PROCESS_INFO: u1 = 0,
        REQUIRE_FULL_FILE_PATH: u1 = 0,
        BLOCK_SELF_IMPLICIT_HYDRATION: u1 = 0,
    }) CF_CONNECT_FLAGS {
        return @as(CF_CONNECT_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CONNECT_FLAGS.NONE) else 0) | (if (o.REQUIRE_PROCESS_INFO == 1) @intFromEnum(CF_CONNECT_FLAGS.REQUIRE_PROCESS_INFO) else 0) | (if (o.REQUIRE_FULL_FILE_PATH == 1) @intFromEnum(CF_CONNECT_FLAGS.REQUIRE_FULL_FILE_PATH) else 0) | (if (o.BLOCK_SELF_IMPLICIT_HYDRATION == 1) @intFromEnum(CF_CONNECT_FLAGS.BLOCK_SELF_IMPLICIT_HYDRATION) else 0)));
    }
};
pub const CF_CONNECT_FLAG_NONE = CF_CONNECT_FLAGS.NONE;
pub const CF_CONNECT_FLAG_REQUIRE_PROCESS_INFO = CF_CONNECT_FLAGS.REQUIRE_PROCESS_INFO;
pub const CF_CONNECT_FLAG_REQUIRE_FULL_FILE_PATH = CF_CONNECT_FLAGS.REQUIRE_FULL_FILE_PATH;
pub const CF_CONNECT_FLAG_BLOCK_SELF_IMPLICIT_HYDRATION = CF_CONNECT_FLAGS.BLOCK_SELF_IMPLICIT_HYDRATION;

pub const CF_OPERATION_TYPE = enum(i32) {
    TRANSFER_DATA = 0,
    RETRIEVE_DATA = 1,
    ACK_DATA = 2,
    RESTART_HYDRATION = 3,
    TRANSFER_PLACEHOLDERS = 4,
    ACK_DEHYDRATE = 5,
    ACK_DELETE = 6,
    ACK_RENAME = 7,
};
pub const CF_OPERATION_TYPE_TRANSFER_DATA = CF_OPERATION_TYPE.TRANSFER_DATA;
pub const CF_OPERATION_TYPE_RETRIEVE_DATA = CF_OPERATION_TYPE.RETRIEVE_DATA;
pub const CF_OPERATION_TYPE_ACK_DATA = CF_OPERATION_TYPE.ACK_DATA;
pub const CF_OPERATION_TYPE_RESTART_HYDRATION = CF_OPERATION_TYPE.RESTART_HYDRATION;
pub const CF_OPERATION_TYPE_TRANSFER_PLACEHOLDERS = CF_OPERATION_TYPE.TRANSFER_PLACEHOLDERS;
pub const CF_OPERATION_TYPE_ACK_DEHYDRATE = CF_OPERATION_TYPE.ACK_DEHYDRATE;
pub const CF_OPERATION_TYPE_ACK_DELETE = CF_OPERATION_TYPE.ACK_DELETE;
pub const CF_OPERATION_TYPE_ACK_RENAME = CF_OPERATION_TYPE.ACK_RENAME;

pub const CF_SYNC_STATUS = extern struct {
    StructSize: u32,
    Code: u32,
    DescriptionOffset: u32,
    DescriptionLength: u32,
    DeviceIdOffset: u32,
    DeviceIdLength: u32,
};

pub const CF_OPERATION_INFO = extern struct {
    StructSize: u32,
    Type: CF_OPERATION_TYPE,
    ConnectionKey: CF_CONNECTION_KEY,
    TransferKey: LARGE_INTEGER,
    CorrelationVector: ?*const CORRELATION_VECTOR,
    SyncStatus: ?*const CF_SYNC_STATUS,
    RequestKey: LARGE_INTEGER,
};

pub const CF_OPERATION_TRANSFER_DATA_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_OPERATION_TRANSFER_DATA_FLAGS {
        return @as(CF_OPERATION_TRANSFER_DATA_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_OPERATION_TRANSFER_DATA_FLAGS.E) else 0)));
    }
};
pub const CF_OPERATION_TRANSFER_DATA_FLAG_NONE = CF_OPERATION_TRANSFER_DATA_FLAGS.E;

pub const CF_OPERATION_RETRIEVE_DATA_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_OPERATION_RETRIEVE_DATA_FLAGS {
        return @as(CF_OPERATION_RETRIEVE_DATA_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_OPERATION_RETRIEVE_DATA_FLAGS.E) else 0)));
    }
};
pub const CF_OPERATION_RETRIEVE_DATA_FLAG_NONE = CF_OPERATION_RETRIEVE_DATA_FLAGS.E;

pub const CF_OPERATION_ACK_DATA_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_OPERATION_ACK_DATA_FLAGS {
        return @as(CF_OPERATION_ACK_DATA_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_OPERATION_ACK_DATA_FLAGS.E) else 0)));
    }
};
pub const CF_OPERATION_ACK_DATA_FLAG_NONE = CF_OPERATION_ACK_DATA_FLAGS.E;

pub const CF_OPERATION_RESTART_HYDRATION_FLAGS = enum(u32) {
    NONE = 0,
    MARK_IN_SYNC = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        MARK_IN_SYNC: u1 = 0,
    }) CF_OPERATION_RESTART_HYDRATION_FLAGS {
        return @as(CF_OPERATION_RESTART_HYDRATION_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_OPERATION_RESTART_HYDRATION_FLAGS.NONE) else 0) | (if (o.MARK_IN_SYNC == 1) @intFromEnum(CF_OPERATION_RESTART_HYDRATION_FLAGS.MARK_IN_SYNC) else 0)));
    }
};
pub const CF_OPERATION_RESTART_HYDRATION_FLAG_NONE = CF_OPERATION_RESTART_HYDRATION_FLAGS.NONE;
pub const CF_OPERATION_RESTART_HYDRATION_FLAG_MARK_IN_SYNC = CF_OPERATION_RESTART_HYDRATION_FLAGS.MARK_IN_SYNC;

pub const CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS = enum(u32) {
    NONE = 0,
    STOP_ON_ERROR = 1,
    DISABLE_ON_DEMAND_POPULATION = 2,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        STOP_ON_ERROR: u1 = 0,
        DISABLE_ON_DEMAND_POPULATION: u1 = 0,
    }) CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS {
        return @as(CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS.NONE) else 0) | (if (o.STOP_ON_ERROR == 1) @intFromEnum(CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS.STOP_ON_ERROR) else 0) | (if (o.DISABLE_ON_DEMAND_POPULATION == 1) @intFromEnum(CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS.DISABLE_ON_DEMAND_POPULATION) else 0)));
    }
};
pub const CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAG_NONE = CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS.NONE;
pub const CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAG_STOP_ON_ERROR = CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS.STOP_ON_ERROR;
pub const CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAG_DISABLE_ON_DEMAND_POPULATION = CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS.DISABLE_ON_DEMAND_POPULATION;

pub const CF_OPERATION_ACK_DEHYDRATE_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_OPERATION_ACK_DEHYDRATE_FLAGS {
        return @as(CF_OPERATION_ACK_DEHYDRATE_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_OPERATION_ACK_DEHYDRATE_FLAGS.E) else 0)));
    }
};
pub const CF_OPERATION_ACK_DEHYDRATE_FLAG_NONE = CF_OPERATION_ACK_DEHYDRATE_FLAGS.E;

pub const CF_OPERATION_ACK_RENAME_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_OPERATION_ACK_RENAME_FLAGS {
        return @as(CF_OPERATION_ACK_RENAME_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_OPERATION_ACK_RENAME_FLAGS.E) else 0)));
    }
};
pub const CF_OPERATION_ACK_RENAME_FLAG_NONE = CF_OPERATION_ACK_RENAME_FLAGS.E;

pub const CF_OPERATION_ACK_DELETE_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_OPERATION_ACK_DELETE_FLAGS {
        return @as(CF_OPERATION_ACK_DELETE_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_OPERATION_ACK_DELETE_FLAGS.E) else 0)));
    }
};
pub const CF_OPERATION_ACK_DELETE_FLAG_NONE = CF_OPERATION_ACK_DELETE_FLAGS.E;

pub const CF_OPERATION_PARAMETERS = extern struct {
    ParamSize: u32,
    Anonymous: extern union {
        TransferData: extern struct {
            Flags: CF_OPERATION_TRANSFER_DATA_FLAGS,
            CompletionStatus: NTSTATUS,
            Buffer: ?*const anyopaque,
            Offset: LARGE_INTEGER,
            Length: LARGE_INTEGER,
        },
        RetrieveData: extern struct {
            Flags: CF_OPERATION_RETRIEVE_DATA_FLAGS,
            Buffer: ?*anyopaque,
            Offset: LARGE_INTEGER,
            Length: LARGE_INTEGER,
            ReturnedLength: LARGE_INTEGER,
        },
        AckData: extern struct {
            Flags: CF_OPERATION_ACK_DATA_FLAGS,
            CompletionStatus: NTSTATUS,
            Offset: LARGE_INTEGER,
            Length: LARGE_INTEGER,
        },
        RestartHydration: extern struct {
            Flags: CF_OPERATION_RESTART_HYDRATION_FLAGS,
            FsMetadata: ?*const CF_FS_METADATA,
            FileIdentity: ?*const anyopaque,
            FileIdentityLength: u32,
        },
        TransferPlaceholders: extern struct {
            Flags: CF_OPERATION_TRANSFER_PLACEHOLDERS_FLAGS,
            CompletionStatus: NTSTATUS,
            PlaceholderTotalCount: LARGE_INTEGER,
            PlaceholderArray: ?*CF_PLACEHOLDER_CREATE_INFO,
            PlaceholderCount: u32,
            EntriesProcessed: u32,
        },
        AckDehydrate: extern struct {
            Flags: CF_OPERATION_ACK_DEHYDRATE_FLAGS,
            CompletionStatus: NTSTATUS,
            FileIdentity: ?*const anyopaque,
            FileIdentityLength: u32,
        },
        AckRename: extern struct {
            Flags: CF_OPERATION_ACK_RENAME_FLAGS,
            CompletionStatus: NTSTATUS,
        },
        AckDelete: extern struct {
            Flags: CF_OPERATION_ACK_DELETE_FLAGS,
            CompletionStatus: NTSTATUS,
        },
    },
};

pub const CF_CREATE_FLAGS = enum(u32) {
    NONE = 0,
    STOP_ON_ERROR = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        STOP_ON_ERROR: u1 = 0,
    }) CF_CREATE_FLAGS {
        return @as(CF_CREATE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CREATE_FLAGS.NONE) else 0) | (if (o.STOP_ON_ERROR == 1) @intFromEnum(CF_CREATE_FLAGS.STOP_ON_ERROR) else 0)));
    }
};
pub const CF_CREATE_FLAG_NONE = CF_CREATE_FLAGS.NONE;
pub const CF_CREATE_FLAG_STOP_ON_ERROR = CF_CREATE_FLAGS.STOP_ON_ERROR;

pub const CF_OPEN_FILE_FLAGS = enum(u32) {
    NONE = 0,
    EXCLUSIVE = 1,
    WRITE_ACCESS = 2,
    DELETE_ACCESS = 4,
    FOREGROUND = 8,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        EXCLUSIVE: u1 = 0,
        WRITE_ACCESS: u1 = 0,
        DELETE_ACCESS: u1 = 0,
        FOREGROUND: u1 = 0,
    }) CF_OPEN_FILE_FLAGS {
        return @as(CF_OPEN_FILE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_OPEN_FILE_FLAGS.NONE) else 0) | (if (o.EXCLUSIVE == 1) @intFromEnum(CF_OPEN_FILE_FLAGS.EXCLUSIVE) else 0) | (if (o.WRITE_ACCESS == 1) @intFromEnum(CF_OPEN_FILE_FLAGS.WRITE_ACCESS) else 0) | (if (o.DELETE_ACCESS == 1) @intFromEnum(CF_OPEN_FILE_FLAGS.DELETE_ACCESS) else 0) | (if (o.FOREGROUND == 1) @intFromEnum(CF_OPEN_FILE_FLAGS.FOREGROUND) else 0)));
    }
};
pub const CF_OPEN_FILE_FLAG_NONE = CF_OPEN_FILE_FLAGS.NONE;
pub const CF_OPEN_FILE_FLAG_EXCLUSIVE = CF_OPEN_FILE_FLAGS.EXCLUSIVE;
pub const CF_OPEN_FILE_FLAG_WRITE_ACCESS = CF_OPEN_FILE_FLAGS.WRITE_ACCESS;
pub const CF_OPEN_FILE_FLAG_DELETE_ACCESS = CF_OPEN_FILE_FLAGS.DELETE_ACCESS;
pub const CF_OPEN_FILE_FLAG_FOREGROUND = CF_OPEN_FILE_FLAGS.FOREGROUND;

pub const CF_FILE_RANGE = extern struct {
    StartingOffset: LARGE_INTEGER,
    Length: LARGE_INTEGER,
};

pub const CF_CONVERT_FLAGS = enum(u32) {
    NONE = 0,
    MARK_IN_SYNC = 1,
    DEHYDRATE = 2,
    ENABLE_ON_DEMAND_POPULATION = 4,
    ALWAYS_FULL = 8,
    FORCE_CONVERT_TO_CLOUD_FILE = 16,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        MARK_IN_SYNC: u1 = 0,
        DEHYDRATE: u1 = 0,
        ENABLE_ON_DEMAND_POPULATION: u1 = 0,
        ALWAYS_FULL: u1 = 0,
        FORCE_CONVERT_TO_CLOUD_FILE: u1 = 0,
    }) CF_CONVERT_FLAGS {
        return @as(CF_CONVERT_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_CONVERT_FLAGS.NONE) else 0) | (if (o.MARK_IN_SYNC == 1) @intFromEnum(CF_CONVERT_FLAGS.MARK_IN_SYNC) else 0) | (if (o.DEHYDRATE == 1) @intFromEnum(CF_CONVERT_FLAGS.DEHYDRATE) else 0) | (if (o.ENABLE_ON_DEMAND_POPULATION == 1) @intFromEnum(CF_CONVERT_FLAGS.ENABLE_ON_DEMAND_POPULATION) else 0) | (if (o.ALWAYS_FULL == 1) @intFromEnum(CF_CONVERT_FLAGS.ALWAYS_FULL) else 0) | (if (o.FORCE_CONVERT_TO_CLOUD_FILE == 1) @intFromEnum(CF_CONVERT_FLAGS.FORCE_CONVERT_TO_CLOUD_FILE) else 0)));
    }
};
pub const CF_CONVERT_FLAG_NONE = CF_CONVERT_FLAGS.NONE;
pub const CF_CONVERT_FLAG_MARK_IN_SYNC = CF_CONVERT_FLAGS.MARK_IN_SYNC;
pub const CF_CONVERT_FLAG_DEHYDRATE = CF_CONVERT_FLAGS.DEHYDRATE;
pub const CF_CONVERT_FLAG_ENABLE_ON_DEMAND_POPULATION = CF_CONVERT_FLAGS.ENABLE_ON_DEMAND_POPULATION;
pub const CF_CONVERT_FLAG_ALWAYS_FULL = CF_CONVERT_FLAGS.ALWAYS_FULL;
pub const CF_CONVERT_FLAG_FORCE_CONVERT_TO_CLOUD_FILE = CF_CONVERT_FLAGS.FORCE_CONVERT_TO_CLOUD_FILE;

pub const CF_UPDATE_FLAGS = enum(u32) {
    NONE = 0,
    VERIFY_IN_SYNC = 1,
    MARK_IN_SYNC = 2,
    DEHYDRATE = 4,
    ENABLE_ON_DEMAND_POPULATION = 8,
    DISABLE_ON_DEMAND_POPULATION = 16,
    REMOVE_FILE_IDENTITY = 32,
    CLEAR_IN_SYNC = 64,
    REMOVE_PROPERTY = 128,
    PASSTHROUGH_FS_METADATA = 256,
    ALWAYS_FULL = 512,
    ALLOW_PARTIAL = 1024,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        VERIFY_IN_SYNC: u1 = 0,
        MARK_IN_SYNC: u1 = 0,
        DEHYDRATE: u1 = 0,
        ENABLE_ON_DEMAND_POPULATION: u1 = 0,
        DISABLE_ON_DEMAND_POPULATION: u1 = 0,
        REMOVE_FILE_IDENTITY: u1 = 0,
        CLEAR_IN_SYNC: u1 = 0,
        REMOVE_PROPERTY: u1 = 0,
        PASSTHROUGH_FS_METADATA: u1 = 0,
        ALWAYS_FULL: u1 = 0,
        ALLOW_PARTIAL: u1 = 0,
    }) CF_UPDATE_FLAGS {
        return @as(CF_UPDATE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_UPDATE_FLAGS.NONE) else 0) | (if (o.VERIFY_IN_SYNC == 1) @intFromEnum(CF_UPDATE_FLAGS.VERIFY_IN_SYNC) else 0) | (if (o.MARK_IN_SYNC == 1) @intFromEnum(CF_UPDATE_FLAGS.MARK_IN_SYNC) else 0) | (if (o.DEHYDRATE == 1) @intFromEnum(CF_UPDATE_FLAGS.DEHYDRATE) else 0) | (if (o.ENABLE_ON_DEMAND_POPULATION == 1) @intFromEnum(CF_UPDATE_FLAGS.ENABLE_ON_DEMAND_POPULATION) else 0) | (if (o.DISABLE_ON_DEMAND_POPULATION == 1) @intFromEnum(CF_UPDATE_FLAGS.DISABLE_ON_DEMAND_POPULATION) else 0) | (if (o.REMOVE_FILE_IDENTITY == 1) @intFromEnum(CF_UPDATE_FLAGS.REMOVE_FILE_IDENTITY) else 0) | (if (o.CLEAR_IN_SYNC == 1) @intFromEnum(CF_UPDATE_FLAGS.CLEAR_IN_SYNC) else 0) | (if (o.REMOVE_PROPERTY == 1) @intFromEnum(CF_UPDATE_FLAGS.REMOVE_PROPERTY) else 0) | (if (o.PASSTHROUGH_FS_METADATA == 1) @intFromEnum(CF_UPDATE_FLAGS.PASSTHROUGH_FS_METADATA) else 0) | (if (o.ALWAYS_FULL == 1) @intFromEnum(CF_UPDATE_FLAGS.ALWAYS_FULL) else 0) | (if (o.ALLOW_PARTIAL == 1) @intFromEnum(CF_UPDATE_FLAGS.ALLOW_PARTIAL) else 0)));
    }
};
pub const CF_UPDATE_FLAG_NONE = CF_UPDATE_FLAGS.NONE;
pub const CF_UPDATE_FLAG_VERIFY_IN_SYNC = CF_UPDATE_FLAGS.VERIFY_IN_SYNC;
pub const CF_UPDATE_FLAG_MARK_IN_SYNC = CF_UPDATE_FLAGS.MARK_IN_SYNC;
pub const CF_UPDATE_FLAG_DEHYDRATE = CF_UPDATE_FLAGS.DEHYDRATE;
pub const CF_UPDATE_FLAG_ENABLE_ON_DEMAND_POPULATION = CF_UPDATE_FLAGS.ENABLE_ON_DEMAND_POPULATION;
pub const CF_UPDATE_FLAG_DISABLE_ON_DEMAND_POPULATION = CF_UPDATE_FLAGS.DISABLE_ON_DEMAND_POPULATION;
pub const CF_UPDATE_FLAG_REMOVE_FILE_IDENTITY = CF_UPDATE_FLAGS.REMOVE_FILE_IDENTITY;
pub const CF_UPDATE_FLAG_CLEAR_IN_SYNC = CF_UPDATE_FLAGS.CLEAR_IN_SYNC;
pub const CF_UPDATE_FLAG_REMOVE_PROPERTY = CF_UPDATE_FLAGS.REMOVE_PROPERTY;
pub const CF_UPDATE_FLAG_PASSTHROUGH_FS_METADATA = CF_UPDATE_FLAGS.PASSTHROUGH_FS_METADATA;
pub const CF_UPDATE_FLAG_ALWAYS_FULL = CF_UPDATE_FLAGS.ALWAYS_FULL;
pub const CF_UPDATE_FLAG_ALLOW_PARTIAL = CF_UPDATE_FLAGS.ALLOW_PARTIAL;

pub const CF_REVERT_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_REVERT_FLAGS {
        return @as(CF_REVERT_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_REVERT_FLAGS.E) else 0)));
    }
};
pub const CF_REVERT_FLAG_NONE = CF_REVERT_FLAGS.E;

pub const CF_HYDRATE_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_HYDRATE_FLAGS {
        return @as(CF_HYDRATE_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_HYDRATE_FLAGS.E) else 0)));
    }
};
pub const CF_HYDRATE_FLAG_NONE = CF_HYDRATE_FLAGS.E;

pub const CF_DEHYDRATE_FLAGS = enum(u32) {
    NONE = 0,
    BACKGROUND = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        BACKGROUND: u1 = 0,
    }) CF_DEHYDRATE_FLAGS {
        return @as(CF_DEHYDRATE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_DEHYDRATE_FLAGS.NONE) else 0) | (if (o.BACKGROUND == 1) @intFromEnum(CF_DEHYDRATE_FLAGS.BACKGROUND) else 0)));
    }
};
pub const CF_DEHYDRATE_FLAG_NONE = CF_DEHYDRATE_FLAGS.NONE;
pub const CF_DEHYDRATE_FLAG_BACKGROUND = CF_DEHYDRATE_FLAGS.BACKGROUND;

pub const CF_PIN_STATE = enum(i32) {
    UNSPECIFIED = 0,
    PINNED = 1,
    UNPINNED = 2,
    EXCLUDED = 3,
    INHERIT = 4,
};
pub const CF_PIN_STATE_UNSPECIFIED = CF_PIN_STATE.UNSPECIFIED;
pub const CF_PIN_STATE_PINNED = CF_PIN_STATE.PINNED;
pub const CF_PIN_STATE_UNPINNED = CF_PIN_STATE.UNPINNED;
pub const CF_PIN_STATE_EXCLUDED = CF_PIN_STATE.EXCLUDED;
pub const CF_PIN_STATE_INHERIT = CF_PIN_STATE.INHERIT;

pub const CF_SET_PIN_FLAGS = enum(u32) {
    NONE = 0,
    RECURSE = 1,
    RECURSE_ONLY = 2,
    RECURSE_STOP_ON_ERROR = 4,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        RECURSE: u1 = 0,
        RECURSE_ONLY: u1 = 0,
        RECURSE_STOP_ON_ERROR: u1 = 0,
    }) CF_SET_PIN_FLAGS {
        return @as(CF_SET_PIN_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(CF_SET_PIN_FLAGS.NONE) else 0) | (if (o.RECURSE == 1) @intFromEnum(CF_SET_PIN_FLAGS.RECURSE) else 0) | (if (o.RECURSE_ONLY == 1) @intFromEnum(CF_SET_PIN_FLAGS.RECURSE_ONLY) else 0) | (if (o.RECURSE_STOP_ON_ERROR == 1) @intFromEnum(CF_SET_PIN_FLAGS.RECURSE_STOP_ON_ERROR) else 0)));
    }
};
pub const CF_SET_PIN_FLAG_NONE = CF_SET_PIN_FLAGS.NONE;
pub const CF_SET_PIN_FLAG_RECURSE = CF_SET_PIN_FLAGS.RECURSE;
pub const CF_SET_PIN_FLAG_RECURSE_ONLY = CF_SET_PIN_FLAGS.RECURSE_ONLY;
pub const CF_SET_PIN_FLAG_RECURSE_STOP_ON_ERROR = CF_SET_PIN_FLAGS.RECURSE_STOP_ON_ERROR;

pub const CF_IN_SYNC_STATE = enum(i32) {
    NOT_IN_SYNC = 0,
    IN_SYNC = 1,
};
pub const CF_IN_SYNC_STATE_NOT_IN_SYNC = CF_IN_SYNC_STATE.NOT_IN_SYNC;
pub const CF_IN_SYNC_STATE_IN_SYNC = CF_IN_SYNC_STATE.IN_SYNC;

pub const CF_SET_IN_SYNC_FLAGS = enum(u32) {
    E = 0,
    _,
    pub fn initFlags(o: struct {
        E: u1 = 0,
    }) CF_SET_IN_SYNC_FLAGS {
        return @as(CF_SET_IN_SYNC_FLAGS, @enumFromInt((if (o.E == 1) @intFromEnum(CF_SET_IN_SYNC_FLAGS.E) else 0)));
    }
};
pub const CF_SET_IN_SYNC_FLAG_NONE = CF_SET_IN_SYNC_FLAGS.E;

pub const CF_PLACEHOLDER_STATE = enum(u32) {
    NO_STATES = 0,
    PLACEHOLDER = 1,
    SYNC_ROOT = 2,
    ESSENTIAL_PROP_PRESENT = 4,
    IN_SYNC = 8,
    PARTIAL = 16,
    PARTIALLY_ON_DISK = 32,
    INVALID = 4294967295,
    _,
    pub fn initFlags(o: struct {
        NO_STATES: u1 = 0,
        PLACEHOLDER: u1 = 0,
        SYNC_ROOT: u1 = 0,
        ESSENTIAL_PROP_PRESENT: u1 = 0,
        IN_SYNC: u1 = 0,
        PARTIAL: u1 = 0,
        PARTIALLY_ON_DISK: u1 = 0,
        INVALID: u1 = 0,
    }) CF_PLACEHOLDER_STATE {
        return @as(CF_PLACEHOLDER_STATE, @enumFromInt((if (o.NO_STATES == 1) @intFromEnum(CF_PLACEHOLDER_STATE.NO_STATES) else 0) | (if (o.PLACEHOLDER == 1) @intFromEnum(CF_PLACEHOLDER_STATE.PLACEHOLDER) else 0) | (if (o.SYNC_ROOT == 1) @intFromEnum(CF_PLACEHOLDER_STATE.SYNC_ROOT) else 0) | (if (o.ESSENTIAL_PROP_PRESENT == 1) @intFromEnum(CF_PLACEHOLDER_STATE.ESSENTIAL_PROP_PRESENT) else 0) | (if (o.IN_SYNC == 1) @intFromEnum(CF_PLACEHOLDER_STATE.IN_SYNC) else 0) | (if (o.PARTIAL == 1) @intFromEnum(CF_PLACEHOLDER_STATE.PARTIAL) else 0) | (if (o.PARTIALLY_ON_DISK == 1) @intFromEnum(CF_PLACEHOLDER_STATE.PARTIALLY_ON_DISK) else 0) | (if (o.INVALID == 1) @intFromEnum(CF_PLACEHOLDER_STATE.INVALID) else 0)));
    }
};
pub const CF_PLACEHOLDER_STATE_NO_STATES = CF_PLACEHOLDER_STATE.NO_STATES;
pub const CF_PLACEHOLDER_STATE_PLACEHOLDER = CF_PLACEHOLDER_STATE.PLACEHOLDER;
pub const CF_PLACEHOLDER_STATE_SYNC_ROOT = CF_PLACEHOLDER_STATE.SYNC_ROOT;
pub const CF_PLACEHOLDER_STATE_ESSENTIAL_PROP_PRESENT = CF_PLACEHOLDER_STATE.ESSENTIAL_PROP_PRESENT;
pub const CF_PLACEHOLDER_STATE_IN_SYNC = CF_PLACEHOLDER_STATE.IN_SYNC;
pub const CF_PLACEHOLDER_STATE_PARTIAL = CF_PLACEHOLDER_STATE.PARTIAL;
pub const CF_PLACEHOLDER_STATE_PARTIALLY_ON_DISK = CF_PLACEHOLDER_STATE.PARTIALLY_ON_DISK;
pub const CF_PLACEHOLDER_STATE_INVALID = CF_PLACEHOLDER_STATE.INVALID;

pub const CF_PLACEHOLDER_INFO_CLASS = enum(i32) {
    BASIC = 0,
    STANDARD = 1,
};
pub const CF_PLACEHOLDER_INFO_BASIC = CF_PLACEHOLDER_INFO_CLASS.BASIC;
pub const CF_PLACEHOLDER_INFO_STANDARD = CF_PLACEHOLDER_INFO_CLASS.STANDARD;

pub const CF_PLACEHOLDER_BASIC_INFO = extern struct {
    PinState: CF_PIN_STATE,
    InSyncState: CF_IN_SYNC_STATE,
    FileId: LARGE_INTEGER,
    SyncRootFileId: LARGE_INTEGER,
    FileIdentityLength: u32,
    FileIdentity: [1]u8,
};

pub const CF_PLACEHOLDER_STANDARD_INFO = extern struct {
    OnDiskDataSize: LARGE_INTEGER,
    ValidatedDataSize: LARGE_INTEGER,
    ModifiedDataSize: LARGE_INTEGER,
    PropertiesSize: LARGE_INTEGER,
    PinState: CF_PIN_STATE,
    InSyncState: CF_IN_SYNC_STATE,
    FileId: LARGE_INTEGER,
    SyncRootFileId: LARGE_INTEGER,
    FileIdentityLength: u32,
    FileIdentity: [1]u8,
};

pub const CF_SYNC_ROOT_INFO_CLASS = enum(i32) {
    BASIC = 0,
    STANDARD = 1,
    PROVIDER = 2,
};
pub const CF_SYNC_ROOT_INFO_BASIC = CF_SYNC_ROOT_INFO_CLASS.BASIC;
pub const CF_SYNC_ROOT_INFO_STANDARD = CF_SYNC_ROOT_INFO_CLASS.STANDARD;
pub const CF_SYNC_ROOT_INFO_PROVIDER = CF_SYNC_ROOT_INFO_CLASS.PROVIDER;

pub const CF_SYNC_ROOT_BASIC_INFO = extern struct {
    SyncRootFileId: LARGE_INTEGER,
};

pub const CF_SYNC_ROOT_PROVIDER_INFO = extern struct {
    ProviderStatus: CF_SYNC_PROVIDER_STATUS,
    ProviderName: [256]u16,
    ProviderVersion: [256]u16,
};

pub const CF_SYNC_ROOT_STANDARD_INFO = extern struct {
    SyncRootFileId: LARGE_INTEGER,
    HydrationPolicy: CF_HYDRATION_POLICY,
    PopulationPolicy: CF_POPULATION_POLICY,
    InSyncPolicy: CF_INSYNC_POLICY,
    HardLinkPolicy: CF_HARDLINK_POLICY,
    ProviderStatus: CF_SYNC_PROVIDER_STATUS,
    ProviderName: [256]u16,
    ProviderVersion: [256]u16,
    SyncRootIdentityLength: u32,
    SyncRootIdentity: [1]u8,
};

pub const CF_PLACEHOLDER_RANGE_INFO_CLASS = enum(i32) {
    ONDISK = 1,
    VALIDATED = 2,
    MODIFIED = 3,
};
pub const CF_PLACEHOLDER_RANGE_INFO_ONDISK = CF_PLACEHOLDER_RANGE_INFO_CLASS.ONDISK;
pub const CF_PLACEHOLDER_RANGE_INFO_VALIDATED = CF_PLACEHOLDER_RANGE_INFO_CLASS.VALIDATED;
pub const CF_PLACEHOLDER_RANGE_INFO_MODIFIED = CF_PLACEHOLDER_RANGE_INFO_CLASS.MODIFIED;

//--------------------------------------------------------------------------------
// Section: Functions (35)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetPlatformInfo(
    PlatformVersion: ?*CF_PLATFORM_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfRegisterSyncRoot(
    SyncRootPath: ?[*:0]const u16,
    Registration: ?*const CF_SYNC_REGISTRATION,
    Policies: ?*const CF_SYNC_POLICIES,
    RegisterFlags: CF_REGISTER_FLAGS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfUnregisterSyncRoot(
    SyncRootPath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfConnectSyncRoot(
    SyncRootPath: ?[*:0]const u16,
    CallbackTable: ?*const CF_CALLBACK_REGISTRATION,
    CallbackContext: ?*const anyopaque,
    ConnectFlags: CF_CONNECT_FLAGS,
    ConnectionKey: ?*CF_CONNECTION_KEY,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfDisconnectSyncRoot(
    ConnectionKey: CF_CONNECTION_KEY,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetTransferKey(
    FileHandle: ?HANDLE,
    TransferKey: ?*LARGE_INTEGER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfReleaseTransferKey(
    FileHandle: ?HANDLE,
    TransferKey: ?*LARGE_INTEGER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfExecute(
    OpInfo: ?*const CF_OPERATION_INFO,
    OpParams: ?*CF_OPERATION_PARAMETERS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfUpdateSyncProviderStatus(
    ConnectionKey: CF_CONNECTION_KEY,
    ProviderStatus: CF_SYNC_PROVIDER_STATUS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfQuerySyncProviderStatus(
    ConnectionKey: CF_CONNECTION_KEY,
    ProviderStatus: ?*CF_SYNC_PROVIDER_STATUS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.17134'
pub extern "cldapi" fn CfReportSyncStatus(
    SyncRootPath: ?[*:0]const u16,
    SyncStatus: ?*CF_SYNC_STATUS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfCreatePlaceholders(
    BaseDirectoryPath: ?[*:0]const u16,
    PlaceholderArray: [*]CF_PLACEHOLDER_CREATE_INFO,
    PlaceholderCount: u32,
    CreateFlags: CF_CREATE_FLAGS,
    EntriesProcessed: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfOpenFileWithOplock(
    FilePath: ?[*:0]const u16,
    Flags: CF_OPEN_FILE_FLAGS,
    ProtectedHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfReferenceProtectedHandle(
    ProtectedHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetWin32HandleFromProtectedHandle(
    ProtectedHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfReleaseProtectedHandle(
    ProtectedHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfCloseHandle(
    FileHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfConvertToPlaceholder(
    FileHandle: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    FileIdentity: ?*const anyopaque,
    FileIdentityLength: u32,
    ConvertFlags: CF_CONVERT_FLAGS,
    ConvertUsn: ?*i64,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfUpdatePlaceholder(
    FileHandle: ?HANDLE,
    FsMetadata: ?*const CF_FS_METADATA,
    // TODO: what to do with BytesParamIndex 3?
    FileIdentity: ?*const anyopaque,
    FileIdentityLength: u32,
    DehydrateRangeArray: ?[*]const CF_FILE_RANGE,
    DehydrateRangeCount: u32,
    UpdateFlags: CF_UPDATE_FLAGS,
    UpdateUsn: ?*i64,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfRevertPlaceholder(
    FileHandle: ?HANDLE,
    RevertFlags: CF_REVERT_FLAGS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfHydratePlaceholder(
    FileHandle: ?HANDLE,
    StartingOffset: LARGE_INTEGER,
    Length: LARGE_INTEGER,
    HydrateFlags: CF_HYDRATE_FLAGS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "cldapi" fn CfDehydratePlaceholder(
    FileHandle: ?HANDLE,
    StartingOffset: LARGE_INTEGER,
    Length: LARGE_INTEGER,
    DehydrateFlags: CF_DEHYDRATE_FLAGS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfSetPinState(
    FileHandle: ?HANDLE,
    PinState: CF_PIN_STATE,
    PinFlags: CF_SET_PIN_FLAGS,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfSetInSyncState(
    FileHandle: ?HANDLE,
    InSyncState: CF_IN_SYNC_STATE,
    InSyncFlags: CF_SET_IN_SYNC_FLAGS,
    InSyncUsn: ?*i64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfSetCorrelationVector(
    FileHandle: ?HANDLE,
    CorrelationVector: ?*const CORRELATION_VECTOR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetCorrelationVector(
    FileHandle: ?HANDLE,
    CorrelationVector: ?*CORRELATION_VECTOR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetPlaceholderStateFromAttributeTag(
    FileAttributes: u32,
    ReparseTag: u32,
) callconv(@import("std").os.windows.WINAPI) CF_PLACEHOLDER_STATE;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetPlaceholderStateFromFileInfo(
    InfoBuffer: ?*const anyopaque,
    InfoClass: FILE_INFO_BY_HANDLE_CLASS,
) callconv(@import("std").os.windows.WINAPI) CF_PLACEHOLDER_STATE;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetPlaceholderStateFromFindData(
    FindData: ?*const WIN32_FIND_DATAA,
) callconv(@import("std").os.windows.WINAPI) CF_PLACEHOLDER_STATE;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetPlaceholderInfo(
    FileHandle: ?HANDLE,
    InfoClass: CF_PLACEHOLDER_INFO_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    InfoBuffer: ?*anyopaque,
    InfoBufferLength: u32,
    ReturnedLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetSyncRootInfoByPath(
    FilePath: ?[*:0]const u16,
    InfoClass: CF_SYNC_ROOT_INFO_CLASS,
    InfoBuffer: ?*anyopaque,
    InfoBufferLength: u32,
    ReturnedLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetSyncRootInfoByHandle(
    FileHandle: ?HANDLE,
    InfoClass: CF_SYNC_ROOT_INFO_CLASS,
    InfoBuffer: ?*anyopaque,
    InfoBufferLength: u32,
    ReturnedLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfGetPlaceholderRangeInfo(
    FileHandle: ?HANDLE,
    InfoClass: CF_PLACEHOLDER_RANGE_INFO_CLASS,
    StartingOffset: LARGE_INTEGER,
    Length: LARGE_INTEGER,
    // TODO: what to do with BytesParamIndex 5?
    InfoBuffer: ?*anyopaque,
    InfoBufferLength: u32,
    ReturnedLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "cldapi" fn CfReportProviderProgress(
    ConnectionKey: CF_CONNECTION_KEY,
    TransferKey: LARGE_INTEGER,
    ProviderProgressTotal: LARGE_INTEGER,
    ProviderProgressCompleted: LARGE_INTEGER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "cldapi" fn CfReportProviderProgress2(
    ConnectionKey: CF_CONNECTION_KEY,
    TransferKey: LARGE_INTEGER,
    RequestKey: LARGE_INTEGER,
    ProviderProgressTotal: LARGE_INTEGER,
    ProviderProgressCompleted: LARGE_INTEGER,
    TargetSessionId: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (12)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const CORRELATION_VECTOR = @import("../system/correlation_vector.zig").CORRELATION_VECTOR;
const FILE_BASIC_INFO = @import("../storage/file_system.zig").FILE_BASIC_INFO;
const FILE_INFO_BY_HANDLE_CLASS = @import("../storage/file_system.zig").FILE_INFO_BY_HANDLE_CLASS;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const LARGE_INTEGER = @import("../foundation.zig").LARGE_INTEGER;
const NTSTATUS = @import("../foundation.zig").NTSTATUS;
const OVERLAPPED = @import("../system/io.zig").OVERLAPPED;
const PWSTR = @import("../foundation.zig").PWSTR;
const WIN32_FIND_DATAA = @import("../storage/file_system.zig").WIN32_FIND_DATAA;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "CF_CALLBACK")) {
        _ = CF_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
