//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (2)
//--------------------------------------------------------------------------------
pub const ComponentTypeEnforcementClientSoH = @as(u32, 1);
pub const ComponentTypeEnforcementClientRp = @as(u32, 2);

//--------------------------------------------------------------------------------
// Section: Types (22)
//--------------------------------------------------------------------------------
pub const IsolationState = enum(i32) {
    NotRestricted = 1,
    InProbation = 2,
    RestrictedAccess = 3,
};
pub const isolationStateNotRestricted = IsolationState.NotRestricted;
pub const isolationStateInProbation = IsolationState.InProbation;
pub const isolationStateRestrictedAccess = IsolationState.RestrictedAccess;

pub const ExtendedIsolationState = enum(i32) {
    NoData = 0,
    Transition = 1,
    Infected = 2,
    Unknown = 3,
};
pub const extendedIsolationStateNoData = ExtendedIsolationState.NoData;
pub const extendedIsolationStateTransition = ExtendedIsolationState.Transition;
pub const extendedIsolationStateInfected = ExtendedIsolationState.Infected;
pub const extendedIsolationStateUnknown = ExtendedIsolationState.Unknown;

pub const NapTracingLevel = enum(i32) {
    Undefined = 0,
    Basic = 1,
    Advanced = 2,
    Debug = 3,
};
pub const tracingLevelUndefined = NapTracingLevel.Undefined;
pub const tracingLevelBasic = NapTracingLevel.Basic;
pub const tracingLevelAdvanced = NapTracingLevel.Advanced;
pub const tracingLevelDebug = NapTracingLevel.Debug;

pub const CountedString = extern struct {
    length: u16,
    string: ?PWSTR,
};

pub const IsolationInfo = extern struct {
    isolationState: IsolationState,
    probEndTime: FILETIME,
    failureUrl: CountedString,
};

pub const IsolationInfoEx = extern struct {
    isolationState: IsolationState,
    extendedIsolationState: ExtendedIsolationState,
    probEndTime: FILETIME,
    failureUrl: CountedString,
};

pub const FailureCategory = enum(i32) {
    None = 0,
    Other = 1,
    ClientComponent = 2,
    ClientCommunication = 3,
    ServerComponent = 4,
    ServerCommunication = 5,
};
pub const failureCategoryNone = FailureCategory.None;
pub const failureCategoryOther = FailureCategory.Other;
pub const failureCategoryClientComponent = FailureCategory.ClientComponent;
pub const failureCategoryClientCommunication = FailureCategory.ClientCommunication;
pub const failureCategoryServerComponent = FailureCategory.ServerComponent;
pub const failureCategoryServerCommunication = FailureCategory.ServerCommunication;

pub const FailureCategoryMapping = extern struct {
    mappingCompliance: [5]BOOL,
};

pub const CorrelationId = extern struct {
    connId: Guid,
    timeStamp: FILETIME,
};

pub const ResultCodes = extern struct {
    count: u16,
    results: ?*HRESULT,
};

pub const Ipv4Address = extern struct {
    addr: [4]u8,
};

pub const Ipv6Address = extern struct {
    addr: [16]u8,
};

pub const FixupState = enum(i32) {
    Success = 0,
    InProgress = 1,
    CouldNotUpdate = 2,
};
pub const fixupStateSuccess = FixupState.Success;
pub const fixupStateInProgress = FixupState.InProgress;
pub const fixupStateCouldNotUpdate = FixupState.CouldNotUpdate;

pub const FixupInfo = extern struct {
    state: FixupState,
    percentage: u8,
    resultCodes: ResultCodes,
    fixupMsgId: u32,
};

pub const NapNotifyType = enum(i32) {
    Unknown = 0,
    ServiceState = 1,
    QuarState = 2,
};
pub const napNotifyTypeUnknown = NapNotifyType.Unknown;
pub const napNotifyTypeServiceState = NapNotifyType.ServiceState;
pub const napNotifyTypeQuarState = NapNotifyType.QuarState;

pub const SystemHealthAgentState = extern struct {
    id: u32,
    shaResultCodes: ResultCodes,
    failureCategory: FailureCategory,
    fixupInfo: FixupInfo,
};

pub const SoHAttribute = extern struct {
    type: u16,
    size: u16,
    value: ?*u8,
};

pub const SoH = extern struct {
    count: u16,
    attributes: ?*SoHAttribute,
};

pub const NetworkSoH = extern struct {
    size: u16,
    data: ?*u8,
};

pub const PrivateData = extern struct {
    size: u16,
    data: ?*u8,
};

pub const NapComponentRegistrationInfo = extern struct {
    id: u32,
    friendlyName: CountedString,
    description: CountedString,
    version: CountedString,
    vendorName: CountedString,
    infoClsid: Guid,
    configClsid: Guid,
    registrationDate: FILETIME,
    componentType: u32,
};

pub const RemoteConfigurationType = enum(i32) {
    Machine = 1,
    ConfigBlob = 2,
};
pub const remoteConfigTypeMachine = RemoteConfigurationType.Machine;
pub const remoteConfigTypeConfigBlob = RemoteConfigurationType.ConfigBlob;

//--------------------------------------------------------------------------------
// Section: Functions (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (5)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const FILETIME = @import("../foundation.zig").FILETIME;
const HRESULT = @import("../foundation.zig").HRESULT;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
